/* AddDialog.c generated by valac 0.56.17, the Vala compiler
 * generated from AddDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */
/* Here because there are some default device_info values so it's nice to have them translated*/

#include <glib.h>
#include <glib/gi18n-lib.h>
#include "io.elementary.settings.printers.h"
#include <adwaita.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "cups/cups.h"
#include "cups/ipp.h"
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_ADD_DIALOG_0_PROPERTY,
	PRINTERS_ADD_DIALOG_NUM_PROPERTIES
};
static GParamSpec* printers_add_dialog_properties[PRINTERS_ADD_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PrintersAddDialogSearchDeviceData PrintersAddDialogSearchDeviceData;

#define PRINTERS_TYPE_ERROR_REVEALER (printers_error_revealer_get_type ())
#define PRINTERS_ERROR_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PRINTERS_TYPE_ERROR_REVEALER, PrintersErrorRevealer))
#define PRINTERS_ERROR_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PRINTERS_TYPE_ERROR_REVEALER, PrintersErrorRevealerClass))
#define PRINTERS_IS_ERROR_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PRINTERS_TYPE_ERROR_REVEALER))
#define PRINTERS_IS_ERROR_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PRINTERS_TYPE_ERROR_REVEALER))
#define PRINTERS_ERROR_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PRINTERS_TYPE_ERROR_REVEALER, PrintersErrorRevealerClass))

typedef struct _PrintersErrorRevealer PrintersErrorRevealer;
typedef struct _PrintersErrorRevealerClass PrintersErrorRevealerClass;
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _ippDelete0(var) ((var == NULL) ? NULL : (var = (ippDelete (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _PrintersAddDialogFindDriversData PrintersAddDialogFindDriversData;
enum  {
	PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_0_PROPERTY,
	PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_TEMP_DEVICE_PROPERTY,
	PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_NUM_PROPERTIES
};
static GParamSpec* printers_add_dialog_temp_device_row_properties[PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_NUM_PROPERTIES];
enum  {
	PRINTERS_ADD_DIALOG_DRIVER_ROW_0_PROPERTY,
	PRINTERS_ADD_DIALOG_DRIVER_ROW_DRIVER_PROPERTY,
	PRINTERS_ADD_DIALOG_DRIVER_ROW_NUM_PROPERTIES
};
static GParamSpec* printers_add_dialog_driver_row_properties[PRINTERS_ADD_DIALOG_DRIVER_ROW_NUM_PROPERTIES];
typedef struct _Block7Data Block7Data;

struct _PrintersAddDialogPrivate {
	AdwNavigationView* navigation_view;
	GraniteValidatedEntry* connection_entry;
	GraniteValidatedEntry* description_entry;
	GtkButton* add_printer_button;
	GtkButton* refresh_button;
	GtkStack* drivers_stack;
	GeeLinkedList* drivers;
	GtkListBox* driver_view;
	GtkListStore* make_list_store;
	GtkTreeView* make_view;
	GtkListBox* devices_list;
	PrintersDeviceDriver* selected_driver;
	GCancellable* driver_cancellable;
};

struct _Block3Data {
	int _ref_count_;
	PrintersAddDialog* self;
	GeeHashMap* tempdevices;
};

struct _PrintersAddDialogSearchDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PrintersAddDialog* self;
	gchar* _error_;
	GHashTable* devices;
	CupsPkHelper* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	Block3Data* _data3_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	PrintersAddDialog* self;
	PrintersErrorRevealer* connection_error;
	GtkEntry* location_entry;
	GtkBox* device_box;
	PrintersTempDevice* temp_device;
};

struct _Block5Data {
	int _ref_count_;
	PrintersAddDialog* self;
	PrintersTempDevice* temp_device;
};

struct _Block6Data {
	int _ref_count_;
	PrintersAddDialog* self;
	GtkTreeSelection* make_selection;
};

struct _PrintersAddDialogFindDriversData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PrintersAddDialog* self;
	gchar* make;
	gchar* selected_make_and_model;
	GtkListBoxRow* result;
	GtkListBoxRow* row_to_select;
	GeeLinkedList* _driver_list;
	GeeLinkedList* _tmp0_;
	gint _driver_size;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _driver_index;
	gint _tmp4_;
	gint _tmp5_;
	PrintersDeviceDriver* driver;
	GeeLinkedList* _tmp6_;
	gpointer _tmp7_;
	GCancellable* _tmp8_;
	PrintersDeviceDriver* _tmp9_;
	const gchar* _tmp10_;
	PrintersAddDialogDriverRow* row;
	PrintersDeviceDriver* _tmp11_;
	PrintersAddDialogDriverRow* _tmp12_;
	GtkListBox* _tmp13_;
	PrintersAddDialogDriverRow* _tmp14_;
	PrintersDeviceDriver* _tmp15_;
	const gchar* _tmp16_;
	PrintersAddDialogDriverRow* _tmp17_;
	GtkListBoxRow* _tmp18_;
};

struct _PrintersAddDialogTempDeviceRowPrivate {
	PrintersTempDevice* _temp_device;
};

struct _PrintersAddDialogDriverRowPrivate {
	PrintersDeviceDriver* _driver;
};

struct _Block7Data {
	int _ref_count_;
	PrintersAddDialog* self;
	GtkButton* next_button;
};

static gint PrintersAddDialog_private_offset;
static gpointer printers_add_dialog_parent_class = NULL;
static gint PrintersAddDialogTempDeviceRow_private_offset;
static gpointer printers_add_dialog_temp_device_row_parent_class = NULL;
static gint PrintersAddDialogDriverRow_private_offset;
static gpointer printers_add_dialog_driver_row_parent_class = NULL;

VALA_EXTERN void printers_translations_translations (void);
static void printers_add_dialog_search_device (PrintersAddDialog* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void printers_add_dialog_search_device_finish (PrintersAddDialog* self,
                                               GAsyncResult* _res_);
static void printers_add_dialog_search_device_data_free (gpointer _data);
static gboolean printers_add_dialog_search_device_co (PrintersAddDialogSearchDeviceData* _data_);
static void printers_add_dialog_search_device_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ____lambda29_ (Block3Data* _data3_,
                    const gchar* key,
                    const gchar* val);
static void _____lambda29__gh_func (gconstpointer key,
                             gconstpointer value,
                             gpointer self);
static void printers_add_dialog_process_devices (PrintersAddDialog* self,
                                          GeeCollection* tempdevices);
static void printers_add_dialog_show_error (PrintersAddDialog* self,
                                     const gchar* _error_);
static void __lambda30_ (PrintersAddDialog* self);
static void ___lambda30__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void printers_add_dialog_continue_with_tempdevice (PrintersAddDialog* self,
                                                   PrintersTempDevice* temp_device);
VALA_EXTERN GType printers_error_revealer_get_type (void) G_GNUC_CONST ;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN PrintersErrorRevealer* printers_error_revealer_new (const gchar* label);
VALA_EXTERN PrintersErrorRevealer* printers_error_revealer_construct (GType object_type,
                                                          const gchar* label);
static void printers_add_dialog_fetch_ppds (PrintersAddDialog* self,
                                     PrintersTempDevice* temp_device);
static void ___lambda35_ (Block4Data* _data4_);
VALA_EXTERN void printers_error_revealer_set_reveal_child (PrintersErrorRevealer* self,
                                               gboolean value);
static void printers_add_dialog_validate_form (PrintersAddDialog* self);
static void ____lambda35__gtk_editable_changed (GtkEditable* _sender,
                                         gpointer self);
static void __lambda36_ (Block4Data* _data4_);
static void ___lambda36__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda37_ (PrintersAddDialog* self);
static void ___lambda37__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda38_ (Block4Data* _data4_);
static void ___lambda38__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda39_ (PrintersAddDialog* self,
                  GtkListBoxRow* row);
static void ___lambda39__gtk_list_box_row_selected (GtkListBox* _sender,
                                             GtkListBoxRow* row,
                                             gpointer self);
static void _printers_add_dialog_validate_form_gtk_editable_changed (GtkEditable* _sender,
                                                              gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void* __lambda31_ (Block5Data* _data5_);
static gboolean __lambda32_ (Block5Data* _data5_);
static void printers_add_dialog_drivers_loaded (PrintersAddDialog* self,
                                         PrintersTempDevice* temp_device);
static gboolean ___lambda32__gsource_func (gpointer self);
static gpointer ___lambda31__gthread_func (gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void printers_add_dialog_populate_driver_list_from_make (PrintersAddDialog* self,
                                                         const gchar* make,
                                                         const gchar* selected_make_and_model);
static void __lambda34_ (Block6Data* _data6_);
static void ___lambda34__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void printers_add_dialog_find_drivers (PrintersAddDialog* self,
                                       const gchar* make,
                                       const gchar* selected_make_and_model,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static GtkListBoxRow* printers_add_dialog_find_drivers_finish (PrintersAddDialog* self,
                                                        GAsyncResult* _res_);
static void __lambda33_ (PrintersAddDialog* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void printers_add_dialog_find_drivers_data_free (gpointer _data);
static gboolean printers_add_dialog_find_drivers_co (PrintersAddDialogFindDriversData* _data_);
static gboolean _printers_add_dialog_find_drivers_co_gsource_func (gpointer self);
static gint printers_add_dialog_temp_device_list_sort (PrintersAddDialogTempDeviceRow* row1,
                                                PrintersAddDialogTempDeviceRow* row2);
static void printers_add_dialog_temp_device_list_header (PrintersAddDialogTempDeviceRow* row,
                                                  PrintersAddDialogTempDeviceRow* before);
static GObject * printers_add_dialog_temp_device_row_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void printers_add_dialog_temp_device_row_finalize (GObject * obj);
static GType printers_add_dialog_temp_device_row_get_type_once (void);
static void _vala_printers_add_dialog_temp_device_row_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_printers_add_dialog_temp_device_row_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static GObject * printers_add_dialog_driver_row_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void printers_add_dialog_driver_row_finalize (GObject * obj);
static GType printers_add_dialog_driver_row_get_type_once (void);
static void _vala_printers_add_dialog_driver_row_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_printers_add_dialog_driver_row_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static GObject * printers_add_dialog_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _printers_add_dialog___lambda40_ (Block7Data* _data7_,
                                       GtkListBoxRow* row);
static void __printers_add_dialog___lambda40__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self);
static void _printers_add_dialog___lambda41_ (PrintersAddDialog* self);
static void __printers_add_dialog___lambda41__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _printers_add_dialog___lambda42_ (PrintersAddDialog* self);
static void __printers_add_dialog___lambda42__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _printers_add_dialog___lambda43_ (PrintersAddDialog* self);
static void __printers_add_dialog___lambda43__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void printers_add_dialog_finalize (GObject * obj);
static GType printers_add_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
printers_translations_translations (void)
{
	_ ("Internet Printing Protocol (https)");
	_ ("Internet Printing Protocol (http)");
	_ ("Internet Printing Protocol (ipp)");
	_ ("Internet Printing Protocol (ipps)");
	_ ("Internet Printing Protocol (ipp14)");
	_ ("LPD/LPR Host or Printer");
	_ ("AppSocket/HP JetDirect");
}

static inline gpointer
printers_add_dialog_get_instance_private (PrintersAddDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersAddDialog_private_offset);
}

PrintersAddDialog*
printers_add_dialog_construct (GType object_type)
{
	PrintersAddDialog * self = NULL;
	self = (PrintersAddDialog*) granite_dialog_construct (object_type);
	printers_add_dialog_search_device (self, NULL, NULL);
	return self;
}

PrintersAddDialog*
printers_add_dialog_new (void)
{
	return printers_add_dialog_construct (PRINTERS_TYPE_ADD_DIALOG);
}

static void
printers_add_dialog_search_device_data_free (gpointer _data)
{
	PrintersAddDialogSearchDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PrintersAddDialogSearchDeviceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
printers_add_dialog_search_device (PrintersAddDialog* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PrintersAddDialogSearchDeviceData* _data_;
	PrintersAddDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PrintersAddDialogSearchDeviceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, printers_add_dialog_search_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	printers_add_dialog_search_device_co (_data_);
}

static void
printers_add_dialog_search_device_finish (PrintersAddDialog* self,
                                          GAsyncResult* _res_)
{
	PrintersAddDialogSearchDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
printers_add_dialog_search_device_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	PrintersAddDialogSearchDeviceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	printers_add_dialog_search_device_co (_data_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PrintersAddDialog* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->tempdevices);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
____lambda29_ (Block3Data* _data3_,
               const gchar* key,
               const gchar* val)
{
	PrintersAddDialog* self;
	gchar** key_vars = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint key_vars_length1;
	gint _key_vars_size_;
	gint number = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	PrintersTempDevice* tempdevice = NULL;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	PrintersTempDevice* _tmp6_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GQuark _tmp14_ = 0U;
	static GQuark _tmp13_label0 = 0;
	static GQuark _tmp13_label1 = 0;
	static GQuark _tmp13_label2 = 0;
	static GQuark _tmp13_label3 = 0;
	static GQuark _tmp13_label4 = 0;
	self = _data3_->self;
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (key, ":", 2);
	key_vars = _tmp1_;
	key_vars_length1 = _vala_array_length (_tmp0_);
	_key_vars_size_ = key_vars_length1;
	_tmp2_ = key_vars;
	_tmp2__length1 = key_vars_length1;
	_tmp3_ = _tmp2_[1];
	number = atoi (_tmp3_);
	_tmp4_ = _data3_->tempdevices;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((gintptr) number));
	_g_object_unref0 (tempdevice);
	tempdevice = (PrintersTempDevice*) _tmp5_;
	_tmp6_ = tempdevice;
	if (_tmp6_ == NULL) {
		PrintersTempDevice* _tmp7_;
		GeeHashMap* _tmp8_;
		PrintersTempDevice* _tmp9_;
		_tmp7_ = printers_temp_device_new ();
		_g_object_unref0 (tempdevice);
		tempdevice = _tmp7_;
		_tmp8_ = _data3_->tempdevices;
		_tmp9_ = tempdevice;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((gintptr) number), _tmp9_);
	}
	_tmp10_ = key_vars;
	_tmp10__length1 = key_vars_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = _tmp11_;
	_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
	if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("device-make-and-model")))) {
		switch (0) {
			default:
			{
				if (g_strcmp0 (val, "Unknown") != 0) {
					PrintersTempDevice* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = tempdevice;
					_tmp16_ = g_strdup (val);
					_g_free0 (_tmp15_->device_make_and_model);
					_tmp15_->device_make_and_model = _tmp16_;
				}
				break;
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("device-class")))) {
		switch (0) {
			default:
			{
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				if (g_strcmp0 (val, "network") == 0) {
					PrintersTempDevice* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = tempdevice;
					_tmp20_ = _tmp19_->device_uri;
					_tmp18_ = _tmp20_ != NULL;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					PrintersTempDevice* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = tempdevice;
					_tmp22_ = _tmp21_->device_uri;
					_tmp17_ = string_contains (_tmp22_, ":");
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					PrintersTempDevice* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = tempdevice;
					_tmp24_ = g_strdup ("ok-network");
					_g_free0 (_tmp23_->device_class);
					_tmp23_->device_class = _tmp24_;
				} else {
					PrintersTempDevice* _tmp25_;
					gchar* _tmp26_;
					_tmp25_ = tempdevice;
					_tmp26_ = g_strdup (val);
					_g_free0 (_tmp25_->device_class);
					_tmp25_->device_class = _tmp26_;
				}
				break;
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("device-uri")))) {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp27_;
				gchar* _tmp28_;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				PrintersTempDevice* _tmp31_;
				const gchar* _tmp32_;
				_tmp27_ = tempdevice;
				_tmp28_ = g_strdup (val);
				_g_free0 (_tmp27_->device_uri);
				_tmp27_->device_uri = _tmp28_;
				_tmp31_ = tempdevice;
				_tmp32_ = _tmp31_->device_class;
				if (_tmp32_ != NULL) {
					PrintersTempDevice* _tmp33_;
					const gchar* _tmp34_;
					_tmp33_ = tempdevice;
					_tmp34_ = _tmp33_->device_class;
					_tmp30_ = g_strcmp0 (_tmp34_, "network") == 0;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					PrintersTempDevice* _tmp35_;
					const gchar* _tmp36_;
					_tmp35_ = tempdevice;
					_tmp36_ = _tmp35_->device_uri;
					_tmp29_ = string_contains (_tmp36_, ":");
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					PrintersTempDevice* _tmp37_;
					gchar* _tmp38_;
					_tmp37_ = tempdevice;
					_tmp38_ = g_strdup ("ok-network");
					_g_free0 (_tmp37_->device_class);
					_tmp37_->device_class = _tmp38_;
				}
				break;
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label3) ? _tmp13_label3 : (_tmp13_label3 = g_quark_from_static_string ("device-info")))) {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp39_;
				gchar* _tmp40_;
				_tmp39_ = tempdevice;
				_tmp40_ = g_strdup (_ (val));
				_g_free0 (_tmp39_->device_info);
				_tmp39_->device_info = _tmp40_;
				break;
			}
		}
	} else if (_tmp14_ == ((0 != _tmp13_label4) ? _tmp13_label4 : (_tmp13_label4 = g_quark_from_static_string ("device-id")))) {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp41_;
				gchar* _tmp42_;
				_tmp41_ = tempdevice;
				_tmp42_ = g_strdup (val);
				_g_free0 (_tmp41_->device_id);
				_tmp41_->device_id = _tmp42_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar** _tmp43_;
				gint _tmp43__length1;
				const gchar* _tmp44_;
				_tmp43_ = key_vars;
				_tmp43__length1 = key_vars_length1;
				_tmp44_ = _tmp43_[0];
				g_debug ("AddDialog.vala:185: missing: %s => %s", _tmp44_, val);
				break;
			}
		}
	}
	_g_object_unref0 (tempdevice);
	key_vars = (_vala_array_free (key_vars, key_vars_length1, (GDestroyNotify) g_free), NULL);
}

static void
_____lambda29__gh_func (gconstpointer key,
                        gconstpointer value,
                        gpointer self)
{
	____lambda29_ (self, (const gchar*) key, (const gchar*) value);
}

static gboolean
printers_add_dialog_search_device_co (PrintersAddDialogSearchDeviceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = cups_get_pk_helper ();
		_data_->_tmp1_ = g_new0 (gchar*, 0 + 1);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp2__length1 = 0;
		_data_->_tmp3_ = g_new0 (gchar*, 0 + 1);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp4__length1 = 0;
		_data_->_tmp5_ = NULL;
		_data_->_tmp6_ = NULL;
		_data_->_state_ = 1;
		cups_pk_helper_devices_get (_data_->_tmp0_, CUPS_TIMEOUT_DEFAULT, -1, _data_->_tmp2_, (gint) 0, _data_->_tmp4_, (gint) 0, printers_add_dialog_search_device_ready, _data_);
		return FALSE;
		_state_1:
		cups_pk_helper_devices_get_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp5_, &_data_->_tmp6_, &_data_->_inner_error0_);
		_g_free0 (_data_->_error_);
		_data_->_error_ = _data_->_tmp5_;
		_g_hash_table_unref0 (_data_->devices);
		_data_->devices = _data_->_tmp6_;
		_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp2_ = (_vala_array_free (_data_->_tmp2_, _data_->_tmp2__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->devices);
			_g_free0 (_data_->_error_);
			goto __catch0_g_error;
		}
		if (_data_->_error_ != NULL) {
			_data_->_data3_ = g_slice_new0 (Block3Data);
			_data_->_data3_->_ref_count_ = 1;
			_data_->_data3_->self = g_object_ref (_data_->self);
			_data_->_tmp7_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, PRINTERS_TYPE_TEMP_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_data_->_data3_->tempdevices = _data_->_tmp7_;
			g_hash_table_foreach (_data_->devices, _____lambda29__gh_func, _data_->_data3_);
			_data_->_tmp8_ = _data_->_data3_->tempdevices;
			_data_->_tmp9_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->_tmp10_;
			printers_add_dialog_process_devices (_data_->self, _data_->_tmp11_);
			_g_object_unref0 (_data_->_tmp11_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
		} else {
			printers_add_dialog_show_error (_data_->self, _data_->_error_);
		}
		_g_hash_table_unref0 (_data_->devices);
		_g_free0 (_data_->_error_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		printers_add_dialog_show_error (_data_->self, _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
printers_add_dialog_process_devices (PrintersAddDialog* self,
                                     GeeCollection* tempdevices)
{
	GtkButton* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tempdevices != NULL);
	{
		GeeIterator* _tempdevice_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) tempdevices);
		_tempdevice_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			PrintersTempDevice* tempdevice = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GtkListBox* _tmp4_;
			PrintersTempDevice* _tmp5_;
			PrintersAddDialogTempDeviceRow* _tmp6_;
			PrintersAddDialogTempDeviceRow* _tmp7_;
			_tmp1_ = _tempdevice_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _tempdevice_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			tempdevice = (PrintersTempDevice*) _tmp3_;
			_tmp4_ = self->priv->devices_list;
			_tmp5_ = tempdevice;
			_tmp6_ = printers_add_dialog_temp_device_row_new (_tmp5_);
			g_object_ref_sink (_tmp6_);
			_tmp7_ = _tmp6_;
			gtk_list_box_append (_tmp4_, (GtkWidget*) _tmp7_);
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (tempdevice);
		}
		_g_object_unref0 (_tempdevice_it);
	}
	_tmp8_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
}

static void
__lambda30_ (PrintersAddDialog* self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda30__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda30_ ((PrintersAddDialog*) self);
}

static void
printers_add_dialog_show_error (PrintersAddDialog* self,
                                const gchar* _error_)
{
	GranitePlaceholder* alertview = NULL;
	GThemedIcon* _tmp0_;
	gchar* _tmp1_;
	GranitePlaceholder* _tmp2_ = NULL;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp3_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* error_box = NULL;
	GtkBox* _tmp5_;
	AdwNavigationPage* error_page = NULL;
	AdwNavigationPage* _tmp6_;
	AdwNavigationView* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp1_ = g_strdup (_error_);
	_tmp2_ = granite_placeholder_new (_ ("Impossible to list all available printers"));
	granite_placeholder_set_icon (_tmp2_, (GIcon*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	granite_placeholder_set_description (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	alertview = _tmp2_;
	gtk_widget_add_css_class ((GtkWidget*) alertview, "dialog-content-area");
	_tmp3_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp3_);
	cancel_button = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
	gtk_box_set_homogeneous (_tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	button_box = _tmp4_;
	gtk_widget_add_css_class ((GtkWidget*) button_box, "dialog-action-area");
	gtk_box_append (button_box, (GtkWidget*) cancel_button);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp5_);
	error_box = _tmp5_;
	gtk_box_append (error_box, (GtkWidget*) alertview);
	gtk_box_append (error_box, (GtkWidget*) button_box);
	_tmp6_ = adw_navigation_page_new ((GtkWidget*) error_box, _ ("Setup Error"));
	g_object_ref_sink (_tmp6_);
	error_page = _tmp6_;
	_tmp7_ = self->priv->navigation_view;
	adw_navigation_view_push (_tmp7_, error_page);
	g_signal_connect_object (cancel_button, "clicked", (GCallback) ___lambda30__gtk_button_clicked, self, 0);
	_g_object_unref0 (error_page);
	_g_object_unref0 (error_box);
	_g_object_unref0 (button_box);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (alertview);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PrintersAddDialog* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->device_box);
		_g_object_unref0 (_data4_->location_entry);
		_g_object_unref0 (_data4_->connection_error);
		_g_object_unref0 (_data4_->temp_device);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda35_ (Block4Data* _data4_)
{
	PrintersAddDialog* self;
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PrintersErrorRevealer* _tmp4_;
	GraniteValidatedEntry* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	self = _data4_->self;
	_tmp0_ = self->priv->connection_entry;
	_tmp1_ = self->priv->connection_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	granite_validated_entry_set_is_valid (_tmp0_, string_contains (_tmp3_, "://"));
	_tmp4_ = _data4_->connection_error;
	_tmp5_ = self->priv->connection_entry;
	_tmp6_ = granite_validated_entry_get_is_valid (_tmp5_);
	_tmp7_ = _tmp6_;
	printers_error_revealer_set_reveal_child (_tmp4_, !_tmp7_);
	printers_add_dialog_validate_form (self);
}

static void
____lambda35__gtk_editable_changed (GtkEditable* _sender,
                                    gpointer self)
{
	___lambda35_ (self);
}

static void
__lambda36_ (Block4Data* _data4_)
{
	PrintersAddDialog* self;
	GCancellable* _tmp0_;
	AdwNavigationView* _tmp1_;
	self = _data4_->self;
	_tmp0_ = self->priv->driver_cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp1_);
	g_signal_emit_by_name ((GtkWidget*) _data4_->device_box, "destroy");
}

static void
___lambda36__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda36_ (self);
}

static void
__lambda37_ (PrintersAddDialog* self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda37__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda37_ ((PrintersAddDialog*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda38_ (Block4Data* _data4_)
{
	PrintersAddDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	{
		gchar* name = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* uri = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		GraniteValidatedEntry* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		CupsPkHelper* pk_helper = NULL;
		CupsPkHelper* _tmp15_;
		CupsPkHelper* _tmp16_;
		CupsPkHelper* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		PrintersDeviceDriver* _tmp20_;
		const gchar* _tmp21_;
		GraniteValidatedEntry* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GtkEntry* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		CupsPkHelper* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		CupsPkHelper* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp0_ = _data4_->temp_device->device_info;
		_tmp1_ = string_replace (_tmp0_, " ", "_");
		name = _tmp1_;
		_tmp2_ = name;
		_tmp3_ = string_replace (_tmp2_, "/", "_");
		_g_free0 (name);
		name = _tmp3_;
		_tmp4_ = name;
		_tmp5_ = string_replace (_tmp4_, "#", "_");
		_g_free0 (name);
		name = _tmp5_;
		_tmp6_ = _data4_->temp_device->device_uri;
		_tmp7_ = g_strdup (_tmp6_);
		uri = _tmp7_;
		_tmp8_ = self->priv->connection_entry;
		_tmp9_ = gtk_widget_get_parent ((GtkWidget*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			GraniteValidatedEntry* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = self->priv->connection_entry;
			_tmp12_ = gtk_editable_get_text ((GtkEditable*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (uri);
			uri = _tmp14_;
		}
		_tmp15_ = cups_get_pk_helper ();
		_tmp16_ = _g_object_ref0 (_tmp15_);
		pk_helper = _tmp16_;
		_tmp17_ = pk_helper;
		_tmp18_ = name;
		_tmp19_ = uri;
		_tmp20_ = self->priv->selected_driver;
		_tmp21_ = _tmp20_->ppd_name;
		_tmp22_ = self->priv->description_entry;
		_tmp23_ = gtk_editable_get_text ((GtkEditable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _data4_->location_entry;
		_tmp26_ = gtk_editable_get_text ((GtkEditable*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = cups_pk_helper_printer_add (_tmp17_, _tmp18_, _tmp19_, _tmp21_, _tmp24_, _tmp27_, &_inner_error0_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp29_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pk_helper);
			_g_free0 (uri);
			_g_free0 (name);
			goto __catch0_g_error;
		}
		_tmp30_ = pk_helper;
		_tmp31_ = name;
		_tmp32_ = cups_pk_helper_printer_set_enabled (_tmp30_, _tmp31_, TRUE, &_inner_error0_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp33_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pk_helper);
			_g_free0 (uri);
			_g_free0 (name);
			goto __catch0_g_error;
		}
		_tmp34_ = pk_helper;
		_tmp35_ = name;
		_tmp36_ = cups_pk_helper_printer_set_accept_jobs (_tmp34_, _tmp35_, TRUE, "", &_inner_error0_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp37_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pk_helper);
			_g_free0 (uri);
			_g_free0 (name);
			goto __catch0_g_error;
		}
		_g_object_unref0 (pk_helper);
		_g_free0 (uri);
		_g_free0 (name);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_critical ("AddDialog.vala:411: %s", _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda38__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda38_ (self);
}

static void
__lambda39_ (PrintersAddDialog* self,
             GtkListBoxRow* row)
{
	if (row != NULL) {
		PrintersDeviceDriver* _tmp0_;
		PrintersDeviceDriver* _tmp1_;
		PrintersDeviceDriver* _tmp2_;
		_tmp0_ = printers_add_dialog_driver_row_get_driver (G_TYPE_CHECK_INSTANCE_CAST (row, PRINTERS_ADD_DIALOG_TYPE_DRIVER_ROW, PrintersAddDialogDriverRow));
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (self->priv->selected_driver);
		self->priv->selected_driver = _tmp2_;
		printers_add_dialog_validate_form (self);
	} else {
		GtkButton* _tmp3_;
		_tmp3_ = self->priv->add_printer_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_g_object_unref0 (self->priv->selected_driver);
		self->priv->selected_driver = NULL;
	}
}

static void
___lambda39__gtk_list_box_row_selected (GtkListBox* _sender,
                                        GtkListBoxRow* row,
                                        gpointer self)
{
	__lambda39_ ((PrintersAddDialog*) self, row);
}

static void
_printers_add_dialog_validate_form_gtk_editable_changed (GtkEditable* _sender,
                                                         gpointer self)
{
	printers_add_dialog_validate_form ((PrintersAddDialog*) self);
}

static void
printers_add_dialog_continue_with_tempdevice (PrintersAddDialog* self,
                                              PrintersTempDevice* temp_device)
{
	Block4Data* _data4_;
	PrintersTempDevice* _tmp0_;
	gchar* _tmp1_;
	GraniteValidatedEntry* _tmp2_ = NULL;
	GraniteHeaderLabel* connection_label = NULL;
	GraniteValidatedEntry* _tmp3_;
	GtkWidget* _tmp4_;
	GraniteHeaderLabel* _tmp5_ = NULL;
	PrintersErrorRevealer* _tmp6_;
	PrintersErrorRevealer* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GraniteValidatedEntry* _tmp13_ = NULL;
	GraniteHeaderLabel* description_label = NULL;
	GraniteValidatedEntry* _tmp14_;
	GtkWidget* _tmp15_;
	GraniteHeaderLabel* _tmp16_ = NULL;
	PrintersErrorRevealer* description_error = NULL;
	PrintersErrorRevealer* _tmp17_;
	PrintersErrorRevealer* _tmp18_;
	gchar* _tmp19_;
	GtkEntry* _tmp20_ = NULL;
	GraniteHeaderLabel* location_label = NULL;
	GtkEntry* _tmp21_;
	GtkWidget* _tmp22_;
	GraniteHeaderLabel* _tmp23_ = NULL;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp24_ = NULL;
	GtkSpinner* _tmp25_;
	GtkListStore* _tmp26_;
	GtkCellRendererText* cellrenderer = NULL;
	GtkCellRendererText* _tmp27_ = NULL;
	GtkListStore* _tmp28_;
	GtkTreeView* _tmp29_ = NULL;
	GtkTreeView* _tmp30_;
	GtkTreeSelection* _tmp31_;
	GtkTreeView* _tmp32_;
	GtkCellRendererText* _tmp33_;
	GtkScrolledWindow* make_scrolled = NULL;
	GtkTreeView* _tmp34_;
	GtkWidget* _tmp35_;
	GtkScrolledWindow* _tmp36_ = NULL;
	GtkListBox* _tmp37_;
	GtkListBox* _tmp38_;
	GtkLabel* _tmp39_;
	GtkLabel* _tmp40_;
	GtkScrolledWindow* driver_scrolled = NULL;
	GtkListBox* _tmp41_;
	GtkWidget* _tmp42_;
	GtkScrolledWindow* _tmp43_ = NULL;
	GtkPaned* drivers_paned = NULL;
	GtkScrolledWindow* _tmp44_;
	GtkWidget* _tmp45_;
	GtkScrolledWindow* _tmp46_;
	GtkWidget* _tmp47_;
	GtkPaned* _tmp48_ = NULL;
	GtkStack* _tmp49_ = NULL;
	GtkStack* _tmp50_;
	GtkSpinner* _tmp51_;
	GtkStack* _tmp52_;
	GtkPaned* _tmp53_;
	GtkFrame* frame = NULL;
	GtkStack* _tmp54_;
	GtkWidget* _tmp55_;
	GtkFrame* _tmp56_ = NULL;
	GCancellable* _tmp57_;
	GtkButton* previous_button = NULL;
	GtkButton* _tmp58_;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp59_;
	GtkButton* _tmp60_ = NULL;
	GtkButton* _tmp61_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp62_ = NULL;
	GtkBox* _tmp63_;
	GtkBox* _tmp64_;
	GtkButton* _tmp65_;
	GtkBox* _tmp66_;
	GtkButton* _tmp67_;
	GtkBox* _tmp68_;
	GtkButton* _tmp69_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp70_;
	GtkBox* _tmp71_;
	GtkBox* _tmp72_;
	GraniteHeaderLabel* _tmp73_;
	GtkBox* _tmp74_;
	GraniteValidatedEntry* _tmp75_;
	GtkBox* _tmp76_;
	PrintersErrorRevealer* _tmp77_;
	const gchar* _tmp78_;
	GtkBox* _tmp88_;
	GraniteHeaderLabel* _tmp89_;
	GtkBox* _tmp90_;
	GtkEntry* _tmp91_;
	GtkBox* _tmp92_;
	GtkFrame* _tmp93_;
	GtkBox* _tmp94_;
	GtkBox* _tmp95_;
	GtkBox* _tmp96_;
	AdwNavigationPage* setup_page = NULL;
	AdwNavigationPage* _tmp97_;
	AdwNavigationView* _tmp98_;
	GtkButton* _tmp99_;
	GtkButton* _tmp100_;
	GtkButton* _tmp101_;
	GtkListBox* _tmp102_;
	GraniteValidatedEntry* _tmp103_;
	GraniteValidatedEntry* _tmp104_;
	PrintersErrorRevealer* _tmp105_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (temp_device != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (temp_device);
	_g_object_unref0 (_data4_->temp_device);
	_data4_->temp_device = _tmp0_;
	_tmp1_ = g_strdup ("ipp://hostname/ipp/port1");
	_tmp2_ = granite_validated_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->connection_entry);
	self->priv->connection_entry = _tmp2_;
	_tmp3_ = self->priv->connection_entry;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _tmp3_);
	_tmp5_ = granite_header_label_new (_ ("Connection"));
	granite_header_label_set_mnemonic_widget (_tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	connection_label = _tmp5_;
	_tmp6_ = printers_error_revealer_new (_ ("Connection uri must contain “://“"));
	g_object_ref_sink (_tmp6_);
	_data4_->connection_error = _tmp6_;
	_tmp7_ = _data4_->connection_error;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_ERROR);
	_tmp9_ = printers_temp_device_get_model_from_id (_data4_->temp_device);
	_tmp8_ = _tmp9_;
	if (_tmp8_ == NULL) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_ ("BrandPrinter X3000"));
	_tmp12_ = _tmp8_;
	_tmp8_ = NULL;
	_tmp13_ = granite_validated_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	granite_validated_entry_set_min_length (_tmp13_, 1);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp13_, _tmp11_);
	_g_free0 (_tmp11_);
	gtk_editable_set_text ((GtkEditable*) _tmp13_, _tmp12_);
	_g_free0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->description_entry);
	self->priv->description_entry = _tmp13_;
	_tmp14_ = self->priv->description_entry;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	_tmp16_ = granite_header_label_new (_ ("Description"));
	granite_header_label_set_mnemonic_widget (_tmp16_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	description_label = _tmp16_;
	_tmp17_ = printers_error_revealer_new (_ ("Description cannot be empty"));
	g_object_ref_sink (_tmp17_);
	description_error = _tmp17_;
	_tmp18_ = description_error;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, GRANITE_STYLE_CLASS_ERROR);
	_tmp19_ = g_strdup (_ ("Lab 1 or John's desk"));
	_tmp20_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	gtk_entry_set_placeholder_text (_tmp20_, _tmp19_);
	_g_free0 (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_data4_->location_entry = _tmp20_;
	_tmp21_ = _data4_->location_entry;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	_tmp23_ = granite_header_label_new (_ ("Location"));
	granite_header_label_set_mnemonic_widget (_tmp23_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	location_label = _tmp23_;
	_tmp24_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp24_);
	spinner = _tmp24_;
	_tmp25_ = spinner;
	gtk_spinner_start (_tmp25_);
	_tmp26_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->make_list_store);
	self->priv->make_list_store = _tmp26_;
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_set ((GtkCellRenderer*) _tmp27_, "xpad", (guint) 6, NULL);
	g_object_ref_sink (_tmp27_);
	cellrenderer = _tmp27_;
	_tmp28_ = self->priv->make_list_store;
	_tmp29_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp28_);
	gtk_tree_view_set_headers_visible (_tmp29_, FALSE);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->make_view);
	self->priv->make_view = _tmp29_;
	_tmp30_ = self->priv->make_view;
	_tmp31_ = gtk_tree_view_get_selection (_tmp30_);
	gtk_tree_selection_set_mode (_tmp31_, GTK_SELECTION_BROWSE);
	_tmp32_ = self->priv->make_view;
	_tmp33_ = cellrenderer;
	gtk_tree_view_insert_column_with_attributes (_tmp32_, -1, NULL, (GtkCellRenderer*) _tmp33_, "text", 0, NULL);
	_tmp34_ = self->priv->make_view;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	_tmp36_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp36_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	g_object_set (_tmp36_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp36_);
	make_scrolled = _tmp36_;
	_tmp37_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->driver_view);
	self->priv->driver_view = _tmp37_;
	_tmp38_ = self->priv->driver_view;
	_tmp39_ = (GtkLabel*) gtk_label_new (_ ("Loading…"));
	g_object_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	gtk_list_box_set_placeholder (_tmp38_, (GtkWidget*) _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = self->priv->driver_view;
	_tmp42_ = _g_object_ref0 ((GtkWidget*) _tmp41_);
	_tmp43_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp43_, _tmp42_);
	_g_object_unref0 (_tmp42_);
	g_object_set (_tmp43_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp43_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp43_, TRUE);
	g_object_ref_sink (_tmp43_);
	driver_scrolled = _tmp43_;
	_tmp44_ = make_scrolled;
	_tmp45_ = _g_object_ref0 ((GtkWidget*) _tmp44_);
	_tmp46_ = driver_scrolled;
	_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
	_tmp48_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_paned_set_start_child (_tmp48_, _tmp45_);
	_g_object_unref0 (_tmp45_);
	gtk_paned_set_end_child (_tmp48_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	gtk_paned_set_resize_start_child (_tmp48_, FALSE);
	gtk_paned_set_shrink_start_child (_tmp48_, FALSE);
	gtk_paned_set_shrink_end_child (_tmp48_, FALSE);
	g_object_ref_sink (_tmp48_);
	drivers_paned = _tmp48_;
	_tmp49_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp49_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp49_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp49_, TRUE);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->drivers_stack);
	self->priv->drivers_stack = _tmp49_;
	_tmp50_ = self->priv->drivers_stack;
	_tmp51_ = spinner;
	gtk_stack_add_named (_tmp50_, (GtkWidget*) _tmp51_, "loading");
	_tmp52_ = self->priv->drivers_stack;
	_tmp53_ = drivers_paned;
	gtk_stack_add_named (_tmp52_, (GtkWidget*) _tmp53_, "drivers");
	_tmp54_ = self->priv->drivers_stack;
	_tmp55_ = _g_object_ref0 ((GtkWidget*) _tmp54_);
	_tmp56_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp56_, _tmp55_);
	_g_object_unref0 (_tmp55_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp56_, 12);
	g_object_ref_sink (_tmp56_);
	frame = _tmp56_;
	_tmp57_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->driver_cancellable);
	self->priv->driver_cancellable = _tmp57_;
	printers_add_dialog_fetch_ppds (self, _data4_->temp_device);
	_tmp58_ = (GtkButton*) gtk_button_new_with_label (_ ("Back"));
	g_object_ref_sink (_tmp58_);
	previous_button = _tmp58_;
	_tmp59_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp59_);
	cancel_button = _tmp59_;
	_tmp60_ = (GtkButton*) gtk_button_new_with_label (_ ("Add Printer"));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp60_, FALSE);
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (self->priv->add_printer_button);
	self->priv->add_printer_button = _tmp60_;
	_tmp61_ = self->priv->add_printer_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp61_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp62_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp62_, GTK_ALIGN_END);
	gtk_box_set_homogeneous (_tmp62_, TRUE);
	g_object_ref_sink (_tmp62_);
	button_box = _tmp62_;
	_tmp63_ = button_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp63_, "dialog-action-area");
	_tmp64_ = button_box;
	_tmp65_ = previous_button;
	gtk_box_append (_tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = button_box;
	_tmp67_ = cancel_button;
	gtk_box_append (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = button_box;
	_tmp69_ = self->priv->add_printer_button;
	gtk_box_append (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp70_);
	content_box = _tmp70_;
	_tmp71_ = content_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp71_, "dialog-content-area");
	_tmp72_ = content_box;
	_tmp73_ = description_label;
	gtk_box_append (_tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = content_box;
	_tmp75_ = self->priv->description_entry;
	gtk_box_append (_tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = content_box;
	_tmp77_ = description_error;
	gtk_box_append (_tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = _data4_->temp_device->device_uri;
	if (!string_contains (_tmp78_, ":")) {
		GraniteValidatedEntry* _tmp79_;
		GraniteValidatedEntry* _tmp80_;
		const gchar* _tmp81_;
		GtkBox* _tmp82_;
		GraniteHeaderLabel* _tmp83_;
		GtkBox* _tmp84_;
		GraniteValidatedEntry* _tmp85_;
		GtkBox* _tmp86_;
		PrintersErrorRevealer* _tmp87_;
		_tmp79_ = self->priv->connection_entry;
		g_signal_connect_data ((GtkEditable*) _tmp79_, "changed", (GCallback) ____lambda35__gtk_editable_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp80_ = self->priv->connection_entry;
		_tmp81_ = _data4_->temp_device->device_uri;
		gtk_editable_set_text ((GtkEditable*) _tmp80_, _tmp81_);
		_tmp82_ = content_box;
		_tmp83_ = connection_label;
		gtk_box_append (_tmp82_, (GtkWidget*) _tmp83_);
		_tmp84_ = content_box;
		_tmp85_ = self->priv->connection_entry;
		gtk_box_append (_tmp84_, (GtkWidget*) _tmp85_);
		_tmp86_ = content_box;
		_tmp87_ = _data4_->connection_error;
		gtk_box_append (_tmp86_, (GtkWidget*) _tmp87_);
	}
	_tmp88_ = content_box;
	_tmp89_ = location_label;
	gtk_box_append (_tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = content_box;
	_tmp91_ = _data4_->location_entry;
	gtk_box_append (_tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = content_box;
	_tmp93_ = frame;
	gtk_box_append (_tmp92_, (GtkWidget*) _tmp93_);
	_tmp94_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp94_);
	_data4_->device_box = _tmp94_;
	_tmp95_ = content_box;
	gtk_box_append (_data4_->device_box, (GtkWidget*) _tmp95_);
	_tmp96_ = button_box;
	gtk_box_append (_data4_->device_box, (GtkWidget*) _tmp96_);
	_tmp97_ = adw_navigation_page_new ((GtkWidget*) _data4_->device_box, _ ("Printer Setup"));
	g_object_ref_sink (_tmp97_);
	setup_page = _tmp97_;
	_tmp98_ = self->priv->navigation_view;
	adw_navigation_view_push (_tmp98_, setup_page);
	_tmp99_ = previous_button;
	g_signal_connect_data (_tmp99_, "clicked", (GCallback) ___lambda36__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp100_ = cancel_button;
	g_signal_connect_object (_tmp100_, "clicked", (GCallback) ___lambda37__gtk_button_clicked, self, 0);
	_tmp101_ = self->priv->add_printer_button;
	g_signal_connect_data (_tmp101_, "clicked", (GCallback) ___lambda38__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp102_ = self->priv->driver_view;
	g_signal_connect_object (_tmp102_, "row-selected", (GCallback) ___lambda39__gtk_list_box_row_selected, self, 0);
	_tmp103_ = self->priv->description_entry;
	g_signal_connect_object ((GtkEditable*) _tmp103_, "changed", (GCallback) _printers_add_dialog_validate_form_gtk_editable_changed, self, 0);
	_tmp104_ = self->priv->description_entry;
	_tmp105_ = description_error;
	g_object_bind_property_with_closures ((GObject*) _tmp104_, "is-valid", (GObject*) _tmp105_, "reveal-child", G_BINDING_INVERT_BOOLEAN | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (setup_page);
	_g_object_unref0 (content_box);
	_g_object_unref0 (button_box);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (previous_button);
	_g_object_unref0 (frame);
	_g_object_unref0 (drivers_paned);
	_g_object_unref0 (driver_scrolled);
	_g_object_unref0 (make_scrolled);
	_g_object_unref0 (cellrenderer);
	_g_object_unref0 (spinner);
	_g_object_unref0 (location_label);
	_g_object_unref0 (description_error);
	_g_object_unref0 (description_label);
	_g_free0 (_tmp8_);
	_g_object_unref0 (connection_label);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
printers_add_dialog_validate_form (PrintersAddDialog* self)
{
	gboolean can_go_next = FALSE;
	gboolean _tmp0_ = FALSE;
	GraniteValidatedEntry* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	PrintersDeviceDriver* _tmp7_;
	GraniteValidatedEntry* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkButton* _tmp11_;
	g_return_if_fail (self != NULL);
	can_go_next = TRUE;
	_tmp1_ = self->priv->connection_entry;
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GraniteValidatedEntry* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->connection_entry;
		_tmp5_ = granite_validated_entry_get_is_valid (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	can_go_next &= _tmp0_;
	_tmp7_ = self->priv->selected_driver;
	can_go_next &= _tmp7_ != NULL;
	_tmp8_ = self->priv->description_entry;
	_tmp9_ = granite_validated_entry_get_is_valid (_tmp8_);
	_tmp10_ = _tmp9_;
	can_go_next &= _tmp10_;
	_tmp11_ = self->priv->add_printer_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, can_go_next);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PrintersAddDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->temp_device);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda32_ (Block5Data* _data5_)
{
	PrintersAddDialog* self;
	GCancellable* _tmp0_;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = self->priv->driver_cancellable;
	if (!g_cancellable_is_cancelled (_tmp0_)) {
		printers_add_dialog_drivers_loaded (self, _data5_->temp_device);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda32_ (self);
	return result;
}

static void*
__lambda31_ (Block5Data* _data5_)
{
	PrintersAddDialog* self;
	gchar* printer_uri = NULL;
	gchar* _tmp0_;
	gint printer_uri_length1;
	gint _printer_uri_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	ipp_t* request = NULL;
	ipp_t* _tmp2_;
	http_t* _tmp3_;
	ipp_t* _tmp4_;
	void* result;
	self = _data5_->self;
	_tmp0_ = g_new0 (gchar, HTTP_MAX_URI);
	printer_uri = _tmp0_;
	printer_uri_length1 = HTTP_MAX_URI;
	_printer_uri_size_ = printer_uri_length1;
	_tmp1_ = printer_uri;
	_tmp1__length1 = printer_uri_length1;
	httpAssembleURIf (HTTP_URI_CODING_QUERY, _tmp1_, (gint) _tmp1__length1, "ipp", NULL, "localhost", 0, NULL);
	_tmp2_ = ippNewRequest (CUPS_GET_PPDS);
	request = _tmp2_;
	_tmp3_ = CUPS_HTTP_DEFAULT;
	request = cupsDoRequest (_tmp3_, request, "/");
	_tmp4_ = request;
	if (ippGetStatusCode (_tmp4_) <= IPP_OK_CONFLICT) {
		ipp_attribute_t* attr = NULL;
		ipp_t* _tmp5_;
		ipp_attribute_t* _tmp6_;
		PrintersDeviceDriver* driver = NULL;
		PrintersDeviceDriver* _tmp7_;
		_tmp5_ = request;
		_tmp6_ = ippFirstAttribute (_tmp5_);
		attr = _tmp6_;
		_tmp7_ = printers_device_driver_new ();
		driver = _tmp7_;
		while (TRUE) {
			ipp_attribute_t* _tmp8_;
			ipp_attribute_t* _tmp9_;
			const gchar* _tmp10_;
			PrintersDeviceDriver* _tmp15_;
			ipp_attribute_t* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			GQuark _tmp21_ = 0U;
			static GQuark _tmp20_label0 = 0;
			static GQuark _tmp20_label1 = 0;
			static GQuark _tmp20_label2 = 0;
			static GQuark _tmp20_label3 = 0;
			static GQuark _tmp20_label4 = 0;
			static GQuark _tmp20_label5 = 0;
			static GQuark _tmp20_label6 = 0;
			static GQuark _tmp20_label7 = 0;
			static GQuark _tmp20_label8 = 0;
			ipp_t* _tmp56_;
			ipp_attribute_t* _tmp57_;
			_tmp8_ = attr;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = attr;
			_tmp10_ = ippGetName (_tmp9_);
			if (_tmp10_ == NULL) {
				GeeLinkedList* _tmp11_;
				PrintersDeviceDriver* _tmp12_;
				ipp_t* _tmp13_;
				ipp_attribute_t* _tmp14_;
				_tmp11_ = self->priv->drivers;
				_tmp12_ = driver;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				_g_object_unref0 (driver);
				driver = NULL;
				_tmp13_ = request;
				_tmp14_ = ippNextAttribute (_tmp13_);
				attr = _tmp14_;
				continue;
			}
			_tmp15_ = driver;
			if (_tmp15_ == NULL) {
				PrintersDeviceDriver* _tmp16_;
				_tmp16_ = printers_device_driver_new ();
				_g_object_unref0 (driver);
				driver = _tmp16_;
			}
			_tmp17_ = attr;
			_tmp18_ = ippGetName (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
			if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("ppd-name")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp22_;
						ipp_attribute_t* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp22_ = driver;
						_tmp23_ = attr;
						_tmp24_ = ippGetString (_tmp23_, 0, NULL);
						_tmp25_ = g_strdup (_tmp24_);
						_g_free0 (_tmp22_->ppd_name);
						_tmp22_->ppd_name = _tmp25_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("ppd-natural-language")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp26_;
						ipp_attribute_t* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp26_ = driver;
						_tmp27_ = attr;
						_tmp28_ = ippGetString (_tmp27_, 0, NULL);
						_tmp29_ = g_strdup (_tmp28_);
						_g_free0 (_tmp26_->ppd_natural_language);
						_tmp26_->ppd_natural_language = _tmp29_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("ppd-make")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp30_;
						ipp_attribute_t* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp30_ = driver;
						_tmp31_ = attr;
						_tmp32_ = ippGetString (_tmp31_, 0, NULL);
						_tmp33_ = g_strdup (_tmp32_);
						_g_free0 (_tmp30_->ppd_make);
						_tmp30_->ppd_make = _tmp33_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label3) ? _tmp20_label3 : (_tmp20_label3 = g_quark_from_static_string ("ppd-make-and-model")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp34_;
						ipp_attribute_t* _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp34_ = driver;
						_tmp35_ = attr;
						_tmp36_ = ippGetString (_tmp35_, 0, NULL);
						_tmp37_ = g_strdup (_tmp36_);
						_g_free0 (_tmp34_->ppd_make_and_model);
						_tmp34_->ppd_make_and_model = _tmp37_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label4) ? _tmp20_label4 : (_tmp20_label4 = g_quark_from_static_string ("ppd-device-id")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp38_;
						ipp_attribute_t* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp38_ = driver;
						_tmp39_ = attr;
						_tmp40_ = ippGetString (_tmp39_, 0, NULL);
						_tmp41_ = g_strdup (_tmp40_);
						_g_free0 (_tmp38_->ppd_device_id);
						_tmp38_->ppd_device_id = _tmp41_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label5) ? _tmp20_label5 : (_tmp20_label5 = g_quark_from_static_string ("ppd-product")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp42_;
						ipp_attribute_t* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp42_ = driver;
						_tmp43_ = attr;
						_tmp44_ = ippGetString (_tmp43_, 0, NULL);
						_tmp45_ = g_strdup (_tmp44_);
						_g_free0 (_tmp42_->ppd_product);
						_tmp42_->ppd_product = _tmp45_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label6) ? _tmp20_label6 : (_tmp20_label6 = g_quark_from_static_string ("ppd-psversion")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp46_;
						ipp_attribute_t* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp46_ = driver;
						_tmp47_ = attr;
						_tmp48_ = ippGetString (_tmp47_, 0, NULL);
						_tmp49_ = g_strdup (_tmp48_);
						_g_free0 (_tmp46_->ppd_psversion);
						_tmp46_->ppd_psversion = _tmp49_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label7) ? _tmp20_label7 : (_tmp20_label7 = g_quark_from_static_string ("ppd-type")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp50_;
						ipp_attribute_t* _tmp51_;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						_tmp50_ = driver;
						_tmp51_ = attr;
						_tmp52_ = ippGetString (_tmp51_, 0, NULL);
						_tmp53_ = g_strdup (_tmp52_);
						_g_free0 (_tmp50_->ppd_type);
						_tmp50_->ppd_type = _tmp53_;
						break;
					}
				}
			} else if (_tmp21_ == ((0 != _tmp20_label8) ? _tmp20_label8 : (_tmp20_label8 = g_quark_from_static_string ("ppd-model-number")))) {
				switch (0) {
					default:
					{
						PrintersDeviceDriver* _tmp54_;
						ipp_attribute_t* _tmp55_;
						_tmp54_ = driver;
						_tmp55_ = attr;
						_tmp54_->ppd_model_number = ippGetInteger (_tmp55_, 0);
						break;
					}
				}
			}
			_tmp56_ = request;
			_tmp57_ = ippNextAttribute (_tmp56_);
			attr = _tmp57_;
		}
		_g_object_unref0 (driver);
	} else {
		ipp_t* _tmp58_;
		const gchar* _tmp59_;
		_tmp58_ = request;
		_tmp59_ = ippErrorString (ippGetStatusCode (_tmp58_));
		g_critical ("AddDialog.vala:498: Error: %s", _tmp59_);
		result = NULL;
		_ippDelete0 (request);
		printer_uri = (g_free (printer_uri), NULL);
		return result;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda32__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	result = NULL;
	_ippDelete0 (request);
	printer_uri = (g_free (printer_uri), NULL);
	return result;
}

static gpointer
___lambda31__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda31_ (self);
	block5_data_unref (self);
	return result;
}

static void
printers_add_dialog_fetch_ppds (PrintersAddDialog* self,
                                PrintersTempDevice* temp_device)
{
	Block5Data* _data5_;
	PrintersTempDevice* _tmp0_;
	GThread* _tmp1_;
	GThread* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (temp_device != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (temp_device);
	_g_object_unref0 (_data5_->temp_device);
	_data5_->temp_device = _tmp0_;
	_tmp1_ = g_thread_new (NULL, ___lambda31__gthread_func, block5_data_ref (_data5_));
	_tmp2_ = _tmp1_;
	_g_thread_unref0 (_tmp2_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PrintersAddDialog* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->make_selection);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__lambda34_ (Block6Data* _data6_)
{
	PrintersAddDialog* self;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	self = _data6_->self;
	_tmp0_ = _data6_->make_selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		GValue val = {0};
		GValue _tmp5_ = {0};
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GValue _tmp8_ = {0};
		gchar* make_and_model = NULL;
		PrintersDeviceDriver* _tmp9_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		g_value_init (&_tmp5_, G_TYPE_STRING);
		val = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		gtk_tree_model_get_value (_tmp6_, &_tmp7_, 0, &_tmp8_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp8_;
		make_and_model = NULL;
		_tmp9_ = self->priv->selected_driver;
		if (_tmp9_ != NULL) {
			PrintersDeviceDriver* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = self->priv->selected_driver;
			_tmp11_ = _tmp10_->ppd_make_and_model;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (make_and_model);
			make_and_model = _tmp12_;
		}
		_tmp13_ = g_value_get_string (&val);
		_tmp14_ = make_and_model;
		printers_add_dialog_populate_driver_list_from_make (self, _tmp13_, _tmp14_);
		_g_free0 (make_and_model);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	_g_object_unref0 (model);
}

static void
___lambda34__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda34_ (self);
}

static void
printers_add_dialog_drivers_loaded (PrintersAddDialog* self,
                                    PrintersTempDevice* temp_device)
{
	Block6Data* _data6_;
	GeeTreeSet* make_list = NULL;
	GeeTreeSet* _tmp0_;
	GtkTreeView* _tmp13_;
	GtkTreeSelection* _tmp14_;
	GtkTreeSelection* _tmp15_;
	gchar* current_make = NULL;
	gchar* _tmp16_;
	GtkTreeSelection* _tmp42_;
	GtkTreeSelection* _tmp52_;
	GtkStack* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (temp_device != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	make_list = _tmp0_;
	{
		GeeLinkedList* _driver_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _driver_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _driver_index = 0;
		_tmp1_ = self->priv->drivers;
		_driver_list = _tmp1_;
		_tmp2_ = _driver_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_driver_size = _tmp4_;
		_driver_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PrintersDeviceDriver* driver = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			GeeTreeSet* _tmp9_;
			PrintersDeviceDriver* _tmp10_;
			const gchar* _tmp11_;
			GCancellable* _tmp12_;
			_driver_index = _driver_index + 1;
			_tmp5_ = _driver_index;
			_tmp6_ = _driver_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _driver_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _driver_index);
			driver = (PrintersDeviceDriver*) _tmp8_;
			_tmp9_ = make_list;
			_tmp10_ = driver;
			_tmp11_ = _tmp10_->ppd_make;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp11_);
			_tmp12_ = self->priv->driver_cancellable;
			if (g_cancellable_is_cancelled (_tmp12_)) {
				_g_object_unref0 (driver);
				_g_object_unref0 (make_list);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				return;
			}
			_g_object_unref0 (driver);
		}
	}
	_tmp13_ = self->priv->make_view;
	_tmp14_ = gtk_tree_view_get_selection (_tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_data6_->make_selection = _tmp15_;
	_tmp16_ = printers_temp_device_get_make_from_id (temp_device);
	current_make = _tmp16_;
	{
		GeeIterator* _make_it = NULL;
		GeeTreeSet* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp17_ = make_list;
		_tmp18_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp17_);
		_make_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			gchar* make = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp22_;
			GtkTreeIter _tmp23_ = {0};
			GtkListStore* _tmp24_;
			GtkTreeIter _tmp25_;
			const gchar* _tmp26_;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
			GCancellable* _tmp41_;
			_tmp19_ = _make_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _make_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			make = (gchar*) _tmp21_;
			_tmp22_ = self->priv->make_list_store;
			gtk_list_store_append (_tmp22_, &_tmp23_);
			iter = _tmp23_;
			_tmp24_ = self->priv->make_list_store;
			_tmp25_ = iter;
			_tmp26_ = make;
			gtk_list_store_set (_tmp24_, &_tmp25_, 0, _tmp26_, -1);
			_tmp28_ = current_make;
			if (_tmp28_ != NULL) {
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp29_ = make;
				_tmp30_ = current_make;
				_tmp27_ = g_strcmp0 (_tmp29_, _tmp30_) == 0;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				GtkTreeSelection* _tmp31_;
				GtkTreeIter _tmp32_;
				GtkTreeView* _tmp33_;
				GtkListStore* _tmp34_;
				GtkTreeIter _tmp35_;
				GtkTreePath* _tmp36_;
				GtkTreePath* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp31_ = _data6_->make_selection;
				_tmp32_ = iter;
				gtk_tree_selection_select_iter (_tmp31_, &_tmp32_);
				_tmp33_ = self->priv->make_view;
				_tmp34_ = self->priv->make_list_store;
				_tmp35_ = iter;
				_tmp36_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp34_, &_tmp35_);
				_tmp37_ = _tmp36_;
				gtk_tree_view_scroll_to_cell (_tmp33_, _tmp37_, NULL, TRUE, 0.0f, 0.0f);
				__vala_GtkTreePath_free0 (_tmp37_);
				_tmp38_ = make;
				_tmp39_ = printers_temp_device_get_model_from_id (temp_device);
				_tmp40_ = _tmp39_;
				printers_add_dialog_populate_driver_list_from_make (self, _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
			}
			_tmp41_ = self->priv->driver_cancellable;
			if (g_cancellable_is_cancelled (_tmp41_)) {
				_g_free0 (make);
				_g_object_unref0 (_make_it);
				_g_free0 (current_make);
				_g_object_unref0 (make_list);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				return;
			}
			_g_free0 (make);
		}
		_g_object_unref0 (_make_it);
	}
	_tmp42_ = _data6_->make_selection;
	if (gtk_tree_selection_count_selected_rows (_tmp42_) < 1) {
		GtkTreeIter iter = {0};
		GtkListStore* _tmp43_;
		GtkTreeIter _tmp44_ = {0};
		GtkTreeSelection* _tmp45_;
		GtkTreeIter _tmp46_;
		GValue val = {0};
		GValue _tmp47_ = {0};
		GtkListStore* _tmp48_;
		GtkTreeIter _tmp49_;
		GValue _tmp50_ = {0};
		const gchar* _tmp51_;
		_tmp43_ = self->priv->make_list_store;
		gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp43_, &_tmp44_);
		iter = _tmp44_;
		_tmp45_ = _data6_->make_selection;
		_tmp46_ = iter;
		gtk_tree_selection_select_iter (_tmp45_, &_tmp46_);
		g_value_init (&_tmp47_, G_TYPE_STRING);
		val = _tmp47_;
		_tmp48_ = self->priv->make_list_store;
		_tmp49_ = iter;
		gtk_tree_model_get_value ((GtkTreeModel*) _tmp48_, &_tmp49_, 0, &_tmp50_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp50_;
		_tmp51_ = g_value_get_string (&val);
		printers_add_dialog_populate_driver_list_from_make (self, _tmp51_, NULL);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	_tmp52_ = _data6_->make_selection;
	g_signal_connect_data (_tmp52_, "changed", (GCallback) ___lambda34__gtk_tree_selection_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, G_CONNECT_AFTER);
	_tmp53_ = self->priv->drivers_stack;
	gtk_stack_set_visible_child_name (_tmp53_, "drivers");
	_g_free0 (current_make);
	_g_object_unref0 (make_list);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
__lambda33_ (PrintersAddDialog* self,
             GObject* obj,
             GAsyncResult* res)
{
	GCancellable* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->driver_cancellable;
	if (!g_cancellable_is_cancelled (_tmp0_)) {
		GtkListBoxRow* row_to_select = NULL;
		GtkListBoxRow* _tmp1_;
		GtkListBox* _tmp2_;
		GtkListBoxRow* _tmp3_;
		_tmp1_ = printers_add_dialog_find_drivers_finish (self, res);
		row_to_select = _tmp1_;
		_tmp2_ = self->priv->driver_view;
		_tmp3_ = row_to_select;
		gtk_list_box_select_row (_tmp2_, _tmp3_);
		_g_object_unref0 (row_to_select);
	}
	_g_object_unref0 (self->priv->driver_cancellable);
	self->priv->driver_cancellable = NULL;
}

static void
___lambda33__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda33_ ((PrintersAddDialog*) self, source_object, res);
	g_object_unref (self);
}

static void
printers_add_dialog_populate_driver_list_from_make (PrintersAddDialog* self,
                                                    const gchar* make,
                                                    const gchar* selected_make_and_model)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (make != NULL);
	_tmp0_ = self->priv->driver_cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->driver_cancellable);
	self->priv->driver_cancellable = _tmp1_;
	while (TRUE) {
		GtkListBox* _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		_tmp2_ = self->priv->driver_view;
		_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, 0);
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = self->priv->driver_view;
		_tmp5_ = self->priv->driver_view;
		_tmp6_ = gtk_list_box_get_row_at_index (_tmp5_, 0);
		gtk_list_box_remove (_tmp4_, (GtkWidget*) _tmp6_);
	}
	printers_add_dialog_find_drivers (self, make, selected_make_and_model, ___lambda33__gasync_ready_callback, g_object_ref (self));
}

static void
printers_add_dialog_find_drivers_data_free (gpointer _data)
{
	PrintersAddDialogFindDriversData* _data_;
	_data_ = _data;
	_g_free0 (_data_->make);
	_g_free0 (_data_->selected_make_and_model);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PrintersAddDialogFindDriversData, _data_);
}

static void
printers_add_dialog_find_drivers (PrintersAddDialog* self,
                                  const gchar* make,
                                  const gchar* selected_make_and_model,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	PrintersAddDialogFindDriversData* _data_;
	PrintersAddDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (make != NULL);
	_data_ = g_slice_new0 (PrintersAddDialogFindDriversData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, printers_add_dialog_find_drivers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (make);
	_g_free0 (_data_->make);
	_data_->make = _tmp1_;
	_tmp2_ = g_strdup (selected_make_and_model);
	_g_free0 (_data_->selected_make_and_model);
	_data_->selected_make_and_model = _tmp2_;
	printers_add_dialog_find_drivers_co (_data_);
}

static GtkListBoxRow*
printers_add_dialog_find_drivers_finish (PrintersAddDialog* self,
                                         GAsyncResult* _res_)
{
	GtkListBoxRow* result;
	PrintersAddDialogFindDriversData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
_printers_add_dialog_find_drivers_co_gsource_func (gpointer self)
{
	gboolean result;
	result = printers_add_dialog_find_drivers_co (self);
	return result;
}

static gboolean
printers_add_dialog_find_drivers_co (PrintersAddDialogFindDriversData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->row_to_select = NULL;
	{
		_data_->_tmp0_ = _data_->self->priv->drivers;
		_data_->_driver_list = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->_driver_list;
		_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_driver_size = _data_->_tmp3_;
		_data_->_driver_index = -1;
		while (TRUE) {
			_data_->_driver_index = _data_->_driver_index + 1;
			_data_->_tmp4_ = _data_->_driver_index;
			_data_->_tmp5_ = _data_->_driver_size;
			if (!(_data_->_tmp4_ < _data_->_tmp5_)) {
				break;
			}
			_data_->_tmp6_ = _data_->_driver_list;
			_data_->_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp6_, _data_->_driver_index);
			_data_->driver = (PrintersDeviceDriver*) _data_->_tmp7_;
			_data_->_tmp8_ = _data_->self->priv->driver_cancellable;
			if (g_cancellable_is_cancelled (_data_->_tmp8_)) {
				_data_->result = NULL;
				_g_object_unref0 (_data_->driver);
				_g_object_unref0 (_data_->row_to_select);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp9_ = _data_->driver;
			_data_->_tmp10_ = _data_->_tmp9_->ppd_make;
			if (g_strcmp0 (_data_->_tmp10_, _data_->make) == 0) {
				_data_->_tmp11_ = _data_->driver;
				_data_->_tmp12_ = printers_add_dialog_driver_row_new (_data_->_tmp11_);
				g_object_ref_sink (_data_->_tmp12_);
				_data_->row = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->self->priv->driver_view;
				_data_->_tmp14_ = _data_->row;
				gtk_list_box_append (_data_->_tmp13_, (GtkWidget*) _data_->_tmp14_);
				_data_->_tmp15_ = _data_->driver;
				_data_->_tmp16_ = _data_->_tmp15_->ppd_make_and_model;
				if (g_strcmp0 (_data_->_tmp16_, _data_->selected_make_and_model) == 0) {
					_data_->_tmp17_ = _data_->row;
					_data_->_tmp18_ = _g_object_ref0 ((GtkListBoxRow*) _data_->_tmp17_);
					_g_object_unref0 (_data_->row_to_select);
					_data_->row_to_select = _data_->_tmp18_;
				}
				_g_object_unref0 (_data_->row);
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _printers_add_dialog_find_drivers_co_gsource_func, _data_, NULL);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
			_g_object_unref0 (_data_->driver);
		}
	}
	_data_->result = _data_->row_to_select;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
printers_add_dialog_temp_device_list_sort (PrintersAddDialogTempDeviceRow* row1,
                                           PrintersAddDialogTempDeviceRow* row2)
{
	PrintersTempDevice* _tmp0_;
	PrintersTempDevice* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = printers_add_dialog_temp_device_row_get_temp_device (row1);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->device_class;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("direct")))) {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp6_;
				PrintersTempDevice* _tmp7_;
				const gchar* _tmp8_;
				_tmp6_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_->device_class;
				if (g_strcmp0 (_tmp8_, "direct") == 0) {
					GCompareFunc _tmp9_;
					PrintersTempDevice* _tmp10_;
					PrintersTempDevice* _tmp11_;
					const gchar* _tmp12_;
					PrintersTempDevice* _tmp13_;
					PrintersTempDevice* _tmp14_;
					const gchar* _tmp15_;
					_tmp9_ = ((GCompareFunc) g_strcmp0);
					_tmp10_ = printers_add_dialog_temp_device_row_get_temp_device (row1);
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_->device_info;
					_tmp13_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
					_tmp14_ = _tmp13_;
					_tmp15_ = _tmp14_->device_info;
					result = _tmp9_ (_tmp12_, _tmp15_);
					return result;
				} else {
					result = -1;
					return result;
				}
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("ok-network")))) {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp16_;
				PrintersTempDevice* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_->device_class;
				if (g_strcmp0 (_tmp18_, "direct") == 0) {
					result = 1;
					return result;
				} else {
					PrintersTempDevice* _tmp19_;
					PrintersTempDevice* _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
					_tmp20_ = _tmp19_;
					_tmp21_ = _tmp20_->device_class;
					if (g_strcmp0 (_tmp21_, "ok-network") == 0) {
						GCompareFunc _tmp22_;
						PrintersTempDevice* _tmp23_;
						PrintersTempDevice* _tmp24_;
						const gchar* _tmp25_;
						PrintersTempDevice* _tmp26_;
						PrintersTempDevice* _tmp27_;
						const gchar* _tmp28_;
						_tmp22_ = ((GCompareFunc) g_strcmp0);
						_tmp23_ = printers_add_dialog_temp_device_row_get_temp_device (row1);
						_tmp24_ = _tmp23_;
						_tmp25_ = _tmp24_->device_info;
						_tmp26_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
						_tmp27_ = _tmp26_;
						_tmp28_ = _tmp27_->device_info;
						result = _tmp22_ (_tmp25_, _tmp28_);
						return result;
					} else {
						result = -1;
						return result;
					}
				}
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp29_;
				PrintersTempDevice* _tmp30_;
				const gchar* _tmp31_;
				_tmp29_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
				_tmp30_ = _tmp29_;
				_tmp31_ = _tmp30_->device_class;
				if (g_strcmp0 (_tmp31_, "direct") == 0) {
					result = 1;
					return result;
				} else {
					PrintersTempDevice* _tmp32_;
					PrintersTempDevice* _tmp33_;
					const gchar* _tmp34_;
					_tmp32_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
					_tmp33_ = _tmp32_;
					_tmp34_ = _tmp33_->device_class;
					if (g_strcmp0 (_tmp34_, "ok-network") == 0) {
						result = 1;
						return result;
					} else {
						PrintersTempDevice* _tmp35_;
						PrintersTempDevice* _tmp36_;
						const gchar* _tmp37_;
						_tmp35_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
						_tmp36_ = _tmp35_;
						_tmp37_ = _tmp36_->device_class;
						if (g_strcmp0 (_tmp37_, "network") == 0) {
							GCompareFunc _tmp38_;
							PrintersTempDevice* _tmp39_;
							PrintersTempDevice* _tmp40_;
							const gchar* _tmp41_;
							PrintersTempDevice* _tmp42_;
							PrintersTempDevice* _tmp43_;
							const gchar* _tmp44_;
							_tmp38_ = ((GCompareFunc) g_strcmp0);
							_tmp39_ = printers_add_dialog_temp_device_row_get_temp_device (row1);
							_tmp40_ = _tmp39_;
							_tmp41_ = _tmp40_->device_info;
							_tmp42_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
							_tmp43_ = _tmp42_;
							_tmp44_ = _tmp43_->device_info;
							result = _tmp38_ (_tmp41_, _tmp44_);
							return result;
						} else {
							result = -1;
							return result;
						}
					}
				}
			}
		}
	} else {
		switch (0) {
			default:
			{
				PrintersTempDevice* _tmp45_;
				PrintersTempDevice* _tmp46_;
				const gchar* _tmp47_;
				_tmp45_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp46_->device_class;
				if (g_strcmp0 (_tmp47_, "direct") == 0) {
					result = 1;
					return result;
				} else {
					PrintersTempDevice* _tmp48_;
					PrintersTempDevice* _tmp49_;
					const gchar* _tmp50_;
					_tmp48_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
					_tmp49_ = _tmp48_;
					_tmp50_ = _tmp49_->device_class;
					if (g_strcmp0 (_tmp50_, "ok-network") == 0) {
						result = 1;
						return result;
					} else {
						PrintersTempDevice* _tmp51_;
						PrintersTempDevice* _tmp52_;
						const gchar* _tmp53_;
						_tmp51_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
						_tmp52_ = _tmp51_;
						_tmp53_ = _tmp52_->device_class;
						if (g_strcmp0 (_tmp53_, "network") == 0) {
							result = 1;
							return result;
						} else {
							GCompareFunc _tmp54_;
							PrintersTempDevice* _tmp55_;
							PrintersTempDevice* _tmp56_;
							const gchar* _tmp57_;
							PrintersTempDevice* _tmp58_;
							PrintersTempDevice* _tmp59_;
							const gchar* _tmp60_;
							_tmp54_ = ((GCompareFunc) g_strcmp0);
							_tmp55_ = printers_add_dialog_temp_device_row_get_temp_device (row1);
							_tmp56_ = _tmp55_;
							_tmp57_ = _tmp56_->device_info;
							_tmp58_ = printers_add_dialog_temp_device_row_get_temp_device (row2);
							_tmp59_ = _tmp58_;
							_tmp60_ = _tmp59_->device_info;
							result = _tmp54_ (_tmp57_, _tmp60_);
							return result;
						}
					}
				}
			}
		}
	}
}

static void
printers_add_dialog_temp_device_list_header (PrintersAddDialogTempDeviceRow* row,
                                             PrintersAddDialogTempDeviceRow* before)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (row != NULL);
	if (before == NULL) {
		_tmp0_ = TRUE;
	} else {
		PrintersTempDevice* _tmp1_;
		PrintersTempDevice* _tmp2_;
		const gchar* _tmp3_;
		PrintersTempDevice* _tmp4_;
		PrintersTempDevice* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = printers_add_dialog_temp_device_row_get_temp_device (before);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_->device_class;
		_tmp4_ = printers_add_dialog_temp_device_row_get_temp_device (row);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->device_class;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp6_) != 0;
	}
	if (_tmp0_) {
		PrintersTempDevice* _tmp7_;
		PrintersTempDevice* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GQuark _tmp12_ = 0U;
		static GQuark _tmp11_label0 = 0;
		static GQuark _tmp11_label1 = 0;
		static GQuark _tmp11_label2 = 0;
		static GQuark _tmp11_label3 = 0;
		_tmp7_ = printers_add_dialog_temp_device_row_get_temp_device (row);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->device_class;
		_tmp10_ = _tmp9_;
		_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
		if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("serial")))) {
			switch (0) {
				default:
				{
					GraniteHeaderLabel* _tmp13_;
					GraniteHeaderLabel* _tmp14_;
					_tmp13_ = granite_header_label_new (_ ("Serial"));
					g_object_ref_sink (_tmp13_);
					_tmp14_ = _tmp13_;
					gtk_list_box_row_set_header ((GtkListBoxRow*) row, (GtkWidget*) _tmp14_);
					_g_object_unref0 (_tmp14_);
					break;
				}
			}
		} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("direct")))) {
			switch (0) {
				default:
				{
					GraniteHeaderLabel* _tmp15_;
					GraniteHeaderLabel* _tmp16_;
					_tmp15_ = granite_header_label_new (_ ("Local Printers"));
					g_object_ref_sink (_tmp15_);
					_tmp16_ = _tmp15_;
					gtk_list_box_row_set_header ((GtkListBoxRow*) row, (GtkWidget*) _tmp16_);
					_g_object_unref0 (_tmp16_);
					break;
				}
			}
		} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("network")))) {
			switch (0) {
				default:
				{
					GraniteHeaderLabel* _tmp17_;
					GraniteHeaderLabel* _tmp18_;
					_tmp17_ = granite_header_label_new (_ ("Network Printers"));
					g_object_ref_sink (_tmp17_);
					_tmp18_ = _tmp17_;
					gtk_list_box_row_set_header ((GtkListBoxRow*) row, (GtkWidget*) _tmp18_);
					_g_object_unref0 (_tmp18_);
					break;
				}
			}
		} else if (_tmp12_ == ((0 != _tmp11_label3) ? _tmp11_label3 : (_tmp11_label3 = g_quark_from_static_string ("ok-network")))) {
			switch (0) {
				default:
				{
					GraniteHeaderLabel* _tmp19_;
					GraniteHeaderLabel* _tmp20_;
					_tmp19_ = granite_header_label_new (_ ("Available Network Printers"));
					g_object_ref_sink (_tmp19_);
					_tmp20_ = _tmp19_;
					gtk_list_box_row_set_header ((GtkListBoxRow*) row, (GtkWidget*) _tmp20_);
					_g_object_unref0 (_tmp20_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					PrintersTempDevice* _tmp21_;
					PrintersTempDevice* _tmp22_;
					const gchar* _tmp23_;
					GraniteHeaderLabel* _tmp24_;
					GraniteHeaderLabel* _tmp25_;
					_tmp21_ = printers_add_dialog_temp_device_row_get_temp_device (row);
					_tmp22_ = _tmp21_;
					_tmp23_ = _tmp22_->device_class;
					_tmp24_ = granite_header_label_new (_tmp23_);
					g_object_ref_sink (_tmp24_);
					_tmp25_ = _tmp24_;
					gtk_list_box_row_set_header ((GtkListBoxRow*) row, (GtkWidget*) _tmp25_);
					_g_object_unref0 (_tmp25_);
					break;
				}
			}
		}
	} else {
		gtk_list_box_row_set_header ((GtkListBoxRow*) row, NULL);
	}
}

static inline gpointer
printers_add_dialog_temp_device_row_get_instance_private (PrintersAddDialogTempDeviceRow* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersAddDialogTempDeviceRow_private_offset);
}

PrintersAddDialogTempDeviceRow*
printers_add_dialog_temp_device_row_construct (GType object_type,
                                               PrintersTempDevice* temp_device)
{
	PrintersAddDialogTempDeviceRow * self = NULL;
	g_return_val_if_fail (temp_device != NULL, NULL);
	self = (PrintersAddDialogTempDeviceRow*) g_object_new (object_type, "temp-device", temp_device, NULL);
	return self;
}

PrintersAddDialogTempDeviceRow*
printers_add_dialog_temp_device_row_new (PrintersTempDevice* temp_device)
{
	return printers_add_dialog_temp_device_row_construct (PRINTERS_ADD_DIALOG_TYPE_TEMP_DEVICE_ROW, temp_device);
}

PrintersTempDevice*
printers_add_dialog_temp_device_row_get_temp_device (PrintersAddDialogTempDeviceRow* self)
{
	PrintersTempDevice* result;
	PrintersTempDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_temp_device;
	result = _tmp0_;
	return result;
}

void
printers_add_dialog_temp_device_row_set_temp_device (PrintersAddDialogTempDeviceRow* self,
                                                     PrintersTempDevice* value)
{
	PrintersTempDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_add_dialog_temp_device_row_get_temp_device (self);
	if (old_value != value) {
		PrintersTempDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_temp_device);
		self->priv->_temp_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_add_dialog_temp_device_row_properties[PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_TEMP_DEVICE_PROPERTY]);
	}
}

static GObject *
printers_add_dialog_temp_device_row_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersAddDialogTempDeviceRow * self;
	GtkLabel* label = NULL;
	PrintersTempDevice* _tmp0_;
	const gchar* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	parent_class = G_OBJECT_CLASS (printers_add_dialog_temp_device_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_ADD_DIALOG_TYPE_TEMP_DEVICE_ROW, PrintersAddDialogTempDeviceRow);
	_tmp0_ = self->priv->_temp_device;
	_tmp1_ = _tmp0_->device_info;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp2_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp2_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, 12);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	label = _tmp2_;
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp3_ = label;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp3_);
	_g_object_unref0 (label);
	return obj;
}

static void
printers_add_dialog_temp_device_row_class_init (PrintersAddDialogTempDeviceRowClass * klass,
                                                gpointer klass_data)
{
	printers_add_dialog_temp_device_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersAddDialogTempDeviceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_add_dialog_temp_device_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_add_dialog_temp_device_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_add_dialog_temp_device_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_add_dialog_temp_device_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_TEMP_DEVICE_PROPERTY, printers_add_dialog_temp_device_row_properties[PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_TEMP_DEVICE_PROPERTY] = g_param_spec_object ("temp-device", "temp-device", "temp-device", PRINTERS_TYPE_TEMP_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
printers_add_dialog_temp_device_row_instance_init (PrintersAddDialogTempDeviceRow * self,
                                                   gpointer klass)
{
	self->priv = printers_add_dialog_temp_device_row_get_instance_private (self);
}

static void
printers_add_dialog_temp_device_row_finalize (GObject * obj)
{
	PrintersAddDialogTempDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_ADD_DIALOG_TYPE_TEMP_DEVICE_ROW, PrintersAddDialogTempDeviceRow);
	_g_object_unref0 (self->priv->_temp_device);
	G_OBJECT_CLASS (printers_add_dialog_temp_device_row_parent_class)->finalize (obj);
}

static GType
printers_add_dialog_temp_device_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersAddDialogTempDeviceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_add_dialog_temp_device_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersAddDialogTempDeviceRow), 0, (GInstanceInitFunc) printers_add_dialog_temp_device_row_instance_init, NULL };
	GType printers_add_dialog_temp_device_row_type_id;
	printers_add_dialog_temp_device_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "PrintersAddDialogTempDeviceRow", &g_define_type_info, 0);
	PrintersAddDialogTempDeviceRow_private_offset = g_type_add_instance_private (printers_add_dialog_temp_device_row_type_id, sizeof (PrintersAddDialogTempDeviceRowPrivate));
	return printers_add_dialog_temp_device_row_type_id;
}

GType
printers_add_dialog_temp_device_row_get_type (void)
{
	static volatile gsize printers_add_dialog_temp_device_row_type_id__once = 0;
	if (g_once_init_enter (&printers_add_dialog_temp_device_row_type_id__once)) {
		GType printers_add_dialog_temp_device_row_type_id;
		printers_add_dialog_temp_device_row_type_id = printers_add_dialog_temp_device_row_get_type_once ();
		g_once_init_leave (&printers_add_dialog_temp_device_row_type_id__once, printers_add_dialog_temp_device_row_type_id);
	}
	return printers_add_dialog_temp_device_row_type_id__once;
}

static void
_vala_printers_add_dialog_temp_device_row_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	PrintersAddDialogTempDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_ADD_DIALOG_TYPE_TEMP_DEVICE_ROW, PrintersAddDialogTempDeviceRow);
	switch (property_id) {
		case PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_TEMP_DEVICE_PROPERTY:
		g_value_set_object (value, printers_add_dialog_temp_device_row_get_temp_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_add_dialog_temp_device_row_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	PrintersAddDialogTempDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_ADD_DIALOG_TYPE_TEMP_DEVICE_ROW, PrintersAddDialogTempDeviceRow);
	switch (property_id) {
		case PRINTERS_ADD_DIALOG_TEMP_DEVICE_ROW_TEMP_DEVICE_PROPERTY:
		printers_add_dialog_temp_device_row_set_temp_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
printers_add_dialog_driver_row_get_instance_private (PrintersAddDialogDriverRow* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersAddDialogDriverRow_private_offset);
}

PrintersAddDialogDriverRow*
printers_add_dialog_driver_row_construct (GType object_type,
                                          PrintersDeviceDriver* driver)
{
	PrintersAddDialogDriverRow * self = NULL;
	g_return_val_if_fail (driver != NULL, NULL);
	self = (PrintersAddDialogDriverRow*) g_object_new (object_type, "driver", driver, NULL);
	return self;
}

PrintersAddDialogDriverRow*
printers_add_dialog_driver_row_new (PrintersDeviceDriver* driver)
{
	return printers_add_dialog_driver_row_construct (PRINTERS_ADD_DIALOG_TYPE_DRIVER_ROW, driver);
}

PrintersDeviceDriver*
printers_add_dialog_driver_row_get_driver (PrintersAddDialogDriverRow* self)
{
	PrintersDeviceDriver* result;
	PrintersDeviceDriver* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_driver;
	result = _tmp0_;
	return result;
}

static void
printers_add_dialog_driver_row_set_driver (PrintersAddDialogDriverRow* self,
                                           PrintersDeviceDriver* value)
{
	PrintersDeviceDriver* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_add_dialog_driver_row_get_driver (self);
	if (old_value != value) {
		PrintersDeviceDriver* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_driver);
		self->priv->_driver = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, printers_add_dialog_driver_row_properties[PRINTERS_ADD_DIALOG_DRIVER_ROW_DRIVER_PROPERTY]);
	}
}

static GObject *
printers_add_dialog_driver_row_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersAddDialogDriverRow * self;
	gchar* model = NULL;
	PrintersDeviceDriver* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* model_label = NULL;
	const gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* detail_label = NULL;
	PrintersDeviceDriver* _tmp7_;
	const gchar* _tmp8_;
	PrintersDeviceDriver* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkBox* box = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkBox* _tmp18_;
	GtkLabel* _tmp19_;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkBox* _tmp22_;
	parent_class = G_OBJECT_CLASS (printers_add_dialog_driver_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_ADD_DIALOG_TYPE_DRIVER_ROW, PrintersAddDialogDriverRow);
	_tmp0_ = self->priv->_driver;
	_tmp1_ = _tmp0_->ppd_make_and_model;
	_tmp2_ = g_strdup (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	_tmp4_ = string_replace (_tmp3_, "(recommended)", _ ("(recommended)"));
	_g_free0 (model);
	model = _tmp4_;
	_tmp5_ = model;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	gtk_label_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_MIDDLE);
	g_object_ref_sink (_tmp6_);
	model_label = _tmp6_;
	_tmp7_ = self->priv->_driver;
	_tmp8_ = _tmp7_->ppd_natural_language;
	_tmp9_ = self->priv->_driver;
	_tmp10_ = _tmp9_->ppd_name;
	_tmp11_ = g_strdup_printf ("%s — %s", _tmp8_, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	gtk_label_set_ellipsize (_tmp13_, PANGO_ELLIPSIZE_MIDDLE);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	detail_label = _tmp14_;
	_tmp15_ = detail_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp15_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp16_ = detail_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp16_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp17_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp17_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 6);
	g_object_ref_sink (_tmp17_);
	box = _tmp17_;
	_tmp18_ = box;
	_tmp19_ = model_label;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = box;
	_tmp21_ = detail_label;
	gtk_box_append (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp22_);
	_g_object_unref0 (box);
	_g_object_unref0 (detail_label);
	_g_object_unref0 (model_label);
	_g_free0 (model);
	return obj;
}

static void
printers_add_dialog_driver_row_class_init (PrintersAddDialogDriverRowClass * klass,
                                           gpointer klass_data)
{
	printers_add_dialog_driver_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersAddDialogDriverRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_add_dialog_driver_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_add_dialog_driver_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_add_dialog_driver_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_add_dialog_driver_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_ADD_DIALOG_DRIVER_ROW_DRIVER_PROPERTY, printers_add_dialog_driver_row_properties[PRINTERS_ADD_DIALOG_DRIVER_ROW_DRIVER_PROPERTY] = g_param_spec_object ("driver", "driver", "driver", PRINTERS_TYPE_DEVICE_DRIVER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
printers_add_dialog_driver_row_instance_init (PrintersAddDialogDriverRow * self,
                                              gpointer klass)
{
	self->priv = printers_add_dialog_driver_row_get_instance_private (self);
}

static void
printers_add_dialog_driver_row_finalize (GObject * obj)
{
	PrintersAddDialogDriverRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_ADD_DIALOG_TYPE_DRIVER_ROW, PrintersAddDialogDriverRow);
	_g_object_unref0 (self->priv->_driver);
	G_OBJECT_CLASS (printers_add_dialog_driver_row_parent_class)->finalize (obj);
}

static GType
printers_add_dialog_driver_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersAddDialogDriverRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_add_dialog_driver_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersAddDialogDriverRow), 0, (GInstanceInitFunc) printers_add_dialog_driver_row_instance_init, NULL };
	GType printers_add_dialog_driver_row_type_id;
	printers_add_dialog_driver_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "PrintersAddDialogDriverRow", &g_define_type_info, 0);
	PrintersAddDialogDriverRow_private_offset = g_type_add_instance_private (printers_add_dialog_driver_row_type_id, sizeof (PrintersAddDialogDriverRowPrivate));
	return printers_add_dialog_driver_row_type_id;
}

GType
printers_add_dialog_driver_row_get_type (void)
{
	static volatile gsize printers_add_dialog_driver_row_type_id__once = 0;
	if (g_once_init_enter (&printers_add_dialog_driver_row_type_id__once)) {
		GType printers_add_dialog_driver_row_type_id;
		printers_add_dialog_driver_row_type_id = printers_add_dialog_driver_row_get_type_once ();
		g_once_init_leave (&printers_add_dialog_driver_row_type_id__once, printers_add_dialog_driver_row_type_id);
	}
	return printers_add_dialog_driver_row_type_id__once;
}

static void
_vala_printers_add_dialog_driver_row_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	PrintersAddDialogDriverRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_ADD_DIALOG_TYPE_DRIVER_ROW, PrintersAddDialogDriverRow);
	switch (property_id) {
		case PRINTERS_ADD_DIALOG_DRIVER_ROW_DRIVER_PROPERTY:
		g_value_set_object (value, printers_add_dialog_driver_row_get_driver (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_add_dialog_driver_row_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	PrintersAddDialogDriverRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_ADD_DIALOG_TYPE_DRIVER_ROW, PrintersAddDialogDriverRow);
	switch (property_id) {
		case PRINTERS_ADD_DIALOG_DRIVER_ROW_DRIVER_PROPERTY:
		printers_add_dialog_driver_row_set_driver (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PrintersAddDialog* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->next_button);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_printers_add_dialog___lambda40_ (Block7Data* _data7_,
                                  GtkListBoxRow* row)
{
	PrintersAddDialog* self;
	GtkButton* _tmp0_;
	self = _data7_->self;
	_tmp0_ = _data7_->next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, row != NULL);
}

static void
__printers_add_dialog___lambda40__gtk_list_box_row_selected (GtkListBox* _sender,
                                                             GtkListBoxRow* row,
                                                             gpointer self)
{
	_printers_add_dialog___lambda40_ (self, row);
}

static void
_printers_add_dialog___lambda41_ (PrintersAddDialog* self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__printers_add_dialog___lambda41__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_printers_add_dialog___lambda41_ ((PrintersAddDialog*) self);
}

static void
_printers_add_dialog___lambda42_ (PrintersAddDialog* self)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	PrintersTempDevice* _tmp2_;
	PrintersTempDevice* _tmp3_;
	_tmp0_ = self->priv->devices_list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = printers_add_dialog_temp_device_row_get_temp_device (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PRINTERS_ADD_DIALOG_TYPE_TEMP_DEVICE_ROW, PrintersAddDialogTempDeviceRow));
	_tmp3_ = _tmp2_;
	printers_add_dialog_continue_with_tempdevice (self, _tmp3_);
}

static void
__printers_add_dialog___lambda42__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_printers_add_dialog___lambda42_ ((PrintersAddDialog*) self);
}

static void
_printers_add_dialog___lambda43_ (PrintersAddDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	while (TRUE) {
		GtkListBox* _tmp1_;
		GtkListBoxRow* _tmp2_;
		GtkListBox* _tmp3_;
		GtkListBox* _tmp4_;
		GtkListBoxRow* _tmp5_;
		_tmp1_ = self->priv->devices_list;
		_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, 0);
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = self->priv->devices_list;
		_tmp4_ = self->priv->devices_list;
		_tmp5_ = gtk_list_box_get_row_at_index (_tmp4_, 0);
		gtk_list_box_remove (_tmp3_, (GtkWidget*) _tmp5_);
	}
	printers_add_dialog_search_device (self, NULL, NULL);
}

static void
__printers_add_dialog___lambda43__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_printers_add_dialog___lambda43_ ((PrintersAddDialog*) self);
}

static GObject *
printers_add_dialog_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersAddDialog * self;
	Block7Data* _data7_;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp0_ = NULL;
	GtkSpinner* _tmp1_;
	GtkLabel* loading_label = NULL;
	GtkLabel* _tmp2_;
	GtkBox* loading_box = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkLabel* _tmp5_;
	GtkBox* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkListBox* _tmp8_ = NULL;
	GtkListBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp13_;
	GtkWidget* _tmp14_;
	GtkScrolledWindow* _tmp15_ = NULL;
	GtkFrame* frame = NULL;
	GtkScrolledWindow* _tmp16_;
	GtkWidget* _tmp17_;
	GtkFrame* _tmp18_ = NULL;
	GtkFrame* _tmp19_;
	GtkButton* _tmp20_ = NULL;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_ = NULL;
	GtkButton* _tmp23_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkButton* _tmp27_;
	GtkBox* _tmp28_;
	GtkGrid* _tmp29_ = NULL;
	GtkGrid* _tmp30_;
	GtkBox* _tmp31_;
	GtkButton* _tmp32_;
	GtkBox* _tmp33_;
	GtkButton* _tmp34_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp35_;
	GtkSizeGroup* _tmp36_;
	GtkButton* _tmp37_;
	GtkSizeGroup* _tmp38_;
	GtkButton* _tmp39_;
	GtkSizeGroup* _tmp40_;
	GtkButton* _tmp41_;
	GtkBox* devices_box = NULL;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkFrame* _tmp44_;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	AdwNavigationPage* devices_page = NULL;
	GtkBox* _tmp47_;
	AdwNavigationPage* _tmp48_;
	AdwNavigationView* _tmp49_;
	AdwNavigationView* _tmp50_;
	AdwNavigationPage* _tmp51_;
	AdwNavigationView* _tmp52_;
	GeeLinkedList* _tmp53_;
	GtkListBox* _tmp54_;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_;
	GtkButton* _tmp57_;
	parent_class = G_OBJECT_CLASS (printers_add_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_ADD_DIALOG, PrintersAddDialog);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp0_);
	spinner = _tmp0_;
	_tmp1_ = spinner;
	gtk_spinner_start (_tmp1_);
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Finding nearby printers…"));
	g_object_ref_sink (_tmp2_);
	loading_label = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp3_);
	loading_box = _tmp3_;
	_tmp4_ = loading_box;
	_tmp5_ = loading_label;
	gtk_box_append (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = loading_box;
	_tmp7_ = spinner;
	gtk_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->devices_list);
	self->priv->devices_list = _tmp8_;
	_tmp9_ = self->priv->devices_list;
	_tmp10_ = loading_box;
	gtk_list_box_set_placeholder (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->devices_list;
	gtk_list_box_set_header_func (_tmp11_, (GtkListBoxUpdateHeaderFunc) printers_add_dialog_temp_device_list_header, NULL, NULL);
	_tmp12_ = self->priv->devices_list;
	gtk_list_box_set_sort_func (_tmp12_, (GtkListBoxSortFunc) printers_add_dialog_temp_device_list_sort, NULL, NULL);
	_tmp13_ = self->priv->devices_list;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	_tmp15_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	scrolled = _tmp15_;
	_tmp16_ = scrolled;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	frame = _tmp18_;
	_tmp19_ = frame;
	gtk_widget_add_css_class ((GtkWidget*) _tmp19_, "dialog-content-area");
	_tmp20_ = (GtkButton*) gtk_button_new_with_label (_ ("Refresh"));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, FALSE);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->refresh_button);
	self->priv->refresh_button = _tmp20_;
	_tmp21_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp21_);
	cancel_button = _tmp21_;
	_tmp22_ = (GtkButton*) gtk_button_new_with_label (_ ("Next"));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, FALSE);
	g_object_ref_sink (_tmp22_);
	_data7_->next_button = _tmp22_;
	_tmp23_ = _data7_->next_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp24_);
	button_box = _tmp24_;
	_tmp25_ = button_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp25_, "dialog-action-area");
	_tmp26_ = button_box;
	_tmp27_ = self->priv->refresh_button;
	gtk_box_append (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = button_box;
	_tmp29_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp29_, TRUE);
	g_object_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	gtk_box_append (_tmp28_, (GtkWidget*) _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = button_box;
	_tmp32_ = cancel_button;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = button_box;
	_tmp34_ = _data7_->next_button;
	gtk_box_append (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp35_;
	_tmp36_ = size_group;
	_tmp37_ = self->priv->refresh_button;
	gtk_size_group_add_widget (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = size_group;
	_tmp39_ = cancel_button;
	gtk_size_group_add_widget (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = size_group;
	_tmp41_ = _data7_->next_button;
	gtk_size_group_add_widget (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp42_);
	devices_box = _tmp42_;
	_tmp43_ = devices_box;
	_tmp44_ = frame;
	gtk_box_append (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = devices_box;
	_tmp46_ = button_box;
	gtk_box_append (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = devices_box;
	_tmp48_ = adw_navigation_page_new ((GtkWidget*) _tmp47_, _ ("Select Printer"));
	g_object_ref_sink (_tmp48_);
	devices_page = _tmp48_;
	_tmp49_ = (AdwNavigationView*) adw_navigation_view_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->navigation_view);
	self->priv->navigation_view = _tmp49_;
	_tmp50_ = self->priv->navigation_view;
	_tmp51_ = devices_page;
	adw_navigation_view_add (_tmp50_, _tmp51_);
	g_object_set ((GtkWindow*) self, "default-height", 450, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 500, NULL);
	_tmp52_ = self->priv->navigation_view;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp52_);
	_tmp53_ = gee_linked_list_new (PRINTERS_TYPE_DEVICE_DRIVER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->drivers);
	self->priv->drivers = _tmp53_;
	_tmp54_ = self->priv->devices_list;
	g_signal_connect_data (_tmp54_, "row-selected", (GCallback) __printers_add_dialog___lambda40__gtk_list_box_row_selected, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp55_ = cancel_button;
	g_signal_connect_object (_tmp55_, "clicked", (GCallback) __printers_add_dialog___lambda41__gtk_button_clicked, self, 0);
	_tmp56_ = _data7_->next_button;
	g_signal_connect_object (_tmp56_, "clicked", (GCallback) __printers_add_dialog___lambda42__gtk_button_clicked, self, 0);
	_tmp57_ = self->priv->refresh_button;
	g_signal_connect_object (_tmp57_, "clicked", (GCallback) __printers_add_dialog___lambda43__gtk_button_clicked, self, 0);
	_g_object_unref0 (devices_page);
	_g_object_unref0 (devices_box);
	_g_object_unref0 (size_group);
	_g_object_unref0 (button_box);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (frame);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (loading_box);
	_g_object_unref0 (loading_label);
	_g_object_unref0 (spinner);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return obj;
}

static void
printers_add_dialog_class_init (PrintersAddDialogClass * klass,
                                gpointer klass_data)
{
	printers_add_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersAddDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = printers_add_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_add_dialog_finalize;
}

static void
printers_add_dialog_instance_init (PrintersAddDialog * self,
                                   gpointer klass)
{
	self->priv = printers_add_dialog_get_instance_private (self);
	self->priv->selected_driver = NULL;
}

static void
printers_add_dialog_finalize (GObject * obj)
{
	PrintersAddDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_ADD_DIALOG, PrintersAddDialog);
	_g_object_unref0 (self->priv->navigation_view);
	_g_object_unref0 (self->priv->connection_entry);
	_g_object_unref0 (self->priv->description_entry);
	_g_object_unref0 (self->priv->add_printer_button);
	_g_object_unref0 (self->priv->refresh_button);
	_g_object_unref0 (self->priv->drivers_stack);
	_g_object_unref0 (self->priv->drivers);
	_g_object_unref0 (self->priv->driver_view);
	_g_object_unref0 (self->priv->make_list_store);
	_g_object_unref0 (self->priv->make_view);
	_g_object_unref0 (self->priv->devices_list);
	_g_object_unref0 (self->priv->selected_driver);
	_g_object_unref0 (self->priv->driver_cancellable);
	G_OBJECT_CLASS (printers_add_dialog_parent_class)->finalize (obj);
}

static GType
printers_add_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersAddDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_add_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersAddDialog), 0, (GInstanceInitFunc) printers_add_dialog_instance_init, NULL };
	GType printers_add_dialog_type_id;
	printers_add_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "PrintersAddDialog", &g_define_type_info, 0);
	PrintersAddDialog_private_offset = g_type_add_instance_private (printers_add_dialog_type_id, sizeof (PrintersAddDialogPrivate));
	return printers_add_dialog_type_id;
}

GType
printers_add_dialog_get_type (void)
{
	static volatile gsize printers_add_dialog_type_id__once = 0;
	if (g_once_init_enter (&printers_add_dialog_type_id__once)) {
		GType printers_add_dialog_type_id;
		printers_add_dialog_type_id = printers_add_dialog_get_type_once ();
		g_once_init_leave (&printers_add_dialog_type_id__once, printers_add_dialog_type_id);
	}
	return printers_add_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

