/* ToucheggSettings.c generated by valac 0.56.18, the Vala compiler
 * generated from ToucheggSettings.vala, do not modify */

/*
 * Copyright (c) 2020 elementary, Inc. (https://elementary.io)
 *               2020 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "mouse-touchpad.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <glib/gstdio.h>

#define MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_SETTINGS_XPATH "//application[@name=\"All\"]"
#define MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_MAXIMIZE_3_XPATH "//application[@name=\"All\"]/gesture[@fingers=\"3\"]/action[@type=\"MA" \
"XIMIZE_RESTORE_WINDOW\"]/.."
#define MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_MAXIMIZE_4_XPATH "//application[@name=\"All\"]/gesture[@fingers=\"4\"]/action[@type=\"MA" \
"XIMIZE_RESTORE_WINDOW\"]/.."
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_0_PROPERTY,
	MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_ERRORS_PROPERTY,
	MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* mouse_touchpad_touchegg_settings_properties[MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _xmlXPathFreeObject0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeObject (var), NULL)))
#define _xmlFreeNode0(var) ((var == NULL) ? NULL : (var = (xmlFreeNode (var), NULL)))

struct _MouseTouchpadToucheggSettingsPrivate {
	gboolean _errors;
	gchar* system_config_path;
	gchar* user_config_dir_path;
	gchar* user_config_path;
};

static gint MouseTouchpadToucheggSettings_private_offset;
static gpointer mouse_touchpad_touchegg_settings_parent_class = NULL;

static gchar* mouse_touchpad_touchegg_settings_build_maximize_xml (gint fingers);
static void mouse_touchpad_touchegg_settings_save_config (MouseTouchpadToucheggSettings* self,
                                                   const gchar* xpath_expression,
                                                   gboolean enabled,
                                                   gchar** xml_settings,
                                                   gint xml_settings_length1);
static gboolean mouse_touchpad_touchegg_settings_user_config_exists (MouseTouchpadToucheggSettings* self);
static void mouse_touchpad_touchegg_settings_set_errors (MouseTouchpadToucheggSettings* self,
                                                  gboolean value);
static void mouse_touchpad_touchegg_settings_remove_matching_nodes (xmlXPathContext* ctx,
                                                             const gchar* xpath_expression);
static void mouse_touchpad_touchegg_settings_append_xml (xmlNode* node,
                                                  const gchar* xml,
                                                  GError** error);
static void mouse_touchpad_touchegg_settings_finalize (GObject * obj);
static GType mouse_touchpad_touchegg_settings_get_type_once (void);
static void _vala_mouse_touchpad_touchegg_settings_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_mouse_touchpad_touchegg_settings_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
mouse_touchpad_touchegg_settings_get_instance_private (MouseTouchpadToucheggSettings* self)
{
	return G_STRUCT_MEMBER_P (self, MouseTouchpadToucheggSettings_private_offset);
}

MouseTouchpadToucheggSettings*
mouse_touchpad_touchegg_settings_construct (GType object_type)
{
	MouseTouchpadToucheggSettings * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (MouseTouchpadToucheggSettings*) g_object_new (object_type, NULL);
	_tmp0_ = g_build_filename (G_DIR_SEPARATOR_S, "usr", "share", "touchegg", "touchegg.conf", NULL);
	_g_free0 (self->priv->system_config_path);
	self->priv->system_config_path = _tmp0_;
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_build_filename (_tmp1_, ".config", "touchegg", NULL);
	_g_free0 (self->priv->user_config_dir_path);
	self->priv->user_config_dir_path = _tmp2_;
	_tmp3_ = g_get_home_dir ();
	_tmp4_ = g_build_filename (_tmp3_, ".config", "touchegg", "touchegg.conf", NULL);
	_g_free0 (self->priv->user_config_path);
	self->priv->user_config_path = _tmp4_;
	return self;
}

MouseTouchpadToucheggSettings*
mouse_touchpad_touchegg_settings_new (void)
{
	return mouse_touchpad_touchegg_settings_construct (MOUSE_TOUCHPAD_TYPE_TOUCHEGG_SETTINGS);
}

gboolean
mouse_touchpad_touchegg_settings_is_installed (MouseTouchpadToucheggSettings* self)
{
	gboolean config_installed = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GSettingsSchema* gala_schema = NULL;
	GSettingsSchemaSource* _tmp4_;
	GSettingsSchema* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->system_config_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	config_installed = _tmp3_;
	_tmp4_ = g_settings_schema_source_get_default ();
	_tmp5_ = g_settings_schema_source_lookup (_tmp4_, "io.elementary.desktop.wm.gestures", FALSE);
	gala_schema = _tmp5_;
	if (config_installed) {
		GSettingsSchema* _tmp7_;
		_tmp7_ = gala_schema;
		_tmp6_ = _tmp7_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	_g_settings_schema_unref0 (gala_schema);
	return result;
}

void
mouse_touchpad_touchegg_settings_set_maximize_settings (MouseTouchpadToucheggSettings* self,
                                                        gboolean enabled,
                                                        gint fingers)
{
	gchar* xml_settings = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* xpath = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = mouse_touchpad_touchegg_settings_build_maximize_xml (fingers);
	xml_settings = _tmp0_;
	if (fingers == 3) {
		_tmp1_ = MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_MAXIMIZE_3_XPATH;
	} else {
		_tmp1_ = MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_MAXIMIZE_4_XPATH;
	}
	_tmp2_ = g_strdup (_tmp1_);
	xpath = _tmp2_;
	_tmp3_ = xml_settings;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	mouse_touchpad_touchegg_settings_save_config (self, xpath, enabled, _tmp6_, (gint) 1);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (xpath);
	_g_free0 (xml_settings);
}

static gboolean
mouse_touchpad_touchegg_settings_user_config_exists (MouseTouchpadToucheggSettings* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->user_config_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
mouse_touchpad_touchegg_settings_parse_config (MouseTouchpadToucheggSettings* self)
{
	xmlDoc* doc = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	doc = NULL;
	{
		const gchar* _tmp0_ = NULL;
		gchar* config_path = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		xmlDoc* _tmp5_;
		xmlDoc* _tmp6_;
		xmlXPathContext* ctx = NULL;
		xmlDoc* _tmp9_;
		xmlXPathContext* _tmp10_;
		xmlXPathContext* _tmp11_;
		if (mouse_touchpad_touchegg_settings_user_config_exists (self)) {
			const gchar* _tmp1_;
			_tmp1_ = self->priv->user_config_path;
			_tmp0_ = _tmp1_;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = self->priv->system_config_path;
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = g_strdup (_tmp0_);
		config_path = _tmp3_;
		_tmp4_ = config_path;
		_tmp5_ = xmlParseFile (_tmp4_);
		doc = _tmp5_;
		_tmp6_ = doc;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			GError* _tmp8_;
			_tmp7_ = config_path;
			_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Error parsing config: %s", _tmp7_);
			_inner_error0_ = _tmp8_;
			_g_free0 (config_path);
			goto __catch0_g_error;
		}
		_tmp9_ = doc;
		_tmp10_ = xmlXPathNewContext (_tmp9_);
		ctx = _tmp10_;
		_tmp11_ = ctx;
		if (_tmp11_ == NULL) {
			GError* _tmp12_;
			_tmp12_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Error creating XPath context");
			_inner_error0_ = _tmp12_;
			_xmlXPathFreeContext0 (ctx);
			_g_free0 (config_path);
			goto __catch0_g_error;
		}
		mouse_touchpad_touchegg_settings_set_errors (self, FALSE);
		_xmlXPathFreeContext0 (ctx);
		_g_free0 (config_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("ToucheggSettings.vala:80: Error parsing Touchégg config: %s", _tmp14_);
		mouse_touchpad_touchegg_settings_set_errors (self, TRUE);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		xmlDoc* _tmp15_;
		_tmp15_ = doc;
		if (_tmp15_ != NULL) {
			xmlDoc* _tmp16_;
			_tmp16_ = doc;
			_xmlFreeDoc0 (_tmp16_);
		}
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
mouse_touchpad_touchegg_settings_save_config (MouseTouchpadToucheggSettings* self,
                                              const gchar* xpath_expression,
                                              gboolean enabled,
                                              gchar** xml_settings,
                                              gint xml_settings_length1)
{
	xmlDoc* doc = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (xpath_expression != NULL);
	doc = NULL;
	{
		gchar* config_path = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		xmlDoc* _tmp10_;
		xmlDoc* _tmp11_;
		xmlXPathContext* ctx = NULL;
		xmlDoc* _tmp14_;
		xmlXPathContext* _tmp15_;
		xmlXPathContext* _tmp16_;
		xmlXPathContext* _tmp18_;
		xmlDoc* _tmp36_;
		const gchar* _tmp37_;
		if (!mouse_touchpad_touchegg_settings_user_config_exists (self)) {
			const gchar* _tmp0_;
			GFile* system_config_file = NULL;
			const gchar* _tmp1_;
			GFile* _tmp2_;
			GFile* home_config_file = NULL;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			_tmp0_ = self->priv->user_config_dir_path;
			g_mkdir_with_parents (_tmp0_, 0775);
			_tmp1_ = self->priv->system_config_path;
			_tmp2_ = g_file_new_for_path (_tmp1_);
			system_config_file = _tmp2_;
			_tmp3_ = self->priv->user_config_path;
			_tmp4_ = g_file_new_for_path (_tmp3_);
			home_config_file = _tmp4_;
			_tmp5_ = system_config_file;
			_tmp6_ = home_config_file;
			g_file_copy (_tmp5_, _tmp6_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (home_config_file);
				_g_object_unref0 (system_config_file);
				goto __catch0_g_error;
			}
			_g_object_unref0 (home_config_file);
			_g_object_unref0 (system_config_file);
		}
		_tmp7_ = self->priv->user_config_path;
		_tmp8_ = g_strdup (_tmp7_);
		config_path = _tmp8_;
		_tmp9_ = config_path;
		_tmp10_ = xmlParseFile (_tmp9_);
		doc = _tmp10_;
		_tmp11_ = doc;
		if (_tmp11_ == NULL) {
			const gchar* _tmp12_;
			GError* _tmp13_;
			_tmp12_ = config_path;
			_tmp13_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Error parsing config: %s", _tmp12_);
			_inner_error0_ = _tmp13_;
			_g_free0 (config_path);
			goto __catch0_g_error;
		}
		_tmp14_ = doc;
		_tmp15_ = xmlXPathNewContext (_tmp14_);
		ctx = _tmp15_;
		_tmp16_ = ctx;
		if (_tmp16_ == NULL) {
			GError* _tmp17_;
			_tmp17_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Error creating XPath context");
			_inner_error0_ = _tmp17_;
			_xmlXPathFreeContext0 (ctx);
			_g_free0 (config_path);
			goto __catch0_g_error;
		}
		_tmp18_ = ctx;
		mouse_touchpad_touchegg_settings_remove_matching_nodes (_tmp18_, xpath_expression);
		if (enabled) {
			xmlXPathObject* obj = NULL;
			xmlXPathContext* _tmp19_;
			xmlXPathObject* _tmp20_;
			xmlXPathObject* _tmp21_;
			gboolean _tmp23_ = FALSE;
			xmlXPathObject* _tmp24_;
			xmlNodeSet* _tmp25_;
			xmlXPathObject* _tmp35_;
			_tmp19_ = ctx;
			_tmp20_ = xmlXPathEvalExpression ((xmlChar*) MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_SETTINGS_XPATH, _tmp19_);
			obj = _tmp20_;
			_tmp21_ = obj;
			if (_tmp21_ == NULL) {
				GError* _tmp22_;
				_tmp22_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "XPath %s not found", MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_SETTINGS_XPATH);
				_inner_error0_ = _tmp22_;
				_xmlXPathFreeContext0 (ctx);
				_g_free0 (config_path);
				goto __catch0_g_error;
			}
			_tmp24_ = obj;
			_tmp25_ = _tmp24_->nodesetval;
			if (_tmp25_ != NULL) {
				xmlXPathObject* _tmp26_;
				xmlNodeSet* _tmp27_;
				xmlNode* _tmp28_;
				_tmp26_ = obj;
				_tmp27_ = _tmp26_->nodesetval;
				_tmp28_ = xmlXPathNodeSetItem (_tmp27_, 0);
				_tmp23_ = _tmp28_ != NULL;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				xmlNode* node = NULL;
				xmlXPathObject* _tmp29_;
				xmlNodeSet* _tmp30_;
				xmlNode* _tmp31_;
				_tmp29_ = obj;
				_tmp30_ = _tmp29_->nodesetval;
				_tmp31_ = xmlXPathNodeSetItem (_tmp30_, 0);
				node = _tmp31_;
				{
					gchar** xml_collection = NULL;
					gint xml_collection_length1 = 0;
					gint _xml_collection_size_ = 0;
					gint xml_it = 0;
					xml_collection = xml_settings;
					xml_collection_length1 = xml_settings_length1;
					for (xml_it = 0; xml_it < xml_collection_length1; xml_it = xml_it + 1) {
						gchar* _tmp32_;
						gchar* xml = NULL;
						_tmp32_ = g_strdup (xml_collection[xml_it]);
						xml = _tmp32_;
						{
							xmlNode* _tmp33_;
							const gchar* _tmp34_;
							_tmp33_ = node;
							_tmp34_ = xml;
							mouse_touchpad_touchegg_settings_append_xml (_tmp33_, _tmp34_, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (xml);
								_xmlXPathFreeContext0 (ctx);
								_g_free0 (config_path);
								goto __catch0_g_error;
							}
							_g_free0 (xml);
						}
					}
				}
			}
			_tmp35_ = obj;
			_xmlXPathFreeObject0 (_tmp35_);
		}
		_tmp36_ = doc;
		_tmp37_ = config_path;
		xmlSaveFile (_tmp37_, _tmp36_);
		mouse_touchpad_touchegg_settings_set_errors (self, FALSE);
		_xmlXPathFreeContext0 (ctx);
		_g_free0 (config_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("ToucheggSettings.vala:133: Error saving Touchégg config: %s", _tmp39_);
		mouse_touchpad_touchegg_settings_set_errors (self, TRUE);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		xmlDoc* _tmp40_;
		_tmp40_ = doc;
		if (_tmp40_ != NULL) {
			xmlDoc* _tmp41_;
			_tmp41_ = doc;
			_xmlFreeDoc0 (_tmp41_);
		}
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
mouse_touchpad_touchegg_settings_remove_matching_nodes (xmlXPathContext* ctx,
                                                        const gchar* xpath_expression)
{
	gboolean done = FALSE;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (xpath_expression != NULL);
	done = FALSE;
	while (TRUE) {
		xmlXPathObject* obj = NULL;
		xmlXPathObject* _tmp0_;
		xmlXPathObject* _tmp1_;
		if (!(!done)) {
			break;
		}
		_tmp0_ = xmlXPathEvalExpression ((xmlChar*) xpath_expression, ctx);
		obj = _tmp0_;
		_tmp1_ = obj;
		if (_tmp1_ != NULL) {
			gboolean _tmp2_ = FALSE;
			xmlXPathObject* _tmp3_;
			xmlNodeSet* _tmp4_;
			xmlXPathObject* _tmp13_;
			_tmp3_ = obj;
			_tmp4_ = _tmp3_->nodesetval;
			if (_tmp4_ != NULL) {
				xmlXPathObject* _tmp5_;
				xmlNodeSet* _tmp6_;
				xmlNode* _tmp7_;
				_tmp5_ = obj;
				_tmp6_ = _tmp5_->nodesetval;
				_tmp7_ = xmlXPathNodeSetItem (_tmp6_, 0);
				_tmp2_ = _tmp7_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				xmlNode* node = NULL;
				xmlXPathObject* _tmp8_;
				xmlNodeSet* _tmp9_;
				xmlNode* _tmp10_;
				xmlNode* _tmp11_;
				xmlNode* _tmp12_;
				_tmp8_ = obj;
				_tmp9_ = _tmp8_->nodesetval;
				_tmp10_ = xmlXPathNodeSetItem (_tmp9_, 0);
				node = _tmp10_;
				_tmp11_ = node;
				xmlUnlinkNode (_tmp11_);
				_tmp12_ = node;
				_xmlFreeNode0 (_tmp12_);
			} else {
				done = TRUE;
			}
			_tmp13_ = obj;
			_xmlXPathFreeObject0 (_tmp13_);
		} else {
			done = TRUE;
		}
	}
}

static void
mouse_touchpad_touchegg_settings_append_xml (xmlNode* node,
                                             const gchar* xml,
                                             GError** error)
{
	xmlDoc* doc = NULL;
	gint _tmp0_;
	gint _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlNode* root = NULL;
	xmlDoc* _tmp5_;
	xmlNode* _tmp6_;
	xmlDoc* _tmp7_;
	xmlNode* _tmp8_;
	xmlNode* _tmp9_;
	xmlNode* _tmp12_;
	xmlDoc* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (xml != NULL);
	_tmp0_ = strlen (xml);
	_tmp1_ = _tmp0_;
	_tmp2_ = xmlReadMemory (xml, _tmp1_, NULL, NULL, 0);
	doc = _tmp2_;
	_tmp3_ = doc;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Error parsing XML string: %s", xml);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = doc;
	_tmp6_ = xmlDocGetRootElement (_tmp5_);
	_tmp7_ = node->doc;
	_tmp8_ = xmlDocCopyNode (_tmp6_, _tmp7_, 1);
	root = _tmp8_;
	_tmp9_ = root;
	if (_tmp9_ == NULL) {
		xmlDoc* _tmp10_;
		GError* _tmp11_;
		_tmp10_ = doc;
		_xmlFreeDoc0 (_tmp10_);
		_tmp11_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Error getting root element of XML string: %s", xml);
		_inner_error0_ = _tmp11_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = root;
	xmlAddChild (node, _tmp12_);
	_tmp13_ = doc;
	_xmlFreeDoc0 (_tmp13_);
}

static gchar*
mouse_touchpad_touchegg_settings_build_maximize_xml (gint fingers)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("\n" \
"            <gesture type=\"SWIPE\" fingers=\"%d\" direction=\"UP\">\n" \
"                <action type=\"MAXIMIZE_RESTORE_WINDOW\">\n" \
"                    <animate>true</animate>\n" \
"                </action>\n" \
"            </gesture>\n" \
"        ", fingers);
	result = _tmp0_;
	return result;
}

gboolean
mouse_touchpad_touchegg_settings_get_errors (MouseTouchpadToucheggSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_errors;
	return result;
}

static void
mouse_touchpad_touchegg_settings_set_errors (MouseTouchpadToucheggSettings* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mouse_touchpad_touchegg_settings_get_errors (self);
	if (old_value != value) {
		self->priv->_errors = value;
		g_object_notify_by_pspec ((GObject *) self, mouse_touchpad_touchegg_settings_properties[MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_ERRORS_PROPERTY]);
	}
}

static void
mouse_touchpad_touchegg_settings_class_init (MouseTouchpadToucheggSettingsClass * klass,
                                             gpointer klass_data)
{
	mouse_touchpad_touchegg_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MouseTouchpadToucheggSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mouse_touchpad_touchegg_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mouse_touchpad_touchegg_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = mouse_touchpad_touchegg_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_ERRORS_PROPERTY, mouse_touchpad_touchegg_settings_properties[MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_ERRORS_PROPERTY] = g_param_spec_boolean ("errors", "errors", "errors", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
mouse_touchpad_touchegg_settings_instance_init (MouseTouchpadToucheggSettings * self,
                                                gpointer klass)
{
	self->priv = mouse_touchpad_touchegg_settings_get_instance_private (self);
	self->priv->_errors = FALSE;
}

static void
mouse_touchpad_touchegg_settings_finalize (GObject * obj)
{
	MouseTouchpadToucheggSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOUSE_TOUCHPAD_TYPE_TOUCHEGG_SETTINGS, MouseTouchpadToucheggSettings);
	_g_free0 (self->priv->system_config_path);
	_g_free0 (self->priv->user_config_dir_path);
	_g_free0 (self->priv->user_config_path);
	G_OBJECT_CLASS (mouse_touchpad_touchegg_settings_parent_class)->finalize (obj);
}

/**
 * Utility class to configure Touchégg based gestures.
 */
static GType
mouse_touchpad_touchegg_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MouseTouchpadToucheggSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mouse_touchpad_touchegg_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MouseTouchpadToucheggSettings), 0, (GInstanceInitFunc) mouse_touchpad_touchegg_settings_instance_init, NULL };
	GType mouse_touchpad_touchegg_settings_type_id;
	mouse_touchpad_touchegg_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "MouseTouchpadToucheggSettings", &g_define_type_info, 0);
	MouseTouchpadToucheggSettings_private_offset = g_type_add_instance_private (mouse_touchpad_touchegg_settings_type_id, sizeof (MouseTouchpadToucheggSettingsPrivate));
	return mouse_touchpad_touchegg_settings_type_id;
}

GType
mouse_touchpad_touchegg_settings_get_type (void)
{
	static volatile gsize mouse_touchpad_touchegg_settings_type_id__once = 0;
	if (g_once_init_enter (&mouse_touchpad_touchegg_settings_type_id__once)) {
		GType mouse_touchpad_touchegg_settings_type_id;
		mouse_touchpad_touchegg_settings_type_id = mouse_touchpad_touchegg_settings_get_type_once ();
		g_once_init_leave (&mouse_touchpad_touchegg_settings_type_id__once, mouse_touchpad_touchegg_settings_type_id);
	}
	return mouse_touchpad_touchegg_settings_type_id__once;
}

static void
_vala_mouse_touchpad_touchegg_settings_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	MouseTouchpadToucheggSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOUSE_TOUCHPAD_TYPE_TOUCHEGG_SETTINGS, MouseTouchpadToucheggSettings);
	switch (property_id) {
		case MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_ERRORS_PROPERTY:
		g_value_set_boolean (value, mouse_touchpad_touchegg_settings_get_errors (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mouse_touchpad_touchegg_settings_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	MouseTouchpadToucheggSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOUSE_TOUCHPAD_TYPE_TOUCHEGG_SETTINGS, MouseTouchpadToucheggSettings);
	switch (property_id) {
		case MOUSE_TOUCHPAD_TOUCHEGG_SETTINGS_ERRORS_PROPERTY:
		mouse_touchpad_touchegg_settings_set_errors (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

