/* gamepad.c generated by valac 0.56.18, the Vala compiler
 * generated from gamepad.vala, do not modify */

/*
 * Copyright 2017 Felipe Escoto
 *           2016 Megh Parikh
 *
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LIB_GAMEPAD_TYPE_GAMEPAD (lib_gamepad_gamepad_get_type ())
#define LIB_GAMEPAD_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepad))
#define LIB_GAMEPAD_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepadClass))
#define LIB_GAMEPAD_IS_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_GAMEPAD))
#define LIB_GAMEPAD_IS_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_GAMEPAD))
#define LIB_GAMEPAD_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepadClass))

typedef struct _LibGamepadGamepad LibGamepadGamepad;
typedef struct _LibGamepadGamepadClass LibGamepadGamepadClass;
typedef struct _LibGamepadGamepadPrivate LibGamepadGamepadPrivate;

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD (lib_gamepad_raw_gamepad_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepad))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD))
#define LIB_GAMEPAD_RAW_GAMEPAD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepadIface))

typedef struct _LibGamepadRawGamepad LibGamepadRawGamepad;
typedef struct _LibGamepadRawGamepadIface LibGamepadRawGamepadIface;
enum  {
	LIB_GAMEPAD_GAMEPAD_0_PROPERTY,
	LIB_GAMEPAD_GAMEPAD_RAW_NAME_PROPERTY,
	LIB_GAMEPAD_GAMEPAD_GUID_PROPERTY,
	LIB_GAMEPAD_GAMEPAD_RAW_GAMEPAD_PROPERTY,
	LIB_GAMEPAD_GAMEPAD_NUM_PROPERTIES
};
static GParamSpec* lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	LIB_GAMEPAD_GAMEPAD_BUTTON_EVENT_SIGNAL,
	LIB_GAMEPAD_GAMEPAD_UNPLUGGED_SIGNAL,
	LIB_GAMEPAD_GAMEPAD_NUM_SIGNALS
};
static guint lib_gamepad_gamepad_signals[LIB_GAMEPAD_GAMEPAD_NUM_SIGNALS] = {0};

struct _LibGamepadGamepad {
	GObject parent_instance;
	LibGamepadGamepadPrivate * priv;
};

struct _LibGamepadGamepadClass {
	GObjectClass parent_class;
};

struct _LibGamepadRawGamepadIface {
	GTypeInterface parent_iface;
	const gchar* (*get_identifier) (LibGamepadRawGamepad* self);
	const gchar* (*get_name) (LibGamepadRawGamepad* self);
	const gchar* (*get_guid) (LibGamepadRawGamepad* self);
	guint8 (*get_axes_number) (LibGamepadRawGamepad* self);
	guint8 (*get_buttons_number) (LibGamepadRawGamepad* self);
	guint8 (*get_dpads_number) (LibGamepadRawGamepad* self);
};

struct _LibGamepadGamepadPrivate {
	gchar* _raw_name;
	gchar* _guid;
	LibGamepadRawGamepad* _raw_gamepad;
	GeeHashSet* pressed_buttons;
};

static gint LibGamepadGamepad_private_offset;
static gpointer lib_gamepad_gamepad_parent_class = NULL;

VALA_EXTERN GType lib_gamepad_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadGamepad, g_object_unref)
VALA_EXTERN GType lib_gamepad_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepad, g_object_unref)
VALA_EXTERN LibGamepadGamepad* lib_gamepad_gamepad_new (LibGamepadRawGamepad* raw_gamepad);
VALA_EXTERN LibGamepadGamepad* lib_gamepad_gamepad_construct (GType object_type,
                                                  LibGamepadRawGamepad* raw_gamepad);
static void lib_gamepad_gamepad_set_raw_gamepad (LibGamepadGamepad* self,
                                          LibGamepadRawGamepad* value);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_name (LibGamepadRawGamepad* self);
static void lib_gamepad_gamepad_set_raw_name (LibGamepadGamepad* self,
                                       const gchar* value);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_guid (LibGamepadRawGamepad* self);
static void lib_gamepad_gamepad_set_guid (LibGamepadGamepad* self,
                                   const gchar* value);
static void lib_gamepad_gamepad_on_raw_button_event (LibGamepadGamepad* self,
                                              gint button,
                                              gboolean value);
static void _lib_gamepad_gamepad_on_raw_button_event_lib_gamepad_raw_gamepad_button_event (LibGamepadRawGamepad* _sender,
                                                                                    gint code,
                                                                                    gboolean value,
                                                                                    gpointer self);
static void __lambda135_ (LibGamepadGamepad* self);
static void ___lambda135__lib_gamepad_raw_gamepad_unplugged (LibGamepadRawGamepad* _sender,
                                                      gpointer self);
VALA_EXTERN const gchar* lib_gamepad_gamepad_get_raw_name (LibGamepadGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_gamepad_get_guid (LibGamepadGamepad* self);
VALA_EXTERN LibGamepadRawGamepad* lib_gamepad_gamepad_get_raw_gamepad (LibGamepadGamepad* self);
static void lib_gamepad_gamepad_finalize (GObject * obj);
static GType lib_gamepad_gamepad_get_type_once (void);
static void _vala_lib_gamepad_gamepad_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_lib_gamepad_gamepad_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
lib_gamepad_gamepad_get_instance_private (LibGamepadGamepad* self)
{
	return G_STRUCT_MEMBER_P (self, LibGamepadGamepad_private_offset);
}

static void
_lib_gamepad_gamepad_on_raw_button_event_lib_gamepad_raw_gamepad_button_event (LibGamepadRawGamepad* _sender,
                                                                               gint code,
                                                                               gboolean value,
                                                                               gpointer self)
{
#line 60 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_on_raw_button_event ((LibGamepadGamepad*) self, code, value);
#line 167 "gamepad.c"
}

static void
__lambda135_ (LibGamepadGamepad* self)
{
#line 64 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_signal_emit (self, lib_gamepad_gamepad_signals[LIB_GAMEPAD_GAMEPAD_UNPLUGGED_SIGNAL], 0);
#line 175 "gamepad.c"
}

static void
___lambda135__lib_gamepad_raw_gamepad_unplugged (LibGamepadRawGamepad* _sender,
                                                 gpointer self)
{
#line 64 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	__lambda135_ ((LibGamepadGamepad*) self);
#line 184 "gamepad.c"
}

LibGamepadGamepad*
lib_gamepad_gamepad_construct (GType object_type,
                               LibGamepadRawGamepad* raw_gamepad)
{
	LibGamepadGamepad * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_val_if_fail (raw_gamepad != NULL, NULL);
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	self = (LibGamepadGamepad*) g_object_new (object_type, NULL);
#line 56 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_set_raw_gamepad (self, raw_gamepad);
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp0_ = lib_gamepad_raw_gamepad_get_name (raw_gamepad);
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp1_ = _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_set_raw_name (self, _tmp1_);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp2_ = lib_gamepad_raw_gamepad_get_guid (raw_gamepad);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp3_ = _tmp2_;
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_set_guid (self, _tmp3_);
#line 60 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_signal_connect_object (raw_gamepad, "button-event", (GCallback) _lib_gamepad_gamepad_on_raw_button_event_lib_gamepad_raw_gamepad_button_event, self, 0);
#line 64 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_signal_connect_object (raw_gamepad, "unplugged", (GCallback) ___lambda135__lib_gamepad_raw_gamepad_unplugged, self, 0);
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	return self;
#line 220 "gamepad.c"
}

LibGamepadGamepad*
lib_gamepad_gamepad_new (LibGamepadRawGamepad* raw_gamepad)
{
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	return lib_gamepad_gamepad_construct (LIB_GAMEPAD_TYPE_GAMEPAD, raw_gamepad);
#line 228 "gamepad.c"
}

static void
lib_gamepad_gamepad_on_raw_button_event (LibGamepadGamepad* self,
                                         gint button,
                                         gboolean value)
{
	gboolean _tmp0_ = FALSE;
#line 68 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_if_fail (self != NULL);
#line 69 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	if (value) {
#line 241 "gamepad.c"
		GeeHashSet* _tmp1_;
#line 69 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp1_ = self->priv->pressed_buttons;
#line 69 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp0_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, (gpointer) ((gintptr) button));
#line 247 "gamepad.c"
	} else {
#line 69 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp0_ = FALSE;
#line 251 "gamepad.c"
	}
#line 69 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	if (_tmp0_) {
#line 255 "gamepad.c"
		GeeHashSet* _tmp2_;
#line 70 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp2_ = self->priv->pressed_buttons;
#line 70 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((gintptr) button));
#line 71 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_debug ("gamepad.vala:71: Raw button pressed event: %d", button);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_signal_emit (self, lib_gamepad_gamepad_signals[LIB_GAMEPAD_GAMEPAD_BUTTON_EVENT_SIGNAL], 0, button);
#line 265 "gamepad.c"
	} else {
#line 73 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		if (!value) {
#line 269 "gamepad.c"
			GeeHashSet* _tmp3_;
#line 74 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
			_tmp3_ = self->priv->pressed_buttons;
#line 74 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, (gpointer) ((gintptr) button));
#line 75 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
			g_debug ("gamepad.vala:75: Raw button released event: %d", button);
#line 277 "gamepad.c"
		}
	}
}

const gchar*
lib_gamepad_gamepad_get_raw_name (LibGamepadGamepad* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp0_ = self->priv->_raw_name;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	result = _tmp0_;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	return result;
#line 295 "gamepad.c"
}

static void
lib_gamepad_gamepad_set_raw_name (LibGamepadGamepad* self,
                                  const gchar* value)
{
	gchar* old_value;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_if_fail (self != NULL);
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	old_value = lib_gamepad_gamepad_get_raw_name (self);
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 309 "gamepad.c"
		gchar* _tmp0_;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp0_ = g_strdup (value);
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_g_free0 (self->priv->_raw_name);
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		self->priv->_raw_name = _tmp0_;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_RAW_NAME_PROPERTY]);
#line 319 "gamepad.c"
	}
}

const gchar*
lib_gamepad_gamepad_get_guid (LibGamepadGamepad* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp0_ = self->priv->_guid;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	result = _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	return result;
#line 336 "gamepad.c"
}

static void
lib_gamepad_gamepad_set_guid (LibGamepadGamepad* self,
                              const gchar* value)
{
	gchar* old_value;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_if_fail (self != NULL);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	old_value = lib_gamepad_gamepad_get_guid (self);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 350 "gamepad.c"
		gchar* _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp0_ = g_strdup (value);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_g_free0 (self->priv->_guid);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		self->priv->_guid = _tmp0_;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_GUID_PROPERTY]);
#line 360 "gamepad.c"
	}
}

LibGamepadRawGamepad*
lib_gamepad_gamepad_get_raw_gamepad (LibGamepadGamepad* self)
{
	LibGamepadRawGamepad* result;
	LibGamepadRawGamepad* _tmp0_;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp0_ = self->priv->_raw_gamepad;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	result = _tmp0_;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	return result;
#line 377 "gamepad.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	return self ? g_object_ref (self) : NULL;
#line 385 "gamepad.c"
}

static void
lib_gamepad_gamepad_set_raw_gamepad (LibGamepadGamepad* self,
                                     LibGamepadRawGamepad* value)
{
	LibGamepadRawGamepad* old_value;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_return_if_fail (self != NULL);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	old_value = lib_gamepad_gamepad_get_raw_gamepad (self);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	if (old_value != value) {
#line 399 "gamepad.c"
		LibGamepadRawGamepad* _tmp0_;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		_g_object_unref0 (self->priv->_raw_gamepad);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		self->priv->_raw_gamepad = _tmp0_;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_RAW_GAMEPAD_PROPERTY]);
#line 409 "gamepad.c"
	}
}

static void
lib_gamepad_gamepad_class_init (LibGamepadGamepadClass * klass,
                                gpointer klass_data)
{
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_parent_class = g_type_class_peek_parent (klass);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_type_class_adjust_private_offset (klass, &LibGamepadGamepad_private_offset);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_lib_gamepad_gamepad_get_property;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_lib_gamepad_gamepad_set_property;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	G_OBJECT_CLASS (klass)->finalize = lib_gamepad_gamepad_finalize;
#line 427 "gamepad.c"
	/**
	     * The raw name reported by the driver
	     */
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_GAMEPAD_RAW_NAME_PROPERTY, lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_RAW_NAME_PROPERTY] = g_param_spec_string ("raw-name", "raw-name", "raw-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 433 "gamepad.c"
	/**
	     * The guid
	     */
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_GAMEPAD_GUID_PROPERTY, lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_GUID_PROPERTY] = g_param_spec_string ("guid", "guid", "guid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 439 "gamepad.c"
	/**
	     * The raw gamepad behind this gamepad
	     */
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_GAMEPAD_RAW_GAMEPAD_PROPERTY, lib_gamepad_gamepad_properties[LIB_GAMEPAD_GAMEPAD_RAW_GAMEPAD_PROPERTY] = g_param_spec_object ("raw-gamepad", "raw-gamepad", "raw-gamepad", LIB_GAMEPAD_TYPE_RAW_GAMEPAD, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 445 "gamepad.c"
	/**
	     * Emitted when a button is pressed
	     * @param  button        The button pressed
	     */
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_signals[LIB_GAMEPAD_GAMEPAD_BUTTON_EVENT_SIGNAL] = g_signal_new ("button-event", LIB_GAMEPAD_TYPE_GAMEPAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 452 "gamepad.c"
	/**
	     * Emitted when the gamepad is unplugged
	     */
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	lib_gamepad_gamepad_signals[LIB_GAMEPAD_GAMEPAD_UNPLUGGED_SIGNAL] = g_signal_new ("unplugged", LIB_GAMEPAD_TYPE_GAMEPAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 458 "gamepad.c"
}

static void
lib_gamepad_gamepad_instance_init (LibGamepadGamepad * self,
                                   gpointer klass)
{
	GeeHashSet* _tmp0_;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	self->priv = lib_gamepad_gamepad_get_instance_private (self);
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	self->priv->pressed_buttons = _tmp0_;
#line 472 "gamepad.c"
}

static void
lib_gamepad_gamepad_finalize (GObject * obj)
{
	LibGamepadGamepad * self;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepad);
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_g_free0 (self->priv->_raw_name);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_g_free0 (self->priv->_guid);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_g_object_unref0 (self->priv->_raw_gamepad);
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	_g_object_unref0 (self->priv->pressed_buttons);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	G_OBJECT_CLASS (lib_gamepad_gamepad_parent_class)->finalize (obj);
#line 491 "gamepad.c"
}

/**
 * This class represents a simplified gamepad
 *
 * The client interfaces with this class primarily
 */
static GType
lib_gamepad_gamepad_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibGamepadGamepadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gamepad_gamepad_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibGamepadGamepad), 0, (GInstanceInitFunc) lib_gamepad_gamepad_instance_init, NULL };
	GType lib_gamepad_gamepad_type_id;
	lib_gamepad_gamepad_type_id = g_type_register_static (G_TYPE_OBJECT, "LibGamepadGamepad", &g_define_type_info, 0);
	LibGamepadGamepad_private_offset = g_type_add_instance_private (lib_gamepad_gamepad_type_id, sizeof (LibGamepadGamepadPrivate));
	return lib_gamepad_gamepad_type_id;
}

GType
lib_gamepad_gamepad_get_type (void)
{
	static volatile gsize lib_gamepad_gamepad_type_id__once = 0;
	if (g_once_init_enter (&lib_gamepad_gamepad_type_id__once)) {
		GType lib_gamepad_gamepad_type_id;
		lib_gamepad_gamepad_type_id = lib_gamepad_gamepad_get_type_once ();
		g_once_init_leave (&lib_gamepad_gamepad_type_id__once, lib_gamepad_gamepad_type_id);
	}
	return lib_gamepad_gamepad_type_id__once;
}

static void
_vala_lib_gamepad_gamepad_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	LibGamepadGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepad);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	switch (property_id) {
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		case LIB_GAMEPAD_GAMEPAD_RAW_NAME_PROPERTY:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_value_set_string (value, lib_gamepad_gamepad_get_raw_name (self));
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		case LIB_GAMEPAD_GAMEPAD_GUID_PROPERTY:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_value_set_string (value, lib_gamepad_gamepad_get_guid (self));
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		case LIB_GAMEPAD_GAMEPAD_RAW_GAMEPAD_PROPERTY:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		g_value_set_object (value, lib_gamepad_gamepad_get_raw_gamepad (self));
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 549 "gamepad.c"
		default:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 555 "gamepad.c"
	}
}

static void
_vala_lib_gamepad_gamepad_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	LibGamepadGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepad);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
	switch (property_id) {
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		case LIB_GAMEPAD_GAMEPAD_RAW_NAME_PROPERTY:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		lib_gamepad_gamepad_set_raw_name (self, g_value_get_string (value));
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		case LIB_GAMEPAD_GAMEPAD_GUID_PROPERTY:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		lib_gamepad_gamepad_set_guid (self, g_value_get_string (value));
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		case LIB_GAMEPAD_GAMEPAD_RAW_GAMEPAD_PROPERTY:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		lib_gamepad_gamepad_set_raw_gamepad (self, g_value_get_object (value));
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 587 "gamepad.c"
		default:
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad.vala"
		break;
#line 593 "gamepad.c"
	}
}

