/* gamepad-monitor.c generated by valac 0.56.18, the Vala compiler
 * generated from gamepad-monitor.vala, do not modify */

/*
 * Copyright 2016 Megh Parikh
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR (lib_gamepad_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitor))
#define LIB_GAMEPAD_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitorClass))
#define LIB_GAMEPAD_IS_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_IS_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_GAMEPAD_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitorClass))

typedef struct _LibGamepadGamepadMonitor LibGamepadGamepadMonitor;
typedef struct _LibGamepadGamepadMonitorClass LibGamepadGamepadMonitorClass;
typedef struct _LibGamepadGamepadMonitorPrivate LibGamepadGamepadMonitorPrivate;

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR (lib_gamepad_raw_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, LibGamepadRawGamepadMonitor))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_RAW_GAMEPAD_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD_MONITOR, LibGamepadRawGamepadMonitorIface))

typedef struct _LibGamepadRawGamepadMonitor LibGamepadRawGamepadMonitor;
typedef struct _LibGamepadRawGamepadMonitorIface LibGamepadRawGamepadMonitorIface;

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD (lib_gamepad_raw_gamepad_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepad))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD))
#define LIB_GAMEPAD_RAW_GAMEPAD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepadIface))

typedef struct _LibGamepadRawGamepad LibGamepadRawGamepad;
typedef struct _LibGamepadRawGamepadIface LibGamepadRawGamepadIface;
typedef void (*LibGamepadRawGamepadMonitorRawGamepadCallback) (LibGamepadRawGamepad* raw_gamepad, gpointer user_data);
enum  {
	LIB_GAMEPAD_GAMEPAD_MONITOR_0_PROPERTY,
	LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPADS_NUMBER_PROPERTY,
	LIB_GAMEPAD_GAMEPAD_MONITOR_NUM_PROPERTIES
};
static GParamSpec* lib_gamepad_gamepad_monitor_properties[LIB_GAMEPAD_GAMEPAD_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR (lib_gamepad_linux_raw_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitor))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitorClass))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD_MONITOR, LibGamepadLinuxRawGamepadMonitorClass))

typedef struct _LibGamepadLinuxRawGamepadMonitor LibGamepadLinuxRawGamepadMonitor;
typedef struct _LibGamepadLinuxRawGamepadMonitorClass LibGamepadLinuxRawGamepadMonitorClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define LIB_GAMEPAD_TYPE_GAMEPAD (lib_gamepad_gamepad_get_type ())
#define LIB_GAMEPAD_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepad))
#define LIB_GAMEPAD_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepadClass))
#define LIB_GAMEPAD_IS_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_GAMEPAD))
#define LIB_GAMEPAD_IS_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_GAMEPAD))
#define LIB_GAMEPAD_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepadClass))

typedef struct _LibGamepadGamepad LibGamepadGamepad;
typedef struct _LibGamepadGamepadClass LibGamepadGamepadClass;
typedef void (*LibGamepadGamepadMonitorGamepadCallback) (LibGamepadGamepad* gamepad, gpointer user_data);
typedef struct _Block28Data Block28Data;
enum  {
	LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPAD_PLUGGED_SIGNAL,
	LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPAD_UNPLUGGED_SIGNAL,
	LIB_GAMEPAD_GAMEPAD_MONITOR_NUM_SIGNALS
};
static guint lib_gamepad_gamepad_monitor_signals[LIB_GAMEPAD_GAMEPAD_MONITOR_NUM_SIGNALS] = {0};

struct _LibGamepadGamepadMonitor {
	GObject parent_instance;
	LibGamepadGamepadMonitorPrivate * priv;
};

struct _LibGamepadGamepadMonitorClass {
	GObjectClass parent_class;
};

struct _LibGamepadRawGamepadIface {
	GTypeInterface parent_iface;
	const gchar* (*get_identifier) (LibGamepadRawGamepad* self);
	const gchar* (*get_name) (LibGamepadRawGamepad* self);
	const gchar* (*get_guid) (LibGamepadRawGamepad* self);
	guint8 (*get_axes_number) (LibGamepadRawGamepad* self);
	guint8 (*get_buttons_number) (LibGamepadRawGamepad* self);
	guint8 (*get_dpads_number) (LibGamepadRawGamepad* self);
};

struct _LibGamepadRawGamepadMonitorIface {
	GTypeInterface parent_iface;
	void (*foreach_gamepad) (LibGamepadRawGamepadMonitor* self, LibGamepadRawGamepadMonitorRawGamepadCallback callback, gpointer callback_target);
};

struct _LibGamepadGamepadMonitorPrivate {
	guint _gamepads_number;
	LibGamepadRawGamepadMonitor* raw_gamepad_monitor;
};

struct _Block28Data {
	int _ref_count_;
	LibGamepadGamepadMonitor* self;
	LibGamepadGamepadMonitorGamepadCallback callback;
	gpointer callback_target;
};

static gint LibGamepadGamepadMonitor_private_offset;
static gpointer lib_gamepad_gamepad_monitor_parent_class = NULL;
static GHashTable* lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad;
static GHashTable* lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad = NULL;
static GHashTable* lib_gamepad_gamepad_monitor_guid_to_raw_name;
static GHashTable* lib_gamepad_gamepad_monitor_guid_to_raw_name = NULL;

VALA_EXTERN GType lib_gamepad_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadGamepadMonitor, g_object_unref)
VALA_EXTERN GType lib_gamepad_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepad, g_object_unref)
VALA_EXTERN GType lib_gamepad_raw_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepadMonitor, g_object_unref)
VALA_EXTERN LibGamepadGamepadMonitor* lib_gamepad_gamepad_monitor_new (void);
VALA_EXTERN LibGamepadGamepadMonitor* lib_gamepad_gamepad_monitor_construct (GType object_type);
static void lib_gamepad_gamepad_monitor_init_static_if_not (void);
VALA_EXTERN LibGamepadLinuxRawGamepadMonitor* lib_gamepad_linux_raw_gamepad_monitor_new (void);
VALA_EXTERN LibGamepadLinuxRawGamepadMonitor* lib_gamepad_linux_raw_gamepad_monitor_construct (GType object_type);
VALA_EXTERN GType lib_gamepad_linux_raw_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadLinuxRawGamepadMonitor, g_object_unref)
static void lib_gamepad_gamepad_monitor_on_raw_gamepad_plugged (LibGamepadGamepadMonitor* self,
                                                         LibGamepadRawGamepad* raw_gamepad);
static void _lib_gamepad_gamepad_monitor_on_raw_gamepad_plugged_lib_gamepad_raw_gamepad_monitor_gamepad_plugged (LibGamepadRawGamepadMonitor* _sender,
                                                                                                          LibGamepadRawGamepad* raw_gamepad,
                                                                                                          gpointer self);
static void lib_gamepad_gamepad_monitor_on_raw_gamepad_unplugged (LibGamepadGamepadMonitor* self,
                                                           const gchar* identifier);
static void _lib_gamepad_gamepad_monitor_on_raw_gamepad_unplugged_lib_gamepad_raw_gamepad_monitor_gamepad_unplugged (LibGamepadRawGamepadMonitor* _sender,
                                                                                                              const gchar* identifier,
                                                                                                              gpointer self);
VALA_EXTERN void lib_gamepad_raw_gamepad_monitor_foreach_gamepad (LibGamepadRawGamepadMonitor* self,
                                                      LibGamepadRawGamepadMonitorRawGamepadCallback callback,
                                                      gpointer callback_target);
static void __lambda136_ (LibGamepadGamepadMonitor* self,
                   LibGamepadRawGamepad* raw_gamepad);
static void lib_gamepad_gamepad_monitor_add_gamepad (LibGamepadGamepadMonitor* self,
                                              LibGamepadRawGamepad* raw_gamepad);
static void ___lambda136__lib_gamepad_raw_gamepad_monitor_raw_gamepad_callback (LibGamepadRawGamepad* raw_gamepad,
                                                                         gpointer self);
VALA_EXTERN LibGamepadRawGamepad* lib_gamepad_gamepad_monitor_get_raw_gamepad (const gchar* identifier);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GType lib_gamepad_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadGamepad, g_object_unref)
VALA_EXTERN void lib_gamepad_gamepad_monitor_foreach_gamepad (LibGamepadGamepadMonitor* self,
                                                  LibGamepadGamepadMonitorGamepadCallback callback,
                                                  gpointer callback_target);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda137_ (Block28Data* _data28_,
                   const gchar* identifier,
                   LibGamepadRawGamepad* raw_gamepad);
VALA_EXTERN LibGamepadGamepad* lib_gamepad_gamepad_new (LibGamepadRawGamepad* raw_gamepad);
VALA_EXTERN LibGamepadGamepad* lib_gamepad_gamepad_construct (GType object_type,
                                                  LibGamepadRawGamepad* raw_gamepad);
static void ___lambda137__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
VALA_EXTERN guint lib_gamepad_gamepad_monitor_get_gamepads_number (LibGamepadGamepadMonitor* self);
static void lib_gamepad_gamepad_monitor_set_gamepads_number (LibGamepadGamepadMonitor* self,
                                                      guint value);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_identifier (LibGamepadRawGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_guid (LibGamepadRawGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_name (LibGamepadRawGamepad* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void lib_gamepad_gamepad_monitor_finalize (GObject * obj);
static GType lib_gamepad_gamepad_monitor_get_type_once (void);
static void _vala_lib_gamepad_gamepad_monitor_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_lib_gamepad_gamepad_monitor_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
lib_gamepad_gamepad_monitor_get_instance_private (LibGamepadGamepadMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, LibGamepadGamepadMonitor_private_offset);
}

static void
_lib_gamepad_gamepad_monitor_on_raw_gamepad_plugged_lib_gamepad_raw_gamepad_monitor_gamepad_plugged (LibGamepadRawGamepadMonitor* _sender,
                                                                                                     LibGamepadRawGamepad* raw_gamepad,
                                                                                                     gpointer self)
{
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_on_raw_gamepad_plugged ((LibGamepadGamepadMonitor*) self, raw_gamepad);
#line 241 "gamepad-monitor.c"
}

static void
_lib_gamepad_gamepad_monitor_on_raw_gamepad_unplugged_lib_gamepad_raw_gamepad_monitor_gamepad_unplugged (LibGamepadRawGamepadMonitor* _sender,
                                                                                                         const gchar* identifier,
                                                                                                         gpointer self)
{
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_on_raw_gamepad_unplugged ((LibGamepadGamepadMonitor*) self, identifier);
#line 251 "gamepad-monitor.c"
}

static void
__lambda136_ (LibGamepadGamepadMonitor* self,
              LibGamepadRawGamepad* raw_gamepad)
{
#line 60 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (raw_gamepad != NULL);
#line 61 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_add_gamepad (self, raw_gamepad);
#line 262 "gamepad-monitor.c"
}

static void
___lambda136__lib_gamepad_raw_gamepad_monitor_raw_gamepad_callback (LibGamepadRawGamepad* raw_gamepad,
                                                                    gpointer self)
{
#line 60 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	__lambda136_ ((LibGamepadGamepadMonitor*) self, raw_gamepad);
#line 271 "gamepad-monitor.c"
}

LibGamepadGamepadMonitor*
lib_gamepad_gamepad_monitor_construct (GType object_type)
{
	LibGamepadGamepadMonitor * self = NULL;
	LibGamepadLinuxRawGamepadMonitor* _tmp0_;
	LibGamepadRawGamepadMonitor* _tmp1_;
	LibGamepadRawGamepadMonitor* _tmp2_;
	LibGamepadRawGamepadMonitor* _tmp3_;
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	self = (LibGamepadGamepadMonitor*) g_object_new (object_type, NULL);
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_init_static_if_not ();
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = lib_gamepad_linux_raw_gamepad_monitor_new ();
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_g_object_unref0 (self->priv->raw_gamepad_monitor);
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	self->priv->raw_gamepad_monitor = (LibGamepadRawGamepadMonitor*) _tmp0_;
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp1_ = self->priv->raw_gamepad_monitor;
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_signal_connect_object (_tmp1_, "gamepad-plugged", (GCallback) _lib_gamepad_gamepad_monitor_on_raw_gamepad_plugged_lib_gamepad_raw_gamepad_monitor_gamepad_plugged, self, 0);
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp2_ = self->priv->raw_gamepad_monitor;
#line 58 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_signal_connect_object (_tmp2_, "gamepad-unplugged", (GCallback) _lib_gamepad_gamepad_monitor_on_raw_gamepad_unplugged_lib_gamepad_raw_gamepad_monitor_gamepad_unplugged, self, 0);
#line 60 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp3_ = self->priv->raw_gamepad_monitor;
#line 60 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_raw_gamepad_monitor_foreach_gamepad (_tmp3_, ___lambda136__lib_gamepad_raw_gamepad_monitor_raw_gamepad_callback, self);
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	return self;
#line 306 "gamepad-monitor.c"
}

LibGamepadGamepadMonitor*
lib_gamepad_gamepad_monitor_new (void)
{
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	return lib_gamepad_gamepad_monitor_construct (LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR);
#line 314 "gamepad-monitor.c"
}

/**
 * This static function returns a raw gamepad given a guid. It can be used
 * for creating interfaces for remappable-controls.
 * @param  identifier         The identifier of the raw gamepad that you want
 */
static gpointer
_g_object_ref0 (gpointer self)
{
#line 77 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 327 "gamepad-monitor.c"
}

LibGamepadRawGamepad*
lib_gamepad_gamepad_monitor_get_raw_gamepad (const gchar* identifier)
{
	LibGamepadRawGamepad* result;
#line 71 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_val_if_fail (identifier != NULL, NULL);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_init_static_if_not ();
#line 74 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (identifier == NULL) {
#line 75 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		result = NULL;
#line 75 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		return result;
#line 344 "gamepad-monitor.c"
	} else {
		GHashTable* _tmp0_;
		gconstpointer _tmp1_;
		LibGamepadRawGamepad* _tmp2_;
#line 77 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp0_ = lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad;
#line 77 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp1_ = g_hash_table_lookup (_tmp0_, identifier);
#line 77 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp2_ = _g_object_ref0 ((LibGamepadRawGamepad*) _tmp1_);
#line 77 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		result = _tmp2_;
#line 77 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		return result;
#line 359 "gamepad-monitor.c"
	}
}

static void
_g_free0_ (gpointer var)
{
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	var = (g_free (var), NULL);
#line 368 "gamepad-monitor.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 376 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_init_static_if_not (void)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
#line 81 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad;
#line 81 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (_tmp0_ == NULL) {
#line 388 "gamepad-monitor.c"
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp1_ = g_str_hash;
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp2_ = g_str_equal;
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_g_hash_table_unref0 (lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad);
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad = _tmp3_;
#line 402 "gamepad-monitor.c"
	}
#line 83 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp4_ = lib_gamepad_gamepad_monitor_guid_to_raw_name;
#line 83 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (_tmp4_ == NULL) {
#line 408 "gamepad-monitor.c"
		GHashFunc _tmp5_;
		GEqualFunc _tmp6_;
		GHashTable* _tmp7_;
#line 84 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp5_ = g_str_hash;
#line 84 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp6_ = g_str_equal;
#line 84 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_free0_);
#line 84 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_g_hash_table_unref0 (lib_gamepad_gamepad_monitor_guid_to_raw_name);
#line 84 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		lib_gamepad_gamepad_monitor_guid_to_raw_name = _tmp7_;
#line 422 "gamepad-monitor.c"
	}
}

/**
 * This function allows to iterate over all gamepads
 * @param    callback          The callback
 */
static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_atomic_int_inc (&_data28_->_ref_count_);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	return _data28_;
#line 437 "gamepad-monitor.c"
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
#line 447 "gamepad-monitor.c"
		LibGamepadGamepadMonitor* self;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		self = _data28_->self;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_g_object_unref0 (self);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		g_slice_free (Block28Data, _data28_);
#line 455 "gamepad-monitor.c"
	}
}

static void
__lambda137_ (Block28Data* _data28_,
              const gchar* identifier,
              LibGamepadRawGamepad* raw_gamepad)
{
	LibGamepadGamepadMonitor* self;
	LibGamepadGamepad* _tmp0_;
	LibGamepadGamepad* _tmp1_;
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	self = _data28_->self;
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (identifier != NULL);
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (raw_gamepad != NULL);
#line 93 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = lib_gamepad_gamepad_new (raw_gamepad);
#line 93 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp1_ = _tmp0_;
#line 93 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_->callback (_tmp1_, _data28_->callback_target);
#line 93 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_g_object_unref0 (_tmp1_);
#line 481 "gamepad-monitor.c"
}

static void
___lambda137__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	__lambda137_ (self, (const gchar*) key, (LibGamepadRawGamepad*) value);
#line 491 "gamepad-monitor.c"
}

void
lib_gamepad_gamepad_monitor_foreach_gamepad (LibGamepadGamepadMonitor* self,
                                             LibGamepadGamepadMonitorGamepadCallback callback,
                                             gpointer callback_target)
{
	Block28Data* _data28_;
	GHashTable* _tmp0_;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (self != NULL);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_ = g_slice_new0 (Block28Data);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_->_ref_count_ = 1;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_->self = g_object_ref (self);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_->callback = callback;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_->callback_target = callback_target;
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad;
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_hash_table_foreach (_tmp0_, ___lambda137__gh_func, _data28_);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	block28_data_unref (_data28_);
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_data28_ = NULL;
#line 521 "gamepad-monitor.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 534 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_add_gamepad (LibGamepadGamepadMonitor* self,
                                         LibGamepadRawGamepad* raw_gamepad)
{
	guint _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	LibGamepadRawGamepad* _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
#line 97 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (self != NULL);
#line 97 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (raw_gamepad != NULL);
#line 98 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = self->priv->_gamepads_number;
#line 98 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_set_gamepads_number (self, _tmp0_ + 1);
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp1_ = lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad;
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp2_ = lib_gamepad_raw_gamepad_get_identifier (raw_gamepad);
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp3_ = _tmp2_;
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp5_ = _g_object_ref0 (raw_gamepad);
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_hash_table_replace (_tmp1_, _tmp4_, _tmp5_);
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp6_ = lib_gamepad_gamepad_monitor_guid_to_raw_name;
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp7_ = lib_gamepad_raw_gamepad_get_guid (raw_gamepad);
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp8_ = _tmp7_;
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp11_ = lib_gamepad_raw_gamepad_get_name (raw_gamepad);
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp12_ = _tmp11_;
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 100 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_hash_table_replace (_tmp6_, _tmp10_, _tmp13_);
#line 593 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_on_raw_gamepad_plugged (LibGamepadGamepadMonitor* self,
                                                    LibGamepadRawGamepad* raw_gamepad)
{
	LibGamepadGamepad* _tmp0_;
	LibGamepadGamepad* _tmp1_;
#line 103 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (self != NULL);
#line 103 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (raw_gamepad != NULL);
#line 104 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_add_gamepad (self, raw_gamepad);
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = lib_gamepad_gamepad_new (raw_gamepad);
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp1_ = _tmp0_;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_signal_emit (self, lib_gamepad_gamepad_monitor_signals[LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPAD_PLUGGED_SIGNAL], 0, _tmp1_);
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_g_object_unref0 (_tmp1_);
#line 616 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_on_raw_gamepad_unplugged (LibGamepadGamepadMonitor* self,
                                                      const gchar* identifier)
{
	LibGamepadRawGamepad* raw_gamepad = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	LibGamepadRawGamepad* _tmp2_;
	LibGamepadRawGamepad* _tmp3_;
	guint _tmp4_;
	GHashTable* _tmp5_;
	LibGamepadRawGamepad* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	LibGamepadRawGamepad* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	LibGamepadRawGamepad* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	LibGamepadRawGamepad* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
#line 108 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (self != NULL);
#line 108 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (identifier != NULL);
#line 109 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp0_ = lib_gamepad_gamepad_monitor_identifier_to_raw_gamepad;
#line 109 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, identifier);
#line 109 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp2_ = _g_object_ref0 ((LibGamepadRawGamepad*) _tmp1_);
#line 109 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	raw_gamepad = _tmp2_;
#line 110 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp3_ = raw_gamepad;
#line 110 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (_tmp3_ == NULL) {
#line 111 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		_g_object_unref0 (raw_gamepad);
#line 111 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		return;
#line 663 "gamepad-monitor.c"
	}
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp4_ = self->priv->_gamepads_number;
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_set_gamepads_number (self, _tmp4_ - 1);
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp5_ = lib_gamepad_gamepad_monitor_guid_to_raw_name;
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp6_ = raw_gamepad;
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp7_ = lib_gamepad_raw_gamepad_get_guid (_tmp6_);
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp8_ = _tmp7_;
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_hash_table_remove (_tmp5_, _tmp9_);
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp10_ = raw_gamepad;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp11_ = lib_gamepad_raw_gamepad_get_identifier (_tmp10_);
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp12_ = _tmp11_;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp13_ = raw_gamepad;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp14_ = lib_gamepad_raw_gamepad_get_guid (_tmp13_);
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp15_ = _tmp14_;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp16_ = raw_gamepad;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp17_ = lib_gamepad_raw_gamepad_get_name (_tmp16_);
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_tmp18_ = _tmp17_;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_signal_emit (self, lib_gamepad_gamepad_monitor_signals[LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPAD_UNPLUGGED_SIGNAL], 0, _tmp12_, _tmp15_, _tmp18_);
#line 108 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_g_object_unref0 (raw_gamepad);
#line 703 "gamepad-monitor.c"
}

guint
lib_gamepad_gamepad_monitor_get_gamepads_number (LibGamepadGamepadMonitor* self)
{
	guint result;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	result = self->priv->_gamepads_number;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	return result;
#line 716 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_set_gamepads_number (LibGamepadGamepadMonitor* self,
                                                 guint value)
{
	guint old_value;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (self != NULL);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	old_value = lib_gamepad_gamepad_monitor_get_gamepads_number (self);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (old_value != value) {
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		self->priv->_gamepads_number = value;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		g_object_notify_by_pspec ((GObject *) self, lib_gamepad_gamepad_monitor_properties[LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPADS_NUMBER_PROPERTY]);
#line 734 "gamepad-monitor.c"
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_return_if_fail (n_param_values == 4);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		data1 = closure->data;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 760 "gamepad-monitor.c"
	} else {
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		data2 = closure->data;
#line 766 "gamepad-monitor.c"
	}
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
#line 772 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_class_init (LibGamepadGamepadMonitorClass * klass,
                                        gpointer klass_data)
{
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_parent_class = g_type_class_peek_parent (klass);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_type_class_adjust_private_offset (klass, &LibGamepadGamepadMonitor_private_offset);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_lib_gamepad_gamepad_monitor_get_property;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_lib_gamepad_gamepad_monitor_set_property;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	G_OBJECT_CLASS (klass)->finalize = lib_gamepad_gamepad_monitor_finalize;
#line 789 "gamepad-monitor.c"
	/**
	 * The number of plugged in gamepads
	 */
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPADS_NUMBER_PROPERTY, lib_gamepad_gamepad_monitor_properties[LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPADS_NUMBER_PROPERTY] = g_param_spec_uint ("gamepads-number", "gamepads-number", "gamepads-number", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 795 "gamepad-monitor.c"
	/**
	 * Emitted when a gamepad is plugged in
	 * @param  gamepad    The gamepad
	 */
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_signals[LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPAD_PLUGGED_SIGNAL] = g_signal_new ("gamepad-plugged", LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, LIB_GAMEPAD_TYPE_GAMEPAD);
#line 802 "gamepad-monitor.c"
	/**
	 * Emitted when a gamepad is unplugged
	 * @param  identifier    The identifier of the unplugged gamepad
	 * @param  guid          The guid of the unplugged gamepad
	 * @param  name          The name of the unplugged gamepad
	 */
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	lib_gamepad_gamepad_monitor_signals[LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPAD_UNPLUGGED_SIGNAL] = g_signal_new ("gamepad-unplugged", LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
#line 811 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_instance_init (LibGamepadGamepadMonitor * self,
                                           gpointer klass)
{
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	self->priv = lib_gamepad_gamepad_monitor_get_instance_private (self);
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	self->priv->_gamepads_number = (guint) 0;
#line 822 "gamepad-monitor.c"
}

static void
lib_gamepad_gamepad_monitor_finalize (GObject * obj)
{
	LibGamepadGamepadMonitor * self;
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitor);
#line 50 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	_g_object_unref0 (self->priv->raw_gamepad_monitor);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	G_OBJECT_CLASS (lib_gamepad_gamepad_monitor_parent_class)->finalize (obj);
#line 835 "gamepad-monitor.c"
}

/**
 * This class provides a way to the client to monitor gamepads
 *
 * The client interfaces with this class primarily
 */
static GType
lib_gamepad_gamepad_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibGamepadGamepadMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gamepad_gamepad_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibGamepadGamepadMonitor), 0, (GInstanceInitFunc) lib_gamepad_gamepad_monitor_instance_init, NULL };
	GType lib_gamepad_gamepad_monitor_type_id;
	lib_gamepad_gamepad_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "LibGamepadGamepadMonitor", &g_define_type_info, 0);
	LibGamepadGamepadMonitor_private_offset = g_type_add_instance_private (lib_gamepad_gamepad_monitor_type_id, sizeof (LibGamepadGamepadMonitorPrivate));
	return lib_gamepad_gamepad_monitor_type_id;
}

GType
lib_gamepad_gamepad_monitor_get_type (void)
{
	static volatile gsize lib_gamepad_gamepad_monitor_type_id__once = 0;
	if (g_once_init_enter (&lib_gamepad_gamepad_monitor_type_id__once)) {
		GType lib_gamepad_gamepad_monitor_type_id;
		lib_gamepad_gamepad_monitor_type_id = lib_gamepad_gamepad_monitor_get_type_once ();
		g_once_init_leave (&lib_gamepad_gamepad_monitor_type_id__once, lib_gamepad_gamepad_monitor_type_id);
	}
	return lib_gamepad_gamepad_monitor_type_id__once;
}

static void
_vala_lib_gamepad_gamepad_monitor_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	LibGamepadGamepadMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitor);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	switch (property_id) {
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		case LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPADS_NUMBER_PROPERTY:
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		g_value_set_uint (value, lib_gamepad_gamepad_monitor_get_gamepads_number (self));
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		break;
#line 881 "gamepad-monitor.c"
		default:
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		break;
#line 887 "gamepad-monitor.c"
	}
}

static void
_vala_lib_gamepad_gamepad_monitor_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	LibGamepadGamepadMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitor);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
	switch (property_id) {
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		case LIB_GAMEPAD_GAMEPAD_MONITOR_GAMEPADS_NUMBER_PROPERTY:
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		lib_gamepad_gamepad_monitor_set_gamepads_number (self, g_value_get_uint (value));
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		break;
#line 907 "gamepad-monitor.c"
		default:
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../Spice-up-1.9.1/src/Services/libgamepad/gamepad-monitor.vala"
		break;
#line 913 "gamepad-monitor.c"
	}
}

