/* TextItem.c generated by valac 0.56.18, the Vala compiler
 * generated from TextItem.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <granite.h>

#define SPICE_TEXT_ITEM_TEXT_STYLE_CSS "\n" \
"        .colored, .view text {\n" \
"            color: %s;\n" \
"            font: %s;\n" \
"            padding: 0px;\n" \
"            background: 0;\n" \
"        }\n" \
"    "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
typedef struct _SpiceCanvasItemPrivate SpiceCanvasItemPrivate;

#define SPICE_TYPE_TEXT_ITEM (spice_text_item_get_type ())
#define SPICE_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItem))
#define SPICE_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))
#define SPICE_IS_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_TEXT_ITEM))
#define SPICE_IS_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_TEXT_ITEM))
#define SPICE_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))

typedef struct _SpiceTextItem SpiceTextItem;
typedef struct _SpiceTextItemClass SpiceTextItemClass;
typedef struct _SpiceTextItemPrivate SpiceTextItemPrivate;
enum  {
	SPICE_TEXT_ITEM_0_PROPERTY,
	SPICE_TEXT_ITEM_JUSTIFICATION_PROPERTY,
	SPICE_TEXT_ITEM_ALIGN_PROPERTY,
	SPICE_TEXT_ITEM_FONT_SIZE_PROPERTY,
	SPICE_TEXT_ITEM_FONT_PROPERTY,
	SPICE_TEXT_ITEM_FONT_COLOR_PROPERTY,
	SPICE_TEXT_ITEM_FONT_STYLE_PROPERTY,
	SPICE_TEXT_ITEM_TEXT_PROPERTY,
	SPICE_TEXT_ITEM_NUM_PROPERTIES
};
static GParamSpec* spice_text_item_properties[SPICE_TEXT_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SpiceCanvasItem {
	GtkEventBox parent_instance;
	SpiceCanvasItemPrivate * priv;
	gdouble start_x;
	gdouble start_y;
	gint start_w;
	gint start_h;
	gboolean holding;
	gint holding_id;
	gint real_width;
	gint real_height;
	gint real_x;
	gint real_y;
	GtkGrid* grid;
	GtkRevealer* grabber_revealer;
};

struct _SpiceCanvasItemClass {
	GtkEventBoxClass parent_class;
	gchar* (*serialise_item) (SpiceCanvasItem* self);
	void (*load_item_data) (SpiceCanvasItem* self);
	void (*style) (SpiceCanvasItem* self);
};

struct _SpiceTextItem {
	SpiceCanvasItem parent_instance;
	SpiceTextItemPrivate * priv;
	GtkTextView* entry;
	gboolean setting_text;
	gboolean first_change_in_edit;
	gchar* previous_text;
	gboolean underlined;
};

struct _SpiceTextItemClass {
	SpiceCanvasItemClass parent_class;
};

struct _SpiceTextItemPrivate {
	GtkLabel* label;
	GtkStack* stack;
	gint _justification;
	gint _align;
	gint _font_size;
	gchar* _font;
	gchar* _font_color;
	gchar* _font_style;
};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

static gint SpiceTextItem_private_offset;
static gpointer spice_text_item_parent_class = NULL;

VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN GType spice_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceTextItem, g_object_unref)
VALA_EXTERN void spice_canvas_item_load_item_data (SpiceCanvasItem* self);
VALA_EXTERN gchar* spice_canvas_item_serialise_item (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_item_style (SpiceCanvasItem* self);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN SpiceTextItem* spice_text_item_new (SpiceCanvas* _canvas,
                                    JsonObject* _save_data);
VALA_EXTERN SpiceTextItem* spice_text_item_construct (GType object_type,
                                          SpiceCanvas* _canvas,
                                          JsonObject* _save_data);
static void __lambda67_ (SpiceTextItem* self);
static gboolean spice_text_item_get_editing (SpiceTextItem* self);
static gboolean ___lambda68_ (SpiceTextItem* self);
static gboolean ____lambda68__gsource_func (gpointer self);
static void spice_text_item_set_editing (SpiceTextItem* self,
                                  gboolean value);
static void ___lambda67__spice_canvas_item_clicked (SpiceCanvasItem* _sender,
                                             gpointer self);
static void __lambda69_ (SpiceTextItem* self);
VALA_EXTERN void spice_text_item_set_text (SpiceTextItem* self,
                               const gchar* value);
static void ___lambda69__spice_canvas_item_un_select (SpiceCanvasItem* _sender,
                                               gpointer self);
VALA_EXTERN void spice_canvas_item_load_data (SpiceCanvasItem* self);
static void __lambda70_ (SpiceTextItem* self);
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_item_changed (GType i_type,
                                                                                                          GBoxedCopyFunc i_dup_func,
                                                                                                          GDestroyNotify i_destroy_func,
                                                                                                          GType t_type,
                                                                                                          GBoxedCopyFunc t_dup_func,
                                                                                                          GDestroyNotify t_destroy_func,
                                                                                                          gconstpointer item,
                                                                                                          const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_item_changed (GType object_type,
                                                                                                                GType i_type,
                                                                                                                GBoxedCopyFunc i_dup_func,
                                                                                                                GDestroyNotify i_destroy_func,
                                                                                                                GType t_type,
                                                                                                                GBoxedCopyFunc t_dup_func,
                                                                                                                GDestroyNotify t_destroy_func,
                                                                                                                gconstpointer item,
                                                                                                                const gchar* property);
VALA_EXTERN SpiceCanvas* spice_canvas_item_get_canvas (SpiceCanvasItem* self);
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManager* spice_window_get_history_manager (SpiceWindow* self);
VALA_EXTERN void spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                         SpiceServicesHistoryManagerHistoryAction* action,
                                                         gboolean force_add);
static void ___lambda70__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static void ___lambda71_ (SpiceTextItem* self,
                   gdouble ratio);
static void ____lambda71__spice_canvas_ratio_changed (SpiceCanvas* _sender,
                                               gdouble ratio,
                                               gpointer self);
VALA_EXTERN void spice_text_item_resize_entry (SpiceTextItem* self);
static void spice_text_item_real_load_item_data (SpiceCanvasItem* base);
VALA_EXTERN JsonObject* spice_canvas_item_get_save_data (SpiceCanvasItem* self);
VALA_EXTERN void spice_text_item_set_font_size (SpiceTextItem* self,
                                    gint value);
VALA_EXTERN void spice_text_item_set_font (SpiceTextItem* self,
                               const gchar* value);
VALA_EXTERN void spice_text_item_set_font_style (SpiceTextItem* self,
                                     const gchar* value);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN void spice_text_item_set_justification (SpiceTextItem* self,
                                        gint value);
VALA_EXTERN void spice_text_item_set_align (SpiceTextItem* self,
                                gint value);
VALA_EXTERN void spice_text_item_set_font_color (SpiceTextItem* self,
                                     const gchar* value);
static gchar* spice_text_item_real_serialise_item (SpiceCanvasItem* base);
VALA_EXTERN const gchar* spice_text_item_get_font (SpiceTextItem* self);
VALA_EXTERN const gchar* spice_text_item_get_font_color (SpiceTextItem* self);
VALA_EXTERN gint spice_text_item_get_font_size (SpiceTextItem* self);
VALA_EXTERN const gchar* spice_text_item_get_font_style (SpiceTextItem* self);
VALA_EXTERN gint spice_text_item_get_justification (SpiceTextItem* self);
VALA_EXTERN gint spice_text_item_get_align (SpiceTextItem* self);
static void spice_text_item_real_style (SpiceCanvasItem* base);
VALA_EXTERN gdouble spice_canvas_get_current_ratio (SpiceCanvas* self);
static gchar* spice_text_item_get_font_css (SpiceTextItem* self,
                                     const gchar* font,
                                     const gchar* _font_style,
                                     gdouble font_size);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
VALA_EXTERN gchar* spice_text_item_get_text (SpiceTextItem* self);
static void spice_text_item_finalize (GObject * obj);
static GType spice_text_item_get_type_once (void);
static void _vala_spice_text_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_spice_text_item_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
spice_text_item_get_instance_private (SpiceTextItem* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceTextItem_private_offset);
}

static gboolean
___lambda68_ (SpiceTextItem* self)
{
	GtkTextView* _tmp0_;
	gboolean result;
#line 122 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 122 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, 0, 0);
#line 123 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = FALSE;
#line 123 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 340 "TextItem.c"
}

static gboolean
____lambda68__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda68_ ((SpiceTextItem*) self);
#line 121 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 350 "TextItem.c"
}

static void
__lambda67_ (SpiceTextItem* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 108 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = spice_text_item_get_editing (self);
#line 108 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = _tmp0_;
#line 108 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (!_tmp1_) {
#line 364 "TextItem.c"
		GtkTextView* _tmp2_;
		GtkTextBuffer* _tmp3_;
		GtkTextBuffer* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		GtkStack* _tmp12_;
		gint w = 0;
		GtkLabel* _tmp13_;
		gint h = 0;
		GtkLabel* _tmp14_;
		GtkTextView* _tmp15_;
		GtkTextView* _tmp16_;
#line 109 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->first_change_in_edit = TRUE;
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp2_ = self->entry;
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp3_ = gtk_text_view_get_buffer (_tmp2_);
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp4_ = _tmp3_;
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_get (_tmp4_, "text", &_tmp5_, NULL);
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp6_ = _tmp5_;
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp7_ = _tmp6_;
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp8_ = g_strcmp0 (_tmp7_, _ ("Click to add text...")) == 0;
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (_tmp7_);
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		if (_tmp8_) {
#line 399 "TextItem.c"
			GtkTextView* _tmp9_;
			GtkTextBuffer* _tmp10_;
			GtkTextBuffer* _tmp11_;
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp9_ = self->entry;
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp10_ = gtk_text_view_get_buffer (_tmp9_);
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp11_ = _tmp10_;
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			g_object_set (_tmp11_, "text", "", NULL);
#line 411 "TextItem.c"
		}
#line 114 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp12_ = self->priv->stack;
#line 114 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_stack_set_visible_child_name (_tmp12_, "entry");
#line 116 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp13_ = self->priv->label;
#line 116 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		w = gtk_widget_get_allocated_width ((GtkWidget*) _tmp13_);
#line 117 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp14_ = self->priv->label;
#line 117 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		h = gtk_widget_get_allocated_height ((GtkWidget*) _tmp14_);
#line 119 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp15_ = self->entry;
#line 119 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_widget_set_size_request ((GtkWidget*) _tmp15_, w, h);
#line 121 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 80, ____lambda68__gsource_func, g_object_ref (self), g_object_unref);
#line 126 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp16_ = self->entry;
#line 126 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_widget_queue_resize ((GtkWidget*) _tmp16_);
#line 127 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_editing (self, TRUE);
#line 437 "TextItem.c"
	}
}

static void
___lambda67__spice_canvas_item_clicked (SpiceCanvasItem* _sender,
                                        gpointer self)
{
#line 107 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	__lambda67_ ((SpiceTextItem*) self);
#line 447 "TextItem.c"
}

static void
__lambda69_ (SpiceTextItem* self)
{
	GtkTextView* _tmp0_;
	GtkTextView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkStack* _tmp7_;
#line 132 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_set_editing (self, FALSE);
#line 133 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 133 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_signal_emit_by_name (_tmp0_, "select-all", FALSE);
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = self->entry;
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = gtk_text_view_get_buffer (_tmp1_);
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp3_ = _tmp2_;
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_get (_tmp3_, "text", &_tmp4_, NULL);
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp5_ = _tmp4_;
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp6_ = _tmp5_;
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_set_text (self, _tmp6_);
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (_tmp6_);
#line 137 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp7_ = self->priv->stack;
#line 137 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_stack_set_visible_child_name (_tmp7_, "label");
#line 487 "TextItem.c"
}

static void
___lambda69__spice_canvas_item_un_select (SpiceCanvasItem* _sender,
                                          gpointer self)
{
#line 131 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	__lambda69_ ((SpiceTextItem*) self);
#line 496 "TextItem.c"
}

static void
__lambda70_ (SpiceTextItem* self)
{
#line 145 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (!self->setting_text) {
#line 504 "TextItem.c"
		SpiceServicesHistoryManagerHistoryAction* action = NULL;
		SpiceServicesHistoryManagerHistoryAction* _tmp0_;
		SpiceCanvas* _tmp1_;
		SpiceCanvas* _tmp2_;
		SpiceWindow* _tmp3_;
		SpiceServicesHistoryManager* _tmp4_;
		SpiceServicesHistoryManager* _tmp5_;
		SpiceServicesHistoryManagerHistoryAction* _tmp6_;
		GtkTextView* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 146 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp0_ = spice_services_history_manager_history_action_new_item_changed (SPICE_TYPE_TEXT_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SPICE_IS_TEXT_ITEM (self) ? ((SpiceTextItem*) self) : NULL, "text");
#line 146 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		action = _tmp0_;
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp1_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp2_ = _tmp1_;
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp3_ = _tmp2_->window;
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp4_ = spice_window_get_history_manager (_tmp3_);
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp5_ = _tmp4_;
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp6_ = action;
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_services_history_manager_add_undoable_action (_tmp5_, _tmp6_, self->first_change_in_edit);
#line 148 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->first_change_in_edit = FALSE;
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp7_ = self->entry;
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp8_ = gtk_text_view_get_buffer (_tmp7_);
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp9_ = _tmp8_;
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_get (_tmp9_, "text", &_tmp10_, NULL);
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp11_ = _tmp10_;
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (self->previous_text);
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->previous_text = _tmp11_;
#line 145 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_object_unref0 (action);
#line 554 "TextItem.c"
	}
}

static void
___lambda70__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	__lambda70_ ((SpiceTextItem*) self);
#line 564 "TextItem.c"
}

static void
___lambda71_ (SpiceTextItem* self,
              gdouble ratio)
{
#line 156 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_canvas_item_style ((SpiceCanvasItem*) self);
#line 573 "TextItem.c"
}

static void
____lambda71__spice_canvas_ratio_changed (SpiceCanvas* _sender,
                                          gdouble ratio,
                                          gpointer self)
{
#line 155 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	___lambda71_ ((SpiceTextItem*) self, ratio);
#line 583 "TextItem.c"
}

SpiceTextItem*
spice_text_item_construct (GType object_type,
                           SpiceCanvas* _canvas,
                           JsonObject* _save_data)
{
	SpiceTextItem * self = NULL;
	GtkTextView* _tmp0_;
	GtkTextView* _tmp1_;
	GtkTextView* _tmp2_;
	GtkTextView* _tmp3_;
	GtkTextView* _tmp4_;
	GtkTextView* _tmp5_;
	GtkTextView* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkStack* _tmp11_;
	GtkStack* _tmp12_;
	GtkStack* _tmp13_;
	GtkLabel* _tmp14_;
	GtkStack* _tmp15_;
	GtkTextView* _tmp16_;
	GtkStack* _tmp17_;
	GtkStack* _tmp18_;
	GtkGrid* _tmp19_;
	GtkTextView* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextBuffer* _tmp24_;
	SpiceCanvas* _tmp25_;
	SpiceCanvas* _tmp26_;
#line 80 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self = (SpiceTextItem*) g_object_new (object_type, "canvas", _canvas, "save-data", _save_data, NULL);
#line 82 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = (GtkTextView*) gtk_text_view_new ();
#line 82 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_ref_sink (_tmp0_);
#line 82 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_object_unref0 (self->entry);
#line 82 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->entry = _tmp0_;
#line 83 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = self->entry;
#line 83 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_text_view_set_justification (_tmp1_, GTK_JUSTIFY_CENTER);
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = self->entry;
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_text_view_set_wrap_mode (_tmp2_, GTK_WRAP_WORD_CHAR);
#line 85 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp3_ = self->entry;
#line 85 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
#line 86 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp4_ = self->entry;
#line 86 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_FILL);
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp5_ = self->entry;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp5_, TRUE);
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp6_ = self->entry;
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_set ((GtkWidget*) _tmp6_, "expand", TRUE, NULL);
#line 90 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("Click to add text..."));
#line 90 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_ref_sink (_tmp7_);
#line 90 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_object_unref0 (self->priv->label);
#line 90 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->label = _tmp7_;
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp8_ = self->priv->label;
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_set (_tmp8_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp9_ = self->priv->label;
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_set ((GtkWidget*) _tmp9_, "expand", TRUE, NULL);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp10_ = self->priv->label;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_set (_tmp10_, "wrap", TRUE, NULL);
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp11_ = (GtkStack*) gtk_stack_new ();
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_ref_sink (_tmp11_);
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_object_unref0 (self->priv->stack);
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->stack = _tmp11_;
#line 96 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp12_ = self->priv->stack;
#line 96 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_stack_set_homogeneous (_tmp12_, FALSE);
#line 98 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp13_ = self->priv->stack;
#line 98 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp14_ = self->priv->label;
#line 98 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_stack_add_named (_tmp13_, (GtkWidget*) _tmp14_, "label");
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp15_ = self->priv->stack;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp16_ = self->entry;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_stack_add_named (_tmp15_, (GtkWidget*) _tmp16_, "entry");
#line 100 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp17_ = self->priv->stack;
#line 100 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_stack_set_visible_child_name (_tmp17_, "label");
#line 101 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp18_ = self->priv->stack;
#line 101 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_set ((GtkWidget*) _tmp18_, "expand", TRUE, NULL);
#line 103 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp19_ = ((SpiceCanvasItem*) self)->grid;
#line 103 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (_tmp19_ != NULL) {
#line 707 "TextItem.c"
		GtkGrid* _tmp20_;
		GtkStack* _tmp21_;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp20_ = ((SpiceCanvasItem*) self)->grid;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp21_ = self->priv->stack;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 0, 1, 1);
#line 716 "TextItem.c"
	}
#line 107 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_signal_connect_object ((SpiceCanvasItem*) self, "clicked", (GCallback) ___lambda67__spice_canvas_item_clicked, self, 0);
#line 131 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_signal_connect_object ((SpiceCanvasItem*) self, "un-select", (GCallback) ___lambda69__spice_canvas_item_un_select, self, 0);
#line 140 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_set_editing (self, FALSE);
#line 142 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_canvas_item_load_data ((SpiceCanvasItem*) self);
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp22_ = self->entry;
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp23_ = gtk_text_view_get_buffer (_tmp22_);
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp24_ = _tmp23_;
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_signal_connect_object (_tmp24_, "changed", (GCallback) ___lambda70__gtk_text_buffer_changed, self, 0);
#line 154 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp25_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 154 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp26_ = _tmp25_;
#line 154 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (_tmp26_ != NULL) {
#line 740 "TextItem.c"
		SpiceCanvas* _tmp27_;
		SpiceCanvas* _tmp28_;
#line 155 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp27_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 155 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp28_ = _tmp27_;
#line 155 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_signal_connect_object (_tmp28_, "ratio-changed", (GCallback) ____lambda71__spice_canvas_ratio_changed, self, 0);
#line 159 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_canvas_item_style ((SpiceCanvasItem*) self);
#line 751 "TextItem.c"
	}
#line 79 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return self;
#line 755 "TextItem.c"
}

SpiceTextItem*
spice_text_item_new (SpiceCanvas* _canvas,
                     JsonObject* _save_data)
{
#line 79 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return spice_text_item_construct (SPICE_TYPE_TEXT_ITEM, _canvas, _save_data);
#line 764 "TextItem.c"
}

void
spice_text_item_resize_entry (SpiceTextItem* self)
{
	GtkTextView* _tmp0_;
#line 164 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 165 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 165 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_widget_queue_resize ((GtkWidget*) _tmp0_);
#line 777 "TextItem.c"
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	dup = g_new0 (gint64, 1);
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	memcpy (dup, self, sizeof (gint64));
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return dup;
#line 790 "TextItem.c"
}

static gpointer
__int64_dup0 (gpointer self)
{
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return self ? _int64_dup (self) : NULL;
#line 798 "TextItem.c"
}

static void
spice_text_item_real_load_item_data (SpiceCanvasItem* base)
{
	SpiceTextItem * self;
	gchar* text_data = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	const gchar* _tmp23_;
	JsonObject* _tmp24_;
	JsonObject* _tmp25_;
	JsonObject* _tmp31_;
	JsonObject* _tmp32_;
	JsonObject* _tmp38_;
	JsonObject* _tmp39_;
	JsonObject* _tmp42_;
	JsonObject* _tmp43_;
	const gchar* _tmp44_;
#line 168 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self = (SpiceTextItem*) base;
#line 169 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	text_data = NULL;
#line 170 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 170 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = _tmp0_;
#line 170 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (json_object_has_member (_tmp1_, "text-data")) {
#line 834 "TextItem.c"
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp2_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp3_ = _tmp2_;
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp4_ = json_object_get_string_member (_tmp3_, "text-data");
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (text_data);
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		text_data = _tmp5_;
#line 851 "TextItem.c"
	}
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp7_ = text_data;
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (_tmp7_ != NULL) {
#line 857 "TextItem.c"
		const gchar* _tmp8_;
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp8_ = text_data;
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
#line 863 "TextItem.c"
	} else {
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp6_ = FALSE;
#line 867 "TextItem.c"
	}
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (_tmp6_) {
#line 871 "TextItem.c"
		const gchar* _tmp9_;
		gsize _tmp10_ = 0;
		guchar* _tmp11_;
		gchar* _tmp12_;
#line 175 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp9_ = text_data;
#line 175 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp11_ = g_base64_decode (_tmp9_, &_tmp10_);
#line 175 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp12_ = (gchar*) _tmp11_;
#line 175 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_text (self, _tmp12_);
#line 175 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (_tmp12_);
#line 886 "TextItem.c"
	} else {
		gchar* text = NULL;
		JsonObject* _tmp13_;
		JsonObject* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
#line 177 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp13_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 177 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp14_ = _tmp13_;
#line 177 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp15_ = json_object_get_string_member (_tmp14_, "text");
#line 177 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 177 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		text = _tmp16_;
#line 178 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp17_ = text;
#line 178 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		if (_tmp17_ != NULL) {
#line 908 "TextItem.c"
			const gchar* _tmp18_;
#line 179 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp18_ = text;
#line 179 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			spice_text_item_set_text (self, _tmp18_);
#line 914 "TextItem.c"
		}
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (text);
#line 918 "TextItem.c"
	}
#line 183 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp19_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 183 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp20_ = _tmp19_;
#line 183 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_set_font_size (self, (gint) json_object_get_int_member (_tmp20_, "font-size"));
#line 184 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp21_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 184 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp22_ = _tmp21_;
#line 184 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp23_ = json_object_get_string_member (_tmp22_, "font");
#line 184 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_set_font (self, _tmp23_);
#line 186 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp24_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 186 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp25_ = _tmp24_;
#line 186 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (json_object_has_member (_tmp25_, "font-style")) {
#line 940 "TextItem.c"
		gchar* _font_style = NULL;
		JsonObject* _tmp26_;
		JsonObject* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
#line 187 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp26_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 187 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp27_ = _tmp26_;
#line 187 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp28_ = json_object_get_string_member (_tmp27_, "font-style");
#line 187 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp29_ = g_strdup (_tmp28_);
#line 187 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_font_style = _tmp29_;
#line 188 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp30_ = _font_style;
#line 188 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_font_style (self, _tmp30_);
#line 186 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (_font_style);
#line 963 "TextItem.c"
	}
#line 191 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp31_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 191 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp32_ = _tmp31_;
#line 191 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (json_object_has_member (_tmp32_, "justification")) {
#line 971 "TextItem.c"
		gint64* justify = NULL;
		JsonObject* _tmp33_;
		JsonObject* _tmp34_;
		gint64 _tmp35_;
		gint64* _tmp36_;
		gint64* _tmp37_;
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp33_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp34_ = _tmp33_;
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp35_ = json_object_get_int_member (_tmp34_, "justification");
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp36_ = __int64_dup0 (&_tmp35_);
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		justify = _tmp36_;
#line 193 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp37_ = justify;
#line 193 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_justification (self, (gint) (*_tmp37_));
#line 191 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (justify);
#line 994 "TextItem.c"
	}
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp38_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp39_ = _tmp38_;
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (json_object_has_member (_tmp39_, "align")) {
#line 1002 "TextItem.c"
		JsonObject* _tmp40_;
		JsonObject* _tmp41_;
#line 197 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp40_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 197 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp41_ = _tmp40_;
#line 197 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_align (self, (gint) json_object_get_int_member (_tmp41_, "align"));
#line 1011 "TextItem.c"
	}
#line 200 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp42_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 200 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp43_ = _tmp42_;
#line 200 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp44_ = json_object_get_string_member (_tmp43_, "color");
#line 200 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_set_font_color (self, _tmp44_);
#line 168 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (text_data);
#line 1023 "TextItem.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 1060 "TextItem.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 1066 "TextItem.c"
}

static gchar*
spice_text_item_real_serialise_item (SpiceCanvasItem* base)
{
	SpiceTextItem * self;
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
#line 203 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self = (SpiceTextItem*) base;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = _tmp1_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp4_ = _tmp3_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp5_ = _tmp4_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp6_ = string_get_data (_tmp5_, &_tmp7_);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp6__length1 = _tmp7_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp8_ = _tmp6_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp8__length1 = _tmp6__length1;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp9_ = g_base64_encode (_tmp8_, (gint) _tmp8__length1);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp10_ = _tmp9_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp11_ = self->priv->_font;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp12_ = self->priv->_font_color;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp13_ = self->priv->_font_size;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp14_ = self->priv->_font_style;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp15_ = self->priv->_justification;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp16_ = self->priv->_align;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp17_ = g_strdup_printf ("\"type\":\"text\",\"text\": \"\",\"text-data\": \"%s\",\"font\": \"%s\"" \
",\"color\": \"%s\",\"font-size\": %d, \"font-style\":\"%s\", \"justifi" \
"cation\": %d, \"align\": %d ", _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp18_ = _tmp17_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (_tmp10_);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (_tmp5_);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp18_;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1145 "TextItem.c"
}

static void
spice_text_item_real_style (SpiceCanvasItem* base)
{
	SpiceTextItem * self;
	gdouble converted_font_size = 0.0;
	SpiceCanvas* _tmp0_;
	SpiceCanvas* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint _tmp17_;
	gint _tmp34_;
#line 207 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self = (SpiceTextItem*) base;
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = _tmp0_;
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = spice_canvas_get_current_ratio (_tmp1_);
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp3_ = _tmp2_;
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp4_ = self->priv->_font_size;
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	converted_font_size = (5.3 * _tmp3_) * _tmp4_;
#line 210 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (converted_font_size > ((gdouble) 0)) {
#line 1176 "TextItem.c"
		gchar* font_css = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* css = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		GtkTextView* _tmp15_;
		const gchar* _tmp16_;
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp5_ = self->priv->_font;
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp6_ = self->priv->_font_style;
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp8_ = _tmp7_;
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp9_ = spice_text_item_get_font_css (self, _tmp5_, _tmp8_, converted_font_size);
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp10_ = _tmp9_;
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (_tmp8_);
#line 211 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		font_css = _tmp10_;
#line 212 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp11_ = self->priv->_font_color;
#line 212 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp12_ = font_css;
#line 212 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp13_ = g_strdup_printf (SPICE_TEXT_ITEM_TEXT_STYLE_CSS, _tmp11_, _tmp12_);
#line 212 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		css = _tmp13_;
#line 213 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp14_ = css;
#line 213 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_utils_set_style ((GtkWidget*) self, _tmp14_);
#line 214 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp15_ = self->entry;
#line 214 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp16_ = css;
#line 214 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_utils_set_style ((GtkWidget*) _tmp15_, _tmp16_);
#line 210 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (css);
#line 210 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (font_css);
#line 1229 "TextItem.c"
	}
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp17_ = self->priv->_justification;
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	switch (_tmp17_) {
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 0:
#line 1237 "TextItem.c"
		{
			GtkTextView* _tmp18_;
			GtkLabel* _tmp19_;
			GtkLabel* _tmp20_;
			GtkLabel* _tmp21_;
#line 219 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp18_ = self->entry;
#line 219 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_text_view_set_justification (_tmp18_, GTK_JUSTIFY_LEFT);
#line 220 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp19_ = self->priv->label;
#line 220 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_justify (_tmp19_, GTK_JUSTIFY_LEFT);
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp20_ = self->priv->label;
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_START);
#line 222 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp21_ = self->priv->label;
#line 222 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_xalign (_tmp21_, 0.0f);
#line 223 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1261 "TextItem.c"
		}
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 1:
#line 1265 "TextItem.c"
		{
			GtkTextView* _tmp22_;
			GtkLabel* _tmp23_;
			GtkLabel* _tmp24_;
			GtkLabel* _tmp25_;
#line 225 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp22_ = self->entry;
#line 225 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_text_view_set_justification (_tmp22_, GTK_JUSTIFY_CENTER);
#line 226 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp23_ = self->priv->label;
#line 226 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_justify (_tmp23_, GTK_JUSTIFY_CENTER);
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp24_ = self->priv->label;
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
#line 228 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp25_ = self->priv->label;
#line 228 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_xalign (_tmp25_, 0.5f);
#line 229 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1289 "TextItem.c"
		}
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 2:
#line 1293 "TextItem.c"
		{
			GtkTextView* _tmp26_;
			GtkLabel* _tmp27_;
			GtkLabel* _tmp28_;
			GtkLabel* _tmp29_;
#line 231 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp26_ = self->entry;
#line 231 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_text_view_set_justification (_tmp26_, GTK_JUSTIFY_RIGHT);
#line 232 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp27_ = self->priv->label;
#line 232 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_justify (_tmp27_, GTK_JUSTIFY_RIGHT);
#line 233 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp28_ = self->priv->label;
#line 233 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_END);
#line 234 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp29_ = self->priv->label;
#line 234 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_xalign (_tmp29_, 1.0f);
#line 235 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1317 "TextItem.c"
		}
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 3:
#line 1321 "TextItem.c"
		{
			GtkTextView* _tmp30_;
			GtkLabel* _tmp31_;
			GtkLabel* _tmp32_;
			GtkLabel* _tmp33_;
#line 237 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp30_ = self->entry;
#line 237 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_text_view_set_justification (_tmp30_, GTK_JUSTIFY_FILL);
#line 238 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp31_ = self->priv->label;
#line 238 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_justify (_tmp31_, GTK_JUSTIFY_FILL);
#line 239 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp32_ = self->priv->label;
#line 239 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_FILL);
#line 240 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp33_ = self->priv->label;
#line 240 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_label_set_xalign (_tmp33_, 0.0f);
#line 241 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1345 "TextItem.c"
		}
		default:
#line 217 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 1350 "TextItem.c"
	}
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp34_ = self->priv->_align;
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	switch (_tmp34_) {
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 0:
#line 1358 "TextItem.c"
		{
			GtkTextView* _tmp35_;
			GtkLabel* _tmp36_;
#line 246 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp35_ = self->entry;
#line 246 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp35_, GTK_ALIGN_START);
#line 247 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp36_ = self->priv->label;
#line 247 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp36_, GTK_ALIGN_START);
#line 248 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1372 "TextItem.c"
		}
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 1:
#line 1376 "TextItem.c"
		{
			GtkTextView* _tmp37_;
			GtkLabel* _tmp38_;
#line 250 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp37_ = self->entry;
#line 250 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp37_, GTK_ALIGN_CENTER);
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp38_ = self->priv->label;
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp38_, GTK_ALIGN_CENTER);
#line 252 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1390 "TextItem.c"
		}
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case 2:
#line 1394 "TextItem.c"
		{
			GtkTextView* _tmp39_;
			GtkLabel* _tmp40_;
#line 254 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp39_ = self->entry;
#line 254 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp39_, GTK_ALIGN_END);
#line 255 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			_tmp40_ = self->priv->label;
#line 255 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp40_, GTK_ALIGN_END);
#line 256 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
			break;
#line 1408 "TextItem.c"
		}
		default:
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 1413 "TextItem.c"
	}
#line 259 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_resize_entry (self);
#line 1417 "TextItem.c"
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 997 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 997 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 997 "glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 997 "glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
#line 997 "glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 997 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 997 "glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 997 "glib-2.0.vapi"
	result = _tmp4_;
#line 997 "glib-2.0.vapi"
	return result;
#line 1448 "TextItem.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1470 "TextItem.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1474 "TextItem.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1480 "TextItem.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1484 "TextItem.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1488 "TextItem.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1496 "TextItem.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1524 "TextItem.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1533 "TextItem.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1547 "TextItem.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1556 "TextItem.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1570 "TextItem.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1579 "TextItem.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1588 "TextItem.c"
}

static gchar*
spice_text_item_get_font_css (SpiceTextItem* self,
                              const gchar* font,
                              const gchar* _font_style,
                              gdouble font_size)
{
	gchar* font_size_text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* font_style = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
#line 262 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 262 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (font != NULL, NULL);
#line 262 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (_font_style != NULL, NULL);
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = double_to_string (font_size);
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = _tmp0_;
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = string_replace (_tmp1_, ",", ".");
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp3_ = _tmp2_;
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (_tmp1_);
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_size_text = _tmp3_;
#line 265 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp4_ = string_replace (_font_style, "black", "900");
#line 265 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp4_;
#line 266 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp5_ = font_style;
#line 266 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp6_ = string_replace (_tmp5_, "extrabold", "800");
#line 266 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 266 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp6_;
#line 267 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp7_ = font_style;
#line 267 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp8_ = string_replace (_tmp7_, "semibold", "600");
#line 267 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 267 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp8_;
#line 268 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp9_ = font_style;
#line 268 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp10_ = string_replace (_tmp9_, "bold", "700");
#line 268 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 268 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp10_;
#line 269 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp11_ = font_style;
#line 269 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp12_ = string_replace (_tmp11_, "medium", "500");
#line 269 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 269 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp12_;
#line 270 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp13_ = font_style;
#line 270 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp14_ = string_replace (_tmp13_, "regular", "400");
#line 270 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 270 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp14_;
#line 271 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp15_ = font_style;
#line 271 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp16_ = string_replace (_tmp15_, "extralight", "300");
#line 271 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 271 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp16_;
#line 272 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp17_ = font_style;
#line 272 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp18_ = string_replace (_tmp17_, "light", "200");
#line 272 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 272 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp18_;
#line 273 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp19_ = font_style;
#line 273 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp20_ = string_replace (_tmp19_, "thin", "100");
#line 273 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 273 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	font_style = _tmp20_;
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp21_ = font_style;
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp22_ = g_strdup_printf ("%s %spx '%s'", _tmp21_, font_size_text, font);
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp22_;
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_style);
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (font_size_text);
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1721 "TextItem.c"
}

gint
spice_text_item_get_justification (SpiceTextItem* self)
{
	gint result;
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = self->priv->_justification;
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1734 "TextItem.c"
}

void
spice_text_item_set_justification (SpiceTextItem* self,
                                   gint value)
{
	gint old_value;
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	old_value = spice_text_item_get_justification (self);
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (old_value != value) {
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->priv->_justification = value;
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_JUSTIFICATION_PROPERTY]);
#line 1752 "TextItem.c"
	}
}

gint
spice_text_item_get_align (SpiceTextItem* self)
{
	gint result;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = self->priv->_align;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1766 "TextItem.c"
}

void
spice_text_item_set_align (SpiceTextItem* self,
                           gint value)
{
	gint old_value;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	old_value = spice_text_item_get_align (self);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (old_value != value) {
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->priv->_align = value;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_ALIGN_PROPERTY]);
#line 1784 "TextItem.c"
	}
}

gint
spice_text_item_get_font_size (SpiceTextItem* self)
{
	gint result;
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = self->priv->_font_size;
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1798 "TextItem.c"
}

void
spice_text_item_set_font_size (SpiceTextItem* self,
                               gint value)
{
	gint old_value;
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	old_value = spice_text_item_get_font_size (self);
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (old_value != value) {
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->priv->_font_size = value;
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_SIZE_PROPERTY]);
#line 1816 "TextItem.c"
	}
}

const gchar*
spice_text_item_get_font (SpiceTextItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->priv->_font;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1833 "TextItem.c"
}

void
spice_text_item_set_font (SpiceTextItem* self,
                          const gchar* value)
{
	gchar* old_value;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	old_value = spice_text_item_get_font (self);
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1847 "TextItem.c"
		gchar* _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp0_ = g_strdup (value);
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (self->priv->_font);
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->priv->_font = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_PROPERTY]);
#line 1857 "TextItem.c"
	}
}

const gchar*
spice_text_item_get_font_color (SpiceTextItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->priv->_font_color;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1874 "TextItem.c"
}

void
spice_text_item_set_font_color (SpiceTextItem* self,
                                const gchar* value)
{
	gchar* old_value;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	old_value = spice_text_item_get_font_color (self);
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1888 "TextItem.c"
		gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp0_ = g_strdup (value);
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (self->priv->_font_color);
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->priv->_font_color = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_COLOR_PROPERTY]);
#line 1898 "TextItem.c"
	}
}

const gchar*
spice_text_item_get_font_style (SpiceTextItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->priv->_font_style;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp0_;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1915 "TextItem.c"
}

void
spice_text_item_set_font_style (SpiceTextItem* self,
                                const gchar* value)
{
	gchar* old_value;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	old_value = spice_text_item_get_font_style (self);
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1929 "TextItem.c"
		gchar* _tmp0_;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp0_ = g_strdup (value);
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_g_free0 (self->priv->_font_style);
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		self->priv->_font_style = _tmp0_;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_STYLE_PROPERTY]);
#line 1939 "TextItem.c"
	}
}

gchar*
spice_text_item_get_text (SpiceTextItem* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 38 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->previous_text;
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp1_;
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 1959 "TextItem.c"
}

void
spice_text_item_set_text (SpiceTextItem* self,
                          const gchar* value)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 41 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->setting_text = TRUE;
#line 42 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 42 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
#line 42 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = _tmp1_;
#line 42 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_set (_tmp2_, "text", value, NULL);
#line 44 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (g_strcmp0 (value, "") == 0) {
#line 1987 "TextItem.c"
		GtkLabel* _tmp3_;
#line 45 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp3_ = self->priv->label;
#line 45 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_label_set_label (_tmp3_, _ ("Click to add text..."));
#line 1993 "TextItem.c"
	} else {
		GtkLabel* _tmp4_;
#line 47 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp4_ = self->priv->label;
#line 47 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_label_set_label (_tmp4_, value);
#line 2000 "TextItem.c"
	}
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp5_ = self->priv->label;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp6_ = gtk_label_get_label (_tmp5_);
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp7_ = _tmp6_;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (self->previous_text);
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->previous_text = _tmp8_;
#line 51 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->setting_text = FALSE;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_text_item_properties[SPICE_TEXT_ITEM_TEXT_PROPERTY]);
#line 2018 "TextItem.c"
}

static gboolean
spice_text_item_get_editing (SpiceTextItem* self)
{
	gboolean result;
	GtkTextView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 58 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = gtk_text_view_get_editable (_tmp0_);
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = _tmp1_;
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	result = _tmp2_;
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	return result;
#line 2040 "TextItem.c"
}

static void
spice_text_item_set_editing (SpiceTextItem* self,
                             gboolean value)
{
	GtkTextView* _tmp0_;
	GtkTextView* _tmp1_;
#line 60 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_return_if_fail (self != NULL);
#line 61 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = self->entry;
#line 61 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_text_view_set_editable (_tmp0_, value);
#line 62 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = self->entry;
#line 62 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	gtk_text_view_set_cursor_visible (_tmp1_, value);
#line 64 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	if (value) {
#line 2061 "TextItem.c"
		GtkTextView* _tmp2_;
#line 65 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		_tmp2_ = self->entry;
#line 65 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
#line 2067 "TextItem.c"
	}
}

static void
spice_text_item_class_init (SpiceTextItemClass * klass,
                            gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	spice_text_item_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_type_class_adjust_private_offset (klass, &SpiceTextItem_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	((SpiceCanvasItemClass *) klass)->load_item_data = (void (*) (SpiceCanvasItem*)) spice_text_item_real_load_item_data;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	((SpiceCanvasItemClass *) klass)->serialise_item = (gchar* (*) (SpiceCanvasItem*)) spice_text_item_real_serialise_item;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	((SpiceCanvasItemClass *) klass)->style = (void (*) (SpiceCanvasItem*)) spice_text_item_real_style;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_text_item_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_text_item_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_text_item_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_JUSTIFICATION_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_JUSTIFICATION_PROPERTY] = g_param_spec_int ("justification", "justification", "justification", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_ALIGN_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_ALIGN_PROPERTY] = g_param_spec_int ("align", "align", "align", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_FONT_SIZE_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_SIZE_PROPERTY] = g_param_spec_int ("font-size", "font-size", "font-size", G_MININT, G_MAXINT, 16, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_FONT_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_PROPERTY] = g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_FONT_COLOR_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_COLOR_PROPERTY] = g_param_spec_string ("font-color", "font-color", "font-color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_FONT_STYLE_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_FONT_STYLE_PROPERTY] = g_param_spec_string ("font-style", "font-style", "font-style", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_TEXT_ITEM_TEXT_PROPERTY, spice_text_item_properties[SPICE_TEXT_ITEM_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2105 "TextItem.c"
}

static void
spice_text_item_instance_init (SpiceTextItem * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv = spice_text_item_get_instance_private (self);
#line 27 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->_justification = 1;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->_align = 1;
#line 29 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->_font_size = 16;
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp0_ = g_strdup ("Open Sans");
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->_font = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp1_ = g_strdup ("#fff");
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->_font_color = _tmp1_;
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp2_ = g_strdup ("Regular");
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->priv->_font_style = _tmp2_;
#line 34 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->setting_text = FALSE;
#line 35 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->first_change_in_edit = FALSE;
#line 36 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_tmp3_ = g_strdup ("");
#line 36 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->previous_text = _tmp3_;
#line 55 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self->underlined = FALSE;
#line 2146 "TextItem.c"
}

static void
spice_text_item_finalize (GObject * obj)
{
	SpiceTextItem * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_TEXT_ITEM, SpiceTextItem);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_object_unref0 (self->entry);
#line 24 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_object_unref0 (self->priv->label);
#line 25 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_object_unref0 (self->priv->stack);
#line 30 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (self->priv->_font);
#line 31 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (self->priv->_font_color);
#line 32 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (self->priv->_font_style);
#line 36 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	_g_free0 (self->previous_text);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	G_OBJECT_CLASS (spice_text_item_parent_class)->finalize (obj);
#line 2171 "TextItem.c"
}

static GType
spice_text_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceTextItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_text_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceTextItem), 0, (GInstanceInitFunc) spice_text_item_instance_init, NULL };
	GType spice_text_item_type_id;
	spice_text_item_type_id = g_type_register_static (SPICE_TYPE_CANVAS_ITEM, "SpiceTextItem", &g_define_type_info, 0);
	SpiceTextItem_private_offset = g_type_add_instance_private (spice_text_item_type_id, sizeof (SpiceTextItemPrivate));
	return spice_text_item_type_id;
}

GType
spice_text_item_get_type (void)
{
	static volatile gsize spice_text_item_type_id__once = 0;
	if (g_once_init_enter (&spice_text_item_type_id__once)) {
		GType spice_text_item_type_id;
		spice_text_item_type_id = spice_text_item_get_type_once ();
		g_once_init_leave (&spice_text_item_type_id__once, spice_text_item_type_id);
	}
	return spice_text_item_type_id__once;
}

static void
_vala_spice_text_item_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	SpiceTextItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_TEXT_ITEM, SpiceTextItem);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_JUSTIFICATION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_set_int (value, spice_text_item_get_justification (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_ALIGN_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_set_int (value, spice_text_item_get_align (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_SIZE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_set_int (value, spice_text_item_get_font_size (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_set_string (value, spice_text_item_get_font (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_set_string (value, spice_text_item_get_font_color (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_STYLE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_set_string (value, spice_text_item_get_font_style (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_TEXT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		g_value_take_string (value, spice_text_item_get_text (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 2248 "TextItem.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 2254 "TextItem.c"
	}
}

static void
_vala_spice_text_item_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	SpiceTextItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_TEXT_ITEM, SpiceTextItem);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_JUSTIFICATION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_justification (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_ALIGN_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_align (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_SIZE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_font_size (self, g_value_get_int (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_font (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_COLOR_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_font_color (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_FONT_STYLE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_font_style (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		case SPICE_TEXT_ITEM_TEXT_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		spice_text_item_set_text (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 2310 "TextItem.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/TextItem.vala"
		break;
#line 2316 "TextItem.c"
	}
}

