/* page-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_PAGE_VIEW_TEXTURE (page_view_texture_get_type ())
#define PAGE_VIEW_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW_TEXTURE, PageViewTexture))
#define PAGE_VIEW_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW_TEXTURE, PageViewTextureClass))
#define IS_PAGE_VIEW_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW_TEXTURE))
#define IS_PAGE_VIEW_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW_TEXTURE))
#define PAGE_VIEW_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW_TEXTURE, PageViewTextureClass))

typedef struct _PageViewTexture PageViewTexture;
typedef struct _PageViewTextureClass PageViewTextureClass;
enum  {
	PAGE_VIEW_0_PROPERTY,
	PAGE_VIEW_PAGE_PROPERTY,
	PAGE_VIEW_SELECTED_PROPERTY,
	PAGE_VIEW_X_OFFSET_PROPERTY,
	PAGE_VIEW_Y_OFFSET_PROPERTY,
	PAGE_VIEW_CURSOR_PROPERTY,
	PAGE_VIEW_WIDTH_PROPERTY,
	PAGE_VIEW_HEIGHT_PROPERTY,
	PAGE_VIEW_NUM_PROPERTIES
};
static GParamSpec* page_view_properties[PAGE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
enum  {
	PAGE_VIEW_SIZE_CHANGED_SIGNAL,
	PAGE_VIEW_CHANGED_SIGNAL,
	PAGE_VIEW_NUM_SIGNALS
};
static guint page_view_signals[PAGE_VIEW_NUM_SIGNALS] = {0};

struct _PageView {
	GObject parent_instance;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GObjectClass parent_class;
};

struct _PageViewPrivate {
	Page* _page;
	PageViewTexture* page_texture;
	gboolean selected_;
	gint ruler_width;
	gint border_width;
	gboolean update_image;
	gint width_;
	gint height_;
	gint _x_offset;
	gint _y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	gchar* _cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

static gint PageView_private_offset;
static gpointer page_view_parent_class = NULL;

VALA_EXTERN GType crop_location_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType page_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageView, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType page_view_texture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageViewTexture, g_object_unref)
VALA_EXTERN Page* page_view_get_page (PageView* self);
static void page_view_page_pixels_changed_cb (PageView* self,
                                       Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender,
                                                            gpointer self);
static void page_view_page_size_changed_cb (PageView* self,
                                     Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender,
                                                        gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self,
                                        Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender,
                                                           gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender,
                                                                gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self,
                                          Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender,
                                                                       gpointer self);
static void page_view_new_buffer_cb (PageView* self);
static void _page_view_new_buffer_cb_page_view_texture_new_buffer (PageViewTexture* _sender,
                                                            gpointer self);
VALA_EXTERN PageView* page_view_new (Page* page);
VALA_EXTERN PageView* page_view_construct (GType object_type,
                               Page* page);
static void page_view_set_page (PageView* self,
                         Page* value);
VALA_EXTERN PageViewTexture* page_view_texture_new (Page* page);
VALA_EXTERN PageViewTexture* page_view_texture_construct (GType object_type,
                                              Page* page);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static gint page_view_page_to_screen_x (PageView* self,
                                 gint x);
VALA_EXTERN gint page_get_width (Page* self);
static gint page_view_page_to_screen_y (PageView* self,
                                 gint y);
VALA_EXTERN gint page_get_height (Page* self);
static gint page_view_screen_to_page_x (PageView* self,
                                 gint x);
static gint page_view_screen_to_page_y (PageView* self,
                                 gint y);
static CropLocation page_view_get_crop_location (PageView* self,
                                          gint x,
                                          gint y);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
VALA_EXTERN gint page_get_crop_x (Page* self);
VALA_EXTERN gint page_get_crop_y (Page* self);
VALA_EXTERN gint page_get_crop_width (Page* self);
VALA_EXTERN gint page_get_crop_height (Page* self);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
VALA_EXTERN void page_view_button_press (PageView* self,
                             gint x,
                             gint y);
VALA_EXTERN void page_view_motion (PageView* self,
                       gint x,
                       gint y);
static void page_view_set_cursor (PageView* self,
                           const gchar* value);
VALA_EXTERN void page_move_crop (Page* self,
                     gint x,
                     gint y);
VALA_EXTERN void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
VALA_EXTERN void page_view_button_release (PageView* self,
                               gint x,
                               gint y);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
VALA_EXTERN gboolean page_get_is_scanning (Page* self);
VALA_EXTERN gboolean page_get_has_data (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
VALA_EXTERN void page_view_render (PageView* self,
                       cairo_t* context,
                       GdkRGBA* ruler_color);
VALA_EXTERN void page_view_texture_request_resize (PageViewTexture* self,
                                       gint width,
                                       gint height);
VALA_EXTERN void page_view_texture_queue_update (PageViewTexture* self,
                                     GError** error);
VALA_EXTERN gint page_view_get_x_offset (PageView* self);
VALA_EXTERN gint page_view_get_y_offset (PageView* self);
VALA_EXTERN GdkPixbuf* page_view_texture_get_pixbuf (PageViewTexture* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN gint page_get_scan_line (Page* self);
VALA_EXTERN GType scan_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ScanDirection page_get_scan_direction (Page* self);
VALA_EXTERN void page_view_texture_request_update (PageViewTexture* self);
VALA_EXTERN gboolean page_view_get_selected (PageView* self);
VALA_EXTERN void page_view_set_selected (PageView* self,
                             gboolean value);
VALA_EXTERN void page_view_set_x_offset (PageView* self,
                             gint value);
VALA_EXTERN void page_view_set_y_offset (PageView* self,
                             gint value);
VALA_EXTERN const gchar* page_view_get_cursor (PageView* self);
VALA_EXTERN gint page_view_get_width (PageView* self);
VALA_EXTERN void page_view_set_width (PageView* self,
                          gint value);
VALA_EXTERN gint page_view_get_height (PageView* self);
VALA_EXTERN void page_view_set_height (PageView* self,
                           gint value);
static void page_view_finalize (GObject * obj);
static GType page_view_get_type_once (void);
static void _vala_page_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_page_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
crop_location_get_type_once (void)
{
	static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
	GType crop_location_type_id;
	crop_location_type_id = g_enum_register_static ("CropLocation", values);
	return crop_location_type_id;
}

GType
crop_location_get_type (void)
{
	static volatile gsize crop_location_type_id__once = 0;
	if (g_once_init_enter (&crop_location_type_id__once)) {
		GType crop_location_type_id;
		crop_location_type_id = crop_location_get_type_once ();
		g_once_init_leave (&crop_location_type_id__once, crop_location_type_id);
	}
	return crop_location_type_id__once;
}

static inline gpointer
page_view_get_instance_private (PageView* self)
{
	return G_STRUCT_MEMBER_P (self, PageView_private_offset);
}

static void
_page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender,
                                                       gpointer self)
{
	page_view_page_pixels_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_page_size_changed_cb_page_size_changed (Page* _sender,
                                                   gpointer self)
{
	page_view_page_size_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender,
                                                      gpointer self)
{
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender,
                                                           gpointer self)
{
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender,
                                                                  gpointer self)
{
	page_view_scan_direction_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_new_buffer_cb_page_view_texture_new_buffer (PageViewTexture* _sender,
                                                       gpointer self)
{
	page_view_new_buffer_cb ((PageView*) self);
}

PageView*
page_view_construct (GType object_type,
                     Page* page)
{
	PageView * self = NULL;
	PageViewTexture* _tmp0_;
	PageViewTexture* _tmp1_;
	g_return_val_if_fail (page != NULL, NULL);
	self = (PageView*) g_object_new (object_type, NULL);
	page_view_set_page (self, page);
	g_signal_connect_object (page, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self, 0);
	g_signal_connect_object (page, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self, 0);
	g_signal_connect_object (page, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self, 0);
	g_signal_connect_object (page, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self, 0);
	g_signal_connect_object (page, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self, 0);
	_tmp0_ = page_view_texture_new (page);
	_g_object_unref0 (self->priv->page_texture);
	self->priv->page_texture = _tmp0_;
	_tmp1_ = self->priv->page_texture;
	g_signal_connect_object (_tmp1_, "new-buffer", (GCallback) _page_view_new_buffer_cb_page_view_texture_new_buffer, self, 0);
	return self;
}

PageView*
page_view_new (Page* page)
{
	return page_view_construct (TYPE_PAGE_VIEW, page);
}

static void
page_view_new_buffer_cb (PageView* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static gint
page_view_get_preview_width (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->width_ - ((self->priv->border_width + self->priv->ruler_width) * 2);
	return result;
}

static gint
page_view_get_preview_height (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->height_ - ((self->priv->border_width + self->priv->ruler_width) * 2);
	return result;
}

static gint
page_view_page_to_screen_x (PageView* self,
                            gint x)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) x) * page_view_get_preview_width (self)) / _tmp2_) + 0.5);
	return result;
}

static gint
page_view_page_to_screen_y (PageView* self,
                            gint y)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) y) * page_view_get_preview_height (self)) / _tmp2_) + 0.5);
	return result;
}

static gint
page_view_screen_to_page_x (PageView* self,
                            gint x)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) x) * _tmp2_) / page_view_get_preview_width (self)) + 0.5);
	return result;
}

static gint
page_view_screen_to_page_y (PageView* self,
                            gint y)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) y) * _tmp2_) / page_view_get_preview_height (self)) + 0.5);
	return result;
}

static CropLocation
page_view_get_crop_location (PageView* self,
                             gint x,
                             gint y)
{
	Page* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint cx = 0;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cy = 0;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint cw = 0;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint ch = 0;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint dx = 0;
	gint dy = 0;
	gint dw = 0;
	gint dh = 0;
	gint ix = 0;
	gint iy = 0;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gchar* name = NULL;
	Page* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gint crop_border = 0;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	CropLocation result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_has_crop (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		result = CROP_LOCATION_NONE;
		return result;
	}
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_crop_x (_tmp3_);
	_tmp5_ = _tmp4_;
	cx = _tmp5_;
	_tmp6_ = self->priv->_page;
	_tmp7_ = page_get_crop_y (_tmp6_);
	_tmp8_ = _tmp7_;
	cy = _tmp8_;
	_tmp9_ = self->priv->_page;
	_tmp10_ = page_get_crop_width (_tmp9_);
	_tmp11_ = _tmp10_;
	cw = _tmp11_;
	_tmp12_ = self->priv->_page;
	_tmp13_ = page_get_crop_height (_tmp12_);
	_tmp14_ = _tmp13_;
	ch = _tmp14_;
	dx = (page_view_page_to_screen_x (self, cx) + self->priv->border_width) + self->priv->ruler_width;
	dy = (page_view_page_to_screen_y (self, cy) + self->priv->border_width) + self->priv->ruler_width;
	dw = (page_view_page_to_screen_x (self, cw) + self->priv->border_width) + self->priv->ruler_width;
	dh = (page_view_page_to_screen_y (self, ch) + self->priv->border_width) + self->priv->ruler_width;
	ix = x - dx;
	iy = y - dy;
	if (ix < 0) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = ix > dw;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = iy < 0;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = iy > dh;
	}
	if (_tmp15_) {
		result = CROP_LOCATION_NONE;
		return result;
	}
	_tmp18_ = self->priv->_page;
	_tmp19_ = page_get_crop_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup (_tmp20_);
	name = _tmp21_;
	_tmp22_ = name;
	if (_tmp22_ != NULL) {
		result = CROP_LOCATION_MIDDLE;
		_g_free0 (name);
		return result;
	}
	crop_border = 20;
	if (dw < (crop_border * 3)) {
		crop_border = dw / 3;
	}
	if (dh < (crop_border * 3)) {
		crop_border = dh / 3;
	}
	if (ix < crop_border) {
		_tmp23_ = iy < crop_border;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		result = CROP_LOCATION_TOP_LEFT;
		_g_free0 (name);
		return result;
	}
	if (ix > (dw - crop_border)) {
		_tmp24_ = iy < crop_border;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = CROP_LOCATION_TOP_RIGHT;
		_g_free0 (name);
		return result;
	}
	if (ix < crop_border) {
		_tmp25_ = iy > (dh - crop_border);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		result = CROP_LOCATION_BOTTOM_LEFT;
		_g_free0 (name);
		return result;
	}
	if (ix > (dw - crop_border)) {
		_tmp26_ = iy > (dh - crop_border);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		result = CROP_LOCATION_BOTTOM_RIGHT;
		_g_free0 (name);
		return result;
	}
	if (ix < crop_border) {
		result = CROP_LOCATION_LEFT;
		_g_free0 (name);
		return result;
	}
	if (ix > (dw - crop_border)) {
		result = CROP_LOCATION_RIGHT;
		_g_free0 (name);
		return result;
	}
	if (iy < crop_border) {
		result = CROP_LOCATION_TOP;
		_g_free0 (name);
		return result;
	}
	if (iy > (dh - crop_border)) {
		result = CROP_LOCATION_BOTTOM;
		_g_free0 (name);
		return result;
	}
	result = CROP_LOCATION_MIDDLE;
	_g_free0 (name);
	return result;
}

void
page_view_button_press (PageView* self,
                        gint x,
                        gint y)
{
	CropLocation location = 0;
	g_return_if_fail (self != NULL);
	location = page_view_get_crop_location (self, x, y);
	if (location != CROP_LOCATION_NONE) {
		Page* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		Page* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		Page* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		Page* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		self->priv->crop_location = location;
		self->priv->selected_crop_px = (gdouble) x;
		self->priv->selected_crop_py = (gdouble) y;
		_tmp0_ = self->priv->_page;
		_tmp1_ = page_get_crop_x (_tmp0_);
		_tmp2_ = _tmp1_;
		self->priv->selected_crop_x = _tmp2_;
		_tmp3_ = self->priv->_page;
		_tmp4_ = page_get_crop_y (_tmp3_);
		_tmp5_ = _tmp4_;
		self->priv->selected_crop_y = _tmp5_;
		_tmp6_ = self->priv->_page;
		_tmp7_ = page_get_crop_width (_tmp6_);
		_tmp8_ = _tmp7_;
		self->priv->selected_crop_w = _tmp8_;
		_tmp9_ = self->priv->_page;
		_tmp10_ = page_get_crop_height (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->selected_crop_h = _tmp11_;
	}
}

void
page_view_motion (PageView* self,
                  gint x,
                  gint y)
{
	CropLocation location = 0;
	gchar* cursor = NULL;
	gint pw = 0;
	Page* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint ph = 0;
	Page* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint cw = 0;
	Page* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint ch = 0;
	Page* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint dx = 0;
	gint dy = 0;
	gint new_x = 0;
	gint new_y = 0;
	gint new_w = 0;
	gint new_h = 0;
	gint min_size = 0;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	Page* _tmp39_;
	gboolean _tmp40_ = FALSE;
	g_return_if_fail (self != NULL);
	location = page_view_get_crop_location (self, x, y);
	switch (location) {
		case CROP_LOCATION_MIDDLE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("hand1");
			_g_free0 (cursor);
			cursor = _tmp0_;
			break;
		}
		case CROP_LOCATION_TOP:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("top_side");
			_g_free0 (cursor);
			cursor = _tmp1_;
			break;
		}
		case CROP_LOCATION_BOTTOM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("bottom_side");
			_g_free0 (cursor);
			cursor = _tmp2_;
			break;
		}
		case CROP_LOCATION_LEFT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("left_side");
			_g_free0 (cursor);
			cursor = _tmp3_;
			break;
		}
		case CROP_LOCATION_RIGHT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("right_side");
			_g_free0 (cursor);
			cursor = _tmp4_;
			break;
		}
		case CROP_LOCATION_TOP_LEFT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("top_left_corner");
			_g_free0 (cursor);
			cursor = _tmp5_;
			break;
		}
		case CROP_LOCATION_TOP_RIGHT:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("top_right_corner");
			_g_free0 (cursor);
			cursor = _tmp6_;
			break;
		}
		case CROP_LOCATION_BOTTOM_LEFT:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("bottom_left_corner");
			_g_free0 (cursor);
			cursor = _tmp7_;
			break;
		}
		case CROP_LOCATION_BOTTOM_RIGHT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("bottom_right_corner");
			_g_free0 (cursor);
			cursor = _tmp8_;
			break;
		}
		default:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("arrow");
			_g_free0 (cursor);
			cursor = _tmp9_;
			break;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_NONE) {
		const gchar* _tmp10_;
		_tmp10_ = cursor;
		page_view_set_cursor (self, _tmp10_);
		_g_free0 (cursor);
		return;
	}
	_tmp11_ = self->priv->_page;
	_tmp12_ = page_get_width (_tmp11_);
	_tmp13_ = _tmp12_;
	pw = _tmp13_;
	_tmp14_ = self->priv->_page;
	_tmp15_ = page_get_height (_tmp14_);
	_tmp16_ = _tmp15_;
	ph = _tmp16_;
	_tmp17_ = self->priv->_page;
	_tmp18_ = page_get_crop_width (_tmp17_);
	_tmp19_ = _tmp18_;
	cw = _tmp19_;
	_tmp20_ = self->priv->_page;
	_tmp21_ = page_get_crop_height (_tmp20_);
	_tmp22_ = _tmp21_;
	ch = _tmp22_;
	dx = page_view_screen_to_page_x (self, x - ((gint) self->priv->selected_crop_px));
	dy = page_view_screen_to_page_y (self, y - ((gint) self->priv->selected_crop_py));
	new_x = self->priv->selected_crop_x;
	new_y = self->priv->selected_crop_y;
	new_w = self->priv->selected_crop_w;
	new_h = self->priv->selected_crop_h;
	min_size = page_view_screen_to_page_x (self, 15);
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = self->priv->crop_location == CROP_LOCATION_LEFT;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT;
	}
	if (_tmp23_) {
		if (dx > (new_w - min_size)) {
			dx = new_w - min_size;
		}
		if ((new_x + dx) < 0) {
			dx = -new_x;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = self->priv->crop_location == CROP_LOCATION_TOP;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = self->priv->crop_location == CROP_LOCATION_TOP_RIGHT;
	}
	if (_tmp25_) {
		if (dy > (new_h - min_size)) {
			dy = new_h - min_size;
		}
		if ((new_y + dy) < 0) {
			dy = -new_y;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_RIGHT) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = self->priv->crop_location == CROP_LOCATION_RIGHT;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp27_) {
		if (dx < (min_size - new_w)) {
			dx = min_size - new_w;
		}
		if (((new_x + new_w) + dx) > pw) {
			dx = (pw - new_x) - new_w;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = self->priv->crop_location == CROP_LOCATION_BOTTOM;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp29_) {
		if (dy < (min_size - new_h)) {
			dy = min_size - new_h;
		}
		if (((new_y + new_h) + dy) > ph) {
			dy = (ph - new_y) - new_h;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_MIDDLE) {
		if (((new_x + dx) + new_w) > pw) {
			dx = (pw - new_x) - new_w;
		}
		if ((new_x + dx) < 0) {
			dx = -new_x;
		}
		if (((new_y + dy) + new_h) > ph) {
			dy = (ph - new_y) - new_h;
		}
		if ((new_y + dy) < 0) {
			dy = -new_y;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_MIDDLE) {
		new_x += dx;
		new_y += dy;
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = self->priv->crop_location == CROP_LOCATION_LEFT;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		_tmp31_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT;
	}
	if (_tmp31_) {
		new_x += dx;
		new_w -= dx;
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp34_ = TRUE;
	} else {
		_tmp34_ = self->priv->crop_location == CROP_LOCATION_TOP;
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = self->priv->crop_location == CROP_LOCATION_TOP_RIGHT;
	}
	if (_tmp33_) {
		new_y += dy;
		new_h -= dy;
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_RIGHT) {
		_tmp36_ = TRUE;
	} else {
		_tmp36_ = self->priv->crop_location == CROP_LOCATION_RIGHT;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp35_) {
		new_w += dx;
	}
	if (self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = self->priv->crop_location == CROP_LOCATION_BOTTOM;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp37_) {
		new_h += dy;
	}
	_tmp39_ = self->priv->_page;
	page_move_crop (_tmp39_, new_x, new_y);
	if (new_w != cw) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = new_h != ch;
	}
	if (_tmp40_) {
		Page* _tmp41_;
		_tmp41_ = self->priv->_page;
		page_set_custom_crop (_tmp41_, new_w, new_h);
	}
	_g_free0 (cursor);
}

void
page_view_button_release (PageView* self,
                          gint x,
                          gint y)
{
	g_return_if_fail (self != NULL);
	self->priv->crop_location = CROP_LOCATION_NONE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static gboolean
page_view_animation_cb (PageView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->animate_segment = (self->priv->animate_segment + 1) % self->priv->animate_n_segments;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gboolean
_page_view_animation_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = page_view_animation_cb ((PageView*) self);
	return result;
}

static void
page_view_update_animation (PageView* self)
{
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_page;
	_tmp2_ = page_get_is_scanning (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Page* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->_page;
		_tmp5_ = page_get_has_data (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	animate = _tmp0_;
	is_animating = self->priv->animate_timeout != ((guint) 0);
	if (animate == is_animating) {
		return;
	}
	if (animate) {
		self->priv->animate_segment = 0;
		if (self->priv->animate_timeout == ((guint) 0)) {
			self->priv->animate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
	} else {
		if (self->priv->animate_timeout != ((guint) 0)) {
			g_source_remove (self->priv->animate_timeout);
		}
		self->priv->animate_timeout = (guint) 0;
	}
}

void
page_view_render (PageView* self,
                  cairo_t* context,
                  GdkRGBA* ruler_color)
{
	PageViewTexture* _tmp0_;
	gint w = 0;
	gint h = 0;
	gint _tmp4_;
	gint _tmp5_;
	PageViewTexture* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkRGBA _tmp23_;
	gint ruler_tick = 0;
	gdouble line = 0.0;
	gint big_ruler_tick = 0;
	gboolean _tmp36_ = FALSE;
	Page* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	Page* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (ruler_color != NULL);
	page_view_update_animation (self);
	_tmp0_ = self->priv->page_texture;
	page_view_texture_request_resize (_tmp0_, page_view_get_preview_width (self), page_view_get_preview_height (self));
	{
		PageViewTexture* _tmp1_;
		_tmp1_ = self->priv->page_texture;
		page_view_texture_queue_update (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("page-view.vala:415: Failed to queue_update of the texture: %s", _tmp3_);
		g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	w = page_view_get_preview_width (self);
	h = page_view_get_preview_height (self);
	cairo_set_line_width (context, (gdouble) 1);
	_tmp4_ = self->priv->_x_offset;
	_tmp5_ = self->priv->_y_offset;
	cairo_translate (context, (gdouble) _tmp4_, (gdouble) _tmp5_);
	cairo_translate (context, (gdouble) (self->priv->border_width + self->priv->ruler_width), (gdouble) (self->priv->border_width + self->priv->ruler_width));
	_tmp6_ = self->priv->page_texture;
	_tmp7_ = page_view_texture_get_pixbuf (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		gfloat x_scale = 0.0F;
		PageViewTexture* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gfloat y_scale = 0.0F;
		PageViewTexture* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		PageViewTexture* _tmp19_;
		GdkPixbuf* _tmp20_;
		GdkPixbuf* _tmp21_;
		_tmp9_ = self->priv->page_texture;
		_tmp10_ = page_view_texture_get_pixbuf (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gdk_pixbuf_get_width (_tmp11_);
		_tmp13_ = _tmp12_;
		x_scale = ((gfloat) w) / ((gfloat) _tmp13_);
		_tmp14_ = self->priv->page_texture;
		_tmp15_ = page_view_texture_get_pixbuf (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gdk_pixbuf_get_height (_tmp16_);
		_tmp18_ = _tmp17_;
		y_scale = ((gfloat) h) / ((gfloat) _tmp18_);
		cairo_save (context);
		cairo_scale (context, (gdouble) x_scale, (gdouble) y_scale);
		_tmp19_ = self->priv->page_texture;
		_tmp20_ = page_view_texture_get_pixbuf (_tmp19_);
		_tmp21_ = _tmp20_;
		gdk_cairo_set_source_pixbuf (context, _tmp21_, (gdouble) 0, (gdouble) 0);
		cairo_paint (context);
		cairo_restore (context);
	} else {
		GdkRGBA _tmp22_ = {0};
		_tmp22_.red = 1.0f;
		_tmp22_.green = 1.0f;
		_tmp22_.blue = 1.0f;
		_tmp22_.alpha = 1.0f;
		gdk_cairo_set_source_rgba (context, &_tmp22_);
		cairo_rectangle (context, (gdouble) 0, 0.0, (gdouble) w, (gdouble) h);
		cairo_fill (context);
	}
	_tmp23_ = *ruler_color;
	gdk_cairo_set_source_rgba (context, &_tmp23_);
	cairo_set_line_width (context, (gdouble) self->priv->border_width);
	cairo_rectangle (context, (gdouble) 0, 0.0, (gdouble) w, (gdouble) h);
	cairo_stroke (context);
	cairo_set_line_width (context, (gdouble) 1);
	ruler_tick = 0;
	line = 0.0;
	big_ruler_tick = 5;
	while (TRUE) {
		Page* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		Page* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp24_ = self->priv->_page;
		_tmp25_ = page_get_width (_tmp24_);
		_tmp26_ = _tmp25_;
		if (!(ruler_tick <= _tmp26_)) {
			break;
		}
		line = page_view_page_to_screen_x (self, ruler_tick) + 0.5;
		if (big_ruler_tick == 5) {
			cairo_move_to (context, line, (gdouble) 0);
			cairo_line_to (context, line, (gdouble) (-self->priv->ruler_width));
			cairo_move_to (context, line, (gdouble) h);
			cairo_line_to (context, line, (gdouble) (h + self->priv->ruler_width));
			big_ruler_tick = 0;
		} else {
			cairo_move_to (context, line, (gdouble) -2);
			cairo_line_to (context, line, (gdouble) -5);
			cairo_move_to (context, line, (gdouble) (h + 2));
			cairo_line_to (context, line, (gdouble) (h + 5));
		}
		_tmp27_ = self->priv->_page;
		_tmp28_ = page_get_dpi (_tmp27_);
		_tmp29_ = _tmp28_;
		ruler_tick = ruler_tick + (_tmp29_ / 5);
		big_ruler_tick = big_ruler_tick + 1;
	}
	cairo_stroke (context);
	ruler_tick = 0;
	line = 0.0;
	big_ruler_tick = 5;
	while (TRUE) {
		Page* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		Page* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp30_ = self->priv->_page;
		_tmp31_ = page_get_height (_tmp30_);
		_tmp32_ = _tmp31_;
		if (!(ruler_tick <= _tmp32_)) {
			break;
		}
		line = page_view_page_to_screen_y (self, ruler_tick) + 0.5;
		if (big_ruler_tick == 5) {
			cairo_move_to (context, (gdouble) 0, line);
			cairo_line_to (context, (gdouble) (-self->priv->ruler_width), line);
			cairo_move_to (context, (gdouble) w, line);
			cairo_line_to (context, (gdouble) (w + self->priv->ruler_width), line);
			big_ruler_tick = 0;
		} else {
			cairo_move_to (context, (gdouble) -2, line);
			cairo_line_to (context, (gdouble) -5, line);
			cairo_move_to (context, (gdouble) (w + 2), line);
			cairo_line_to (context, (gdouble) (w + 5), line);
		}
		_tmp33_ = self->priv->_page;
		_tmp34_ = page_get_dpi (_tmp33_);
		_tmp35_ = _tmp34_;
		ruler_tick = ruler_tick + (_tmp35_ / 5);
		big_ruler_tick = big_ruler_tick + 1;
	}
	cairo_stroke (context);
	_tmp37_ = self->priv->_page;
	_tmp38_ = page_get_is_scanning (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_) {
		Page* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp40_ = self->priv->_page;
		_tmp41_ = page_get_scan_line (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp36_ = _tmp42_ > 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gint scan_line = 0;
		Page* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp46_;
		ScanDirection _tmp47_;
		ScanDirection _tmp48_;
		_tmp43_ = self->priv->_page;
		_tmp44_ = page_get_scan_line (_tmp43_);
		_tmp45_ = _tmp44_;
		scan_line = _tmp45_;
		_tmp46_ = self->priv->_page;
		_tmp47_ = page_get_scan_direction (_tmp46_);
		_tmp48_ = _tmp47_;
		switch (_tmp48_) {
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
			{
				s = (gdouble) page_view_page_to_screen_y (self, scan_line);
				x1 = (gdouble) 0;
				y1 = s + 0.5;
				x2 = (gdouble) w;
				y2 = s + 0.5;
				break;
			}
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
			{
				s = (gdouble) page_view_page_to_screen_y (self, scan_line);
				x1 = (gdouble) 0;
				y1 = (h - s) + 0.5;
				x2 = (gdouble) w;
				y2 = (h - s) + 0.5;
				break;
			}
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
			{
				s = (gdouble) page_view_page_to_screen_x (self, scan_line);
				x1 = s + 0.5;
				y1 = (gdouble) 0;
				x2 = s + 0.5;
				y2 = (gdouble) h;
				break;
			}
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
			{
				s = (gdouble) page_view_page_to_screen_x (self, scan_line);
				x1 = (w - s) + 0.5;
				y1 = (gdouble) 0;
				x2 = (w - s) + 0.5;
				y2 = (gdouble) h;
				break;
			}
			default:
			{
				y2 = (gdouble) 0;
				x2 = y2;
				y1 = x2;
				x1 = y1;
				break;
			}
		}
		cairo_move_to (context, x1, y1);
		cairo_line_to (context, x2, y2);
		cairo_set_source_rgb (context, 1.0, 0.0, 0.0);
		cairo_stroke (context);
	}
	_tmp49_ = self->priv->_page;
	_tmp50_ = page_get_has_crop (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_) {
		gint x = 0;
		Page* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint y = 0;
		Page* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint crop_width = 0;
		Page* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint crop_height = 0;
		Page* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint dx = 0;
		gint dy = 0;
		gint dw = 0;
		gint dh = 0;
		_tmp52_ = self->priv->_page;
		_tmp53_ = page_get_crop_x (_tmp52_);
		_tmp54_ = _tmp53_;
		x = _tmp54_;
		_tmp55_ = self->priv->_page;
		_tmp56_ = page_get_crop_y (_tmp55_);
		_tmp57_ = _tmp56_;
		y = _tmp57_;
		_tmp58_ = self->priv->_page;
		_tmp59_ = page_get_crop_width (_tmp58_);
		_tmp60_ = _tmp59_;
		crop_width = _tmp60_;
		_tmp61_ = self->priv->_page;
		_tmp62_ = page_get_crop_height (_tmp61_);
		_tmp63_ = _tmp62_;
		crop_height = _tmp63_;
		dx = page_view_page_to_screen_x (self, x);
		dy = page_view_page_to_screen_y (self, y);
		dw = page_view_page_to_screen_x (self, crop_width);
		dh = page_view_page_to_screen_y (self, crop_height);
		cairo_rectangle (context, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
		cairo_new_sub_path (context);
		cairo_rectangle (context, (gdouble) dx, (gdouble) dy, (gdouble) dw, (gdouble) dh);
		cairo_set_fill_rule (context, CAIRO_FILL_RULE_EVEN_ODD);
		cairo_set_source_rgba (context, 0.25, 0.25, 0.25, 0.2);
		cairo_fill (context);
		cairo_set_source_rgb (context, 1.0, 1.0, 1.0);
		cairo_move_to (context, (gdouble) (-self->priv->border_width), dy - 1.5);
		cairo_line_to (context, (gdouble) (self->priv->border_width + w), dy - 1.5);
		cairo_move_to (context, (gdouble) (-self->priv->border_width), (dy + dh) + 1.5);
		cairo_line_to (context, (gdouble) (self->priv->border_width + w), (dy + dh) + 1.5);
		cairo_stroke (context);
		cairo_move_to (context, dx - 1.5, (gdouble) (-self->priv->border_width));
		cairo_line_to (context, dx - 1.5, (gdouble) (self->priv->border_width + h));
		cairo_move_to (context, (dx + dw) + 1.5, (gdouble) (-self->priv->border_width));
		cairo_line_to (context, (dx + dw) + 1.5, (gdouble) (self->priv->border_width + h));
		cairo_stroke (context);
		cairo_rectangle (context, dx - 0.5, dy - 0.5, (gdouble) (dw + 1), (gdouble) (dh + 1));
		cairo_set_source_rgb (context, 0.0, 0.0, 0.0);
		cairo_stroke (context);
	}
}

static void
page_view_page_pixels_changed_cb (PageView* self,
                                  Page* p)
{
	PageViewTexture* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	_tmp0_ = self->priv->page_texture;
	page_view_texture_request_update (_tmp0_);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static void
page_view_page_size_changed_cb (PageView* self,
                                Page* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static void
page_view_page_overlay_changed_cb (PageView* self,
                                   Page* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static void
page_view_scan_direction_changed_cb (PageView* self,
                                     Page* p)
{
	PageViewTexture* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	_tmp0_ = self->priv->page_texture;
	page_view_texture_request_update (_tmp0_);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

Page*
page_view_get_page (PageView* self)
{
	Page* result;
	Page* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_page;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
page_view_set_page (PageView* self,
                    Page* value)
{
	Page* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_page (self);
	if (old_value != value) {
		Page* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_page);
		self->priv->_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_PAGE_PROPERTY]);
	}
}

gboolean
page_view_get_selected (PageView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->selected_;
	return result;
}

void
page_view_set_selected (PageView* self,
                        gboolean value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp2_ = page_view_get_selected (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = page_view_get_selected (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = page_view_get_selected (self);
		_tmp8_ = _tmp7_;
		if (!_tmp8_) {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = page_view_get_selected (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = !_tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = page_view_get_selected (self);
	_tmp12_ = _tmp11_;
	page_view_set_selected (self, _tmp12_);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_SELECTED_PROPERTY]);
}

gint
page_view_get_x_offset (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_x_offset;
	return result;
}

void
page_view_set_x_offset (PageView* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_x_offset (self);
	if (old_value != value) {
		self->priv->_x_offset = value;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_X_OFFSET_PROPERTY]);
	}
}

gint
page_view_get_y_offset (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_y_offset;
	return result;
}

void
page_view_set_y_offset (PageView* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_y_offset (self);
	if (old_value != value) {
		self->priv->_y_offset = value;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_Y_OFFSET_PROPERTY]);
	}
}

const gchar*
page_view_get_cursor (PageView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cursor;
	result = _tmp0_;
	return result;
}

static void
page_view_set_cursor (PageView* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_cursor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_cursor);
		self->priv->_cursor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_CURSOR_PROPERTY]);
	}
}

gint
page_view_get_width (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->width_;
	return result;
}

void
page_view_set_width (PageView* self,
                     gint value)
{
	gint h = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_width (_tmp3_);
	_tmp5_ = _tmp4_;
	h = (gint) ((((gdouble) value) * _tmp2_) / _tmp5_);
	if (self->priv->width_ == value) {
		_tmp6_ = self->priv->height_ == h;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	self->priv->width_ = value;
	self->priv->height_ = h;
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_WIDTH_PROPERTY]);
}

gint
page_view_get_height (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->height_;
	return result;
}

void
page_view_set_height (PageView* self,
                      gint value)
{
	gint w = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_height (_tmp3_);
	_tmp5_ = _tmp4_;
	w = (gint) ((((gdouble) value) * _tmp2_) / _tmp5_);
	if (self->priv->width_ == w) {
		_tmp6_ = self->priv->height_ == value;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	self->priv->width_ = w;
	self->priv->height_ = value;
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_HEIGHT_PROPERTY]);
}

static void
page_view_class_init (PageViewClass * klass,
                      gpointer klass_data)
{
	page_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_page_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_page_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = page_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_PAGE_PROPERTY, page_view_properties[PAGE_VIEW_PAGE_PROPERTY] = g_param_spec_object ("page", "page", "page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_SELECTED_PROPERTY, page_view_properties[PAGE_VIEW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_X_OFFSET_PROPERTY, page_view_properties[PAGE_VIEW_X_OFFSET_PROPERTY] = g_param_spec_int ("x-offset", "x-offset", "x-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_Y_OFFSET_PROPERTY, page_view_properties[PAGE_VIEW_Y_OFFSET_PROPERTY] = g_param_spec_int ("y-offset", "y-offset", "y-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_CURSOR_PROPERTY, page_view_properties[PAGE_VIEW_CURSOR_PROPERTY] = g_param_spec_string ("cursor", "cursor", "cursor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_WIDTH_PROPERTY, page_view_properties[PAGE_VIEW_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_HEIGHT_PROPERTY, page_view_properties[PAGE_VIEW_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL] = g_signal_new ("size-changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_view_signals[PAGE_VIEW_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
page_view_instance_init (PageView * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = page_view_get_instance_private (self);
	self->priv->selected_ = FALSE;
	self->priv->ruler_width = 8;
	self->priv->border_width = 2;
	self->priv->update_image = TRUE;
	_tmp0_ = g_strdup ("arrow");
	self->priv->_cursor = _tmp0_;
	self->priv->animate_n_segments = 7;
}

static void
page_view_finalize (GObject * obj)
{
	PageView * self;
	Page* _tmp0_;
	guint _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
	guint _tmp5_;
	Page* _tmp6_;
	guint _tmp7_;
	Page* _tmp8_;
	guint _tmp9_;
	PageViewTexture* _tmp10_;
	guint _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
	_tmp0_ = self->priv->_page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
	_tmp2_ = self->priv->_page;
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
	_tmp4_ = self->priv->_page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
	_tmp6_ = self->priv->_page;
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
	_tmp8_ = self->priv->_page;
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
	_tmp10_ = self->priv->page_texture;
	g_signal_parse_name ("new-buffer", TYPE_PAGE_VIEW_TEXTURE, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _page_view_new_buffer_cb_page_view_texture_new_buffer, self);
	_g_object_unref0 (self->priv->_page);
	_g_object_unref0 (self->priv->page_texture);
	_g_free0 (self->priv->_cursor);
	G_OBJECT_CLASS (page_view_parent_class)->finalize (obj);
}

static GType
page_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, NULL };
	GType page_view_type_id;
	page_view_type_id = g_type_register_static (G_TYPE_OBJECT, "PageView", &g_define_type_info, 0);
	PageView_private_offset = g_type_add_instance_private (page_view_type_id, sizeof (PageViewPrivate));
	return page_view_type_id;
}

GType
page_view_get_type (void)
{
	static volatile gsize page_view_type_id__once = 0;
	if (g_once_init_enter (&page_view_type_id__once)) {
		GType page_view_type_id;
		page_view_type_id = page_view_get_type_once ();
		g_once_init_leave (&page_view_type_id__once, page_view_type_id);
	}
	return page_view_type_id__once;
}

static void
_vala_page_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	PageView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_VIEW, PageView);
	switch (property_id) {
		case PAGE_VIEW_PAGE_PROPERTY:
		g_value_set_object (value, page_view_get_page (self));
		break;
		case PAGE_VIEW_SELECTED_PROPERTY:
		g_value_set_boolean (value, page_view_get_selected (self));
		break;
		case PAGE_VIEW_X_OFFSET_PROPERTY:
		g_value_set_int (value, page_view_get_x_offset (self));
		break;
		case PAGE_VIEW_Y_OFFSET_PROPERTY:
		g_value_set_int (value, page_view_get_y_offset (self));
		break;
		case PAGE_VIEW_CURSOR_PROPERTY:
		g_value_set_string (value, page_view_get_cursor (self));
		break;
		case PAGE_VIEW_WIDTH_PROPERTY:
		g_value_set_int (value, page_view_get_width (self));
		break;
		case PAGE_VIEW_HEIGHT_PROPERTY:
		g_value_set_int (value, page_view_get_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_page_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	PageView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_VIEW, PageView);
	switch (property_id) {
		case PAGE_VIEW_PAGE_PROPERTY:
		page_view_set_page (self, g_value_get_object (value));
		break;
		case PAGE_VIEW_SELECTED_PROPERTY:
		page_view_set_selected (self, g_value_get_boolean (value));
		break;
		case PAGE_VIEW_X_OFFSET_PROPERTY:
		page_view_set_x_offset (self, g_value_get_int (value));
		break;
		case PAGE_VIEW_Y_OFFSET_PROPERTY:
		page_view_set_y_offset (self, g_value_get_int (value));
		break;
		case PAGE_VIEW_CURSOR_PROPERTY:
		page_view_set_cursor (self, g_value_get_string (value));
		break;
		case PAGE_VIEW_WIDTH_PROPERTY:
		page_view_set_width (self, g_value_get_int (value));
		break;
		case PAGE_VIEW_HEIGHT_PROPERTY:
		page_view_set_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

