#include <QtWaylandClient/private/wayland-wayland-client-protocol.h>
/* Generated by wayland-scanner 1.23.1 */

#ifndef XCOMPOSITE_CLIENT_PROTOCOL_H
#define XCOMPOSITE_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_xcomposite The xcomposite protocol
 * @section page_ifaces_xcomposite Interfaces
 * - @subpage page_iface_qt_xcomposite - 
 * @section page_copyright_xcomposite Copyright
 * <pre>
 *
 * Copyright (C) 2015 The Qt Company Ltd.
 * Contact: http://www.qt.io/licensing/
 *
 * This file is part of the plugins of the Qt Toolkit.
 *
 * $QT_BEGIN_LICENSE:BSD$
 * You may use this file under the terms of the BSD license as follows:
 *
 * "Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * * Neither the name of The Qt Company Ltd nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 *
 * $QT_END_LICENSE$
 * </pre>
 */
struct qt_xcomposite;
struct wl_buffer;

#ifndef QT_XCOMPOSITE_INTERFACE
#define QT_XCOMPOSITE_INTERFACE
/**
 * @page page_iface_qt_xcomposite qt_xcomposite
 * @section page_iface_qt_xcomposite_api API
 * See @ref iface_qt_xcomposite.
 */
/**
 * @defgroup iface_qt_xcomposite The qt_xcomposite interface
 */
extern const struct wl_interface qt_xcomposite_interface;
#endif

/**
 * @ingroup iface_qt_xcomposite
 * @struct qt_xcomposite_listener
 */
struct qt_xcomposite_listener {
	/**
	 */
	void (*root)(void *data,
		     struct qt_xcomposite *qt_xcomposite,
		     const char *display_name,
		     uint32_t root_window);
};

/**
 * @ingroup iface_qt_xcomposite
 */
static inline int
qt_xcomposite_add_listener(struct qt_xcomposite *qt_xcomposite,
			   const struct qt_xcomposite_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) qt_xcomposite,
				     (void (**)(void)) listener, data);
}

#define QT_XCOMPOSITE_CREATE_BUFFER 0

/**
 * @ingroup iface_qt_xcomposite
 */
#define QT_XCOMPOSITE_ROOT_SINCE_VERSION 1

/**
 * @ingroup iface_qt_xcomposite
 */
#define QT_XCOMPOSITE_CREATE_BUFFER_SINCE_VERSION 1

/** @ingroup iface_qt_xcomposite */
static inline void
qt_xcomposite_set_user_data(struct qt_xcomposite *qt_xcomposite, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) qt_xcomposite, user_data);
}

/** @ingroup iface_qt_xcomposite */
static inline void *
qt_xcomposite_get_user_data(struct qt_xcomposite *qt_xcomposite)
{
	return wl_proxy_get_user_data((struct wl_proxy *) qt_xcomposite);
}

static inline uint32_t
qt_xcomposite_get_version(struct qt_xcomposite *qt_xcomposite)
{
	return wl_proxy_get_version((struct wl_proxy *) qt_xcomposite);
}

/** @ingroup iface_qt_xcomposite */
static inline void
qt_xcomposite_destroy(struct qt_xcomposite *qt_xcomposite)
{
	wl_proxy_destroy((struct wl_proxy *) qt_xcomposite);
}

/**
 * @ingroup iface_qt_xcomposite
 */
static inline struct wl_buffer *
qt_xcomposite_create_buffer(struct qt_xcomposite *qt_xcomposite, uint32_t x_window, int32_t width, int32_t height)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) qt_xcomposite,
			 QT_XCOMPOSITE_CREATE_BUFFER, &wl_buffer_interface, wl_proxy_get_version((struct wl_proxy *) qt_xcomposite), 0, NULL, x_window, width, height);

	return (struct wl_buffer *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
