/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.13.1
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6-NetworkAuth.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetworkAuth.h"

#line 26 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/sip/QtNetworkAuth/qoauth1signature.sip"
#include <qoauth1signature.h>
#line 29 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"

#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qurl.sip"
#include <qurl.h>
#line 33 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"
#line 259 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qmap.sip"
#include <qmap.h>
#line 36 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 39 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"
#line 24 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 42 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 45 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 48 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt6/bindings/QtCore/qurlquery.sip"
#include <qurlquery.h>
#line 51 "/build/pyqt6-networkauth/src/pyqt6_networkauth-6.10.0/build/QtNetworkAuth/sipQtNetworkAuthQOAuth1Signature.cpp"


PyDoc_STRVAR(doc_QOAuth1Signature_httpRequestMethod, "httpRequestMethod(self) -> QOAuth1Signature.HttpRequestMethod");

extern "C" {static PyObject *meth_QOAuth1Signature_httpRequestMethod(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_httpRequestMethod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QOAuth1Signature::HttpRequestMethod sipRes;

            sipRes = sipCpp->httpRequestMethod();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QOAuth1Signature_HttpRequestMethod);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_httpRequestMethod, doc_QOAuth1Signature_httpRequestMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_setHttpRequestMethod, "setHttpRequestMethod(self, method: QOAuth1Signature.HttpRequestMethod)");

extern "C" {static PyObject *meth_QOAuth1Signature_setHttpRequestMethod(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_setHttpRequestMethod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOAuth1Signature::HttpRequestMethod a0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QOAuth1Signature_HttpRequestMethod, &a0))
        {
            sipCpp->setHttpRequestMethod(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_setHttpRequestMethod, doc_QOAuth1Signature_setHttpRequestMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_url, "url(self) -> QUrl");

extern "C" {static PyObject *meth_QOAuth1Signature_url(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_url(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QUrl*sipRes;

            sipRes = new ::QUrl(sipCpp->url());

            return sipConvertFromNewType(sipRes, sipType_QUrl, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_url, doc_QOAuth1Signature_url);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_setUrl, "setUrl(self, url: QUrl)");

extern "C" {static PyObject *meth_QOAuth1Signature_setUrl(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_setUrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUrl* a0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QUrl, &a0))
        {
            sipCpp->setUrl(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_setUrl, doc_QOAuth1Signature_setUrl);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_parameters, "parameters(self) -> dict[str, list[Any]]");

extern "C" {static PyObject *meth_QOAuth1Signature_parameters(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_parameters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            QMultiMap< ::QString, ::QVariant>*sipRes;

            sipRes = new QMultiMap< ::QString, ::QVariant>(sipCpp->parameters());

            return sipConvertFromNewType(sipRes, sipType_QMultiMap_0100QString_0100QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_parameters, doc_QOAuth1Signature_parameters);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_setParameters, "setParameters(self, parameters: dict[Optional[str], Sequence[Any]])");

extern "C" {static PyObject *meth_QOAuth1Signature_setParameters(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_setParameters(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QMultiMap< ::QString, ::QVariant>* a0;
        int a0State = 0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QMultiMap_0100QString_0100QVariant, &a0, &a0State))
        {
            sipCpp->setParameters(*a0);
            sipReleaseType(const_cast<QMultiMap< ::QString, ::QVariant> *>(a0), sipType_QMultiMap_0100QString_0100QVariant, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_setParameters, doc_QOAuth1Signature_setParameters);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_addRequestBody, "addRequestBody(self, body: QUrlQuery)");

extern "C" {static PyObject *meth_QOAuth1Signature_addRequestBody(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_addRequestBody(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUrlQuery* a0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QUrlQuery, &a0))
        {
            sipCpp->addRequestBody(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_addRequestBody, doc_QOAuth1Signature_addRequestBody);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_insert, "insert(self, key: Optional[str], value: Any)");

extern "C" {static PyObject *meth_QOAuth1Signature_insert(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QVariant* a1;
        int a1State = 0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QString, &a0, &a0State, sipType_QVariant, &a1, &a1State))
        {
            sipCpp->insert(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_insert, doc_QOAuth1Signature_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_keys, "keys(self) -> list[str]");

extern "C" {static PyObject *meth_QOAuth1Signature_keys(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_keys(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            QList< ::QString>*sipRes;

            sipRes = new QList< ::QString>(sipCpp->keys());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_keys, doc_QOAuth1Signature_keys);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_take, "take(self, key: Optional[str]) -> Any");

extern "C" {static PyObject *meth_QOAuth1Signature_take(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_take(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->take(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_take, doc_QOAuth1Signature_take);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_value, "value(self, key: Optional[str], defaultValue: Any = None) -> Any");

extern "C" {static PyObject *meth_QOAuth1Signature_value(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_value(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QVariant& a1def = QVariant();
        const ::QVariant* a1 = &a1def;
        int a1State = 0;
        const ::QOAuth1Signature *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_defaultValue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QString, &a0, &a0State, sipType_QVariant, &a1, &a1State))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->value(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_value, doc_QOAuth1Signature_value);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_clientSharedKey, "clientSharedKey(self) -> str");

extern "C" {static PyObject *meth_QOAuth1Signature_clientSharedKey(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_clientSharedKey(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->clientSharedKey());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_clientSharedKey, doc_QOAuth1Signature_clientSharedKey);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_setClientSharedKey, "setClientSharedKey(self, secret: Optional[str])");

extern "C" {static PyObject *meth_QOAuth1Signature_setClientSharedKey(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_setClientSharedKey(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setClientSharedKey(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_setClientSharedKey, doc_QOAuth1Signature_setClientSharedKey);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_tokenSecret, "tokenSecret(self) -> str");

extern "C" {static PyObject *meth_QOAuth1Signature_tokenSecret(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_tokenSecret(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->tokenSecret());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_tokenSecret, doc_QOAuth1Signature_tokenSecret);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_setTokenSecret, "setTokenSecret(self, secret: Optional[str])");

extern "C" {static PyObject *meth_QOAuth1Signature_setTokenSecret(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_setTokenSecret(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setTokenSecret(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_setTokenSecret, doc_QOAuth1Signature_setTokenSecret);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_hmacSha1, "hmacSha1(self) -> QByteArray");

extern "C" {static PyObject *meth_QOAuth1Signature_hmacSha1(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_hmacSha1(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->hmacSha1());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_hmacSha1, doc_QOAuth1Signature_hmacSha1);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_rsaSha1, "rsaSha1(self) -> QByteArray");

extern "C" {static PyObject *meth_QOAuth1Signature_rsaSha1(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_rsaSha1(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->rsaSha1());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_rsaSha1, doc_QOAuth1Signature_rsaSha1);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_plainText, "plainText(self) -> QByteArray\n"
"plainText(clientSharedSecret: Optional[str], tokenSecret: Optional[str]) -> QByteArray");

extern "C" {static PyObject *meth_QOAuth1Signature_plainText(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_plainText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->plainText());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1J1", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QOAuth1Signature::plainText(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_plainText, doc_QOAuth1Signature_plainText);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_swap, "swap(self, other: QOAuth1Signature)");

extern "C" {static PyObject *meth_QOAuth1Signature_swap(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOAuth1Signature* a0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QOAuth1Signature, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_swap, doc_QOAuth1Signature_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_customMethodString, "customMethodString(self) -> QByteArray");

extern "C" {static PyObject *meth_QOAuth1Signature_customMethodString(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_customMethodString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOAuth1Signature, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->customMethodString());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_customMethodString, doc_QOAuth1Signature_customMethodString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOAuth1Signature_setCustomMethodString, "setCustomMethodString(self, verb: Union[QByteArray, bytes, bytearray, memoryview])");

extern "C" {static PyObject *meth_QOAuth1Signature_setCustomMethodString(PyObject *, PyObject *);}
static PyObject *meth_QOAuth1Signature_setCustomMethodString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QOAuth1Signature *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QOAuth1Signature, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->setCustomMethodString(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOAuth1Signature, sipName_setCustomMethodString, doc_QOAuth1Signature_setCustomMethodString);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QOAuth1Signature(void *, int);}
static void release_QOAuth1Signature(void *sipCppV, int)
{
    delete reinterpret_cast< ::QOAuth1Signature *>(sipCppV);
}


extern "C" {static void *array_QOAuth1Signature(Py_ssize_t);}
static void *array_QOAuth1Signature(Py_ssize_t sipNrElem)
{
    return new ::QOAuth1Signature[sipNrElem];
}


extern "C" {static void array_delete_QOAuth1Signature(void *);}
static void array_delete_QOAuth1Signature(void *sipCpp)
{
    delete[] reinterpret_cast< ::QOAuth1Signature *>(sipCpp);
}


extern "C" {static void assign_QOAuth1Signature(void *, Py_ssize_t, void *);}
static void assign_QOAuth1Signature(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QOAuth1Signature *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QOAuth1Signature *>(sipSrc);
}


extern "C" {static void *copy_QOAuth1Signature(const void *, Py_ssize_t);}
static void *copy_QOAuth1Signature(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QOAuth1Signature(reinterpret_cast<const ::QOAuth1Signature *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QOAuth1Signature(sipSimpleWrapper *);}
static void dealloc_QOAuth1Signature(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QOAuth1Signature(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QOAuth1Signature(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QOAuth1Signature(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QOAuth1Signature *sipCpp = SIP_NULLPTR;

    {
        const ::QUrl& a0def = QUrl();
        const ::QUrl* a0 = &a0def;
        ::QOAuth1Signature::HttpRequestMethod a1 = QOAuth1Signature::HttpRequestMethod::Post;
        const QMultiMap< ::QString, ::QVariant>& a2def = {};
        const QMultiMap< ::QString, ::QVariant>* a2 = &a2def;
        int a2State = 0;

        static const char *sipKwdList[] = {
            sipName_url,
            sipName_method,
            sipName_parameters,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J9EJ1", sipType_QUrl, &a0, sipType_QOAuth1Signature_HttpRequestMethod, &a1, sipType_QMultiMap_0100QString_0100QVariant, &a2, &a2State))
        {
            sipCpp = new ::QOAuth1Signature(*a0, a1, *a2);
            sipReleaseType(const_cast<QMultiMap< ::QString, ::QVariant> *>(a2), sipType_QMultiMap_0100QString_0100QVariant, a2State);

            return sipCpp;
        }
    }

    {
        const ::QUrl* a0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        ::QOAuth1Signature::HttpRequestMethod a3 = QOAuth1Signature::HttpRequestMethod::Post;
        const QMultiMap< ::QString, ::QVariant>& a4def = {};
        const QMultiMap< ::QString, ::QVariant>* a4 = &a4def;
        int a4State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_method,
            sipName_parameters,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J1J1|EJ1", sipType_QUrl, &a0, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QOAuth1Signature_HttpRequestMethod, &a3, sipType_QMultiMap_0100QString_0100QVariant, &a4, &a4State))
        {
            sipCpp = new ::QOAuth1Signature(*a0, *a1, *a2, a3, *a4);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast<QMultiMap< ::QString, ::QVariant> *>(a4), sipType_QMultiMap_0100QString_0100QVariant, a4State);

            return sipCpp;
        }
    }

    {
        const ::QOAuth1Signature* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QOAuth1Signature, &a0))
        {
            sipCpp = new ::QOAuth1Signature(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QOAuth1Signature[] = {
    {sipName_addRequestBody, meth_QOAuth1Signature_addRequestBody, METH_VARARGS, doc_QOAuth1Signature_addRequestBody},
    {sipName_clientSharedKey, meth_QOAuth1Signature_clientSharedKey, METH_VARARGS, doc_QOAuth1Signature_clientSharedKey},
    {sipName_customMethodString, meth_QOAuth1Signature_customMethodString, METH_VARARGS, doc_QOAuth1Signature_customMethodString},
    {sipName_hmacSha1, meth_QOAuth1Signature_hmacSha1, METH_VARARGS, doc_QOAuth1Signature_hmacSha1},
    {sipName_httpRequestMethod, meth_QOAuth1Signature_httpRequestMethod, METH_VARARGS, doc_QOAuth1Signature_httpRequestMethod},
    {sipName_insert, meth_QOAuth1Signature_insert, METH_VARARGS, doc_QOAuth1Signature_insert},
    {sipName_keys, meth_QOAuth1Signature_keys, METH_VARARGS, doc_QOAuth1Signature_keys},
    {sipName_parameters, meth_QOAuth1Signature_parameters, METH_VARARGS, doc_QOAuth1Signature_parameters},
    {sipName_plainText, meth_QOAuth1Signature_plainText, METH_VARARGS, doc_QOAuth1Signature_plainText},
    {sipName_rsaSha1, meth_QOAuth1Signature_rsaSha1, METH_VARARGS, doc_QOAuth1Signature_rsaSha1},
    {sipName_setClientSharedKey, meth_QOAuth1Signature_setClientSharedKey, METH_VARARGS, doc_QOAuth1Signature_setClientSharedKey},
    {sipName_setCustomMethodString, meth_QOAuth1Signature_setCustomMethodString, METH_VARARGS, doc_QOAuth1Signature_setCustomMethodString},
    {sipName_setHttpRequestMethod, meth_QOAuth1Signature_setHttpRequestMethod, METH_VARARGS, doc_QOAuth1Signature_setHttpRequestMethod},
    {sipName_setParameters, meth_QOAuth1Signature_setParameters, METH_VARARGS, doc_QOAuth1Signature_setParameters},
    {sipName_setTokenSecret, meth_QOAuth1Signature_setTokenSecret, METH_VARARGS, doc_QOAuth1Signature_setTokenSecret},
    {sipName_setUrl, meth_QOAuth1Signature_setUrl, METH_VARARGS, doc_QOAuth1Signature_setUrl},
    {sipName_swap, meth_QOAuth1Signature_swap, METH_VARARGS, doc_QOAuth1Signature_swap},
    {sipName_take, meth_QOAuth1Signature_take, METH_VARARGS, doc_QOAuth1Signature_take},
    {sipName_tokenSecret, meth_QOAuth1Signature_tokenSecret, METH_VARARGS, doc_QOAuth1Signature_tokenSecret},
    {sipName_url, meth_QOAuth1Signature_url, METH_VARARGS, doc_QOAuth1Signature_url},
    {sipName_value, SIP_MLMETH_CAST(meth_QOAuth1Signature_value), METH_VARARGS|METH_KEYWORDS, doc_QOAuth1Signature_value}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QOAuth1Signature[] = {
    {sipName_Head, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Head)},
    {sipName_Get, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Get)},
    {sipName_Put, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Put)},
    {sipName_Post, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Post)},
    {sipName_Delete, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Delete)},
    {sipName_Custom, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Custom)},
    {sipName_Unknown, static_cast<int>(::QOAuth1Signature::HttpRequestMethod::Unknown)},
    {0, 0}
};

PyDoc_STRVAR(doc_QOAuth1Signature, "\1QOAuth1Signature(url: QUrl = QUrl(), method: QOAuth1Signature.HttpRequestMethod = QOAuth1Signature.HttpRequestMethod.Post, parameters: dict[Optional[str], Sequence[Any]] = {})\n"
"QOAuth1Signature(url: QUrl, clientSharedKey: Optional[str], tokenSecret: Optional[str], method: QOAuth1Signature.HttpRequestMethod = QOAuth1Signature.HttpRequestMethod.Post, parameters: dict[Optional[str], Sequence[Any]] = {})\n"
"QOAuth1Signature(other: QOAuth1Signature)");


sipClassTypeDef sipTypeDef_QtNetworkAuth_QOAuth1Signature = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QOAuth1Signature,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QOAuth1Signature,
        {0, 0, 1},
        21, methods_QOAuth1Signature,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QOAuth1Signature, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QOAuth1Signature,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QOAuth1Signature,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QOAuth1Signature,
    assign_QOAuth1Signature,
    array_QOAuth1Signature,
    copy_QOAuth1Signature,
    release_QOAuth1Signature,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QOAuth1Signature,
    sizeof (::QOAuth1Signature),
};
