/* DBusManager.c generated by valac 0.56.17, the Vala compiler
 * generated from DBusManager.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "plank.h"
#include <gee.h>

#define PLANK_DBUS_DOCK_INTERFACE_NAME "net.launchpad.plank"
#define PLANK_DBUS_PING_NAME "Ping"
#define PLANK_DBUS_CLIENT_INTERFACE_NAME "net.launchpad.plank.Client"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PLANK_TYPE_DBUS_ITEMS_IFACE (plank_dbus_items_iface_get_type ())
#define PLANK_DBUS_ITEMS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE, PlankDBusItemsIface))
#define PLANK_IS_DBUS_ITEMS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE))
#define PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE, PlankDBusItemsIfaceIface))

typedef struct _PlankDBusItemsIface PlankDBusItemsIface;
typedef struct _PlankDBusItemsIfaceIface PlankDBusItemsIfaceIface;

#define PLANK_TYPE_DBUS_ITEMS_IFACE_PROXY (plank_dbus_items_iface_proxy_get_type ())

#define PLANK_TYPE_DBUS_ITEMS (plank_dbus_items_get_type ())
#define PLANK_DBUS_ITEMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_TYPE_DBUS_ITEMS, PlankDBusItems))
#define PLANK_DBUS_ITEMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLANK_TYPE_DBUS_ITEMS, PlankDBusItemsClass))
#define PLANK_IS_DBUS_ITEMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_TYPE_DBUS_ITEMS))
#define PLANK_IS_DBUS_ITEMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLANK_TYPE_DBUS_ITEMS))
#define PLANK_DBUS_ITEMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLANK_TYPE_DBUS_ITEMS, PlankDBusItemsClass))

typedef struct _PlankDBusItems PlankDBusItems;
typedef struct _PlankDBusItemsClass PlankDBusItemsClass;
typedef struct _PlankDBusItemsPrivate PlankDBusItemsPrivate;
enum  {
	PLANK_DBUS_ITEMS_0_PROPERTY,
	PLANK_DBUS_ITEMS_NUM_PROPERTIES
};
static GParamSpec* plank_dbus_items_properties[PLANK_DBUS_ITEMS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLANK_DBUS_MANAGER_0_PROPERTY,
	PLANK_DBUS_MANAGER_CONTROLLER_PROPERTY,
	PLANK_DBUS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* plank_dbus_manager_properties[PLANK_DBUS_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PlankDBusItemsIfaceIface {
	GTypeInterface parent_iface;
	gboolean (*add) (PlankDBusItemsIface* self, const gchar* uri, GError** error);
	gboolean (*remove) (PlankDBusItemsIface* self, const gchar* uri, GError** error);
	gint (*get_count) (PlankDBusItemsIface* self, GError** error);
	gchar** (*get_persistent_applications) (PlankDBusItemsIface* self, gint* result_length1, GError** error);
	gchar** (*get_transient_applications) (PlankDBusItemsIface* self, gint* result_length1, GError** error);
	gboolean (*get_hover_position) (PlankDBusItemsIface* self, const gchar* uri, gint* x, gint* y, GtkPositionType* dock_position, GError** error);
};

struct _PlankDBusItems {
	GObject parent_instance;
	PlankDBusItemsPrivate * priv;
};

struct _PlankDBusItemsClass {
	GObjectClass parent_class;
};

struct _PlankDBusItemsPrivate {
	PlankDockController* controller;
	guint changed_timer_id;
};

struct _PlankDBusManagerPrivate {
	PlankDockController* _controller;
	GDBusConnection* connection;
	gchar* dock_object_path;
	guint dbus_items_signal_id;
	guint dbus_client_ping_signal_id;
};

static gint PlankDBusItems_private_offset;
static gpointer plank_dbus_items_parent_class = NULL;
static PlankDBusItemsIfaceIface * plank_dbus_items_plank_dbus_items_iface_parent_iface = NULL;
static gint PlankDBusManager_private_offset;
static gpointer plank_dbus_manager_parent_class = NULL;

VALA_EXTERN GType plank_dbus_items_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint plank_dbus_items_iface_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType plank_dbus_items_iface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType plank_dbus_items_get_type (void) G_GNUC_CONST ;
static void plank_dbus_items_handle_elements_changed (PlankDBusItems* self);
static void _plank_dbus_items_handle_elements_changed_plank_dock_container_elements_changed (PlankDockContainer* _sender,
                                                                                      GeeList* added,
                                                                                      GeeList* removed,
                                                                                      gpointer self);
VALA_EXTERN PlankDBusItems* plank_dbus_items_new (PlankDockController* _controller);
VALA_EXTERN PlankDBusItems* plank_dbus_items_construct (GType object_type,
                                            PlankDockController* _controller);
static gboolean __lambda64_ (PlankDBusItems* self);
static gboolean ___lambda64__gsource_func (gpointer self);
static gboolean plank_dbus_items_real_add (PlankDBusItemsIface* base,
                                    const gchar* uri,
                                    GError** error);
static gboolean plank_dbus_items_real_remove (PlankDBusItemsIface* base,
                                       const gchar* uri,
                                       GError** error);
static gint plank_dbus_items_real_get_count (PlankDBusItemsIface* base,
                                      GError** error);
static gchar** plank_dbus_items_real_get_persistent_applications (PlankDBusItemsIface* base,
                                                           gint* result_length1,
                                                           GError** error);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** plank_dbus_items_real_get_transient_applications (PlankDBusItemsIface* base,
                                                          gint* result_length1,
                                                          GError** error);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean plank_dbus_items_real_get_hover_position (PlankDBusItemsIface* base,
                                                   const gchar* uri,
                                                   gint* x,
                                                   gint* y,
                                                   GtkPositionType* dock_position,
                                                   GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_add (PlankDBusItemsIface* self,
                                     const gchar* uri,
                                     GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_remove (PlankDBusItemsIface* self,
                                        const gchar* uri,
                                        GError** error);
VALA_EXTERN gint plank_dbus_items_iface_get_count (PlankDBusItemsIface* self,
                                       GError** error);
VALA_EXTERN gchar** plank_dbus_items_iface_get_persistent_applications (PlankDBusItemsIface* self,
                                                            gint* result_length1,
                                                            GError** error);
VALA_EXTERN gchar** plank_dbus_items_iface_get_transient_applications (PlankDBusItemsIface* self,
                                                           gint* result_length1,
                                                           GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_get_hover_position (PlankDBusItemsIface* self,
                                                    const gchar* uri,
                                                    gint* x,
                                                    gint* y,
                                                    GtkPositionType* dock_position,
                                                    GError** error);
static void plank_dbus_items_finalize (GObject * obj);
static GType plank_dbus_items_get_type_once (void);
static void plank_dbus_manager_handle_client_ping (GDBusConnection* connection,
                                            const gchar* sender_name,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* signal_name,
                                            GVariant* parameters,
                                            PlankDBusManager* self);
static PlankDockController* plank_dbus_manager_get_controller (PlankDBusManager* self);
static GObject * plank_dbus_manager_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void plank_dbus_manager_finalize (GObject * obj);
static GType plank_dbus_manager_get_type_once (void);
static void _vala_plank_dbus_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_plank_dbus_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
plank_dbus_items_get_instance_private (PlankDBusItems* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDBusItems_private_offset);
}

static void
_plank_dbus_items_handle_elements_changed_plank_dock_container_elements_changed (PlankDockContainer* _sender,
                                                                                 GeeList* added,
                                                                                 GeeList* removed,
                                                                                 gpointer self)
{
	plank_dbus_items_handle_elements_changed ((PlankDBusItems*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PlankDBusItems*
plank_dbus_items_construct (GType object_type,
                            PlankDockController* _controller)
{
	PlankDBusItems * self = NULL;
	PlankDockController* _tmp0_;
	PlankDockController* _tmp1_;
	g_return_val_if_fail (_controller != NULL, NULL);
	self = (PlankDBusItems*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (_controller);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp0_;
	_tmp1_ = self->priv->controller;
	g_signal_connect_object ((PlankDockContainer*) _tmp1_, "elements-changed", (GCallback) _plank_dbus_items_handle_elements_changed_plank_dock_container_elements_changed, self, 0);
	return self;
}

PlankDBusItems*
plank_dbus_items_new (PlankDockController* _controller)
{
	return plank_dbus_items_construct (PLANK_TYPE_DBUS_ITEMS, _controller);
}

static gboolean
__lambda64_ (PlankDBusItems* self)
{
	gboolean result;
	self->priv->changed_timer_id = 0U;
	g_signal_emit_by_name ((PlankDBusItemsIface*) self, "changed");
	result = FALSE;
	return result;
}

static gboolean
___lambda64__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda64_ ((PlankDBusItems*) self);
	return result;
}

static void
plank_dbus_items_handle_elements_changed (PlankDBusItems* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->changed_timer_id > 0U) {
		return;
	}
	self->priv->changed_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda64__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
plank_dbus_items_real_add (PlankDBusItemsIface* base,
                           const gchar* uri,
                           GError** error)
{
	PlankDBusItems * self;
	PlankApplicationDockItemProvider* provider = NULL;
	PlankDockController* _tmp0_;
	PlankDockItemProvider* _tmp1_;
	PlankDockItemProvider* _tmp2_;
	PlankApplicationDockItemProvider* _tmp3_;
	PlankDockItem* item = NULL;
	PlankApplicationDockItemProvider* _tmp4_;
	PlankDockItem* _tmp5_;
	gboolean _tmp6_ = FALSE;
	PlankDockItem* _tmp7_;
	PlankApplicationDockItemProvider* _tmp10_;
	gboolean result;
	self = (PlankDBusItems*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_debug ("DBusManager.vala:61: Try to remotely add '%s'", uri);
	_tmp0_ = self->priv->controller;
	_tmp1_ = plank_dock_controller_get_default_provider (_tmp0_);
	_tmp2_ = _tmp1_;
	provider = PLANK_IS_APPLICATION_DOCK_ITEM_PROVIDER (_tmp2_) ? ((PlankApplicationDockItemProvider*) _tmp2_) : NULL;
	_tmp3_ = provider;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp4_ = provider;
	_tmp5_ = plank_dock_item_provider_item_for_uri ((PlankDockItemProvider*) _tmp4_, uri);
	item = _tmp5_;
	_tmp7_ = item;
	if (_tmp7_ != NULL) {
		PlankDockItem* _tmp8_;
		_tmp8_ = item;
		_tmp6_ = PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		PlankDockItem* _tmp9_;
		_tmp9_ = item;
		g_signal_emit_by_name ((PlankApplicationDockItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, PLANK_TYPE_TRANSIENT_DOCK_ITEM, PlankTransientDockItem), "pin-launcher");
		result = TRUE;
		return result;
	}
	_tmp10_ = provider;
	result = plank_dock_item_provider_add_item_with_uri ((PlankDockItemProvider*) _tmp10_, uri, NULL);
	return result;
}

static gboolean
plank_dbus_items_real_remove (PlankDBusItemsIface* base,
                              const gchar* uri,
                              GError** error)
{
	PlankDBusItems * self;
	PlankApplicationDockItemProvider* provider = NULL;
	PlankDockController* _tmp0_;
	PlankDockItemProvider* _tmp1_;
	PlankDockItemProvider* _tmp2_;
	PlankApplicationDockItemProvider* _tmp3_;
	PlankDockItem* item = NULL;
	PlankApplicationDockItemProvider* _tmp4_;
	PlankDockItem* _tmp5_;
	PlankDockItem* _tmp6_;
	PlankDockItem* _tmp7_;
	PlankApplicationDockItemProvider* _tmp10_;
	PlankDockItem* _tmp11_;
	gboolean result;
	self = (PlankDBusItems*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_debug ("DBusManager.vala:78: Try to remotely remove '%s'", uri);
	_tmp0_ = self->priv->controller;
	_tmp1_ = plank_dock_controller_get_default_provider (_tmp0_);
	_tmp2_ = _tmp1_;
	provider = PLANK_IS_APPLICATION_DOCK_ITEM_PROVIDER (_tmp2_) ? ((PlankApplicationDockItemProvider*) _tmp2_) : NULL;
	_tmp3_ = provider;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp4_ = provider;
	_tmp5_ = plank_dock_item_provider_item_for_uri ((PlankDockItemProvider*) _tmp4_, uri);
	item = _tmp5_;
	_tmp6_ = item;
	if (_tmp6_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp7_ = item;
	if (PLANK_IS_APPLICATION_DOCK_ITEM (_tmp7_)) {
		PlankDockItem* _tmp8_;
		_tmp8_ = item;
		if (!PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp8_)) {
			PlankDockItem* _tmp9_;
			_tmp9_ = item;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, PLANK_TYPE_APPLICATION_DOCK_ITEM, PlankApplicationDockItem), "pin-launcher");
		}
		result = TRUE;
		return result;
	}
	_tmp10_ = provider;
	_tmp11_ = item;
	result = plank_dock_container_remove ((PlankDockContainer*) _tmp10_, (PlankDockElement*) _tmp11_);
	return result;
}

static gint
plank_dbus_items_real_get_count (PlankDBusItemsIface* base,
                                 GError** error)
{
	PlankDBusItems * self;
	PlankDockController* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint result;
	self = (PlankDBusItems*) base;
	_tmp0_ = self->priv->controller;
	_tmp1_ = plank_dock_controller_get_VisibleItems (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
plank_dbus_items_real_get_persistent_applications (PlankDBusItemsIface* base,
                                                   gint* result_length1,
                                                   GError** error)
{
	PlankDBusItems * self;
	GeeArrayList* items = NULL;
	PlankDockController* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar** _result_ = NULL;
	gchar** _tmp4_;
	gint _result__length1;
	gint __result__size_;
	const gchar* launcher = NULL;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** result;
	self = (PlankDBusItems*) base;
	plank_logger_verbose ("Remotely list persistent items", NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = plank_dock_controller_get_Items (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	items = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp4_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp5_;
		gint _item_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = items;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_ = FALSE;
			PlankDockItem* _tmp14_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
			item = (PlankDockItem*) _tmp12_;
			_tmp14_ = item;
			if (PLANK_IS_APPLICATION_DOCK_ITEM (_tmp14_)) {
				PlankDockItem* _tmp15_;
				_tmp15_ = item;
				_tmp13_ = !PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp15_);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				PlankDockItem* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				_tmp16_ = item;
				_tmp17_ = plank_dock_item_get_Launcher (_tmp16_);
				_tmp18_ = _tmp17_;
				launcher = _tmp18_;
				_tmp20_ = launcher;
				if (_tmp20_ != NULL) {
					const gchar* _tmp21_;
					_tmp21_ = launcher;
					_tmp19_ = g_strcmp0 (_tmp21_, "") != 0;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp22_ = launcher;
					_tmp23_ = g_strdup (_tmp22_);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp23_);
				}
			}
		}
	}
	_tmp24_ = _result_;
	_tmp24__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	_g_object_unref0 (items);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
plank_dbus_items_real_get_transient_applications (PlankDBusItemsIface* base,
                                                  gint* result_length1,
                                                  GError** error)
{
	PlankDBusItems * self;
	GeeArrayList* items = NULL;
	PlankDockController* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar** _result_ = NULL;
	gchar** _tmp4_;
	gint _result__length1;
	gint __result__size_;
	const gchar* launcher = NULL;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result;
	self = (PlankDBusItems*) base;
	plank_logger_verbose ("Remotely list transient items", NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = plank_dock_controller_get_Items (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	items = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp4_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp5_;
		gint _item_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = items;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			PlankDockItem* _tmp13_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
			item = (PlankDockItem*) _tmp12_;
			_tmp13_ = item;
			if (PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp13_)) {
				PlankDockItem* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				_tmp14_ = item;
				_tmp15_ = plank_dock_item_get_Launcher (_tmp14_);
				_tmp16_ = _tmp15_;
				launcher = _tmp16_;
				_tmp18_ = launcher;
				if (_tmp18_ != NULL) {
					const gchar* _tmp19_;
					_tmp19_ = launcher;
					_tmp17_ = g_strcmp0 (_tmp19_, "") != 0;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = launcher;
					_tmp21_ = g_strdup (_tmp20_);
					_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp21_);
				}
			}
		}
	}
	_tmp22_ = _result_;
	_tmp22__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_g_object_unref0 (items);
	return result;
}

static gboolean
plank_dbus_items_real_get_hover_position (PlankDBusItemsIface* base,
                                          const gchar* uri,
                                          gint* x,
                                          gint* y,
                                          GtkPositionType* dock_position,
                                          GError** error)
{
	PlankDBusItems * self;
	gint _vala_x = 0;
	gint _vala_y = 0;
	GtkPositionType _vala_dock_position = 0;
	GeeArrayList* items = NULL;
	PlankDockController* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	PlankDockItem* found = NULL;
	PlankDockItem* _tmp16_;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp17_;
	PlankPositionManager* _tmp18_;
	PlankPositionManager* _tmp19_;
	PlankPositionManager* _tmp20_;
	PlankDockItem* _tmp21_;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	PlankPositionManager* _tmp24_;
	GtkPositionType _tmp25_;
	GtkPositionType _tmp26_;
	gboolean result;
	self = (PlankDBusItems*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->controller;
	_tmp1_ = plank_dock_controller_get_Items (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	items = _tmp3_;
	found = NULL;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp4_;
		gint _item_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _item_index = 0;
		_tmp4_ = items;
		_item_list = _tmp4_;
		_tmp5_ = _item_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_item_size = _tmp7_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			PlankDockItem* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_item_index = _item_index + 1;
			_tmp8_ = _item_index;
			_tmp9_ = _item_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _item_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _item_index);
			item = (PlankDockItem*) _tmp11_;
			_tmp12_ = item;
			_tmp13_ = plank_dock_item_get_Launcher (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (uri, _tmp14_) == 0) {
				PlankDockItem* _tmp15_;
				_tmp15_ = item;
				found = _tmp15_;
				break;
			}
		}
	}
	_tmp16_ = found;
	if (_tmp16_ == NULL) {
		_vala_y = -1;
		_vala_x = _vala_y;
		_vala_dock_position = 0;
		result = FALSE;
		_g_object_unref0 (items);
		if (x) {
			*x = _vala_x;
		}
		if (y) {
			*y = _vala_y;
		}
		if (dock_position) {
			*dock_position = _vala_dock_position;
		}
		return result;
	}
	_tmp17_ = self->priv->controller;
	_tmp18_ = plank_dock_controller_get_position_manager (_tmp17_);
	_tmp19_ = _tmp18_;
	position_manager = _tmp19_;
	_tmp20_ = position_manager;
	_tmp21_ = found;
	plank_position_manager_get_hover_position (_tmp20_, _tmp21_, &_tmp22_, &_tmp23_);
	_vala_x = _tmp22_;
	_vala_y = _tmp23_;
	_tmp24_ = position_manager;
	_tmp25_ = plank_position_manager_get_Position (_tmp24_);
	_tmp26_ = _tmp25_;
	_vala_dock_position = _tmp26_;
	result = TRUE;
	_g_object_unref0 (items);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (dock_position) {
		*dock_position = _vala_dock_position;
	}
	return result;
}

static void
plank_dbus_items_class_init (PlankDBusItemsClass * klass,
                             gpointer klass_data)
{
	plank_dbus_items_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDBusItems_private_offset);
	G_OBJECT_CLASS (klass)->finalize = plank_dbus_items_finalize;
}

static void
plank_dbus_items_plank_dbus_items_iface_interface_init (PlankDBusItemsIfaceIface * iface,
                                                        gpointer iface_data)
{
	plank_dbus_items_plank_dbus_items_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->add = (gboolean (*) (PlankDBusItemsIface*, const gchar*, GError**)) plank_dbus_items_real_add;
	iface->remove = (gboolean (*) (PlankDBusItemsIface*, const gchar*, GError**)) plank_dbus_items_real_remove;
	iface->get_count = (gint (*) (PlankDBusItemsIface*, GError**)) plank_dbus_items_real_get_count;
	iface->get_persistent_applications = (gchar** (*) (PlankDBusItemsIface*, gint*, GError**)) plank_dbus_items_real_get_persistent_applications;
	iface->get_transient_applications = (gchar** (*) (PlankDBusItemsIface*, gint*, GError**)) plank_dbus_items_real_get_transient_applications;
	iface->get_hover_position = (gboolean (*) (PlankDBusItemsIface*, const gchar*, gint*, gint*, GtkPositionType*, GError**)) plank_dbus_items_real_get_hover_position;
}

static void
plank_dbus_items_instance_init (PlankDBusItems * self,
                                gpointer klass)
{
	self->priv = plank_dbus_items_get_instance_private (self);
	self->priv->changed_timer_id = 0U;
}

static void
plank_dbus_items_finalize (GObject * obj)
{
	PlankDBusItems * self;
	PlankDockController* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DBUS_ITEMS, PlankDBusItems);
	_tmp0_ = self->priv->controller;
	g_signal_parse_name ("elements-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_dbus_items_handle_elements_changed_plank_dock_container_elements_changed, self);
	if (self->priv->changed_timer_id > 0U) {
		g_source_remove (self->priv->changed_timer_id);
		self->priv->changed_timer_id = 0U;
	}
	_g_object_unref0 (self->priv->controller);
	G_OBJECT_CLASS (plank_dbus_items_parent_class)->finalize (obj);
}

/**
 * Provide an interface to manage items of the dock
 */
static GType
plank_dbus_items_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDBusItemsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dbus_items_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDBusItems), 0, (GInstanceInitFunc) plank_dbus_items_instance_init, NULL };
	static const GInterfaceInfo plank_dbus_items_iface_info = { (GInterfaceInitFunc) plank_dbus_items_plank_dbus_items_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plank_dbus_items_type_id;
	plank_dbus_items_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDBusItems", &g_define_type_info, 0);
	g_type_add_interface_static (plank_dbus_items_type_id, PLANK_TYPE_DBUS_ITEMS_IFACE, &plank_dbus_items_iface_info);
	PlankDBusItems_private_offset = g_type_add_instance_private (plank_dbus_items_type_id, sizeof (PlankDBusItemsPrivate));
	return plank_dbus_items_type_id;
}

GType
plank_dbus_items_get_type (void)
{
	static volatile gsize plank_dbus_items_type_id__once = 0;
	if (g_once_init_enter (&plank_dbus_items_type_id__once)) {
		GType plank_dbus_items_type_id;
		plank_dbus_items_type_id = plank_dbus_items_get_type_once ();
		g_once_init_leave (&plank_dbus_items_type_id__once, plank_dbus_items_type_id);
	}
	return plank_dbus_items_type_id__once;
}

static inline gpointer
plank_dbus_manager_get_instance_private (PlankDBusManager* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDBusManager_private_offset);
}

PlankDBusManager*
plank_dbus_manager_construct (GType object_type,
                              PlankDockController* controller)
{
	PlankDBusManager * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (PlankDBusManager*) g_object_new (object_type, "controller", controller, NULL);
	return self;
}

PlankDBusManager*
plank_dbus_manager_new (PlankDockController* controller)
{
	return plank_dbus_manager_construct (PLANK_TYPE_DBUS_MANAGER, controller);
}

static void
plank_dbus_manager_handle_client_ping (GDBusConnection* connection,
                                       const gchar* sender_name,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* signal_name,
                                       GVariant* parameters,
                                       PlankDBusManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	{
		const gchar* _tmp0_;
		_tmp0_ = self->priv->dock_object_path;
		g_dbus_connection_emit_signal (connection, NULL, _tmp0_, PLANK_DBUS_DOCK_INTERFACE_NAME, PLANK_DBUS_PING_NAME, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("DBusManager.vala:242: Could not ping running clients (%s)", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static PlankDockController*
plank_dbus_manager_get_controller (PlankDBusManager* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
plank_dbus_manager_set_controller (PlankDBusManager* self,
                                   PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dbus_manager_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dbus_manager_properties[PLANK_DBUS_MANAGER_CONTROLLER_PROPERTY]);
	}
}

static GObject *
plank_dbus_manager_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDBusManager * self;
	GApplication* application = NULL;
	GApplication* _tmp0_;
	gchar* object_path = NULL;
	GApplication* _tmp1_;
	GDBusConnection* _tmp2_;
	GDBusConnection* _tmp3_;
	GApplication* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GDBusConnection* _tmp8_;
	const gchar* _tmp10_;
	PlankDockController* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (plank_dbus_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DBUS_MANAGER, PlankDBusManager);
	_tmp0_ = g_application_get_default ();
	application = _tmp0_;
	_tmp1_ = application;
	_tmp2_ = g_application_get_dbus_connection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp3_;
	_tmp4_ = application;
	_tmp5_ = g_application_get_dbus_object_path (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (object_path);
	object_path = _tmp6_;
	_tmp8_ = self->priv->connection;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = object_path;
		_tmp7_ = _tmp9_ == NULL;
	}
	if (_tmp7_) {
		g_critical ("DBusManager.vala:192: Not able to register our interfaces");
		_g_free0 (object_path);
		return obj;
	}
	_tmp10_ = object_path;
	_tmp11_ = self->priv->_controller;
	_tmp12_ = plank_dock_controller_get_name (_tmp11_);
	_tmp13_ = _tmp12_;
	if (!g_str_has_suffix (_tmp10_, _tmp13_)) {
		const gchar* _tmp14_;
		PlankDockController* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp14_ = object_path;
		_tmp15_ = self->priv->_controller;
		_tmp16_ = plank_dock_controller_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s/%s", _tmp14_, _tmp17_);
		_g_free0 (object_path);
		object_path = _tmp18_;
	}
	{
		GDBusConnection* _tmp19_;
		_tmp19_ = self->priv->connection;
		self->priv->dbus_client_ping_signal_id = g_dbus_connection_signal_subscribe (_tmp19_, NULL, PLANK_DBUS_CLIENT_INTERFACE_NAME, PLANK_DBUS_PING_NAME, NULL, NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) plank_dbus_manager_handle_client_ping, g_object_ref (self), g_object_unref);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("DBusManager.vala:204: Could not subscribe for client signal (%s)", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	{
		PlankDBusItems* dbus_items = NULL;
		PlankDockController* _tmp22_;
		PlankDBusItems* _tmp23_;
		guint _tmp24_ = 0U;
		GDBusConnection* _tmp25_;
		const gchar* _tmp26_;
		PlankDBusItems* _tmp27_;
		guint _tmp28_;
		_tmp22_ = self->priv->_controller;
		_tmp23_ = plank_dbus_items_new (_tmp22_);
		dbus_items = _tmp23_;
		_tmp25_ = self->priv->connection;
		_tmp26_ = object_path;
		_tmp27_ = dbus_items;
		_tmp28_ = plank_dbus_items_iface_register_object ((PlankDBusItemsIface*) _tmp27_, _tmp25_, _tmp26_, &_inner_error0_);
		_tmp24_ = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dbus_items);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			_g_free0 (object_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		self->priv->dbus_items_signal_id = _tmp24_;
		_g_object_unref0 (dbus_items);
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("DBusManager.vala:211: Could not register service (%s)", _tmp30_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp31_ = object_path;
	object_path = NULL;
	_g_free0 (self->priv->dock_object_path);
	self->priv->dock_object_path = _tmp31_;
	{
		GDBusConnection* _tmp32_;
		const gchar* _tmp33_;
		_tmp32_ = self->priv->connection;
		_tmp33_ = self->priv->dock_object_path;
		g_dbus_connection_emit_signal (_tmp32_, NULL, _tmp33_, PLANK_DBUS_DOCK_INTERFACE_NAME, PLANK_DBUS_PING_NAME, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		g_warning ("DBusManager.vala:220: Could not ping running clients (%s)", _tmp35_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_free0 (object_path);
	return obj;
}

static void
plank_dbus_manager_class_init (PlankDBusManagerClass * klass,
                               gpointer klass_data)
{
	plank_dbus_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDBusManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dbus_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dbus_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dbus_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dbus_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DBUS_MANAGER_CONTROLLER_PROPERTY, plank_dbus_manager_properties[PLANK_DBUS_MANAGER_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
plank_dbus_manager_instance_init (PlankDBusManager * self,
                                  gpointer klass)
{
	self->priv = plank_dbus_manager_get_instance_private (self);
	self->priv->connection = NULL;
	self->priv->dbus_items_signal_id = 0U;
	self->priv->dbus_client_ping_signal_id = 0U;
}

static void
plank_dbus_manager_finalize (GObject * obj)
{
	PlankDBusManager * self;
	GDBusConnection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DBUS_MANAGER, PlankDBusManager);
	_tmp0_ = self->priv->connection;
	if (_tmp0_ != NULL) {
		if (self->priv->dbus_items_signal_id > 0U) {
			GDBusConnection* _tmp1_;
			_tmp1_ = self->priv->connection;
			g_dbus_connection_unregister_object (_tmp1_, self->priv->dbus_items_signal_id);
		}
		if (self->priv->dbus_client_ping_signal_id > 0U) {
			GDBusConnection* _tmp2_;
			_tmp2_ = self->priv->connection;
			g_dbus_connection_signal_unsubscribe (_tmp2_, self->priv->dbus_client_ping_signal_id);
		}
	}
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->connection);
	_g_free0 (self->priv->dock_object_path);
	G_OBJECT_CLASS (plank_dbus_manager_parent_class)->finalize (obj);
}

/**
 * Handles all the exported DBus functions of the dock
 */
static GType
plank_dbus_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDBusManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dbus_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDBusManager), 0, (GInstanceInitFunc) plank_dbus_manager_instance_init, NULL };
	GType plank_dbus_manager_type_id;
	plank_dbus_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDBusManager", &g_define_type_info, 0);
	PlankDBusManager_private_offset = g_type_add_instance_private (plank_dbus_manager_type_id, sizeof (PlankDBusManagerPrivate));
	return plank_dbus_manager_type_id;
}

GType
plank_dbus_manager_get_type (void)
{
	static volatile gsize plank_dbus_manager_type_id__once = 0;
	if (g_once_init_enter (&plank_dbus_manager_type_id__once)) {
		GType plank_dbus_manager_type_id;
		plank_dbus_manager_type_id = plank_dbus_manager_get_type_once ();
		g_once_init_leave (&plank_dbus_manager_type_id__once, plank_dbus_manager_type_id);
	}
	return plank_dbus_manager_type_id__once;
}

static void
_vala_plank_dbus_manager_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PlankDBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DBUS_MANAGER, PlankDBusManager);
	switch (property_id) {
		case PLANK_DBUS_MANAGER_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_dbus_manager_get_controller (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dbus_manager_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PlankDBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DBUS_MANAGER, PlankDBusManager);
	switch (property_id) {
		case PLANK_DBUS_MANAGER_CONTROLLER_PROPERTY:
		plank_dbus_manager_set_controller (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

