/* pdf.c generated by valac 0.56.17, the Vala compiler
 * generated from pdf.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <poppler.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PDFPC_RENDERER_TYPE_PDF (pdfpc_renderer_pdf_get_type ())
#define PDFPC_RENDERER_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf))
#define PDFPC_RENDERER_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))
#define PDFPC_RENDERER_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))

typedef struct _pdfpcRendererPdf pdfpcRendererPdf;
typedef struct _pdfpcRendererPdfClass pdfpcRendererPdfClass;
typedef struct _pdfpcRendererPdfPrivate pdfpcRendererPdfPrivate;

#define PDFPC_METADATA_TYPE_PDF (pdfpc_metadata_pdf_get_type ())
#define PDFPC_METADATA_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdf))
#define PDFPC_METADATA_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))
#define PDFPC_METADATA_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))

typedef struct _pdfpcMetadataPdf pdfpcMetadataPdf;
typedef struct _pdfpcMetadataPdfClass pdfpcMetadataPdfClass;

#define PDFPC_RENDERER_TYPE_CACHE (pdfpc_renderer_cache_get_type ())
#define PDFPC_RENDERER_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCache))
#define PDFPC_RENDERER_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCacheClass))
#define PDFPC_RENDERER_IS_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_CACHE))
#define PDFPC_RENDERER_IS_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_CACHE))
#define PDFPC_RENDERER_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_CACHE, pdfpcRendererCacheClass))

typedef struct _pdfpcRendererCache pdfpcRendererCache;
typedef struct _pdfpcRendererCacheClass pdfpcRendererCacheClass;
enum  {
	PDFPC_RENDERER_PDF_0_PROPERTY,
	PDFPC_RENDERER_PDF_METADATA_PROPERTY,
	PDFPC_RENDERER_PDF_CACHE_PROPERTY,
	PDFPC_RENDERER_PDF_NUM_PROPERTIES
};
static GParamSpec* pdfpc_renderer_pdf_properties[PDFPC_RENDERER_PDF_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PDFPC_PRESENTATION_CONTROLLER_TYPE_SCALED_RECTANGLE (pdfpc_presentation_controller_scaled_rectangle_get_type ())
typedef struct _pdfpcPresentationControllerScaledRectangle pdfpcPresentationControllerScaledRectangle;

#define PDFPC_RENDERER_TYPE_RENDER_ERROR (pdfpc_renderer_render_error_get_type ())

#define PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS (pdfpc_renderer_cached_page_props_get_type ())
#define PDFPC_RENDERER_CACHED_PAGE_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPageProps))
#define PDFPC_RENDERER_CACHED_PAGE_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPagePropsClass))
#define PDFPC_RENDERER_IS_CACHED_PAGE_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS))
#define PDFPC_RENDERER_IS_CACHED_PAGE_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS))
#define PDFPC_RENDERER_CACHED_PAGE_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_CACHED_PAGE_PROPS, pdfpcRendererCachedPagePropsClass))

typedef struct _pdfpcRendererCachedPageProps pdfpcRendererCachedPageProps;
typedef struct _pdfpcRendererCachedPagePropsClass pdfpcRendererCachedPagePropsClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _pdfpcRendererPdf {
	GObject parent_instance;
	pdfpcRendererPdfPrivate * priv;
};

struct _pdfpcRendererPdfClass {
	GObjectClass parent_class;
};

struct _pdfpcRendererPdfPrivate {
	pdfpcMetadataPdf* _metadata;
	pdfpcRendererCache* _cache;
};

struct _pdfpcPresentationControllerScaledRectangle {
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble height;
};

typedef enum  {
	PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST
} pdfpcRendererRenderError;
#define PDFPC_RENDERER_RENDER_ERROR pdfpc_renderer_render_error_quark ()

/**
     * Error domain used for every render error, which might occur
     */

static gint pdfpcRendererPdf_private_offset;
static gpointer pdfpc_renderer_pdf_parent_class = NULL;
VALA_EXTERN gboolean pdfpc_options_cache_debug;
VALA_EXTERN gint pdfpc_options_cache_min_rtime;
VALA_EXTERN gint pdfpc_options_cache_max_rtime;

VALA_EXTERN GType pdfpc_renderer_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererPdf, g_object_unref)
VALA_EXTERN GType pdfpc_metadata_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcMetadataPdf, g_object_unref)
VALA_EXTERN GType pdfpc_renderer_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererCache, g_object_unref)
VALA_EXTERN pdfpcRendererPdf* pdfpc_renderer_pdf_new (pdfpcMetadataPdf* metadata);
VALA_EXTERN pdfpcRendererPdf* pdfpc_renderer_pdf_construct (GType object_type,
                                                pdfpcMetadataPdf* metadata);
VALA_EXTERN void pdfpc_renderer_pdf_set_metadata (pdfpcRendererPdf* self,
                                      pdfpcMetadataPdf* value);
VALA_EXTERN pdfpcRendererCache* pdfpc_renderer_cache_new (void);
VALA_EXTERN pdfpcRendererCache* pdfpc_renderer_cache_construct (GType object_type);
VALA_EXTERN void pdfpc_renderer_pdf_set_cache (pdfpcRendererPdf* self,
                                   pdfpcRendererCache* value);
VALA_EXTERN GType pdfpc_presentation_controller_scaled_rectangle_get_type (void) G_GNUC_CONST ;
VALA_EXTERN pdfpcPresentationControllerScaledRectangle* pdfpc_presentation_controller_scaled_rectangle_dup (const pdfpcPresentationControllerScaledRectangle* self);
VALA_EXTERN void pdfpc_presentation_controller_scaled_rectangle_free (pdfpcPresentationControllerScaledRectangle* self);
VALA_EXTERN GQuark pdfpc_renderer_render_error_quark (void);
VALA_EXTERN GType pdfpc_renderer_render_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN cairo_surface_t* pdfpc_renderer_pdf_render (pdfpcRendererPdf* self,
                                            gint slide_number,
                                            gboolean notes_area,
                                            gint width,
                                            gint height,
                                            gboolean force_cache,
                                            gboolean permanent_cache,
                                            pdfpcPresentationControllerScaledRectangle* zoom_area,
                                            GError** error);
VALA_EXTERN pdfpcMetadataPdf* pdfpc_renderer_pdf_get_metadata (pdfpcRendererPdf* self);
VALA_EXTERN guint pdfpc_metadata_pdf_get_slide_count (pdfpcMetadataPdf* self);
VALA_EXTERN GType pdfpc_renderer_cached_page_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererCachedPageProps, g_object_unref)
VALA_EXTERN pdfpcRendererCachedPageProps* pdfpc_renderer_cached_page_props_new (guint index,
                                                                    guint width,
                                                                    guint height,
                                                                    gboolean notes_area);
VALA_EXTERN pdfpcRendererCachedPageProps* pdfpc_renderer_cached_page_props_construct (GType object_type,
                                                                          guint index,
                                                                          guint width,
                                                                          guint height,
                                                                          gboolean notes_area);
VALA_EXTERN pdfpcRendererCache* pdfpc_renderer_pdf_get_cache (pdfpcRendererPdf* self);
VALA_EXTERN cairo_surface_t* pdfpc_renderer_cache_retrieve (pdfpcRendererCache* self,
                                                pdfpcRendererCachedPageProps* props);
VALA_EXTERN PopplerDocument* pdfpc_metadata_pdf_get_document (pdfpcMetadataPdf* self);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_corrected_page_width (pdfpcMetadataPdf* self,
                                                     gdouble page_width);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_corrected_page_height (pdfpcMetadataPdf* self,
                                                      gdouble page_height);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_horizontal_offset (pdfpcMetadataPdf* self,
                                                  gboolean notes_area,
                                                  gdouble page_width);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_vertical_offset (pdfpcMetadataPdf* self,
                                                gboolean notes_area,
                                                gdouble page_height);
VALA_EXTERN void pdfpc_renderer_cache_store (pdfpcRendererCache* self,
                                 pdfpcRendererCachedPageProps* props,
                                 cairo_surface_t* surface,
                                 gboolean permanent);
VALA_EXTERN cairo_surface_t* pdfpc_renderer_pdf_fade_to_black (pdfpcRendererPdf* self,
                                                   gint width,
                                                   gint height);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_page_width (pdfpcMetadataPdf* self);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_page_height (pdfpcMetadataPdf* self);
VALA_EXTERN void pdfpc_renderer_pdf_invalidate_cache (pdfpcRendererPdf* self);
VALA_EXTERN void pdfpc_renderer_cache_invalidate (pdfpcRendererCache* self);
static void pdfpc_renderer_pdf_finalize (GObject * obj);
static GType pdfpc_renderer_pdf_get_type_once (void);
static void _vala_pdfpc_renderer_pdf_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_pdfpc_renderer_pdf_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
pdfpc_renderer_pdf_get_instance_private (pdfpcRendererPdf* self)
{
	return G_STRUCT_MEMBER_P (self, pdfpcRendererPdf_private_offset);
}

/**
         * Base constructor taking a pdf metadata object as well as the desired
         * render width and height as parameters.
         *
         * The pdf will always be rendered to fill up all available space. If
         * the proportions of the rendersize do not fit the proportions of the
         * pdf document the renderspace is filled up completely cutting of a
         * part of the pdf document.
         */
pdfpcRendererPdf*
pdfpc_renderer_pdf_construct (GType object_type,
                              pdfpcMetadataPdf* metadata)
{
	pdfpcRendererPdf * self = NULL;
	pdfpcRendererCache* _tmp0_;
	pdfpcRendererCache* _tmp1_;
	g_return_val_if_fail (metadata != NULL, NULL);
	self = (pdfpcRendererPdf*) g_object_new (object_type, NULL);
	pdfpc_renderer_pdf_set_metadata (self, metadata);
	_tmp0_ = pdfpc_renderer_cache_new ();
	_tmp1_ = _tmp0_;
	pdfpc_renderer_pdf_set_cache (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

pdfpcRendererPdf*
pdfpc_renderer_pdf_new (pdfpcMetadataPdf* metadata)
{
	return pdfpc_renderer_pdf_construct (PDFPC_RENDERER_TYPE_PDF, metadata);
}

/**
         * Render the given slide_number to a Cairo.ImageSurface and return it.
         *
         * If the requested slide is not available an
         * RenderError.SLIDE_DOES_NOT_EXIST error is thrown.
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

cairo_surface_t*
pdfpc_renderer_pdf_render (pdfpcRendererPdf* self,
                           gint slide_number,
                           gboolean notes_area,
                           gint width,
                           gint height,
                           gboolean force_cache,
                           gboolean permanent_cache,
                           pdfpcPresentationControllerScaledRectangle* zoom_area,
                           GError** error)
{
	pdfpcMetadataPdf* metadata = NULL;
	pdfpcMetadataPdf* _tmp0_;
	pdfpcMetadataPdf* _tmp1_;
	gboolean _tmp2_ = FALSE;
	pdfpcRendererCachedPageProps* props = NULL;
	GTimer* timer = NULL;
	GTimer* _tmp10_;
	PopplerPage* page = NULL;
	pdfpcMetadataPdf* _tmp11_;
	PopplerDocument* _tmp12_;
	PopplerDocument* _tmp13_;
	PopplerPage* _tmp14_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp15_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	gdouble full_page_width = 0.0;
	gdouble corrected_page_width = 0.0;
	gdouble full_page_height = 0.0;
	gdouble corrected_page_height = 0.0;
	PopplerPage* _tmp21_;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	pdfpcMetadataPdf* _tmp24_;
	pdfpcMetadataPdf* _tmp25_;
	gdouble scaling_factor = 0.0;
	gdouble h_offset = 0.0;
	gdouble v_offset = 0.0;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	pdfpcMetadataPdf* _tmp28_;
	pdfpcMetadataPdf* _tmp29_;
	PopplerPage* _tmp30_;
	cairo_t* _tmp31_;
	GTimer* _tmp32_;
	gdouble rtime = 0.0;
	GTimer* _tmp33_;
	gboolean _tmp34_ = FALSE;
	GError* _inner_error0_ = NULL;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	metadata = _tmp1_;
	if (slide_number < 0) {
		_tmp2_ = TRUE;
	} else {
		pdfpcMetadataPdf* _tmp3_;
		_tmp3_ = metadata;
		_tmp2_ = ((guint) slide_number) >= pdfpc_metadata_pdf_get_slide_count (_tmp3_);
	}
	if (_tmp2_) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (PDFPC_RENDERER_RENDER_ERROR, PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST, "The requested slide '%i' does not exist.", slide_number);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == PDFPC_RENDERER_RENDER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (metadata);
			return NULL;
		} else {
			_g_object_unref0 (metadata);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	props = NULL;
	if (zoom_area == NULL) {
		pdfpcRendererCachedPageProps* _tmp5_;
		cairo_surface_t* cache_content = NULL;
		pdfpcRendererCache* _tmp6_;
		pdfpcRendererCachedPageProps* _tmp7_;
		cairo_surface_t* _tmp8_;
		cairo_surface_t* _tmp9_;
		_tmp5_ = pdfpc_renderer_cached_page_props_new ((guint) slide_number, (guint) width, (guint) height, notes_area);
		_g_object_unref0 (props);
		props = _tmp5_;
		_tmp6_ = self->priv->_cache;
		_tmp7_ = props;
		_tmp8_ = pdfpc_renderer_cache_retrieve (_tmp6_, _tmp7_);
		_cairo_surface_destroy0 (cache_content);
		cache_content = _tmp8_;
		_tmp9_ = cache_content;
		if (_tmp9_ != NULL) {
			result = cache_content;
			_g_object_unref0 (props);
			_g_object_unref0 (metadata);
			return result;
		}
		_cairo_surface_destroy0 (cache_content);
	}
	_tmp10_ = g_timer_new ();
	timer = _tmp10_;
	_tmp11_ = metadata;
	_tmp12_ = pdfpc_metadata_pdf_get_document (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = poppler_document_get_page (_tmp13_, slide_number);
	page = _tmp14_;
	_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, width, height);
	surface = _tmp15_;
	_tmp16_ = surface;
	_tmp17_ = cairo_create (_tmp16_);
	cr = _tmp17_;
	_tmp18_ = cr;
	cairo_set_source_rgb (_tmp18_, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp19_ = cr;
	cairo_rectangle (_tmp19_, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	_tmp20_ = cr;
	cairo_fill (_tmp20_);
	_tmp21_ = page;
	poppler_page_get_size (_tmp21_, &_tmp22_, &_tmp23_);
	full_page_width = _tmp22_;
	full_page_height = _tmp23_;
	_tmp24_ = metadata;
	corrected_page_width = pdfpc_metadata_pdf_get_corrected_page_width (_tmp24_, full_page_width);
	_tmp25_ = metadata;
	corrected_page_height = pdfpc_metadata_pdf_get_corrected_page_height (_tmp25_, full_page_height);
	if ((width / corrected_page_width) < (height / corrected_page_height)) {
		scaling_factor = width / corrected_page_width;
		h_offset = (gdouble) 0;
		v_offset = ((height / scaling_factor) - corrected_page_height) / 2;
	} else {
		scaling_factor = height / corrected_page_height;
		h_offset = ((width / scaling_factor) - corrected_page_width) / 2;
		v_offset = (gdouble) 0;
	}
	if (zoom_area != NULL) {
		gdouble zoom = 0.0;
		gdouble h_zoom_offset = 0.0;
		gdouble v_zoom_offset = 0.0;
		if ((*zoom_area).width > (*zoom_area).height) {
			zoom = 1 / (*zoom_area).width;
			h_zoom_offset = (gdouble) 0;
			v_zoom_offset = ((*zoom_area).width - (*zoom_area).height) / 2;
		} else {
			zoom = 1 / (*zoom_area).height;
			h_zoom_offset = ((*zoom_area).height - (*zoom_area).width) / 2;
			v_zoom_offset = (gdouble) 0;
		}
		h_offset -= corrected_page_width * ((*zoom_area).x - h_zoom_offset);
		v_offset -= corrected_page_height * ((*zoom_area).y - v_zoom_offset);
		scaling_factor *= zoom;
	}
	_tmp26_ = cr;
	cairo_scale (_tmp26_, scaling_factor, scaling_factor);
	_tmp27_ = cr;
	_tmp28_ = metadata;
	_tmp29_ = metadata;
	cairo_translate (_tmp27_, (-pdfpc_metadata_pdf_get_horizontal_offset (_tmp28_, notes_area, full_page_width)) + h_offset, (-pdfpc_metadata_pdf_get_vertical_offset (_tmp29_, notes_area, full_page_height)) + v_offset);
	_tmp30_ = page;
	_tmp31_ = cr;
	poppler_page_render (_tmp30_, (cairo_t*) _tmp31_);
	_tmp32_ = timer;
	g_timer_stop (_tmp32_);
	_tmp33_ = timer;
	rtime = g_timer_elapsed (_tmp33_, NULL);
	if (pdfpc_options_cache_debug) {
		g_printerr ("Render time of [%d] (%dx%d) = %g s\n", slide_number, width, height, rtime);
	}
	if (zoom_area == NULL) {
		gboolean _tmp35_ = FALSE;
		if (force_cache) {
			_tmp35_ = TRUE;
		} else {
			_tmp35_ = rtime > (pdfpc_options_cache_min_rtime / 1000.0);
		}
		_tmp34_ = _tmp35_;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		pdfpcRendererCache* _tmp36_;
		pdfpcRendererCachedPageProps* _tmp37_;
		cairo_surface_t* _tmp38_;
		if (rtime > ((gdouble) pdfpc_options_cache_max_rtime)) {
			permanent_cache = TRUE;
		}
		_tmp36_ = self->priv->_cache;
		_tmp37_ = props;
		_tmp38_ = surface;
		pdfpc_renderer_cache_store (_tmp36_, _tmp37_, _tmp38_, permanent_cache);
	}
	result = surface;
	_cairo_destroy0 (cr);
	_g_object_unref0 (page);
	_g_timer_destroy0 (timer);
	_g_object_unref0 (props);
	_g_object_unref0 (metadata);
	return result;
}

cairo_surface_t*
pdfpc_renderer_pdf_fade_to_black (pdfpcRendererPdf* self,
                                  gint width,
                                  gint height)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* cr = NULL;
	cairo_t* _tmp1_;
	gdouble scaling_factor = 0.0;
	pdfpcMetadataPdf* _tmp2_;
	pdfpcMetadataPdf* _tmp3_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, width, height);
	surface = _tmp0_;
	_tmp1_ = cairo_create (surface);
	cr = _tmp1_;
	cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	cairo_fill (cr);
	_tmp2_ = self->priv->_metadata;
	_tmp3_ = self->priv->_metadata;
	scaling_factor = fmax (width / pdfpc_metadata_pdf_get_page_width (_tmp2_), height / pdfpc_metadata_pdf_get_page_height (_tmp3_));
	cairo_scale (cr, scaling_factor, scaling_factor);
	result = surface;
	_cairo_destroy0 (cr);
	return result;
}

/**
         * Invalidate the whole cache (if the document is reloaded/changed)
         */
void
pdfpc_renderer_pdf_invalidate_cache (pdfpcRendererPdf* self)
{
	pdfpcRendererCache* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cache;
	pdfpc_renderer_cache_invalidate (_tmp0_);
}

pdfpcMetadataPdf*
pdfpc_renderer_pdf_get_metadata (pdfpcRendererPdf* self)
{
	pdfpcMetadataPdf* result;
	pdfpcMetadataPdf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata;
	result = _tmp0_;
	return result;
}

void
pdfpc_renderer_pdf_set_metadata (pdfpcRendererPdf* self,
                                 pdfpcMetadataPdf* value)
{
	pdfpcMetadataPdf* old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_renderer_pdf_get_metadata (self);
	if (old_value != value) {
		pdfpcMetadataPdf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_metadata);
		self->priv->_metadata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_renderer_pdf_properties[PDFPC_RENDERER_PDF_METADATA_PROPERTY]);
	}
}

pdfpcRendererCache*
pdfpc_renderer_pdf_get_cache (pdfpcRendererPdf* self)
{
	pdfpcRendererCache* result;
	pdfpcRendererCache* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cache;
	result = _tmp0_;
	return result;
}

void
pdfpc_renderer_pdf_set_cache (pdfpcRendererPdf* self,
                              pdfpcRendererCache* value)
{
	pdfpcRendererCache* old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_renderer_pdf_get_cache (self);
	if (old_value != value) {
		pdfpcRendererCache* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cache);
		self->priv->_cache = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_renderer_pdf_properties[PDFPC_RENDERER_PDF_CACHE_PROPERTY]);
	}
}

static void
pdfpc_renderer_pdf_class_init (pdfpcRendererPdfClass * klass,
                               gpointer klass_data)
{
	pdfpc_renderer_pdf_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &pdfpcRendererPdf_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pdfpc_renderer_pdf_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pdfpc_renderer_pdf_set_property;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_renderer_pdf_finalize;
	/**
	         * Metadata object to render slides for
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_RENDERER_PDF_METADATA_PROPERTY, pdfpc_renderer_pdf_properties[PDFPC_RENDERER_PDF_METADATA_PROPERTY] = g_param_spec_object ("metadata", "metadata", "metadata", PDFPC_METADATA_TYPE_PDF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Cache store to be used
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_RENDERER_PDF_CACHE_PROPERTY, pdfpc_renderer_pdf_properties[PDFPC_RENDERER_PDF_CACHE_PROPERTY] = g_param_spec_object ("cache", "cache", "cache", PDFPC_RENDERER_TYPE_CACHE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pdfpc_renderer_pdf_instance_init (pdfpcRendererPdf * self,
                                  gpointer klass)
{
	self->priv = pdfpc_renderer_pdf_get_instance_private (self);
}

static void
pdfpc_renderer_pdf_finalize (GObject * obj)
{
	pdfpcRendererPdf * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf);
	_g_object_unref0 (self->priv->_metadata);
	_g_object_unref0 (self->priv->_cache);
	G_OBJECT_CLASS (pdfpc_renderer_pdf_parent_class)->finalize (obj);
}

/**
     * Pdf slide renderer
     */
static GType
pdfpc_renderer_pdf_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererPdfClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_pdf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererPdf), 0, (GInstanceInitFunc) pdfpc_renderer_pdf_instance_init, NULL };
	GType pdfpc_renderer_pdf_type_id;
	pdfpc_renderer_pdf_type_id = g_type_register_static (G_TYPE_OBJECT, "pdfpcRendererPdf", &g_define_type_info, 0);
	pdfpcRendererPdf_private_offset = g_type_add_instance_private (pdfpc_renderer_pdf_type_id, sizeof (pdfpcRendererPdfPrivate));
	return pdfpc_renderer_pdf_type_id;
}

GType
pdfpc_renderer_pdf_get_type (void)
{
	static volatile gsize pdfpc_renderer_pdf_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_renderer_pdf_type_id__once)) {
		GType pdfpc_renderer_pdf_type_id;
		pdfpc_renderer_pdf_type_id = pdfpc_renderer_pdf_get_type_once ();
		g_once_init_leave (&pdfpc_renderer_pdf_type_id__once, pdfpc_renderer_pdf_type_id);
	}
	return pdfpc_renderer_pdf_type_id__once;
}

static void
_vala_pdfpc_renderer_pdf_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	pdfpcRendererPdf * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf);
	switch (property_id) {
		case PDFPC_RENDERER_PDF_METADATA_PROPERTY:
		g_value_set_object (value, pdfpc_renderer_pdf_get_metadata (self));
		break;
		case PDFPC_RENDERER_PDF_CACHE_PROPERTY:
		g_value_set_object (value, pdfpc_renderer_pdf_get_cache (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pdfpc_renderer_pdf_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	pdfpcRendererPdf * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf);
	switch (property_id) {
		case PDFPC_RENDERER_PDF_METADATA_PROPERTY:
		pdfpc_renderer_pdf_set_metadata (self, g_value_get_object (value));
		break;
		case PDFPC_RENDERER_PDF_CACHE_PROPERTY:
		pdfpc_renderer_pdf_set_cache (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GQuark
pdfpc_renderer_render_error_quark (void)
{
	return g_quark_from_static_string ("pdfpc-renderer-render-error-quark");
}

static GType
pdfpc_renderer_render_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST, "PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST", "slide-does-not-exist"}, {0, NULL, NULL}};
	GType pdfpc_renderer_render_error_type_id;
	pdfpc_renderer_render_error_type_id = g_enum_register_static ("pdfpcRendererRenderError", values);
	return pdfpc_renderer_render_error_type_id;
}

GType
pdfpc_renderer_render_error_get_type (void)
{
	static volatile gsize pdfpc_renderer_render_error_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_renderer_render_error_type_id__once)) {
		GType pdfpc_renderer_render_error_type_id;
		pdfpc_renderer_render_error_type_id = pdfpc_renderer_render_error_get_type_once ();
		g_once_init_leave (&pdfpc_renderer_render_error_type_id__once, pdfpc_renderer_render_error_type_id);
	}
	return pdfpc_renderer_render_error_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

