/* InterfaceSettings.c generated by valac 0.56.18, the Vala compiler
 * generated from InterfaceSettings.vala, do not modify */

/*
 * Copyright 2023 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gstdio.h>

#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK "cursor-blink"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK_TIME "cursor-blink-time"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK_TIMEOUT "cursor-blink-timeout"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_SIZE "cursor-size"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_LOCATE_POINTER "locate-pointer"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_TEXT_SCALING_FACTOR "text-scaling-factor"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PICTURE_OPTIONS "picture-options"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PRIMARY_COLOR "primary-color"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PICTURE_URI "picture-uri"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DOCUMENT_FONT_NAME "document-font-name"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_FONT_NAME "font-name"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_MONOSPACE_FONT_NAME "monospace-font-name"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_LAST_COORDINATES "last-coordinates"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ORIENTATION_LOCK "orientation-lock"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE "prefer-dark-schedule"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE_FROM "prefer-dark-schedule-from"
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE_TO "prefer-dark-schedule-to"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS (settings_daemon_backends_interface_settings_get_type ())
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettings))
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettingsClass))
#define SETTINGS_DAEMON_BACKENDS_IS_INTERFACE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS))
#define SETTINGS_DAEMON_BACKENDS_IS_INTERFACE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS))
#define SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettingsClass))

typedef struct _SettingsDaemonBackendsInterfaceSettings SettingsDaemonBackendsInterfaceSettings;
typedef struct _SettingsDaemonBackendsInterfaceSettingsClass SettingsDaemonBackendsInterfaceSettingsClass;
typedef struct _SettingsDaemonBackendsInterfaceSettingsPrivate SettingsDaemonBackendsInterfaceSettingsPrivate;

#define SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE (settings_daemon_accounts_service_get_type ())
#define SETTINGS_DAEMON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, SettingsDaemonAccountsService))
#define SETTINGS_DAEMON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE))
#define SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, SettingsDaemonAccountsServiceIface))

typedef struct _SettingsDaemonAccountsService SettingsDaemonAccountsService;
typedef struct _SettingsDaemonAccountsServiceIface SettingsDaemonAccountsServiceIface;

#define SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_KEYBOARD_LAYOUT (settings_daemon_accounts_service_keyboard_layout_get_type ())
typedef struct _SettingsDaemonAccountsServiceKeyboardLayout SettingsDaemonAccountsServiceKeyboardLayout;

#define SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_XKB_OPTION (settings_daemon_accounts_service_xkb_option_get_type ())
typedef struct _SettingsDaemonAccountsServiceXkbOption SettingsDaemonAccountsServiceXkbOption;

#define SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_COORDINATES (settings_daemon_accounts_service_coordinates_get_type ())
typedef struct _SettingsDaemonAccountsServiceCoordinates SettingsDaemonAccountsServiceCoordinates;

#define SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY (settings_daemon_accounts_service_proxy_get_type ())

#define DISPLAY_MANAGER_TYPE_ACCOUNTS_SERVICE (display_manager_accounts_service_get_type ())
#define DISPLAY_MANAGER_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DISPLAY_MANAGER_TYPE_ACCOUNTS_SERVICE, DisplayManagerAccountsService))
#define DISPLAY_MANAGER_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DISPLAY_MANAGER_TYPE_ACCOUNTS_SERVICE))
#define DISPLAY_MANAGER_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DISPLAY_MANAGER_TYPE_ACCOUNTS_SERVICE, DisplayManagerAccountsServiceIface))

typedef struct _DisplayManagerAccountsService DisplayManagerAccountsService;
typedef struct _DisplayManagerAccountsServiceIface DisplayManagerAccountsServiceIface;

#define DISPLAY_MANAGER_TYPE_ACCOUNTS_SERVICE_PROXY (display_manager_accounts_service_proxy_get_type ())
enum  {
	SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_0_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ACCOUNTS_SERVICE_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DISPLAY_MANAGER_ACCOUNTS_SERVICE_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* settings_daemon_backends_interface_settings_properties[SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SettingsDaemonBackendsInterfaceSettings {
	GObject parent_instance;
	SettingsDaemonBackendsInterfaceSettingsPrivate * priv;
};

struct _SettingsDaemonBackendsInterfaceSettingsClass {
	GObjectClass parent_class;
};

struct _SettingsDaemonAccountsServiceKeyboardLayout {
	gchar* backend;
	gchar* name;
};

struct _SettingsDaemonAccountsServiceXkbOption {
	gchar* option;
};

struct _SettingsDaemonAccountsServiceCoordinates {
	gdouble latitude;
	gdouble longitude;
};

struct _SettingsDaemonAccountsServiceIface {
	GTypeInterface parent_iface;
	SettingsDaemonAccountsServiceKeyboardLayout* (*get_keyboard_layouts) (SettingsDaemonAccountsService* self, gint* result_length1);
	void (*set_keyboard_layouts) (SettingsDaemonAccountsService* self, SettingsDaemonAccountsServiceKeyboardLayout* value, gint value_length1);
	guint (*get_active_keyboard_layout) (SettingsDaemonAccountsService* self);
	void (*set_active_keyboard_layout) (SettingsDaemonAccountsService* self, guint value);
	SettingsDaemonAccountsServiceXkbOption* (*get_xkb_options) (SettingsDaemonAccountsService* self, gint* result_length1);
	void (*set_xkb_options) (SettingsDaemonAccountsService* self, SettingsDaemonAccountsServiceXkbOption* value, gint value_length1);
	gboolean (*get_left_handed) (SettingsDaemonAccountsService* self);
	void (*set_left_handed) (SettingsDaemonAccountsService* self, gboolean value);
	gint (*get_accel_profile) (SettingsDaemonAccountsService* self);
	void (*set_accel_profile) (SettingsDaemonAccountsService* self, gint value);
	gboolean (*get_mouse_natural_scroll) (SettingsDaemonAccountsService* self);
	void (*set_mouse_natural_scroll) (SettingsDaemonAccountsService* self, gboolean value);
	gdouble (*get_mouse_speed) (SettingsDaemonAccountsService* self);
	void (*set_mouse_speed) (SettingsDaemonAccountsService* self, gdouble value);
	gint (*get_touchpad_click_method) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_click_method) (SettingsDaemonAccountsService* self, gint value);
	gboolean (*get_touchpad_disable_while_typing) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_disable_while_typing) (SettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_touchpad_edge_scrolling) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_edge_scrolling) (SettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_touchpad_natural_scroll) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_natural_scroll) (SettingsDaemonAccountsService* self, gboolean value);
	gint (*get_touchpad_send_events) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_send_events) (SettingsDaemonAccountsService* self, gint value);
	gdouble (*get_touchpad_speed) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_speed) (SettingsDaemonAccountsService* self, gdouble value);
	gboolean (*get_touchpad_tap_to_click) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_tap_to_click) (SettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_touchpad_two_finger_scrolling) (SettingsDaemonAccountsService* self);
	void (*set_touchpad_two_finger_scrolling) (SettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_cursor_blink) (SettingsDaemonAccountsService* self);
	void (*set_cursor_blink) (SettingsDaemonAccountsService* self, gboolean value);
	gint (*get_cursor_blink_time) (SettingsDaemonAccountsService* self);
	void (*set_cursor_blink_time) (SettingsDaemonAccountsService* self, gint value);
	gint (*get_cursor_blink_timeout) (SettingsDaemonAccountsService* self);
	void (*set_cursor_blink_timeout) (SettingsDaemonAccountsService* self, gint value);
	gint (*get_cursor_size) (SettingsDaemonAccountsService* self);
	void (*set_cursor_size) (SettingsDaemonAccountsService* self, gint value);
	gboolean (*get_locate_pointer) (SettingsDaemonAccountsService* self);
	void (*set_locate_pointer) (SettingsDaemonAccountsService* self, gboolean value);
	gdouble (*get_text_scaling_factor) (SettingsDaemonAccountsService* self);
	void (*set_text_scaling_factor) (SettingsDaemonAccountsService* self, gdouble value);
	gint (*get_picture_options) (SettingsDaemonAccountsService* self);
	void (*set_picture_options) (SettingsDaemonAccountsService* self, gint value);
	gchar* (*get_primary_color) (SettingsDaemonAccountsService* self);
	void (*set_primary_color) (SettingsDaemonAccountsService* self, const gchar* value);
	gchar* (*get_document_font_name) (SettingsDaemonAccountsService* self);
	void (*set_document_font_name) (SettingsDaemonAccountsService* self, const gchar* value);
	gchar* (*get_font_name) (SettingsDaemonAccountsService* self);
	void (*set_font_name) (SettingsDaemonAccountsService* self, const gchar* value);
	gchar* (*get_monospace_font_name) (SettingsDaemonAccountsService* self);
	void (*set_monospace_font_name) (SettingsDaemonAccountsService* self, const gchar* value);
	gboolean (*get_orientation_lock) (SettingsDaemonAccountsService* self);
	void (*set_orientation_lock) (SettingsDaemonAccountsService* self, gboolean value);
	void (*get_last_coordinates) (SettingsDaemonAccountsService* self, SettingsDaemonAccountsServiceCoordinates * result);
	void (*set_last_coordinates) (SettingsDaemonAccountsService* self, SettingsDaemonAccountsServiceCoordinates * value);
	gint (*get_prefer_dark_schedule) (SettingsDaemonAccountsService* self);
	void (*set_prefer_dark_schedule) (SettingsDaemonAccountsService* self, gint value);
	gdouble (*get_prefer_dark_schedule_from) (SettingsDaemonAccountsService* self);
	void (*set_prefer_dark_schedule_from) (SettingsDaemonAccountsService* self, gdouble value);
	gdouble (*get_prefer_dark_schedule_to) (SettingsDaemonAccountsService* self);
	void (*set_prefer_dark_schedule_to) (SettingsDaemonAccountsService* self, gdouble value);
	gboolean (*get_night_light_enabled) (SettingsDaemonAccountsService* self);
	void (*set_night_light_enabled) (SettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_night_light_schedule_automatic) (SettingsDaemonAccountsService* self);
	void (*set_night_light_schedule_automatic) (SettingsDaemonAccountsService* self, gboolean value);
	gdouble (*get_night_light_schedule_from) (SettingsDaemonAccountsService* self);
	void (*set_night_light_schedule_from) (SettingsDaemonAccountsService* self, gdouble value);
	gdouble (*get_night_light_schedule_to) (SettingsDaemonAccountsService* self);
	void (*set_night_light_schedule_to) (SettingsDaemonAccountsService* self, gdouble value);
	guint (*get_night_light_temperature) (SettingsDaemonAccountsService* self);
	void (*set_night_light_temperature) (SettingsDaemonAccountsService* self, guint value);
};

struct _DisplayManagerAccountsServiceIface {
	GTypeInterface parent_iface;
	gchar* (*get_background_file) (DisplayManagerAccountsService* self);
	void (*set_background_file) (DisplayManagerAccountsService* self, const gchar* value);
};

struct _SettingsDaemonBackendsInterfaceSettingsPrivate {
	SettingsDaemonAccountsService* _accounts_service;
	DisplayManagerAccountsService* _display_manager_accounts_service;
	GSettings* interface_settings;
	GSettings* background_settings;
	GSettings* settings_daemon_settings;
	GSettings* touchscreen_settings;
};

static gint SettingsDaemonBackendsInterfaceSettings_private_offset;
static gpointer settings_daemon_backends_interface_settings_parent_class = NULL;

VALA_EXTERN GType settings_daemon_backends_interface_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonBackendsInterfaceSettings, g_object_unref)
VALA_EXTERN GType settings_daemon_accounts_service_keyboard_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsDaemonAccountsServiceKeyboardLayout* settings_daemon_accounts_service_keyboard_layout_dup (const SettingsDaemonAccountsServiceKeyboardLayout* self);
VALA_EXTERN void settings_daemon_accounts_service_keyboard_layout_free (SettingsDaemonAccountsServiceKeyboardLayout* self);
VALA_EXTERN void settings_daemon_accounts_service_keyboard_layout_copy (const SettingsDaemonAccountsServiceKeyboardLayout* self,
                                                            SettingsDaemonAccountsServiceKeyboardLayout* dest);
VALA_EXTERN void settings_daemon_accounts_service_keyboard_layout_destroy (SettingsDaemonAccountsServiceKeyboardLayout* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SettingsDaemonAccountsServiceKeyboardLayout, settings_daemon_accounts_service_keyboard_layout_destroy)
VALA_EXTERN GType settings_daemon_accounts_service_xkb_option_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsDaemonAccountsServiceXkbOption* settings_daemon_accounts_service_xkb_option_dup (const SettingsDaemonAccountsServiceXkbOption* self);
VALA_EXTERN void settings_daemon_accounts_service_xkb_option_free (SettingsDaemonAccountsServiceXkbOption* self);
VALA_EXTERN void settings_daemon_accounts_service_xkb_option_copy (const SettingsDaemonAccountsServiceXkbOption* self,
                                                       SettingsDaemonAccountsServiceXkbOption* dest);
VALA_EXTERN void settings_daemon_accounts_service_xkb_option_destroy (SettingsDaemonAccountsServiceXkbOption* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SettingsDaemonAccountsServiceXkbOption, settings_daemon_accounts_service_xkb_option_destroy)
VALA_EXTERN GType settings_daemon_accounts_service_coordinates_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsDaemonAccountsServiceCoordinates* settings_daemon_accounts_service_coordinates_dup (const SettingsDaemonAccountsServiceCoordinates* self);
VALA_EXTERN void settings_daemon_accounts_service_coordinates_free (SettingsDaemonAccountsServiceCoordinates* self);
VALA_EXTERN GType settings_daemon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonAccountsService, g_object_unref)
VALA_EXTERN GType settings_daemon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint settings_daemon_accounts_service_register_object (void* object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error);
VALA_EXTERN GType display_manager_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DisplayManagerAccountsService, g_object_unref)
VALA_EXTERN GType display_manager_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint display_manager_accounts_service_register_object (void* object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error);
VALA_EXTERN SettingsDaemonBackendsInterfaceSettings* settings_daemon_backends_interface_settings_new (SettingsDaemonAccountsService* accounts_service,
                                                                                          DisplayManagerAccountsService* display_manager_accounts_service);
VALA_EXTERN SettingsDaemonBackendsInterfaceSettings* settings_daemon_backends_interface_settings_construct (GType object_type,
                                                                                                SettingsDaemonAccountsService* accounts_service,
                                                                                                DisplayManagerAccountsService* display_manager_accounts_service);
static void settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice (SettingsDaemonBackendsInterfaceSettings* self);
VALA_EXTERN SettingsDaemonAccountsService* settings_daemon_backends_interface_settings_get_accounts_service (SettingsDaemonBackendsInterfaceSettings* self);
VALA_EXTERN void settings_daemon_accounts_service_set_cursor_blink (SettingsDaemonAccountsService* self,
                                                        gboolean value);
VALA_EXTERN void settings_daemon_accounts_service_set_cursor_blink_time (SettingsDaemonAccountsService* self,
                                                             gint value);
VALA_EXTERN void settings_daemon_accounts_service_set_cursor_blink_timeout (SettingsDaemonAccountsService* self,
                                                                gint value);
VALA_EXTERN void settings_daemon_accounts_service_set_cursor_size (SettingsDaemonAccountsService* self,
                                                       gint value);
VALA_EXTERN void settings_daemon_accounts_service_set_locate_pointer (SettingsDaemonAccountsService* self,
                                                          gboolean value);
VALA_EXTERN void settings_daemon_accounts_service_set_text_scaling_factor (SettingsDaemonAccountsService* self,
                                                               gdouble value);
VALA_EXTERN void settings_daemon_accounts_service_set_picture_options (SettingsDaemonAccountsService* self,
                                                           gint value);
VALA_EXTERN void settings_daemon_accounts_service_set_primary_color (SettingsDaemonAccountsService* self,
                                                         const gchar* value);
VALA_EXTERN void settings_daemon_accounts_service_set_document_font_name (SettingsDaemonAccountsService* self,
                                                              const gchar* value);
VALA_EXTERN void settings_daemon_accounts_service_set_font_name (SettingsDaemonAccountsService* self,
                                                     const gchar* value);
VALA_EXTERN void settings_daemon_accounts_service_set_monospace_font_name (SettingsDaemonAccountsService* self,
                                                               const gchar* value);
VALA_EXTERN void settings_daemon_accounts_service_set_last_coordinates (SettingsDaemonAccountsService* self,
                                                            SettingsDaemonAccountsServiceCoordinates * value);
VALA_EXTERN void settings_daemon_accounts_service_set_prefer_dark_schedule (SettingsDaemonAccountsService* self,
                                                                gint value);
VALA_EXTERN void settings_daemon_accounts_service_set_prefer_dark_schedule_from (SettingsDaemonAccountsService* self,
                                                                     gdouble value);
VALA_EXTERN void settings_daemon_accounts_service_set_prefer_dark_schedule_to (SettingsDaemonAccountsService* self,
                                                                   gdouble value);
VALA_EXTERN void settings_daemon_accounts_service_set_orientation_lock (SettingsDaemonAccountsService* self,
                                                            gboolean value);
static void settings_daemon_backends_interface_settings_sync_background_to_greeter (SettingsDaemonBackendsInterfaceSettings* self);
VALA_EXTERN DisplayManagerAccountsService* settings_daemon_backends_interface_settings_get_display_manager_accounts_service (SettingsDaemonBackendsInterfaceSettings* self);
VALA_EXTERN void display_manager_accounts_service_set_background_file (DisplayManagerAccountsService* self,
                                                           const gchar* value);
static void settings_daemon_backends_interface_settings_remove_directory (SettingsDaemonBackendsInterfaceSettings* self,
                                                                   GFile* directory);
static void settings_daemon_backends_interface_settings_set_accounts_service (SettingsDaemonBackendsInterfaceSettings* self,
                                                                       SettingsDaemonAccountsService* value);
static void settings_daemon_backends_interface_settings_set_display_manager_accounts_service (SettingsDaemonBackendsInterfaceSettings* self,
                                                                                       DisplayManagerAccountsService* value);
static GObject * settings_daemon_backends_interface_settings_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void _settings_daemon_backends_interface_settings___lambda7_ (SettingsDaemonBackendsInterfaceSettings* self,
                                                              const gchar* key);
static void __settings_daemon_backends_interface_settings___lambda7__g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static void _settings_daemon_backends_interface_settings___lambda8_ (SettingsDaemonBackendsInterfaceSettings* self,
                                                              const gchar* key);
static void __settings_daemon_backends_interface_settings___lambda8__g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static void _settings_daemon_backends_interface_settings___lambda9_ (SettingsDaemonBackendsInterfaceSettings* self,
                                                              const gchar* key);
static void __settings_daemon_backends_interface_settings___lambda9__g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static void _settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice_g_settings_changed (GSettings* _sender,
                                                                                                        const gchar* key,
                                                                                                        gpointer self);
static void settings_daemon_backends_interface_settings_finalize (GObject * obj);
static GType settings_daemon_backends_interface_settings_get_type_once (void);
static void _vala_settings_daemon_backends_interface_settings_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_settings_daemon_backends_interface_settings_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
settings_daemon_backends_interface_settings_get_instance_private (SettingsDaemonBackendsInterfaceSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SettingsDaemonBackendsInterfaceSettings_private_offset);
}

SettingsDaemonBackendsInterfaceSettings*
settings_daemon_backends_interface_settings_construct (GType object_type,
                                                       SettingsDaemonAccountsService* accounts_service,
                                                       DisplayManagerAccountsService* display_manager_accounts_service)
{
	SettingsDaemonBackendsInterfaceSettings * self = NULL;
	g_return_val_if_fail (accounts_service != NULL, NULL);
	g_return_val_if_fail (display_manager_accounts_service != NULL, NULL);
	self = (SettingsDaemonBackendsInterfaceSettings*) g_object_new (object_type, "accounts-service", accounts_service, "display-manager-accounts-service", display_manager_accounts_service, NULL);
	return self;
}

SettingsDaemonBackendsInterfaceSettings*
settings_daemon_backends_interface_settings_new (SettingsDaemonAccountsService* accounts_service,
                                                 DisplayManagerAccountsService* display_manager_accounts_service)
{
	return settings_daemon_backends_interface_settings_construct (SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, accounts_service, display_manager_accounts_service);
}

static void
settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice (SettingsDaemonBackendsInterfaceSettings* self)
{
	SettingsDaemonAccountsService* _tmp0_;
	GSettings* _tmp1_;
	SettingsDaemonAccountsService* _tmp2_;
	GSettings* _tmp3_;
	SettingsDaemonAccountsService* _tmp4_;
	GSettings* _tmp5_;
	SettingsDaemonAccountsService* _tmp6_;
	GSettings* _tmp7_;
	SettingsDaemonAccountsService* _tmp8_;
	GSettings* _tmp9_;
	SettingsDaemonAccountsService* _tmp10_;
	GSettings* _tmp11_;
	SettingsDaemonAccountsService* _tmp12_;
	GSettings* _tmp13_;
	SettingsDaemonAccountsService* _tmp14_;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	SettingsDaemonAccountsService* _tmp18_;
	GSettings* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	SettingsDaemonAccountsService* _tmp22_;
	GSettings* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	SettingsDaemonAccountsService* _tmp26_;
	GSettings* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GVariant* last_coordinates_value = NULL;
	GSettings* _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	const GVariantType* _tmp33_;
	SettingsDaemonAccountsService* _tmp39_;
	GSettings* _tmp40_;
	SettingsDaemonAccountsService* _tmp41_;
	GSettings* _tmp42_;
	SettingsDaemonAccountsService* _tmp43_;
	GSettings* _tmp44_;
	SettingsDaemonAccountsService* _tmp45_;
	GSettings* _tmp46_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_accounts_service;
	_tmp1_ = self->priv->interface_settings;
	settings_daemon_accounts_service_set_cursor_blink (_tmp0_, g_settings_get_boolean (_tmp1_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK));
	_tmp2_ = self->priv->_accounts_service;
	_tmp3_ = self->priv->interface_settings;
	settings_daemon_accounts_service_set_cursor_blink_time (_tmp2_, g_settings_get_int (_tmp3_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK_TIME));
	_tmp4_ = self->priv->_accounts_service;
	_tmp5_ = self->priv->interface_settings;
	settings_daemon_accounts_service_set_cursor_blink_timeout (_tmp4_, g_settings_get_int (_tmp5_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK_TIMEOUT));
	_tmp6_ = self->priv->_accounts_service;
	_tmp7_ = self->priv->interface_settings;
	settings_daemon_accounts_service_set_cursor_size (_tmp6_, g_settings_get_int (_tmp7_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_SIZE));
	_tmp8_ = self->priv->_accounts_service;
	_tmp9_ = self->priv->interface_settings;
	settings_daemon_accounts_service_set_locate_pointer (_tmp8_, g_settings_get_boolean (_tmp9_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_LOCATE_POINTER));
	_tmp10_ = self->priv->_accounts_service;
	_tmp11_ = self->priv->interface_settings;
	settings_daemon_accounts_service_set_text_scaling_factor (_tmp10_, g_settings_get_double (_tmp11_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_TEXT_SCALING_FACTOR));
	_tmp12_ = self->priv->_accounts_service;
	_tmp13_ = self->priv->background_settings;
	settings_daemon_accounts_service_set_picture_options (_tmp12_, g_settings_get_enum (_tmp13_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PICTURE_OPTIONS));
	_tmp14_ = self->priv->_accounts_service;
	_tmp15_ = self->priv->background_settings;
	_tmp16_ = g_settings_get_string (_tmp15_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PRIMARY_COLOR);
	_tmp17_ = _tmp16_;
	settings_daemon_accounts_service_set_primary_color (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->_accounts_service;
	_tmp19_ = self->priv->interface_settings;
	_tmp20_ = g_settings_get_string (_tmp19_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DOCUMENT_FONT_NAME);
	_tmp21_ = _tmp20_;
	settings_daemon_accounts_service_set_document_font_name (_tmp18_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = self->priv->_accounts_service;
	_tmp23_ = self->priv->interface_settings;
	_tmp24_ = g_settings_get_string (_tmp23_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_FONT_NAME);
	_tmp25_ = _tmp24_;
	settings_daemon_accounts_service_set_font_name (_tmp22_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->_accounts_service;
	_tmp27_ = self->priv->interface_settings;
	_tmp28_ = g_settings_get_string (_tmp27_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_MONOSPACE_FONT_NAME);
	_tmp29_ = _tmp28_;
	settings_daemon_accounts_service_set_monospace_font_name (_tmp26_, _tmp29_);
	_g_free0 (_tmp29_);
	_tmp30_ = self->priv->settings_daemon_settings;
	_tmp31_ = g_settings_get_value (_tmp30_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_LAST_COORDINATES);
	last_coordinates_value = _tmp31_;
	_tmp32_ = last_coordinates_value;
	_tmp33_ = G_VARIANT_TYPE_TUPLE;
	if (g_variant_is_of_type (_tmp32_, _tmp33_)) {
		gdouble latitude = 0.0;
		gdouble longitude = 0.0;
		GVariant* _tmp34_;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		SettingsDaemonAccountsService* _tmp37_;
		SettingsDaemonAccountsServiceCoordinates _tmp38_ = {0};
		_tmp34_ = last_coordinates_value;
		g_variant_get (_tmp34_, "(dd)", &_tmp35_, &_tmp36_, NULL);
		latitude = _tmp35_;
		longitude = _tmp36_;
		_tmp37_ = self->priv->_accounts_service;
		memset (&_tmp38_, 0, sizeof (SettingsDaemonAccountsServiceCoordinates));
		_tmp38_.latitude = latitude;
		_tmp38_.longitude = longitude;
		settings_daemon_accounts_service_set_last_coordinates (_tmp37_, &_tmp38_);
	} else {
		g_warning ("InterfaceSettings.vala:130: Unknown prefer dark coordinates type, unab" \
"le to save to AccountsService");
	}
	_tmp39_ = self->priv->_accounts_service;
	_tmp40_ = self->priv->settings_daemon_settings;
	settings_daemon_accounts_service_set_prefer_dark_schedule (_tmp39_, g_settings_get_enum (_tmp40_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE));
	_tmp41_ = self->priv->_accounts_service;
	_tmp42_ = self->priv->settings_daemon_settings;
	settings_daemon_accounts_service_set_prefer_dark_schedule_from (_tmp41_, g_settings_get_double (_tmp42_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE_FROM));
	_tmp43_ = self->priv->_accounts_service;
	_tmp44_ = self->priv->settings_daemon_settings;
	settings_daemon_accounts_service_set_prefer_dark_schedule_to (_tmp43_, g_settings_get_double (_tmp44_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE_TO));
	_tmp45_ = self->priv->_accounts_service;
	_tmp46_ = self->priv->touchscreen_settings;
	settings_daemon_accounts_service_set_orientation_lock (_tmp45_, g_settings_get_boolean (_tmp46_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ORIENTATION_LOCK));
	_g_variant_unref0 (last_coordinates_value);
}

static void
settings_daemon_backends_interface_settings_sync_background_to_greeter (SettingsDaemonBackendsInterfaceSettings* self)
{
	GFile* source = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* wallpaper_name = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* greeter_data_dir = NULL;
	gchar* _tmp13_;
	GFile* folder = NULL;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* dest = NULL;
	GFile* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PICTURE_URI);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	source = _tmp4_;
	_tmp5_ = source;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		DisplayManagerAccountsService* _tmp6_;
		g_debug ("InterfaceSettings.vala:144: Wallpaper path is invalid");
		_tmp6_ = self->priv->_display_manager_accounts_service;
		display_manager_accounts_service_set_background_file (_tmp6_, "");
		_g_object_unref0 (source);
		return;
	}
	_tmp7_ = g_strdup ("wallpaper");
	wallpaper_name = _tmp7_;
	_tmp9_ = g_getenv ("XDG_GREETER_DATA_DIR");
	_tmp10_ = g_strdup (_tmp9_);
	_tmp8_ = _tmp10_;
	if (_tmp8_ == NULL) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_get_user_name ();
		_tmp12_ = g_build_filename ("/var/lib/lightdm-data", _tmp11_, NULL);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp12_;
	}
	_tmp13_ = _tmp8_;
	_tmp8_ = NULL;
	greeter_data_dir = _tmp13_;
	_tmp14_ = greeter_data_dir;
	_tmp15_ = g_file_new_for_path (_tmp14_);
	folder = _tmp15_;
	_tmp16_ = folder;
	_tmp17_ = wallpaper_name;
	_tmp18_ = g_file_get_child (_tmp16_, _tmp17_);
	dest = _tmp18_;
	{
		GFile* _tmp19_;
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gboolean _tmp24_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		DisplayManagerAccountsService* _tmp31_;
		GFile* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp19_ = folder;
		if (!g_file_query_exists (_tmp19_, NULL)) {
			GFile* _tmp20_;
			_tmp20_ = folder;
			g_file_make_directory_with_parents (_tmp20_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_IS_DIRECTORY)) {
					goto __catch0_g_io_error_is_directory;
				}
				goto __catch0_g_error;
			}
		}
		_tmp21_ = dest;
		_tmp22_ = g_file_get_path (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_file_test (_tmp23_, G_FILE_TEST_IS_DIR);
		_g_free0 (_tmp23_);
		if (_tmp24_) {
			GFile* _tmp25_;
			g_debug ("InterfaceSettings.vala:161: Migrating to new wallpaper directory");
			_tmp25_ = dest;
			settings_daemon_backends_interface_settings_remove_directory (self, _tmp25_);
		}
		_tmp26_ = source;
		_tmp27_ = dest;
		g_file_copy (_tmp26_, _tmp27_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_IS_DIRECTORY)) {
				goto __catch0_g_io_error_is_directory;
			}
			goto __catch0_g_error;
		}
		_tmp28_ = dest;
		_tmp29_ = g_file_get_path (_tmp28_);
		_tmp30_ = _tmp29_;
		g_chmod (_tmp30_, 0604);
		_g_free0 (_tmp30_);
		_tmp31_ = self->priv->_display_manager_accounts_service;
		_tmp32_ = dest;
		_tmp33_ = g_file_get_path (_tmp32_);
		_tmp34_ = _tmp33_;
		display_manager_accounts_service_set_background_file (_tmp31_, _tmp34_);
		_g_free0 (_tmp34_);
	}
	goto __finally0;
	__catch0_g_io_error_is_directory:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		DisplayManagerAccountsService* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		g_critical ("InterfaceSettings.vala:171: Migration failed %s", _tmp36_);
		_tmp37_ = self->priv->_display_manager_accounts_service;
		display_manager_accounts_service_set_background_file (_tmp37_, "");
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		DisplayManagerAccountsService* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("InterfaceSettings.vala:174: %s", _tmp39_);
		_tmp40_ = self->priv->_display_manager_accounts_service;
		display_manager_accounts_service_set_background_file (_tmp40_, "");
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest);
		_g_object_unref0 (folder);
		_g_free0 (greeter_data_dir);
		_g_free0 (_tmp8_);
		_g_free0 (wallpaper_name);
		_g_object_unref0 (source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dest);
	_g_object_unref0 (folder);
	_g_free0 (greeter_data_dir);
	_g_free0 (_tmp8_);
	_g_free0 (wallpaper_name);
	_g_object_unref0 (source);
}

static void
settings_daemon_backends_interface_settings_remove_directory (SettingsDaemonBackendsInterfaceSettings* self,
                                                              GFile* directory)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* file_info = NULL;
		_tmp0_ = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFile* file = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			GFileInfo* _tmp9_;
			GFile* _tmp11_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = file_info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			_tmp8_ = g_file_get_child (directory, _tmp7_);
			file = _tmp8_;
			_tmp9_ = file_info;
			if (g_file_info_get_file_type (_tmp9_) == G_FILE_TYPE_DIRECTORY) {
				GFile* _tmp10_;
				_tmp10_ = file;
				settings_daemon_backends_interface_settings_remove_directory (self, _tmp10_);
			}
			_tmp11_ = file;
			g_file_delete (_tmp11_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (_tmp1_);
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp1_);
		}
		g_file_delete (directory, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			goto __catch0_g_error;
		}
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = g_file_get_path (directory);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("InterfaceSettings.vala:195: Couldn't remove directory %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

SettingsDaemonAccountsService*
settings_daemon_backends_interface_settings_get_accounts_service (SettingsDaemonBackendsInterfaceSettings* self)
{
	SettingsDaemonAccountsService* result;
	SettingsDaemonAccountsService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accounts_service;
	result = _tmp0_;
	return result;
}

static void
settings_daemon_backends_interface_settings_set_accounts_service (SettingsDaemonBackendsInterfaceSettings* self,
                                                                  SettingsDaemonAccountsService* value)
{
	SettingsDaemonAccountsService* old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_daemon_backends_interface_settings_get_accounts_service (self);
	if (old_value != value) {
		self->priv->_accounts_service = value;
		g_object_notify_by_pspec ((GObject *) self, settings_daemon_backends_interface_settings_properties[SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ACCOUNTS_SERVICE_PROPERTY]);
	}
}

DisplayManagerAccountsService*
settings_daemon_backends_interface_settings_get_display_manager_accounts_service (SettingsDaemonBackendsInterfaceSettings* self)
{
	DisplayManagerAccountsService* result;
	DisplayManagerAccountsService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_manager_accounts_service;
	result = _tmp0_;
	return result;
}

static void
settings_daemon_backends_interface_settings_set_display_manager_accounts_service (SettingsDaemonBackendsInterfaceSettings* self,
                                                                                  DisplayManagerAccountsService* value)
{
	DisplayManagerAccountsService* old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_daemon_backends_interface_settings_get_display_manager_accounts_service (self);
	if (old_value != value) {
		self->priv->_display_manager_accounts_service = value;
		g_object_notify_by_pspec ((GObject *) self, settings_daemon_backends_interface_settings_properties[SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DISPLAY_MANAGER_ACCOUNTS_SERVICE_PROPERTY]);
	}
}

static void
_settings_daemon_backends_interface_settings___lambda7_ (SettingsDaemonBackendsInterfaceSettings* self,
                                                         const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK) == 0) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK_TIME) == 0;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_BLINK_TIMEOUT) == 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_CURSOR_SIZE) == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_LOCATE_POINTER) == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_TEXT_SCALING_FACTOR) == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DOCUMENT_FONT_NAME) == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_FONT_NAME) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_MONOSPACE_FONT_NAME) == 0;
	}
	if (_tmp0_) {
		settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice (self);
	}
}

static void
__settings_daemon_backends_interface_settings___lambda7__g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	_settings_daemon_backends_interface_settings___lambda7_ ((SettingsDaemonBackendsInterfaceSettings*) self, key);
}

static void
_settings_daemon_backends_interface_settings___lambda8_ (SettingsDaemonBackendsInterfaceSettings* self,
                                                         const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PICTURE_OPTIONS) == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PRIMARY_COLOR) == 0;
	}
	if (_tmp0_) {
		settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice (self);
		return;
	}
	if (g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PICTURE_URI) == 0) {
		settings_daemon_backends_interface_settings_sync_background_to_greeter (self);
	}
}

static void
__settings_daemon_backends_interface_settings___lambda8__g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	_settings_daemon_backends_interface_settings___lambda8_ ((SettingsDaemonBackendsInterfaceSettings*) self, key);
}

static void
_settings_daemon_backends_interface_settings___lambda9_ (SettingsDaemonBackendsInterfaceSettings* self,
                                                         const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_LAST_COORDINATES) == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE) == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE_FROM) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_PREFER_DARK_SCHEDULE_TO) == 0;
	}
	if (_tmp0_) {
		settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice (self);
	}
}

static void
__settings_daemon_backends_interface_settings___lambda9__g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	_settings_daemon_backends_interface_settings___lambda9_ ((SettingsDaemonBackendsInterfaceSettings*) self, key);
}

static void
_settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice_g_settings_changed (GSettings* _sender,
                                                                                                   const gchar* key,
                                                                                                   gpointer self)
{
	settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice ((SettingsDaemonBackendsInterfaceSettings*) self);
}

static GObject *
settings_daemon_backends_interface_settings_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SettingsDaemonBackendsInterfaceSettings * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	parent_class = G_OBJECT_CLASS (settings_daemon_backends_interface_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettings);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (self->priv->background_settings);
	self->priv->background_settings = _tmp1_;
	_tmp2_ = g_settings_new ("io.elementary.settings-daemon.prefers-color-scheme");
	_g_object_unref0 (self->priv->settings_daemon_settings);
	self->priv->settings_daemon_settings = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.settings-daemon.peripherals.touchscreen");
	_g_object_unref0 (self->priv->touchscreen_settings);
	self->priv->touchscreen_settings = _tmp3_;
	settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice (self);
	_tmp4_ = self->priv->interface_settings;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) __settings_daemon_backends_interface_settings___lambda7__g_settings_changed, self, 0);
	_tmp5_ = self->priv->background_settings;
	g_signal_connect_object (_tmp5_, "changed", (GCallback) __settings_daemon_backends_interface_settings___lambda8__g_settings_changed, self, 0);
	_tmp6_ = self->priv->settings_daemon_settings;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) __settings_daemon_backends_interface_settings___lambda9__g_settings_changed, self, 0);
	_tmp7_ = self->priv->touchscreen_settings;
	g_signal_connect_object (_tmp7_, "changed", (GCallback) _settings_daemon_backends_interface_settings_sync_gsettings_to_accountsservice_g_settings_changed, self, 0);
	return obj;
}

static void
settings_daemon_backends_interface_settings_class_init (SettingsDaemonBackendsInterfaceSettingsClass * klass,
                                                        gpointer klass_data)
{
	settings_daemon_backends_interface_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingsDaemonBackendsInterfaceSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_daemon_backends_interface_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_daemon_backends_interface_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_daemon_backends_interface_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_daemon_backends_interface_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ACCOUNTS_SERVICE_PROPERTY, settings_daemon_backends_interface_settings_properties[SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ACCOUNTS_SERVICE_PROPERTY] = g_param_spec_object ("accounts-service", "accounts-service", "accounts-service", SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DISPLAY_MANAGER_ACCOUNTS_SERVICE_PROPERTY, settings_daemon_backends_interface_settings_properties[SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DISPLAY_MANAGER_ACCOUNTS_SERVICE_PROPERTY] = g_param_spec_object ("display-manager-accounts-service", "display-manager-accounts-service", "display-manager-accounts-service", DISPLAY_MANAGER_TYPE_ACCOUNTS_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
settings_daemon_backends_interface_settings_instance_init (SettingsDaemonBackendsInterfaceSettings * self,
                                                           gpointer klass)
{
	self->priv = settings_daemon_backends_interface_settings_get_instance_private (self);
}

static void
settings_daemon_backends_interface_settings_finalize (GObject * obj)
{
	SettingsDaemonBackendsInterfaceSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettings);
	_g_object_unref0 (self->priv->interface_settings);
	_g_object_unref0 (self->priv->background_settings);
	_g_object_unref0 (self->priv->settings_daemon_settings);
	_g_object_unref0 (self->priv->touchscreen_settings);
	G_OBJECT_CLASS (settings_daemon_backends_interface_settings_parent_class)->finalize (obj);
}

static GType
settings_daemon_backends_interface_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonBackendsInterfaceSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_backends_interface_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDaemonBackendsInterfaceSettings), 0, (GInstanceInitFunc) settings_daemon_backends_interface_settings_instance_init, NULL };
	GType settings_daemon_backends_interface_settings_type_id;
	settings_daemon_backends_interface_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsDaemonBackendsInterfaceSettings", &g_define_type_info, 0);
	SettingsDaemonBackendsInterfaceSettings_private_offset = g_type_add_instance_private (settings_daemon_backends_interface_settings_type_id, sizeof (SettingsDaemonBackendsInterfaceSettingsPrivate));
	return settings_daemon_backends_interface_settings_type_id;
}

GType
settings_daemon_backends_interface_settings_get_type (void)
{
	static volatile gsize settings_daemon_backends_interface_settings_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_interface_settings_type_id__once)) {
		GType settings_daemon_backends_interface_settings_type_id;
		settings_daemon_backends_interface_settings_type_id = settings_daemon_backends_interface_settings_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_interface_settings_type_id__once, settings_daemon_backends_interface_settings_type_id);
	}
	return settings_daemon_backends_interface_settings_type_id__once;
}

static void
_vala_settings_daemon_backends_interface_settings_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	SettingsDaemonBackendsInterfaceSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettings);
	switch (property_id) {
		case SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ACCOUNTS_SERVICE_PROPERTY:
		g_value_set_object (value, settings_daemon_backends_interface_settings_get_accounts_service (self));
		break;
		case SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DISPLAY_MANAGER_ACCOUNTS_SERVICE_PROPERTY:
		g_value_set_object (value, settings_daemon_backends_interface_settings_get_display_manager_accounts_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_settings_daemon_backends_interface_settings_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	SettingsDaemonBackendsInterfaceSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_BACKENDS_TYPE_INTERFACE_SETTINGS, SettingsDaemonBackendsInterfaceSettings);
	switch (property_id) {
		case SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_ACCOUNTS_SERVICE_PROPERTY:
		settings_daemon_backends_interface_settings_set_accounts_service (self, g_value_get_object (value));
		break;
		case SETTINGS_DAEMON_BACKENDS_INTERFACE_SETTINGS_DISPLAY_MANAGER_ACCOUNTS_SERVICE_PROPERTY:
		settings_daemon_backends_interface_settings_set_display_manager_accounts_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

