/* Commands.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Commands.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* PageCommand stores the current page when a Command is created.  Subclasses can call return_to_page ()*/
/* if it's appropriate to return to that page when executing an undo () or redo ().*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define FLAG_UNFLAG_COMMAND_MIN_PROGRESS_BAR_THRESHOLD 1000
#define FLAG_UNFLAG_COMMAND_FLAG_SELECTED_STRING _ ("Flag selected photos")
#define FLAG_UNFLAG_COMMAND_UNFLAG_SELECTED_STRING _ ("Unflag selected photos")
#define FLAG_UNFLAG_COMMAND_FLAG_PROGRESS _ ("Flagging selected photos")
#define FLAG_UNFLAG_COMMAND_UNFLAG_PROGRESS _ ("Unflagging selected photos")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PAGE_COMMAND_0_PROPERTY,
	PAGE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* page_command_properties[PAGE_COMMAND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
enum  {
	SINGLE_DATA_SOURCE_COMMAND_0_PROPERTY,
	SINGLE_DATA_SOURCE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* single_data_source_command_properties[SINGLE_DATA_SOURCE_COMMAND_NUM_PROPERTIES];
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
enum  {
	SIMPLE_PROXYABLE_COMMAND_0_PROPERTY,
	SIMPLE_PROXYABLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* simple_proxyable_command_properties[SIMPLE_PROXYABLE_COMMAND_NUM_PROPERTIES];
#define _source_proxy_unref0(var) ((var == NULL) ? NULL : (var = (source_proxy_unref (var), NULL)))
enum  {
	SINGLE_PHOTO_TRANSFORMATION_COMMAND_0_PROPERTY,
	SINGLE_PHOTO_TRANSFORMATION_COMMAND_NUM_PROPERTIES
};
static GParamSpec* single_photo_transformation_command_properties[SINGLE_PHOTO_TRANSFORMATION_COMMAND_NUM_PROPERTIES];
enum  {
	GENERIC_PHOTO_TRANSFORMATION_COMMAND_0_PROPERTY,
	GENERIC_PHOTO_TRANSFORMATION_COMMAND_NUM_PROPERTIES
};
static GParamSpec* generic_photo_transformation_command_properties[GENERIC_PHOTO_TRANSFORMATION_COMMAND_NUM_PROPERTIES];
enum  {
	MULTIPLE_DATA_SOURCE_COMMAND_0_PROPERTY,
	MULTIPLE_DATA_SOURCE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* multiple_data_source_command_properties[MULTIPLE_DATA_SOURCE_COMMAND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND_0_PROPERTY,
	MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* multiple_data_source_at_once_command_properties[MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND_NUM_PROPERTIES];
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MULTIPLE_PHOTO_TRANSFORMATION_COMMAND_0_PROPERTY,
	MULTIPLE_PHOTO_TRANSFORMATION_COMMAND_NUM_PROPERTIES
};
static GParamSpec* multiple_photo_transformation_command_properties[MULTIPLE_PHOTO_TRANSFORMATION_COMMAND_NUM_PROPERTIES];
enum  {
	ROTATE_SINGLE_COMMAND_0_PROPERTY,
	ROTATE_SINGLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* rotate_single_command_properties[ROTATE_SINGLE_COMMAND_NUM_PROPERTIES];
enum  {
	ROTATE_MULTIPLE_COMMAND_0_PROPERTY,
	ROTATE_MULTIPLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* rotate_multiple_command_properties[ROTATE_MULTIPLE_COMMAND_NUM_PROPERTIES];
enum  {
	EDIT_TITLE_COMMAND_0_PROPERTY,
	EDIT_TITLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* edit_title_command_properties[EDIT_TITLE_COMMAND_NUM_PROPERTIES];
enum  {
	EDIT_COMMENT_COMMAND_0_PROPERTY,
	EDIT_COMMENT_COMMAND_NUM_PROPERTIES
};
static GParamSpec* edit_comment_command_properties[EDIT_COMMENT_COMMAND_NUM_PROPERTIES];
enum  {
	EDIT_MULTIPLE_TITLES_COMMAND_0_PROPERTY,
	EDIT_MULTIPLE_TITLES_COMMAND_NUM_PROPERTIES
};
static GParamSpec* edit_multiple_titles_command_properties[EDIT_MULTIPLE_TITLES_COMMAND_NUM_PROPERTIES];
enum  {
	EDIT_MULTIPLE_COMMENTS_COMMAND_0_PROPERTY,
	EDIT_MULTIPLE_COMMENTS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* edit_multiple_comments_command_properties[EDIT_MULTIPLE_COMMENTS_COMMAND_NUM_PROPERTIES];
enum  {
	RENAME_EVENT_COMMAND_0_PROPERTY,
	RENAME_EVENT_COMMAND_NUM_PROPERTIES
};
static GParamSpec* rename_event_command_properties[RENAME_EVENT_COMMAND_NUM_PROPERTIES];
enum  {
	EDIT_EVENT_COMMENT_COMMAND_0_PROPERTY,
	EDIT_EVENT_COMMENT_COMMAND_NUM_PROPERTIES
};
static GParamSpec* edit_event_comment_command_properties[EDIT_EVENT_COMMENT_COMMAND_NUM_PROPERTIES];
enum  {
	SET_KEY_PHOTO_COMMAND_0_PROPERTY,
	SET_KEY_PHOTO_COMMAND_NUM_PROPERTIES
};
static GParamSpec* set_key_photo_command_properties[SET_KEY_PHOTO_COMMAND_NUM_PROPERTIES];
enum  {
	REVERT_SINGLE_COMMAND_0_PROPERTY,
	REVERT_SINGLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* revert_single_command_properties[REVERT_SINGLE_COMMAND_NUM_PROPERTIES];
enum  {
	REVERT_MULTIPLE_COMMAND_0_PROPERTY,
	REVERT_MULTIPLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* revert_multiple_command_properties[REVERT_MULTIPLE_COMMAND_NUM_PROPERTIES];
enum  {
	ENHANCE_SINGLE_COMMAND_0_PROPERTY,
	ENHANCE_SINGLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* enhance_single_command_properties[ENHANCE_SINGLE_COMMAND_NUM_PROPERTIES];
enum  {
	ENHANCE_MULTIPLE_COMMAND_0_PROPERTY,
	ENHANCE_MULTIPLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* enhance_multiple_command_properties[ENHANCE_MULTIPLE_COMMAND_NUM_PROPERTIES];
enum  {
	UN_ENHANCE_SINGLE_COMMAND_0_PROPERTY,
	UN_ENHANCE_SINGLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* un_enhance_single_command_properties[UN_ENHANCE_SINGLE_COMMAND_NUM_PROPERTIES];
enum  {
	UN_ENHANCE_MULTIPLE_COMMAND_0_PROPERTY,
	UN_ENHANCE_MULTIPLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* un_enhance_multiple_command_properties[UN_ENHANCE_MULTIPLE_COMMAND_NUM_PROPERTIES];
enum  {
	STRAIGHTEN_COMMAND_0_PROPERTY,
	STRAIGHTEN_COMMAND_NUM_PROPERTIES
};
static GParamSpec* straighten_command_properties[STRAIGHTEN_COMMAND_NUM_PROPERTIES];
enum  {
	CROP_COMMAND_0_PROPERTY,
	CROP_COMMAND_NUM_PROPERTIES
};
static GParamSpec* crop_command_properties[CROP_COMMAND_NUM_PROPERTIES];
enum  {
	ADJUST_COLORS_SINGLE_COMMAND_0_PROPERTY,
	ADJUST_COLORS_SINGLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* adjust_colors_single_command_properties[ADJUST_COLORS_SINGLE_COMMAND_NUM_PROPERTIES];
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
enum  {
	ADJUST_COLORS_MULTIPLE_COMMAND_0_PROPERTY,
	ADJUST_COLORS_MULTIPLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* adjust_colors_multiple_command_properties[ADJUST_COLORS_MULTIPLE_COMMAND_NUM_PROPERTIES];
enum  {
	REDEYE_COMMAND_0_PROPERTY,
	REDEYE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* redeye_command_properties[REDEYE_COMMAND_NUM_PROPERTIES];
enum  {
	MOVE_PHOTOS_COMMAND_0_PROPERTY,
	MOVE_PHOTOS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* move_photos_command_properties[MOVE_PHOTOS_COMMAND_NUM_PROPERTIES];
enum  {
	MOVE_PHOTOS_COMMAND_REAL_MOVE_PHOTOS_COMMAND_0_PROPERTY,
	MOVE_PHOTOS_COMMAND_REAL_MOVE_PHOTOS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* move_photos_command_real_move_photos_command_properties[MOVE_PHOTOS_COMMAND_REAL_MOVE_PHOTOS_COMMAND_NUM_PROPERTIES];
enum  {
	NEW_EVENT_COMMAND_0_PROPERTY,
	NEW_EVENT_COMMAND_NUM_PROPERTIES
};
static GParamSpec* new_event_command_properties[NEW_EVENT_COMMAND_NUM_PROPERTIES];
enum  {
	SET_EVENT_COMMAND_0_PROPERTY,
	SET_EVENT_COMMAND_NUM_PROPERTIES
};
static GParamSpec* set_event_command_properties[SET_EVENT_COMMAND_NUM_PROPERTIES];
enum  {
	MERGE_EVENTS_COMMAND_0_PROPERTY,
	MERGE_EVENTS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* merge_events_command_properties[MERGE_EVENTS_COMMAND_NUM_PROPERTIES];
enum  {
	DUPLICATE_MULTIPLE_PHOTOS_COMMAND_0_PROPERTY,
	DUPLICATE_MULTIPLE_PHOTOS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* duplicate_multiple_photos_command_properties[DUPLICATE_MULTIPLE_PHOTOS_COMMAND_NUM_PROPERTIES];
enum  {
	SET_RAW_DEVELOPER_COMMAND_0_PROPERTY,
	SET_RAW_DEVELOPER_COMMAND_NUM_PROPERTIES
};
static GParamSpec* set_raw_developer_command_properties[SET_RAW_DEVELOPER_COMMAND_NUM_PROPERTIES];
enum  {
	ADJUST_DATE_TIME_PHOTO_COMMAND_0_PROPERTY,
	ADJUST_DATE_TIME_PHOTO_COMMAND_NUM_PROPERTIES
};
static GParamSpec* adjust_date_time_photo_command_properties[ADJUST_DATE_TIME_PHOTO_COMMAND_NUM_PROPERTIES];
enum  {
	ADJUST_DATE_TIME_PHOTOS_COMMAND_0_PROPERTY,
	ADJUST_DATE_TIME_PHOTOS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* adjust_date_time_photos_command_properties[ADJUST_DATE_TIME_PHOTOS_COMMAND_NUM_PROPERTIES];
enum  {
	ADD_TAGS_COMMAND_0_PROPERTY,
	ADD_TAGS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* add_tags_command_properties[ADD_TAGS_COMMAND_NUM_PROPERTIES];
enum  {
	RENAME_TAG_COMMAND_0_PROPERTY,
	RENAME_TAG_COMMAND_NUM_PROPERTIES
};
static GParamSpec* rename_tag_command_properties[RENAME_TAG_COMMAND_NUM_PROPERTIES];
enum  {
	DELETE_TAG_COMMAND_0_PROPERTY,
	DELETE_TAG_COMMAND_NUM_PROPERTIES
};
static GParamSpec* delete_tag_command_properties[DELETE_TAG_COMMAND_NUM_PROPERTIES];
enum  {
	NEW_CHILD_TAG_COMMAND_0_PROPERTY,
	NEW_CHILD_TAG_COMMAND_NUM_PROPERTIES
};
static GParamSpec* new_child_tag_command_properties[NEW_CHILD_TAG_COMMAND_NUM_PROPERTIES];
enum  {
	NEW_ROOT_TAG_COMMAND_0_PROPERTY,
	NEW_ROOT_TAG_COMMAND_NUM_PROPERTIES
};
static GParamSpec* new_root_tag_command_properties[NEW_ROOT_TAG_COMMAND_NUM_PROPERTIES];
enum  {
	REPARENT_TAG_COMMAND_0_PROPERTY,
	REPARENT_TAG_COMMAND_NUM_PROPERTIES
};
static GParamSpec* reparent_tag_command_properties[REPARENT_TAG_COMMAND_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	MODIFY_TAGS_COMMAND_0_PROPERTY,
	MODIFY_TAGS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* modify_tags_command_properties[MODIFY_TAGS_COMMAND_NUM_PROPERTIES];
enum  {
	TAG_UNTAG_PHOTOS_COMMAND_0_PROPERTY,
	TAG_UNTAG_PHOTOS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* tag_untag_photos_command_properties[TAG_UNTAG_PHOTOS_COMMAND_NUM_PROPERTIES];
enum  {
	RENAME_SAVED_SEARCH_COMMAND_0_PROPERTY,
	RENAME_SAVED_SEARCH_COMMAND_NUM_PROPERTIES
};
static GParamSpec* rename_saved_search_command_properties[RENAME_SAVED_SEARCH_COMMAND_NUM_PROPERTIES];
enum  {
	DELETE_SAVED_SEARCH_COMMAND_0_PROPERTY,
	DELETE_SAVED_SEARCH_COMMAND_NUM_PROPERTIES
};
static GParamSpec* delete_saved_search_command_properties[DELETE_SAVED_SEARCH_COMMAND_NUM_PROPERTIES];
#define _saved_search_table_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_table_unref (var), NULL)))
enum  {
	TRASH_UNTRASH_PHOTOS_COMMAND_0_PROPERTY,
	TRASH_UNTRASH_PHOTOS_COMMAND_NUM_PROPERTIES
};
static GParamSpec* trash_untrash_photos_command_properties[TRASH_UNTRASH_PHOTOS_COMMAND_NUM_PROPERTIES];
enum  {
	FLAG_UNFLAG_COMMAND_0_PROPERTY,
	FLAG_UNFLAG_COMMAND_NUM_PROPERTIES
};
static GParamSpec* flag_unflag_command_properties[FLAG_UNFLAG_COMMAND_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PageCommandPrivate {
	Page* page;
	gboolean auto_return;
	Photo* library_photo;
	CollectionPage* collection_page;
};

struct _SimpleProxyableCommandPrivate {
	SourceProxy* proxy;
	GeeHashSet* proxies;
};

struct _SinglePhotoTransformationCommandPrivate {
	PhotoTransformationState* state;
};

struct _GenericPhotoTransformationCommandPrivate {
	PhotoTransformationState* original_state;
	PhotoTransformationState* transformed_state;
};

struct _MultipleDataSourceCommandPrivate {
	gchar* progress_text;
	gchar* undo_progress_text;
	GeeArrayList* acted_upon;
	GeeHashSet* hooked_collections;
};

struct _MultipleDataSourceAtOnceCommandPrivate {
	GeeHashSet* sources;
	GeeHashSet* hooked_collections;
};

struct _MultiplePhotoTransformationCommandPrivate {
	GeeHashMap* map;
};

struct _RotateSingleCommandPrivate {
	Rotation rotation;
};

struct _RotateMultipleCommandPrivate {
	Rotation rotation;
};

struct _EditTitleCommandPrivate {
	gchar* new_title;
	gchar* old_title;
};

struct _EditCommentCommandPrivate {
	gchar* new_comment;
	gchar* old_comment;
};

struct _RenameEventCommandPrivate {
	gchar* new_name;
	gchar* old_name;
};

struct _EditEventCommentCommandPrivate {
	gchar* new_comment;
	gchar* old_comment;
};

struct _SetKeyPhotoCommandPrivate {
	MediaSource* new_primary_source;
	MediaSource* old_primary_source;
};

struct _StraightenCommandPrivate {
	gdouble theta;
	Box crop;
};

struct _CropCommandPrivate {
	Box crop;
};

struct _AdjustColorsSingleCommandPrivate {
	PixelTransformationBundle* transformations;
};

struct _AdjustColorsMultipleCommandPrivate {
	PixelTransformationBundle* transformations;
};

struct _RedeyeCommandPrivate {
	EditingToolsRedeyeInstance redeye_instance;
};

struct _MovePhotosCommandRealMovePhotosCommandPrivate {
	SourceProxy* new_event_proxy;
	GeeHashMap* old_events;
};

struct _DuplicateMultiplePhotosCommandPrivate {
	GeeHashMap* dupes;
	gint failed;
};

struct _SetRawDeveloperCommandPrivate {
	GeeHashMap* last_developer_map;
	GeeHashMap* last_transformation_map;
	RawDeveloper new_developer;
};

struct _AdjustDateTimePhotoCommandPrivate {
	Dateable* dateable;
	Event* prev_event;
	gint64 time_shift;
	gboolean modify_original;
};

struct _AdjustDateTimePhotosCommandPrivate {
	gint64 time_shift;
	gboolean keep_relativity;
	gboolean modify_originals;
	GeeMap* prev_events;
	gint64* new_time;
	GeeHashMap* old_times;
	GeeArrayList* error_list;
};

struct _AddTagsCommandPrivate {
	GeeHashMap* map;
};

struct _RenameTagCommandPrivate {
	gchar* old_name;
	gchar* new_name;
};

struct _DeleteTagCommandPrivate {
	GeeList* recursive_victim_proxies;
};

struct _NewChildTagCommandPrivate {
	Tag* created_child;
};

struct _NewRootTagCommandPrivate {
	SourceProxy* created_proxy;
};

struct _ReparentTagCommandPrivate {
	gchar* from_path;
	gchar* to_path;
	gchar* to_path_parent_path;
	GeeList* src_before_state;
	GeeList* dest_before_state;
	GeeList* after_state;
	GeeHashSet* sources_in_play;
	GeeMap* dest_parent_attachments;
	GeeMap* src_parent_detachments;
	GeeMap* in_play_child_structure;
	GeeMap* existing_dest_child_structure;
	GeeSet* existing_dest_membership;
	gboolean to_path_exists;
};

struct _ModifyTagsCommandPrivate {
	MediaSource* media;
	GeeArrayList* to_add;
	GeeArrayList* to_remove;
};

struct _TagUntagPhotosCommandPrivate {
	GeeCollection* sources;
	gboolean attach;
	GeeMultiMap* detached_from;
	GeeList* attached_to;
};

struct _RenameSavedSearchCommandPrivate {
	SavedSearch* search;
	gchar* old_name;
	gchar* new_name;
};

struct _DeleteSavedSearchCommandPrivate {
	SavedSearch* search;
};

struct _TrashUntrashPhotosCommandPrivate {
	GeeCollection* sources;
	gboolean to_trash;
};

struct _FlagUnflagCommandPrivate {
	gboolean flag;
	ProgressDialog* progress_dialog;
};

static gint PageCommand_private_offset;
static gpointer page_command_parent_class = NULL;
static gpointer single_data_source_command_parent_class = NULL;
static gint SimpleProxyableCommand_private_offset;
static gpointer simple_proxyable_command_parent_class = NULL;
static gint SinglePhotoTransformationCommand_private_offset;
static gpointer single_photo_transformation_command_parent_class = NULL;
static gint GenericPhotoTransformationCommand_private_offset;
static gpointer generic_photo_transformation_command_parent_class = NULL;
static gint MultipleDataSourceCommand_private_offset;
static gpointer multiple_data_source_command_parent_class = NULL;
static gint MultipleDataSourceAtOnceCommand_private_offset;
static gpointer multiple_data_source_at_once_command_parent_class = NULL;
static gint MultiplePhotoTransformationCommand_private_offset;
static gpointer multiple_photo_transformation_command_parent_class = NULL;
static gint RotateSingleCommand_private_offset;
static gpointer rotate_single_command_parent_class = NULL;
static gint RotateMultipleCommand_private_offset;
static gpointer rotate_multiple_command_parent_class = NULL;
static gint EditTitleCommand_private_offset;
static gpointer edit_title_command_parent_class = NULL;
static gint EditCommentCommand_private_offset;
static gpointer edit_comment_command_parent_class = NULL;
static gpointer edit_multiple_titles_command_parent_class = NULL;
static gpointer edit_multiple_comments_command_parent_class = NULL;
static gint RenameEventCommand_private_offset;
static gpointer rename_event_command_parent_class = NULL;
static gint EditEventCommentCommand_private_offset;
static gpointer edit_event_comment_command_parent_class = NULL;
static gint SetKeyPhotoCommand_private_offset;
static gpointer set_key_photo_command_parent_class = NULL;
static gpointer revert_single_command_parent_class = NULL;
static gpointer revert_multiple_command_parent_class = NULL;
static gpointer enhance_single_command_parent_class = NULL;
static gpointer enhance_multiple_command_parent_class = NULL;
static gpointer un_enhance_single_command_parent_class = NULL;
static gpointer un_enhance_multiple_command_parent_class = NULL;
static gint StraightenCommand_private_offset;
static gpointer straighten_command_parent_class = NULL;
static gint CropCommand_private_offset;
static gpointer crop_command_parent_class = NULL;
static gint AdjustColorsSingleCommand_private_offset;
static gpointer adjust_colors_single_command_parent_class = NULL;
static gint AdjustColorsMultipleCommand_private_offset;
static gpointer adjust_colors_multiple_command_parent_class = NULL;
static gint RedeyeCommand_private_offset;
static gpointer redeye_command_parent_class = NULL;
static gpointer move_photos_command_parent_class = NULL;
static gint MovePhotosCommandRealMovePhotosCommand_private_offset;
static gpointer move_photos_command_real_move_photos_command_parent_class = NULL;
static gpointer new_event_command_parent_class = NULL;
static gpointer set_event_command_parent_class = NULL;
static gpointer merge_events_command_parent_class = NULL;
static gint DuplicateMultiplePhotosCommand_private_offset;
static gpointer duplicate_multiple_photos_command_parent_class = NULL;
static gint SetRawDeveloperCommand_private_offset;
static gpointer set_raw_developer_command_parent_class = NULL;
static gint AdjustDateTimePhotoCommand_private_offset;
static gpointer adjust_date_time_photo_command_parent_class = NULL;
static gint AdjustDateTimePhotosCommand_private_offset;
static gpointer adjust_date_time_photos_command_parent_class = NULL;
static gint AddTagsCommand_private_offset;
static gpointer add_tags_command_parent_class = NULL;
static gint RenameTagCommand_private_offset;
static gpointer rename_tag_command_parent_class = NULL;
static gint DeleteTagCommand_private_offset;
static gpointer delete_tag_command_parent_class = NULL;
static gint NewChildTagCommand_private_offset;
static gpointer new_child_tag_command_parent_class = NULL;
static gint NewRootTagCommand_private_offset;
static gpointer new_root_tag_command_parent_class = NULL;
static gint ReparentTagCommand_private_offset;
static gpointer reparent_tag_command_parent_class = NULL;
static gint ModifyTagsCommand_private_offset;
static gpointer modify_tags_command_parent_class = NULL;
static gint TagUntagPhotosCommand_private_offset;
static gpointer tag_untag_photos_command_parent_class = NULL;
static gint RenameSavedSearchCommand_private_offset;
static gpointer rename_saved_search_command_parent_class = NULL;
static gint DeleteSavedSearchCommand_private_offset;
static gpointer delete_saved_search_command_parent_class = NULL;
static gint TrashUntrashPhotosCommand_private_offset;
static gpointer trash_untrash_photos_command_parent_class = NULL;
static gint FlagUnflagCommand_private_offset;
static gpointer flag_unflag_command_parent_class = NULL;

static void page_command_on_page_destroyed (PageCommand* self);
static void _page_command_on_page_destroyed_gtk_widget_destroy (GtkWidget* _sender,
                                                         gpointer self);
static void page_command_on_photo_destroyed (PageCommand* self);
static void _page_command_on_photo_destroyed_data_source_destroyed (DataSource* _sender,
                                                             gpointer self);
static void page_command_on_controller_destroyed (PageCommand* self);
static void _page_command_on_controller_destroyed_gtk_widget_destroy (GtkWidget* _sender,
                                                               gpointer self);
static void page_command_real_prepare (Command* base);
static void page_command_finalize (GObject * obj);
static GType page_command_get_type_once (void);
static void single_data_source_command_on_source_destroyed (SingleDataSourceCommand* self);
static void _single_data_source_command_on_source_destroyed_data_source_destroyed (DataSource* _sender,
                                                                            gpointer self);
static void single_data_source_command_finalize (GObject * obj);
static GType single_data_source_command_get_type_once (void);
static void simple_proxyable_command_on_proxy_broken (SimpleProxyableCommand* self);
static void _simple_proxyable_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                                    gpointer self);
static void simple_proxyable_command_real_execute (Command* base);
static void simple_proxyable_command_real_execute_on_source (SimpleProxyableCommand* self,
                                                      DataSource* source);
static void simple_proxyable_command_real_undo (Command* base);
static void simple_proxyable_command_real_undo_on_source (SimpleProxyableCommand* self,
                                                   DataSource* source);
static void simple_proxyable_command_finalize (GObject * obj);
static GType simple_proxyable_command_get_type_once (void);
static void single_photo_transformation_command_on_state_broken (SinglePhotoTransformationCommand* self);
static void _single_photo_transformation_command_on_state_broken_photo_transformation_state_broken (PhotoTransformationState* _sender,
                                                                                             gpointer self);
static void single_photo_transformation_command_real_undo (Command* base);
static void single_photo_transformation_command_finalize (GObject * obj);
static GType single_photo_transformation_command_get_type_once (void);
static void generic_photo_transformation_command_on_state_broken (GenericPhotoTransformationCommand* self);
static void _generic_photo_transformation_command_on_state_broken_photo_transformation_state_broken (PhotoTransformationState* _sender,
                                                                                              gpointer self);
static void generic_photo_transformation_command_real_execute (Command* base);
static void generic_photo_transformation_command_real_execute_on_photo (GenericPhotoTransformationCommand* self,
                                                                 Photo* photo);
static void generic_photo_transformation_command_real_undo (Command* base);
static void generic_photo_transformation_command_real_redo (Command* base);
static gboolean generic_photo_transformation_command_real_can_compress (GenericPhotoTransformationCommand* self,
                                                                 Command* command);
static gboolean generic_photo_transformation_command_real_compress (Command* base,
                                                             Command* command);
static void generic_photo_transformation_command_finalize (GObject * obj);
static GType generic_photo_transformation_command_get_type_once (void);
static void multiple_data_source_command_on_source_destroyed (MultipleDataSourceCommand* self,
                                                       DataSource* source);
static void _multiple_data_source_command_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                         DataSource* source,
                                                                                         gpointer self);
static void multiple_data_source_command_real_execute (Command* base);
static void multiple_data_source_command_start_transaction (MultipleDataSourceCommand* self);
static void multiple_data_source_command_execute_all (MultipleDataSourceCommand* self,
                                               gboolean exec,
                                               gboolean can_cancel,
                                               GeeArrayList* todo,
                                               GeeArrayList* completed);
static void multiple_data_source_command_commit_transaction (MultipleDataSourceCommand* self);
static void multiple_data_source_command_real_execute_on_source (MultipleDataSourceCommand* self,
                                                          DataSource* source);
static void multiple_data_source_command_real_undo (Command* base);
static void multiple_data_source_command_real_undo_on_source (MultipleDataSourceCommand* self,
                                                       DataSource* source);
static void multiple_data_source_command_finalize (GObject * obj);
static GType multiple_data_source_command_get_type_once (void);
static void multiple_data_source_at_once_command_on_sources_destroyed (MultipleDataSourceAtOnceCommand* self,
                                                                GeeCollection* destroyed);
static void _multiple_data_source_at_once_command_on_sources_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                                                   GeeCollection* destroyed,
                                                                                                   gpointer self);
static void multiple_data_source_at_once_command_real_execute (Command* base);
static void multiple_data_source_at_once_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* self,
                                                               GeeCollection* sources);
static void multiple_data_source_at_once_command_real_undo (Command* base);
static void multiple_data_source_at_once_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* self,
                                                            GeeCollection* sources);
static void multiple_data_source_at_once_command_finalize (GObject * obj);
static GType multiple_data_source_at_once_command_get_type_once (void);
static void multiple_photo_transformation_command_on_state_broken (MultiplePhotoTransformationCommand* self);
static void _multiple_photo_transformation_command_on_state_broken_photo_transformation_state_broken (PhotoTransformationState* _sender,
                                                                                               gpointer self);
static void multiple_photo_transformation_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                                DataSource* source);
static void multiple_photo_transformation_command_finalize (GObject * obj);
static GType multiple_photo_transformation_command_get_type_once (void);
static void rotate_single_command_real_execute (Command* base);
static void rotate_single_command_real_undo (Command* base);
static void rotate_single_command_finalize (GObject * obj);
static GType rotate_single_command_get_type_once (void);
static void rotate_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                     DataSource* source);
static void rotate_multiple_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                  DataSource* source);
static void rotate_multiple_command_finalize (GObject * obj);
static GType rotate_multiple_command_get_type_once (void);
static void edit_title_command_real_execute (Command* base);
static void edit_title_command_real_undo (Command* base);
static void edit_title_command_finalize (GObject * obj);
static GType edit_title_command_get_type_once (void);
static void edit_comment_command_real_execute (Command* base);
static void edit_comment_command_real_undo (Command* base);
static void edit_comment_command_finalize (GObject * obj);
static GType edit_comment_command_get_type_once (void);
static void edit_multiple_titles_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* base,
                                                       GeeCollection* sources);
static void edit_multiple_titles_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* base,
                                                    GeeCollection* sources);
static void edit_multiple_titles_command_finalize (GObject * obj);
static GType edit_multiple_titles_command_get_type_once (void);
static void edit_multiple_comments_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* base,
                                                         GeeCollection* sources);
static void edit_multiple_comments_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* base,
                                                      GeeCollection* sources);
static void edit_multiple_comments_command_finalize (GObject * obj);
static GType edit_multiple_comments_command_get_type_once (void);
static void rename_event_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                  DataSource* source);
static void rename_event_command_real_undo_on_source (SimpleProxyableCommand* base,
                                               DataSource* source);
static void rename_event_command_finalize (GObject * obj);
static GType rename_event_command_get_type_once (void);
static void edit_event_comment_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                        DataSource* source);
static void edit_event_comment_command_real_undo_on_source (SimpleProxyableCommand* base,
                                                     DataSource* source);
static void edit_event_comment_command_finalize (GObject * obj);
static GType edit_event_comment_command_get_type_once (void);
static void set_key_photo_command_real_execute (Command* base);
static void set_key_photo_command_real_undo (Command* base);
static void set_key_photo_command_finalize (GObject * obj);
static GType set_key_photo_command_get_type_once (void);
static void revert_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                                  Photo* photo);
static gboolean revert_single_command_real_compress (Command* base,
                                              Command* command);
static GType revert_single_command_get_type_once (void);
static void revert_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                     DataSource* source);
static GType revert_multiple_command_get_type_once (void);
static void enhance_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                                   Photo* photo);
static gboolean enhance_single_command_real_compress (Command* base,
                                               Command* command);
static GType enhance_single_command_get_type_once (void);
static void enhance_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                      DataSource* source);
static GType enhance_multiple_command_get_type_once (void);
static void un_enhance_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                                      Photo* photo);
static gboolean un_enhance_single_command_real_compress (Command* base,
                                                  Command* command);
static GType un_enhance_single_command_get_type_once (void);
static void un_enhance_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                         DataSource* source);
static GType un_enhance_multiple_command_get_type_once (void);
static void straighten_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                               Photo* photo);
static void straighten_command_finalize (GObject * obj);
static GType straighten_command_get_type_once (void);
static void crop_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                         Photo* photo);
static void crop_command_finalize (GObject * obj);
static GType crop_command_get_type_once (void);
static void adjust_colors_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                                         Photo* photo);
static gboolean adjust_colors_single_command_real_can_compress (GenericPhotoTransformationCommand* base,
                                                         Command* command);
static void adjust_colors_single_command_finalize (GObject * obj);
static GType adjust_colors_single_command_get_type_once (void);
static void adjust_colors_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                            DataSource* source);
static void adjust_colors_multiple_command_finalize (GObject * obj);
static GType adjust_colors_multiple_command_get_type_once (void);
static void redeye_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                           Photo* photo);
static void redeye_command_finalize (GObject * obj);
static GType redeye_command_get_type_once (void);
static void move_photos_command_real_prepare (Command* base);
static void move_photos_command_real_execute (Command* base);
static void move_photos_command_real_undo (Command* base);
static void move_photos_command_real_move_photos_command_on_proxy_broken (MovePhotosCommandRealMovePhotosCommand* self);
static void _move_photos_command_real_move_photos_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                                                        gpointer self);
static void move_photos_command_real_move_photos_command_real_execute (Command* base);
static void move_photos_command_real_move_photos_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                                          DataSource* source);
static void move_photos_command_real_move_photos_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                                       DataSource* source);
static void move_photos_command_real_move_photos_command_finalize (GObject * obj);
static GType move_photos_command_real_move_photos_command_get_type_once (void);
static void move_photos_command_finalize (GObject * obj);
static GType move_photos_command_get_type_once (void);
static GType new_event_command_get_type_once (void);
static GType set_event_command_get_type_once (void);
static GType merge_events_command_get_type_once (void);
static void duplicate_multiple_photos_command_on_photo_destroyed (DuplicateMultiplePhotosCommand* self,
                                                           DataSource* source);
static void _duplicate_multiple_photos_command_on_photo_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                             DataSource* source,
                                                                                             gpointer self);
static void duplicate_multiple_photos_command_real_execute (Command* base);
static void duplicate_multiple_photos_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                               DataSource* source);
static void duplicate_multiple_photos_command_real_undo (Command* base);
static void duplicate_multiple_photos_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                            DataSource* source);
static void duplicate_multiple_photos_command_finalize (GObject * obj);
static GType duplicate_multiple_photos_command_get_type_once (void);
static void set_raw_developer_command_save_source_states (SetRawDeveloperCommand* self,
                                                   GeeIterable* iter);
static gboolean set_raw_developer_command_is_raw_photo (SetRawDeveloperCommand* self,
                                                 Photo* photo);
static void set_raw_developer_command_real_execute (Command* base);
static void set_raw_developer_command_real_undo (Command* base);
static void set_raw_developer_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                       DataSource* source);
static void set_raw_developer_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                    DataSource* source);
static void set_raw_developer_command_finalize (GObject * obj);
static GType set_raw_developer_command_get_type_once (void);
static void adjust_date_time_photo_command_real_execute (Command* base);
static void adjust_date_time_photo_command_set_time (AdjustDateTimePhotoCommand* self,
                                              Dateable* dateable,
                                              gint64 exposure_time);
static void adjust_date_time_photo_command_real_undo (Command* base);
static void adjust_date_time_photo_command_finalize (GObject * obj);
static GType adjust_date_time_photo_command_get_type_once (void);
static gint64* _int64_dup (gint64* self);
static void adjust_date_time_photos_command_real_execute (Command* base);
static void adjust_date_time_photos_command_real_undo (Command* base);
static void adjust_date_time_photos_command_set_time (AdjustDateTimePhotosCommand* self,
                                               Dateable* dateable,
                                               gint64 exposure_time);
static void adjust_date_time_photos_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                             DataSource* source);
static void adjust_date_time_photos_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                          DataSource* source);
static void adjust_date_time_photos_command_finalize (GObject * obj);
static GType adjust_date_time_photos_command_get_type_once (void);
static void add_tags_command_on_proxy_broken (AddTagsCommand* self);
static void _add_tags_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                            gpointer self);
static void add_tags_command_on_source_destroyed (AddTagsCommand* self,
                                           DataSource* source);
static void _add_tags_command_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                             DataSource* source,
                                                                             gpointer self);
VALA_EXTERN GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path);
static void add_tags_command_real_execute (Command* base);
static void add_tags_command_real_undo (Command* base);
static void add_tags_command_finalize (GObject * obj);
static GType add_tags_command_get_type_once (void);
static void rename_tag_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                DataSource* source);
static void rename_tag_command_real_undo_on_source (SimpleProxyableCommand* base,
                                             DataSource* source);
static void rename_tag_command_finalize (GObject * obj);
static GType rename_tag_command_get_type_once (void);
static void delete_tag_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                DataSource* source);
static void delete_tag_command_on_proxy_broken (DeleteTagCommand* self);
static void _delete_tag_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                              gpointer self);
static void delete_tag_command_real_undo_on_source (SimpleProxyableCommand* base,
                                             DataSource* source);
static void delete_tag_command_finalize (GObject * obj);
static GType delete_tag_command_get_type_once (void);
static void new_child_tag_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                   DataSource* source);
static void new_child_tag_command_real_undo_on_source (SimpleProxyableCommand* base,
                                                DataSource* source);
static void new_child_tag_command_finalize (GObject * obj);
static GType new_child_tag_command_get_type_once (void);
static void new_root_tag_command_real_execute (Command* base);
static void new_root_tag_command_real_undo (Command* base);
static void new_root_tag_command_finalize (GObject * obj);
static GType new_root_tag_command_get_type_once (void);
static void reparent_tag_command_on_items_destroyed (ReparentTagCommand* self,
                                              GeeCollection* destroyed);
static void _reparent_tag_command_on_items_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                                 GeeCollection* destroyed,
                                                                                 gpointer self);
VALA_EXTERN gchar* hierarchical_tag_utilities_get_root_path_form (const gchar* client_path);
static GeeMap* reparent_tag_command_get_child_structure_at (ReparentTagCommand* self,
                                                     const gchar* client_path);
static void reparent_tag_command_restore_child_attachments_at (ReparentTagCommand* self,
                                                        const gchar* client_path,
                                                        GeeMap* child_structure);
static void reparent_tag_command_reattach_in_play_sources_at (ReparentTagCommand* self,
                                                       const gchar* client_path);
static void reparent_tag_command_save_before_state (ReparentTagCommand* self);
static void reparent_tag_command_restore_before_state (ReparentTagCommand* self);
static void reparent_tag_command_save_after_state (ReparentTagCommand* self);
static void reparent_tag_command_restore_after_state (ReparentTagCommand* self);
static void reparent_tag_command_prepare_parent (ReparentTagCommand* self,
                                          const gchar* path);
static void reparent_tag_command_do_source_parent_detachments (ReparentTagCommand* self);
static void reparent_tag_command_do_source_parent_reattachments (ReparentTagCommand* self);
static void reparent_tag_command_do_destination_parent_detachments (ReparentTagCommand* self);
static void reparent_tag_command_do_destination_parent_reattachments (ReparentTagCommand* self);
static void reparent_tag_command_copy_subtree (ReparentTagCommand* self,
                                        const gchar* from,
                                        const gchar* to);
static void reparent_tag_command_destroy_subtree (ReparentTagCommand* self,
                                           const gchar* client_path);
static void reparent_tag_command_real_execute (Command* base);
static void reparent_tag_command_real_undo (Command* base);
VALA_EXTERN void hierarchical_tag_utilities_cleanup_root_path (const gchar* path);
static void reparent_tag_command_finalize (GObject * obj);
static GType reparent_tag_command_get_type_once (void);
static void modify_tags_command_on_proxy_broken (ModifyTagsCommand* self);
static void _modify_tags_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                               gpointer self);
static void modify_tags_command_real_execute (Command* base);
static void modify_tags_command_real_undo (Command* base);
static void modify_tags_command_finalize (GObject * obj);
static GType modify_tags_command_get_type_once (void);
static void tag_untag_photos_command_on_source_destroyed (TagUntagPhotosCommand* self,
                                                   DataSource* source);
static void _tag_untag_photos_command_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                     DataSource* source,
                                                                                     gpointer self);
static void tag_untag_photos_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                      DataSource* source);
static void tag_untag_photos_command_do_attach (TagUntagPhotosCommand* self,
                                         Tag* tag);
static void tag_untag_photos_command_do_detach (TagUntagPhotosCommand* self,
                                         Tag* tag);
static void tag_untag_photos_command_real_undo_on_source (SimpleProxyableCommand* base,
                                                   DataSource* source);
static void tag_untag_photos_command_finalize (GObject * obj);
static GType tag_untag_photos_command_get_type_once (void);
static void rename_saved_search_command_real_execute (Command* base);
static void rename_saved_search_command_real_undo (Command* base);
static void rename_saved_search_command_finalize (GObject * obj);
static GType rename_saved_search_command_get_type_once (void);
static void delete_saved_search_command_real_execute (Command* base);
static void delete_saved_search_command_real_undo (Command* base);
static void delete_saved_search_command_finalize (GObject * obj);
static GType delete_saved_search_command_get_type_once (void);
static void trash_untrash_photos_command_on_photo_destroyed (TrashUntrashPhotosCommand* self,
                                                      DataSource* source);
static void _trash_untrash_photos_command_on_photo_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                        DataSource* source,
                                                                                        gpointer self);
static ProgressDialog* trash_untrash_photos_command_get_progress_dialog (TrashUntrashPhotosCommand* self,
                                                                  gboolean to_trash);
static void trash_untrash_photos_command_real_execute (Command* base);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
static void trash_untrash_photos_command_trash (TrashUntrashPhotosCommand* self,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
static void trash_untrash_photos_command_untrash (TrashUntrashPhotosCommand* self,
                                           ProgressMonitor monitor,
                                           gpointer monitor_target);
static void trash_untrash_photos_command_real_undo (Command* base);
static void trash_untrash_photos_command_finalize (GObject * obj);
static GType trash_untrash_photos_command_get_type_once (void);
static void flag_unflag_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* base,
                                              GeeCollection* sources);
static void flag_unflag_command_flag_unflag (FlagUnflagCommand* self,
                                      DataSource* source,
                                      gboolean flag);
static void flag_unflag_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* base,
                                           GeeCollection* sources);
static void flag_unflag_command_finalize (GObject * obj);
static GType flag_unflag_command_get_type_once (void);

static inline gpointer
page_command_get_instance_private (PageCommand* self)
{
	return G_STRUCT_MEMBER_P (self, PageCommand_private_offset);
}

static void
_page_command_on_page_destroyed_gtk_widget_destroy (GtkWidget* _sender,
                                                    gpointer self)
{
	page_command_on_page_destroyed ((PageCommand*) self);
}

static void
_page_command_on_photo_destroyed_data_source_destroyed (DataSource* _sender,
                                                        gpointer self)
{
	page_command_on_photo_destroyed ((PageCommand*) self);
}

static void
_page_command_on_controller_destroyed_gtk_widget_destroy (GtkWidget* _sender,
                                                          gpointer self)
{
	page_command_on_controller_destroyed ((PageCommand*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PageCommand*
page_command_construct (GType object_type,
                        const gchar* name,
                        const gchar* explanation)
{
	PageCommand * self = NULL;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (PageCommand*) command_construct (object_type, name, explanation);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = page_window_get_current_page ((PageWindow*) _tmp1_);
	_g_object_unref0 (self->priv->page);
	self->priv->page = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		LibraryPhotoPage* photo_page = NULL;
		Page* _tmp5_;
		LibraryPhotoPage* _tmp6_;
		LibraryPhotoPage* _tmp7_;
		_tmp4_ = self->priv->page;
		g_signal_connect_object ((GtkWidget*) _tmp4_, "destroy", (GCallback) _page_command_on_page_destroyed_gtk_widget_destroy, self, 0);
		_tmp5_ = self->priv->page;
		_tmp6_ = _g_object_ref0 (IS_LIBRARY_PHOTO_PAGE (_tmp5_) ? ((LibraryPhotoPage*) _tmp5_) : NULL);
		photo_page = _tmp6_;
		_tmp7_ = photo_page;
		if (_tmp7_ != NULL) {
			LibraryPhotoPage* _tmp8_;
			Photo* _tmp9_;
			LibraryPhotoPage* _tmp10_;
			CollectionPage* _tmp11_;
			gboolean _tmp12_ = FALSE;
			Photo* _tmp13_;
			_tmp8_ = photo_page;
			_tmp9_ = editing_host_page_get_photo ((EditingHostPage*) _tmp8_);
			_g_object_unref0 (self->priv->library_photo);
			self->priv->library_photo = _tmp9_;
			_tmp10_ = photo_page;
			_tmp11_ = library_photo_page_get_controller_page (_tmp10_);
			_g_object_unref0 (self->priv->collection_page);
			self->priv->collection_page = _tmp11_;
			_tmp13_ = self->priv->library_photo;
			if (_tmp13_ != NULL) {
				CollectionPage* _tmp14_;
				_tmp14_ = self->priv->collection_page;
				_tmp12_ = _tmp14_ != NULL;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				Photo* _tmp15_;
				CollectionPage* _tmp16_;
				_tmp15_ = self->priv->library_photo;
				g_signal_connect_object ((DataSource*) _tmp15_, "destroyed", (GCallback) _page_command_on_photo_destroyed_data_source_destroyed, self, 0);
				_tmp16_ = self->priv->collection_page;
				g_signal_connect_object ((GtkWidget*) _tmp16_, "destroy", (GCallback) _page_command_on_controller_destroyed_gtk_widget_destroy, self, 0);
			} else {
				_g_object_unref0 (self->priv->library_photo);
				self->priv->library_photo = NULL;
				_g_object_unref0 (self->priv->collection_page);
				self->priv->collection_page = NULL;
			}
		}
		_g_object_unref0 (photo_page);
	}
	return self;
}

void
page_command_set_auto_return_to_page (PageCommand* self,
                                      gboolean auto_return)
{
	g_return_if_fail (self != NULL);
	self->priv->auto_return = auto_return;
}

static void
page_command_real_prepare (Command* base)
{
	PageCommand * self;
	self = (PageCommand*) base;
	if (self->priv->auto_return) {
		page_command_return_to_page (self);
	}
	COMMAND_CLASS (page_command_parent_class)->prepare (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_COMMAND, Command));
}

void
page_command_return_to_page (PageCommand* self)
{
	LibraryPhotoPage* photo_page = NULL;
	Page* _tmp0_;
	LibraryPhotoPage* _tmp1_;
	LibraryPhotoPage* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page;
	_tmp1_ = _g_object_ref0 (IS_LIBRARY_PHOTO_PAGE (_tmp0_) ? ((LibraryPhotoPage*) _tmp0_) : NULL);
	photo_page = _tmp1_;
	_tmp2_ = photo_page;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		Photo* _tmp4_;
		_tmp4_ = self->priv->library_photo;
		if (_tmp4_ != NULL) {
			CollectionPage* _tmp5_;
			_tmp5_ = self->priv->collection_page;
			_tmp3_ = _tmp5_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gboolean photo_in_collection = FALSE;
			gint count = 0;
			CollectionPage* _tmp6_;
			ViewCollection* _tmp7_;
			ViewCollection* _tmp8_;
			gint _tmp9_;
			photo_in_collection = FALSE;
			_tmp6_ = self->priv->collection_page;
			_tmp7_ = page_get_view ((Page*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = data_collection_get_count ((DataCollection*) _tmp8_);
			_data_collection_unref0 (_tmp8_);
			count = _tmp9_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp10_ = FALSE;
					_tmp10_ = TRUE;
					while (TRUE) {
						CollectionPage* _tmp12_;
						ViewCollection* _tmp13_;
						ViewCollection* _tmp14_;
						DataObject* _tmp15_;
						Thumbnail* _tmp16_;
						MediaSource* _tmp17_;
						MediaSource* _tmp18_;
						Photo* _tmp19_;
						gboolean _tmp20_;
						if (!_tmp10_) {
							gint _tmp11_;
							_tmp11_ = i;
							i = _tmp11_ + 1;
						}
						_tmp10_ = FALSE;
						if (!(i < count)) {
							break;
						}
						_tmp12_ = self->priv->collection_page;
						_tmp13_ = page_get_view ((Page*) _tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = data_collection_get_at ((DataCollection*) _tmp14_, i);
						_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_THUMBNAIL, Thumbnail);
						_tmp17_ = thumbnail_get_media_source (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = self->priv->library_photo;
						_tmp20_ = _tmp18_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_MEDIA_SOURCE, MediaSource);
						_g_object_unref0 (_tmp18_);
						_g_object_unref0 (_tmp16_);
						_data_collection_unref0 (_tmp14_);
						if (_tmp20_) {
							photo_in_collection = TRUE;
							break;
						}
					}
				}
			}
			if (photo_in_collection) {
				LibraryWindow* _tmp21_;
				LibraryWindow* _tmp22_;
				CollectionPage* _tmp23_;
				Photo* _tmp24_;
				_tmp21_ = library_window_get_app ();
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->collection_page;
				_tmp24_ = self->priv->library_photo;
				library_window_switch_to_photo_page (_tmp22_, _tmp23_, _tmp24_);
				_g_object_unref0 (_tmp22_);
			}
		}
	} else {
		Page* _tmp25_;
		_tmp25_ = self->priv->page;
		if (_tmp25_ != NULL) {
			AppWindow* _tmp26_;
			AppWindow* _tmp27_;
			Page* _tmp28_;
			_tmp26_ = app_window_get_instance ();
			_tmp27_ = _tmp26_;
			_tmp28_ = self->priv->page;
			page_window_set_current_page ((PageWindow*) _tmp27_, _tmp28_);
			_g_object_unref0 (_tmp27_);
		}
	}
	_g_object_unref0 (photo_page);
}

static void
page_command_on_page_destroyed (PageCommand* self)
{
	Page* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page;
	g_signal_parse_name ("destroy", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_command_on_page_destroyed_gtk_widget_destroy, self);
	_g_object_unref0 (self->priv->page);
	self->priv->page = NULL;
}

static void
page_command_on_photo_destroyed (PageCommand* self)
{
	Photo* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->library_photo;
	g_signal_parse_name ("destroyed", TYPE_DATA_SOURCE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataSource*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_command_on_photo_destroyed_data_source_destroyed, self);
	_g_object_unref0 (self->priv->library_photo);
	self->priv->library_photo = NULL;
}

static void
page_command_on_controller_destroyed (PageCommand* self)
{
	CollectionPage* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->collection_page;
	g_signal_parse_name ("destroy", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_command_on_controller_destroyed_gtk_widget_destroy, self);
	_g_object_unref0 (self->priv->collection_page);
	self->priv->collection_page = NULL;
}

static void
page_command_class_init (PageCommandClass * klass,
                         gpointer klass_data)
{
	page_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageCommand_private_offset);
	((CommandClass *) klass)->prepare = (void (*) (Command*)) page_command_real_prepare;
	G_OBJECT_CLASS (klass)->finalize = page_command_finalize;
}

static void
page_command_instance_init (PageCommand * self,
                            gpointer klass)
{
	self->priv = page_command_get_instance_private (self);
	self->priv->auto_return = TRUE;
	self->priv->library_photo = NULL;
	self->priv->collection_page = NULL;
}

static void
page_command_finalize (GObject * obj)
{
	PageCommand * self;
	Page* _tmp0_;
	Photo* _tmp3_;
	CollectionPage* _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_COMMAND, PageCommand);
	_tmp0_ = self->priv->page;
	if (_tmp0_ != NULL) {
		Page* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->page;
		g_signal_parse_name ("destroy", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _page_command_on_page_destroyed_gtk_widget_destroy, self);
	}
	_tmp3_ = self->priv->library_photo;
	if (_tmp3_ != NULL) {
		Photo* _tmp4_;
		guint _tmp5_;
		_tmp4_ = self->priv->library_photo;
		g_signal_parse_name ("destroyed", TYPE_DATA_SOURCE, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((DataSource*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_command_on_photo_destroyed_data_source_destroyed, self);
	}
	_tmp6_ = self->priv->collection_page;
	if (_tmp6_ != NULL) {
		CollectionPage* _tmp7_;
		guint _tmp8_;
		_tmp7_ = self->priv->collection_page;
		g_signal_parse_name ("destroy", gtk_widget_get_type (), &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _page_command_on_controller_destroyed_gtk_widget_destroy, self);
	}
	_g_object_unref0 (self->priv->page);
	_g_object_unref0 (self->priv->library_photo);
	_g_object_unref0 (self->priv->collection_page);
	G_OBJECT_CLASS (page_command_parent_class)->finalize (obj);
}

static GType
page_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageCommand), 0, (GInstanceInitFunc) page_command_instance_init, NULL };
	GType page_command_type_id;
	page_command_type_id = g_type_register_static (TYPE_COMMAND, "PageCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PageCommand_private_offset = g_type_add_instance_private (page_command_type_id, sizeof (PageCommandPrivate));
	return page_command_type_id;
}

GType
page_command_get_type (void)
{
	static volatile gsize page_command_type_id__once = 0;
	if (g_once_init_enter (&page_command_type_id__once)) {
		GType page_command_type_id;
		page_command_type_id = page_command_get_type_once ();
		g_once_init_leave (&page_command_type_id__once, page_command_type_id);
	}
	return page_command_type_id__once;
}

static void
_single_data_source_command_on_source_destroyed_data_source_destroyed (DataSource* _sender,
                                                                       gpointer self)
{
	single_data_source_command_on_source_destroyed ((SingleDataSourceCommand*) self);
}

SingleDataSourceCommand*
single_data_source_command_construct (GType object_type,
                                      DataSource* source,
                                      const gchar* name,
                                      const gchar* explanation)
{
	SingleDataSourceCommand * self = NULL;
	DataSource* _tmp0_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (SingleDataSourceCommand*) page_command_construct (object_type, name, explanation);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->source);
	self->source = _tmp0_;
	g_signal_connect_object (source, "destroyed", (GCallback) _single_data_source_command_on_source_destroyed_data_source_destroyed, self, 0);
	return self;
}

DataSource*
single_data_source_command_get_source (SingleDataSourceCommand* self)
{
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
single_data_source_command_on_source_destroyed (SingleDataSourceCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
single_data_source_command_class_init (SingleDataSourceCommandClass * klass,
                                       gpointer klass_data)
{
	single_data_source_command_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = single_data_source_command_finalize;
}

static void
single_data_source_command_instance_init (SingleDataSourceCommand * self,
                                          gpointer klass)
{
}

static void
single_data_source_command_finalize (GObject * obj)
{
	SingleDataSourceCommand * self;
	DataSource* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SINGLE_DATA_SOURCE_COMMAND, SingleDataSourceCommand);
	_tmp0_ = self->source;
	g_signal_parse_name ("destroyed", TYPE_DATA_SOURCE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _single_data_source_command_on_source_destroyed_data_source_destroyed, self);
	_g_object_unref0 (self->source);
	G_OBJECT_CLASS (single_data_source_command_parent_class)->finalize (obj);
}

static GType
single_data_source_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SingleDataSourceCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) single_data_source_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingleDataSourceCommand), 0, (GInstanceInitFunc) single_data_source_command_instance_init, NULL };
	GType single_data_source_command_type_id;
	single_data_source_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "SingleDataSourceCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return single_data_source_command_type_id;
}

GType
single_data_source_command_get_type (void)
{
	static volatile gsize single_data_source_command_type_id__once = 0;
	if (g_once_init_enter (&single_data_source_command_type_id__once)) {
		GType single_data_source_command_type_id;
		single_data_source_command_type_id = single_data_source_command_get_type_once ();
		g_once_init_leave (&single_data_source_command_type_id__once, single_data_source_command_type_id);
	}
	return single_data_source_command_type_id__once;
}

static inline gpointer
simple_proxyable_command_get_instance_private (SimpleProxyableCommand* self)
{
	return G_STRUCT_MEMBER_P (self, SimpleProxyableCommand_private_offset);
}

static void
_simple_proxyable_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                               gpointer self)
{
	simple_proxyable_command_on_proxy_broken ((SimpleProxyableCommand*) self);
}

SimpleProxyableCommand*
simple_proxyable_command_construct (GType object_type,
                                    Proxyable* proxyable,
                                    const gchar* name,
                                    const gchar* explanation)
{
	SimpleProxyableCommand * self = NULL;
	SourceProxy* _tmp0_;
	SourceProxy* _tmp1_;
	g_return_val_if_fail (proxyable != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (SimpleProxyableCommand*) page_command_construct (object_type, name, explanation);
	_tmp0_ = proxyable_get_proxy (proxyable);
	_source_proxy_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp0_;
	_tmp1_ = self->priv->proxy;
	g_signal_connect_object (_tmp1_, "broken", (GCallback) _simple_proxyable_command_on_proxy_broken_source_proxy_broken, self, 0);
	return self;
}

static void
simple_proxyable_command_real_execute (Command* base)
{
	SimpleProxyableCommand * self;
	SourceProxy* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	self = (SimpleProxyableCommand*) base;
	_tmp0_ = self->priv->proxy;
	_tmp1_ = source_proxy_get_source (_tmp0_);
	_tmp2_ = _tmp1_;
	simple_proxyable_command_execute_on_source (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
simple_proxyable_command_real_execute_on_source (SimpleProxyableCommand* self,
                                                 DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `simple_proxyable_command_execute_on_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
simple_proxyable_command_execute_on_source (SimpleProxyableCommand* self,
                                            DataSource* source)
{
	SimpleProxyableCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIMPLE_PROXYABLE_COMMAND_GET_CLASS (self);
	if (_klass_->execute_on_source) {
		_klass_->execute_on_source (self, source);
	}
}

static void
simple_proxyable_command_real_undo (Command* base)
{
	SimpleProxyableCommand * self;
	SourceProxy* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	self = (SimpleProxyableCommand*) base;
	_tmp0_ = self->priv->proxy;
	_tmp1_ = source_proxy_get_source (_tmp0_);
	_tmp2_ = _tmp1_;
	simple_proxyable_command_undo_on_source (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
simple_proxyable_command_real_undo_on_source (SimpleProxyableCommand* self,
                                              DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `simple_proxyable_command_undo_on_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
simple_proxyable_command_undo_on_source (SimpleProxyableCommand* self,
                                         DataSource* source)
{
	SimpleProxyableCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIMPLE_PROXYABLE_COMMAND_GET_CLASS (self);
	if (_klass_->undo_on_source) {
		_klass_->undo_on_source (self, source);
	}
}

void
simple_proxyable_command_add_proxyables (SimpleProxyableCommand* self,
                                         GeeCollection* proxyables)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxyables != NULL);
	{
		GeeIterator* _proxyable_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) proxyables);
		_proxyable_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			Proxyable* proxyable = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			SourceProxy* added_proxy = NULL;
			Proxyable* _tmp4_;
			SourceProxy* _tmp5_;
			SourceProxy* _tmp6_;
			GeeHashSet* _tmp7_;
			SourceProxy* _tmp8_;
			_tmp1_ = _proxyable_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _proxyable_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			proxyable = (Proxyable*) _tmp3_;
			_tmp4_ = proxyable;
			_tmp5_ = proxyable_get_proxy (_tmp4_);
			added_proxy = _tmp5_;
			_tmp6_ = added_proxy;
			g_signal_connect_object (_tmp6_, "broken", (GCallback) _simple_proxyable_command_on_proxy_broken_source_proxy_broken, self, 0);
			_tmp7_ = self->priv->proxies;
			_tmp8_ = added_proxy;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			_source_proxy_unref0 (added_proxy);
			_g_object_unref0 (proxyable);
		}
		_g_object_unref0 (_proxyable_it);
	}
}

void
simple_proxyable_command_clear_added_proxies (SimpleProxyableCommand* self)
{
	GeeHashSet* _tmp7_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _added_proxy_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->proxies;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_added_proxy_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceProxy* added_proxy = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceProxy* _tmp5_;
			guint _tmp6_;
			_tmp2_ = _added_proxy_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _added_proxy_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			added_proxy = (SourceProxy*) _tmp4_;
			_tmp5_ = added_proxy;
			g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _simple_proxyable_command_on_proxy_broken_source_proxy_broken, self);
			_source_proxy_unref0 (added_proxy);
		}
		_g_object_unref0 (_added_proxy_it);
	}
	_tmp7_ = self->priv->proxies;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
}

static void
simple_proxyable_command_on_proxy_broken (SimpleProxyableCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	g_debug ("Commands.vala:191: on_proxy_broken");
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
simple_proxyable_command_class_init (SimpleProxyableCommandClass * klass,
                                     gpointer klass_data)
{
	simple_proxyable_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SimpleProxyableCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) simple_proxyable_command_real_execute;
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) simple_proxyable_command_real_execute_on_source;
	((CommandClass *) klass)->undo = (void (*) (Command*)) simple_proxyable_command_real_undo;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) simple_proxyable_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = simple_proxyable_command_finalize;
}

static void
simple_proxyable_command_instance_init (SimpleProxyableCommand * self,
                                        gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->priv = simple_proxyable_command_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->proxies = _tmp0_;
}

static void
simple_proxyable_command_finalize (GObject * obj)
{
	SimpleProxyableCommand * self;
	SourceProxy* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_PROXYABLE_COMMAND, SimpleProxyableCommand);
	_tmp0_ = self->priv->proxy;
	g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _simple_proxyable_command_on_proxy_broken_source_proxy_broken, self);
	simple_proxyable_command_clear_added_proxies (self);
	_source_proxy_unref0 (self->priv->proxy);
	_g_object_unref0 (self->priv->proxies);
	G_OBJECT_CLASS (simple_proxyable_command_parent_class)->finalize (obj);
}

static GType
simple_proxyable_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SimpleProxyableCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_proxyable_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleProxyableCommand), 0, (GInstanceInitFunc) simple_proxyable_command_instance_init, NULL };
	GType simple_proxyable_command_type_id;
	simple_proxyable_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "SimpleProxyableCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SimpleProxyableCommand_private_offset = g_type_add_instance_private (simple_proxyable_command_type_id, sizeof (SimpleProxyableCommandPrivate));
	return simple_proxyable_command_type_id;
}

GType
simple_proxyable_command_get_type (void)
{
	static volatile gsize simple_proxyable_command_type_id__once = 0;
	if (g_once_init_enter (&simple_proxyable_command_type_id__once)) {
		GType simple_proxyable_command_type_id;
		simple_proxyable_command_type_id = simple_proxyable_command_get_type_once ();
		g_once_init_leave (&simple_proxyable_command_type_id__once, simple_proxyable_command_type_id);
	}
	return simple_proxyable_command_type_id__once;
}

static inline gpointer
single_photo_transformation_command_get_instance_private (SinglePhotoTransformationCommand* self)
{
	return G_STRUCT_MEMBER_P (self, SinglePhotoTransformationCommand_private_offset);
}

static void
_single_photo_transformation_command_on_state_broken_photo_transformation_state_broken (PhotoTransformationState* _sender,
                                                                                        gpointer self)
{
	single_photo_transformation_command_on_state_broken ((SinglePhotoTransformationCommand*) self);
}

SinglePhotoTransformationCommand*
single_photo_transformation_command_construct (GType object_type,
                                               Photo* photo,
                                               const gchar* name,
                                               const gchar* explanation)
{
	SinglePhotoTransformationCommand * self = NULL;
	PhotoTransformationState* _tmp0_;
	PhotoTransformationState* _tmp1_;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (SinglePhotoTransformationCommand*) single_data_source_command_construct (object_type, (DataSource*) photo, name, explanation);
	_tmp0_ = photo_save_transformation_state (photo);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp0_;
	_tmp1_ = self->priv->state;
	g_signal_connect_object (_tmp1_, "broken", (GCallback) _single_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self, 0);
	return self;
}

static void
single_photo_transformation_command_real_undo (Command* base)
{
	SinglePhotoTransformationCommand * self;
	DataSource* _tmp0_;
	PhotoTransformationState* _tmp1_;
	self = (SinglePhotoTransformationCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->state;
	photo_load_transformation_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo), _tmp1_);
}

static void
single_photo_transformation_command_on_state_broken (SinglePhotoTransformationCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
single_photo_transformation_command_class_init (SinglePhotoTransformationCommandClass * klass,
                                                gpointer klass_data)
{
	single_photo_transformation_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SinglePhotoTransformationCommand_private_offset);
	((CommandClass *) klass)->undo = (void (*) (Command*)) single_photo_transformation_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = single_photo_transformation_command_finalize;
}

static void
single_photo_transformation_command_instance_init (SinglePhotoTransformationCommand * self,
                                                   gpointer klass)
{
	self->priv = single_photo_transformation_command_get_instance_private (self);
}

static void
single_photo_transformation_command_finalize (GObject * obj)
{
	SinglePhotoTransformationCommand * self;
	PhotoTransformationState* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SINGLE_PHOTO_TRANSFORMATION_COMMAND, SinglePhotoTransformationCommand);
	_tmp0_ = self->priv->state;
	g_signal_parse_name ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _single_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self);
	_g_object_unref0 (self->priv->state);
	G_OBJECT_CLASS (single_photo_transformation_command_parent_class)->finalize (obj);
}

static GType
single_photo_transformation_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SinglePhotoTransformationCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) single_photo_transformation_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SinglePhotoTransformationCommand), 0, (GInstanceInitFunc) single_photo_transformation_command_instance_init, NULL };
	GType single_photo_transformation_command_type_id;
	single_photo_transformation_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "SinglePhotoTransformationCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SinglePhotoTransformationCommand_private_offset = g_type_add_instance_private (single_photo_transformation_command_type_id, sizeof (SinglePhotoTransformationCommandPrivate));
	return single_photo_transformation_command_type_id;
}

GType
single_photo_transformation_command_get_type (void)
{
	static volatile gsize single_photo_transformation_command_type_id__once = 0;
	if (g_once_init_enter (&single_photo_transformation_command_type_id__once)) {
		GType single_photo_transformation_command_type_id;
		single_photo_transformation_command_type_id = single_photo_transformation_command_get_type_once ();
		g_once_init_leave (&single_photo_transformation_command_type_id__once, single_photo_transformation_command_type_id);
	}
	return single_photo_transformation_command_type_id__once;
}

static inline gpointer
generic_photo_transformation_command_get_instance_private (GenericPhotoTransformationCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GenericPhotoTransformationCommand_private_offset);
}

static void
_generic_photo_transformation_command_on_state_broken_photo_transformation_state_broken (PhotoTransformationState* _sender,
                                                                                         gpointer self)
{
	generic_photo_transformation_command_on_state_broken ((GenericPhotoTransformationCommand*) self);
}

GenericPhotoTransformationCommand*
generic_photo_transformation_command_construct (GType object_type,
                                                Photo* photo,
                                                const gchar* name,
                                                const gchar* explanation)
{
	GenericPhotoTransformationCommand * self = NULL;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (GenericPhotoTransformationCommand*) single_data_source_command_construct (object_type, (DataSource*) photo, name, explanation);
	return self;
}

static void
generic_photo_transformation_command_real_execute (Command* base)
{
	GenericPhotoTransformationCommand * self;
	Photo* photo = NULL;
	DataSource* _tmp0_;
	Photo* _tmp1_;
	PhotoTransformationState* _tmp2_;
	PhotoTransformationState* _tmp3_;
	PhotoTransformationState* _tmp4_;
	PhotoTransformationState* _tmp5_;
	self = (GenericPhotoTransformationCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo));
	photo = _tmp1_;
	_tmp2_ = photo_save_transformation_state (photo);
	_g_object_unref0 (self->priv->original_state);
	self->priv->original_state = _tmp2_;
	_tmp3_ = self->priv->original_state;
	g_signal_connect_object (_tmp3_, "broken", (GCallback) _generic_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self, 0);
	generic_photo_transformation_command_execute_on_photo (self, photo);
	_tmp4_ = photo_save_transformation_state (photo);
	_g_object_unref0 (self->priv->transformed_state);
	self->priv->transformed_state = _tmp4_;
	_tmp5_ = self->priv->transformed_state;
	g_signal_connect_object (_tmp5_, "broken", (GCallback) _generic_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self, 0);
	_g_object_unref0 (photo);
}

static void
generic_photo_transformation_command_real_execute_on_photo (GenericPhotoTransformationCommand* self,
                                                            Photo* photo)
{
	g_critical ("Type `%s' does not implement abstract method `generic_photo_transformation_command_execute_on_photo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
generic_photo_transformation_command_execute_on_photo (GenericPhotoTransformationCommand* self,
                                                       Photo* photo)
{
	GenericPhotoTransformationCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GENERIC_PHOTO_TRANSFORMATION_COMMAND_GET_CLASS (self);
	if (_klass_->execute_on_photo) {
		_klass_->execute_on_photo (self, photo);
	}
}

static void
generic_photo_transformation_command_real_undo (Command* base)
{
	GenericPhotoTransformationCommand * self;
	DataSource* _tmp0_;
	PhotoTransformationState* _tmp1_;
	self = (GenericPhotoTransformationCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->original_state;
	photo_load_transformation_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo), _tmp1_);
}

static void
generic_photo_transformation_command_real_redo (Command* base)
{
	GenericPhotoTransformationCommand * self;
	DataSource* _tmp0_;
	PhotoTransformationState* _tmp1_;
	self = (GenericPhotoTransformationCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->transformed_state;
	photo_load_transformation_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo), _tmp1_);
}

static gboolean
generic_photo_transformation_command_real_can_compress (GenericPhotoTransformationCommand* self,
                                                        Command* command)
{
	gboolean result;
	g_return_val_if_fail (command != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
generic_photo_transformation_command_can_compress (GenericPhotoTransformationCommand* self,
                                                   Command* command)
{
	GenericPhotoTransformationCommandClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = GENERIC_PHOTO_TRANSFORMATION_COMMAND_GET_CLASS (self);
	if (_klass_->can_compress) {
		return _klass_->can_compress (self, command);
	}
	return FALSE;
}

static gboolean
generic_photo_transformation_command_real_compress (Command* base,
                                                    Command* command)
{
	GenericPhotoTransformationCommand * self;
	gboolean result;
	self = (GenericPhotoTransformationCommand*) base;
	g_return_val_if_fail (command != NULL, FALSE);
	if (!generic_photo_transformation_command_can_compress (self, command)) {
		result = FALSE;
		return result;
	}
	if (IS_GENERIC_PHOTO_TRANSFORMATION_COMMAND (command)) {
		GenericPhotoTransformationCommand* generic = NULL;
		GenericPhotoTransformationCommand* _tmp0_;
		GenericPhotoTransformationCommand* _tmp1_;
		DataSource* _tmp2_;
		DataSource* _tmp3_;
		GenericPhotoTransformationCommand* _tmp4_;
		GenericPhotoTransformationCommand* _tmp5_;
		PhotoTransformationState* _tmp6_;
		PhotoTransformationState* _tmp7_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (command, TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, GenericPhotoTransformationCommand));
		generic = _tmp0_;
		_tmp1_ = generic;
		_tmp2_ = ((SingleDataSourceCommand*) _tmp1_)->source;
		_tmp3_ = ((SingleDataSourceCommand*) self)->source;
		if (_tmp2_ != _tmp3_) {
			result = FALSE;
			_g_object_unref0 (generic);
			return result;
		}
		_tmp4_ = generic;
		command_execute ((Command*) _tmp4_);
		_tmp5_ = generic;
		_tmp6_ = _tmp5_->priv->transformed_state;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->priv->transformed_state);
		self->priv->transformed_state = _tmp7_;
		result = TRUE;
		_g_object_unref0 (generic);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
generic_photo_transformation_command_on_state_broken (GenericPhotoTransformationCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
generic_photo_transformation_command_class_init (GenericPhotoTransformationCommandClass * klass,
                                                 gpointer klass_data)
{
	generic_photo_transformation_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GenericPhotoTransformationCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) generic_photo_transformation_command_real_execute;
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) generic_photo_transformation_command_real_execute_on_photo;
	((CommandClass *) klass)->undo = (void (*) (Command*)) generic_photo_transformation_command_real_undo;
	((CommandClass *) klass)->redo = (void (*) (Command*)) generic_photo_transformation_command_real_redo;
	((GenericPhotoTransformationCommandClass *) klass)->can_compress = (gboolean (*) (GenericPhotoTransformationCommand*, Command*)) generic_photo_transformation_command_real_can_compress;
	((CommandClass *) klass)->compress = (gboolean (*) (Command*, Command*)) generic_photo_transformation_command_real_compress;
	G_OBJECT_CLASS (klass)->finalize = generic_photo_transformation_command_finalize;
}

static void
generic_photo_transformation_command_instance_init (GenericPhotoTransformationCommand * self,
                                                    gpointer klass)
{
	self->priv = generic_photo_transformation_command_get_instance_private (self);
	self->priv->original_state = NULL;
	self->priv->transformed_state = NULL;
}

static void
generic_photo_transformation_command_finalize (GObject * obj)
{
	GenericPhotoTransformationCommand * self;
	PhotoTransformationState* _tmp0_;
	PhotoTransformationState* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, GenericPhotoTransformationCommand);
	_tmp0_ = self->priv->original_state;
	if (_tmp0_ != NULL) {
		PhotoTransformationState* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->original_state;
		g_signal_parse_name ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _generic_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self);
	}
	_tmp3_ = self->priv->transformed_state;
	if (_tmp3_ != NULL) {
		PhotoTransformationState* _tmp4_;
		guint _tmp5_;
		_tmp4_ = self->priv->transformed_state;
		g_signal_parse_name ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _generic_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self);
	}
	_g_object_unref0 (self->priv->original_state);
	_g_object_unref0 (self->priv->transformed_state);
	G_OBJECT_CLASS (generic_photo_transformation_command_parent_class)->finalize (obj);
}

static GType
generic_photo_transformation_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GenericPhotoTransformationCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generic_photo_transformation_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GenericPhotoTransformationCommand), 0, (GInstanceInitFunc) generic_photo_transformation_command_instance_init, NULL };
	GType generic_photo_transformation_command_type_id;
	generic_photo_transformation_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "GenericPhotoTransformationCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GenericPhotoTransformationCommand_private_offset = g_type_add_instance_private (generic_photo_transformation_command_type_id, sizeof (GenericPhotoTransformationCommandPrivate));
	return generic_photo_transformation_command_type_id;
}

GType
generic_photo_transformation_command_get_type (void)
{
	static volatile gsize generic_photo_transformation_command_type_id__once = 0;
	if (g_once_init_enter (&generic_photo_transformation_command_type_id__once)) {
		GType generic_photo_transformation_command_type_id;
		generic_photo_transformation_command_type_id = generic_photo_transformation_command_get_type_once ();
		g_once_init_leave (&generic_photo_transformation_command_type_id__once, generic_photo_transformation_command_type_id);
	}
	return generic_photo_transformation_command_type_id__once;
}

static inline gpointer
multiple_data_source_command_get_instance_private (MultipleDataSourceCommand* self)
{
	return G_STRUCT_MEMBER_P (self, MultipleDataSourceCommand_private_offset);
}

static void
_multiple_data_source_command_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                    DataSource* source,
                                                                                    gpointer self)
{
	multiple_data_source_command_on_source_destroyed ((MultipleDataSourceCommand*) self, source);
}

MultipleDataSourceCommand*
multiple_data_source_command_construct (GType object_type,
                                        GeeIterable* iter,
                                        const gchar* progress_text,
                                        const gchar* undo_progress_text,
                                        const gchar* name,
                                        const gchar* explanation)
{
	MultipleDataSourceCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (progress_text != NULL, NULL);
	g_return_val_if_fail (undo_progress_text != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (MultipleDataSourceCommand*) page_command_construct (object_type, name, explanation);
	_tmp0_ = g_strdup (progress_text);
	_g_free0 (self->priv->progress_text);
	self->priv->progress_text = _tmp0_;
	_tmp1_ = g_strdup (undo_progress_text);
	_g_free0 (self->priv->undo_progress_text);
	self->priv->undo_progress_text = _tmp1_;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (iter);
		_view_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataView* view = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataSource* source = NULL;
			DataView* _tmp6_;
			DataSource* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			SourceCollection* collection = NULL;
			DataSource* _tmp10_;
			DataCollection* _tmp11_;
			SourceCollection* _tmp12_;
			GeeArrayList* _tmp15_;
			DataSource* _tmp16_;
			_tmp3_ = _view_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _view_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			view = (DataView*) _tmp5_;
			_tmp6_ = view;
			_tmp7_ = data_view_get_source (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			source = _tmp9_;
			_tmp10_ = source;
			_tmp11_ = data_object_get_membership ((DataObject*) _tmp10_);
			collection = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_SOURCE_COLLECTION, SourceCollection);
			_tmp12_ = collection;
			if (_tmp12_ != NULL) {
				GeeHashSet* _tmp13_;
				SourceCollection* _tmp14_;
				_tmp13_ = self->priv->hooked_collections;
				_tmp14_ = collection;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
			}
			_tmp15_ = self->source_list;
			_tmp16_ = source;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			_data_collection_unref0 (collection);
			_g_object_unref0 (source);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	{
		GeeIterator* _current_collection_it = NULL;
		GeeHashSet* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp17_ = self->priv->hooked_collections;
		_tmp18_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp17_);
		_current_collection_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			SourceCollection* current_collection = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			SourceCollection* _tmp22_;
			_tmp19_ = _current_collection_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _current_collection_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			current_collection = (SourceCollection*) _tmp21_;
			_tmp22_ = current_collection;
			g_signal_connect_object (_tmp22_, "item-destroyed", (GCallback) _multiple_data_source_command_on_source_destroyed_source_collection_item_destroyed, self, 0);
			_data_collection_unref0 (current_collection);
		}
		_g_object_unref0 (_current_collection_it);
	}
	return self;
}

GeeIterable*
multiple_data_source_command_get_sources (MultipleDataSourceCommand* self)
{
	GeeArrayList* _tmp0_;
	GeeIterable* _tmp1_;
	GeeIterable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->source_list;
	_tmp1_ = _g_object_ref0 ((GeeIterable*) _tmp0_);
	result = _tmp1_;
	return result;
}

gint
multiple_data_source_command_get_source_count (MultipleDataSourceCommand* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->source_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
multiple_data_source_command_on_source_destroyed (MultipleDataSourceCommand* self,
                                                  DataSource* source)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->source_list;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, source)) {
		CommandManager* _tmp1_;
		CommandManager* _tmp2_;
		_tmp1_ = command_get_command_manager ((Command*) self);
		_tmp2_ = _tmp1_;
		command_manager_reset (_tmp2_);
		_command_manager_unref0 (_tmp2_);
	}
}

static void
multiple_data_source_command_real_execute (Command* base)
{
	MultipleDataSourceCommand * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	self = (MultipleDataSourceCommand*) base;
	_tmp0_ = self->priv->acted_upon;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	multiple_data_source_command_start_transaction (self);
	_tmp1_ = self->source_list;
	_tmp2_ = self->priv->acted_upon;
	multiple_data_source_command_execute_all (self, TRUE, TRUE, _tmp1_, _tmp2_);
	multiple_data_source_command_commit_transaction (self);
}

static void
multiple_data_source_command_real_execute_on_source (MultipleDataSourceCommand* self,
                                                     DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `multiple_data_source_command_execute_on_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
multiple_data_source_command_execute_on_source (MultipleDataSourceCommand* self,
                                                DataSource* source)
{
	MultipleDataSourceCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MULTIPLE_DATA_SOURCE_COMMAND_GET_CLASS (self);
	if (_klass_->execute_on_source) {
		_klass_->execute_on_source (self, source);
	}
}

static void
multiple_data_source_command_real_undo (Command* base)
{
	MultipleDataSourceCommand * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (MultipleDataSourceCommand*) base;
	_tmp0_ = self->priv->acted_upon;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		multiple_data_source_command_start_transaction (self);
		_tmp3_ = self->priv->acted_upon;
		multiple_data_source_command_execute_all (self, FALSE, FALSE, _tmp3_, NULL);
		multiple_data_source_command_commit_transaction (self);
		_tmp4_ = self->priv->acted_upon;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
	}
}

static void
multiple_data_source_command_real_undo_on_source (MultipleDataSourceCommand* self,
                                                  DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `multiple_data_source_command_undo_on_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
multiple_data_source_command_undo_on_source (MultipleDataSourceCommand* self,
                                             DataSource* source)
{
	MultipleDataSourceCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MULTIPLE_DATA_SOURCE_COMMAND_GET_CLASS (self);
	if (_klass_->undo_on_source) {
		_klass_->undo_on_source (self, source);
	}
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static void
multiple_data_source_command_start_transaction (MultipleDataSourceCommand* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _sources_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->hooked_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_sources_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* sources = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			MediaSourceCollection* media_collection = NULL;
			SourceCollection* _tmp5_;
			MediaSourceCollection* _tmp6_;
			MediaSourceCollection* _tmp7_;
			_tmp2_ = _sources_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _sources_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			sources = (SourceCollection*) _tmp4_;
			_tmp5_ = sources;
			_tmp6_ = _data_collection_ref0 (IS_MEDIA_SOURCE_COLLECTION (_tmp5_) ? ((MediaSourceCollection*) _tmp5_) : NULL);
			media_collection = _tmp6_;
			_tmp7_ = media_collection;
			if (_tmp7_ != NULL) {
				MediaSourceCollection* _tmp8_;
				TransactionController* _tmp9_;
				TransactionController* _tmp10_;
				_tmp8_ = media_collection;
				_tmp9_ = media_source_collection_get_transaction_controller (_tmp8_);
				_tmp10_ = _tmp9_;
				transaction_controller_begin (_tmp10_);
			}
			_data_collection_unref0 (media_collection);
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

static void
multiple_data_source_command_commit_transaction (MultipleDataSourceCommand* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _sources_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->hooked_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_sources_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* sources = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			MediaSourceCollection* media_collection = NULL;
			SourceCollection* _tmp5_;
			MediaSourceCollection* _tmp6_;
			MediaSourceCollection* _tmp7_;
			_tmp2_ = _sources_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _sources_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			sources = (SourceCollection*) _tmp4_;
			_tmp5_ = sources;
			_tmp6_ = _data_collection_ref0 (IS_MEDIA_SOURCE_COLLECTION (_tmp5_) ? ((MediaSourceCollection*) _tmp5_) : NULL);
			media_collection = _tmp6_;
			_tmp7_ = media_collection;
			if (_tmp7_ != NULL) {
				MediaSourceCollection* _tmp8_;
				TransactionController* _tmp9_;
				TransactionController* _tmp10_;
				_tmp8_ = media_collection;
				_tmp9_ = media_source_collection_get_transaction_controller (_tmp8_);
				_tmp10_ = _tmp9_;
				transaction_controller_commit (_tmp10_);
			}
			_data_collection_unref0 (media_collection);
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

static void
multiple_data_source_command_execute_all (MultipleDataSourceCommand* self,
                                          gboolean exec,
                                          gboolean can_cancel,
                                          GeeArrayList* todo,
                                          GeeArrayList* completed)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	gint count = 0;
	gint total = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint two_percent = 0;
	const gchar* _tmp4_ = NULL;
	gchar* text = NULL;
	gchar* _tmp7_;
	GCancellable* cancellable = NULL;
	ProgressDialog* progress = NULL;
	ProgressDialog* _tmp33_;
	AppWindow* _tmp35_;
	AppWindow* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (todo != NULL);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	count = 0;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) todo);
	_tmp3_ = _tmp2_;
	total = _tmp3_;
	two_percent = (gint) (((gdouble) total) / 50.0);
	if (two_percent <= 0) {
		two_percent = 1;
	}
	if (exec) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->progress_text;
		_tmp4_ = _tmp5_;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->undo_progress_text;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp4_);
	text = _tmp7_;
	cancellable = NULL;
	progress = NULL;
	if (total >= MULTIPLE_DATA_SOURCE_COMMAND_MIN_OPS_FOR_PROGRESS_WINDOW) {
		GCancellable* _tmp8_ = NULL;
		GCancellable* _tmp10_;
		AppWindow* _tmp11_;
		AppWindow* _tmp12_;
		const gchar* _tmp13_;
		GCancellable* _tmp14_;
		ProgressDialog* _tmp15_;
		if (can_cancel) {
			GCancellable* _tmp9_;
			_tmp9_ = g_cancellable_new ();
			_g_object_unref0 (_tmp8_);
			_tmp8_ = _tmp9_;
		} else {
			_g_object_unref0 (_tmp8_);
			_tmp8_ = NULL;
		}
		_tmp10_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (cancellable);
		cancellable = _tmp10_;
		_tmp11_ = app_window_get_instance ();
		_tmp12_ = _tmp11_;
		_tmp13_ = text;
		_tmp14_ = cancellable;
		_tmp15_ = progress_dialog_new ((GtkWindow*) _tmp12_, _tmp13_, _tmp14_);
		g_object_ref_sink (_tmp15_);
		_g_object_unref0 (progress);
		progress = _tmp15_;
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp8_);
	}
	{
		GeeArrayList* _source_list = NULL;
		gint _source_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _source_index = 0;
		_source_list = todo;
		_tmp16_ = _source_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_source_size = _tmp18_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			DataSource* source = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			ProgressDialog* _tmp26_;
			_source_index = _source_index + 1;
			_tmp19_ = _source_index;
			_tmp20_ = _source_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _source_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _source_index);
			source = (DataSource*) _tmp22_;
			if (exec) {
				DataSource* _tmp23_;
				_tmp23_ = source;
				multiple_data_source_command_execute_on_source (self, _tmp23_);
			} else {
				DataSource* _tmp24_;
				_tmp24_ = source;
				multiple_data_source_command_undo_on_source (self, _tmp24_);
			}
			if (completed != NULL) {
				DataSource* _tmp25_;
				_tmp25_ = source;
				gee_abstract_collection_add ((GeeAbstractCollection*) completed, _tmp25_);
			}
			_tmp26_ = progress;
			if (_tmp26_ != NULL) {
				gint _tmp27_;
				gint _tmp28_;
				gboolean _tmp30_ = FALSE;
				GCancellable* _tmp31_;
				count = count + 1;
				_tmp27_ = count;
				_tmp28_ = two_percent;
				if ((_tmp27_ % _tmp28_) == 0) {
					ProgressDialog* _tmp29_;
					_tmp29_ = progress;
					progress_dialog_set_fraction (_tmp29_, count, total);
					spin_event_loop ();
				}
				_tmp31_ = cancellable;
				if (_tmp31_ != NULL) {
					GCancellable* _tmp32_;
					_tmp32_ = cancellable;
					_tmp30_ = g_cancellable_is_cancelled (_tmp32_);
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					_g_object_unref0 (source);
					break;
				}
			}
			_g_object_unref0 (source);
		}
	}
	_tmp33_ = progress;
	if (_tmp33_ != NULL) {
		ProgressDialog* _tmp34_;
		_tmp34_ = progress;
		progress_dialog_close (_tmp34_);
	}
	_tmp35_ = app_window_get_instance ();
	_tmp36_ = _tmp35_;
	page_window_set_normal_cursor ((PageWindow*) _tmp36_);
	_g_object_unref0 (_tmp36_);
	_g_object_unref0 (progress);
	_g_object_unref0 (cancellable);
	_g_free0 (text);
}

static void
multiple_data_source_command_class_init (MultipleDataSourceCommandClass * klass,
                                         gpointer klass_data)
{
	multiple_data_source_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MultipleDataSourceCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) multiple_data_source_command_real_execute;
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) multiple_data_source_command_real_execute_on_source;
	((CommandClass *) klass)->undo = (void (*) (Command*)) multiple_data_source_command_real_undo;
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) multiple_data_source_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = multiple_data_source_command_finalize;
}

static void
multiple_data_source_command_instance_init (MultipleDataSourceCommand * self,
                                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashSet* _tmp2_;
	self->priv = multiple_data_source_command_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->source_list = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->acted_upon = _tmp1_;
	_tmp2_ = gee_hash_set_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->hooked_collections = _tmp2_;
}

static void
multiple_data_source_command_finalize (GObject * obj)
{
	MultipleDataSourceCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand);
	{
		GeeIterator* _current_collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->hooked_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_current_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* current_collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			guint _tmp6_;
			_tmp2_ = _current_collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _current_collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			current_collection = (SourceCollection*) _tmp4_;
			_tmp5_ = current_collection;
			g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _multiple_data_source_command_on_source_destroyed_source_collection_item_destroyed, self);
			_data_collection_unref0 (current_collection);
		}
		_g_object_unref0 (_current_collection_it);
	}
	_g_object_unref0 (self->source_list);
	_g_free0 (self->priv->progress_text);
	_g_free0 (self->priv->undo_progress_text);
	_g_object_unref0 (self->priv->acted_upon);
	_g_object_unref0 (self->priv->hooked_collections);
	G_OBJECT_CLASS (multiple_data_source_command_parent_class)->finalize (obj);
}

static GType
multiple_data_source_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MultipleDataSourceCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiple_data_source_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultipleDataSourceCommand), 0, (GInstanceInitFunc) multiple_data_source_command_instance_init, NULL };
	GType multiple_data_source_command_type_id;
	multiple_data_source_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "MultipleDataSourceCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	MultipleDataSourceCommand_private_offset = g_type_add_instance_private (multiple_data_source_command_type_id, sizeof (MultipleDataSourceCommandPrivate));
	return multiple_data_source_command_type_id;
}

GType
multiple_data_source_command_get_type (void)
{
	static volatile gsize multiple_data_source_command_type_id__once = 0;
	if (g_once_init_enter (&multiple_data_source_command_type_id__once)) {
		GType multiple_data_source_command_type_id;
		multiple_data_source_command_type_id = multiple_data_source_command_get_type_once ();
		g_once_init_leave (&multiple_data_source_command_type_id__once, multiple_data_source_command_type_id);
	}
	return multiple_data_source_command_type_id__once;
}

static inline gpointer
multiple_data_source_at_once_command_get_instance_private (MultipleDataSourceAtOnceCommand* self)
{
	return G_STRUCT_MEMBER_P (self, MultipleDataSourceAtOnceCommand_private_offset);
}

static void
_multiple_data_source_at_once_command_on_sources_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                                              GeeCollection* destroyed,
                                                                                              gpointer self)
{
	multiple_data_source_at_once_command_on_sources_destroyed ((MultipleDataSourceAtOnceCommand*) self, destroyed);
}

MultipleDataSourceAtOnceCommand*
multiple_data_source_at_once_command_construct (GType object_type,
                                                GeeCollection* sources,
                                                const gchar* name,
                                                const gchar* explanation)
{
	MultipleDataSourceAtOnceCommand * self = NULL;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (sources != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (MultipleDataSourceAtOnceCommand*) page_command_construct (object_type, name, explanation);
	_tmp0_ = self->priv->sources;
	gee_collection_add_all ((GeeCollection*) _tmp0_, sources);
	{
		GeeIterator* _source_it = NULL;
		GeeHashSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->sources;
		_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SourceCollection* membership = NULL;
			DataSource* _tmp6_;
			DataCollection* _tmp7_;
			SourceCollection* _tmp8_;
			SourceCollection* _tmp9_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (DataSource*) _tmp5_;
			_tmp6_ = source;
			_tmp7_ = data_object_get_membership ((DataObject*) _tmp6_);
			_tmp8_ = IS_SOURCE_COLLECTION (_tmp7_) ? ((SourceCollection*) _tmp7_) : NULL;
			if (_tmp8_ == NULL) {
				_data_collection_unref0 (_tmp7_);
			}
			membership = _tmp8_;
			_tmp9_ = membership;
			if (_tmp9_ != NULL) {
				GeeHashSet* _tmp10_;
				SourceCollection* _tmp11_;
				_tmp10_ = self->priv->hooked_collections;
				_tmp11_ = membership;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			_data_collection_unref0 (membership);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	{
		GeeIterator* _source_collection_it = NULL;
		GeeHashSet* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp12_ = self->priv->hooked_collections;
		_tmp13_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp12_);
		_source_collection_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			SourceCollection* source_collection = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			SourceCollection* _tmp17_;
			_tmp14_ = _source_collection_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _source_collection_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			source_collection = (SourceCollection*) _tmp16_;
			_tmp17_ = source_collection;
			g_signal_connect_object (_tmp17_, "items-destroyed", (GCallback) _multiple_data_source_at_once_command_on_sources_destroyed_source_collection_items_destroyed, self, 0);
			_data_collection_unref0 (source_collection);
		}
		_g_object_unref0 (_source_collection_it);
	}
	return self;
}

static void
multiple_data_source_at_once_command_real_execute (Command* base)
{
	MultipleDataSourceAtOnceCommand * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	MediaCollectionRegistry* _tmp2_;
	MediaCollectionRegistry* _tmp3_;
	GeeHashSet* _tmp4_;
	MediaCollectionRegistry* _tmp5_;
	MediaCollectionRegistry* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (MultipleDataSourceAtOnceCommand*) base;
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	database_table_begin_transaction ();
	_tmp2_ = media_collection_registry_get_instance ();
	_tmp3_ = _tmp2_;
	media_collection_registry_freeze_all (_tmp3_);
	_media_collection_registry_unref0 (_tmp3_);
	_tmp4_ = self->priv->sources;
	multiple_data_source_at_once_command_execute_on_all (self, (GeeCollection*) _tmp4_);
	_tmp5_ = media_collection_registry_get_instance ();
	_tmp6_ = _tmp5_;
	media_collection_registry_thaw_all (_tmp6_);
	_media_collection_registry_unref0 (_tmp6_);
	{
		database_table_commit_transaction (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		app_window_database_error (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		AppWindow* _tmp8_;
		AppWindow* _tmp9_;
		_tmp8_ = app_window_get_instance ();
		_tmp9_ = _tmp8_;
		page_window_set_normal_cursor ((PageWindow*) _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
multiple_data_source_at_once_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* self,
                                                          GeeCollection* sources)
{
	g_critical ("Type `%s' does not implement abstract method `multiple_data_source_at_once_command_execute_on_all'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
multiple_data_source_at_once_command_execute_on_all (MultipleDataSourceAtOnceCommand* self,
                                                     GeeCollection* sources)
{
	MultipleDataSourceAtOnceCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND_GET_CLASS (self);
	if (_klass_->execute_on_all) {
		_klass_->execute_on_all (self, sources);
	}
}

static void
multiple_data_source_at_once_command_real_undo (Command* base)
{
	MultipleDataSourceAtOnceCommand * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	MediaCollectionRegistry* _tmp2_;
	MediaCollectionRegistry* _tmp3_;
	GeeHashSet* _tmp4_;
	MediaCollectionRegistry* _tmp5_;
	MediaCollectionRegistry* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (MultipleDataSourceAtOnceCommand*) base;
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	database_table_begin_transaction ();
	_tmp2_ = media_collection_registry_get_instance ();
	_tmp3_ = _tmp2_;
	media_collection_registry_freeze_all (_tmp3_);
	_media_collection_registry_unref0 (_tmp3_);
	_tmp4_ = self->priv->sources;
	multiple_data_source_at_once_command_undo_on_all (self, (GeeCollection*) _tmp4_);
	_tmp5_ = media_collection_registry_get_instance ();
	_tmp6_ = _tmp5_;
	media_collection_registry_thaw_all (_tmp6_);
	_media_collection_registry_unref0 (_tmp6_);
	{
		database_table_commit_transaction (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		app_window_database_error (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		AppWindow* _tmp8_;
		AppWindow* _tmp9_;
		_tmp8_ = app_window_get_instance ();
		_tmp9_ = _tmp8_;
		page_window_set_normal_cursor ((PageWindow*) _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
multiple_data_source_at_once_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* self,
                                                       GeeCollection* sources)
{
	g_critical ("Type `%s' does not implement abstract method `multiple_data_source_at_once_command_undo_on_all'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
multiple_data_source_at_once_command_undo_on_all (MultipleDataSourceAtOnceCommand* self,
                                                  GeeCollection* sources)
{
	MultipleDataSourceAtOnceCommandClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND_GET_CLASS (self);
	if (_klass_->undo_on_all) {
		_klass_->undo_on_all (self, sources);
	}
}

static void
multiple_data_source_at_once_command_on_sources_destroyed (MultipleDataSourceAtOnceCommand* self,
                                                           GeeCollection* destroyed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (destroyed != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) destroyed);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashSet* _tmp4_;
			DataSource* _tmp5_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = self->priv->sources;
			_tmp5_ = source;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_)) {
				CommandManager* _tmp6_;
				CommandManager* _tmp7_;
				_tmp6_ = command_get_command_manager ((Command*) self);
				_tmp7_ = _tmp6_;
				command_manager_reset (_tmp7_);
				_command_manager_unref0 (_tmp7_);
				_g_object_unref0 (source);
				break;
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
multiple_data_source_at_once_command_class_init (MultipleDataSourceAtOnceCommandClass * klass,
                                                 gpointer klass_data)
{
	multiple_data_source_at_once_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MultipleDataSourceAtOnceCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) multiple_data_source_at_once_command_real_execute;
	((MultipleDataSourceAtOnceCommandClass *) klass)->execute_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) multiple_data_source_at_once_command_real_execute_on_all;
	((CommandClass *) klass)->undo = (void (*) (Command*)) multiple_data_source_at_once_command_real_undo;
	((MultipleDataSourceAtOnceCommandClass *) klass)->undo_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) multiple_data_source_at_once_command_real_undo_on_all;
	G_OBJECT_CLASS (klass)->finalize = multiple_data_source_at_once_command_finalize;
}

static void
multiple_data_source_at_once_command_instance_init (MultipleDataSourceAtOnceCommand * self,
                                                    gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = multiple_data_source_at_once_command_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->sources = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->hooked_collections = _tmp1_;
}

static void
multiple_data_source_at_once_command_finalize (GObject * obj)
{
	MultipleDataSourceAtOnceCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND, MultipleDataSourceAtOnceCommand);
	{
		GeeIterator* _source_collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->hooked_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_source_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* source_collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			guint _tmp6_;
			_tmp2_ = _source_collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source_collection = (SourceCollection*) _tmp4_;
			_tmp5_ = source_collection;
			g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _multiple_data_source_at_once_command_on_sources_destroyed_source_collection_items_destroyed, self);
			_data_collection_unref0 (source_collection);
		}
		_g_object_unref0 (_source_collection_it);
	}
	_g_object_unref0 (self->priv->sources);
	_g_object_unref0 (self->priv->hooked_collections);
	G_OBJECT_CLASS (multiple_data_source_at_once_command_parent_class)->finalize (obj);
}

static GType
multiple_data_source_at_once_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MultipleDataSourceAtOnceCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiple_data_source_at_once_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultipleDataSourceAtOnceCommand), 0, (GInstanceInitFunc) multiple_data_source_at_once_command_instance_init, NULL };
	GType multiple_data_source_at_once_command_type_id;
	multiple_data_source_at_once_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "MultipleDataSourceAtOnceCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	MultipleDataSourceAtOnceCommand_private_offset = g_type_add_instance_private (multiple_data_source_at_once_command_type_id, sizeof (MultipleDataSourceAtOnceCommandPrivate));
	return multiple_data_source_at_once_command_type_id;
}

GType
multiple_data_source_at_once_command_get_type (void)
{
	static volatile gsize multiple_data_source_at_once_command_type_id__once = 0;
	if (g_once_init_enter (&multiple_data_source_at_once_command_type_id__once)) {
		GType multiple_data_source_at_once_command_type_id;
		multiple_data_source_at_once_command_type_id = multiple_data_source_at_once_command_get_type_once ();
		g_once_init_leave (&multiple_data_source_at_once_command_type_id__once, multiple_data_source_at_once_command_type_id);
	}
	return multiple_data_source_at_once_command_type_id__once;
}

static inline gpointer
multiple_photo_transformation_command_get_instance_private (MultiplePhotoTransformationCommand* self)
{
	return G_STRUCT_MEMBER_P (self, MultiplePhotoTransformationCommand_private_offset);
}

static void
_multiple_photo_transformation_command_on_state_broken_photo_transformation_state_broken (PhotoTransformationState* _sender,
                                                                                          gpointer self)
{
	multiple_photo_transformation_command_on_state_broken ((MultiplePhotoTransformationCommand*) self);
}

MultiplePhotoTransformationCommand*
multiple_photo_transformation_command_construct (GType object_type,
                                                 GeeIterable* iter,
                                                 const gchar* progress_text,
                                                 const gchar* undo_progress_text,
                                                 const gchar* name,
                                                 const gchar* explanation)
{
	MultiplePhotoTransformationCommand * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (progress_text != NULL, NULL);
	g_return_val_if_fail (undo_progress_text != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (MultiplePhotoTransformationCommand*) multiple_data_source_command_construct (object_type, iter, progress_text, undo_progress_text, name, explanation);
	{
		GeeArrayList* _source_list = NULL;
		GeeArrayList* _tmp0_;
		gint _source_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _source_index = 0;
		_tmp0_ = ((MultipleDataSourceCommand*) self)->source_list;
		_source_list = _tmp0_;
		_tmp1_ = _source_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_source_size = _tmp3_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DataSource* source = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			Photo* photo = NULL;
			DataSource* _tmp8_;
			Photo* _tmp9_;
			PhotoTransformationState* state = NULL;
			Photo* _tmp10_;
			PhotoTransformationState* _tmp11_;
			PhotoTransformationState* _tmp12_;
			GeeHashMap* _tmp13_;
			Photo* _tmp14_;
			PhotoTransformationState* _tmp15_;
			_source_index = _source_index + 1;
			_tmp4_ = _source_index;
			_tmp5_ = _source_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _source_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _source_index);
			source = (DataSource*) _tmp7_;
			_tmp8_ = source;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO, Photo));
			photo = _tmp9_;
			_tmp10_ = photo;
			_tmp11_ = photo_save_transformation_state (_tmp10_);
			state = _tmp11_;
			_tmp12_ = state;
			g_signal_connect_object (_tmp12_, "broken", (GCallback) _multiple_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self, 0);
			_tmp13_ = self->priv->map;
			_tmp14_ = photo;
			_tmp15_ = state;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, _tmp15_);
			_g_object_unref0 (state);
			_g_object_unref0 (photo);
			_g_object_unref0 (source);
		}
	}
	return self;
}

static void
multiple_photo_transformation_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                           DataSource* source)
{
	MultiplePhotoTransformationCommand * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	PhotoTransformationState* state = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	self = (MultiplePhotoTransformationCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo));
	photo = _tmp0_;
	_tmp1_ = self->priv->map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, photo);
	state = (PhotoTransformationState*) _tmp2_;
	_vala_assert (state != NULL, "state != null");
	photo_load_transformation_state (photo, state);
	_g_object_unref0 (state);
	_g_object_unref0 (photo);
}

static void
multiple_photo_transformation_command_on_state_broken (MultiplePhotoTransformationCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
multiple_photo_transformation_command_class_init (MultiplePhotoTransformationCommandClass * klass,
                                                  gpointer klass_data)
{
	multiple_photo_transformation_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MultiplePhotoTransformationCommand_private_offset);
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) multiple_photo_transformation_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = multiple_photo_transformation_command_finalize;
}

static void
multiple_photo_transformation_command_instance_init (MultiplePhotoTransformationCommand * self,
                                                     gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = multiple_photo_transformation_command_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_PHOTO_TRANSFORMATION_STATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
}

static void
multiple_photo_transformation_command_finalize (GObject * obj)
{
	MultiplePhotoTransformationCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MULTIPLE_PHOTO_TRANSFORMATION_COMMAND, MultiplePhotoTransformationCommand);
	{
		GeeIterator* _state_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_state_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			PhotoTransformationState* state = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PhotoTransformationState* _tmp9_;
			guint _tmp10_;
			_tmp6_ = _state_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _state_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			state = (PhotoTransformationState*) _tmp8_;
			_tmp9_ = state;
			g_signal_parse_name ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, &_tmp10_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _multiple_photo_transformation_command_on_state_broken_photo_transformation_state_broken, self);
			_g_object_unref0 (state);
		}
		_g_object_unref0 (_state_it);
	}
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (multiple_photo_transformation_command_parent_class)->finalize (obj);
}

static GType
multiple_photo_transformation_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MultiplePhotoTransformationCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiple_photo_transformation_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiplePhotoTransformationCommand), 0, (GInstanceInitFunc) multiple_photo_transformation_command_instance_init, NULL };
	GType multiple_photo_transformation_command_type_id;
	multiple_photo_transformation_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_COMMAND, "MultiplePhotoTransformationCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	MultiplePhotoTransformationCommand_private_offset = g_type_add_instance_private (multiple_photo_transformation_command_type_id, sizeof (MultiplePhotoTransformationCommandPrivate));
	return multiple_photo_transformation_command_type_id;
}

GType
multiple_photo_transformation_command_get_type (void)
{
	static volatile gsize multiple_photo_transformation_command_type_id__once = 0;
	if (g_once_init_enter (&multiple_photo_transformation_command_type_id__once)) {
		GType multiple_photo_transformation_command_type_id;
		multiple_photo_transformation_command_type_id = multiple_photo_transformation_command_get_type_once ();
		g_once_init_leave (&multiple_photo_transformation_command_type_id__once, multiple_photo_transformation_command_type_id);
	}
	return multiple_photo_transformation_command_type_id__once;
}

static inline gpointer
rotate_single_command_get_instance_private (RotateSingleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, RotateSingleCommand_private_offset);
}

RotateSingleCommand*
rotate_single_command_construct (GType object_type,
                                 Photo* photo,
                                 Rotation rotation,
                                 const gchar* name,
                                 const gchar* explanation)
{
	RotateSingleCommand * self = NULL;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (RotateSingleCommand*) single_data_source_command_construct (object_type, (DataSource*) photo, name, explanation);
	self->priv->rotation = rotation;
	return self;
}

RotateSingleCommand*
rotate_single_command_new (Photo* photo,
                           Rotation rotation,
                           const gchar* name,
                           const gchar* explanation)
{
	return rotate_single_command_construct (TYPE_ROTATE_SINGLE_COMMAND, photo, rotation, name, explanation);
}

static void
rotate_single_command_real_execute (Command* base)
{
	RotateSingleCommand * self;
	DataSource* _tmp0_;
	self = (RotateSingleCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	photo_rotate (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo), self->priv->rotation);
}

static void
rotate_single_command_real_undo (Command* base)
{
	RotateSingleCommand * self;
	DataSource* _tmp0_;
	self = (RotateSingleCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	photo_rotate (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo), rotation_opposite (self->priv->rotation));
}

static void
rotate_single_command_class_init (RotateSingleCommandClass * klass,
                                  gpointer klass_data)
{
	rotate_single_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RotateSingleCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) rotate_single_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) rotate_single_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = rotate_single_command_finalize;
}

static void
rotate_single_command_instance_init (RotateSingleCommand * self,
                                     gpointer klass)
{
	self->priv = rotate_single_command_get_instance_private (self);
}

static void
rotate_single_command_finalize (GObject * obj)
{
	RotateSingleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROTATE_SINGLE_COMMAND, RotateSingleCommand);
	G_OBJECT_CLASS (rotate_single_command_parent_class)->finalize (obj);
}

static GType
rotate_single_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RotateSingleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rotate_single_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RotateSingleCommand), 0, (GInstanceInitFunc) rotate_single_command_instance_init, NULL };
	GType rotate_single_command_type_id;
	rotate_single_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "RotateSingleCommand", &g_define_type_info, 0);
	RotateSingleCommand_private_offset = g_type_add_instance_private (rotate_single_command_type_id, sizeof (RotateSingleCommandPrivate));
	return rotate_single_command_type_id;
}

GType
rotate_single_command_get_type (void)
{
	static volatile gsize rotate_single_command_type_id__once = 0;
	if (g_once_init_enter (&rotate_single_command_type_id__once)) {
		GType rotate_single_command_type_id;
		rotate_single_command_type_id = rotate_single_command_get_type_once ();
		g_once_init_leave (&rotate_single_command_type_id__once, rotate_single_command_type_id);
	}
	return rotate_single_command_type_id__once;
}

static inline gpointer
rotate_multiple_command_get_instance_private (RotateMultipleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, RotateMultipleCommand_private_offset);
}

RotateMultipleCommand*
rotate_multiple_command_construct (GType object_type,
                                   GeeIterable* iter,
                                   Rotation rotation,
                                   const gchar* name,
                                   const gchar* explanation,
                                   const gchar* progress_text,
                                   const gchar* undo_progress_text)
{
	RotateMultipleCommand * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	g_return_val_if_fail (progress_text != NULL, NULL);
	g_return_val_if_fail (undo_progress_text != NULL, NULL);
	self = (RotateMultipleCommand*) multiple_data_source_command_construct (object_type, iter, progress_text, undo_progress_text, name, explanation);
	self->priv->rotation = rotation;
	return self;
}

RotateMultipleCommand*
rotate_multiple_command_new (GeeIterable* iter,
                             Rotation rotation,
                             const gchar* name,
                             const gchar* explanation,
                             const gchar* progress_text,
                             const gchar* undo_progress_text)
{
	return rotate_multiple_command_construct (TYPE_ROTATE_MULTIPLE_COMMAND, iter, rotation, name, explanation, progress_text, undo_progress_text);
}

static void
rotate_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                DataSource* source)
{
	RotateMultipleCommand * self;
	self = (RotateMultipleCommand*) base;
	g_return_if_fail (source != NULL);
	photo_rotate (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo), self->priv->rotation);
}

static void
rotate_multiple_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                             DataSource* source)
{
	RotateMultipleCommand * self;
	self = (RotateMultipleCommand*) base;
	g_return_if_fail (source != NULL);
	photo_rotate (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo), rotation_opposite (self->priv->rotation));
}

static void
rotate_multiple_command_class_init (RotateMultipleCommandClass * klass,
                                    gpointer klass_data)
{
	rotate_multiple_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RotateMultipleCommand_private_offset);
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) rotate_multiple_command_real_execute_on_source;
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) rotate_multiple_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = rotate_multiple_command_finalize;
}

static void
rotate_multiple_command_instance_init (RotateMultipleCommand * self,
                                       gpointer klass)
{
	self->priv = rotate_multiple_command_get_instance_private (self);
}

static void
rotate_multiple_command_finalize (GObject * obj)
{
	RotateMultipleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROTATE_MULTIPLE_COMMAND, RotateMultipleCommand);
	G_OBJECT_CLASS (rotate_multiple_command_parent_class)->finalize (obj);
}

static GType
rotate_multiple_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RotateMultipleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rotate_multiple_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RotateMultipleCommand), 0, (GInstanceInitFunc) rotate_multiple_command_instance_init, NULL };
	GType rotate_multiple_command_type_id;
	rotate_multiple_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_COMMAND, "RotateMultipleCommand", &g_define_type_info, 0);
	RotateMultipleCommand_private_offset = g_type_add_instance_private (rotate_multiple_command_type_id, sizeof (RotateMultipleCommandPrivate));
	return rotate_multiple_command_type_id;
}

GType
rotate_multiple_command_get_type (void)
{
	static volatile gsize rotate_multiple_command_type_id__once = 0;
	if (g_once_init_enter (&rotate_multiple_command_type_id__once)) {
		GType rotate_multiple_command_type_id;
		rotate_multiple_command_type_id = rotate_multiple_command_get_type_once ();
		g_once_init_leave (&rotate_multiple_command_type_id__once, rotate_multiple_command_type_id);
	}
	return rotate_multiple_command_type_id__once;
}

static inline gpointer
edit_title_command_get_instance_private (EditTitleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, EditTitleCommand_private_offset);
}

EditTitleCommand*
edit_title_command_construct (GType object_type,
                              MediaSource* source,
                              const gchar* new_title)
{
	EditTitleCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (new_title != NULL, NULL);
	self = (EditTitleCommand*) single_data_source_command_construct (object_type, (DataSource*) source, RESOURCES_EDIT_TITLE_LABEL, "");
	_tmp0_ = g_strdup (new_title);
	_g_free0 (self->priv->new_title);
	self->priv->new_title = _tmp0_;
	_tmp1_ = media_source_get_title (source);
	_g_free0 (self->priv->old_title);
	self->priv->old_title = _tmp1_;
	return self;
}

EditTitleCommand*
edit_title_command_new (MediaSource* source,
                        const gchar* new_title)
{
	return edit_title_command_construct (TYPE_EDIT_TITLE_COMMAND, source, new_title);
}

static void
edit_title_command_real_execute (Command* base)
{
	EditTitleCommand * self;
	DataSource* _tmp0_;
	const gchar* _tmp1_;
	self = (EditTitleCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->new_title;
	media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource), _tmp1_);
}

static void
edit_title_command_real_undo (Command* base)
{
	EditTitleCommand * self;
	DataSource* _tmp0_;
	const gchar* _tmp1_;
	self = (EditTitleCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->old_title;
	media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource), _tmp1_);
}

static void
edit_title_command_class_init (EditTitleCommandClass * klass,
                               gpointer klass_data)
{
	edit_title_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditTitleCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) edit_title_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) edit_title_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = edit_title_command_finalize;
}

static void
edit_title_command_instance_init (EditTitleCommand * self,
                                  gpointer klass)
{
	self->priv = edit_title_command_get_instance_private (self);
}

static void
edit_title_command_finalize (GObject * obj)
{
	EditTitleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDIT_TITLE_COMMAND, EditTitleCommand);
	_g_free0 (self->priv->new_title);
	_g_free0 (self->priv->old_title);
	G_OBJECT_CLASS (edit_title_command_parent_class)->finalize (obj);
}

static GType
edit_title_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditTitleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_title_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditTitleCommand), 0, (GInstanceInitFunc) edit_title_command_instance_init, NULL };
	GType edit_title_command_type_id;
	edit_title_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "EditTitleCommand", &g_define_type_info, 0);
	EditTitleCommand_private_offset = g_type_add_instance_private (edit_title_command_type_id, sizeof (EditTitleCommandPrivate));
	return edit_title_command_type_id;
}

GType
edit_title_command_get_type (void)
{
	static volatile gsize edit_title_command_type_id__once = 0;
	if (g_once_init_enter (&edit_title_command_type_id__once)) {
		GType edit_title_command_type_id;
		edit_title_command_type_id = edit_title_command_get_type_once ();
		g_once_init_leave (&edit_title_command_type_id__once, edit_title_command_type_id);
	}
	return edit_title_command_type_id__once;
}

static inline gpointer
edit_comment_command_get_instance_private (EditCommentCommand* self)
{
	return G_STRUCT_MEMBER_P (self, EditCommentCommand_private_offset);
}

EditCommentCommand*
edit_comment_command_construct (GType object_type,
                                MediaSource* source,
                                const gchar* new_comment)
{
	EditCommentCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (new_comment != NULL, NULL);
	self = (EditCommentCommand*) single_data_source_command_construct (object_type, (DataSource*) source, RESOURCES_EDIT_COMMENT_LABEL, "");
	_tmp0_ = g_strdup (new_comment);
	_g_free0 (self->priv->new_comment);
	self->priv->new_comment = _tmp0_;
	_tmp1_ = media_source_get_comment (source);
	_g_free0 (self->priv->old_comment);
	self->priv->old_comment = _tmp1_;
	return self;
}

EditCommentCommand*
edit_comment_command_new (MediaSource* source,
                          const gchar* new_comment)
{
	return edit_comment_command_construct (TYPE_EDIT_COMMENT_COMMAND, source, new_comment);
}

static void
edit_comment_command_real_execute (Command* base)
{
	EditCommentCommand * self;
	DataSource* _tmp0_;
	const gchar* _tmp1_;
	self = (EditCommentCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->new_comment;
	media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource), _tmp1_);
}

static void
edit_comment_command_real_undo (Command* base)
{
	EditCommentCommand * self;
	DataSource* _tmp0_;
	const gchar* _tmp1_;
	self = (EditCommentCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->old_comment;
	media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource), _tmp1_);
}

static void
edit_comment_command_class_init (EditCommentCommandClass * klass,
                                 gpointer klass_data)
{
	edit_comment_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditCommentCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) edit_comment_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) edit_comment_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = edit_comment_command_finalize;
}

static void
edit_comment_command_instance_init (EditCommentCommand * self,
                                    gpointer klass)
{
	self->priv = edit_comment_command_get_instance_private (self);
}

static void
edit_comment_command_finalize (GObject * obj)
{
	EditCommentCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDIT_COMMENT_COMMAND, EditCommentCommand);
	_g_free0 (self->priv->new_comment);
	_g_free0 (self->priv->old_comment);
	G_OBJECT_CLASS (edit_comment_command_parent_class)->finalize (obj);
}

static GType
edit_comment_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditCommentCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_comment_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditCommentCommand), 0, (GInstanceInitFunc) edit_comment_command_instance_init, NULL };
	GType edit_comment_command_type_id;
	edit_comment_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "EditCommentCommand", &g_define_type_info, 0);
	EditCommentCommand_private_offset = g_type_add_instance_private (edit_comment_command_type_id, sizeof (EditCommentCommandPrivate));
	return edit_comment_command_type_id;
}

GType
edit_comment_command_get_type (void)
{
	static volatile gsize edit_comment_command_type_id__once = 0;
	if (g_once_init_enter (&edit_comment_command_type_id__once)) {
		GType edit_comment_command_type_id;
		edit_comment_command_type_id = edit_comment_command_get_type_once ();
		g_once_init_leave (&edit_comment_command_type_id__once, edit_comment_command_type_id);
	}
	return edit_comment_command_type_id__once;
}

EditMultipleTitlesCommand*
edit_multiple_titles_command_construct (GType object_type,
                                        GeeCollection* media_sources,
                                        const gchar* new_title)
{
	EditMultipleTitlesCommand * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (media_sources != NULL, NULL);
	g_return_val_if_fail (new_title != NULL, NULL);
	self = (EditMultipleTitlesCommand*) multiple_data_source_at_once_command_construct (object_type, media_sources, RESOURCES_EDIT_TITLE_LABEL, "");
	_tmp0_ = g_strdup (new_title);
	_g_free0 (self->new_title);
	self->new_title = _tmp0_;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) media_sources);
		_media_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* media = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeHashMap* _tmp5_;
			MediaSource* _tmp6_;
			MediaSource* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = _media_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _media_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			media = (MediaSource*) _tmp4_;
			_tmp5_ = self->old_titles;
			_tmp6_ = media;
			_tmp7_ = media;
			_tmp8_ = media_source_get_title (_tmp7_);
			_tmp9_ = _tmp8_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	return self;
}

EditMultipleTitlesCommand*
edit_multiple_titles_command_new (GeeCollection* media_sources,
                                  const gchar* new_title)
{
	return edit_multiple_titles_command_construct (TYPE_EDIT_MULTIPLE_TITLES_COMMAND, media_sources, new_title);
}

static void
edit_multiple_titles_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* base,
                                                  GeeCollection* sources)
{
	EditMultipleTitlesCommand * self;
	self = (EditMultipleTitlesCommand*) base;
	g_return_if_fail (sources != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			_tmp5_ = self->new_title;
			media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource), _tmp5_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
edit_multiple_titles_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* base,
                                               GeeCollection* sources)
{
	EditMultipleTitlesCommand * self;
	self = (EditMultipleTitlesCommand*) base;
	g_return_if_fail (sources != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* _tmp4_;
			GeeHashMap* _tmp5_;
			DataSource* _tmp6_;
			gpointer _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			_tmp5_ = self->old_titles;
			_tmp6_ = source;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp8_ = (gchar*) _tmp7_;
			media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource), _tmp8_);
			_g_free0 (_tmp8_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
edit_multiple_titles_command_class_init (EditMultipleTitlesCommandClass * klass,
                                         gpointer klass_data)
{
	edit_multiple_titles_command_parent_class = g_type_class_peek_parent (klass);
	((MultipleDataSourceAtOnceCommandClass *) klass)->execute_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) edit_multiple_titles_command_real_execute_on_all;
	((MultipleDataSourceAtOnceCommandClass *) klass)->undo_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) edit_multiple_titles_command_real_undo_on_all;
	G_OBJECT_CLASS (klass)->finalize = edit_multiple_titles_command_finalize;
}

static void
edit_multiple_titles_command_instance_init (EditMultipleTitlesCommand * self,
                                            gpointer klass)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->old_titles = _tmp0_;
}

static void
edit_multiple_titles_command_finalize (GObject * obj)
{
	EditMultipleTitlesCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDIT_MULTIPLE_TITLES_COMMAND, EditMultipleTitlesCommand);
	_g_free0 (self->new_title);
	_g_object_unref0 (self->old_titles);
	G_OBJECT_CLASS (edit_multiple_titles_command_parent_class)->finalize (obj);
}

static GType
edit_multiple_titles_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditMultipleTitlesCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_multiple_titles_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditMultipleTitlesCommand), 0, (GInstanceInitFunc) edit_multiple_titles_command_instance_init, NULL };
	GType edit_multiple_titles_command_type_id;
	edit_multiple_titles_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND, "EditMultipleTitlesCommand", &g_define_type_info, 0);
	return edit_multiple_titles_command_type_id;
}

GType
edit_multiple_titles_command_get_type (void)
{
	static volatile gsize edit_multiple_titles_command_type_id__once = 0;
	if (g_once_init_enter (&edit_multiple_titles_command_type_id__once)) {
		GType edit_multiple_titles_command_type_id;
		edit_multiple_titles_command_type_id = edit_multiple_titles_command_get_type_once ();
		g_once_init_leave (&edit_multiple_titles_command_type_id__once, edit_multiple_titles_command_type_id);
	}
	return edit_multiple_titles_command_type_id__once;
}

EditMultipleCommentsCommand*
edit_multiple_comments_command_construct (GType object_type,
                                          GeeCollection* media_sources,
                                          const gchar* new_comment)
{
	EditMultipleCommentsCommand * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (media_sources != NULL, NULL);
	g_return_val_if_fail (new_comment != NULL, NULL);
	self = (EditMultipleCommentsCommand*) multiple_data_source_at_once_command_construct (object_type, media_sources, RESOURCES_EDIT_COMMENT_LABEL, "");
	_tmp0_ = g_strdup (new_comment);
	_g_free0 (self->new_comment);
	self->new_comment = _tmp0_;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) media_sources);
		_media_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* media = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeHashMap* _tmp5_;
			MediaSource* _tmp6_;
			MediaSource* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = _media_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _media_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			media = (MediaSource*) _tmp4_;
			_tmp5_ = self->old_comments;
			_tmp6_ = media;
			_tmp7_ = media;
			_tmp8_ = media_source_get_comment (_tmp7_);
			_tmp9_ = _tmp8_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	return self;
}

EditMultipleCommentsCommand*
edit_multiple_comments_command_new (GeeCollection* media_sources,
                                    const gchar* new_comment)
{
	return edit_multiple_comments_command_construct (TYPE_EDIT_MULTIPLE_COMMENTS_COMMAND, media_sources, new_comment);
}

static void
edit_multiple_comments_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* base,
                                                    GeeCollection* sources)
{
	EditMultipleCommentsCommand * self;
	self = (EditMultipleCommentsCommand*) base;
	g_return_if_fail (sources != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			_tmp5_ = self->new_comment;
			media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource), _tmp5_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
edit_multiple_comments_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* base,
                                                 GeeCollection* sources)
{
	EditMultipleCommentsCommand * self;
	self = (EditMultipleCommentsCommand*) base;
	g_return_if_fail (sources != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* _tmp4_;
			GeeHashMap* _tmp5_;
			DataSource* _tmp6_;
			gpointer _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			_tmp5_ = self->old_comments;
			_tmp6_ = source;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp8_ = (gchar*) _tmp7_;
			media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource), _tmp8_);
			_g_free0 (_tmp8_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
edit_multiple_comments_command_class_init (EditMultipleCommentsCommandClass * klass,
                                           gpointer klass_data)
{
	edit_multiple_comments_command_parent_class = g_type_class_peek_parent (klass);
	((MultipleDataSourceAtOnceCommandClass *) klass)->execute_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) edit_multiple_comments_command_real_execute_on_all;
	((MultipleDataSourceAtOnceCommandClass *) klass)->undo_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) edit_multiple_comments_command_real_undo_on_all;
	G_OBJECT_CLASS (klass)->finalize = edit_multiple_comments_command_finalize;
}

static void
edit_multiple_comments_command_instance_init (EditMultipleCommentsCommand * self,
                                              gpointer klass)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->old_comments = _tmp0_;
}

static void
edit_multiple_comments_command_finalize (GObject * obj)
{
	EditMultipleCommentsCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDIT_MULTIPLE_COMMENTS_COMMAND, EditMultipleCommentsCommand);
	_g_free0 (self->new_comment);
	_g_object_unref0 (self->old_comments);
	G_OBJECT_CLASS (edit_multiple_comments_command_parent_class)->finalize (obj);
}

static GType
edit_multiple_comments_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditMultipleCommentsCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_multiple_comments_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditMultipleCommentsCommand), 0, (GInstanceInitFunc) edit_multiple_comments_command_instance_init, NULL };
	GType edit_multiple_comments_command_type_id;
	edit_multiple_comments_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND, "EditMultipleCommentsCommand", &g_define_type_info, 0);
	return edit_multiple_comments_command_type_id;
}

GType
edit_multiple_comments_command_get_type (void)
{
	static volatile gsize edit_multiple_comments_command_type_id__once = 0;
	if (g_once_init_enter (&edit_multiple_comments_command_type_id__once)) {
		GType edit_multiple_comments_command_type_id;
		edit_multiple_comments_command_type_id = edit_multiple_comments_command_get_type_once ();
		g_once_init_leave (&edit_multiple_comments_command_type_id__once, edit_multiple_comments_command_type_id);
	}
	return edit_multiple_comments_command_type_id__once;
}

static inline gpointer
rename_event_command_get_instance_private (RenameEventCommand* self)
{
	return G_STRUCT_MEMBER_P (self, RenameEventCommand_private_offset);
}

RenameEventCommand*
rename_event_command_construct (GType object_type,
                                Event* event,
                                const gchar* new_name)
{
	RenameEventCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	self = (RenameEventCommand*) simple_proxyable_command_construct (object_type, (Proxyable*) event, RESOURCES_RENAME_EVENT_LABEL, "");
	_tmp0_ = g_strdup (new_name);
	_g_free0 (self->priv->new_name);
	self->priv->new_name = _tmp0_;
	_tmp1_ = event_get_raw_name (event);
	_g_free0 (self->priv->old_name);
	self->priv->old_name = _tmp1_;
	return self;
}

RenameEventCommand*
rename_event_command_new (Event* event,
                          const gchar* new_name)
{
	return rename_event_command_construct (TYPE_RENAME_EVENT_COMMAND, event, new_name);
}

static void
rename_event_command_real_execute_on_source (SimpleProxyableCommand* base,
                                             DataSource* source)
{
	RenameEventCommand * self;
	const gchar* _tmp0_;
	self = (RenameEventCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->new_name;
	event_rename (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_EVENT, Event), _tmp0_);
}

static void
rename_event_command_real_undo_on_source (SimpleProxyableCommand* base,
                                          DataSource* source)
{
	RenameEventCommand * self;
	const gchar* _tmp0_;
	self = (RenameEventCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->old_name;
	event_rename (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_EVENT, Event), _tmp0_);
}

static void
rename_event_command_class_init (RenameEventCommandClass * klass,
                                 gpointer klass_data)
{
	rename_event_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RenameEventCommand_private_offset);
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) rename_event_command_real_execute_on_source;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) rename_event_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = rename_event_command_finalize;
}

static void
rename_event_command_instance_init (RenameEventCommand * self,
                                    gpointer klass)
{
	self->priv = rename_event_command_get_instance_private (self);
}

static void
rename_event_command_finalize (GObject * obj)
{
	RenameEventCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RENAME_EVENT_COMMAND, RenameEventCommand);
	_g_free0 (self->priv->new_name);
	_g_free0 (self->priv->old_name);
	G_OBJECT_CLASS (rename_event_command_parent_class)->finalize (obj);
}

static GType
rename_event_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RenameEventCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rename_event_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RenameEventCommand), 0, (GInstanceInitFunc) rename_event_command_instance_init, NULL };
	GType rename_event_command_type_id;
	rename_event_command_type_id = g_type_register_static (TYPE_SIMPLE_PROXYABLE_COMMAND, "RenameEventCommand", &g_define_type_info, 0);
	RenameEventCommand_private_offset = g_type_add_instance_private (rename_event_command_type_id, sizeof (RenameEventCommandPrivate));
	return rename_event_command_type_id;
}

GType
rename_event_command_get_type (void)
{
	static volatile gsize rename_event_command_type_id__once = 0;
	if (g_once_init_enter (&rename_event_command_type_id__once)) {
		GType rename_event_command_type_id;
		rename_event_command_type_id = rename_event_command_get_type_once ();
		g_once_init_leave (&rename_event_command_type_id__once, rename_event_command_type_id);
	}
	return rename_event_command_type_id__once;
}

static inline gpointer
edit_event_comment_command_get_instance_private (EditEventCommentCommand* self)
{
	return G_STRUCT_MEMBER_P (self, EditEventCommentCommand_private_offset);
}

EditEventCommentCommand*
edit_event_comment_command_construct (GType object_type,
                                      Event* event,
                                      const gchar* new_comment)
{
	EditEventCommentCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (new_comment != NULL, NULL);
	self = (EditEventCommentCommand*) simple_proxyable_command_construct (object_type, (Proxyable*) event, RESOURCES_EDIT_COMMENT_LABEL, "");
	_tmp0_ = g_strdup (new_comment);
	_g_free0 (self->priv->new_comment);
	self->priv->new_comment = _tmp0_;
	_tmp1_ = event_source_get_comment ((EventSource*) event);
	_g_free0 (self->priv->old_comment);
	self->priv->old_comment = _tmp1_;
	return self;
}

EditEventCommentCommand*
edit_event_comment_command_new (Event* event,
                                const gchar* new_comment)
{
	return edit_event_comment_command_construct (TYPE_EDIT_EVENT_COMMENT_COMMAND, event, new_comment);
}

static void
edit_event_comment_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                   DataSource* source)
{
	EditEventCommentCommand * self;
	const gchar* _tmp0_;
	self = (EditEventCommentCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->new_comment;
	event_source_set_comment ((EventSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_EVENT, Event), _tmp0_);
}

static void
edit_event_comment_command_real_undo_on_source (SimpleProxyableCommand* base,
                                                DataSource* source)
{
	EditEventCommentCommand * self;
	const gchar* _tmp0_;
	self = (EditEventCommentCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->old_comment;
	event_source_set_comment ((EventSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_EVENT, Event), _tmp0_);
}

static void
edit_event_comment_command_class_init (EditEventCommentCommandClass * klass,
                                       gpointer klass_data)
{
	edit_event_comment_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditEventCommentCommand_private_offset);
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) edit_event_comment_command_real_execute_on_source;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) edit_event_comment_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = edit_event_comment_command_finalize;
}

static void
edit_event_comment_command_instance_init (EditEventCommentCommand * self,
                                          gpointer klass)
{
	self->priv = edit_event_comment_command_get_instance_private (self);
}

static void
edit_event_comment_command_finalize (GObject * obj)
{
	EditEventCommentCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDIT_EVENT_COMMENT_COMMAND, EditEventCommentCommand);
	_g_free0 (self->priv->new_comment);
	_g_free0 (self->priv->old_comment);
	G_OBJECT_CLASS (edit_event_comment_command_parent_class)->finalize (obj);
}

static GType
edit_event_comment_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditEventCommentCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_event_comment_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditEventCommentCommand), 0, (GInstanceInitFunc) edit_event_comment_command_instance_init, NULL };
	GType edit_event_comment_command_type_id;
	edit_event_comment_command_type_id = g_type_register_static (TYPE_SIMPLE_PROXYABLE_COMMAND, "EditEventCommentCommand", &g_define_type_info, 0);
	EditEventCommentCommand_private_offset = g_type_add_instance_private (edit_event_comment_command_type_id, sizeof (EditEventCommentCommandPrivate));
	return edit_event_comment_command_type_id;
}

GType
edit_event_comment_command_get_type (void)
{
	static volatile gsize edit_event_comment_command_type_id__once = 0;
	if (g_once_init_enter (&edit_event_comment_command_type_id__once)) {
		GType edit_event_comment_command_type_id;
		edit_event_comment_command_type_id = edit_event_comment_command_get_type_once ();
		g_once_init_leave (&edit_event_comment_command_type_id__once, edit_event_comment_command_type_id);
	}
	return edit_event_comment_command_type_id__once;
}

static inline gpointer
set_key_photo_command_get_instance_private (SetKeyPhotoCommand* self)
{
	return G_STRUCT_MEMBER_P (self, SetKeyPhotoCommand_private_offset);
}

SetKeyPhotoCommand*
set_key_photo_command_construct (GType object_type,
                                 Event* event,
                                 MediaSource* new_primary_source)
{
	SetKeyPhotoCommand * self = NULL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (new_primary_source != NULL, NULL);
	self = (SetKeyPhotoCommand*) single_data_source_command_construct (object_type, (DataSource*) event, RESOURCES_MAKE_KEY_PHOTO_LABEL, "");
	_tmp0_ = _g_object_ref0 (new_primary_source);
	_g_object_unref0 (self->priv->new_primary_source);
	self->priv->new_primary_source = _tmp0_;
	_tmp1_ = event_get_primary_source (event);
	_g_object_unref0 (self->priv->old_primary_source);
	self->priv->old_primary_source = _tmp1_;
	return self;
}

SetKeyPhotoCommand*
set_key_photo_command_new (Event* event,
                           MediaSource* new_primary_source)
{
	return set_key_photo_command_construct (TYPE_SET_KEY_PHOTO_COMMAND, event, new_primary_source);
}

static void
set_key_photo_command_real_execute (Command* base)
{
	SetKeyPhotoCommand * self;
	DataSource* _tmp0_;
	MediaSource* _tmp1_;
	self = (SetKeyPhotoCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->new_primary_source;
	event_set_primary_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT, Event), _tmp1_);
}

static void
set_key_photo_command_real_undo (Command* base)
{
	SetKeyPhotoCommand * self;
	DataSource* _tmp0_;
	MediaSource* _tmp1_;
	self = (SetKeyPhotoCommand*) base;
	_tmp0_ = ((SingleDataSourceCommand*) self)->source;
	_tmp1_ = self->priv->old_primary_source;
	event_set_primary_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT, Event), _tmp1_);
}

static void
set_key_photo_command_class_init (SetKeyPhotoCommandClass * klass,
                                  gpointer klass_data)
{
	set_key_photo_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SetKeyPhotoCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) set_key_photo_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) set_key_photo_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = set_key_photo_command_finalize;
}

static void
set_key_photo_command_instance_init (SetKeyPhotoCommand * self,
                                     gpointer klass)
{
	self->priv = set_key_photo_command_get_instance_private (self);
}

static void
set_key_photo_command_finalize (GObject * obj)
{
	SetKeyPhotoCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SET_KEY_PHOTO_COMMAND, SetKeyPhotoCommand);
	_g_object_unref0 (self->priv->new_primary_source);
	_g_object_unref0 (self->priv->old_primary_source);
	G_OBJECT_CLASS (set_key_photo_command_parent_class)->finalize (obj);
}

static GType
set_key_photo_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SetKeyPhotoCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) set_key_photo_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetKeyPhotoCommand), 0, (GInstanceInitFunc) set_key_photo_command_instance_init, NULL };
	GType set_key_photo_command_type_id;
	set_key_photo_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "SetKeyPhotoCommand", &g_define_type_info, 0);
	SetKeyPhotoCommand_private_offset = g_type_add_instance_private (set_key_photo_command_type_id, sizeof (SetKeyPhotoCommandPrivate));
	return set_key_photo_command_type_id;
}

GType
set_key_photo_command_get_type (void)
{
	static volatile gsize set_key_photo_command_type_id__once = 0;
	if (g_once_init_enter (&set_key_photo_command_type_id__once)) {
		GType set_key_photo_command_type_id;
		set_key_photo_command_type_id = set_key_photo_command_get_type_once ();
		g_once_init_leave (&set_key_photo_command_type_id__once, set_key_photo_command_type_id);
	}
	return set_key_photo_command_type_id__once;
}

RevertSingleCommand*
revert_single_command_construct (GType object_type,
                                 Photo* photo)
{
	RevertSingleCommand * self = NULL;
	g_return_val_if_fail (photo != NULL, NULL);
	self = (RevertSingleCommand*) generic_photo_transformation_command_construct (object_type, photo, RESOURCES_REVERT_LABEL, "");
	return self;
}

RevertSingleCommand*
revert_single_command_new (Photo* photo)
{
	return revert_single_command_construct (TYPE_REVERT_SINGLE_COMMAND, photo);
}

static void
revert_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                             Photo* photo)
{
	RevertSingleCommand * self;
	self = (RevertSingleCommand*) base;
	g_return_if_fail (photo != NULL);
	photo_remove_all_transformations (photo);
}

static gboolean
revert_single_command_real_compress (Command* base,
                                     Command* command)
{
	RevertSingleCommand * self;
	gboolean result;
	self = (RevertSingleCommand*) base;
	g_return_val_if_fail (command != NULL, FALSE);
	if (IS_REVERT_SINGLE_COMMAND (command)) {
		RevertSingleCommand* revert_single_command = NULL;
		RevertSingleCommand* _tmp0_;
		RevertSingleCommand* _tmp1_;
		DataSource* _tmp2_;
		DataSource* _tmp3_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (command, TYPE_REVERT_SINGLE_COMMAND, RevertSingleCommand));
		revert_single_command = _tmp0_;
		_tmp1_ = revert_single_command;
		_tmp2_ = ((SingleDataSourceCommand*) _tmp1_)->source;
		_tmp3_ = ((SingleDataSourceCommand*) self)->source;
		if (_tmp2_ != _tmp3_) {
			result = FALSE;
			_g_object_unref0 (revert_single_command);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (revert_single_command);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
revert_single_command_class_init (RevertSingleCommandClass * klass,
                                  gpointer klass_data)
{
	revert_single_command_parent_class = g_type_class_peek_parent (klass);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) revert_single_command_real_execute_on_photo;
	((CommandClass *) klass)->compress = (gboolean (*) (Command*, Command*)) revert_single_command_real_compress;
}

static void
revert_single_command_instance_init (RevertSingleCommand * self,
                                     gpointer klass)
{
}

static GType
revert_single_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RevertSingleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) revert_single_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RevertSingleCommand), 0, (GInstanceInitFunc) revert_single_command_instance_init, NULL };
	GType revert_single_command_type_id;
	revert_single_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "RevertSingleCommand", &g_define_type_info, 0);
	return revert_single_command_type_id;
}

GType
revert_single_command_get_type (void)
{
	static volatile gsize revert_single_command_type_id__once = 0;
	if (g_once_init_enter (&revert_single_command_type_id__once)) {
		GType revert_single_command_type_id;
		revert_single_command_type_id = revert_single_command_get_type_once ();
		g_once_init_leave (&revert_single_command_type_id__once, revert_single_command_type_id);
	}
	return revert_single_command_type_id__once;
}

RevertMultipleCommand*
revert_multiple_command_construct (GType object_type,
                                   GeeIterable* iter)
{
	RevertMultipleCommand * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (RevertMultipleCommand*) multiple_photo_transformation_command_construct (object_type, iter, _ ("Reverting"), _ ("Undoing Revert"), RESOURCES_REVERT_LABEL, "");
	return self;
}

RevertMultipleCommand*
revert_multiple_command_new (GeeIterable* iter)
{
	return revert_multiple_command_construct (TYPE_REVERT_MULTIPLE_COMMAND, iter);
}

static void
revert_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                DataSource* source)
{
	RevertMultipleCommand * self;
	self = (RevertMultipleCommand*) base;
	g_return_if_fail (source != NULL);
	photo_remove_all_transformations (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo));
}

static void
revert_multiple_command_class_init (RevertMultipleCommandClass * klass,
                                    gpointer klass_data)
{
	revert_multiple_command_parent_class = g_type_class_peek_parent (klass);
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) revert_multiple_command_real_execute_on_source;
}

static void
revert_multiple_command_instance_init (RevertMultipleCommand * self,
                                       gpointer klass)
{
}

static GType
revert_multiple_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RevertMultipleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) revert_multiple_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RevertMultipleCommand), 0, (GInstanceInitFunc) revert_multiple_command_instance_init, NULL };
	GType revert_multiple_command_type_id;
	revert_multiple_command_type_id = g_type_register_static (TYPE_MULTIPLE_PHOTO_TRANSFORMATION_COMMAND, "RevertMultipleCommand", &g_define_type_info, 0);
	return revert_multiple_command_type_id;
}

GType
revert_multiple_command_get_type (void)
{
	static volatile gsize revert_multiple_command_type_id__once = 0;
	if (g_once_init_enter (&revert_multiple_command_type_id__once)) {
		GType revert_multiple_command_type_id;
		revert_multiple_command_type_id = revert_multiple_command_get_type_once ();
		g_once_init_leave (&revert_multiple_command_type_id__once, revert_multiple_command_type_id);
	}
	return revert_multiple_command_type_id__once;
}

EnhanceSingleCommand*
enhance_single_command_construct (GType object_type,
                                  Photo* photo)
{
	EnhanceSingleCommand * self = NULL;
	g_return_val_if_fail (photo != NULL, NULL);
	self = (EnhanceSingleCommand*) generic_photo_transformation_command_construct (object_type, photo, RESOURCES_ENHANCE_LABEL, RESOURCES_ENHANCE_TOOLTIP);
	return self;
}

EnhanceSingleCommand*
enhance_single_command_new (Photo* photo)
{
	return enhance_single_command_construct (TYPE_ENHANCE_SINGLE_COMMAND, photo);
}

static void
enhance_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                              Photo* photo)
{
	EnhanceSingleCommand * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	self = (EnhanceSingleCommand*) base;
	g_return_if_fail (photo != NULL);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	photo_enhance (photo);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	page_window_set_normal_cursor ((PageWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static gboolean
enhance_single_command_real_compress (Command* base,
                                      Command* command)
{
	EnhanceSingleCommand * self;
	gboolean result;
	self = (EnhanceSingleCommand*) base;
	g_return_val_if_fail (command != NULL, FALSE);
	if (IS_ENHANCE_SINGLE_COMMAND (command)) {
		EnhanceSingleCommand* enhance_single_command = NULL;
		EnhanceSingleCommand* _tmp0_;
		EnhanceSingleCommand* _tmp1_;
		DataSource* _tmp2_;
		DataSource* _tmp3_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (command, TYPE_ENHANCE_SINGLE_COMMAND, EnhanceSingleCommand));
		enhance_single_command = _tmp0_;
		_tmp1_ = enhance_single_command;
		_tmp2_ = ((SingleDataSourceCommand*) _tmp1_)->source;
		_tmp3_ = ((SingleDataSourceCommand*) self)->source;
		if (_tmp2_ != _tmp3_) {
			result = FALSE;
			_g_object_unref0 (enhance_single_command);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (enhance_single_command);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
enhance_single_command_class_init (EnhanceSingleCommandClass * klass,
                                   gpointer klass_data)
{
	enhance_single_command_parent_class = g_type_class_peek_parent (klass);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) enhance_single_command_real_execute_on_photo;
	((CommandClass *) klass)->compress = (gboolean (*) (Command*, Command*)) enhance_single_command_real_compress;
}

static void
enhance_single_command_instance_init (EnhanceSingleCommand * self,
                                      gpointer klass)
{
}

static GType
enhance_single_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EnhanceSingleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enhance_single_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnhanceSingleCommand), 0, (GInstanceInitFunc) enhance_single_command_instance_init, NULL };
	GType enhance_single_command_type_id;
	enhance_single_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "EnhanceSingleCommand", &g_define_type_info, 0);
	return enhance_single_command_type_id;
}

GType
enhance_single_command_get_type (void)
{
	static volatile gsize enhance_single_command_type_id__once = 0;
	if (g_once_init_enter (&enhance_single_command_type_id__once)) {
		GType enhance_single_command_type_id;
		enhance_single_command_type_id = enhance_single_command_get_type_once ();
		g_once_init_leave (&enhance_single_command_type_id__once, enhance_single_command_type_id);
	}
	return enhance_single_command_type_id__once;
}

EnhanceMultipleCommand*
enhance_multiple_command_construct (GType object_type,
                                    GeeIterable* iter)
{
	EnhanceMultipleCommand * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (EnhanceMultipleCommand*) multiple_photo_transformation_command_construct (object_type, iter, _ ("Enhancing"), _ ("Undoing Enhance"), RESOURCES_ENHANCE_LABEL, RESOURCES_ENHANCE_TOOLTIP);
	return self;
}

EnhanceMultipleCommand*
enhance_multiple_command_new (GeeIterable* iter)
{
	return enhance_multiple_command_construct (TYPE_ENHANCE_MULTIPLE_COMMAND, iter);
}

static void
enhance_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                 DataSource* source)
{
	EnhanceMultipleCommand * self;
	self = (EnhanceMultipleCommand*) base;
	g_return_if_fail (source != NULL);
	photo_enhance (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo));
}

static void
enhance_multiple_command_class_init (EnhanceMultipleCommandClass * klass,
                                     gpointer klass_data)
{
	enhance_multiple_command_parent_class = g_type_class_peek_parent (klass);
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) enhance_multiple_command_real_execute_on_source;
}

static void
enhance_multiple_command_instance_init (EnhanceMultipleCommand * self,
                                        gpointer klass)
{
}

static GType
enhance_multiple_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EnhanceMultipleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enhance_multiple_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnhanceMultipleCommand), 0, (GInstanceInitFunc) enhance_multiple_command_instance_init, NULL };
	GType enhance_multiple_command_type_id;
	enhance_multiple_command_type_id = g_type_register_static (TYPE_MULTIPLE_PHOTO_TRANSFORMATION_COMMAND, "EnhanceMultipleCommand", &g_define_type_info, 0);
	return enhance_multiple_command_type_id;
}

GType
enhance_multiple_command_get_type (void)
{
	static volatile gsize enhance_multiple_command_type_id__once = 0;
	if (g_once_init_enter (&enhance_multiple_command_type_id__once)) {
		GType enhance_multiple_command_type_id;
		enhance_multiple_command_type_id = enhance_multiple_command_get_type_once ();
		g_once_init_leave (&enhance_multiple_command_type_id__once, enhance_multiple_command_type_id);
	}
	return enhance_multiple_command_type_id__once;
}

UnEnhanceSingleCommand*
un_enhance_single_command_construct (GType object_type,
                                     Photo* photo)
{
	UnEnhanceSingleCommand * self = NULL;
	g_return_val_if_fail (photo != NULL, NULL);
	self = (UnEnhanceSingleCommand*) generic_photo_transformation_command_construct (object_type, photo, RESOURCES_UNENHANCE_LABEL, RESOURCES_ENHANCE_TOOLTIP);
	return self;
}

UnEnhanceSingleCommand*
un_enhance_single_command_new (Photo* photo)
{
	return un_enhance_single_command_construct (TYPE_UN_ENHANCE_SINGLE_COMMAND, photo);
}

static void
un_enhance_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                                 Photo* photo)
{
	UnEnhanceSingleCommand * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	self = (UnEnhanceSingleCommand*) base;
	g_return_if_fail (photo != NULL);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	photo_unenhance (photo);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	page_window_set_normal_cursor ((PageWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static gboolean
un_enhance_single_command_real_compress (Command* base,
                                         Command* command)
{
	UnEnhanceSingleCommand * self;
	gboolean result;
	self = (UnEnhanceSingleCommand*) base;
	g_return_val_if_fail (command != NULL, FALSE);
	if (IS_UN_ENHANCE_SINGLE_COMMAND (command)) {
		UnEnhanceSingleCommand* unenhance_single_command = NULL;
		UnEnhanceSingleCommand* _tmp0_;
		UnEnhanceSingleCommand* _tmp1_;
		DataSource* _tmp2_;
		DataSource* _tmp3_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (command, TYPE_UN_ENHANCE_SINGLE_COMMAND, UnEnhanceSingleCommand));
		unenhance_single_command = _tmp0_;
		_tmp1_ = unenhance_single_command;
		_tmp2_ = ((SingleDataSourceCommand*) _tmp1_)->source;
		_tmp3_ = ((SingleDataSourceCommand*) self)->source;
		if (_tmp2_ != _tmp3_) {
			result = FALSE;
			_g_object_unref0 (unenhance_single_command);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (unenhance_single_command);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
un_enhance_single_command_class_init (UnEnhanceSingleCommandClass * klass,
                                      gpointer klass_data)
{
	un_enhance_single_command_parent_class = g_type_class_peek_parent (klass);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) un_enhance_single_command_real_execute_on_photo;
	((CommandClass *) klass)->compress = (gboolean (*) (Command*, Command*)) un_enhance_single_command_real_compress;
}

static void
un_enhance_single_command_instance_init (UnEnhanceSingleCommand * self,
                                         gpointer klass)
{
}

static GType
un_enhance_single_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnEnhanceSingleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) un_enhance_single_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnEnhanceSingleCommand), 0, (GInstanceInitFunc) un_enhance_single_command_instance_init, NULL };
	GType un_enhance_single_command_type_id;
	un_enhance_single_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "UnEnhanceSingleCommand", &g_define_type_info, 0);
	return un_enhance_single_command_type_id;
}

GType
un_enhance_single_command_get_type (void)
{
	static volatile gsize un_enhance_single_command_type_id__once = 0;
	if (g_once_init_enter (&un_enhance_single_command_type_id__once)) {
		GType un_enhance_single_command_type_id;
		un_enhance_single_command_type_id = un_enhance_single_command_get_type_once ();
		g_once_init_leave (&un_enhance_single_command_type_id__once, un_enhance_single_command_type_id);
	}
	return un_enhance_single_command_type_id__once;
}

UnEnhanceMultipleCommand*
un_enhance_multiple_command_construct (GType object_type,
                                       GeeIterable* iter)
{
	UnEnhanceMultipleCommand * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (UnEnhanceMultipleCommand*) multiple_photo_transformation_command_construct (object_type, iter, _ ("UnEnhancing"), _ ("Undoing UnEnhance"), RESOURCES_UNENHANCE_LABEL, RESOURCES_ENHANCE_TOOLTIP);
	return self;
}

UnEnhanceMultipleCommand*
un_enhance_multiple_command_new (GeeIterable* iter)
{
	return un_enhance_multiple_command_construct (TYPE_UN_ENHANCE_MULTIPLE_COMMAND, iter);
}

static void
un_enhance_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                    DataSource* source)
{
	UnEnhanceMultipleCommand * self;
	self = (UnEnhanceMultipleCommand*) base;
	g_return_if_fail (source != NULL);
	photo_unenhance (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo));
}

static void
un_enhance_multiple_command_class_init (UnEnhanceMultipleCommandClass * klass,
                                        gpointer klass_data)
{
	un_enhance_multiple_command_parent_class = g_type_class_peek_parent (klass);
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) un_enhance_multiple_command_real_execute_on_source;
}

static void
un_enhance_multiple_command_instance_init (UnEnhanceMultipleCommand * self,
                                           gpointer klass)
{
}

static GType
un_enhance_multiple_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnEnhanceMultipleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) un_enhance_multiple_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnEnhanceMultipleCommand), 0, (GInstanceInitFunc) un_enhance_multiple_command_instance_init, NULL };
	GType un_enhance_multiple_command_type_id;
	un_enhance_multiple_command_type_id = g_type_register_static (TYPE_MULTIPLE_PHOTO_TRANSFORMATION_COMMAND, "UnEnhanceMultipleCommand", &g_define_type_info, 0);
	return un_enhance_multiple_command_type_id;
}

GType
un_enhance_multiple_command_get_type (void)
{
	static volatile gsize un_enhance_multiple_command_type_id__once = 0;
	if (g_once_init_enter (&un_enhance_multiple_command_type_id__once)) {
		GType un_enhance_multiple_command_type_id;
		un_enhance_multiple_command_type_id = un_enhance_multiple_command_get_type_once ();
		g_once_init_leave (&un_enhance_multiple_command_type_id__once, un_enhance_multiple_command_type_id);
	}
	return un_enhance_multiple_command_type_id__once;
}

static inline gpointer
straighten_command_get_instance_private (StraightenCommand* self)
{
	return G_STRUCT_MEMBER_P (self, StraightenCommand_private_offset);
}

StraightenCommand*
straighten_command_construct (GType object_type,
                              Photo* photo,
                              gdouble theta,
                              Box* crop,
                              const gchar* name,
                              const gchar* explanation)
{
	StraightenCommand * self = NULL;
	Box _tmp0_;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (crop != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (StraightenCommand*) generic_photo_transformation_command_construct (object_type, photo, name, explanation);
	self->priv->theta = theta;
	_tmp0_ = *crop;
	self->priv->crop = _tmp0_;
	return self;
}

StraightenCommand*
straighten_command_new (Photo* photo,
                        gdouble theta,
                        Box* crop,
                        const gchar* name,
                        const gchar* explanation)
{
	return straighten_command_construct (TYPE_STRAIGHTEN_COMMAND, photo, theta, crop, name, explanation);
}

static void
straighten_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                          Photo* photo)
{
	StraightenCommand * self;
	Box _tmp0_;
	self = (StraightenCommand*) base;
	g_return_if_fail (photo != NULL);
	photo_set_straighten (photo, self->priv->theta);
	_tmp0_ = self->priv->crop;
	photo_set_crop (photo, &_tmp0_);
}

static void
straighten_command_class_init (StraightenCommandClass * klass,
                               gpointer klass_data)
{
	straighten_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StraightenCommand_private_offset);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) straighten_command_real_execute_on_photo;
	G_OBJECT_CLASS (klass)->finalize = straighten_command_finalize;
}

static void
straighten_command_instance_init (StraightenCommand * self,
                                  gpointer klass)
{
	self->priv = straighten_command_get_instance_private (self);
}

static void
straighten_command_finalize (GObject * obj)
{
	StraightenCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRAIGHTEN_COMMAND, StraightenCommand);
	G_OBJECT_CLASS (straighten_command_parent_class)->finalize (obj);
}

static GType
straighten_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StraightenCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) straighten_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StraightenCommand), 0, (GInstanceInitFunc) straighten_command_instance_init, NULL };
	GType straighten_command_type_id;
	straighten_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "StraightenCommand", &g_define_type_info, 0);
	StraightenCommand_private_offset = g_type_add_instance_private (straighten_command_type_id, sizeof (StraightenCommandPrivate));
	return straighten_command_type_id;
}

GType
straighten_command_get_type (void)
{
	static volatile gsize straighten_command_type_id__once = 0;
	if (g_once_init_enter (&straighten_command_type_id__once)) {
		GType straighten_command_type_id;
		straighten_command_type_id = straighten_command_get_type_once ();
		g_once_init_leave (&straighten_command_type_id__once, straighten_command_type_id);
	}
	return straighten_command_type_id__once;
}

static inline gpointer
crop_command_get_instance_private (CropCommand* self)
{
	return G_STRUCT_MEMBER_P (self, CropCommand_private_offset);
}

CropCommand*
crop_command_construct (GType object_type,
                        Photo* photo,
                        Box* crop,
                        const gchar* name,
                        const gchar* explanation)
{
	CropCommand * self = NULL;
	Box _tmp0_;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (crop != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (CropCommand*) generic_photo_transformation_command_construct (object_type, photo, name, explanation);
	_tmp0_ = *crop;
	self->priv->crop = _tmp0_;
	return self;
}

CropCommand*
crop_command_new (Photo* photo,
                  Box* crop,
                  const gchar* name,
                  const gchar* explanation)
{
	return crop_command_construct (TYPE_CROP_COMMAND, photo, crop, name, explanation);
}

static void
crop_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                    Photo* photo)
{
	CropCommand * self;
	Box _tmp0_;
	self = (CropCommand*) base;
	g_return_if_fail (photo != NULL);
	_tmp0_ = self->priv->crop;
	photo_set_crop (photo, &_tmp0_);
}

static void
crop_command_class_init (CropCommandClass * klass,
                         gpointer klass_data)
{
	crop_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CropCommand_private_offset);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) crop_command_real_execute_on_photo;
	G_OBJECT_CLASS (klass)->finalize = crop_command_finalize;
}

static void
crop_command_instance_init (CropCommand * self,
                            gpointer klass)
{
	self->priv = crop_command_get_instance_private (self);
}

static void
crop_command_finalize (GObject * obj)
{
	CropCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CROP_COMMAND, CropCommand);
	G_OBJECT_CLASS (crop_command_parent_class)->finalize (obj);
}

static GType
crop_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CropCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crop_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CropCommand), 0, (GInstanceInitFunc) crop_command_instance_init, NULL };
	GType crop_command_type_id;
	crop_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "CropCommand", &g_define_type_info, 0);
	CropCommand_private_offset = g_type_add_instance_private (crop_command_type_id, sizeof (CropCommandPrivate));
	return crop_command_type_id;
}

GType
crop_command_get_type (void)
{
	static volatile gsize crop_command_type_id__once = 0;
	if (g_once_init_enter (&crop_command_type_id__once)) {
		GType crop_command_type_id;
		crop_command_type_id = crop_command_get_type_once ();
		g_once_init_leave (&crop_command_type_id__once, crop_command_type_id);
	}
	return crop_command_type_id__once;
}

static inline gpointer
adjust_colors_single_command_get_instance_private (AdjustColorsSingleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, AdjustColorsSingleCommand_private_offset);
}

static gpointer
_pixel_transformation_bundle_ref0 (gpointer self)
{
	return self ? pixel_transformation_bundle_ref (self) : NULL;
}

AdjustColorsSingleCommand*
adjust_colors_single_command_construct (GType object_type,
                                        Photo* photo,
                                        PixelTransformationBundle* transformations,
                                        const gchar* name,
                                        const gchar* explanation)
{
	AdjustColorsSingleCommand * self = NULL;
	PixelTransformationBundle* _tmp0_;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (transformations != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (AdjustColorsSingleCommand*) generic_photo_transformation_command_construct (object_type, photo, name, explanation);
	_tmp0_ = _pixel_transformation_bundle_ref0 (transformations);
	_pixel_transformation_bundle_unref0 (self->priv->transformations);
	self->priv->transformations = _tmp0_;
	return self;
}

AdjustColorsSingleCommand*
adjust_colors_single_command_new (Photo* photo,
                                  PixelTransformationBundle* transformations,
                                  const gchar* name,
                                  const gchar* explanation)
{
	return adjust_colors_single_command_construct (TYPE_ADJUST_COLORS_SINGLE_COMMAND, photo, transformations, name, explanation);
}

static void
adjust_colors_single_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                                    Photo* photo)
{
	AdjustColorsSingleCommand * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	PixelTransformationBundle* _tmp2_;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	self = (AdjustColorsSingleCommand*) base;
	g_return_if_fail (photo != NULL);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->transformations;
	photo_set_color_adjustments (photo, _tmp2_);
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	page_window_set_normal_cursor ((PageWindow*) _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static gboolean
adjust_colors_single_command_real_can_compress (GenericPhotoTransformationCommand* base,
                                                Command* command)
{
	AdjustColorsSingleCommand * self;
	gboolean result;
	self = (AdjustColorsSingleCommand*) base;
	g_return_val_if_fail (command != NULL, FALSE);
	result = IS_ADJUST_COLORS_SINGLE_COMMAND (command);
	return result;
}

static void
adjust_colors_single_command_class_init (AdjustColorsSingleCommandClass * klass,
                                         gpointer klass_data)
{
	adjust_colors_single_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdjustColorsSingleCommand_private_offset);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) adjust_colors_single_command_real_execute_on_photo;
	((GenericPhotoTransformationCommandClass *) klass)->can_compress = (gboolean (*) (GenericPhotoTransformationCommand*, Command*)) adjust_colors_single_command_real_can_compress;
	G_OBJECT_CLASS (klass)->finalize = adjust_colors_single_command_finalize;
}

static void
adjust_colors_single_command_instance_init (AdjustColorsSingleCommand * self,
                                            gpointer klass)
{
	self->priv = adjust_colors_single_command_get_instance_private (self);
}

static void
adjust_colors_single_command_finalize (GObject * obj)
{
	AdjustColorsSingleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_COLORS_SINGLE_COMMAND, AdjustColorsSingleCommand);
	_pixel_transformation_bundle_unref0 (self->priv->transformations);
	G_OBJECT_CLASS (adjust_colors_single_command_parent_class)->finalize (obj);
}

static GType
adjust_colors_single_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdjustColorsSingleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adjust_colors_single_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdjustColorsSingleCommand), 0, (GInstanceInitFunc) adjust_colors_single_command_instance_init, NULL };
	GType adjust_colors_single_command_type_id;
	adjust_colors_single_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "AdjustColorsSingleCommand", &g_define_type_info, 0);
	AdjustColorsSingleCommand_private_offset = g_type_add_instance_private (adjust_colors_single_command_type_id, sizeof (AdjustColorsSingleCommandPrivate));
	return adjust_colors_single_command_type_id;
}

GType
adjust_colors_single_command_get_type (void)
{
	static volatile gsize adjust_colors_single_command_type_id__once = 0;
	if (g_once_init_enter (&adjust_colors_single_command_type_id__once)) {
		GType adjust_colors_single_command_type_id;
		adjust_colors_single_command_type_id = adjust_colors_single_command_get_type_once ();
		g_once_init_leave (&adjust_colors_single_command_type_id__once, adjust_colors_single_command_type_id);
	}
	return adjust_colors_single_command_type_id__once;
}

static inline gpointer
adjust_colors_multiple_command_get_instance_private (AdjustColorsMultipleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, AdjustColorsMultipleCommand_private_offset);
}

AdjustColorsMultipleCommand*
adjust_colors_multiple_command_construct (GType object_type,
                                          GeeIterable* iter,
                                          PixelTransformationBundle* transformations,
                                          const gchar* name,
                                          const gchar* explanation)
{
	AdjustColorsMultipleCommand * self = NULL;
	PixelTransformationBundle* _tmp0_;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (transformations != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (AdjustColorsMultipleCommand*) multiple_photo_transformation_command_construct (object_type, iter, _ ("Applying Color Transformations"), _ ("Undoing Color Transformations"), name, explanation);
	_tmp0_ = _pixel_transformation_bundle_ref0 (transformations);
	_pixel_transformation_bundle_unref0 (self->priv->transformations);
	self->priv->transformations = _tmp0_;
	return self;
}

AdjustColorsMultipleCommand*
adjust_colors_multiple_command_new (GeeIterable* iter,
                                    PixelTransformationBundle* transformations,
                                    const gchar* name,
                                    const gchar* explanation)
{
	return adjust_colors_multiple_command_construct (TYPE_ADJUST_COLORS_MULTIPLE_COMMAND, iter, transformations, name, explanation);
}

static void
adjust_colors_multiple_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                       DataSource* source)
{
	AdjustColorsMultipleCommand * self;
	PixelTransformationBundle* _tmp0_;
	self = (AdjustColorsMultipleCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->transformations;
	photo_set_color_adjustments (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo), _tmp0_);
}

static void
adjust_colors_multiple_command_class_init (AdjustColorsMultipleCommandClass * klass,
                                           gpointer klass_data)
{
	adjust_colors_multiple_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdjustColorsMultipleCommand_private_offset);
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) adjust_colors_multiple_command_real_execute_on_source;
	G_OBJECT_CLASS (klass)->finalize = adjust_colors_multiple_command_finalize;
}

static void
adjust_colors_multiple_command_instance_init (AdjustColorsMultipleCommand * self,
                                              gpointer klass)
{
	self->priv = adjust_colors_multiple_command_get_instance_private (self);
}

static void
adjust_colors_multiple_command_finalize (GObject * obj)
{
	AdjustColorsMultipleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_COLORS_MULTIPLE_COMMAND, AdjustColorsMultipleCommand);
	_pixel_transformation_bundle_unref0 (self->priv->transformations);
	G_OBJECT_CLASS (adjust_colors_multiple_command_parent_class)->finalize (obj);
}

static GType
adjust_colors_multiple_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdjustColorsMultipleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adjust_colors_multiple_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdjustColorsMultipleCommand), 0, (GInstanceInitFunc) adjust_colors_multiple_command_instance_init, NULL };
	GType adjust_colors_multiple_command_type_id;
	adjust_colors_multiple_command_type_id = g_type_register_static (TYPE_MULTIPLE_PHOTO_TRANSFORMATION_COMMAND, "AdjustColorsMultipleCommand", &g_define_type_info, 0);
	AdjustColorsMultipleCommand_private_offset = g_type_add_instance_private (adjust_colors_multiple_command_type_id, sizeof (AdjustColorsMultipleCommandPrivate));
	return adjust_colors_multiple_command_type_id;
}

GType
adjust_colors_multiple_command_get_type (void)
{
	static volatile gsize adjust_colors_multiple_command_type_id__once = 0;
	if (g_once_init_enter (&adjust_colors_multiple_command_type_id__once)) {
		GType adjust_colors_multiple_command_type_id;
		adjust_colors_multiple_command_type_id = adjust_colors_multiple_command_get_type_once ();
		g_once_init_leave (&adjust_colors_multiple_command_type_id__once, adjust_colors_multiple_command_type_id);
	}
	return adjust_colors_multiple_command_type_id__once;
}

static inline gpointer
redeye_command_get_instance_private (RedeyeCommand* self)
{
	return G_STRUCT_MEMBER_P (self, RedeyeCommand_private_offset);
}

RedeyeCommand*
redeye_command_construct (GType object_type,
                          Photo* photo,
                          EditingToolsRedeyeInstance* redeye_instance,
                          const gchar* name,
                          const gchar* explanation)
{
	RedeyeCommand * self = NULL;
	EditingToolsRedeyeInstance _tmp0_;
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (redeye_instance != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (RedeyeCommand*) generic_photo_transformation_command_construct (object_type, photo, name, explanation);
	_tmp0_ = *redeye_instance;
	self->priv->redeye_instance = _tmp0_;
	return self;
}

RedeyeCommand*
redeye_command_new (Photo* photo,
                    EditingToolsRedeyeInstance* redeye_instance,
                    const gchar* name,
                    const gchar* explanation)
{
	return redeye_command_construct (TYPE_REDEYE_COMMAND, photo, redeye_instance, name, explanation);
}

static void
redeye_command_real_execute_on_photo (GenericPhotoTransformationCommand* base,
                                      Photo* photo)
{
	RedeyeCommand * self;
	EditingToolsRedeyeInstance _tmp0_;
	self = (RedeyeCommand*) base;
	g_return_if_fail (photo != NULL);
	_tmp0_ = self->priv->redeye_instance;
	photo_add_redeye_instance (photo, &_tmp0_);
}

static void
redeye_command_class_init (RedeyeCommandClass * klass,
                           gpointer klass_data)
{
	redeye_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RedeyeCommand_private_offset);
	((GenericPhotoTransformationCommandClass *) klass)->execute_on_photo = (void (*) (GenericPhotoTransformationCommand*, Photo*)) redeye_command_real_execute_on_photo;
	G_OBJECT_CLASS (klass)->finalize = redeye_command_finalize;
}

static void
redeye_command_instance_init (RedeyeCommand * self,
                              gpointer klass)
{
	self->priv = redeye_command_get_instance_private (self);
}

static void
redeye_command_finalize (GObject * obj)
{
	RedeyeCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REDEYE_COMMAND, RedeyeCommand);
	G_OBJECT_CLASS (redeye_command_parent_class)->finalize (obj);
}

static GType
redeye_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RedeyeCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) redeye_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RedeyeCommand), 0, (GInstanceInitFunc) redeye_command_instance_init, NULL };
	GType redeye_command_type_id;
	redeye_command_type_id = g_type_register_static (TYPE_GENERIC_PHOTO_TRANSFORMATION_COMMAND, "RedeyeCommand", &g_define_type_info, 0);
	RedeyeCommand_private_offset = g_type_add_instance_private (redeye_command_type_id, sizeof (RedeyeCommandPrivate));
	return redeye_command_type_id;
}

GType
redeye_command_get_type (void)
{
	static volatile gsize redeye_command_type_id__once = 0;
	if (g_once_init_enter (&redeye_command_type_id__once)) {
		GType redeye_command_type_id;
		redeye_command_type_id = redeye_command_get_type_once ();
		g_once_init_leave (&redeye_command_type_id__once, redeye_command_type_id);
	}
	return redeye_command_type_id__once;
}

MovePhotosCommand*
move_photos_command_construct (GType object_type,
                               const gchar* name,
                               const gchar* explanation)
{
	MovePhotosCommand * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (MovePhotosCommand*) command_construct (object_type, name, explanation);
	return self;
}

static void
move_photos_command_real_prepare (Command* base)
{
	MovePhotosCommand * self;
	MovePhotosCommandRealMovePhotosCommand* _tmp0_;
	MovePhotosCommandRealMovePhotosCommand* _tmp1_;
	self = (MovePhotosCommand*) base;
	_tmp0_ = self->real_command;
	_vala_assert (_tmp0_ != NULL, "real_command != null");
	_tmp1_ = self->real_command;
	command_prepare ((Command*) _tmp1_);
}

static void
move_photos_command_real_execute (Command* base)
{
	MovePhotosCommand * self;
	MovePhotosCommandRealMovePhotosCommand* _tmp0_;
	MovePhotosCommandRealMovePhotosCommand* _tmp1_;
	self = (MovePhotosCommand*) base;
	_tmp0_ = self->real_command;
	_vala_assert (_tmp0_ != NULL, "real_command != null");
	_tmp1_ = self->real_command;
	command_execute ((Command*) _tmp1_);
}

static void
move_photos_command_real_undo (Command* base)
{
	MovePhotosCommand * self;
	MovePhotosCommandRealMovePhotosCommand* _tmp0_;
	MovePhotosCommandRealMovePhotosCommand* _tmp1_;
	self = (MovePhotosCommand*) base;
	_tmp0_ = self->real_command;
	_vala_assert (_tmp0_ != NULL, "real_command != null");
	_tmp1_ = self->real_command;
	command_undo ((Command*) _tmp1_);
}

static inline gpointer
move_photos_command_real_move_photos_command_get_instance_private (MovePhotosCommandRealMovePhotosCommand* self)
{
	return G_STRUCT_MEMBER_P (self, MovePhotosCommandRealMovePhotosCommand_private_offset);
}

static void
_move_photos_command_real_move_photos_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                                                   gpointer self)
{
	move_photos_command_real_move_photos_command_on_proxy_broken ((MovePhotosCommandRealMovePhotosCommand*) self);
}

static gpointer
_source_proxy_ref0 (gpointer self)
{
	return self ? source_proxy_ref (self) : NULL;
}

MovePhotosCommandRealMovePhotosCommand*
move_photos_command_real_move_photos_command_construct (GType object_type,
                                                        Event* new_event,
                                                        GeeIterable* source_views,
                                                        const gchar* progress_text,
                                                        const gchar* undo_progress_text,
                                                        const gchar* name,
                                                        const gchar* explanation)
{
	MovePhotosCommandRealMovePhotosCommand * self = NULL;
	SourceProxy* _tmp22_;
	SourceProxy* _tmp23_;
	g_return_val_if_fail (source_views != NULL, NULL);
	g_return_val_if_fail (progress_text != NULL, NULL);
	g_return_val_if_fail (undo_progress_text != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (explanation != NULL, NULL);
	self = (MovePhotosCommandRealMovePhotosCommand*) multiple_data_source_command_construct (object_type, source_views, progress_text, undo_progress_text, name, explanation);
	{
		GeeArrayList* _source_list = NULL;
		GeeArrayList* _tmp0_;
		gint _source_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _source_index = 0;
		_tmp0_ = ((MultipleDataSourceCommand*) self)->source_list;
		_source_list = _tmp0_;
		_tmp1_ = _source_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_source_size = _tmp3_;
		_source_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DataSource* source = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MediaSource* current_media = NULL;
			DataSource* _tmp8_;
			MediaSource* _tmp9_;
			Event* old_event = NULL;
			MediaSource* _tmp10_;
			Event* _tmp11_;
			SourceProxy* _tmp12_ = NULL;
			Event* _tmp13_;
			SourceProxy* old_event_proxy = NULL;
			SourceProxy* _tmp16_;
			SourceProxy* _tmp17_;
			GeeHashMap* _tmp19_;
			MediaSource* _tmp20_;
			SourceProxy* _tmp21_;
			_source_index = _source_index + 1;
			_tmp4_ = _source_index;
			_tmp5_ = _source_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _source_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _source_index);
			source = (DataSource*) _tmp7_;
			_tmp8_ = source;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
			current_media = _tmp9_;
			_tmp10_ = current_media;
			_tmp11_ = media_source_get_event (_tmp10_);
			old_event = _tmp11_;
			_tmp13_ = old_event;
			if (_tmp13_ != NULL) {
				Event* _tmp14_;
				SourceProxy* _tmp15_;
				_tmp14_ = old_event;
				_tmp15_ = proxyable_get_proxy ((Proxyable*) _tmp14_);
				_source_proxy_unref0 (_tmp12_);
				_tmp12_ = _tmp15_;
			} else {
				_source_proxy_unref0 (_tmp12_);
				_tmp12_ = NULL;
			}
			_tmp16_ = _source_proxy_ref0 (_tmp12_);
			old_event_proxy = _tmp16_;
			_tmp17_ = old_event_proxy;
			if (_tmp17_ != NULL) {
				SourceProxy* _tmp18_;
				_tmp18_ = old_event_proxy;
				g_signal_connect_object (_tmp18_, "broken", (GCallback) _move_photos_command_real_move_photos_command_on_proxy_broken_source_proxy_broken, self, 0);
			}
			_tmp19_ = self->priv->old_events;
			_tmp20_ = current_media;
			_tmp21_ = old_event_proxy;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp20_, _tmp21_);
			_source_proxy_unref0 (old_event_proxy);
			_source_proxy_unref0 (_tmp12_);
			_g_object_unref0 (old_event);
			_g_object_unref0 (current_media);
			_g_object_unref0 (source);
		}
	}
	_tmp22_ = proxyable_get_proxy ((Proxyable*) new_event);
	_source_proxy_unref0 (self->priv->new_event_proxy);
	self->priv->new_event_proxy = _tmp22_;
	_tmp23_ = self->priv->new_event_proxy;
	g_signal_connect_object (_tmp23_, "broken", (GCallback) _move_photos_command_real_move_photos_command_on_proxy_broken_source_proxy_broken, self, 0);
	return self;
}

MovePhotosCommandRealMovePhotosCommand*
move_photos_command_real_move_photos_command_new (Event* new_event,
                                                  GeeIterable* source_views,
                                                  const gchar* progress_text,
                                                  const gchar* undo_progress_text,
                                                  const gchar* name,
                                                  const gchar* explanation)
{
	return move_photos_command_real_move_photos_command_construct (MOVE_PHOTOS_COMMAND_TYPE_REAL_MOVE_PHOTOS_COMMAND, new_event, source_views, progress_text, undo_progress_text, name, explanation);
}

static void
move_photos_command_real_move_photos_command_real_execute (Command* base)
{
	MovePhotosCommandRealMovePhotosCommand * self;
	LibraryWindow* _tmp0_;
	LibraryWindow* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	gboolean _tmp4_;
	self = (MovePhotosCommandRealMovePhotosCommand*) base;
	_tmp0_ = library_window_get_app ();
	_tmp1_ = _tmp0_;
	_tmp2_ = page_window_get_current_page ((PageWindow*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = IS_EVENT_PAGE (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		Event* evt = NULL;
		LibraryWindow* _tmp5_;
		LibraryWindow* _tmp6_;
		Page* _tmp7_;
		EventPage* _tmp8_;
		Event* _tmp9_;
		Event* _tmp10_;
		Event* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp5_ = library_window_get_app ();
		_tmp6_ = _tmp5_;
		_tmp7_ = page_window_get_current_page ((PageWindow*) _tmp6_);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_EVENT_PAGE, EventPage);
		_tmp9_ = event_page_get_event (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		evt = _tmp10_;
		_tmp11_ = evt;
		_tmp12_ = ((MultipleDataSourceCommand*) self)->source_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (event_source_get_media_count ((EventSource*) _tmp11_) == _tmp14_) {
			LibraryWindow* _tmp15_;
			LibraryWindow* _tmp16_;
			SourceProxy* _tmp17_;
			DataSource* _tmp18_;
			Event* _tmp19_;
			_tmp15_ = library_window_get_app ();
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->new_event_proxy;
			_tmp18_ = source_proxy_get_source (_tmp17_);
			_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_EVENT, Event);
			library_window_switch_to_event (_tmp16_, _tmp19_);
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (_tmp16_);
		}
		_g_object_unref0 (evt);
	} else {
		SourceProxy* _tmp20_;
		DataSource* _tmp21_;
		Event* _tmp22_;
		gboolean _tmp23_;
		_tmp20_ = self->priv->new_event_proxy;
		_tmp21_ = source_proxy_get_source (_tmp20_);
		_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_EVENT, Event);
		_tmp23_ = event_source_get_media_count ((EventSource*) _tmp22_) == 0;
		_g_object_unref0 (_tmp22_);
		if (_tmp23_) {
			LibraryWindow* _tmp24_;
			LibraryWindow* _tmp25_;
			SourceProxy* _tmp26_;
			DataSource* _tmp27_;
			Event* _tmp28_;
			_tmp24_ = library_window_get_app ();
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->new_event_proxy;
			_tmp27_ = source_proxy_get_source (_tmp26_);
			_tmp28_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_EVENT, Event);
			library_window_switch_to_event (_tmp25_, _tmp28_);
			_g_object_unref0 (_tmp28_);
			_g_object_unref0 (_tmp25_);
		}
	}
	COMMAND_CLASS (move_photos_command_real_move_photos_command_parent_class)->execute ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
}

static void
move_photos_command_real_move_photos_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                                     DataSource* source)
{
	MovePhotosCommandRealMovePhotosCommand * self;
	SourceProxy* _tmp0_;
	DataSource* _tmp1_;
	Event* _tmp2_;
	self = (MovePhotosCommandRealMovePhotosCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->new_event_proxy;
	_tmp1_ = source_proxy_get_source (_tmp0_);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_EVENT, Event);
	media_source_set_event (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource), _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
move_photos_command_real_move_photos_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                                  DataSource* source)
{
	MovePhotosCommandRealMovePhotosCommand * self;
	MediaSource* current_media = NULL;
	MediaSource* _tmp0_;
	SourceProxy* event_proxy = NULL;
	GeeHashMap* _tmp1_;
	MediaSource* _tmp2_;
	gpointer _tmp3_;
	Event* _tmp4_ = NULL;
	SourceProxy* _tmp5_;
	MediaSource* _tmp8_;
	self = (MovePhotosCommandRealMovePhotosCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
	current_media = _tmp0_;
	_tmp1_ = self->priv->old_events;
	_tmp2_ = current_media;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	event_proxy = (SourceProxy*) _tmp3_;
	_tmp5_ = event_proxy;
	if (_tmp5_ != NULL) {
		SourceProxy* _tmp6_;
		DataSource* _tmp7_;
		_tmp6_ = event_proxy;
		_tmp7_ = source_proxy_get_source (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_EVENT, Event);
	} else {
		_g_object_unref0 (_tmp4_);
		_tmp4_ = NULL;
	}
	_tmp8_ = current_media;
	media_source_set_event (_tmp8_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_source_proxy_unref0 (event_proxy);
	_g_object_unref0 (current_media);
}

static void
move_photos_command_real_move_photos_command_on_proxy_broken (MovePhotosCommandRealMovePhotosCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
move_photos_command_real_move_photos_command_class_init (MovePhotosCommandRealMovePhotosCommandClass * klass,
                                                         gpointer klass_data)
{
	move_photos_command_real_move_photos_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MovePhotosCommandRealMovePhotosCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) move_photos_command_real_move_photos_command_real_execute;
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) move_photos_command_real_move_photos_command_real_execute_on_source;
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) move_photos_command_real_move_photos_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = move_photos_command_real_move_photos_command_finalize;
}

static void
move_photos_command_real_move_photos_command_instance_init (MovePhotosCommandRealMovePhotosCommand * self,
                                                            gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = move_photos_command_real_move_photos_command_get_instance_private (self);
	self->priv->new_event_proxy = NULL;
	_tmp0_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->old_events = _tmp0_;
}

static void
move_photos_command_real_move_photos_command_finalize (GObject * obj)
{
	MovePhotosCommandRealMovePhotosCommand * self;
	SourceProxy* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOVE_PHOTOS_COMMAND_TYPE_REAL_MOVE_PHOTOS_COMMAND, MovePhotosCommandRealMovePhotosCommand);
	_tmp0_ = self->priv->new_event_proxy;
	g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _move_photos_command_real_move_photos_command_on_proxy_broken_source_proxy_broken, self);
	{
		GeeIterator* _proxy_it = NULL;
		GeeHashMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = self->priv->old_events;
		_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_proxy_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			SourceProxy* proxy = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			SourceProxy* _tmp11_;
			_tmp8_ = _proxy_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _proxy_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			proxy = (SourceProxy*) _tmp10_;
			_tmp11_ = proxy;
			if (_tmp11_ != NULL) {
				SourceProxy* _tmp12_;
				guint _tmp13_;
				_tmp12_ = proxy;
				g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp13_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _move_photos_command_real_move_photos_command_on_proxy_broken_source_proxy_broken, self);
			}
			_source_proxy_unref0 (proxy);
		}
		_g_object_unref0 (_proxy_it);
	}
	_source_proxy_unref0 (self->priv->new_event_proxy);
	_g_object_unref0 (self->priv->old_events);
	G_OBJECT_CLASS (move_photos_command_real_move_photos_command_parent_class)->finalize (obj);
}

static GType
move_photos_command_real_move_photos_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MovePhotosCommandRealMovePhotosCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) move_photos_command_real_move_photos_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MovePhotosCommandRealMovePhotosCommand), 0, (GInstanceInitFunc) move_photos_command_real_move_photos_command_instance_init, NULL };
	GType move_photos_command_real_move_photos_command_type_id;
	move_photos_command_real_move_photos_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_COMMAND, "MovePhotosCommandRealMovePhotosCommand", &g_define_type_info, 0);
	MovePhotosCommandRealMovePhotosCommand_private_offset = g_type_add_instance_private (move_photos_command_real_move_photos_command_type_id, sizeof (MovePhotosCommandRealMovePhotosCommandPrivate));
	return move_photos_command_real_move_photos_command_type_id;
}

GType
move_photos_command_real_move_photos_command_get_type (void)
{
	static volatile gsize move_photos_command_real_move_photos_command_type_id__once = 0;
	if (g_once_init_enter (&move_photos_command_real_move_photos_command_type_id__once)) {
		GType move_photos_command_real_move_photos_command_type_id;
		move_photos_command_real_move_photos_command_type_id = move_photos_command_real_move_photos_command_get_type_once ();
		g_once_init_leave (&move_photos_command_real_move_photos_command_type_id__once, move_photos_command_real_move_photos_command_type_id);
	}
	return move_photos_command_real_move_photos_command_type_id__once;
}

static void
move_photos_command_class_init (MovePhotosCommandClass * klass,
                                gpointer klass_data)
{
	move_photos_command_parent_class = g_type_class_peek_parent (klass);
	((CommandClass *) klass)->prepare = (void (*) (Command*)) move_photos_command_real_prepare;
	((CommandClass *) klass)->execute = (void (*) (Command*)) move_photos_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) move_photos_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = move_photos_command_finalize;
}

static void
move_photos_command_instance_init (MovePhotosCommand * self,
                                   gpointer klass)
{
}

static void
move_photos_command_finalize (GObject * obj)
{
	MovePhotosCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOVE_PHOTOS_COMMAND, MovePhotosCommand);
	_g_object_unref0 (self->real_command);
	G_OBJECT_CLASS (move_photos_command_parent_class)->finalize (obj);
}

static GType
move_photos_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MovePhotosCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) move_photos_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MovePhotosCommand), 0, (GInstanceInitFunc) move_photos_command_instance_init, NULL };
	GType move_photos_command_type_id;
	move_photos_command_type_id = g_type_register_static (TYPE_COMMAND, "MovePhotosCommand", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return move_photos_command_type_id;
}

GType
move_photos_command_get_type (void)
{
	static volatile gsize move_photos_command_type_id__once = 0;
	if (g_once_init_enter (&move_photos_command_type_id__once)) {
		GType move_photos_command_type_id;
		move_photos_command_type_id = move_photos_command_get_type_once ();
		g_once_init_leave (&move_photos_command_type_id__once, move_photos_command_type_id);
	}
	return move_photos_command_type_id__once;
}

NewEventCommand*
new_event_command_construct (GType object_type,
                             GeeIterable* iter)
{
	NewEventCommand * self = NULL;
	MediaSource* key_source = NULL;
	MediaSource* _tmp11_;
	Event* new_event = NULL;
	MediaSource* _tmp12_;
	Event* _tmp13_;
	MovePhotosCommandRealMovePhotosCommand* _tmp14_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (NewEventCommand*) move_photos_command_construct (object_type, RESOURCES_NEW_EVENT_LABEL, "");
	key_source = NULL;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (iter);
		_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			MediaSource* current_source = NULL;
			DataView* _tmp4_;
			DataSource* _tmp5_;
			DataSource* _tmp6_;
			MediaSource* _tmp7_;
			MediaSource* _tmp8_;
			_tmp1_ = _view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			view = (DataView*) _tmp3_;
			_tmp4_ = view;
			_tmp5_ = data_view_get_source (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
			current_source = _tmp7_;
			_tmp8_ = key_source;
			if (_tmp8_ == NULL) {
				MediaSource* _tmp9_;
				MediaSource* _tmp10_;
				_tmp9_ = current_source;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (key_source);
				key_source = _tmp10_;
				_g_object_unref0 (current_source);
				_g_object_unref0 (view);
				break;
			}
			_g_object_unref0 (current_source);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp11_ = key_source;
	_vala_assert (_tmp11_ != NULL, "key_source != null");
	_tmp12_ = key_source;
	_tmp13_ = event_create_empty_event (_tmp12_);
	new_event = _tmp13_;
	_tmp14_ = move_photos_command_real_move_photos_command_new (new_event, iter, _ ("Creating New Event"), _ ("Removing Event"), RESOURCES_NEW_EVENT_LABEL, "");
	_g_object_unref0 (((MovePhotosCommand*) self)->real_command);
	((MovePhotosCommand*) self)->real_command = _tmp14_;
	_g_object_unref0 (new_event);
	_g_object_unref0 (key_source);
	return self;
}

NewEventCommand*
new_event_command_new (GeeIterable* iter)
{
	return new_event_command_construct (TYPE_NEW_EVENT_COMMAND, iter);
}

static void
new_event_command_class_init (NewEventCommandClass * klass,
                              gpointer klass_data)
{
	new_event_command_parent_class = g_type_class_peek_parent (klass);
}

static void
new_event_command_instance_init (NewEventCommand * self,
                                 gpointer klass)
{
}

static GType
new_event_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NewEventCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) new_event_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NewEventCommand), 0, (GInstanceInitFunc) new_event_command_instance_init, NULL };
	GType new_event_command_type_id;
	new_event_command_type_id = g_type_register_static (TYPE_MOVE_PHOTOS_COMMAND, "NewEventCommand", &g_define_type_info, 0);
	return new_event_command_type_id;
}

GType
new_event_command_get_type (void)
{
	static volatile gsize new_event_command_type_id__once = 0;
	if (g_once_init_enter (&new_event_command_type_id__once)) {
		GType new_event_command_type_id;
		new_event_command_type_id = new_event_command_get_type_once ();
		g_once_init_leave (&new_event_command_type_id__once, new_event_command_type_id);
	}
	return new_event_command_type_id__once;
}

SetEventCommand*
set_event_command_construct (GType object_type,
                             GeeIterable* iter,
                             Event* new_event)
{
	SetEventCommand * self = NULL;
	MovePhotosCommandRealMovePhotosCommand* _tmp0_;
	g_return_val_if_fail (iter != NULL, NULL);
	g_return_val_if_fail (new_event != NULL, NULL);
	self = (SetEventCommand*) move_photos_command_construct (object_type, RESOURCES_SET_PHOTO_EVENT_LABEL, RESOURCES_SET_PHOTO_EVENT_TOOLTIP);
	_tmp0_ = move_photos_command_real_move_photos_command_new (new_event, iter, _ ("Moving Photos to New Event"), _ ("Setting Photos to Previous Event"), RESOURCES_SET_PHOTO_EVENT_LABEL, "");
	_g_object_unref0 (((MovePhotosCommand*) self)->real_command);
	((MovePhotosCommand*) self)->real_command = _tmp0_;
	return self;
}

SetEventCommand*
set_event_command_new (GeeIterable* iter,
                       Event* new_event)
{
	return set_event_command_construct (TYPE_SET_EVENT_COMMAND, iter, new_event);
}

static void
set_event_command_class_init (SetEventCommandClass * klass,
                              gpointer klass_data)
{
	set_event_command_parent_class = g_type_class_peek_parent (klass);
}

static void
set_event_command_instance_init (SetEventCommand * self,
                                 gpointer klass)
{
}

static GType
set_event_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SetEventCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) set_event_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetEventCommand), 0, (GInstanceInitFunc) set_event_command_instance_init, NULL };
	GType set_event_command_type_id;
	set_event_command_type_id = g_type_register_static (TYPE_MOVE_PHOTOS_COMMAND, "SetEventCommand", &g_define_type_info, 0);
	return set_event_command_type_id;
}

GType
set_event_command_get_type (void)
{
	static volatile gsize set_event_command_type_id__once = 0;
	if (g_once_init_enter (&set_event_command_type_id__once)) {
		GType set_event_command_type_id;
		set_event_command_type_id = set_event_command_get_type_once ();
		g_once_init_leave (&set_event_command_type_id__once, set_event_command_type_id);
	}
	return set_event_command_type_id__once;
}

MergeEventsCommand*
merge_events_command_construct (GType object_type,
                                GeeIterable* iter)
{
	MergeEventsCommand * self = NULL;
	Event* master_event = NULL;
	gint named_evt_src_count = 0;
	gint unnamed_evt_src_count = 0;
	GeeArrayList* media_thumbs = NULL;
	GeeArrayList* _tmp0_;
	Event* _tmp36_;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	Event* _tmp40_;
	GeeArrayList* _tmp41_;
	MovePhotosCommandRealMovePhotosCommand* _tmp42_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (MergeEventsCommand*) move_photos_command_construct (object_type, RESOURCES_MERGE_LABEL, "");
	master_event = NULL;
	named_evt_src_count = 0;
	unnamed_evt_src_count = 0;
	_tmp0_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	media_thumbs = _tmp0_;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (iter);
		_view_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataView* view = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			Event* event = NULL;
			DataView* _tmp5_;
			DataSource* _tmp6_;
			DataSource* _tmp7_;
			Event* _tmp8_;
			Event* _tmp9_;
			_tmp2_ = _view_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _view_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			view = (DataView*) _tmp4_;
			_tmp5_ = view;
			_tmp6_ = data_view_get_source (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_EVENT, Event));
			event = _tmp8_;
			_tmp9_ = master_event;
			if (_tmp9_ == NULL) {
				Event* _tmp10_;
				Event* _tmp11_;
				Event* _tmp12_;
				Event* _tmp13_;
				_tmp10_ = event;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (master_event);
				master_event = _tmp11_;
				_tmp12_ = master_event;
				unnamed_evt_src_count = event_source_get_media_count ((EventSource*) _tmp12_);
				_tmp13_ = event;
				if (event_has_name (_tmp13_)) {
					Event* _tmp14_;
					_tmp14_ = master_event;
					named_evt_src_count = event_source_get_media_count ((EventSource*) _tmp14_);
				}
			} else {
				Event* _tmp15_;
				_tmp15_ = event;
				if (event_has_name (_tmp15_)) {
					Event* _tmp16_;
					_tmp16_ = event;
					if (event_source_get_media_count ((EventSource*) _tmp16_) > named_evt_src_count) {
						Event* _tmp17_;
						Event* _tmp18_;
						Event* _tmp19_;
						_tmp17_ = event;
						named_evt_src_count = event_source_get_media_count ((EventSource*) _tmp17_);
						_tmp18_ = event;
						_tmp19_ = _g_object_ref0 (_tmp18_);
						_g_object_unref0 (master_event);
						master_event = _tmp19_;
					}
				} else {
					if (named_evt_src_count == 0) {
						Event* _tmp20_;
						_tmp20_ = event;
						if (event_source_get_media_count ((EventSource*) _tmp20_) > unnamed_evt_src_count) {
							Event* _tmp21_;
							Event* _tmp22_;
							Event* _tmp23_;
							_tmp21_ = event;
							unnamed_evt_src_count = event_source_get_media_count ((EventSource*) _tmp21_);
							_tmp22_ = event;
							_tmp23_ = _g_object_ref0 (_tmp22_);
							_g_object_unref0 (master_event);
							master_event = _tmp23_;
						}
					}
				}
			}
			{
				GeeIterator* _media_source_it = NULL;
				Event* _tmp24_;
				GeeCollection* _tmp25_;
				GeeCollection* _tmp26_;
				GeeIterator* _tmp27_;
				GeeIterator* _tmp28_;
				_tmp24_ = event;
				_tmp25_ = event_source_get_media ((EventSource*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
				_tmp28_ = _tmp27_;
				_g_object_unref0 (_tmp26_);
				_media_source_it = _tmp28_;
				while (TRUE) {
					GeeIterator* _tmp29_;
					MediaSource* media_source = NULL;
					GeeIterator* _tmp30_;
					gpointer _tmp31_;
					GeeArrayList* _tmp32_;
					MediaSource* _tmp33_;
					ThumbnailView* _tmp34_;
					ThumbnailView* _tmp35_;
					_tmp29_ = _media_source_it;
					if (!gee_iterator_next (_tmp29_)) {
						break;
					}
					_tmp30_ = _media_source_it;
					_tmp31_ = gee_iterator_get (_tmp30_);
					media_source = (MediaSource*) _tmp31_;
					_tmp32_ = media_thumbs;
					_tmp33_ = media_source;
					_tmp34_ = thumbnail_view_new ((ThumbnailSource*) _tmp33_);
					_tmp35_ = _tmp34_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp35_);
					_g_object_unref0 (_tmp35_);
					_g_object_unref0 (media_source);
				}
				_g_object_unref0 (_media_source_it);
			}
			_g_object_unref0 (event);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp36_ = master_event;
	_vala_assert (_tmp36_ != NULL, "master_event != null");
	_tmp37_ = media_thumbs;
	_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_assert (_tmp39_ > 0, "media_thumbs.size > 0");
	_tmp40_ = master_event;
	_tmp41_ = media_thumbs;
	_tmp42_ = move_photos_command_real_move_photos_command_new (_tmp40_, (GeeIterable*) _tmp41_, _ ("Merging"), _ ("Unmerging"), RESOURCES_MERGE_LABEL, "");
	_g_object_unref0 (((MovePhotosCommand*) self)->real_command);
	((MovePhotosCommand*) self)->real_command = _tmp42_;
	_g_object_unref0 (media_thumbs);
	_g_object_unref0 (master_event);
	return self;
}

MergeEventsCommand*
merge_events_command_new (GeeIterable* iter)
{
	return merge_events_command_construct (TYPE_MERGE_EVENTS_COMMAND, iter);
}

static void
merge_events_command_class_init (MergeEventsCommandClass * klass,
                                 gpointer klass_data)
{
	merge_events_command_parent_class = g_type_class_peek_parent (klass);
}

static void
merge_events_command_instance_init (MergeEventsCommand * self,
                                    gpointer klass)
{
}

static GType
merge_events_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MergeEventsCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) merge_events_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MergeEventsCommand), 0, (GInstanceInitFunc) merge_events_command_instance_init, NULL };
	GType merge_events_command_type_id;
	merge_events_command_type_id = g_type_register_static (TYPE_MOVE_PHOTOS_COMMAND, "MergeEventsCommand", &g_define_type_info, 0);
	return merge_events_command_type_id;
}

GType
merge_events_command_get_type (void)
{
	static volatile gsize merge_events_command_type_id__once = 0;
	if (g_once_init_enter (&merge_events_command_type_id__once)) {
		GType merge_events_command_type_id;
		merge_events_command_type_id = merge_events_command_get_type_once ();
		g_once_init_leave (&merge_events_command_type_id__once, merge_events_command_type_id);
	}
	return merge_events_command_type_id__once;
}

static inline gpointer
duplicate_multiple_photos_command_get_instance_private (DuplicateMultiplePhotosCommand* self)
{
	return G_STRUCT_MEMBER_P (self, DuplicateMultiplePhotosCommand_private_offset);
}

static void
_duplicate_multiple_photos_command_on_photo_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                        DataSource* source,
                                                                                        gpointer self)
{
	duplicate_multiple_photos_command_on_photo_destroyed ((DuplicateMultiplePhotosCommand*) self, source);
}

DuplicateMultiplePhotosCommand*
duplicate_multiple_photos_command_construct (GType object_type,
                                             GeeIterable* iter)
{
	DuplicateMultiplePhotosCommand * self = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (DuplicateMultiplePhotosCommand*) multiple_data_source_command_construct (object_type, iter, _ ("Duplicating photos"), _ ("Removing duplicated photos"), RESOURCES_DUPLICATE_PHOTO_LABEL, RESOURCES_DUPLICATE_PHOTO_TOOLTIP);
	_tmp0_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp0_, "item-destroyed", (GCallback) _duplicate_multiple_photos_command_on_photo_destroyed_source_collection_item_destroyed, self, 0);
	return self;
}

DuplicateMultiplePhotosCommand*
duplicate_multiple_photos_command_new (GeeIterable* iter)
{
	return duplicate_multiple_photos_command_construct (TYPE_DUPLICATE_MULTIPLE_PHOTOS_COMMAND, iter);
}

static void
duplicate_multiple_photos_command_on_photo_destroyed (DuplicateMultiplePhotosCommand* self,
                                                      DataSource* source)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->dupes;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_contains (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		CommandManager* _tmp5_;
		CommandManager* _tmp6_;
		_tmp5_ = command_get_command_manager ((Command*) self);
		_tmp6_ = _tmp5_;
		command_manager_reset (_tmp6_);
		_command_manager_unref0 (_tmp6_);
	}
}

static void
duplicate_multiple_photos_command_real_execute (Command* base)
{
	DuplicateMultiplePhotosCommand * self;
	GeeHashMap* _tmp0_;
	self = (DuplicateMultiplePhotosCommand*) base;
	_tmp0_ = self->priv->dupes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	self->priv->failed = 0;
	COMMAND_CLASS (duplicate_multiple_photos_command_parent_class)->execute ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
	if (self->priv->failed > 0) {
		gchar* error_string = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_strdup_printf (ngettext ("Unable to duplicate one photo due to a file error", "Unable to duplicate %d photos due to file errors", (gulong) self->priv->failed), self->priv->failed);
		error_string = _tmp1_;
		_tmp2_ = error_string;
		app_window_error_message (_tmp2_, NULL, NULL);
		_g_free0 (error_string);
	}
}

static void
duplicate_multiple_photos_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                          DataSource* source)
{
	DuplicateMultiplePhotosCommand * self;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (DuplicateMultiplePhotosCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	photo = _tmp0_;
	{
		LibraryPhoto* dupe = NULL;
		LibraryPhoto* _tmp1_;
		GeeHashMap* _tmp2_;
		_tmp1_ = library_photo_duplicate (photo, &_inner_error0_);
		dupe = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->dupes;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, photo, dupe);
		_g_object_unref0 (dupe);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = media_source_get_file ((MediaSource*) photo);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_critical ("Commands.vala:1167: Unable to duplicate file %s: %s", _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_tmp9_ = self->priv->failed;
		self->priv->failed = _tmp9_ + 1;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (photo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (photo);
}

static void
duplicate_multiple_photos_command_real_undo (Command* base)
{
	DuplicateMultiplePhotosCommand * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	GeeHashMap* _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	self = (DuplicateMultiplePhotosCommand*) base;
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _duplicate_multiple_photos_command_on_photo_destroyed_source_collection_item_destroyed, self);
	COMMAND_CLASS (duplicate_multiple_photos_command_parent_class)->undo ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
	_tmp2_ = self->priv->dupes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp2_);
	self->priv->failed = 0;
	_tmp3_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp3_, "item-destroyed", (GCallback) _duplicate_multiple_photos_command_on_photo_destroyed_source_collection_item_destroyed, self, 0);
}

static void
duplicate_multiple_photos_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                       DataSource* source)
{
	DuplicateMultiplePhotosCommand * self;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	Marker* marker = NULL;
	LibraryPhotoSourceCollection* _tmp1_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	LibraryPhoto* _tmp4_;
	Marker* _tmp5_;
	Marker* _tmp6_;
	LibraryPhotoSourceCollection* _tmp7_;
	self = (DuplicateMultiplePhotosCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	photo = _tmp0_;
	_tmp1_ = library_photo_global;
	_tmp2_ = self->priv->dupes;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, photo);
	_tmp4_ = (LibraryPhoto*) _tmp3_;
	_tmp5_ = data_collection_mark ((DataCollection*) _tmp1_, (DataObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	marker = _tmp6_;
	_tmp7_ = library_photo_global;
	source_collection_destroy_marked ((SourceCollection*) _tmp7_, marker, TRUE, NULL, NULL, NULL);
	_g_object_unref0 (marker);
	_g_object_unref0 (photo);
}

static void
duplicate_multiple_photos_command_class_init (DuplicateMultiplePhotosCommandClass * klass,
                                              gpointer klass_data)
{
	duplicate_multiple_photos_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DuplicateMultiplePhotosCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) duplicate_multiple_photos_command_real_execute;
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) duplicate_multiple_photos_command_real_execute_on_source;
	((CommandClass *) klass)->undo = (void (*) (Command*)) duplicate_multiple_photos_command_real_undo;
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) duplicate_multiple_photos_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = duplicate_multiple_photos_command_finalize;
}

static void
duplicate_multiple_photos_command_instance_init (DuplicateMultiplePhotosCommand * self,
                                                 gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = duplicate_multiple_photos_command_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->dupes = _tmp0_;
	self->priv->failed = 0;
}

static void
duplicate_multiple_photos_command_finalize (GObject * obj)
{
	DuplicateMultiplePhotosCommand * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICATE_MULTIPLE_PHOTOS_COMMAND, DuplicateMultiplePhotosCommand);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _duplicate_multiple_photos_command_on_photo_destroyed_source_collection_item_destroyed, self);
	_g_object_unref0 (self->priv->dupes);
	G_OBJECT_CLASS (duplicate_multiple_photos_command_parent_class)->finalize (obj);
}

static GType
duplicate_multiple_photos_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DuplicateMultiplePhotosCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicate_multiple_photos_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicateMultiplePhotosCommand), 0, (GInstanceInitFunc) duplicate_multiple_photos_command_instance_init, NULL };
	GType duplicate_multiple_photos_command_type_id;
	duplicate_multiple_photos_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_COMMAND, "DuplicateMultiplePhotosCommand", &g_define_type_info, 0);
	DuplicateMultiplePhotosCommand_private_offset = g_type_add_instance_private (duplicate_multiple_photos_command_type_id, sizeof (DuplicateMultiplePhotosCommandPrivate));
	return duplicate_multiple_photos_command_type_id;
}

GType
duplicate_multiple_photos_command_get_type (void)
{
	static volatile gsize duplicate_multiple_photos_command_type_id__once = 0;
	if (g_once_init_enter (&duplicate_multiple_photos_command_type_id__once)) {
		GType duplicate_multiple_photos_command_type_id;
		duplicate_multiple_photos_command_type_id = duplicate_multiple_photos_command_get_type_once ();
		g_once_init_leave (&duplicate_multiple_photos_command_type_id__once, duplicate_multiple_photos_command_type_id);
	}
	return duplicate_multiple_photos_command_type_id__once;
}

static inline gpointer
set_raw_developer_command_get_instance_private (SetRawDeveloperCommand* self)
{
	return G_STRUCT_MEMBER_P (self, SetRawDeveloperCommand_private_offset);
}

SetRawDeveloperCommand*
set_raw_developer_command_construct (GType object_type,
                                     GeeIterable* iter,
                                     RawDeveloper developer)
{
	SetRawDeveloperCommand * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (SetRawDeveloperCommand*) multiple_data_source_command_construct (object_type, iter, _ ("Setting RAW developer"), _ ("Restoring previous RAW developer"), _ ("Set Developer"), "");
	self->priv->new_developer = developer;
	set_raw_developer_command_save_source_states (self, iter);
	return self;
}

SetRawDeveloperCommand*
set_raw_developer_command_new (GeeIterable* iter,
                               RawDeveloper developer)
{
	return set_raw_developer_command_construct (TYPE_SET_RAW_DEVELOPER_COMMAND, iter, developer);
}

static void
set_raw_developer_command_save_source_states (SetRawDeveloperCommand* self,
                                              GeeIterable* iter)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_RAW_DEVELOPER, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->last_developer_map);
	self->priv->last_developer_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_PHOTO_TRANSFORMATION_STATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->last_transformation_map);
	self->priv->last_transformation_map = _tmp1_;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (iter);
		_view_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataView* view = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			Photo* photo = NULL;
			DataView* _tmp6_;
			DataSource* _tmp7_;
			DataSource* _tmp8_;
			Photo* _tmp9_;
			Photo* _tmp10_;
			_tmp3_ = _view_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _view_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			view = (DataView*) _tmp5_;
			_tmp6_ = view;
			_tmp7_ = data_view_get_source (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _g_object_ref0 (IS_PHOTO (_tmp8_) ? ((Photo*) _tmp8_) : NULL);
			photo = _tmp9_;
			_tmp10_ = photo;
			if (set_raw_developer_command_is_raw_photo (self, _tmp10_)) {
				GeeHashMap* _tmp11_;
				Photo* _tmp12_;
				Photo* _tmp13_;
				GeeHashMap* _tmp14_;
				Photo* _tmp15_;
				Photo* _tmp16_;
				PhotoTransformationState* _tmp17_;
				PhotoTransformationState* _tmp18_;
				_tmp11_ = self->priv->last_developer_map;
				_tmp12_ = photo;
				_tmp13_ = photo;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp12_, (gpointer) ((gintptr) photo_get_raw_developer (_tmp13_)));
				_tmp14_ = self->priv->last_transformation_map;
				_tmp15_ = photo;
				_tmp16_ = photo;
				_tmp17_ = photo_save_transformation_state (_tmp16_);
				_tmp18_ = _tmp17_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, _tmp18_);
				_g_object_unref0 (_tmp18_);
			}
			_g_object_unref0 (photo);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
}

static void
set_raw_developer_command_real_execute (Command* base)
{
	SetRawDeveloperCommand * self;
	self = (SetRawDeveloperCommand*) base;
	COMMAND_CLASS (set_raw_developer_command_parent_class)->execute ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
}

static void
set_raw_developer_command_real_undo (Command* base)
{
	SetRawDeveloperCommand * self;
	self = (SetRawDeveloperCommand*) base;
	COMMAND_CLASS (set_raw_developer_command_parent_class)->undo ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
}

static void
set_raw_developer_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                  DataSource* source)
{
	SetRawDeveloperCommand * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
	self = (SetRawDeveloperCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (set_raw_developer_command_is_raw_photo (self, _tmp1_)) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->new_developer == RAW_DEVELOPER_CAMERA) {
			Photo* _tmp3_;
			_tmp3_ = photo;
			_tmp2_ = !photo_is_raw_developer_available (_tmp3_, RAW_DEVELOPER_CAMERA);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			Photo* _tmp4_;
			_tmp4_ = photo;
			photo_set_raw_developer (_tmp4_, RAW_DEVELOPER_EMBEDDED);
		} else {
			Photo* _tmp5_;
			_tmp5_ = photo;
			photo_set_raw_developer (_tmp5_, self->priv->new_developer);
		}
	}
	_g_object_unref0 (photo);
}

static void
set_raw_developer_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                               DataSource* source)
{
	SetRawDeveloperCommand * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
	self = (SetRawDeveloperCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (set_raw_developer_command_is_raw_photo (self, _tmp1_)) {
		Photo* _tmp2_;
		GeeHashMap* _tmp3_;
		Photo* _tmp4_;
		gpointer _tmp5_;
		Photo* _tmp6_;
		GeeHashMap* _tmp7_;
		Photo* _tmp8_;
		gpointer _tmp9_;
		PhotoTransformationState* _tmp10_;
		_tmp2_ = photo;
		_tmp3_ = self->priv->last_developer_map;
		_tmp4_ = photo;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		photo_set_raw_developer (_tmp2_, (RawDeveloper) ((gintptr) _tmp5_));
		_tmp6_ = photo;
		_tmp7_ = self->priv->last_transformation_map;
		_tmp8_ = photo;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
		_tmp10_ = (PhotoTransformationState*) _tmp9_;
		photo_load_transformation_state (_tmp6_, _tmp10_);
		_g_object_unref0 (_tmp10_);
	}
	_g_object_unref0 (photo);
}

static gboolean
set_raw_developer_command_is_raw_photo (SetRawDeveloperCommand* self,
                                        Photo* photo)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (photo != NULL) {
		_tmp0_ = photo_get_master_file_format (photo) == PHOTO_FILE_FORMAT_RAW;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
set_raw_developer_command_class_init (SetRawDeveloperCommandClass * klass,
                                      gpointer klass_data)
{
	set_raw_developer_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SetRawDeveloperCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) set_raw_developer_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) set_raw_developer_command_real_undo;
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) set_raw_developer_command_real_execute_on_source;
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) set_raw_developer_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = set_raw_developer_command_finalize;
}

static void
set_raw_developer_command_instance_init (SetRawDeveloperCommand * self,
                                         gpointer klass)
{
	self->priv = set_raw_developer_command_get_instance_private (self);
}

static void
set_raw_developer_command_finalize (GObject * obj)
{
	SetRawDeveloperCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SET_RAW_DEVELOPER_COMMAND, SetRawDeveloperCommand);
	_g_object_unref0 (self->priv->last_developer_map);
	_g_object_unref0 (self->priv->last_transformation_map);
	G_OBJECT_CLASS (set_raw_developer_command_parent_class)->finalize (obj);
}

static GType
set_raw_developer_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SetRawDeveloperCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) set_raw_developer_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetRawDeveloperCommand), 0, (GInstanceInitFunc) set_raw_developer_command_instance_init, NULL };
	GType set_raw_developer_command_type_id;
	set_raw_developer_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_COMMAND, "SetRawDeveloperCommand", &g_define_type_info, 0);
	SetRawDeveloperCommand_private_offset = g_type_add_instance_private (set_raw_developer_command_type_id, sizeof (SetRawDeveloperCommandPrivate));
	return set_raw_developer_command_type_id;
}

GType
set_raw_developer_command_get_type (void)
{
	static volatile gsize set_raw_developer_command_type_id__once = 0;
	if (g_once_init_enter (&set_raw_developer_command_type_id__once)) {
		GType set_raw_developer_command_type_id;
		set_raw_developer_command_type_id = set_raw_developer_command_get_type_once ();
		g_once_init_leave (&set_raw_developer_command_type_id__once, set_raw_developer_command_type_id);
	}
	return set_raw_developer_command_type_id__once;
}

static inline gpointer
adjust_date_time_photo_command_get_instance_private (AdjustDateTimePhotoCommand* self)
{
	return G_STRUCT_MEMBER_P (self, AdjustDateTimePhotoCommand_private_offset);
}

AdjustDateTimePhotoCommand*
adjust_date_time_photo_command_construct (GType object_type,
                                          Dateable* dateable,
                                          gint64 time_shift,
                                          gboolean modify_original)
{
	AdjustDateTimePhotoCommand * self = NULL;
	Dateable* _tmp0_;
	g_return_val_if_fail (dateable != NULL, NULL);
	self = (AdjustDateTimePhotoCommand*) single_data_source_command_construct (object_type, (DataSource*) dateable, RESOURCES_ADJUST_DATE_TIME_LABEL, "");
	_tmp0_ = _g_object_ref0 (dateable);
	_g_object_unref0 (self->priv->dateable);
	self->priv->dateable = _tmp0_;
	self->priv->time_shift = time_shift;
	self->priv->modify_original = modify_original;
	return self;
}

AdjustDateTimePhotoCommand*
adjust_date_time_photo_command_new (Dateable* dateable,
                                    gint64 time_shift,
                                    gboolean modify_original)
{
	return adjust_date_time_photo_command_construct (TYPE_ADJUST_DATE_TIME_PHOTO_COMMAND, dateable, time_shift, modify_original);
}

static void
adjust_date_time_photo_command_real_execute (Command* base)
{
	AdjustDateTimePhotoCommand * self;
	Dateable* _tmp0_;
	Dateable* _tmp1_;
	Dateable* _tmp2_;
	Event* _tmp3_;
	ViewCollection* all_events = NULL;
	ViewCollection* _tmp4_;
	Dateable* _tmp20_;
	ViewCollection* _tmp21_;
	self = (AdjustDateTimePhotoCommand*) base;
	_tmp0_ = self->priv->dateable;
	_tmp1_ = self->priv->dateable;
	adjust_date_time_photo_command_set_time (self, _tmp0_, dateable_get_exposure_time (_tmp1_) + self->priv->time_shift);
	_tmp2_ = self->priv->dateable;
	_tmp3_ = media_source_get_event ((MediaSource*) _tmp2_);
	_g_object_unref0 (self->priv->prev_event);
	self->priv->prev_event = _tmp3_;
	_tmp4_ = view_collection_new ("tmp");
	all_events = _tmp4_;
	{
		GeeIterator* _dobj_it = NULL;
		EventSourceCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp5_ = event_global;
		_tmp6_ = data_collection_get_all ((DataCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_dobj_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataObject* dobj = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			Event* event = NULL;
			DataObject* _tmp13_;
			Event* _tmp14_;
			Event* _tmp15_;
			_tmp10_ = _dobj_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _dobj_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			dobj = (DataObject*) _tmp12_;
			_tmp13_ = dobj;
			_tmp14_ = _g_object_ref0 (IS_EVENT (_tmp13_) ? ((Event*) _tmp13_) : NULL);
			event = _tmp14_;
			_tmp15_ = event;
			if (_tmp15_ != NULL) {
				ViewCollection* _tmp16_;
				Event* _tmp17_;
				EventView* _tmp18_;
				EventView* _tmp19_;
				_tmp16_ = all_events;
				_tmp17_ = event;
				_tmp18_ = event_view_new ((EventSource*) _tmp17_);
				_tmp19_ = _tmp18_;
				data_collection_add ((DataCollection*) _tmp16_, (DataObject*) _tmp19_);
				_g_object_unref0 (_tmp19_);
			}
			_g_object_unref0 (event);
			_g_object_unref0 (dobj);
		}
		_g_object_unref0 (_dobj_it);
	}
	_tmp20_ = self->priv->dateable;
	_tmp21_ = all_events;
	event_generate_single_event ((MediaSource*) _tmp20_, _tmp21_, NULL);
	_data_collection_unref0 (all_events);
}

static void
adjust_date_time_photo_command_real_undo (Command* base)
{
	AdjustDateTimePhotoCommand * self;
	Dateable* _tmp0_;
	Dateable* _tmp1_;
	Dateable* _tmp2_;
	Event* _tmp3_;
	self = (AdjustDateTimePhotoCommand*) base;
	_tmp0_ = self->priv->dateable;
	_tmp1_ = self->priv->dateable;
	adjust_date_time_photo_command_set_time (self, _tmp0_, dateable_get_exposure_time (_tmp1_) - self->priv->time_shift);
	_tmp2_ = self->priv->dateable;
	_tmp3_ = self->priv->prev_event;
	media_source_set_event ((MediaSource*) _tmp2_, _tmp3_);
}

static void
adjust_date_time_photo_command_set_time (AdjustDateTimePhotoCommand* self,
                                         Dateable* dateable,
                                         gint64 exposure_time)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dateable != NULL);
	if (self->priv->modify_original) {
		_tmp0_ = IS_PHOTO (dateable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			photo_set_exposure_time_persistent (G_TYPE_CHECK_INSTANCE_CAST (dateable, TYPE_PHOTO, Photo), exposure_time, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			app_window_error_message (_ ("Original photo could not be adjusted."), NULL, NULL);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		dateable_set_exposure_time (dateable, exposure_time);
	}
}

static void
adjust_date_time_photo_command_class_init (AdjustDateTimePhotoCommandClass * klass,
                                           gpointer klass_data)
{
	adjust_date_time_photo_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdjustDateTimePhotoCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) adjust_date_time_photo_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) adjust_date_time_photo_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = adjust_date_time_photo_command_finalize;
}

static void
adjust_date_time_photo_command_instance_init (AdjustDateTimePhotoCommand * self,
                                              gpointer klass)
{
	self->priv = adjust_date_time_photo_command_get_instance_private (self);
}

static void
adjust_date_time_photo_command_finalize (GObject * obj)
{
	AdjustDateTimePhotoCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_DATE_TIME_PHOTO_COMMAND, AdjustDateTimePhotoCommand);
	_g_object_unref0 (self->priv->dateable);
	_g_object_unref0 (self->priv->prev_event);
	G_OBJECT_CLASS (adjust_date_time_photo_command_parent_class)->finalize (obj);
}

static GType
adjust_date_time_photo_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdjustDateTimePhotoCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adjust_date_time_photo_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdjustDateTimePhotoCommand), 0, (GInstanceInitFunc) adjust_date_time_photo_command_instance_init, NULL };
	GType adjust_date_time_photo_command_type_id;
	adjust_date_time_photo_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "AdjustDateTimePhotoCommand", &g_define_type_info, 0);
	AdjustDateTimePhotoCommand_private_offset = g_type_add_instance_private (adjust_date_time_photo_command_type_id, sizeof (AdjustDateTimePhotoCommandPrivate));
	return adjust_date_time_photo_command_type_id;
}

GType
adjust_date_time_photo_command_get_type (void)
{
	static volatile gsize adjust_date_time_photo_command_type_id__once = 0;
	if (g_once_init_enter (&adjust_date_time_photo_command_type_id__once)) {
		GType adjust_date_time_photo_command_type_id;
		adjust_date_time_photo_command_type_id = adjust_date_time_photo_command_get_type_once ();
		g_once_init_leave (&adjust_date_time_photo_command_type_id__once, adjust_date_time_photo_command_type_id);
	}
	return adjust_date_time_photo_command_type_id__once;
}

static inline gpointer
adjust_date_time_photos_command_get_instance_private (AdjustDateTimePhotosCommand* self)
{
	return G_STRUCT_MEMBER_P (self, AdjustDateTimePhotosCommand_private_offset);
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

AdjustDateTimePhotosCommand*
adjust_date_time_photos_command_construct (GType object_type,
                                           GeeIterable* iter,
                                           gint64 time_shift,
                                           gboolean keep_relativity,
                                           gboolean modify_originals)
{
	AdjustDateTimePhotosCommand * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp20_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (AdjustDateTimePhotosCommand*) multiple_data_source_command_construct (object_type, iter, _ ("Adjusting Date and Time"), _ ("Undoing Date and Time Adjustment"), RESOURCES_ADJUST_DATE_TIME_LABEL, "");
	self->priv->time_shift = time_shift;
	self->priv->keep_relativity = keep_relativity;
	self->priv->modify_originals = modify_originals;
	_tmp0_ = gee_hash_map_new (TYPE_DATEABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_EVENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->prev_events);
	self->priv->prev_events = (GeeMap*) _tmp0_;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (iter);
		_view_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataView* view = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeMap* _tmp5_;
			DataView* _tmp6_;
			DataSource* _tmp7_;
			DataSource* _tmp8_;
			DataView* _tmp9_;
			DataSource* _tmp10_;
			DataSource* _tmp11_;
			Event* _tmp12_;
			Event* _tmp13_;
			gint64* _tmp14_;
			_tmp2_ = _view_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _view_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			view = (DataView*) _tmp4_;
			_tmp5_ = self->priv->prev_events;
			_tmp6_ = view;
			_tmp7_ = data_view_get_source (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = view;
			_tmp10_ = data_view_get_source (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = media_source_get_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp13_ = _tmp12_;
			gee_map_set (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATEABLE, Dateable), _tmp13_);
			_g_object_unref0 (_tmp13_);
			_tmp14_ = self->priv->new_time;
			if (_tmp14_ == NULL) {
				DataView* _tmp15_;
				DataSource* _tmp16_;
				DataSource* _tmp17_;
				gint64 _tmp18_;
				gint64* _tmp19_;
				_tmp15_ = view;
				_tmp16_ = data_view_get_source (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = dateable_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATEABLE, Dateable)) + time_shift;
				_tmp19_ = __int64_dup0 (&_tmp18_);
				_g_free0 (self->priv->new_time);
				self->priv->new_time = _tmp19_;
				_g_object_unref0 (view);
				break;
			}
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp20_ = gee_hash_map_new (TYPE_DATEABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->old_times);
	self->priv->old_times = _tmp20_;
	return self;
}

AdjustDateTimePhotosCommand*
adjust_date_time_photos_command_new (GeeIterable* iter,
                                     gint64 time_shift,
                                     gboolean keep_relativity,
                                     gboolean modify_originals)
{
	return adjust_date_time_photos_command_construct (TYPE_ADJUST_DATE_TIME_PHOTOS_COMMAND, iter, time_shift, keep_relativity, modify_originals);
}

static void
adjust_date_time_photos_command_real_execute (Command* base)
{
	AdjustDateTimePhotosCommand * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ViewCollection* all_events = NULL;
	ViewCollection* _tmp8_;
	self = (AdjustDateTimePhotosCommand*) base;
	_tmp0_ = gee_array_list_new (TYPE_DATEABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->error_list);
	self->priv->error_list = _tmp0_;
	COMMAND_CLASS (adjust_date_time_photos_command_parent_class)->execute ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
	_tmp1_ = self->priv->error_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->error_list;
		_tmp5_ = self->priv->error_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		multiple_object_error_dialog (_tmp4_, ngettext ("One original photo could not be adjusted.", "The following original photos could not be adjusted.", (gulong) _tmp7_), _ ("Time Adjustment Error"));
	}
	_tmp8_ = view_collection_new ("tmp");
	all_events = _tmp8_;
	{
		GeeIterator* _d_it = NULL;
		GeeMap* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeSet* _tmp12_;
		GeeIterator* _tmp13_;
		GeeIterator* _tmp14_;
		_tmp9_ = self->priv->prev_events;
		_tmp10_ = gee_map_get_keys (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_d_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			Dateable* d = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			Dateable* _tmp33_;
			ViewCollection* _tmp34_;
			_tmp15_ = _d_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _d_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			d = (Dateable*) _tmp17_;
			{
				GeeIterator* _dobj_it = NULL;
				EventSourceCollection* _tmp18_;
				GeeCollection* _tmp19_;
				GeeCollection* _tmp20_;
				GeeIterator* _tmp21_;
				GeeIterator* _tmp22_;
				_tmp18_ = event_global;
				_tmp19_ = data_collection_get_all ((DataCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
				_tmp22_ = _tmp21_;
				_g_object_unref0 (_tmp20_);
				_dobj_it = _tmp22_;
				while (TRUE) {
					GeeIterator* _tmp23_;
					DataObject* dobj = NULL;
					GeeIterator* _tmp24_;
					gpointer _tmp25_;
					Event* event = NULL;
					DataObject* _tmp26_;
					Event* _tmp27_;
					Event* _tmp28_;
					_tmp23_ = _dobj_it;
					if (!gee_iterator_next (_tmp23_)) {
						break;
					}
					_tmp24_ = _dobj_it;
					_tmp25_ = gee_iterator_get (_tmp24_);
					dobj = (DataObject*) _tmp25_;
					_tmp26_ = dobj;
					_tmp27_ = _g_object_ref0 (IS_EVENT (_tmp26_) ? ((Event*) _tmp26_) : NULL);
					event = _tmp27_;
					_tmp28_ = event;
					if (_tmp28_ != NULL) {
						ViewCollection* _tmp29_;
						Event* _tmp30_;
						EventView* _tmp31_;
						EventView* _tmp32_;
						_tmp29_ = all_events;
						_tmp30_ = event;
						_tmp31_ = event_view_new ((EventSource*) _tmp30_);
						_tmp32_ = _tmp31_;
						data_collection_add ((DataCollection*) _tmp29_, (DataObject*) _tmp32_);
						_g_object_unref0 (_tmp32_);
					}
					_g_object_unref0 (event);
					_g_object_unref0 (dobj);
				}
				_g_object_unref0 (_dobj_it);
			}
			_tmp33_ = d;
			_tmp34_ = all_events;
			event_generate_single_event ((MediaSource*) _tmp33_, _tmp34_, NULL);
			_g_object_unref0 (d);
		}
		_g_object_unref0 (_d_it);
	}
	_data_collection_unref0 (all_events);
}

static void
adjust_date_time_photos_command_real_undo (Command* base)
{
	AdjustDateTimePhotosCommand * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (AdjustDateTimePhotosCommand*) base;
	_tmp0_ = gee_array_list_new (TYPE_DATEABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->error_list);
	self->priv->error_list = _tmp0_;
	COMMAND_CLASS (adjust_date_time_photos_command_parent_class)->undo ((Command*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MULTIPLE_DATA_SOURCE_COMMAND, MultipleDataSourceCommand));
	_tmp1_ = self->priv->error_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->error_list;
		_tmp5_ = self->priv->error_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		multiple_object_error_dialog (_tmp4_, ngettext ("Time adjustments could not be undone on the following photo file.", "Time adjustments could not be undone on the following photo files.", (gulong) _tmp7_), _ ("Time Adjustment Error"));
	}
}

static void
adjust_date_time_photos_command_set_time (AdjustDateTimePhotosCommand* self,
                                          Dateable* dateable,
                                          gint64 exposure_time)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dateable != NULL);
	if (self->priv->modify_originals) {
		_tmp0_ = IS_PHOTO (dateable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			photo_set_exposure_time_persistent (G_TYPE_CHECK_INSTANCE_CAST (dateable, TYPE_PHOTO, Photo), exposure_time, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GeeArrayList* _tmp1_;
			g_clear_error (&_inner_error0_);
			_tmp1_ = self->priv->error_list;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, dateable);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		dateable_set_exposure_time (dateable, exposure_time);
	}
}

static void
adjust_date_time_photos_command_real_execute_on_source (MultipleDataSourceCommand* base,
                                                        DataSource* source)
{
	AdjustDateTimePhotosCommand * self;
	Dateable* dateable = NULL;
	Dateable* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ViewCollection* all_events = NULL;
	ViewCollection* _tmp11_;
	Dateable* _tmp27_;
	ViewCollection* _tmp28_;
	self = (AdjustDateTimePhotosCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATEABLE, Dateable));
	dateable = _tmp0_;
	if (self->priv->keep_relativity) {
		Dateable* _tmp2_;
		_tmp2_ = dateable;
		_tmp1_ = dateable_get_exposure_time (_tmp2_) != ((gint64) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Dateable* _tmp3_;
		Dateable* _tmp4_;
		_tmp3_ = dateable;
		_tmp4_ = dateable;
		adjust_date_time_photos_command_set_time (self, _tmp3_, dateable_get_exposure_time (_tmp4_) + self->priv->time_shift);
	} else {
		GeeHashMap* _tmp5_;
		Dateable* _tmp6_;
		Dateable* _tmp7_;
		gint64 _tmp8_;
		Dateable* _tmp9_;
		gint64* _tmp10_;
		_tmp5_ = self->priv->old_times;
		_tmp6_ = dateable;
		_tmp7_ = dateable;
		_tmp8_ = dateable_get_exposure_time (_tmp7_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, &_tmp8_);
		_tmp9_ = dateable;
		_tmp10_ = self->priv->new_time;
		adjust_date_time_photos_command_set_time (self, _tmp9_, *_tmp10_);
	}
	_tmp11_ = view_collection_new ("tmp");
	all_events = _tmp11_;
	{
		GeeIterator* _dobj_it = NULL;
		EventSourceCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeIterator* _tmp15_;
		GeeIterator* _tmp16_;
		_tmp12_ = event_global;
		_tmp13_ = data_collection_get_all ((DataCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_dobj_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			DataObject* dobj = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			Event* event = NULL;
			DataObject* _tmp20_;
			Event* _tmp21_;
			Event* _tmp22_;
			_tmp17_ = _dobj_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _dobj_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			dobj = (DataObject*) _tmp19_;
			_tmp20_ = dobj;
			_tmp21_ = _g_object_ref0 (IS_EVENT (_tmp20_) ? ((Event*) _tmp20_) : NULL);
			event = _tmp21_;
			_tmp22_ = event;
			if (_tmp22_ != NULL) {
				ViewCollection* _tmp23_;
				Event* _tmp24_;
				EventView* _tmp25_;
				EventView* _tmp26_;
				_tmp23_ = all_events;
				_tmp24_ = event;
				_tmp25_ = event_view_new ((EventSource*) _tmp24_);
				_tmp26_ = _tmp25_;
				data_collection_add ((DataCollection*) _tmp23_, (DataObject*) _tmp26_);
				_g_object_unref0 (_tmp26_);
			}
			_g_object_unref0 (event);
			_g_object_unref0 (dobj);
		}
		_g_object_unref0 (_dobj_it);
	}
	_tmp27_ = dateable;
	_tmp28_ = all_events;
	event_generate_single_event ((MediaSource*) _tmp27_, _tmp28_, NULL);
	_data_collection_unref0 (all_events);
	_g_object_unref0 (dateable);
}

static void
adjust_date_time_photos_command_real_undo_on_source (MultipleDataSourceCommand* base,
                                                     DataSource* source)
{
	AdjustDateTimePhotosCommand * self;
	Dateable* photo = NULL;
	Dateable* _tmp0_;
	GeeHashMap* _tmp1_;
	Dateable* _tmp2_;
	GeeMap* _tmp12_;
	gpointer _tmp13_;
	Event* _tmp14_;
	self = (AdjustDateTimePhotosCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATEABLE, Dateable));
	photo = _tmp0_;
	_tmp1_ = self->priv->old_times;
	_tmp2_ = photo;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_)) {
		Dateable* _tmp3_;
		GeeHashMap* _tmp4_;
		Dateable* _tmp5_;
		gpointer _tmp6_;
		gint64* _tmp7_;
		GeeHashMap* _tmp8_;
		Dateable* _tmp9_;
		_tmp3_ = photo;
		_tmp4_ = self->priv->old_times;
		_tmp5_ = photo;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (gint64*) _tmp6_;
		adjust_date_time_photos_command_set_time (self, _tmp3_, *_tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = self->priv->old_times;
		_tmp9_ = photo;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
	} else {
		Dateable* _tmp10_;
		Dateable* _tmp11_;
		_tmp10_ = photo;
		_tmp11_ = photo;
		adjust_date_time_photos_command_set_time (self, _tmp10_, dateable_get_exposure_time (_tmp11_) - self->priv->time_shift);
	}
	_tmp12_ = self->priv->prev_events;
	_tmp13_ = gee_map_get (_tmp12_, IS_DATEABLE (source) ? ((Dateable*) source) : NULL);
	_tmp14_ = (Event*) _tmp13_;
	media_source_set_event (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource), _tmp14_);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (photo);
}

static void
adjust_date_time_photos_command_class_init (AdjustDateTimePhotosCommandClass * klass,
                                            gpointer klass_data)
{
	adjust_date_time_photos_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdjustDateTimePhotosCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) adjust_date_time_photos_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) adjust_date_time_photos_command_real_undo;
	((MultipleDataSourceCommandClass *) klass)->execute_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) adjust_date_time_photos_command_real_execute_on_source;
	((MultipleDataSourceCommandClass *) klass)->undo_on_source = (void (*) (MultipleDataSourceCommand*, DataSource*)) adjust_date_time_photos_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = adjust_date_time_photos_command_finalize;
}

static void
adjust_date_time_photos_command_instance_init (AdjustDateTimePhotosCommand * self,
                                               gpointer klass)
{
	self->priv = adjust_date_time_photos_command_get_instance_private (self);
	self->priv->new_time = NULL;
}

static void
adjust_date_time_photos_command_finalize (GObject * obj)
{
	AdjustDateTimePhotosCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADJUST_DATE_TIME_PHOTOS_COMMAND, AdjustDateTimePhotosCommand);
	_g_object_unref0 (self->priv->prev_events);
	_g_free0 (self->priv->new_time);
	_g_object_unref0 (self->priv->old_times);
	_g_object_unref0 (self->priv->error_list);
	G_OBJECT_CLASS (adjust_date_time_photos_command_parent_class)->finalize (obj);
}

static GType
adjust_date_time_photos_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdjustDateTimePhotosCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adjust_date_time_photos_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdjustDateTimePhotosCommand), 0, (GInstanceInitFunc) adjust_date_time_photos_command_instance_init, NULL };
	GType adjust_date_time_photos_command_type_id;
	adjust_date_time_photos_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_COMMAND, "AdjustDateTimePhotosCommand", &g_define_type_info, 0);
	AdjustDateTimePhotosCommand_private_offset = g_type_add_instance_private (adjust_date_time_photos_command_type_id, sizeof (AdjustDateTimePhotosCommandPrivate));
	return adjust_date_time_photos_command_type_id;
}

GType
adjust_date_time_photos_command_get_type (void)
{
	static volatile gsize adjust_date_time_photos_command_type_id__once = 0;
	if (g_once_init_enter (&adjust_date_time_photos_command_type_id__once)) {
		GType adjust_date_time_photos_command_type_id;
		adjust_date_time_photos_command_type_id = adjust_date_time_photos_command_get_type_once ();
		g_once_init_leave (&adjust_date_time_photos_command_type_id__once, adjust_date_time_photos_command_type_id);
	}
	return adjust_date_time_photos_command_type_id__once;
}

static inline gpointer
add_tags_command_get_instance_private (AddTagsCommand* self)
{
	return G_STRUCT_MEMBER_P (self, AddTagsCommand_private_offset);
}

static void
_add_tags_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                       gpointer self)
{
	add_tags_command_on_proxy_broken ((AddTagsCommand*) self);
}

static void
_add_tags_command_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                        DataSource* source,
                                                                        gpointer self)
{
	add_tags_command_on_source_destroyed ((AddTagsCommand*) self, source);
}

AddTagsCommand*
add_tags_command_construct (GType object_type,
                            gchar** paths,
                            gint paths_length1,
                            GeeCollection* sources)
{
	AddTagsCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	LibraryPhotoSourceCollection* _tmp35_;
	VideoSourceCollection* _tmp36_;
	g_return_val_if_fail (sources != NULL, NULL);
	_tmp0_ = resources_add_tags_label (paths, (gint) paths_length1);
	_tmp1_ = _tmp0_;
	self = (AddTagsCommand*) page_command_construct (object_type, _tmp1_, "");
	_g_free0 (_tmp1_);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = paths;
		path_collection_length1 = paths_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp2_;
			gchar* path = NULL;
			_tmp2_ = g_strdup (path_collection[path_it]);
			path = _tmp2_;
			{
				GeeList* paths_to_create = NULL;
				const gchar* _tmp3_;
				GeeList* _tmp4_;
				GeeList* _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = path;
				_tmp4_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp3_);
				paths_to_create = _tmp4_;
				_tmp5_ = paths_to_create;
				_tmp6_ = path;
				gee_collection_add ((GeeCollection*) _tmp5_, _tmp6_);
				{
					GeeList* _create_path_list = NULL;
					GeeList* _tmp7_;
					gint _create_path_size = 0;
					GeeList* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gint _create_path_index = 0;
					_tmp7_ = paths_to_create;
					_create_path_list = _tmp7_;
					_tmp8_ = _create_path_list;
					_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
					_tmp10_ = _tmp9_;
					_create_path_size = _tmp10_;
					_create_path_index = -1;
					while (TRUE) {
						gint _tmp11_;
						gint _tmp12_;
						gchar* create_path = NULL;
						GeeList* _tmp13_;
						gpointer _tmp14_;
						Tag* tag = NULL;
						const gchar* _tmp15_;
						Tag* _tmp16_;
						SourceProxy* tag_proxy = NULL;
						Tag* _tmp17_;
						SourceProxy* _tmp18_;
						GeeArrayList* add_sources = NULL;
						GeeArrayList* _tmp19_;
						GeeArrayList* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						_create_path_index = _create_path_index + 1;
						_tmp11_ = _create_path_index;
						_tmp12_ = _create_path_size;
						if (!(_tmp11_ < _tmp12_)) {
							break;
						}
						_tmp13_ = _create_path_list;
						_tmp14_ = gee_list_get (_tmp13_, _create_path_index);
						create_path = (gchar*) _tmp14_;
						_tmp15_ = create_path;
						_tmp16_ = tag_for_path (_tmp15_);
						tag = _tmp16_;
						_tmp17_ = tag;
						_tmp18_ = proxyable_get_proxy ((Proxyable*) _tmp17_);
						tag_proxy = _tmp18_;
						_tmp19_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						add_sources = _tmp19_;
						{
							GeeIterator* _source_it = NULL;
							GeeIterator* _tmp20_;
							_tmp20_ = gee_iterable_iterator ((GeeIterable*) sources);
							_source_it = _tmp20_;
							while (TRUE) {
								GeeIterator* _tmp21_;
								MediaSource* source = NULL;
								GeeIterator* _tmp22_;
								gpointer _tmp23_;
								Tag* _tmp24_;
								MediaSource* _tmp25_;
								_tmp21_ = _source_it;
								if (!gee_iterator_next (_tmp21_)) {
									break;
								}
								_tmp22_ = _source_it;
								_tmp23_ = gee_iterator_get (_tmp22_);
								source = (MediaSource*) _tmp23_;
								_tmp24_ = tag;
								_tmp25_ = source;
								if (!tag_contains (_tmp24_, _tmp25_)) {
									GeeArrayList* _tmp26_;
									MediaSource* _tmp27_;
									_tmp26_ = add_sources;
									_tmp27_ = source;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
								}
								_g_object_unref0 (source);
							}
							_g_object_unref0 (_source_it);
						}
						_tmp28_ = add_sources;
						_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
						_tmp30_ = _tmp29_;
						if (_tmp30_ > 0) {
							SourceProxy* _tmp31_;
							GeeHashMap* _tmp32_;
							SourceProxy* _tmp33_;
							GeeArrayList* _tmp34_;
							_tmp31_ = tag_proxy;
							g_signal_connect_object (_tmp31_, "broken", (GCallback) _add_tags_command_on_proxy_broken_source_proxy_broken, self, 0);
							_tmp32_ = self->priv->map;
							_tmp33_ = tag_proxy;
							_tmp34_ = add_sources;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, _tmp33_, _tmp34_);
						}
						_g_object_unref0 (add_sources);
						_source_proxy_unref0 (tag_proxy);
						_g_object_unref0 (tag);
						_g_free0 (create_path);
					}
				}
				_g_object_unref0 (paths_to_create);
				_g_free0 (path);
			}
		}
	}
	_tmp35_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp35_, "item-destroyed", (GCallback) _add_tags_command_on_source_destroyed_source_collection_item_destroyed, self, 0);
	_tmp36_ = video_global;
	g_signal_connect_object ((SourceCollection*) _tmp36_, "item-destroyed", (GCallback) _add_tags_command_on_source_destroyed_source_collection_item_destroyed, self, 0);
	return self;
}

AddTagsCommand*
add_tags_command_new (gchar** paths,
                      gint paths_length1,
                      GeeCollection* sources)
{
	return add_tags_command_construct (TYPE_ADD_TAGS_COMMAND, paths, paths_length1, sources);
}

static void
add_tags_command_real_execute (Command* base)
{
	AddTagsCommand * self;
	self = (AddTagsCommand*) base;
	{
		GeeIterator* _tag_proxy_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_tag_proxy_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			SourceProxy* tag_proxy = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SourceProxy* _tmp9_;
			DataSource* _tmp10_;
			Tag* _tmp11_;
			GeeHashMap* _tmp12_;
			SourceProxy* _tmp13_;
			gpointer _tmp14_;
			GeeArrayList* _tmp15_;
			_tmp6_ = _tag_proxy_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _tag_proxy_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			tag_proxy = (SourceProxy*) _tmp8_;
			_tmp9_ = tag_proxy;
			_tmp10_ = source_proxy_get_source (_tmp9_);
			_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_TAG, Tag);
			_tmp12_ = self->priv->map;
			_tmp13_ = tag_proxy;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
			_tmp15_ = (GeeArrayList*) _tmp14_;
			tag_attach_many (_tmp11_, (GeeCollection*) _tmp15_);
			_g_object_unref0 (_tmp15_);
			_g_object_unref0 (_tmp11_);
			_source_proxy_unref0 (tag_proxy);
		}
		_g_object_unref0 (_tag_proxy_it);
	}
}

static void
add_tags_command_real_undo (Command* base)
{
	AddTagsCommand * self;
	self = (AddTagsCommand*) base;
	{
		GeeIterator* _tag_proxy_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_tag_proxy_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			SourceProxy* tag_proxy = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			Tag* tag = NULL;
			SourceProxy* _tmp9_;
			DataSource* _tmp10_;
			Tag* _tmp11_;
			GeeHashMap* _tmp12_;
			SourceProxy* _tmp13_;
			gpointer _tmp14_;
			GeeArrayList* _tmp15_;
			GeeMultiMap* _tmp16_;
			GeeMultiMap* _tmp17_;
			_tmp6_ = _tag_proxy_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _tag_proxy_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			tag_proxy = (SourceProxy*) _tmp8_;
			_tmp9_ = tag_proxy;
			_tmp10_ = source_proxy_get_source (_tmp9_);
			tag = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_TAG, Tag);
			_tmp11_ = tag;
			_tmp12_ = self->priv->map;
			_tmp13_ = tag_proxy;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
			_tmp15_ = (GeeArrayList*) _tmp14_;
			_tmp16_ = tag_detach_many (_tmp11_, (GeeCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (_tmp15_);
			_g_object_unref0 (tag);
			_source_proxy_unref0 (tag_proxy);
		}
		_g_object_unref0 (_tag_proxy_it);
	}
}

static void
add_tags_command_on_source_destroyed (AddTagsCommand* self,
                                      DataSource* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	{
		GeeIterator* _sources_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_sources_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeArrayList* sources = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeArrayList* _tmp9_;
			_tmp6_ = _sources_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _sources_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			sources = (GeeArrayList*) _tmp8_;
			_tmp9_ = sources;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource))) {
				CommandManager* _tmp10_;
				CommandManager* _tmp11_;
				_tmp10_ = command_get_command_manager ((Command*) self);
				_tmp11_ = _tmp10_;
				command_manager_reset (_tmp11_);
				_command_manager_unref0 (_tmp11_);
				_g_object_unref0 (sources);
				_g_object_unref0 (_sources_it);
				return;
			}
			_g_object_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
}

static void
add_tags_command_on_proxy_broken (AddTagsCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
add_tags_command_class_init (AddTagsCommandClass * klass,
                             gpointer klass_data)
{
	add_tags_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AddTagsCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) add_tags_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) add_tags_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = add_tags_command_finalize;
}

static void
add_tags_command_instance_init (AddTagsCommand * self,
                                gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = add_tags_command_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
}

static void
add_tags_command_finalize (GObject * obj)
{
	AddTagsCommand * self;
	LibraryPhotoSourceCollection* _tmp11_;
	guint _tmp12_;
	VideoSourceCollection* _tmp13_;
	guint _tmp14_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_TAGS_COMMAND, AddTagsCommand);
	{
		GeeIterator* _tag_proxy_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->map;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_tag_proxy_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			SourceProxy* tag_proxy = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SourceProxy* _tmp9_;
			guint _tmp10_;
			_tmp6_ = _tag_proxy_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _tag_proxy_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			tag_proxy = (SourceProxy*) _tmp8_;
			_tmp9_ = tag_proxy;
			g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp10_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _add_tags_command_on_proxy_broken_source_proxy_broken, self);
			_source_proxy_unref0 (tag_proxy);
		}
		_g_object_unref0 (_tag_proxy_it);
	}
	_tmp11_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _add_tags_command_on_source_destroyed_source_collection_item_destroyed, self);
	_tmp13_ = video_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _add_tags_command_on_source_destroyed_source_collection_item_destroyed, self);
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (add_tags_command_parent_class)->finalize (obj);
}

static GType
add_tags_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AddTagsCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_tags_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddTagsCommand), 0, (GInstanceInitFunc) add_tags_command_instance_init, NULL };
	GType add_tags_command_type_id;
	add_tags_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "AddTagsCommand", &g_define_type_info, 0);
	AddTagsCommand_private_offset = g_type_add_instance_private (add_tags_command_type_id, sizeof (AddTagsCommandPrivate));
	return add_tags_command_type_id;
}

GType
add_tags_command_get_type (void)
{
	static volatile gsize add_tags_command_type_id__once = 0;
	if (g_once_init_enter (&add_tags_command_type_id__once)) {
		GType add_tags_command_type_id;
		add_tags_command_type_id = add_tags_command_get_type_once ();
		g_once_init_leave (&add_tags_command_type_id__once, add_tags_command_type_id);
	}
	return add_tags_command_type_id__once;
}

static inline gpointer
rename_tag_command_get_instance_private (RenameTagCommand* self)
{
	return G_STRUCT_MEMBER_P (self, RenameTagCommand_private_offset);
}

RenameTagCommand*
rename_tag_command_construct (GType object_type,
                              Tag* tag,
                              const gchar* new_name)
{
	RenameTagCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = tag_get_user_visible_name (tag);
	_tmp1_ = _tmp0_;
	_tmp2_ = resources_rename_tag_label (_tmp1_, new_name);
	_tmp3_ = _tmp2_;
	_tmp4_ = data_object_get_name ((DataObject*) tag);
	_tmp5_ = _tmp4_;
	self = (RenameTagCommand*) simple_proxyable_command_construct (object_type, (Proxyable*) tag, _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = tag_get_user_visible_name (tag);
	_g_free0 (self->priv->old_name);
	self->priv->old_name = _tmp6_;
	_tmp7_ = g_strdup (new_name);
	_g_free0 (self->priv->new_name);
	self->priv->new_name = _tmp7_;
	return self;
}

RenameTagCommand*
rename_tag_command_new (Tag* tag,
                        const gchar* new_name)
{
	return rename_tag_command_construct (TYPE_RENAME_TAG_COMMAND, tag, new_name);
}

static void
rename_tag_command_real_execute_on_source (SimpleProxyableCommand* base,
                                           DataSource* source)
{
	RenameTagCommand * self;
	const gchar* _tmp0_;
	self = (RenameTagCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->new_name;
	if (!tag_rename (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag), _tmp0_)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->new_name;
		_tmp2_ = resources_rename_tag_exists_message (_tmp1_);
		_tmp3_ = _tmp2_;
		app_window_error_message (_tmp3_, NULL, NULL);
		_g_free0 (_tmp3_);
	}
}

static void
rename_tag_command_real_undo_on_source (SimpleProxyableCommand* base,
                                        DataSource* source)
{
	RenameTagCommand * self;
	const gchar* _tmp0_;
	self = (RenameTagCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->old_name;
	if (!tag_rename (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag), _tmp0_)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->old_name;
		_tmp2_ = resources_rename_tag_exists_message (_tmp1_);
		_tmp3_ = _tmp2_;
		app_window_error_message (_tmp3_, NULL, NULL);
		_g_free0 (_tmp3_);
	}
}

static void
rename_tag_command_class_init (RenameTagCommandClass * klass,
                               gpointer klass_data)
{
	rename_tag_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RenameTagCommand_private_offset);
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) rename_tag_command_real_execute_on_source;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) rename_tag_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = rename_tag_command_finalize;
}

static void
rename_tag_command_instance_init (RenameTagCommand * self,
                                  gpointer klass)
{
	self->priv = rename_tag_command_get_instance_private (self);
}

static void
rename_tag_command_finalize (GObject * obj)
{
	RenameTagCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RENAME_TAG_COMMAND, RenameTagCommand);
	_g_free0 (self->priv->old_name);
	_g_free0 (self->priv->new_name);
	G_OBJECT_CLASS (rename_tag_command_parent_class)->finalize (obj);
}

static GType
rename_tag_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RenameTagCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rename_tag_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RenameTagCommand), 0, (GInstanceInitFunc) rename_tag_command_instance_init, NULL };
	GType rename_tag_command_type_id;
	rename_tag_command_type_id = g_type_register_static (TYPE_SIMPLE_PROXYABLE_COMMAND, "RenameTagCommand", &g_define_type_info, 0);
	RenameTagCommand_private_offset = g_type_add_instance_private (rename_tag_command_type_id, sizeof (RenameTagCommandPrivate));
	return rename_tag_command_type_id;
}

GType
rename_tag_command_get_type (void)
{
	static volatile gsize rename_tag_command_type_id__once = 0;
	if (g_once_init_enter (&rename_tag_command_type_id__once)) {
		GType rename_tag_command_type_id;
		rename_tag_command_type_id = rename_tag_command_get_type_once ();
		g_once_init_leave (&rename_tag_command_type_id__once, rename_tag_command_type_id);
	}
	return rename_tag_command_type_id__once;
}

static inline gpointer
delete_tag_command_get_instance_private (DeleteTagCommand* self)
{
	return G_STRUCT_MEMBER_P (self, DeleteTagCommand_private_offset);
}

DeleteTagCommand*
delete_tag_command_construct (GType object_type,
                              Tag* tag)
{
	DeleteTagCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = tag_get_user_visible_name (tag);
	_tmp1_ = _tmp0_;
	_tmp2_ = resources_delete_tag_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = data_object_get_name ((DataObject*) tag);
	_tmp5_ = _tmp4_;
	self = (DeleteTagCommand*) simple_proxyable_command_construct (object_type, (Proxyable*) tag, _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

DeleteTagCommand*
delete_tag_command_new (Tag* tag)
{
	return delete_tag_command_construct (TYPE_DELETE_TAG_COMMAND, tag);
}

static void
_delete_tag_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                         gpointer self)
{
	delete_tag_command_on_proxy_broken ((DeleteTagCommand*) self);
}

static void
delete_tag_command_real_execute_on_source (SimpleProxyableCommand* base,
                                           DataSource* source)
{
	DeleteTagCommand * self;
	Tag* tag = NULL;
	Tag* _tmp0_;
	GeeList* recursive_victims = NULL;
	Tag* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	TagSourceCollection* _tmp25_;
	TagSourceCollection* _tmp26_;
	Marker* _tmp27_;
	Marker* _tmp28_;
	self = (DeleteTagCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag));
	tag = _tmp0_;
	_tmp1_ = tag;
	_tmp2_ = tag_get_hierarchical_children (_tmp1_);
	recursive_victims = _tmp2_;
	_tmp3_ = recursive_victims;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		GeeArrayList* _tmp6_;
		_tmp6_ = gee_array_list_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->recursive_victim_proxies);
		self->priv->recursive_victim_proxies = (GeeList*) _tmp6_;
		{
			GeeList* _victim_list = NULL;
			GeeList* _tmp7_;
			gint _victim_size = 0;
			GeeList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _victim_index = 0;
			_tmp7_ = recursive_victims;
			_victim_list = _tmp7_;
			_tmp8_ = _victim_list;
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_victim_size = _tmp10_;
			_victim_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				Tag* victim = NULL;
				GeeList* _tmp13_;
				gpointer _tmp14_;
				SourceProxy* proxy = NULL;
				Tag* _tmp15_;
				SourceProxy* _tmp16_;
				SourceProxy* _tmp17_;
				GeeList* _tmp18_;
				SourceProxy* _tmp19_;
				TagSourceCollection* _tmp20_;
				TagSourceCollection* _tmp21_;
				Tag* _tmp22_;
				Marker* _tmp23_;
				Marker* _tmp24_;
				_victim_index = _victim_index + 1;
				_tmp11_ = _victim_index;
				_tmp12_ = _victim_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _victim_list;
				_tmp14_ = gee_list_get (_tmp13_, _victim_index);
				victim = (Tag*) _tmp14_;
				_tmp15_ = victim;
				_tmp16_ = proxyable_get_proxy ((Proxyable*) _tmp15_);
				proxy = _tmp16_;
				_tmp17_ = proxy;
				g_signal_connect_object (_tmp17_, "broken", (GCallback) _delete_tag_command_on_proxy_broken_source_proxy_broken, self, 0);
				_tmp18_ = self->priv->recursive_victim_proxies;
				_tmp19_ = proxy;
				gee_collection_add ((GeeCollection*) _tmp18_, _tmp19_);
				_tmp20_ = tag_global;
				_tmp21_ = tag_global;
				_tmp22_ = victim;
				_tmp23_ = data_collection_mark ((DataCollection*) _tmp21_, (DataObject*) _tmp22_);
				_tmp24_ = _tmp23_;
				source_collection_destroy_marked ((SourceCollection*) _tmp20_, _tmp24_, FALSE, NULL, NULL, NULL);
				_g_object_unref0 (_tmp24_);
				_source_proxy_unref0 (proxy);
				_g_object_unref0 (victim);
			}
		}
	}
	_tmp25_ = tag_global;
	_tmp26_ = tag_global;
	_tmp27_ = data_collection_mark ((DataCollection*) _tmp26_, (DataObject*) source);
	_tmp28_ = _tmp27_;
	source_collection_destroy_marked ((SourceCollection*) _tmp25_, _tmp28_, FALSE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp28_);
	_g_object_unref0 (recursive_victims);
	_g_object_unref0 (tag);
}

static void
delete_tag_command_real_undo_on_source (SimpleProxyableCommand* base,
                                        DataSource* source)
{
	DeleteTagCommand * self;
	GeeList* _tmp0_;
	self = (DeleteTagCommand*) base;
	g_return_if_fail (source != NULL);
	_vala_assert (IS_TAG (source), "source is Tag");
	_tmp0_ = self->priv->recursive_victim_proxies;
	if (_tmp0_ != NULL) {
		{
			gint i = 0;
			GeeList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			_tmp1_ = self->priv->recursive_victim_proxies;
			_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			i = _tmp3_ - 1;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					SourceProxy* proxy = NULL;
					GeeList* _tmp6_;
					gpointer _tmp7_;
					DataSource* victim_source = NULL;
					SourceProxy* _tmp8_;
					DataSource* _tmp9_;
					DataSource* _tmp10_;
					SourceProxy* _tmp11_;
					guint _tmp12_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ - 1;
					}
					_tmp4_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp6_ = self->priv->recursive_victim_proxies;
					_tmp7_ = gee_list_get (_tmp6_, i);
					proxy = (SourceProxy*) _tmp7_;
					_tmp8_ = proxy;
					_tmp9_ = source_proxy_get_source (_tmp8_);
					victim_source = _tmp9_;
					_tmp10_ = victim_source;
					_vala_assert (IS_TAG (_tmp10_), "victim_source is Tag");
					_tmp11_ = proxy;
					g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp12_, NULL, FALSE);
					g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _delete_tag_command_on_proxy_broken_source_proxy_broken, self);
					_g_object_unref0 (victim_source);
					_source_proxy_unref0 (proxy);
				}
			}
		}
		_g_object_unref0 (self->priv->recursive_victim_proxies);
		self->priv->recursive_victim_proxies = NULL;
	}
}

static void
delete_tag_command_on_proxy_broken (DeleteTagCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
delete_tag_command_class_init (DeleteTagCommandClass * klass,
                               gpointer klass_data)
{
	delete_tag_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DeleteTagCommand_private_offset);
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) delete_tag_command_real_execute_on_source;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) delete_tag_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = delete_tag_command_finalize;
}

static void
delete_tag_command_instance_init (DeleteTagCommand * self,
                                  gpointer klass)
{
	self->priv = delete_tag_command_get_instance_private (self);
	self->priv->recursive_victim_proxies = NULL;
}

static void
delete_tag_command_finalize (GObject * obj)
{
	DeleteTagCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELETE_TAG_COMMAND, DeleteTagCommand);
	_g_object_unref0 (self->priv->recursive_victim_proxies);
	G_OBJECT_CLASS (delete_tag_command_parent_class)->finalize (obj);
}

static GType
delete_tag_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DeleteTagCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delete_tag_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeleteTagCommand), 0, (GInstanceInitFunc) delete_tag_command_instance_init, NULL };
	GType delete_tag_command_type_id;
	delete_tag_command_type_id = g_type_register_static (TYPE_SIMPLE_PROXYABLE_COMMAND, "DeleteTagCommand", &g_define_type_info, 0);
	DeleteTagCommand_private_offset = g_type_add_instance_private (delete_tag_command_type_id, sizeof (DeleteTagCommandPrivate));
	return delete_tag_command_type_id;
}

GType
delete_tag_command_get_type (void)
{
	static volatile gsize delete_tag_command_type_id__once = 0;
	if (g_once_init_enter (&delete_tag_command_type_id__once)) {
		GType delete_tag_command_type_id;
		delete_tag_command_type_id = delete_tag_command_get_type_once ();
		g_once_init_leave (&delete_tag_command_type_id__once, delete_tag_command_type_id);
	}
	return delete_tag_command_type_id__once;
}

static inline gpointer
new_child_tag_command_get_instance_private (NewChildTagCommand* self)
{
	return G_STRUCT_MEMBER_P (self, NewChildTagCommand_private_offset);
}

NewChildTagCommand*
new_child_tag_command_construct (GType object_type,
                                 Tag* tag)
{
	NewChildTagCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = data_object_get_name ((DataObject*) tag);
	_tmp1_ = _tmp0_;
	self = (NewChildTagCommand*) simple_proxyable_command_construct (object_type, (Proxyable*) tag, _ ("Create Tag"), _tmp1_);
	_g_free0 (_tmp1_);
	return self;
}

NewChildTagCommand*
new_child_tag_command_new (Tag* tag)
{
	return new_child_tag_command_construct (TYPE_NEW_CHILD_TAG_COMMAND, tag);
}

static void
new_child_tag_command_real_execute_on_source (SimpleProxyableCommand* base,
                                              DataSource* source)
{
	NewChildTagCommand * self;
	Tag* tag = NULL;
	Tag* _tmp0_;
	Tag* _tmp1_;
	self = (NewChildTagCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag));
	tag = _tmp0_;
	_tmp1_ = tag_create_new_child (tag);
	_g_object_unref0 (self->priv->created_child);
	self->priv->created_child = _tmp1_;
	_g_object_unref0 (tag);
}

static void
new_child_tag_command_real_undo_on_source (SimpleProxyableCommand* base,
                                           DataSource* source)
{
	NewChildTagCommand * self;
	TagSourceCollection* _tmp0_;
	TagSourceCollection* _tmp1_;
	Tag* _tmp2_;
	Marker* _tmp3_;
	Marker* _tmp4_;
	self = (NewChildTagCommand*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = tag_global;
	_tmp1_ = tag_global;
	_tmp2_ = self->priv->created_child;
	_tmp3_ = data_collection_mark ((DataCollection*) _tmp1_, (DataObject*) _tmp2_);
	_tmp4_ = _tmp3_;
	source_collection_destroy_marked ((SourceCollection*) _tmp0_, _tmp4_, TRUE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp4_);
}

Tag*
new_child_tag_command_get_created_child (NewChildTagCommand* self)
{
	Tag* _tmp0_;
	Tag* _tmp1_;
	Tag* _tmp2_;
	Tag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->created_child;
	_vala_assert (_tmp0_ != NULL, "created_child != null");
	_tmp1_ = self->priv->created_child;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
new_child_tag_command_class_init (NewChildTagCommandClass * klass,
                                  gpointer klass_data)
{
	new_child_tag_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NewChildTagCommand_private_offset);
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) new_child_tag_command_real_execute_on_source;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) new_child_tag_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = new_child_tag_command_finalize;
}

static void
new_child_tag_command_instance_init (NewChildTagCommand * self,
                                     gpointer klass)
{
	self->priv = new_child_tag_command_get_instance_private (self);
	self->priv->created_child = NULL;
}

static void
new_child_tag_command_finalize (GObject * obj)
{
	NewChildTagCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEW_CHILD_TAG_COMMAND, NewChildTagCommand);
	_g_object_unref0 (self->priv->created_child);
	G_OBJECT_CLASS (new_child_tag_command_parent_class)->finalize (obj);
}

static GType
new_child_tag_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NewChildTagCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) new_child_tag_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NewChildTagCommand), 0, (GInstanceInitFunc) new_child_tag_command_instance_init, NULL };
	GType new_child_tag_command_type_id;
	new_child_tag_command_type_id = g_type_register_static (TYPE_SIMPLE_PROXYABLE_COMMAND, "NewChildTagCommand", &g_define_type_info, 0);
	NewChildTagCommand_private_offset = g_type_add_instance_private (new_child_tag_command_type_id, sizeof (NewChildTagCommandPrivate));
	return new_child_tag_command_type_id;
}

GType
new_child_tag_command_get_type (void)
{
	static volatile gsize new_child_tag_command_type_id__once = 0;
	if (g_once_init_enter (&new_child_tag_command_type_id__once)) {
		GType new_child_tag_command_type_id;
		new_child_tag_command_type_id = new_child_tag_command_get_type_once ();
		g_once_init_leave (&new_child_tag_command_type_id__once, new_child_tag_command_type_id);
	}
	return new_child_tag_command_type_id__once;
}

static inline gpointer
new_root_tag_command_get_instance_private (NewRootTagCommand* self)
{
	return G_STRUCT_MEMBER_P (self, NewRootTagCommand_private_offset);
}

NewRootTagCommand*
new_root_tag_command_construct (GType object_type)
{
	NewRootTagCommand * self = NULL;
	self = (NewRootTagCommand*) page_command_construct (object_type, _ ("Create Tag"), "");
	return self;
}

NewRootTagCommand*
new_root_tag_command_new (void)
{
	return new_root_tag_command_construct (TYPE_NEW_ROOT_TAG_COMMAND);
}

static void
new_root_tag_command_real_execute (Command* base)
{
	NewRootTagCommand * self;
	SourceProxy* _tmp0_;
	self = (NewRootTagCommand*) base;
	_tmp0_ = self->priv->created_proxy;
	if (_tmp0_ == NULL) {
		Tag* _tmp1_;
		Tag* _tmp2_;
		SourceProxy* _tmp3_;
		_tmp1_ = tag_create_new_root ();
		_tmp2_ = _tmp1_;
		_tmp3_ = proxyable_get_proxy ((Proxyable*) _tmp2_);
		_source_proxy_unref0 (self->priv->created_proxy);
		self->priv->created_proxy = _tmp3_;
		_g_object_unref0 (_tmp2_);
	} else {
		SourceProxy* _tmp4_;
		DataSource* _tmp5_;
		DataSource* _tmp6_;
		_tmp4_ = self->priv->created_proxy;
		_tmp5_ = source_proxy_get_source (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
	}
}

static void
new_root_tag_command_real_undo (Command* base)
{
	NewRootTagCommand * self;
	TagSourceCollection* _tmp0_;
	TagSourceCollection* _tmp1_;
	SourceProxy* _tmp2_;
	DataSource* _tmp3_;
	DataSource* _tmp4_;
	Marker* _tmp5_;
	Marker* _tmp6_;
	self = (NewRootTagCommand*) base;
	_tmp0_ = tag_global;
	_tmp1_ = tag_global;
	_tmp2_ = self->priv->created_proxy;
	_tmp3_ = source_proxy_get_source (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = data_collection_mark ((DataCollection*) _tmp1_, (DataObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	source_collection_destroy_marked ((SourceCollection*) _tmp0_, _tmp6_, TRUE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
}

Tag*
new_root_tag_command_get_created_tag (NewRootTagCommand* self)
{
	SourceProxy* _tmp0_;
	DataSource* _tmp1_;
	Tag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->created_proxy;
	_tmp1_ = source_proxy_get_source (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TAG, Tag);
	return result;
}

static void
new_root_tag_command_class_init (NewRootTagCommandClass * klass,
                                 gpointer klass_data)
{
	new_root_tag_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NewRootTagCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) new_root_tag_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) new_root_tag_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = new_root_tag_command_finalize;
}

static void
new_root_tag_command_instance_init (NewRootTagCommand * self,
                                    gpointer klass)
{
	self->priv = new_root_tag_command_get_instance_private (self);
	self->priv->created_proxy = NULL;
}

static void
new_root_tag_command_finalize (GObject * obj)
{
	NewRootTagCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEW_ROOT_TAG_COMMAND, NewRootTagCommand);
	_source_proxy_unref0 (self->priv->created_proxy);
	G_OBJECT_CLASS (new_root_tag_command_parent_class)->finalize (obj);
}

static GType
new_root_tag_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NewRootTagCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) new_root_tag_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NewRootTagCommand), 0, (GInstanceInitFunc) new_root_tag_command_instance_init, NULL };
	GType new_root_tag_command_type_id;
	new_root_tag_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "NewRootTagCommand", &g_define_type_info, 0);
	NewRootTagCommand_private_offset = g_type_add_instance_private (new_root_tag_command_type_id, sizeof (NewRootTagCommandPrivate));
	return new_root_tag_command_type_id;
}

GType
new_root_tag_command_get_type (void)
{
	static volatile gsize new_root_tag_command_type_id__once = 0;
	if (g_once_init_enter (&new_root_tag_command_type_id__once)) {
		GType new_root_tag_command_type_id;
		new_root_tag_command_type_id = new_root_tag_command_get_type_once ();
		g_once_init_leave (&new_root_tag_command_type_id__once, new_root_tag_command_type_id);
	}
	return new_root_tag_command_type_id__once;
}

static inline gpointer
reparent_tag_command_get_instance_private (ReparentTagCommand* self)
{
	return G_STRUCT_MEMBER_P (self, ReparentTagCommand_private_offset);
}

static void
_reparent_tag_command_on_items_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                            GeeCollection* destroyed,
                                                                            gpointer self)
{
	reparent_tag_command_on_items_destroyed ((ReparentTagCommand*) self, destroyed);
}

ReparentTagCommand*
reparent_tag_command_construct (GType object_type,
                                Tag* tag,
                                const gchar* new_parent_path)
{
	ReparentTagCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean has_children = FALSE;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gchar* basename = NULL;
	gchar* _tmp10_;
	gchar* new_to_path = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	TagSourceCollection* _tmp32_;
	const gchar* _tmp33_;
	GeeHashSet* _tmp34_;
	GeeCollection* _tmp35_;
	GeeCollection* _tmp36_;
	LibraryPhotoSourceCollection* _tmp37_;
	VideoSourceCollection* _tmp38_;
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (new_parent_path != NULL, NULL);
	_tmp0_ = tag_get_user_visible_name (tag);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Move Tag \"%s\""), _tmp1_);
	_tmp3_ = _tmp2_;
	self = (ReparentTagCommand*) page_command_construct (object_type, _tmp3_, "");
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = tag_get_path (tag);
	_g_free0 (self->priv->from_path);
	self->priv->from_path = _tmp4_;
	_tmp5_ = tag_get_hierarchical_children (tag);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ > 0;
	_g_object_unref0 (_tmp6_);
	has_children = _tmp9_;
	_tmp10_ = tag_get_user_visible_name (tag);
	basename = _tmp10_;
	if (g_strcmp0 (new_parent_path, TAG_PATH_SEPARATOR_STRING) == 0) {
		gchar* _tmp11_ = NULL;
		gchar* _tmp16_;
		if (has_children) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = basename;
			_tmp13_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp12_, NULL);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp13_;
		} else {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = basename;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp15_;
		}
		_tmp16_ = g_strdup (_tmp11_);
		_g_free0 (self->priv->to_path);
		self->priv->to_path = _tmp16_;
		_g_free0 (_tmp11_);
	} else {
		if (g_str_has_prefix (new_parent_path, TAG_PATH_SEPARATOR_STRING)) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp17_ = g_strconcat (new_parent_path, TAG_PATH_SEPARATOR_STRING, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = basename;
			_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
			_g_free0 (self->priv->to_path);
			self->priv->to_path = _tmp20_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, new_parent_path, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp22_, TAG_PATH_SEPARATOR_STRING, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = basename;
			_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
			_g_free0 (self->priv->to_path);
			self->priv->to_path = _tmp26_;
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
		}
	}
	_tmp27_ = self->priv->to_path;
	_tmp28_ = hierarchical_tag_utilities_get_root_path_form (_tmp27_);
	new_to_path = _tmp28_;
	_tmp29_ = new_to_path;
	if (_tmp29_ != NULL) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = new_to_path;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (self->priv->to_path);
		self->priv->to_path = _tmp31_;
	}
	_tmp32_ = tag_global;
	_tmp33_ = self->priv->to_path;
	if (tag_source_collection_exists (_tmp32_, _tmp33_, FALSE)) {
		self->priv->to_path_exists = TRUE;
	}
	_tmp34_ = self->priv->sources_in_play;
	_tmp35_ = tag_get_sources (tag);
	_tmp36_ = _tmp35_;
	gee_collection_add_all ((GeeCollection*) _tmp34_, _tmp36_);
	_g_object_unref0 (_tmp36_);
	_tmp37_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp37_, "items-destroyed", (GCallback) _reparent_tag_command_on_items_destroyed_source_collection_items_destroyed, self, 0);
	_tmp38_ = video_global;
	g_signal_connect_object ((SourceCollection*) _tmp38_, "items-destroyed", (GCallback) _reparent_tag_command_on_items_destroyed_source_collection_items_destroyed, self, 0);
	_g_free0 (new_to_path);
	_g_free0 (basename);
	return self;
}

ReparentTagCommand*
reparent_tag_command_new (Tag* tag,
                          const gchar* new_parent_path)
{
	return reparent_tag_command_construct (TYPE_REPARENT_TAG_COMMAND, tag, new_parent_path);
}

static void
reparent_tag_command_on_items_destroyed (ReparentTagCommand* self,
                                         GeeCollection* destroyed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (destroyed != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) destroyed);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashSet* _tmp4_;
			DataSource* _tmp5_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = self->priv->sources_in_play;
			_tmp5_ = source;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource))) {
				CommandManager* _tmp6_;
				CommandManager* _tmp7_;
				_tmp6_ = command_get_command_manager ((Command*) self);
				_tmp7_ = _tmp6_;
				command_manager_reset (_tmp7_);
				_command_manager_unref0 (_tmp7_);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GeeMap*
reparent_tag_command_get_child_structure_at (ReparentTagCommand* self,
                                             const gchar* client_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	GeeMap* _result_ = NULL;
	GeeHashMap* _tmp5_;
	TagSourceCollection* _tmp6_;
	const gchar* _tmp7_;
	Tag* tag = NULL;
	const gchar* _tmp8_;
	Tag* _tmp9_;
	gchar* path_prefix = NULL;
	Tag* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (client_path != NULL, NULL);
	_tmp0_ = hierarchical_tag_utilities_get_root_path_form (client_path);
	path = _tmp0_;
	_tmp2_ = path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = path;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = client_path;
	}
	_tmp4_ = g_strdup (_tmp1_);
	_g_free0 (path);
	path = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_result_ = (GeeMap*) _tmp5_;
	_tmp6_ = tag_global;
	_tmp7_ = path;
	if (!tag_source_collection_exists (_tmp6_, _tmp7_, FALSE)) {
		result = _result_;
		_g_free0 (path);
		return result;
	}
	_tmp8_ = path;
	_tmp9_ = tag_for_path (_tmp8_);
	tag = _tmp9_;
	_tmp10_ = tag;
	_tmp11_ = tag_get_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, TAG_PATH_SEPARATOR_STRING, NULL);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	path_prefix = _tmp14_;
	{
		GeeList* _t_list = NULL;
		Tag* _tmp15_;
		GeeList* _tmp16_;
		gint _t_size = 0;
		GeeList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _t_index = 0;
		_tmp15_ = tag;
		_tmp16_ = tag_get_hierarchical_children (_tmp15_);
		_t_list = _tmp16_;
		_tmp17_ = _t_list;
		_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_t_size = _tmp19_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			Tag* t = NULL;
			GeeList* _tmp22_;
			gpointer _tmp23_;
			gchar* child_subpath = NULL;
			Tag* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GeeMap* _tmp30_;
			const gchar* _tmp31_;
			GeeHashSet* _tmp32_;
			GeeHashSet* _tmp33_;
			GeeMap* _tmp34_;
			const gchar* _tmp35_;
			gpointer _tmp36_;
			GeeSet* _tmp37_;
			Tag* _tmp38_;
			GeeCollection* _tmp39_;
			GeeCollection* _tmp40_;
			_t_index = _t_index + 1;
			_tmp20_ = _t_index;
			_tmp21_ = _t_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _t_list;
			_tmp23_ = gee_list_get (_tmp22_, _t_index);
			t = (Tag*) _tmp23_;
			_tmp24_ = t;
			_tmp25_ = tag_get_path (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = path_prefix;
			_tmp28_ = string_replace (_tmp26_, _tmp27_, "");
			_tmp29_ = _tmp28_;
			_g_free0 (_tmp26_);
			child_subpath = _tmp29_;
			_tmp30_ = _result_;
			_tmp31_ = child_subpath;
			_tmp32_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_tmp33_ = _tmp32_;
			gee_map_set (_tmp30_, _tmp31_, (GeeSet*) _tmp33_);
			_g_object_unref0 (_tmp33_);
			_tmp34_ = _result_;
			_tmp35_ = child_subpath;
			_tmp36_ = gee_map_get (_tmp34_, _tmp35_);
			_tmp37_ = (GeeSet*) _tmp36_;
			_tmp38_ = t;
			_tmp39_ = tag_get_sources (_tmp38_);
			_tmp40_ = _tmp39_;
			gee_collection_add_all ((GeeCollection*) _tmp37_, _tmp40_);
			_g_object_unref0 (_tmp40_);
			_g_object_unref0 (_tmp37_);
			_g_free0 (child_subpath);
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_list);
	}
	result = _result_;
	_g_free0 (path_prefix);
	_g_object_unref0 (tag);
	_g_free0 (path);
	return result;
}

static void
reparent_tag_command_restore_child_attachments_at (ReparentTagCommand* self,
                                                   const gchar* client_path,
                                                   GeeMap* child_structure)
{
	gchar* new_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* path = NULL;
	gchar* _tmp4_;
	TagSourceCollection* _tmp5_;
	const gchar* _tmp6_;
	Tag* tag = NULL;
	const gchar* _tmp7_;
	Tag* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client_path != NULL);
	g_return_if_fail (child_structure != NULL);
	_tmp0_ = hierarchical_tag_utilities_get_root_path_form (client_path);
	new_path = _tmp0_;
	_tmp2_ = new_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = new_path;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = client_path;
	}
	_tmp4_ = g_strdup (_tmp1_);
	path = _tmp4_;
	_tmp5_ = tag_global;
	_tmp6_ = path;
	_vala_assert (tag_source_collection_exists (_tmp5_, _tmp6_, FALSE), "Tag.global.exists (path)");
	_tmp7_ = path;
	_tmp8_ = tag_for_path (_tmp7_);
	tag = _tmp8_;
	{
		GeeIterator* _child_subpath_it = NULL;
		GeeSet* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp9_ = gee_map_get_keys (child_structure);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_child_subpath_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			gchar* child_subpath = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			gchar* child_path = NULL;
			Tag* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			Tag* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			TagSourceCollection* _tmp37_;
			const gchar* _tmp38_;
			_tmp14_ = _child_subpath_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _child_subpath_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			child_subpath = (gchar*) _tmp16_;
			_tmp17_ = tag;
			_tmp18_ = tag_get_path (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp19_, TAG_PATH_SEPARATOR_STRING, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = child_subpath;
			_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			child_path = _tmp24_;
			_tmp25_ = tag;
			_tmp26_ = tag_get_path (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = !g_str_has_prefix (_tmp27_, TAG_PATH_SEPARATOR_STRING);
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				Tag* _tmp29_;
				Tag* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp29_ = tag;
				tag_promote (_tmp29_);
				_tmp30_ = tag;
				_tmp31_ = tag_get_path (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, TAG_PATH_SEPARATOR_STRING, NULL);
				_tmp34_ = _tmp33_;
				_tmp35_ = child_subpath;
				_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
				_g_free0 (child_path);
				child_path = _tmp36_;
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
			}
			_tmp37_ = tag_global;
			_tmp38_ = child_path;
			_vala_assert (tag_source_collection_exists (_tmp37_, _tmp38_, FALSE), "Tag.global.exists (child_path)");
			{
				GeeIterator* _s_it = NULL;
				const gchar* _tmp39_;
				gpointer _tmp40_;
				GeeSet* _tmp41_;
				GeeIterator* _tmp42_;
				GeeIterator* _tmp43_;
				_tmp39_ = child_subpath;
				_tmp40_ = gee_map_get (child_structure, _tmp39_);
				_tmp41_ = (GeeSet*) _tmp40_;
				_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
				_tmp43_ = _tmp42_;
				_g_object_unref0 (_tmp41_);
				_s_it = _tmp43_;
				while (TRUE) {
					GeeIterator* _tmp44_;
					MediaSource* s = NULL;
					GeeIterator* _tmp45_;
					gpointer _tmp46_;
					const gchar* _tmp47_;
					Tag* _tmp48_;
					Tag* _tmp49_;
					MediaSource* _tmp50_;
					_tmp44_ = _s_it;
					if (!gee_iterator_next (_tmp44_)) {
						break;
					}
					_tmp45_ = _s_it;
					_tmp46_ = gee_iterator_get (_tmp45_);
					s = (MediaSource*) _tmp46_;
					_tmp47_ = child_path;
					_tmp48_ = tag_for_path (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = s;
					tag_attach (_tmp49_, _tmp50_);
					_g_object_unref0 (_tmp49_);
					_g_object_unref0 (s);
				}
				_g_object_unref0 (_s_it);
			}
			_g_free0 (child_path);
			_g_free0 (child_subpath);
		}
		_g_object_unref0 (_child_subpath_it);
	}
	_g_object_unref0 (tag);
	_g_free0 (path);
	_g_free0 (new_path);
}

static void
reparent_tag_command_reattach_in_play_sources_at (ReparentTagCommand* self,
                                                  const gchar* client_path)
{
	gchar* new_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* path = NULL;
	gchar* _tmp4_;
	TagSourceCollection* _tmp5_;
	const gchar* _tmp6_;
	Tag* tag = NULL;
	const gchar* _tmp7_;
	Tag* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client_path != NULL);
	_tmp0_ = hierarchical_tag_utilities_get_root_path_form (client_path);
	new_path = _tmp0_;
	_tmp2_ = new_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = new_path;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = client_path;
	}
	_tmp4_ = g_strdup (_tmp1_);
	path = _tmp4_;
	_tmp5_ = tag_global;
	_tmp6_ = path;
	_vala_assert (tag_source_collection_exists (_tmp5_, _tmp6_, FALSE), "Tag.global.exists (path)");
	_tmp7_ = path;
	_tmp8_ = tag_for_path (_tmp7_);
	tag = _tmp8_;
	{
		GeeIterator* _s_it = NULL;
		GeeHashSet* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = self->priv->sources_in_play;
		_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
		_s_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			MediaSource* s = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			Tag* _tmp14_;
			MediaSource* _tmp15_;
			_tmp11_ = _s_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _s_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			s = (MediaSource*) _tmp13_;
			_tmp14_ = tag;
			_tmp15_ = s;
			tag_attach (_tmp14_, _tmp15_);
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_it);
	}
	_g_object_unref0 (tag);
	_g_free0 (path);
	_g_free0 (new_path);
}

static void
reparent_tag_command_save_before_state (ReparentTagCommand* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeMap* _tmp4_;
	const gchar* _tmp5_;
	GeeMap* _tmp6_;
	TagSourceCollection* _tmp7_;
	const gchar* _tmp8_;
	Tag* from_tag = NULL;
	const gchar* _tmp9_;
	Tag* _tmp10_;
	GeeList* _tmp11_;
	Tag* _tmp12_;
	SourceProxy* _tmp13_;
	SourceProxy* _tmp14_;
	GeeList* parent_paths = NULL;
	const gchar* _tmp15_;
	GeeList* _tmp16_;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	const gchar* _tmp25_;
	const gchar* _tmp29_;
	const gchar* _tmp41_;
	const gchar* _tmp57_;
	GeeList* from_children = NULL;
	Tag* _tmp64_;
	GeeList* _tmp65_;
	const gchar* _tmp77_;
	const gchar* _tmp94_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->src_before_state;
	_vala_assert (_tmp0_ == NULL, "src_before_state == null");
	_tmp1_ = self->priv->dest_before_state;
	_vala_assert (_tmp1_ == NULL, "dest_before_state == null");
	_tmp2_ = gee_array_list_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->src_before_state);
	self->priv->src_before_state = (GeeList*) _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->dest_before_state);
	self->priv->dest_before_state = (GeeList*) _tmp3_;
	_tmp4_ = self->priv->in_play_child_structure;
	_vala_assert (_tmp4_ == NULL, "in_play_child_structure == null");
	_tmp5_ = self->priv->from_path;
	_tmp6_ = reparent_tag_command_get_child_structure_at (self, _tmp5_);
	_g_object_unref0 (self->priv->in_play_child_structure);
	self->priv->in_play_child_structure = _tmp6_;
	_tmp7_ = tag_global;
	_tmp8_ = self->priv->from_path;
	_vala_assert (tag_source_collection_exists (_tmp7_, _tmp8_, FALSE), "Tag.global.exists (from_path)");
	_tmp9_ = self->priv->from_path;
	_tmp10_ = tag_for_path (_tmp9_);
	from_tag = _tmp10_;
	_tmp11_ = self->priv->src_before_state;
	_tmp12_ = from_tag;
	_tmp13_ = proxyable_get_proxy ((Proxyable*) _tmp12_);
	_tmp14_ = _tmp13_;
	gee_collection_add ((GeeCollection*) _tmp11_, _tmp14_);
	_source_proxy_unref0 (_tmp14_);
	_tmp15_ = self->priv->to_path;
	_tmp16_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp15_);
	parent_paths = _tmp16_;
	_tmp17_ = parent_paths;
	_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		GeeList* _tmp20_;
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gpointer _tmp24_;
		_tmp20_ = parent_paths;
		_tmp21_ = parent_paths;
		_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_list_get (_tmp20_, _tmp23_ - 1);
		_g_free0 (self->priv->to_path_parent_path);
		self->priv->to_path_parent_path = (gchar*) _tmp24_;
	}
	_tmp25_ = self->priv->to_path_parent_path;
	if (_tmp25_ != NULL) {
		GeeMap* _tmp26_;
		const gchar* _tmp27_;
		GeeMap* _tmp28_;
		_tmp26_ = self->priv->existing_dest_child_structure;
		_vala_assert (_tmp26_ == NULL, "existing_dest_child_structure == null");
		_tmp27_ = self->priv->to_path_parent_path;
		_tmp28_ = reparent_tag_command_get_child_structure_at (self, _tmp27_);
		_g_object_unref0 (self->priv->existing_dest_child_structure);
		self->priv->existing_dest_child_structure = _tmp28_;
	}
	_tmp29_ = self->priv->to_path_parent_path;
	if (_tmp29_ == NULL) {
		GeeMap* _tmp30_;
		GeeSet* _tmp31_;
		const gchar* _tmp32_;
		GeeMap* _tmp33_;
		GeeHashSet* _tmp34_;
		GeeSet* _tmp35_;
		const gchar* _tmp36_;
		Tag* _tmp37_;
		Tag* _tmp38_;
		GeeCollection* _tmp39_;
		GeeCollection* _tmp40_;
		_tmp30_ = self->priv->existing_dest_child_structure;
		_vala_assert (_tmp30_ == NULL, "existing_dest_child_structure == null");
		_tmp31_ = self->priv->existing_dest_membership;
		_vala_assert (_tmp31_ == NULL, "existing_dest_membership == null");
		_tmp32_ = self->priv->to_path;
		_tmp33_ = reparent_tag_command_get_child_structure_at (self, _tmp32_);
		_g_object_unref0 (self->priv->existing_dest_child_structure);
		self->priv->existing_dest_child_structure = _tmp33_;
		_tmp34_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->existing_dest_membership);
		self->priv->existing_dest_membership = (GeeSet*) _tmp34_;
		_tmp35_ = self->priv->existing_dest_membership;
		_tmp36_ = self->priv->to_path;
		_tmp37_ = tag_for_path (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = tag_get_sources (_tmp38_);
		_tmp40_ = _tmp39_;
		gee_collection_add_all ((GeeCollection*) _tmp35_, _tmp40_);
		_g_object_unref0 (_tmp40_);
		_g_object_unref0 (_tmp38_);
	}
	_tmp41_ = self->priv->to_path_parent_path;
	if (_tmp41_ != NULL) {
		gchar* new_tpp = NULL;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_;
		gchar* _tmp48_;
		TagSourceCollection* _tmp49_;
		const gchar* _tmp50_;
		GeeList* _tmp51_;
		const gchar* _tmp52_;
		Tag* _tmp53_;
		Tag* _tmp54_;
		SourceProxy* _tmp55_;
		SourceProxy* _tmp56_;
		_tmp42_ = self->priv->to_path_parent_path;
		_tmp43_ = hierarchical_tag_utilities_get_root_path_form (_tmp42_);
		new_tpp = _tmp43_;
		_tmp45_ = new_tpp;
		if (_tmp45_ != NULL) {
			const gchar* _tmp46_;
			_tmp46_ = new_tpp;
			_tmp44_ = _tmp46_;
		} else {
			const gchar* _tmp47_;
			_tmp47_ = self->priv->to_path_parent_path;
			_tmp44_ = _tmp47_;
		}
		_tmp48_ = g_strdup (_tmp44_);
		_g_free0 (self->priv->to_path_parent_path);
		self->priv->to_path_parent_path = _tmp48_;
		_tmp49_ = tag_global;
		_tmp50_ = self->priv->to_path_parent_path;
		_vala_assert (tag_source_collection_exists (_tmp49_, _tmp50_, FALSE), "Tag.global.exists (to_path_parent_path)");
		_tmp51_ = self->priv->dest_before_state;
		_tmp52_ = self->priv->to_path_parent_path;
		_tmp53_ = tag_for_path (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = proxyable_get_proxy ((Proxyable*) _tmp54_);
		_tmp56_ = _tmp55_;
		gee_collection_add ((GeeCollection*) _tmp51_, _tmp56_);
		_source_proxy_unref0 (_tmp56_);
		_g_object_unref0 (_tmp54_);
		_g_free0 (new_tpp);
	}
	_tmp57_ = self->priv->to_path_parent_path;
	if (_tmp57_ == NULL) {
		GeeList* _tmp58_;
		const gchar* _tmp59_;
		Tag* _tmp60_;
		Tag* _tmp61_;
		SourceProxy* _tmp62_;
		SourceProxy* _tmp63_;
		_tmp58_ = self->priv->dest_before_state;
		_tmp59_ = self->priv->to_path;
		_tmp60_ = tag_for_path (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = proxyable_get_proxy ((Proxyable*) _tmp61_);
		_tmp63_ = _tmp62_;
		gee_collection_add ((GeeCollection*) _tmp58_, _tmp63_);
		_source_proxy_unref0 (_tmp63_);
		_g_object_unref0 (_tmp61_);
	}
	_tmp64_ = from_tag;
	_tmp65_ = tag_get_hierarchical_children (_tmp64_);
	from_children = _tmp65_;
	{
		gint i = 0;
		GeeList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		_tmp66_ = from_children;
		_tmp67_ = gee_collection_get_size ((GeeCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		i = _tmp68_ - 1;
		{
			gboolean _tmp69_ = FALSE;
			_tmp69_ = TRUE;
			while (TRUE) {
				GeeList* _tmp71_;
				GeeList* _tmp72_;
				gpointer _tmp73_;
				Tag* _tmp74_;
				SourceProxy* _tmp75_;
				SourceProxy* _tmp76_;
				if (!_tmp69_) {
					gint _tmp70_;
					_tmp70_ = i;
					i = _tmp70_ - 1;
				}
				_tmp69_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp71_ = self->priv->src_before_state;
				_tmp72_ = from_children;
				_tmp73_ = gee_list_get (_tmp72_, i);
				_tmp74_ = (Tag*) _tmp73_;
				_tmp75_ = proxyable_get_proxy ((Proxyable*) _tmp74_);
				_tmp76_ = _tmp75_;
				gee_collection_add ((GeeCollection*) _tmp71_, _tmp76_);
				_source_proxy_unref0 (_tmp76_);
				_g_object_unref0 (_tmp74_);
			}
		}
	}
	_tmp77_ = self->priv->to_path_parent_path;
	if (_tmp77_ != NULL) {
		GeeList* to_children = NULL;
		const gchar* _tmp78_;
		Tag* _tmp79_;
		Tag* _tmp80_;
		GeeList* _tmp81_;
		GeeList* _tmp82_;
		_tmp78_ = self->priv->to_path_parent_path;
		_tmp79_ = tag_for_path (_tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = tag_get_hierarchical_children (_tmp80_);
		_tmp82_ = _tmp81_;
		_g_object_unref0 (_tmp80_);
		to_children = _tmp82_;
		{
			gint i = 0;
			GeeList* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			_tmp83_ = to_children;
			_tmp84_ = gee_collection_get_size ((GeeCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			i = _tmp85_ - 1;
			{
				gboolean _tmp86_ = FALSE;
				_tmp86_ = TRUE;
				while (TRUE) {
					GeeList* _tmp88_;
					GeeList* _tmp89_;
					gpointer _tmp90_;
					Tag* _tmp91_;
					SourceProxy* _tmp92_;
					SourceProxy* _tmp93_;
					if (!_tmp86_) {
						gint _tmp87_;
						_tmp87_ = i;
						i = _tmp87_ - 1;
					}
					_tmp86_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp88_ = self->priv->dest_before_state;
					_tmp89_ = to_children;
					_tmp90_ = gee_list_get (_tmp89_, i);
					_tmp91_ = (Tag*) _tmp90_;
					_tmp92_ = proxyable_get_proxy ((Proxyable*) _tmp91_);
					_tmp93_ = _tmp92_;
					gee_collection_add ((GeeCollection*) _tmp88_, _tmp93_);
					_source_proxy_unref0 (_tmp93_);
					_g_object_unref0 (_tmp91_);
				}
			}
		}
		_g_object_unref0 (to_children);
	}
	_tmp94_ = self->priv->to_path_parent_path;
	if (_tmp94_ == NULL) {
		GeeList* to_children = NULL;
		const gchar* _tmp95_;
		Tag* _tmp96_;
		Tag* _tmp97_;
		GeeList* _tmp98_;
		GeeList* _tmp99_;
		_tmp95_ = self->priv->to_path;
		_tmp96_ = tag_for_path (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = tag_get_hierarchical_children (_tmp97_);
		_tmp99_ = _tmp98_;
		_g_object_unref0 (_tmp97_);
		to_children = _tmp99_;
		{
			gint i = 0;
			GeeList* _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			_tmp100_ = to_children;
			_tmp101_ = gee_collection_get_size ((GeeCollection*) _tmp100_);
			_tmp102_ = _tmp101_;
			i = _tmp102_ - 1;
			{
				gboolean _tmp103_ = FALSE;
				_tmp103_ = TRUE;
				while (TRUE) {
					GeeList* _tmp105_;
					GeeList* _tmp106_;
					gpointer _tmp107_;
					Tag* _tmp108_;
					SourceProxy* _tmp109_;
					SourceProxy* _tmp110_;
					if (!_tmp103_) {
						gint _tmp104_;
						_tmp104_ = i;
						i = _tmp104_ - 1;
					}
					_tmp103_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp105_ = self->priv->dest_before_state;
					_tmp106_ = to_children;
					_tmp107_ = gee_list_get (_tmp106_, i);
					_tmp108_ = (Tag*) _tmp107_;
					_tmp109_ = proxyable_get_proxy ((Proxyable*) _tmp108_);
					_tmp110_ = _tmp109_;
					gee_collection_add ((GeeCollection*) _tmp105_, _tmp110_);
					_source_proxy_unref0 (_tmp110_);
					_g_object_unref0 (_tmp108_);
				}
			}
		}
		_g_object_unref0 (to_children);
	}
	_g_object_unref0 (from_children);
	_g_object_unref0 (parent_paths);
	_g_object_unref0 (from_tag);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
reparent_tag_command_restore_before_state (ReparentTagCommand* self)
{
	GeeList* _tmp0_;
	GeeMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	gchar* unwind_target = NULL;
	gchar* _tmp14_;
	const gchar* _tmp83_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->src_before_state;
	_vala_assert (_tmp0_ != NULL, "src_before_state != null");
	_tmp1_ = self->priv->existing_dest_child_structure;
	_vala_assert (_tmp1_ != NULL, "existing_dest_child_structure != null");
	_tmp2_ = self->priv->to_path_parent_path;
	if (_tmp2_ != NULL) {
		gchar* new_tpp = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		gchar* _tmp9_;
		_tmp3_ = self->priv->to_path_parent_path;
		_tmp4_ = hierarchical_tag_utilities_get_root_path_form (_tmp3_);
		new_tpp = _tmp4_;
		_tmp6_ = new_tpp;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = new_tpp;
			_tmp5_ = _tmp7_;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = self->priv->to_path_parent_path;
			_tmp5_ = _tmp8_;
		}
		_tmp9_ = g_strdup (_tmp5_);
		_g_free0 (self->priv->to_path_parent_path);
		self->priv->to_path_parent_path = _tmp9_;
		_g_free0 (new_tpp);
	}
	_tmp11_ = self->priv->to_path_parent_path;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_;
		_tmp12_ = self->priv->to_path_parent_path;
		_tmp10_ = _tmp12_;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = self->priv->to_path;
		_tmp10_ = _tmp13_;
	}
	_tmp14_ = g_strdup (_tmp10_);
	unwind_target = _tmp14_;
	{
		GeeList* _t_list = NULL;
		const gchar* _tmp15_;
		Tag* _tmp16_;
		Tag* _tmp17_;
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		gint _t_size = 0;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _t_index = 0;
		_tmp15_ = unwind_target;
		_tmp16_ = tag_for_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = tag_get_hierarchical_children (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_t_list = _tmp19_;
		_tmp20_ = _t_list;
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_t_size = _tmp22_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			Tag* t = NULL;
			GeeList* _tmp25_;
			gpointer _tmp26_;
			gchar* child_subpath = NULL;
			Tag* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			GeeMap* _tmp36_;
			const gchar* _tmp37_;
			_t_index = _t_index + 1;
			_tmp23_ = _t_index;
			_tmp24_ = _t_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _t_list;
			_tmp26_ = gee_list_get (_tmp25_, _t_index);
			t = (Tag*) _tmp26_;
			_tmp27_ = t;
			_tmp28_ = tag_get_path (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = unwind_target;
			_tmp31_ = string_replace (_tmp29_, _tmp30_, "");
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp29_);
			child_subpath = _tmp32_;
			_tmp33_ = child_subpath;
			if (g_str_has_prefix (_tmp33_, TAG_PATH_SEPARATOR_STRING)) {
				const gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp34_ = child_subpath;
				_tmp35_ = string_substring (_tmp34_, (glong) 1, (glong) -1);
				_g_free0 (child_subpath);
				child_subpath = _tmp35_;
			}
			_tmp36_ = self->priv->existing_dest_child_structure;
			_tmp37_ = child_subpath;
			if (!gee_map_has_key (_tmp36_, _tmp37_)) {
				TagSourceCollection* _tmp38_;
				TagSourceCollection* _tmp39_;
				Tag* _tmp40_;
				Marker* _tmp41_;
				Marker* _tmp42_;
				_tmp38_ = tag_global;
				_tmp39_ = tag_global;
				_tmp40_ = t;
				_tmp41_ = data_collection_mark ((DataCollection*) _tmp39_, (DataObject*) _tmp40_);
				_tmp42_ = _tmp41_;
				source_collection_destroy_marked ((SourceCollection*) _tmp38_, _tmp42_, TRUE, NULL, NULL, NULL);
				_g_object_unref0 (_tmp42_);
			} else {
				GeeSet* starting_sources = NULL;
				GeeHashSet* _tmp43_;
				GeeSet* _tmp44_;
				Tag* _tmp45_;
				GeeCollection* _tmp46_;
				GeeCollection* _tmp47_;
				_tmp43_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				starting_sources = (GeeSet*) _tmp43_;
				_tmp44_ = starting_sources;
				_tmp45_ = t;
				_tmp46_ = tag_get_sources (_tmp45_);
				_tmp47_ = _tmp46_;
				gee_collection_add_all ((GeeCollection*) _tmp44_, _tmp47_);
				_g_object_unref0 (_tmp47_);
				{
					GeeIterator* _source_it = NULL;
					GeeSet* _tmp48_;
					GeeIterator* _tmp49_;
					_tmp48_ = starting_sources;
					_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
					_source_it = _tmp49_;
					while (TRUE) {
						GeeIterator* _tmp50_;
						MediaSource* source = NULL;
						GeeIterator* _tmp51_;
						gpointer _tmp52_;
						GeeMap* _tmp53_;
						const gchar* _tmp54_;
						gpointer _tmp55_;
						GeeSet* _tmp56_;
						MediaSource* _tmp57_;
						gboolean _tmp58_;
						_tmp50_ = _source_it;
						if (!gee_iterator_next (_tmp50_)) {
							break;
						}
						_tmp51_ = _source_it;
						_tmp52_ = gee_iterator_get (_tmp51_);
						source = (MediaSource*) _tmp52_;
						_tmp53_ = self->priv->existing_dest_child_structure;
						_tmp54_ = child_subpath;
						_tmp55_ = gee_map_get (_tmp53_, _tmp54_);
						_tmp56_ = (GeeSet*) _tmp55_;
						_tmp57_ = source;
						_tmp58_ = !gee_collection_contains ((GeeCollection*) _tmp56_, _tmp57_);
						_g_object_unref0 (_tmp56_);
						if (_tmp58_) {
							Tag* _tmp59_;
							MediaSource* _tmp60_;
							GeeList* _tmp61_;
							GeeList* _tmp62_;
							_tmp59_ = t;
							_tmp60_ = source;
							_tmp61_ = tag_detach (_tmp59_, _tmp60_);
							_tmp62_ = _tmp61_;
							_g_object_unref0 (_tmp62_);
						}
						_g_object_unref0 (source);
					}
					_g_object_unref0 (_source_it);
				}
				_g_object_unref0 (starting_sources);
			}
			_g_free0 (child_subpath);
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_list);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				GeeList* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				GeeList* _tmp68_;
				gpointer _tmp69_;
				SourceProxy* _tmp70_;
				DataSource* _tmp71_;
				DataSource* _tmp72_;
				if (!_tmp63_) {
					gint _tmp64_;
					_tmp64_ = i;
					i = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp65_ = self->priv->src_before_state;
				_tmp66_ = gee_collection_get_size ((GeeCollection*) _tmp65_);
				_tmp67_ = _tmp66_;
				if (!(i < _tmp67_)) {
					break;
				}
				_tmp68_ = self->priv->src_before_state;
				_tmp69_ = gee_list_get (_tmp68_, i);
				_tmp70_ = (SourceProxy*) _tmp69_;
				_tmp71_ = source_proxy_get_source (_tmp70_);
				_tmp72_ = _tmp71_;
				_g_object_unref0 (_tmp72_);
				_source_proxy_unref0 (_tmp70_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp73_ = FALSE;
			_tmp73_ = TRUE;
			while (TRUE) {
				GeeList* _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				GeeList* _tmp78_;
				gpointer _tmp79_;
				SourceProxy* _tmp80_;
				DataSource* _tmp81_;
				DataSource* _tmp82_;
				if (!_tmp73_) {
					gint _tmp74_;
					_tmp74_ = i;
					i = _tmp74_ + 1;
				}
				_tmp73_ = FALSE;
				_tmp75_ = self->priv->dest_before_state;
				_tmp76_ = gee_collection_get_size ((GeeCollection*) _tmp75_);
				_tmp77_ = _tmp76_;
				if (!(i < _tmp77_)) {
					break;
				}
				_tmp78_ = self->priv->dest_before_state;
				_tmp79_ = gee_list_get (_tmp78_, i);
				_tmp80_ = (SourceProxy*) _tmp79_;
				_tmp81_ = source_proxy_get_source (_tmp80_);
				_tmp82_ = _tmp81_;
				_g_object_unref0 (_tmp82_);
				_source_proxy_unref0 (_tmp80_);
			}
		}
	}
	_tmp83_ = self->priv->to_path_parent_path;
	if (_tmp83_ != NULL) {
		gchar* new_path = NULL;
		const gchar* _tmp84_;
		gchar* _tmp85_;
		const gchar* _tmp86_ = NULL;
		const gchar* _tmp87_;
		gchar* path = NULL;
		gchar* _tmp90_;
		TagSourceCollection* _tmp91_;
		const gchar* _tmp92_;
		Tag* t = NULL;
		const gchar* _tmp93_;
		Tag* _tmp94_;
		GeeList* kids = NULL;
		Tag* _tmp95_;
		GeeList* _tmp96_;
		const gchar* _tmp111_;
		GeeMap* _tmp112_;
		_tmp84_ = self->priv->to_path_parent_path;
		_tmp85_ = hierarchical_tag_utilities_get_root_path_form (_tmp84_);
		new_path = _tmp85_;
		_tmp87_ = new_path;
		if (_tmp87_ != NULL) {
			const gchar* _tmp88_;
			_tmp88_ = new_path;
			_tmp86_ = _tmp88_;
		} else {
			const gchar* _tmp89_;
			_tmp89_ = self->priv->to_path_parent_path;
			_tmp86_ = _tmp89_;
		}
		_tmp90_ = g_strdup (_tmp86_);
		path = _tmp90_;
		_tmp91_ = tag_global;
		_tmp92_ = path;
		_vala_assert (tag_source_collection_exists (_tmp91_, _tmp92_, FALSE), "Tag.global.exists (path)");
		_tmp93_ = path;
		_tmp94_ = tag_for_path (_tmp93_);
		t = _tmp94_;
		_tmp95_ = t;
		_tmp96_ = tag_get_hierarchical_children (_tmp95_);
		kids = _tmp96_;
		{
			GeeList* _kidtag_list = NULL;
			GeeList* _tmp97_;
			gint _kidtag_size = 0;
			GeeList* _tmp98_;
			gint _tmp99_;
			gint _tmp100_;
			gint _kidtag_index = 0;
			_tmp97_ = kids;
			_kidtag_list = _tmp97_;
			_tmp98_ = _kidtag_list;
			_tmp99_ = gee_collection_get_size ((GeeCollection*) _tmp98_);
			_tmp100_ = _tmp99_;
			_kidtag_size = _tmp100_;
			_kidtag_index = -1;
			while (TRUE) {
				gint _tmp101_;
				gint _tmp102_;
				Tag* kidtag = NULL;
				GeeList* _tmp103_;
				gpointer _tmp104_;
				Tag* _tmp105_;
				Tag* _tmp106_;
				GeeCollection* _tmp107_;
				GeeCollection* _tmp108_;
				GeeMultiMap* _tmp109_;
				GeeMultiMap* _tmp110_;
				_kidtag_index = _kidtag_index + 1;
				_tmp101_ = _kidtag_index;
				_tmp102_ = _kidtag_size;
				if (!(_tmp101_ < _tmp102_)) {
					break;
				}
				_tmp103_ = _kidtag_list;
				_tmp104_ = gee_list_get (_tmp103_, _kidtag_index);
				kidtag = (Tag*) _tmp104_;
				_tmp105_ = kidtag;
				_tmp106_ = kidtag;
				_tmp107_ = tag_get_sources (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = tag_detach_many (_tmp105_, _tmp108_);
				_tmp110_ = _tmp109_;
				_g_object_unref0 (_tmp110_);
				_g_object_unref0 (_tmp108_);
				_g_object_unref0 (kidtag);
			}
		}
		_tmp111_ = path;
		_tmp112_ = self->priv->existing_dest_child_structure;
		reparent_tag_command_restore_child_attachments_at (self, _tmp111_, _tmp112_);
		_g_object_unref0 (kids);
		_g_object_unref0 (t);
		_g_free0 (path);
		_g_free0 (new_path);
	} else {
		GeeSet* _tmp113_;
		const gchar* _tmp114_;
		Tag* _tmp115_;
		Tag* _tmp116_;
		const gchar* _tmp117_;
		Tag* _tmp118_;
		Tag* _tmp119_;
		GeeCollection* _tmp120_;
		GeeCollection* _tmp121_;
		GeeMultiMap* _tmp122_;
		GeeMultiMap* _tmp123_;
		const gchar* _tmp124_;
		Tag* _tmp125_;
		Tag* _tmp126_;
		GeeSet* _tmp127_;
		GeeList* kids = NULL;
		const gchar* _tmp128_;
		Tag* _tmp129_;
		Tag* _tmp130_;
		GeeList* _tmp131_;
		GeeList* _tmp132_;
		const gchar* _tmp147_;
		GeeMap* _tmp148_;
		_tmp113_ = self->priv->existing_dest_membership;
		_vala_assert (_tmp113_ != NULL, "existing_dest_membership != null");
		_tmp114_ = self->priv->to_path;
		_tmp115_ = tag_for_path (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = self->priv->to_path;
		_tmp118_ = tag_for_path (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = tag_get_sources (_tmp119_);
		_tmp121_ = _tmp120_;
		_tmp122_ = tag_detach_many (_tmp116_, _tmp121_);
		_tmp123_ = _tmp122_;
		_g_object_unref0 (_tmp123_);
		_g_object_unref0 (_tmp121_);
		_g_object_unref0 (_tmp119_);
		_g_object_unref0 (_tmp116_);
		_tmp124_ = self->priv->to_path;
		_tmp125_ = tag_for_path (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = self->priv->existing_dest_membership;
		tag_attach_many (_tmp126_, (GeeCollection*) _tmp127_);
		_g_object_unref0 (_tmp126_);
		_tmp128_ = self->priv->to_path;
		_tmp129_ = tag_for_path (_tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = tag_get_hierarchical_children (_tmp130_);
		_tmp132_ = _tmp131_;
		_g_object_unref0 (_tmp130_);
		kids = _tmp132_;
		{
			GeeList* _kidtag_list = NULL;
			GeeList* _tmp133_;
			gint _kidtag_size = 0;
			GeeList* _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			gint _kidtag_index = 0;
			_tmp133_ = kids;
			_kidtag_list = _tmp133_;
			_tmp134_ = _kidtag_list;
			_tmp135_ = gee_collection_get_size ((GeeCollection*) _tmp134_);
			_tmp136_ = _tmp135_;
			_kidtag_size = _tmp136_;
			_kidtag_index = -1;
			while (TRUE) {
				gint _tmp137_;
				gint _tmp138_;
				Tag* kidtag = NULL;
				GeeList* _tmp139_;
				gpointer _tmp140_;
				Tag* _tmp141_;
				Tag* _tmp142_;
				GeeCollection* _tmp143_;
				GeeCollection* _tmp144_;
				GeeMultiMap* _tmp145_;
				GeeMultiMap* _tmp146_;
				_kidtag_index = _kidtag_index + 1;
				_tmp137_ = _kidtag_index;
				_tmp138_ = _kidtag_size;
				if (!(_tmp137_ < _tmp138_)) {
					break;
				}
				_tmp139_ = _kidtag_list;
				_tmp140_ = gee_list_get (_tmp139_, _kidtag_index);
				kidtag = (Tag*) _tmp140_;
				_tmp141_ = kidtag;
				_tmp142_ = kidtag;
				_tmp143_ = tag_get_sources (_tmp142_);
				_tmp144_ = _tmp143_;
				_tmp145_ = tag_detach_many (_tmp141_, _tmp144_);
				_tmp146_ = _tmp145_;
				_g_object_unref0 (_tmp146_);
				_g_object_unref0 (_tmp144_);
				_g_object_unref0 (kidtag);
			}
		}
		_tmp147_ = self->priv->to_path;
		_tmp148_ = self->priv->existing_dest_child_structure;
		reparent_tag_command_restore_child_attachments_at (self, _tmp147_, _tmp148_);
		_g_object_unref0 (kids);
	}
	_g_free0 (unwind_target);
}

static void
reparent_tag_command_save_after_state (ReparentTagCommand* self)
{
	GeeList* _tmp0_;
	GeeArrayList* _tmp1_;
	TagSourceCollection* _tmp2_;
	const gchar* _tmp3_;
	Tag* to_tag = NULL;
	const gchar* _tmp4_;
	Tag* _tmp5_;
	GeeList* _tmp6_;
	Tag* _tmp7_;
	SourceProxy* _tmp8_;
	SourceProxy* _tmp9_;
	GeeList* to_children = NULL;
	Tag* _tmp10_;
	GeeList* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->after_state;
	_vala_assert (_tmp0_ == NULL, "after_state == null");
	_tmp1_ = gee_array_list_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->after_state);
	self->priv->after_state = (GeeList*) _tmp1_;
	_tmp2_ = tag_global;
	_tmp3_ = self->priv->to_path;
	_vala_assert (tag_source_collection_exists (_tmp2_, _tmp3_, FALSE), "Tag.global.exists (to_path)");
	_tmp4_ = self->priv->to_path;
	_tmp5_ = tag_for_path (_tmp4_);
	to_tag = _tmp5_;
	_tmp6_ = self->priv->after_state;
	_tmp7_ = to_tag;
	_tmp8_ = proxyable_get_proxy ((Proxyable*) _tmp7_);
	_tmp9_ = _tmp8_;
	gee_collection_add ((GeeCollection*) _tmp6_, _tmp9_);
	_source_proxy_unref0 (_tmp9_);
	_tmp10_ = to_tag;
	_tmp11_ = tag_get_hierarchical_children (_tmp10_);
	to_children = _tmp11_;
	{
		gint i = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = to_children;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		i = _tmp14_ - 1;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				GeeList* _tmp17_;
				GeeList* _tmp18_;
				gpointer _tmp19_;
				Tag* _tmp20_;
				SourceProxy* _tmp21_;
				SourceProxy* _tmp22_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ - 1;
				}
				_tmp15_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp17_ = self->priv->after_state;
				_tmp18_ = to_children;
				_tmp19_ = gee_list_get (_tmp18_, i);
				_tmp20_ = (Tag*) _tmp19_;
				_tmp21_ = proxyable_get_proxy ((Proxyable*) _tmp20_);
				_tmp22_ = _tmp21_;
				gee_collection_add ((GeeCollection*) _tmp17_, _tmp22_);
				_source_proxy_unref0 (_tmp22_);
				_g_object_unref0 (_tmp20_);
			}
		}
	}
	_g_object_unref0 (to_children);
	_g_object_unref0 (to_tag);
}

static void
reparent_tag_command_restore_after_state (ReparentTagCommand* self)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->after_state;
	_vala_assert (_tmp0_ != NULL, "after_state != null");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GeeList* _tmp6_;
				gpointer _tmp7_;
				SourceProxy* _tmp8_;
				DataSource* _tmp9_;
				DataSource* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->after_state;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->after_state;
				_tmp7_ = gee_list_get (_tmp6_, i);
				_tmp8_ = (SourceProxy*) _tmp7_;
				_tmp9_ = source_proxy_get_source (_tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp10_);
				_source_proxy_unref0 (_tmp8_);
			}
		}
	}
}

static void
reparent_tag_command_prepare_parent (ReparentTagCommand* self,
                                     const gchar* path)
{
	Tag* new_parent = NULL;
	Tag* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	new_parent = NULL;
	if (g_str_has_prefix (path, TAG_PATH_SEPARATOR_STRING)) {
		GeeList* parent_paths = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = hierarchical_tag_utilities_enumerate_parent_paths (path);
		parent_paths = _tmp0_;
		_tmp1_ = parent_paths;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ > 0) {
			gchar* immediate_parent_path = NULL;
			GeeList* _tmp4_;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			TagSourceCollection* _tmp9_;
			const gchar* _tmp10_;
			_tmp4_ = parent_paths;
			_tmp5_ = parent_paths;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_list_get (_tmp4_, _tmp7_ - 1);
			immediate_parent_path = (gchar*) _tmp8_;
			_tmp9_ = tag_global;
			_tmp10_ = immediate_parent_path;
			if (tag_source_collection_exists (_tmp9_, _tmp10_, FALSE)) {
				const gchar* _tmp11_;
				Tag* _tmp12_;
				_tmp11_ = immediate_parent_path;
				_tmp12_ = tag_for_path (_tmp11_);
				_g_object_unref0 (new_parent);
				new_parent = _tmp12_;
			} else {
				TagSourceCollection* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gboolean _tmp17_;
				_tmp13_ = tag_global;
				_tmp14_ = immediate_parent_path;
				_tmp15_ = string_substring (_tmp14_, (glong) 1, (glong) -1);
				_tmp16_ = _tmp15_;
				_tmp17_ = tag_source_collection_exists (_tmp13_, _tmp16_, FALSE);
				_g_free0 (_tmp16_);
				if (_tmp17_) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					Tag* _tmp21_;
					_tmp18_ = immediate_parent_path;
					_tmp19_ = string_substring (_tmp18_, (glong) 1, (glong) -1);
					_tmp20_ = _tmp19_;
					_tmp21_ = tag_for_path (_tmp20_);
					_g_object_unref0 (new_parent);
					new_parent = _tmp21_;
					_g_free0 (_tmp20_);
				} else {
					g_assert_not_reached ();
				}
			}
			_g_free0 (immediate_parent_path);
		}
		_g_object_unref0 (parent_paths);
	}
	_tmp22_ = new_parent;
	if (_tmp22_ != NULL) {
		Tag* _tmp23_;
		_tmp23_ = new_parent;
		tag_promote (_tmp23_);
	}
	_g_object_unref0 (new_parent);
}

static void
reparent_tag_command_do_source_parent_detachments (ReparentTagCommand* self)
{
	TagSourceCollection* _tmp0_;
	const gchar* _tmp1_;
	Tag* from_tag = NULL;
	const gchar* _tmp2_;
	Tag* _tmp3_;
	GeeMap* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tag_global;
	_tmp1_ = self->priv->from_path;
	_vala_assert (tag_source_collection_exists (_tmp0_, _tmp1_, FALSE), "Tag.global.exists (from_path)");
	_tmp2_ = self->priv->from_path;
	_tmp3_ = tag_for_path (_tmp2_);
	from_tag = _tmp3_;
	_tmp4_ = self->priv->src_parent_detachments;
	if (_tmp4_ == NULL) {
		GeeHashMap* _tmp5_;
		_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->src_parent_detachments);
		self->priv->src_parent_detachments = (GeeMap*) _tmp5_;
		{
			GeeIterator* _source_it = NULL;
			Tag* _tmp6_;
			GeeCollection* _tmp7_;
			GeeCollection* _tmp8_;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp6_ = from_tag;
			_tmp7_ = tag_get_sources (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_source_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				MediaSource* source = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				Tag* current_parent = NULL;
				Tag* _tmp14_;
				Tag* _tmp15_;
				gint running_attach_count = 0;
				Tag* _tmp16_;
				MediaSource* _tmp17_;
				_tmp11_ = _source_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _source_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				source = (MediaSource*) _tmp13_;
				_tmp14_ = from_tag;
				_tmp15_ = tag_get_hierarchical_parent (_tmp14_);
				current_parent = _tmp15_;
				_tmp16_ = from_tag;
				_tmp17_ = source;
				running_attach_count = tag_get_attachment_count (_tmp16_, _tmp17_) + 1;
				while (TRUE) {
					Tag* _tmp18_;
					gchar* current_parent_path = NULL;
					Tag* _tmp19_;
					gchar* _tmp20_;
					GeeMap* _tmp21_;
					const gchar* _tmp22_;
					gint curr_parent_attach_count = 0;
					Tag* _tmp27_;
					MediaSource* _tmp28_;
					gint _tmp34_;
					Tag* _tmp35_;
					Tag* _tmp36_;
					_tmp18_ = current_parent;
					if (!(_tmp18_ != NULL)) {
						break;
					}
					_tmp19_ = current_parent;
					_tmp20_ = tag_get_path (_tmp19_);
					current_parent_path = _tmp20_;
					_tmp21_ = self->priv->src_parent_detachments;
					_tmp22_ = current_parent_path;
					if (!gee_map_has_key (_tmp21_, _tmp22_)) {
						GeeMap* _tmp23_;
						const gchar* _tmp24_;
						GeeHashSet* _tmp25_;
						GeeHashSet* _tmp26_;
						_tmp23_ = self->priv->src_parent_detachments;
						_tmp24_ = current_parent_path;
						_tmp25_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
						_tmp26_ = _tmp25_;
						gee_map_set (_tmp23_, _tmp24_, (GeeSet*) _tmp26_);
						_g_object_unref0 (_tmp26_);
					}
					_tmp27_ = current_parent;
					_tmp28_ = source;
					curr_parent_attach_count = tag_get_attachment_count (_tmp27_, _tmp28_);
					_vala_assert (curr_parent_attach_count >= running_attach_count, "curr_parent_attach_count >= running_attach_count");
					if (curr_parent_attach_count == running_attach_count) {
						GeeMap* _tmp29_;
						const gchar* _tmp30_;
						gpointer _tmp31_;
						GeeSet* _tmp32_;
						MediaSource* _tmp33_;
						_tmp29_ = self->priv->src_parent_detachments;
						_tmp30_ = current_parent_path;
						_tmp31_ = gee_map_get (_tmp29_, _tmp30_);
						_tmp32_ = (GeeSet*) _tmp31_;
						_tmp33_ = source;
						gee_collection_add ((GeeCollection*) _tmp32_, _tmp33_);
						_g_object_unref0 (_tmp32_);
					}
					_tmp34_ = running_attach_count;
					running_attach_count = _tmp34_ + 1;
					_tmp35_ = current_parent;
					_tmp36_ = tag_get_hierarchical_parent (_tmp35_);
					_g_object_unref0 (current_parent);
					current_parent = _tmp36_;
					_g_free0 (current_parent_path);
				}
				_g_object_unref0 (current_parent);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	{
		GeeIterator* _p_it = NULL;
		GeeMap* _tmp37_;
		GeeSet* _tmp38_;
		GeeSet* _tmp39_;
		GeeSet* _tmp40_;
		GeeIterator* _tmp41_;
		GeeIterator* _tmp42_;
		_tmp37_ = self->priv->src_parent_detachments;
		_tmp38_ = gee_map_get_keys (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp39_;
		_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
		_tmp42_ = _tmp41_;
		_g_object_unref0 (_tmp40_);
		_p_it = _tmp42_;
		while (TRUE) {
			GeeIterator* _tmp43_;
			gchar* p = NULL;
			GeeIterator* _tmp44_;
			gpointer _tmp45_;
			_tmp43_ = _p_it;
			if (!gee_iterator_next (_tmp43_)) {
				break;
			}
			_tmp44_ = _p_it;
			_tmp45_ = gee_iterator_get (_tmp44_);
			p = (gchar*) _tmp45_;
			{
				GeeIterator* _s_it = NULL;
				GeeMap* _tmp46_;
				const gchar* _tmp47_;
				gpointer _tmp48_;
				GeeSet* _tmp49_;
				GeeIterator* _tmp50_;
				GeeIterator* _tmp51_;
				_tmp46_ = self->priv->src_parent_detachments;
				_tmp47_ = p;
				_tmp48_ = gee_map_get (_tmp46_, _tmp47_);
				_tmp49_ = (GeeSet*) _tmp48_;
				_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
				_tmp51_ = _tmp50_;
				_g_object_unref0 (_tmp49_);
				_s_it = _tmp51_;
				while (TRUE) {
					GeeIterator* _tmp52_;
					MediaSource* s = NULL;
					GeeIterator* _tmp53_;
					gpointer _tmp54_;
					const gchar* _tmp55_;
					Tag* _tmp56_;
					Tag* _tmp57_;
					MediaSource* _tmp58_;
					GeeList* _tmp59_;
					GeeList* _tmp60_;
					_tmp52_ = _s_it;
					if (!gee_iterator_next (_tmp52_)) {
						break;
					}
					_tmp53_ = _s_it;
					_tmp54_ = gee_iterator_get (_tmp53_);
					s = (MediaSource*) _tmp54_;
					_tmp55_ = p;
					_tmp56_ = tag_for_path (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = s;
					_tmp59_ = tag_detach (_tmp57_, _tmp58_);
					_tmp60_ = _tmp59_;
					_g_object_unref0 (_tmp60_);
					_g_object_unref0 (_tmp57_);
					_g_object_unref0 (s);
				}
				_g_object_unref0 (_s_it);
			}
			_g_free0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_g_object_unref0 (from_tag);
}

static void
reparent_tag_command_do_source_parent_reattachments (ReparentTagCommand* self)
{
	GeeMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->src_parent_detachments;
	_vala_assert (_tmp0_ != NULL, "src_parent_detachments != null");
	{
		GeeIterator* _p_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->src_parent_detachments;
		_tmp2_ = gee_map_get_keys (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_p_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* p = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			_tmp7_ = _p_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _p_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			p = (gchar*) _tmp9_;
			{
				GeeIterator* _s_it = NULL;
				GeeMap* _tmp10_;
				const gchar* _tmp11_;
				gpointer _tmp12_;
				GeeSet* _tmp13_;
				GeeIterator* _tmp14_;
				GeeIterator* _tmp15_;
				_tmp10_ = self->priv->src_parent_detachments;
				_tmp11_ = p;
				_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
				_tmp13_ = (GeeSet*) _tmp12_;
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
				_tmp15_ = _tmp14_;
				_g_object_unref0 (_tmp13_);
				_s_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					MediaSource* s = NULL;
					GeeIterator* _tmp17_;
					gpointer _tmp18_;
					const gchar* _tmp19_;
					Tag* _tmp20_;
					Tag* _tmp21_;
					MediaSource* _tmp22_;
					_tmp16_ = _s_it;
					if (!gee_iterator_next (_tmp16_)) {
						break;
					}
					_tmp17_ = _s_it;
					_tmp18_ = gee_iterator_get (_tmp17_);
					s = (MediaSource*) _tmp18_;
					_tmp19_ = p;
					_tmp20_ = tag_for_path (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = s;
					tag_attach (_tmp21_, _tmp22_);
					_g_object_unref0 (_tmp21_);
					_g_object_unref0 (s);
				}
				_g_object_unref0 (_s_it);
			}
			_g_free0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}

static void
reparent_tag_command_do_destination_parent_detachments (ReparentTagCommand* self)
{
	GeeMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dest_parent_attachments;
	_vala_assert (_tmp0_ != NULL, "dest_parent_attachments != null");
	{
		GeeIterator* _p_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->dest_parent_attachments;
		_tmp2_ = gee_map_get_keys (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_p_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* p = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			_tmp7_ = _p_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _p_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			p = (gchar*) _tmp9_;
			{
				GeeIterator* _s_it = NULL;
				GeeMap* _tmp10_;
				const gchar* _tmp11_;
				gpointer _tmp12_;
				GeeSet* _tmp13_;
				GeeIterator* _tmp14_;
				GeeIterator* _tmp15_;
				_tmp10_ = self->priv->dest_parent_attachments;
				_tmp11_ = p;
				_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
				_tmp13_ = (GeeSet*) _tmp12_;
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
				_tmp15_ = _tmp14_;
				_g_object_unref0 (_tmp13_);
				_s_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					MediaSource* s = NULL;
					GeeIterator* _tmp17_;
					gpointer _tmp18_;
					const gchar* _tmp19_;
					Tag* _tmp20_;
					Tag* _tmp21_;
					MediaSource* _tmp22_;
					GeeList* _tmp23_;
					GeeList* _tmp24_;
					_tmp16_ = _s_it;
					if (!gee_iterator_next (_tmp16_)) {
						break;
					}
					_tmp17_ = _s_it;
					_tmp18_ = gee_iterator_get (_tmp17_);
					s = (MediaSource*) _tmp18_;
					_tmp19_ = p;
					_tmp20_ = tag_for_path (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = s;
					_tmp23_ = tag_detach (_tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					_g_object_unref0 (_tmp24_);
					_g_object_unref0 (_tmp21_);
					_g_object_unref0 (s);
				}
				_g_object_unref0 (_s_it);
			}
			_g_free0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}

static void
reparent_tag_command_do_destination_parent_reattachments (ReparentTagCommand* self)
{
	GeeMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dest_parent_attachments;
	_vala_assert (_tmp0_ != NULL, "dest_parent_attachments != null");
	{
		GeeIterator* _p_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->dest_parent_attachments;
		_tmp2_ = gee_map_get_keys (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_p_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* p = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			_tmp7_ = _p_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _p_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			p = (gchar*) _tmp9_;
			{
				GeeIterator* _s_it = NULL;
				GeeMap* _tmp10_;
				const gchar* _tmp11_;
				gpointer _tmp12_;
				GeeSet* _tmp13_;
				GeeIterator* _tmp14_;
				GeeIterator* _tmp15_;
				_tmp10_ = self->priv->dest_parent_attachments;
				_tmp11_ = p;
				_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
				_tmp13_ = (GeeSet*) _tmp12_;
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
				_tmp15_ = _tmp14_;
				_g_object_unref0 (_tmp13_);
				_s_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					MediaSource* s = NULL;
					GeeIterator* _tmp17_;
					gpointer _tmp18_;
					const gchar* _tmp19_;
					Tag* _tmp20_;
					Tag* _tmp21_;
					MediaSource* _tmp22_;
					_tmp16_ = _s_it;
					if (!gee_iterator_next (_tmp16_)) {
						break;
					}
					_tmp17_ = _s_it;
					_tmp18_ = gee_iterator_get (_tmp17_);
					s = (MediaSource*) _tmp18_;
					_tmp19_ = p;
					_tmp20_ = tag_for_path (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = s;
					tag_attach (_tmp21_, _tmp22_);
					_g_object_unref0 (_tmp21_);
					_g_object_unref0 (s);
				}
				_g_object_unref0 (_s_it);
			}
			_g_free0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}

static void
reparent_tag_command_copy_subtree (ReparentTagCommand* self,
                                   const gchar* from,
                                   const gchar* to)
{
	TagSourceCollection* _tmp0_;
	Tag* from_tag = NULL;
	Tag* _tmp1_;
	Tag* to_tag = NULL;
	Tag* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeList* from_children = NULL;
	Tag* _tmp42_;
	GeeList* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = tag_global;
	_vala_assert (tag_source_collection_exists (_tmp0_, from, FALSE), "Tag.global.exists (from)");
	_tmp1_ = tag_for_path (from);
	from_tag = _tmp1_;
	_tmp2_ = tag_for_path (to);
	to_tag = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->dest_parent_attachments);
	self->priv->dest_parent_attachments = (GeeMap*) _tmp3_;
	{
		GeeIterator* _source_it = NULL;
		Tag* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp4_ = from_tag;
		_tmp5_ = tag_get_sources (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_source_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			MediaSource* source = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			Tag* current_parent = NULL;
			Tag* _tmp12_;
			Tag* _tmp13_;
			_tmp9_ = _source_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _source_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			source = (MediaSource*) _tmp11_;
			_tmp12_ = to_tag;
			_tmp13_ = tag_get_hierarchical_parent (_tmp12_);
			current_parent = _tmp13_;
			while (TRUE) {
				Tag* _tmp14_;
				gchar* current_parent_path = NULL;
				Tag* _tmp15_;
				gchar* _tmp16_;
				GeeMap* _tmp17_;
				const gchar* _tmp18_;
				Tag* _tmp23_;
				MediaSource* _tmp24_;
				Tag* _tmp30_;
				Tag* _tmp31_;
				_tmp14_ = current_parent;
				if (!(_tmp14_ != NULL)) {
					break;
				}
				_tmp15_ = current_parent;
				_tmp16_ = tag_get_path (_tmp15_);
				current_parent_path = _tmp16_;
				_tmp17_ = self->priv->dest_parent_attachments;
				_tmp18_ = current_parent_path;
				if (!gee_map_has_key (_tmp17_, _tmp18_)) {
					GeeMap* _tmp19_;
					const gchar* _tmp20_;
					GeeHashSet* _tmp21_;
					GeeHashSet* _tmp22_;
					_tmp19_ = self->priv->dest_parent_attachments;
					_tmp20_ = current_parent_path;
					_tmp21_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
					_tmp22_ = _tmp21_;
					gee_map_set (_tmp19_, _tmp20_, (GeeSet*) _tmp22_);
					_g_object_unref0 (_tmp22_);
				}
				_tmp23_ = current_parent;
				_tmp24_ = source;
				if (!tag_contains (_tmp23_, _tmp24_)) {
					GeeMap* _tmp25_;
					const gchar* _tmp26_;
					gpointer _tmp27_;
					GeeSet* _tmp28_;
					MediaSource* _tmp29_;
					_tmp25_ = self->priv->dest_parent_attachments;
					_tmp26_ = current_parent_path;
					_tmp27_ = gee_map_get (_tmp25_, _tmp26_);
					_tmp28_ = (GeeSet*) _tmp27_;
					_tmp29_ = source;
					gee_collection_add ((GeeCollection*) _tmp28_, _tmp29_);
					_g_object_unref0 (_tmp28_);
				}
				_tmp30_ = current_parent;
				_tmp31_ = tag_get_hierarchical_parent (_tmp30_);
				_g_object_unref0 (current_parent);
				current_parent = _tmp31_;
				_g_free0 (current_parent_path);
			}
			_g_object_unref0 (current_parent);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	{
		GeeIterator* _source_it = NULL;
		Tag* _tmp32_;
		GeeCollection* _tmp33_;
		GeeCollection* _tmp34_;
		GeeIterator* _tmp35_;
		GeeIterator* _tmp36_;
		_tmp32_ = from_tag;
		_tmp33_ = tag_get_sources (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = gee_iterable_iterator ((GeeIterable*) _tmp34_);
		_tmp36_ = _tmp35_;
		_g_object_unref0 (_tmp34_);
		_source_it = _tmp36_;
		while (TRUE) {
			GeeIterator* _tmp37_;
			MediaSource* source = NULL;
			GeeIterator* _tmp38_;
			gpointer _tmp39_;
			Tag* _tmp40_;
			MediaSource* _tmp41_;
			_tmp37_ = _source_it;
			if (!gee_iterator_next (_tmp37_)) {
				break;
			}
			_tmp38_ = _source_it;
			_tmp39_ = gee_iterator_get (_tmp38_);
			source = (MediaSource*) _tmp39_;
			_tmp40_ = to_tag;
			_tmp41_ = source;
			tag_attach (_tmp40_, _tmp41_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp42_ = from_tag;
	_tmp43_ = tag_get_hierarchical_children (_tmp42_);
	from_children = _tmp43_;
	{
		gint i = 0;
		GeeList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		_tmp44_ = from_children;
		_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		i = _tmp46_ - 1;
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				Tag* from_child = NULL;
				GeeList* _tmp49_;
				gpointer _tmp50_;
				gchar* child_subpath = NULL;
				Tag* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				Tag* to_child = NULL;
				Tag* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				Tag* _tmp66_;
				Tag* _tmp67_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ - 1;
				}
				_tmp47_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp49_ = from_children;
				_tmp50_ = gee_list_get (_tmp49_, i);
				from_child = (Tag*) _tmp50_;
				_tmp51_ = from_child;
				_tmp52_ = tag_get_path (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strconcat (from, TAG_PATH_SEPARATOR_STRING, NULL);
				_tmp55_ = _tmp54_;
				_tmp56_ = string_replace (_tmp53_, _tmp55_, "");
				_tmp57_ = _tmp56_;
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				child_subpath = _tmp57_;
				_tmp58_ = to_tag;
				_tmp59_ = tag_get_path (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strconcat (_tmp60_, TAG_PATH_SEPARATOR_STRING, NULL);
				_tmp62_ = _tmp61_;
				_tmp63_ = child_subpath;
				_tmp64_ = g_strconcat (_tmp62_, _tmp63_, NULL);
				_tmp65_ = _tmp64_;
				_tmp66_ = tag_for_path (_tmp65_);
				_tmp67_ = _tmp66_;
				_g_free0 (_tmp65_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				to_child = _tmp67_;
				{
					GeeIterator* _source_it = NULL;
					Tag* _tmp68_;
					GeeCollection* _tmp69_;
					GeeCollection* _tmp70_;
					GeeIterator* _tmp71_;
					GeeIterator* _tmp72_;
					_tmp68_ = from_child;
					_tmp69_ = tag_get_sources (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = gee_iterable_iterator ((GeeIterable*) _tmp70_);
					_tmp72_ = _tmp71_;
					_g_object_unref0 (_tmp70_);
					_source_it = _tmp72_;
					while (TRUE) {
						GeeIterator* _tmp73_;
						MediaSource* source = NULL;
						GeeIterator* _tmp74_;
						gpointer _tmp75_;
						Tag* _tmp76_;
						MediaSource* _tmp77_;
						_tmp73_ = _source_it;
						if (!gee_iterator_next (_tmp73_)) {
							break;
						}
						_tmp74_ = _source_it;
						_tmp75_ = gee_iterator_get (_tmp74_);
						source = (MediaSource*) _tmp75_;
						_tmp76_ = to_child;
						_tmp77_ = source;
						tag_attach (_tmp76_, _tmp77_);
						_g_object_unref0 (source);
					}
					_g_object_unref0 (_source_it);
				}
				_g_object_unref0 (to_child);
				_g_free0 (child_subpath);
				_g_object_unref0 (from_child);
			}
		}
	}
	_g_object_unref0 (from_children);
	_g_object_unref0 (to_tag);
	_g_object_unref0 (from_tag);
}

static void
reparent_tag_command_destroy_subtree (ReparentTagCommand* self,
                                      const gchar* client_path)
{
	gchar* victim_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	TagSourceCollection* _tmp3_;
	const gchar* _tmp4_;
	Tag* victim = NULL;
	const gchar* _tmp5_;
	Tag* _tmp6_;
	GeeList* victim_children = NULL;
	Tag* _tmp7_;
	GeeList* _tmp8_;
	TagSourceCollection* _tmp21_;
	TagSourceCollection* _tmp22_;
	Tag* _tmp23_;
	Marker* _tmp24_;
	Marker* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client_path != NULL);
	_tmp0_ = hierarchical_tag_utilities_get_root_path_form (client_path);
	victim_path = _tmp0_;
	_tmp1_ = victim_path;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (client_path);
		_g_free0 (victim_path);
		victim_path = _tmp2_;
	}
	_tmp3_ = tag_global;
	_tmp4_ = victim_path;
	if (!tag_source_collection_exists (_tmp3_, _tmp4_, FALSE)) {
		_g_free0 (victim_path);
		return;
	}
	_tmp5_ = victim_path;
	_tmp6_ = tag_for_path (_tmp5_);
	victim = _tmp6_;
	_tmp7_ = victim;
	_tmp8_ = tag_get_hierarchical_children (_tmp7_);
	victim_children = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GeeList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				TagSourceCollection* _tmp14_;
				TagSourceCollection* _tmp15_;
				GeeList* _tmp16_;
				gpointer _tmp17_;
				Tag* _tmp18_;
				Marker* _tmp19_;
				Marker* _tmp20_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = victim_children;
				_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				if (!(i < _tmp13_)) {
					break;
				}
				_tmp14_ = tag_global;
				_tmp15_ = tag_global;
				_tmp16_ = victim_children;
				_tmp17_ = gee_list_get (_tmp16_, i);
				_tmp18_ = (Tag*) _tmp17_;
				_tmp19_ = data_collection_mark ((DataCollection*) _tmp15_, (DataObject*) _tmp18_);
				_tmp20_ = _tmp19_;
				source_collection_destroy_marked ((SourceCollection*) _tmp14_, _tmp20_, TRUE, NULL, NULL, NULL);
				_g_object_unref0 (_tmp20_);
				_g_object_unref0 (_tmp18_);
			}
		}
	}
	_tmp21_ = tag_global;
	_tmp22_ = tag_global;
	_tmp23_ = victim;
	_tmp24_ = data_collection_mark ((DataCollection*) _tmp22_, (DataObject*) _tmp23_);
	_tmp25_ = _tmp24_;
	source_collection_destroy_marked ((SourceCollection*) _tmp21_, _tmp25_, TRUE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (victim_children);
	_g_object_unref0 (victim);
	_g_free0 (victim_path);
}

static void
reparent_tag_command_real_execute (Command* base)
{
	ReparentTagCommand * self;
	GeeList* _tmp0_;
	self = (ReparentTagCommand*) base;
	_tmp0_ = self->priv->after_state;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		reparent_tag_command_save_before_state (self);
		_tmp1_ = self->priv->to_path;
		reparent_tag_command_prepare_parent (self, _tmp1_);
		_tmp2_ = self->priv->from_path;
		_tmp3_ = self->priv->to_path;
		reparent_tag_command_copy_subtree (self, _tmp2_, _tmp3_);
		reparent_tag_command_save_after_state (self);
		reparent_tag_command_do_source_parent_detachments (self);
		_tmp4_ = self->priv->from_path;
		reparent_tag_command_destroy_subtree (self, _tmp4_);
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GeeMap* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = self->priv->to_path;
		reparent_tag_command_prepare_parent (self, _tmp5_);
		reparent_tag_command_restore_after_state (self);
		_tmp6_ = self->priv->to_path;
		_tmp7_ = self->priv->in_play_child_structure;
		reparent_tag_command_restore_child_attachments_at (self, _tmp6_, _tmp7_);
		_tmp8_ = self->priv->to_path;
		reparent_tag_command_reattach_in_play_sources_at (self, _tmp8_);
		reparent_tag_command_do_source_parent_detachments (self);
		reparent_tag_command_do_destination_parent_reattachments (self);
		_tmp9_ = self->priv->from_path;
		reparent_tag_command_destroy_subtree (self, _tmp9_);
	}
}

static void
reparent_tag_command_real_undo (Command* base)
{
	ReparentTagCommand * self;
	GeeList* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	GeeMap* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	self = (ReparentTagCommand*) base;
	_tmp0_ = self->priv->src_before_state;
	_vala_assert (_tmp0_ != NULL, "src_before_state != null");
	_tmp1_ = self->priv->from_path;
	reparent_tag_command_prepare_parent (self, _tmp1_);
	reparent_tag_command_restore_before_state (self);
	if (!self->priv->to_path_exists) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->to_path;
		reparent_tag_command_destroy_subtree (self, _tmp2_);
	}
	_tmp3_ = self->priv->from_path;
	_tmp4_ = self->priv->in_play_child_structure;
	reparent_tag_command_restore_child_attachments_at (self, _tmp3_, _tmp4_);
	_tmp5_ = self->priv->from_path;
	reparent_tag_command_reattach_in_play_sources_at (self, _tmp5_);
	reparent_tag_command_do_source_parent_reattachments (self);
	reparent_tag_command_do_destination_parent_detachments (self);
	_tmp6_ = self->priv->to_path;
	hierarchical_tag_utilities_cleanup_root_path (_tmp6_);
	_tmp7_ = self->priv->from_path;
	hierarchical_tag_utilities_cleanup_root_path (_tmp7_);
	_tmp8_ = self->priv->to_path_parent_path;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = self->priv->to_path_parent_path;
		hierarchical_tag_utilities_cleanup_root_path (_tmp9_);
	}
}

static void
reparent_tag_command_class_init (ReparentTagCommandClass * klass,
                                 gpointer klass_data)
{
	reparent_tag_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ReparentTagCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) reparent_tag_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) reparent_tag_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = reparent_tag_command_finalize;
}

static void
reparent_tag_command_instance_init (ReparentTagCommand * self,
                                    gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->priv = reparent_tag_command_get_instance_private (self);
	self->priv->src_before_state = NULL;
	self->priv->dest_before_state = NULL;
	self->priv->after_state = NULL;
	_tmp0_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->sources_in_play = _tmp0_;
	self->priv->dest_parent_attachments = NULL;
	self->priv->src_parent_detachments = NULL;
	self->priv->in_play_child_structure = NULL;
	self->priv->existing_dest_child_structure = NULL;
	self->priv->existing_dest_membership = NULL;
	self->priv->to_path_exists = FALSE;
}

static void
reparent_tag_command_finalize (GObject * obj)
{
	ReparentTagCommand * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	VideoSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REPARENT_TAG_COMMAND, ReparentTagCommand);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _reparent_tag_command_on_items_destroyed_source_collection_items_destroyed, self);
	_tmp2_ = video_global;
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _reparent_tag_command_on_items_destroyed_source_collection_items_destroyed, self);
	_g_free0 (self->priv->from_path);
	_g_free0 (self->priv->to_path);
	_g_free0 (self->priv->to_path_parent_path);
	_g_object_unref0 (self->priv->src_before_state);
	_g_object_unref0 (self->priv->dest_before_state);
	_g_object_unref0 (self->priv->after_state);
	_g_object_unref0 (self->priv->sources_in_play);
	_g_object_unref0 (self->priv->dest_parent_attachments);
	_g_object_unref0 (self->priv->src_parent_detachments);
	_g_object_unref0 (self->priv->in_play_child_structure);
	_g_object_unref0 (self->priv->existing_dest_child_structure);
	_g_object_unref0 (self->priv->existing_dest_membership);
	G_OBJECT_CLASS (reparent_tag_command_parent_class)->finalize (obj);
}

static GType
reparent_tag_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ReparentTagCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) reparent_tag_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReparentTagCommand), 0, (GInstanceInitFunc) reparent_tag_command_instance_init, NULL };
	GType reparent_tag_command_type_id;
	reparent_tag_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "ReparentTagCommand", &g_define_type_info, 0);
	ReparentTagCommand_private_offset = g_type_add_instance_private (reparent_tag_command_type_id, sizeof (ReparentTagCommandPrivate));
	return reparent_tag_command_type_id;
}

GType
reparent_tag_command_get_type (void)
{
	static volatile gsize reparent_tag_command_type_id__once = 0;
	if (g_once_init_enter (&reparent_tag_command_type_id__once)) {
		GType reparent_tag_command_type_id;
		reparent_tag_command_type_id = reparent_tag_command_get_type_once ();
		g_once_init_leave (&reparent_tag_command_type_id__once, reparent_tag_command_type_id);
	}
	return reparent_tag_command_type_id__once;
}

static inline gpointer
modify_tags_command_get_instance_private (ModifyTagsCommand* self)
{
	return G_STRUCT_MEMBER_P (self, ModifyTagsCommand_private_offset);
}

static void
_modify_tags_command_on_proxy_broken_source_proxy_broken (SourceProxy* _sender,
                                                          gpointer self)
{
	modify_tags_command_on_proxy_broken ((ModifyTagsCommand*) self);
}

ModifyTagsCommand*
modify_tags_command_construct (GType object_type,
                               MediaSource* media,
                               GeeCollection* new_tag_list)
{
	ModifyTagsCommand * self = NULL;
	MediaSource* _tmp0_;
	GeeList* original_tags = NULL;
	TagSourceCollection* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeSortedSet* new_paths = NULL;
	GeeTreeSet* _tmp17_;
	g_return_val_if_fail (media != NULL, NULL);
	g_return_val_if_fail (new_tag_list != NULL, NULL);
	self = (ModifyTagsCommand*) single_data_source_command_construct (object_type, (DataSource*) media, RESOURCES_MODIFY_TAGS_LABEL, "");
	_tmp0_ = _g_object_ref0 (media);
	_g_object_unref0 (self->priv->media);
	self->priv->media = _tmp0_;
	_tmp1_ = tag_global;
	_tmp2_ = tag_source_collection_fetch_for_source (_tmp1_, media);
	original_tags = _tmp2_;
	_tmp3_ = original_tags;
	if (_tmp3_ != NULL) {
		{
			GeeList* _tag_list = NULL;
			GeeList* _tmp4_;
			gint _tag_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tag_index = 0;
			_tmp4_ = original_tags;
			_tag_list = _tmp4_;
			_tmp5_ = _tag_list;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tag_size = _tmp7_;
			_tag_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				Tag* tag = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				SourceProxy* proxy = NULL;
				Tag* _tmp12_;
				SourceProxy* _tmp13_;
				GeeArrayList* _tmp14_;
				SourceProxy* _tmp15_;
				SourceProxy* _tmp16_;
				_tag_index = _tag_index + 1;
				_tmp8_ = _tag_index;
				_tmp9_ = _tag_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _tag_list;
				_tmp11_ = gee_list_get (_tmp10_, _tag_index);
				tag = (Tag*) _tmp11_;
				_tmp12_ = tag;
				_tmp13_ = proxyable_get_proxy ((Proxyable*) _tmp12_);
				proxy = _tmp13_;
				_tmp14_ = self->priv->to_remove;
				_tmp15_ = proxy;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
				_tmp16_ = proxy;
				g_signal_connect_object (_tmp16_, "broken", (GCallback) _modify_tags_command_on_proxy_broken_source_proxy_broken, self, 0);
				_source_proxy_unref0 (proxy);
				_g_object_unref0 (tag);
			}
		}
	}
	_tmp17_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	new_paths = (GeeSortedSet*) _tmp17_;
	{
		GeeIterator* _new_tag_it = NULL;
		GeeIterator* _tmp18_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) new_tag_list);
		_new_tag_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			Tag* new_tag = NULL;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			gchar* new_tag_path = NULL;
			Tag* _tmp22_;
			gchar* _tmp23_;
			GeeSortedSet* _tmp24_;
			const gchar* _tmp25_;
			GeeSortedSet* _tmp26_;
			const gchar* _tmp27_;
			GeeList* _tmp28_;
			GeeList* _tmp29_;
			_tmp19_ = _new_tag_it;
			if (!gee_iterator_next (_tmp19_)) {
				break;
			}
			_tmp20_ = _new_tag_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			new_tag = (Tag*) _tmp21_;
			_tmp22_ = new_tag;
			_tmp23_ = tag_get_path (_tmp22_);
			new_tag_path = _tmp23_;
			_tmp24_ = new_paths;
			_tmp25_ = new_tag_path;
			gee_collection_add ((GeeCollection*) _tmp24_, _tmp25_);
			_tmp26_ = new_paths;
			_tmp27_ = new_tag_path;
			_tmp28_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp27_);
			_tmp29_ = _tmp28_;
			gee_collection_add_all ((GeeCollection*) _tmp26_, (GeeCollection*) _tmp29_);
			_g_object_unref0 (_tmp29_);
			_g_free0 (new_tag_path);
			_g_object_unref0 (new_tag);
		}
		_g_object_unref0 (_new_tag_it);
	}
	{
		GeeIterator* _path_it = NULL;
		GeeSortedSet* _tmp30_;
		GeeIterator* _tmp31_;
		_tmp30_ = new_paths;
		_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
		_path_it = _tmp31_;
		while (TRUE) {
			GeeIterator* _tmp32_;
			gchar* path = NULL;
			GeeIterator* _tmp33_;
			gpointer _tmp34_;
			SourceProxy* proxy = NULL;
			const gchar* _tmp35_;
			Tag* _tmp36_;
			Tag* _tmp37_;
			SourceProxy* _tmp38_;
			SourceProxy* _tmp39_;
			GeeArrayList* _tmp40_;
			SourceProxy* _tmp41_;
			SourceProxy* _tmp42_;
			_tmp32_ = _path_it;
			if (!gee_iterator_next (_tmp32_)) {
				break;
			}
			_tmp33_ = _path_it;
			_tmp34_ = gee_iterator_get (_tmp33_);
			path = (gchar*) _tmp34_;
			_tmp35_ = path;
			_tmp36_ = tag_for_path (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = proxyable_get_proxy ((Proxyable*) _tmp37_);
			_tmp39_ = _tmp38_;
			_g_object_unref0 (_tmp37_);
			proxy = _tmp39_;
			_tmp40_ = self->priv->to_add;
			_tmp41_ = proxy;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
			_tmp42_ = proxy;
			g_signal_connect_object (_tmp42_, "broken", (GCallback) _modify_tags_command_on_proxy_broken_source_proxy_broken, self, 0);
			_source_proxy_unref0 (proxy);
			_g_free0 (path);
		}
		_g_object_unref0 (_path_it);
	}
	_g_object_unref0 (new_paths);
	_g_object_unref0 (original_tags);
	return self;
}

ModifyTagsCommand*
modify_tags_command_new (MediaSource* media,
                         GeeCollection* new_tag_list)
{
	return modify_tags_command_construct (TYPE_MODIFY_TAGS_COMMAND, media, new_tag_list);
}

static void
modify_tags_command_real_execute (Command* base)
{
	ModifyTagsCommand * self;
	self = (ModifyTagsCommand*) base;
	{
		GeeArrayList* _proxy_list = NULL;
		GeeArrayList* _tmp0_;
		gint _proxy_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _proxy_index = 0;
		_tmp0_ = self->priv->to_remove;
		_proxy_list = _tmp0_;
		_tmp1_ = _proxy_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_proxy_size = _tmp3_;
		_proxy_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			SourceProxy* proxy = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			SourceProxy* _tmp8_;
			DataSource* _tmp9_;
			Tag* _tmp10_;
			MediaSource* _tmp11_;
			GeeList* _tmp12_;
			GeeList* _tmp13_;
			_proxy_index = _proxy_index + 1;
			_tmp4_ = _proxy_index;
			_tmp5_ = _proxy_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _proxy_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _proxy_index);
			proxy = (SourceProxy*) _tmp7_;
			_tmp8_ = proxy;
			_tmp9_ = source_proxy_get_source (_tmp8_);
			_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TAG, Tag);
			_tmp11_ = self->priv->media;
			_tmp12_ = tag_detach (_tmp10_, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp10_);
			_source_proxy_unref0 (proxy);
		}
	}
	{
		GeeArrayList* _proxy_list = NULL;
		GeeArrayList* _tmp14_;
		gint _proxy_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _proxy_index = 0;
		_tmp14_ = self->priv->to_add;
		_proxy_list = _tmp14_;
		_tmp15_ = _proxy_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_proxy_size = _tmp17_;
		_proxy_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			SourceProxy* proxy = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			SourceProxy* _tmp22_;
			DataSource* _tmp23_;
			Tag* _tmp24_;
			MediaSource* _tmp25_;
			_proxy_index = _proxy_index + 1;
			_tmp18_ = _proxy_index;
			_tmp19_ = _proxy_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _proxy_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _proxy_index);
			proxy = (SourceProxy*) _tmp21_;
			_tmp22_ = proxy;
			_tmp23_ = source_proxy_get_source (_tmp22_);
			_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_TAG, Tag);
			_tmp25_ = self->priv->media;
			tag_attach (_tmp24_, _tmp25_);
			_g_object_unref0 (_tmp24_);
			_source_proxy_unref0 (proxy);
		}
	}
}

static void
modify_tags_command_real_undo (Command* base)
{
	ModifyTagsCommand * self;
	self = (ModifyTagsCommand*) base;
	{
		GeeArrayList* _proxy_list = NULL;
		GeeArrayList* _tmp0_;
		gint _proxy_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _proxy_index = 0;
		_tmp0_ = self->priv->to_add;
		_proxy_list = _tmp0_;
		_tmp1_ = _proxy_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_proxy_size = _tmp3_;
		_proxy_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			SourceProxy* proxy = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			SourceProxy* _tmp8_;
			DataSource* _tmp9_;
			Tag* _tmp10_;
			MediaSource* _tmp11_;
			GeeList* _tmp12_;
			GeeList* _tmp13_;
			_proxy_index = _proxy_index + 1;
			_tmp4_ = _proxy_index;
			_tmp5_ = _proxy_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _proxy_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _proxy_index);
			proxy = (SourceProxy*) _tmp7_;
			_tmp8_ = proxy;
			_tmp9_ = source_proxy_get_source (_tmp8_);
			_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TAG, Tag);
			_tmp11_ = self->priv->media;
			_tmp12_ = tag_detach (_tmp10_, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp10_);
			_source_proxy_unref0 (proxy);
		}
	}
	{
		GeeArrayList* _proxy_list = NULL;
		GeeArrayList* _tmp14_;
		gint _proxy_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _proxy_index = 0;
		_tmp14_ = self->priv->to_remove;
		_proxy_list = _tmp14_;
		_tmp15_ = _proxy_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_proxy_size = _tmp17_;
		_proxy_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			SourceProxy* proxy = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			SourceProxy* _tmp22_;
			DataSource* _tmp23_;
			Tag* _tmp24_;
			MediaSource* _tmp25_;
			_proxy_index = _proxy_index + 1;
			_tmp18_ = _proxy_index;
			_tmp19_ = _proxy_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _proxy_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _proxy_index);
			proxy = (SourceProxy*) _tmp21_;
			_tmp22_ = proxy;
			_tmp23_ = source_proxy_get_source (_tmp22_);
			_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_TAG, Tag);
			_tmp25_ = self->priv->media;
			tag_attach (_tmp24_, _tmp25_);
			_g_object_unref0 (_tmp24_);
			_source_proxy_unref0 (proxy);
		}
	}
}

static void
modify_tags_command_on_proxy_broken (ModifyTagsCommand* self)
{
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command_get_command_manager ((Command*) self);
	_tmp1_ = _tmp0_;
	command_manager_reset (_tmp1_);
	_command_manager_unref0 (_tmp1_);
}

static void
modify_tags_command_class_init (ModifyTagsCommandClass * klass,
                                gpointer klass_data)
{
	modify_tags_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ModifyTagsCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) modify_tags_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) modify_tags_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = modify_tags_command_finalize;
}

static void
modify_tags_command_instance_init (ModifyTagsCommand * self,
                                   gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = modify_tags_command_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL);
	self->priv->to_add = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_SOURCE_PROXY, (GBoxedCopyFunc) source_proxy_ref, (GDestroyNotify) source_proxy_unref, NULL, NULL, NULL);
	self->priv->to_remove = _tmp1_;
}

static void
modify_tags_command_finalize (GObject * obj)
{
	ModifyTagsCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MODIFY_TAGS_COMMAND, ModifyTagsCommand);
	{
		GeeArrayList* _proxy_list = NULL;
		GeeArrayList* _tmp0_;
		gint _proxy_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _proxy_index = 0;
		_tmp0_ = self->priv->to_add;
		_proxy_list = _tmp0_;
		_tmp1_ = _proxy_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_proxy_size = _tmp3_;
		_proxy_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			SourceProxy* proxy = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			SourceProxy* _tmp8_;
			guint _tmp9_;
			_proxy_index = _proxy_index + 1;
			_tmp4_ = _proxy_index;
			_tmp5_ = _proxy_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _proxy_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _proxy_index);
			proxy = (SourceProxy*) _tmp7_;
			_tmp8_ = proxy;
			g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp9_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _modify_tags_command_on_proxy_broken_source_proxy_broken, self);
			_source_proxy_unref0 (proxy);
		}
	}
	{
		GeeArrayList* _proxy_list = NULL;
		GeeArrayList* _tmp10_;
		gint _proxy_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _proxy_index = 0;
		_tmp10_ = self->priv->to_remove;
		_proxy_list = _tmp10_;
		_tmp11_ = _proxy_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_proxy_size = _tmp13_;
		_proxy_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			SourceProxy* proxy = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			SourceProxy* _tmp18_;
			guint _tmp19_;
			_proxy_index = _proxy_index + 1;
			_tmp14_ = _proxy_index;
			_tmp15_ = _proxy_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _proxy_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _proxy_index);
			proxy = (SourceProxy*) _tmp17_;
			_tmp18_ = proxy;
			g_signal_parse_name ("broken", TYPE_SOURCE_PROXY, &_tmp19_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _modify_tags_command_on_proxy_broken_source_proxy_broken, self);
			_source_proxy_unref0 (proxy);
		}
	}
	_g_object_unref0 (self->priv->media);
	_g_object_unref0 (self->priv->to_add);
	_g_object_unref0 (self->priv->to_remove);
	G_OBJECT_CLASS (modify_tags_command_parent_class)->finalize (obj);
}

static GType
modify_tags_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ModifyTagsCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modify_tags_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModifyTagsCommand), 0, (GInstanceInitFunc) modify_tags_command_instance_init, NULL };
	GType modify_tags_command_type_id;
	modify_tags_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "ModifyTagsCommand", &g_define_type_info, 0);
	ModifyTagsCommand_private_offset = g_type_add_instance_private (modify_tags_command_type_id, sizeof (ModifyTagsCommandPrivate));
	return modify_tags_command_type_id;
}

GType
modify_tags_command_get_type (void)
{
	static volatile gsize modify_tags_command_type_id__once = 0;
	if (g_once_init_enter (&modify_tags_command_type_id__once)) {
		GType modify_tags_command_type_id;
		modify_tags_command_type_id = modify_tags_command_get_type_once ();
		g_once_init_leave (&modify_tags_command_type_id__once, modify_tags_command_type_id);
	}
	return modify_tags_command_type_id__once;
}

static inline gpointer
tag_untag_photos_command_get_instance_private (TagUntagPhotosCommand* self)
{
	return G_STRUCT_MEMBER_P (self, TagUntagPhotosCommand_private_offset);
}

static void
_tag_untag_photos_command_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                DataSource* source,
                                                                                gpointer self)
{
	tag_untag_photos_command_on_source_destroyed ((TagUntagPhotosCommand*) self, source);
}

TagUntagPhotosCommand*
tag_untag_photos_command_construct (GType object_type,
                                    Tag* tag,
                                    GeeCollection* sources,
                                    gint count,
                                    gboolean attach)
{
	TagUntagPhotosCommand * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GeeCollection* _tmp9_;
	LibraryPhotoSourceCollection* _tmp10_;
	VideoSourceCollection* _tmp11_;
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (sources != NULL, NULL);
	if (attach) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = tag_get_user_visible_name (tag);
		_tmp2_ = _tmp1_;
		_tmp3_ = resources_tag_photos_label (_tmp2_, count);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
		_g_free0 (_tmp2_);
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = tag_get_user_visible_name (tag);
		_tmp5_ = _tmp4_;
		_tmp6_ = resources_untag_photos_label (_tmp5_, count);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = data_object_get_name ((DataObject*) tag);
	_tmp8_ = _tmp7_;
	self = (TagUntagPhotosCommand*) simple_proxyable_command_construct (object_type, (Proxyable*) tag, _tmp0_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = _g_object_ref0 (sources);
	_g_object_unref0 (self->priv->sources);
	self->priv->sources = _tmp9_;
	self->priv->attach = attach;
	_tmp10_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp10_, "item-destroyed", (GCallback) _tag_untag_photos_command_on_source_destroyed_source_collection_item_destroyed, self, 0);
	_tmp11_ = video_global;
	g_signal_connect_object ((SourceCollection*) _tmp11_, "item-destroyed", (GCallback) _tag_untag_photos_command_on_source_destroyed_source_collection_item_destroyed, self, 0);
	_g_free0 (_tmp0_);
	return self;
}

TagUntagPhotosCommand*
tag_untag_photos_command_new (Tag* tag,
                              GeeCollection* sources,
                              gint count,
                              gboolean attach)
{
	return tag_untag_photos_command_construct (TYPE_TAG_UNTAG_PHOTOS_COMMAND, tag, sources, count, attach);
}

static void
tag_untag_photos_command_real_execute_on_source (SimpleProxyableCommand* base,
                                                 DataSource* source)
{
	TagUntagPhotosCommand * self;
	self = (TagUntagPhotosCommand*) base;
	g_return_if_fail (source != NULL);
	if (self->priv->attach) {
		tag_untag_photos_command_do_attach (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag));
	} else {
		tag_untag_photos_command_do_detach (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag));
	}
}

static void
tag_untag_photos_command_real_undo_on_source (SimpleProxyableCommand* base,
                                              DataSource* source)
{
	TagUntagPhotosCommand * self;
	self = (TagUntagPhotosCommand*) base;
	g_return_if_fail (source != NULL);
	if (self->priv->attach) {
		tag_untag_photos_command_do_detach (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag));
	} else {
		tag_untag_photos_command_do_attach (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_TAG, Tag));
	}
}

static void
tag_untag_photos_command_do_attach (TagUntagPhotosCommand* self,
                                    Tag* tag)
{
	GeeMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->priv->detached_from;
	if (_tmp0_ == NULL) {
		GeeCollection* _tmp1_;
		GeeArrayList* _tmp2_;
		Tag* curr_tmp = NULL;
		Tag* _tmp3_;
		_tmp1_ = self->priv->sources;
		tag_attach_many (tag, _tmp1_);
		_tmp2_ = gee_array_list_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->attached_to);
		self->priv->attached_to = (GeeList*) _tmp2_;
		_tmp3_ = _g_object_ref0 (tag);
		curr_tmp = _tmp3_;
		while (TRUE) {
			Tag* _tmp4_;
			GeeList* _tmp5_;
			Tag* _tmp6_;
			Tag* _tmp7_;
			Tag* _tmp8_;
			_tmp4_ = curr_tmp;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = self->priv->attached_to;
			_tmp6_ = curr_tmp;
			gee_collection_add ((GeeCollection*) _tmp5_, _tmp6_);
			_tmp7_ = curr_tmp;
			_tmp8_ = tag_get_hierarchical_parent (_tmp7_);
			_g_object_unref0 (curr_tmp);
			curr_tmp = _tmp8_;
		}
		_g_object_unref0 (curr_tmp);
		return;
	}
	{
		GeeIterator* _detached_tag_it = NULL;
		GeeMultiMap* _tmp9_;
		GeeMultiSet* _tmp10_;
		GeeMultiSet* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp9_ = self->priv->detached_from;
		_tmp10_ = gee_multi_map_get_all_keys (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_detached_tag_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			Tag* detached_tag = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			Tag* _tmp17_;
			GeeMultiMap* _tmp18_;
			Tag* _tmp19_;
			GeeCollection* _tmp20_;
			GeeCollection* _tmp21_;
			_tmp14_ = _detached_tag_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _detached_tag_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			detached_tag = (Tag*) _tmp16_;
			_tmp17_ = detached_tag;
			_tmp18_ = self->priv->detached_from;
			_tmp19_ = detached_tag;
			_tmp20_ = gee_multi_map_get (_tmp18_, _tmp19_);
			_tmp21_ = _tmp20_;
			tag_attach_many (_tmp17_, _tmp21_);
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (detached_tag);
		}
		_g_object_unref0 (_detached_tag_it);
	}
	_g_object_unref0 (self->priv->detached_from);
	self->priv->detached_from = NULL;
	simple_proxyable_command_clear_added_proxies ((SimpleProxyableCommand*) self);
}

static void
tag_untag_photos_command_do_detach (TagUntagPhotosCommand* self,
                                    Tag* tag)
{
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->priv->attached_to;
	if (_tmp0_ == NULL) {
		GeeCollection* _tmp1_;
		GeeMultiMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		_tmp1_ = self->priv->sources;
		_tmp2_ = tag_detach_many (tag, _tmp1_);
		_g_object_unref0 (self->priv->detached_from);
		self->priv->detached_from = _tmp2_;
		_tmp3_ = self->priv->detached_from;
		_tmp4_ = gee_multi_map_get_keys (_tmp3_);
		_tmp5_ = _tmp4_;
		simple_proxyable_command_add_proxyables ((SimpleProxyableCommand*) self, (GeeCollection*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	} else {
		{
			GeeList* _t_list = NULL;
			GeeList* _tmp6_;
			gint _t_size = 0;
			GeeList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _t_index = 0;
			_tmp6_ = self->priv->attached_to;
			_t_list = _tmp6_;
			_tmp7_ = _t_list;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_t_size = _tmp9_;
			_t_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				Tag* t = NULL;
				GeeList* _tmp12_;
				gpointer _tmp13_;
				_t_index = _t_index + 1;
				_tmp10_ = _t_index;
				_tmp11_ = _t_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _t_list;
				_tmp13_ = gee_list_get (_tmp12_, _t_index);
				t = (Tag*) _tmp13_;
				{
					GeeIterator* _ms_it = NULL;
					GeeCollection* _tmp14_;
					GeeIterator* _tmp15_;
					_tmp14_ = self->priv->sources;
					_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
					_ms_it = _tmp15_;
					while (TRUE) {
						GeeIterator* _tmp16_;
						MediaSource* ms = NULL;
						GeeIterator* _tmp17_;
						gpointer _tmp18_;
						Tag* _tmp19_;
						MediaSource* _tmp20_;
						_tmp16_ = _ms_it;
						if (!gee_iterator_next (_tmp16_)) {
							break;
						}
						_tmp17_ = _ms_it;
						_tmp18_ = gee_iterator_get (_tmp17_);
						ms = (MediaSource*) _tmp18_;
						_tmp19_ = t;
						_tmp20_ = ms;
						if (tag_get_attachment_count (_tmp19_, _tmp20_) < 2) {
							Tag* _tmp21_;
							MediaSource* _tmp22_;
							GeeList* _tmp23_;
							GeeList* _tmp24_;
							_tmp21_ = t;
							_tmp22_ = ms;
							_tmp23_ = tag_detach (_tmp21_, _tmp22_);
							_tmp24_ = _tmp23_;
							_g_object_unref0 (_tmp24_);
						}
						_g_object_unref0 (ms);
					}
					_g_object_unref0 (_ms_it);
				}
				_g_object_unref0 (t);
			}
		}
	}
}

static void
tag_untag_photos_command_on_source_destroyed (TagUntagPhotosCommand* self,
                                              DataSource* source)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = data_object_to_string ((DataObject*) source);
	_tmp1_ = _tmp0_;
	g_debug ("Commands.vala:2234: on_source_destroyed: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->sources;
	if (gee_collection_contains (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource))) {
		CommandManager* _tmp3_;
		CommandManager* _tmp4_;
		_tmp3_ = command_get_command_manager ((Command*) self);
		_tmp4_ = _tmp3_;
		command_manager_reset (_tmp4_);
		_command_manager_unref0 (_tmp4_);
	}
}

static void
tag_untag_photos_command_class_init (TagUntagPhotosCommandClass * klass,
                                     gpointer klass_data)
{
	tag_untag_photos_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TagUntagPhotosCommand_private_offset);
	((SimpleProxyableCommandClass *) klass)->execute_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) tag_untag_photos_command_real_execute_on_source;
	((SimpleProxyableCommandClass *) klass)->undo_on_source = (void (*) (SimpleProxyableCommand*, DataSource*)) tag_untag_photos_command_real_undo_on_source;
	G_OBJECT_CLASS (klass)->finalize = tag_untag_photos_command_finalize;
}

static void
tag_untag_photos_command_instance_init (TagUntagPhotosCommand * self,
                                        gpointer klass)
{
	self->priv = tag_untag_photos_command_get_instance_private (self);
	self->priv->detached_from = NULL;
	self->priv->attached_to = NULL;
}

static void
tag_untag_photos_command_finalize (GObject * obj)
{
	TagUntagPhotosCommand * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	VideoSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAG_UNTAG_PHOTOS_COMMAND, TagUntagPhotosCommand);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _tag_untag_photos_command_on_source_destroyed_source_collection_item_destroyed, self);
	_tmp2_ = video_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _tag_untag_photos_command_on_source_destroyed_source_collection_item_destroyed, self);
	_g_object_unref0 (self->priv->sources);
	_g_object_unref0 (self->priv->detached_from);
	_g_object_unref0 (self->priv->attached_to);
	G_OBJECT_CLASS (tag_untag_photos_command_parent_class)->finalize (obj);
}

static GType
tag_untag_photos_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TagUntagPhotosCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tag_untag_photos_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagUntagPhotosCommand), 0, (GInstanceInitFunc) tag_untag_photos_command_instance_init, NULL };
	GType tag_untag_photos_command_type_id;
	tag_untag_photos_command_type_id = g_type_register_static (TYPE_SIMPLE_PROXYABLE_COMMAND, "TagUntagPhotosCommand", &g_define_type_info, 0);
	TagUntagPhotosCommand_private_offset = g_type_add_instance_private (tag_untag_photos_command_type_id, sizeof (TagUntagPhotosCommandPrivate));
	return tag_untag_photos_command_type_id;
}

GType
tag_untag_photos_command_get_type (void)
{
	static volatile gsize tag_untag_photos_command_type_id__once = 0;
	if (g_once_init_enter (&tag_untag_photos_command_type_id__once)) {
		GType tag_untag_photos_command_type_id;
		tag_untag_photos_command_type_id = tag_untag_photos_command_get_type_once ();
		g_once_init_leave (&tag_untag_photos_command_type_id__once, tag_untag_photos_command_type_id);
	}
	return tag_untag_photos_command_type_id__once;
}

static inline gpointer
rename_saved_search_command_get_instance_private (RenameSavedSearchCommand* self)
{
	return G_STRUCT_MEMBER_P (self, RenameSavedSearchCommand_private_offset);
}

RenameSavedSearchCommand*
rename_saved_search_command_construct (GType object_type,
                                       SavedSearch* search,
                                       const gchar* new_name)
{
	RenameSavedSearchCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SavedSearch* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (search != NULL, NULL);
	g_return_val_if_fail (new_name != NULL, NULL);
	_tmp0_ = data_object_get_name ((DataObject*) search);
	_tmp1_ = _tmp0_;
	_tmp2_ = resources_rename_search_label (_tmp1_, new_name);
	_tmp3_ = _tmp2_;
	_tmp4_ = data_object_get_name ((DataObject*) search);
	_tmp5_ = _tmp4_;
	self = (RenameSavedSearchCommand*) single_data_source_command_construct (object_type, (DataSource*) search, _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->search);
	self->priv->search = _tmp6_;
	_tmp7_ = data_object_get_name ((DataObject*) search);
	_g_free0 (self->priv->old_name);
	self->priv->old_name = _tmp7_;
	_tmp8_ = g_strdup (new_name);
	_g_free0 (self->priv->new_name);
	self->priv->new_name = _tmp8_;
	return self;
}

RenameSavedSearchCommand*
rename_saved_search_command_new (SavedSearch* search,
                                 const gchar* new_name)
{
	return rename_saved_search_command_construct (TYPE_RENAME_SAVED_SEARCH_COMMAND, search, new_name);
}

static void
rename_saved_search_command_real_execute (Command* base)
{
	RenameSavedSearchCommand * self;
	SavedSearch* _tmp0_;
	const gchar* _tmp1_;
	self = (RenameSavedSearchCommand*) base;
	_tmp0_ = self->priv->search;
	_tmp1_ = self->priv->new_name;
	if (!saved_search_rename (_tmp0_, _tmp1_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->new_name;
		_tmp3_ = resources_rename_search_exists_message (_tmp2_);
		_tmp4_ = _tmp3_;
		app_window_error_message (_tmp4_, NULL, NULL);
		_g_free0 (_tmp4_);
	}
}

static void
rename_saved_search_command_real_undo (Command* base)
{
	RenameSavedSearchCommand * self;
	SavedSearch* _tmp0_;
	const gchar* _tmp1_;
	self = (RenameSavedSearchCommand*) base;
	_tmp0_ = self->priv->search;
	_tmp1_ = self->priv->old_name;
	if (!saved_search_rename (_tmp0_, _tmp1_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->old_name;
		_tmp3_ = resources_rename_search_exists_message (_tmp2_);
		_tmp4_ = _tmp3_;
		app_window_error_message (_tmp4_, NULL, NULL);
		_g_free0 (_tmp4_);
	}
}

static void
rename_saved_search_command_class_init (RenameSavedSearchCommandClass * klass,
                                        gpointer klass_data)
{
	rename_saved_search_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RenameSavedSearchCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) rename_saved_search_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) rename_saved_search_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = rename_saved_search_command_finalize;
}

static void
rename_saved_search_command_instance_init (RenameSavedSearchCommand * self,
                                           gpointer klass)
{
	self->priv = rename_saved_search_command_get_instance_private (self);
}

static void
rename_saved_search_command_finalize (GObject * obj)
{
	RenameSavedSearchCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RENAME_SAVED_SEARCH_COMMAND, RenameSavedSearchCommand);
	_g_object_unref0 (self->priv->search);
	_g_free0 (self->priv->old_name);
	_g_free0 (self->priv->new_name);
	G_OBJECT_CLASS (rename_saved_search_command_parent_class)->finalize (obj);
}

static GType
rename_saved_search_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RenameSavedSearchCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rename_saved_search_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RenameSavedSearchCommand), 0, (GInstanceInitFunc) rename_saved_search_command_instance_init, NULL };
	GType rename_saved_search_command_type_id;
	rename_saved_search_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "RenameSavedSearchCommand", &g_define_type_info, 0);
	RenameSavedSearchCommand_private_offset = g_type_add_instance_private (rename_saved_search_command_type_id, sizeof (RenameSavedSearchCommandPrivate));
	return rename_saved_search_command_type_id;
}

GType
rename_saved_search_command_get_type (void)
{
	static volatile gsize rename_saved_search_command_type_id__once = 0;
	if (g_once_init_enter (&rename_saved_search_command_type_id__once)) {
		GType rename_saved_search_command_type_id;
		rename_saved_search_command_type_id = rename_saved_search_command_get_type_once ();
		g_once_init_leave (&rename_saved_search_command_type_id__once, rename_saved_search_command_type_id);
	}
	return rename_saved_search_command_type_id__once;
}

static inline gpointer
delete_saved_search_command_get_instance_private (DeleteSavedSearchCommand* self)
{
	return G_STRUCT_MEMBER_P (self, DeleteSavedSearchCommand_private_offset);
}

DeleteSavedSearchCommand*
delete_saved_search_command_construct (GType object_type,
                                       SavedSearch* search)
{
	DeleteSavedSearchCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SavedSearch* _tmp6_;
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = data_object_get_name ((DataObject*) search);
	_tmp1_ = _tmp0_;
	_tmp2_ = resources_delete_search_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = data_object_get_name ((DataObject*) search);
	_tmp5_ = _tmp4_;
	self = (DeleteSavedSearchCommand*) single_data_source_command_construct (object_type, (DataSource*) search, _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->search);
	self->priv->search = _tmp6_;
	return self;
}

DeleteSavedSearchCommand*
delete_saved_search_command_new (SavedSearch* search)
{
	return delete_saved_search_command_construct (TYPE_DELETE_SAVED_SEARCH_COMMAND, search);
}

static void
delete_saved_search_command_real_execute (Command* base)
{
	DeleteSavedSearchCommand * self;
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp1_;
	SavedSearch* _tmp2_;
	self = (DeleteSavedSearchCommand*) base;
	_tmp0_ = saved_search_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->search;
	saved_search_table_remove (_tmp1_, _tmp2_);
	_saved_search_table_unref0 (_tmp1_);
}

static void
delete_saved_search_command_real_undo (Command* base)
{
	DeleteSavedSearchCommand * self;
	SavedSearch* _tmp0_;
	self = (DeleteSavedSearchCommand*) base;
	_tmp0_ = self->priv->search;
	saved_search_reconstitute (_tmp0_);
}

static void
delete_saved_search_command_class_init (DeleteSavedSearchCommandClass * klass,
                                        gpointer klass_data)
{
	delete_saved_search_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DeleteSavedSearchCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) delete_saved_search_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) delete_saved_search_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = delete_saved_search_command_finalize;
}

static void
delete_saved_search_command_instance_init (DeleteSavedSearchCommand * self,
                                           gpointer klass)
{
	self->priv = delete_saved_search_command_get_instance_private (self);
}

static void
delete_saved_search_command_finalize (GObject * obj)
{
	DeleteSavedSearchCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELETE_SAVED_SEARCH_COMMAND, DeleteSavedSearchCommand);
	_g_object_unref0 (self->priv->search);
	G_OBJECT_CLASS (delete_saved_search_command_parent_class)->finalize (obj);
}

static GType
delete_saved_search_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DeleteSavedSearchCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delete_saved_search_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeleteSavedSearchCommand), 0, (GInstanceInitFunc) delete_saved_search_command_instance_init, NULL };
	GType delete_saved_search_command_type_id;
	delete_saved_search_command_type_id = g_type_register_static (TYPE_SINGLE_DATA_SOURCE_COMMAND, "DeleteSavedSearchCommand", &g_define_type_info, 0);
	DeleteSavedSearchCommand_private_offset = g_type_add_instance_private (delete_saved_search_command_type_id, sizeof (DeleteSavedSearchCommandPrivate));
	return delete_saved_search_command_type_id;
}

GType
delete_saved_search_command_get_type (void)
{
	static volatile gsize delete_saved_search_command_type_id__once = 0;
	if (g_once_init_enter (&delete_saved_search_command_type_id__once)) {
		GType delete_saved_search_command_type_id;
		delete_saved_search_command_type_id = delete_saved_search_command_get_type_once ();
		g_once_init_leave (&delete_saved_search_command_type_id__once, delete_saved_search_command_type_id);
	}
	return delete_saved_search_command_type_id__once;
}

static inline gpointer
trash_untrash_photos_command_get_instance_private (TrashUntrashPhotosCommand* self)
{
	return G_STRUCT_MEMBER_P (self, TrashUntrashPhotosCommand_private_offset);
}

static void
_trash_untrash_photos_command_on_photo_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                   DataSource* source,
                                                                                   gpointer self)
{
	trash_untrash_photos_command_on_photo_destroyed ((TrashUntrashPhotosCommand*) self, source);
}

TrashUntrashPhotosCommand*
trash_untrash_photos_command_construct (GType object_type,
                                        GeeCollection* sources,
                                        gboolean to_trash)
{
	TrashUntrashPhotosCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	VideoSourceCollection* _tmp4_;
	g_return_val_if_fail (sources != NULL, NULL);
	if (to_trash) {
		_tmp0_ = _ ("Move Photos to Trash");
	} else {
		_tmp0_ = _ ("Restore Photos from Trash");
	}
	if (to_trash) {
		_tmp1_ = _ ("Move the photos to the Photos trash");
	} else {
		_tmp1_ = _ ("Restore the photos back to the Photos library");
	}
	self = (TrashUntrashPhotosCommand*) page_command_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = _g_object_ref0 (sources);
	_g_object_unref0 (self->priv->sources);
	self->priv->sources = _tmp2_;
	self->priv->to_trash = to_trash;
	_tmp3_ = library_photo_global;
	g_signal_connect_object ((SourceCollection*) _tmp3_, "item-destroyed", (GCallback) _trash_untrash_photos_command_on_photo_destroyed_source_collection_item_destroyed, self, 0);
	_tmp4_ = video_global;
	g_signal_connect_object ((SourceCollection*) _tmp4_, "item-destroyed", (GCallback) _trash_untrash_photos_command_on_photo_destroyed_source_collection_item_destroyed, self, 0);
	return self;
}

TrashUntrashPhotosCommand*
trash_untrash_photos_command_new (GeeCollection* sources,
                                  gboolean to_trash)
{
	return trash_untrash_photos_command_construct (TYPE_TRASH_UNTRASH_PHOTOS_COMMAND, sources, to_trash);
}

static ProgressDialog*
trash_untrash_photos_command_get_progress_dialog (TrashUntrashPhotosCommand* self,
                                                  gboolean to_trash)
{
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_ = NULL;
	ProgressDialog* dialog = NULL;
	AppWindow* _tmp4_;
	AppWindow* _tmp5_;
	ProgressDialog* _tmp6_;
	ProgressDialog* _tmp7_;
	ProgressDialog* _tmp8_;
	GeeCollection* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	ProgressDialog* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sources;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 5) {
		result = NULL;
		return result;
	}
	if (to_trash) {
		_tmp3_ = _ ("Moving Photos to Trash");
	} else {
		_tmp3_ = _ ("Restoring Photos From Trash");
	}
	_tmp4_ = app_window_get_instance ();
	_tmp5_ = _tmp4_;
	_tmp6_ = progress_dialog_new ((GtkWindow*) _tmp5_, _tmp3_, NULL);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	dialog = _tmp7_;
	_tmp8_ = dialog;
	_tmp9_ = self->priv->sources;
	_tmp10_ = gee_collection_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	progress_dialog_update_display_every (_tmp8_, CLAMP (_tmp11_ / 5, 2, 10));
	result = dialog;
	return result;
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

static void
trash_untrash_photos_command_real_execute (Command* base)
{
	TrashUntrashPhotosCommand * self;
	ProgressDialog* dialog = NULL;
	ProgressDialog* _tmp0_;
	ProgressMonitor monitor = NULL;
	gpointer monitor_target;
	GDestroyNotify monitor_target_destroy_notify;
	ProgressDialog* _tmp1_;
	ProgressDialog* _tmp5_;
	self = (TrashUntrashPhotosCommand*) base;
	_tmp0_ = trash_untrash_photos_command_get_progress_dialog (self, self->priv->to_trash);
	dialog = _tmp0_;
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_tmp1_ = dialog;
	if (_tmp1_ != NULL) {
		ProgressDialog* _tmp2_;
		_tmp2_ = dialog;
		(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
		monitor = NULL;
		monitor_target = NULL;
		monitor_target_destroy_notify = NULL;
		monitor = _progress_dialog_monitor_progress_monitor;
		monitor_target = g_object_ref (_tmp2_);
		monitor_target_destroy_notify = g_object_unref;
	}
	if (self->priv->to_trash) {
		ProgressMonitor _tmp3_;
		gpointer _tmp3__target;
		_tmp3_ = monitor;
		_tmp3__target = monitor_target;
		trash_untrash_photos_command_trash (self, _tmp3_, _tmp3__target);
	} else {
		ProgressMonitor _tmp4_;
		gpointer _tmp4__target;
		_tmp4_ = monitor;
		_tmp4__target = monitor_target;
		trash_untrash_photos_command_untrash (self, _tmp4_, _tmp4__target);
	}
	_tmp5_ = dialog;
	if (_tmp5_ != NULL) {
		ProgressDialog* _tmp6_;
		_tmp6_ = dialog;
		progress_dialog_close (_tmp6_);
	}
	(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_g_object_unref0 (dialog);
}

static void
trash_untrash_photos_command_real_undo (Command* base)
{
	TrashUntrashPhotosCommand * self;
	ProgressDialog* dialog = NULL;
	ProgressDialog* _tmp0_;
	ProgressMonitor monitor = NULL;
	gpointer monitor_target;
	GDestroyNotify monitor_target_destroy_notify;
	ProgressDialog* _tmp1_;
	ProgressDialog* _tmp5_;
	self = (TrashUntrashPhotosCommand*) base;
	_tmp0_ = trash_untrash_photos_command_get_progress_dialog (self, !self->priv->to_trash);
	dialog = _tmp0_;
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_tmp1_ = dialog;
	if (_tmp1_ != NULL) {
		ProgressDialog* _tmp2_;
		_tmp2_ = dialog;
		(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
		monitor = NULL;
		monitor_target = NULL;
		monitor_target_destroy_notify = NULL;
		monitor = _progress_dialog_monitor_progress_monitor;
		monitor_target = g_object_ref (_tmp2_);
		monitor_target_destroy_notify = g_object_unref;
	}
	if (self->priv->to_trash) {
		ProgressMonitor _tmp3_;
		gpointer _tmp3__target;
		_tmp3_ = monitor;
		_tmp3__target = monitor_target;
		trash_untrash_photos_command_untrash (self, _tmp3_, _tmp3__target);
	} else {
		ProgressMonitor _tmp4_;
		gpointer _tmp4__target;
		_tmp4_ = monitor;
		_tmp4__target = monitor_target;
		trash_untrash_photos_command_trash (self, _tmp4_, _tmp4__target);
	}
	_tmp5_ = dialog;
	if (_tmp5_ != NULL) {
		ProgressDialog* _tmp6_;
		_tmp6_ = dialog;
		progress_dialog_close (_tmp6_);
	}
	(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_g_object_unref0 (dialog);
}

static void
trash_untrash_photos_command_trash (TrashUntrashPhotosCommand* self,
                                    ProgressMonitor monitor,
                                    gpointer monitor_target)
{
	gint ctr = 0;
	gint count = 0;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	TransactionController* _tmp4_;
	TransactionController* _tmp5_;
	VideoSourceCollection* _tmp6_;
	TransactionController* _tmp7_;
	TransactionController* _tmp8_;
	LibraryPhotoSourceCollection* _tmp18_;
	TransactionController* _tmp19_;
	TransactionController* _tmp20_;
	VideoSourceCollection* _tmp21_;
	TransactionController* _tmp22_;
	TransactionController* _tmp23_;
	g_return_if_fail (self != NULL);
	ctr = 0;
	_tmp0_ = self->priv->sources;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	_tmp3_ = library_photo_global;
	_tmp4_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	transaction_controller_begin (_tmp5_);
	_tmp6_ = video_global;
	_tmp7_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	transaction_controller_begin (_tmp8_);
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = self->priv->sources;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_source_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			MediaSource* source = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			MediaSource* _tmp14_;
			_tmp11_ = _source_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _source_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			source = (MediaSource*) _tmp13_;
			_tmp14_ = source;
			media_source_trash (_tmp14_);
			if (monitor != NULL) {
				ProgressMonitor _tmp15_;
				gpointer _tmp15__target;
				gint _tmp16_;
				gint _tmp17_;
				_tmp15_ = monitor;
				_tmp15__target = monitor_target;
				ctr = ctr + 1;
				_tmp16_ = ctr;
				_tmp17_ = count;
				_tmp15_ ((guint64) _tmp16_, (guint64) _tmp17_, TRUE, _tmp15__target);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp18_ = library_photo_global;
	_tmp19_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	transaction_controller_commit (_tmp20_);
	_tmp21_ = video_global;
	_tmp22_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	transaction_controller_commit (_tmp23_);
}

static void
trash_untrash_photos_command_untrash (TrashUntrashPhotosCommand* self,
                                      ProgressMonitor monitor,
                                      gpointer monitor_target)
{
	gint ctr = 0;
	gint count = 0;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	TransactionController* _tmp4_;
	TransactionController* _tmp5_;
	VideoSourceCollection* _tmp6_;
	TransactionController* _tmp7_;
	TransactionController* _tmp8_;
	LibraryPhotoSourceCollection* _tmp18_;
	TransactionController* _tmp19_;
	TransactionController* _tmp20_;
	VideoSourceCollection* _tmp21_;
	TransactionController* _tmp22_;
	TransactionController* _tmp23_;
	g_return_if_fail (self != NULL);
	ctr = 0;
	_tmp0_ = self->priv->sources;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	_tmp3_ = library_photo_global;
	_tmp4_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	transaction_controller_begin (_tmp5_);
	_tmp6_ = video_global;
	_tmp7_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	transaction_controller_begin (_tmp8_);
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = self->priv->sources;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_source_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			MediaSource* source = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			MediaSource* _tmp14_;
			_tmp11_ = _source_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _source_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			source = (MediaSource*) _tmp13_;
			_tmp14_ = source;
			media_source_untrash (_tmp14_);
			if (monitor != NULL) {
				ProgressMonitor _tmp15_;
				gpointer _tmp15__target;
				gint _tmp16_;
				gint _tmp17_;
				_tmp15_ = monitor;
				_tmp15__target = monitor_target;
				ctr = ctr + 1;
				_tmp16_ = ctr;
				_tmp17_ = count;
				_tmp15_ ((guint64) _tmp16_, (guint64) _tmp17_, TRUE, _tmp15__target);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp18_ = library_photo_global;
	_tmp19_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	transaction_controller_commit (_tmp20_);
	_tmp21_ = video_global;
	_tmp22_ = media_source_collection_get_transaction_controller ((MediaSourceCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	transaction_controller_commit (_tmp23_);
}

static void
trash_untrash_photos_command_on_photo_destroyed (TrashUntrashPhotosCommand* self,
                                                 DataSource* source)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->sources;
	gee_collection_remove (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = self->priv->sources;
	_tmp2_ = gee_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		CommandManager* _tmp4_;
		CommandManager* _tmp5_;
		_tmp4_ = command_get_command_manager ((Command*) self);
		_tmp5_ = _tmp4_;
		command_manager_reset (_tmp5_);
		_command_manager_unref0 (_tmp5_);
	}
}

static void
trash_untrash_photos_command_class_init (TrashUntrashPhotosCommandClass * klass,
                                         gpointer klass_data)
{
	trash_untrash_photos_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TrashUntrashPhotosCommand_private_offset);
	((CommandClass *) klass)->execute = (void (*) (Command*)) trash_untrash_photos_command_real_execute;
	((CommandClass *) klass)->undo = (void (*) (Command*)) trash_untrash_photos_command_real_undo;
	G_OBJECT_CLASS (klass)->finalize = trash_untrash_photos_command_finalize;
}

static void
trash_untrash_photos_command_instance_init (TrashUntrashPhotosCommand * self,
                                            gpointer klass)
{
	self->priv = trash_untrash_photos_command_get_instance_private (self);
}

static void
trash_untrash_photos_command_finalize (GObject * obj)
{
	TrashUntrashPhotosCommand * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	VideoSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRASH_UNTRASH_PHOTOS_COMMAND, TrashUntrashPhotosCommand);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _trash_untrash_photos_command_on_photo_destroyed_source_collection_item_destroyed, self);
	_tmp2_ = video_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((SourceCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _trash_untrash_photos_command_on_photo_destroyed_source_collection_item_destroyed, self);
	_g_object_unref0 (self->priv->sources);
	G_OBJECT_CLASS (trash_untrash_photos_command_parent_class)->finalize (obj);
}

static GType
trash_untrash_photos_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrashUntrashPhotosCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trash_untrash_photos_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrashUntrashPhotosCommand), 0, (GInstanceInitFunc) trash_untrash_photos_command_instance_init, NULL };
	GType trash_untrash_photos_command_type_id;
	trash_untrash_photos_command_type_id = g_type_register_static (TYPE_PAGE_COMMAND, "TrashUntrashPhotosCommand", &g_define_type_info, 0);
	TrashUntrashPhotosCommand_private_offset = g_type_add_instance_private (trash_untrash_photos_command_type_id, sizeof (TrashUntrashPhotosCommandPrivate));
	return trash_untrash_photos_command_type_id;
}

GType
trash_untrash_photos_command_get_type (void)
{
	static volatile gsize trash_untrash_photos_command_type_id__once = 0;
	if (g_once_init_enter (&trash_untrash_photos_command_type_id__once)) {
		GType trash_untrash_photos_command_type_id;
		trash_untrash_photos_command_type_id = trash_untrash_photos_command_get_type_once ();
		g_once_init_leave (&trash_untrash_photos_command_type_id__once, trash_untrash_photos_command_type_id);
	}
	return trash_untrash_photos_command_type_id__once;
}

static inline gpointer
flag_unflag_command_get_instance_private (FlagUnflagCommand* self)
{
	return G_STRUCT_MEMBER_P (self, FlagUnflagCommand_private_offset);
}

FlagUnflagCommand*
flag_unflag_command_construct (GType object_type,
                               GeeCollection* sources,
                               gboolean flag)
{
	FlagUnflagCommand * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (sources != NULL, NULL);
	if (flag) {
		_tmp0_ = _ ("Flag");
	} else {
		_tmp0_ = _ ("Unflag");
	}
	if (flag) {
		_tmp1_ = FLAG_UNFLAG_COMMAND_FLAG_SELECTED_STRING;
	} else {
		_tmp1_ = FLAG_UNFLAG_COMMAND_UNFLAG_SELECTED_STRING;
	}
	self = (FlagUnflagCommand*) multiple_data_source_at_once_command_construct (object_type, sources, _tmp0_, _tmp1_);
	self->priv->flag = flag;
	_tmp2_ = gee_collection_get_size (sources);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= FLAG_UNFLAG_COMMAND_MIN_PROGRESS_BAR_THRESHOLD) {
		const gchar* _tmp4_ = NULL;
		ProgressDialog* _tmp5_;
		ProgressDialog* _tmp6_;
		if (flag) {
			_tmp4_ = FLAG_UNFLAG_COMMAND_FLAG_PROGRESS;
		} else {
			_tmp4_ = FLAG_UNFLAG_COMMAND_UNFLAG_PROGRESS;
		}
		_tmp5_ = progress_dialog_new (NULL, _tmp4_, NULL);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->progress_dialog);
		self->priv->progress_dialog = _tmp5_;
		_tmp6_ = self->priv->progress_dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
	}
	return self;
}

FlagUnflagCommand*
flag_unflag_command_new (GeeCollection* sources,
                         gboolean flag)
{
	return flag_unflag_command_construct (TYPE_FLAG_UNFLAG_COMMAND, sources, flag);
}

static void
flag_unflag_command_real_execute_on_all (MultipleDataSourceAtOnceCommand* base,
                                         GeeCollection* sources)
{
	FlagUnflagCommand * self;
	gint num_processed = 0;
	ProgressDialog* _tmp11_;
	self = (FlagUnflagCommand*) base;
	g_return_if_fail (sources != NULL);
	num_processed = 0;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* _tmp4_;
			gint _tmp5_;
			ProgressDialog* _tmp6_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			flag_unflag_command_flag_unflag (self, _tmp4_, self->priv->flag);
			_tmp5_ = num_processed;
			num_processed = _tmp5_ + 1;
			_tmp6_ = self->priv->progress_dialog;
			if (_tmp6_ != NULL) {
				ProgressDialog* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				ProgressDialog* _tmp10_;
				_tmp7_ = self->priv->progress_dialog;
				_tmp8_ = gee_collection_get_size (sources);
				_tmp9_ = _tmp8_;
				progress_dialog_set_fraction (_tmp7_, num_processed, _tmp9_);
				_tmp10_ = self->priv->progress_dialog;
				gtk_widget_queue_draw ((GtkWidget*) _tmp10_);
				spin_event_loop ();
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp11_ = self->priv->progress_dialog;
	if (_tmp11_ != NULL) {
		ProgressDialog* _tmp12_;
		_tmp12_ = self->priv->progress_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp12_);
	}
}

static void
flag_unflag_command_real_undo_on_all (MultipleDataSourceAtOnceCommand* base,
                                      GeeCollection* sources)
{
	FlagUnflagCommand * self;
	self = (FlagUnflagCommand*) base;
	g_return_if_fail (sources != NULL);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) sources);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* _tmp4_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = source;
			flag_unflag_command_flag_unflag (self, _tmp4_, !self->priv->flag);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
}

static void
flag_unflag_command_flag_unflag (FlagUnflagCommand* self,
                                 DataSource* source,
                                 gboolean flag)
{
	Flaggable* flaggable = NULL;
	Flaggable* _tmp0_;
	Flaggable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (IS_FLAGGABLE (source) ? ((Flaggable*) source) : NULL);
	flaggable = _tmp0_;
	_tmp1_ = flaggable;
	if (_tmp1_ != NULL) {
		if (flag) {
			Flaggable* _tmp2_;
			_tmp2_ = flaggable;
			flaggable_mark_flagged (_tmp2_);
		} else {
			Flaggable* _tmp3_;
			_tmp3_ = flaggable;
			flaggable_mark_unflagged (_tmp3_);
		}
	}
	_g_object_unref0 (flaggable);
}

static void
flag_unflag_command_class_init (FlagUnflagCommandClass * klass,
                                gpointer klass_data)
{
	flag_unflag_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FlagUnflagCommand_private_offset);
	((MultipleDataSourceAtOnceCommandClass *) klass)->execute_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) flag_unflag_command_real_execute_on_all;
	((MultipleDataSourceAtOnceCommandClass *) klass)->undo_on_all = (void (*) (MultipleDataSourceAtOnceCommand*, GeeCollection*)) flag_unflag_command_real_undo_on_all;
	G_OBJECT_CLASS (klass)->finalize = flag_unflag_command_finalize;
}

static void
flag_unflag_command_instance_init (FlagUnflagCommand * self,
                                   gpointer klass)
{
	self->priv = flag_unflag_command_get_instance_private (self);
	self->priv->progress_dialog = NULL;
}

static void
flag_unflag_command_finalize (GObject * obj)
{
	FlagUnflagCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FLAG_UNFLAG_COMMAND, FlagUnflagCommand);
	_g_object_unref0 (self->priv->progress_dialog);
	G_OBJECT_CLASS (flag_unflag_command_parent_class)->finalize (obj);
}

static GType
flag_unflag_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FlagUnflagCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flag_unflag_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlagUnflagCommand), 0, (GInstanceInitFunc) flag_unflag_command_instance_init, NULL };
	GType flag_unflag_command_type_id;
	flag_unflag_command_type_id = g_type_register_static (TYPE_MULTIPLE_DATA_SOURCE_AT_ONCE_COMMAND, "FlagUnflagCommand", &g_define_type_info, 0);
	FlagUnflagCommand_private_offset = g_type_add_instance_private (flag_unflag_command_type_id, sizeof (FlagUnflagCommandPrivate));
	return flag_unflag_command_type_id;
}

GType
flag_unflag_command_get_type (void)
{
	static volatile gsize flag_unflag_command_type_id__once = 0;
	if (g_once_init_enter (&flag_unflag_command_type_id__once)) {
		GType flag_unflag_command_type_id;
		flag_unflag_command_type_id = flag_unflag_command_get_type_once ();
		g_once_init_leave (&flag_unflag_command_type_id__once, flag_unflag_command_type_id);
	}
	return flag_unflag_command_type_id__once;
}

