/* MediaMetadata.c generated by valac 0.56.18, the Vala compiler
 * generated from MediaMetadata.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <stdio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _ParamSpecMediaMetadata ParamSpecMediaMetadata;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ParamSpecMetadataDateTime ParamSpecMetadataDateTime;

struct _ParamSpecMediaMetadata {
	GParamSpec parent_instance;
};

struct _MetadataDateTimePrivate {
	gint64 timestamp;
};

struct _ParamSpecMetadataDateTime {
	GParamSpec parent_instance;
};

static gpointer media_metadata_parent_class = NULL;
static gint MetadataDateTime_private_offset;
static gpointer metadata_date_time_parent_class = NULL;

static void media_metadata_real_read_from_file (MediaMetadata* self,
                                         GFile* file,
                                         GError** error);
static MetadataDateTime* media_metadata_real_get_creation_date_time (MediaMetadata* self);
static gchar* media_metadata_real_get_title (MediaMetadata* self);
static gchar* media_metadata_real_get_comment (MediaMetadata* self);
static void media_metadata_finalize (MediaMetadata * obj);
static GType media_metadata_get_type_once (void);
static gboolean metadata_rational_is_component_valid (MetadataRational *self,
                                               gint component);
static gboolean metadata_date_time_from_exif_date_time (const gchar* date_time_s,
                                                 gint64* timestamp);
static void metadata_date_time_finalize (MetadataDateTime * obj);
static GType metadata_date_time_get_type_once (void);

MediaMetadata*
media_metadata_construct (GType object_type)
{
	MediaMetadata* self = NULL;
	self = (MediaMetadata*) g_type_create_instance (object_type);
	return self;
}

static void
media_metadata_real_read_from_file (MediaMetadata* self,
                                    GFile* file,
                                    GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `media_metadata_read_from_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
media_metadata_read_from_file (MediaMetadata* self,
                               GFile* file,
                               GError** error)
{
	MediaMetadataClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MEDIA_METADATA_GET_CLASS (self);
	if (_klass_->read_from_file) {
		_klass_->read_from_file (self, file, error);
	}
}

static MetadataDateTime*
media_metadata_real_get_creation_date_time (MediaMetadata* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_metadata_get_creation_date_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

MetadataDateTime*
media_metadata_get_creation_date_time (MediaMetadata* self)
{
	MediaMetadataClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MEDIA_METADATA_GET_CLASS (self);
	if (_klass_->get_creation_date_time) {
		return _klass_->get_creation_date_time (self);
	}
	return NULL;
}

static gchar*
media_metadata_real_get_title (MediaMetadata* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_metadata_get_title'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
media_metadata_get_title (MediaMetadata* self)
{
	MediaMetadataClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MEDIA_METADATA_GET_CLASS (self);
	if (_klass_->get_title) {
		return _klass_->get_title (self);
	}
	return NULL;
}

static gchar*
media_metadata_real_get_comment (MediaMetadata* self)
{
	g_critical ("Type `%s' does not implement abstract method `media_metadata_get_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
media_metadata_get_comment (MediaMetadata* self)
{
	MediaMetadataClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = MEDIA_METADATA_GET_CLASS (self);
	if (_klass_->get_comment) {
		return _klass_->get_comment (self);
	}
	return NULL;
}

static void
value_media_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_media_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		media_metadata_unref (value->data[0].v_pointer);
	}
}

static void
value_media_metadata_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = media_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_media_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_media_metadata_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MediaMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = media_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_media_metadata_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	MediaMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = media_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_media_metadata (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecMediaMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MEDIA_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_media_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_METADATA), NULL);
	return value->data[0].v_pointer;
}

void
value_set_media_metadata (GValue* value,
                          gpointer v_object)
{
	MediaMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		media_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		media_metadata_unref (old);
	}
}

void
value_take_media_metadata (GValue* value,
                           gpointer v_object)
{
	MediaMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MEDIA_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MEDIA_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		media_metadata_unref (old);
	}
}

static void
media_metadata_class_init (MediaMetadataClass * klass,
                           gpointer klass_data)
{
	media_metadata_parent_class = g_type_class_peek_parent (klass);
	((MediaMetadataClass *) klass)->finalize = media_metadata_finalize;
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata*, GFile*, GError**)) media_metadata_real_read_from_file;
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata*)) media_metadata_real_get_creation_date_time;
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata*)) media_metadata_real_get_title;
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata*)) media_metadata_real_get_comment;
}

static void
media_metadata_instance_init (MediaMetadata * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
media_metadata_finalize (MediaMetadata * obj)
{
	MediaMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_METADATA, MediaMetadata);
	g_signal_handlers_destroy (self);
}

static GType
media_metadata_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_media_metadata_init, value_media_metadata_free_value, value_media_metadata_copy_value, value_media_metadata_peek_pointer, "p", value_media_metadata_collect_value, "p", value_media_metadata_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MediaMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaMetadata), 0, (GInstanceInitFunc) media_metadata_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType media_metadata_type_id;
	media_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MediaMetadata", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return media_metadata_type_id;
}

GType
media_metadata_get_type (void)
{
	static volatile gsize media_metadata_type_id__once = 0;
	if (g_once_init_enter (&media_metadata_type_id__once)) {
		GType media_metadata_type_id;
		media_metadata_type_id = media_metadata_get_type_once ();
		g_once_init_leave (&media_metadata_type_id__once, media_metadata_type_id);
	}
	return media_metadata_type_id__once;
}

gpointer
media_metadata_ref (gpointer instance)
{
	MediaMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
media_metadata_unref (gpointer instance)
{
	MediaMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MEDIA_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
metadata_rational_init (MetadataRational *self,
                        gint numerator,
                        gint denominator)
{
	memset (self, 0, sizeof (MetadataRational));
	(*self).numerator = numerator;
	(*self).denominator = denominator;
}

static gboolean
metadata_rational_is_component_valid (MetadataRational *self,
                                      gint component)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (component >= 0) {
		_tmp0_ = component <= 1000000;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
metadata_rational_is_valid (MetadataRational *self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (metadata_rational_is_component_valid (&(*self), (*self).numerator)) {
		_tmp0_ = metadata_rational_is_component_valid (&(*self), (*self).denominator);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
metadata_rational_to_string (MetadataRational *self)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	if (metadata_rational_is_valid (&(*self))) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%d/%d", (*self).numerator, (*self).denominator);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

MetadataRational*
metadata_rational_dup (const MetadataRational* self)
{
	MetadataRational* dup;
	dup = g_new0 (MetadataRational, 1);
	memcpy (dup, self, sizeof (MetadataRational));
	return dup;
}

void
metadata_rational_free (MetadataRational* self)
{
	g_free (self);
}

static GType
metadata_rational_get_type_once (void)
{
	GType metadata_rational_type_id;
	metadata_rational_type_id = g_boxed_type_register_static ("MetadataRational", (GBoxedCopyFunc) metadata_rational_dup, (GBoxedFreeFunc) metadata_rational_free);
	return metadata_rational_type_id;
}

GType
metadata_rational_get_type (void)
{
	static volatile gsize metadata_rational_type_id__once = 0;
	if (g_once_init_enter (&metadata_rational_type_id__once)) {
		GType metadata_rational_type_id;
		metadata_rational_type_id = metadata_rational_get_type_once ();
		g_once_init_leave (&metadata_rational_type_id__once, metadata_rational_type_id);
	}
	return metadata_rational_type_id__once;
}

GQuark
metadata_date_time_error_quark (void)
{
	return g_quark_from_static_string ("metadata-date-time-error-quark");
}

static GType
metadata_date_time_error_get_type_once (void)
{
	static const GEnumValue values[] = {{METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "METADATA_DATE_TIME_ERROR_INVALID_FORMAT", "invalid-format"}, {METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT, "METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT", "unsupported-format"}, {0, NULL, NULL}};
	GType metadata_date_time_error_type_id;
	metadata_date_time_error_type_id = g_enum_register_static ("MetadataDateTimeError", values);
	return metadata_date_time_error_type_id;
}

GType
metadata_date_time_error_get_type (void)
{
	static volatile gsize metadata_date_time_error_type_id__once = 0;
	if (g_once_init_enter (&metadata_date_time_error_type_id__once)) {
		GType metadata_date_time_error_type_id;
		metadata_date_time_error_type_id = metadata_date_time_error_get_type_once ();
		g_once_init_leave (&metadata_date_time_error_type_id__once, metadata_date_time_error_type_id);
	}
	return metadata_date_time_error_type_id__once;
}

static inline gpointer
metadata_date_time_get_instance_private (MetadataDateTime* self)
{
	return G_STRUCT_MEMBER_P (self, MetadataDateTime_private_offset);
}

MetadataDateTime*
metadata_date_time_construct (GType object_type,
                              gint64 timestamp)
{
	MetadataDateTime* self = NULL;
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	self->priv->timestamp = timestamp;
	return self;
}

MetadataDateTime*
metadata_date_time_new (gint64 timestamp)
{
	return metadata_date_time_construct (TYPE_METADATA_DATE_TIME, timestamp);
}

MetadataDateTime*
metadata_date_time_construct_from_exif (GType object_type,
                                        const gchar* label,
                                        GError** error)
{
	MetadataDateTime* self = NULL;
	gint64 _tmp0_ = 0LL;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	_tmp1_ = metadata_date_time_from_exif_date_time (label, &_tmp0_);
	self->priv->timestamp = _tmp0_;
	if (!_tmp1_) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "%s is not EXIF format date/time", label);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == METADATA_DATE_TIME_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_metadata_date_time_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

MetadataDateTime*
metadata_date_time_new_from_exif (const gchar* label,
                                  GError** error)
{
	return metadata_date_time_construct_from_exif (TYPE_METADATA_DATE_TIME, label, error);
}

MetadataDateTime*
metadata_date_time_construct_from_xmp (GType object_type,
                                       const gchar* label,
                                       GError** error)
{
	MetadataDateTime* self = NULL;
	GDateTime* date_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (MetadataDateTime*) g_type_create_instance (object_type);
	_tmp0_ = g_date_time_new_from_iso8601 (label, NULL);
	date_time = _tmp0_;
	_tmp1_ = date_time;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (METADATA_DATE_TIME_ERROR, METADATA_DATE_TIME_ERROR_INVALID_FORMAT, "%s is not XMP format date/time", label);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == METADATA_DATE_TIME_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (date_time);
			_metadata_date_time_unref0 (self);
			return NULL;
		} else {
			_g_date_time_unref0 (date_time);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = date_time;
	self->priv->timestamp = g_date_time_to_unix (_tmp3_);
	_g_date_time_unref0 (date_time);
	return self;
}

MetadataDateTime*
metadata_date_time_new_from_xmp (const gchar* label,
                                 GError** error)
{
	return metadata_date_time_construct_from_xmp (TYPE_METADATA_DATE_TIME, label, error);
}

gint64
metadata_date_time_get_timestamp (MetadataDateTime* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->timestamp;
	return result;
}

gchar*
metadata_date_time_get_exif_label (MetadataDateTime* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_new_from_unix_utc (self->priv->timestamp);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%Y:%m:%d %H:%M:%S");
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
metadata_date_time_get_xmp_label (MetadataDateTime* self)
{
	GDateTime* date_time = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_new_from_unix_utc (self->priv->timestamp);
	date_time = _tmp0_;
	_tmp1_ = g_date_time_format_iso8601 (date_time);
	result = _tmp1_;
	_g_date_time_unref0 (date_time);
	return result;
}

static gboolean
metadata_date_time_from_exif_date_time (const gchar* date_time_s,
                                        gint64* timestamp)
{
	gint64 _vala_timestamp = 0LL;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gint second = 0;
	GDateTime* date_time = NULL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gboolean result;
	g_return_val_if_fail (date_time_s != NULL, FALSE);
	_vala_timestamp = (gint64) 0;
	year = 0;
	month = 0;
	day = 0;
	hour = 0;
	minute = 0;
	second = 0;
	if (sscanf (date_time_s, "%d:%d:%d %d:%d:%d", &year, &month, &day, &hour, &minute, &second) != 6) {
		gchar* tmp = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = g_strdup (date_time_s);
		tmp = _tmp0_;
		_tmp1_ = tmp;
		g_strcanon (_tmp1_, "0123456789", ' ');
		_tmp2_ = tmp;
		if (sscanf (_tmp2_, "%4d%2d%2d%2d%2d%2d", year, month, day, hour, minute, second) != 6) {
			result = FALSE;
			_g_free0 (tmp);
			if (timestamp) {
				*timestamp = _vala_timestamp;
			}
			return result;
		}
		_g_free0 (tmp);
	}
	_tmp3_ = g_date_time_new_local (year, month, day, hour, minute, (gdouble) second);
	date_time = _tmp3_;
	_tmp4_ = date_time;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_date_time_unref0 (date_time);
		if (timestamp) {
			*timestamp = _vala_timestamp;
		}
		return result;
	}
	_tmp5_ = date_time;
	_vala_timestamp = g_date_time_to_unix (_tmp5_);
	result = TRUE;
	_g_date_time_unref0 (date_time);
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	return result;
}

static void
value_metadata_date_time_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_metadata_date_time_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		metadata_date_time_unref (value->data[0].v_pointer);
	}
}

static void
value_metadata_date_time_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = metadata_date_time_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_metadata_date_time_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_metadata_date_time_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MetadataDateTime * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = metadata_date_time_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_metadata_date_time_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	MetadataDateTime ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = metadata_date_time_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_metadata_date_time (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecMetadataDateTime* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_METADATA_DATE_TIME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_metadata_date_time (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME), NULL);
	return value->data[0].v_pointer;
}

void
value_set_metadata_date_time (GValue* value,
                              gpointer v_object)
{
	MetadataDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METADATA_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		metadata_date_time_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		metadata_date_time_unref (old);
	}
}

void
value_take_metadata_date_time (GValue* value,
                               gpointer v_object)
{
	MetadataDateTime * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METADATA_DATE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METADATA_DATE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		metadata_date_time_unref (old);
	}
}

static void
metadata_date_time_class_init (MetadataDateTimeClass * klass,
                               gpointer klass_data)
{
	metadata_date_time_parent_class = g_type_class_peek_parent (klass);
	((MetadataDateTimeClass *) klass)->finalize = metadata_date_time_finalize;
	g_type_class_adjust_private_offset (klass, &MetadataDateTime_private_offset);
}

static void
metadata_date_time_instance_init (MetadataDateTime * self,
                                  gpointer klass)
{
	self->priv = metadata_date_time_get_instance_private (self);
	self->ref_count = 1;
}

static void
metadata_date_time_finalize (MetadataDateTime * obj)
{
	MetadataDateTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_METADATA_DATE_TIME, MetadataDateTime);
	g_signal_handlers_destroy (self);
}

static GType
metadata_date_time_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_metadata_date_time_init, value_metadata_date_time_free_value, value_metadata_date_time_copy_value, value_metadata_date_time_peek_pointer, "p", value_metadata_date_time_collect_value, "p", value_metadata_date_time_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MetadataDateTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_date_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataDateTime), 0, (GInstanceInitFunc) metadata_date_time_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType metadata_date_time_type_id;
	metadata_date_time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MetadataDateTime", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MetadataDateTime_private_offset = g_type_add_instance_private (metadata_date_time_type_id, sizeof (MetadataDateTimePrivate));
	return metadata_date_time_type_id;
}

GType
metadata_date_time_get_type (void)
{
	static volatile gsize metadata_date_time_type_id__once = 0;
	if (g_once_init_enter (&metadata_date_time_type_id__once)) {
		GType metadata_date_time_type_id;
		metadata_date_time_type_id = metadata_date_time_get_type_once ();
		g_once_init_leave (&metadata_date_time_type_id__once, metadata_date_time_type_id);
	}
	return metadata_date_time_type_id__once;
}

gpointer
metadata_date_time_ref (gpointer instance)
{
	MetadataDateTime * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
metadata_date_time_unref (gpointer instance)
{
	MetadataDateTime * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		METADATA_DATE_TIME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

