/* AliasDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AliasDialog.vala, do not modify */

/*
* Copyright (c) 2017-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>
*
* Authored by: Leonhard Kargl <leo.kargl@proton.me>
*/

#include <granite.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <camel/camel.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <libedataserver/libedataserver.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_ALIAS_DIALOG (mail_alias_dialog_get_type ())
#define MAIL_ALIAS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ALIAS_DIALOG, MailAliasDialog))
#define MAIL_ALIAS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ALIAS_DIALOG, MailAliasDialogClass))
#define MAIL_IS_ALIAS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ALIAS_DIALOG))
#define MAIL_IS_ALIAS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ALIAS_DIALOG))
#define MAIL_ALIAS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ALIAS_DIALOG, MailAliasDialogClass))

typedef struct _MailAliasDialog MailAliasDialog;
typedef struct _MailAliasDialogClass MailAliasDialogClass;
typedef struct _MailAliasDialogPrivate MailAliasDialogPrivate;
enum  {
	MAIL_ALIAS_DIALOG_0_PROPERTY,
	MAIL_ALIAS_DIALOG_ACCOUNT_UID_PROPERTY,
	MAIL_ALIAS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* mail_alias_dialog_properties[MAIL_ALIAS_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAIL_TYPE_ALIAS (mail_alias_get_type ())
#define MAIL_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ALIAS, MailAlias))
#define MAIL_ALIAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ALIAS, MailAliasClass))
#define MAIL_IS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ALIAS))
#define MAIL_IS_ALIAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ALIAS))
#define MAIL_ALIAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ALIAS, MailAliasClass))

typedef struct _MailAlias MailAlias;
typedef struct _MailAliasClass MailAliasClass;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
typedef struct _Block37Data Block37Data;
typedef struct _Block38Data Block38Data;

struct _MailAliasDialog {
	GraniteDialog parent_instance;
	MailAliasDialogPrivate * priv;
};

struct _MailAliasDialogClass {
	GraniteDialogClass parent_class;
};

struct _MailAliasDialogPrivate {
	gchar* _account_uid;
	GHashTable* aliases;
	GtkListBox* list;
	GraniteWidgetsToast* toast;
	gchar* primary_name;
};

struct _Block37Data {
	int _ref_count_;
	MailAliasDialog* self;
	MailAlias* alias;
};

struct _Block38Data {
	int _ref_count_;
	MailAliasDialog* self;
	CamelInternetAddress* encoded_aliases;
};

static gint MailAliasDialog_private_offset;
static gpointer mail_alias_dialog_parent_class = NULL;

VALA_EXTERN GType mail_alias_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAliasDialog, g_object_unref)
VALA_EXTERN MailAliasDialog* mail_alias_dialog_new (const gchar* account_uid);
VALA_EXTERN MailAliasDialog* mail_alias_dialog_construct (GType object_type,
                                              const gchar* account_uid);
VALA_EXTERN GType mail_alias_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAlias, g_object_unref)
static gboolean mail_alias_dialog_filter_func (MailAlias* alias);
VALA_EXTERN gboolean mail_alias_get_is_deleted (MailAlias* self);
static void mail_alias_dialog_populate_list (MailAliasDialog* self);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN GHashTable* mail_backend_session_get_aliases_for_account_uid (MailBackendSession* self,
                                                              const gchar* uid);
VALA_EXTERN const gchar* mail_alias_dialog_get_account_uid (MailAliasDialog* self);
static void _g_free0_ (gpointer var);
static void mail_alias_dialog_add_alias (MailAliasDialog* self,
                                  const gchar* address,
                                  const gchar* name);
static void mail_alias_dialog_create_new_alias (MailAliasDialog* self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
VALA_EXTERN MailAlias* mail_alias_new (const gchar* address,
                           const gchar* alias_name);
VALA_EXTERN MailAlias* mail_alias_construct (GType object_type,
                                 const gchar* address,
                                 const gchar* alias_name);
static void __lambda27_ (Block37Data* _data37_,
                  const gchar* old_address);
VALA_EXTERN const gchar* mail_alias_get_address (MailAlias* self);
VALA_EXTERN const gchar* mail_alias_get_alias_name (MailAlias* self);
static void mail_alias_dialog_write_aliases (MailAliasDialog* self);
static void ___lambda27__mail_alias_save (MailAlias* _sender,
                                   const gchar* old_address,
                                   gpointer self);
static void __lambda29_ (Block37Data* _data37_);
static void ___lambda29__mail_alias_start_delete (MailAlias* _sender,
                                           gpointer self);
static void __lambda30_ (Block37Data* _data37_);
static void ___lambda30__mail_alias_finish_delete (MailAlias* _sender,
                                            gpointer self);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda28_ (Block38Data* _data38_,
                  const gchar* key,
                  const gchar* val);
static void ___lambda28__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
VALA_EXTERN void mail_backend_session_set_aliases_for_account_uid (MailBackendSession* self,
                                                       const gchar* uid,
                                                       const gchar* encoded_aliases,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN void mail_backend_session_set_aliases_for_account_uid_finish (MailBackendSession* self,
                                                              GAsyncResult* _res_);
static void mail_alias_dialog_set_account_uid (MailAliasDialog* self,
                                        const gchar* value);
static GObject * mail_alias_dialog_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN ESource* mail_backend_session_get_identity_source_for_account_uid (MailBackendSession* self,
                                                                   const gchar* account_uid);
static void _mail_alias_dialog___lambda31_ (MailAliasDialog* self);
static void __mail_alias_dialog___lambda31__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
static void _mail_alias_dialog___lambda32_ (MailAliasDialog* self);
VALA_EXTERN void mail_alias_undo_delete (MailAlias* self);
static void __mail_alias_dialog___lambda32__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                           gpointer self);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static gboolean _mail_alias_dialog___lambda33_ (MailAliasDialog* self);
static gboolean __mail_alias_dialog___lambda33__gtk_widget_delete_event (GtkWidget* _sender,
                                                                  GdkEventAny* event,
                                                                  gpointer self);
static void mail_alias_dialog_finalize (GObject * obj);
static GType mail_alias_dialog_get_type_once (void);
static void _vala_mail_alias_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_mail_alias_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
mail_alias_dialog_get_instance_private (MailAliasDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MailAliasDialog_private_offset);
}

MailAliasDialog*
mail_alias_dialog_construct (GType object_type,
                             const gchar* account_uid)
{
	MailAliasDialog * self = NULL;
	g_return_val_if_fail (account_uid != NULL, NULL);
	self = (MailAliasDialog*) g_object_new (object_type, "account-uid", account_uid, NULL);
	return self;
}

MailAliasDialog*
mail_alias_dialog_new (const gchar* account_uid)
{
	return mail_alias_dialog_construct (MAIL_TYPE_ALIAS_DIALOG, account_uid);
}

static gboolean
mail_alias_dialog_filter_func (MailAlias* alias)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (alias != NULL, FALSE);
	_tmp0_ = mail_alias_get_is_deleted (alias);
	_tmp1_ = _tmp0_;
	result = !_tmp1_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
mail_alias_dialog_populate_list (MailAliasDialog* self)
{
	MailBackendSession* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp7_;
	GList* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mail_backend_session_get_default ();
	_tmp1_ = self->priv->_account_uid;
	_tmp2_ = mail_backend_session_get_aliases_for_account_uid (_tmp0_, _tmp1_);
	_g_hash_table_unref0 (self->priv->aliases);
	self->priv->aliases = _tmp2_;
	_tmp3_ = self->priv->aliases;
	if (_tmp3_ == NULL) {
		GHashFunc _tmp4_;
		GEqualFunc _tmp5_;
		GHashTable* _tmp6_;
		_tmp4_ = g_str_hash;
		_tmp5_ = g_str_equal;
		_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (self->priv->aliases);
		self->priv->aliases = _tmp6_;
	}
	_tmp7_ = self->priv->aliases;
	_tmp8_ = g_hash_table_get_keys (_tmp7_);
	{
		GList* address_collection = NULL;
		GList* address_it = NULL;
		address_collection = _tmp8_;
		for (address_it = address_collection; address_it != NULL; address_it = address_it->next) {
			const gchar* address = NULL;
			address = (const gchar*) address_it->data;
			{
				const gchar* _tmp9_;
				GHashTable* _tmp10_;
				const gchar* _tmp11_;
				gconstpointer _tmp12_;
				_tmp9_ = address;
				_tmp10_ = self->priv->aliases;
				_tmp11_ = address;
				_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
				mail_alias_dialog_add_alias (self, _tmp9_, (const gchar*) _tmp12_);
			}
		}
		(address_collection == NULL) ? NULL : (address_collection = (g_list_free (address_collection), NULL));
	}
}

static void
mail_alias_dialog_create_new_alias (MailAliasDialog* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_name;
	mail_alias_dialog_add_alias (self, "", _tmp0_);
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		MailAliasDialog* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->alias);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static void
__lambda27_ (Block37Data* _data37_,
             const gchar* old_address)
{
	MailAliasDialog* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	self = _data37_->self;
	g_return_if_fail (old_address != NULL);
	_tmp0_ = mail_alias_get_address (_data37_->alias);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (old_address, _tmp1_) != 0) {
		GHashTable* _tmp2_;
		_tmp2_ = self->priv->aliases;
		g_hash_table_remove (_tmp2_, old_address);
	}
	_tmp3_ = self->priv->aliases;
	_tmp4_ = mail_alias_get_address (_data37_->alias);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = mail_alias_get_alias_name (_data37_->alias);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	g_hash_table_insert (_tmp3_, _tmp6_, _tmp9_);
	mail_alias_dialog_write_aliases (self);
}

static void
___lambda27__mail_alias_save (MailAlias* _sender,
                              const gchar* old_address,
                              gpointer self)
{
	__lambda27_ (self, old_address);
}

static void
__lambda29_ (Block37Data* _data37_)
{
	MailAliasDialog* self;
	GtkListBox* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GraniteWidgetsToast* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GraniteWidgetsToast* _tmp11_;
	self = _data37_->self;
	_tmp0_ = self->priv->list;
	gtk_list_box_invalidate_filter (_tmp0_);
	_tmp2_ = mail_alias_get_alias_name (_data37_->alias);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = mail_alias_get_alias_name (_data37_->alias);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = mail_alias_get_address (_data37_->alias);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = self->priv->toast;
	_tmp9_ = g_strdup_printf (_ ("'%s' deleted"), _tmp1_);
	_tmp10_ = _tmp9_;
	granite_widgets_toast_set_title (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->toast;
	granite_widgets_toast_send_notification (_tmp11_);
}

static void
___lambda29__mail_alias_start_delete (MailAlias* _sender,
                                      gpointer self)
{
	__lambda29_ (self);
}

static void
__lambda30_ (Block37Data* _data37_)
{
	MailAliasDialog* self;
	GtkListBox* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data37_->self;
	_tmp0_ = self->priv->list;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _data37_->alias);
	_tmp1_ = self->priv->aliases;
	_tmp2_ = mail_alias_get_address (_data37_->alias);
	_tmp3_ = _tmp2_;
	g_hash_table_remove (_tmp1_, _tmp3_);
	mail_alias_dialog_write_aliases (self);
}

static void
___lambda30__mail_alias_finish_delete (MailAlias* _sender,
                                       gpointer self)
{
	__lambda30_ (self);
}

static void
mail_alias_dialog_add_alias (MailAliasDialog* self,
                             const gchar* address,
                             const gchar* name)
{
	Block37Data* _data37_;
	const gchar* _tmp0_ = NULL;
	MailAlias* _tmp1_;
	GtkListBox* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = name;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp1_ = mail_alias_new (address, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_data37_->alias = _tmp1_;
	g_signal_connect_data (_data37_->alias, "save", (GCallback) ___lambda27__mail_alias_save, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	g_signal_connect_data (_data37_->alias, "start-delete", (GCallback) ___lambda29__mail_alias_start_delete, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	g_signal_connect_data (_data37_->alias, "finish-delete", (GCallback) ___lambda30__mail_alias_finish_delete, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	_tmp2_ = self->priv->list;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _data37_->alias);
	block37_data_unref (_data37_);
	_data37_ = NULL;
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		MailAliasDialog* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->encoded_aliases);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static void
__lambda28_ (Block38Data* _data38_,
             const gchar* key,
             const gchar* val)
{
	MailAliasDialog* self;
	const gchar* _tmp0_ = NULL;
	CamelInternetAddress* _tmp1_;
	self = _data38_->self;
	g_return_if_fail (key != NULL);
	_tmp0_ = val;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp1_ = _data38_->encoded_aliases;
	camel_internet_address_add (_tmp1_, _tmp0_, key);
}

static void
___lambda28__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda28_ (self, (const gchar*) key, (const gchar*) value);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_alias_dialog_write_aliases (MailAliasDialog* self)
{
	Block38Data* _data38_;
	CamelInternetAddress* _tmp0_;
	GHashTable* _tmp1_;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp2_;
	MailBackendSession* _tmp3_;
	gchar* _tmp4_ = NULL;
	CamelInternetAddress* _tmp5_;
	gchar* _tmp6_;
	MailBackendSession* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = camel_internet_address_new ();
	_data38_->encoded_aliases = _tmp0_;
	_tmp1_ = self->priv->aliases;
	g_hash_table_foreach (_tmp1_, ___lambda28__gh_func, _data38_);
	_tmp2_ = mail_backend_session_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	session = _tmp3_;
	_tmp5_ = _data38_->encoded_aliases;
	_tmp6_ = camel_address_encode ((CamelAddress*) _tmp5_);
	_tmp4_ = _tmp6_;
	if (_tmp4_ == NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp7_;
	}
	_tmp8_ = session;
	_tmp9_ = self->priv->_account_uid;
	mail_backend_session_set_aliases_for_account_uid (_tmp8_, _tmp9_, _tmp4_, NULL, NULL);
	_g_free0 (_tmp4_);
	_g_object_unref0 (session);
	block38_data_unref (_data38_);
	_data38_ = NULL;
}

const gchar*
mail_alias_dialog_get_account_uid (MailAliasDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account_uid;
	result = _tmp0_;
	return result;
}

static void
mail_alias_dialog_set_account_uid (MailAliasDialog* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_alias_dialog_get_account_uid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_account_uid);
		self->priv->_account_uid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_alias_dialog_properties[MAIL_ALIAS_DIALOG_ACCOUNT_UID_PROPERTY]);
	}
}

static void
_mail_alias_dialog___lambda31_ (MailAliasDialog* self)
{
	mail_alias_dialog_create_new_alias (self);
}

static void
__mail_alias_dialog___lambda31__gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
	_mail_alias_dialog___lambda31_ ((MailAliasDialog*) self);
}

static void
_mail_alias_dialog___lambda32_ (MailAliasDialog* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp4_;
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				if (MAIL_IS_ALIAS (_tmp2_)) {
					GtkWidget* _tmp3_;
					_tmp3_ = child;
					mail_alias_undo_delete (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, MAIL_TYPE_ALIAS, MailAlias));
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp4_ = self->priv->list;
	gtk_list_box_invalidate_filter (_tmp4_);
}

static void
__mail_alias_dialog___lambda32__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                      gpointer self)
{
	_mail_alias_dialog___lambda32_ ((MailAliasDialog*) self);
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static gboolean
_mail_alias_dialog___lambda33_ (MailAliasDialog* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				gboolean _tmp2_ = FALSE;
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				if (MAIL_IS_ALIAS (_tmp3_)) {
					GtkWidget* _tmp4_;
					gboolean _tmp5_;
					gboolean _tmp6_;
					_tmp4_ = child;
					_tmp5_ = mail_alias_get_is_deleted (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, MAIL_TYPE_ALIAS, MailAlias));
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GHashTable* _tmp7_;
					GtkWidget* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp7_ = self->priv->aliases;
					_tmp8_ = child;
					_tmp9_ = mail_alias_get_address (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, MAIL_TYPE_ALIAS, MailAlias));
					_tmp10_ = _tmp9_;
					g_hash_table_remove (_tmp7_, _tmp10_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	mail_alias_dialog_write_aliases (self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__mail_alias_dialog___lambda33__gtk_widget_delete_event (GtkWidget* _sender,
                                                         GdkEventAny* event,
                                                         gpointer self)
{
	gboolean result;
	result = _mail_alias_dialog___lambda33_ ((MailAliasDialog*) self);
	return result;
}

static GObject *
mail_alias_dialog_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailAliasDialog * self;
	GtkLabel* placeholder_title = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* placeholder_description = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkBox* placeholder = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkListBox* _tmp12_ = NULL;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkListBox* _tmp16_;
	GtkWidget* _tmp17_;
	GtkScrolledWindow* _tmp18_ = NULL;
	GtkLabel* add_button_label = NULL;
	GtkLabel* _tmp19_;
	GtkBox* add_box = NULL;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkImage* _tmp22_;
	GtkImage* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp26_;
	GtkWidget* _tmp27_;
	GtkButton* _tmp28_ = NULL;
	GtkButton* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkLabel* _tmp31_;
	GtkButton* _tmp32_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp33_;
	GtkActionBar* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkActionBar* _tmp36_;
	GtkButton* _tmp37_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkScrolledWindow* _tmp40_;
	GtkBox* _tmp41_;
	GtkActionBar* _tmp42_;
	GtkFrame* frame = NULL;
	GtkBox* _tmp43_;
	GtkWidget* _tmp44_;
	GtkFrame* _tmp45_ = NULL;
	GraniteWidgetsToast* _tmp46_;
	GraniteWidgetsToast* _tmp47_;
	GtkOverlay* overlay = NULL;
	GtkFrame* _tmp48_;
	GtkWidget* _tmp49_;
	GtkOverlay* _tmp50_ = NULL;
	GtkOverlay* _tmp51_;
	GraniteWidgetsToast* _tmp52_;
	GtkOverlay* _tmp53_;
	GtkBox* _tmp54_;
	GtkOverlay* _tmp55_;
	ESource* identity_source = NULL;
	MailBackendSession* _tmp56_;
	const gchar* _tmp57_;
	ESource* _tmp58_;
	ESourceMailIdentity* extension = NULL;
	ESource* _tmp59_;
	ESourceExtension* _tmp60_;
	ESourceMailIdentity* _tmp61_;
	ESourceMailIdentity* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	GtkButton* _tmp66_;
	GraniteWidgetsToast* _tmp67_;
	parent_class = G_OBJECT_CLASS (mail_alias_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_ALIAS_DIALOG, MailAliasDialog);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("No Aliases"));
	gtk_label_set_xalign (_tmp0_, (gfloat) 0);
	g_object_ref_sink (_tmp0_);
	placeholder_title = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Add aliases using the button in the toolbar below"));
	g_object_set (_tmp1_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	placeholder_description = _tmp1_;
	_tmp2_ = placeholder_description;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp4_ = placeholder_description;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 12);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp6_);
	placeholder = _tmp6_;
	_tmp7_ = placeholder;
	_tmp8_ = placeholder_title;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = placeholder;
	_tmp10_ = placeholder_description;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = placeholder;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp12_;
	_tmp13_ = self->priv->list;
	gtk_list_box_set_filter_func (_tmp13_, (GtkListBoxFilterFunc) mail_alias_dialog_filter_func, NULL, NULL);
	_tmp14_ = self->priv->list;
	_tmp15_ = placeholder;
	gtk_list_box_set_placeholder (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->list;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp18_, "child", _tmp17_, NULL);
	_g_object_unref0 (_tmp17_);
	g_object_set (_tmp18_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp18_);
	scrolled_window = _tmp18_;
	_tmp19_ = (GtkLabel*) gtk_label_new (_ ("Add Alias…"));
	g_object_ref_sink (_tmp19_);
	add_button_label = _tmp19_;
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp20_);
	add_box = _tmp20_;
	_tmp21_ = add_box;
	_tmp22_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = add_box;
	_tmp25_ = add_button_label;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = add_box;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = (GtkButton*) gtk_button_new ();
	g_object_set ((GtkContainer*) _tmp28_, "child", _tmp27_, NULL);
	_g_object_unref0 (_tmp27_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp28_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 3);
	g_object_ref_sink (_tmp28_);
	add_button = _tmp28_;
	_tmp29_ = add_button;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, "image-button");
	_tmp31_ = add_button_label;
	_tmp32_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp33_);
	actionbar = _tmp33_;
	_tmp34_ = actionbar;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	gtk_style_context_add_class (_tmp35_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp36_ = actionbar;
	_tmp37_ = add_button;
	gtk_action_bar_pack_start (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp38_);
	content_box = _tmp38_;
	_tmp39_ = content_box;
	_tmp40_ = scrolled_window;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = content_box;
	_tmp42_ = actionbar;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = content_box;
	_tmp44_ = _g_object_ref0 ((GtkWidget*) _tmp43_);
	_tmp45_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp45_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp45_, 12);
	g_object_set ((GtkContainer*) _tmp45_, "child", _tmp44_, NULL);
	_g_object_unref0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	frame = _tmp45_;
	_tmp46_ = granite_widgets_toast_new ("");
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->toast);
	self->priv->toast = _tmp46_;
	_tmp47_ = self->priv->toast;
	granite_widgets_toast_set_default_action (_tmp47_, _ ("Undo"));
	_tmp48_ = frame;
	_tmp49_ = _g_object_ref0 ((GtkWidget*) _tmp48_);
	_tmp50_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_set ((GtkContainer*) _tmp50_, "child", _tmp49_, NULL);
	_g_object_unref0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	overlay = _tmp50_;
	_tmp51_ = overlay;
	_tmp52_ = self->priv->toast;
	gtk_overlay_add_overlay (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = overlay;
	gtk_widget_show_all ((GtkWidget*) _tmp53_);
	gtk_window_set_title ((GtkWindow*) self, _ ("Aliases"));
	g_object_set ((GtkWindow*) self, "default-height", 300, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 500, NULL);
	_tmp54_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp55_ = overlay;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	_tmp56_ = mail_backend_session_get_default ();
	_tmp57_ = self->priv->_account_uid;
	_tmp58_ = mail_backend_session_get_identity_source_for_account_uid (_tmp56_, _tmp57_);
	identity_source = _tmp58_;
	_tmp59_ = identity_source;
	_tmp60_ = e_source_get_extension (_tmp59_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	_tmp61_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, e_source_mail_identity_get_type (), ESourceMailIdentity));
	extension = _tmp61_;
	_tmp62_ = extension;
	_tmp63_ = e_source_mail_identity_get_name (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = g_strdup (_tmp64_);
	_g_free0 (self->priv->primary_name);
	self->priv->primary_name = _tmp65_;
	mail_alias_dialog_populate_list (self);
	_tmp66_ = add_button;
	g_signal_connect_object (_tmp66_, "clicked", (GCallback) __mail_alias_dialog___lambda31__gtk_button_clicked, self, 0);
	_tmp67_ = self->priv->toast;
	g_signal_connect_object (_tmp67_, "default-action", (GCallback) __mail_alias_dialog___lambda32__granite_widgets_toast_default_action, self, 0);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __mail_alias_dialog___lambda33__gtk_widget_delete_event, self, 0);
	_g_object_unref0 (extension);
	_g_object_unref0 (identity_source);
	_g_object_unref0 (overlay);
	_g_object_unref0 (frame);
	_g_object_unref0 (content_box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_box);
	_g_object_unref0 (add_button_label);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (placeholder_description);
	_g_object_unref0 (placeholder_title);
	return obj;
}

static void
mail_alias_dialog_class_init (MailAliasDialogClass * klass,
                              gpointer klass_data)
{
	mail_alias_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailAliasDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_alias_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_alias_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_alias_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_alias_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_ALIAS_DIALOG_ACCOUNT_UID_PROPERTY, mail_alias_dialog_properties[MAIL_ALIAS_DIALOG_ACCOUNT_UID_PROPERTY] = g_param_spec_string ("account-uid", "account-uid", "account-uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
mail_alias_dialog_instance_init (MailAliasDialog * self,
                                 gpointer klass)
{
	self->priv = mail_alias_dialog_get_instance_private (self);
}

static void
mail_alias_dialog_finalize (GObject * obj)
{
	MailAliasDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_ALIAS_DIALOG, MailAliasDialog);
	_g_free0 (self->priv->_account_uid);
	_g_hash_table_unref0 (self->priv->aliases);
	_g_object_unref0 (self->priv->list);
	_g_object_unref0 (self->priv->toast);
	_g_free0 (self->priv->primary_name);
	G_OBJECT_CLASS (mail_alias_dialog_parent_class)->finalize (obj);
}

static GType
mail_alias_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailAliasDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_alias_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailAliasDialog), 0, (GInstanceInitFunc) mail_alias_dialog_instance_init, NULL };
	GType mail_alias_dialog_type_id;
	mail_alias_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "MailAliasDialog", &g_define_type_info, 0);
	MailAliasDialog_private_offset = g_type_add_instance_private (mail_alias_dialog_type_id, sizeof (MailAliasDialogPrivate));
	return mail_alias_dialog_type_id;
}

GType
mail_alias_dialog_get_type (void)
{
	static volatile gsize mail_alias_dialog_type_id__once = 0;
	if (g_once_init_enter (&mail_alias_dialog_type_id__once)) {
		GType mail_alias_dialog_type_id;
		mail_alias_dialog_type_id = mail_alias_dialog_get_type_once ();
		g_once_init_leave (&mail_alias_dialog_type_id__once, mail_alias_dialog_type_id);
	}
	return mail_alias_dialog_type_id__once;
}

static void
_vala_mail_alias_dialog_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	MailAliasDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_ALIAS_DIALOG, MailAliasDialog);
	switch (property_id) {
		case MAIL_ALIAS_DIALOG_ACCOUNT_UID_PROPERTY:
		g_value_set_string (value, mail_alias_dialog_get_account_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_alias_dialog_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	MailAliasDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_ALIAS_DIALOG, MailAliasDialog);
	switch (property_id) {
		case MAIL_ALIAS_DIALOG_ACCOUNT_UID_PROPERTY:
		mail_alias_dialog_set_account_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

