/* LocationBar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LocationBar.vala, do not modify */

/*
* Copyright (c) 2018 elementary LLC <https://elementary.io>
*               2011 Lucas Baudin <xapantu@gmail.com>
*               2010 mathijshenquet
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-files-core.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_CHROME_TYPE_LOCATION_BAR (files_view_chrome_location_bar_get_type ())
#define FILES_VIEW_CHROME_LOCATION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBar))
#define FILES_VIEW_CHROME_LOCATION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBarClass))
#define FILES_VIEW_CHROME_IS_LOCATION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_LOCATION_BAR))
#define FILES_VIEW_CHROME_IS_LOCATION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_LOCATION_BAR))
#define FILES_VIEW_CHROME_LOCATION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBarClass))

typedef struct _FilesViewChromeLocationBar FilesViewChromeLocationBar;
typedef struct _FilesViewChromeLocationBarClass FilesViewChromeLocationBarClass;
typedef struct _FilesViewChromeLocationBarPrivate FilesViewChromeLocationBarPrivate;

#define FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY (files_view_chrome_breadcrumbs_entry_get_type ())
#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntry))
#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntryClass))
#define FILES_VIEW_CHROME_IS_BREADCRUMBS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY))
#define FILES_VIEW_CHROME_IS_BREADCRUMBS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY))
#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntryClass))

typedef struct _FilesViewChromeBreadcrumbsEntry FilesViewChromeBreadcrumbsEntry;
typedef struct _FilesViewChromeBreadcrumbsEntryClass FilesViewChromeBreadcrumbsEntryClass;

#define FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS (files_view_chrome_search_results_get_type ())
#define FILES_VIEW_CHROME_SEARCH_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResults))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResultsClass))
#define FILES_VIEW_CHROME_IS_SEARCH_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS))
#define FILES_VIEW_CHROME_IS_SEARCH_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResultsClass))

typedef struct _FilesViewChromeSearchResults FilesViewChromeSearchResults;
typedef struct _FilesViewChromeSearchResultsClass FilesViewChromeSearchResultsClass;
enum  {
	FILES_VIEW_CHROME_LOCATION_BAR_0_PROPERTY,
	FILES_VIEW_CHROME_LOCATION_BAR_SEARCH_MODE_PROPERTY,
	FILES_VIEW_CHROME_LOCATION_BAR_SENSITIVE_PROPERTY,
	FILES_VIEW_CHROME_LOCATION_BAR_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_location_bar_properties[FILES_VIEW_CHROME_LOCATION_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block58Data Block58Data;
enum  {
	FILES_VIEW_CHROME_LOCATION_BAR_FOCUS_FILE_REQUEST_SIGNAL,
	FILES_VIEW_CHROME_LOCATION_BAR_ESCAPE_SIGNAL,
	FILES_VIEW_CHROME_LOCATION_BAR_NUM_SIGNALS
};
static guint files_view_chrome_location_bar_signals[FILES_VIEW_CHROME_LOCATION_BAR_NUM_SIGNALS] = {0};

struct _FilesViewChromeLocationBar {
	FilesViewChromeBasicLocationBar parent_instance;
	FilesViewChromeLocationBarPrivate * priv;
};

struct _FilesViewChromeLocationBarClass {
	FilesViewChromeBasicLocationBarClass parent_class;
	gboolean (*enter_navigate_mode) (FilesViewChromeLocationBar* self, const gchar* current);
};

struct _FilesViewChromeLocationBarPrivate {
	GtkRevealer* admin_revealer;
	FilesViewChromeBreadcrumbsEntry* bread;
	FilesViewChromeSearchResults* search_results;
	GFile* search_location;
	guint focus_timeout_id;
};

struct _Block58Data {
	int _ref_count_;
	FilesViewChromeLocationBar* self;
	GFile* file;
};

static gint FilesViewChromeLocationBar_private_offset;
static gpointer files_view_chrome_location_bar_parent_class = NULL;

VALA_EXTERN GType files_view_chrome_location_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeLocationBar, g_object_unref)
VALA_EXTERN GType files_view_chrome_breadcrumbs_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBreadcrumbsEntry, g_object_unref)
VALA_EXTERN GType files_view_chrome_search_results_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeSearchResults, g_object_unref)
VALA_EXTERN gboolean files_view_chrome_location_bar_enter_navigate_mode (FilesViewChromeLocationBar* self,
                                                             const gchar* current);
VALA_EXTERN FilesViewChromeLocationBar* files_view_chrome_location_bar_new (void);
VALA_EXTERN FilesViewChromeLocationBar* files_view_chrome_location_bar_construct (GType object_type);
VALA_EXTERN FilesViewChromeBreadcrumbsEntry* files_view_chrome_breadcrumbs_entry_new (void);
VALA_EXTERN FilesViewChromeBreadcrumbsEntry* files_view_chrome_breadcrumbs_entry_construct (GType object_type);
VALA_EXTERN FilesViewChromeSearchResults* files_view_chrome_search_results_new (GtkWidget* _delegate_widget);
VALA_EXTERN FilesViewChromeSearchResults* files_view_chrome_search_results_construct (GType object_type,
                                                                          GtkWidget* _delegate_widget);
static void files_view_chrome_location_bar_connect_additional_signals (FilesViewChromeLocationBar* self);
VALA_EXTERN void files_view_chrome_location_bar_show_refresh_icon (FilesViewChromeLocationBar* self);
static void files_view_chrome_location_bar_on_bread_open_with_request (FilesViewChromeLocationBar* self,
                                                                GFile* file,
                                                                GAppInfo* app);
static void _files_view_chrome_location_bar_on_bread_open_with_request_files_view_chrome_breadcrumbs_entry_open_with_request (FilesViewChromeBreadcrumbsEntry* _sender,
                                                                                                                       GFile* file,
                                                                                                                       GAppInfo* app,
                                                                                                                       gpointer self);
static void files_view_chrome_location_bar_on_search_results_file_selected (FilesViewChromeLocationBar* self,
                                                                     GFile* file);
static void _files_view_chrome_location_bar_on_search_results_file_selected_files_view_chrome_searchable_file_selected (FilesViewChromeSearchable* _sender,
                                                                                                                 GFile* file,
                                                                                                                 gpointer self);
static void files_view_chrome_location_bar_on_search_results_file_activated (FilesViewChromeLocationBar* self,
                                                                      GFile* file);
static void _files_view_chrome_location_bar_on_search_results_file_activated_files_view_chrome_searchable_file_activated (FilesViewChromeSearchable* _sender,
                                                                                                                   GFile* file,
                                                                                                                   gpointer self);
static void files_view_chrome_location_bar_on_search_results_cursor_changed (FilesViewChromeLocationBar* self,
                                                                      GFile* file);
static void _files_view_chrome_location_bar_on_search_results_cursor_changed_files_view_chrome_searchable_cursor_changed (FilesViewChromeSearchable* _sender,
                                                                                                                   GFile* file,
                                                                                                                   gpointer self);
static void files_view_chrome_location_bar_on_search_results_first_match_found (FilesViewChromeLocationBar* self,
                                                                         GFile* file);
static void _files_view_chrome_location_bar_on_search_results_first_match_found_files_view_chrome_searchable_first_match_found (FilesViewChromeSearchable* _sender,
                                                                                                                         GFile* file,
                                                                                                                         gpointer self);
static void files_view_chrome_location_bar_on_search_results_exit (FilesViewChromeLocationBar* self,
                                                            gboolean exit_navigate);
static void _files_view_chrome_location_bar_on_search_results_exit_files_view_chrome_searchable_exit (FilesViewChromeSearchable* _sender,
                                                                                               gboolean exit_navigate,
                                                                                               gpointer self);
static void files_view_chrome_location_bar_on_search_results_working_changed (FilesViewChromeLocationBar* self);
static void _files_view_chrome_location_bar_on_search_results_working_changed_g_object_notify (GObject* _sender,
                                                                                        GParamSpec* pspec,
                                                                                        gpointer self);
VALA_EXTERN GAppInfo* files_mime_actions_get_default_application_for_glib_file (GFile* file);
VALA_EXTERN void files_mime_actions_open_glib_file_request (GFile* file_to_open,
                                                GtkWidget* parent,
                                                GAppInfo* app,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void files_mime_actions_open_glib_file_request_finish (GAsyncResult* _res_);
static void files_view_chrome_location_bar_schedule_focus_file_request (FilesViewChromeLocationBar* self,
                                                                 GFile* file);
VALA_EXTERN gboolean files_view_chrome_search_results_get_working (FilesViewChromeSearchResults* self);
static void files_view_chrome_location_bar_show_working_icon (FilesViewChromeLocationBar* self);
static void files_view_chrome_location_bar_hide_working_icon (FilesViewChromeLocationBar* self);
static gboolean files_view_chrome_location_bar_real_after_bread_focus_out_event (FilesViewChromeBasicLocationBar* base,
                                                                          GdkEventFocus* event);
VALA_EXTERN gboolean files_view_chrome_search_results_get_is_active (FilesViewChromeSearchResults* self);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (FilesViewChromeBreadcrumbsEntry* self,
                                                               gboolean value);
static void files_view_chrome_location_bar_set_search_mode (FilesViewChromeLocationBar* self,
                                                     gboolean value);
static void files_view_chrome_location_bar_check_home (FilesViewChromeLocationBar* self);
static gboolean files_view_chrome_location_bar_real_after_bread_focus_in_event (FilesViewChromeBasicLocationBar* base,
                                                                         GdkEventFocus* event);
static void files_view_chrome_location_bar_real_on_bread_action_icon_press (FilesViewChromeBasicLocationBar* base);
static void files_view_chrome_location_bar_real_after_bread_text_changed (FilesViewChromeBasicLocationBar* base,
                                                                   const gchar* txt);
VALA_EXTERN gboolean files_view_chrome_location_bar_get_search_mode (FilesViewChromeLocationBar* self);
static void files_view_chrome_location_bar_switch_to_search_mode (FilesViewChromeLocationBar* self);
static void files_view_chrome_location_bar_show_placeholder (FilesViewChromeLocationBar* self);
static void files_view_chrome_location_bar_hide_placeholder (FilesViewChromeLocationBar* self);
static gboolean files_view_chrome_location_bar_text_is_path (FilesViewChromeLocationBar* self,
                                                      const gchar* txt);
static void files_view_chrome_location_bar_switch_to_navigate_mode (FilesViewChromeLocationBar* self);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_completion_needed (FilesViewChromeBreadcrumbsEntry* self);
VALA_EXTERN gboolean files_view_chrome_location_bar_enter_search_mode (FilesViewChromeLocationBar* self,
                                                           const gchar* term);
VALA_EXTERN gboolean files_view_chrome_location_bar_get_sensitive (FilesViewChromeLocationBar* self);
static gboolean files_view_chrome_location_bar_real_enter_navigate_mode (FilesViewChromeLocationBar* self,
                                                                  const gchar* current);
static void files_view_chrome_location_bar_cancel_search (FilesViewChromeLocationBar* self);
VALA_EXTERN void files_view_chrome_location_bar_cancel (FilesViewChromeLocationBar* self);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static gboolean __lambda37_ (Block58Data* _data58_);
static gboolean ___lambda37__gsource_func (gpointer self);
static void files_view_chrome_location_bar_real_set_display_path (FilesViewChromeBasicLocationBar* base,
                                                           const gchar* uri);
VALA_EXTERN gboolean files_view_chrome_breadcrumbs_entry_get_hide_breadcrumbs (FilesViewChromeBreadcrumbsEntry* self);
VALA_EXTERN gboolean files_view_chrome_breadcrumbs_entry_get_search_mode (FilesViewChromeBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_set_search_mode (FilesViewChromeBreadcrumbsEntry* self,
                                                          gboolean value);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_set_primary_icon_name (FilesViewChromeBreadcrumbsEntry* self,
                                                                const gchar* icon_name);
VALA_EXTERN void files_view_chrome_location_bar_set_sensitive (FilesViewChromeLocationBar* self,
                                                   gboolean value);
static GObject * files_view_chrome_location_bar_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _files_view_chrome_location_bar___lambda38_ (FilesViewChromeLocationBar* self);
static void __files_view_chrome_location_bar___lambda38__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void files_view_chrome_location_bar_finalize (GObject * obj);
static GType files_view_chrome_location_bar_get_type_once (void);
static void _vala_files_view_chrome_location_bar_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_files_view_chrome_location_bar_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
files_view_chrome_location_bar_get_instance_private (FilesViewChromeLocationBar* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeLocationBar_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesViewChromeLocationBar*
files_view_chrome_location_bar_construct (GType object_type)
{
	FilesViewChromeLocationBar * self = NULL;
	FilesViewChromeBreadcrumbsEntry* _bread = NULL;
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	FilesViewChromeBreadcrumbsEntry* _tmp1_;
	FilesViewChromeBreadcrumbsEntry* _tmp2_;
	FilesViewChromeSearchResults* _tmp3_;
	_tmp0_ = files_view_chrome_breadcrumbs_entry_new ();
	g_object_ref_sink (_tmp0_);
	_bread = _tmp0_;
	self = (FilesViewChromeLocationBar*) files_view_chrome_basic_location_bar_construct (object_type, G_TYPE_CHECK_INSTANCE_TYPE (_bread, FILES_VIEW_CHROME_TYPE_NAVIGATABLE) ? ((FilesViewChromeNavigatable*) _bread) : NULL);
	_tmp1_ = _g_object_ref0 (_bread);
	_g_object_unref0 (self->priv->bread);
	self->priv->bread = _tmp1_;
	_tmp2_ = self->priv->bread;
	_tmp3_ = files_view_chrome_search_results_new ((GtkWidget*) _tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->search_results);
	self->priv->search_results = _tmp3_;
	files_view_chrome_location_bar_connect_additional_signals (self);
	files_view_chrome_location_bar_show_refresh_icon (self);
	_g_object_unref0 (_bread);
	return self;
}

FilesViewChromeLocationBar*
files_view_chrome_location_bar_new (void)
{
	return files_view_chrome_location_bar_construct (FILES_VIEW_CHROME_TYPE_LOCATION_BAR);
}

static void
_files_view_chrome_location_bar_on_bread_open_with_request_files_view_chrome_breadcrumbs_entry_open_with_request (FilesViewChromeBreadcrumbsEntry* _sender,
                                                                                                                  GFile* file,
                                                                                                                  GAppInfo* app,
                                                                                                                  gpointer self)
{
	files_view_chrome_location_bar_on_bread_open_with_request ((FilesViewChromeLocationBar*) self, file, app);
}

static void
_files_view_chrome_location_bar_on_search_results_file_selected_files_view_chrome_searchable_file_selected (FilesViewChromeSearchable* _sender,
                                                                                                            GFile* file,
                                                                                                            gpointer self)
{
	files_view_chrome_location_bar_on_search_results_file_selected ((FilesViewChromeLocationBar*) self, file);
}

static void
_files_view_chrome_location_bar_on_search_results_file_activated_files_view_chrome_searchable_file_activated (FilesViewChromeSearchable* _sender,
                                                                                                              GFile* file,
                                                                                                              gpointer self)
{
	files_view_chrome_location_bar_on_search_results_file_activated ((FilesViewChromeLocationBar*) self, file);
}

static void
_files_view_chrome_location_bar_on_search_results_cursor_changed_files_view_chrome_searchable_cursor_changed (FilesViewChromeSearchable* _sender,
                                                                                                              GFile* file,
                                                                                                              gpointer self)
{
	files_view_chrome_location_bar_on_search_results_cursor_changed ((FilesViewChromeLocationBar*) self, file);
}

static void
_files_view_chrome_location_bar_on_search_results_first_match_found_files_view_chrome_searchable_first_match_found (FilesViewChromeSearchable* _sender,
                                                                                                                    GFile* file,
                                                                                                                    gpointer self)
{
	files_view_chrome_location_bar_on_search_results_first_match_found ((FilesViewChromeLocationBar*) self, file);
}

static void
_files_view_chrome_location_bar_on_search_results_exit_files_view_chrome_searchable_exit (FilesViewChromeSearchable* _sender,
                                                                                          gboolean exit_navigate,
                                                                                          gpointer self)
{
	files_view_chrome_location_bar_on_search_results_exit ((FilesViewChromeLocationBar*) self, exit_navigate);
}

static void
_files_view_chrome_location_bar_on_search_results_working_changed_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self)
{
	files_view_chrome_location_bar_on_search_results_working_changed ((FilesViewChromeLocationBar*) self);
}

static void
files_view_chrome_location_bar_connect_additional_signals (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	FilesViewChromeSearchResults* _tmp1_;
	FilesViewChromeSearchResults* _tmp2_;
	FilesViewChromeSearchResults* _tmp3_;
	FilesViewChromeSearchResults* _tmp4_;
	FilesViewChromeSearchResults* _tmp5_;
	FilesViewChromeSearchResults* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	g_signal_connect_object (_tmp0_, "open-with-request", (GCallback) _files_view_chrome_location_bar_on_bread_open_with_request_files_view_chrome_breadcrumbs_entry_open_with_request, self, 0);
	_tmp1_ = self->priv->search_results;
	g_signal_connect_object ((FilesViewChromeSearchable*) _tmp1_, "file-selected", (GCallback) _files_view_chrome_location_bar_on_search_results_file_selected_files_view_chrome_searchable_file_selected, self, 0);
	_tmp2_ = self->priv->search_results;
	g_signal_connect_object ((FilesViewChromeSearchable*) _tmp2_, "file-activated", (GCallback) _files_view_chrome_location_bar_on_search_results_file_activated_files_view_chrome_searchable_file_activated, self, 0);
	_tmp3_ = self->priv->search_results;
	g_signal_connect_object ((FilesViewChromeSearchable*) _tmp3_, "cursor-changed", (GCallback) _files_view_chrome_location_bar_on_search_results_cursor_changed_files_view_chrome_searchable_cursor_changed, self, 0);
	_tmp4_ = self->priv->search_results;
	g_signal_connect_object ((FilesViewChromeSearchable*) _tmp4_, "first-match-found", (GCallback) _files_view_chrome_location_bar_on_search_results_first_match_found_files_view_chrome_searchable_first_match_found, self, 0);
	_tmp5_ = self->priv->search_results;
	g_signal_connect_object ((FilesViewChromeSearchable*) _tmp5_, "exit", (GCallback) _files_view_chrome_location_bar_on_search_results_exit_files_view_chrome_searchable_exit, self, 0);
	_tmp6_ = self->priv->search_results;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::working", (GCallback) _files_view_chrome_location_bar_on_search_results_working_changed_g_object_notify, self, 0);
}

static void
files_view_chrome_location_bar_on_search_results_file_selected (FilesViewChromeLocationBar* self,
                                                                GFile* file)
{
	FilesFile* gof = NULL;
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = files_file_new (file, NULL);
	gof = _tmp0_;
	files_file_ensure_query_info (gof);
	_tmp1_ = files_file_get_target_location (gof);
	_tmp2_ = g_file_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name ((FilesViewChromeLocatable*) self, "path-change-request", _tmp3_, FILES_OPEN_FLAG_DEFAULT);
	_g_free0 (_tmp3_);
	files_view_chrome_location_bar_on_search_results_exit (self, TRUE);
	_g_object_unref0 (gof);
}

static void
files_view_chrome_location_bar_on_search_results_file_activated (FilesViewChromeLocationBar* self,
                                                                 GFile* file)
{
	GAppInfo* app = NULL;
	GAppInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = files_mime_actions_get_default_application_for_glib_file (file);
	app = _tmp0_;
	files_mime_actions_open_glib_file_request (file, (GtkWidget*) self, app, NULL, NULL);
	files_view_chrome_location_bar_on_search_results_exit (self, TRUE);
	_g_object_unref0 (app);
}

static void
files_view_chrome_location_bar_on_search_results_first_match_found (FilesViewChromeLocationBar* self,
                                                                    GFile* file)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, files_view_chrome_location_bar_signals[FILES_VIEW_CHROME_LOCATION_BAR_FOCUS_FILE_REQUEST_SIGNAL], 0, file);
}

static void
files_view_chrome_location_bar_on_search_results_cursor_changed (FilesViewChromeLocationBar* self,
                                                                 GFile* file)
{
	g_return_if_fail (self != NULL);
	if (file != NULL) {
		files_view_chrome_location_bar_schedule_focus_file_request (self, file);
	}
}

static void
files_view_chrome_location_bar_on_search_results_exit (FilesViewChromeLocationBar* self,
                                                       gboolean exit_navigate)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	gtk_entry_reset_im_context ((GtkEntry*) _tmp0_);
	if (self->priv->focus_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->focus_timeout_id);
	}
	if (exit_navigate) {
		g_signal_emit (self, files_view_chrome_location_bar_signals[FILES_VIEW_CHROME_LOCATION_BAR_ESCAPE_SIGNAL], 0);
	} else {
		FilesViewChromeBreadcrumbsEntry* _tmp1_;
		FilesViewChromeBreadcrumbsEntry* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->bread;
		_tmp2_ = self->priv->bread;
		_tmp3_ = files_view_chrome_navigatable_get_breadcrumbs_path ((FilesViewChromeNavigatable*) _tmp2_, FALSE);
		_tmp4_ = _tmp3_;
		files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) _tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		files_view_chrome_location_bar_enter_navigate_mode (self, NULL);
	}
}

static void
files_view_chrome_location_bar_on_search_results_working_changed (FilesViewChromeLocationBar* self)
{
	FilesViewChromeSearchResults* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_results;
	_tmp1_ = files_view_chrome_search_results_get_working (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		files_view_chrome_location_bar_show_working_icon (self);
	} else {
		files_view_chrome_location_bar_hide_working_icon (self);
	}
}

static gboolean
files_view_chrome_location_bar_real_after_bread_focus_out_event (FilesViewChromeBasicLocationBar* base,
                                                                 GdkEventFocus* event)
{
	FilesViewChromeLocationBar * self;
	FilesViewChromeSearchResults* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (FilesViewChromeLocationBar*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->search_results;
	_tmp1_ = files_view_chrome_search_results_get_is_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		FilesViewChromeBreadcrumbsEntry* _tmp3_;
		_tmp3_ = self->priv->bread;
		files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (_tmp3_, TRUE);
	} else {
		gboolean _tmp4_ = FALSE;
		FILES_VIEW_CHROME_BASIC_LOCATION_BAR_CLASS (files_view_chrome_location_bar_parent_class)->after_bread_focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBar), event);
		files_view_chrome_location_bar_set_search_mode (self, FALSE);
		files_view_chrome_location_bar_show_refresh_icon (self);
		g_signal_emit_by_name ((GtkWidget*) self, "focus-out-event", event, &_tmp4_);
		files_view_chrome_location_bar_check_home (self);
	}
	result = TRUE;
	return result;
}

static gboolean
files_view_chrome_location_bar_real_after_bread_focus_in_event (FilesViewChromeBasicLocationBar* base,
                                                                GdkEventFocus* event)
{
	FilesViewChromeLocationBar * self;
	gboolean _tmp0_ = FALSE;
	FilesViewChromeBreadcrumbsEntry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	gboolean result;
	self = (FilesViewChromeLocationBar*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	FILES_VIEW_CHROME_BASIC_LOCATION_BAR_CLASS (files_view_chrome_location_bar_parent_class)->after_bread_focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBar), event);
	g_signal_emit_by_name ((GtkWidget*) self, "focus-in-event", event, &_tmp0_);
	_tmp1_ = self->priv->bread;
	_tmp2_ = files_view_chrome_navigatable_get_breadcrumbs_path ((FilesViewChromeNavigatable*) _tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_file_utils_get_file_for_path (_tmp3_);
	_g_object_unref0 (self->priv->search_location);
	self->priv->search_location = _tmp4_;
	_g_free0 (_tmp3_);
	result = TRUE;
	return result;
}

static void
files_view_chrome_location_bar_on_bread_open_with_request (FilesViewChromeLocationBar* self,
                                                           GFile* file,
                                                           GAppInfo* app)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	files_mime_actions_open_glib_file_request (file, (GtkWidget*) self, app, NULL, NULL);
}

static void
files_view_chrome_location_bar_real_on_bread_action_icon_press (FilesViewChromeBasicLocationBar* base)
{
	FilesViewChromeLocationBar * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (FilesViewChromeLocationBar*) base;
	_tmp0_ = files_view_chrome_basic_location_bar_get_has_focus ((FilesViewChromeBasicLocationBar*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		FilesViewChromeBreadcrumbsEntry* _tmp2_;
		_tmp2_ = self->priv->bread;
		g_signal_emit_by_name ((GtkEntry*) _tmp2_, "activate");
	} else {
		GActionGroup* _tmp3_;
		_tmp3_ = gtk_widget_get_action_group ((GtkWidget*) self, "win");
		g_action_group_activate_action (_tmp3_, "refresh", NULL);
	}
}

static void
files_view_chrome_location_bar_real_after_bread_text_changed (FilesViewChromeBasicLocationBar* base,
                                                              const gchar* txt)
{
	FilesViewChromeLocationBar * self;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (FilesViewChromeLocationBar*) base;
	g_return_if_fail (txt != NULL);
	_tmp0_ = strlen (txt);
	_tmp1_ = _tmp0_;
	if (_tmp1_ < 1) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = files_view_chrome_location_bar_get_search_mode (self);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			files_view_chrome_location_bar_switch_to_search_mode (self);
		}
		files_view_chrome_location_bar_show_placeholder (self);
		return;
	}
	files_view_chrome_location_bar_hide_placeholder (self);
	_tmp4_ = files_view_chrome_location_bar_get_search_mode (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		if (files_view_chrome_location_bar_text_is_path (self, txt)) {
			FilesViewChromeBreadcrumbsEntry* _tmp6_;
			files_view_chrome_location_bar_switch_to_navigate_mode (self);
			_tmp6_ = self->priv->bread;
			files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) _tmp6_, txt);
		} else {
			FilesViewChromeSearchResults* _tmp7_;
			GFile* _tmp8_;
			_tmp7_ = self->priv->search_results;
			_tmp8_ = self->priv->search_location;
			files_view_chrome_searchable_search ((FilesViewChromeSearchable*) _tmp7_, txt, _tmp8_);
		}
	} else {
		if (!files_view_chrome_location_bar_text_is_path (self, txt)) {
			files_view_chrome_location_bar_switch_to_search_mode (self);
		} else {
			FilesViewChromeBreadcrumbsEntry* _tmp9_;
			FILES_VIEW_CHROME_BASIC_LOCATION_BAR_CLASS (files_view_chrome_location_bar_parent_class)->after_bread_text_changed (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBar), txt);
			_tmp9_ = self->priv->bread;
			files_view_chrome_breadcrumbs_entry_completion_needed (_tmp9_);
		}
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
files_view_chrome_location_bar_text_is_path (FilesViewChromeLocationBar* self,
                                             const gchar* txt)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (txt != NULL, FALSE);
	if (string_contains (txt, G_DIR_SEPARATOR_S)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_contains (txt, ":");
	}
	result = _tmp0_;
	return result;
}

void
files_view_chrome_location_bar_show_refresh_icon (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	GtkStyleContext* _tmp1_;
	FilesViewChromeBreadcrumbsEntry* _tmp2_;
	FilesViewChromeBreadcrumbsEntry* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "spin");
	_tmp2_ = self->priv->bread;
	files_view_chrome_navigatable_set_action_icon_name ((FilesViewChromeNavigatable*) _tmp2_, FILES_ICON_PATHBAR_SECONDARY_REFRESH_SYMBOLIC);
	_tmp3_ = self->priv->bread;
	_tmp4_ = g_strdup ("F5");
	_tmp5_ = g_strdup ("<Ctrl>R");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp8_ = granite_markup_accel_tooltip (_tmp7_, (gint) 2, _ ("Reload this folder"));
	_tmp9_ = _tmp8_;
	files_view_chrome_navigatable_set_action_icon_tooltip ((FilesViewChromeNavigatable*) _tmp3_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
}

static void
files_view_chrome_location_bar_show_placeholder (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	files_view_chrome_navigatable_set_placeholder ((FilesViewChromeNavigatable*) _tmp0_, _ ("Search or Type Path"));
}

static void
files_view_chrome_location_bar_hide_placeholder (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	files_view_chrome_navigatable_set_placeholder ((FilesViewChromeNavigatable*) _tmp0_, "");
}

static void
files_view_chrome_location_bar_show_working_icon (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	FilesViewChromeBreadcrumbsEntry* _tmp1_;
	FilesViewChromeBreadcrumbsEntry* _tmp2_;
	GtkStyleContext* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	files_view_chrome_navigatable_set_action_icon_name ((FilesViewChromeNavigatable*) _tmp0_, FILES_ICON_PATHBAR_SECONDARY_WORKING_SYMBOLIC);
	_tmp1_ = self->priv->bread;
	files_view_chrome_navigatable_set_action_icon_tooltip ((FilesViewChromeNavigatable*) _tmp1_, _ ("Searching…"));
	_tmp2_ = self->priv->bread;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "spin");
}

static void
files_view_chrome_location_bar_hide_working_icon (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	GtkStyleContext* _tmp1_;
	FilesViewChromeBreadcrumbsEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "spin");
	_tmp2_ = self->priv->bread;
	files_view_chrome_navigatable_set_action_icon_name ((FilesViewChromeNavigatable*) _tmp2_, NULL);
}

gboolean
files_view_chrome_location_bar_enter_search_mode (FilesViewChromeLocationBar* self,
                                                  const gchar* term)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (term != NULL, FALSE);
	_tmp0_ = files_view_chrome_location_bar_get_sensitive (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = files_view_chrome_location_bar_get_search_mode (self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		if (files_view_chrome_locatable_set_focussed ((FilesViewChromeLocatable*) self)) {
			FilesViewChromeBreadcrumbsEntry* _tmp4_;
			files_view_chrome_location_bar_set_search_mode (self, TRUE);
			_tmp4_ = self->priv->bread;
			files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) _tmp4_, term);
		} else {
			result = FALSE;
			return result;
		}
	} else {
		FilesViewChromeSearchResults* _tmp5_;
		FilesViewChromeBreadcrumbsEntry* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GFile* _tmp9_;
		_tmp5_ = self->priv->search_results;
		_tmp6_ = self->priv->bread;
		_tmp7_ = files_view_chrome_navigatable_get_entry_text ((FilesViewChromeNavigatable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->search_location;
		files_view_chrome_searchable_search ((FilesViewChromeSearchable*) _tmp5_, _tmp8_, _tmp9_);
		_g_free0 (_tmp8_);
	}
	result = TRUE;
	return result;
}

static gboolean
files_view_chrome_location_bar_real_enter_navigate_mode (FilesViewChromeLocationBar* self,
                                                         const gchar* current)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp1_ = files_view_chrome_location_bar_get_sensitive (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = files_view_chrome_locatable_set_focussed ((FilesViewChromeLocatable*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		files_view_chrome_basic_location_bar_show_navigate_icon ((FilesViewChromeBasicLocationBar*) self);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
files_view_chrome_location_bar_enter_navigate_mode (FilesViewChromeLocationBar* self,
                                                    const gchar* current)
{
	FilesViewChromeLocationBarClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_VIEW_CHROME_LOCATION_BAR_GET_CLASS (self);
	if (_klass_->enter_navigate_mode) {
		return _klass_->enter_navigate_mode (self, current);
	}
	return FALSE;
}

static void
files_view_chrome_location_bar_switch_to_navigate_mode (FilesViewChromeLocationBar* self)
{
	g_return_if_fail (self != NULL);
	files_view_chrome_location_bar_set_search_mode (self, FALSE);
	files_view_chrome_location_bar_cancel_search (self);
	files_view_chrome_basic_location_bar_show_navigate_icon ((FilesViewChromeBasicLocationBar*) self);
}

static void
files_view_chrome_location_bar_switch_to_search_mode (FilesViewChromeLocationBar* self)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	files_view_chrome_location_bar_set_search_mode (self, TRUE);
	files_view_chrome_basic_location_bar_hide_navigate_icon ((FilesViewChromeBasicLocationBar*) self);
	_tmp0_ = self->priv->bread;
	_tmp1_ = files_view_chrome_navigatable_get_entry_text ((FilesViewChromeNavigatable*) _tmp0_);
	_tmp2_ = _tmp1_;
	files_view_chrome_basic_location_bar_after_bread_text_changed ((FilesViewChromeBasicLocationBar*) self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
files_view_chrome_location_bar_cancel_search (FilesViewChromeLocationBar* self)
{
	FilesViewChromeSearchResults* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_results;
	files_view_chrome_searchable_cancel ((FilesViewChromeSearchable*) _tmp0_);
}

void
files_view_chrome_location_bar_cancel (FilesViewChromeLocationBar* self)
{
	g_return_if_fail (self != NULL);
	files_view_chrome_location_bar_cancel_search (self);
	files_view_chrome_location_bar_on_search_results_exit (self, TRUE);
}

static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		FilesViewChromeLocationBar* self;
		self = _data58_->self;
		_g_object_unref0 (_data58_->file);
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static gboolean
__lambda37_ (Block58Data* _data58_)
{
	FilesViewChromeLocationBar* self;
	gboolean result;
	self = _data58_->self;
	g_signal_emit (self, files_view_chrome_location_bar_signals[FILES_VIEW_CHROME_LOCATION_BAR_FOCUS_FILE_REQUEST_SIGNAL], 0, _data58_->file);
	self->priv->focus_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda37__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda37_ (self);
	return result;
}

static void
files_view_chrome_location_bar_schedule_focus_file_request (FilesViewChromeLocationBar* self,
                                                            GFile* file)
{
	Block58Data* _data58_;
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_data58_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data58_->file);
	_data58_->file = _tmp0_;
	if (self->priv->focus_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->focus_timeout_id);
	}
	self->priv->focus_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ___lambda37__gsource_func, block58_data_ref (_data58_), block58_data_unref);
	block58_data_unref (_data58_);
	_data58_ = NULL;
}

static void
files_view_chrome_location_bar_real_set_display_path (FilesViewChromeBasicLocationBar* base,
                                                      const gchar* uri)
{
	FilesViewChromeLocationBar * self;
	self = (FilesViewChromeLocationBar*) base;
	g_return_if_fail (uri != NULL);
	FILES_VIEW_CHROME_BASIC_LOCATION_BAR_CLASS (files_view_chrome_location_bar_parent_class)->set_display_path (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, FilesViewChromeBasicLocationBar), uri);
	files_view_chrome_location_bar_check_home (self);
}

static void
files_view_chrome_location_bar_check_home (FilesViewChromeLocationBar* self)
{
	GtkWidget* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FilesViewChromeBreadcrumbsEntry* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), "has-toplevel-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		FilesViewChromeBreadcrumbsEntry* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = files_view_chrome_basic_location_bar_get_displayed_path ((FilesViewChromeBasicLocationBar*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_filename_from_uri (_tmp5_, NULL, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->bread;
		_tmp8_ = g_get_home_dir ();
		files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (_tmp7_, g_strcmp0 (_tmp3_, _tmp8_) == 0);
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		FilesViewChromeBreadcrumbsEntry* _tmp9_;
		g_clear_error (&_inner_error0_);
		_tmp9_ = self->priv->bread;
		files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (_tmp9_, FALSE);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp10_ = self->priv->bread;
	_tmp11_ = files_view_chrome_breadcrumbs_entry_get_hide_breadcrumbs (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		files_view_chrome_location_bar_show_placeholder (self);
	} else {
		files_view_chrome_location_bar_hide_placeholder (self);
	}
}

gboolean
files_view_chrome_location_bar_get_search_mode (FilesViewChromeLocationBar* self)
{
	gboolean result;
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bread;
	_tmp1_ = files_view_chrome_breadcrumbs_entry_get_search_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
files_view_chrome_location_bar_set_search_mode (FilesViewChromeLocationBar* self,
                                                gboolean value)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	files_view_chrome_breadcrumbs_entry_set_search_mode (_tmp0_, value);
	if (!value) {
		FilesViewChromeBreadcrumbsEntry* _tmp1_;
		_tmp1_ = self->priv->bread;
		files_view_chrome_breadcrumbs_entry_set_primary_icon_name (_tmp1_, NULL);
	} else {
		FilesViewChromeBreadcrumbsEntry* _tmp2_;
		GtkStyleContext* _tmp3_;
		FilesViewChromeBreadcrumbsEntry* _tmp4_;
		_tmp2_ = self->priv->bread;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
		gtk_style_context_remove_class (_tmp3_, "spin");
		_tmp4_ = self->priv->bread;
		files_view_chrome_breadcrumbs_entry_set_primary_icon_name (_tmp4_, FILES_ICON_PATHBAR_PRIMARY_FIND_SYMBOLIC);
		files_view_chrome_basic_location_bar_hide_navigate_icon ((FilesViewChromeBasicLocationBar*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_location_bar_properties[FILES_VIEW_CHROME_LOCATION_BAR_SEARCH_MODE_PROPERTY]);
}

gboolean
files_view_chrome_location_bar_get_sensitive (FilesViewChromeLocationBar* self)
{
	gboolean result;
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bread;
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
files_view_chrome_location_bar_set_sensitive (FilesViewChromeLocationBar* self,
                                              gboolean value)
{
	FilesViewChromeBreadcrumbsEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bread;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_location_bar_properties[FILES_VIEW_CHROME_LOCATION_BAR_SENSITIVE_PROPERTY]);
}

static void
_files_view_chrome_location_bar___lambda38_ (FilesViewChromeLocationBar* self)
{
	GtkRevealer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->admin_revealer;
	_tmp1_ = files_view_chrome_basic_location_bar_get_displayed_path ((FilesViewChromeBasicLocationBar*) self);
	_tmp2_ = _tmp1_;
	gtk_revealer_set_reveal_child (_tmp0_, g_str_has_prefix (_tmp2_, "admin:/"));
}

static void
__files_view_chrome_location_bar___lambda38__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_files_view_chrome_location_bar___lambda38_ ((FilesViewChromeLocationBar*) self);
}

static GObject *
files_view_chrome_location_bar_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewChromeLocationBar * self;
	GtkImage* admin_image = NULL;
	gchar* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkImage* _tmp2_;
	GtkWidget* _tmp3_;
	GtkRevealer* _tmp4_ = NULL;
	GtkRevealer* _tmp5_;
	parent_class = G_OBJECT_CLASS (files_view_chrome_location_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBar);
	_tmp0_ = g_strdup (_ ("Caution. Administrative rights will be granted after successful authen" \
"tication"));
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	admin_image = _tmp1_;
	_tmp2_ = admin_image;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp4_, "child", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	gtk_revealer_set_reveal_child (_tmp4_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, FALSE);
	gtk_revealer_set_transition_type (_tmp4_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->admin_revealer);
	self->priv->admin_revealer = _tmp4_;
	_tmp5_ = self->priv->admin_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	g_signal_connect_object ((GObject*) self, "notify::displayed-path", (GCallback) __files_view_chrome_location_bar___lambda38__g_object_notify, self, 0);
	_g_object_unref0 (admin_image);
	return obj;
}

static void
files_view_chrome_location_bar_class_init (FilesViewChromeLocationBarClass * klass,
                                           gpointer klass_data)
{
	files_view_chrome_location_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeLocationBar_private_offset);
	((FilesViewChromeBasicLocationBarClass *) klass)->after_bread_focus_out_event = (gboolean (*) (FilesViewChromeBasicLocationBar*, GdkEventFocus*)) files_view_chrome_location_bar_real_after_bread_focus_out_event;
	((FilesViewChromeBasicLocationBarClass *) klass)->after_bread_focus_in_event = (gboolean (*) (FilesViewChromeBasicLocationBar*, GdkEventFocus*)) files_view_chrome_location_bar_real_after_bread_focus_in_event;
	((FilesViewChromeBasicLocationBarClass *) klass)->on_bread_action_icon_press = (void (*) (FilesViewChromeBasicLocationBar*)) files_view_chrome_location_bar_real_on_bread_action_icon_press;
	((FilesViewChromeBasicLocationBarClass *) klass)->after_bread_text_changed = (void (*) (FilesViewChromeBasicLocationBar*, const gchar*)) files_view_chrome_location_bar_real_after_bread_text_changed;
	((FilesViewChromeLocationBarClass *) klass)->enter_navigate_mode = (gboolean (*) (FilesViewChromeLocationBar*, const gchar*)) files_view_chrome_location_bar_real_enter_navigate_mode;
	((FilesViewChromeBasicLocationBarClass *) klass)->set_display_path = (void (*) (FilesViewChromeBasicLocationBar*, const gchar*)) files_view_chrome_location_bar_real_set_display_path;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_location_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_location_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_chrome_location_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_location_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_LOCATION_BAR_SEARCH_MODE_PROPERTY, files_view_chrome_location_bar_properties[FILES_VIEW_CHROME_LOCATION_BAR_SEARCH_MODE_PROPERTY] = g_param_spec_boolean ("search-mode", "search-mode", "search-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_LOCATION_BAR_SENSITIVE_PROPERTY, files_view_chrome_location_bar_properties[FILES_VIEW_CHROME_LOCATION_BAR_SENSITIVE_PROPERTY] = g_param_spec_boolean ("sensitive", "sensitive", "sensitive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	files_view_chrome_location_bar_signals[FILES_VIEW_CHROME_LOCATION_BAR_FOCUS_FILE_REQUEST_SIGNAL] = g_signal_new ("focus-file-request", FILES_VIEW_CHROME_TYPE_LOCATION_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	files_view_chrome_location_bar_signals[FILES_VIEW_CHROME_LOCATION_BAR_ESCAPE_SIGNAL] = g_signal_new ("escape", FILES_VIEW_CHROME_TYPE_LOCATION_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
files_view_chrome_location_bar_instance_init (FilesViewChromeLocationBar * self,
                                              gpointer klass)
{
	self->priv = files_view_chrome_location_bar_get_instance_private (self);
	self->priv->search_location = NULL;
	self->priv->focus_timeout_id = (guint) 0;
}

static void
files_view_chrome_location_bar_finalize (GObject * obj)
{
	FilesViewChromeLocationBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBar);
	_g_object_unref0 (self->priv->admin_revealer);
	_g_object_unref0 (self->priv->bread);
	_g_object_unref0 (self->priv->search_results);
	_g_object_unref0 (self->priv->search_location);
	G_OBJECT_CLASS (files_view_chrome_location_bar_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_location_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeLocationBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_location_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeLocationBar), 0, (GInstanceInitFunc) files_view_chrome_location_bar_instance_init, NULL };
	GType files_view_chrome_location_bar_type_id;
	files_view_chrome_location_bar_type_id = g_type_register_static (FILES_VIEW_CHROME_TYPE_BASIC_LOCATION_BAR, "FilesViewChromeLocationBar", &g_define_type_info, 0);
	FilesViewChromeLocationBar_private_offset = g_type_add_instance_private (files_view_chrome_location_bar_type_id, sizeof (FilesViewChromeLocationBarPrivate));
	return files_view_chrome_location_bar_type_id;
}

GType
files_view_chrome_location_bar_get_type (void)
{
	static volatile gsize files_view_chrome_location_bar_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_location_bar_type_id__once)) {
		GType files_view_chrome_location_bar_type_id;
		files_view_chrome_location_bar_type_id = files_view_chrome_location_bar_get_type_once ();
		g_once_init_leave (&files_view_chrome_location_bar_type_id__once, files_view_chrome_location_bar_type_id);
	}
	return files_view_chrome_location_bar_type_id__once;
}

static void
_vala_files_view_chrome_location_bar_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	FilesViewChromeLocationBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBar);
	switch (property_id) {
		case FILES_VIEW_CHROME_LOCATION_BAR_SEARCH_MODE_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_location_bar_get_search_mode (self));
		break;
		case FILES_VIEW_CHROME_LOCATION_BAR_SENSITIVE_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_location_bar_get_sensitive (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_location_bar_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	FilesViewChromeLocationBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBar);
	switch (property_id) {
		case FILES_VIEW_CHROME_LOCATION_BAR_SEARCH_MODE_PROPERTY:
		files_view_chrome_location_bar_set_search_mode (self, g_value_get_boolean (value));
		break;
		case FILES_VIEW_CHROME_LOCATION_BAR_SENSITIVE_PROPERTY:
		files_view_chrome_location_bar_set_sensitive (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

