/* VolumelessMountRow.c generated by valac 0.56.18, the Vala compiler
 * generated from VolumelessMountRow.vala, do not modify */

/* DeviceRow.vala
 *
 * Copyright 2021 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */
/* Represents a mount not associated with a volume or drive - usually a bind mount*/
/* Also used for builtin row "FileSystem" which has null mount*/
/*FIXME Identify and deal with any other conditions resulting in a volumeless mount */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _SidebarBookmarkRowPrivate SidebarBookmarkRowPrivate;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
typedef struct _SidebarAbstractMountableRowPrivate SidebarAbstractMountableRowPrivate;

#define SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW (sidebar_volumeless_mount_row_get_type ())
#define SIDEBAR_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRow))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))

typedef struct _SidebarVolumelessMountRow SidebarVolumelessMountRow;
typedef struct _SidebarVolumelessMountRowClass SidebarVolumelessMountRowClass;
typedef struct _SidebarVolumelessMountRowPrivate SidebarVolumelessMountRowPrivate;
enum  {
	SIDEBAR_VOLUMELESS_MOUNT_ROW_0_PROPERTY,
	SIDEBAR_VOLUMELESS_MOUNT_ROW_NUM_PROPERTIES
};
static GParamSpec* sidebar_volumeless_mount_row_properties[SIDEBAR_VOLUMELESS_MOUNT_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	MOUNTABLE_TYPE_VOLUMELESS_MOUNT,
	MOUNTABLE_TYPE_VOLUME,
	MOUNTABLE_TYPE_EMPTY_DRIVE
} MountableType;

#define TYPE_MOUNTABLE_TYPE (mountable_type_get_type ())

#define FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG (files_view_abstract_properties_dialog_get_type ())
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialog))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))

typedef struct _FilesViewAbstractPropertiesDialog FilesViewAbstractPropertiesDialog;
typedef struct _FilesViewAbstractPropertiesDialogClass FilesViewAbstractPropertiesDialogClass;

#define FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW (files_view_volume_properties_window_get_type ())
#define FILES_VIEW_VOLUME_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW, FilesViewVolumePropertiesWindow))
#define FILES_VIEW_VOLUME_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW, FilesViewVolumePropertiesWindowClass))
#define FILES_VIEW_IS_VOLUME_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW))
#define FILES_VIEW_IS_VOLUME_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW))
#define FILES_VIEW_VOLUME_PROPERTIES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_VOLUME_PROPERTIES_WINDOW, FilesViewVolumePropertiesWindowClass))

typedef struct _FilesViewVolumePropertiesWindow FilesViewVolumePropertiesWindow;
typedef struct _FilesViewVolumePropertiesWindowClass FilesViewVolumePropertiesWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SidebarVolumelessMountRowGetFilesystemSpaceData SidebarVolumelessMountRowGetFilesystemSpaceData;

struct _SidebarBookmarkRow {
	GtkListBoxRow parent_instance;
	SidebarBookmarkRowPrivate * priv;
	GtkGrid* content_grid;
	GtkGrid* icon_label_grid;
	GtkStack* label_stack;
	GtkEntry* editable;
	GtkLabel* label;
	GtkRevealer* drop_revealer;
	FilesFile* target_file;
};

struct _SidebarBookmarkRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*on_key_press_event) (SidebarBookmarkRow* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_release_event) (SidebarBookmarkRow* self, gint n_press, gdouble x, gdouble y);
	void (*popup_context_menu) (SidebarBookmarkRow* self);
};

struct _SidebarAbstractMountableRow {
	SidebarBookmarkRow parent_instance;
	SidebarAbstractMountableRowPrivate * priv;
	gboolean valid;
};

struct _SidebarAbstractMountableRowClass {
	SidebarBookmarkRowClass parent_class;
	void (*update_free_space) (SidebarAbstractMountableRow* self);
	void (*add_mountable_tooltip) (SidebarAbstractMountableRow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_mountable_tooltip_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	void (*on_mount_removed) (SidebarAbstractMountableRow* self, GMount* removed_mount);
	void (*on_mount_added) (SidebarAbstractMountableRow* self, GMount* added_mount);
	void (*show_mount_info) (SidebarAbstractMountableRow* self);
	void (*get_filesystem_space) (SidebarAbstractMountableRow* self, GCancellable* update_cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_filesystem_space_finish) (SidebarAbstractMountableRow* self, GAsyncResult* _res_);
	gboolean (*get_is_mounted) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_unmount) (SidebarAbstractMountableRow* self);
	gboolean (*get_can_eject) (SidebarAbstractMountableRow* self);
};

struct _SidebarVolumelessMountRow {
	SidebarAbstractMountableRow parent_instance;
	SidebarVolumelessMountRowPrivate * priv;
};

struct _SidebarVolumelessMountRowClass {
	SidebarAbstractMountableRowClass parent_class;
};

struct _SidebarVolumelessMountRowGetFilesystemSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SidebarVolumelessMountRow* self;
	GCancellable* update_cancellable;
	gboolean result;
	GFile* root;
	GMount* _tmp0_;
	GMount* _tmp1_;
	GMount* _tmp2_;
	GMount* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
};

static gpointer sidebar_volumeless_mount_row_parent_class = NULL;
static SidebarSidebarItemInterfaceIface * sidebar_volumeless_mount_row_sidebar_sidebar_item_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN GType sidebar_volumeless_mount_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarVolumelessMountRow, g_object_unref)
VALA_EXTERN void sidebar_abstract_mountable_row_on_mount_removed (SidebarAbstractMountableRow* self,
                                                      GMount* removed_mount);
VALA_EXTERN void sidebar_abstract_mountable_row_show_mount_info (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space (SidebarAbstractMountableRow* self,
                                                          GCancellable* update_cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_finish (SidebarAbstractMountableRow* self,
                                                                     GAsyncResult* _res_);
VALA_EXTERN SidebarVolumelessMountRow* sidebar_volumeless_mount_row_new (const gchar* name,
                                                             const gchar* uri,
                                                             GIcon* gicon,
                                                             SidebarSidebarListInterface* list,
                                                             gboolean pinned,
                                                             gboolean permanent,
                                                             const gchar* _uuid,
                                                             GMount* _mount);
VALA_EXTERN SidebarVolumelessMountRow* sidebar_volumeless_mount_row_construct (GType object_type,
                                                                   const gchar* name,
                                                                   const gchar* uri,
                                                                   GIcon* gicon,
                                                                   SidebarSidebarListInterface* list,
                                                                   gboolean pinned,
                                                                   gboolean permanent,
                                                                   const gchar* _uuid,
                                                                   GMount* _mount);
VALA_EXTERN GMount* sidebar_abstract_mountable_row_get_mount (SidebarAbstractMountableRow* self);
VALA_EXTERN void sidebar_abstract_mountable_row_set_sort_key (SidebarAbstractMountableRow* self,
                                                  const gchar* value);
VALA_EXTERN GType mountable_type_get_type (void) G_GNUC_CONST ;
static void sidebar_volumeless_mount_row_real_activated (SidebarSidebarItemInterface* base,
                                                  FilesOpenFlag flag);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_working (SidebarAbstractMountableRow* self);
static void sidebar_volumeless_mount_row_real_on_mount_removed (SidebarAbstractMountableRow* base,
                                                         GMount* removed_mount);
static void sidebar_volumeless_mount_row_real_show_mount_info (SidebarAbstractMountableRow* base);
VALA_EXTERN GtkWindow* files_get_active_window (void);
VALA_EXTERN FilesViewVolumePropertiesWindow* files_view_volume_properties_window_new (GMount* mount,
                                                                          GtkWindow* parent);
VALA_EXTERN FilesViewVolumePropertiesWindow* files_view_volume_properties_window_construct (GType object_type,
                                                                                GMount* mount,
                                                                                GtkWindow* parent);
VALA_EXTERN GType files_view_abstract_properties_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewAbstractPropertiesDialog, g_object_unref)
VALA_EXTERN GType files_view_volume_properties_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewVolumePropertiesWindow, g_object_unref)
static void sidebar_volumeless_mount_row_real_add_extra_menu_items (SidebarSidebarItemInterface* base,
                                                             GMenu* menu);
VALA_EXTERN void sidebar_abstract_mountable_row_add_extra_menu_items_for_mount (SidebarAbstractMountableRow* self,
                                                                    GMount* mount,
                                                                    GMenu* menu);
static void sidebar_volumeless_mount_row_real_get_filesystem_space_data_free (gpointer _data);
static void sidebar_volumeless_mount_row_real_get_filesystem_space (SidebarAbstractMountableRow* base,
                                                             GCancellable* update_cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean sidebar_volumeless_mount_row_real_get_filesystem_space_co (SidebarVolumelessMountRowGetFilesystemSpaceData* _data_);
VALA_EXTERN void sidebar_abstract_mountable_row_get_filesystem_space_for_root (SidebarAbstractMountableRow* self,
                                                                   GFile* root,
                                                                   GCancellable* update_cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
VALA_EXTERN gboolean sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish (SidebarAbstractMountableRow* self,
                                                                              GAsyncResult* _res_);
static void sidebar_volumeless_mount_row_get_filesystem_space_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static GType sidebar_volumeless_mount_row_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

SidebarVolumelessMountRow*
sidebar_volumeless_mount_row_construct (GType object_type,
                                        const gchar* name,
                                        const gchar* uri,
                                        GIcon* gicon,
                                        SidebarSidebarListInterface* list,
                                        gboolean pinned,
                                        gboolean permanent,
                                        const gchar* _uuid,
                                        GMount* _mount)
{
	SidebarVolumelessMountRow * self = NULL;
	GMount* _tmp0_;
	GMount* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	self = (SidebarVolumelessMountRow*) g_object_new (object_type, "custom-name", name, "uri", uri, "gicon", gicon, "list", list, "pinned", pinned, "permanent", permanent, "uuid", _uuid, "mount", _mount, NULL);
	_tmp0_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* mount_sort_key = NULL;
		GMount* _tmp6_;
		GMount* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp2_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf (_ ("%s (%s)"), _tmp3_, _ ("Bind mount"));
		_tmp5_ = _tmp4_;
		sidebar_sidebar_item_interface_set_custom_name ((SidebarSidebarItemInterface*) self, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_mount_get_sort_key (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		mount_sort_key = _tmp9_;
		_tmp10_ = mount_sort_key;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp11_ = mount_sort_key;
			_tmp12_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp15_);
			_g_free0 (_tmp15_);
		} else {
			gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp16_ = g_enum_to_string (TYPE_MOUNTABLE_TYPE, MOUNTABLE_TYPE_VOLUMELESS_MOUNT);
			_tmp17_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
			_tmp20_ = _tmp19_;
			sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
		}
		_g_free0 (mount_sort_key);
	} else {
		sidebar_abstract_mountable_row_set_sort_key ((SidebarAbstractMountableRow*) self, "");
	}
	return self;
}

SidebarVolumelessMountRow*
sidebar_volumeless_mount_row_new (const gchar* name,
                                  const gchar* uri,
                                  GIcon* gicon,
                                  SidebarSidebarListInterface* list,
                                  gboolean pinned,
                                  gboolean permanent,
                                  const gchar* _uuid,
                                  GMount* _mount)
{
	return sidebar_volumeless_mount_row_construct (SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, name, uri, gicon, list, pinned, permanent, _uuid, _mount);
}

static void
sidebar_volumeless_mount_row_real_activated (SidebarSidebarItemInterface* base,
                                             FilesOpenFlag flag)
{
	SidebarVolumelessMountRow * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (SidebarVolumelessMountRow*) base;
	_tmp0_ = sidebar_abstract_mountable_row_get_working ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		SidebarSidebarListInterface* _tmp2_;
		SidebarSidebarListInterface* _tmp3_;
		_tmp2_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp3_ = _tmp2_;
		sidebar_sidebar_list_interface_open_item (_tmp3_, (SidebarSidebarItemInterface*) self, flag);
		return;
	}
}

static void
sidebar_volumeless_mount_row_real_on_mount_removed (SidebarAbstractMountableRow* base,
                                                    GMount* removed_mount)
{
	SidebarVolumelessMountRow * self;
	GMount* _tmp0_;
	GMount* _tmp1_;
	self = (SidebarVolumelessMountRow*) base;
	g_return_if_fail (removed_mount != NULL);
	if (!((SidebarAbstractMountableRow*) self)->valid) {
		return;
	}
	_tmp0_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == removed_mount) {
		SidebarSidebarListInterface* _tmp2_;
		SidebarSidebarListInterface* _tmp3_;
		guint32 _tmp4_;
		guint32 _tmp5_;
		((SidebarAbstractMountableRow*) self)->valid = FALSE;
		_tmp2_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
		_tmp5_ = _tmp4_;
		sidebar_sidebar_list_interface_remove_item_by_id (_tmp3_, _tmp5_);
	}
}

static void
sidebar_volumeless_mount_row_real_show_mount_info (SidebarAbstractMountableRow* base)
{
	SidebarVolumelessMountRow * self;
	gboolean _tmp0_ = FALSE;
	GMount* _tmp1_;
	GMount* _tmp2_;
	self = (SidebarVolumelessMountRow*) base;
	_tmp1_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, FILES_ROOT_FS_URI) == 0;
	}
	if (_tmp0_) {
		GMount* _tmp5_;
		GMount* _tmp6_;
		GtkWindow* _tmp7_;
		GtkWindow* _tmp8_;
		FilesViewVolumePropertiesWindow* _tmp9_;
		FilesViewVolumePropertiesWindow* _tmp10_;
		_tmp5_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = files_get_active_window ();
		_tmp8_ = _tmp7_;
		_tmp9_ = files_view_volume_properties_window_new (_tmp6_, _tmp8_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
	}
}

static void
sidebar_volumeless_mount_row_real_add_extra_menu_items (SidebarSidebarItemInterface* base,
                                                        GMenu* menu)
{
	SidebarVolumelessMountRow * self;
	GMount* _tmp0_;
	GMount* _tmp1_;
	self = (SidebarVolumelessMountRow*) base;
	g_return_if_fail (menu != NULL);
	_tmp0_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) self);
	_tmp1_ = _tmp0_;
	sidebar_abstract_mountable_row_add_extra_menu_items_for_mount ((SidebarAbstractMountableRow*) self, _tmp1_, menu);
}

static void
sidebar_volumeless_mount_row_real_get_filesystem_space_data_free (gpointer _data)
{
	SidebarVolumelessMountRowGetFilesystemSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->update_cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SidebarVolumelessMountRowGetFilesystemSpaceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sidebar_volumeless_mount_row_real_get_filesystem_space (SidebarAbstractMountableRow* base,
                                                        GCancellable* update_cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	SidebarVolumelessMountRow * self;
	SidebarVolumelessMountRowGetFilesystemSpaceData* _data_;
	SidebarVolumelessMountRow* _tmp0_;
	GCancellable* _tmp1_;
	self = (SidebarVolumelessMountRow*) base;
	_data_ = g_slice_new0 (SidebarVolumelessMountRowGetFilesystemSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), update_cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sidebar_volumeless_mount_row_real_get_filesystem_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (update_cancellable);
	_g_object_unref0 (_data_->update_cancellable);
	_data_->update_cancellable = _tmp1_;
	sidebar_volumeless_mount_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_volumeless_mount_row_get_filesystem_space_finish (SidebarAbstractMountableRow* base,
                                                          GAsyncResult* _res_)
{
	gboolean result;
	SidebarVolumelessMountRowGetFilesystemSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
sidebar_volumeless_mount_row_get_filesystem_space_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	SidebarVolumelessMountRowGetFilesystemSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sidebar_volumeless_mount_row_real_get_filesystem_space_co (_data_);
}

static gboolean
sidebar_volumeless_mount_row_real_get_filesystem_space_co (SidebarVolumelessMountRowGetFilesystemSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = sidebar_abstract_mountable_row_get_mount ((SidebarAbstractMountableRow*) _data_->self);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_mount_get_root (_data_->_tmp3_);
		_g_object_unref0 (_data_->root);
		_data_->root = _data_->_tmp4_;
	} else {
		_data_->_tmp5_ = g_file_new_for_uri ("file:///");
		_g_object_unref0 (_data_->root);
		_data_->root = _data_->_tmp5_;
	}
	_data_->_tmp6_ = _data_->root;
	_data_->_state_ = 1;
	sidebar_abstract_mountable_row_get_filesystem_space_for_root ((SidebarAbstractMountableRow*) _data_->self, _data_->_tmp6_, _data_->update_cancellable, sidebar_volumeless_mount_row_get_filesystem_space_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result = sidebar_abstract_mountable_row_get_filesystem_space_for_root_finish ((SidebarAbstractMountableRow*) _data_->self, _data_->_res_);
	_g_object_unref0 (_data_->root);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sidebar_volumeless_mount_row_class_init (SidebarVolumelessMountRowClass * klass,
                                         gpointer klass_data)
{
	sidebar_volumeless_mount_row_parent_class = g_type_class_peek_parent (klass);
	((SidebarAbstractMountableRowClass *) klass)->on_mount_removed = (void (*) (SidebarAbstractMountableRow*, GMount*)) sidebar_volumeless_mount_row_real_on_mount_removed;
	((SidebarAbstractMountableRowClass *) klass)->show_mount_info = (void (*) (SidebarAbstractMountableRow*)) sidebar_volumeless_mount_row_real_show_mount_info;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space = (void (*) (SidebarAbstractMountableRow*, GCancellable*, GAsyncReadyCallback, gpointer)) sidebar_volumeless_mount_row_real_get_filesystem_space;
	((SidebarAbstractMountableRowClass *) klass)->get_filesystem_space_finish = (gboolean (*) (SidebarAbstractMountableRow*, GAsyncResult*)) sidebar_volumeless_mount_row_get_filesystem_space_finish;
}

static void
sidebar_volumeless_mount_row_sidebar_sidebar_item_interface_interface_init (SidebarSidebarItemInterfaceIface * iface,
                                                                            gpointer iface_data)
{
	sidebar_volumeless_mount_row_sidebar_sidebar_item_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->activated = (void (*) (SidebarSidebarItemInterface*, FilesOpenFlag)) sidebar_volumeless_mount_row_real_activated;
	iface->add_extra_menu_items = (void (*) (SidebarSidebarItemInterface*, GMenu*)) sidebar_volumeless_mount_row_real_add_extra_menu_items;
}

static void
sidebar_volumeless_mount_row_instance_init (SidebarVolumelessMountRow * self,
                                            gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
sidebar_volumeless_mount_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarVolumelessMountRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_volumeless_mount_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarVolumelessMountRow), 0, (GInstanceInitFunc) sidebar_volumeless_mount_row_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_item_interface_info = { (GInterfaceInitFunc) sidebar_volumeless_mount_row_sidebar_sidebar_item_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_volumeless_mount_row_type_id;
	sidebar_volumeless_mount_row_type_id = g_type_register_static (SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, "SidebarVolumelessMountRow", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_volumeless_mount_row_type_id, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, &sidebar_sidebar_item_interface_info);
	return sidebar_volumeless_mount_row_type_id;
}

GType
sidebar_volumeless_mount_row_get_type (void)
{
	static volatile gsize sidebar_volumeless_mount_row_type_id__once = 0;
	if (g_once_init_enter (&sidebar_volumeless_mount_row_type_id__once)) {
		GType sidebar_volumeless_mount_row_type_id;
		sidebar_volumeless_mount_row_type_id = sidebar_volumeless_mount_row_get_type_once ();
		g_once_init_leave (&sidebar_volumeless_mount_row_type_id__once, sidebar_volumeless_mount_row_type_id);
	}
	return sidebar_volumeless_mount_row_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

