/* ProgressUIHandler.c generated by valac 0.56.18, the Vala compiler
 * generated from ProgressUIHandler.vala, do not modify */

/***
    Copyright (c) 2007, 2011 Red Hat, Inc.
    Copyright (c) 2013 Julián Unrrein <junrrein@gmail.com>

    This program is free software: you can redistribute it and/or modify it
    under the terms of the GNU Lesser General Public License version 3, as published
    by the Free Software Foundation.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranties of
    MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
    PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program. If not, see <http://www.gnu.org/licenses/>.

    Authors: Alexander Larsson <alexl@redhat.com>
             Cosimo Cecchi <cosimoc@redhat.com>
             Julián Unrrein <junrrein@gmail.com>
             Jeremy Wootten <jeremywootten@gmail.com>
***/

#include <glib-object.h>
#include "pantheon-files-core.h"
#include <granite.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_PROGRESS_TYPE_UI_HANDLER (files_progress_ui_handler_get_type ())
#define FILES_PROGRESS_UI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandler))
#define FILES_PROGRESS_UI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandlerClass))
#define FILES_PROGRESS_IS_UI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_PROGRESS_TYPE_UI_HANDLER))
#define FILES_PROGRESS_IS_UI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_PROGRESS_TYPE_UI_HANDLER))
#define FILES_PROGRESS_UI_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandlerClass))

typedef struct _FilesProgressUIHandler FilesProgressUIHandler;
typedef struct _FilesProgressUIHandlerClass FilesProgressUIHandlerClass;
typedef struct _FilesProgressUIHandlerPrivate FilesProgressUIHandlerPrivate;
enum  {
	FILES_PROGRESS_UI_HANDLER_0_PROPERTY,
	FILES_PROGRESS_UI_HANDLER_NUM_PROPERTIES
};
static GParamSpec* files_progress_ui_handler_properties[FILES_PROGRESS_UI_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

#define FILES_PROGRESS_TYPE_INFO_WIDGET (files_progress_info_widget_get_type ())
#define FILES_PROGRESS_INFO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_PROGRESS_TYPE_INFO_WIDGET, FilesProgressInfoWidget))
#define FILES_PROGRESS_INFO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_PROGRESS_TYPE_INFO_WIDGET, FilesProgressInfoWidgetClass))
#define FILES_PROGRESS_IS_INFO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_PROGRESS_TYPE_INFO_WIDGET))
#define FILES_PROGRESS_IS_INFO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_PROGRESS_TYPE_INFO_WIDGET))
#define FILES_PROGRESS_INFO_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_PROGRESS_TYPE_INFO_WIDGET, FilesProgressInfoWidgetClass))

typedef struct _FilesProgressInfoWidget FilesProgressInfoWidget;
typedef struct _FilesProgressInfoWidgetClass FilesProgressInfoWidgetClass;
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FilesProgressUIHandler {
	GObject parent_instance;
	FilesProgressUIHandlerPrivate * priv;
};

struct _FilesProgressUIHandlerClass {
	GObjectClass parent_class;
};

struct _FilesProgressUIHandlerPrivate {
	PFProgressInfoManager* manager;
	GraniteDialog* progress_window;
	GtkBox* window_vbox;
	guint active_infos;
	GtkApplication* application;
	gboolean launcher_progress_visible;
	gboolean can_show_launcher_progress;
};

struct _Block4Data {
	int _ref_count_;
	FilesProgressUIHandler* self;
	gboolean operation_running;
	PFProgressInfo* info;
};

struct _Block5Data {
	int _ref_count_;
	FilesProgressUIHandler* self;
	FilesProgressInfoWidget* progress_widget;
};

struct _Block6Data {
	int _ref_count_;
	FilesProgressUIHandler* self;
	gchar* title;
};

static gint FilesProgressUIHandler_private_offset;
static gpointer files_progress_ui_handler_parent_class = NULL;

VALA_EXTERN GType files_progress_ui_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesProgressUIHandler, g_object_unref)
static void files_progress_ui_handler_progress_info_started_cb (FilesProgressUIHandler* self,
                                                         PFProgressInfo* info);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _files_progress_ui_handler_progress_info_started_cb_pf_progress_info_started (PFProgressInfo* _sender,
                                                                                   gpointer self);
static void files_progress_ui_handler_progress_info_finished_cb (FilesProgressUIHandler* self,
                                                          PFProgressInfo* info);
static void _files_progress_ui_handler_progress_info_finished_cb_pf_progress_info_finished (PFProgressInfo* _sender,
                                                                                     gpointer self);
static gboolean __lambda6_ (Block4Data* _data4_);
static void files_progress_ui_handler_add_progress_info_to_window (FilesProgressUIHandler* self,
                                                            PFProgressInfo* info);
static gboolean ___lambda6__gsource_func (gpointer self);
static void files_progress_ui_handler_add_to_window (FilesProgressUIHandler* self,
                                              PFProgressInfo* info);
static void files_progress_ui_handler_update_launcher (FilesProgressUIHandler* self,
                                                PFProgressInfo* info,
                                                gboolean added);
VALA_EXTERN GType files_progress_info_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesProgressInfoWidget, g_object_unref)
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void files_progress_ui_handler_ensure_window (FilesProgressUIHandler* self);
VALA_EXTERN FilesProgressInfoWidget* files_progress_info_widget_new (PFProgressInfo* info);
VALA_EXTERN FilesProgressInfoWidget* files_progress_info_widget_construct (GType object_type,
                                                               PFProgressInfo* info);
static void __lambda10_ (Block5Data* _data5_,
                  PFProgressInfo* info);
static void ___lambda10__files_progress_info_widget_cancelled (FilesProgressInfoWidget* _sender,
                                                        PFProgressInfo* info,
                                                        gpointer self);
static gboolean ___lambda7_ (FilesProgressUIHandler* self,
                      GtkWidget* widget,
                      GdkEventAny* event);
static gboolean ____lambda7__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block6Data* _data6_);
static void files_progress_ui_handler_show_operation_complete_notification (FilesProgressUIHandler* self,
                                                                     const gchar* title,
                                                                     gboolean all_finished);
static gboolean _____lambda4__gsource_func (gpointer self);
static void files_progress_ui_handler_update_launcher_entry (FilesProgressUIHandler* self,
                                                      PFProgressInfo* info);
static void files_progress_ui_handler_launcher_progress_changed (FilesProgressUIHandler* self);
static void _files_progress_ui_handler_launcher_progress_changed_pf_progress_info_progress_changed (PFProgressInfo* _sender,
                                                                                             gpointer self);
static void ____lambda5_ (FilesProgressUIHandler* self,
                   GObject* obj,
                   GAsyncResult* res);
static void _____lambda5__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN FilesProgressUIHandler* files_progress_ui_handler_new (void);
VALA_EXTERN FilesProgressUIHandler* files_progress_ui_handler_construct (GType object_type);
static GObject * files_progress_ui_handler_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _files_progress_ui_handler___lambda11_ (FilesProgressUIHandler* self,
                                             PFProgressInfo* info);
static void __files_progress_ui_handler___lambda11__pf_progress_info_manager_new_progress_info (PFProgressInfoManager* _sender,
                                                                                         PFProgressInfo* info,
                                                                                         gpointer self);
static void files_progress_ui_handler_finalize (GObject * obj);
static GType files_progress_ui_handler_get_type_once (void);

static inline gpointer
files_progress_ui_handler_get_instance_private (FilesProgressUIHandler* self)
{
	return G_STRUCT_MEMBER_P (self, FilesProgressUIHandler_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FilesProgressUIHandler* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->info);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_files_progress_ui_handler_progress_info_started_cb_pf_progress_info_started (PFProgressInfo* _sender,
                                                                              gpointer self)
{
	files_progress_ui_handler_progress_info_started_cb ((FilesProgressUIHandler*) self, _sender);
}

static void
_files_progress_ui_handler_progress_info_finished_cb_pf_progress_info_finished (PFProgressInfo* _sender,
                                                                                gpointer self)
{
	files_progress_ui_handler_progress_info_finished_cb ((FilesProgressUIHandler*) self, _sender);
}

static gboolean
__lambda6_ (Block4Data* _data4_)
{
	FilesProgressUIHandler* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	self = _data4_->self;
	if (_data4_->info == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data4_->info, PF_PROGRESS_TYPE_INFO);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = pf_progress_info_get_is_finished (_data4_->info);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = pf_progress_info_get_is_cancelled (_data4_->info);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp7_ = pf_progress_info_get_is_paused (_data4_->info);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		if (_data4_->operation_running) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = pf_progress_info_get_is_finished (_data4_->info);
			_tmp11_ = _tmp10_;
			_tmp9_ = !_tmp11_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			files_progress_ui_handler_add_progress_info_to_window (self, _data4_->info);
			result = G_SOURCE_REMOVE;
			return result;
		} else {
			_data4_->operation_running = TRUE;
			result = G_SOURCE_CONTINUE;
			return result;
		}
	}
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
	return result;
}

static void
files_progress_ui_handler_progress_info_started_cb (FilesProgressUIHandler* self,
                                                    PFProgressInfo* info)
{
	Block4Data* _data4_;
	PFProgressInfo* _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (info);
	_g_object_unref0 (_data4_->info);
	_data4_->info = _tmp0_;
	if (_data4_->info == NULL) {
		g_critical ("ProgressUIHandler.vala:58: Null progressinfo started");
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	g_signal_parse_name ("started", PF_PROGRESS_TYPE_INFO, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data4_->info, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_progress_ui_handler_progress_info_started_cb_pf_progress_info_started, self);
	_tmp3_ = pf_progress_info_get_is_finished (_data4_->info);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = pf_progress_info_get_is_cancelled (_data4_->info);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	g_signal_connect_object (_data4_->info, "finished", (GCallback) _files_progress_ui_handler_progress_info_finished_cb_pf_progress_info_finished, self, 0);
	_tmp7_ = self->priv->active_infos;
	self->priv->active_infos = _tmp7_ + 1;
	_data4_->operation_running = FALSE;
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 500, ___lambda6__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
files_progress_ui_handler_add_progress_info_to_window (FilesProgressUIHandler* self,
                                                       PFProgressInfo* info)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	if (self->priv->active_infos == ((guint) 1)) {
		GraniteDialog* _tmp0_;
		files_progress_ui_handler_add_to_window (self, info);
		_tmp0_ = self->priv->progress_window;
		gtk_window_present ((GtkWindow*) _tmp0_);
	} else {
		GraniteDialog* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->progress_window;
		_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			files_progress_ui_handler_add_to_window (self, info);
		}
	}
	files_progress_ui_handler_update_launcher (self, info, TRUE);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FilesProgressUIHandler* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->progress_widget);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda10_ (Block5Data* _data5_,
             PFProgressInfo* info)
{
	FilesProgressUIHandler* self;
	FilesProgressInfoWidget* _tmp0_;
	self = _data5_->self;
	g_return_if_fail (info != NULL);
	files_progress_ui_handler_progress_info_finished_cb (self, info);
	_tmp0_ = _data5_->progress_widget;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
___lambda10__files_progress_info_widget_cancelled (FilesProgressInfoWidget* _sender,
                                                   PFProgressInfo* info,
                                                   gpointer self)
{
	__lambda10_ (self, info);
}

static void
files_progress_ui_handler_add_to_window (FilesProgressUIHandler* self,
                                         PFProgressInfo* info)
{
	Block5Data* _data5_;
	FilesProgressInfoWidget* _tmp0_;
	GtkBox* _tmp1_;
	FilesProgressInfoWidget* _tmp2_;
	FilesProgressInfoWidget* _tmp3_;
	FilesProgressInfoWidget* _tmp4_;
	GraniteDialog* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	files_progress_ui_handler_ensure_window (self);
	_tmp0_ = files_progress_info_widget_new (info);
	g_object_ref_sink (_tmp0_);
	_data5_->progress_widget = _tmp0_;
	_tmp1_ = self->priv->window_vbox;
	_tmp2_ = _data5_->progress_widget;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = _data5_->progress_widget;
	g_signal_connect_data (_tmp3_, "cancelled", (GCallback) ___lambda10__files_progress_info_widget_cancelled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp4_ = _data5_->progress_widget;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->progress_window;
	_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GraniteDialog* _tmp8_;
		_tmp8_ = self->priv->progress_window;
		gtk_window_present ((GtkWindow*) _tmp8_);
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static gboolean
___lambda7_ (FilesProgressUIHandler* self,
             GtkWidget* widget,
             GdkEventAny* event)
{
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_hide (widget);
	result = TRUE;
	return result;
}

static gboolean
____lambda7__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = ___lambda7_ ((FilesProgressUIHandler*) self, _sender, event);
	return result;
}

static void
files_progress_ui_handler_ensure_window (FilesProgressUIHandler* self)
{
	GraniteDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_window;
	if (_tmp0_ == NULL) {
		GtkBox* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GtkApplication* _tmp4_;
		GtkWindow* _tmp5_;
		GtkWindow* _tmp6_;
		GraniteDialog* _tmp7_ = NULL;
		GraniteDialog* _tmp8_;
		GtkBox* _tmp9_;
		GtkBox* _tmp10_;
		GtkBox* _tmp11_;
		GraniteDialog* _tmp12_;
		_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
		gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 10);
		gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 10);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->window_vbox);
		self->priv->window_vbox = _tmp1_;
		_tmp2_ = g_strdup (_ ("File Operations"));
		_tmp3_ = g_strdup ("system-file-manager");
		_tmp4_ = self->priv->application;
		_tmp5_ = gtk_application_get_active_window (_tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_tmp7_ = granite_dialog_new ();
		gtk_window_set_resizable ((GtkWindow*) _tmp7_, FALSE);
		gtk_window_set_title ((GtkWindow*) _tmp7_, _tmp2_);
		_g_free0 (_tmp2_);
		gtk_window_set_icon_name ((GtkWindow*) _tmp7_, _tmp3_);
		_g_free0 (_tmp3_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp6_);
		_g_object_unref0 (_tmp6_);
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (self->priv->progress_window);
		self->priv->progress_window = _tmp7_;
		_tmp8_ = self->priv->progress_window;
		_tmp9_ = gtk_dialog_get_content_area ((GtkDialog*) _tmp8_);
		_tmp10_ = self->priv->window_vbox;
		gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = self->priv->window_vbox;
		gtk_widget_show ((GtkWidget*) _tmp11_);
		_tmp12_ = self->priv->progress_window;
		g_signal_connect_object ((GtkWidget*) _tmp12_, "delete-event", (GCallback) ____lambda7__gtk_widget_delete_event, self, 0);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		FilesProgressUIHandler* self;
		self = _data6_->self;
		_g_free0 (_data6_->title);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
____lambda4_ (Block6Data* _data6_)
{
	FilesProgressUIHandler* self;
	GtkApplication* _tmp0_;
	GtkWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = _data6_->self;
	_tmp0_ = self->priv->application;
	_tmp1_ = gtk_application_get_active_window (_tmp0_);
	g_object_get (_tmp1_, "has-toplevel-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = _data6_->title;
		files_progress_ui_handler_show_operation_complete_notification (self, _tmp4_, self->priv->active_infos < ((guint) 1));
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}

static void
files_progress_ui_handler_progress_info_finished_cb (FilesProgressUIHandler* self,
                                                     PFProgressInfo* info)
{
	guint _tmp0_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_signal_parse_name ("finished", PF_PROGRESS_TYPE_INFO, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (info, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _files_progress_ui_handler_progress_info_finished_cb_pf_progress_info_finished, self);
	if (self->priv->active_infos > ((guint) 0)) {
		guint _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->active_infos;
		self->priv->active_infos = _tmp1_ - 1;
		_tmp2_ = pf_progress_info_get_is_cancelled (info);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			Block6Data* _data6_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_data6_ = g_slice_new0 (Block6Data);
			_data6_->_ref_count_ = 1;
			_data6_->self = g_object_ref (self);
			_tmp4_ = pf_progress_info_get_title (info);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			_data6_->title = _tmp6_;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _____lambda4__gsource_func, block6_data_ref (_data6_), block6_data_unref);
			block6_data_unref (_data6_);
			_data6_ = NULL;
		}
	} else {
		g_warning ("ProgressUIHandler.vala:169: Attempt to decrement zero active infos");
	}
	if (self->priv->active_infos < ((guint) 1)) {
		GraniteDialog* _tmp9_;
		_tmp9_ = self->priv->progress_window;
		_tmp8_ = _tmp9_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GraniteDialog* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = self->priv->progress_window;
		_tmp11_ = gtk_widget_get_visible ((GtkWidget*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp7_ = _tmp12_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GraniteDialog* _tmp13_;
		_tmp13_ = self->priv->progress_window;
		gtk_widget_hide ((GtkWidget*) _tmp13_);
	}
	files_progress_ui_handler_update_launcher (self, info, FALSE);
}

static void
files_progress_ui_handler_show_operation_complete_notification (FilesProgressUIHandler* self,
                                                                const gchar* title,
                                                                gboolean all_finished)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	GNotification* complete_notification = NULL;
	GNotification* _tmp5_;
	const gchar* _tmp6_;
	GThemedIcon* _tmp7_;
	GThemedIcon* _tmp8_;
	GtkApplication* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup_printf (_ ("Completed %s"), title);
	_result_ = _tmp0_;
	if (all_finished) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = _result_;
		_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, _ ("All file operations have ended"), NULL);
		_g_free0 (_result_);
		_result_ = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = g_notification_new (_ ("File Operations"));
	complete_notification = _tmp5_;
	_tmp6_ = _result_;
	g_notification_set_body (complete_notification, _tmp6_);
	_tmp7_ = (GThemedIcon*) g_themed_icon_new (FILES_ICON_APP_LOGO);
	_tmp8_ = _tmp7_;
	g_notification_set_icon (complete_notification, (GIcon*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->application;
	g_application_send_notification ((GApplication*) _tmp9_, "Pantheon Files Operation", complete_notification);
	_g_object_unref0 (complete_notification);
	_g_free0 (_result_);
}

static void
_files_progress_ui_handler_launcher_progress_changed_pf_progress_info_progress_changed (PFProgressInfo* _sender,
                                                                                        gpointer self)
{
	files_progress_ui_handler_launcher_progress_changed ((FilesProgressUIHandler*) self);
}

static void
files_progress_ui_handler_update_launcher (FilesProgressUIHandler* self,
                                           PFProgressInfo* info,
                                           gboolean added)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	files_progress_ui_handler_update_launcher_entry (self, info);
	if (added) {
		g_signal_connect_object (info, "progress-changed", (GCallback) _files_progress_ui_handler_launcher_progress_changed_pf_progress_info_progress_changed, self, 0);
	}
}

static void
____lambda5_ (FilesProgressUIHandler* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = granite_services_application_set_progress_visible_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			self->priv->launcher_progress_visible = TRUE;
			files_progress_ui_handler_launcher_progress_changed (self);
		} else {
			self->priv->can_show_launcher_progress = FALSE;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->priv->can_show_launcher_progress = FALSE;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_debug ("ProgressUIHandler.vala:216: Could not set progress visible: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda5__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda5_ ((FilesProgressUIHandler*) self, source_object, res);
	g_object_unref (self);
}

static void
files_progress_ui_handler_update_launcher_entry (FilesProgressUIHandler* self,
                                                 PFProgressInfo* info)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	if (self->priv->active_infos > ((guint) 0)) {
		gboolean _tmp0_ = FALSE;
		if (!self->priv->launcher_progress_visible) {
			_tmp0_ = self->priv->can_show_launcher_progress;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			granite_services_application_set_progress_visible (TRUE, _____lambda5__gasync_ready_callback, g_object_ref (self));
		} else {
			if (self->priv->launcher_progress_visible) {
				files_progress_ui_handler_launcher_progress_changed (self);
			}
		}
	} else {
		self->priv->launcher_progress_visible = FALSE;
		self->priv->can_show_launcher_progress = TRUE;
		granite_services_application_set_progress_visible (FALSE, NULL, NULL);
	}
}

static void
files_progress_ui_handler_launcher_progress_changed (FilesProgressUIHandler* self)
{
	gdouble progress = 0.0;
	gdouble current = 0.0;
	gdouble total = 0.0;
	GeeLinkedList* infos = NULL;
	PFProgressInfoManager* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	progress = (gdouble) 0;
	current = (gdouble) 0;
	total = (gdouble) 0;
	_tmp0_ = self->priv->manager;
	_tmp1_ = pf_progress_info_manager_get_all_infos (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	infos = _tmp2_;
	{
		GeeLinkedList* __info_list = NULL;
		GeeLinkedList* _tmp3_;
		gint __info_size = 0;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint __info_index = 0;
		_tmp3_ = infos;
		__info_list = _tmp3_;
		_tmp4_ = __info_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		__info_size = _tmp6_;
		__info_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			PFProgressInfo* _info = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			gdouble c = 0.0;
			PFProgressInfo* _tmp11_;
			gdouble _tmp12_;
			gdouble _tmp13_;
			gdouble t = 0.0;
			PFProgressInfo* _tmp14_;
			gdouble _tmp15_;
			gdouble _tmp16_;
			__info_index = __info_index + 1;
			_tmp7_ = __info_index;
			_tmp8_ = __info_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = __info_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, __info_index);
			_info = (PFProgressInfo*) _tmp10_;
			_tmp11_ = _info;
			_tmp12_ = pf_progress_info_get_current (_tmp11_);
			_tmp13_ = _tmp12_;
			c = _tmp13_;
			_tmp14_ = _info;
			_tmp15_ = pf_progress_info_get_total (_tmp14_);
			_tmp16_ = _tmp15_;
			t = _tmp16_;
			if (c < ((gdouble) 0)) {
				c = (gdouble) 0;
			}
			if (t <= ((gdouble) 0)) {
				_g_object_unref0 (_info);
				continue;
			}
			current += c;
			total += t;
			_g_object_unref0 (_info);
		}
	}
	if (current >= ((gdouble) 0)) {
		_tmp17_ = total > ((gdouble) 0);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		progress = current / total;
	}
	if (progress > 1.0) {
		progress = 1.0;
	}
	granite_services_application_set_progress (progress, NULL, NULL);
	_g_object_unref0 (infos);
}

FilesProgressUIHandler*
files_progress_ui_handler_construct (GType object_type)
{
	FilesProgressUIHandler * self = NULL;
	self = (FilesProgressUIHandler*) g_object_new (object_type, NULL);
	return self;
}

FilesProgressUIHandler*
files_progress_ui_handler_new (void)
{
	return files_progress_ui_handler_construct (FILES_PROGRESS_TYPE_UI_HANDLER);
}

static void
_files_progress_ui_handler___lambda11_ (FilesProgressUIHandler* self,
                                        PFProgressInfo* info)
{
	g_return_if_fail (info != NULL);
	g_signal_connect_object (info, "started", (GCallback) _files_progress_ui_handler_progress_info_started_cb_pf_progress_info_started, self, 0);
}

static void
__files_progress_ui_handler___lambda11__pf_progress_info_manager_new_progress_info (PFProgressInfoManager* _sender,
                                                                                    PFProgressInfo* info,
                                                                                    gpointer self)
{
	_files_progress_ui_handler___lambda11_ ((FilesProgressUIHandler*) self, info);
}

static GObject *
files_progress_ui_handler_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesProgressUIHandler * self;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	PFProgressInfoManager* _tmp2_;
	PFProgressInfoManager* _tmp3_;
	parent_class = G_OBJECT_CLASS (files_progress_ui_handler_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandler);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp1_;
	_tmp2_ = pf_progress_info_manager_get_instance ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp2_;
	_tmp3_ = self->priv->manager;
	g_signal_connect_object (_tmp3_, "new-progress-info", (GCallback) __files_progress_ui_handler___lambda11__pf_progress_info_manager_new_progress_info, self, 0);
	return obj;
}

static void
files_progress_ui_handler_class_init (FilesProgressUIHandlerClass * klass,
                                      gpointer klass_data)
{
	files_progress_ui_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesProgressUIHandler_private_offset);
	G_OBJECT_CLASS (klass)->constructor = files_progress_ui_handler_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_progress_ui_handler_finalize;
}

static void
files_progress_ui_handler_instance_init (FilesProgressUIHandler * self,
                                         gpointer klass)
{
	self->priv = files_progress_ui_handler_get_instance_private (self);
	self->priv->manager = NULL;
	self->priv->progress_window = NULL;
	self->priv->window_vbox = NULL;
	self->priv->active_infos = (guint) 0;
	self->priv->launcher_progress_visible = FALSE;
	self->priv->can_show_launcher_progress = TRUE;
}

static void
files_progress_ui_handler_finalize (GObject * obj)
{
	FilesProgressUIHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandler);
	g_debug ("ProgressUIHandler.vala:46: ProgressUIHandler destruct");
	if (self->priv->active_infos > ((guint) 0)) {
		GeeLinkedList* infos = NULL;
		PFProgressInfoManager* _tmp0_;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		g_warning ("ProgressUIHandler.vala:48: ProgressUIHandler destruct when infos activ" \
"e");
		_tmp0_ = self->priv->manager;
		_tmp1_ = pf_progress_info_manager_get_all_infos (_tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		infos = _tmp2_;
		{
			GeeLinkedList* _info_list = NULL;
			GeeLinkedList* _tmp3_;
			gint _info_size = 0;
			GeeLinkedList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _info_index = 0;
			_tmp3_ = infos;
			_info_list = _tmp3_;
			_tmp4_ = _info_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_info_size = _tmp6_;
			_info_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				PFProgressInfo* info = NULL;
				GeeLinkedList* _tmp9_;
				gpointer _tmp10_;
				PFProgressInfo* _tmp11_;
				_info_index = _info_index + 1;
				_tmp7_ = _info_index;
				_tmp8_ = _info_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _info_list;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _info_index);
				info = (PFProgressInfo*) _tmp10_;
				_tmp11_ = info;
				pf_progress_info_cancel (_tmp11_);
				_g_object_unref0 (info);
			}
		}
		_g_object_unref0 (infos);
	}
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->progress_window);
	_g_object_unref0 (self->priv->window_vbox);
	_g_object_unref0 (self->priv->application);
	G_OBJECT_CLASS (files_progress_ui_handler_parent_class)->finalize (obj);
}

/*** One instance of this class is owned by the application and handles UI for file transfers initiated by
 *   of the app windows.  Feedback is provided by a dialog window which appears if a transfer takes longer than
 *   approximately 1 second. The launcher is also updated if present and a notification is sent of the
 *   completion of the operation unless it was cancelled by the user.
***/
 G_GNUC_NO_INLINE static GType
files_progress_ui_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesProgressUIHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_progress_ui_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesProgressUIHandler), 0, (GInstanceInitFunc) files_progress_ui_handler_instance_init, NULL };
	GType files_progress_ui_handler_type_id;
	files_progress_ui_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesProgressUIHandler", &g_define_type_info, 0);
	FilesProgressUIHandler_private_offset = g_type_add_instance_private (files_progress_ui_handler_type_id, sizeof (FilesProgressUIHandlerPrivate));
	return files_progress_ui_handler_type_id;
}

GType
files_progress_ui_handler_get_type (void)
{
	static volatile gsize files_progress_ui_handler_type_id__once = 0;
	if (g_once_init_enter (&files_progress_ui_handler_type_id__once)) {
		GType files_progress_ui_handler_type_id;
		files_progress_ui_handler_type_id = files_progress_ui_handler_get_type_once ();
		g_once_init_leave (&files_progress_ui_handler_type_id__once, files_progress_ui_handler_type_id);
	}
	return files_progress_ui_handler_type_id__once;
}

