/* EmblemRenderer.c generated by valac 0.56.18, the Vala compiler
 * generated from EmblemRenderer.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "pantheon-files-core.h"
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define FILES_EMBLEM_RENDERER_RIGHT_MARGIN 12
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_EMBLEM_RENDERER (files_emblem_renderer_get_type ())
#define FILES_EMBLEM_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_EMBLEM_RENDERER, FilesEmblemRenderer))
#define FILES_EMBLEM_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_EMBLEM_RENDERER, FilesEmblemRendererClass))
#define FILES_IS_EMBLEM_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_EMBLEM_RENDERER))
#define FILES_IS_EMBLEM_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_EMBLEM_RENDERER))
#define FILES_EMBLEM_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_EMBLEM_RENDERER, FilesEmblemRendererClass))

typedef struct _FilesEmblemRenderer FilesEmblemRenderer;
typedef struct _FilesEmblemRendererClass FilesEmblemRendererClass;
typedef struct _FilesEmblemRendererPrivate FilesEmblemRendererPrivate;
enum  {
	FILES_EMBLEM_RENDERER_0_PROPERTY,
	FILES_EMBLEM_RENDERER_FILE_PROPERTY,
	FILES_EMBLEM_RENDERER_NUM_PROPERTIES
};
static GParamSpec* files_emblem_renderer_properties[FILES_EMBLEM_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FilesEmblemRenderer {
	GtkCellRenderer parent_instance;
	FilesEmblemRendererPrivate * priv;
};

struct _FilesEmblemRendererClass {
	GtkCellRendererClass parent_class;
};

struct _FilesEmblemRendererPrivate {
	FilesFile* _file;
	gint icon_scale;
};

static gint FilesEmblemRenderer_private_offset;
static gpointer files_emblem_renderer_parent_class = NULL;
static GeeHashMap* files_emblem_renderer_emblem_pixbuf_map;
static GeeHashMap* files_emblem_renderer_emblem_pixbuf_map = NULL;

VALA_EXTERN GType files_emblem_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesEmblemRenderer, g_object_unref)
VALA_EXTERN void files_emblem_renderer_clear_cache (void);
static void files_emblem_renderer_real_render (GtkCellRenderer* base,
                                        cairo_t* cr,
                                        GtkWidget* widget,
                                        GdkRectangle* background_area,
                                        GdkRectangle* cell_area,
                                        GtkCellRendererState flags);
VALA_EXTERN FilesFile* files_emblem_renderer_get_file (FilesEmblemRenderer* self);
VALA_EXTERN GdkPixbuf* files_emblem_renderer_render_icon (FilesEmblemRenderer* self,
                                              const gchar* icon_name,
                                              GtkStyleContext* context);
static void files_emblem_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                     GtkWidget* widget,
                                                     gint* minimum_size,
                                                     gint* natural_size);
static void files_emblem_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                      GtkWidget* widget,
                                                      gint* minimum_size,
                                                      gint* natural_size);
static void files_emblem_renderer_real_get_size (GtkCellRenderer* base,
                                          GtkWidget* widget,
                                          GdkRectangle* cell_area,
                                          gint* x_offset,
                                          gint* y_offset,
                                          gint* width,
                                          gint* height);
VALA_EXTERN FilesEmblemRenderer* files_emblem_renderer_new (void);
VALA_EXTERN FilesEmblemRenderer* files_emblem_renderer_construct (GType object_type);
VALA_EXTERN void files_emblem_renderer_set_file (FilesEmblemRenderer* self,
                                     FilesFile* value);
static void files_emblem_renderer_finalize (GObject * obj);
static GType files_emblem_renderer_get_type_once (void);
static void _vala_files_emblem_renderer_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_files_emblem_renderer_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
files_emblem_renderer_get_instance_private (FilesEmblemRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, FilesEmblemRenderer_private_offset);
}

void
files_emblem_renderer_clear_cache (void)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = files_emblem_renderer_emblem_pixbuf_map;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_emblem_renderer_real_render (GtkCellRenderer* base,
                                   cairo_t* cr,
                                   GtkWidget* widget,
                                   GdkRectangle* background_area,
                                   GdkRectangle* cell_area,
                                   GtkCellRendererState flags)
{
	FilesEmblemRenderer * self;
	FilesFile* _tmp0_;
	GtkStyleContext* style_context = NULL;
	GtkContainer* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	gint pos = 0;
	GdkRectangle emblem_area = {0};
	FilesFile* _tmp4_;
	GList* _tmp5_;
	self = (FilesEmblemRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = self->priv->_file;
	if (_tmp0_ == NULL) {
		return;
	}
	if (gtk_widget_get_scale_factor (widget) != self->priv->icon_scale) {
		self->priv->icon_scale = gtk_widget_get_scale_factor (widget);
	}
	_tmp1_ = gtk_widget_get_parent (widget);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style_context = _tmp3_;
	pos = 1;
	memset (&emblem_area, 0, sizeof (GdkRectangle));
	_tmp4_ = self->priv->_file;
	_tmp5_ = _tmp4_->emblems_list;
	{
		GList* emblem_collection = NULL;
		GList* emblem_it = NULL;
		emblem_collection = _tmp5_;
		for (emblem_it = emblem_collection; emblem_it != NULL; emblem_it = emblem_it->next) {
			gchar* _tmp6_;
			gchar* emblem = NULL;
			_tmp6_ = g_strdup ((const gchar*) emblem_it->data);
			emblem = _tmp6_;
			{
				GdkPixbuf* pix = NULL;
				gchar* key = NULL;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				GeeHashMap* _tmp9_;
				const gchar* _tmp10_;
				GdkRectangle _tmp21_;
				GdkRectangle _tmp22_;
				GdkRectangle _tmp23_;
				GdkRectangle _tmp24_;
				GtkStyleContext* _tmp25_;
				GdkPixbuf* _tmp26_;
				GdkRectangle _tmp27_;
				GdkRectangle _tmp28_;
				gint _tmp29_;
				pix = NULL;
				_tmp7_ = emblem;
				_tmp8_ = g_strconcat (_tmp7_, "-symbolic", NULL);
				key = _tmp8_;
				_tmp9_ = files_emblem_renderer_emblem_pixbuf_map;
				_tmp10_ = key;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp10_)) {
					GeeHashMap* _tmp11_;
					const gchar* _tmp12_;
					gpointer _tmp13_;
					_tmp11_ = files_emblem_renderer_emblem_pixbuf_map;
					_tmp12_ = key;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
					_g_object_unref0 (pix);
					pix = (GdkPixbuf*) _tmp13_;
				} else {
					const gchar* _tmp14_;
					GtkStyleContext* _tmp15_;
					GdkPixbuf* _tmp16_;
					GdkPixbuf* _tmp17_;
					GeeHashMap* _tmp18_;
					const gchar* _tmp19_;
					GdkPixbuf* _tmp20_;
					_tmp14_ = key;
					_tmp15_ = style_context;
					_tmp16_ = files_emblem_renderer_render_icon (self, _tmp14_, _tmp15_);
					_g_object_unref0 (pix);
					pix = _tmp16_;
					_tmp17_ = pix;
					if (_tmp17_ == NULL) {
						_g_free0 (key);
						_g_object_unref0 (pix);
						_g_free0 (emblem);
						continue;
					}
					_tmp18_ = files_emblem_renderer_emblem_pixbuf_map;
					_tmp19_ = key;
					_tmp20_ = pix;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp19_, _tmp20_);
				}
				_tmp21_ = *cell_area;
				_tmp22_ = *cell_area;
				emblem_area.y = _tmp21_.y + ((_tmp22_.height - FILES_ICON_SIZE_EMBLEM) / 2);
				_tmp23_ = *cell_area;
				_tmp24_ = *cell_area;
				emblem_area.x = ((_tmp23_.x + _tmp24_.width) - (pos * FILES_ICON_SIZE_EMBLEM)) - FILES_EMBLEM_RENDERER_RIGHT_MARGIN;
				_tmp25_ = style_context;
				_tmp26_ = pix;
				_tmp27_ = emblem_area;
				_tmp28_ = emblem_area;
				gtk_render_icon (_tmp25_, cr, _tmp26_, (gdouble) (_tmp27_.x * self->priv->icon_scale), (gdouble) (_tmp28_.y * self->priv->icon_scale));
				_tmp29_ = pos;
				pos = _tmp29_ + 1;
				_g_free0 (key);
				_g_object_unref0 (pix);
				_g_free0 (emblem);
			}
		}
	}
	_g_object_unref0 (style_context);
}

GdkPixbuf*
files_emblem_renderer_render_icon (FilesEmblemRenderer* self,
                                   const gchar* icon_name,
                                   GtkStyleContext* context)
{
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	GdkPixbuf* pix = NULL;
	GtkIconInfo* gtk_icon_info = NULL;
	gint scale = 0;
	GThemedIcon* gicon = NULL;
	GThemedIcon* _tmp2_;
	GtkIconLookupFlags flags = 0U;
	GtkIconTheme* _tmp3_;
	GThemedIcon* _tmp4_;
	GtkIconInfo* _tmp5_;
	GtkIconInfo* _tmp6_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	pix = NULL;
	gtk_icon_info = NULL;
	scale = gtk_style_context_get_scale (context);
	_tmp2_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (icon_name);
	gicon = _tmp2_;
	flags = GTK_ICON_LOOKUP_FORCE_SIZE | GTK_ICON_LOOKUP_FORCE_SYMBOLIC;
	_tmp3_ = theme;
	_tmp4_ = gicon;
	_tmp5_ = gtk_icon_theme_lookup_by_gicon_for_scale (_tmp3_, (GIcon*) _tmp4_, 16, scale, flags);
	_g_object_unref0 (gtk_icon_info);
	gtk_icon_info = _tmp5_;
	_tmp6_ = gtk_icon_info;
	if (_tmp6_ != NULL) {
		{
			GdkPixbuf* _tmp7_ = NULL;
			GtkIconInfo* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp8_ = gtk_icon_info;
			_tmp9_ = gtk_icon_info_load_symbolic_for_context (_tmp8_, context, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (pix);
			pix = _tmp10_;
			_g_object_unref0 (_tmp7_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("EmblemRenderer.vala:91: Failed to load icon for %s: %s", icon_name, _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (gicon);
			_g_object_unref0 (gtk_icon_info);
			_g_object_unref0 (pix);
			_g_object_unref0 (theme);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = pix;
	_g_object_unref0 (gicon);
	_g_object_unref0 (gtk_icon_info);
	_g_object_unref0 (theme);
	return result;
}

static void
files_emblem_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                GtkWidget* widget,
                                                gint* minimum_size,
                                                gint* natural_size)
{
	FilesEmblemRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	FilesFile* _tmp0_;
	self = (FilesEmblemRenderer*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->_file;
	if (_tmp0_ != NULL) {
		FilesFile* _tmp1_;
		_tmp1_ = self->priv->_file;
		_vala_minimum_size = ((gint) ((_tmp1_->n_emblems + 1) * FILES_ICON_SIZE_EMBLEM)) + FILES_EMBLEM_RENDERER_RIGHT_MARGIN;
		_vala_natural_size = _vala_minimum_size;
	} else {
		_vala_minimum_size = 0;
		_vala_natural_size = 0;
	}
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
files_emblem_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                 GtkWidget* widget,
                                                 gint* minimum_size,
                                                 gint* natural_size)
{
	FilesEmblemRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	self = (FilesEmblemRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_natural_size = (gint) FILES_ICON_SIZE_EMBLEM;
	_vala_minimum_size = _vala_natural_size;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static void
files_emblem_renderer_real_get_size (GtkCellRenderer* base,
                                     GtkWidget* widget,
                                     GdkRectangle* cell_area,
                                     gint* x_offset,
                                     gint* y_offset,
                                     gint* width,
                                     gint* height)
{
	FilesEmblemRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint mw = 0;
	gint nw = 0;
	gint mh = 0;
	gint nh = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = (FilesEmblemRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_x_offset = 0;
	_vala_y_offset = 0;
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, widget, &_tmp0_, &_tmp1_);
	mw = _tmp0_;
	nw = _tmp1_;
	gtk_cell_renderer_get_preferred_height ((GtkCellRenderer*) self, widget, &_tmp2_, &_tmp3_);
	mh = _tmp2_;
	nh = _tmp3_;
	_vala_width = nw;
	_vala_height = nh;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

FilesEmblemRenderer*
files_emblem_renderer_construct (GType object_type)
{
	FilesEmblemRenderer * self = NULL;
	self = (FilesEmblemRenderer*) g_object_new (object_type, NULL);
	return self;
}

FilesEmblemRenderer*
files_emblem_renderer_new (void)
{
	return files_emblem_renderer_construct (FILES_TYPE_EMBLEM_RENDERER);
}

FilesFile*
files_emblem_renderer_get_file (FilesEmblemRenderer* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

void
files_emblem_renderer_set_file (FilesEmblemRenderer* self,
                                FilesFile* value)
{
	FilesFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_emblem_renderer_get_file (self);
	if (old_value != value) {
		FilesFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_emblem_renderer_properties[FILES_EMBLEM_RENDERER_FILE_PROPERTY]);
	}
}

static void
files_emblem_renderer_class_init (FilesEmblemRendererClass * klass,
                                  gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	files_emblem_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesEmblemRenderer_private_offset);
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) files_emblem_renderer_real_render;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) files_emblem_renderer_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) files_emblem_renderer_real_get_preferred_height;
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) files_emblem_renderer_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_emblem_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_emblem_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_emblem_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_EMBLEM_RENDERER_FILE_PROPERTY, files_emblem_renderer_properties[FILES_EMBLEM_RENDERER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (files_emblem_renderer_emblem_pixbuf_map);
	files_emblem_renderer_emblem_pixbuf_map = _tmp0_;
}

static void
files_emblem_renderer_instance_init (FilesEmblemRenderer * self,
                                     gpointer klass)
{
	self->priv = files_emblem_renderer_get_instance_private (self);
	self->priv->icon_scale = 1;
}

static void
files_emblem_renderer_finalize (GObject * obj)
{
	FilesEmblemRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_EMBLEM_RENDERER, FilesEmblemRenderer);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (files_emblem_renderer_parent_class)->finalize (obj);
}

/***
    Copyright (c) 2021 Elementary, Inc <https://elementary.io>

    Pantheon Files is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Pantheon Files is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; see the file COPYING.  If not,
    write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1335 USA.

    Author(s):  Jeremy Wootten <jeremywootten@gmail.com>

***/
 G_GNUC_NO_INLINE static GType
files_emblem_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesEmblemRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_emblem_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesEmblemRenderer), 0, (GInstanceInitFunc) files_emblem_renderer_instance_init, NULL };
	GType files_emblem_renderer_type_id;
	files_emblem_renderer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "FilesEmblemRenderer", &g_define_type_info, 0);
	FilesEmblemRenderer_private_offset = g_type_add_instance_private (files_emblem_renderer_type_id, sizeof (FilesEmblemRendererPrivate));
	return files_emblem_renderer_type_id;
}

GType
files_emblem_renderer_get_type (void)
{
	static volatile gsize files_emblem_renderer_type_id__once = 0;
	if (g_once_init_enter (&files_emblem_renderer_type_id__once)) {
		GType files_emblem_renderer_type_id;
		files_emblem_renderer_type_id = files_emblem_renderer_get_type_once ();
		g_once_init_leave (&files_emblem_renderer_type_id__once, files_emblem_renderer_type_id);
	}
	return files_emblem_renderer_type_id__once;
}

static void
_vala_files_emblem_renderer_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	FilesEmblemRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_EMBLEM_RENDERER, FilesEmblemRenderer);
	switch (property_id) {
		case FILES_EMBLEM_RENDERER_FILE_PROPERTY:
		g_value_set_object (value, files_emblem_renderer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_emblem_renderer_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	FilesEmblemRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_EMBLEM_RENDERER, FilesEmblemRenderer);
	switch (property_id) {
		case FILES_EMBLEM_RENDERER_FILE_PROPERTY:
		files_emblem_renderer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

