/* TrashMonitor.c generated by valac 0.56.18, the Vala compiler
 * generated from TrashMonitor.vala, do not modify */

/* Copyright (c) 2018 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_TRASH_MONITOR_0_PROPERTY,
	FILES_TRASH_MONITOR_IS_EMPTY_PROPERTY,
	FILES_TRASH_MONITOR_NUM_PROPERTIES
};
static GParamSpec* files_trash_monitor_properties[FILES_TRASH_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesTrashMonitorUpdateInfoData FilesTrashMonitorUpdateInfoData;

struct _FilesTrashMonitorPrivate {
	gboolean _is_empty;
	GIcon* icon;
	GFileMonitor* file_monitor;
	GFile* trash_file;
};

struct _FilesTrashMonitorUpdateInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesTrashMonitor* self;
	gchar* attribs;
	gchar* _tmp0_;
	GFileInfo* info;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	GIcon* new_icon;
	GObject* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GIcon* _tmp6_;
	GIcon* _tmp7_;
	guint32 toplevel_trash_count;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

static gint FilesTrashMonitor_private_offset;
static gpointer files_trash_monitor_parent_class = NULL;
static FilesTrashMonitor* files_trash_monitor_marlin_trash_monitor;
static FilesTrashMonitor* files_trash_monitor_marlin_trash_monitor = NULL;

static void files_trash_monitor_update_info_data_free (gpointer _data);
static void files_trash_monitor_update_info (FilesTrashMonitor* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void files_trash_monitor_update_info_finish (FilesTrashMonitor* self,
                                             GAsyncResult* _res_);
static gboolean files_trash_monitor_update_info_co (FilesTrashMonitorUpdateInfoData* _data_);
static void files_trash_monitor_update_info_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void files_trash_monitor_set_is_empty (FilesTrashMonitor* self,
                                       gboolean value);
static GObject * files_trash_monitor_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _files_trash_monitor____lambda59_ (FilesTrashMonitor* self,
                                        GFile* file,
                                        GFile* other_file,
                                        GFileMonitorEvent event_type);
static void __files_trash_monitor____lambda59__g_file_monitor_changed (GFileMonitor* _sender,
                                                                GFile* file,
                                                                GFile* other_file,
                                                                GFileMonitorEvent event_type,
                                                                gpointer self);
static void _files_trash_monitor___lambda60_ (FilesTrashMonitor* self);
static void __files_trash_monitor___lambda60__gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self);
static void files_trash_monitor_finalize (GObject * obj);
static GType files_trash_monitor_get_type_once (void);
static void _vala_files_trash_monitor_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_files_trash_monitor_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
files_trash_monitor_get_instance_private (FilesTrashMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, FilesTrashMonitor_private_offset);
}

FilesTrashMonitor*
files_trash_monitor_get_default (void)
{
	FilesTrashMonitor* _tmp0_;
	FilesTrashMonitor* _tmp2_;
	FilesTrashMonitor* result;
	_tmp0_ = files_trash_monitor_marlin_trash_monitor;
	if (_tmp0_ == NULL) {
		FilesTrashMonitor* _tmp1_;
		_tmp1_ = files_trash_monitor_new ();
		_g_object_unref0 (files_trash_monitor_marlin_trash_monitor);
		files_trash_monitor_marlin_trash_monitor = _tmp1_;
	}
	_tmp2_ = files_trash_monitor_marlin_trash_monitor;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GIcon*
files_trash_monitor_get_icon (FilesTrashMonitor* self)
{
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
files_trash_monitor_update_info_data_free (gpointer _data)
{
	FilesTrashMonitorUpdateInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesTrashMonitorUpdateInfoData, _data_);
}

static void
files_trash_monitor_update_info (FilesTrashMonitor* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	FilesTrashMonitorUpdateInfoData* _data_;
	FilesTrashMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesTrashMonitorUpdateInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_trash_monitor_update_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	files_trash_monitor_update_info_co (_data_);
}

static void
files_trash_monitor_update_info_finish (FilesTrashMonitor* self,
                                        GAsyncResult* _res_)
{
	FilesTrashMonitorUpdateInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_trash_monitor_update_info_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	FilesTrashMonitorUpdateInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_trash_monitor_update_info_co (_data_);
}

static gboolean
files_trash_monitor_update_info_co (FilesTrashMonitorUpdateInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT);
		_data_->attribs = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->self->priv->trash_file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp1_, _data_->attribs, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, files_trash_monitor_update_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_query_info_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->attribs);
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = g_file_info_get_attribute_object (_data_->info, G_FILE_ATTRIBUTE_STANDARD_ICON);
		_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, g_icon_get_type ()) ? ((GIcon*) _data_->_tmp3_) : NULL);
		_data_->new_icon = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->new_icon;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->new_icon;
			_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
			_g_object_unref0 (_data_->self->priv->icon);
			_data_->self->priv->icon = _data_->_tmp7_;
		}
		_data_->toplevel_trash_count = g_file_info_get_attribute_uint32 (_data_->info, G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT);
		files_trash_monitor_set_is_empty (_data_->self, _data_->toplevel_trash_count == ((guint32) 0));
		_g_object_unref0 (_data_->new_icon);
		_g_object_unref0 (_data_->info);
		_g_free0 (_data_->attribs);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_critical ("TrashMonitor.vala:69: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

FilesTrashMonitor*
files_trash_monitor_construct (GType object_type)
{
	FilesTrashMonitor * self = NULL;
	self = (FilesTrashMonitor*) g_object_new (object_type, NULL);
	return self;
}

FilesTrashMonitor*
files_trash_monitor_new (void)
{
	return files_trash_monitor_construct (FILES_TYPE_TRASH_MONITOR);
}

gboolean
files_trash_monitor_get_is_empty (FilesTrashMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_empty;
	return result;
}

static void
files_trash_monitor_set_is_empty (FilesTrashMonitor* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_trash_monitor_get_is_empty (self);
	if (old_value != value) {
		self->priv->_is_empty = value;
		g_object_notify_by_pspec ((GObject *) self, files_trash_monitor_properties[FILES_TRASH_MONITOR_IS_EMPTY_PROPERTY]);
	}
}

static void
_files_trash_monitor____lambda59_ (FilesTrashMonitor* self,
                                   GFile* file,
                                   GFile* other_file,
                                   GFileMonitorEvent event_type)
{
	g_return_if_fail (file != NULL);
	files_trash_monitor_update_info (self, NULL, NULL);
}

static void
__files_trash_monitor____lambda59__g_file_monitor_changed (GFileMonitor* _sender,
                                                           GFile* file,
                                                           GFile* other_file,
                                                           GFileMonitorEvent event_type,
                                                           gpointer self)
{
	_files_trash_monitor____lambda59_ ((FilesTrashMonitor*) self, file, other_file, event_type);
}

static void
_files_trash_monitor___lambda60_ (FilesTrashMonitor* self)
{
	g_object_notify ((GObject*) self, "is-empty");
}

static void
__files_trash_monitor___lambda60__gasync_ready_callback (GObject* source_object,
                                                         GAsyncResult* res,
                                                         gpointer self)
{
	_files_trash_monitor___lambda60_ ((FilesTrashMonitor*) self);
	g_object_unref (self);
}

static GObject *
files_trash_monitor_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesTrashMonitor * self;
	GThemedIcon* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (files_trash_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_TRASH_MONITOR, FilesTrashMonitor);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("user-trash");
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = (GIcon*) _tmp0_;
	_tmp1_ = g_file_new_for_uri (FILES_TRASH_MONITOR_URI);
	_g_object_unref0 (self->priv->trash_file);
	self->priv->trash_file = _tmp1_;
	{
		GFileMonitor* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GFileMonitor* _tmp6_;
		_tmp3_ = self->priv->trash_file;
		_tmp4_ = g_file_monitor (_tmp3_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->file_monitor);
		self->priv->file_monitor = _tmp5_;
		_tmp6_ = self->priv->file_monitor;
		g_signal_connect_object (_tmp6_, "changed", (GCallback) __files_trash_monitor____lambda59__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("TrashMonitor.vala:45: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	files_trash_monitor_update_info (self, __files_trash_monitor___lambda60__gasync_ready_callback, g_object_ref (self));
	return obj;
}

static void
files_trash_monitor_class_init (FilesTrashMonitorClass * klass,
                                gpointer klass_data)
{
	files_trash_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesTrashMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_trash_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_trash_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_trash_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_trash_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_TRASH_MONITOR_IS_EMPTY_PROPERTY, files_trash_monitor_properties[FILES_TRASH_MONITOR_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
files_trash_monitor_instance_init (FilesTrashMonitor * self,
                                   gpointer klass)
{
	self->priv = files_trash_monitor_get_instance_private (self);
	self->priv->_is_empty = TRUE;
}

static void
files_trash_monitor_finalize (GObject * obj)
{
	FilesTrashMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_TRASH_MONITOR, FilesTrashMonitor);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->file_monitor);
	_g_object_unref0 (self->priv->trash_file);
	G_OBJECT_CLASS (files_trash_monitor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_trash_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesTrashMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_trash_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesTrashMonitor), 0, (GInstanceInitFunc) files_trash_monitor_instance_init, NULL };
	GType files_trash_monitor_type_id;
	files_trash_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesTrashMonitor", &g_define_type_info, 0);
	FilesTrashMonitor_private_offset = g_type_add_instance_private (files_trash_monitor_type_id, sizeof (FilesTrashMonitorPrivate));
	return files_trash_monitor_type_id;
}

GType
files_trash_monitor_get_type (void)
{
	static volatile gsize files_trash_monitor_type_id__once = 0;
	if (g_once_init_enter (&files_trash_monitor_type_id__once)) {
		GType files_trash_monitor_type_id;
		files_trash_monitor_type_id = files_trash_monitor_get_type_once ();
		g_once_init_leave (&files_trash_monitor_type_id__once, files_trash_monitor_type_id);
	}
	return files_trash_monitor_type_id__once;
}

static void
_vala_files_trash_monitor_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FilesTrashMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_TRASH_MONITOR, FilesTrashMonitor);
	switch (property_id) {
		case FILES_TRASH_MONITOR_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, files_trash_monitor_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_trash_monitor_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FilesTrashMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_TRASH_MONITOR, FilesTrashMonitor);
	switch (property_id) {
		case FILES_TRASH_MONITOR_IS_EMPTY_PROPERTY:
		files_trash_monitor_set_is_empty (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

