/* DeleteJob.c generated by valac 0.56.18, the Vala compiler
 * generated from DeleteJob.vala, do not modify */

/* Copyright 2022 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer marlin_file_operations_delete_job_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static const gchar* marlin_file_operations_delete_job_real_get_scan_primary (FilesFileOperationsCommonJob* base);
static void marlin_file_operations_delete_job_real_report_count_progress (FilesFileOperationsCommonJob* base,
                                                                   SourceInfo* source_info);
static void marlin_file_operations_delete_job_finalize (FilesFileOperationsCommonJob * obj);
static GType marlin_file_operations_delete_job_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

gboolean
marlin_file_operations_delete_job_can_delete_without_confirm (GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	if (g_file_has_uri_scheme (file, "burn")) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_file_has_uri_scheme (file, "x-nautilus-desktop");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_file_has_uri_scheme (file, "trash");
	}
	result = _tmp0_;
	return result;
}

FilesFileOperationsDeleteJob*
marlin_file_operations_delete_job_construct (GType object_type,
                                             GtkWindow* parent_window,
                                             GList* files,
                                             gboolean try_trash)
{
	FilesFileOperationsDeleteJob* self = NULL;
	GList* _tmp0_;
	self = (FilesFileOperationsDeleteJob*) marlin_file_operations_common_job_construct (object_type, parent_window);
	_tmp0_ = g_list_copy_deep (files, (GCopyFunc) g_object_ref, NULL);
	(self->files == NULL) ? NULL : (self->files = (_g_list_free__g_object_unref0_ (self->files), NULL));
	self->files = _tmp0_;
	self->try_trash = try_trash;
	self->user_cancel = FALSE;
	return self;
}

FilesFileOperationsDeleteJob*
marlin_file_operations_delete_job_new (GtkWindow* parent_window,
                                       GList* files,
                                       gboolean try_trash)
{
	return marlin_file_operations_delete_job_construct (MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB, parent_window, files, try_trash);
}

static const gchar*
marlin_file_operations_delete_job_real_get_scan_primary (FilesFileOperationsCommonJob* base)
{
	FilesFileOperationsDeleteJob * self;
	const gchar* result;
	self = (FilesFileOperationsDeleteJob*) base;
	result = _ ("Error while deleting.");
	return result;
}

gboolean
marlin_file_operations_delete_job_confirm_delete_from_trash (FilesFileOperationsDeleteJob* self,
                                                             GList* to_delete_files)
{
	gchar* prompt = NULL;
	guint file_count = 0U;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	file_count = g_list_length (to_delete_files);
	if (file_count == ((guint) 1)) {
		gchar* basename = NULL;
		gconstpointer _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = to_delete_files->data;
		_tmp1_ = files_file_utils_custom_basename_from_file ((GFile*) _tmp0_);
		basename = _tmp1_;
		_tmp2_ = basename;
		_tmp3_ = g_strdup_printf (_ ("Are you sure you want to permanently delete \"%s\" from the trash?"), _tmp2_);
		_g_free0 (prompt);
		prompt = _tmp3_;
		_g_free0 (basename);
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf (ngettext ("Are you sure you want to permanently delete the %'d selected item from" \
" the trash?", "Are you sure you want to permanently delete the %'d selected items fro" \
"m the trash?", (gulong) file_count), file_count);
		_g_free0 (prompt);
		prompt = _tmp4_;
	}
	_tmp5_ = prompt;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_strdup (_ ("If you delete an item, it will be permanently lost."));
	result = marlin_file_operations_common_job_run_warning ((FilesFileOperationsCommonJob*) self, _tmp6_, _tmp7_, NULL, FALSE, CANCEL, DELETE, NULL) == 1;
	_g_free0 (prompt);
	return result;
}

gboolean
marlin_file_operations_delete_job_confirm_delete_directly (FilesFileOperationsDeleteJob* self,
                                                           GList* to_delete_files)
{
	gchar* prompt = NULL;
	guint file_count = 0U;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	file_count = g_list_length (to_delete_files);
	if (file_count == ((guint) 1)) {
		gchar* basename = NULL;
		gconstpointer _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = to_delete_files->data;
		_tmp1_ = files_file_utils_custom_basename_from_file ((GFile*) _tmp0_);
		basename = _tmp1_;
		_tmp2_ = basename;
		_tmp3_ = g_strdup_printf (_ ("Permanently delete “%s”?"), _tmp2_);
		_g_free0 (prompt);
		prompt = _tmp3_;
		_g_free0 (basename);
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf (ngettext ("Are you sure you want to permanently delete the %'d selected item?", "Are you sure you want to permanently delete the %'d selected items?", (gulong) file_count), file_count);
		_g_free0 (prompt);
		prompt = _tmp4_;
	}
	_tmp5_ = prompt;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_strdup (_ ("Deleted items are not sent to Trash and are not recoverable."));
	result = marlin_file_operations_common_job_run_warning ((FilesFileOperationsCommonJob*) self, _tmp6_, _tmp7_, NULL, FALSE, CANCEL, DELETE, NULL) == 1;
	_g_free0 (prompt);
	return result;
}

void
marlin_file_operations_delete_job_report_delete_progress (FilesFileOperationsDeleteJob* self,
                                                          SourceInfo* source_info,
                                                          TransferInfo* transfer_info)
{
	gint64 now = 0LL;
	gboolean _tmp0_ = FALSE;
	gint files_left = 0;
	gchar* files_left_s = NULL;
	gchar* _tmp1_;
	PFProgressInfo* _tmp2_;
	gchar* _tmp3_;
	gdouble elapsed = 0.0;
	GTimer* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_info != NULL);
	g_return_if_fail (transfer_info != NULL);
	now = g_get_monotonic_time () * 1000;
	if (transfer_info->last_report_time != ((guint64) 0)) {
		_tmp0_ = llabs (((gint64) transfer_info->last_report_time) - now) < ((gint64) (100 * MARLIN_FILE_OPERATIONS_COMMON_JOB_NSEC_PER_MSEC));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	transfer_info->last_report_time = (guint64) now;
	files_left = source_info->num_files - transfer_info->num_files;
	if (files_left < 0) {
		files_left = 1;
	}
	_tmp1_ = g_strdup_printf (ngettext ("%'d file left to delete", "%'d files left to delete", (gulong) files_left), files_left);
	files_left_s = _tmp1_;
	_tmp2_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp3_ = g_strdup (_ ("Deleting files"));
	pf_progress_info_take_status (_tmp2_, _tmp3_);
	_tmp4_ = ((FilesFileOperationsCommonJob*) self)->time;
	elapsed = g_timer_elapsed (_tmp4_, NULL);
	if (elapsed < ((gdouble) MARLIN_FILE_OPERATIONS_COMMON_JOB_SECONDS_NEEDED_FOR_RELIABLE_TRANSFER_RATE)) {
		PFProgressInfo* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = ((FilesFileOperationsCommonJob*) self)->progress;
		_tmp6_ = files_left_s;
		files_left_s = NULL;
		pf_progress_info_take_details (_tmp5_, _tmp6_);
	} else {
		gdouble transfer_rate = 0.0;
		gint remaining_time = 0;
		gint formated_time_unit = 0;
		gchar* formated_time = NULL;
		gint _tmp7_ = 0;
		gchar* _tmp8_;
		gchar* time_left_s = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* details = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		PFProgressInfo* _tmp14_;
		gchar* _tmp15_;
		transfer_rate = transfer_info->num_files / elapsed;
		remaining_time = (gint) floor (files_left / transfer_rate);
		_tmp8_ = files_file_utils_format_time (remaining_time, &_tmp7_);
		formated_time_unit = _tmp7_;
		formated_time = _tmp8_;
		_tmp9_ = formated_time;
		_tmp10_ = g_strdup_printf (ngettext ("%s left", "%s left", (gulong) formated_time_unit), _tmp9_);
		time_left_s = _tmp10_;
		_tmp11_ = files_left_s;
		_tmp12_ = time_left_s;
		_tmp13_ = g_strconcat (_tmp11_, "\xE2\x80\x94", _tmp12_, NULL);
		details = _tmp13_;
		_tmp14_ = ((FilesFileOperationsCommonJob*) self)->progress;
		_tmp15_ = details;
		details = NULL;
		pf_progress_info_take_details (_tmp14_, _tmp15_);
		_g_free0 (details);
		_g_free0 (time_left_s);
		_g_free0 (formated_time);
	}
	if (source_info->num_files != 0) {
		PFProgressInfo* _tmp16_;
		_tmp16_ = ((FilesFileOperationsCommonJob*) self)->progress;
		pf_progress_info_update_progress (_tmp16_, (gdouble) transfer_info->num_files, (gdouble) source_info->num_files);
	}
	_g_free0 (files_left_s);
}

static void
marlin_file_operations_delete_job_real_report_count_progress (FilesFileOperationsCommonJob* base,
                                                              SourceInfo* source_info)
{
	FilesFileOperationsDeleteJob * self;
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PFProgressInfo* _tmp4_;
	gchar* _tmp5_;
	PFProgressInfo* _tmp6_;
	self = (FilesFileOperationsDeleteJob*) base;
	g_return_if_fail (source_info != NULL);
	_tmp0_ = g_format_size_full ((guint64) source_info->num_bytes, G_FORMAT_SIZE_DEFAULT);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (ngettext ("Preparing to delete %'d file (%s)", "Preparing to delete %'d files (%s)", (gulong) source_info->num_files), source_info->num_files, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	s = _tmp3_;
	_tmp4_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp5_ = g_strdup (s);
	pf_progress_info_take_details (_tmp4_, _tmp5_);
	_tmp6_ = ((FilesFileOperationsCommonJob*) self)->progress;
	pf_progress_info_pulse_progress (_tmp6_);
	_g_free0 (s);
}

void
marlin_file_operations_delete_job_report_trash_progress (FilesFileOperationsDeleteJob* self,
                                                         gint files_trashed,
                                                         gint total_files)
{
	gint files_left = 0;
	PFProgressInfo* _tmp0_;
	gchar* _tmp1_;
	gchar* s = NULL;
	gchar* _tmp2_;
	PFProgressInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	files_left = total_files - files_trashed;
	_tmp0_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp1_ = g_strdup (_ ("Moving files to trash"));
	pf_progress_info_take_status (_tmp0_, _tmp1_);
	_tmp2_ = g_strdup_printf (ngettext ("%'d file left to trash", "%'d files left to trash", (gulong) files_left), files_left);
	s = _tmp2_;
	_tmp3_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp4_ = s;
	_tmp5_ = g_strdup (_tmp4_);
	pf_progress_info_take_details (_tmp3_, _tmp5_);
	if (total_files != 0) {
		PFProgressInfo* _tmp6_;
		_tmp6_ = ((FilesFileOperationsCommonJob*) self)->progress;
		pf_progress_info_update_progress (_tmp6_, (gdouble) files_trashed, (gdouble) total_files);
	}
	_g_free0 (s);
}

static void
marlin_file_operations_delete_job_class_init (FilesFileOperationsDeleteJobClass * klass,
                                              gpointer klass_data)
{
	marlin_file_operations_delete_job_parent_class = g_type_class_peek_parent (klass);
	((FilesFileOperationsCommonJobClass *) klass)->finalize = marlin_file_operations_delete_job_finalize;
	((FilesFileOperationsCommonJobClass *) klass)->get_scan_primary = (const gchar* (*) (FilesFileOperationsCommonJob*)) marlin_file_operations_delete_job_real_get_scan_primary;
	((FilesFileOperationsCommonJobClass *) klass)->report_count_progress = (void (*) (FilesFileOperationsCommonJob*, SourceInfo*)) marlin_file_operations_delete_job_real_report_count_progress;
}

static void
marlin_file_operations_delete_job_instance_init (FilesFileOperationsDeleteJob * self,
                                                 gpointer klass)
{
}

static void
marlin_file_operations_delete_job_finalize (FilesFileOperationsCommonJob * obj)
{
	FilesFileOperationsDeleteJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MARLIN_FILE_OPERATIONS_TYPE_DELETE_JOB, FilesFileOperationsDeleteJob);
	files_file_changes_consume_changes (TRUE);
	(self->files == NULL) ? NULL : (self->files = (_g_list_free__g_object_unref0_ (self->files), NULL));
	MARLIN_FILE_OPERATIONS_COMMON_JOB_CLASS (marlin_file_operations_delete_job_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
marlin_file_operations_delete_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileOperationsDeleteJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) marlin_file_operations_delete_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFileOperationsDeleteJob), 0, (GInstanceInitFunc) marlin_file_operations_delete_job_instance_init, NULL };
	GType marlin_file_operations_delete_job_type_id;
	marlin_file_operations_delete_job_type_id = g_type_register_static (MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, "FilesFileOperationsDeleteJob", &g_define_type_info, 0);
	return marlin_file_operations_delete_job_type_id;
}

GType
marlin_file_operations_delete_job_get_type (void)
{
	static volatile gsize marlin_file_operations_delete_job_type_id__once = 0;
	if (g_once_init_enter (&marlin_file_operations_delete_job_type_id__once)) {
		GType marlin_file_operations_delete_job_type_id;
		marlin_file_operations_delete_job_type_id = marlin_file_operations_delete_job_get_type_once ();
		g_once_init_leave (&marlin_file_operations_delete_job_type_id__once, marlin_file_operations_delete_job_type_id);
	}
	return marlin_file_operations_delete_job_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

