/* FileChooserDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from FileChooserDialog.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <handy.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define XDP_TYPE_REQUEST (xdp_request_get_type ())
#define XDP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XDP_TYPE_REQUEST, XdpRequest))
#define XDP_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XDP_TYPE_REQUEST))
#define XDP_REQUEST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), XDP_TYPE_REQUEST, XdpRequestIface))

typedef struct _XdpRequest XdpRequest;
typedef struct _XdpRequestIface XdpRequestIface;

#define XDP_TYPE_REQUEST_PROXY (xdp_request_proxy_get_type ())
typedef GDBusProxy XdpRequestProxy;
typedef GDBusProxyClass XdpRequestProxyClass;

#define FILES_TYPE_FILE_CHOOSER_DIALOG (files_file_chooser_dialog_get_type ())
#define FILES_FILE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialog))
#define FILES_FILE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialogClass))
#define FILES_IS_FILE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CHOOSER_DIALOG))
#define FILES_IS_FILE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CHOOSER_DIALOG))
#define FILES_FILE_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialogClass))

typedef struct _FilesFileChooserDialog FilesFileChooserDialog;
typedef struct _FilesFileChooserDialogClass FilesFileChooserDialogClass;
typedef struct _FilesFileChooserDialogPrivate FilesFileChooserDialogPrivate;
enum  {
	FILES_FILE_CHOOSER_DIALOG_0_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_PARENT_WINDOW_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_ACTION_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_READ_ONLY_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_ACCEPT_LABEL_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_SELECT_MULTIPLE_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_FILTER_PROPERTY,
	FILES_FILE_CHOOSER_DIALOG_NUM_PROPERTIES
};
static GParamSpec* files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define FILES_TYPE_FILE_CHOOSER_CHOICE (files_file_chooser_choice_get_type ())
#define FILES_FILE_CHOOSER_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoice))
#define FILES_FILE_CHOOSER_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoiceClass))
#define FILES_IS_FILE_CHOOSER_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CHOOSER_CHOICE))
#define FILES_IS_FILE_CHOOSER_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CHOOSER_CHOICE))
#define FILES_FILE_CHOOSER_CHOICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoiceClass))

typedef struct _FilesFileChooserChoice FilesFileChooserChoice;
typedef struct _FilesFileChooserChoiceClass FilesFileChooserChoiceClass;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define TYPE_EXTERNAL_WINDOW (external_window_get_type ())
#define EXTERNAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL_WINDOW, ExternalWindow))
#define IS_EXTERNAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL_WINDOW))
#define EXTERNAL_WINDOW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_EXTERNAL_WINDOW, ExternalWindowIface))

typedef struct _ExternalWindow ExternalWindow;
typedef struct _ExternalWindowIface ExternalWindowIface;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
enum  {
	FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL,
	FILES_FILE_CHOOSER_DIALOG_NUM_SIGNALS
};
static guint files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _XdpRequestIface {
	GTypeInterface parent_iface;
	void (*close) (XdpRequest* self, GError** error);
};

struct _FilesFileChooserDialog {
	HdyWindow parent_instance;
	FilesFileChooserDialogPrivate * priv;
};

struct _FilesFileChooserDialogClass {
	HdyWindowClass parent_class;
};

struct _FilesFileChooserDialogPrivate {
	gchar* _parent_window;
	GtkFileChooserAction _action;
	gboolean _read_only;
	HdyHeaderBar* header;
	FilesViewChromeBasicLocationBar* location_bar;
	GtkFileChooserWidget* chooser;
	GtkTreeView* tree_view;
	GtkButton* accept_button;
	GtkComboBoxText* filter_box;
	GtkEntry* entry;
	GtkBox* choices_box;
	GtkBox* extra_box;
	GQueue* previous_paths;
	GQueue* next_paths;
	gchar* current_path;
	gboolean previous_button_clicked;
	gboolean next_button_clicked;
	guint register_id;
	GDBusConnection* dbus_connection;
	GSettings* settings;
};

struct _Block1Data {
	int _ref_count_;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GtkWidget* widget;
	gchar* name;
};

struct _Block2Data {
	int _ref_count_;
	FilesFileChooserDialog* self;
	GtkRevealer* revealer;
	GtkStack* stack;
};

struct _Block3Data {
	int _ref_count_;
	FilesFileChooserDialog* self;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
};

struct _Block4Data {
	int _ref_count_;
	FilesFileChooserDialog* self;
	GVariant** choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _Block5Data {
	int _ref_count_;
	FilesFileChooserDialog* self;
	GtkButton* previous_button;
	GtkButton* next_button;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkCheckButton* read_only_check;
};

struct _ExternalWindowIface {
	GTypeInterface parent_iface;
	void (*set_parent_of) (ExternalWindow* self, GdkWindow* child_window);
};

static gint FilesFileChooserDialog_private_offset;
static gpointer files_file_chooser_dialog_parent_class = NULL;
static XdpRequestIface * files_file_chooser_dialog_xdp_request_parent_iface = NULL;

VALA_EXTERN GType xdp_request_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint xdp_request_register_object (void* object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error);
VALA_EXTERN GType xdp_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XdpRequest, g_object_unref)
VALA_EXTERN void xdp_request_close (XdpRequest* self,
                        GError** error);
static GType xdp_request_get_type_once (void);
static void xdp_request_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters);
static void xdp_request_proxy_close (XdpRequest* self,
                              GError** error);
static void xdp_request_proxy_xdp_request_interface_init (XdpRequestIface* iface);
static void _dbus_xdp_request_close (XdpRequest* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation);
static void xdp_request_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data);
static GVariant* xdp_request_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data);
static gboolean xdp_request_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data);
static void _xdp_request_unregister_object (gpointer user_data);
VALA_EXTERN GType files_file_chooser_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileChooserDialog, g_object_unref)
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
VALA_EXTERN FilesFileChooserDialog* files_file_chooser_dialog_new (GtkFileChooserAction action,
                                                       const gchar* parent_window,
                                                       const gchar* title);
VALA_EXTERN FilesFileChooserDialog* files_file_chooser_dialog_construct (GType object_type,
                                                             GtkFileChooserAction action,
                                                             const gchar* parent_window,
                                                             const gchar* title);
static gpointer files_file_chooser_dialog_find_child_by_name (GType t_type,
                                                       GBoxedCopyFunc t_dup_func,
                                                       GDestroyNotify t_destroy_func,
                                                       GtkWidget* root,
                                                       const gchar* path);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void __lambda6_ (Block1Data* _data1_,
                 GtkWidget* w);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static void files_file_chooser_dialog_setup_chooser (FilesFileChooserDialog* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_);
static void __lambda8_ (Block2Data* _data2_);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void ___lambda7__gtk_widget_realize (GtkWidget* _sender,
                                     gpointer self);
VALA_EXTERN GtkFileChooserAction files_file_chooser_dialog_get_action (FilesFileChooserDialog* self);
static void ___lambda10_ (FilesFileChooserDialog* self);
static void ____lambda10__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static gboolean files_file_chooser_dialog_real_key_press_event (GtkWidget* base,
                                                         GdkEventKey* event);
static void files_file_chooser_dialog_real_show (GtkWidget* base);
VALA_EXTERN void files_file_chooser_dialog_set_current_folder (FilesFileChooserDialog* self,
                                                   const gchar* uri);
VALA_EXTERN void files_file_chooser_dialog_set_current_name (FilesFileChooserDialog* self,
                                                 const gchar* text);
VALA_EXTERN gchar* files_file_chooser_dialog_get_uri (FilesFileChooserDialog* self);
VALA_EXTERN void files_file_chooser_dialog_set_uri (FilesFileChooserDialog* self,
                                        const gchar* uri);
VALA_EXTERN gchar** files_file_chooser_dialog_get_uris (FilesFileChooserDialog* self,
                                            gint* result_length1);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda11_ (Block3Data* _data3_,
                  const gchar* uri);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda11__gfunc (gconstpointer data,
                         gpointer self);
static inline void _g_slist_free__g_free0_ (GSList* self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN GFile* files_file_chooser_dialog_get_file (FilesFileChooserDialog* self);
VALA_EXTERN GType files_file_chooser_choice_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileChooserChoice, g_object_unref)
VALA_EXTERN void files_file_chooser_dialog_add_choice (FilesFileChooserDialog* self,
                                           FilesFileChooserChoice* choice);
VALA_EXTERN GVariant** files_file_chooser_dialog_get_choices (FilesFileChooserDialog* self,
                                                  gint* result_length1);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda12_ (Block4Data* _data4_,
                  GtkWidget* w);
VALA_EXTERN const gchar* files_file_chooser_choice_get_selected (FilesFileChooserChoice* self);
static void _vala_array_add2 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
static void ___lambda12__gfunc (gconstpointer data,
                         gpointer self);
static GVariant** _vala_array_dup3 (GVariant** self,
                             gssize length);
VALA_EXTERN void files_file_chooser_dialog_add_filter (FilesFileChooserDialog* self,
                                           GtkFileFilter* filter);
static gint __lambda13_ (GtkFileFilter* a,
                  const gchar* b);
static gint ___lambda13__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void files_file_chooser_dialog_real_close (XdpRequest* base,
                                           GError** error);
VALA_EXTERN gboolean files_file_chooser_dialog_register_object (FilesFileChooserDialog* self,
                                                    GDBusConnection* connection,
                                                    const char* handle);
static void files_file_chooser_dialog_real_dispose (GObject* base);
VALA_EXTERN const gchar* files_file_chooser_dialog_get_parent_window (FilesFileChooserDialog* self);
static void files_file_chooser_dialog_set_parent_window (FilesFileChooserDialog* self,
                                                  const gchar* value);
static void files_file_chooser_dialog_set_action (FilesFileChooserDialog* self,
                                           GtkFileChooserAction value);
VALA_EXTERN gboolean files_file_chooser_dialog_get_read_only (FilesFileChooserDialog* self);
VALA_EXTERN void files_file_chooser_dialog_set_read_only (FilesFileChooserDialog* self,
                                              gboolean value);
VALA_EXTERN const gchar* files_file_chooser_dialog_get_accept_label (FilesFileChooserDialog* self);
VALA_EXTERN void files_file_chooser_dialog_set_accept_label (FilesFileChooserDialog* self,
                                                 const gchar* value);
VALA_EXTERN gboolean files_file_chooser_dialog_get_select_multiple (FilesFileChooserDialog* self);
VALA_EXTERN void files_file_chooser_dialog_set_select_multiple (FilesFileChooserDialog* self,
                                                    gboolean value);
VALA_EXTERN GtkFileFilter* files_file_chooser_dialog_get_filter (FilesFileChooserDialog* self);
VALA_EXTERN void files_file_chooser_dialog_set_filter (FilesFileChooserDialog* self,
                                           GtkFileFilter* value);
static GObject * files_file_chooser_dialog_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _files_file_chooser_dialog____lambda14_ (Block6Data* _data6_);
static void __files_file_chooser_dialog____lambda14__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void _files_file_chooser_dialog___lambda15_ (FilesFileChooserDialog* self);
VALA_EXTERN GType external_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExternalWindow, g_object_unref)
VALA_EXTERN ExternalWindow* external_window_from_handle (const gchar* handle);
VALA_EXTERN void external_window_set_parent_of (ExternalWindow* self,
                                    GdkWindow* child_window);
static void __files_file_chooser_dialog___lambda15__gtk_widget_realize (GtkWidget* _sender,
                                                                 gpointer self);
static void _files_file_chooser_dialog___lambda16_ (FilesFileChooserDialog* self);
static void __files_file_chooser_dialog___lambda16__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _files_file_chooser_dialog___lambda17_ (FilesFileChooserDialog* self);
static void __files_file_chooser_dialog___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _files_file_chooser_dialog___lambda18_ (FilesFileChooserDialog* self,
                                             const gchar* path);
static void __files_file_chooser_dialog___lambda18__files_view_chrome_locatable_path_change_request (FilesViewChromeLocatable* _sender,
                                                                                              const gchar* path,
                                                                                              FilesOpenFlag flag,
                                                                                              gpointer self);
static void _files_file_chooser_dialog___lambda19_ (FilesFileChooserDialog* self);
static gint __lambda20_ (GtkFileFilter* a,
                  const gchar* b);
static gint ___lambda20__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void __files_file_chooser_dialog___lambda19__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                    gpointer self);
static gboolean _files_file_chooser_dialog___lambda21_ (FilesFileChooserDialog* self,
                                                 GtkWidget* w,
                                                 GdkEventButton* e);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static gboolean __files_file_chooser_dialog___lambda21__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                  GdkEventButton* event,
                                                                                  gpointer self);
static void _files_file_chooser_dialog___lambda22_ (Block5Data* _data5_);
static void __files_file_chooser_dialog___lambda22__gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender,
                                                                                      gpointer self);
static void _files_file_chooser_dialog___lambda23_ (FilesFileChooserDialog* self);
static void __files_file_chooser_dialog___lambda23__gtk_file_chooser_file_activated (GtkFileChooser* _sender,
                                                                              gpointer self);
static void _files_file_chooser_dialog___lambda24_ (FilesFileChooserDialog* self);
static void __files_file_chooser_dialog___lambda24__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _files_file_chooser_dialog___lambda25_ (FilesFileChooserDialog* self);
static void __files_file_chooser_dialog___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _files_file_chooser_dialog___lambda26_ (Block5Data* _data5_);
static void __files_file_chooser_dialog___lambda26__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void files_file_chooser_dialog_finalize (GObject * obj);
static GType files_file_chooser_dialog_get_type_once (void);
static void _vala_files_file_chooser_dialog_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_files_file_chooser_dialog_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo * const _xdp_request_dbus_arg_info_close_in[] = {NULL};
static const GDBusArgInfo * const _xdp_request_dbus_arg_info_close_out[] = {NULL};
static const GDBusMethodInfo _xdp_request_dbus_method_info_close = {-1, "Close", (GDBusArgInfo **) (&_xdp_request_dbus_arg_info_close_in), (GDBusArgInfo **) (&_xdp_request_dbus_arg_info_close_out), NULL};
static const GDBusMethodInfo * const _xdp_request_dbus_method_info[] = {&_xdp_request_dbus_method_info_close, NULL};
static const GDBusSignalInfo * const _xdp_request_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _xdp_request_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _xdp_request_dbus_interface_info = {-1, "org.freedesktop.impl.portal.Request", (GDBusMethodInfo **) (&_xdp_request_dbus_method_info), (GDBusSignalInfo **) (&_xdp_request_dbus_signal_info), (GDBusPropertyInfo **) (&_xdp_request_dbus_property_info), NULL};
static const GDBusInterfaceVTable _xdp_request_dbus_interface_vtable = {xdp_request_dbus_interface_method_call, xdp_request_dbus_interface_get_property, xdp_request_dbus_interface_set_property};

void
xdp_request_close (XdpRequest* self,
                   GError** error)
{
	XdpRequestIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = XDP_REQUEST_GET_INTERFACE (self);
	if (_iface_->close) {
		_iface_->close (self, error);
	}
}

static void
xdp_request_default_init (XdpRequestIface * iface,
                          gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
xdp_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XdpRequestIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xdp_request_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType xdp_request_type_id;
	xdp_request_type_id = g_type_register_static (G_TYPE_INTERFACE, "XdpRequest", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (xdp_request_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (xdp_request_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) xdp_request_proxy_get_type);
	g_type_set_qdata (xdp_request_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.impl.portal.Request");
	g_type_set_qdata (xdp_request_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_xdp_request_dbus_interface_info));
	g_type_set_qdata (xdp_request_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) xdp_request_register_object);
	return xdp_request_type_id;
}

GType
xdp_request_get_type (void)
{
	static volatile gsize xdp_request_type_id__once = 0;
	if (g_once_init_enter (&xdp_request_type_id__once)) {
		GType xdp_request_type_id;
		xdp_request_type_id = xdp_request_get_type_once ();
		g_once_init_leave (&xdp_request_type_id__once, xdp_request_type_id);
	}
	return xdp_request_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (XdpRequestProxy, xdp_request_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (XDP_TYPE_REQUEST, xdp_request_proxy_xdp_request_interface_init) )
static void
xdp_request_proxy_class_init (XdpRequestProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = xdp_request_proxy_g_signal;
}

static void
xdp_request_proxy_g_signal (GDBusProxy* proxy,
                            const gchar* sender_name,
                            const gchar* signal_name,
                            GVariant* parameters)
{
}

static void
xdp_request_proxy_init (XdpRequestProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_xdp_request_dbus_interface_info));
}

static void
xdp_request_proxy_close (XdpRequest* self,
                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.impl.portal.Request", "Close");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
xdp_request_proxy_xdp_request_interface_init (XdpRequestIface* iface)
{
	iface->close = xdp_request_proxy_close;
}

static void
_dbus_xdp_request_close (XdpRequest* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	xdp_request_close (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
xdp_request_dbus_interface_method_call (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* method_name,
                                        GVariant* parameters,
                                        GDBusMethodInvocation* invocation,
                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Close") == 0) {
		_dbus_xdp_request_close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
xdp_request_dbus_interface_get_property (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* property_name,
                                         GError** error,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
xdp_request_dbus_interface_set_property (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* property_name,
                                         GVariant* value,
                                         GError** error,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
xdp_request_register_object (gpointer object,
                             GDBusConnection* connection,
                             const gchar* path,
                             GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_xdp_request_dbus_interface_info), &_xdp_request_dbus_interface_vtable, data, _xdp_request_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_xdp_request_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
files_file_chooser_dialog_get_instance_private (FilesFileChooserDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FilesFileChooserDialog_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

FilesFileChooserDialog*
files_file_chooser_dialog_construct (GType object_type,
                                     GtkFileChooserAction action,
                                     const gchar* parent_window,
                                     const gchar* title)
{
	FilesFileChooserDialog * self = NULL;
	g_return_val_if_fail (parent_window != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (FilesFileChooserDialog*) g_object_new (object_type, "parent-window", parent_window, "action", action, "title", title, NULL);
	return self;
}

FilesFileChooserDialog*
files_file_chooser_dialog_new (GtkFileChooserAction action,
                               const gchar* parent_window,
                               const gchar* title)
{
	return files_file_chooser_dialog_construct (FILES_TYPE_FILE_CHOOSER_DIALOG, action, parent_window, title);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GType t_type;
		GBoxedCopyFunc t_dup_func;
		GDestroyNotify t_destroy_func;
		t_type = _data1_->t_type;
		t_dup_func = _data1_->t_dup_func;
		t_destroy_func = _data1_->t_destroy_func;
		_g_free0 (_data1_->name);
		_g_object_unref0 (_data1_->widget);
		g_slice_free (Block1Data, _data1_);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (Block1Data* _data1_,
            GtkWidget* w)
{
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GtkWidget* _tmp0_;
	t_type = _data1_->t_type;
	t_dup_func = _data1_->t_dup_func;
	t_destroy_func = _data1_->t_destroy_func;
	g_return_if_fail (w != NULL);
	_tmp0_ = _data1_->widget;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = _data1_->name;
		if (g_str_has_prefix (_tmp1_, "<")) {
			GType c_type = 0UL;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GType _tmp8_;
			GType w_type = 0UL;
			GtkWidget* _tmp9_ = NULL;
			GtkWidget* _tmp10_;
			_tmp2_ = _data1_->name;
			_tmp3_ = _data1_->name;
			_tmp4_ = strlen (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_slice (_tmp2_, (glong) 1, (glong) (_tmp5_ - 1));
			_tmp7_ = _tmp6_;
			_tmp8_ = g_type_from_name (_tmp7_);
			_g_free0 (_tmp7_);
			c_type = _tmp8_;
			w_type = G_TYPE_FROM_INSTANCE ((GObject*) w);
			if (g_type_is_a (w_type, c_type)) {
				_tmp9_ = w;
			} else {
				_tmp9_ = NULL;
			}
			_tmp10_ = _g_object_ref0 (_tmp9_);
			_g_object_unref0 (_data1_->widget);
			_data1_->widget = _tmp10_;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (w, gtk_buildable_get_type ())) {
				GtkWidget* _tmp11_ = NULL;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GtkWidget* _tmp14_;
				_tmp12_ = gtk_buildable_get_name (G_TYPE_CHECK_INSTANCE_CAST (w, gtk_buildable_get_type (), GtkBuildable));
				_tmp13_ = _data1_->name;
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					_tmp11_ = w;
				} else {
					_tmp11_ = NULL;
				}
				_tmp14_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (_data1_->widget);
				_data1_->widget = _tmp14_;
			} else {
				GtkWidget* _tmp15_ = NULL;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				GtkWidget* _tmp19_;
				_tmp16_ = gtk_widget_get_name (w);
				_tmp17_ = _tmp16_;
				_tmp18_ = _data1_->name;
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
					_tmp15_ = w;
				} else {
					_tmp15_ = NULL;
				}
				_tmp19_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (_data1_->widget);
				_data1_->widget = _tmp19_;
			}
		}
	}
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (GtkWidget*) data);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gpointer
files_file_chooser_dialog_find_child_by_name (GType t_type,
                                              GBoxedCopyFunc t_dup_func,
                                              GDestroyNotify t_destroy_func,
                                              GtkWidget* root,
                                              const gchar* path)
{
	Block1Data* _data1_;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	gchar** paths = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint paths_length1;
	gint _paths_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GList* _tmp13_;
	GList* _tmp14_;
	GtkWidget* _tmp15_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gpointer result;
	g_return_val_if_fail (root != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, gtk_container_get_type ()), "root is Gtk.Container", NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->t_type = t_type;
	_data1_->t_dup_func = t_dup_func;
	_data1_->t_destroy_func = t_destroy_func;
	if (g_str_has_prefix (path, "/")) {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		_tmp1_ = strlen (path);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_slice (path, (glong) 1, (glong) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "/", 0);
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		_tmp0_ = _tmp6_;
		_tmp0__length1 = _vala_array_length (_tmp5_);
		__tmp0__size_ = _tmp0__length1;
		_g_free0 (_tmp4_);
	} else {
		gchar** _tmp7_;
		gchar** _tmp8_;
		_tmp8_ = _tmp7_ = g_strsplit (path, "/", 0);
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		_tmp0_ = _tmp8_;
		_tmp0__length1 = _vala_array_length (_tmp7_);
		__tmp0__size_ = _tmp0__length1;
	}
	_tmp9_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp9__length1 = _tmp0__length1;
	paths = _tmp9_;
	paths_length1 = _tmp9__length1;
	_paths_size_ = paths_length1;
	_data1_->widget = NULL;
	_tmp10_ = paths;
	_tmp10__length1 = paths_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_strdup (_tmp11_);
	_data1_->name = _tmp12_;
	_tmp13_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (root, gtk_container_get_type (), GtkContainer));
	_tmp14_ = _tmp13_;
	g_list_foreach (_tmp14_, ___lambda6__gfunc, _data1_);
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (g_list_free (_tmp14_), NULL));
	_tmp15_ = _data1_->widget;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = paths;
		_tmp16__length1 = paths_length1;
		if (_tmp16__length1 > 1) {
			GtkWidget* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gchar** _tmp19_;
			gint _tmp19__length1;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gpointer _tmp22_;
			gpointer _tmp23_;
			_tmp17_ = _data1_->widget;
			_tmp18_ = paths;
			_tmp18__length1 = paths_length1;
			_tmp19_ = paths;
			_tmp19__length1 = paths_length1;
			_tmp20_ = _vala_g_strjoinv ("/", _tmp18_ + 1, (gint) (_tmp19__length1 - 1));
			_tmp21_ = _tmp20_;
			_tmp22_ = files_file_chooser_dialog_find_child_by_name (t_type, (GBoxedCopyFunc) t_dup_func, (GDestroyNotify) t_destroy_func, _tmp17_, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			result = _tmp23_;
			paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
			_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		} else {
			GtkWidget* _tmp24_;
			gpointer _tmp25_;
			_tmp24_ = _data1_->widget;
			_tmp25_ = ((((gconstpointer) _tmp24_) != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) ((gconstpointer) _tmp24_)) : ((gpointer) ((gconstpointer) _tmp24_));
			result = _tmp25_;
			paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
			_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
	}
	_tmp26_ = _data1_->name;
	_tmp27_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) root));
	g_warning ("FileChooserDialog.vala:330: cannot find child with name \"%s\" in \"%s" \
"\"", _tmp26_, _tmp27_);
	result = NULL;
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FilesFileChooserDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->stack);
		_g_object_unref0 (_data2_->revealer);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda8_ (Block2Data* _data2_)
{
	FilesFileChooserDialog* self;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data2_->self;
	_tmp0_ = _data2_->revealer;
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkRevealer* _tmp3_;
		GtkStack* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = _data2_->revealer;
		_tmp4_ = _data2_->stack;
		_tmp5_ = gtk_stack_get_visible_child_name (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_revealer_set_reveal_child (_tmp3_, g_strcmp0 (_tmp6_, "search") == 0);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ (self);
}

static void
__lambda9_ (Block2Data* _data2_)
{
	FilesFileChooserDialog* self;
	GtkRevealer* _tmp0_;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data2_->self;
	_tmp0_ = _data2_->revealer;
	_tmp1_ = _data2_->stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, g_strcmp0 (_tmp3_, "search") == 0);
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ (self);
}

static void
__lambda7_ (Block2Data* _data2_)
{
	FilesFileChooserDialog* self;
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkStack* _tmp2_;
	self = _data2_->self;
	_tmp0_ = _data2_->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = _data2_->revealer;
	g_signal_connect_data ((GObject*) _tmp1_, "notify::reveal-child", (GCallback) ___lambda8__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp2_ = _data2_->stack;
	g_signal_connect_data ((GObject*) _tmp2_, "notify::visible-child", (GCallback) ___lambda9__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
}

static void
___lambda7__gtk_widget_realize (GtkWidget* _sender,
                                gpointer self)
{
	__lambda7_ (self);
}

static void
___lambda10_ (FilesFileChooserDialog* self)
{
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->accept_button;
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		g_signal_emit (self, files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL], 0, GTK_RESPONSE_OK);
	}
}

static void
____lambda10__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	___lambda10_ ((FilesFileChooserDialog*) self);
}

static void
files_file_chooser_dialog_setup_chooser (FilesFileChooserDialog* self)
{
	Block2Data* _data2_;
	GtkFileChooserWidget* _tmp0_;
	gpointer _tmp1_;
	GtkRevealer* _tmp2_;
	GtkWidget* _tmp3_;
	gpointer _tmp4_;
	GtkMenuButton* new_folder_button = NULL;
	GtkStack* _tmp5_;
	gpointer _tmp6_;
	GtkMenuButton* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkMenuButton* _tmp10_;
	GtkContainer* _tmp11_;
	GtkContainer* _tmp12_;
	GtkMenuButton* _tmp13_;
	HdyHeaderBar* _tmp14_;
	GtkMenuButton* _tmp15_;
	GtkFileChooserAction _tmp16_;
	GtkStack* view_stack = NULL;
	GtkRevealer* _tmp37_;
	GtkContainer* _tmp38_;
	GtkContainer* _tmp39_;
	gpointer _tmp40_;
	GtkWidget* _tmp41_;
	gpointer _tmp42_;
	GtkContainer* _tmp43_;
	GtkContainer* _tmp44_;
	GtkContainer* _tmp45_;
	GtkContainer* _tmp46_;
	gpointer _tmp47_;
	GtkWidget* _tmp48_;
	GtkFileChooserWidget* _tmp49_;
	GtkFileChooserWidget* _tmp50_;
	gpointer _tmp51_;
	GtkWidget* _tmp52_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->chooser;
	_tmp1_ = files_file_chooser_dialog_find_child_by_name (gtk_revealer_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp0_, "browse_widgets_box/browse_widgets_hpaned/<GtkBox>/browse_header_reveal" \
"er");
	_data2_->revealer = (GtkRevealer*) _tmp1_;
	_tmp2_ = _data2_->revealer;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) _tmp2_);
	_tmp4_ = files_file_chooser_dialog_find_child_by_name (gtk_stack_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, "browse_header_stack");
	_data2_->stack = (GtkStack*) _tmp4_;
	_tmp5_ = _data2_->stack;
	_tmp6_ = files_file_chooser_dialog_find_child_by_name (gtk_menu_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp5_, "<GtkBox>/browse_new_folder_button");
	new_folder_button = (GtkMenuButton*) _tmp6_;
	_tmp7_ = new_folder_button;
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-new", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_button_set_image ((GtkButton*) _tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = new_folder_button;
	_tmp11_ = gtk_widget_get_parent ((GtkWidget*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = new_folder_button;
	gtk_container_remove (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->header;
	_tmp15_ = new_folder_button;
	hdy_header_bar_pack_end (_tmp14_, (GtkWidget*) _tmp15_);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) ___lambda7__gtk_widget_realize, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp16_ = self->priv->_action;
	if (_tmp16_ == GTK_FILE_CHOOSER_ACTION_SAVE) {
		GtkGrid* grid = NULL;
		GtkFileChooserWidget* _tmp17_;
		gpointer _tmp18_;
		GtkGrid* _tmp19_;
		GtkContainer* _tmp20_;
		GtkContainer* _tmp21_;
		GtkGrid* _tmp22_;
		GtkGrid* _tmp23_;
		GtkGrid* _tmp24_;
		GtkBox* _tmp25_;
		GtkGrid* _tmp26_;
		GtkGrid* _tmp27_;
		gpointer _tmp28_;
		GtkEntry* _tmp29_;
		GtkEntry* _tmp30_;
		GtkButton* _tmp31_;
		GtkEntry* _tmp32_;
		GtkFileChooserWidget* _tmp33_;
		GtkFileChooserWidget* _tmp34_;
		gpointer _tmp35_;
		GtkWidget* _tmp36_;
		_tmp17_ = self->priv->chooser;
		_tmp18_ = files_file_chooser_dialog_find_child_by_name (gtk_grid_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp17_, "<GtkBox>/<GtkGrid>");
		grid = (GtkGrid*) _tmp18_;
		_tmp19_ = grid;
		_tmp20_ = gtk_widget_get_parent ((GtkWidget*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = grid;
		gtk_container_remove (_tmp21_, (GtkWidget*) _tmp22_);
		_tmp23_ = grid;
		gtk_container_set_border_width ((GtkContainer*) _tmp23_, (guint) 0);
		_tmp24_ = grid;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp24_, 2);
		_tmp25_ = self->priv->extra_box;
		_tmp26_ = grid;
		gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
		_tmp27_ = grid;
		_tmp28_ = files_file_chooser_dialog_find_child_by_name (gtk_entry_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp27_, "<GtkFileChooserEntry>");
		_g_object_unref0 (self->priv->entry);
		self->priv->entry = (GtkEntry*) _tmp28_;
		_tmp29_ = self->priv->entry;
		gtk_entry_set_placeholder_text (_tmp29_, _ ("Enter new filename"));
		_tmp30_ = self->priv->entry;
		_tmp31_ = self->priv->accept_button;
		g_object_bind_property_with_closures ((GObject*) _tmp30_, "text-length", (GObject*) _tmp31_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp32_ = self->priv->entry;
		g_signal_connect_object (_tmp32_, "activate", (GCallback) ____lambda10__gtk_entry_activate, self, 0);
		_tmp33_ = self->priv->chooser;
		_tmp34_ = self->priv->chooser;
		_tmp35_ = files_file_chooser_dialog_find_child_by_name (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp34_, "<GtkBox>");
		_tmp36_ = (GtkWidget*) _tmp35_;
		gtk_container_remove ((GtkContainer*) _tmp33_, _tmp36_);
		_g_object_unref0 (_tmp36_);
		_g_object_unref0 (grid);
	}
	_tmp37_ = _data2_->revealer;
	_tmp38_ = gtk_widget_get_parent ((GtkWidget*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = files_file_chooser_dialog_find_child_by_name (gtk_stack_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp39_, "list_and_preview_box/browse_files_stack");
	view_stack = (GtkStack*) _tmp40_;
	_tmp41_ = gtk_stack_get_child_by_name (view_stack, "list");
	_tmp42_ = files_file_chooser_dialog_find_child_by_name (gtk_tree_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp41_, "browse_files_swin/browse_files_tree_view");
	_g_object_unref0 (self->priv->tree_view);
	self->priv->tree_view = (GtkTreeView*) _tmp42_;
	_tmp43_ = gtk_widget_get_parent ((GtkWidget*) view_stack);
	_tmp44_ = _tmp43_;
	_tmp45_ = gtk_widget_get_parent ((GtkWidget*) view_stack);
	_tmp46_ = _tmp45_;
	_tmp47_ = files_file_chooser_dialog_find_child_by_name (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp46_, "preview_box");
	_tmp48_ = (GtkWidget*) _tmp47_;
	gtk_container_remove (_tmp44_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = self->priv->chooser;
	_tmp50_ = self->priv->chooser;
	_tmp51_ = files_file_chooser_dialog_find_child_by_name (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GtkWidget*) _tmp50_, "extra_and_filters");
	_tmp52_ = (GtkWidget*) _tmp51_;
	gtk_container_remove ((GtkContainer*) _tmp49_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	_g_object_unref0 (view_stack);
	_g_object_unref0 (new_folder_button);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gboolean
files_file_chooser_dialog_real_key_press_event (GtkWidget* base,
                                                GdkEventKey* event)
{
	FilesFileChooserDialog * self;
	guint keyval = 0U;
	guint _tmp0_ = 0U;
	gboolean result;
	self = (FilesFileChooserDialog*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gdk_event_get_keyval ((GdkEvent*) event, &_tmp0_);
	keyval = _tmp0_;
	if (keyval == GDK_KEY_Escape) {
		g_signal_emit (self, files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL], 0, GTK_RESPONSE_DELETE_EVENT);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GTK_WIDGET_CLASS (files_file_chooser_dialog_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_window_get_type (), HdyWindow), event);
	return result;
}

static void
files_file_chooser_dialog_real_show (GtkWidget* base)
{
	FilesFileChooserDialog * self;
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	self = (FilesFileChooserDialog*) base;
	GTK_WIDGET_CLASS (files_file_chooser_dialog_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_window_get_type (), HdyWindow));
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = window;
	gdk_window_focus (_tmp2_, (guint32) GDK_CURRENT_TIME);
}

void
files_file_chooser_dialog_set_current_folder (FilesFileChooserDialog* self,
                                              const gchar* uri)
{
	const gchar* _tmp0_ = NULL;
	GtkFileChooserWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = uri;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = g_get_home_dir ();
		_tmp0_ = _tmp1_;
	}
	_tmp2_ = self->priv->chooser;
	gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) _tmp2_, _tmp0_);
}

void
files_file_chooser_dialog_set_current_name (FilesFileChooserDialog* self,
                                            const gchar* text)
{
	GtkFileChooserWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->chooser;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp0_, text);
}

gchar*
files_file_chooser_dialog_get_uri (FilesFileChooserDialog* self)
{
	GtkFileChooserWidget* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
files_file_chooser_dialog_set_uri (FilesFileChooserDialog* self,
                                   const gchar* uri)
{
	GtkFileChooserWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->chooser;
	gtk_file_chooser_set_uri ((GtkFileChooser*) _tmp0_, uri);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FilesFileChooserDialog* self;
		self = _data3_->self;
		_data3_->uris = (_vala_array_free (_data3_->uris, _data3_->uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda11_ (Block3Data* _data3_,
             const gchar* uri)
{
	FilesFileChooserDialog* self;
	gchar* _tmp0_;
	self = _data3_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup (uri);
	_vala_array_add1 (&_data3_->uris, &_data3_->uris_length1, &_data3_->_uris_size_, _tmp0_);
}

static void
___lambda11__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda11_ (self, (const gchar*) data);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
files_file_chooser_dialog_get_uris (FilesFileChooserDialog* self,
                                    gint* result_length1)
{
	Block3Data* _data3_;
	gchar** _tmp0_;
	GtkFileChooserWidget* _tmp1_;
	GSList* _tmp2_;
	GSList* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data3_->uris = _tmp0_;
	_data3_->uris_length1 = 0;
	_data3_->_uris_size_ = _data3_->uris_length1;
	_tmp1_ = self->priv->chooser;
	_tmp2_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_slist_foreach (_tmp3_, ___lambda11__gfunc, _data3_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_slist_free__g_free0_ (_tmp3_), NULL));
	_tmp4_ = (_data3_->uris != NULL) ? _vala_array_dup2 (_data3_->uris, _data3_->uris_length1) : _data3_->uris;
	_tmp4__length1 = _data3_->uris_length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

GFile*
files_file_chooser_dialog_get_file (FilesFileChooserDialog* self)
{
	GtkFileChooserWidget* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
files_file_chooser_dialog_add_choice (FilesFileChooserDialog* self,
                                      FilesFileChooserChoice* choice)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (choice != NULL);
	_tmp0_ = self->priv->choices_box;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) choice);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FilesFileChooserDialog* self;
		self = _data4_->self;
		_data4_->choices = (_vala_array_free (_data4_->choices, _data4_->choices_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_array_add2 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda12_ (Block4Data* _data4_,
             GtkWidget* w)
{
	FilesFileChooserDialog* self;
	FilesFileChooserChoice* c = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	self = _data4_->self;
	g_return_if_fail (w != NULL);
	c = G_TYPE_CHECK_INSTANCE_CAST (w, FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoice);
	_tmp0_ = gtk_widget_get_name ((GtkWidget*) c);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_file_chooser_choice_get_selected (c);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new ("(ss)", _tmp1_, _tmp3_, NULL);
	g_variant_ref_sink (_tmp4_);
	_vala_array_add2 (&_data4_->choices, &_data4_->choices_length1, &_data4_->_choices_size_, _tmp4_);
}

static void
___lambda12__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda12_ (self, (GtkWidget*) data);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static GVariant**
_vala_array_dup3 (GVariant** self,
                  gssize length)
{
	if (length >= 0) {
		GVariant** result;
		gssize i;
		result = g_new0 (GVariant*, length + 1);
		for (i = 0; i < length; i++) {
			GVariant* _tmp0_;
			_tmp0_ = _g_variant_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GVariant**
files_file_chooser_dialog_get_choices (FilesFileChooserDialog* self,
                                       gint* result_length1)
{
	Block4Data* _data4_;
	GVariant** _tmp0_;
	GtkBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GVariant** _tmp4_;
	gint _tmp4__length1;
	GVariant** _tmp5_;
	gint _tmp5__length1;
	GVariant** result;
	g_return_val_if_fail (self != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_new0 (GVariant*, 0 + 1);
	_data4_->choices = _tmp0_;
	_data4_->choices_length1 = 0;
	_data4_->_choices_size_ = _data4_->choices_length1;
	_tmp1_ = self->priv->choices_box;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda12__gfunc, _data4_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	_tmp4_ = (_data4_->choices != NULL) ? _vala_array_dup3 (_data4_->choices, _data4_->choices_length1) : _data4_->choices;
	_tmp4__length1 = _data4_->choices_length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

static gint
__lambda13_ (GtkFileFilter* a,
             const gchar* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = gtk_file_filter_get_name (a);
	result = _tmp0_ (_tmp1_, b);
	return result;
}

static gint
___lambda13__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda13_ ((GtkFileFilter*) a, (const gchar*) b);
	return result;
}

void
files_file_chooser_dialog_add_filter (FilesFileChooserDialog* self,
                                      GtkFileFilter* filter)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkFileChooserWidget* _tmp2_;
	GSList* _tmp3_;
	GSList* _tmp4_;
	const gchar* _tmp5_;
	GSList* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	_tmp0_ = gtk_file_filter_get_name (filter);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->chooser;
	_tmp3_ = gtk_file_chooser_list_filters ((GtkFileChooser*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = name;
	_tmp6_ = g_slist_find_custom (_tmp4_, _tmp5_, ___lambda13__gcompare_func);
	_tmp7_ = _tmp6_ == NULL;
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_slist_free (_tmp4_), NULL));
	if (_tmp7_) {
		GtkFileChooserWidget* _tmp8_;
		GtkFileFilter* _tmp9_;
		GtkComboBoxText* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = self->priv->chooser;
		_tmp9_ = _g_object_ref0 (filter);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp8_, _tmp9_);
		_tmp10_ = self->priv->filter_box;
		_tmp11_ = name;
		_tmp12_ = name;
		gtk_combo_box_text_append (_tmp10_, _tmp11_, _tmp12_);
	}
	_g_free0 (name);
}

static void
files_file_chooser_dialog_real_close (XdpRequest* base,
                                      GError** error)
{
	FilesFileChooserDialog * self;
	self = (FilesFileChooserDialog*) base;
	g_signal_emit (self, files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL], 0, GTK_RESPONSE_DELETE_EVENT);
}

gboolean
files_file_chooser_dialog_register_object (FilesFileChooserDialog* self,
                                           GDBusConnection* connection,
                                           const char* handle)
{
	GDBusConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (handle != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->dbus_connection);
	self->priv->dbus_connection = _tmp0_;
	{
		guint _tmp1_ = 0U;
		guint _tmp2_;
		_tmp2_ = xdp_request_register_object ((XdpRequest*) self, connection, (const gchar*) handle, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->register_id = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("FileChooserDialog.vala:485: %s", _tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = TRUE;
	return result;
}

static void
files_file_chooser_dialog_real_dispose (GObject* base)
{
	FilesFileChooserDialog * self;
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_;
	GtkFileChooserWidget* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_ = FALSE;
	self = (FilesFileChooserDialog*) base;
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->chooser;
	_tmp4_ = gtk_file_chooser_get_current_folder_uri ((GtkFileChooser*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_settings_set_string (_tmp2_, "last-folder-uri", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->settings;
	g_settings_set (_tmp6_, "window-size", "(ii)", w, h);
	if (self->priv->register_id != ((guint) 0)) {
		GDBusConnection* _tmp8_;
		_tmp8_ = self->priv->dbus_connection;
		_tmp7_ = _tmp8_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GDBusConnection* _tmp9_;
		_tmp9_ = self->priv->dbus_connection;
		g_dbus_connection_unregister_object (_tmp9_, self->priv->register_id);
	}
	G_OBJECT_CLASS (files_file_chooser_dialog_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_window_get_type (), HdyWindow));
}

const gchar*
files_file_chooser_dialog_get_parent_window (FilesFileChooserDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_window;
	result = _tmp0_;
	return result;
}

static void
files_file_chooser_dialog_set_parent_window (FilesFileChooserDialog* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_chooser_dialog_get_parent_window (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_parent_window);
		self->priv->_parent_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_PARENT_WINDOW_PROPERTY]);
	}
}

GtkFileChooserAction
files_file_chooser_dialog_get_action (FilesFileChooserDialog* self)
{
	GtkFileChooserAction result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_action;
	return result;
}

static void
files_file_chooser_dialog_set_action (FilesFileChooserDialog* self,
                                      GtkFileChooserAction value)
{
	GtkFileChooserAction old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_chooser_dialog_get_action (self);
	if (old_value != value) {
		self->priv->_action = value;
		g_object_notify_by_pspec ((GObject *) self, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_ACTION_PROPERTY]);
	}
}

gboolean
files_file_chooser_dialog_get_read_only (FilesFileChooserDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_read_only;
	return result;
}

void
files_file_chooser_dialog_set_read_only (FilesFileChooserDialog* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_chooser_dialog_get_read_only (self);
	if (old_value != value) {
		self->priv->_read_only = value;
		g_object_notify_by_pspec ((GObject *) self, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_READ_ONLY_PROPERTY]);
	}
}

const gchar*
files_file_chooser_dialog_get_accept_label (FilesFileChooserDialog* self)
{
	const gchar* result;
	GtkButton* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->accept_button;
	_tmp1_ = gtk_button_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
files_file_chooser_dialog_set_accept_label (FilesFileChooserDialog* self,
                                            const gchar* value)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->accept_button;
	gtk_button_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_ACCEPT_LABEL_PROPERTY]);
}

gboolean
files_file_chooser_dialog_get_select_multiple (FilesFileChooserDialog* self)
{
	gboolean result;
	GtkFileChooserWidget* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_select_multiple ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
files_file_chooser_dialog_set_select_multiple (FilesFileChooserDialog* self,
                                               gboolean value)
{
	GtkFileChooserWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->chooser;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_SELECT_MULTIPLE_PROPERTY]);
}

GtkFileFilter*
files_file_chooser_dialog_get_filter (FilesFileChooserDialog* self)
{
	GtkFileFilter* result;
	GtkFileChooserWidget* _tmp0_;
	GtkFileFilter* _tmp1_;
	GtkFileFilter* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
files_file_chooser_dialog_set_filter (FilesFileChooserDialog* self,
                                      GtkFileFilter* value)
{
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter_box;
	_tmp1_ = gtk_file_filter_get_name (value);
	if (!gtk_combo_box_set_active_id ((GtkComboBox*) _tmp0_, _tmp1_)) {
		GtkFileChooserWidget* _tmp2_;
		_tmp2_ = self->priv->chooser;
		gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp2_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_FILTER_PROPERTY]);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FilesFileChooserDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->gtk_settings);
		_g_object_unref0 (_data5_->granite_settings);
		_g_object_unref0 (_data5_->next_button);
		_g_object_unref0 (_data5_->previous_button);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		FilesFileChooserDialog* self;
		self = _data6_->_data5_->self;
		_g_object_unref0 (_data6_->read_only_check);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_files_file_chooser_dialog____lambda14_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	FilesFileChooserDialog* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkCheckButton* _tmp3_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp1_ = files_file_chooser_dialog_get_select_multiple (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = _ ("Open Files as Read Only");
	} else {
		_tmp0_ = _ ("Open File as Read Only");
	}
	_tmp3_ = _data6_->read_only_check;
	gtk_button_set_label ((GtkButton*) _tmp3_, _tmp0_);
}

static void
__files_file_chooser_dialog____lambda14__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	_files_file_chooser_dialog____lambda14_ (self);
}

static void
_files_file_chooser_dialog___lambda15_ (FilesFileChooserDialog* self)
{
	const gchar* _tmp0_;
	GtkFileChooserWidget* _tmp7_;
	GSList* _tmp8_;
	GSList* _tmp9_;
	gboolean _tmp10_;
	GtkBox* _tmp16_;
	GList* _tmp17_;
	GList* _tmp18_;
	gboolean _tmp19_;
	_tmp0_ = self->priv->_parent_window;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		ExternalWindow* parent = NULL;
		const gchar* _tmp1_;
		ExternalWindow* _tmp2_;
		ExternalWindow* _tmp3_;
		_tmp1_ = self->priv->_parent_window;
		_tmp2_ = external_window_from_handle (_tmp1_);
		parent = _tmp2_;
		_tmp3_ = parent;
		if (_tmp3_ == NULL) {
			const gchar* _tmp4_;
			_tmp4_ = self->priv->_parent_window;
			g_warning ("FileChooserDialog.vala:182: Failed to associate portal window with par" \
"ent window %s", _tmp4_);
		} else {
			ExternalWindow* _tmp5_;
			GdkWindow* _tmp6_;
			_tmp5_ = parent;
			_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
			external_window_set_parent_of (_tmp5_, _tmp6_);
		}
		_g_object_unref0 (parent);
	}
	_tmp7_ = self->priv->chooser;
	_tmp8_ = gtk_file_chooser_list_filters ((GtkFileChooser*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_slist_length (_tmp9_) == ((guint) 0);
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (g_slist_free (_tmp9_), NULL));
	if (_tmp10_) {
		GtkComboBoxText* _tmp11_;
		_tmp11_ = self->priv->filter_box;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
	} else {
		GtkComboBoxText* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->filter_box;
		_tmp13_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == NULL) {
			GtkComboBoxText* _tmp15_;
			_tmp15_ = self->priv->filter_box;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp15_, 0);
		}
	}
	_tmp16_ = self->priv->choices_box;
	_tmp17_ = gtk_container_get_children ((GtkContainer*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_list_length (_tmp18_) == ((guint) 0);
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (g_list_free (_tmp18_), NULL));
	if (_tmp19_) {
		GtkBox* _tmp20_;
		_tmp20_ = self->priv->choices_box;
		gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
	}
}

static void
__files_file_chooser_dialog___lambda15__gtk_widget_realize (GtkWidget* _sender,
                                                            gpointer self)
{
	_files_file_chooser_dialog___lambda15_ ((FilesFileChooserDialog*) self);
}

static void
_files_file_chooser_dialog___lambda16_ (FilesFileChooserDialog* self)
{
	GtkFileChooserWidget* _tmp0_;
	GQueue* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	self->priv->previous_button_clicked = TRUE;
	_tmp0_ = self->priv->chooser;
	_tmp1_ = self->priv->previous_paths;
	_tmp2_ = g_queue_pop_head (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) _tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
__files_file_chooser_dialog___lambda16__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_files_file_chooser_dialog___lambda16_ ((FilesFileChooserDialog*) self);
}

static void
_files_file_chooser_dialog___lambda17_ (FilesFileChooserDialog* self)
{
	GtkFileChooserWidget* _tmp0_;
	GQueue* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	self->priv->next_button_clicked = TRUE;
	_tmp0_ = self->priv->chooser;
	_tmp1_ = self->priv->next_paths;
	_tmp2_ = g_queue_pop_head (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) _tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
__files_file_chooser_dialog___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_files_file_chooser_dialog___lambda17_ ((FilesFileChooserDialog*) self);
}

static void
_files_file_chooser_dialog___lambda18_ (FilesFileChooserDialog* self,
                                        const gchar* path)
{
	GtkFileChooserWidget* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->chooser;
	gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) _tmp0_, path);
}

static void
__files_file_chooser_dialog___lambda18__files_view_chrome_locatable_path_change_request (FilesViewChromeLocatable* _sender,
                                                                                         const gchar* path,
                                                                                         FilesOpenFlag flag,
                                                                                         gpointer self)
{
	_files_file_chooser_dialog___lambda18_ ((FilesFileChooserDialog*) self, path);
}

static gint
__lambda20_ (GtkFileFilter* a,
             const gchar* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = gtk_file_filter_get_name (a);
	result = _tmp0_ (_tmp1_, b);
	return result;
}

static gint
___lambda20__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda20_ ((GtkFileFilter*) a, (const gchar*) b);
	return result;
}

static void
_files_file_chooser_dialog___lambda19_ (FilesFileChooserDialog* self)
{
	GtkFileFilter* filter = NULL;
	GtkFileChooserWidget* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	GtkComboBoxText* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GSList* _tmp6_;
	gconstpointer _tmp7_;
	GtkFileFilter* _tmp8_;
	GtkFileFilter* _tmp9_;
	GtkFileFilter* _tmp10_;
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_list_filters ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->filter_box;
	_tmp4_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_slist_find_custom (_tmp2_, _tmp5_, ___lambda20__gcompare_func);
	_tmp7_ = _tmp6_->data;
	_tmp8_ = _g_object_ref0 ((GtkFileFilter*) _tmp7_);
	_tmp9_ = _tmp8_;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_slist_free (_tmp2_), NULL));
	filter = _tmp9_;
	_tmp10_ = filter;
	if (_tmp10_ != NULL) {
		GtkFileChooserWidget* _tmp11_;
		GtkFileFilter* _tmp12_;
		_tmp11_ = self->priv->chooser;
		_tmp12_ = filter;
		gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp11_, _tmp12_);
	}
	_g_object_unref0 (filter);
}

static void
__files_file_chooser_dialog___lambda19__gtk_combo_box_changed (GtkComboBox* _sender,
                                                               gpointer self)
{
	_files_file_chooser_dialog___lambda19_ ((FilesFileChooserDialog*) self);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static gboolean
_files_file_chooser_dialog___lambda21_ (FilesFileChooserDialog* self,
                                        GtkWidget* w,
                                        GdkEventButton* e)
{
	GtkTreeView* tv = NULL;
	GtkTreeView* _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeView* _tmp1_;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_ = NULL;
	gboolean _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	tv = G_TYPE_CHECK_INSTANCE_CAST (w, gtk_tree_view_get_type (), GtkTreeView);
	if (e->type == GDK_2BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp0_ = tv;
	gtk_tree_view_set_activate_on_single_click (_tmp0_, FALSE);
	path = NULL;
	column = NULL;
	_tmp1_ = tv;
	_tmp4_ = gtk_tree_view_get_path_at_pos (_tmp1_, (gint) e->x, (gint) e->y, &_tmp2_, &_tmp3_, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp2_;
	_g_object_unref0 (column);
	_tmp5_ = _g_object_ref0 (_tmp3_);
	column = _tmp5_;
	if (_tmp4_) {
		GtkTreeModel* model = NULL;
		GtkTreeView* _tmp6_;
		GtkTreeModel* _tmp7_;
		GtkTreeModel* _tmp8_;
		GtkTreeIter* iter = NULL;
		GtkTreeModel* _tmp9_;
		GtkTreePath* _tmp10_;
		GtkTreeIter _tmp11_ = {0};
		gboolean _tmp12_;
		GtkTreeIter _tmp13_;
		GtkTreeIter* _tmp14_;
		_tmp6_ = tv;
		_tmp7_ = gtk_tree_view_get_model (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		model = _tmp8_;
		iter = NULL;
		_tmp9_ = model;
		_tmp10_ = path;
		_tmp12_ = gtk_tree_model_get_iter (_tmp9_, &_tmp11_, _tmp10_);
		__vala_GtkTreeIter_free0 (iter);
		_tmp13_ = _tmp11_;
		_tmp14_ = __vala_GtkTreeIter_copy0 (&_tmp13_);
		iter = _tmp14_;
		if (_tmp12_) {
			gboolean is_folder = FALSE;
			GtkTreeModel* _tmp15_;
			GtkTreeIter* _tmp16_;
			GtkTreeIter _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp15_ = model;
			_tmp16_ = iter;
			_tmp17_ = *_tmp16_;
			gtk_tree_model_get (_tmp15_, &_tmp17_, 6, &_tmp18_, -1);
			is_folder = _tmp18_;
			if (is_folder) {
				GtkTreeView* _tmp19_;
				_tmp19_ = tv;
				gtk_tree_view_set_activate_on_single_click (_tmp19_, TRUE);
			}
		}
		__vala_GtkTreeIter_free0 (iter);
		_g_object_unref0 (model);
	}
	result = FALSE;
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
	return result;
}

static gboolean
__files_file_chooser_dialog___lambda21__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self)
{
	gboolean result;
	result = _files_file_chooser_dialog___lambda21_ ((FilesFileChooserDialog*) self, _sender, event);
	return result;
}

static void
_files_file_chooser_dialog___lambda22_ (Block5Data* _data5_)
{
	FilesFileChooserDialog* self;
	gchar* previous_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	GtkFileChooserWidget* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	GtkButton* _tmp19_;
	GQueue* _tmp20_;
	GtkButton* _tmp21_;
	GQueue* _tmp22_;
	FilesViewChromeBasicLocationBar* _tmp23_;
	const gchar* _tmp24_;
	self = _data5_->self;
	_tmp0_ = self->priv->current_path;
	_tmp1_ = g_strdup (_tmp0_);
	previous_path = _tmp1_;
	_tmp3_ = self->priv->chooser;
	_tmp4_ = gtk_file_chooser_get_current_folder_uri ((GtkFileChooser*) _tmp3_);
	_tmp2_ = _tmp4_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_get_home_dir ();
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	_g_free0 (self->priv->current_path);
	self->priv->current_path = _tmp7_;
	_tmp9_ = previous_path;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = previous_path;
		_tmp11_ = self->priv->current_path;
		_tmp8_ = g_strcmp0 (_tmp10_, _tmp11_) != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		if (self->priv->previous_button_clicked) {
			GQueue* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = self->priv->next_paths;
			_tmp13_ = previous_path;
			_tmp14_ = g_strdup (_tmp13_);
			g_queue_push_head (_tmp12_, _tmp14_);
		} else {
			GQueue* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = self->priv->previous_paths;
			_tmp16_ = previous_path;
			_tmp17_ = g_strdup (_tmp16_);
			g_queue_push_head (_tmp15_, _tmp17_);
			if (!self->priv->next_button_clicked) {
				GQueue* _tmp18_;
				_tmp18_ = self->priv->next_paths;
				g_queue_clear (_tmp18_);
			}
		}
	}
	_tmp19_ = _data5_->previous_button;
	_tmp20_ = self->priv->previous_paths;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, !g_queue_is_empty (_tmp20_));
	_tmp21_ = _data5_->next_button;
	_tmp22_ = self->priv->next_paths;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, !g_queue_is_empty (_tmp22_));
	self->priv->previous_button_clicked = FALSE;
	self->priv->next_button_clicked = FALSE;
	_tmp23_ = self->priv->location_bar;
	_tmp24_ = self->priv->current_path;
	files_view_chrome_basic_location_bar_set_display_path (_tmp23_, _tmp24_);
	_g_free0 (_tmp2_);
	_g_free0 (previous_path);
}

static void
__files_file_chooser_dialog___lambda22__gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender,
                                                                                 gpointer self)
{
	_files_file_chooser_dialog___lambda22_ (self);
}

static void
_files_file_chooser_dialog___lambda23_ (FilesFileChooserDialog* self)
{
	GtkFileChooserWidget* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_file_test (_tmp2_, G_FILE_TEST_IS_DIR);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		g_signal_emit (self, files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL], 0, GTK_RESPONSE_OK);
	}
}

static void
__files_file_chooser_dialog___lambda23__gtk_file_chooser_file_activated (GtkFileChooser* _sender,
                                                                         gpointer self)
{
	_files_file_chooser_dialog___lambda23_ ((FilesFileChooserDialog*) self);
}

static void
_files_file_chooser_dialog___lambda24_ (FilesFileChooserDialog* self)
{
	g_signal_emit (self, files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL], 0, GTK_RESPONSE_CANCEL);
}

static void
__files_file_chooser_dialog___lambda24__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_files_file_chooser_dialog___lambda24_ ((FilesFileChooserDialog*) self);
}

static void
_files_file_chooser_dialog___lambda25_ (FilesFileChooserDialog* self)
{
	g_signal_emit (self, files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL], 0, GTK_RESPONSE_OK);
}

static void
__files_file_chooser_dialog___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_files_file_chooser_dialog___lambda25_ ((FilesFileChooserDialog*) self);
}

static void
_files_file_chooser_dialog___lambda26_ (Block5Data* _data5_)
{
	FilesFileChooserDialog* self;
	GtkSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	self = _data5_->self;
	_tmp0_ = _data5_->gtk_settings;
	_tmp1_ = _data5_->granite_settings;
	_tmp2_ = granite_settings_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gtk-application-prefer-dark-theme", _tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
__files_file_chooser_dialog___lambda26__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_files_file_chooser_dialog___lambda26_ (self);
}

static GObject *
files_file_chooser_dialog_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesFileChooserDialog * self;
	Block5Data* _data5_;
	GQueue* _tmp0_;
	GQueue* _tmp1_;
	FilesViewChromeBasicLocationBar* _tmp2_;
	gchar* _tmp3_;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	gchar* _tmp7_;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_;
	GtkStyleContext* _tmp10_;
	FilesViewChromeBasicLocationBar* _tmp11_;
	GtkWidget* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	HdyHeaderBar* _tmp16_ = NULL;
	HdyHeaderBar* _tmp17_;
	GtkStyleContext* _tmp18_;
	HdyHeaderBar* _tmp19_;
	GtkButton* _tmp20_;
	HdyHeaderBar* _tmp21_;
	GtkButton* _tmp22_;
	GtkFileChooserAction _tmp23_;
	GtkFileChooserWidget* _tmp24_ = NULL;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_ = NULL;
	GtkButton* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkComboBoxText* _tmp29_;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkComboBoxText* _tmp32_;
	GtkFileChooserAction _tmp33_;
	GtkButtonBox* action_box = NULL;
	GtkButtonBox* _tmp41_ = NULL;
	GtkButtonBox* _tmp42_;
	GtkButton* _tmp43_;
	GtkButtonBox* _tmp44_;
	GtkButton* _tmp45_;
	GtkButtonBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkButtonBox* _tmp48_;
	GtkBox* _tmp49_;
	GtkBox* _tmp50_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp51_ = NULL;
	GtkGrid* _tmp52_;
	HdyHeaderBar* _tmp53_;
	GtkGrid* _tmp54_;
	GtkSeparator* _tmp55_;
	GtkSeparator* _tmp56_;
	GtkGrid* _tmp57_;
	GtkFileChooserWidget* _tmp58_;
	GtkGrid* _tmp59_;
	GtkSeparator* _tmp60_;
	GtkSeparator* _tmp61_;
	GtkGrid* _tmp62_;
	GtkBox* _tmp63_;
	GtkGrid* _tmp64_;
	GtkButtonBox* _tmp65_;
	GtkGrid* _tmp66_;
	GSettings* _tmp67_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp68_;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	GtkButton* _tmp71_;
	GtkButton* _tmp72_;
	FilesViewChromeBasicLocationBar* _tmp73_;
	GtkComboBoxText* _tmp74_;
	GtkTreeView* _tmp75_;
	GtkFileChooserWidget* _tmp76_;
	GtkFileChooserWidget* _tmp77_;
	GtkButton* _tmp78_;
	GtkButton* _tmp79_;
	GraniteSettings* _tmp80_;
	GraniteSettings* _tmp81_;
	GtkSettings* _tmp82_;
	GtkSettings* _tmp83_;
	GtkSettings* _tmp84_;
	GraniteSettings* _tmp85_;
	GraniteSettingsColorScheme _tmp86_;
	GraniteSettingsColorScheme _tmp87_;
	GraniteSettings* _tmp88_;
	GtkFileChooserWidget* _tmp89_;
	GSettings* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GtkFileChooserAction _tmp93_;
	parent_class = G_OBJECT_CLASS (files_file_chooser_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialog);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_queue_new ();
	(self->priv->previous_paths == NULL) ? NULL : (self->priv->previous_paths = (_g_queue_free__g_free0_ (self->priv->previous_paths), NULL));
	self->priv->previous_paths = _tmp0_;
	_tmp1_ = g_queue_new ();
	(self->priv->next_paths == NULL) ? NULL : (self->priv->next_paths = (_g_queue_free__g_free0_ (self->priv->next_paths), NULL));
	self->priv->next_paths = _tmp1_;
	hdy_init ();
	_tmp2_ = files_view_chrome_basic_location_bar_new (NULL);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->location_bar);
	self->priv->location_bar = _tmp2_;
	_tmp3_ = g_strdup (_ ("Previous"));
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	g_object_ref_sink (_tmp4_);
	_data5_->previous_button = _tmp4_;
	_tmp5_ = _data5_->previous_button;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_FLAT);
	_tmp7_ = g_strdup (_ ("Next"));
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	g_object_ref_sink (_tmp8_);
	_data5_->next_button = _tmp8_;
	_tmp9_ = _data5_->next_button;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, GTK_STYLE_CLASS_FLAT);
	_tmp11_ = self->priv->location_bar;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_custom_title (_tmp16_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	hdy_header_bar_set_title (_tmp16_, _tmp15_);
	_g_free0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp16_;
	_tmp17_ = self->priv->header;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_FLAT);
	_tmp19_ = self->priv->header;
	_tmp20_ = _data5_->previous_button;
	hdy_header_bar_pack_start (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->header;
	_tmp22_ = _data5_->next_button;
	hdy_header_bar_pack_start (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->_action;
	_tmp24_ = (GtkFileChooserWidget*) gtk_file_chooser_widget_new (_tmp23_);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp24_, TRUE);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->chooser);
	self->priv->chooser = _tmp24_;
	_tmp25_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp25_);
	cancel_button = _tmp25_;
	_tmp26_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_use_underline (_tmp26_, TRUE);
	gtk_widget_set_can_default ((GtkWidget*) _tmp26_, TRUE);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->accept_button);
	self->priv->accept_button = _tmp26_;
	_tmp27_ = self->priv->accept_button;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp29_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->filter_box);
	self->priv->filter_box = _tmp29_;
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->extra_box);
	self->priv->extra_box = _tmp30_;
	_tmp31_ = self->priv->extra_box;
	_tmp32_ = self->priv->filter_box;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, TRUE, TRUE, (guint) 0);
	_tmp33_ = self->priv->_action;
	if (_tmp33_ == GTK_FILE_CHOOSER_ACTION_OPEN) {
		Block6Data* _data6_;
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_;
		gboolean _tmp36_;
		GtkCheckButton* _tmp37_ = NULL;
		GtkCheckButton* _tmp38_;
		GtkBox* _tmp39_;
		GtkCheckButton* _tmp40_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data5_ = block5_data_ref (_data5_);
		_tmp35_ = files_file_chooser_dialog_get_select_multiple (self);
		_tmp36_ = _tmp35_;
		if (_tmp36_) {
			_tmp34_ = _ ("Open Files as Read Only");
		} else {
			_tmp34_ = _ ("Open File as Read Only");
		}
		_tmp37_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp34_);
		gtk_widget_set_margin_start ((GtkWidget*) _tmp37_, 6);
		g_object_ref_sink (_tmp37_);
		_data6_->read_only_check = _tmp37_;
		g_signal_connect_data ((GObject*) self, "notify::select-multiple", (GCallback) __files_file_chooser_dialog____lambda14__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp38_ = _data6_->read_only_check;
		g_object_bind_property_with_closures ((GObject*) _tmp38_, "active", (GObject*) self, "read-only", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp39_ = self->priv->extra_box;
		_tmp40_ = _data6_->read_only_check;
		gtk_box_pack_end (_tmp39_, (GtkWidget*) _tmp40_, TRUE, TRUE, (guint) 0);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	_tmp41_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_set (_tmp41_, "layout-style", GTK_BUTTONBOX_END, NULL);
	gtk_box_set_spacing ((GtkBox*) _tmp41_, 6);
	g_object_set ((GtkWidget*) _tmp41_, "margin", 6, NULL);
	g_object_ref_sink (_tmp41_);
	action_box = _tmp41_;
	_tmp42_ = action_box;
	_tmp43_ = cancel_button;
	gtk_box_pack_start ((GtkBox*) _tmp42_, (GtkWidget*) _tmp43_, TRUE, TRUE, (guint) 0);
	_tmp44_ = action_box;
	_tmp45_ = self->priv->accept_button;
	gtk_box_pack_start ((GtkBox*) _tmp44_, (GtkWidget*) _tmp45_, TRUE, TRUE, (guint) 0);
	_tmp46_ = action_box;
	_tmp47_ = self->priv->extra_box;
	gtk_box_pack_start ((GtkBox*) _tmp46_, (GtkWidget*) _tmp47_, TRUE, TRUE, (guint) 0);
	_tmp48_ = action_box;
	_tmp49_ = self->priv->extra_box;
	gtk_button_box_set_child_secondary (_tmp48_, (GtkWidget*) _tmp49_, TRUE);
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_halign ((GtkWidget*) _tmp50_, GTK_ALIGN_START);
	g_object_set ((GtkWidget*) _tmp50_, "margin", 6, NULL);
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->choices_box);
	self->priv->choices_box = _tmp50_;
	_tmp51_ = (GtkGrid*) gtk_grid_new ();
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp51_, GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp51_);
	grid = _tmp51_;
	_tmp52_ = grid;
	_tmp53_ = self->priv->header;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = grid;
	_tmp55_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp55_);
	_tmp56_ = _tmp55_;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp56_);
	_g_object_unref0 (_tmp56_);
	_tmp57_ = grid;
	_tmp58_ = self->priv->chooser;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = grid;
	_tmp60_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp60_);
	_tmp61_ = _tmp60_;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp61_);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = grid;
	_tmp63_ = self->priv->choices_box;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = grid;
	_tmp65_ = action_box;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp66_);
	files_file_chooser_dialog_setup_chooser (self);
	_tmp67_ = g_settings_new ("io.elementary.files.file-chooser");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp67_;
	_tmp68_ = self->priv->settings;
	g_settings_get (_tmp68_, "window-size", "(ii)", &_tmp69_, &_tmp70_);
	width = _tmp69_;
	height = _tmp70_;
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DIALOG);
	g_object_set ((GtkWindow*) self, "default-height", height, NULL);
	g_object_set ((GtkWindow*) self, "default-width", width, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __files_file_chooser_dialog___lambda15__gtk_widget_realize, self, 0);
	_tmp71_ = _data5_->previous_button;
	g_signal_connect_object (_tmp71_, "clicked", (GCallback) __files_file_chooser_dialog___lambda16__gtk_button_clicked, self, 0);
	_tmp72_ = _data5_->next_button;
	g_signal_connect_object (_tmp72_, "clicked", (GCallback) __files_file_chooser_dialog___lambda17__gtk_button_clicked, self, 0);
	_tmp73_ = self->priv->location_bar;
	g_signal_connect_object ((FilesViewChromeLocatable*) _tmp73_, "path-change-request", (GCallback) __files_file_chooser_dialog___lambda18__files_view_chrome_locatable_path_change_request, self, 0);
	_tmp74_ = self->priv->filter_box;
	g_signal_connect_object ((GtkComboBox*) _tmp74_, "changed", (GCallback) __files_file_chooser_dialog___lambda19__gtk_combo_box_changed, self, 0);
	_tmp75_ = self->priv->tree_view;
	g_signal_connect_object ((GtkWidget*) _tmp75_, "button-release-event", (GCallback) __files_file_chooser_dialog___lambda21__gtk_widget_button_release_event, self, 0);
	_tmp76_ = self->priv->chooser;
	g_signal_connect_data ((GtkFileChooser*) _tmp76_, "current-folder-changed", (GCallback) __files_file_chooser_dialog___lambda22__gtk_file_chooser_current_folder_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, G_CONNECT_AFTER);
	_tmp77_ = self->priv->chooser;
	g_signal_connect_object ((GtkFileChooser*) _tmp77_, "file-activated", (GCallback) __files_file_chooser_dialog___lambda23__gtk_file_chooser_file_activated, self, 0);
	_tmp78_ = cancel_button;
	g_signal_connect_object (_tmp78_, "clicked", (GCallback) __files_file_chooser_dialog___lambda24__gtk_button_clicked, self, 0);
	_tmp79_ = self->priv->accept_button;
	g_signal_connect_object (_tmp79_, "clicked", (GCallback) __files_file_chooser_dialog___lambda25__gtk_button_clicked, self, 0);
	_tmp80_ = granite_settings_get_default ();
	_tmp81_ = _g_object_ref0 (_tmp80_);
	_data5_->granite_settings = _tmp81_;
	_tmp82_ = gtk_settings_get_default ();
	_tmp83_ = _g_object_ref0 (_tmp82_);
	_data5_->gtk_settings = _tmp83_;
	_tmp84_ = _data5_->gtk_settings;
	_tmp85_ = _data5_->granite_settings;
	_tmp86_ = granite_settings_get_prefers_color_scheme (_tmp85_);
	_tmp87_ = _tmp86_;
	g_object_set (_tmp84_, "gtk-application-prefer-dark-theme", _tmp87_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	_tmp88_ = _data5_->granite_settings;
	g_signal_connect_data ((GObject*) _tmp88_, "notify::prefers-color-scheme", (GCallback) __files_file_chooser_dialog___lambda26__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp89_ = self->priv->chooser;
	_tmp90_ = self->priv->settings;
	_tmp91_ = g_settings_get_string (_tmp90_, "last-folder-uri");
	_tmp92_ = _tmp91_;
	gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) _tmp89_, _tmp92_);
	_g_free0 (_tmp92_);
	_tmp93_ = self->priv->_action;
	if (_tmp93_ == GTK_FILE_CHOOSER_ACTION_SAVE) {
		GtkEntry* _tmp94_;
		_tmp94_ = self->priv->entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp94_);
	} else {
		GtkTreeView* _tmp95_;
		_tmp95_ = self->priv->tree_view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp95_);
	}
	_g_object_unref0 (grid);
	_g_object_unref0 (action_box);
	_g_object_unref0 (cancel_button);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
files_file_chooser_dialog_class_init (FilesFileChooserDialogClass * klass,
                                      gpointer klass_data)
{
	files_file_chooser_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesFileChooserDialog_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) files_file_chooser_dialog_real_key_press_event;
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) files_file_chooser_dialog_real_show;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) files_file_chooser_dialog_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_file_chooser_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_file_chooser_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_file_chooser_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_file_chooser_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CHOOSER_DIALOG_PARENT_WINDOW_PROPERTY, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_PARENT_WINDOW_PROPERTY] = g_param_spec_string ("parent-window", "parent-window", "parent-window", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CHOOSER_DIALOG_ACTION_PROPERTY, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_ACTION_PROPERTY] = g_param_spec_enum ("action", "action", "action", gtk_file_chooser_action_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CHOOSER_DIALOG_READ_ONLY_PROPERTY, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CHOOSER_DIALOG_ACCEPT_LABEL_PROPERTY, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_ACCEPT_LABEL_PROPERTY] = g_param_spec_string ("accept-label", "accept-label", "accept-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CHOOSER_DIALOG_SELECT_MULTIPLE_PROPERTY, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_SELECT_MULTIPLE_PROPERTY] = g_param_spec_boolean ("select-multiple", "select-multiple", "select-multiple", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CHOOSER_DIALOG_FILTER_PROPERTY, files_file_chooser_dialog_properties[FILES_FILE_CHOOSER_DIALOG_FILTER_PROPERTY] = g_param_spec_object ("filter", "filter", "filter", gtk_file_filter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	files_file_chooser_dialog_signals[FILES_FILE_CHOOSER_DIALOG_RESPONSE_SIGNAL] = g_signal_new ("response", FILES_TYPE_FILE_CHOOSER_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, gtk_response_type_get_type ());
}

static void
files_file_chooser_dialog_xdp_request_interface_init (XdpRequestIface * iface,
                                                      gpointer iface_data)
{
	files_file_chooser_dialog_xdp_request_parent_iface = g_type_interface_peek_parent (iface);
	iface->close = (void (*) (XdpRequest*, GError**)) files_file_chooser_dialog_real_close;
}

static void
files_file_chooser_dialog_instance_init (FilesFileChooserDialog * self,
                                         gpointer klass)
{
	self->priv = files_file_chooser_dialog_get_instance_private (self);
	self->priv->_read_only = FALSE;
	self->priv->current_path = NULL;
	self->priv->previous_button_clicked = FALSE;
	self->priv->next_button_clicked = FALSE;
	self->priv->register_id = (guint) 0;
	self->priv->dbus_connection = NULL;
}

static void
files_file_chooser_dialog_finalize (GObject * obj)
{
	FilesFileChooserDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialog);
	_g_free0 (self->priv->_parent_window);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->location_bar);
	_g_object_unref0 (self->priv->chooser);
	_g_object_unref0 (self->priv->tree_view);
	_g_object_unref0 (self->priv->accept_button);
	_g_object_unref0 (self->priv->filter_box);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->choices_box);
	_g_object_unref0 (self->priv->extra_box);
	(self->priv->previous_paths == NULL) ? NULL : (self->priv->previous_paths = (_g_queue_free__g_free0_ (self->priv->previous_paths), NULL));
	(self->priv->next_paths == NULL) ? NULL : (self->priv->next_paths = (_g_queue_free__g_free0_ (self->priv->next_paths), NULL));
	_g_free0 (self->priv->current_path);
	_g_object_unref0 (self->priv->dbus_connection);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (files_file_chooser_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_file_chooser_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileChooserDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_file_chooser_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFileChooserDialog), 0, (GInstanceInitFunc) files_file_chooser_dialog_instance_init, NULL };
	static const GInterfaceInfo xdp_request_info = { (GInterfaceInitFunc) files_file_chooser_dialog_xdp_request_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType files_file_chooser_dialog_type_id;
	files_file_chooser_dialog_type_id = g_type_register_static (hdy_window_get_type (), "FilesFileChooserDialog", &g_define_type_info, 0);
	g_type_add_interface_static (files_file_chooser_dialog_type_id, XDP_TYPE_REQUEST, &xdp_request_info);
	FilesFileChooserDialog_private_offset = g_type_add_instance_private (files_file_chooser_dialog_type_id, sizeof (FilesFileChooserDialogPrivate));
	return files_file_chooser_dialog_type_id;
}

GType
files_file_chooser_dialog_get_type (void)
{
	static volatile gsize files_file_chooser_dialog_type_id__once = 0;
	if (g_once_init_enter (&files_file_chooser_dialog_type_id__once)) {
		GType files_file_chooser_dialog_type_id;
		files_file_chooser_dialog_type_id = files_file_chooser_dialog_get_type_once ();
		g_once_init_leave (&files_file_chooser_dialog_type_id__once, files_file_chooser_dialog_type_id);
	}
	return files_file_chooser_dialog_type_id__once;
}

static void
_vala_files_file_chooser_dialog_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	FilesFileChooserDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialog);
	switch (property_id) {
		case FILES_FILE_CHOOSER_DIALOG_PARENT_WINDOW_PROPERTY:
		g_value_set_string (value, files_file_chooser_dialog_get_parent_window (self));
		break;
		case FILES_FILE_CHOOSER_DIALOG_ACTION_PROPERTY:
		g_value_set_enum (value, files_file_chooser_dialog_get_action (self));
		break;
		case FILES_FILE_CHOOSER_DIALOG_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, files_file_chooser_dialog_get_read_only (self));
		break;
		case FILES_FILE_CHOOSER_DIALOG_ACCEPT_LABEL_PROPERTY:
		g_value_set_string (value, files_file_chooser_dialog_get_accept_label (self));
		break;
		case FILES_FILE_CHOOSER_DIALOG_SELECT_MULTIPLE_PROPERTY:
		g_value_set_boolean (value, files_file_chooser_dialog_get_select_multiple (self));
		break;
		case FILES_FILE_CHOOSER_DIALOG_FILTER_PROPERTY:
		g_value_set_object (value, files_file_chooser_dialog_get_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_file_chooser_dialog_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	FilesFileChooserDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialog);
	switch (property_id) {
		case FILES_FILE_CHOOSER_DIALOG_PARENT_WINDOW_PROPERTY:
		files_file_chooser_dialog_set_parent_window (self, g_value_get_string (value));
		break;
		case FILES_FILE_CHOOSER_DIALOG_ACTION_PROPERTY:
		files_file_chooser_dialog_set_action (self, g_value_get_enum (value));
		break;
		case FILES_FILE_CHOOSER_DIALOG_READ_ONLY_PROPERTY:
		files_file_chooser_dialog_set_read_only (self, g_value_get_boolean (value));
		break;
		case FILES_FILE_CHOOSER_DIALOG_ACCEPT_LABEL_PROPERTY:
		files_file_chooser_dialog_set_accept_label (self, g_value_get_string (value));
		break;
		case FILES_FILE_CHOOSER_DIALOG_SELECT_MULTIPLE_PROPERTY:
		files_file_chooser_dialog_set_select_multiple (self, g_value_get_boolean (value));
		break;
		case FILES_FILE_CHOOSER_DIALOG_FILTER_PROPERTY:
		files_file_chooser_dialog_set_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

