/* BreadcrumbsEntry.c generated by valac 0.56.18, the Vala compiler
 * generated from BreadcrumbsEntry.vala, do not modify */

/** Overridden Navigatable interface functions **/
/** Search related functions **/
/** Completion related functions
      * Implementing interface virtual functions **/
/** Drag-drop functions **/
/** Context menu functions **/

#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_FILE_DRAG_ACTIONS ((GDK_ACTION_COPY | GDK_ACTION_MOVE) | GDK_ACTION_LINK)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY (files_view_chrome_breadcrumbs_entry_get_type ())
#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntry))
#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntryClass))
#define FILES_VIEW_CHROME_IS_BREADCRUMBS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY))
#define FILES_VIEW_CHROME_IS_BREADCRUMBS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY))
#define FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntryClass))

typedef struct _FilesViewChromeBreadcrumbsEntry FilesViewChromeBreadcrumbsEntry;
typedef struct _FilesViewChromeBreadcrumbsEntryClass FilesViewChromeBreadcrumbsEntryClass;
typedef struct _FilesViewChromeBreadcrumbsEntryPrivate FilesViewChromeBreadcrumbsEntryPrivate;
enum  {
	FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_0_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_SEARCH_MODE_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
typedef struct _Block54Data Block54Data;
typedef struct _Block55Data Block55Data;
typedef struct _Block56Data Block56Data;
enum  {
	FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_OPEN_WITH_REQUEST_SIGNAL,
	FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_NUM_SIGNALS
};
static guint files_view_chrome_breadcrumbs_entry_signals[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_NUM_SIGNALS] = {0};

struct _FilesViewChromeBreadcrumbsEntry {
	FilesViewChromeBasicBreadcrumbsEntry parent_instance;
	FilesViewChromeBreadcrumbsEntryPrivate * priv;
};

struct _FilesViewChromeBreadcrumbsEntryClass {
	FilesViewChromeBasicBreadcrumbsEntryClass parent_class;
};

struct _FilesViewChromeBreadcrumbsEntryPrivate {
	gulong files_menu_dir_handler_id;
	GtkMenu* menu;
	FilesDirectory* current_completion_dir;
	gboolean match_found;
	gboolean multiple_completions;
	gchar* to_complete;
	gboolean _search_mode;
	gboolean drop_data_ready;
	gboolean drop_occurred;
	GList* drop_file_list;
	GdkDragAction current_suggested_action;
	GdkDragAction current_actions;
	FilesFile* drop_target_file;
	gdouble menu_x_root;
	gdouble menu_y_root;
};

struct _Block54Data {
	int _ref_count_;
	FilesViewChromeBreadcrumbsEntry* self;
	FilesDirectory* files_menu_dir;
	GdkEvent* event;
};

struct _Block55Data {
	int _ref_count_;
	FilesViewChromeBreadcrumbsEntry* self;
	GFile* loc;
	gchar* path;
};

struct _Block56Data {
	int _ref_count_;
	Block55Data * _data55_;
	GAppInfo* app_info;
};

static gint FilesViewChromeBreadcrumbsEntry_private_offset;
static gpointer files_view_chrome_breadcrumbs_entry_parent_class = NULL;
VALA_EXTERN FilesDndHandler* files_view_chrome_breadcrumbs_entry_dnd_handler;
FilesDndHandler* files_view_chrome_breadcrumbs_entry_dnd_handler = NULL;

VALA_EXTERN GType files_view_chrome_breadcrumbs_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeBreadcrumbsEntry, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN FilesViewChromeBreadcrumbsEntry* files_view_chrome_breadcrumbs_entry_new (void);
VALA_EXTERN FilesViewChromeBreadcrumbsEntry* files_view_chrome_breadcrumbs_entry_construct (GType object_type);
static void files_view_chrome_breadcrumbs_entry_set_up_drag_drop (FilesViewChromeBreadcrumbsEntry* self);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_on_drag_leave (FilesViewChromeBreadcrumbsEntry* self);
static void _files_view_chrome_breadcrumbs_entry_on_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                                               GdkDragContext* context,
                                                                               guint time_,
                                                                               gpointer self);
VALA_EXTERN gboolean files_view_chrome_breadcrumbs_entry_on_drag_motion (FilesViewChromeBreadcrumbsEntry* self,
                                                             GdkDragContext* context,
                                                             gint x,
                                                             gint y,
                                                             guint time);
static gboolean _files_view_chrome_breadcrumbs_entry_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                                     GdkDragContext* context,
                                                                                     gint x,
                                                                                     gint y,
                                                                                     guint time_,
                                                                                     gpointer self);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_on_drag_data_received (FilesViewChromeBreadcrumbsEntry* self,
                                                                GdkDragContext* context,
                                                                gint x,
                                                                gint y,
                                                                GtkSelectionData* selection_data,
                                                                guint info,
                                                                guint timestamp);
static void _files_view_chrome_breadcrumbs_entry_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                               GdkDragContext* context,
                                                                                               gint x,
                                                                                               gint y,
                                                                                               GtkSelectionData* selection_data,
                                                                                               guint info,
                                                                                               guint time_,
                                                                                               gpointer self);
VALA_EXTERN gboolean files_view_chrome_breadcrumbs_entry_on_drag_drop (FilesViewChromeBreadcrumbsEntry* self,
                                                           GdkDragContext* context,
                                                           gint x,
                                                           gint y,
                                                           guint timestamp);
static gboolean _files_view_chrome_breadcrumbs_entry_on_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                                 GdkDragContext* context,
                                                                                 gint x,
                                                                                 gint y,
                                                                                 guint time_,
                                                                                 gpointer self);
static gboolean files_view_chrome_breadcrumbs_entry_real_on_key_press_event (FilesViewChromeBasicBreadcrumbsEntry* base,
                                                                      guint keyval,
                                                                      guint keycode,
                                                                      GdkModifierType state);
VALA_EXTERN gboolean files_view_chrome_breadcrumbs_entry_get_search_mode (FilesViewChromeBreadcrumbsEntry* self);
static const gchar* files_view_chrome_breadcrumbs_entry_get_completion_text (FilesViewChromeBreadcrumbsEntry* self);
static void files_view_chrome_breadcrumbs_entry_real_reset (FilesViewChromeBasicBreadcrumbsEntry* base);
static void files_view_chrome_breadcrumbs_entry_set_completion_text (FilesViewChromeBreadcrumbsEntry* self,
                                                              const gchar* value);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_set_primary_icon_name (FilesViewChromeBreadcrumbsEntry* self,
                                                                const gchar* icon_name);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_hide_primary_icon (FilesViewChromeBreadcrumbsEntry* self);
static void files_view_chrome_breadcrumbs_entry_real_set_default_entry_tooltip (FilesViewChromeBasicBreadcrumbsEntry* base);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_completion_needed (FilesViewChromeBreadcrumbsEntry* self);
static void files_view_chrome_breadcrumbs_entry_on_file_loaded (FilesViewChromeBreadcrumbsEntry* self,
                                                         FilesFile* file);
static void _files_view_chrome_breadcrumbs_entry_on_file_loaded_files_directory_file_loaded_func (FilesFile* file,
                                                                                           gpointer self);
static void ___lambda16_ (FilesViewChromeBreadcrumbsEntry* self);
static void ____lambda16__files_directory_done_loading_func (gpointer self);
static FilesFile* files_view_chrome_breadcrumbs_entry_get_target_location (FilesViewChromeBreadcrumbsEntry* self,
                                                                    gint x,
                                                                    gint y);
VALA_EXTERN GtkWindow* files_get_active_window (void);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_right_click_menu_position_func (FilesViewChromeBreadcrumbsEntry* self,
                                                                         GtkMenu* menu,
                                                                         gint* x,
                                                                         gint* y,
                                                                         gboolean* push_in);
static void files_view_chrome_breadcrumbs_entry_load_right_click_menu (FilesViewChromeBreadcrumbsEntry* self,
                                                                GdkEvent* event,
                                                                FilesViewChromeBreadcrumbElement* clicked_element);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void __lambda17_ (FilesViewChromeBreadcrumbsEntry* self);
static void ___lambda17__gtk_menu_shell_cancel (GtkMenuShell* _sender,
                                         gpointer self);
static void __lambda18_ (FilesViewChromeBreadcrumbsEntry* self);
static void ___lambda18__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                             gpointer self);
static void files_view_chrome_breadcrumbs_entry_build_base_menu (FilesViewChromeBreadcrumbsEntry* self,
                                                          GtkMenu* menu,
                                                          const gchar* path);
static void ___lambda25_ (Block54Data* _data54_);
static void files_view_chrome_breadcrumbs_entry_append_subdirectories (FilesViewChromeBreadcrumbsEntry* self,
                                                                GtkMenu* menu,
                                                                FilesDirectory* dir);
static void ____lambda25__files_directory_done_loading (FilesDirectory* _sender,
                                                 gpointer self);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void __lambda19_ (Block55Data* _data55_);
static void ___lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda20_ (Block55Data* _data55_);
static void ___lambda20__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
VALA_EXTERN GList* files_mime_actions_get_applications_for_folder (FilesFile* file);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void _____lambda23_ (Block56Data* _data56_);
static void ______lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static void __lambda24_ (Block55Data* _data55_);
static void ___lambda24__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void ______lambda26_ (FilesViewChromeBreadcrumbsEntry* self,
                      GtkMenuItem* mi);
static void _______lambda26__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static void files_view_chrome_breadcrumbs_entry_real_on_button_pressed_event (FilesViewChromeBasicBreadcrumbsEntry* base,
                                                                       gint n_press,
                                                                       gdouble x,
                                                                       gdouble y);
VALA_EXTERN gboolean files_view_chrome_breadcrumbs_entry_get_hide_breadcrumbs (FilesViewChromeBreadcrumbsEntry* self);
static FilesViewChromeBreadcrumbElement* files_view_chrome_breadcrumbs_entry_mark_pressed_element (FilesViewChromeBreadcrumbsEntry* self,
                                                                                            gdouble x);
static void files_view_chrome_breadcrumbs_entry_real_on_button_released_event (FilesViewChromeBasicBreadcrumbsEntry* base,
                                                                        gint n_press,
                                                                        gdouble x,
                                                                        gdouble y);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (FilesViewChromeBreadcrumbsEntry* self,
                                                               gboolean value);
VALA_EXTERN void files_view_chrome_breadcrumbs_entry_set_search_mode (FilesViewChromeBreadcrumbsEntry* self,
                                                          gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void files_view_chrome_breadcrumbs_entry_finalize (GObject * obj);
static GType files_view_chrome_breadcrumbs_entry_get_type_once (void);
static void _vala_files_view_chrome_breadcrumbs_entry_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_files_view_chrome_breadcrumbs_entry_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);

static inline gpointer
files_view_chrome_breadcrumbs_entry_get_instance_private (FilesViewChromeBreadcrumbsEntry* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeBreadcrumbsEntry_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

FilesViewChromeBreadcrumbsEntry*
files_view_chrome_breadcrumbs_entry_construct (GType object_type)
{
	FilesViewChromeBreadcrumbsEntry * self = NULL;
	self = (FilesViewChromeBreadcrumbsEntry*) files_view_chrome_basic_breadcrumbs_entry_construct (object_type);
	files_view_chrome_breadcrumbs_entry_set_up_drag_drop (self);
	return self;
}

FilesViewChromeBreadcrumbsEntry*
files_view_chrome_breadcrumbs_entry_new (void)
{
	return files_view_chrome_breadcrumbs_entry_construct (FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY);
}

static void
_files_view_chrome_breadcrumbs_entry_on_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          guint time_,
                                                                          gpointer self)
{
	files_view_chrome_breadcrumbs_entry_on_drag_leave ((FilesViewChromeBreadcrumbsEntry*) self);
}

static gboolean
_files_view_chrome_breadcrumbs_entry_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                            GdkDragContext* context,
                                                                            gint x,
                                                                            gint y,
                                                                            guint time_,
                                                                            gpointer self)
{
	gboolean result;
	result = files_view_chrome_breadcrumbs_entry_on_drag_motion ((FilesViewChromeBreadcrumbsEntry*) self, context, x, y, time_);
	return result;
}

static void
_files_view_chrome_breadcrumbs_entry_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                          GdkDragContext* context,
                                                                                          gint x,
                                                                                          gint y,
                                                                                          GtkSelectionData* selection_data,
                                                                                          guint info,
                                                                                          guint time_,
                                                                                          gpointer self)
{
	files_view_chrome_breadcrumbs_entry_on_drag_data_received ((FilesViewChromeBreadcrumbsEntry*) self, context, x, y, selection_data, info, time_);
}

static gboolean
_files_view_chrome_breadcrumbs_entry_on_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        gint x,
                                                                        gint y,
                                                                        guint time_,
                                                                        gpointer self)
{
	gboolean result;
	result = files_view_chrome_breadcrumbs_entry_on_drag_drop ((FilesViewChromeBreadcrumbsEntry*) self, context, x, y, time_);
	return result;
}

static void
files_view_chrome_breadcrumbs_entry_set_up_drag_drop (FilesViewChromeBreadcrumbsEntry* self)
{
	GtkTargetEntry target_uri_list = {0};
	GtkTargetEntry _tmp0_ = {0};
	GtkTargetEntry _tmp1_;
	GtkTargetEntry* _tmp2_;
	GtkTargetEntry* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_.target = "text/uri-list";
	_tmp0_.flags = (guint) 0;
	_tmp0_.info = (guint) FILES_TARGET_TYPE_TEXT_URI_LIST;
	target_uri_list = _tmp0_;
	_tmp1_ = target_uri_list;
	_tmp2_ = g_new0 (GtkTargetEntry, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_MOTION, _tmp3_, (gint) 1, GDK_ACTION_ASK | FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_FILE_DRAG_ACTIONS);
	_tmp3_ = (g_free (_tmp3_), NULL);
	g_signal_connect_object ((GtkWidget*) self, "drag-leave", (GCallback) _files_view_chrome_breadcrumbs_entry_on_drag_leave_gtk_widget_drag_leave, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-motion", (GCallback) _files_view_chrome_breadcrumbs_entry_on_drag_motion_gtk_widget_drag_motion, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _files_view_chrome_breadcrumbs_entry_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-drop", (GCallback) _files_view_chrome_breadcrumbs_entry_on_drag_drop_gtk_widget_drag_drop, self, 0);
}

/************************************************/
static gboolean
files_view_chrome_breadcrumbs_entry_real_on_key_press_event (FilesViewChromeBasicBreadcrumbsEntry* base,
                                                             guint keyval,
                                                             guint keycode,
                                                             GdkModifierType state)
{
	FilesViewChromeBreadcrumbsEntry * self;
	gboolean result;
	self = (FilesViewChromeBreadcrumbsEntry*) base;
	switch (keyval) {
		case GDK_KEY_Return:
		case GDK_KEY_KP_Enter:
		case GDK_KEY_ISO_Enter:
		{
			gboolean _tmp0_;
			_tmp0_ = self->priv->_search_mode;
			if (_tmp0_) {
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_KP_Tab:
		case GDK_KEY_Tab:
		{
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp1_ = gtk_entry_get_text ((GtkEntry*) self);
			_tmp2_ = _tmp1_;
			_tmp3_ = files_view_chrome_breadcrumbs_entry_get_completion_text (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) self, _tmp6_);
			_g_free0 (_tmp6_);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_CLASS (files_view_chrome_breadcrumbs_entry_parent_class)->on_key_press_event (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry), keyval, keycode, state);
	return result;
}

static void
files_view_chrome_breadcrumbs_entry_real_reset (FilesViewChromeBasicBreadcrumbsEntry* base)
{
	FilesViewChromeBreadcrumbsEntry * self;
	gboolean _tmp0_;
	self = (FilesViewChromeBreadcrumbsEntry*) base;
	_tmp0_ = self->priv->_search_mode;
	if (_tmp0_) {
		return;
	} else {
		FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_CLASS (files_view_chrome_breadcrumbs_entry_parent_class)->reset (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry));
		files_view_chrome_breadcrumbs_entry_set_completion_text (self, "");
		_g_object_unref0 (self->priv->current_completion_dir);
		self->priv->current_completion_dir = NULL;
	}
}

/******************************/
void
files_view_chrome_breadcrumbs_entry_set_primary_icon_name (FilesViewChromeBreadcrumbsEntry* self,
                                                           const gchar* icon_name)
{
	g_return_if_fail (self != NULL);
	g_object_set ((GtkEntry*) self, "primary-icon-name", icon_name, NULL);
}

void
files_view_chrome_breadcrumbs_entry_hide_primary_icon (FilesViewChromeBreadcrumbsEntry* self)
{
	g_return_if_fail (self != NULL);
	g_object_set ((GtkEntry*) self, "primary-icon-pixbuf", NULL, NULL);
}

static void
files_view_chrome_breadcrumbs_entry_real_set_default_entry_tooltip (FilesViewChromeBasicBreadcrumbsEntry* base)
{
	FilesViewChromeBreadcrumbsEntry * self;
	self = (FilesViewChromeBreadcrumbsEntry*) base;
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, _ ("Search or Type Path"));
}

/****************************/
static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_files_view_chrome_breadcrumbs_entry_on_file_loaded_files_directory_file_loaded_func (FilesFile* file,
                                                                                      gpointer self)
{
	files_view_chrome_breadcrumbs_entry_on_file_loaded ((FilesViewChromeBreadcrumbsEntry*) self, file);
}

static void
___lambda16_ (FilesViewChromeBreadcrumbsEntry* self)
{
}

static void
____lambda16__files_directory_done_loading_func (gpointer self)
{
	___lambda16_ ((FilesViewChromeBreadcrumbsEntry*) self);
}

void
files_view_chrome_breadcrumbs_entry_completion_needed (FilesViewChromeBreadcrumbsEntry* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* _tmp10_;
	gint last_slash = 0;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp5_ = path;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = path;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ < 1;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = path;
		_tmp3_ = g_str_has_prefix (_tmp9_, "admin:/");
	}
	if (_tmp3_) {
		_g_free0 (path);
		return;
	}
	_tmp10_ = g_strdup ("");
	_g_free0 (self->priv->to_complete);
	self->priv->to_complete = _tmp10_;
	files_view_chrome_breadcrumbs_entry_set_completion_text (self, "");
	_tmp11_ = path;
	last_slash = string_last_index_of_char (_tmp11_, (gunichar) '/', 0);
	if (last_slash > -1) {
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp13_ = path;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp12_ = last_slash < _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = path;
		_tmp17_ = path;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_slice (_tmp16_, (glong) (last_slash + 1), (glong) _tmp19_);
		_g_free0 (self->priv->to_complete);
		self->priv->to_complete = _tmp20_;
	}
	_tmp21_ = self->priv->to_complete;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 0) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GFile* file = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		gboolean _tmp36_ = FALSE;
		FilesDirectory* _tmp37_;
		FilesDirectory* _tmp44_;
		_tmp24_ = path;
		_tmp25_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->current_dir_path;
		if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
			_g_free0 (path);
			return;
		}
		_tmp26_ = path;
		_tmp27_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->current_dir_path;
		_tmp28_ = files_file_utils_sanitize_path (_tmp26_, _tmp27_, TRUE);
		_tmp29_ = _tmp28_;
		_tmp30_ = files_file_utils_get_file_for_path (_tmp29_);
		_tmp31_ = _tmp30_;
		_g_free0 (_tmp29_);
		file = _tmp31_;
		_tmp32_ = file;
		if (_tmp32_ == NULL) {
			_g_object_unref0 (file);
			_g_free0 (path);
			return;
		}
		_tmp33_ = file;
		if (g_file_has_parent (_tmp33_, NULL)) {
			GFile* _tmp34_;
			GFile* _tmp35_;
			_tmp34_ = file;
			_tmp35_ = g_file_get_parent (_tmp34_);
			_g_object_unref0 (file);
			file = _tmp35_;
		} else {
			_g_object_unref0 (file);
			_g_free0 (path);
			return;
		}
		_tmp37_ = self->priv->current_completion_dir;
		if (_tmp37_ == NULL) {
			_tmp36_ = TRUE;
		} else {
			GFile* _tmp38_;
			FilesDirectory* _tmp39_;
			GFile* _tmp40_;
			GFile* _tmp41_;
			_tmp38_ = file;
			_tmp39_ = self->priv->current_completion_dir;
			_tmp40_ = files_directory_get_location (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp36_ = !g_file_equal (_tmp38_, _tmp41_);
		}
		if (_tmp36_) {
			GFile* _tmp42_;
			FilesDirectory* _tmp43_;
			_tmp42_ = file;
			_tmp43_ = files_directory_from_gfile (_tmp42_);
			_g_object_unref0 (self->priv->current_completion_dir);
			self->priv->current_completion_dir = _tmp43_;
		}
		self->priv->multiple_completions = FALSE;
		self->priv->match_found = FALSE;
		_tmp44_ = self->priv->current_completion_dir;
		files_directory_init (_tmp44_, _files_view_chrome_breadcrumbs_entry_on_file_loaded_files_directory_file_loaded_func, self, ____lambda16__files_directory_done_loading_func, self);
		_g_object_unref0 (file);
	}
	_g_free0 (path);
}

/**
         * This function is used as a callback for files.file_loaded.
         * We check that the file can be used
         * in auto-completion, if yes we put it in our entry.
         *
         * @param file The file you want to load
         *
         **/
static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
files_view_chrome_breadcrumbs_entry_on_file_loaded (FilesViewChromeBreadcrumbsEntry* self,
                                                    FilesFile* file)
{
	gchar* file_display_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (!file->is_directory) {
		return;
	}
	_tmp0_ = files_file_get_display_name (file);
	_tmp1_ = g_strdup (_tmp0_);
	file_display_name = _tmp1_;
	_tmp2_ = file_display_name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->to_complete;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp4_ > _tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp8_ = file_display_name;
		_tmp9_ = g_utf8_strup (_tmp8_, (gssize) -1);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->to_complete;
		_tmp12_ = g_utf8_strup (_tmp11_, (gssize) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_str_has_prefix (_tmp10_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		if (_tmp14_) {
			gchar* residue = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gchar* _tmp22_;
			_tmp15_ = file_display_name;
			_tmp16_ = self->priv->to_complete;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = file_display_name;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = string_slice (_tmp15_, (glong) _tmp18_, (glong) _tmp21_);
			residue = _tmp22_;
			if (!self->priv->match_found) {
				const gchar* _tmp23_;
				self->priv->match_found = TRUE;
				_tmp23_ = residue;
				files_view_chrome_breadcrumbs_entry_set_completion_text (self, _tmp23_);
			} else {
				gunichar c1 = 0U;
				gunichar c2 = 0U;
				gint index1 = 0;
				gint index2 = 0;
				gchar* new_common_chars = NULL;
				gchar* _tmp24_;
				const gchar* _tmp38_;
				self->priv->multiple_completions = TRUE;
				c2 = (gunichar) 0;
				index1 = 0;
				index2 = 0;
				_tmp24_ = g_strdup ("");
				new_common_chars = _tmp24_;
				while (TRUE) {
					gboolean _tmp25_ = FALSE;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gunichar _tmp28_ = 0U;
					gboolean _tmp29_;
					gboolean _tmp33_ = FALSE;
					_tmp26_ = files_view_chrome_breadcrumbs_entry_get_completion_text (self);
					_tmp27_ = _tmp26_;
					_tmp29_ = string_get_next_char (_tmp27_, &index1, &_tmp28_);
					c1 = _tmp28_;
					if (_tmp29_) {
						const gchar* _tmp30_;
						gunichar _tmp31_ = 0U;
						gboolean _tmp32_;
						_tmp30_ = residue;
						_tmp32_ = string_get_next_char (_tmp30_, &index2, &_tmp31_);
						c2 = _tmp31_;
						_tmp25_ = _tmp32_;
					} else {
						_tmp25_ = FALSE;
					}
					if (!_tmp25_) {
						break;
					}
					if (c1 == c2) {
						_tmp33_ = index1 == index2;
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						const gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp34_ = new_common_chars;
						_tmp35_ = g_unichar_to_string (c1);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
						_g_free0 (new_common_chars);
						new_common_chars = _tmp37_;
						_g_free0 (_tmp36_);
					} else {
						break;
					}
				}
				_tmp38_ = new_common_chars;
				files_view_chrome_breadcrumbs_entry_set_completion_text (self, _tmp38_);
				_g_free0 (new_common_chars);
			}
			_g_free0 (residue);
		}
	}
	_g_free0 (file_display_name);
}

/****************************/
gboolean
files_view_chrome_breadcrumbs_entry_on_drag_motion (FilesViewChromeBreadcrumbsEntry* self,
                                                    GdkDragContext* context,
                                                    gint x,
                                                    gint y,
                                                    guint time)
{
	FilesViewChromeBreadcrumbElement* el = NULL;
	FilesViewChromeBreadcrumbElement* _tmp10_;
	gboolean _tmp11_ = FALSE;
	FilesViewChromeBreadcrumbElement* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	if (!self->priv->drop_data_ready) {
		GtkTargetList* list = NULL;
		GdkAtom target = (GdkAtom) 0U;
		GtkTargetList* _tmp0_;
		list = NULL;
		_tmp0_ = list;
		target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp0_);
		if (target != GDK_NONE) {
			gtk_drag_get_data ((GtkWidget*) self, context, target, (guint32) time);
		}
		_gtk_target_list_unref0 (list);
	}
	gtk_drag_unhighlight ((GtkWidget*) self);
	g_signal_stop_emission_by_name (self, "drag-motion");
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			FilesViewChromeBreadcrumbElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			FilesViewChromeBreadcrumbElement* _tmp9_;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (FilesViewChromeBreadcrumbElement*) _tmp8_;
			_tmp9_ = element;
			_tmp9_->pressed = FALSE;
			_g_object_unref0 (element);
		}
	}
	_tmp10_ = files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates ((FilesViewChromeBasicBreadcrumbsEntry*) self, (gdouble) x);
	el = _tmp10_;
	self->priv->current_suggested_action = GDK_ACTION_DEFAULT;
	_tmp12_ = el;
	if (_tmp12_ != NULL) {
		GList* _tmp13_;
		_tmp13_ = self->priv->drop_file_list;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		FilesViewChromeBreadcrumbElement* _tmp14_;
		FilesFile* _tmp15_;
		FilesFile* _tmp16_;
		GList* _tmp17_;
		GdkDragAction _tmp18_ = 0U;
		GdkDragAction _tmp19_;
		_tmp14_ = el;
		_tmp14_->pressed = TRUE;
		_tmp15_ = files_view_chrome_breadcrumbs_entry_get_target_location (self, x, y);
		_g_object_unref0 (self->priv->drop_target_file);
		self->priv->drop_target_file = _tmp15_;
		_tmp16_ = self->priv->drop_target_file;
		_tmp17_ = self->priv->drop_file_list;
		_tmp19_ = files_dnd_handler_file_accepts_drop (_tmp16_, _tmp17_, gdk_drag_context_get_selected_action (context), gdk_drag_context_get_actions (context), &_tmp18_);
		self->priv->current_suggested_action = _tmp18_;
		self->priv->current_actions = _tmp19_;
	}
	gdk_drag_status (context, self->priv->current_suggested_action, (guint32) time);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_object_unref0 (el);
	return result;
}

gboolean
files_view_chrome_breadcrumbs_entry_on_drag_drop (FilesViewChromeBreadcrumbsEntry* self,
                                                  GdkDragContext* context,
                                                  gint x,
                                                  gint y,
                                                  guint timestamp)
{
	GtkTargetList* list = NULL;
	gboolean ok_to_drop = FALSE;
	GdkAtom target = (GdkAtom) 0U;
	GtkTargetList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	list = NULL;
	ok_to_drop = FALSE;
	_tmp0_ = list;
	target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp0_);
	ok_to_drop = target != GDK_NONE;
	if (ok_to_drop) {
		self->priv->drop_occurred = TRUE;
		gtk_drag_get_data ((GtkWidget*) self, context, target, (guint32) timestamp);
	}
	result = ok_to_drop;
	_gtk_target_list_unref0 (list);
	return result;
}

void
files_view_chrome_breadcrumbs_entry_on_drag_data_received (FilesViewChromeBreadcrumbsEntry* self,
                                                           GdkDragContext* context,
                                                           gint x,
                                                           gint y,
                                                           GtkSelectionData* selection_data,
                                                           guint info,
                                                           guint timestamp)
{
	gboolean success = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	success = FALSE;
	if (!self->priv->drop_data_ready) {
		gchar* text = NULL;
		gchar* _tmp0_ = NULL;
		gboolean _tmp1_;
		_tmp1_ = files_dnd_handler_selection_data_is_uri_list (selection_data, info, &_tmp0_);
		_g_free0 (text);
		text = _tmp0_;
		if (_tmp1_) {
			const gchar* _tmp2_;
			GList* _tmp3_;
			_tmp2_ = text;
			_tmp3_ = files_file_utils_files_from_uris (_tmp2_);
			(self->priv->drop_file_list == NULL) ? NULL : (self->priv->drop_file_list = (_g_list_free__g_object_unref0_ (self->priv->drop_file_list), NULL));
			self->priv->drop_file_list = _tmp3_;
			self->priv->drop_data_ready = TRUE;
		}
		_g_free0 (text);
	}
	g_signal_stop_emission_by_name (self, "drag-data-received");
	if (self->priv->drop_data_ready) {
		_tmp5_ = self->priv->drop_occurred;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = info == ((guint) FILES_TARGET_TYPE_TEXT_URI_LIST);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		FilesFile* _tmp6_;
		FilesFile* _tmp7_;
		self->priv->drop_occurred = FALSE;
		self->priv->current_actions = 0;
		self->priv->current_suggested_action = 0;
		_tmp6_ = files_view_chrome_breadcrumbs_entry_get_target_location (self, x, y);
		_g_object_unref0 (self->priv->drop_target_file);
		self->priv->drop_target_file = _tmp6_;
		_tmp7_ = self->priv->drop_target_file;
		if (_tmp7_ != NULL) {
			FilesFile* _tmp8_;
			GList* _tmp9_;
			GdkDragAction _tmp10_ = 0U;
			GdkDragAction _tmp11_;
			_tmp8_ = self->priv->drop_target_file;
			_tmp9_ = self->priv->drop_file_list;
			_tmp11_ = files_dnd_handler_file_accepts_drop (_tmp8_, _tmp9_, gdk_drag_context_get_selected_action (context), gdk_drag_context_get_actions (context), &_tmp10_);
			self->priv->current_suggested_action = _tmp10_;
			self->priv->current_actions = _tmp11_;
			if ((self->priv->current_actions & FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_FILE_DRAG_ACTIONS) != 0) {
				FilesDndHandler* _tmp12_;
				FilesFile* _tmp13_;
				GList* _tmp14_;
				GtkWindow* _tmp15_;
				GtkApplicationWindow* _tmp16_;
				_tmp12_ = files_view_chrome_breadcrumbs_entry_dnd_handler;
				_tmp13_ = self->priv->drop_target_file;
				_tmp14_ = self->priv->drop_file_list;
				_tmp15_ = files_get_active_window ();
				_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_application_window_get_type (), GtkApplicationWindow);
				success = files_dnd_handler_handle_file_drag_actions (_tmp12_, (GtkWidget*) self, _tmp13_, _tmp14_, self->priv->current_actions, self->priv->current_suggested_action, _tmp16_, (guint32) timestamp);
				_g_object_unref0 (_tmp16_);
			}
		}
		gtk_drag_finish (context, success, FALSE, (guint32) timestamp);
		files_view_chrome_breadcrumbs_entry_on_drag_leave (self);
	}
}

void
files_view_chrome_breadcrumbs_entry_on_drag_leave (FilesViewChromeBreadcrumbsEntry* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp0_;
		gint _element_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _element_index = 0;
		_tmp0_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->elements;
		_element_list = _tmp0_;
		_tmp1_ = _element_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_element_size = _tmp3_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FilesViewChromeBreadcrumbElement* element = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			FilesViewChromeBreadcrumbElement* _tmp8_;
			_element_index = _element_index + 1;
			_tmp4_ = _element_index;
			_tmp5_ = _element_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _element_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _element_index);
			element = (FilesViewChromeBreadcrumbElement*) _tmp7_;
			_tmp8_ = element;
			if (_tmp8_->pressed) {
				FilesViewChromeBreadcrumbElement* _tmp9_;
				_tmp9_ = element;
				_tmp9_->pressed = FALSE;
				_g_object_unref0 (element);
				break;
			}
			_g_object_unref0 (element);
		}
	}
	self->priv->drop_occurred = FALSE;
	self->priv->drop_data_ready = FALSE;
	(self->priv->drop_file_list == NULL) ? NULL : (self->priv->drop_file_list = (_g_list_free__g_object_unref0_ (self->priv->drop_file_list), NULL));
	self->priv->drop_file_list = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
files_view_chrome_breadcrumbs_entry_right_click_menu_position_func (FilesViewChromeBreadcrumbsEntry* self,
                                                                    GtkMenu* menu,
                                                                    gint* x,
                                                                    gint* y,
                                                                    gboolean* push_in)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_vala_x = (gint) self->priv->menu_x_root;
	_vala_y = (gint) self->priv->menu_y_root;
	_vala_push_in = TRUE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

/****************************/
static GdkEvent*
_vala_GdkEvent_copy (GdkEvent* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEvent_copy0 (gpointer self)
{
	return self ? _vala_GdkEvent_copy (self) : NULL;
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		FilesViewChromeBreadcrumbsEntry* self;
		self = _data54_->self;
		_g_object_unref0 (_data54_->files_menu_dir);
		__vala_GdkEvent_free0 (_data54_->event);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda17_ (FilesViewChromeBreadcrumbsEntry* self)
{
	files_view_chrome_basic_breadcrumbs_entry_reset_elements_states ((FilesViewChromeBasicBreadcrumbsEntry*) self);
}

static void
___lambda17__gtk_menu_shell_cancel (GtkMenuShell* _sender,
                                    gpointer self)
{
	__lambda17_ ((FilesViewChromeBreadcrumbsEntry*) self);
}

static void
__lambda18_ (FilesViewChromeBreadcrumbsEntry* self)
{
	files_view_chrome_basic_breadcrumbs_entry_reset_elements_states ((FilesViewChromeBasicBreadcrumbsEntry*) self);
}

static void
___lambda18__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                        gpointer self)
{
	__lambda18_ ((FilesViewChromeBreadcrumbsEntry*) self);
}

static void
___lambda25_ (Block54Data* _data54_)
{
	FilesViewChromeBreadcrumbsEntry* self;
	GtkMenu* _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	GtkMenu* _tmp3_;
	GtkMenu* _tmp4_;
	self = _data54_->self;
	_tmp0_ = self->priv->menu;
	_tmp1_ = _data54_->files_menu_dir;
	files_view_chrome_breadcrumbs_entry_append_subdirectories (self, _tmp0_, _tmp1_);
	_tmp2_ = _data54_->files_menu_dir;
	g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->files_menu_dir_handler_id);
	_tmp3_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->menu;
	gtk_menu_popup_at_pointer (_tmp4_, _data54_->event);
}

static void
____lambda25__files_directory_done_loading (FilesDirectory* _sender,
                                            gpointer self)
{
	___lambda25_ (self);
}

static void
files_view_chrome_breadcrumbs_entry_load_right_click_menu (FilesViewChromeBreadcrumbsEntry* self,
                                                           GdkEvent* event,
                                                           FilesViewChromeBreadcrumbElement* clicked_element)
{
	Block54Data* _data54_;
	GdkEvent* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	gchar* parent_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* root = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkBorder _tmp10_ = {0};
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble x_root = 0.0;
	gdouble y_root = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	GtkBorder _tmp15_;
	GtkBorder _tmp16_;
	GtkMenu* _tmp17_;
	GtkMenu* _tmp18_;
	GtkMenu* _tmp19_;
	GtkMenu* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	FilesDirectory* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (clicked_element != NULL);
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->self = g_object_ref (self);
	_tmp0_ = __vala_GdkEvent_copy0 (event);
	__vala_GdkEvent_free0 (_data54_->event);
	_data54_->event = _tmp0_;
	_tmp1_ = files_view_chrome_basic_breadcrumbs_entry_get_path_from_element ((FilesViewChromeBasicBreadcrumbsEntry*) self, clicked_element, TRUE);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = files_file_utils_get_parent_path_from_path (_tmp2_, TRUE);
	parent_path = _tmp3_;
	_tmp4_ = parent_path;
	_tmp5_ = files_file_utils_get_file_for_path (_tmp4_);
	root = _tmp5_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	style_context = _tmp7_;
	_tmp8_ = style_context;
	_tmp9_ = style_context;
	gtk_style_context_get_padding (_tmp8_, gtk_style_context_get_state (_tmp9_), &_tmp10_);
	padding = _tmp10_;
	gdk_event_get_coords (_data54_->event, &_tmp11_, &_tmp12_);
	x = _tmp11_;
	y = _tmp12_;
	gdk_event_get_root_coords (_data54_->event, &_tmp13_, &_tmp14_);
	x_root = _tmp13_;
	y_root = _tmp14_;
	if ((clicked_element->x - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_BREAD_SPACING) < ((gdouble) 0)) {
		self->priv->menu_x_root = (x_root - x) + clicked_element->x;
	} else {
		self->priv->menu_x_root = ((x_root - x) + clicked_element->x) - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_BREAD_SPACING;
	}
	_tmp15_ = padding;
	_tmp16_ = padding;
	self->priv->menu_y_root = (((y_root - y) + gtk_widget_get_allocated_height ((GtkWidget*) self)) - _tmp15_.bottom) - _tmp16_.top;
	_tmp17_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp17_;
	_tmp18_ = self->priv->menu;
	g_signal_connect_object ((GtkMenuShell*) _tmp18_, "cancel", (GCallback) ___lambda17__gtk_menu_shell_cancel, self, 0);
	_tmp19_ = self->priv->menu;
	g_signal_connect_object ((GtkMenuShell*) _tmp19_, "deactivate", (GCallback) ___lambda18__gtk_menu_shell_deactivate, self, 0);
	_tmp20_ = self->priv->menu;
	_tmp21_ = path;
	files_view_chrome_breadcrumbs_entry_build_base_menu (self, _tmp20_, _tmp21_);
	_data54_->files_menu_dir = NULL;
	_tmp22_ = root;
	if (_tmp22_ != NULL) {
		GFile* _tmp23_;
		FilesDirectory* _tmp24_;
		FilesDirectory* _tmp25_;
		gulong _tmp26_;
		_tmp23_ = root;
		_tmp24_ = files_directory_from_gfile (_tmp23_);
		_g_object_unref0 (_data54_->files_menu_dir);
		_data54_->files_menu_dir = _tmp24_;
		_tmp25_ = _data54_->files_menu_dir;
		_tmp26_ = g_signal_connect_data (_tmp25_, "done-loading", (GCallback) ____lambda25__files_directory_done_loading, block54_data_ref (_data54_), (GClosureNotify) block54_data_unref, 0);
		self->priv->files_menu_dir_handler_id = _tmp26_;
	} else {
		const gchar* _tmp27_;
		GtkMenu* _tmp28_;
		GtkMenu* _tmp29_;
		_tmp27_ = path;
		g_warning ("BreadcrumbsEntry.vala:390: Root directory null for %s", _tmp27_);
		_tmp28_ = self->priv->menu;
		gtk_widget_show_all ((GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->menu;
		gtk_menu_popup_at_pointer (_tmp29_, _data54_->event);
	}
	_tmp30_ = _data54_->files_menu_dir;
	if (_tmp30_ != NULL) {
		FilesDirectory* _tmp31_;
		_tmp31_ = _data54_->files_menu_dir;
		files_directory_init (_tmp31_, NULL, NULL, NULL, NULL);
	}
	_g_object_unref0 (style_context);
	_g_object_unref0 (root);
	_g_free0 (parent_path);
	_g_free0 (path);
	block54_data_unref (_data54_);
	_data54_ = NULL;
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		FilesViewChromeBreadcrumbsEntry* self;
		self = _data55_->self;
		_g_object_unref0 (_data55_->loc);
		_g_free0 (_data55_->path);
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static void
__lambda19_ (Block55Data* _data55_)
{
	FilesViewChromeBreadcrumbsEntry* self;
	self = _data55_->self;
	g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", _data55_->path, FILES_OPEN_FLAG_NEW_TAB);
}

static void
___lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda19_ (self);
}

static void
__lambda20_ (Block55Data* _data55_)
{
	FilesViewChromeBreadcrumbsEntry* self;
	self = _data55_->self;
	g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", _data55_->path, FILES_OPEN_FLAG_NEW_WINDOW);
}

static void
___lambda20__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda20_ (self);
}

static Block56Data*
block56_data_ref (Block56Data* _data56_)
{
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}

static void
block56_data_unref (void * _userdata_)
{
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		FilesViewChromeBreadcrumbsEntry* self;
		self = _data56_->_data55_->self;
		_g_object_unref0 (_data56_->app_info);
		block55_data_unref (_data56_->_data55_);
		_data56_->_data55_ = NULL;
		g_slice_free (Block56Data, _data56_);
	}
}

static void
_____lambda23_ (Block56Data* _data56_)
{
	Block55Data* _data55_;
	FilesViewChromeBreadcrumbsEntry* self;
	GFile* _tmp0_;
	GAppInfo* _tmp1_;
	_data55_ = _data56_->_data55_;
	self = _data55_->self;
	_tmp0_ = _data55_->loc;
	_tmp1_ = _data56_->app_info;
	g_signal_emit (self, files_view_chrome_breadcrumbs_entry_signals[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_OPEN_WITH_REQUEST_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
______lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
	_____lambda23_ (self);
}

static void
__lambda24_ (Block55Data* _data55_)
{
	FilesViewChromeBreadcrumbsEntry* self;
	GFile* _tmp0_;
	self = _data55_->self;
	_tmp0_ = _data55_->loc;
	g_signal_emit (self, files_view_chrome_breadcrumbs_entry_signals[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_OPEN_WITH_REQUEST_SIGNAL], 0, _tmp0_, NULL);
}

static void
___lambda24__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda24_ (self);
}

static void
files_view_chrome_breadcrumbs_entry_build_base_menu (FilesViewChromeBreadcrumbsEntry* self,
                                                     GtkMenu* menu,
                                                     const gchar* path)
{
	Block55Data* _data55_;
	gchar* _tmp0_;
	GtkMenuItem* menuitem_newtab = NULL;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* menuitem_newwin = NULL;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkSeparatorMenuItem* _tmp7_;
	GtkSeparatorMenuItem* _tmp8_;
	GtkMenu* submenu_open_with = NULL;
	GtkMenu* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	FilesFile* root = NULL;
	FilesFile* _tmp14_;
	GList* app_info_list = NULL;
	FilesFile* _tmp15_;
	GList* _tmp16_;
	gboolean at_least_one = FALSE;
	GList* _tmp17_;
	GtkMenuItem* open_with_other_item = NULL;
	GtkMenuItem* _tmp51_;
	GtkMenu* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (path != NULL);
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_data55_->self = g_object_ref (self);
	_tmp0_ = g_strdup (path);
	_g_free0 (_data55_->path);
	_data55_->path = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in New Tab"));
	g_object_ref_sink (_tmp1_);
	menuitem_newtab = _tmp1_;
	_tmp2_ = menuitem_newtab;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp2_);
	_tmp3_ = menuitem_newtab;
	g_signal_connect_data (_tmp3_, "activate", (GCallback) ___lambda19__gtk_menu_item_activate, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in New Window"));
	g_object_ref_sink (_tmp4_);
	menuitem_newwin = _tmp4_;
	_tmp5_ = menuitem_newwin;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp5_);
	_tmp6_ = menuitem_newwin;
	g_signal_connect_data (_tmp6_, "activate", (GCallback) ___lambda20__gtk_menu_item_activate, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
	_tmp7_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp9_);
	submenu_open_with = _tmp9_;
	_tmp10_ = files_file_utils_escape_uri (_data55_->path, TRUE, TRUE);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_uri (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_data55_->loc = _tmp13_;
	_tmp14_ = files_file_get_by_uri (_data55_->path);
	root = _tmp14_;
	_tmp15_ = root;
	_tmp16_ = files_mime_actions_get_applications_for_folder (_tmp15_);
	app_info_list = _tmp16_;
	at_least_one = FALSE;
	_tmp17_ = app_info_list;
	{
		GList* app_info_collection = NULL;
		GList* app_info_it = NULL;
		app_info_collection = _tmp17_;
		for (app_info_it = app_info_collection; app_info_it != NULL; app_info_it = app_info_it->next) {
			GAppInfo* _tmp18_;
			GAppInfo* app_info = NULL;
			_tmp18_ = _g_object_ref0 ((GAppInfo*) app_info_it->data);
			app_info = _tmp18_;
			{
				Block56Data* _data56_;
				gboolean _tmp19_ = FALSE;
				GAppInfo* _tmp20_;
				_data56_ = g_slice_new0 (Block56Data);
				_data56_->_ref_count_ = 1;
				_data56_->_data55_ = block55_data_ref (_data55_);
				_data56_->app_info = app_info;
				_tmp20_ = _data56_->app_info;
				if (_tmp20_ != NULL) {
					GAppInfo* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp21_ = _data56_->app_info;
					_tmp22_ = g_app_info_get_executable (_tmp21_);
					_tmp23_ = g_get_application_name ();
					_tmp19_ = g_strcmp0 (_tmp22_, _tmp23_) != 0;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					GtkGrid* item_grid = NULL;
					GtkGrid* _tmp24_;
					GtkImage* img = NULL;
					GAppInfo* _tmp25_;
					GIcon* _tmp26_;
					GtkImage* _tmp27_ = NULL;
					GtkGrid* _tmp28_;
					GtkImage* _tmp29_;
					GtkGrid* _tmp30_;
					GAppInfo* _tmp31_;
					const gchar* _tmp32_;
					GtkLabel* _tmp33_;
					GtkLabel* _tmp34_;
					GtkMenuItem* menu_item = NULL;
					GtkMenuItem* _tmp35_;
					GtkMenuItem* _tmp36_;
					GtkGrid* _tmp37_;
					GtkMenuItem* _tmp38_;
					GAppInfo* _tmp39_;
					GAppInfo* _tmp40_;
					GtkMenuItem* _tmp41_;
					GtkMenu* _tmp42_;
					GtkMenuItem* _tmp43_;
					at_least_one = TRUE;
					_tmp24_ = (GtkGrid*) gtk_grid_new ();
					g_object_ref_sink (_tmp24_);
					item_grid = _tmp24_;
					_tmp25_ = _data56_->app_info;
					_tmp26_ = g_app_info_get_icon (_tmp25_);
					_tmp27_ = (GtkImage*) gtk_image_new_from_gicon (_tmp26_, (GtkIconSize) GTK_ICON_SIZE_MENU);
					gtk_image_set_pixel_size (_tmp27_, 16);
					g_object_ref_sink (_tmp27_);
					img = _tmp27_;
					_tmp28_ = item_grid;
					_tmp29_ = img;
					gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
					_tmp30_ = item_grid;
					_tmp31_ = _data56_->app_info;
					_tmp32_ = g_app_info_get_name (_tmp31_);
					_tmp33_ = (GtkLabel*) gtk_label_new (_tmp32_);
					g_object_ref_sink (_tmp33_);
					_tmp34_ = _tmp33_;
					gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp34_);
					_g_object_unref0 (_tmp34_);
					_tmp35_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp35_);
					menu_item = _tmp35_;
					_tmp36_ = menu_item;
					_tmp37_ = item_grid;
					gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
					_tmp38_ = menu_item;
					_tmp39_ = _data56_->app_info;
					_tmp40_ = _g_object_ref0 (_tmp39_);
					g_object_set_data_full ((GObject*) _tmp38_, "appinfo", _tmp40_, g_object_unref);
					_tmp41_ = menu_item;
					g_signal_connect_data (_tmp41_, "activate", (GCallback) ______lambda23__gtk_menu_item_activate, block56_data_ref (_data56_), (GClosureNotify) block56_data_unref, 0);
					_tmp42_ = submenu_open_with;
					_tmp43_ = menu_item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp42_, _tmp43_);
					_g_object_unref0 (menu_item);
					_g_object_unref0 (img);
					_g_object_unref0 (item_grid);
				}
				block56_data_unref (_data56_);
				_data56_ = NULL;
			}
		}
	}
	if (at_least_one) {
		GtkMenuItem* menu_open_with = NULL;
		GtkMenuItem* _tmp44_;
		GtkMenuItem* _tmp45_;
		GtkMenuItem* _tmp46_;
		GtkMenu* _tmp47_;
		GtkMenu* _tmp48_;
		GtkSeparatorMenuItem* _tmp49_;
		GtkSeparatorMenuItem* _tmp50_;
		_tmp44_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open with"));
		g_object_ref_sink (_tmp44_);
		menu_open_with = _tmp44_;
		_tmp45_ = menu_open_with;
		gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp45_);
		_tmp46_ = menu_open_with;
		_tmp47_ = submenu_open_with;
		gtk_menu_item_set_submenu (_tmp46_, _tmp47_);
		_tmp48_ = submenu_open_with;
		_tmp49_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp49_);
		_tmp50_ = _tmp49_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp48_, (GtkMenuItem*) _tmp50_);
		_g_object_unref0 (_tmp50_);
		_g_object_unref0 (menu_open_with);
	}
	_tmp51_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in Other Application…"));
	g_object_ref_sink (_tmp51_);
	open_with_other_item = _tmp51_;
	g_signal_connect_data (open_with_other_item, "activate", (GCallback) ___lambda24__gtk_menu_item_activate, block55_data_ref (_data55_), (GClosureNotify) block55_data_unref, 0);
	_tmp52_ = submenu_open_with;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp52_, open_with_other_item);
	_g_object_unref0 (open_with_other_item);
	(app_info_list == NULL) ? NULL : (app_info_list = (_g_list_free__g_object_unref0_ (app_info_list), NULL));
	_g_object_unref0 (root);
	_g_object_unref0 (submenu_open_with);
	_g_object_unref0 (menuitem_newwin);
	_g_object_unref0 (menuitem_newtab);
	block55_data_unref (_data55_);
	_data55_ = NULL;
}

static void
______lambda26_ (FilesViewChromeBreadcrumbsEntry* self,
                 GtkMenuItem* mi)
{
	gconstpointer _tmp0_;
	g_return_if_fail (mi != NULL);
	_tmp0_ = g_object_get_data ((GObject*) mi, "location");
	g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", (const gchar*) _tmp0_, FILES_OPEN_FLAG_DEFAULT);
}

static void
_______lambda26__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	______lambda26_ ((FilesViewChromeBreadcrumbsEntry*) self, _sender);
}

static void
files_view_chrome_breadcrumbs_entry_append_subdirectories (FilesViewChromeBreadcrumbsEntry* self,
                                                           GtkMenu* menu,
                                                           FilesDirectory* dir)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = files_directory_get_can_load (dir);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GList* sorted_dirs = NULL;
		GList* _tmp2_;
		GList* _tmp3_;
		_tmp2_ = files_directory_get_sorted_dirs (dir);
		sorted_dirs = _tmp2_;
		_tmp3_ = sorted_dirs;
		if (_tmp3_ != NULL) {
			GtkSeparatorMenuItem* _tmp4_;
			GtkSeparatorMenuItem* _tmp5_;
			GList* _tmp6_;
			_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp4_);
			_tmp5_ = _tmp4_;
			gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) _tmp5_);
			_g_object_unref0 (_tmp5_);
			_tmp6_ = sorted_dirs;
			{
				GList* gof_collection = NULL;
				GList* gof_it = NULL;
				gof_collection = _tmp6_;
				for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
					FilesFile* gof = NULL;
					gof = (FilesFile*) gof_it->data;
					{
						GtkMenuItem* menuitem = NULL;
						FilesFile* _tmp7_;
						const gchar* _tmp8_;
						GtkMenuItem* _tmp9_;
						GtkMenuItem* _tmp10_;
						FilesFile* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						GtkMenuItem* _tmp15_;
						GtkMenuItem* _tmp16_;
						_tmp7_ = gof;
						_tmp8_ = files_file_get_display_name (_tmp7_);
						_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp8_);
						g_object_ref_sink (_tmp9_);
						menuitem = _tmp9_;
						_tmp10_ = menuitem;
						_tmp11_ = gof;
						_tmp12_ = files_file_get_uri (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = g_strdup (_tmp13_);
						g_object_set_data_full ((GObject*) _tmp10_, "location", _tmp14_, g_free);
						_tmp15_ = menuitem;
						gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp15_);
						_tmp16_ = menuitem;
						g_signal_connect_object (_tmp16_, "activate", (GCallback) _______lambda26__gtk_menu_item_activate, self, 0);
						_g_object_unref0 (menuitem);
					}
				}
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) menu);
	dir = NULL;
}

static FilesFile*
files_view_chrome_breadcrumbs_entry_get_target_location (FilesViewChromeBreadcrumbsEntry* self,
                                                         gint x,
                                                         gint y)
{
	FilesFile* file = NULL;
	FilesViewChromeBreadcrumbElement* el = NULL;
	FilesViewChromeBreadcrumbElement* _tmp0_;
	FilesViewChromeBreadcrumbElement* _tmp1_;
	FilesFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates ((FilesViewChromeBasicBreadcrumbsEntry*) self, (gdouble) x);
	el = _tmp0_;
	_tmp1_ = el;
	if (_tmp1_ != NULL) {
		FilesViewChromeBreadcrumbElement* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		FilesFile* _tmp7_;
		FilesFile* _tmp8_;
		_tmp2_ = el;
		_tmp3_ = files_view_chrome_basic_breadcrumbs_entry_get_path_from_element ((FilesViewChromeBasicBreadcrumbsEntry*) self, _tmp2_, TRUE);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_commandline_arg (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = files_file_get (_tmp6_);
		_g_object_unref0 (file);
		file = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp8_ = file;
		files_file_ensure_query_info (_tmp8_);
		result = file;
		_g_object_unref0 (el);
		return result;
	}
	result = NULL;
	_g_object_unref0 (el);
	_g_object_unref0 (file);
	return result;
}

static void
files_view_chrome_breadcrumbs_entry_real_on_button_pressed_event (FilesViewChromeBasicBreadcrumbsEntry* base,
                                                                  gint n_press,
                                                                  gdouble x,
                                                                  gdouble y)
{
	FilesViewChromeBreadcrumbsEntry * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (FilesViewChromeBreadcrumbsEntry*) base;
	if (files_view_chrome_basic_breadcrumbs_entry_is_icon_event ((FilesViewChromeBasicBreadcrumbsEntry*) self, x)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		g_object_get ((GtkWidget*) self, "has-focus", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = files_view_chrome_breadcrumbs_entry_get_hide_breadcrumbs (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_CLASS (files_view_chrome_breadcrumbs_entry_parent_class)->on_button_pressed_event (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry), n_press, x, y);
	} else {
		FilesViewChromeBreadcrumbElement* el = NULL;
		FilesViewChromeBreadcrumbElement* _tmp6_;
		FilesViewChromeBreadcrumbElement* _tmp7_;
		_tmp6_ = files_view_chrome_breadcrumbs_entry_mark_pressed_element (self, x);
		el = _tmp6_;
		_tmp7_ = el;
		if (_tmp7_ != NULL) {
			GtkGestureMultiPress* _tmp8_;
			_tmp8_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->button_controller;
			switch (gtk_gesture_single_get_current_button ((GtkGestureSingle*) _tmp8_)) {
				case 2:
				{
					FilesViewChromeBreadcrumbElement* _tmp9_;
					_tmp9_ = el;
					if (_tmp9_ != NULL) {
						GtkGestureMultiPress* _tmp10_;
						FilesViewChromeBreadcrumbElement* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp10_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->button_controller;
						gtk_gesture_set_state ((GtkGesture*) _tmp10_, GTK_EVENT_SEQUENCE_CLAIMED);
						_tmp11_ = el;
						_tmp12_ = files_view_chrome_basic_breadcrumbs_entry_get_path_from_element ((FilesViewChromeBasicBreadcrumbsEntry*) self, _tmp11_, TRUE);
						_tmp13_ = _tmp12_;
						g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", _tmp13_, FILES_OPEN_FLAG_NEW_TAB);
						_g_free0 (_tmp13_);
					}
					break;
				}
				case 3:
				{
					GtkGestureMultiPress* _tmp14_;
					GdkEvent* _tmp15_;
					GdkEvent* _tmp16_;
					FilesViewChromeBreadcrumbElement* _tmp17_;
					_tmp14_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->button_controller;
					gtk_gesture_set_state ((GtkGesture*) _tmp14_, GTK_EVENT_SEQUENCE_CLAIMED);
					_tmp15_ = gtk_get_current_event ();
					_tmp16_ = _tmp15_;
					_tmp17_ = el;
					files_view_chrome_breadcrumbs_entry_load_right_click_menu (self, _tmp16_, _tmp17_);
					__vala_GdkEvent_free0 (_tmp16_);
					break;
				}
				default:
				{
					FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_CLASS (files_view_chrome_breadcrumbs_entry_parent_class)->on_button_pressed_event (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry), n_press, x, y);
					break;
				}
			}
		}
		_g_object_unref0 (el);
	}
}

static void
files_view_chrome_breadcrumbs_entry_real_on_button_released_event (FilesViewChromeBasicBreadcrumbsEntry* base,
                                                                   gint n_press,
                                                                   gdouble x,
                                                                   gdouble y)
{
	FilesViewChromeBreadcrumbsEntry * self;
	GList* _tmp0_;
	self = (FilesViewChromeBreadcrumbsEntry*) base;
	_tmp0_ = self->priv->drop_file_list;
	if (_tmp0_ != NULL) {
		return;
	}
	FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_CLASS (files_view_chrome_breadcrumbs_entry_parent_class)->on_button_released_event (G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry), n_press, x, y);
}

static FilesViewChromeBreadcrumbElement*
files_view_chrome_breadcrumbs_entry_mark_pressed_element (FilesViewChromeBreadcrumbsEntry* self,
                                                          gdouble x)
{
	FilesViewChromeBreadcrumbElement* el = NULL;
	FilesViewChromeBreadcrumbElement* _tmp0_;
	FilesViewChromeBreadcrumbElement* _tmp1_;
	FilesViewChromeBreadcrumbElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	files_view_chrome_basic_breadcrumbs_entry_reset_elements_states ((FilesViewChromeBasicBreadcrumbsEntry*) self);
	_tmp0_ = files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates ((FilesViewChromeBasicBreadcrumbsEntry*) self, x);
	el = _tmp0_;
	_tmp1_ = el;
	if (_tmp1_ != NULL) {
		FilesViewChromeBreadcrumbElement* _tmp2_;
		_tmp2_ = el;
		_tmp2_->pressed = TRUE;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	result = el;
	return result;
}

static const gchar*
files_view_chrome_breadcrumbs_entry_get_completion_text (FilesViewChromeBreadcrumbsEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->placeholder;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_breadcrumbs_entry_set_completion_text (FilesViewChromeBreadcrumbsEntry* self,
                                                         const gchar* value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FilesViewChromeBasicBreadcrumbsEntry*) self)->placeholder;
	if (g_strcmp0 (_tmp0_, value) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (value);
		_g_free0 (((FilesViewChromeBasicBreadcrumbsEntry*) self)->placeholder);
		((FilesViewChromeBasicBreadcrumbsEntry*) self)->placeholder = _tmp1_;
		gtk_widget_queue_draw ((GtkWidget*) self);
		gtk_editable_set_position ((GtkEditable*) self, -1);
	}
}

gboolean
files_view_chrome_breadcrumbs_entry_get_hide_breadcrumbs (FilesViewChromeBreadcrumbsEntry* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = G_TYPE_INSTANCE_GET_INTERFACE (self, FILES_VIEW_CHROME_TYPE_NAVIGATABLE, FilesViewChromeNavigatableIface)->get_hide_breadcrumbs ((FilesViewChromeNavigatable*) G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry));
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_search_mode;
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

void
files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (FilesViewChromeBreadcrumbsEntry* self,
                                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	G_TYPE_INSTANCE_GET_INTERFACE (self, FILES_VIEW_CHROME_TYPE_NAVIGATABLE, FilesViewChromeNavigatableIface)->set_hide_breadcrumbs ((FilesViewChromeNavigatable*) G_TYPE_CHECK_INSTANCE_CAST (self, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry), value);
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY]);
}

gboolean
files_view_chrome_breadcrumbs_entry_get_search_mode (FilesViewChromeBreadcrumbsEntry* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_search_mode;
	return result;
}

void
files_view_chrome_breadcrumbs_entry_set_search_mode (FilesViewChromeBreadcrumbsEntry* self,
                                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_breadcrumbs_entry_get_search_mode (self);
	if (old_value != value) {
		self->priv->_search_mode = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_SEARCH_MODE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
files_view_chrome_breadcrumbs_entry_class_init (FilesViewChromeBreadcrumbsEntryClass * klass,
                                                gpointer klass_data)
{
	FilesDndHandler* _tmp0_;
	files_view_chrome_breadcrumbs_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeBreadcrumbsEntry_private_offset);
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_key_press_event = (gboolean (*) (FilesViewChromeBasicBreadcrumbsEntry*, guint, guint, GdkModifierType)) files_view_chrome_breadcrumbs_entry_real_on_key_press_event;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->reset = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_breadcrumbs_entry_real_reset;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->set_default_entry_tooltip = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_breadcrumbs_entry_real_set_default_entry_tooltip;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_button_pressed_event = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*, gint, gdouble, gdouble)) files_view_chrome_breadcrumbs_entry_real_on_button_pressed_event;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_button_released_event = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*, gint, gdouble, gdouble)) files_view_chrome_breadcrumbs_entry_real_on_button_released_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_breadcrumbs_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_breadcrumbs_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_breadcrumbs_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY, files_view_chrome_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY] = g_param_spec_boolean ("hide-breadcrumbs", "hide-breadcrumbs", "hide-breadcrumbs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_SEARCH_MODE_PROPERTY, files_view_chrome_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_SEARCH_MODE_PROPERTY] = g_param_spec_boolean ("search-mode", "search-mode", "search-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	files_view_chrome_breadcrumbs_entry_signals[FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_OPEN_WITH_REQUEST_SIGNAL] = g_signal_new ("open-with-request", FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_app_info_get_type ());
	_tmp0_ = files_dnd_handler_new ();
	files_view_chrome_breadcrumbs_entry_dnd_handler = _tmp0_;
}

static void
files_view_chrome_breadcrumbs_entry_instance_init (FilesViewChromeBreadcrumbsEntry * self,
                                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_view_chrome_breadcrumbs_entry_get_instance_private (self);
	self->priv->files_menu_dir_handler_id = (gulong) 0;
	self->priv->current_completion_dir = NULL;
	self->priv->match_found = FALSE;
	self->priv->multiple_completions = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->to_complete = _tmp0_;
	self->priv->_search_mode = FALSE;
	self->priv->drop_data_ready = FALSE;
	self->priv->drop_occurred = FALSE;
	self->priv->drop_file_list = NULL;
	self->priv->current_suggested_action = 0;
	self->priv->current_actions = 0;
	self->priv->drop_target_file = NULL;
}

static void
files_view_chrome_breadcrumbs_entry_finalize (GObject * obj)
{
	FilesViewChromeBreadcrumbsEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntry);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->current_completion_dir);
	_g_free0 (self->priv->to_complete);
	(self->priv->drop_file_list == NULL) ? NULL : (self->priv->drop_file_list = (_g_list_free__g_object_unref0_ (self->priv->drop_file_list), NULL));
	_g_object_unref0 (self->priv->drop_target_file);
	G_OBJECT_CLASS (files_view_chrome_breadcrumbs_entry_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_breadcrumbs_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeBreadcrumbsEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_breadcrumbs_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeBreadcrumbsEntry), 0, (GInstanceInitFunc) files_view_chrome_breadcrumbs_entry_instance_init, NULL };
	GType files_view_chrome_breadcrumbs_entry_type_id;
	files_view_chrome_breadcrumbs_entry_type_id = g_type_register_static (FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, "FilesViewChromeBreadcrumbsEntry", &g_define_type_info, 0);
	FilesViewChromeBreadcrumbsEntry_private_offset = g_type_add_instance_private (files_view_chrome_breadcrumbs_entry_type_id, sizeof (FilesViewChromeBreadcrumbsEntryPrivate));
	return files_view_chrome_breadcrumbs_entry_type_id;
}

GType
files_view_chrome_breadcrumbs_entry_get_type (void)
{
	static volatile gsize files_view_chrome_breadcrumbs_entry_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_breadcrumbs_entry_type_id__once)) {
		GType files_view_chrome_breadcrumbs_entry_type_id;
		files_view_chrome_breadcrumbs_entry_type_id = files_view_chrome_breadcrumbs_entry_get_type_once ();
		g_once_init_leave (&files_view_chrome_breadcrumbs_entry_type_id__once, files_view_chrome_breadcrumbs_entry_type_id);
	}
	return files_view_chrome_breadcrumbs_entry_type_id__once;
}

static void
_vala_files_view_chrome_breadcrumbs_entry_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	FilesViewChromeBreadcrumbsEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntry);
	switch (property_id) {
		case FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_breadcrumbs_entry_get_hide_breadcrumbs (self));
		break;
		case FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_SEARCH_MODE_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_breadcrumbs_entry_get_search_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_breadcrumbs_entry_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	FilesViewChromeBreadcrumbsEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BREADCRUMBS_ENTRY, FilesViewChromeBreadcrumbsEntry);
	switch (property_id) {
		case FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY:
		files_view_chrome_breadcrumbs_entry_set_hide_breadcrumbs (self, g_value_get_boolean (value));
		break;
		case FILES_VIEW_CHROME_BREADCRUMBS_ENTRY_SEARCH_MODE_PROPERTY:
		files_view_chrome_breadcrumbs_entry_set_search_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

