/* RenamerDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from RenamerDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2019-2022 Jeremy Wootten
 *
 * Authored by: Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "pantheon-files-core.h"
#include <gee.h>
#include <gdk/gdk.h>

#define FILES_RENAMER_DIALOG_MAX_PREFIX 1
#define FILES_RENAMER_DIALOG_MAX_SUFFIX 1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_RENAMER_DIALOG (files_renamer_dialog_get_type ())
#define FILES_RENAMER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialog))
#define FILES_RENAMER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialogClass))
#define FILES_IS_RENAMER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER_DIALOG))
#define FILES_IS_RENAMER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER_DIALOG))
#define FILES_RENAMER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialogClass))

typedef struct _FilesRenamerDialog FilesRenamerDialog;
typedef struct _FilesRenamerDialogClass FilesRenamerDialogClass;
typedef struct _FilesRenamerDialogPrivate FilesRenamerDialogPrivate;

#define FILES_TYPE_RENAMER (files_renamer_get_type ())
#define FILES_RENAMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER, FilesRenamer))
#define FILES_RENAMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER, FilesRenamerClass))
#define FILES_IS_RENAMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER))
#define FILES_IS_RENAMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER))
#define FILES_RENAMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER, FilesRenamerClass))

typedef struct _FilesRenamer FilesRenamer;
typedef struct _FilesRenamerClass FilesRenamerClass;
enum  {
	FILES_RENAMER_DIALOG_0_PROPERTY,
	FILES_RENAMER_DIALOG_N_NUMBER_SEQ_PROPERTY,
	FILES_RENAMER_DIALOG_N_PREFIX_PROPERTY,
	FILES_RENAMER_DIALOG_N_SUFFIX_PROPERTY,
	FILES_RENAMER_DIALOG_NUM_PROPERTIES
};
static GParamSpec* files_renamer_dialog_properties[FILES_RENAMER_DIALOG_NUM_PROPERTIES];
typedef enum  {
	FILES_RENAMER_DIALOG_RENAME_BASE_ORIGINAL,
	FILES_RENAMER_DIALOG_RENAME_BASE_REPLACE,
	FILES_RENAMER_DIALOG_RENAME_BASE_CUSTOM
} FilesRenamerDialogRenameBase;

#define FILES_RENAMER_DIALOG_TYPE_RENAME_BASE (files_renamer_dialog_rename_base_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FILES_TYPE_RENAMER_MODIFIER (files_renamer_modifier_get_type ())
#define FILES_RENAMER_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifier))
#define FILES_RENAMER_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifierClass))
#define FILES_IS_RENAMER_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER_MODIFIER))
#define FILES_IS_RENAMER_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER_MODIFIER))
#define FILES_RENAMER_MODIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifierClass))

typedef struct _FilesRenamerModifier FilesRenamerModifier;
typedef struct _FilesRenamerModifierClass FilesRenamerModifierClass;
typedef struct _Block13Data Block13Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _FilesRenamerDialog {
	GraniteDialog parent_instance;
	FilesRenamerDialogPrivate * priv;
};

struct _FilesRenamerDialogClass {
	GraniteDialogClass parent_class;
};

struct _FilesRenamerDialogPrivate {
	FilesRenamer* renamer;
	GtkGrid* controls_grid;
	GtkBox* prefix_box;
	GtkBox* suffix_box;
	GtkRevealer* prefix_revealer;
	GtkRevealer* suffix_revealer;
	GtkEntry* basename_entry;
	GtkEntry* replacement_entry;
	GtkRadioButton* modify_basename_toggle;
	GtkRadioButton* new_basename_toggle;
	GtkRadioButton* original_basename_toggle;
	GtkRevealer* sortby_revealer;
	GSimpleActionGroup* actions;
	gint _n_number_seq;
	gint _n_prefix;
	gint _n_suffix;
};

struct _Block13Data {
	int _ref_count_;
	FilesRenamerDialog* self;
	GtkPopover* mod_popover;
	FilesRenamerModifier* mod;
};

struct _Block14Data {
	int _ref_count_;
	FilesRenamerDialog* self;
	GtkRevealer* replacement_entry_revealer;
	GtkRadioButton* name_check;
	GtkRadioButton* created_check;
	GtkRadioButton* modified_check;
	GtkRadioButton* size_check;
};

static gint FilesRenamerDialog_private_offset;
static gpointer files_renamer_dialog_parent_class = NULL;

VALA_EXTERN GType files_renamer_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerDialog, g_object_unref)
VALA_EXTERN GType files_renamer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamer, g_object_unref)
VALA_EXTERN GType files_renamer_dialog_rename_base_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* files_renamer_dialog_rename_base_to_string (FilesRenamerDialogRenameBase self);
static void files_renamer_dialog_on_action_add_text (FilesRenamerDialog* self,
                                              GSimpleAction* action,
                                              GVariant* target);
static void _files_renamer_dialog_on_action_add_text_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void files_renamer_dialog_on_action_add_number (FilesRenamerDialog* self,
                                                GSimpleAction* action,
                                                GVariant* target);
static void _files_renamer_dialog_on_action_add_number_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void files_renamer_dialog_on_action_add_date (FilesRenamerDialog* self,
                                              GSimpleAction* action,
                                              GVariant* target);
static void _files_renamer_dialog_on_action_add_date_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
VALA_EXTERN FilesRenamerDialog* files_renamer_dialog_new (GList* files,
                                              const gchar* basename);
VALA_EXTERN FilesRenamerDialog* files_renamer_dialog_construct (GType object_type,
                                                    GList* files,
                                                    const gchar* basename);
VALA_EXTERN void files_renamer_add_files (FilesRenamer* self,
                              GList* files);
VALA_EXTERN void files_renamer_dialog_schedule_view_update (FilesRenamerDialog* self);
VALA_EXTERN GType files_renamer_modifier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerModifier, g_object_unref)
static void files_renamer_dialog_add_modifier (FilesRenamerDialog* self,
                                        FilesRenamerModifier* mod);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
VALA_EXTERN FilesRenamePosition files_renamer_modifier_get_pos (FilesRenamerModifier* self);
VALA_EXTERN gint files_renamer_dialog_get_n_prefix (FilesRenamerDialog* self);
static void files_renamer_dialog_set_n_prefix (FilesRenamerDialog* self,
                                        gint value);
VALA_EXTERN gint files_renamer_dialog_get_n_suffix (FilesRenamerDialog* self);
static void files_renamer_dialog_set_n_suffix (FilesRenamerDialog* self,
                                        gint value);
VALA_EXTERN FilesRenameMode files_renamer_modifier_get_mode (FilesRenamerModifier* self);
VALA_EXTERN gint files_renamer_dialog_get_n_number_seq (FilesRenamerDialog* self);
static void files_renamer_dialog_set_n_number_seq (FilesRenamerDialog* self,
                                            gint value);
VALA_EXTERN GeeArrayList* files_renamer_get_modifier_chain (FilesRenamer* self);
VALA_EXTERN GtkWidget* files_renamer_modifier_get_modifier_widget (FilesRenamerModifier* self);
static void __lambda96_ (Block13Data* _data13_);
static void ___lambda96__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda97_ (Block13Data* _data13_);
static void files_renamer_dialog_delete_modifier (FilesRenamerDialog* self,
                                           FilesRenamerModifier* mod);
static void ___lambda97__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda98_ (Block13Data* _data13_);
VALA_EXTERN void files_renamer_modifier_cancel_edit (FilesRenamerModifier* self);
static void ___lambda98__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda99_ (Block13Data* _data13_,
                      GdkEventKey* event);
static gboolean ___lambda99__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static void __lambda100_ (FilesRenamerDialog* self);
static void ___lambda100__gtk_popover_closed (GtkPopover* _sender,
                                       gpointer self);
VALA_EXTERN gchar* files_renamer_modifier_get_button_text (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_schedule_update (FilesRenamer* self,
                                    const gchar* custom_basename,
                                    const gchar* replacement_text);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new_default_number (FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct_default_number (GType object_type,
                                                                       FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new_default_date (FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct_default_date (GType object_type,
                                                                     FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new_default_text (FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct_default_text (GType object_type,
                                                                     FilesRenamePosition pos);
static GObject * files_renamer_dialog_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN FilesRenamer* files_renamer_new (void);
VALA_EXTERN FilesRenamer* files_renamer_construct (GType object_type);
VALA_EXTERN GtkListBox* files_renamer_get_listbox (FilesRenamer* self);
static void _files_renamer_dialog___lambda101_ (Block14Data* _data14_);
static void __files_renamer_dialog___lambda101__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self);
static void _files_renamer_dialog___lambda102_ (Block14Data* _data14_);
static void __files_renamer_dialog___lambda102__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self);
static void _files_renamer_dialog___lambda103_ (Block14Data* _data14_);
static void __files_renamer_dialog___lambda103__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self);
static void _files_renamer_dialog___lambda104_ (FilesRenamerDialog* self);
static void __files_renamer_dialog___lambda104__gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
static void _files_renamer_dialog___lambda105_ (FilesRenamerDialog* self);
static void __files_renamer_dialog___lambda105__gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
static void _files_renamer_dialog___lambda106_ (FilesRenamerDialog* self,
                                         gint response_id);
VALA_EXTERN gboolean files_renamer_get_can_rename (FilesRenamer* self);
VALA_EXTERN void files_renamer_rename_files (FilesRenamer* self);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void __files_renamer_dialog___lambda106__gtk_dialog_response (GtkDialog* _sender,
                                                              gint response_id,
                                                              gpointer self);
static void _files_renamer_dialog___lambda107_ (Block14Data* _data14_);
static void __files_renamer_dialog___lambda107__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _files_renamer_dialog___lambda108_ (Block14Data* _data14_);
VALA_EXTERN void files_renamer_set_sortby (FilesRenamer* self,
                               FilesSortBy value);
static void __files_renamer_dialog___lambda108__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self);
static void files_renamer_dialog_finalize (GObject * obj);
static GType files_renamer_dialog_get_type_once (void);
static void _vala_files_renamer_dialog_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_files_renamer_dialog_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static const GActionEntry FILES_RENAMER_DIALOG_ACTION_ENTRIES[3] = {{"add-text", _files_renamer_dialog_on_action_add_text_gsimple_action_activate_callback, "u"}, {"add-number", _files_renamer_dialog_on_action_add_number_gsimple_action_activate_callback, "u"}, {"add-date", _files_renamer_dialog_on_action_add_date_gsimple_action_activate_callback, "u"}};

static inline gpointer
files_renamer_dialog_get_instance_private (FilesRenamerDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FilesRenamerDialog_private_offset);
}

gchar*
files_renamer_dialog_rename_base_to_string (FilesRenamerDialogRenameBase self)
{
	gchar* result;
	switch (self) {
		case FILES_RENAMER_DIALOG_RENAME_BASE_ORIGINAL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Original filename"));
			result = _tmp0_;
			return result;
		}
		case FILES_RENAMER_DIALOG_RENAME_BASE_REPLACE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Modified original"));
			result = _tmp1_;
			return result;
		}
		case FILES_RENAMER_DIALOG_RENAME_BASE_CUSTOM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("New basename"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
files_renamer_dialog_rename_base_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_RENAMER_DIALOG_RENAME_BASE_ORIGINAL, "FILES_RENAMER_DIALOG_RENAME_BASE_ORIGINAL", "original"}, {FILES_RENAMER_DIALOG_RENAME_BASE_REPLACE, "FILES_RENAMER_DIALOG_RENAME_BASE_REPLACE", "replace"}, {FILES_RENAMER_DIALOG_RENAME_BASE_CUSTOM, "FILES_RENAMER_DIALOG_RENAME_BASE_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType files_renamer_dialog_rename_base_type_id;
	files_renamer_dialog_rename_base_type_id = g_enum_register_static ("FilesRenamerDialogRenameBase", values);
	return files_renamer_dialog_rename_base_type_id;
}

GType
files_renamer_dialog_rename_base_get_type (void)
{
	static volatile gsize files_renamer_dialog_rename_base_type_id__once = 0;
	if (g_once_init_enter (&files_renamer_dialog_rename_base_type_id__once)) {
		GType files_renamer_dialog_rename_base_type_id;
		files_renamer_dialog_rename_base_type_id = files_renamer_dialog_rename_base_get_type_once ();
		g_once_init_leave (&files_renamer_dialog_rename_base_type_id__once, files_renamer_dialog_rename_base_type_id);
	}
	return files_renamer_dialog_rename_base_type_id__once;
}

static void
_files_renamer_dialog_on_action_add_text_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	files_renamer_dialog_on_action_add_text ((FilesRenamerDialog*) self, action, parameter);
}

static void
_files_renamer_dialog_on_action_add_number_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	files_renamer_dialog_on_action_add_number ((FilesRenamerDialog*) self, action, parameter);
}

static void
_files_renamer_dialog_on_action_add_date_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	files_renamer_dialog_on_action_add_date ((FilesRenamerDialog*) self, action, parameter);
}

FilesRenamerDialog*
files_renamer_dialog_construct (GType object_type,
                                GList* files,
                                const gchar* basename)
{
	FilesRenamerDialog * self = NULL;
	FilesRenamer* _tmp0_;
	self = (FilesRenamerDialog*) granite_dialog_construct (object_type);
	_tmp0_ = self->priv->renamer;
	files_renamer_add_files (_tmp0_, files);
	files_renamer_dialog_schedule_view_update (self);
	return self;
}

FilesRenamerDialog*
files_renamer_dialog_new (GList* files,
                          const gchar* basename)
{
	return files_renamer_dialog_construct (FILES_TYPE_RENAMER_DIALOG, files, basename);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		FilesRenamerDialog* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->mod_popover);
		_g_object_unref0 (_data13_->mod);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda96_ (Block13Data* _data13_)
{
	FilesRenamerDialog* self;
	GtkPopover* _tmp0_;
	self = _data13_->self;
	_tmp0_ = _data13_->mod_popover;
	gtk_popover_popdown (_tmp0_);
}

static void
___lambda96__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda96_ (self);
}

static void
__lambda97_ (Block13Data* _data13_)
{
	FilesRenamerDialog* self;
	GtkPopover* _tmp0_;
	self = _data13_->self;
	_tmp0_ = _data13_->mod_popover;
	gtk_popover_popdown (_tmp0_);
	files_renamer_dialog_delete_modifier (self, _data13_->mod);
}

static void
___lambda97__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda97_ (self);
}

static void
__lambda98_ (Block13Data* _data13_)
{
	FilesRenamerDialog* self;
	GtkPopover* _tmp0_;
	self = _data13_->self;
	files_renamer_modifier_cancel_edit (_data13_->mod);
	_tmp0_ = _data13_->mod_popover;
	gtk_popover_popdown (_tmp0_);
}

static void
___lambda98__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda98_ (self);
}

static gboolean
__lambda99_ (Block13Data* _data13_,
             GdkEventKey* event)
{
	FilesRenamerDialog* self;
	gboolean result;
	self = _data13_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Return:
		case GDK_KEY_KP_Enter:
		{
			GtkPopover* _tmp0_;
			_tmp0_ = _data13_->mod_popover;
			gtk_popover_popdown (_tmp0_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			GtkPopover* _tmp1_;
			files_renamer_modifier_cancel_edit (_data13_->mod);
			_tmp1_ = _data13_->mod_popover;
			gtk_popover_popdown (_tmp1_);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
___lambda99__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda99_ (self, event);
	return result;
}

static void
__lambda100_ (FilesRenamerDialog* self)
{
	files_renamer_dialog_schedule_view_update (self);
}

static void
___lambda100__gtk_popover_closed (GtkPopover* _sender,
                                  gpointer self)
{
	__lambda100_ ((FilesRenamerDialog*) self);
}

static void
files_renamer_dialog_add_modifier (FilesRenamerDialog* self,
                                   FilesRenamerModifier* mod)
{
	Block13Data* _data13_;
	FilesRenamerModifier* _tmp0_;
	FilesRenamePosition _tmp1_;
	FilesRenamePosition _tmp2_;
	FilesRenameMode _tmp9_;
	FilesRenameMode _tmp10_;
	FilesRenamer* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GtkButton* apply_button = NULL;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp18_;
	GtkButton* delete_button = NULL;
	GtkButton* _tmp19_;
	GtkActionBar* button_box = NULL;
	GtkActionBar* _tmp20_;
	GtkActionBar* _tmp21_;
	GtkButton* _tmp22_;
	GtkActionBar* _tmp23_;
	GtkButton* _tmp24_;
	GtkActionBar* _tmp25_;
	GtkButton* _tmp26_;
	GtkActionBar* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkBox* edit_box = NULL;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_;
	GtkBox* _tmp33_;
	GtkActionBar* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkWidget* _tmp37_;
	GtkPopover* _tmp38_ = NULL;
	GtkMenuButton* mod_button = NULL;
	GtkImage* _tmp39_;
	FilesRenameMode _tmp40_;
	FilesRenameMode _tmp41_;
	gchar* _tmp42_;
	GtkPopover* _tmp43_;
	GtkPopover* _tmp44_;
	GtkMenuButton* _tmp45_ = NULL;
	GtkMenuButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* _tmp50_;
	GtkPopover* _tmp51_;
	GtkPopover* _tmp52_;
	FilesRenamePosition _tmp53_;
	FilesRenamePosition _tmp54_;
	GtkGrid* _tmp61_;
	GtkGrid* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mod != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (mod);
	_g_object_unref0 (_data13_->mod);
	_data13_->mod = _tmp0_;
	_tmp1_ = files_renamer_modifier_get_pos (_data13_->mod);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FILES_RENAME_POSITION_PREFIX) {
		GtkRevealer* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->prefix_revealer;
		_tmp4_ = self->priv->_n_prefix;
		_tmp4_ = _tmp4_ + 1;
		_tmp5_ = _tmp4_;
		files_renamer_dialog_set_n_prefix (self, _tmp5_);
		gtk_revealer_set_reveal_child (_tmp3_, _tmp5_ < FILES_RENAMER_DIALOG_MAX_PREFIX);
	} else {
		GtkRevealer* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->suffix_revealer;
		_tmp7_ = self->priv->_n_suffix;
		_tmp7_ = _tmp7_ + 1;
		_tmp8_ = _tmp7_;
		files_renamer_dialog_set_n_suffix (self, _tmp8_);
		gtk_revealer_set_reveal_child (_tmp6_, _tmp8_ < FILES_RENAMER_DIALOG_MAX_SUFFIX);
	}
	_tmp9_ = files_renamer_modifier_get_mode (_data13_->mod);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == FILES_RENAME_MODE_NUMBER_SEQUENCE) {
		gint _tmp11_;
		_tmp11_ = self->priv->_n_number_seq;
		files_renamer_dialog_set_n_number_seq (self, _tmp11_ + 1);
	}
	_tmp12_ = self->priv->renamer;
	_tmp13_ = files_renamer_get_modifier_chain (_tmp12_);
	_tmp14_ = _tmp13_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _data13_->mod);
	_tmp15_ = (GtkButton*) gtk_button_new_with_label (_ ("Apply"));
	g_object_ref_sink (_tmp15_);
	apply_button = _tmp15_;
	_tmp16_ = apply_button;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp18_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp18_);
	cancel_button = _tmp18_;
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("Delete"));
	g_object_ref_sink (_tmp19_);
	delete_button = _tmp19_;
	_tmp20_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp20_);
	button_box = _tmp20_;
	_tmp21_ = button_box;
	_tmp22_ = delete_button;
	gtk_action_bar_pack_start (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = button_box;
	_tmp24_ = apply_button;
	gtk_action_bar_pack_end (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = button_box;
	_tmp26_ = cancel_button;
	gtk_action_bar_pack_end (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = button_box;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, GTK_STYLE_CLASS_FLAT);
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp29_);
	edit_box = _tmp29_;
	_tmp30_ = edit_box;
	_tmp31_ = files_renamer_modifier_get_modifier_widget (_data13_->mod);
	_tmp32_ = _tmp31_;
	gtk_box_pack_start (_tmp30_, _tmp32_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = edit_box;
	_tmp34_ = button_box;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
	_tmp35_ = edit_box;
	gtk_widget_show_all ((GtkWidget*) _tmp35_);
	_tmp36_ = edit_box;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	_tmp38_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_set ((GtkContainer*) _tmp38_, "child", _tmp37_, NULL);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	_data13_->mod_popover = _tmp38_;
	_tmp39_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp39_);
	_tmp40_ = files_renamer_modifier_get_mode (_data13_->mod);
	_tmp41_ = _tmp40_;
	_tmp42_ = files_rename_mode_to_string (_tmp41_);
	_tmp43_ = _data13_->mod_popover;
	_tmp44_ = _g_object_ref0 (_tmp43_);
	_tmp45_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_always_show_image ((GtkButton*) _tmp45_, TRUE);
	gtk_button_set_image ((GtkButton*) _tmp45_, (GtkWidget*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	gtk_button_set_image_position ((GtkButton*) _tmp45_, GTK_POS_RIGHT);
	gtk_button_set_label ((GtkButton*) _tmp45_, _tmp42_);
	_g_free0 (_tmp42_);
	gtk_menu_button_set_popover (_tmp45_, _tmp44_);
	_g_object_unref0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	mod_button = _tmp45_;
	_tmp46_ = mod_button;
	_tmp47_ = _g_object_ref0 ((GtkButton*) _tmp46_);
	g_object_set_data_full ((GObject*) _data13_->mod, "button", _tmp47_, g_object_unref);
	_tmp48_ = apply_button;
	g_signal_connect_data (_tmp48_, "clicked", (GCallback) ___lambda96__gtk_button_clicked, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp49_ = delete_button;
	g_signal_connect_data (_tmp49_, "clicked", (GCallback) ___lambda97__gtk_button_clicked, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp50_ = cancel_button;
	g_signal_connect_data (_tmp50_, "clicked", (GCallback) ___lambda98__gtk_button_clicked, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp51_ = _data13_->mod_popover;
	g_signal_connect_data ((GtkWidget*) _tmp51_, "key-press-event", (GCallback) ___lambda99__gtk_widget_key_press_event, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp52_ = _data13_->mod_popover;
	g_signal_connect_object (_tmp52_, "closed", (GCallback) ___lambda100__gtk_popover_closed, self, 0);
	_tmp53_ = files_renamer_modifier_get_pos (_data13_->mod);
	_tmp54_ = _tmp53_;
	if (_tmp54_ == FILES_RENAME_POSITION_PREFIX) {
		GtkBox* _tmp55_;
		GtkMenuButton* _tmp56_;
		_tmp55_ = self->priv->prefix_box;
		_tmp56_ = mod_button;
		gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	} else {
		GtkBox* _tmp57_;
		GtkMenuButton* _tmp58_;
		GtkBox* _tmp59_;
		GtkRevealer* _tmp60_;
		_tmp57_ = self->priv->suffix_box;
		_tmp58_ = mod_button;
		gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
		_tmp59_ = self->priv->suffix_box;
		_tmp60_ = self->priv->suffix_revealer;
		gtk_box_reorder_child (_tmp59_, (GtkWidget*) _tmp60_, -1);
	}
	_tmp61_ = self->priv->controls_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp61_);
	_tmp62_ = self->priv->controls_grid;
	gtk_widget_queue_draw ((GtkWidget*) _tmp62_);
	files_renamer_dialog_schedule_view_update (self);
	_g_object_unref0 (mod_button);
	_g_object_unref0 (edit_box);
	_g_object_unref0 (button_box);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (apply_button);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
files_renamer_dialog_delete_modifier (FilesRenamerDialog* self,
                                      FilesRenamerModifier* mod)
{
	FilesRenamePosition _tmp0_;
	FilesRenamePosition _tmp1_;
	FilesRenameMode _tmp8_;
	FilesRenameMode _tmp9_;
	FilesRenamer* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GtkButton* button = NULL;
	gconstpointer _tmp14_;
	GtkButton* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mod != NULL);
	_tmp0_ = files_renamer_modifier_get_pos (mod);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FILES_RENAME_POSITION_PREFIX) {
		GtkRevealer* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->prefix_revealer;
		_tmp3_ = self->priv->_n_prefix;
		_tmp3_ = _tmp3_ - 1;
		_tmp4_ = _tmp3_;
		files_renamer_dialog_set_n_prefix (self, _tmp4_);
		gtk_revealer_set_reveal_child (_tmp2_, _tmp4_ < FILES_RENAMER_DIALOG_MAX_PREFIX);
	} else {
		GtkRevealer* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->suffix_revealer;
		_tmp6_ = self->priv->_n_suffix;
		_tmp6_ = _tmp6_ - 1;
		_tmp7_ = _tmp6_;
		files_renamer_dialog_set_n_suffix (self, _tmp7_);
		gtk_revealer_set_reveal_child (_tmp5_, _tmp7_ < FILES_RENAMER_DIALOG_MAX_SUFFIX);
	}
	_tmp8_ = files_renamer_modifier_get_mode (mod);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == FILES_RENAME_MODE_NUMBER_SEQUENCE) {
		gint _tmp10_;
		_tmp10_ = self->priv->_n_number_seq;
		files_renamer_dialog_set_n_number_seq (self, _tmp10_ - 1);
	}
	_tmp11_ = self->priv->renamer;
	_tmp12_ = files_renamer_get_modifier_chain (_tmp11_);
	_tmp13_ = _tmp12_;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp13_, mod);
	_tmp14_ = g_object_get_data ((GObject*) mod, "button");
	_tmp15_ = _g_object_ref0 ((GtkButton*) _tmp14_);
	button = _tmp15_;
	gtk_widget_destroy ((GtkWidget*) button);
	files_renamer_dialog_schedule_view_update (self);
	_g_object_unref0 (button);
	return;
}

void
files_renamer_dialog_schedule_view_update (FilesRenamerDialog* self)
{
	const gchar* _tmp17_ = NULL;
	GtkRadioButton* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gchar* custom_basename = NULL;
	gchar* _tmp24_;
	const gchar* _tmp25_ = NULL;
	GtkRadioButton* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gchar* replacement_text = NULL;
	gchar* _tmp32_;
	FilesRenamer* _tmp33_;
	const gchar* _tmp34_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _mod_list = NULL;
		FilesRenamer* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _mod_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _mod_index = 0;
		_tmp0_ = self->priv->renamer;
		_tmp1_ = files_renamer_get_modifier_chain (_tmp0_);
		_tmp2_ = _tmp1_;
		_mod_list = _tmp2_;
		_tmp3_ = _mod_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_mod_size = _tmp5_;
		_mod_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			FilesRenamerModifier* mod = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GtkButton* button = NULL;
			FilesRenamerModifier* _tmp10_;
			gconstpointer _tmp11_;
			GtkButton* _tmp12_;
			GtkButton* _tmp13_;
			FilesRenamerModifier* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_mod_index = _mod_index + 1;
			_tmp6_ = _mod_index;
			_tmp7_ = _mod_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _mod_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _mod_index);
			mod = (FilesRenamerModifier*) _tmp9_;
			_tmp10_ = mod;
			_tmp11_ = g_object_get_data ((GObject*) _tmp10_, "button");
			_tmp12_ = _g_object_ref0 ((GtkButton*) _tmp11_);
			button = _tmp12_;
			_tmp13_ = button;
			_tmp14_ = mod;
			_tmp15_ = files_renamer_modifier_get_button_text (_tmp14_);
			_tmp16_ = _tmp15_;
			gtk_button_set_label (_tmp13_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_object_unref0 (button);
			_g_object_unref0 (mod);
		}
	}
	_tmp18_ = self->priv->original_basename_toggle;
	_tmp19_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		_tmp17_ = NULL;
	} else {
		GtkEntry* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = self->priv->basename_entry;
		_tmp22_ = gtk_entry_get_text (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	}
	_tmp24_ = g_strdup (_tmp17_);
	custom_basename = _tmp24_;
	_tmp26_ = self->priv->modify_basename_toggle;
	_tmp27_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		GtkEntry* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp29_ = self->priv->replacement_entry;
		_tmp30_ = gtk_entry_get_text (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp25_ = _tmp31_;
	} else {
		_tmp25_ = NULL;
	}
	_tmp32_ = g_strdup (_tmp25_);
	replacement_text = _tmp32_;
	_tmp33_ = self->priv->renamer;
	_tmp34_ = custom_basename;
	files_renamer_schedule_update (_tmp33_, _tmp34_, replacement_text);
	_g_free0 (replacement_text);
	_g_free0 (custom_basename);
}

static void
files_renamer_dialog_on_action_add_number (FilesRenamerDialog* self,
                                           GSimpleAction* action,
                                           GVariant* target)
{
	FilesRenamePosition pos = 0;
	FilesRenamerModifier* mod = NULL;
	FilesRenamerModifier* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pos = (FilesRenamePosition) g_variant_get_uint32 (target);
	_tmp0_ = files_renamer_modifier_new_default_number (pos);
	mod = _tmp0_;
	files_renamer_dialog_add_modifier (self, mod);
	_g_object_unref0 (mod);
}

static void
files_renamer_dialog_on_action_add_date (FilesRenamerDialog* self,
                                         GSimpleAction* action,
                                         GVariant* target)
{
	FilesRenamePosition pos = 0;
	FilesRenamerModifier* mod = NULL;
	FilesRenamerModifier* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pos = (FilesRenamePosition) g_variant_get_uint32 (target);
	_tmp0_ = files_renamer_modifier_new_default_date (pos);
	mod = _tmp0_;
	files_renamer_dialog_add_modifier (self, mod);
	_g_object_unref0 (mod);
}

static void
files_renamer_dialog_on_action_add_text (FilesRenamerDialog* self,
                                         GSimpleAction* action,
                                         GVariant* target)
{
	FilesRenamePosition pos = 0;
	FilesRenamerModifier* mod = NULL;
	FilesRenamerModifier* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pos = (FilesRenamePosition) g_variant_get_uint32 (target);
	_tmp0_ = files_renamer_modifier_new_default_text (pos);
	mod = _tmp0_;
	files_renamer_dialog_add_modifier (self, mod);
	_g_object_unref0 (mod);
}

gint
files_renamer_dialog_get_n_number_seq (FilesRenamerDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_number_seq;
	return result;
}

static void
files_renamer_dialog_set_n_number_seq (FilesRenamerDialog* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_dialog_get_n_number_seq (self);
	if (old_value != value) {
		self->priv->_n_number_seq = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_dialog_properties[FILES_RENAMER_DIALOG_N_NUMBER_SEQ_PROPERTY]);
	}
}

gint
files_renamer_dialog_get_n_prefix (FilesRenamerDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_prefix;
	return result;
}

static void
files_renamer_dialog_set_n_prefix (FilesRenamerDialog* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_dialog_get_n_prefix (self);
	if (old_value != value) {
		self->priv->_n_prefix = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_dialog_properties[FILES_RENAMER_DIALOG_N_PREFIX_PROPERTY]);
	}
}

gint
files_renamer_dialog_get_n_suffix (FilesRenamerDialog* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_suffix;
	return result;
}

static void
files_renamer_dialog_set_n_suffix (FilesRenamerDialog* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_dialog_get_n_suffix (self);
	if (old_value != value) {
		self->priv->_n_suffix = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_dialog_properties[FILES_RENAMER_DIALOG_N_SUFFIX_PROPERTY]);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		FilesRenamerDialog* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->size_check);
		_g_object_unref0 (_data14_->modified_check);
		_g_object_unref0 (_data14_->created_check);
		_g_object_unref0 (_data14_->name_check);
		_g_object_unref0 (_data14_->replacement_entry_revealer);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_files_renamer_dialog___lambda101_ (Block14Data* _data14_)
{
	FilesRenamerDialog* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data14_->self;
	_tmp0_ = self->priv->original_basename_toggle;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkEntry* _tmp3_;
		GtkEntry* _tmp4_;
		GtkRevealer* _tmp5_;
		_tmp3_ = self->priv->basename_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->basename_entry;
		gtk_entry_set_text (_tmp4_, _ ("Original Basename"));
		_tmp5_ = _data14_->replacement_entry_revealer;
		gtk_revealer_set_reveal_child (_tmp5_, FALSE);
		files_renamer_dialog_schedule_view_update (self);
	}
}

static void
__files_renamer_dialog___lambda101__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                               gpointer self)
{
	_files_renamer_dialog___lambda101_ (self);
}

static void
_files_renamer_dialog___lambda102_ (Block14Data* _data14_)
{
	FilesRenamerDialog* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data14_->self;
	_tmp0_ = self->priv->new_basename_toggle;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkEntry* _tmp3_;
		GtkEntry* _tmp4_;
		GtkEntry* _tmp5_;
		GtkRevealer* _tmp6_;
		_tmp3_ = self->priv->basename_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->basename_entry;
		gtk_entry_set_text (_tmp4_, "");
		_tmp5_ = self->priv->basename_entry;
		gtk_entry_set_placeholder_text (_tmp5_, _ ("New basename"));
		_tmp6_ = _data14_->replacement_entry_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, FALSE);
		files_renamer_dialog_schedule_view_update (self);
	}
}

static void
__files_renamer_dialog___lambda102__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                               gpointer self)
{
	_files_renamer_dialog___lambda102_ (self);
}

static void
_files_renamer_dialog___lambda103_ (Block14Data* _data14_)
{
	FilesRenamerDialog* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data14_->self;
	_tmp0_ = self->priv->modify_basename_toggle;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkEntry* _tmp3_;
		GtkEntry* _tmp4_;
		GtkEntry* _tmp5_;
		GtkRevealer* _tmp6_;
		_tmp3_ = self->priv->basename_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->basename_entry;
		gtk_entry_set_text (_tmp4_, "");
		_tmp5_ = self->priv->basename_entry;
		gtk_entry_set_placeholder_text (_tmp5_, _ ("Text to be replaced"));
		_tmp6_ = _data14_->replacement_entry_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, TRUE);
		files_renamer_dialog_schedule_view_update (self);
	}
}

static void
__files_renamer_dialog___lambda103__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                               gpointer self)
{
	_files_renamer_dialog___lambda103_ (self);
}

static void
_files_renamer_dialog___lambda104_ (FilesRenamerDialog* self)
{
	files_renamer_dialog_schedule_view_update (self);
}

static void
__files_renamer_dialog___lambda104__gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	_files_renamer_dialog___lambda104_ ((FilesRenamerDialog*) self);
}

static void
_files_renamer_dialog___lambda105_ (FilesRenamerDialog* self)
{
	files_renamer_dialog_schedule_view_update (self);
}

static void
__files_renamer_dialog___lambda105__gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	_files_renamer_dialog___lambda105_ ((FilesRenamerDialog*) self);
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
_files_renamer_dialog___lambda106_ (FilesRenamerDialog* self,
                                    gint response_id)
{
	GError* _inner_error0_ = NULL;
	if (response_id == ((gint) GTK_RESPONSE_APPLY)) {
		FilesRenamer* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->renamer;
		_tmp1_ = files_renamer_get_can_rename (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			{
				FilesRenamer* _tmp3_;
				_tmp3_ = self->priv->renamer;
				files_renamer_rename_files (_tmp3_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GraniteMessageDialog* dlg = NULL;
				GError* _tmp4_;
				const gchar* _tmp5_;
				GThemedIcon* _tmp6_;
				GThemedIcon* _tmp7_;
				GraniteMessageDialog* _tmp8_;
				GraniteMessageDialog* _tmp9_;
				GraniteMessageDialog* _tmp10_;
				GraniteMessageDialog* _tmp11_;
				GraniteMessageDialog* _tmp12_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp4_ = e;
				_tmp5_ = _tmp4_->message;
				_tmp6_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
				_tmp7_ = _tmp6_;
				_tmp8_ = granite_message_dialog_new ("Error renaming files", _tmp5_, (GIcon*) _tmp7_, GTK_BUTTONS_CLOSE);
				g_object_ref_sink (_tmp8_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				dlg = _tmp9_;
				_tmp10_ = dlg;
				gtk_window_present ((GtkWindow*) _tmp10_);
				_tmp11_ = dlg;
				_tmp12_ = dlg;
				g_signal_connect_object ((GtkDialog*) _tmp11_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp12_, 0);
				_g_object_unref0 (dlg);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	g_signal_emit_by_name ((GtkDialog*) self, "close");
}

static void
__files_renamer_dialog___lambda106__gtk_dialog_response (GtkDialog* _sender,
                                                         gint response_id,
                                                         gpointer self)
{
	_files_renamer_dialog___lambda106_ ((FilesRenamerDialog*) self, response_id);
}

static void
_files_renamer_dialog___lambda107_ (Block14Data* _data14_)
{
	FilesRenamerDialog* self;
	GtkRevealer* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data14_->self;
	_tmp0_ = self->priv->sortby_revealer;
	_tmp1_ = self->priv->_n_number_seq;
	gtk_revealer_set_reveal_child (_tmp0_, _tmp1_ > 0);
	_tmp2_ = self->priv->_n_number_seq;
	if (_tmp2_ == 0) {
		GtkRadioButton* _tmp3_;
		_tmp3_ = _data14_->name_check;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
	}
}

static void
__files_renamer_dialog___lambda107__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_files_renamer_dialog___lambda107_ (self);
}

static void
_files_renamer_dialog___lambda108_ (Block14Data* _data14_)
{
	FilesRenamerDialog* self;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data14_->self;
	_tmp0_ = _data14_->size_check;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		FilesRenamer* _tmp3_;
		_tmp3_ = self->priv->renamer;
		files_renamer_set_sortby (_tmp3_, FILES_SORT_BY_SIZE);
	} else {
		GtkRadioButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = _data14_->created_check;
		_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			FilesRenamer* _tmp7_;
			_tmp7_ = self->priv->renamer;
			files_renamer_set_sortby (_tmp7_, FILES_SORT_BY_CREATED);
		} else {
			GtkRadioButton* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = _data14_->modified_check;
			_tmp9_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				FilesRenamer* _tmp11_;
				_tmp11_ = self->priv->renamer;
				files_renamer_set_sortby (_tmp11_, FILES_SORT_BY_MODIFIED);
			} else {
				FilesRenamer* _tmp12_;
				_tmp12_ = self->priv->renamer;
				files_renamer_set_sortby (_tmp12_, FILES_SORT_BY_NAME);
			}
		}
	}
}

static void
__files_renamer_dialog___lambda108__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                               gpointer self)
{
	_files_renamer_dialog___lambda108_ (self);
}

static GObject *
files_renamer_dialog_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesRenamerDialog * self;
	Block14Data* _data14_;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	FilesRenamer* _tmp3_;
	GtkWidget* cancel_button = NULL;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* rename_button = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkStyleContext* _tmp9_;
	FilesRenamer* _tmp10_;
	GtkWidget* _tmp11_;
	GVariant* prefix_var = NULL;
	GVariant* _tmp12_;
	GMenu* prefix_menumodel = NULL;
	GMenu* _tmp13_;
	GMenu* _tmp14_;
	GVariant* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GMenu* _tmp18_;
	GVariant* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GMenu* _tmp22_;
	GVariant* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GVariant* suffix_var = NULL;
	GVariant* _tmp26_;
	GMenu* suffix_menumodel = NULL;
	GMenu* _tmp27_;
	GMenu* _tmp28_;
	GVariant* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GMenu* _tmp32_;
	GVariant* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GMenu* _tmp36_;
	GVariant* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkBox* prefix_button_box = NULL;
	GtkBox* _tmp40_;
	GtkBox* _tmp41_;
	GtkImage* _tmp42_;
	GtkImage* _tmp43_;
	GtkBox* _tmp44_;
	GtkLabel* _tmp45_;
	GtkLabel* _tmp46_;
	GtkMenuButton* prefix_button = NULL;
	GtkBox* _tmp47_;
	GtkWidget* _tmp48_;
	GMenu* _tmp49_;
	GMenuModel* _tmp50_;
	GtkMenuButton* _tmp51_ = NULL;
	GtkMenuButton* _tmp52_;
	GtkWidget* _tmp53_;
	GtkRevealer* _tmp54_ = NULL;
	GtkBox* _tmp55_;
	GtkBox* _tmp56_;
	GtkRevealer* _tmp57_;
	GtkBox* suffix_button_box = NULL;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkImage* _tmp60_;
	GtkImage* _tmp61_;
	GtkBox* _tmp62_;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	GtkMenuButton* suffix_button = NULL;
	GtkBox* _tmp65_;
	GtkWidget* _tmp66_;
	GMenu* _tmp67_;
	GMenuModel* _tmp68_;
	GtkMenuButton* _tmp69_ = NULL;
	GtkMenuButton* _tmp70_;
	GtkWidget* _tmp71_;
	GtkRevealer* _tmp72_ = NULL;
	GtkBox* _tmp73_;
	GtkBox* _tmp74_;
	GtkRevealer* _tmp75_;
	GtkLabel* basename_label = NULL;
	GtkLabel* _tmp76_;
	gchar* _tmp77_;
	GtkRadioButton* _tmp78_ = NULL;
	GtkRadioButton* _tmp79_;
	GtkRadioButton* _tmp80_;
	gchar* _tmp81_;
	GtkRadioButton* _tmp82_ = NULL;
	GtkRadioButton* _tmp83_;
	GtkRadioButton* _tmp84_;
	gchar* _tmp85_;
	GtkRadioButton* _tmp86_ = NULL;
	GtkRadioButton* _tmp87_;
	GtkBox* toggle_box = NULL;
	GtkBox* _tmp88_;
	GtkBox* _tmp89_;
	GtkStyleContext* _tmp90_;
	GtkBox* _tmp91_;
	GtkRadioButton* _tmp92_;
	GtkBox* _tmp93_;
	GtkRadioButton* _tmp94_;
	GtkBox* _tmp95_;
	GtkRadioButton* _tmp96_;
	GtkBox* basename_box = NULL;
	GtkBox* _tmp97_ = NULL;
	GtkBox* _tmp98_;
	GtkLabel* _tmp99_;
	GtkBox* _tmp100_;
	GtkBox* _tmp101_;
	gchar* _tmp102_;
	GtkEntry* _tmp103_ = NULL;
	gchar* _tmp104_;
	GtkEntry* _tmp105_ = NULL;
	GtkEntry* _tmp106_;
	GtkWidget* _tmp107_;
	GtkRevealer* _tmp108_ = NULL;
	GtkScrolledWindow* list_scrolled_window = NULL;
	FilesRenamer* _tmp109_;
	GtkListBox* _tmp110_;
	GtkListBox* _tmp111_;
	GtkWidget* _tmp112_;
	GtkScrolledWindow* _tmp113_ = NULL;
	GtkFrame* frame = NULL;
	GtkScrolledWindow* _tmp114_;
	GtkWidget* _tmp115_;
	GtkFrame* _tmp116_ = NULL;
	GtkLabel* sortby_label = NULL;
	GtkLabel* _tmp117_;
	GtkRadioButton* _tmp118_ = NULL;
	GtkRadioButton* _tmp119_;
	GtkRadioButton* _tmp120_ = NULL;
	GtkRadioButton* _tmp121_;
	GtkRadioButton* _tmp122_ = NULL;
	GtkRadioButton* _tmp123_;
	GtkRadioButton* _tmp124_ = NULL;
	GtkBox* sortby_box = NULL;
	GtkBox* _tmp125_ = NULL;
	GtkBox* _tmp126_;
	GtkLabel* _tmp127_;
	GtkBox* _tmp128_;
	GtkRadioButton* _tmp129_;
	GtkBox* _tmp130_;
	GtkRadioButton* _tmp131_;
	GtkBox* _tmp132_;
	GtkRadioButton* _tmp133_;
	GtkBox* _tmp134_;
	GtkRadioButton* _tmp135_;
	GtkBox* _tmp136_;
	GtkWidget* _tmp137_;
	GtkRevealer* _tmp138_ = NULL;
	GtkBox* list_box = NULL;
	GtkBox* _tmp139_;
	GtkBox* _tmp140_;
	GtkRevealer* _tmp141_;
	GtkBox* _tmp142_;
	GtkFrame* _tmp143_;
	GtkGrid* _tmp144_ = NULL;
	GtkGrid* _tmp145_;
	GtkBox* _tmp146_;
	GtkGrid* _tmp147_;
	GtkEntry* _tmp148_;
	GtkGrid* _tmp149_;
	GtkBox* _tmp150_;
	GtkGrid* _tmp151_;
	GtkRevealer* _tmp152_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp153_;
	GtkBox* _tmp154_;
	GtkBox* _tmp155_;
	GtkBox* _tmp156_;
	GtkBox* _tmp157_;
	GtkGrid* _tmp158_;
	GtkBox* _tmp159_;
	GtkBox* _tmp160_;
	GtkBox* _tmp161_;
	GtkBox* _tmp162_;
	GtkBox* _tmp163_;
	GtkBox* _tmp164_;
	GtkRevealer* _tmp165_;
	GtkRadioButton* _tmp166_;
	GtkRadioButton* _tmp167_;
	GtkRadioButton* _tmp168_;
	GtkEntry* _tmp169_;
	GtkEntry* _tmp170_;
	GtkRadioButton* _tmp171_;
	parent_class = G_OBJECT_CLASS (files_renamer_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialog);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp0_;
	_tmp1_ = self->priv->actions;
	g_action_map_add_action_entries ((GActionMap*) _tmp1_, FILES_RENAMER_DIALOG_ACTION_ENTRIES, (gint) G_N_ELEMENTS (FILES_RENAMER_DIALOG_ACTION_ENTRIES), self);
	_tmp2_ = self->priv->actions;
	gtk_widget_insert_action_group ((GtkWidget*) self, "renamer", (GActionGroup*) _tmp2_);
	gtk_window_set_title ((GtkWindow*) self, _ ("Bulk Rename"));
	_tmp3_ = files_renamer_new ();
	_g_object_unref0 (self->priv->renamer);
	self->priv->renamer = _tmp3_;
	_tmp4_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	cancel_button = _tmp5_;
	_tmp6_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Rename"), (gint) GTK_RESPONSE_APPLY);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	rename_button = _tmp7_;
	_tmp8_ = rename_button;
	_tmp9_ = gtk_widget_get_style_context (_tmp8_);
	gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp10_ = self->priv->renamer;
	_tmp11_ = rename_button;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "can-rename", (GObject*) _tmp11_, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp12_ = g_variant_new_uint32 ((guint32) ((guint) FILES_RENAME_POSITION_PREFIX));
	g_variant_ref_sink (_tmp12_);
	prefix_var = _tmp12_;
	_tmp13_ = g_menu_new ();
	prefix_menumodel = _tmp13_;
	_tmp14_ = prefix_menumodel;
	_tmp15_ = prefix_var;
	_tmp16_ = g_action_print_detailed_name ("renamer.add-number", _tmp15_);
	_tmp17_ = _tmp16_;
	g_menu_append (_tmp14_, _ ("Number Sequence"), _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = prefix_menumodel;
	_tmp19_ = prefix_var;
	_tmp20_ = g_action_print_detailed_name ("renamer.add-date", _tmp19_);
	_tmp21_ = _tmp20_;
	g_menu_append (_tmp18_, _ ("Creation Date"), _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = prefix_menumodel;
	_tmp23_ = prefix_var;
	_tmp24_ = g_action_print_detailed_name ("renamer.add-text", _tmp23_);
	_tmp25_ = _tmp24_;
	g_menu_append (_tmp22_, _ ("Fixed Text"), _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = g_variant_new_uint32 ((guint32) ((guint) FILES_RENAME_POSITION_SUFFIX));
	g_variant_ref_sink (_tmp26_);
	suffix_var = _tmp26_;
	_tmp27_ = g_menu_new ();
	suffix_menumodel = _tmp27_;
	_tmp28_ = suffix_menumodel;
	_tmp29_ = suffix_var;
	_tmp30_ = g_action_print_detailed_name ("renamer.add-number", _tmp29_);
	_tmp31_ = _tmp30_;
	g_menu_append (_tmp28_, _ ("Number Sequence"), _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = suffix_menumodel;
	_tmp33_ = suffix_var;
	_tmp34_ = g_action_print_detailed_name ("renamer.add-date", _tmp33_);
	_tmp35_ = _tmp34_;
	g_menu_append (_tmp32_, _ ("Creation Date"), _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = suffix_menumodel;
	_tmp37_ = suffix_var;
	_tmp38_ = g_action_print_detailed_name ("renamer.add-text", _tmp37_);
	_tmp39_ = _tmp38_;
	g_menu_append (_tmp36_, _ ("Fixed Text"), _tmp39_);
	_g_free0 (_tmp39_);
	_tmp40_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp40_);
	prefix_button_box = _tmp40_;
	_tmp41_ = prefix_button_box;
	_tmp42_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = prefix_button_box;
	_tmp45_ = (GtkLabel*) gtk_label_new (_ ("Add Prefix…"));
	g_object_ref_sink (_tmp45_);
	_tmp46_ = _tmp45_;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = prefix_button_box;
	_tmp48_ = _g_object_ref0 ((GtkWidget*) _tmp47_);
	_tmp49_ = prefix_menumodel;
	_tmp50_ = _g_object_ref0 ((GMenuModel*) _tmp49_);
	_tmp51_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_set ((GtkContainer*) _tmp51_, "child", _tmp48_, NULL);
	_g_object_unref0 (_tmp48_);
	gtk_menu_button_set_menu_model (_tmp51_, _tmp50_);
	_g_object_unref0 (_tmp50_);
	gtk_menu_button_set_use_popover (_tmp51_, FALSE);
	g_object_ref_sink (_tmp51_);
	prefix_button = _tmp51_;
	_tmp52_ = prefix_button;
	_tmp53_ = _g_object_ref0 ((GtkWidget*) _tmp52_);
	_tmp54_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp54_, "child", _tmp53_, NULL);
	_g_object_unref0 (_tmp53_);
	gtk_revealer_set_reveal_child (_tmp54_, TRUE);
	gtk_revealer_set_transition_type (_tmp54_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->prefix_revealer);
	self->priv->prefix_revealer = _tmp54_;
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->prefix_box);
	self->priv->prefix_box = _tmp55_;
	_tmp56_ = self->priv->prefix_box;
	_tmp57_ = self->priv->prefix_revealer;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp58_);
	suffix_button_box = _tmp58_;
	_tmp59_ = suffix_button_box;
	_tmp60_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp60_);
	_tmp61_ = _tmp60_;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp61_);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = suffix_button_box;
	_tmp63_ = (GtkLabel*) gtk_label_new (_ ("Add Suffix…"));
	g_object_ref_sink (_tmp63_);
	_tmp64_ = _tmp63_;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = suffix_button_box;
	_tmp66_ = _g_object_ref0 ((GtkWidget*) _tmp65_);
	_tmp67_ = suffix_menumodel;
	_tmp68_ = _g_object_ref0 ((GMenuModel*) _tmp67_);
	_tmp69_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_set ((GtkContainer*) _tmp69_, "child", _tmp66_, NULL);
	_g_object_unref0 (_tmp66_);
	gtk_menu_button_set_menu_model (_tmp69_, _tmp68_);
	_g_object_unref0 (_tmp68_);
	gtk_menu_button_set_use_popover (_tmp69_, FALSE);
	g_object_ref_sink (_tmp69_);
	suffix_button = _tmp69_;
	_tmp70_ = suffix_button;
	_tmp71_ = _g_object_ref0 ((GtkWidget*) _tmp70_);
	_tmp72_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp72_, "child", _tmp71_, NULL);
	_g_object_unref0 (_tmp71_);
	gtk_revealer_set_reveal_child (_tmp72_, TRUE);
	gtk_revealer_set_transition_type (_tmp72_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp72_);
	_g_object_unref0 (self->priv->suffix_revealer);
	self->priv->suffix_revealer = _tmp72_;
	_tmp73_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->suffix_box);
	self->priv->suffix_box = _tmp73_;
	_tmp74_ = self->priv->suffix_box;
	_tmp75_ = self->priv->suffix_revealer;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = (GtkLabel*) gtk_label_new (_ ("Basename:"));
	g_object_ref_sink (_tmp76_);
	basename_label = _tmp76_;
	_tmp77_ = g_strdup (C_ ("bulk-rename", "Keep"));
	_tmp78_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	gtk_button_set_label ((GtkButton*) _tmp78_, _tmp77_);
	_g_free0 (_tmp77_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp78_, TRUE);
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (self->priv->original_basename_toggle);
	self->priv->original_basename_toggle = _tmp78_;
	_tmp79_ = self->priv->original_basename_toggle;
	gtk_toggle_button_set_mode ((GtkToggleButton*) _tmp79_, FALSE);
	_tmp80_ = self->priv->original_basename_toggle;
	_tmp81_ = g_strdup (C_ ("bulk-rename", "Replace"));
	_tmp82_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp80_);
	gtk_button_set_label ((GtkButton*) _tmp82_, _tmp81_);
	_g_free0 (_tmp81_);
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (self->priv->new_basename_toggle);
	self->priv->new_basename_toggle = _tmp82_;
	_tmp83_ = self->priv->new_basename_toggle;
	gtk_toggle_button_set_mode ((GtkToggleButton*) _tmp83_, FALSE);
	_tmp84_ = self->priv->original_basename_toggle;
	_tmp85_ = g_strdup (C_ ("bulk-rename", "Modify"));
	_tmp86_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp84_);
	gtk_button_set_label ((GtkButton*) _tmp86_, _tmp85_);
	_g_free0 (_tmp85_);
	g_object_ref_sink (_tmp86_);
	_g_object_unref0 (self->priv->modify_basename_toggle);
	self->priv->modify_basename_toggle = _tmp86_;
	_tmp87_ = self->priv->modify_basename_toggle;
	gtk_toggle_button_set_mode ((GtkToggleButton*) _tmp87_, FALSE);
	_tmp88_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp88_);
	toggle_box = _tmp88_;
	_tmp89_ = toggle_box;
	_tmp90_ = gtk_widget_get_style_context ((GtkWidget*) _tmp89_);
	gtk_style_context_add_class (_tmp90_, GTK_STYLE_CLASS_LINKED);
	_tmp91_ = toggle_box;
	_tmp92_ = self->priv->original_basename_toggle;
	gtk_container_add ((GtkContainer*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = toggle_box;
	_tmp94_ = self->priv->new_basename_toggle;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = toggle_box;
	_tmp96_ = self->priv->modify_basename_toggle;
	gtk_container_add ((GtkContainer*) _tmp95_, (GtkWidget*) _tmp96_);
	_tmp97_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp97_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp97_, 24);
	g_object_ref_sink (_tmp97_);
	basename_box = _tmp97_;
	_tmp98_ = basename_box;
	_tmp99_ = basename_label;
	gtk_box_pack_start (_tmp98_, (GtkWidget*) _tmp99_, TRUE, TRUE, (guint) 0);
	_tmp100_ = basename_box;
	_tmp101_ = toggle_box;
	gtk_box_pack_end (_tmp100_, (GtkWidget*) _tmp101_, TRUE, TRUE, (guint) 0);
	_tmp102_ = g_strdup (_ ("Original Basename"));
	_tmp103_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp103_, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp103_, FALSE);
	gtk_entry_set_text (_tmp103_, _tmp102_);
	_g_free0 (_tmp102_);
	g_object_ref_sink (_tmp103_);
	_g_object_unref0 (self->priv->basename_entry);
	self->priv->basename_entry = _tmp103_;
	_tmp104_ = g_strdup (_ ("Replacement text"));
	_tmp105_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp105_, 6);
	gtk_entry_set_placeholder_text (_tmp105_, _tmp104_);
	_g_free0 (_tmp104_);
	g_object_ref_sink (_tmp105_);
	_g_object_unref0 (self->priv->replacement_entry);
	self->priv->replacement_entry = _tmp105_;
	_tmp106_ = self->priv->replacement_entry;
	_tmp107_ = _g_object_ref0 ((GtkWidget*) _tmp106_);
	_tmp108_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp108_, "child", _tmp107_, NULL);
	_g_object_unref0 (_tmp107_);
	g_object_ref_sink (_tmp108_);
	_data14_->replacement_entry_revealer = _tmp108_;
	_tmp109_ = self->priv->renamer;
	_tmp110_ = files_renamer_get_listbox (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = _g_object_ref0 ((GtkWidget*) _tmp111_);
	_tmp113_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp113_, "child", _tmp112_, NULL);
	_g_object_unref0 (_tmp112_);
	g_object_set (_tmp113_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_min_content_height (_tmp113_, 200);
	g_object_ref_sink (_tmp113_);
	list_scrolled_window = _tmp113_;
	_tmp114_ = list_scrolled_window;
	_tmp115_ = _g_object_ref0 ((GtkWidget*) _tmp114_);
	_tmp116_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_set ((GtkContainer*) _tmp116_, "child", _tmp115_, NULL);
	_g_object_unref0 (_tmp115_);
	g_object_ref_sink (_tmp116_);
	frame = _tmp116_;
	_tmp117_ = (GtkLabel*) gtk_label_new (_ ("Number in order of:"));
	g_object_ref_sink (_tmp117_);
	sortby_label = _tmp117_;
	_tmp118_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, C_ ("bulk-rename", "Name"));
	gtk_widget_set_margin_start ((GtkWidget*) _tmp118_, 6);
	g_object_ref_sink (_tmp118_);
	_data14_->name_check = _tmp118_;
	_tmp119_ = _data14_->name_check;
	_tmp120_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp119_, C_ ("bulk-rename", "Date created"));
	gtk_widget_set_margin_start ((GtkWidget*) _tmp120_, 6);
	g_object_ref_sink (_tmp120_);
	_data14_->created_check = _tmp120_;
	_tmp121_ = _data14_->name_check;
	_tmp122_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp121_, C_ ("bulk-rename", "Date modified"));
	gtk_widget_set_margin_start ((GtkWidget*) _tmp122_, 6);
	g_object_ref_sink (_tmp122_);
	_data14_->modified_check = _tmp122_;
	_tmp123_ = _data14_->name_check;
	_tmp124_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp123_, C_ ("bulk-rename", "Size"));
	gtk_widget_set_margin_start ((GtkWidget*) _tmp124_, 6);
	g_object_ref_sink (_tmp124_);
	_data14_->size_check = _tmp124_;
	_tmp125_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp125_, 12);
	g_object_ref_sink (_tmp125_);
	sortby_box = _tmp125_;
	_tmp126_ = sortby_box;
	_tmp127_ = sortby_label;
	gtk_box_pack_start (_tmp126_, (GtkWidget*) _tmp127_, TRUE, TRUE, (guint) 0);
	_tmp128_ = sortby_box;
	_tmp129_ = _data14_->name_check;
	gtk_box_pack_start (_tmp128_, (GtkWidget*) _tmp129_, TRUE, TRUE, (guint) 0);
	_tmp130_ = sortby_box;
	_tmp131_ = _data14_->created_check;
	gtk_box_pack_start (_tmp130_, (GtkWidget*) _tmp131_, TRUE, TRUE, (guint) 0);
	_tmp132_ = sortby_box;
	_tmp133_ = _data14_->modified_check;
	gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, TRUE, TRUE, (guint) 0);
	_tmp134_ = sortby_box;
	_tmp135_ = _data14_->size_check;
	gtk_box_pack_start (_tmp134_, (GtkWidget*) _tmp135_, TRUE, TRUE, (guint) 0);
	_tmp136_ = sortby_box;
	_tmp137_ = _g_object_ref0 ((GtkWidget*) _tmp136_);
	_tmp138_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp138_, "child", _tmp137_, NULL);
	_g_object_unref0 (_tmp137_);
	gtk_revealer_set_reveal_child (_tmp138_, FALSE);
	gtk_widget_set_halign ((GtkWidget*) _tmp138_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp138_);
	_g_object_unref0 (self->priv->sortby_revealer);
	self->priv->sortby_revealer = _tmp138_;
	_tmp139_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp139_);
	list_box = _tmp139_;
	_tmp140_ = list_box;
	_tmp141_ = self->priv->sortby_revealer;
	gtk_container_add ((GtkContainer*) _tmp140_, (GtkWidget*) _tmp141_);
	_tmp142_ = list_box;
	_tmp143_ = frame;
	gtk_container_add ((GtkContainer*) _tmp142_, (GtkWidget*) _tmp143_);
	_tmp144_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp144_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp144_, 24);
	g_object_ref_sink (_tmp144_);
	_g_object_unref0 (self->priv->controls_grid);
	self->priv->controls_grid = _tmp144_;
	_tmp145_ = self->priv->controls_grid;
	_tmp146_ = self->priv->prefix_box;
	gtk_grid_attach (_tmp145_, (GtkWidget*) _tmp146_, 0, 0, 1, 1);
	_tmp147_ = self->priv->controls_grid;
	_tmp148_ = self->priv->basename_entry;
	gtk_grid_attach (_tmp147_, (GtkWidget*) _tmp148_, 1, 0, 1, 1);
	_tmp149_ = self->priv->controls_grid;
	_tmp150_ = self->priv->suffix_box;
	gtk_grid_attach (_tmp149_, (GtkWidget*) _tmp150_, 2, 0, 1, 1);
	_tmp151_ = self->priv->controls_grid;
	_tmp152_ = _data14_->replacement_entry_revealer;
	gtk_grid_attach (_tmp151_, (GtkWidget*) _tmp152_, 1, 1, 1, 1);
	_tmp153_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp154_ = _g_object_ref0 (_tmp153_);
	content_box = _tmp154_;
	_tmp155_ = content_box;
	_tmp156_ = basename_box;
	gtk_container_add ((GtkContainer*) _tmp155_, (GtkWidget*) _tmp156_);
	_tmp157_ = content_box;
	_tmp158_ = self->priv->controls_grid;
	gtk_container_add ((GtkContainer*) _tmp157_, (GtkWidget*) _tmp158_);
	_tmp159_ = content_box;
	_tmp160_ = list_box;
	gtk_container_add ((GtkContainer*) _tmp159_, (GtkWidget*) _tmp160_);
	_tmp161_ = content_box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp161_, 10);
	_tmp162_ = content_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp162_, 10);
	_tmp163_ = content_box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp163_, 10);
	_tmp164_ = content_box;
	gtk_widget_show_all ((GtkWidget*) _tmp164_);
	_tmp165_ = _data14_->replacement_entry_revealer;
	gtk_revealer_set_reveal_child (_tmp165_, FALSE);
	_tmp166_ = self->priv->original_basename_toggle;
	g_signal_connect_data ((GtkToggleButton*) _tmp166_, "toggled", (GCallback) __files_renamer_dialog___lambda101__gtk_toggle_button_toggled, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp167_ = self->priv->new_basename_toggle;
	g_signal_connect_data ((GtkToggleButton*) _tmp167_, "toggled", (GCallback) __files_renamer_dialog___lambda102__gtk_toggle_button_toggled, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp168_ = self->priv->modify_basename_toggle;
	g_signal_connect_data ((GtkToggleButton*) _tmp168_, "toggled", (GCallback) __files_renamer_dialog___lambda103__gtk_toggle_button_toggled, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp169_ = self->priv->basename_entry;
	g_signal_connect_object ((GtkEditable*) _tmp169_, "changed", (GCallback) __files_renamer_dialog___lambda104__gtk_editable_changed, self, 0);
	_tmp170_ = self->priv->replacement_entry;
	g_signal_connect_object ((GtkEditable*) _tmp170_, "changed", (GCallback) __files_renamer_dialog___lambda105__gtk_editable_changed, self, 0);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __files_renamer_dialog___lambda106__gtk_dialog_response, self, 0);
	g_signal_connect_data ((GObject*) self, "notify::n-number-seq", (GCallback) __files_renamer_dialog___lambda107__g_object_notify, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp171_ = _data14_->name_check;
	g_signal_connect_data ((GtkToggleButton*) _tmp171_, "toggled", (GCallback) __files_renamer_dialog___lambda108__gtk_toggle_button_toggled, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	files_renamer_dialog_schedule_view_update (self);
	_g_object_unref0 (content_box);
	_g_object_unref0 (list_box);
	_g_object_unref0 (sortby_box);
	_g_object_unref0 (sortby_label);
	_g_object_unref0 (frame);
	_g_object_unref0 (list_scrolled_window);
	_g_object_unref0 (basename_box);
	_g_object_unref0 (toggle_box);
	_g_object_unref0 (basename_label);
	_g_object_unref0 (suffix_button);
	_g_object_unref0 (suffix_button_box);
	_g_object_unref0 (prefix_button);
	_g_object_unref0 (prefix_button_box);
	_g_object_unref0 (suffix_menumodel);
	_g_variant_unref0 (suffix_var);
	_g_object_unref0 (prefix_menumodel);
	_g_variant_unref0 (prefix_var);
	_g_object_unref0 (rename_button);
	_g_object_unref0 (cancel_button);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return obj;
}

static void
files_renamer_dialog_class_init (FilesRenamerDialogClass * klass,
                                 gpointer klass_data)
{
	files_renamer_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesRenamerDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_renamer_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_renamer_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_renamer_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_renamer_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_DIALOG_N_NUMBER_SEQ_PROPERTY, files_renamer_dialog_properties[FILES_RENAMER_DIALOG_N_NUMBER_SEQ_PROPERTY] = g_param_spec_int ("n-number-seq", "n-number-seq", "n-number-seq", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_DIALOG_N_PREFIX_PROPERTY, files_renamer_dialog_properties[FILES_RENAMER_DIALOG_N_PREFIX_PROPERTY] = g_param_spec_int ("n-prefix", "n-prefix", "n-prefix", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_DIALOG_N_SUFFIX_PROPERTY, files_renamer_dialog_properties[FILES_RENAMER_DIALOG_N_SUFFIX_PROPERTY] = g_param_spec_int ("n-suffix", "n-suffix", "n-suffix", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
files_renamer_dialog_instance_init (FilesRenamerDialog * self,
                                    gpointer klass)
{
	self->priv = files_renamer_dialog_get_instance_private (self);
	self->priv->_n_number_seq = 0;
	self->priv->_n_prefix = 0;
	self->priv->_n_suffix = 0;
}

static void
files_renamer_dialog_finalize (GObject * obj)
{
	FilesRenamerDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialog);
	_g_object_unref0 (self->priv->renamer);
	_g_object_unref0 (self->priv->controls_grid);
	_g_object_unref0 (self->priv->prefix_box);
	_g_object_unref0 (self->priv->suffix_box);
	_g_object_unref0 (self->priv->prefix_revealer);
	_g_object_unref0 (self->priv->suffix_revealer);
	_g_object_unref0 (self->priv->basename_entry);
	_g_object_unref0 (self->priv->replacement_entry);
	_g_object_unref0 (self->priv->modify_basename_toggle);
	_g_object_unref0 (self->priv->new_basename_toggle);
	_g_object_unref0 (self->priv->original_basename_toggle);
	_g_object_unref0 (self->priv->sortby_revealer);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (files_renamer_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_renamer_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesRenamerDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_renamer_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesRenamerDialog), 0, (GInstanceInitFunc) files_renamer_dialog_instance_init, NULL };
	GType files_renamer_dialog_type_id;
	files_renamer_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "FilesRenamerDialog", &g_define_type_info, 0);
	FilesRenamerDialog_private_offset = g_type_add_instance_private (files_renamer_dialog_type_id, sizeof (FilesRenamerDialogPrivate));
	return files_renamer_dialog_type_id;
}

GType
files_renamer_dialog_get_type (void)
{
	static volatile gsize files_renamer_dialog_type_id__once = 0;
	if (g_once_init_enter (&files_renamer_dialog_type_id__once)) {
		GType files_renamer_dialog_type_id;
		files_renamer_dialog_type_id = files_renamer_dialog_get_type_once ();
		g_once_init_leave (&files_renamer_dialog_type_id__once, files_renamer_dialog_type_id);
	}
	return files_renamer_dialog_type_id__once;
}

static void
_vala_files_renamer_dialog_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	FilesRenamerDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialog);
	switch (property_id) {
		case FILES_RENAMER_DIALOG_N_NUMBER_SEQ_PROPERTY:
		g_value_set_int (value, files_renamer_dialog_get_n_number_seq (self));
		break;
		case FILES_RENAMER_DIALOG_N_PREFIX_PROPERTY:
		g_value_set_int (value, files_renamer_dialog_get_n_prefix (self));
		break;
		case FILES_RENAMER_DIALOG_N_SUFFIX_PROPERTY:
		g_value_set_int (value, files_renamer_dialog_get_n_suffix (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_renamer_dialog_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	FilesRenamerDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER_DIALOG, FilesRenamerDialog);
	switch (property_id) {
		case FILES_RENAMER_DIALOG_N_NUMBER_SEQ_PROPERTY:
		files_renamer_dialog_set_n_number_seq (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_DIALOG_N_PREFIX_PROPERTY:
		files_renamer_dialog_set_n_prefix (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_DIALOG_N_SUFFIX_PROPERTY:
		files_renamer_dialog_set_n_suffix (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

