/* BreadcrumbIconList.c generated by valac 0.56.18, the Vala compiler
 * generated from BreadcrumbIconList.vala, do not modify */

/* Copyright (c) 2015-2018 elementary LLC <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation, Inc.,; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor
* Boston, MA 02110-1335 USA.
*/

#include "pantheon-files-core.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesViewChromeParamSpecBreadcrumbIconInfo FilesViewChromeParamSpecBreadcrumbIconInfo;
enum  {
	FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_0_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CONTEXT_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_SCALE_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_breadcrumb_icon_list_properties[FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_NUM_PROPERTIES];
#define _files_view_chrome_breadcrumb_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (files_view_chrome_breadcrumb_icon_info_unref (var), NULL)))

struct _FilesViewChromeParamSpecBreadcrumbIconInfo {
	GParamSpec parent_instance;
};

struct _FilesViewChromeBreadcrumbIconListPrivate {
	GeeArrayList* icon_info_list;
	GtkStyleContext* _context;
};

static gpointer files_view_chrome_breadcrumb_icon_info_parent_class = NULL;
static gint FilesViewChromeBreadcrumbIconList_private_offset;
static gpointer files_view_chrome_breadcrumb_icon_list_parent_class = NULL;

static void files_view_chrome_breadcrumb_icon_info_finalize (FilesViewChromeBreadcrumbIconInfo * obj);
static GType files_view_chrome_breadcrumb_icon_info_get_type_once (void);
static void files_view_chrome_breadcrumb_icon_list_add_protocol_directory (FilesViewChromeBreadcrumbIconList* self,
                                                                    const gchar* protocol,
                                                                    const gchar* icon);
static void files_view_chrome_breadcrumb_icon_list_add_special_directory (FilesViewChromeBreadcrumbIconList* self,
                                                                   const gchar* dir,
                                                                   const gchar* icon_name,
                                                                   gboolean break_loop);
static void __lambda66_ (FilesViewChromeBreadcrumbIconList* self,
                  GMount* mount);
static void ___lambda66__gfunc (gconstpointer data,
                         gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GObject * files_view_chrome_breadcrumb_icon_list_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static void files_view_chrome_breadcrumb_icon_list_finalize (GObject * obj);
static GType files_view_chrome_breadcrumb_icon_list_get_type_once (void);
static void _vala_files_view_chrome_breadcrumb_icon_list_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_files_view_chrome_breadcrumb_icon_list_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_construct_special_directory (GType object_type,
                                                                    const gchar* path,
                                                                    const gchar* icon_name)
{
	FilesViewChromeBreadcrumbIconInfo* self = NULL;
	GThemedIcon* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (FilesViewChromeBreadcrumbIconInfo*) g_type_create_instance (object_type);
	files_view_chrome_breadcrumb_icon_info_set_path (self, path);
	self->protocol = FALSE;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (icon_name);
	_g_object_unref0 (self->gicon);
	self->gicon = (GIcon*) _tmp0_;
	self->break_loop = FALSE;
	_tmp1_ = g_filename_display_basename (path);
	_g_free0 (self->text_displayed);
	self->text_displayed = _tmp1_;
	return self;
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_new_special_directory (const gchar* path,
                                                              const gchar* icon_name)
{
	return files_view_chrome_breadcrumb_icon_info_construct_special_directory (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, path, icon_name);
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_construct_protocol_directory (GType object_type,
                                                                     const gchar* scheme,
                                                                     const gchar* icon_name,
                                                                     const gchar* display_name)
{
	FilesViewChromeBreadcrumbIconInfo* self = NULL;
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (scheme != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (FilesViewChromeBreadcrumbIconInfo*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (scheme);
	_g_free0 (self->path);
	self->path = _tmp0_;
	self->protocol = TRUE;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new (icon_name);
	_g_object_unref0 (self->gicon);
	self->gicon = (GIcon*) _tmp1_;
	self->break_loop = TRUE;
	_tmp2_ = g_strdup (display_name);
	_g_free0 (self->text_displayed);
	self->text_displayed = _tmp2_;
	return self;
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_new_protocol_directory (const gchar* scheme,
                                                               const gchar* icon_name,
                                                               const gchar* display_name)
{
	return files_view_chrome_breadcrumb_icon_info_construct_protocol_directory (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, scheme, icon_name, display_name);
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_construct_from_mount (GType object_type,
                                                             GMount* mount)
{
	FilesViewChromeBreadcrumbIconInfo* self = NULL;
	GFile* root = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIcon* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (mount != NULL, NULL);
	self = (FilesViewChromeBreadcrumbIconInfo*) g_type_create_instance (object_type);
	_tmp0_ = g_mount_get_root (mount);
	root = _tmp0_;
	_tmp1_ = g_file_get_path (root);
	_tmp2_ = _tmp1_;
	files_view_chrome_breadcrumb_icon_info_set_path (self, _tmp2_);
	_g_free0 (_tmp2_);
	self->protocol = FALSE;
	_tmp3_ = g_mount_get_icon (mount);
	_g_object_unref0 (self->gicon);
	self->gicon = _tmp3_;
	self->break_loop = TRUE;
	_tmp4_ = g_mount_get_name (mount);
	_g_free0 (self->text_displayed);
	self->text_displayed = _tmp4_;
	_g_object_unref0 (root);
	return self;
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_new_from_mount (GMount* mount)
{
	return files_view_chrome_breadcrumb_icon_info_construct_from_mount (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, mount);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
files_view_chrome_breadcrumb_icon_info_render_icon (FilesViewChromeBreadcrumbIconInfo* self,
                                                    GtkStyleContext* context)
{
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	GdkPixbuf* icon = NULL;
	GtkIconInfo* gtk_icon_info = NULL;
	gint scale = 0;
	GIcon* _tmp2_;
	GtkIconLookupFlags flags = 0U;
	GtkIconTheme* _tmp4_;
	GIcon* _tmp5_;
	GtkIconInfo* _tmp6_;
	GtkIconInfo* _tmp7_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	icon = NULL;
	gtk_icon_info = NULL;
	scale = gtk_style_context_get_scale (context);
	_tmp2_ = self->gicon;
	if (_tmp2_ == NULL) {
		GThemedIcon* _tmp3_;
		_tmp3_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("image-missing");
		_g_object_unref0 (self->gicon);
		self->gicon = (GIcon*) _tmp3_;
	}
	flags = GTK_ICON_LOOKUP_FORCE_SIZE | GTK_ICON_LOOKUP_FORCE_SYMBOLIC;
	_tmp4_ = theme;
	_tmp5_ = self->gicon;
	_tmp6_ = gtk_icon_theme_lookup_by_gicon_for_scale (_tmp4_, _tmp5_, 16, scale, flags);
	_g_object_unref0 (gtk_icon_info);
	gtk_icon_info = _tmp6_;
	_tmp7_ = gtk_icon_info;
	if (_tmp7_ != NULL) {
		{
			GdkPixbuf* _tmp8_ = NULL;
			GtkIconInfo* _tmp9_;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			_tmp9_ = gtk_icon_info;
			_tmp10_ = gtk_icon_info_load_symbolic_for_context (_tmp9_, context, NULL, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_object_unref0 (icon);
			icon = _tmp11_;
			_tmp12_ = icon;
			self->icon_width = gdk_pixbuf_get_width (_tmp12_) / scale;
			_tmp13_ = icon;
			self->icon_height = gdk_pixbuf_get_height (_tmp13_) / scale;
			_g_object_unref0 (_tmp8_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = self->text_displayed;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("BreadcrumbIconList.vala:74: Filed to load icon for %s: %s", _tmp14_, _tmp16_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (gtk_icon_info);
			_g_object_unref0 (icon);
			_g_object_unref0 (theme);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = icon;
	_g_object_unref0 (gtk_icon_info);
	_g_object_unref0 (theme);
	return result;
}

void
files_view_chrome_breadcrumb_icon_info_set_path (FilesViewChromeBreadcrumbIconInfo* self,
                                                 const gchar* path)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (self->path);
	self->path = _tmp0_;
	if (path != NULL) {
		if (g_strcmp0 (path, G_DIR_SEPARATOR_S) == 0) {
			gchar* _tmp1_;
			gchar** _tmp2_;
			_tmp1_ = g_strdup (G_DIR_SEPARATOR_S);
			_tmp2_ = g_new0 (gchar*, 1 + 1);
			_tmp2_[0] = _tmp1_;
			self->exploded = (_vala_array_free (self->exploded, self->exploded_length1, (GDestroyNotify) g_free), NULL);
			self->exploded = _tmp2_;
			self->exploded_length1 = 1;
		} else {
			gchar** _tmp3_;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_;
			_tmp4_ = _tmp3_ = g_strsplit (path, G_DIR_SEPARATOR_S, 0);
			self->exploded = (_vala_array_free (self->exploded, self->exploded_length1, (GDestroyNotify) g_free), NULL);
			self->exploded = _tmp4_;
			self->exploded_length1 = _vala_array_length (_tmp3_);
			_tmp5_ = self->exploded;
			_tmp5__length1 = self->exploded_length1;
			_tmp6_ = g_strdup (G_DIR_SEPARATOR_S);
			_g_free0 (_tmp5_[0]);
			_tmp5_[0] = _tmp6_;
		}
	}
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_construct (GType object_type)
{
	FilesViewChromeBreadcrumbIconInfo* self = NULL;
	self = (FilesViewChromeBreadcrumbIconInfo*) g_type_create_instance (object_type);
	return self;
}

FilesViewChromeBreadcrumbIconInfo*
files_view_chrome_breadcrumb_icon_info_new (void)
{
	return files_view_chrome_breadcrumb_icon_info_construct (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO);
}

static void
files_view_chrome_value_breadcrumb_icon_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
files_view_chrome_value_breadcrumb_icon_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		files_view_chrome_breadcrumb_icon_info_unref (value->data[0].v_pointer);
	}
}

static void
files_view_chrome_value_breadcrumb_icon_info_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = files_view_chrome_breadcrumb_icon_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
files_view_chrome_value_breadcrumb_icon_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
files_view_chrome_value_breadcrumb_icon_info_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FilesViewChromeBreadcrumbIconInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = files_view_chrome_breadcrumb_icon_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
files_view_chrome_value_breadcrumb_icon_info_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	FilesViewChromeBreadcrumbIconInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = files_view_chrome_breadcrumb_icon_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
files_view_chrome_param_spec_breadcrumb_icon_info (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	FilesViewChromeParamSpecBreadcrumbIconInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
files_view_chrome_value_get_breadcrumb_icon_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO), NULL);
	return value->data[0].v_pointer;
}

void
files_view_chrome_value_set_breadcrumb_icon_info (GValue* value,
                                                  gpointer v_object)
{
	FilesViewChromeBreadcrumbIconInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		files_view_chrome_breadcrumb_icon_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		files_view_chrome_breadcrumb_icon_info_unref (old);
	}
}

void
files_view_chrome_value_take_breadcrumb_icon_info (GValue* value,
                                                   gpointer v_object)
{
	FilesViewChromeBreadcrumbIconInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		files_view_chrome_breadcrumb_icon_info_unref (old);
	}
}

static void
files_view_chrome_breadcrumb_icon_info_class_init (FilesViewChromeBreadcrumbIconInfoClass * klass,
                                                   gpointer klass_data)
{
	files_view_chrome_breadcrumb_icon_info_parent_class = g_type_class_peek_parent (klass);
	((FilesViewChromeBreadcrumbIconInfoClass *) klass)->finalize = files_view_chrome_breadcrumb_icon_info_finalize;
}

static void
files_view_chrome_breadcrumb_icon_info_instance_init (FilesViewChromeBreadcrumbIconInfo * self,
                                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
files_view_chrome_breadcrumb_icon_info_finalize (FilesViewChromeBreadcrumbIconInfo * obj)
{
	FilesViewChromeBreadcrumbIconInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, FilesViewChromeBreadcrumbIconInfo);
	g_signal_handlers_destroy (self);
	_g_free0 (self->path);
	_g_object_unref0 (self->gicon);
	self->exploded = (_vala_array_free (self->exploded, self->exploded_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->text_displayed);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_breadcrumb_icon_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { files_view_chrome_value_breadcrumb_icon_info_init, files_view_chrome_value_breadcrumb_icon_info_free_value, files_view_chrome_value_breadcrumb_icon_info_copy_value, files_view_chrome_value_breadcrumb_icon_info_peek_pointer, "p", files_view_chrome_value_breadcrumb_icon_info_collect_value, "p", files_view_chrome_value_breadcrumb_icon_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeBreadcrumbIconInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_breadcrumb_icon_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeBreadcrumbIconInfo), 0, (GInstanceInitFunc) files_view_chrome_breadcrumb_icon_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType files_view_chrome_breadcrumb_icon_info_type_id;
	files_view_chrome_breadcrumb_icon_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FilesViewChromeBreadcrumbIconInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return files_view_chrome_breadcrumb_icon_info_type_id;
}

GType
files_view_chrome_breadcrumb_icon_info_get_type (void)
{
	static volatile gsize files_view_chrome_breadcrumb_icon_info_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_breadcrumb_icon_info_type_id__once)) {
		GType files_view_chrome_breadcrumb_icon_info_type_id;
		files_view_chrome_breadcrumb_icon_info_type_id = files_view_chrome_breadcrumb_icon_info_get_type_once ();
		g_once_init_leave (&files_view_chrome_breadcrumb_icon_info_type_id__once, files_view_chrome_breadcrumb_icon_info_type_id);
	}
	return files_view_chrome_breadcrumb_icon_info_type_id__once;
}

gpointer
files_view_chrome_breadcrumb_icon_info_ref (gpointer instance)
{
	FilesViewChromeBreadcrumbIconInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
files_view_chrome_breadcrumb_icon_info_unref (gpointer instance)
{
	FilesViewChromeBreadcrumbIconInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILES_VIEW_CHROME_BREADCRUMB_ICON_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
files_view_chrome_breadcrumb_icon_list_get_instance_private (FilesViewChromeBreadcrumbIconList* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeBreadcrumbIconList_private_offset);
}

FilesViewChromeBreadcrumbIconList*
files_view_chrome_breadcrumb_icon_list_construct (GType object_type,
                                                  GtkStyleContext* context)
{
	FilesViewChromeBreadcrumbIconList * self = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (FilesViewChromeBreadcrumbIconList*) g_object_new (object_type, "context", context, NULL);
	return self;
}

FilesViewChromeBreadcrumbIconList*
files_view_chrome_breadcrumb_icon_list_new (GtkStyleContext* context)
{
	return files_view_chrome_breadcrumb_icon_list_construct (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, context);
}

static void
files_view_chrome_breadcrumb_icon_list_add_protocol_directory (FilesViewChromeBreadcrumbIconList* self,
                                                               const gchar* protocol,
                                                               const gchar* icon)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* separator = NULL;
	gchar* _tmp2_;
	FilesViewChromeBreadcrumbIconInfo* info = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FilesViewChromeBreadcrumbIconInfo* _tmp7_;
	FilesViewChromeBreadcrumbIconInfo* _tmp8_;
	GeeArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (icon != NULL);
	if (g_strcmp0 (protocol, "mtp") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (protocol, "gphoto2") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = "[";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = g_strconcat ("://", _tmp0_, NULL);
	separator = _tmp2_;
	_tmp3_ = g_strconcat (protocol, separator, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = files_protocol_to_name (protocol);
	_tmp6_ = _tmp5_;
	_tmp7_ = files_view_chrome_breadcrumb_icon_info_new_protocol_directory (_tmp4_, icon, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	info = _tmp8_;
	_tmp9_ = self->priv->icon_info_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, info);
	_files_view_chrome_breadcrumb_icon_info_unref0 (info);
	_g_free0 (separator);
}

static void
files_view_chrome_breadcrumb_icon_list_add_special_directory (FilesViewChromeBreadcrumbIconList* self,
                                                              const gchar* dir,
                                                              const gchar* icon_name,
                                                              gboolean break_loop)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	if (dir != NULL) {
		FilesViewChromeBreadcrumbIconInfo* icon = NULL;
		FilesViewChromeBreadcrumbIconInfo* _tmp0_ = NULL;
		GeeArrayList* _tmp1_;
		FilesViewChromeBreadcrumbIconInfo* _tmp2_;
		_tmp0_ = files_view_chrome_breadcrumb_icon_info_new_special_directory (dir, icon_name);
		_tmp0_->break_loop = break_loop;
		icon = _tmp0_;
		_tmp1_ = self->priv->icon_info_list;
		_tmp2_ = icon;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		_files_view_chrome_breadcrumb_icon_info_unref0 (icon);
	}
}

static void
__lambda66_ (FilesViewChromeBreadcrumbIconList* self,
             GMount* mount)
{
	FilesViewChromeBreadcrumbIconInfo* icon_info = NULL;
	FilesViewChromeBreadcrumbIconInfo* _tmp0_;
	FilesViewChromeBreadcrumbIconInfo* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (mount != NULL);
	_tmp0_ = files_view_chrome_breadcrumb_icon_info_new_from_mount (mount);
	icon_info = _tmp0_;
	_tmp1_ = icon_info;
	_tmp2_ = _tmp1_->path;
	if (_tmp2_ != NULL) {
		GeeArrayList* _tmp3_;
		FilesViewChromeBreadcrumbIconInfo* _tmp4_;
		_tmp3_ = self->priv->icon_info_list;
		_tmp4_ = icon_info;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	}
	_files_view_chrome_breadcrumb_icon_info_unref0 (icon_info);
}

static void
___lambda66__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda66_ ((FilesViewChromeBreadcrumbIconList*) self, (GMount*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
files_view_chrome_breadcrumb_icon_list_add_mounted_volumes (FilesViewChromeBreadcrumbIconList* self)
{
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GVolumeMonitor* volume_monitor = NULL;
	GVolumeMonitor* _tmp2_;
	GList* mount_list = NULL;
	GList* _tmp3_;
	GtkStyleContext* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_context;
	gtk_style_context_save (_tmp0_);
	_tmp1_ = self->priv->_context;
	gtk_style_context_set_state (_tmp1_, GTK_STATE_FLAG_NORMAL);
	_tmp2_ = g_volume_monitor_get ();
	volume_monitor = _tmp2_;
	_tmp3_ = g_volume_monitor_get_mounts (volume_monitor);
	mount_list = _tmp3_;
	g_list_foreach (mount_list, ___lambda66__gfunc, self);
	_tmp4_ = self->priv->_context;
	gtk_style_context_restore (_tmp4_);
	(mount_list == NULL) ? NULL : (mount_list = (_g_list_free__g_object_unref0_ (mount_list), NULL));
	_g_object_unref0 (volume_monitor);
}

void
files_view_chrome_breadcrumb_icon_list_truncate_to_length (FilesViewChromeBreadcrumbIconList* self,
                                                           gint new_length)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->icon_info_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				FilesViewChromeBreadcrumbIconInfo* _tmp7_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(i >= new_length)) {
					break;
				}
				_tmp5_ = self->priv->icon_info_list;
				_tmp6_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp5_, i);
				_tmp7_ = (FilesViewChromeBreadcrumbIconInfo*) _tmp6_;
				_files_view_chrome_breadcrumb_icon_info_unref0 (_tmp7_);
			}
		}
	}
}

gint
files_view_chrome_breadcrumb_icon_list_length (FilesViewChromeBreadcrumbIconList* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->icon_info_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GeeArrayList*
files_view_chrome_breadcrumb_icon_list_get_list (FilesViewChromeBreadcrumbIconList* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->icon_info_list;
	result = _tmp0_;
	return result;
}

GtkStyleContext*
files_view_chrome_breadcrumb_icon_list_get_context (FilesViewChromeBreadcrumbIconList* self)
{
	GtkStyleContext* result;
	GtkStyleContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_breadcrumb_icon_list_set_context (FilesViewChromeBreadcrumbIconList* self,
                                                    GtkStyleContext* value)
{
	GtkStyleContext* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_breadcrumb_icon_list_get_context (self);
	if (old_value != value) {
		self->priv->_context = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_breadcrumb_icon_list_properties[FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CONTEXT_PROPERTY]);
	}
}

gint
files_view_chrome_breadcrumb_icon_list_get_scale (FilesViewChromeBreadcrumbIconList* self)
{
	gint result;
	GtkStyleContext* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_context;
	result = gtk_style_context_get_scale (_tmp0_);
	return result;
}

void
files_view_chrome_breadcrumb_icon_list_set_scale (FilesViewChromeBreadcrumbIconList* self,
                                                  gint value)
{
	GtkStyleContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_context;
	gtk_style_context_set_scale (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_breadcrumb_icon_list_properties[FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_SCALE_PROPERTY]);
}

static GObject *
files_view_chrome_breadcrumb_icon_list_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewChromeBreadcrumbIconList * self;
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	parent_class = G_OBJECT_CLASS (files_view_chrome_breadcrumb_icon_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconList);
	_tmp0_ = gee_array_list_new (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_INFO, (GBoxedCopyFunc) files_view_chrome_breadcrumb_icon_info_ref, (GDestroyNotify) files_view_chrome_breadcrumb_icon_info_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->icon_info_list);
	self->priv->icon_info_list = _tmp0_;
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "afp", FILES_ICON_FOLDER_REMOTE_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "dav", FILES_ICON_FOLDER_REMOTE_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "davs", FILES_ICON_FOLDER_REMOTE_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "ftp", FILES_ICON_FOLDER_REMOTE_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "sftp", FILES_ICON_FOLDER_REMOTE_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "mtp", FILES_ICON_DEVICE_REMOVABLE_MEDIA_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "gphoto2", FILES_ICON_DEVICE_CAMERA_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "afc", FILES_ICON_DEVICE_PHONE_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "network", FILES_ICON_NETWORK_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "smb", FILES_ICON_NETWORK_SERVER_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "trash", FILES_ICON_TRASH_SYMBOLIC);
	files_view_chrome_breadcrumb_icon_list_add_protocol_directory (self, "recent", FILES_ICON_RECENT_SYMBOLIC);
	_tmp1_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp1_, FILES_ICON_FOLDER_MUSIC_SYMBOLIC, FALSE);
	_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp2_, FILES_ICON_FOLDER_PICTURES_SYMBOLIC, FALSE);
	_tmp3_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp3_, FILES_ICON_FOLDER_VIDEOS_SYMBOLIC, FALSE);
	_tmp4_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp4_, FILES_ICON_FOLDER_DOWNLOADS_SYMBOLIC, FALSE);
	_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp5_, FILES_ICON_FOLDER_DOCUMENTS_SYMBOLIC, FALSE);
	_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp6_, FILES_ICON_FOLDER_TEMPLATES_SYMBOLIC, FALSE);
	_tmp7_ = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp7_, FILES_ICON_FOLDER_PUBLICSHARE_SYMBOLIC, FALSE);
	_tmp8_ = pf_user_utils_get_real_user_home ();
	_tmp9_ = _tmp8_;
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, _tmp9_, FILES_ICON_GO_HOME_SYMBOLIC, TRUE);
	_g_free0 (_tmp9_);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, "/media", FILES_ICON_FILESYSTEM_SYMBOLIC, TRUE);
	files_view_chrome_breadcrumb_icon_list_add_special_directory (self, G_DIR_SEPARATOR_S, FILES_ICON_FILESYSTEM_SYMBOLIC, FALSE);
	return obj;
}

static void
files_view_chrome_breadcrumb_icon_list_class_init (FilesViewChromeBreadcrumbIconListClass * klass,
                                                   gpointer klass_data)
{
	files_view_chrome_breadcrumb_icon_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeBreadcrumbIconList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_breadcrumb_icon_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_breadcrumb_icon_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_chrome_breadcrumb_icon_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_breadcrumb_icon_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CONTEXT_PROPERTY, files_view_chrome_breadcrumb_icon_list_properties[FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CONTEXT_PROPERTY] = g_param_spec_object ("context", "context", "context", gtk_style_context_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_SCALE_PROPERTY, files_view_chrome_breadcrumb_icon_list_properties[FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_SCALE_PROPERTY] = g_param_spec_int ("scale", "scale", "scale", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_view_chrome_breadcrumb_icon_list_instance_init (FilesViewChromeBreadcrumbIconList * self,
                                                      gpointer klass)
{
	self->priv = files_view_chrome_breadcrumb_icon_list_get_instance_private (self);
}

static void
files_view_chrome_breadcrumb_icon_list_finalize (GObject * obj)
{
	FilesViewChromeBreadcrumbIconList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconList);
	_g_object_unref0 (self->priv->icon_info_list);
	G_OBJECT_CLASS (files_view_chrome_breadcrumb_icon_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_breadcrumb_icon_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeBreadcrumbIconListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_breadcrumb_icon_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeBreadcrumbIconList), 0, (GInstanceInitFunc) files_view_chrome_breadcrumb_icon_list_instance_init, NULL };
	GType files_view_chrome_breadcrumb_icon_list_type_id;
	files_view_chrome_breadcrumb_icon_list_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesViewChromeBreadcrumbIconList", &g_define_type_info, 0);
	FilesViewChromeBreadcrumbIconList_private_offset = g_type_add_instance_private (files_view_chrome_breadcrumb_icon_list_type_id, sizeof (FilesViewChromeBreadcrumbIconListPrivate));
	return files_view_chrome_breadcrumb_icon_list_type_id;
}

GType
files_view_chrome_breadcrumb_icon_list_get_type (void)
{
	static volatile gsize files_view_chrome_breadcrumb_icon_list_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_breadcrumb_icon_list_type_id__once)) {
		GType files_view_chrome_breadcrumb_icon_list_type_id;
		files_view_chrome_breadcrumb_icon_list_type_id = files_view_chrome_breadcrumb_icon_list_get_type_once ();
		g_once_init_leave (&files_view_chrome_breadcrumb_icon_list_type_id__once, files_view_chrome_breadcrumb_icon_list_type_id);
	}
	return files_view_chrome_breadcrumb_icon_list_type_id__once;
}

static void
_vala_files_view_chrome_breadcrumb_icon_list_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	FilesViewChromeBreadcrumbIconList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconList);
	switch (property_id) {
		case FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CONTEXT_PROPERTY:
		g_value_set_object (value, files_view_chrome_breadcrumb_icon_list_get_context (self));
		break;
		case FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_SCALE_PROPERTY:
		g_value_set_int (value, files_view_chrome_breadcrumb_icon_list_get_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_breadcrumb_icon_list_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	FilesViewChromeBreadcrumbIconList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ICON_LIST, FilesViewChromeBreadcrumbIconList);
	switch (property_id) {
		case FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_CONTEXT_PROPERTY:
		files_view_chrome_breadcrumb_icon_list_set_context (self, g_value_get_object (value));
		break;
		case FILES_VIEW_CHROME_BREADCRUMB_ICON_LIST_SCALE_PROPERTY:
		files_view_chrome_breadcrumb_icon_list_set_scale (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

