/* UserUtils.c generated by valac 0.56.18, the Vala compiler
 * generated from UserUtils.vala, do not modify */

/* Copyright (c) 2018 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <grp.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

static gint _g_utf8_collate_gcompare_func (gconstpointer a,
                                    gconstpointer b);
static uid_t* _uid_t_dup (uid_t* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gint
_g_utf8_collate_gcompare_func (gconstpointer a,
                               gconstpointer b)
{
	gint result;
	result = g_utf8_collate (a, (const gchar*) b);
	return result;
}

GList*
pf_user_utils_get_user_names (void)
{
	GList* list = NULL;
	GList* result;
	list = NULL;
	setpwent ();
	{
		struct passwd* user = NULL;
		struct passwd* _tmp0_;
		_tmp0_ = getpwent ();
		user = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				struct passwd* _tmp3_;
				struct passwd* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				if (!_tmp1_) {
					struct passwd* _tmp2_;
					_tmp2_ = getpwent ();
					user = _tmp2_;
				}
				_tmp1_ = FALSE;
				_tmp3_ = user;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = user;
				_tmp5_ = _tmp4_->pw_name;
				_tmp6_ = g_strdup (_tmp5_);
				list = g_list_prepend (list, _tmp6_);
			}
		}
	}
	endpwent ();
	list = g_list_sort (list, _g_utf8_collate_gcompare_func);
	result = list;
	return result;
}

GList*
pf_user_utils_get_group_names_for_user (void)
{
	GList* list = NULL;
	gid_t* gid_list = NULL;
	gid_t* _tmp0_;
	gint gid_list_length1;
	gint _gid_list_size_;
	gint group_number = 0;
	gid_t* _tmp1_;
	gint _tmp1__length1;
	GList* result;
	list = NULL;
	_tmp0_ = g_new0 (gid_t, NGROUPS_MAX + 1);
	gid_list = _tmp0_;
	gid_list_length1 = NGROUPS_MAX + 1;
	_gid_list_size_ = gid_list_length1;
	_tmp1_ = gid_list;
	_tmp1__length1 = gid_list_length1;
	group_number = getgroups ((gint) _tmp1__length1, _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				struct group* group = NULL;
				gid_t* _tmp4_;
				gint _tmp4__length1;
				gid_t _tmp5_;
				struct group* _tmp6_;
				struct group* _tmp7_;
				struct group* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < group_number)) {
					break;
				}
				_tmp4_ = gid_list;
				_tmp4__length1 = gid_list_length1;
				_tmp5_ = _tmp4_[i];
				_tmp6_ = getgrgid (_tmp5_);
				group = _tmp6_;
				_tmp7_ = group;
				if (_tmp7_ == NULL) {
					break;
				}
				_tmp8_ = group;
				_tmp9_ = _tmp8_->gr_name;
				_tmp10_ = g_strdup (_tmp9_);
				list = g_list_prepend (list, _tmp10_);
			}
		}
	}
	list = g_list_sort (list, _g_utf8_collate_gcompare_func);
	result = list;
	gid_list = (g_free (gid_list), NULL);
	return result;
}

GList*
pf_user_utils_get_all_group_names (void)
{
	GList* list = NULL;
	GList* result;
	list = NULL;
	setgrent ();
	{
		struct group* group = NULL;
		struct group* _tmp0_;
		_tmp0_ = getgrent ();
		group = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				struct group* _tmp3_;
				struct group* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				if (!_tmp1_) {
					struct group* _tmp2_;
					_tmp2_ = getgrent ();
					group = _tmp2_;
				}
				_tmp1_ = FALSE;
				_tmp3_ = group;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = group;
				_tmp5_ = _tmp4_->gr_name;
				_tmp6_ = g_strdup (_tmp5_);
				list = g_list_prepend (list, _tmp6_);
			}
		}
	}
	endgrent ();
	list = g_list_sort (list, _g_utf8_collate_gcompare_func);
	result = list;
	return result;
}

gboolean
pf_user_utils_user_in_group (const gchar* group_name)
{
	gid_t* gid_list = NULL;
	gid_t* _tmp0_;
	gint gid_list_length1;
	gint _gid_list_size_;
	gint group_number = 0;
	gid_t* _tmp1_;
	gint _tmp1__length1;
	gboolean result;
	g_return_val_if_fail (group_name != NULL, FALSE);
	_tmp0_ = g_new0 (gid_t, NGROUPS_MAX + 1);
	gid_list = _tmp0_;
	gid_list_length1 = NGROUPS_MAX + 1;
	_gid_list_size_ = gid_list_length1;
	_tmp1_ = gid_list;
	_tmp1__length1 = gid_list_length1;
	group_number = getgroups ((gint) _tmp1__length1, _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				struct group* group = NULL;
				gid_t* _tmp4_;
				gint _tmp4__length1;
				gid_t _tmp5_;
				struct group* _tmp6_;
				struct group* _tmp7_;
				struct group* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < group_number)) {
					break;
				}
				_tmp4_ = gid_list;
				_tmp4__length1 = gid_list_length1;
				_tmp5_ = _tmp4_[i];
				_tmp6_ = getgrgid (_tmp5_);
				group = _tmp6_;
				_tmp7_ = group;
				if (_tmp7_ == NULL) {
					break;
				}
				_tmp8_ = group;
				_tmp9_ = _tmp8_->gr_name;
				if (g_strcmp0 (_tmp9_, group_name) == 0) {
					result = TRUE;
					gid_list = (g_free (gid_list), NULL);
					return result;
				}
			}
		}
	}
	result = FALSE;
	gid_list = (g_free (gid_list), NULL);
	return result;
}

static uid_t*
_uid_t_dup (uid_t* self)
{
	uid_t* dup;
	dup = g_new0 (uid_t, 1);
	memcpy (dup, self, sizeof (uid_t));
	return dup;
}

static gpointer
__uid_t_dup0 (gpointer self)
{
	return self ? _uid_t_dup (self) : NULL;
}

uid_t*
pf_user_utils_get_group_id_from_group_name (const gchar* group_name)
{
	struct group* group = NULL;
	struct group* _tmp0_;
	struct group* _tmp1_;
	uid_t* uid = NULL;
	struct group* _tmp2_;
	uid_t _tmp3_;
	uid_t* _tmp4_;
	uid_t* result;
	g_return_val_if_fail (group_name != NULL, NULL);
	_tmp0_ = getgrnam (group_name);
	group = _tmp0_;
	_tmp1_ = group;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = group;
	_tmp3_ = (uid_t) _tmp2_->gr_gid;
	_tmp4_ = __uid_t_dup0 (&_tmp3_);
	uid = _tmp4_;
	result = uid;
	return result;
}

uid_t*
pf_user_utils_get_user_id_from_user_name (const gchar* user_name)
{
	struct passwd* password_info = NULL;
	struct passwd* _tmp0_;
	struct passwd* _tmp1_;
	uid_t* uid = NULL;
	struct passwd* _tmp2_;
	uid_t* _tmp3_;
	uid_t* result;
	g_return_val_if_fail (user_name != NULL, NULL);
	_tmp0_ = getpwnam (user_name);
	password_info = _tmp0_;
	_tmp1_ = password_info;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = password_info;
	_tmp3_ = __uid_t_dup0 (&_tmp2_->pw_uid);
	uid = _tmp3_;
	result = uid;
	return result;
}

const gchar*
pf_user_utils_get_user_home_from_user_uid (uid_t uid)
{
	struct passwd* password_info = NULL;
	struct passwd* _tmp0_;
	struct passwd* _tmp1_;
	struct passwd* _tmp2_;
	const gchar* _tmp3_;
	const gchar* result;
	_tmp0_ = getpwuid (uid);
	password_info = _tmp0_;
	_tmp1_ = password_info;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = password_info;
	_tmp3_ = _tmp2_->pw_dir;
	result = _tmp3_;
	return result;
}

uid_t*
pf_user_utils_get_id_from_digit_string (const gchar* digit_string)
{
	gchar c = '\0';
	glong id = 0L;
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	gint _tmp2_;
	uid_t* uid = NULL;
	uid_t _tmp3_;
	uid_t* _tmp4_;
	uid_t* result;
	g_return_val_if_fail (digit_string != NULL, NULL);
	_tmp2_ = sscanf (digit_string, "%ld%c", &_tmp0_, &_tmp1_);
	id = _tmp0_;
	c = _tmp1_;
	if (_tmp2_ != 1) {
		result = NULL;
		return result;
	}
	_tmp3_ = (uid_t) id;
	_tmp4_ = __uid_t_dup0 (&_tmp3_);
	uid = _tmp4_;
	result = uid;
	return result;
}

gchar*
pf_user_utils_get_real_user_home (void)
{
	const gchar* real_uid_s = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	_tmp1_ = _tmp0_ = g_get_environ ();
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = g_environ_getenv (_tmp2_, "PKEXEC_UID");
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	real_uid_s = _tmp4_;
	_tmp5_ = real_uid_s;
	if (_tmp5_ != NULL) {
		uid_t* scanned_id = NULL;
		const gchar* _tmp6_;
		uid_t* _tmp7_;
		uid_t* _tmp8_;
		_tmp6_ = real_uid_s;
		_tmp7_ = pf_user_utils_get_id_from_digit_string (_tmp6_);
		scanned_id = _tmp7_;
		_tmp8_ = scanned_id;
		if (_tmp8_ != NULL) {
			uid_t* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = scanned_id;
			_tmp10_ = pf_user_utils_get_user_home_from_user_uid (*_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			_g_free0 (scanned_id);
			return result;
		}
		_g_free0 (scanned_id);
	}
	_tmp12_ = g_get_home_dir ();
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

