/* PluginManager.c generated by valac 0.56.18, the Vala compiler
 * generated from PluginManager.vala, do not modify */

#include "pantheon-files-core.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_PLUGIN_MANAGER_0_PROPERTY,
	FILES_PLUGIN_MANAGER_MENUITEM_REFERENCES_PROPERTY,
	FILES_PLUGIN_MANAGER_NUM_PROPERTIES
};
static GParamSpec* files_plugin_manager_properties[FILES_PLUGIN_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesPluginManagerOnPluginDirectoryChangeData FilesPluginManagerOnPluginDirectoryChangeData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef FilesPluginsBase* (*FilesPluginManagerModuleInitFunc) (gpointer user_data);
#define _files_plugins_base_unref0(var) ((var == NULL) ? NULL : (var = (files_plugins_base_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FilesPluginManagerPrivate {
	GeeHashMap* plugin_hash;
	GeeList* names;
	gboolean in_available;
	gboolean update_queued;
	gboolean is_admin;
	GeeList* _menuitem_references;
	gchar** plugin_dirs;
	gint plugin_dirs_length1;
	gint _plugin_dirs_size_;
};

struct _FilesPluginManagerOnPluginDirectoryChangeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesPluginManager* self;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event;
};

FilesPluginManager* plugins = NULL;
static gint FilesPluginManager_private_offset;
static gpointer files_plugin_manager_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void files_plugin_manager_set_menuitem_references (FilesPluginManager* self,
                                                   GeeList* value);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void files_plugin_manager_load_plugins (FilesPluginManager* self);
static void files_plugin_manager_set_directory_monitor (FilesPluginManager* self,
                                                 const gchar* path);
static void files_plugin_manager_load_modules_from_dir (FilesPluginManager* self,
                                                 const gchar* path);
static void files_plugin_manager_on_plugin_directory_change (FilesPluginManager* self,
                                                      GFile* file,
                                                      GFile* other_file,
                                                      GFileMonitorEvent event,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void files_plugin_manager_on_plugin_directory_change_finish (FilesPluginManager* self,
                                                             GAsyncResult* _res_);
static void _files_plugin_manager_on_plugin_directory_change_g_file_monitor_changed (GFileMonitor* _sender,
                                                                              GFile* file,
                                                                              GFile* other_file,
                                                                              GFileMonitorEvent event_type,
                                                                              gpointer self);
static void files_plugin_manager_on_plugin_directory_change_data_free (gpointer _data);
static gboolean files_plugin_manager_on_plugin_directory_change_co (FilesPluginManagerOnPluginDirectoryChangeData* _data_);
static gboolean _files_plugin_manager_on_plugin_directory_change_co_gsource_func (gpointer self);
static void files_plugin_manager_load_plugin_keyfile (FilesPluginManager* self,
                                               const gchar* path,
                                               const gchar* parent);
static void files_plugin_manager_load_module (FilesPluginManager* self,
                                       const gchar* file_path,
                                       const gchar* name);
static void files_plugin_manager_drop_menu_references (FilesPluginManager* self,
                                                GtkWidget* menu) G_GNUC_DEPRECATED ;
static void files_plugin_manager_drop_plugin_menuitems (FilesPluginManager* self);
static void files_plugin_manager_finalize (GObject * obj);
static GType files_plugin_manager_get_type_once (void);
static void _vala_files_plugin_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_files_plugin_manager_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
files_plugin_manager_get_instance_private (FilesPluginManager* self)
{
	return G_STRUCT_MEMBER_P (self, FilesPluginManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

FilesPluginManager*
files_plugin_manager_construct (GType object_type,
                                const gchar* plugin_dir,
                                guint user_id)
{
	FilesPluginManager * self = NULL;
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	gchar** _tmp4_;
	g_return_val_if_fail (plugin_dir != NULL, NULL);
	self = (FilesPluginManager*) g_object_new (object_type, NULL);
	self->priv->is_admin = user_id == ((guint) 0);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FILES_PLUGINS_TYPE_BASE, (GBoxedCopyFunc) files_plugins_base_ref, (GDestroyNotify) files_plugins_base_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->plugin_hash);
	self->priv->plugin_hash = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->names);
	self->priv->names = (GeeList*) _tmp1_;
	_tmp2_ = gee_linked_list_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	files_plugin_manager_set_menuitem_references (self, (GeeList*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	self->priv->plugin_dirs = (_vala_array_free (self->priv->plugin_dirs, self->priv->plugin_dirs_length1, (GDestroyNotify) g_free), NULL);
	self->priv->plugin_dirs = _tmp4_;
	self->priv->plugin_dirs_length1 = 0;
	self->priv->_plugin_dirs_size_ = self->priv->plugin_dirs_length1;
	if (!self->priv->is_admin) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp5_ = g_build_filename (plugin_dir, "core", NULL);
		_vala_array_add1 (&self->priv->plugin_dirs, &self->priv->plugin_dirs_length1, &self->priv->_plugin_dirs_size_, _tmp5_);
		_tmp6_ = g_strdup (plugin_dir);
		_vala_array_add2 (&self->priv->plugin_dirs, &self->priv->plugin_dirs_length1, &self->priv->_plugin_dirs_size_, _tmp6_);
		files_plugin_manager_load_plugins (self);
		_tmp7_ = self->priv->plugin_dirs;
		_tmp7__length1 = self->priv->plugin_dirs_length1;
		{
			gchar** path_collection = NULL;
			gint path_collection_length1 = 0;
			gint _path_collection_size_ = 0;
			gint path_it = 0;
			path_collection = _tmp7_;
			path_collection_length1 = _tmp7__length1;
			for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
				gchar* _tmp8_;
				gchar* path = NULL;
				_tmp8_ = g_strdup (path_collection[path_it]);
				path = _tmp8_;
				{
					const gchar* _tmp9_;
					_tmp9_ = path;
					files_plugin_manager_set_directory_monitor (self, _tmp9_);
					_g_free0 (path);
				}
			}
		}
	}
	return self;
}

FilesPluginManager*
files_plugin_manager_new (const gchar* plugin_dir,
                          guint user_id)
{
	return files_plugin_manager_construct (FILES_TYPE_PLUGIN_MANAGER, plugin_dir, user_id);
}

static void
files_plugin_manager_load_plugins (FilesPluginManager* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->plugin_dirs;
	_tmp0__length1 = self->priv->plugin_dirs_length1;
	_tmp1_ = _tmp0_[0];
	files_plugin_manager_load_modules_from_dir (self, _tmp1_);
	self->priv->in_available = TRUE;
	_tmp2_ = self->priv->plugin_dirs;
	_tmp2__length1 = self->priv->plugin_dirs_length1;
	_tmp3_ = _tmp2_[1];
	files_plugin_manager_load_modules_from_dir (self, _tmp3_);
	self->priv->in_available = FALSE;
}

static void
_files_plugin_manager_on_plugin_directory_change_g_file_monitor_changed (GFileMonitor* _sender,
                                                                         GFile* file,
                                                                         GFile* other_file,
                                                                         GFileMonitorEvent event_type,
                                                                         gpointer self)
{
	files_plugin_manager_on_plugin_directory_change ((FilesPluginManager*) self, file, other_file, event_type, NULL, NULL);
}

static void
files_plugin_manager_set_directory_monitor (FilesPluginManager* self,
                                            const gchar* path)
{
	GFile* dir = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_new_for_path (path);
	dir = _tmp0_;
	{
		GFileMonitor* monitor = NULL;
		GFileMonitor* _tmp1_;
		_tmp1_ = g_file_monitor_directory (dir, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		monitor = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_signal_connect_object (monitor, "changed", (GCallback) _files_plugin_manager_on_plugin_directory_change_g_file_monitor_changed, self, 0);
		g_object_ref ((GObject*) monitor);
		_g_object_unref0 (monitor);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = g_file_get_path (dir);
		_tmp3_ = _tmp2_;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("PluginManager.vala:75: Could not setup monitor for '%s': %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dir);
}

static void
files_plugin_manager_on_plugin_directory_change_data_free (gpointer _data)
{
	FilesPluginManagerOnPluginDirectoryChangeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->other_file);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesPluginManagerOnPluginDirectoryChangeData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_plugin_manager_on_plugin_directory_change (FilesPluginManager* self,
                                                 GFile* file,
                                                 GFile* other_file,
                                                 GFileMonitorEvent event,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	FilesPluginManagerOnPluginDirectoryChangeData* _data_;
	FilesPluginManager* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (FilesPluginManagerOnPluginDirectoryChangeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_plugin_manager_on_plugin_directory_change_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (other_file);
	_g_object_unref0 (_data_->other_file);
	_data_->other_file = _tmp2_;
	_data_->event = event;
	files_plugin_manager_on_plugin_directory_change_co (_data_);
}

static void
files_plugin_manager_on_plugin_directory_change_finish (FilesPluginManager* self,
                                                        GAsyncResult* _res_)
{
	FilesPluginManagerOnPluginDirectoryChangeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_files_plugin_manager_on_plugin_directory_change_co_gsource_func (gpointer self)
{
	gboolean result;
	result = files_plugin_manager_on_plugin_directory_change_co (self);
	return result;
}

static gboolean
files_plugin_manager_on_plugin_directory_change_co (FilesPluginManagerOnPluginDirectoryChangeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->update_queued) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->update_queued = TRUE;
	g_idle_add_full (G_PRIORITY_LOW, _files_plugin_manager_on_plugin_directory_change_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	files_plugin_manager_load_plugins (_data_->self);
	_data_->self->priv->update_queued = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_plugin_manager_load_modules_from_dir (FilesPluginManager* self,
                                            const gchar* path)
{
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFileEnumerator* enumerator = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE);
	attributes = _tmp0_;
	{
		GFile* dir = NULL;
		GFile* _tmp1_;
		GFileEnumerator* _tmp2_ = NULL;
		GFile* _tmp3_;
		const gchar* _tmp4_;
		GFileEnumerator* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileInfo* _tmp7_ = NULL;
		GFileEnumerator* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		_tmp1_ = g_file_new_for_path (path);
		dir = _tmp1_;
		_tmp3_ = dir;
		_tmp4_ = attributes;
		_tmp5_ = g_file_enumerate_children (_tmp3_, _tmp4_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp6_;
		_tmp8_ = enumerator;
		_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (info);
		info = _tmp10_;
		while (TRUE) {
			GFileInfo* _tmp11_;
			gchar* file_name = NULL;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			GFile* plugin_file = NULL;
			GFile* _tmp15_;
			const gchar* _tmp16_;
			GFile* _tmp17_;
			const gchar* _tmp18_;
			GFileInfo* _tmp22_ = NULL;
			GFileEnumerator* _tmp23_;
			GFileInfo* _tmp24_;
			GFileInfo* _tmp25_;
			_tmp11_ = info;
			if (!(_tmp11_ != NULL)) {
				break;
			}
			_tmp12_ = info;
			_tmp13_ = g_file_info_get_name (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			file_name = _tmp14_;
			_tmp15_ = dir;
			_tmp16_ = file_name;
			_tmp17_ = g_file_get_child_for_display_name (_tmp15_, _tmp16_, &_inner_error0_);
			plugin_file = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (file_name);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (dir);
				goto __catch0_g_error;
			}
			_tmp18_ = file_name;
			if (g_str_has_suffix (_tmp18_, ".plug")) {
				GFile* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp19_ = plugin_file;
				_tmp20_ = g_file_get_path (_tmp19_);
				_tmp21_ = _tmp20_;
				files_plugin_manager_load_plugin_keyfile (self, _tmp21_, path);
				_g_free0 (_tmp21_);
			}
			_tmp23_ = enumerator;
			_tmp24_ = g_file_enumerator_next_file (_tmp23_, NULL, &_inner_error0_);
			_tmp22_ = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (plugin_file);
				_g_free0 (file_name);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (dir);
				goto __catch0_g_error;
			}
			_tmp25_ = _tmp22_;
			_tmp22_ = NULL;
			_g_object_unref0 (info);
			info = _tmp25_;
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (plugin_file);
			_g_free0 (file_name);
		}
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = _error_;
		_tmp27_ = _tmp26_->message;
		g_critical ("PluginManager.vala:120: Error listing contents of folder '%s': %s", path, _tmp27_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (enumerator);
		_g_object_unref0 (info);
		_g_free0 (attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (enumerator);
	_g_object_unref0 (info);
	_g_free0 (attributes);
}

static void
files_plugin_manager_load_module (FilesPluginManager* self,
                                  const gchar* file_path,
                                  const gchar* name)
{
	GeeHashMap* _tmp0_;
	GModule* module = NULL;
	GModule* _tmp1_;
	GModule* _tmp2_;
	void* function = NULL;
	GModule* _tmp4_;
	void* _tmp5_ = NULL;
	gboolean _tmp6_;
	FilesPluginManagerModuleInitFunc module_init = NULL;
	void* _tmp8_;
	gpointer module_init_target;
	FilesPluginManagerModuleInitFunc _tmp9_;
	gpointer _tmp9__target;
	GModule* _tmp10_;
	FilesPluginsBase* plug = NULL;
	FilesPluginManagerModuleInitFunc _tmp11_;
	gpointer _tmp11__target;
	FilesPluginsBase* _tmp12_;
	GModule* _tmp13_;
	const gchar* _tmp14_;
	FilesPluginsBase* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->plugin_hash;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, file_path)) {
		g_debug ("PluginManager.vala:126: plugin for %s already loaded. Not adding again", file_path);
		return;
	}
	g_debug ("PluginManager.vala:130: Loading plugin for %s", file_path);
	_tmp1_ = g_module_open (file_path, G_MODULE_BIND_LOCAL);
	module = _tmp1_;
	_tmp2_ = module;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = g_module_error ();
		g_warning ("PluginManager.vala:134: Failed to load module from path '%s': %s", file_path, _tmp3_);
		_g_module_close0 (module);
		return;
	}
	_tmp4_ = module;
	_tmp6_ = g_module_symbol (_tmp4_, "module_init", &_tmp5_);
	function = _tmp5_;
	if (!_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = g_module_error ();
		g_warning ("PluginManager.vala:143: Failed to find entry point function '%s' in '%" \
"s': %s", "module_init", file_path, _tmp7_);
		_g_module_close0 (module);
		return;
	}
	_tmp8_ = function;
	module_init = (FilesPluginManagerModuleInitFunc) _tmp8_;
	module_init_target = NULL;
	_tmp9_ = module_init;
	_tmp9__target = module_init_target;
	_vala_assert (_tmp9_ != NULL, "module_init != null");
	_tmp10_ = module;
	g_module_make_resident (_tmp10_);
	_tmp11_ = module_init;
	_tmp11__target = module_init_target;
	_tmp12_ = _tmp11_ (_tmp11__target);
	plug = _tmp12_;
	_tmp13_ = module;
	_tmp14_ = g_module_name (_tmp13_);
	g_debug ("PluginManager.vala:157: Loaded module source: '%s'", _tmp14_);
	_tmp15_ = plug;
	if (_tmp15_ != NULL) {
		GeeHashMap* _tmp16_;
		FilesPluginsBase* _tmp17_;
		_tmp16_ = self->priv->plugin_hash;
		_tmp17_ = plug;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, file_path, _tmp17_);
	}
	if (self->priv->in_available) {
		GeeList* _tmp18_;
		_tmp18_ = self->priv->names;
		gee_collection_add ((GeeCollection*) _tmp18_, name);
	}
	_files_plugins_base_unref0 (plug);
	_g_module_close0 (module);
}

static void
files_plugin_manager_load_plugin_keyfile (FilesPluginManager* self,
                                          const gchar* path,
                                          const gchar* parent)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	{
		GKeyFile* _tmp1_;
		gchar* name = NULL;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp1_ = keyfile;
		g_key_file_load_from_file (_tmp1_, path, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = keyfile;
		_tmp3_ = g_key_file_get_string (_tmp2_, "Plugin", "Name", &_inner_error0_);
		name = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = keyfile;
		_tmp6_ = g_key_file_get_string (_tmp5_, "Plugin", "File", &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (name);
			goto __catch0_g_error;
		}
		_tmp7_ = g_build_filename (parent, _tmp4_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = name;
		files_plugin_manager_load_module (self, _tmp8_, _tmp9_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp4_);
		_g_free0 (name);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("PluginManager.vala:176: Couldn't open the keyfile '%s': %s", path, _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (keyfile);
}

void
files_plugin_manager_hook_context_menu (FilesPluginManager* self,
                                        GtkWidget* menu,
                                        GList* files)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	files_plugin_manager_drop_menu_references (self, menu);
	if (G_TYPE_CHECK_INSTANCE_TYPE (menu, gtk_menu_get_type ())) {
		files_plugin_manager_drop_plugin_menuitems (self);
	}
	{
		GeeIterator* _plugin_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->plugin_hash;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FilesPluginsBase* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FilesPluginsBase* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (FilesPluginsBase*) _tmp8_;
			_tmp9_ = plugin;
			files_plugins_base_context_menu (_tmp9_, menu, files);
			_files_plugins_base_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
}

static void
files_plugin_manager_drop_plugin_menuitems (FilesPluginManager* self)
{
	GeeList* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		GeeList* _menu_item_list = NULL;
		GeeList* _tmp0_;
		gint _menu_item_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _menu_item_index = 0;
		_tmp0_ = self->priv->_menuitem_references;
		_menu_item_list = _tmp0_;
		_tmp1_ = _menu_item_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_menu_item_size = _tmp3_;
		_menu_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GtkWidget* menu_item = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			GtkWidget* _tmp8_;
			GtkContainer* _tmp9_;
			GtkContainer* _tmp10_;
			GtkWidget* _tmp11_;
			_menu_item_index = _menu_item_index + 1;
			_tmp4_ = _menu_item_index;
			_tmp5_ = _menu_item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _menu_item_list;
			_tmp7_ = gee_list_get (_tmp6_, _menu_item_index);
			menu_item = (GtkWidget*) _tmp7_;
			_tmp8_ = menu_item;
			_tmp9_ = gtk_widget_get_parent (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = menu_item;
			gtk_container_remove (_tmp10_, _tmp11_);
			_g_object_unref0 (menu_item);
		}
	}
	_tmp12_ = self->priv->_menuitem_references;
	gee_collection_clear ((GeeCollection*) _tmp12_);
}

static void
files_plugin_manager_drop_menu_references (FilesPluginManager* self,
                                           GtkWidget* menu)
{
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->menus;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->menus;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* item = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) item_it->data);
			item = _tmp2_;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = item;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (item);
			}
		}
	}
	(self->menus == NULL) ? NULL : (self->menus = (_g_list_free__g_object_unref0_ (self->menus), NULL));
	self->menus = NULL;
}

void
files_plugin_manager_directory_loaded (FilesPluginManager* self,
                                       GtkApplicationWindow* window,
                                       FilesAbstractSlot* view,
                                       FilesFile* directory)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (directory != NULL);
	{
		GeeIterator* _plugin_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->plugin_hash;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FilesPluginsBase* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FilesPluginsBase* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (FilesPluginsBase*) _tmp8_;
			_tmp9_ = plugin;
			files_plugins_base_directory_loaded (_tmp9_, window, view, directory);
			_files_plugins_base_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
}

void
files_plugin_manager_interface_loaded (FilesPluginManager* self,
                                       GtkWidget* win)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	{
		GeeIterator* _plugin_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->plugin_hash;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FilesPluginsBase* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FilesPluginsBase* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (FilesPluginsBase*) _tmp8_;
			_tmp9_ = plugin;
			files_plugins_base_interface_loaded (_tmp9_, win);
			_files_plugins_base_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
}

void
files_plugin_manager_sidebar_loaded (FilesPluginManager* self,
                                     GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GeeIterator* _plugin_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->plugin_hash;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FilesPluginsBase* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FilesPluginsBase* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (FilesPluginsBase*) _tmp8_;
			_tmp9_ = plugin;
			files_plugins_base_sidebar_loaded (_tmp9_, widget);
			_files_plugins_base_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
}

void
files_plugin_manager_update_sidebar (FilesPluginManager* self,
                                     GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GeeIterator* _plugin_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->plugin_hash;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FilesPluginsBase* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FilesPluginsBase* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (FilesPluginsBase*) _tmp8_;
			_tmp9_ = plugin;
			files_plugins_base_update_sidebar (_tmp9_, widget);
			_files_plugins_base_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
}

void
files_plugin_manager_update_file_info (FilesPluginManager* self,
                                       FilesFile* file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GeeIterator* _plugin_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->plugin_hash;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FilesPluginsBase* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FilesPluginsBase* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (FilesPluginsBase*) _tmp8_;
			_tmp9_ = plugin;
			files_plugins_base_update_file_info (_tmp9_, file);
			_files_plugins_base_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
}

GeeList*
files_plugin_manager_get_available_plugins (FilesPluginManager* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->names;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeList*
files_plugin_manager_get_menuitem_references (FilesPluginManager* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_menuitem_references;
	result = _tmp0_;
	return result;
}

static void
files_plugin_manager_set_menuitem_references (FilesPluginManager* self,
                                              GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_plugin_manager_get_menuitem_references (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_menuitem_references);
		self->priv->_menuitem_references = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_plugin_manager_properties[FILES_PLUGIN_MANAGER_MENUITEM_REFERENCES_PROPERTY]);
	}
}

static void
files_plugin_manager_class_init (FilesPluginManagerClass * klass,
                                 gpointer klass_data)
{
	files_plugin_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesPluginManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_plugin_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_plugin_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_plugin_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_PLUGIN_MANAGER_MENUITEM_REFERENCES_PROPERTY, files_plugin_manager_properties[FILES_PLUGIN_MANAGER_MENUITEM_REFERENCES_PROPERTY] = g_param_spec_object ("menuitem-references", "menuitem-references", "menuitem-references", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
files_plugin_manager_instance_init (FilesPluginManager * self,
                                    gpointer klass)
{
	self->priv = files_plugin_manager_get_instance_private (self);
	self->priv->in_available = FALSE;
	self->priv->update_queued = FALSE;
	self->priv->is_admin = FALSE;
}

static void
files_plugin_manager_finalize (GObject * obj)
{
	FilesPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_PLUGIN_MANAGER, FilesPluginManager);
	_g_object_unref0 (self->priv->plugin_hash);
	_g_object_unref0 (self->priv->names);
	(self->menus == NULL) ? NULL : (self->menus = (_g_list_free__g_object_unref0_ (self->menus), NULL));
	_g_object_unref0 (self->priv->_menuitem_references);
	self->priv->plugin_dirs = (_vala_array_free (self->priv->plugin_dirs, self->priv->plugin_dirs_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (files_plugin_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_plugin_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesPluginManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_plugin_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesPluginManager), 0, (GInstanceInitFunc) files_plugin_manager_instance_init, NULL };
	GType files_plugin_manager_type_id;
	files_plugin_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesPluginManager", &g_define_type_info, 0);
	FilesPluginManager_private_offset = g_type_add_instance_private (files_plugin_manager_type_id, sizeof (FilesPluginManagerPrivate));
	return files_plugin_manager_type_id;
}

GType
files_plugin_manager_get_type (void)
{
	static volatile gsize files_plugin_manager_type_id__once = 0;
	if (g_once_init_enter (&files_plugin_manager_type_id__once)) {
		GType files_plugin_manager_type_id;
		files_plugin_manager_type_id = files_plugin_manager_get_type_once ();
		g_once_init_leave (&files_plugin_manager_type_id__once, files_plugin_manager_type_id);
	}
	return files_plugin_manager_type_id__once;
}

static void
_vala_files_plugin_manager_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	FilesPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_PLUGIN_MANAGER, FilesPluginManager);
	switch (property_id) {
		case FILES_PLUGIN_MANAGER_MENUITEM_REFERENCES_PROPERTY:
		g_value_set_object (value, files_plugin_manager_get_menuitem_references (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_plugin_manager_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	FilesPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_PLUGIN_MANAGER, FilesPluginManager);
	switch (property_id) {
		case FILES_PLUGIN_MANAGER_MENUITEM_REFERENCES_PROPERTY:
		files_plugin_manager_set_menuitem_references (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

