/* FileChanges.c generated by valac 0.56.18, the Vala compiler
 * generated from FileChanges.vala, do not modify */

/* Copyright 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include "pantheon-files-core.h"
#include <gio/gio.h>

#define FILES_FILE_CHANGES_CONSUME_CHANGES_MAX_CHUNK 20
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _files_file_changes_change_free0(var) ((var == NULL) ? NULL : (var = (files_file_changes_change_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

VALA_EXTERN GQueue* files_file_changes_queue;
GQueue* files_file_changes_queue = NULL;
VALA_EXTERN GMutex files_file_changes_queue_mutex;
GMutex files_file_changes_queue_mutex = {0};

static void files_file_changes_change_instance_init (FilesFileChangesChange * self);
VALA_EXTERN GQueue* files_file_changes_get_queue (void);
static void _files_file_changes_change_free0_ (gpointer var);
static inline void _g_queue_free__files_file_changes_change_free0_ (GQueue* self);
VALA_EXTERN void files_file_changes_queue_add_common (FilesFileChangesChange* new_item);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_array_unref0_ (gpointer var);
static inline void _g_list_free__g_array_unref0_ (GList* self);
static inline void _g_list_free__files_file_changes_change_free0_ (GList* self);
static void _vala_GFile_free_function_content_of (gpointer data);

 G_GNUC_NO_INLINE static GType
files_file_changes_kind_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_FILE_CHANGES_KIND_INITIAL, "FILES_FILE_CHANGES_KIND_INITIAL", "initial"}, {FILES_FILE_CHANGES_KIND_ADDED, "FILES_FILE_CHANGES_KIND_ADDED", "added"}, {FILES_FILE_CHANGES_KIND_CHANGED, "FILES_FILE_CHANGES_KIND_CHANGED", "changed"}, {FILES_FILE_CHANGES_KIND_REMOVED, "FILES_FILE_CHANGES_KIND_REMOVED", "removed"}, {FILES_FILE_CHANGES_KIND_MOVED, "FILES_FILE_CHANGES_KIND_MOVED", "moved"}, {0, NULL, NULL}};
	GType files_file_changes_kind_type_id;
	files_file_changes_kind_type_id = g_enum_register_static ("FilesFileChangesKind", values);
	return files_file_changes_kind_type_id;
}

GType
files_file_changes_kind_get_type (void)
{
	static volatile gsize files_file_changes_kind_type_id__once = 0;
	if (g_once_init_enter (&files_file_changes_kind_type_id__once)) {
		GType files_file_changes_kind_type_id;
		files_file_changes_kind_type_id = files_file_changes_kind_get_type_once ();
		g_once_init_leave (&files_file_changes_kind_type_id__once, files_file_changes_kind_type_id);
	}
	return files_file_changes_kind_type_id__once;
}

FilesFileChangesChange*
files_file_changes_change_new (void)
{
	FilesFileChangesChange* self;
	self = g_slice_new0 (FilesFileChangesChange);
	files_file_changes_change_instance_init (self);
	return self;
}

static void
files_file_changes_change_instance_init (FilesFileChangesChange * self)
{
}

void
files_file_changes_change_free (FilesFileChangesChange * self)
{
	_g_object_unref0 (self->from);
	_g_object_unref0 (self->to);
	g_slice_free (FilesFileChangesChange, self);
}

static void
_files_file_changes_change_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_file_changes_change_free (var), NULL));
}

static inline void
_g_queue_free__files_file_changes_change_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _files_file_changes_change_free0_);
}

GQueue*
files_file_changes_get_queue (void)
{
	GQueue* _tmp0_;
	GQueue* _tmp2_;
	GQueue* result;
	g_mutex_lock (&files_file_changes_queue_mutex);
	_tmp0_ = files_file_changes_queue;
	if (_tmp0_ == NULL) {
		GQueue* _tmp1_;
		_tmp1_ = g_queue_new ();
		(files_file_changes_queue == NULL) ? NULL : (files_file_changes_queue = (_g_queue_free__files_file_changes_change_free0_ (files_file_changes_queue), NULL));
		files_file_changes_queue = _tmp1_;
	}
	g_mutex_unlock (&files_file_changes_queue_mutex);
	_tmp2_ = files_file_changes_queue;
	result = _tmp2_;
	return result;
}

void
files_file_changes_queue_add_common (FilesFileChangesChange* new_item)
{
	GQueue* queue = NULL;
	GQueue* _tmp0_;
	FilesFileChangesChange* last_item = NULL;
	GQueue* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	FilesFileChangesChange* _tmp5_;
	g_return_if_fail (new_item != NULL);
	_tmp0_ = files_file_changes_get_queue ();
	queue = _tmp0_;
	g_mutex_lock (&files_file_changes_queue_mutex);
	_tmp1_ = queue;
	_tmp2_ = g_queue_peek_head (_tmp1_);
	last_item = (FilesFileChangesChange*) _tmp2_;
	_tmp5_ = last_item;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		FilesFileChangesChange* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp6_ = last_item;
		_tmp7_ = _tmp6_->from;
		_tmp8_ = new_item->from;
		_tmp4_ = !g_file_equal (_tmp7_, _tmp8_);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		FilesFileChangesChange* _tmp9_;
		_tmp9_ = last_item;
		_tmp3_ = _tmp9_->kind != new_item->kind;
	}
	if (_tmp3_) {
		GQueue* _tmp10_;
		FilesFileChangesChange* _tmp11_;
		_tmp10_ = queue;
		_tmp11_ = new_item;
		new_item = NULL;
		g_queue_push_head (_tmp10_, _tmp11_);
	}
	g_mutex_unlock (&files_file_changes_queue_mutex);
	_files_file_changes_change_free0 (new_item);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
files_file_changes_queue_file_added (GFile* location,
                                     gboolean internal_origin)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_ADDED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = internal_origin;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_file_changed (GFile* location)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_CHANGED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = TRUE;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_file_removed (GFile* location)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	FilesFileChangesChange* _tmp1_ = NULL;
	FilesFileChangesChange* _tmp2_;
	g_return_if_fail (location != NULL);
	_tmp0_ = _g_object_ref0 (location);
	_tmp1_ = files_file_changes_change_new ();
	_tmp1_->kind = FILES_FILE_CHANGES_KIND_REMOVED;
	_g_object_unref0 (_tmp1_->from);
	_tmp1_->from = _tmp0_;
	_tmp1_->is_internal = TRUE;
	new_item = _tmp1_;
	_tmp2_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp2_);
	_files_file_changes_change_free0 (new_item);
}

void
files_file_changes_queue_file_moved (GFile* from,
                                     GFile* to)
{
	FilesFileChangesChange* new_item = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	FilesFileChangesChange* _tmp2_ = NULL;
	FilesFileChangesChange* _tmp3_;
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = _g_object_ref0 (from);
	_tmp1_ = _g_object_ref0 (to);
	_tmp2_ = files_file_changes_change_new ();
	_tmp2_->kind = FILES_FILE_CHANGES_KIND_MOVED;
	_g_object_unref0 (_tmp2_->from);
	_tmp2_->from = _tmp0_;
	_g_object_unref0 (_tmp2_->to);
	_tmp2_->to = _tmp1_;
	_tmp2_->is_internal = TRUE;
	new_item = _tmp2_;
	_tmp3_ = new_item;
	new_item = NULL;
	files_file_changes_queue_add_common (_tmp3_);
	_files_file_changes_change_free0 (new_item);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_g_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_array_unref (var), NULL));
}

static inline void
_g_list_free__g_array_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_array_unref0_);
}

static inline void
_g_list_free__files_file_changes_change_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _files_file_changes_change_free0_);
}

static void
_vala_GFile_free_function_content_of (gpointer data)
{
	GFile* self;
	self = *((GFile**) data);
	_g_object_unref0_ (self);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

void
files_file_changes_consume_changes (gboolean consume_all)
{
	GQueue* queue = NULL;
	GQueue* _tmp0_;
	guint chunk_count = 0U;
	gboolean flush_needed = FALSE;
	GList* changes = NULL;
	GList* deletions = NULL;
	GList* moves = NULL;
	GList* additions = NULL;
	_tmp0_ = files_file_changes_get_queue ();
	queue = _tmp0_;
	changes = NULL;
	deletions = NULL;
	moves = NULL;
	additions = NULL;
	{
		gboolean _tmp1_ = FALSE;
		chunk_count = (guint) 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			FilesFileChangesChange* change = NULL;
			GQueue* _tmp3_;
			gpointer _tmp4_;
			FilesFileChangesChange* _tmp5_;
			FilesFileChangesChange* _tmp27_;
			FilesFileChangesChange* _tmp28_;
			if (!_tmp1_) {
				guint _tmp2_;
				_tmp2_ = chunk_count;
				chunk_count = _tmp2_ + 1;
			}
			_tmp1_ = FALSE;
			g_mutex_lock (&files_file_changes_queue_mutex);
			_tmp3_ = queue;
			_tmp4_ = g_queue_pop_tail (_tmp3_);
			change = (FilesFileChangesChange*) _tmp4_;
			g_mutex_unlock (&files_file_changes_queue_mutex);
			_tmp5_ = change;
			if (_tmp5_ == NULL) {
				flush_needed = TRUE;
			} else {
				gboolean _tmp6_ = FALSE;
				GList* _tmp7_;
				gboolean _tmp9_ = FALSE;
				GList* _tmp10_;
				gboolean _tmp12_ = FALSE;
				GList* _tmp13_;
				gboolean _tmp15_ = FALSE;
				GList* _tmp16_;
				gboolean _tmp18_ = FALSE;
				_tmp7_ = additions;
				if (_tmp7_ != NULL) {
					FilesFileChangesChange* _tmp8_;
					_tmp8_ = change;
					_tmp6_ = _tmp8_->kind != FILES_FILE_CHANGES_KIND_ADDED;
				} else {
					_tmp6_ = FALSE;
				}
				flush_needed = _tmp6_;
				_tmp10_ = changes;
				if (_tmp10_ != NULL) {
					FilesFileChangesChange* _tmp11_;
					_tmp11_ = change;
					_tmp9_ = _tmp11_->kind != FILES_FILE_CHANGES_KIND_CHANGED;
				} else {
					_tmp9_ = FALSE;
				}
				flush_needed |= _tmp9_;
				_tmp13_ = moves;
				if (_tmp13_ != NULL) {
					FilesFileChangesChange* _tmp14_;
					_tmp14_ = change;
					_tmp12_ = _tmp14_->kind != FILES_FILE_CHANGES_KIND_MOVED;
				} else {
					_tmp12_ = FALSE;
				}
				flush_needed |= _tmp12_;
				_tmp16_ = deletions;
				if (_tmp16_ != NULL) {
					FilesFileChangesChange* _tmp17_;
					_tmp17_ = change;
					_tmp15_ = _tmp17_->kind != FILES_FILE_CHANGES_KIND_REMOVED;
				} else {
					_tmp15_ = FALSE;
				}
				flush_needed |= _tmp15_;
				if (!consume_all) {
					_tmp18_ = chunk_count >= ((guint) FILES_FILE_CHANGES_CONSUME_CHANGES_MAX_CHUNK);
				} else {
					_tmp18_ = FALSE;
				}
				flush_needed |= _tmp18_;
			}
			if (flush_needed) {
				GList* _tmp19_;
				GList* _tmp21_;
				GList* _tmp23_;
				GList* _tmp25_;
				_tmp19_ = deletions;
				if (_tmp19_ != NULL) {
					GList* _tmp20_;
					deletions = g_list_reverse (deletions);
					_tmp20_ = deletions;
					files_directory_notify_files_removed (_tmp20_);
					(deletions == NULL) ? NULL : (deletions = (_g_list_free__g_object_unref0_ (deletions), NULL));
					deletions = NULL;
				}
				_tmp21_ = moves;
				if (_tmp21_ != NULL) {
					GList* _tmp22_;
					moves = g_list_reverse (moves);
					_tmp22_ = moves;
					files_directory_notify_files_moved (_tmp22_);
					(moves == NULL) ? NULL : (moves = (_g_list_free__g_array_unref0_ (moves), NULL));
					moves = NULL;
				}
				_tmp23_ = additions;
				if (_tmp23_ != NULL) {
					GList* _tmp24_;
					additions = g_list_reverse (additions);
					_tmp24_ = additions;
					files_directory_notify_changes_added (_tmp24_);
					(additions == NULL) ? NULL : (additions = (_g_list_free__files_file_changes_change_free0_ (additions), NULL));
					additions = NULL;
				}
				_tmp25_ = changes;
				if (_tmp25_ != NULL) {
					GList* _tmp26_;
					changes = g_list_reverse (changes);
					_tmp26_ = changes;
					files_directory_notify_files_changed (_tmp26_);
					(changes == NULL) ? NULL : (changes = (_g_list_free__g_object_unref0_ (changes), NULL));
					changes = NULL;
				}
			}
			_tmp27_ = change;
			if (_tmp27_ == NULL) {
				_files_file_changes_change_free0 (change);
				(additions == NULL) ? NULL : (additions = (_g_list_free__files_file_changes_change_free0_ (additions), NULL));
				(moves == NULL) ? NULL : (moves = (_g_list_free__g_array_unref0_ (moves), NULL));
				(deletions == NULL) ? NULL : (deletions = (_g_list_free__g_object_unref0_ (deletions), NULL));
				(changes == NULL) ? NULL : (changes = (_g_list_free__g_object_unref0_ (changes), NULL));
				return;
			}
			_tmp28_ = change;
			switch (_tmp28_->kind) {
				case FILES_FILE_CHANGES_KIND_ADDED:
				{
					GList* _tmp29_;
					FilesFileChangesChange* _tmp30_;
					_tmp29_ = additions;
					if (_tmp29_ == NULL) {
						(additions == NULL) ? NULL : (additions = (_g_list_free__files_file_changes_change_free0_ (additions), NULL));
						additions = NULL;
					}
					_tmp30_ = change;
					change = NULL;
					additions = g_list_prepend (additions, _tmp30_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_CHANGED:
				{
					GList* _tmp31_;
					FilesFileChangesChange* _tmp32_;
					GFile* _tmp33_;
					GFile* _tmp34_;
					_tmp31_ = changes;
					if (_tmp31_ == NULL) {
						(changes == NULL) ? NULL : (changes = (_g_list_free__g_object_unref0_ (changes), NULL));
						changes = NULL;
					}
					_tmp32_ = change;
					_tmp33_ = _tmp32_->from;
					_tmp34_ = _g_object_ref0 (_tmp33_);
					changes = g_list_prepend (changes, _tmp34_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_REMOVED:
				{
					GList* _tmp35_;
					FilesFileChangesChange* _tmp36_;
					GFile* _tmp37_;
					GFile* _tmp38_;
					_tmp35_ = deletions;
					if (_tmp35_ == NULL) {
						(deletions == NULL) ? NULL : (deletions = (_g_list_free__g_object_unref0_ (deletions), NULL));
						deletions = NULL;
					}
					_tmp36_ = change;
					_tmp37_ = _tmp36_->from;
					_tmp38_ = _g_object_ref0 (_tmp37_);
					deletions = g_list_prepend (deletions, _tmp38_);
					break;
				}
				case FILES_FILE_CHANGES_KIND_MOVED:
				{
					GList* _tmp39_;
					GArray* pair = NULL;
					GArray* _tmp40_;
					GArray* _tmp41_;
					FilesFileChangesChange* _tmp42_;
					GFile* _tmp43_;
					GFile* _tmp44_;
					GArray* _tmp45_;
					FilesFileChangesChange* _tmp46_;
					GFile* _tmp47_;
					GFile* _tmp48_;
					GArray* _tmp49_;
					GArray* _tmp50_;
					_tmp39_ = moves;
					if (_tmp39_ == NULL) {
						(moves == NULL) ? NULL : (moves = (_g_list_free__g_array_unref0_ (moves), NULL));
						moves = NULL;
					}
					_tmp40_ = g_array_sized_new (FALSE, FALSE, sizeof (GFile*), (guint) 2);
					g_array_set_clear_func (_tmp40_, (GDestroyNotify) _vala_GFile_free_function_content_of);
					pair = _tmp40_;
					_tmp41_ = pair;
					_tmp42_ = change;
					_tmp43_ = _tmp42_->from;
					_tmp44_ = _g_object_ref0 (_tmp43_);
					g_array_append_val (_tmp41_, _tmp44_);
					_tmp45_ = pair;
					_tmp46_ = change;
					_tmp47_ = _tmp46_->to;
					_tmp48_ = _g_object_ref0 (_tmp47_);
					g_array_append_val (_tmp45_, _tmp48_);
					_tmp49_ = pair;
					_tmp50_ = _g_array_ref0 (_tmp49_);
					moves = g_list_prepend (moves, _tmp50_);
					_g_array_unref0 (pair);
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			_files_file_changes_change_free0 (change);
		}
	}
}

