/* DndHandler.c generated by valac 0.56.18, the Vala compiler
 * generated from DndHandler.vala, do not modify */

#include "pantheon-files-core.h"
#include <gdk/gdk.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "marlin-file-operations.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#define FILES_DND_HANDLER_MAX_FILES_CHECKED ((guint) 100)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_DND_HANDLER_0_PROPERTY,
	FILES_DND_HANDLER_NUM_PROPERTIES
};
static GParamSpec* files_dnd_handler_properties[FILES_DND_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FilesDndHandlerPrivate {
	GdkDragAction chosen;
};

struct _Block9Data {
	int _ref_count_;
	FilesDndHandler* self;
	GMainLoop* loop;
	GtkApplicationWindow* win;
};

struct _Block10Data {
	int _ref_count_;
	FilesDndHandler* self;
	GdkDragAction* action;
};

struct _Block11Data {
	int _ref_count_;
	GString* sb;
	gboolean keep_protocol;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	gboolean in_recent;
};

static gint FilesDndHandler_private_offset;
static gpointer files_dnd_handler_parent_class = NULL;

static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void files_dnd_handler_add_action (FilesDndHandler* self,
                                   GtkApplicationWindow* win);
static GtkMenu* files_dnd_handler_build_menu (FilesDndHandler* self,
                                       GdkDragAction possible_actions);
static void __lambda34_ (Block9Data* _data9_);
static void files_dnd_handler_remove_action (FilesDndHandler* self,
                                      GtkApplicationWindow* win);
static void ___lambda34__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                             gpointer self);
static GdkDragAction* _gdk_drag_action_dup (GdkDragAction* self);
static void _files_dnd_handler_on_choice_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static void files_dnd_handler_build_and_append_menu_item (FilesDndHandler* self,
                                                   GtkMenu* menu,
                                                   const gchar* label,
                                                   GdkDragAction* action,
                                                   GdkDragAction possible_actions);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void ___lambda33_ (Block10Data* _data10_);
static void ____lambda33__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void files_dnd_handler_set_stringbuilder_from_file_list (GString* sb,
                                                         GList* file_list,
                                                         gboolean keep_protocol);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void ___lambda35_ (Block12Data* _data12_,
                   FilesFile* file);
static void ____lambda35__gfunc (gconstpointer data,
                          gpointer self);
static GdkDragAction files_dnd_handler_valid_actions_for_file_list (GFile* target_location,
                                                             GList* drop_file_list,
                                                             GdkDragAction* suggested_action);
VALA_EXTERN gboolean files_file_utils_same_file_system (GFile* a,
                                            GFile* b);
static void files_dnd_handler_finalize (GObject * obj);
static GType files_dnd_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_dnd_handler_get_instance_private (FilesDndHandler* self)
{
	return G_STRUCT_MEMBER_P (self, FilesDndHandler_private_offset);
}

FilesDndHandler*
files_dnd_handler_construct (GType object_type)
{
	FilesDndHandler * self = NULL;
	self = (FilesDndHandler*) g_object_new (object_type, NULL);
	return self;
}

FilesDndHandler*
files_dnd_handler_new (void)
{
	return files_dnd_handler_construct (FILES_TYPE_DND_HANDLER);
}

gboolean
files_dnd_handler_dnd_perform (FilesDndHandler* self,
                               GtkWidget* widget,
                               FilesFile* drop_target,
                               GList* drop_file_list,
                               GdkDragAction action)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (drop_target != NULL, FALSE);
	_vala_return_val_if_fail ((drop_target != NULL) && (drop_file_list != NULL), "drop_target != null && drop_file_list != null", FALSE);
	if (files_file_is_folder (drop_target)) {
		GFile* _tmp0_;
		_tmp0_ = files_file_get_target_location (drop_target);
		marlin_file_operations_copy_move_link (drop_file_list, _tmp0_, action, widget, NULL, NULL, NULL);
		result = TRUE;
		return result;
	} else {
		if (files_file_is_executable (drop_target)) {
			gboolean _tmp9_ = FALSE;
			{
				files_file_execute (drop_target, drop_file_list, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				result = TRUE;
				return result;
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* target_name = NULL;
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				GError* _tmp5_;
				const gchar* _tmp6_;
				GraniteMessageDialog* _tmp7_;
				GraniteMessageDialog* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp1_ = files_file_get_display_name (drop_target);
				target_name = _tmp1_;
				_tmp2_ = target_name;
				_tmp3_ = g_strdup_printf (_ ("Failed to execute \"%s\""), _tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = e;
				_tmp6_ = _tmp5_->message;
				_tmp7_ = pf_dialogs_show_error_dialog (_tmp4_, _tmp6_, NULL);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp8_);
				_g_free0 (_tmp4_);
				result = FALSE;
				_g_error_free0 (e);
				return result;
			}
			__finally0:
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		FilesDndHandler* self;
		self = _data9_->self;
		_g_main_loop_unref0 (_data9_->loop);
		_g_object_unref0 (_data9_->win);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda34_ (Block9Data* _data9_)
{
	FilesDndHandler* self;
	self = _data9_->self;
	if (g_main_loop_is_running (_data9_->loop)) {
		g_main_loop_quit (_data9_->loop);
	}
	files_dnd_handler_remove_action (self, G_TYPE_CHECK_INSTANCE_CAST (_data9_->win, gtk_application_window_get_type (), GtkApplicationWindow));
}

static void
___lambda34__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                        gpointer self)
{
	__lambda34_ (self);
}

static GdkDragAction*
_gdk_drag_action_dup (GdkDragAction* self)
{
	GdkDragAction* dup;
	dup = g_new0 (GdkDragAction, 1);
	memcpy (dup, self, sizeof (GdkDragAction));
	return dup;
}

static gpointer
__gdk_drag_action_dup0 (gpointer self)
{
	return self ? _gdk_drag_action_dup (self) : NULL;
}

GdkDragAction*
files_dnd_handler_drag_drop_action_ask (FilesDndHandler* self,
                                        GtkWidget* dest_widget,
                                        GtkApplicationWindow* win,
                                        GdkDragAction possible_actions)
{
	Block9Data* _data9_;
	GtkApplicationWindow* _tmp0_;
	GtkMenu* ask_menu = NULL;
	GtkMenu* _tmp1_;
	GdkScreen* _tmp2_;
	GMainLoop* _tmp3_;
	GdkDragAction* _tmp4_;
	GdkDragAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dest_widget != NULL, NULL);
	g_return_val_if_fail (win != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (_data9_->win);
	_data9_->win = _tmp0_;
	self->priv->chosen = GDK_ACTION_DEFAULT;
	files_dnd_handler_add_action (self, _data9_->win);
	_tmp1_ = files_dnd_handler_build_menu (self, possible_actions);
	ask_menu = _tmp1_;
	_tmp2_ = gtk_widget_get_screen (dest_widget);
	gtk_menu_set_screen (ask_menu, _tmp2_);
	gtk_widget_show_all ((GtkWidget*) ask_menu);
	_tmp3_ = g_main_loop_new (NULL, FALSE);
	_data9_->loop = _tmp3_;
	g_signal_connect_data ((GtkMenuShell*) ask_menu, "deactivate", (GCallback) ___lambda34__gtk_menu_shell_deactivate, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	gtk_menu_popup_at_pointer (ask_menu, NULL);
	g_main_loop_run (_data9_->loop);
	gtk_grab_remove ((GtkWidget*) ask_menu);
	_tmp4_ = __gdk_drag_action_dup0 (&self->priv->chosen);
	result = _tmp4_;
	_g_object_unref0 (ask_menu);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}

static void
_files_dnd_handler_on_choice_g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	files_dnd_handler_on_choice ((FilesDndHandler*) self, parameter);
}

static void
files_dnd_handler_add_action (FilesDndHandler* self,
                              GtkApplicationWindow* win)
{
	GSimpleAction* action = NULL;
	const GVariantType* _tmp0_;
	GSimpleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_tmp1_ = g_simple_action_new ("choice", _tmp0_);
	action = _tmp1_;
	g_signal_connect_object (action, "activate", (GCallback) _files_dnd_handler_on_choice_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) win, (GAction*) action);
	_g_object_unref0 (action);
}

static void
files_dnd_handler_remove_action (FilesDndHandler* self,
                                 GtkApplicationWindow* win)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	g_action_map_remove_action ((GActionMap*) win, "choice");
}

static GtkMenu*
files_dnd_handler_build_menu (FilesDndHandler* self,
                              GdkDragAction possible_actions)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GdkDragAction _tmp1_;
	GdkDragAction _tmp2_;
	GdkDragAction _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = GDK_ACTION_MOVE;
	files_dnd_handler_build_and_append_menu_item (self, menu, _ ("Move Here"), &_tmp1_, possible_actions);
	_tmp2_ = GDK_ACTION_COPY;
	files_dnd_handler_build_and_append_menu_item (self, menu, _ ("Copy Here"), &_tmp2_, possible_actions);
	_tmp3_ = GDK_ACTION_LINK;
	files_dnd_handler_build_and_append_menu_item (self, menu, _ ("Link Here"), &_tmp3_, possible_actions);
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp7_);
	_g_object_unref0 (_tmp7_);
	result = menu;
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		FilesDndHandler* self;
		self = _data10_->self;
		_g_free0 (_data10_->action);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
___lambda33_ (Block10Data* _data10_)
{
	FilesDndHandler* self;
	self = _data10_->self;
	self->priv->chosen = *_data10_->action;
}

static void
____lambda33__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda33_ (self);
}

static void
files_dnd_handler_build_and_append_menu_item (FilesDndHandler* self,
                                              GtkMenu* menu,
                                              const gchar* label,
                                              GdkDragAction* action,
                                              GdkDragAction possible_actions)
{
	Block10Data* _data10_;
	GdkDragAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (label != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = __gdk_drag_action_dup0 (action);
	_g_free0 (_data10_->action);
	_data10_->action = _tmp0_;
	if ((possible_actions & (*_data10_->action)) != 0) {
		GtkMenuItem* item = NULL;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (label);
		g_object_ref_sink (_tmp1_);
		item = _tmp1_;
		_tmp2_ = item;
		g_signal_connect_data (_tmp2_, "activate", (GCallback) ____lambda33__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
		_tmp3_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp3_);
		_g_object_unref0 (item);
	}
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

void
files_dnd_handler_on_choice (FilesDndHandler* self,
                             GVariant* param)
{
	gboolean _tmp0_ = FALSE;
	gchar* choice = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	g_return_if_fail (self != NULL);
	if (param == NULL) {
		_tmp0_ = TRUE;
	} else {
		const GVariantType* _tmp1_;
		_tmp1_ = G_VARIANT_TYPE_STRING;
		_tmp0_ = !g_variant_is_of_type (param, _tmp1_);
	}
	if (_tmp0_) {
		g_critical ("DndHandler.vala:126: Invalid variant type in DndHandler Menu");
		return;
	}
	_tmp2_ = g_variant_get_string (param, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	choice = _tmp3_;
	_tmp4_ = choice;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("move")))) {
		switch (0) {
			default:
			{
				self->priv->chosen = GDK_ACTION_MOVE;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("copy")))) {
		switch (0) {
			default:
			{
				self->priv->chosen = GDK_ACTION_COPY;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("link")))) {
		switch (0) {
			default:
			{
				self->priv->chosen = GDK_ACTION_LINK;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				self->priv->chosen = GDK_ACTION_DEFAULT;
				break;
			}
		}
	}
	_g_free0 (choice);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
files_dnd_handler_get_source_filename (FilesDndHandler* self,
                                       GdkWindow* source_window)
{
	guchar* data = NULL;
	gint data_length1;
	gint _data_size_;
	GdkAtom property_name = (GdkAtom) 0U;
	GdkAtom property_type = (GdkAtom) 0U;
	gboolean exists = FALSE;
	guint8* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_window != NULL, NULL);
	data = NULL;
	data_length1 = 0;
	_data_size_ = data_length1;
	property_name = gdk_atom_intern_static_string ("XdndDirectSave0");
	property_type = gdk_atom_intern_static_string ("text/plain");
	_tmp2_ = gdk_property_get (source_window, property_name, property_type, (gulong) 0, (gulong) 1024, 0, NULL, NULL, &_tmp1_, &_tmp0_);
	data = (g_free (data), NULL);
	data = _tmp0_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	exists = _tmp2_;
	if (exists) {
		guchar* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = data;
		_tmp4__length1 = data_length1;
		_tmp3_ = _tmp4_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* name = NULL;
		guchar* _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = data;
		_tmp5__length1 = data_length1;
		_tmp6_ = files_dnd_handler_data_to_string (_tmp5_, (gint) _tmp5__length1);
		name = _tmp6_;
		_tmp7_ = name;
		_tmp8_ = g_strdup_printf ("%c", G_DIR_SEPARATOR);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_contains (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			g_warning ("DndHandler.vala:168: invalid source filename");
			result = NULL;
			_g_free0 (name);
			data = (g_free (data), NULL);
			return result;
		} else {
			result = name;
			data = (g_free (data), NULL);
			return result;
		}
		_g_free0 (name);
	} else {
		g_warning ("DndHandler.vala:174: source file does not exist");
		result = NULL;
		data = (g_free (data), NULL);
		return result;
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
files_dnd_handler_set_source_uri (FilesDndHandler* self,
                                  GdkWindow* source_window,
                                  const gchar* uri)
{
	GdkAtom property_name = (GdkAtom) 0U;
	GdkAtom property_type = (GdkAtom) 0U;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_window != NULL);
	g_return_if_fail (uri != NULL);
	g_debug ("DndHandler.vala:180: DNDHANDLER: set source uri to %s", uri);
	property_name = gdk_atom_intern_static_string ("XdndDirectSave0");
	property_type = gdk_atom_intern_static_string ("text/plain");
	_tmp0_ = string_get_data (uri, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = strlen (uri);
	_tmp4_ = _tmp3_;
	gdk_property_change (source_window, property_name, property_type, 8, GDK_PROP_MODE_REPLACE, (const guchar*) _tmp2_, _tmp4_);
}

gboolean
files_dnd_handler_handle_xdnddirectsave (FilesDndHandler* self,
                                         GdkWindow* source_window,
                                         FilesFile* drop_target,
                                         GtkSelectionData* selection)
{
	gboolean success = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_window != NULL, FALSE);
	g_return_val_if_fail (drop_target != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	success = FALSE;
	if (selection != NULL) {
		_tmp1_ = gtk_selection_data_get_length (selection) == 1;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = gtk_selection_data_get_format (selection) == 8;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guchar _result_ = '\0';
		guint8* _tmp2_;
		guint8 _tmp3_;
		_tmp2_ = gtk_selection_data_get_data (selection);
		_tmp3_ = _tmp2_[0];
		_result_ = (guchar) _tmp3_;
		switch (_result_) {
			case 'F':
			{
				break;
			}
			case 'E':
			{
				success = TRUE;
				break;
			}
			case 'S':
			{
				success = TRUE;
				break;
			}
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = g_strdup_printf ("%hhu", _result_);
				_tmp5_ = _tmp4_;
				g_warning ("DndHandler.vala:216: Unhandled XdndDirectSave result %s", _tmp5_);
				_g_free0 (_tmp5_);
				break;
			}
		}
	}
	if (!success) {
		files_dnd_handler_set_source_uri (self, source_window, "");
	}
	result = success;
	return result;
}

gboolean
files_dnd_handler_handle_netscape_url (FilesDndHandler* self,
                                       GdkWindow* source_window,
                                       FilesFile* drop_target,
                                       GtkSelectionData* selection)
{
	gchar** parts = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_window != NULL, FALSE);
	g_return_val_if_fail (drop_target != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	_tmp0_ = gtk_selection_data_get_text (selection);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	parts = _tmp4_;
	parts_length1 = _tmp4__length1;
	_parts_size_ = parts_length1;
	_tmp5_ = parts;
	_tmp5__length1 = parts_length1;
	if (_tmp5__length1 != 2) {
		result = FALSE;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = FALSE;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gboolean
files_dnd_handler_handle_file_drag_actions (FilesDndHandler* self,
                                            GtkWidget* dest_widget,
                                            FilesFile* drop_target,
                                            GList* drop_file_list,
                                            GdkDragAction possible_actions,
                                            GdkDragAction suggested_action,
                                            GtkApplicationWindow* win,
                                            guint32 timestamp)
{
	gboolean success = FALSE;
	GdkDragAction action = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dest_widget != NULL, FALSE);
	g_return_val_if_fail (drop_target != NULL, FALSE);
	g_return_val_if_fail (win != NULL, FALSE);
	success = FALSE;
	action = suggested_action;
	if (drop_file_list != NULL) {
		if ((possible_actions & GDK_ACTION_ASK) != 0) {
			GdkDragAction* _tmp0_;
			GdkDragAction* _tmp1_;
			_tmp0_ = files_dnd_handler_drag_drop_action_ask (self, dest_widget, win, possible_actions);
			_tmp1_ = _tmp0_;
			action = *_tmp1_;
			_g_free0 (_tmp1_);
		}
		if (action != GDK_ACTION_DEFAULT) {
			success = files_dnd_handler_dnd_perform (self, dest_widget, drop_target, drop_file_list, action);
		}
	} else {
		g_critical ("DndHandler.vala:264: Attempt to drop null file list");
	}
	result = success;
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

gboolean
files_dnd_handler_selection_data_is_uri_list (GtkSelectionData* selection_data,
                                              guint info,
                                              gchar** text)
{
	gchar* _vala_text = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean result;
	g_return_val_if_fail (selection_data != NULL, FALSE);
	_g_free0 (_vala_text);
	_vala_text = NULL;
	if (info == ((guint) FILES_TARGET_TYPE_TEXT_URI_LIST)) {
		_tmp2_ = selection_data != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = gtk_selection_data_get_length (selection_data) > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = gtk_selection_data_get_format (selection_data) == 8;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp3_ = 0;
		guint8* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = gtk_selection_data_get_data_with_length (selection_data, &_tmp3_);
		_tmp5_ = files_dnd_handler_data_to_string (_tmp4_, (gint) _tmp3_);
		_g_free0 (_vala_text);
		_vala_text = _tmp5_;
	}
	_tmp6_ = _vala_text;
	_tmp7_ = bool_to_string (_tmp6_ != NULL);
	_tmp8_ = _tmp7_;
	g_debug ("DndHandler.vala:283: DNDHANDLER selection data is uri list returning %" \
"s", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = _vala_text;
	result = _tmp9_ != NULL;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	return result;
}

gchar*
files_dnd_handler_data_to_string (guchar* cdata,
                                  gint cdata_length1)
{
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	{
		guchar* u_collection = NULL;
		gint u_collection_length1 = 0;
		gint _u_collection_size_ = 0;
		gint u_it = 0;
		u_collection = cdata;
		u_collection_length1 = cdata_length1;
		for (u_it = 0; u_it < u_collection_length1; u_it = u_it + 1) {
			guchar u = '\0';
			u = u_collection[u_it];
			{
				GString* _tmp1_;
				_tmp1_ = sb;
				g_string_append_c (_tmp1_, (gchar) u);
			}
		}
	}
	_tmp2_ = sb;
	_tmp3_ = _tmp2_->str;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_g_string_free0 (sb);
	return result;
}

static guint8*
g_string_get_data (GString* self,
                   gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	const gchar* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->str;
	res = (guint8*) _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) self->len;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

void
files_dnd_handler_set_selection_data_from_file_list (GtkSelectionData* selection_data,
                                                     GList* file_list,
                                                     const gchar* prefix)
{
	GString* sb = NULL;
	GString* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (selection_data != NULL);
	g_return_if_fail (prefix != NULL);
	_tmp0_ = g_string_new (prefix);
	sb = _tmp0_;
	files_dnd_handler_set_stringbuilder_from_file_list (sb, file_list, TRUE);
	_tmp1_ = g_string_get_data (sb, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	gtk_selection_data_set (selection_data, gtk_selection_data_get_target (selection_data), 8, _tmp3_, (gint) _tmp3__length1);
	_g_string_free0 (sb);
}

void
files_dnd_handler_set_selection_text_from_file_list (GtkSelectionData* selection_data,
                                                     GList* file_list,
                                                     const gchar* prefix)
{
	GString* sb = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (selection_data != NULL);
	g_return_if_fail (prefix != NULL);
	_tmp0_ = g_string_new (prefix);
	sb = _tmp0_;
	files_dnd_handler_set_stringbuilder_from_file_list (sb, file_list, FALSE);
	g_string_truncate (sb, (gsize) (sb->len - 2));
	_tmp1_ = sb->str;
	gtk_selection_data_set_text (selection_data, _tmp1_, (gint) sb->len);
	_g_string_free0 (sb);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		g_slice_free (Block11Data, _data11_);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static void
___lambda35_ (Block12Data* _data12_,
              FilesFile* file)
{
	Block11Data* _data11_;
	gchar* _tmp0_ = NULL;
	gchar* target = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	_data11_ = _data12_->_data11_;
	g_return_if_fail (file != NULL);
	if (_data12_->in_recent) {
		gchar* _tmp1_;
		_tmp1_ = files_file_get_display_target_uri (file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GFile* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = files_file_get_target_location (file);
		_tmp3_ = g_file_get_uri (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	target = _tmp4_;
	_tmp5_ = target;
	_tmp6_ = files_file_utils_sanitize_path (_tmp5_, NULL, _data11_->keep_protocol);
	_g_free0 (target);
	target = _tmp6_;
	_tmp7_ = target;
	_tmp8_ = g_shell_quote (_tmp7_);
	_tmp9_ = _tmp8_;
	g_string_append (_data11_->sb, _tmp9_);
	_g_free0 (_tmp9_);
	g_string_append (_data11_->sb, "\r\n");
	_g_free0 (target);
	_g_free0 (_tmp0_);
}

static void
____lambda35__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda35_ (self, (FilesFile*) data);
}

static void
files_dnd_handler_set_stringbuilder_from_file_list (GString* sb,
                                                    GList* file_list,
                                                    gboolean keep_protocol)
{
	Block11Data* _data11_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (sb != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->sb = sb;
	_data11_->keep_protocol = keep_protocol;
	if (file_list != NULL) {
		gconstpointer _tmp2_;
		_tmp2_ = file_list->data;
		_tmp1_ = ((FilesFile*) _tmp2_) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gconstpointer _tmp3_;
		_tmp3_ = file_list->data;
		_tmp0_ = FILES_IS_FILE ((FilesFile*) _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Block12Data* _data12_;
		gconstpointer _tmp4_;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->_data11_ = block11_data_ref (_data11_);
		_tmp4_ = file_list->data;
		_data12_->in_recent = files_file_is_recent_uri_scheme ((FilesFile*) _tmp4_);
		g_list_foreach (file_list, ____lambda35__gfunc, _data12_);
		block12_data_unref (_data12_);
		_data12_ = NULL;
	} else {
		g_warning ("DndHandler.vala:337: Invalid file list for drag and drop ignored");
	}
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

GdkDragAction
files_dnd_handler_file_accepts_drop (FilesFile* dest,
                                     GList* drop_file_list,
                                     GdkDragAction selected_action,
                                     GdkDragAction possible_actions,
                                     GdkDragAction* suggested_action_return)
{
	GdkDragAction _vala_suggested_action_return = 0U;
	GdkDragAction actions = 0U;
	GdkDragAction suggested_action = 0U;
	GFile* target_location = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GdkDragAction result;
	g_return_val_if_fail (dest != NULL, 0U);
	actions = possible_actions;
	suggested_action = selected_action;
	_tmp0_ = files_file_get_target_location (dest);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	target_location = _tmp1_;
	_vala_suggested_action_return = GDK_ACTION_PRIVATE;
	if (drop_file_list == NULL) {
		_tmp2_ = TRUE;
	} else {
		gconstpointer _tmp3_;
		_tmp3_ = drop_file_list->data;
		_tmp2_ = ((GFile*) _tmp3_) == NULL;
	}
	if (_tmp2_) {
		result = GDK_ACTION_DEFAULT;
		_g_object_unref0 (target_location);
		if (suggested_action_return) {
			*suggested_action_return = _vala_suggested_action_return;
		}
		return result;
	}
	if (files_file_is_folder (dest)) {
		if (!files_file_is_writable (dest)) {
			actions = GDK_ACTION_DEFAULT;
		} else {
			GFile* _tmp4_;
			GdkDragAction _tmp5_;
			_tmp4_ = target_location;
			_tmp5_ = files_dnd_handler_valid_actions_for_file_list (_tmp4_, drop_file_list, &suggested_action);
			actions &= _tmp5_;
		}
	} else {
		if (files_file_is_executable (dest)) {
			actions |= ((GDK_ACTION_COPY | GDK_ACTION_MOVE) | GDK_ACTION_LINK) | GDK_ACTION_PRIVATE;
		} else {
			actions = GDK_ACTION_DEFAULT;
		}
	}
	if (actions == GDK_ACTION_DEFAULT) {
		result = GDK_ACTION_DEFAULT;
		_g_object_unref0 (target_location);
		if (suggested_action_return) {
			*suggested_action_return = _vala_suggested_action_return;
		}
		return result;
	} else {
		GFile* _tmp6_;
		_tmp6_ = target_location;
		if (files_file_utils_location_is_in_trash (_tmp6_)) {
			actions &= ~(GDK_ACTION_COPY | GDK_ACTION_LINK);
		}
	}
	if ((actions & suggested_action) == suggested_action) {
		_vala_suggested_action_return = suggested_action;
	} else {
		if ((actions & GDK_ACTION_ASK) == GDK_ACTION_ASK) {
			_vala_suggested_action_return = GDK_ACTION_ASK;
		} else {
			if ((actions & GDK_ACTION_COPY) == GDK_ACTION_COPY) {
				_vala_suggested_action_return = GDK_ACTION_COPY;
			} else {
				if ((actions & GDK_ACTION_LINK) == GDK_ACTION_LINK) {
					_vala_suggested_action_return = GDK_ACTION_LINK;
				} else {
					if ((actions & GDK_ACTION_MOVE) == GDK_ACTION_MOVE) {
						_vala_suggested_action_return = GDK_ACTION_MOVE;
					}
				}
			}
		}
	}
	result = actions;
	_g_object_unref0 (target_location);
	if (suggested_action_return) {
		*suggested_action_return = _vala_suggested_action_return;
	}
	return result;
}

static GdkDragAction
files_dnd_handler_valid_actions_for_file_list (GFile* target_location,
                                               GList* drop_file_list,
                                               GdkDragAction* suggested_action)
{
	GdkDragAction valid_actions = 0U;
	guint count = 0U;
	gboolean from_trash = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GdkDragAction result;
	g_return_val_if_fail (target_location != NULL, 0U);
	valid_actions = ((GDK_ACTION_DEFAULT | GDK_ACTION_COPY) | GDK_ACTION_MOVE) | GDK_ACTION_LINK;
	count = (guint) 0;
	from_trash = FALSE;
	{
		GList* drop_file_collection = NULL;
		GList* drop_file_it = NULL;
		drop_file_collection = drop_file_list;
		for (drop_file_it = drop_file_collection; drop_file_it != NULL; drop_file_it = drop_file_it->next) {
			GFile* _tmp0_;
			GFile* drop_file = NULL;
			_tmp0_ = _g_object_ref0 ((GFile*) drop_file_it->data);
			drop_file = _tmp0_;
			{
				GFile* _tmp1_;
				GFile* parent = NULL;
				GFile* _tmp2_;
				GFile* _tmp3_;
				gboolean _tmp4_ = FALSE;
				GFile* _tmp5_;
				gchar* scheme = NULL;
				GFile* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				gboolean _tmp12_ = FALSE;
				guint _tmp13_;
				_tmp1_ = drop_file;
				if (files_file_utils_location_is_in_trash (_tmp1_)) {
					from_trash = TRUE;
					if (files_file_utils_location_is_in_trash (target_location)) {
						valid_actions = GDK_ACTION_DEFAULT;
					}
				}
				_tmp2_ = drop_file;
				_tmp3_ = g_file_get_parent (_tmp2_);
				parent = _tmp3_;
				_tmp5_ = parent;
				if (_tmp5_ != NULL) {
					GFile* _tmp6_;
					_tmp6_ = parent;
					_tmp4_ = g_file_equal (_tmp6_, target_location);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					valid_actions &= GDK_ACTION_LINK;
				}
				_tmp7_ = drop_file;
				_tmp8_ = g_file_get_uri_scheme (_tmp7_);
				scheme = _tmp8_;
				_tmp10_ = scheme;
				if (_tmp10_ == NULL) {
					_tmp9_ = TRUE;
				} else {
					const gchar* _tmp11_;
					_tmp11_ = scheme;
					_tmp9_ = !g_str_has_prefix (_tmp11_, "file");
				}
				if (_tmp9_) {
					valid_actions &= ~GDK_ACTION_LINK;
				}
				count = count + 1;
				_tmp13_ = count;
				if (_tmp13_ > FILES_DND_HANDLER_MAX_FILES_CHECKED) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = valid_actions == GDK_ACTION_DEFAULT;
				}
				if (_tmp12_) {
					_g_free0 (scheme);
					_g_object_unref0 (parent);
					_g_object_unref0 (drop_file);
					break;
				}
				_g_free0 (scheme);
				_g_object_unref0 (parent);
				_g_object_unref0 (drop_file);
			}
		}
	}
	if ((valid_actions & GDK_ACTION_COPY) == GDK_ACTION_COPY) {
		_tmp16_ = (valid_actions & GDK_ACTION_MOVE) == GDK_ACTION_MOVE;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = (*suggested_action) == GDK_ACTION_COPY;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean _tmp17_ = FALSE;
		if (from_trash) {
			_tmp17_ = TRUE;
		} else {
			GList* _tmp18_;
			gconstpointer _tmp19_;
			_tmp18_ = g_list_first (drop_file_list);
			_tmp19_ = _tmp18_->data;
			_tmp17_ = files_file_utils_same_file_system ((GFile*) _tmp19_, target_location);
		}
		_tmp14_ = _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		*suggested_action = GDK_ACTION_MOVE;
	}
	if (valid_actions != GDK_ACTION_DEFAULT) {
		valid_actions |= GDK_ACTION_ASK;
	}
	result = valid_actions;
	return result;
}

static void
files_dnd_handler_class_init (FilesDndHandlerClass * klass,
                              gpointer klass_data)
{
	files_dnd_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesDndHandler_private_offset);
	G_OBJECT_CLASS (klass)->finalize = files_dnd_handler_finalize;
}

static void
files_dnd_handler_instance_init (FilesDndHandler * self,
                                 gpointer klass)
{
	self->priv = files_dnd_handler_get_instance_private (self);
	self->priv->chosen = GDK_ACTION_DEFAULT;
}

static void
files_dnd_handler_finalize (GObject * obj)
{
	FilesDndHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_DND_HANDLER, FilesDndHandler);
	G_OBJECT_CLASS (files_dnd_handler_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_dnd_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesDndHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_dnd_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesDndHandler), 0, (GInstanceInitFunc) files_dnd_handler_instance_init, NULL };
	GType files_dnd_handler_type_id;
	files_dnd_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesDndHandler", &g_define_type_info, 0);
	FilesDndHandler_private_offset = g_type_add_instance_private (files_dnd_handler_type_id, sizeof (FilesDndHandlerPrivate));
	return files_dnd_handler_type_id;
}

GType
files_dnd_handler_get_type (void)
{
	static volatile gsize files_dnd_handler_type_id__once = 0;
	if (g_once_init_enter (&files_dnd_handler_type_id__once)) {
		GType files_dnd_handler_type_id;
		files_dnd_handler_type_id = files_dnd_handler_get_type_once ();
		g_once_init_leave (&files_dnd_handler_type_id__once, files_dnd_handler_type_id);
	}
	return files_dnd_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

