/* Application.c generated by valac 0.56.17, the Vala compiler
 * generated from Application.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2023 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian <maxwell@elementary.io>
 *              Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <libportal/portal.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include "elementary-calendar.h"
#include <libportal-gtk3/portal-gtk3.h>
#include <float.h>
#include <math.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libical-glib/libical-glib.h>
#include <locale.h>

#define GETTEXT_PACKAGE "io.elementary.calendar"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_TYPE_APPLICATION (maya_application_get_type ())
#define MAYA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_APPLICATION, MayaApplication))
#define MAYA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_APPLICATION, MayaApplicationClass))
#define MAYA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_APPLICATION))
#define MAYA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_APPLICATION))
#define MAYA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_APPLICATION, MayaApplicationClass))

typedef struct _MayaApplication MayaApplication;
typedef struct _MayaApplicationClass MayaApplicationClass;
typedef struct _MayaApplicationPrivate MayaApplicationPrivate;

#define MAYA_TYPE_MAIN_WINDOW (maya_main_window_get_type ())
#define MAYA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindow))
#define MAYA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))
#define MAYA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))

typedef struct _MayaMainWindow MayaMainWindow;
typedef struct _MayaMainWindowClass MayaMainWindowClass;
enum  {
	MAYA_APPLICATION_0_PROPERTY,
	MAYA_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* maya_application_properties[MAYA_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

#define CALENDAR_TYPE_TODAY_EVENT_MONITOR (calendar_today_event_monitor_get_type ())
#define CALENDAR_TODAY_EVENT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitor))
#define CALENDAR_TODAY_EVENT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitorClass))
#define CALENDAR_IS_TODAY_EVENT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_TODAY_EVENT_MONITOR))
#define CALENDAR_IS_TODAY_EVENT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_TODAY_EVENT_MONITOR))
#define CALENDAR_TODAY_EVENT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitorClass))

typedef struct _CalendarTodayEventMonitor CalendarTodayEventMonitor;
typedef struct _CalendarTodayEventMonitorClass CalendarTodayEventMonitorClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MayaMainWindowPrivate MayaMainWindowPrivate;

#define MAYA_VIEW_TYPE_CALENDAR_VIEW (maya_view_calendar_view_get_type ())
#define MAYA_VIEW_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView))
#define MAYA_VIEW_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))
#define MAYA_VIEW_IS_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_IS_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_CALENDAR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))

typedef struct _MayaViewCalendarView MayaViewCalendarView;
typedef struct _MayaViewCalendarViewClass MayaViewCalendarViewClass;

#define MAYA_VIEW_TYPE_IMPORT_DIALOG (maya_view_import_dialog_get_type ())
#define MAYA_VIEW_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialog))
#define MAYA_VIEW_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialogClass))
#define MAYA_VIEW_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG))
#define MAYA_VIEW_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_IMPORT_DIALOG))
#define MAYA_VIEW_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialogClass))

typedef struct _MayaViewImportDialog MayaViewImportDialog;
typedef struct _MayaViewImportDialogClass MayaViewImportDialogClass;
#define __vala_XdpParent_free0(var) ((var == NULL) ? NULL : (var = (_vala_XdpParent_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MayaApplicationAskForBackgroundData MayaApplicationAskForBackgroundData;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _MayaApplication {
	GtkApplication parent_instance;
	MayaApplicationPrivate * priv;
	MayaMainWindow* window;
};

struct _MayaApplicationClass {
	GtkApplicationClass parent_class;
};

struct _MayaApplicationPrivate {
	XdpPortal* portal;
};

struct _Block3Data {
	int _ref_count_;
	MayaApplication* self;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
};

struct _MayaMainWindow {
	HdyApplicationWindow parent_instance;
	MayaMainWindowPrivate * priv;
	MayaViewCalendarView* calview;
};

struct _MayaMainWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _MayaApplicationAskForBackgroundData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MayaApplication* self;
	gboolean result;
	XdpPortal* _tmp0_;
	XdpPortal* _tmp1_;
	gchar* reason;
	gchar* _tmp2_;
	GPtrArray* command;
	GPtrArray* _tmp3_;
	const gchar** arg_collection;
	gint arg_collection_length1;
	gint _arg_collection_size_;
	gint arg_it;
	const gchar* arg;
	GPtrArray* _tmp4_;
	const gchar* _tmp5_;
	XdpParent* window;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
	XdpParent* _tmp8_;
	gboolean _tmp9_;
	XdpPortal* _tmp10_;
	const gchar* _tmp11_;
	GPtrArray* _tmp12_;
	GPtrArray* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	GError* _inner_error0_;
};

static gint MayaApplication_private_offset;
static gpointer maya_application_parent_class = NULL;
static gboolean maya_application_add_event;
static gchar* maya_application_show_day;
static gboolean maya_application_run_in_background;
VALA_EXTERN GSettings* maya_application_saved_state;
GSettings* maya_application_saved_state = NULL;
VALA_EXTERN GSettings* maya_application_wingpanel_settings;
GSettings* maya_application_wingpanel_settings = NULL;
static gboolean maya_application_run_in_background = FALSE;
static gboolean maya_application_add_event = FALSE;
static gchar* maya_application_show_day = NULL;

VALA_EXTERN GType maya_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaApplication, g_object_unref)
VALA_EXTERN GType maya_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaMainWindow, g_object_unref)
static void maya_application_real_activate (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN CalendarTodayEventMonitor* calendar_today_event_monitor_new (void);
VALA_EXTERN CalendarTodayEventMonitor* calendar_today_event_monitor_construct (GType object_type);
VALA_EXTERN GType calendar_today_event_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarTodayEventMonitor, g_object_unref)
VALA_EXTERN void maya_application_ask_for_background (MayaApplication* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN gboolean maya_application_ask_for_background_finish (MayaApplication* self,
                                                     GAsyncResult* _res_);
static void ___lambda202_ (MayaApplication* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda202__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
VALA_EXTERN GDateTime* maya_application_get_selected_datetime (void);
static void maya_application_init_gui (MayaApplication* self);
static gboolean ___lambda204_ (MayaApplication* self);
VALA_EXTERN void maya_main_window_on_tb_add_clicked (MayaMainWindow* self,
                                         GDateTime* dt);
VALA_EXTERN GType maya_view_calendar_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewCalendarView, g_object_unref)
VALA_EXTERN GDateTime* maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self);
static gboolean ____lambda204__gsource_func (gpointer self);
static void __lambda205_ (Block3Data* _data3_);
static void ___lambda205__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void maya_application_real_open (GApplication* base,
                                 GFile** files,
                                 gint files_length1,
                                 const gchar* hint);
VALA_EXTERN GType maya_view_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewImportDialog, g_object_unref)
VALA_EXTERN MayaViewImportDialog* maya_view_import_dialog_new (GFile** files,
                                                   gint files_length1);
VALA_EXTERN MayaViewImportDialog* maya_view_import_dialog_construct (GType object_type,
                                                         GFile** files,
                                                         gint files_length1);
VALA_EXTERN MayaMainWindow* maya_main_window_new (GtkApplication* application);
VALA_EXTERN MayaMainWindow* maya_main_window_construct (GType object_type,
                                            GtkApplication* application);
static void maya_application_on_quit (MayaApplication* self);
static void _maya_application_on_quit_gtk_widget_destroy (GtkWidget* _sender,
                                                   gpointer self);
static void __lambda203_ (MayaApplication* self);
static void ___lambda203__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void maya_application_ask_for_background_data_free (gpointer _data);
static gboolean maya_application_ask_for_background_co (MayaApplicationAskForBackgroundData* _data_);
static void maya_application_ask_for_background_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void _vala_XdpParent_free (XdpParent* self);
static gint maya_application_main (gchar** args,
                            gint args_length1);
VALA_EXTERN MayaApplication* maya_application_new (void);
VALA_EXTERN MayaApplication* maya_application_construct (GType object_type);
static GObject * maya_application_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void maya_application_finalize (GObject * obj);
static GType maya_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry MAYA_APPLICATION_APP_OPTIONS[4] = {{"add-event", 'a', (gint) 0, G_OPTION_ARG_NONE, &maya_application_add_event, N_ ("Create an event"), NULL}, {"show-day", 's', (gint) 0, G_OPTION_ARG_STRING, &maya_application_show_day, N_ ("Focus the given day"), N_ ("date")}, {"background", 'b', (gint) 0, G_OPTION_ARG_NONE, &maya_application_run_in_background, "Run the Application in background", NULL}, {NULL}};

static inline gpointer
maya_application_get_instance_private (MayaApplication* self)
{
	return G_STRUCT_MEMBER_P (self, MayaApplication_private_offset);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		MayaApplication* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->gtk_settings);
		_g_object_unref0 (_data3_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda202_ (MayaApplication* self,
               GObject* obj,
               GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	if (!maya_application_ask_for_background_finish (self, res)) {
		g_application_release ((GApplication*) self);
	}
}

static void
____lambda202__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda202_ ((MayaApplication*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
___lambda204_ (MayaApplication* self)
{
	MayaMainWindow* _tmp0_;
	MayaMainWindow* _tmp1_;
	MayaViewCalendarView* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gboolean result;
	_tmp0_ = self->window;
	_tmp1_ = self->window;
	_tmp2_ = _tmp1_->calview;
	_tmp3_ = maya_view_calendar_view_get_selected_date (_tmp2_);
	_tmp4_ = _tmp3_;
	maya_main_window_on_tb_add_clicked (_tmp0_, _tmp4_);
	result = FALSE;
	return result;
}

static gboolean
____lambda204__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda204_ ((MayaApplication*) self);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda205_ (Block3Data* _data3_)
{
	MayaApplication* self;
	GtkSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	self = _data3_->self;
	_tmp0_ = _data3_->gtk_settings;
	_tmp1_ = _data3_->granite_settings;
	_tmp2_ = granite_settings_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gtk-application-prefer-dark-theme", _tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda205__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda205_ (self);
}

static void
maya_application_real_activate (GApplication* base)
{
	MayaApplication * self;
	Block3Data* _data3_;
	CalendarTodayEventMonitor* _tmp0_;
	CalendarTodayEventMonitor* _tmp1_;
	GList* _tmp2_;
	const gchar* _tmp5_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp23_;
	CalendarEventStore* _tmp24_;
	MayaMainWindow* _tmp25_;
	GraniteSettings* _tmp26_;
	GraniteSettings* _tmp27_;
	GtkSettings* _tmp28_;
	GtkSettings* _tmp29_;
	GtkSettings* _tmp30_;
	GraniteSettings* _tmp31_;
	GraniteSettingsColorScheme _tmp32_;
	GraniteSettingsColorScheme _tmp33_;
	GraniteSettings* _tmp34_;
	self = (MayaApplication*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = calendar_today_event_monitor_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	if (maya_application_run_in_background) {
		maya_application_run_in_background = FALSE;
		g_application_hold ((GApplication*) self);
		maya_application_ask_for_background (self, ____lambda202__gasync_ready_callback, g_object_ref (self));
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		gconstpointer _tmp4_;
		_tmp3_ = gtk_application_get_windows ((GtkApplication*) self);
		_tmp4_ = _tmp3_->data;
		gtk_window_present ((GtkWindow*) _tmp4_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp5_ = maya_application_show_day;
	if (_tmp5_ != NULL) {
		GDate date = {0};
		const gchar* _tmp6_;
		memset (&date, 0, sizeof (GDate));
		_tmp6_ = maya_application_show_day;
		g_date_set_parse (&date, _tmp6_);
		if (g_date_valid (&date) == TRUE) {
			GDateTime* datetime = NULL;
			GDateTime* _tmp7_;
			GDateTime* _tmp8_;
			GDateTime* _tmp9_;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			GDateTime* _tmp12_;
			GDateTime* _tmp13_;
			GSettings* _tmp14_;
			GDateTime* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GSettings* _tmp18_;
			GDateTime* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp7_ = maya_application_get_selected_datetime ();
			datetime = _tmp7_;
			_tmp8_ = datetime;
			_tmp9_ = datetime;
			_tmp10_ = g_date_time_add_years (_tmp8_, ((gint) g_date_get_year (&date)) - g_date_time_get_year (_tmp9_));
			_g_date_time_unref0 (datetime);
			datetime = _tmp10_;
			_tmp11_ = datetime;
			_tmp12_ = datetime;
			_tmp13_ = g_date_time_add_days (_tmp11_, ((gint) g_date_get_day_of_year (&date)) - g_date_time_get_day_of_year (_tmp12_));
			_g_date_time_unref0 (datetime);
			datetime = _tmp13_;
			_tmp14_ = maya_application_saved_state;
			_tmp15_ = datetime;
			_tmp16_ = g_date_time_format (_tmp15_, "%Y-%j");
			_tmp17_ = _tmp16_;
			g_settings_set_string (_tmp14_, "selected-day", _tmp17_);
			_g_free0 (_tmp17_);
			_tmp18_ = maya_application_saved_state;
			_tmp19_ = datetime;
			_tmp20_ = g_date_time_format (_tmp19_, "%Y-%m");
			_tmp21_ = _tmp20_;
			g_settings_set_string (_tmp18_, "month-page", _tmp21_);
			_g_free0 (_tmp21_);
			_g_date_time_unref0 (datetime);
		} else {
			const gchar* _tmp22_;
			_tmp22_ = maya_application_show_day;
			g_warning ("Application.vala:94: Invalid date '%s' - Ignoring", _tmp22_);
		}
	}
	_tmp23_ = calendar_event_store_get_default ();
	calmodel = _tmp23_;
	_tmp24_ = calmodel;
	calendar_event_store_load_all_sources (_tmp24_);
	maya_application_init_gui (self);
	_tmp25_ = self->window;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	if (maya_application_add_event) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda204__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp26_ = granite_settings_get_default ();
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_data3_->granite_settings = _tmp27_;
	_tmp28_ = gtk_settings_get_default ();
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_data3_->gtk_settings = _tmp29_;
	_tmp30_ = _data3_->gtk_settings;
	_tmp31_ = _data3_->granite_settings;
	_tmp32_ = granite_settings_get_prefers_color_scheme (_tmp31_);
	_tmp33_ = _tmp32_;
	g_object_set (_tmp30_, "gtk-application-prefer-dark-theme", _tmp33_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	_tmp34_ = _data3_->granite_settings;
	g_signal_connect_data ((GObject*) _tmp34_, "notify::prefers-color-scheme", (GCallback) ___lambda205__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (calmodel);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
maya_application_real_open (GApplication* base,
                            GFile** files,
                            gint files_length1,
                            const gchar* hint)
{
	MayaApplication * self;
	GList* _tmp0_;
	MayaViewImportDialog* dialog = NULL;
	MayaViewImportDialog* _tmp6_;
	MayaMainWindow* _tmp7_;
	self = (MayaApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		CalendarEventStore* calmodel = NULL;
		CalendarEventStore* _tmp1_;
		CalendarEventStore* _tmp2_;
		MayaMainWindow* _tmp3_;
		_tmp1_ = calendar_event_store_get_default ();
		calmodel = _tmp1_;
		_tmp2_ = calmodel;
		calendar_event_store_load_all_sources (_tmp2_);
		maya_application_init_gui (self);
		_tmp3_ = self->window;
		gtk_widget_show_all ((GtkWidget*) _tmp3_);
		_g_object_unref0 (calmodel);
	} else {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		_tmp4_ = gtk_application_get_windows ((GtkApplication*) self);
		_tmp5_ = _tmp4_->data;
		gtk_window_present ((GtkWindow*) _tmp5_);
	}
	_tmp6_ = maya_view_import_dialog_new (files, files_length1);
	g_object_ref_sink (_tmp6_);
	dialog = _tmp6_;
	_tmp7_ = self->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp7_);
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

/**
         * Initializes the graphical window and its components
         */
static void
_maya_application_on_quit_gtk_widget_destroy (GtkWidget* _sender,
                                              gpointer self)
{
	maya_application_on_quit ((MayaApplication*) self);
}

static void
__lambda203_ (MayaApplication* self)
{
	MayaMainWindow* _tmp0_;
	_tmp0_ = self->window;
	if (_tmp0_ != NULL) {
		MayaMainWindow* _tmp1_;
		_tmp1_ = self->window;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
}

static void
___lambda203__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda203_ ((MayaApplication*) self);
}

static void
maya_application_init_gui (MayaApplication* self)
{
	GtkAllocation rect = {0};
	GSettings* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	MayaMainWindow* _tmp3_;
	MayaMainWindow* _tmp4_;
	MayaMainWindow* _tmp5_;
	GtkAllocation _tmp6_;
	GSettings* _tmp7_;
	MayaMainWindow* _tmp9_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_if_fail (self != NULL);
	memset (&rect, 0, sizeof (GtkAllocation));
	_tmp0_ = maya_application_saved_state;
	g_settings_get (_tmp0_, "window-size", "(ii)", &_tmp1_, &_tmp2_);
	rect.width = _tmp1_;
	rect.height = _tmp2_;
	_tmp3_ = maya_main_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->window);
	self->window = _tmp3_;
	_tmp4_ = self->window;
	gtk_window_set_title ((GtkWindow*) _tmp4_, _ (BUILD_APP_NAME));
	_tmp5_ = self->window;
	_tmp6_ = rect;
	gtk_widget_set_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
	_tmp7_ = maya_application_saved_state;
	if (g_settings_get_boolean (_tmp7_, "window-maximized")) {
		MayaMainWindow* _tmp8_;
		_tmp8_ = self->window;
		gtk_window_maximize ((GtkWindow*) _tmp8_);
	}
	_tmp9_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "destroy", (GCallback) _maya_application_on_quit_gtk_widget_destroy, self, 0);
	_tmp10_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp10_;
	g_signal_connect_object (quit_action, "activate", (GCallback) ___lambda203__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_tmp11_ = g_strdup ("<Control>q");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (quit_action);
}

static void
maya_application_on_quit (MayaApplication* self)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_delete_trashed_calendars (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
maya_application_ask_for_background_data_free (gpointer _data)
{
	MayaApplicationAskForBackgroundData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MayaApplicationAskForBackgroundData, _data_);
}

void
maya_application_ask_for_background (MayaApplication* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	MayaApplicationAskForBackgroundData* _data_;
	MayaApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MayaApplicationAskForBackgroundData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, maya_application_ask_for_background_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	maya_application_ask_for_background_co (_data_);
}

gboolean
maya_application_ask_for_background_finish (MayaApplication* self,
                                            GAsyncResult* _res_)
{
	gboolean result;
	MayaApplicationAskForBackgroundData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
maya_application_ask_for_background_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	MayaApplicationAskForBackgroundData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	maya_application_ask_for_background_co (_data_);
}

static void
_vala_XdpParent_free (XdpParent* self)
{
	g_boxed_free (xdp_parent_get_type (), self);
}

static gboolean
maya_application_ask_for_background_co (MayaApplicationAskForBackgroundData* _data_)
{
	static const gchar* DAEMON_COMMAND[2] = {"io.elementary.calendar", "--background"};
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->portal;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = xdp_portal_new ();
		_g_object_unref0 (_data_->self->priv->portal);
		_data_->self->priv->portal = _data_->_tmp1_;
	}
	_data_->_tmp2_ = g_strdup (_ ("Calendar will automatically start when this device turns on " "and run when its window is closed so that it can send event notificati" \
"ons."));
	_data_->reason = _data_->_tmp2_;
	_data_->_tmp3_ = g_ptr_array_new_full ((guint) 2, NULL);
	_data_->command = _data_->_tmp3_;
	{
		_data_->arg_collection_length1 = 0;
		_data_->_arg_collection_size_ = 0;
		_data_->arg_collection = DAEMON_COMMAND;
		_data_->arg_collection_length1 = G_N_ELEMENTS (DAEMON_COMMAND);
		for (_data_->arg_it = 0; _data_->arg_it < _data_->arg_collection_length1; _data_->arg_it = _data_->arg_it + 1) {
			_data_->arg = _data_->arg_collection[_data_->arg_it];
			{
				_data_->_tmp4_ = _data_->command;
				_data_->_tmp5_ = _data_->arg;
				g_ptr_array_add (_data_->_tmp4_, _data_->_tmp5_);
			}
		}
	}
	_data_->_tmp6_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = xdp_parent_new_gtk (_data_->_tmp7_);
	_data_->window = _data_->_tmp8_;
	{
		_data_->_tmp10_ = _data_->self->priv->portal;
		_data_->_tmp11_ = _data_->reason;
		_data_->_tmp12_ = _data_->command;
		_data_->_tmp13_ = _g_ptr_array_ref0 (_data_->_tmp12_);
		_data_->_state_ = 1;
		xdp_portal_request_background (_data_->_tmp10_, _data_->window, _data_->_tmp11_, _data_->_tmp13_, XDP_BACKGROUND_FLAG_AUTOSTART, NULL, maya_application_ask_for_background_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = xdp_portal_request_background_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->result = _data_->_tmp9_;
		__vala_XdpParent_free0 (_data_->window);
		_g_ptr_array_unref0 (_data_->command);
		_g_free0 (_data_->reason);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("Application.vala:189: Error during portal request: %s", _data_->_tmp15_);
		_data_->_tmp16_ = _data_->e;
		_data_->result = g_error_matches (_data_->_tmp16_, G_IO_ERROR, G_IO_ERROR_FAILED);
		_g_error_free0 (_data_->e);
		__vala_XdpParent_free0 (_data_->window);
		_g_ptr_array_unref0 (_data_->command);
		_g_free0 (_data_->reason);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	__vala_XdpParent_free0 (_data_->window);
	_g_ptr_array_unref0 (_data_->command);
	_g_free0 (_data_->reason);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GDateTime*
maya_application_get_selected_datetime (void)
{
	gchar* selected_day = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar** numbers = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint numbers_length1;
	gint _numbers_size_;
	GDateTime* dt = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* result;
	_tmp0_ = maya_application_saved_state;
	_tmp1_ = g_settings_get_string (_tmp0_, "selected-day");
	selected_day = _tmp1_;
	_tmp3_ = selected_day;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = selected_day;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		GDateTime* _tmp5_;
		_tmp5_ = g_date_time_new_now_local ();
		result = _tmp5_;
		_g_free0 (selected_day);
		return result;
	}
	_tmp6_ = selected_day;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "-", 2);
	numbers = _tmp8_;
	numbers_length1 = _vala_array_length (_tmp7_);
	_numbers_size_ = numbers_length1;
	_tmp9_ = numbers;
	_tmp9__length1 = numbers_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = g_date_time_new_local (atoi (_tmp10_), 1, 1, 0, 0, (gdouble) 0);
	dt = _tmp11_;
	_tmp12_ = dt;
	_tmp13_ = numbers;
	_tmp13__length1 = numbers_length1;
	_tmp14_ = _tmp13_[1];
	_tmp15_ = g_date_time_add_days (_tmp12_, atoi (_tmp14_) - 1);
	_g_date_time_unref0 (dt);
	dt = _tmp15_;
	result = dt;
	numbers = (_vala_array_free (numbers, numbers_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (selected_day);
	return result;
}

static gint
maya_application_main (gchar** args,
                       gint args_length1)
{
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionGroup* _tmp1_;
	MayaApplication* app = NULL;
	MayaApplication* _tmp5_;
	gint res = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	_tmp0_ = g_option_context_new (_ ("Calendar"));
	context = _tmp0_;
	g_option_context_add_main_entries (context, MAYA_APPLICATION_APP_OPTIONS, "maya");
	_tmp1_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp1_);
	{
		g_option_context_parse (context, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Application.vala:214: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	gtk_clutter_init ((gint*) (&args_length1), &args);
	_tmp5_ = maya_application_new ();
	app = _tmp5_;
	res = g_application_run ((GApplication*) app, (gint) args_length1, args);
	i_cal_object_free_global_objects ();
	result = res;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return maya_application_main (argv, argc);
}

MayaApplication*
maya_application_construct (GType object_type)
{
	MayaApplication * self = NULL;
	self = (MayaApplication*) g_object_new (object_type, NULL);
	return self;
}

MayaApplication*
maya_application_new (void)
{
	return maya_application_construct (MAYA_TYPE_APPLICATION);
}

static GObject *
maya_application_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaApplication * self;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	parent_class = G_OBJECT_CLASS (maya_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_APPLICATION, MayaApplication);
	_tmp0_ = g_application_get_flags ((GApplication*) self);
	_tmp1_ = _tmp0_;
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_OPEN);
	g_application_set_application_id ((GApplication*) self, BUILD_EXEC_NAME);
	g_setenv ("GTK_USE_PORTAL", "1", TRUE);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	return obj;
}

static void
maya_application_class_init (MayaApplicationClass * klass,
                             gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	GSettingsSchemaSource* _tmp5_;
	GSettingsSchema* _tmp6_;
	GSettingsSchema* _tmp7_;
	gboolean _tmp8_;
	maya_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaApplication_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) maya_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) maya_application_real_open;
	G_OBJECT_CLASS (klass)->constructor = maya_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_application_finalize;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "io.elementary.calendar.savedstate", TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new ("io.elementary.calendar.savedstate");
		_g_object_unref0 (maya_application_saved_state);
		maya_application_saved_state = _tmp4_;
	}
	_tmp5_ = g_settings_schema_source_get_default ();
	_tmp6_ = g_settings_schema_source_lookup (_tmp5_, "io.elementary.desktop.wingpanel.datetime", TRUE);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	_g_settings_schema_unref0 (_tmp7_);
	if (_tmp8_) {
		GSettings* _tmp9_;
		_tmp9_ = g_settings_new ("io.elementary.desktop.wingpanel.datetime");
		_g_object_unref0 (maya_application_wingpanel_settings);
		maya_application_wingpanel_settings = _tmp9_;
	}
}

static void
maya_application_instance_init (MayaApplication * self,
                                gpointer klass)
{
	self->priv = maya_application_get_instance_private (self);
	self->priv->portal = NULL;
}

static void
maya_application_finalize (GObject * obj)
{
	MayaApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_APPLICATION, MayaApplication);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->priv->portal);
	G_OBJECT_CLASS (maya_application_parent_class)->finalize (obj);
}

static GType
maya_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaApplication), 0, (GInstanceInitFunc) maya_application_instance_init, NULL };
	GType maya_application_type_id;
	maya_application_type_id = g_type_register_static (gtk_application_get_type (), "MayaApplication", &g_define_type_info, 0);
	MayaApplication_private_offset = g_type_add_instance_private (maya_application_type_id, sizeof (MayaApplicationPrivate));
	return maya_application_type_id;
}

GType
maya_application_get_type (void)
{
	static volatile gsize maya_application_type_id__once = 0;
	if (g_once_init_enter (&maya_application_type_id__once)) {
		GType maya_application_type_id;
		maya_application_type_id = maya_application_get_type_once ();
		g_once_init_leave (&maya_application_type_id__once, maya_application_type_id);
	}
	return maya_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

