/* RunnerAction.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RunnerAction.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*               2020-2021 Justin Haygood
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_TYPE_RUNNER_ACTION (synapse_runner_action_get_type ())
#define SYNAPSE_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction))
#define SYNAPSE_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerActionClass))
#define SYNAPSE_IS_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RUNNER_ACTION))
#define SYNAPSE_IS_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RUNNER_ACTION))
#define SYNAPSE_RUNNER_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerActionClass))

typedef struct _SynapseRunnerAction SynapseRunnerAction;
typedef struct _SynapseRunnerActionClass SynapseRunnerActionClass;
typedef struct _SynapseRunnerActionPrivate SynapseRunnerActionPrivate;
enum  {
	SYNAPSE_RUNNER_ACTION_0_PROPERTY,
	SYNAPSE_RUNNER_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_runner_action_properties[SYNAPSE_RUNNER_ACTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseRunnerAction {
	SynapseBaseAction parent_instance;
	SynapseRunnerActionPrivate * priv;
};

struct _SynapseRunnerActionClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseRunnerActionPrivate {
	SlingshotBackendSwitcherooControl* switcheroo_control;
};

static gint SynapseRunnerAction_private_offset;
static gpointer synapse_runner_action_parent_class = NULL;

VALA_EXTERN GType synapse_runner_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SynapseRunnerAction* synapse_runner_action_new (void);
VALA_EXTERN SynapseRunnerAction* synapse_runner_action_construct (GType object_type);
static void synapse_runner_action_real_do_execute (SynapseBaseAction* base,
                                            SynapseMatch* match,
                                            SynapseMatch* target);
static gboolean synapse_runner_action_real_valid_for_match (SynapseBaseAction* base,
                                                     SynapseMatch* match);
static GObject * synapse_runner_action_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void synapse_runner_action_finalize (GObject * obj);
static GType synapse_runner_action_get_type_once (void);

static inline gpointer
synapse_runner_action_get_instance_private (SynapseRunnerAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseRunnerAction_private_offset);
}

SynapseRunnerAction*
synapse_runner_action_construct (GType object_type)
{
	SynapseRunnerAction * self = NULL;
	self = (SynapseRunnerAction*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
	return self;
}

SynapseRunnerAction*
synapse_runner_action_new (void)
{
	return synapse_runner_action_construct (SYNAPSE_TYPE_RUNNER_ACTION);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_runner_action_real_do_execute (SynapseBaseAction* base,
                                       SynapseMatch* match,
                                       SynapseMatch* target)
{
	SynapseRunnerAction * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (SynapseRunnerAction*) base;
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp2_;
		GDesktopAppInfo* app_info = NULL;
		GAppInfo* app = NULL;
		SynapseApplicationMatch* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		app_match = SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL;
		_tmp2_ = app_match;
		g_return_if_fail (_tmp2_ != NULL);
		app_info = NULL;
		_tmp3_ = app_match;
		_tmp4_ = synapse_application_match_get_app_info (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			SynapseApplicationMatch* _tmp6_;
			GAppInfo* _tmp7_;
			GAppInfo* _tmp8_;
			GAppInfo* _tmp9_;
			_tmp6_ = app_match;
			_tmp7_ = synapse_application_match_get_app_info (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (app);
			app = _tmp9_;
		} else {
			SynapseApplicationMatch* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			GDesktopAppInfo* _tmp13_;
			GDesktopAppInfo* _tmp14_;
			GAppInfo* _tmp15_;
			_tmp10_ = app_match;
			_tmp11_ = synapse_application_match_get_filename (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_desktop_app_info_new_from_filename (_tmp12_);
			_g_object_unref0 (app_info);
			app_info = _tmp13_;
			_tmp14_ = app_info;
			_tmp15_ = _g_object_ref0 ((GAppInfo*) _tmp14_);
			_g_object_unref0 (app);
			app = _tmp15_;
		}
		{
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp16_;
			GdkAppLaunchContext* context = NULL;
			GdkDisplay* _tmp17_;
			GdkAppLaunchContext* _tmp18_;
			GDesktopAppInfo* _tmp19_;
			GAppInfo* _tmp23_;
			GdkAppLaunchContext* _tmp24_;
			SynapseRelevancyService* _tmp25_;
			SynapseRelevancyService* _tmp26_;
			GAppInfo* _tmp27_;
			_tmp16_ = gdk_display_get_default ();
			display = _tmp16_;
			_tmp17_ = display;
			_tmp18_ = gdk_display_get_app_launch_context (_tmp17_);
			context = _tmp18_;
			_tmp19_ = app_info;
			if (_tmp19_ != NULL) {
				gboolean use_default_gpu = FALSE;
				GDesktopAppInfo* _tmp20_;
				SlingshotBackendSwitcherooControl* _tmp21_;
				GdkAppLaunchContext* _tmp22_;
				_tmp20_ = app_info;
				use_default_gpu = !g_desktop_app_info_get_boolean (_tmp20_, "PrefersNonDefaultGPU");
				_tmp21_ = self->priv->switcheroo_control;
				_tmp22_ = context;
				slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp21_, (GAppLaunchContext*) _tmp22_, use_default_gpu);
			}
			_tmp23_ = app;
			_tmp24_ = context;
			g_app_info_launch (_tmp23_, NULL, (GAppLaunchContext*) _tmp24_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (context);
				goto __catch0_g_error;
			}
			_tmp25_ = synapse_relevancy_service_get_default ();
			_tmp26_ = _tmp25_;
			_tmp27_ = app;
			synapse_relevancy_service_application_launched (_tmp26_, _tmp27_);
			_g_object_unref0 (_tmp26_);
			_g_object_unref0 (context);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp28_;
			const gchar* _tmp29_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = err;
			_tmp29_ = _tmp28_->message;
			g_critical ("RunnerAction.vala:68: %s", _tmp29_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (app);
			_g_object_unref0 (app_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (app_info);
	} else {
		synapse_match_execute (match, NULL);
	}
}

static gboolean
synapse_runner_action_real_valid_for_match (SynapseBaseAction* base,
                                            SynapseMatch* match)
{
	SynapseRunnerAction * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	gboolean result;
	self = (SynapseRunnerAction*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SYNAPSE_MATCH_TYPE_SEARCH:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_ACTION:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseApplicationMatch* am = NULL;
			gboolean _tmp2_ = FALSE;
			SynapseApplicationMatch* _tmp3_;
			am = SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL;
			_tmp3_ = am;
			if (_tmp3_ == NULL) {
				_tmp2_ = TRUE;
			} else {
				SynapseApplicationMatch* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp4_ = am;
				_tmp5_ = synapse_application_match_get_needs_terminal (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp2_ = !_tmp6_;
			}
			result = _tmp2_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static GObject *
synapse_runner_action_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseRunnerAction * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	parent_class = G_OBJECT_CLASS (synapse_runner_action_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	return obj;
}

static void
synapse_runner_action_class_init (SynapseRunnerActionClass * klass,
                                  gpointer klass_data)
{
	synapse_runner_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseRunnerAction_private_offset);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_runner_action_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_runner_action_real_valid_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_runner_action_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_runner_action_finalize;
}

static void
synapse_runner_action_instance_init (SynapseRunnerAction * self,
                                     gpointer klass)
{
	self->priv = synapse_runner_action_get_instance_private (self);
}

static void
synapse_runner_action_finalize (GObject * obj)
{
	SynapseRunnerAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction);
	_g_object_unref0 (self->priv->switcheroo_control);
	G_OBJECT_CLASS (synapse_runner_action_parent_class)->finalize (obj);
}

static GType
synapse_runner_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseRunnerActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_runner_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseRunnerAction), 0, (GInstanceInitFunc) synapse_runner_action_instance_init, NULL };
	GType synapse_runner_action_type_id;
	synapse_runner_action_type_id = g_type_register_static (SYNAPSE_TYPE_BASE_ACTION, "SynapseRunnerAction", &g_define_type_info, 0);
	SynapseRunnerAction_private_offset = g_type_add_instance_private (synapse_runner_action_type_id, sizeof (SynapseRunnerActionPrivate));
	return synapse_runner_action_type_id;
}

GType
synapse_runner_action_get_type (void)
{
	static volatile gsize synapse_runner_action_type_id__once = 0;
	if (g_once_init_enter (&synapse_runner_action_type_id__once)) {
		GType synapse_runner_action_type_id;
		synapse_runner_action_type_id = synapse_runner_action_get_type_once ();
		g_once_init_leave (&synapse_runner_action_type_id__once, synapse_runner_action_type_id);
	}
	return synapse_runner_action_type_id__once;
}

