use gio::prelude::ToVariant;
use glib::Boxed;
use news_flash::models::CategoryID;
use std::fmt;

#[derive(Clone, Debug, Eq, Boxed)]
#[boxed_type(name = "GCategoryID")]
pub struct GCategoryID(CategoryID);

impl From<CategoryID> for GCategoryID {
    fn from(id: CategoryID) -> Self {
        Self(id)
    }
}

impl AsRef<CategoryID> for GCategoryID {
    fn as_ref(&self) -> &CategoryID {
        &self.0
    }
}

impl From<GCategoryID> for CategoryID {
    fn from(id: GCategoryID) -> Self {
        id.0
    }
}

impl Default for GCategoryID {
    fn default() -> Self {
        CategoryID::from_owned(String::new()).into()
    }
}

impl ToVariant for GCategoryID {
    fn to_variant(&self) -> glib::Variant {
        self.0.as_str().to_variant()
    }
}

impl fmt::Display for GCategoryID {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl PartialEq for GCategoryID {
    fn eq(&self, other: &GCategoryID) -> bool {
        self.0 == other.0
    }
}
