use glib::Boxed;
use news_flash::models::PluginCapabilities;

#[derive(Clone, Debug, Boxed)]
#[boxed_type(name = "GPluginFeatures")]
pub struct PluginFeautres(PluginCapabilities);

impl From<PluginCapabilities> for PluginFeautres {
    fn from(val: PluginCapabilities) -> Self {
        Self(val)
    }
}

impl AsRef<PluginCapabilities> for PluginFeautres {
    fn as_ref(&self) -> &PluginCapabilities {
        &self.0
    }
}

impl From<PluginFeautres> for PluginCapabilities {
    fn from(id: PluginFeautres) -> Self {
        id.0
    }
}

impl Default for PluginFeautres {
    fn default() -> Self {
        PluginCapabilities::NONE.into()
    }
}
