/// More Error Cases.
///
/// This is a hack because `XmlError` is not open to extension.
///
/// TODO(v2): Merge these errors into `XmlError`.
#[derive(Debug)]
#[non_exhaustive]
pub enum XmlExtendedError {
    DuplicateAttribute(std::borrow::Cow<'static, str>),
    DuplicateElement(std::borrow::Cow<'static, str>),
}

impl std::error::Error for XmlExtendedError {}

impl std::fmt::Display for XmlExtendedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            XmlExtendedError::DuplicateAttribute(attr) => write!(f, "Duplicate attribute {:?}", attr),
            XmlExtendedError::DuplicateElement(name) => write!(f, "Duplicate element <{}>", name),
        }
    }
}
