use crate::app::App;
use crate::settings::dialog::keybind_row::KeybindRow;
use glib::{Object, subclass};
use gtk4::{CompositeTemplate, Widget, prelude::*, subclass::prelude::*};
use libadwaita::{PreferencesPage, subclass::prelude::*};

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate)]
    #[template(file = "data/resources/ui_templates/settings/shortcuts.blp")]
    pub struct SettingsShortcutsPage {
        #[template_child]
        pub next_article_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub previous_article_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub toggle_read_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub toggle_marked_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub open_browser_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub copy_url_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub next_item_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub previous_item_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub toggle_category_expanded_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub sidebar_set_read_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub scroll_up_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub scroll_down_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub scrap_content_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub tag_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub fullscreen_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub close_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub search_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub refresh_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub all_articles_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub only_unread_row: TemplateChild<KeybindRow>,

        #[template_child]
        pub only_starred_row: TemplateChild<KeybindRow>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for SettingsShortcutsPage {
        const NAME: &'static str = "SettingsShortcutsPage";
        type ParentType = PreferencesPage;
        type Type = super::SettingsShortcutsPage;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
        }

        fn instance_init(obj: &subclass::InitializingObject<Self>) {
            obj.init_template();
        }
    }

    impl ObjectImpl for SettingsShortcutsPage {
        fn constructed(&self) {
            let keybind_settings = App::default().settings().keybindings();
            let article_list_keybindings: Object = keybind_settings.article_list().upcast();
            let feed_list_keybindings: Object = keybind_settings.feed_list().upcast();
            let general_keybindings: Object = keybind_settings.general().upcast();
            let article_veiw_keybindings: Object = keybind_settings.article_view().upcast();

            self.next_article_row
                .set_settings_obj(Some(article_list_keybindings.clone()));
            self.previous_article_row
                .set_settings_obj(Some(article_list_keybindings.clone()));
            self.toggle_read_row
                .set_settings_obj(Some(article_list_keybindings.clone()));
            self.toggle_marked_row
                .set_settings_obj(Some(article_list_keybindings.clone()));
            self.open_browser_row
                .set_settings_obj(Some(article_list_keybindings.clone()));
            self.copy_url_row
                .set_settings_obj(Some(article_list_keybindings.clone()));

            self.next_item_row.set_settings_obj(Some(feed_list_keybindings.clone()));
            self.previous_item_row
                .set_settings_obj(Some(feed_list_keybindings.clone()));
            self.toggle_category_expanded_row
                .set_settings_obj(Some(feed_list_keybindings.clone()));
            self.sidebar_set_read_row
                .set_settings_obj(Some(feed_list_keybindings.clone()));

            self.refresh_row.set_settings_obj(Some(general_keybindings.clone()));
            self.search_row.set_settings_obj(Some(general_keybindings.clone()));
            self.all_articles_row
                .set_settings_obj(Some(general_keybindings.clone()));
            self.only_unread_row.set_settings_obj(Some(general_keybindings.clone()));
            self.only_starred_row
                .set_settings_obj(Some(general_keybindings.clone()));

            self.scroll_up_row
                .set_settings_obj(Some(article_veiw_keybindings.clone()));
            self.scroll_down_row
                .set_settings_obj(Some(article_veiw_keybindings.clone()));
            self.scrap_content_row
                .set_settings_obj(Some(article_veiw_keybindings.clone()));
            self.tag_row.set_settings_obj(Some(article_veiw_keybindings.clone()));
            self.fullscreen_row
                .set_settings_obj(Some(article_veiw_keybindings.clone()));
            self.close_row.set_settings_obj(Some(article_veiw_keybindings.clone()));
        }
    }

    impl WidgetImpl for SettingsShortcutsPage {}

    impl PreferencesPageImpl for SettingsShortcutsPage {}
}

glib::wrapper! {
    pub struct SettingsShortcutsPage(ObjectSubclass<imp::SettingsShortcutsPage>)
        @extends Widget, PreferencesPage;
}

impl Default for SettingsShortcutsPage {
    fn default() -> Self {
        glib::Object::new::<Self>()
    }
}
