/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"
#line 12 "HTMLElement.bnd"

#include <utils/corestrings.h>
#define HANDLER_MAGIC MAGIC(HANDLER_MAP)
#line 47 "html_element.c"

void dukky_html_element___init(duk_context *ctx, html_element_private_t *priv, struct dom_html_element *html_element)
{
	dukky_element___init(ctx, &priv->parent, (struct dom_element *)html_element);
#line 18 "HTMLElement.bnd"
#line 53 "html_element.c"
}

void dukky_html_element___fini(duk_context *ctx, html_element_private_t *priv)
{
	dukky_element___fini(ctx, &priv->parent);
}

static duk_ret_t dukky_html_element___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	html_element_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_html_element___init(ctx, priv, duk_get_pointer(ctx, 1));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_html_element___destructor(duk_context *ctx)
{
	html_element_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_html_element___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_html_element_click(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_focus(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_blur(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_forceSpellCheck(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_title_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 26 "HTMLElement.bnd"
#line 192 "html_element.c"
	dom_exception exc;
	dom_string *str;

	exc = dom_html_element_get_title((struct dom_html_element *)((node_private_t*)priv)->node, &str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (str != NULL) {
		duk_push_lstring(ctx,
			dom_string_data(str),
			dom_string_length(str));
		dom_string_unref(str);
	} else {
		duk_push_lstring(ctx, NULL, 0);
	}

	return 1;
}

static duk_ret_t dukky_html_element_title_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 27 "HTMLElement.bnd"
#line 226 "html_element.c"
	dom_exception exc;
	dom_string *str;
	duk_size_t slen;
	const char *s;
	s = duk_safe_to_lstring(ctx, 0, &slen);

	exc = dom_string_create((const uint8_t *)s, slen, &str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	exc = dom_html_element_set_title((struct dom_html_element *)((node_private_t*)priv)->node, str);
	dom_string_unref(str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	return 0;
}

static duk_ret_t dukky_html_element_lang_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 23 "HTMLElement.bnd"
#line 260 "html_element.c"
	dom_exception exc;
	dom_string *str;

	exc = dom_html_element_get_lang((struct dom_html_element *)((node_private_t*)priv)->node, &str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (str != NULL) {
		duk_push_lstring(ctx,
			dom_string_data(str),
			dom_string_length(str));
		dom_string_unref(str);
	} else {
		duk_push_lstring(ctx, NULL, 0);
	}

	return 1;
}

static duk_ret_t dukky_html_element_lang_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 24 "HTMLElement.bnd"
#line 294 "html_element.c"
	dom_exception exc;
	dom_string *str;
	duk_size_t slen;
	const char *s;
	s = duk_safe_to_lstring(ctx, 0, &slen);

	exc = dom_string_create((const uint8_t *)s, slen, &str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	exc = dom_html_element_set_lang((struct dom_html_element *)((node_private_t*)priv)->node, str);
	dom_string_unref(str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	return 0;
}

static duk_ret_t dukky_html_element_translate_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_translate_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_dir_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 20 "HTMLElement.bnd"
#line 358 "html_element.c"
	dom_exception exc;
	dom_string *str;

	exc = dom_html_element_get_dir((struct dom_html_element *)((node_private_t*)priv)->node, &str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (str != NULL) {
		duk_push_lstring(ctx,
			dom_string_data(str),
			dom_string_length(str));
		dom_string_unref(str);
	} else {
		duk_push_lstring(ctx, NULL, 0);
	}

	return 1;
}

static duk_ret_t dukky_html_element_dir_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 21 "HTMLElement.bnd"
#line 392 "html_element.c"
	dom_exception exc;
	dom_string *str;
	duk_size_t slen;
	const char *s;
	s = duk_safe_to_lstring(ctx, 0, &slen);

	exc = dom_string_create((const uint8_t *)s, slen, &str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	exc = dom_html_element_set_dir((struct dom_html_element *)((node_private_t*)priv)->node, str);
	dom_string_unref(str);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	return 0;
}

static duk_ret_t dukky_html_element_dataset_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_hidden_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_hidden_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_tabIndex_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_tabIndex_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_accessKey_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_accessKey_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_accessKeyLabel_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_draggable_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_draggable_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_dropzone_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_dropzone_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	duk_ret_t get_ret;

	get_ret = dukky_html_element_dropzone_getter(ctx);
	if (get_ret != 1) {
		return 0;
	}

	/* parameter ... attribute */

	duk_dup(ctx, 0);
	/* ... attribute parameter */

	/* call the putforward */
	duk_put_prop_string(ctx, -2, "value");

	return 0;
}

static duk_ret_t dukky_html_element_contextMenu_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_contextMenu_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_spellcheck_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_spellcheck_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_commandType_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_commandLabel_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_commandIcon_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_commandHidden_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_commandDisabled_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_commandChecked_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_onabort_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 35 "HTMLElement.bnd"
#line 771 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"abort", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onabort_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 36 "HTMLElement.bnd"
#line 805 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "abort", 5);
	/* handlerfn this handlers abort */
	duk_dup(ctx, -4);
	/* handlerfn this handlers abort handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_abort, false);
	return 0;
}

static duk_ret_t dukky_html_element_onautocomplete_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 39 "HTMLElement.bnd"
#line 836 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"autocomplete", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onautocomplete_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 40 "HTMLElement.bnd"
#line 870 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "autocomplete", 12);
	/* handlerfn this handlers autocomplete */
	duk_dup(ctx, -4);
	/* handlerfn this handlers autocomplete handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_autocomplete, false);
	return 0;
}

static duk_ret_t dukky_html_element_onautocompleteerror_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 37 "HTMLElement.bnd"
#line 901 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"autocompleteerror", 17, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onautocompleteerror_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 38 "HTMLElement.bnd"
#line 935 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "autocompleteerror", 17);
	/* handlerfn this handlers autocompleteerror */
	duk_dup(ctx, -4);
	/* handlerfn this handlers autocompleteerror handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_autocompleteerror, false);
	return 0;
}

static duk_ret_t dukky_html_element_onblur_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 41 "HTMLElement.bnd"
#line 966 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"blur", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onblur_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 42 "HTMLElement.bnd"
#line 1000 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "blur", 4);
	/* handlerfn this handlers blur */
	duk_dup(ctx, -4);
	/* handlerfn this handlers blur handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_blur, false);
	return 0;
}

static duk_ret_t dukky_html_element_oncancel_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 43 "HTMLElement.bnd"
#line 1031 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"cancel", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oncancel_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 44 "HTMLElement.bnd"
#line 1065 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "cancel", 6);
	/* handlerfn this handlers cancel */
	duk_dup(ctx, -4);
	/* handlerfn this handlers cancel handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_cancel, false);
	return 0;
}

static duk_ret_t dukky_html_element_oncanplay_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 47 "HTMLElement.bnd"
#line 1096 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"canplay", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oncanplay_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 48 "HTMLElement.bnd"
#line 1130 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "canplay", 7);
	/* handlerfn this handlers canplay */
	duk_dup(ctx, -4);
	/* handlerfn this handlers canplay handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_canplay, false);
	return 0;
}

static duk_ret_t dukky_html_element_oncanplaythrough_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 45 "HTMLElement.bnd"
#line 1161 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"canplaythrough", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oncanplaythrough_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 46 "HTMLElement.bnd"
#line 1195 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "canplaythrough", 14);
	/* handlerfn this handlers canplaythrough */
	duk_dup(ctx, -4);
	/* handlerfn this handlers canplaythrough handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_canplaythrough, false);
	return 0;
}

static duk_ret_t dukky_html_element_onchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 29 "HTMLElement.bnd"
#line 1226 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"change", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 30 "HTMLElement.bnd"
#line 1260 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "change", 6);
	/* handlerfn this handlers change */
	duk_dup(ctx, -4);
	/* handlerfn this handlers change handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_change, false);
	return 0;
}

static duk_ret_t dukky_html_element_onclick_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 33 "HTMLElement.bnd"
#line 1291 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"click", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onclick_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 32 "HTMLElement.bnd"
#line 1325 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "click", 5);
	/* handlerfn this handlers click */
	duk_dup(ctx, -4);
	/* handlerfn this handlers click handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_click, false);
	return 0;
}

static duk_ret_t dukky_html_element_onclose_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 49 "HTMLElement.bnd"
#line 1356 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"close", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onclose_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 50 "HTMLElement.bnd"
#line 1390 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "close", 5);
	/* handlerfn this handlers close */
	duk_dup(ctx, -4);
	/* handlerfn this handlers close handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_close, false);
	return 0;
}

static duk_ret_t dukky_html_element_oncontextmenu_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 51 "HTMLElement.bnd"
#line 1421 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"contextmenu", 11, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oncontextmenu_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 52 "HTMLElement.bnd"
#line 1455 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "contextmenu", 11);
	/* handlerfn this handlers contextmenu */
	duk_dup(ctx, -4);
	/* handlerfn this handlers contextmenu handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_contextmenu, false);
	return 0;
}

static duk_ret_t dukky_html_element_oncuechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 53 "HTMLElement.bnd"
#line 1486 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"cuechange", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oncuechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 54 "HTMLElement.bnd"
#line 1520 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "cuechange", 9);
	/* handlerfn this handlers cuechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers cuechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_cuechange, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondblclick_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 55 "HTMLElement.bnd"
#line 1551 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dblclick", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondblclick_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 56 "HTMLElement.bnd"
#line 1585 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dblclick", 8);
	/* handlerfn this handlers dblclick */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dblclick handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dblclick, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondrag_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 69 "HTMLElement.bnd"
#line 1616 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"drag", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondrag_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 70 "HTMLElement.bnd"
#line 1650 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "drag", 4);
	/* handlerfn this handlers drag */
	duk_dup(ctx, -4);
	/* handlerfn this handlers drag handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_drag, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondragend_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 57 "HTMLElement.bnd"
#line 1681 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragend", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondragend_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 58 "HTMLElement.bnd"
#line 1715 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragend", 7);
	/* handlerfn this handlers dragend */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragend handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragend, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondragenter_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 59 "HTMLElement.bnd"
#line 1746 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragenter", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondragenter_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 60 "HTMLElement.bnd"
#line 1780 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragenter", 9);
	/* handlerfn this handlers dragenter */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragenter handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragenter, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondragexit_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 61 "HTMLElement.bnd"
#line 1811 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragexit", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondragexit_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 62 "HTMLElement.bnd"
#line 1845 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragexit", 8);
	/* handlerfn this handlers dragexit */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragexit handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragexit, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondragleave_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 63 "HTMLElement.bnd"
#line 1876 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragleave", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondragleave_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 64 "HTMLElement.bnd"
#line 1910 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragleave", 9);
	/* handlerfn this handlers dragleave */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragleave handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragleave, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondragover_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 65 "HTMLElement.bnd"
#line 1941 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragover", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondragover_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 66 "HTMLElement.bnd"
#line 1975 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragover", 8);
	/* handlerfn this handlers dragover */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragover handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragover, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondragstart_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 67 "HTMLElement.bnd"
#line 2006 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragstart", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondragstart_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 68 "HTMLElement.bnd"
#line 2040 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragstart", 9);
	/* handlerfn this handlers dragstart */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragstart handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragstart, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondrop_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 71 "HTMLElement.bnd"
#line 2071 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"drop", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondrop_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 72 "HTMLElement.bnd"
#line 2105 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "drop", 4);
	/* handlerfn this handlers drop */
	duk_dup(ctx, -4);
	/* handlerfn this handlers drop handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_drop, false);
	return 0;
}

static duk_ret_t dukky_html_element_ondurationchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 73 "HTMLElement.bnd"
#line 2136 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"durationchange", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ondurationchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 74 "HTMLElement.bnd"
#line 2170 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "durationchange", 14);
	/* handlerfn this handlers durationchange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers durationchange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_durationchange, false);
	return 0;
}

static duk_ret_t dukky_html_element_onemptied_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 75 "HTMLElement.bnd"
#line 2201 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"emptied", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onemptied_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 76 "HTMLElement.bnd"
#line 2235 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "emptied", 7);
	/* handlerfn this handlers emptied */
	duk_dup(ctx, -4);
	/* handlerfn this handlers emptied handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_emptied, false);
	return 0;
}

static duk_ret_t dukky_html_element_onended_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 77 "HTMLElement.bnd"
#line 2266 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"ended", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onended_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 78 "HTMLElement.bnd"
#line 2300 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "ended", 5);
	/* handlerfn this handlers ended */
	duk_dup(ctx, -4);
	/* handlerfn this handlers ended handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_ended, false);
	return 0;
}

static duk_ret_t dukky_html_element_onerror_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_onerror_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_onfocus_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 79 "HTMLElement.bnd"
#line 2361 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"focus", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onfocus_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 80 "HTMLElement.bnd"
#line 2395 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "focus", 5);
	/* handlerfn this handlers focus */
	duk_dup(ctx, -4);
	/* handlerfn this handlers focus handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_focus, false);
	return 0;
}

static duk_ret_t dukky_html_element_oninput_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 81 "HTMLElement.bnd"
#line 2426 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"input", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oninput_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 82 "HTMLElement.bnd"
#line 2460 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "input", 5);
	/* handlerfn this handlers input */
	duk_dup(ctx, -4);
	/* handlerfn this handlers input handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_input, false);
	return 0;
}

static duk_ret_t dukky_html_element_oninvalid_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 83 "HTMLElement.bnd"
#line 2491 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"invalid", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_oninvalid_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 84 "HTMLElement.bnd"
#line 2525 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "invalid", 7);
	/* handlerfn this handlers invalid */
	duk_dup(ctx, -4);
	/* handlerfn this handlers invalid handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_invalid, false);
	return 0;
}

static duk_ret_t dukky_html_element_onkeydown_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 85 "HTMLElement.bnd"
#line 2556 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keydown", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onkeydown_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 86 "HTMLElement.bnd"
#line 2590 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keydown", 7);
	/* handlerfn this handlers keydown */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keydown handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keydown, false);
	return 0;
}

static duk_ret_t dukky_html_element_onkeypress_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 87 "HTMLElement.bnd"
#line 2621 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keypress", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onkeypress_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 88 "HTMLElement.bnd"
#line 2655 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keypress", 8);
	/* handlerfn this handlers keypress */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keypress handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keypress, false);
	return 0;
}

static duk_ret_t dukky_html_element_onkeyup_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 89 "HTMLElement.bnd"
#line 2686 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keyup", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onkeyup_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 90 "HTMLElement.bnd"
#line 2720 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keyup", 5);
	/* handlerfn this handlers keyup */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keyup handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keyup, false);
	return 0;
}

static duk_ret_t dukky_html_element_onload_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 97 "HTMLElement.bnd"
#line 2751 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"load", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onload_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 98 "HTMLElement.bnd"
#line 2785 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "load", 4);
	/* handlerfn this handlers load */
	duk_dup(ctx, -4);
	/* handlerfn this handlers load handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_load, false);
	return 0;
}

static duk_ret_t dukky_html_element_onloadeddata_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 91 "HTMLElement.bnd"
#line 2816 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadeddata", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onloadeddata_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 92 "HTMLElement.bnd"
#line 2850 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadeddata", 10);
	/* handlerfn this handlers loadeddata */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadeddata handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadeddata, false);
	return 0;
}

static duk_ret_t dukky_html_element_onloadedmetadata_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 93 "HTMLElement.bnd"
#line 2881 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadedmetadata", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onloadedmetadata_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 94 "HTMLElement.bnd"
#line 2915 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadedmetadata", 14);
	/* handlerfn this handlers loadedmetadata */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadedmetadata handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadedmetadata, false);
	return 0;
}

static duk_ret_t dukky_html_element_onloadstart_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 95 "HTMLElement.bnd"
#line 2946 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadstart", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onloadstart_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 96 "HTMLElement.bnd"
#line 2980 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadstart", 9);
	/* handlerfn this handlers loadstart */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadstart handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadstart, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmousedown_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 99 "HTMLElement.bnd"
#line 3011 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mousedown", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmousedown_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 100 "HTMLElement.bnd"
#line 3045 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mousedown", 9);
	/* handlerfn this handlers mousedown */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mousedown handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mousedown, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmouseenter_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 101 "HTMLElement.bnd"
#line 3076 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseenter", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmouseenter_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 102 "HTMLElement.bnd"
#line 3110 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseenter", 10);
	/* handlerfn this handlers mouseenter */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseenter handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseenter, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmouseleave_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 103 "HTMLElement.bnd"
#line 3141 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseleave", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmouseleave_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 104 "HTMLElement.bnd"
#line 3175 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseleave", 10);
	/* handlerfn this handlers mouseleave */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseleave handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseleave, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmousemove_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 105 "HTMLElement.bnd"
#line 3206 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mousemove", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmousemove_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 106 "HTMLElement.bnd"
#line 3240 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mousemove", 9);
	/* handlerfn this handlers mousemove */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mousemove handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mousemove, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmouseout_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 107 "HTMLElement.bnd"
#line 3271 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseout", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmouseout_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 108 "HTMLElement.bnd"
#line 3305 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseout", 8);
	/* handlerfn this handlers mouseout */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseout handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseout, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmouseover_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 109 "HTMLElement.bnd"
#line 3336 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseover", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmouseover_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 110 "HTMLElement.bnd"
#line 3370 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseover", 9);
	/* handlerfn this handlers mouseover */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseover handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseover, false);
	return 0;
}

static duk_ret_t dukky_html_element_onmouseup_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 111 "HTMLElement.bnd"
#line 3401 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseup", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onmouseup_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 112 "HTMLElement.bnd"
#line 3435 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseup", 7);
	/* handlerfn this handlers mouseup */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseup handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseup, false);
	return 0;
}

static duk_ret_t dukky_html_element_onwheel_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 153 "HTMLElement.bnd"
#line 3466 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"wheel", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onwheel_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 154 "HTMLElement.bnd"
#line 3500 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "wheel", 5);
	/* handlerfn this handlers wheel */
	duk_dup(ctx, -4);
	/* handlerfn this handlers wheel handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_wheel, false);
	return 0;
}

static duk_ret_t dukky_html_element_onpause_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 113 "HTMLElement.bnd"
#line 3531 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"pause", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onpause_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 114 "HTMLElement.bnd"
#line 3565 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "pause", 5);
	/* handlerfn this handlers pause */
	duk_dup(ctx, -4);
	/* handlerfn this handlers pause handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_pause, false);
	return 0;
}

static duk_ret_t dukky_html_element_onplay_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 117 "HTMLElement.bnd"
#line 3596 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"play", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onplay_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 118 "HTMLElement.bnd"
#line 3630 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "play", 4);
	/* handlerfn this handlers play */
	duk_dup(ctx, -4);
	/* handlerfn this handlers play handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_play, false);
	return 0;
}

static duk_ret_t dukky_html_element_onplaying_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 115 "HTMLElement.bnd"
#line 3661 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"playing", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onplaying_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 116 "HTMLElement.bnd"
#line 3695 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "playing", 7);
	/* handlerfn this handlers playing */
	duk_dup(ctx, -4);
	/* handlerfn this handlers playing handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_playing, false);
	return 0;
}

static duk_ret_t dukky_html_element_onprogress_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 119 "HTMLElement.bnd"
#line 3726 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"progress", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onprogress_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 120 "HTMLElement.bnd"
#line 3760 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "progress", 8);
	/* handlerfn this handlers progress */
	duk_dup(ctx, -4);
	/* handlerfn this handlers progress handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_progress, false);
	return 0;
}

static duk_ret_t dukky_html_element_onratechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 121 "HTMLElement.bnd"
#line 3791 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"ratechange", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onratechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 122 "HTMLElement.bnd"
#line 3825 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "ratechange", 10);
	/* handlerfn this handlers ratechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers ratechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_ratechange, false);
	return 0;
}

static duk_ret_t dukky_html_element_onreset_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 123 "HTMLElement.bnd"
#line 3856 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"reset", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onreset_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 124 "HTMLElement.bnd"
#line 3890 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "reset", 5);
	/* handlerfn this handlers reset */
	duk_dup(ctx, -4);
	/* handlerfn this handlers reset handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_reset, false);
	return 0;
}

static duk_ret_t dukky_html_element_onresize_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 125 "HTMLElement.bnd"
#line 3921 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"resize", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onresize_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 126 "HTMLElement.bnd"
#line 3955 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "resize", 6);
	/* handlerfn this handlers resize */
	duk_dup(ctx, -4);
	/* handlerfn this handlers resize handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_resize, false);
	return 0;
}

static duk_ret_t dukky_html_element_onscroll_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 127 "HTMLElement.bnd"
#line 3986 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"scroll", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onscroll_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 128 "HTMLElement.bnd"
#line 4020 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "scroll", 6);
	/* handlerfn this handlers scroll */
	duk_dup(ctx, -4);
	/* handlerfn this handlers scroll handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_scroll, false);
	return 0;
}

static duk_ret_t dukky_html_element_onseeked_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 129 "HTMLElement.bnd"
#line 4051 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"seeked", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onseeked_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 130 "HTMLElement.bnd"
#line 4085 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "seeked", 6);
	/* handlerfn this handlers seeked */
	duk_dup(ctx, -4);
	/* handlerfn this handlers seeked handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_seeked, false);
	return 0;
}

static duk_ret_t dukky_html_element_onseeking_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 131 "HTMLElement.bnd"
#line 4116 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"seeking", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onseeking_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 132 "HTMLElement.bnd"
#line 4150 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "seeking", 7);
	/* handlerfn this handlers seeking */
	duk_dup(ctx, -4);
	/* handlerfn this handlers seeking handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_seeking, false);
	return 0;
}

static duk_ret_t dukky_html_element_onselect_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 133 "HTMLElement.bnd"
#line 4181 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"select", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onselect_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 134 "HTMLElement.bnd"
#line 4215 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "select", 6);
	/* handlerfn this handlers select */
	duk_dup(ctx, -4);
	/* handlerfn this handlers select handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_select, false);
	return 0;
}

static duk_ret_t dukky_html_element_onshow_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 135 "HTMLElement.bnd"
#line 4246 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"show", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onshow_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 136 "HTMLElement.bnd"
#line 4280 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "show", 4);
	/* handlerfn this handlers show */
	duk_dup(ctx, -4);
	/* handlerfn this handlers show handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_show, false);
	return 0;
}

static duk_ret_t dukky_html_element_onsort_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 137 "HTMLElement.bnd"
#line 4311 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"sort", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onsort_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 138 "HTMLElement.bnd"
#line 4345 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "sort", 4);
	/* handlerfn this handlers sort */
	duk_dup(ctx, -4);
	/* handlerfn this handlers sort handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_sort, false);
	return 0;
}

static duk_ret_t dukky_html_element_onstalled_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 139 "HTMLElement.bnd"
#line 4376 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"stalled", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onstalled_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 140 "HTMLElement.bnd"
#line 4410 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "stalled", 7);
	/* handlerfn this handlers stalled */
	duk_dup(ctx, -4);
	/* handlerfn this handlers stalled handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_stalled, false);
	return 0;
}

static duk_ret_t dukky_html_element_onsubmit_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 141 "HTMLElement.bnd"
#line 4441 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"submit", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onsubmit_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 142 "HTMLElement.bnd"
#line 4475 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "submit", 6);
	/* handlerfn this handlers submit */
	duk_dup(ctx, -4);
	/* handlerfn this handlers submit handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_submit, false);
	return 0;
}

static duk_ret_t dukky_html_element_onsuspend_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 143 "HTMLElement.bnd"
#line 4506 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"suspend", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onsuspend_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 144 "HTMLElement.bnd"
#line 4540 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "suspend", 7);
	/* handlerfn this handlers suspend */
	duk_dup(ctx, -4);
	/* handlerfn this handlers suspend handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_suspend, false);
	return 0;
}

static duk_ret_t dukky_html_element_ontimeupdate_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 145 "HTMLElement.bnd"
#line 4571 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"timeupdate", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ontimeupdate_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 146 "HTMLElement.bnd"
#line 4605 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "timeupdate", 10);
	/* handlerfn this handlers timeupdate */
	duk_dup(ctx, -4);
	/* handlerfn this handlers timeupdate handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_timeupdate, false);
	return 0;
}

static duk_ret_t dukky_html_element_ontoggle_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 147 "HTMLElement.bnd"
#line 4636 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"toggle", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_ontoggle_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 148 "HTMLElement.bnd"
#line 4670 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "toggle", 6);
	/* handlerfn this handlers toggle */
	duk_dup(ctx, -4);
	/* handlerfn this handlers toggle handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_toggle, false);
	return 0;
}

static duk_ret_t dukky_html_element_onvolumechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 149 "HTMLElement.bnd"
#line 4701 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"volumechange", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onvolumechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 150 "HTMLElement.bnd"
#line 4735 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "volumechange", 12);
	/* handlerfn this handlers volumechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers volumechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_volumechange, false);
	return 0;
}

static duk_ret_t dukky_html_element_onwaiting_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 151 "HTMLElement.bnd"
#line 4766 "html_element.c"
	dom_event_target *et = (dom_event_target *)(((node_private_t *)priv)->node);
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"waiting", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_html_element_onwaiting_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 152 "HTMLElement.bnd"
#line 4800 "html_element.c"
	dom_element *et = (dom_element *)(((node_private_t *)priv)->node);
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "waiting", 7);
	/* handlerfn this handlers waiting */
	duk_dup(ctx, -4);
	/* handlerfn this handlers waiting handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_waiting, false);
	return 0;
}

static duk_ret_t dukky_html_element_contentEditable_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_contentEditable_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_isContentEditable_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_html_element_style_getter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 156 "HTMLElement.bnd"

	/* Minimal implementation to avoid infinite-loop in Modernizr (c.f. #2413) */
	if (dukky_create_object(ctx, PROTO_NAME(CSSSTYLEDECLARATION), 0) != DUK_EXEC_SUCCESS) {
		return 0;
	}
	return 1;
#line 4882 "html_element.c"
}

static duk_ret_t dukky_html_element_style_setter(duk_context *ctx)
{
	/* Get private data for method */
	html_element_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	duk_ret_t get_ret;

	get_ret = dukky_html_element_style_getter(ctx);
	if (get_ret != 1) {
		return 0;
	}

	/* parameter ... attribute */

	duk_dup(ctx, 0);
	/* ... attribute parameter */

	/* call the putforward */
	duk_put_prop_string(ctx, -2, "cssText");

	return 0;
}

duk_ret_t dukky_html_element___proto(duk_context *ctx, void *udata)
{
	/* Set this prototype's prototype (left-parent) */
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_ELEMENT");
	duk_replace(ctx, -2);
	duk_set_prototype(ctx, 0);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "click");
	duk_push_c_function(ctx, dukky_html_element_click, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "focus");
	duk_push_c_function(ctx, dukky_html_element_focus, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "blur");
	duk_push_c_function(ctx, dukky_html_element_blur, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "forceSpellCheck");
	duk_push_c_function(ctx, dukky_html_element_forceSpellCheck, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "title");
	duk_push_c_function(ctx, dukky_html_element_title_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_title_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lang");
	duk_push_c_function(ctx, dukky_html_element_lang_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_lang_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "translate");
	duk_push_c_function(ctx, dukky_html_element_translate_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_translate_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "dir");
	duk_push_c_function(ctx, dukky_html_element_dir_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_dir_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "dataset");
	duk_push_c_function(ctx, dukky_html_element_dataset_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "hidden");
	duk_push_c_function(ctx, dukky_html_element_hidden_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_hidden_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "tabIndex");
	duk_push_c_function(ctx, dukky_html_element_tabIndex_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_tabIndex_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "accessKey");
	duk_push_c_function(ctx, dukky_html_element_accessKey_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_accessKey_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "accessKeyLabel");
	duk_push_c_function(ctx, dukky_html_element_accessKeyLabel_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "draggable");
	duk_push_c_function(ctx, dukky_html_element_draggable_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_draggable_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "dropzone");
	duk_push_c_function(ctx, dukky_html_element_dropzone_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_dropzone_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "contextMenu");
	duk_push_c_function(ctx, dukky_html_element_contextMenu_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_contextMenu_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "spellcheck");
	duk_push_c_function(ctx, dukky_html_element_spellcheck_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_spellcheck_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commandType");
	duk_push_c_function(ctx, dukky_html_element_commandType_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commandLabel");
	duk_push_c_function(ctx, dukky_html_element_commandLabel_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commandIcon");
	duk_push_c_function(ctx, dukky_html_element_commandIcon_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commandHidden");
	duk_push_c_function(ctx, dukky_html_element_commandHidden_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commandDisabled");
	duk_push_c_function(ctx, dukky_html_element_commandDisabled_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commandChecked");
	duk_push_c_function(ctx, dukky_html_element_commandChecked_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onabort");
	duk_push_c_function(ctx, dukky_html_element_onabort_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onabort_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onautocomplete");
	duk_push_c_function(ctx, dukky_html_element_onautocomplete_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onautocomplete_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onautocompleteerror");
	duk_push_c_function(ctx, dukky_html_element_onautocompleteerror_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onautocompleteerror_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onblur");
	duk_push_c_function(ctx, dukky_html_element_onblur_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onblur_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncancel");
	duk_push_c_function(ctx, dukky_html_element_oncancel_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oncancel_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncanplay");
	duk_push_c_function(ctx, dukky_html_element_oncanplay_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oncanplay_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncanplaythrough");
	duk_push_c_function(ctx, dukky_html_element_oncanplaythrough_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oncanplaythrough_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onchange");
	duk_push_c_function(ctx, dukky_html_element_onchange_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onclick");
	duk_push_c_function(ctx, dukky_html_element_onclick_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onclick_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onclose");
	duk_push_c_function(ctx, dukky_html_element_onclose_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onclose_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncontextmenu");
	duk_push_c_function(ctx, dukky_html_element_oncontextmenu_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oncontextmenu_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncuechange");
	duk_push_c_function(ctx, dukky_html_element_oncuechange_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oncuechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondblclick");
	duk_push_c_function(ctx, dukky_html_element_ondblclick_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondblclick_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondrag");
	duk_push_c_function(ctx, dukky_html_element_ondrag_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondrag_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragend");
	duk_push_c_function(ctx, dukky_html_element_ondragend_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondragend_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragenter");
	duk_push_c_function(ctx, dukky_html_element_ondragenter_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondragenter_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragexit");
	duk_push_c_function(ctx, dukky_html_element_ondragexit_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondragexit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragleave");
	duk_push_c_function(ctx, dukky_html_element_ondragleave_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondragleave_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragover");
	duk_push_c_function(ctx, dukky_html_element_ondragover_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondragover_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragstart");
	duk_push_c_function(ctx, dukky_html_element_ondragstart_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondragstart_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondrop");
	duk_push_c_function(ctx, dukky_html_element_ondrop_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondrop_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondurationchange");
	duk_push_c_function(ctx, dukky_html_element_ondurationchange_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ondurationchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onemptied");
	duk_push_c_function(ctx, dukky_html_element_onemptied_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onemptied_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onended");
	duk_push_c_function(ctx, dukky_html_element_onended_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onended_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onerror");
	duk_push_c_function(ctx, dukky_html_element_onerror_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onerror_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onfocus");
	duk_push_c_function(ctx, dukky_html_element_onfocus_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onfocus_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oninput");
	duk_push_c_function(ctx, dukky_html_element_oninput_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oninput_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oninvalid");
	duk_push_c_function(ctx, dukky_html_element_oninvalid_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_oninvalid_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeydown");
	duk_push_c_function(ctx, dukky_html_element_onkeydown_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onkeydown_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeypress");
	duk_push_c_function(ctx, dukky_html_element_onkeypress_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onkeypress_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeyup");
	duk_push_c_function(ctx, dukky_html_element_onkeyup_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onkeyup_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onload");
	duk_push_c_function(ctx, dukky_html_element_onload_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onload_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadeddata");
	duk_push_c_function(ctx, dukky_html_element_onloadeddata_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onloadeddata_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadedmetadata");
	duk_push_c_function(ctx, dukky_html_element_onloadedmetadata_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onloadedmetadata_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadstart");
	duk_push_c_function(ctx, dukky_html_element_onloadstart_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onloadstart_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmousedown");
	duk_push_c_function(ctx, dukky_html_element_onmousedown_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmousedown_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseenter");
	duk_push_c_function(ctx, dukky_html_element_onmouseenter_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmouseenter_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseleave");
	duk_push_c_function(ctx, dukky_html_element_onmouseleave_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmouseleave_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmousemove");
	duk_push_c_function(ctx, dukky_html_element_onmousemove_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmousemove_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseout");
	duk_push_c_function(ctx, dukky_html_element_onmouseout_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmouseout_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseover");
	duk_push_c_function(ctx, dukky_html_element_onmouseover_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmouseover_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseup");
	duk_push_c_function(ctx, dukky_html_element_onmouseup_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onmouseup_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onwheel");
	duk_push_c_function(ctx, dukky_html_element_onwheel_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onwheel_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onpause");
	duk_push_c_function(ctx, dukky_html_element_onpause_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onpause_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onplay");
	duk_push_c_function(ctx, dukky_html_element_onplay_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onplay_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onplaying");
	duk_push_c_function(ctx, dukky_html_element_onplaying_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onplaying_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onprogress");
	duk_push_c_function(ctx, dukky_html_element_onprogress_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onprogress_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onratechange");
	duk_push_c_function(ctx, dukky_html_element_onratechange_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onratechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onreset");
	duk_push_c_function(ctx, dukky_html_element_onreset_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onreset_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onresize");
	duk_push_c_function(ctx, dukky_html_element_onresize_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onresize_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onscroll");
	duk_push_c_function(ctx, dukky_html_element_onscroll_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onscroll_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onseeked");
	duk_push_c_function(ctx, dukky_html_element_onseeked_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onseeked_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onseeking");
	duk_push_c_function(ctx, dukky_html_element_onseeking_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onseeking_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onselect");
	duk_push_c_function(ctx, dukky_html_element_onselect_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onselect_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onshow");
	duk_push_c_function(ctx, dukky_html_element_onshow_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onshow_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsort");
	duk_push_c_function(ctx, dukky_html_element_onsort_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onsort_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onstalled");
	duk_push_c_function(ctx, dukky_html_element_onstalled_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onstalled_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsubmit");
	duk_push_c_function(ctx, dukky_html_element_onsubmit_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onsubmit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsuspend");
	duk_push_c_function(ctx, dukky_html_element_onsuspend_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onsuspend_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ontimeupdate");
	duk_push_c_function(ctx, dukky_html_element_ontimeupdate_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ontimeupdate_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ontoggle");
	duk_push_c_function(ctx, dukky_html_element_ontoggle_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_ontoggle_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onvolumechange");
	duk_push_c_function(ctx, dukky_html_element_onvolumechange_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onvolumechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onwaiting");
	duk_push_c_function(ctx, dukky_html_element_onwaiting_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_onwaiting_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "contentEditable");
	duk_push_c_function(ctx, dukky_html_element_contentEditable_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_contentEditable_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "isContentEditable");
	duk_push_c_function(ctx, dukky_html_element_isContentEditable_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "style");
	duk_push_c_function(ctx, dukky_html_element_style_getter, 0);
	duk_push_c_function(ctx, dukky_html_element_style_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_html_element___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_html_element___constructor, 2);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


