/* Preferences.c generated by valac 0.56.17, the Vala compiler
 * generated from Preferences.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
typedef struct _PreferencesPrivate PreferencesPrivate;
enum  {
	PREFERENCES_0_PROPERTY,
	PREFERENCES_USE_SYSTEM_MONOSPACE_FONT_PROPERTY,
	PREFERENCES_FONT_PROPERTY,
	PREFERENCES_FONT_COLOR_PROPERTY,
	PREFERENCES_BACKGROUND_COLOR_PROPERTY,
	PREFERENCES_HIGHLIGHT_COLOR_PROPERTY,
	PREFERENCES_RECORD_LAUNCH_PROPERTY,
	PREFERENCES_ENABLE_TIMEOUT_PROPERTY,
	PREFERENCES_TIMEOUT_PROPERTY,
	PREFERENCES_RECORD_AUTO_NAME_PROPERTY,
	PREFERENCES_RECORD_AUTO_DIRECTION_PROPERTY,
	PREFERENCES_RECORD_AUTO_EXTENSION_PROPERTY,
	PREFERENCES_RECORD_AUTO_FOLDER_PROPERTY,
	PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* preferences_properties[PREFERENCES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;

struct _Preferences {
	GObject parent_instance;
	PreferencesPrivate * priv;
};

struct _PreferencesClass {
	GObjectClass parent_class;
};

struct _PreferencesPrivate {
	gboolean _useSystemMonospaceFont;
	gchar* _font;
	gchar* _fontColor;
	gchar* _backgroundColor;
	gchar* _highlightColor;
	gboolean _recordLaunch;
	gboolean _enableTimeout;
	gint _timeout;
	gboolean _recordAutoName;
	gint _recordAutoDirection;
	gchar* _recordAutoExtension;
	gchar* _recordAutoFolder;
};

static gint Preferences_private_offset;
static gpointer preferences_parent_class = NULL;
VALA_EXTERN gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT;
gboolean preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT = TRUE;
VALA_EXTERN gchar* preferences_DEFAULT_FONT;
gchar* preferences_DEFAULT_FONT = NULL;
VALA_EXTERN gchar* preferences_DEFAULT_FONT_COLOR;
gchar* preferences_DEFAULT_FONT_COLOR = NULL;
VALA_EXTERN gchar* preferences_DEFAULT_BACKGROUND_COLOR;
gchar* preferences_DEFAULT_BACKGROUND_COLOR = NULL;
VALA_EXTERN gchar* preferences_DEFAULT_HIGHLIGHT_COLOR;
gchar* preferences_DEFAULT_HIGHLIGHT_COLOR = NULL;
VALA_EXTERN gboolean preferences_DEFAULT_RECORD_LAUNCH;
gboolean preferences_DEFAULT_RECORD_LAUNCH = TRUE;

VALA_EXTERN GType preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preferences, g_object_unref)
VALA_EXTERN Preferences* preferences_new (gboolean useSystemMonospaceFont,
                              const gchar* font,
                              const gchar* fontColor,
                              const gchar* backgroundColor,
                              const gchar* highlightColor,
                              gboolean recordLaunch,
                              gboolean enableTimeout,
                              gint timeout,
                              gboolean recordAutoName,
                              gint recordAutoDirection,
                              const gchar* recordAutoExtension,
                              const gchar* recordAutoFolder);
VALA_EXTERN Preferences* preferences_construct (GType object_type,
                                    gboolean useSystemMonospaceFont,
                                    const gchar* font,
                                    const gchar* fontColor,
                                    const gchar* backgroundColor,
                                    const gchar* highlightColor,
                                    gboolean recordLaunch,
                                    gboolean enableTimeout,
                                    gint timeout,
                                    gboolean recordAutoName,
                                    gint recordAutoDirection,
                                    const gchar* recordAutoExtension,
                                    const gchar* recordAutoFolder);
VALA_EXTERN gchar* preferences_getSystemDefaultMonospaceFont (void);
VALA_EXTERN void preferences_getGdkRGBA (const gchar* color,
                             GdkRGBA* result);
VALA_EXTERN void preferences_toString (Preferences* self);
VALA_EXTERN gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
VALA_EXTERN const gchar* preferences_get_font (Preferences* self);
VALA_EXTERN const gchar* preferences_get_fontColor (Preferences* self);
VALA_EXTERN const gchar* preferences_get_backgroundColor (Preferences* self);
VALA_EXTERN const gchar* preferences_get_highlightColor (Preferences* self);
VALA_EXTERN gboolean preferences_get_recordLaunch (Preferences* self);
VALA_EXTERN gboolean preferences_get_recordAutoName (Preferences* self);
VALA_EXTERN gint preferences_get_recordAutoDirection (Preferences* self);
VALA_EXTERN const gchar* preferences_get_recordAutoExtension (Preferences* self);
VALA_EXTERN const gchar* preferences_get_recordAutoFolder (Preferences* self);
VALA_EXTERN GType profile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Profile, g_object_unref)
VALA_EXTERN void preferences_saveToProfile (Preferences* self,
                                Profile* profile);
VALA_EXTERN void profile_setBoolean (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gboolean new_val);
VALA_EXTERN void profile_setString (Profile* self,
                        const gchar* group,
                        const gchar* key,
                        const gchar* new_val);
VALA_EXTERN gboolean preferences_get_enableTimeout (Preferences* self);
VALA_EXTERN void profile_setInteger (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gint new_val);
VALA_EXTERN gint preferences_get_timeout (Preferences* self);
VALA_EXTERN Preferences* preferences_loadFromProfile (Profile* profile);
VALA_EXTERN gboolean profile_getBoolean (Profile* self,
                             const gchar* group,
                             const gchar* key,
                             gboolean default_val);
VALA_EXTERN gchar* profile_getString (Profile* self,
                          const gchar* group,
                          const gchar* key);
VALA_EXTERN gint profile_getInteger (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gint default_val);
static void preferences_set_useSystemMonospaceFont (Preferences* self,
                                             gboolean value);
static void preferences_set_font (Preferences* self,
                           const gchar* value);
static void preferences_set_fontColor (Preferences* self,
                                const gchar* value);
static void preferences_set_backgroundColor (Preferences* self,
                                      const gchar* value);
static void preferences_set_highlightColor (Preferences* self,
                                     const gchar* value);
static void preferences_set_recordLaunch (Preferences* self,
                                   gboolean value);
static void preferences_set_enableTimeout (Preferences* self,
                                    gboolean value);
static void preferences_set_timeout (Preferences* self,
                              gint value);
static void preferences_set_recordAutoName (Preferences* self,
                                     gboolean value);
static void preferences_set_recordAutoDirection (Preferences* self,
                                          gint value);
static void preferences_set_recordAutoExtension (Preferences* self,
                                          const gchar* value);
static void preferences_set_recordAutoFolder (Preferences* self,
                                       const gchar* value);
static GObject * preferences_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void preferences_finalize (GObject * obj);
static GType preferences_get_type_once (void);
static void _vala_preferences_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_preferences_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
preferences_get_instance_private (Preferences* self)
{
	return G_STRUCT_MEMBER_P (self, Preferences_private_offset);
}

Preferences*
preferences_construct (GType object_type,
                       gboolean useSystemMonospaceFont,
                       const gchar* font,
                       const gchar* fontColor,
                       const gchar* backgroundColor,
                       const gchar* highlightColor,
                       gboolean recordLaunch,
                       gboolean enableTimeout,
                       gint timeout,
                       gboolean recordAutoName,
                       gint recordAutoDirection,
                       const gchar* recordAutoExtension,
                       const gchar* recordAutoFolder)
{
	Preferences * self = NULL;
	self = (Preferences*) g_object_new (object_type, "useSystemMonospaceFont", useSystemMonospaceFont, "font", font, "recordLaunch", recordLaunch, "fontColor", fontColor, "backgroundColor", backgroundColor, "highlightColor", highlightColor, "enableTimeout", enableTimeout, "timeout", timeout, "recordAutoName", recordAutoName, "recordAutoDirection", recordAutoDirection, "recordAutoExtension", recordAutoExtension, "recordAutoFolder", recordAutoFolder, NULL);
	return self;
}

Preferences*
preferences_new (gboolean useSystemMonospaceFont,
                 const gchar* font,
                 const gchar* fontColor,
                 const gchar* backgroundColor,
                 const gchar* highlightColor,
                 gboolean recordLaunch,
                 gboolean enableTimeout,
                 gint timeout,
                 gboolean recordAutoName,
                 gint recordAutoDirection,
                 const gchar* recordAutoExtension,
                 const gchar* recordAutoFolder)
{
	return preferences_construct (TYPE_PREFERENCES, useSystemMonospaceFont, font, fontColor, backgroundColor, highlightColor, recordLaunch, enableTimeout, timeout, recordAutoName, recordAutoDirection, recordAutoExtension, recordAutoFolder);
}

gchar*
preferences_getSystemDefaultMonospaceFont (void)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gchar* value = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "monospace-font-name");
	value = _tmp2_;
	_tmp3_ = value;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		g_warning ("Preferences.vala:86: %s", _ ("Unable to retrieve system font setting"));
		_tmp4_ = preferences_DEFAULT_FONT;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (value);
		value = _tmp5_;
	}
	result = value;
	_g_object_unref0 (settings);
	return result;
}

void
preferences_getGdkRGBA (const gchar* color,
                        GdkRGBA* result)
{
	GdkRGBA c = {0};
	g_return_if_fail (color != NULL);
	memset (&c, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&c, color);
	*result = c;
	return;
}

void
preferences_toString (Preferences* self)
{
	FILE* _tmp0_;
	gboolean _tmp1_;
	FILE* _tmp4_;
	const gchar* _tmp5_;
	FILE* _tmp6_;
	const gchar* _tmp7_;
	FILE* _tmp8_;
	const gchar* _tmp9_;
	FILE* _tmp10_;
	const gchar* _tmp11_;
	FILE* _tmp12_;
	gboolean _tmp13_;
	FILE* _tmp16_;
	gboolean _tmp17_;
	FILE* _tmp20_;
	gint _tmp21_;
	FILE* _tmp22_;
	const gchar* _tmp23_;
	FILE* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "useSystemMonospaceFont: ");
	_tmp1_ = self->priv->_useSystemMonospaceFont;
	if (_tmp1_) {
		FILE* _tmp2_;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "true\n");
	} else {
		FILE* _tmp3_;
		_tmp3_ = stdout;
		fprintf (_tmp3_, "false\n");
	}
	_tmp4_ = stdout;
	_tmp5_ = self->priv->_font;
	fprintf (_tmp4_, "font: %s\n", _tmp5_);
	_tmp6_ = stdout;
	_tmp7_ = self->priv->_fontColor;
	fprintf (_tmp6_, "fontColor: %s\n", _tmp7_);
	_tmp8_ = stdout;
	_tmp9_ = self->priv->_backgroundColor;
	fprintf (_tmp8_, "backgroundColor: %s\n", _tmp9_);
	_tmp10_ = stdout;
	_tmp11_ = self->priv->_highlightColor;
	fprintf (_tmp10_, "highlightColor: %s\n", _tmp11_);
	_tmp12_ = stdout;
	fprintf (_tmp12_, "recordLaunch: ");
	_tmp13_ = self->priv->_recordLaunch;
	if (_tmp13_) {
		FILE* _tmp14_;
		_tmp14_ = stdout;
		fprintf (_tmp14_, "true\n");
	} else {
		FILE* _tmp15_;
		_tmp15_ = stdout;
		fprintf (_tmp15_, "false\n");
	}
	_tmp16_ = stdout;
	fprintf (_tmp16_, "recordAutoName: ");
	_tmp17_ = self->priv->_recordAutoName;
	if (_tmp17_) {
		FILE* _tmp18_;
		_tmp18_ = stdout;
		fprintf (_tmp18_, "true\n");
	} else {
		FILE* _tmp19_;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "false\n");
	}
	_tmp20_ = stdout;
	_tmp21_ = self->priv->_recordAutoDirection;
	fprintf (_tmp20_, "recordAutoDirection: %d\n", _tmp21_);
	_tmp22_ = stdout;
	_tmp23_ = self->priv->_recordAutoExtension;
	fprintf (_tmp22_, "recordAutoExtension: %s\n", _tmp23_);
	_tmp24_ = stdout;
	_tmp25_ = self->priv->_recordAutoFolder;
	fprintf (_tmp24_, "recordAutoFolder: %s\n", _tmp25_);
}

void
preferences_saveToProfile (Preferences* self,
                           Profile* profile)
{
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	_tmp0_ = self->priv->_useSystemMonospaceFont;
	profile_setBoolean (profile, "preferences", "use_system_monospace_font", _tmp0_);
	_tmp1_ = self->priv->_font;
	profile_setString (profile, "preferences", "font", _tmp1_);
	_tmp2_ = self->priv->_fontColor;
	profile_setString (profile, "preferences", "font_color", _tmp2_);
	_tmp3_ = self->priv->_backgroundColor;
	profile_setString (profile, "preferences", "background_color", _tmp3_);
	_tmp4_ = self->priv->_highlightColor;
	profile_setString (profile, "preferences", "highlight_color", _tmp4_);
	_tmp5_ = self->priv->_recordLaunch;
	profile_setBoolean (profile, "preferences", "record_launch", _tmp5_);
	_tmp6_ = self->priv->_enableTimeout;
	profile_setBoolean (profile, "preferences", "enable_timeout", _tmp6_);
	_tmp7_ = self->priv->_timeout;
	profile_setInteger (profile, "preferences", "timeout", _tmp7_);
	_tmp8_ = self->priv->_recordAutoName;
	profile_setBoolean (profile, "preferences", "record_auto_name", _tmp8_);
	_tmp9_ = self->priv->_recordAutoDirection;
	profile_setInteger (profile, "preferences", "record_auto_direction", _tmp9_);
	_tmp10_ = self->priv->_recordAutoExtension;
	profile_setString (profile, "preferences", "record_auto_extension", _tmp10_);
	_tmp11_ = self->priv->_recordAutoFolder;
	profile_setString (profile, "preferences", "record_auto_folder", _tmp11_);
}

Preferences*
preferences_loadFromProfile (Profile* profile)
{
	gboolean useSystemMonospaceFont = FALSE;
	gchar* font = NULL;
	gchar* fontColor = NULL;
	gchar* backgroundColor = NULL;
	gchar* highlightColor = NULL;
	gboolean recordLaunch = FALSE;
	gboolean enableTimeout = FALSE;
	gint timeout = 0;
	gboolean recordAutoName = FALSE;
	gint recordAutoDirection = 0;
	gchar* recordAutoExtension = NULL;
	gchar* recordAutoFolder = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	Preferences* _tmp10_;
	Preferences* result;
	g_return_val_if_fail (profile != NULL, NULL);
	font = NULL;
	fontColor = NULL;
	backgroundColor = NULL;
	highlightColor = NULL;
	useSystemMonospaceFont = profile_getBoolean (profile, "preferences", "use_system_monospace_font", preferences_DEFAULT_USE_SYSTEM_MONOSPACE_FONT);
	_tmp0_ = profile_getString (profile, "preferences", "font");
	_g_free0 (font);
	font = _tmp0_;
	_tmp1_ = profile_getString (profile, "preferences", "font_color");
	_g_free0 (fontColor);
	fontColor = _tmp1_;
	_tmp2_ = profile_getString (profile, "preferences", "background_color");
	_g_free0 (backgroundColor);
	backgroundColor = _tmp2_;
	_tmp3_ = profile_getString (profile, "preferences", "highlight_color");
	_g_free0 (highlightColor);
	highlightColor = _tmp3_;
	recordLaunch = profile_getBoolean (profile, "preferences", "record_launch", TRUE);
	enableTimeout = profile_getBoolean (profile, "preferences", "enable_timeout", FALSE);
	timeout = profile_getInteger (profile, "preferences", "timeout", 30);
	recordAutoName = profile_getBoolean (profile, "preferences", "record_auto_name", FALSE);
	recordAutoDirection = profile_getInteger (profile, "preferences", "record_auto_direction", 0);
	_tmp4_ = profile_getString (profile, "preferences", "record_auto_extension");
	_g_free0 (recordAutoExtension);
	recordAutoExtension = _tmp4_;
	_tmp5_ = profile_getString (profile, "preferences", "record_auto_folder");
	_g_free0 (recordAutoFolder);
	recordAutoFolder = _tmp5_;
	_tmp6_ = font;
	_tmp7_ = fontColor;
	_tmp8_ = backgroundColor;
	_tmp9_ = highlightColor;
	_tmp10_ = preferences_new (useSystemMonospaceFont, _tmp6_, _tmp7_, _tmp8_, _tmp9_, recordLaunch, enableTimeout, timeout, recordAutoName, recordAutoDirection, recordAutoExtension, recordAutoFolder);
	result = _tmp10_;
	_g_free0 (recordAutoFolder);
	_g_free0 (recordAutoExtension);
	_g_free0 (highlightColor);
	_g_free0 (backgroundColor);
	_g_free0 (fontColor);
	_g_free0 (font);
	return result;
}

gboolean
preferences_get_useSystemMonospaceFont (Preferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_useSystemMonospaceFont;
	return result;
}

static void
preferences_set_useSystemMonospaceFont (Preferences* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_useSystemMonospaceFont (self);
	if (old_value != value) {
		self->priv->_useSystemMonospaceFont = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_USE_SYSTEM_MONOSPACE_FONT_PROPERTY]);
	}
}

const gchar*
preferences_get_font (Preferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font;
	result = _tmp0_;
	return result;
}

static void
preferences_set_font (Preferences* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_font (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_font);
		self->priv->_font = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_FONT_PROPERTY]);
	}
}

const gchar*
preferences_get_fontColor (Preferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fontColor;
	result = _tmp0_;
	return result;
}

static void
preferences_set_fontColor (Preferences* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_fontColor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_fontColor);
		self->priv->_fontColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_FONT_COLOR_PROPERTY]);
	}
}

const gchar*
preferences_get_backgroundColor (Preferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backgroundColor;
	result = _tmp0_;
	return result;
}

static void
preferences_set_backgroundColor (Preferences* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_backgroundColor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_backgroundColor);
		self->priv->_backgroundColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_BACKGROUND_COLOR_PROPERTY]);
	}
}

const gchar*
preferences_get_highlightColor (Preferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_highlightColor;
	result = _tmp0_;
	return result;
}

static void
preferences_set_highlightColor (Preferences* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_highlightColor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_highlightColor);
		self->priv->_highlightColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_HIGHLIGHT_COLOR_PROPERTY]);
	}
}

gboolean
preferences_get_recordLaunch (Preferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recordLaunch;
	return result;
}

static void
preferences_set_recordLaunch (Preferences* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_recordLaunch (self);
	if (old_value != value) {
		self->priv->_recordLaunch = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_RECORD_LAUNCH_PROPERTY]);
	}
}

gboolean
preferences_get_enableTimeout (Preferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enableTimeout;
	return result;
}

static void
preferences_set_enableTimeout (Preferences* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_enableTimeout (self);
	if (old_value != value) {
		self->priv->_enableTimeout = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_ENABLE_TIMEOUT_PROPERTY]);
	}
}

gint
preferences_get_timeout (Preferences* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_timeout;
	return result;
}

static void
preferences_set_timeout (Preferences* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_timeout (self);
	if (old_value != value) {
		self->priv->_timeout = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_TIMEOUT_PROPERTY]);
	}
}

gboolean
preferences_get_recordAutoName (Preferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recordAutoName;
	return result;
}

static void
preferences_set_recordAutoName (Preferences* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_recordAutoName (self);
	if (old_value != value) {
		self->priv->_recordAutoName = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_RECORD_AUTO_NAME_PROPERTY]);
	}
}

gint
preferences_get_recordAutoDirection (Preferences* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_recordAutoDirection;
	return result;
}

static void
preferences_set_recordAutoDirection (Preferences* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_recordAutoDirection (self);
	if (old_value != value) {
		self->priv->_recordAutoDirection = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_RECORD_AUTO_DIRECTION_PROPERTY]);
	}
}

const gchar*
preferences_get_recordAutoExtension (Preferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_recordAutoExtension;
	result = _tmp0_;
	return result;
}

static void
preferences_set_recordAutoExtension (Preferences* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_recordAutoExtension (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_recordAutoExtension);
		self->priv->_recordAutoExtension = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_RECORD_AUTO_EXTENSION_PROPERTY]);
	}
}

const gchar*
preferences_get_recordAutoFolder (Preferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_recordAutoFolder;
	result = _tmp0_;
	return result;
}

static void
preferences_set_recordAutoFolder (Preferences* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_recordAutoFolder (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_recordAutoFolder);
		self->priv->_recordAutoFolder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_RECORD_AUTO_FOLDER_PROPERTY]);
	}
}

static GObject *
preferences_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Preferences * self;
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	parent_class = G_OBJECT_CLASS (preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES, Preferences);
	_tmp0_ = self->priv->_font;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = preferences_DEFAULT_FONT;
		preferences_set_font (self, _tmp1_);
	}
	_tmp2_ = self->priv->_fontColor;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = preferences_DEFAULT_FONT_COLOR;
		preferences_set_fontColor (self, _tmp3_);
	}
	_tmp4_ = self->priv->_backgroundColor;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		_tmp5_ = preferences_DEFAULT_BACKGROUND_COLOR;
		preferences_set_backgroundColor (self, _tmp5_);
	}
	_tmp6_ = self->priv->_highlightColor;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = preferences_DEFAULT_HIGHLIGHT_COLOR;
		preferences_set_highlightColor (self, _tmp7_);
	}
	_tmp8_ = self->priv->_recordAutoExtension;
	if (_tmp8_ == NULL) {
		preferences_set_recordAutoExtension (self, "");
	}
	_tmp9_ = self->priv->_recordAutoFolder;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		_tmp10_ = g_get_home_dir ();
		preferences_set_recordAutoFolder (self, _tmp10_);
	}
	return obj;
}

static void
preferences_class_init (PreferencesClass * klass,
                        gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Preferences_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_USE_SYSTEM_MONOSPACE_FONT_PROPERTY, preferences_properties[PREFERENCES_USE_SYSTEM_MONOSPACE_FONT_PROPERTY] = g_param_spec_boolean ("useSystemMonospaceFont", "useSystemMonospaceFont", "useSystemMonospaceFont", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT_PROPERTY, preferences_properties[PREFERENCES_FONT_PROPERTY] = g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_FONT_COLOR_PROPERTY, preferences_properties[PREFERENCES_FONT_COLOR_PROPERTY] = g_param_spec_string ("fontColor", "fontColor", "fontColor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_BACKGROUND_COLOR_PROPERTY, preferences_properties[PREFERENCES_BACKGROUND_COLOR_PROPERTY] = g_param_spec_string ("backgroundColor", "backgroundColor", "backgroundColor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_HIGHLIGHT_COLOR_PROPERTY, preferences_properties[PREFERENCES_HIGHLIGHT_COLOR_PROPERTY] = g_param_spec_string ("highlightColor", "highlightColor", "highlightColor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_LAUNCH_PROPERTY, preferences_properties[PREFERENCES_RECORD_LAUNCH_PROPERTY] = g_param_spec_boolean ("recordLaunch", "recordLaunch", "recordLaunch", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_ENABLE_TIMEOUT_PROPERTY, preferences_properties[PREFERENCES_ENABLE_TIMEOUT_PROPERTY] = g_param_spec_boolean ("enableTimeout", "enableTimeout", "enableTimeout", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_TIMEOUT_PROPERTY, preferences_properties[PREFERENCES_TIMEOUT_PROPERTY] = g_param_spec_int ("timeout", "timeout", "timeout", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_AUTO_NAME_PROPERTY, preferences_properties[PREFERENCES_RECORD_AUTO_NAME_PROPERTY] = g_param_spec_boolean ("recordAutoName", "recordAutoName", "recordAutoName", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_AUTO_DIRECTION_PROPERTY, preferences_properties[PREFERENCES_RECORD_AUTO_DIRECTION_PROPERTY] = g_param_spec_int ("recordAutoDirection", "recordAutoDirection", "recordAutoDirection", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_AUTO_EXTENSION_PROPERTY, preferences_properties[PREFERENCES_RECORD_AUTO_EXTENSION_PROPERTY] = g_param_spec_string ("recordAutoExtension", "recordAutoExtension", "recordAutoExtension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_RECORD_AUTO_FOLDER_PROPERTY, preferences_properties[PREFERENCES_RECORD_AUTO_FOLDER_PROPERTY] = g_param_spec_string ("recordAutoFolder", "recordAutoFolder", "recordAutoFolder", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("Monospace 10");
	preferences_DEFAULT_FONT = _tmp0_;
	_tmp1_ = g_strdup ("black");
	preferences_DEFAULT_FONT_COLOR = _tmp1_;
	_tmp2_ = g_strdup ("white");
	preferences_DEFAULT_BACKGROUND_COLOR = _tmp2_;
	_tmp3_ = g_strdup ("#2020ff");
	preferences_DEFAULT_HIGHLIGHT_COLOR = _tmp3_;
}

static void
preferences_instance_init (Preferences * self,
                           gpointer klass)
{
	self->priv = preferences_get_instance_private (self);
}

static void
preferences_finalize (GObject * obj)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES, Preferences);
	_g_free0 (self->priv->_font);
	_g_free0 (self->priv->_fontColor);
	_g_free0 (self->priv->_backgroundColor);
	_g_free0 (self->priv->_highlightColor);
	_g_free0 (self->priv->_recordAutoExtension);
	_g_free0 (self->priv->_recordAutoFolder);
	G_OBJECT_CLASS (preferences_parent_class)->finalize (obj);
}

static GType
preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preferences), 0, (GInstanceInitFunc) preferences_instance_init, NULL };
	GType preferences_type_id;
	preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "Preferences", &g_define_type_info, 0);
	Preferences_private_offset = g_type_add_instance_private (preferences_type_id, sizeof (PreferencesPrivate));
	return preferences_type_id;
}

GType
preferences_get_type (void)
{
	static volatile gsize preferences_type_id__once = 0;
	if (g_once_init_enter (&preferences_type_id__once)) {
		GType preferences_type_id;
		preferences_type_id = preferences_get_type_once ();
		g_once_init_leave (&preferences_type_id__once, preferences_type_id);
	}
	return preferences_type_id__once;
}

static void
_vala_preferences_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREFERENCES, Preferences);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT_PROPERTY:
		g_value_set_boolean (value, preferences_get_useSystemMonospaceFont (self));
		break;
		case PREFERENCES_FONT_PROPERTY:
		g_value_set_string (value, preferences_get_font (self));
		break;
		case PREFERENCES_FONT_COLOR_PROPERTY:
		g_value_set_string (value, preferences_get_fontColor (self));
		break;
		case PREFERENCES_BACKGROUND_COLOR_PROPERTY:
		g_value_set_string (value, preferences_get_backgroundColor (self));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR_PROPERTY:
		g_value_set_string (value, preferences_get_highlightColor (self));
		break;
		case PREFERENCES_RECORD_LAUNCH_PROPERTY:
		g_value_set_boolean (value, preferences_get_recordLaunch (self));
		break;
		case PREFERENCES_ENABLE_TIMEOUT_PROPERTY:
		g_value_set_boolean (value, preferences_get_enableTimeout (self));
		break;
		case PREFERENCES_TIMEOUT_PROPERTY:
		g_value_set_int (value, preferences_get_timeout (self));
		break;
		case PREFERENCES_RECORD_AUTO_NAME_PROPERTY:
		g_value_set_boolean (value, preferences_get_recordAutoName (self));
		break;
		case PREFERENCES_RECORD_AUTO_DIRECTION_PROPERTY:
		g_value_set_int (value, preferences_get_recordAutoDirection (self));
		break;
		case PREFERENCES_RECORD_AUTO_EXTENSION_PROPERTY:
		g_value_set_string (value, preferences_get_recordAutoExtension (self));
		break;
		case PREFERENCES_RECORD_AUTO_FOLDER_PROPERTY:
		g_value_set_string (value, preferences_get_recordAutoFolder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_preferences_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREFERENCES, Preferences);
	switch (property_id) {
		case PREFERENCES_USE_SYSTEM_MONOSPACE_FONT_PROPERTY:
		preferences_set_useSystemMonospaceFont (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_FONT_PROPERTY:
		preferences_set_font (self, g_value_get_string (value));
		break;
		case PREFERENCES_FONT_COLOR_PROPERTY:
		preferences_set_fontColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_BACKGROUND_COLOR_PROPERTY:
		preferences_set_backgroundColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_HIGHLIGHT_COLOR_PROPERTY:
		preferences_set_highlightColor (self, g_value_get_string (value));
		break;
		case PREFERENCES_RECORD_LAUNCH_PROPERTY:
		preferences_set_recordLaunch (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_ENABLE_TIMEOUT_PROPERTY:
		preferences_set_enableTimeout (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_TIMEOUT_PROPERTY:
		preferences_set_timeout (self, g_value_get_int (value));
		break;
		case PREFERENCES_RECORD_AUTO_NAME_PROPERTY:
		preferences_set_recordAutoName (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_RECORD_AUTO_DIRECTION_PROPERTY:
		preferences_set_recordAutoDirection (self, g_value_get_int (value));
		break;
		case PREFERENCES_RECORD_AUTO_EXTENSION_PROPERTY:
		preferences_set_recordAutoExtension (self, g_value_get_string (value));
		break;
		case PREFERENCES_RECORD_AUTO_FOLDER_PROPERTY:
		preferences_set_recordAutoFolder (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

