/* TaggerParser.c generated by valac 0.56.18, the Vala compiler
 * generated from TaggerParser.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;
typedef struct _TextParserPrivate TextParserPrivate;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TYPE_TAGGER_PARSER (tagger_parser_get_type ())
#define TAGGER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAGGER_PARSER, TaggerParser))
#define TAGGER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAGGER_PARSER, TaggerParserClass))
#define IS_TAGGER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAGGER_PARSER))
#define IS_TAGGER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAGGER_PARSER))
#define TAGGER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAGGER_PARSER, TaggerParserClass))

typedef struct _TaggerParser TaggerParser;
typedef struct _TaggerParserClass TaggerParserClass;
typedef struct _TaggerParserPrivate TaggerParserPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef void (*TextParserTextMatchCallback) (FormattedText* text, GMatchInfo* match_info, gpointer user_data);

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_TEXT_COMPLETION_ITEM (text_completion_item_get_type ())
#define TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItem))
#define TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))
#define IS_TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_COMPLETION_ITEM))
#define IS_TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_COMPLETION_ITEM))
#define TEXT_COMPLETION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))

typedef struct _TextCompletionItem TextCompletionItem;
typedef struct _TextCompletionItemClass TextCompletionItemClass;

#define TYPE_TAGGER (tagger_get_type ())
#define TAGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAGGER, Tagger))
#define TAGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAGGER, TaggerClass))
#define IS_TAGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAGGER))
#define IS_TAGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAGGER))
#define TAGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAGGER, TaggerClass))

typedef struct _Tagger Tagger;
typedef struct _TaggerClass TaggerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TextParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextParserPrivate * priv;
};

struct _TextParserClass {
	GTypeClass parent_class;
	void (*finalize) (TextParser *self);
	gboolean (*tag_handled) (TextParser* self, FormatTag tag);
	void (*insert_tag) (TextParser* self, CanvasText* ct, FormatTag tag, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer, const gchar* extra);
	void (*remove_all_tags) (TextParser* self, CanvasText* ct, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer);
};

struct _TaggerParser {
	TextParser parent_instance;
	TaggerParserPrivate * priv;
};

struct _TaggerParserClass {
	TextParserClass parent_class;
};

struct _TaggerParserPrivate {
	DrawArea* _da;
};

static gint TaggerParser_private_offset;
static gpointer tagger_parser_parent_class = NULL;

VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN GType tagger_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TaggerParser, text_parser_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gboolean text_parser_tag_handled (TextParser* self,
                                  FormatTag tag);
VALA_EXTERN TaggerParser* tagger_parser_new (DrawArea* da);
VALA_EXTERN TaggerParser* tagger_parser_construct (GType object_type,
                                       DrawArea* da);
VALA_EXTERN TextParser* text_parser_new (const gchar* name);
VALA_EXTERN TextParser* text_parser_construct (GType object_type,
                                   const gchar* name);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN void text_parser_add_regex (TextParser* self,
                            const gchar* re,
                            TextParserTextMatchCallback func,
                            gpointer func_target);
static void tagger_parser_handle_tag (TaggerParser* self,
                               FormattedText* text,
                               GMatchInfo* match);
static void _tagger_parser_handle_tag_text_parser_text_match_callback (FormattedText* text,
                                                                GMatchInfo* match_info,
                                                                gpointer self);
static void tagger_parser_handle_notag (TaggerParser* self,
                                 FormattedText* text,
                                 GMatchInfo* match);
static void _tagger_parser_handle_notag_text_parser_text_match_callback (FormattedText* text,
                                                                  GMatchInfo* match_info,
                                                                  gpointer self);
VALA_EXTERN gchar* text_parser_get_text (TextParser* self,
                             GMatchInfo* matches,
                             gint paren);
VALA_EXTERN void text_parser_add_tag (TextParser* self,
                          FormattedText* text,
                          GMatchInfo* matches,
                          gint paren,
                          FormatTag tag,
                          const gchar* extra);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN gint canvas_text_get_cursor (CanvasText* self);
VALA_EXTERN gpointer text_completion_item_ref (gpointer instance);
VALA_EXTERN void text_completion_item_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_completion_item (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_text_completion_item (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_text_completion_item (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_text_completion_item (const GValue* value);
VALA_EXTERN GType text_completion_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextCompletionItem, text_completion_item_unref)
VALA_EXTERN void draw_area_show_auto_completion (DrawArea* self,
                                     GList* values,
                                     gint start_pos,
                                     gint end_pos);
VALA_EXTERN gpointer tagger_ref (gpointer instance);
VALA_EXTERN void tagger_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_tagger (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_tagger (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_tagger (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_tagger (const GValue* value);
VALA_EXTERN GType tagger_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tagger, tagger_unref)
VALA_EXTERN Tagger* draw_area_get_tagger (DrawArea* self);
VALA_EXTERN GList* tagger_get_matches (Tagger* self,
                           const gchar* partial);
static void _text_completion_item_unref0_ (gpointer var);
static inline void _g_list_free__text_completion_item_unref0_ (GList* self);
VALA_EXTERN void draw_area_hide_auto_completion (DrawArea* self);
static gboolean tagger_parser_real_tag_handled (TextParser* base,
                                         FormatTag tag);
static void tagger_parser_finalize (TextParser * obj);
static GType tagger_parser_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tagger_parser_get_instance_private (TaggerParser* self)
{
	return G_STRUCT_MEMBER_P (self, TaggerParser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tagger_parser_handle_tag_text_parser_text_match_callback (FormattedText* text,
                                                           GMatchInfo* match_info,
                                                           gpointer self)
{
	tagger_parser_handle_tag ((TaggerParser*) self, text, match_info);
}

static void
_tagger_parser_handle_notag_text_parser_text_match_callback (FormattedText* text,
                                                             GMatchInfo* match_info,
                                                             gpointer self)
{
	tagger_parser_handle_notag ((TaggerParser*) self, text, match_info);
}

TaggerParser*
tagger_parser_construct (GType object_type,
                         DrawArea* da)
{
	TaggerParser* self = NULL;
	DrawArea* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (TaggerParser*) text_parser_construct (object_type, "Tagger");
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	text_parser_add_regex ((TextParser*) self, "\\s(@(\\S*))", _tagger_parser_handle_tag_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "\\s", _tagger_parser_handle_notag_text_parser_text_match_callback, self);
	return self;
}

TaggerParser*
tagger_parser_new (DrawArea* da)
{
	return tagger_parser_construct (TYPE_TAGGER_PARSER, da);
}

static void
_text_completion_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (text_completion_item_unref (var), NULL));
}

static inline void
_g_list_free__text_completion_item_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _text_completion_item_unref0_);
}

static void
tagger_parser_handle_tag (TaggerParser* self,
                          FormattedText* text,
                          GMatchInfo* match)
{
	gchar* tag = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	DrawArea* _tmp3_;
	Node* _tmp4_;
	Node* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 2);
	tag = _tmp0_;
	_tmp1_ = tag;
	text_parser_add_tag ((TextParser*) self, text, match, 1, FORMAT_TAG_TAG, _tmp1_);
	_tmp3_ = self->priv->_da;
	_tmp4_ = draw_area_get_current_node (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		DrawArea* _tmp7_;
		Node* _tmp8_;
		Node* _tmp9_;
		CanvasText* _tmp10_;
		CanvasText* _tmp11_;
		FormattedText* _tmp12_;
		FormattedText* _tmp13_;
		_tmp7_ = self->priv->_da;
		_tmp8_ = draw_area_get_current_node (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = node_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = canvas_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp2_ = _tmp13_ == text;
		_g_object_unref0 (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint start = 0;
		gint end = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint cursor = 0;
		DrawArea* _tmp16_;
		Node* _tmp17_;
		Node* _tmp18_;
		CanvasText* _tmp19_;
		CanvasText* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gboolean _tmp24_ = FALSE;
		g_match_info_fetch_pos (match, 1, &_tmp14_, &_tmp15_);
		start = _tmp14_;
		end = _tmp15_;
		_tmp16_ = self->priv->_da;
		_tmp17_ = draw_area_get_current_node (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = node_get_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = canvas_text_get_cursor (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp18_);
		cursor = _tmp23_;
		if (start <= cursor) {
			_tmp24_ = cursor <= end;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			DrawArea* _tmp25_;
			DrawArea* _tmp26_;
			Tagger* _tmp27_;
			Tagger* _tmp28_;
			const gchar* _tmp29_;
			GList* _tmp30_;
			GList* _tmp31_;
			_tmp25_ = self->priv->_da;
			_tmp26_ = self->priv->_da;
			_tmp27_ = draw_area_get_tagger (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = tag;
			_tmp30_ = tagger_get_matches (_tmp28_, _tmp29_);
			_tmp31_ = _tmp30_;
			draw_area_show_auto_completion (_tmp25_, _tmp31_, start + 1, end);
			(_tmp31_ == NULL) ? NULL : (_tmp31_ = (_g_list_free__text_completion_item_unref0_ (_tmp31_), NULL));
		}
	}
	_g_free0 (tag);
}

static void
tagger_parser_handle_notag (TaggerParser* self,
                            FormattedText* text,
                            GMatchInfo* match)
{
	gboolean _tmp0_ = FALSE;
	DrawArea* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_current_node (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		DrawArea* _tmp5_;
		Node* _tmp6_;
		Node* _tmp7_;
		CanvasText* _tmp8_;
		CanvasText* _tmp9_;
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		_tmp5_ = self->priv->_da;
		_tmp6_ = draw_area_get_current_node (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = node_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = canvas_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_ == text;
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint start = 0;
		gint end = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		DrawArea* _tmp14_;
		Node* _tmp15_;
		Node* _tmp16_;
		CanvasText* _tmp17_;
		CanvasText* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gboolean _tmp21_;
		g_match_info_fetch_pos (match, 0, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = self->priv->_da;
		_tmp15_ = draw_area_get_current_node (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = node_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = canvas_text_get_cursor (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_ == start;
		_g_object_unref0 (_tmp16_);
		if (_tmp21_) {
			DrawArea* _tmp22_;
			_tmp22_ = self->priv->_da;
			draw_area_hide_auto_completion (_tmp22_);
		}
	}
}

static gboolean
tagger_parser_real_tag_handled (TextParser* base,
                                FormatTag tag)
{
	TaggerParser * self;
	gboolean result;
	self = (TaggerParser*) base;
	result = tag == FORMAT_TAG_TAG;
	return result;
}

static void
tagger_parser_class_init (TaggerParserClass * klass,
                          gpointer klass_data)
{
	tagger_parser_parent_class = g_type_class_peek_parent (klass);
	((TextParserClass *) klass)->finalize = tagger_parser_finalize;
	g_type_class_adjust_private_offset (klass, &TaggerParser_private_offset);
	((TextParserClass *) klass)->tag_handled = (gboolean (*) (TextParser*, FormatTag)) tagger_parser_real_tag_handled;
}

static void
tagger_parser_instance_init (TaggerParser * self,
                             gpointer klass)
{
	self->priv = tagger_parser_get_instance_private (self);
}

static void
tagger_parser_finalize (TextParser * obj)
{
	TaggerParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAGGER_PARSER, TaggerParser);
	_g_object_unref0 (self->priv->_da);
	TEXT_PARSER_CLASS (tagger_parser_parent_class)->finalize (obj);
}

static GType
tagger_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TaggerParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tagger_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaggerParser), 0, (GInstanceInitFunc) tagger_parser_instance_init, NULL };
	GType tagger_parser_type_id;
	tagger_parser_type_id = g_type_register_static (TYPE_TEXT_PARSER, "TaggerParser", &g_define_type_info, 0);
	TaggerParser_private_offset = g_type_add_instance_private (tagger_parser_type_id, sizeof (TaggerParserPrivate));
	return tagger_parser_type_id;
}

GType
tagger_parser_get_type (void)
{
	static volatile gsize tagger_parser_type_id__once = 0;
	if (g_once_init_enter (&tagger_parser_type_id__once)) {
		GType tagger_parser_type_id;
		tagger_parser_type_id = tagger_parser_get_type_once ();
		g_once_init_leave (&tagger_parser_type_id__once, tagger_parser_type_id);
	}
	return tagger_parser_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

