/* ExportPlantUML.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportPlantUML.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_PLANT_UML (export_plant_uml_get_type ())
#define EXPORT_PLANT_UML(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_PLANT_UML, ExportPlantUML))
#define EXPORT_PLANT_UML_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_PLANT_UML, ExportPlantUMLClass))
#define IS_EXPORT_PLANT_UML(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_PLANT_UML))
#define IS_EXPORT_PLANT_UML_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_PLANT_UML))
#define EXPORT_PLANT_UML_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_PLANT_UML, ExportPlantUMLClass))

typedef struct _ExportPlantUML ExportPlantUML;
typedef struct _ExportPlantUMLClass ExportPlantUMLClass;
typedef struct _ExportPlantUMLPrivate ExportPlantUMLPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

#define TYPE_NODE_BORDER (node_border_get_type ())
#define NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BORDER, NodeBorder))
#define IS_NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BORDER))
#define NODE_BORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NODE_BORDER, NodeBorderIface))

typedef struct _NodeBorder NodeBorder;
typedef struct _NodeBorderIface NodeBorderIface;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportPlantUML {
	Export parent_instance;
	ExportPlantUMLPrivate * priv;
};

struct _ExportPlantUMLClass {
	ExportClass parent_class;
};

struct _NodeBorderIface {
	GTypeInterface parent_iface;
	gchar* (*name) (NodeBorder* self);
	gchar* (*display_name) (NodeBorder* self);
	gchar* (*icon_name) (NodeBorder* self);
	gboolean (*is_fillable) (NodeBorder* self);
	void (*draw_border) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
	void (*draw_fill) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
};

static gpointer export_plant_uml_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_plant_uml_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportPlantUML, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportPlantUML* export_plant_uml_new (void);
VALA_EXTERN ExportPlantUML* export_plant_uml_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_plant_uml_real_export (Export* base,
                                       const gchar* fname,
                                       DrawArea* da);
static void export_plant_uml_export_top_nodes (ExportPlantUML* self,
                                        GFileOutputStream* os,
                                        DrawArea* da);
static void export_plant_uml_export_header (ExportPlantUML* self,
                                     GFileOutputStream* os,
                                     DrawArea* da);
static void export_plant_uml_export_footer (ExportPlantUML* self,
                                     GFileOutputStream* os,
                                     DrawArea* da);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
static void export_plant_uml_export_node (ExportPlantUML* self,
                                   GFileOutputStream* os,
                                   Node* node,
                                   gint depth);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN const gchar* layout_get_name (Layout* self);
VALA_EXTERN gboolean node_main_branch (Node* self);
VALA_EXTERN gint node_index (Node* self);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN Node* node_prev_child (Node* self,
                       Node* n);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN GType node_border_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBorder, g_object_unref)
VALA_EXTERN NodeBorder* style_get_node_border (Style* self);
VALA_EXTERN gboolean node_border_is_fillable (NodeBorder* self);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN GArray* node_children (Node* self);
static gboolean export_plant_uml_real_import (Export* base,
                                       const gchar* fname,
                                       DrawArea* da);
static void export_plant_uml_import_doc (ExportPlantUML* self,
                                  const gchar* str,
                                  DrawArea* da);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
static void export_plant_uml_import_node (ExportPlantUML* self,
                                   DrawArea* da,
                                   GMatchInfo* matches,
                                   NodeSide side,
                                   Node** last_node);
VALA_EXTERN Node* draw_area_create_root_node (DrawArea* self,
                                  const gchar* name);
VALA_EXTERN Node* draw_area_create_main_node (DrawArea* self,
                                  Node* root,
                                  NodeSide side,
                                  const gchar* name);
VALA_EXTERN Node* node_get_root (Node* self);
VALA_EXTERN guint node_get_level (Node* self);
VALA_EXTERN Node* draw_area_create_child_node (DrawArea* self,
                                   Node* parent,
                                   const gchar* name);
VALA_EXTERN Node* draw_area_create_sibling_node (DrawArea* self,
                                     Node* sibling,
                                     gboolean below,
                                     const gchar* name);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN NodeBorder* styles_get_node_border (Styles* self,
                                    const gchar* name);
VALA_EXTERN void style_set_node_border (Style* self,
                            NodeBorder* value);
VALA_EXTERN void node_set_link_color (Node* self,
                          GdkRGBA* value);
static GType export_plant_uml_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportPlantUML*
export_plant_uml_construct (GType object_type)
{
	ExportPlantUML* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".puml");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportPlantUML*) export_construct (object_type, "plant-uml", _ ("PlantUML"), _tmp2_, (gint) 1, TRUE, TRUE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportPlantUML*
export_plant_uml_new (void)
{
	return export_plant_uml_construct (TYPE_EXPORT_PLANT_UML);
}

static gboolean
export_plant_uml_real_export (Export* base,
                              const gchar* fname,
                              DrawArea* da)
{
	ExportPlantUML * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportPlantUML*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	retval = TRUE;
	{
		GFileOutputStream* os = NULL;
		GFileOutputStream* _tmp1_;
		_tmp1_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		os = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		export_plant_uml_export_top_nodes (self, os, da);
		_g_object_unref0 (os);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		retval = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = retval;
	_g_object_unref0 (file);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
export_plant_uml_export_header (ExportPlantUML* self,
                                GFileOutputStream* os,
                                DrawArea* da)
{
	gchar* start = NULL;
	gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = g_strdup ("@startmindmap\n");
	start = _tmp0_;
	_tmp1_ = string_get_data (start, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	g_output_stream_write ((GOutputStream*) os, _tmp3_, (gsize) _tmp3__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (start);
}

static void
export_plant_uml_export_footer (ExportPlantUML* self,
                                GFileOutputStream* os,
                                DrawArea* da)
{
	gchar* start = NULL;
	gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = g_strdup ("@endmindmap\n\n");
	start = _tmp0_;
	_tmp1_ = string_get_data (start, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	g_output_stream_write ((GOutputStream*) os, _tmp3_, (gsize) _tmp3__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (start);
}

static void
export_plant_uml_export_top_nodes (ExportPlantUML* self,
                                   GFileOutputStream* os,
                                   DrawArea* da)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	{
		GArray* nodes = NULL;
		GArray* _tmp0_;
		_tmp0_ = draw_area_get_nodes (da);
		nodes = _tmp0_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Node* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = nodes;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					export_plant_uml_export_header (self, os, da);
					_tmp4_ = nodes;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					export_plant_uml_export_node (self, os, _tmp5_, 1);
					export_plant_uml_export_footer (self, os, da);
				}
			}
		}
		_g_array_unref0 (nodes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
export_plant_uml_export_node (ExportPlantUML* self,
                              GFileOutputStream* os,
                              Node* node,
                              gint depth)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (node != NULL);
	{
		gchar* layout_name = NULL;
		Layout* _tmp0_;
		Layout* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* title = NULL;
		gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp43_;
		CanvasText* _tmp44_;
		CanvasText* _tmp45_;
		FormattedText* _tmp46_;
		FormattedText* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		guint8* _tmp56_;
		gint _tmp56__length1;
		gint _tmp57_ = 0;
		guint8* _tmp58_;
		gint _tmp58__length1;
		GArray* children = NULL;
		GArray* _tmp59_;
		_tmp0_ = node_get_layout (node);
		_tmp1_ = _tmp0_;
		_tmp2_ = layout_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		layout_name = _tmp4_;
		_tmp5_ = g_strdup ("");
		title = _tmp5_;
		if (node_main_branch (node)) {
			gboolean _tmp7_ = FALSE;
			if (node_index (node) == 0) {
				_tmp7_ = TRUE;
			} else {
				NodeSide _tmp8_;
				NodeSide _tmp9_;
				Node* _tmp10_;
				Node* _tmp11_;
				Node* _tmp12_;
				Node* _tmp13_;
				NodeSide _tmp14_;
				NodeSide _tmp15_;
				_tmp8_ = node_get_side (node);
				_tmp9_ = _tmp8_;
				_tmp10_ = node_get_parent (node);
				_tmp11_ = _tmp10_;
				_tmp12_ = node_prev_child (_tmp11_, node);
				_tmp13_ = _tmp12_;
				_tmp14_ = node_get_side (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp7_ = _tmp9_ != _tmp15_;
				_g_object_unref0 (_tmp13_);
			}
			_tmp6_ = _tmp7_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			NodeSide _tmp16_;
			NodeSide _tmp17_;
			_tmp16_ = node_get_side (node);
			_tmp17_ = _tmp16_;
			switch (_tmp17_) {
				case NODE_SIDE_LEFT:
				case NODE_SIDE_TOP:
				{
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = title;
					_tmp19_ = g_strconcat (_tmp18_, "\nleft side\n", NULL);
					_g_free0 (title);
					title = _tmp19_;
					break;
				}
				default:
				{
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = title;
					_tmp21_ = g_strconcat (_tmp20_, "\nright side\n", NULL);
					_g_free0 (title);
					title = _tmp21_;
					break;
				}
			}
		}
		_tmp22_ = title;
		_tmp23_ = g_strnfill ((gsize) depth, '*');
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
		_g_free0 (title);
		title = _tmp25_;
		_g_free0 (_tmp24_);
		if (!node_is_root (node)) {
			Style* _tmp26_;
			Style* _tmp27_;
			NodeBorder* _tmp28_;
			NodeBorder* _tmp29_;
			_tmp26_ = node_get_style (node);
			_tmp27_ = _tmp26_;
			_tmp28_ = style_get_node_border (_tmp27_);
			_tmp29_ = _tmp28_;
			if (node_border_is_fillable (_tmp29_)) {
				const gchar* _tmp30_;
				GdkRGBA* _tmp31_;
				GdkRGBA* _tmp32_;
				GdkRGBA _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp30_ = title;
				_tmp31_ = node_get_link_color (node);
				_tmp32_ = _tmp31_;
				_tmp33_ = *_tmp32_;
				_tmp34_ = utils_color_from_rgba (&_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strdup_printf ("[%s] ", _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat (_tmp30_, _tmp37_, NULL);
				_g_free0 (title);
				title = _tmp38_;
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
			} else {
				const gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp39_ = title;
				_tmp40_ = g_strconcat (_tmp39_, "_ ", NULL);
				_g_free0 (title);
				title = _tmp40_;
			}
		} else {
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp41_ = title;
			_tmp42_ = g_strconcat (_tmp41_, " ", NULL);
			_g_free0 (title);
			title = _tmp42_;
		}
		_tmp43_ = title;
		_tmp44_ = node_get_name (node);
		_tmp45_ = _tmp44_;
		_tmp46_ = canvas_text_get_text (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = formatted_text_get_text (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = string_replace (_tmp49_, "\n", "\\n");
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat (_tmp51_, "\n", NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_tmp43_, _tmp53_, NULL);
		_g_free0 (title);
		title = _tmp54_;
		_g_free0 (_tmp53_);
		_g_free0 (_tmp51_);
		_tmp55_ = title;
		_tmp56_ = string_get_data (_tmp55_, &_tmp57_);
		_tmp56__length1 = _tmp57_;
		_tmp58_ = _tmp56_;
		_tmp58__length1 = _tmp56__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp58_, (gsize) _tmp58__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			_g_free0 (layout_name);
			goto __catch0_g_error;
		}
		_tmp59_ = node_children (node);
		children = _tmp59_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp60_ = FALSE;
				_tmp60_ = TRUE;
				while (TRUE) {
					GArray* _tmp62_;
					GArray* _tmp63_;
					Node* _tmp64_;
					if (!_tmp60_) {
						gint _tmp61_;
						_tmp61_ = i;
						i = _tmp61_ + 1;
					}
					_tmp60_ = FALSE;
					_tmp62_ = children;
					if (!(((guint) i) < _tmp62_->len)) {
						break;
					}
					_tmp63_ = children;
					_tmp64_ = g_array_index (_tmp63_, Node*, (guint) i);
					export_plant_uml_export_node (self, os, _tmp64_, depth + 1);
				}
			}
		}
		_g_array_unref0 (children);
		_g_free0 (title);
		_g_free0 (layout_name);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
export_plant_uml_real_import (Export* base,
                              const gchar* fname,
                              DrawArea* da)
{
	ExportPlantUML * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportPlantUML*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFileInputStream* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFileInputStream* _tmp3_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp4_;
		gsize len = 0UL;
		GArray* nodes = NULL;
		gchar* _tmp5_ = NULL;
		GDataInputStream* _tmp6_;
		gsize _tmp7_ = 0UL;
		gchar* _tmp8_;
		gchar* str = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp0_ = g_file_new_for_path (fname);
		file = _tmp0_;
		_tmp2_ = file;
		_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
		_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
		dis = _tmp4_;
		_tmp6_ = dis;
		_tmp8_ = g_data_input_stream_read_upto (_tmp6_, "\0", (gssize) 1, &_tmp7_, NULL, &_inner_error0_);
		len = _tmp7_;
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_array_unref0 (nodes);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (file);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
		_tmp9_ = g_strconcat (_tmp5_, "\0", NULL);
		str = _tmp9_;
		_tmp10_ = str;
		export_plant_uml_import_doc (self, _tmp10_, da);
		gtk_widget_queue_draw ((GtkWidget*) da);
		draw_area_auto_save (da);
		_g_free0 (str);
		_g_free0 (_tmp5_);
		_g_array_unref0 (nodes);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	result = TRUE;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static void
export_plant_uml_import_doc (ExportPlantUML* self,
                             const gchar* str,
                             DrawArea* da)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	gboolean parse = FALSE;
	NodeSide side = 0;
	GMatchInfo* matches = NULL;
	GRegex* node_re = NULL;
	Node* last_node = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	g_return_if_fail (da != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (str, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	parse = FALSE;
	side = NODE_SIDE_RIGHT;
	last_node = NULL;
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		_tmp3_ = g_regex_new ("^([*+-]+|\\t*[*+-])(\\[#[0-9a-fA-F]{6}\\]|_)?\\s(.*)$", 0, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_object_unref0 (last_node);
			_g_regex_unref0 (node_re);
			_g_match_info_unref0 (matches);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (node_re);
		node_re = _tmp4_;
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (last_node);
		_g_regex_unref0 (node_re);
		_g_match_info_unref0 (matches);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (last_node);
		_g_regex_unref0 (node_re);
		_g_match_info_unref0 (matches);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp6_;
			gchar* line = NULL;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				if (!parse) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gboolean _tmp10_;
					_tmp7_ = line;
					_tmp8_ = string_chomp (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strcmp0 (_tmp9_, "@startmindmap") == 0;
					_g_free0 (_tmp9_);
					if (_tmp10_) {
						parse = TRUE;
					}
				} else {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gboolean _tmp14_;
					_tmp11_ = line;
					_tmp12_ = string_chomp (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strcmp0 (_tmp13_, "@endmindmap") == 0;
					_g_free0 (_tmp13_);
					if (_tmp14_) {
						parse = FALSE;
					} else {
						const gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gboolean _tmp18_;
						_tmp15_ = line;
						_tmp16_ = string_chomp (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = g_strcmp0 (_tmp17_, "right side") == 0;
						_g_free0 (_tmp17_);
						if (_tmp18_) {
							side = NODE_SIDE_RIGHT;
						} else {
							const gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gboolean _tmp22_;
							_tmp19_ = line;
							_tmp20_ = string_chomp (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_strcmp0 (_tmp21_, "left side") == 0;
							_g_free0 (_tmp21_);
							if (_tmp22_) {
								side = NODE_SIDE_LEFT;
							} else {
								GRegex* _tmp23_;
								const gchar* _tmp24_;
								GMatchInfo* _tmp25_ = NULL;
								gboolean _tmp26_;
								_tmp23_ = node_re;
								_tmp24_ = line;
								_tmp26_ = g_regex_match (_tmp23_, _tmp24_, 0, &_tmp25_);
								_g_match_info_unref0 (matches);
								matches = _tmp25_;
								if (_tmp26_) {
									GMatchInfo* _tmp27_;
									_tmp27_ = matches;
									export_plant_uml_import_node (self, da, _tmp27_, side, &last_node);
								}
							}
						}
					}
				}
				_g_free0 (line);
			}
		}
	}
	_g_object_unref0 (last_node);
	_g_regex_unref0 (node_re);
	_g_match_info_unref0 (matches);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
export_plant_uml_import_node (ExportPlantUML* self,
                              DrawArea* da,
                              GMatchInfo* matches,
                              NodeSide side,
                              Node** last_node)
{
	gchar* li = NULL;
	gchar* _tmp0_;
	gchar* color = NULL;
	gchar* _tmp1_;
	gchar* text = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint depth = 0;
	const gchar* _tmp6_;
	const gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (matches != NULL);
	_tmp0_ = g_match_info_fetch (matches, 1);
	li = _tmp0_;
	_tmp1_ = g_match_info_fetch (matches, 2);
	color = _tmp1_;
	_tmp2_ = g_match_info_fetch (matches, 3);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "\\n", "\n");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	text = _tmp5_;
	depth = 1;
	_tmp6_ = li;
	switch (string_get_char (_tmp6_, (glong) 0)) {
		case '*':
		{
			const gchar* _tmp7_;
			_tmp7_ = li;
			depth = g_utf8_strlen (_tmp7_, (gssize) -1);
			break;
		}
		case '+':
		{
			const gchar* _tmp8_;
			_tmp8_ = li;
			depth = g_utf8_strlen (_tmp8_, (gssize) -1);
			side = NODE_SIDE_RIGHT;
			break;
		}
		case '-':
		{
			const gchar* _tmp9_;
			_tmp9_ = li;
			depth = g_utf8_strlen (_tmp9_, (gssize) -1);
			side = NODE_SIDE_LEFT;
			break;
		}
		default:
		{
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = li;
			depth = g_utf8_strlen (_tmp10_, (gssize) -1) - 1;
			_tmp11_ = li;
			_tmp12_ = li;
			switch (string_get_char (_tmp11_, (glong) string_index_of_nth_char (_tmp12_, (glong) depth))) {
				case '+':
				{
					side = NODE_SIDE_RIGHT;
					break;
				}
				case '-':
				{
					side = NODE_SIDE_LEFT;
					break;
				}
				default:
				break;
			}
			break;
		}
	}
	switch (depth) {
		case 1:
		{
			const gchar* _tmp13_;
			Node* _tmp14_;
			_tmp13_ = text;
			_tmp14_ = draw_area_create_root_node (da, _tmp13_);
			_g_object_unref0 (*last_node);
			*last_node = _tmp14_;
			break;
		}
		case 2:
		{
			if ((*last_node) != NULL) {
				Node* _tmp15_;
				Node* _tmp16_;
				const gchar* _tmp17_;
				Node* _tmp18_;
				_tmp15_ = node_get_root (*last_node);
				_tmp16_ = _tmp15_;
				_tmp17_ = text;
				_tmp18_ = draw_area_create_main_node (da, _tmp16_, side, _tmp17_);
				_g_object_unref0 (*last_node);
				*last_node = _tmp18_;
				_g_object_unref0 (_tmp16_);
			}
			break;
		}
		default:
		{
			if ((*last_node) != NULL) {
				guint last_depth = 0U;
				last_depth = node_get_level (*last_node) + 1;
				if ((last_depth + 1) == ((guint) depth)) {
					const gchar* _tmp19_;
					Node* _tmp20_;
					_tmp19_ = text;
					_tmp20_ = draw_area_create_child_node (da, *last_node, _tmp19_);
					_g_object_unref0 (*last_node);
					*last_node = _tmp20_;
				} else {
					if (last_depth == ((guint) depth)) {
						const gchar* _tmp21_;
						Node* _tmp22_;
						_tmp21_ = text;
						_tmp22_ = draw_area_create_sibling_node (da, *last_node, TRUE, _tmp21_);
						_g_object_unref0 (*last_node);
						*last_node = _tmp22_;
					} else {
						if (last_depth > ((guint) depth)) {
							const gchar* _tmp28_;
							Node* _tmp29_;
							{
								gint i = 0;
								i = 0;
								{
									gboolean _tmp23_ = FALSE;
									_tmp23_ = TRUE;
									while (TRUE) {
										Node* _tmp25_;
										Node* _tmp26_;
										Node* _tmp27_;
										if (!_tmp23_) {
											gint _tmp24_;
											_tmp24_ = i;
											i = _tmp24_ + 1;
										}
										_tmp23_ = FALSE;
										if (!(((guint) i) < (last_depth - depth))) {
											break;
										}
										_tmp25_ = node_get_parent (*last_node);
										_tmp26_ = _tmp25_;
										_tmp27_ = _g_object_ref0 (_tmp26_);
										_g_object_unref0 (*last_node);
										*last_node = _tmp27_;
									}
								}
							}
							_tmp28_ = text;
							_tmp29_ = draw_area_create_sibling_node (da, *last_node, TRUE, _tmp28_);
							_g_object_unref0 (*last_node);
							*last_node = _tmp29_;
						}
					}
				}
			}
			break;
		}
	}
	_tmp30_ = color;
	if (g_strcmp0 (_tmp30_, "_") == 0) {
		Style* _tmp31_;
		Style* _tmp32_;
		Styles* _tmp33_;
		NodeBorder* _tmp34_;
		NodeBorder* _tmp35_;
		_tmp31_ = node_get_style (*last_node);
		_tmp32_ = _tmp31_;
		_tmp33_ = style_inspector_styles;
		_tmp34_ = styles_get_node_border (_tmp33_, "none");
		_tmp35_ = _tmp34_;
		style_set_node_border (_tmp32_, _tmp35_);
		_g_object_unref0 (_tmp35_);
	} else {
		Style* _tmp36_;
		Style* _tmp37_;
		Styles* _tmp38_;
		NodeBorder* _tmp39_;
		NodeBorder* _tmp40_;
		const gchar* _tmp41_;
		_tmp36_ = node_get_style (*last_node);
		_tmp37_ = _tmp36_;
		_tmp38_ = style_inspector_styles;
		_tmp39_ = styles_get_node_border (_tmp38_, "squared");
		_tmp40_ = _tmp39_;
		style_set_node_border (_tmp37_, _tmp40_);
		_g_object_unref0 (_tmp40_);
		_tmp41_ = color;
		if (string_get_char (_tmp41_, (glong) 0) == ((gunichar) '[')) {
			GdkRGBA c = {0};
			GdkRGBA _tmp42_ = {0};
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			GdkRGBA _tmp48_;
			_tmp42_.red = 1.0;
			_tmp42_.green = 1.0;
			_tmp42_.blue = 1.0;
			_tmp42_.alpha = 1.0;
			c = _tmp42_;
			_tmp43_ = color;
			_tmp44_ = color;
			_tmp45_ = color;
			_tmp46_ = string_slice (_tmp43_, (glong) string_index_of_nth_char (_tmp44_, (glong) 1), (glong) string_index_of_nth_char (_tmp45_, (glong) 8));
			_tmp47_ = _tmp46_;
			gdk_rgba_parse (&c, _tmp47_);
			_g_free0 (_tmp47_);
			_tmp48_ = c;
			node_set_link_color (*last_node, &_tmp48_);
		}
	}
	_g_free0 (text);
	_g_free0 (color);
	_g_free0 (li);
}

static void
export_plant_uml_class_init (ExportPlantUMLClass * klass,
                             gpointer klass_data)
{
	export_plant_uml_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_plant_uml_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_plant_uml_real_import;
}

static void
export_plant_uml_instance_init (ExportPlantUML * self,
                                gpointer klass)
{
}

static GType
export_plant_uml_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportPlantUMLClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_plant_uml_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportPlantUML), 0, (GInstanceInitFunc) export_plant_uml_instance_init, NULL };
	GType export_plant_uml_type_id;
	export_plant_uml_type_id = g_type_register_static (TYPE_EXPORT, "ExportPlantUML", &g_define_type_info, 0);
	return export_plant_uml_type_id;
}

GType
export_plant_uml_get_type (void)
{
	static volatile gsize export_plant_uml_type_id__once = 0;
	if (g_once_init_enter (&export_plant_uml_type_id__once)) {
		GType export_plant_uml_type_id;
		export_plant_uml_type_id = export_plant_uml_get_type_once ();
		g_once_init_leave (&export_plant_uml_type_id__once, export_plant_uml_type_id);
	}
	return export_plant_uml_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

