/* ExportPDF.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportPDF.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo-pdf.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_PDF (export_pdf_get_type ())
#define EXPORT_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_PDF, ExportPDF))
#define EXPORT_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_PDF, ExportPDFClass))
#define IS_EXPORT_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_PDF))
#define IS_EXPORT_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_PDF))
#define EXPORT_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_PDF, ExportPDFClass))

typedef struct _ExportPDF ExportPDF;
typedef struct _ExportPDFClass ExportPDFClass;
typedef struct _ExportPDFPrivate ExportPDFPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportPDF {
	Export parent_instance;
	ExportPDFPrivate * priv;
};

struct _ExportPDFClass {
	ExportClass parent_class;
};

static gpointer export_pdf_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportPDF, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportPDF* export_pdf_new (void);
VALA_EXTERN ExportPDF* export_pdf_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_pdf_real_export (Export* base,
                                 const gchar* fname,
                                 DrawArea* da);
VALA_EXTERN void draw_area_document_rectangle (DrawArea* self,
                                   gdouble* x,
                                   gdouble* y,
                                   gdouble* width,
                                   gdouble* height);
VALA_EXTERN void draw_area_draw_all (DrawArea* self,
                         cairo_t* ctx,
                         gboolean exporting);
static GType export_pdf_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportPDF*
export_pdf_construct (GType object_type)
{
	ExportPDF* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".pdf");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportPDF*) export_construct (object_type, "pdf", _ ("PDF"), _tmp2_, (gint) 1, TRUE, FALSE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportPDF*
export_pdf_new (void)
{
	return export_pdf_construct (TYPE_EXPORT_PDF);
}

static gboolean
export_pdf_real_export (Export* base,
                        const gchar* fname,
                        DrawArea* da)
{
	ExportPDF * self;
	gdouble page_width = 0.0;
	gdouble page_height = 0.0;
	gdouble margin = 0.0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble sf = 0.0;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	GtkStyleContext* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	gboolean result;
	self = (ExportPDF*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	page_width = 8.5 * 72;
	page_height = (gdouble) (11 * 72);
	margin = 0.5 * 72;
	_tmp0_ = cairo_pdf_surface_create (fname, page_width, page_height);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	context = _tmp2_;
	draw_area_document_rectangle (da, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	x = _tmp3_;
	y = _tmp4_;
	w = _tmp5_;
	h = _tmp6_;
	width = (page_width - (2 * margin)) / w;
	height = (page_height - (2 * margin)) / h;
	if (width < height) {
		_tmp7_ = width;
	} else {
		_tmp7_ = height;
	}
	sf = _tmp7_;
	_tmp8_ = context;
	cairo_scale (_tmp8_, sf, sf);
	_tmp9_ = context;
	cairo_translate (_tmp9_, (0 - x) + (margin / sf), (0 - y) + (margin / sf));
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) da);
	_tmp11_ = context;
	gtk_render_background (_tmp10_, _tmp11_, x, y, w, h);
	_tmp12_ = context;
	draw_area_draw_all (da, _tmp12_, TRUE);
	_tmp13_ = context;
	cairo_show_page (_tmp13_);
	result = TRUE;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	return result;
}

static void
export_pdf_class_init (ExportPDFClass * klass,
                       gpointer klass_data)
{
	export_pdf_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_pdf_real_export;
}

static void
export_pdf_instance_init (ExportPDF * self,
                          gpointer klass)
{
}

static GType
export_pdf_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportPDFClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_pdf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportPDF), 0, (GInstanceInitFunc) export_pdf_instance_init, NULL };
	GType export_pdf_type_id;
	export_pdf_type_id = g_type_register_static (TYPE_EXPORT, "ExportPDF", &g_define_type_info, 0);
	return export_pdf_type_id;
}

GType
export_pdf_get_type (void)
{
	static volatile gsize export_pdf_type_id__once = 0;
	if (g_once_init_enter (&export_pdf_type_id__once)) {
		GType export_pdf_type_id;
		export_pdf_type_id = export_pdf_get_type_once ();
		g_once_init_leave (&export_pdf_type_id__once, export_pdf_type_id);
	}
	return export_pdf_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

