/* UrlEditor.c generated by valac 0.56.18, the Vala compiler
 * generated from UrlEditor.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_URL_EDITOR (url_editor_get_type ())
#define URL_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_EDITOR, UrlEditor))
#define URL_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_URL_EDITOR, UrlEditorClass))
#define IS_URL_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_EDITOR))
#define IS_URL_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_URL_EDITOR))
#define URL_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_URL_EDITOR, UrlEditorClass))

typedef struct _UrlEditor UrlEditor;
typedef struct _UrlEditorClass UrlEditorClass;
typedef struct _UrlEditorPrivate UrlEditorPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
enum  {
	URL_EDITOR_0_PROPERTY,
	URL_EDITOR_NUM_PROPERTIES
};
static GParamSpec* url_editor_properties[URL_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
typedef enum  {
	NODE_MODE_NONE = 0,
	NODE_MODE_CURRENT,
	NODE_MODE_SELECTED,
	NODE_MODE_EDITABLE,
	NODE_MODE_ATTACHABLE,
	NODE_MODE_DROPPABLE,
	NODE_MODE_HIGHLIGHTED
} NodeMode;

#define TYPE_NODE_MODE (node_mode_get_type ())
typedef enum  {
	CALLOUT_MODE_NONE = 0,
	CALLOUT_MODE_SELECTED,
	CALLOUT_MODE_EDITABLE,
	CALLOUT_MODE_HIDING,
	CALLOUT_MODE_HIDDEN
} CalloutMode;

#define TYPE_CALLOUT_MODE (callout_mode_get_type ())
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _UrlEditor {
	GtkPopover parent_instance;
	UrlEditorPrivate * priv;
};

struct _UrlEditorClass {
	GtkPopoverClass parent_class;
};

struct _UrlEditorPrivate {
	DrawArea* _da;
	gboolean _add;
	GtkEntry* _entry;
	GtkButton* _apply;
};

static gint UrlEditor_private_offset;
static gpointer url_editor_parent_class = NULL;

VALA_EXTERN GType url_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UrlEditor, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN UrlEditor* url_editor_new (DrawArea* da);
VALA_EXTERN UrlEditor* url_editor_construct (GType object_type,
                                 DrawArea* da);
static void __lambda143_ (UrlEditor* self);
static void ___lambda143__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static void url_editor_check_entry (UrlEditor* self);
static void _url_editor_check_entry_gtk_editable_changed (GtkEditable* _sender,
                                                   gpointer self);
static void __lambda144_ (UrlEditor* self);
static void url_editor_set_url (UrlEditor* self);
VALA_EXTERN void utils_hide_popover (GtkPopover* popover);
static void ___lambda144__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda145_ (UrlEditor* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
static CanvasText* url_editor_current_text (UrlEditor* self);
VALA_EXTERN void canvas_text_clear_selection (CanvasText* self,
                                  const gchar* msg);
static void ___lambda145__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN Callout* draw_area_get_current_callout (DrawArea* self);
VALA_EXTERN CanvasText* callout_get_text (Callout* self);
VALA_EXTERN gboolean utils_is_url (const gchar* str);
VALA_EXTERN GType node_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeMode node_get_mode (Node* self);
VALA_EXTERN void draw_area_set_node_mode (DrawArea* self,
                              Node* node,
                              NodeMode mode,
                              gboolean undoable);
VALA_EXTERN GType callout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CalloutMode callout_get_mode (Callout* self);
VALA_EXTERN void draw_area_set_callout_mode (DrawArea* self,
                                 Callout* callout,
                                 CalloutMode mode,
                                 gboolean undoable);
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN void canvas_text_remove_tag (CanvasText* self,
                             FormatTag tag,
                             UndoTextBuffer* undo_buffer);
VALA_EXTERN UndoTextBuffer* draw_area_get_undo_text (DrawArea* self);
VALA_EXTERN void canvas_text_add_tag (CanvasText* self,
                          FormatTag tag,
                          const gchar* extra,
                          gboolean parsed,
                          UndoTextBuffer* undo_buffer);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
VALA_EXTERN void url_editor_add_url (UrlEditor* self);
VALA_EXTERN void canvas_text_get_cursor_info (CanvasText* self,
                                  gint* cursor,
                                  gint* start,
                                  gint* end);
VALA_EXTERN void canvas_text_get_char_pos (CanvasText* self,
                               gint pos,
                               gdouble* left,
                               gdouble* top,
                               gdouble* bottom,
                               gint* line);
static gchar* url_editor_get_url_from_clipboard (UrlEditor* self);
VALA_EXTERN void utils_show_popover (GtkPopover* popover);
VALA_EXTERN void url_editor_remove_url (UrlEditor* self);
VALA_EXTERN void url_editor_edit_url (UrlEditor* self);
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN GArray* formatted_text_get_full_tags_in_range (FormattedText* self,
                                               FormatTag tag,
                                               gint start,
                                               gint end);
VALA_EXTERN gint undo_tag_info_get_start (UndoTagInfo* self);
VALA_EXTERN const gchar* undo_tag_info_get_extra (UndoTagInfo* self);
static void url_editor_finalize (GObject * obj);
static GType url_editor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
url_editor_get_instance_private (UrlEditor* self)
{
	return G_STRUCT_MEMBER_P (self, UrlEditor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda143_ (UrlEditor* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->_apply;
	g_signal_emit_by_name (_tmp0_, "activate");
}

static void
___lambda143__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	__lambda143_ ((UrlEditor*) self);
}

static void
_url_editor_check_entry_gtk_editable_changed (GtkEditable* _sender,
                                              gpointer self)
{
	url_editor_check_entry ((UrlEditor*) self);
}

static void
__lambda144_ (UrlEditor* self)
{
	url_editor_set_url (self);
	utils_hide_popover ((GtkPopover*) self);
}

static void
___lambda144__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda144_ ((UrlEditor*) self);
}

static void
__lambda145_ (UrlEditor* self)
{
	CanvasText* ct = NULL;
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	_tmp0_ = url_editor_current_text (self);
	ct = _tmp0_;
	_tmp1_ = ct;
	if (_tmp1_ != NULL) {
		CanvasText* _tmp2_;
		_tmp2_ = ct;
		canvas_text_clear_selection (_tmp2_, NULL);
	}
	utils_hide_popover ((GtkPopover*) self);
	_g_object_unref0 (ct);
}

static void
___lambda145__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda145_ ((UrlEditor*) self);
}

UrlEditor*
url_editor_construct (GType object_type,
                      DrawArea* da)
{
	UrlEditor * self = NULL;
	DrawArea* _tmp0_;
	GtkBox* box = NULL;
	GtkBox* _tmp1_;
	GtkBox* ebox = NULL;
	GtkBox* _tmp2_;
	GtkLabel* lbl = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* cancel = NULL;
	GtkButton* _tmp17_;
	GtkBox* bbox = NULL;
	GtkBox* _tmp18_;
	GtkButton* _tmp19_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (UrlEditor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	gtk_popover_set_relative_to ((GtkPopover*) self, (GtkWidget*) da);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp1_);
	box = _tmp1_;
	gtk_container_set_border_width ((GtkContainer*) box, (guint) 5);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp2_);
	ebox = _tmp2_;
	_tmp3_ = g_strconcat (_ ("URL"), ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	lbl = _tmp6_;
	_tmp7_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp7_;
	_tmp8_ = self->priv->_entry;
	gtk_entry_set_width_chars (_tmp8_, 50);
	_tmp9_ = self->priv->_entry;
	gtk_entry_set_input_purpose (_tmp9_, GTK_INPUT_PURPOSE_URL);
	_tmp10_ = self->priv->_entry;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) ___lambda143__gtk_entry_activate, self, 0);
	_tmp11_ = self->priv->_entry;
	g_signal_connect_object ((GtkEditable*) _tmp11_, "changed", (GCallback) _url_editor_check_entry_gtk_editable_changed, self, 0);
	gtk_box_pack_start (ebox, (GtkWidget*) lbl, FALSE, FALSE, (guint) 0);
	_tmp12_ = self->priv->_entry;
	gtk_box_pack_start (ebox, (GtkWidget*) _tmp12_, TRUE, FALSE, (guint) 0);
	_tmp13_ = (GtkButton*) gtk_button_new_with_label (_ ("Apply"));
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->_apply);
	self->priv->_apply = _tmp13_;
	_tmp14_ = self->priv->_apply;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp16_ = self->priv->_apply;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) ___lambda144__gtk_button_clicked, self, 0);
	_tmp17_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp17_);
	cancel = _tmp17_;
	g_signal_connect_object (cancel, "clicked", (GCallback) ___lambda145__gtk_button_clicked, self, 0);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp18_);
	bbox = _tmp18_;
	_tmp19_ = self->priv->_apply;
	gtk_box_pack_end (bbox, (GtkWidget*) _tmp19_, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end (bbox, (GtkWidget*) cancel, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) ebox, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) bbox, FALSE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) box);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (bbox);
	_g_object_unref0 (cancel);
	_g_object_unref0 (lbl);
	_g_object_unref0 (ebox);
	_g_object_unref0 (box);
	return self;
}

UrlEditor*
url_editor_new (DrawArea* da)
{
	return url_editor_construct (TYPE_URL_EDITOR, da);
}

static CanvasText*
url_editor_current_text (UrlEditor* self)
{
	CanvasText* ct = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean _tmp3_;
	CanvasText* result;
	g_return_val_if_fail (self != NULL, NULL);
	ct = NULL;
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		DrawArea* _tmp4_;
		Node* _tmp5_;
		Node* _tmp6_;
		CanvasText* _tmp7_;
		CanvasText* _tmp8_;
		CanvasText* _tmp9_;
		_tmp4_ = self->priv->_da;
		_tmp5_ = draw_area_get_current_node (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = node_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (ct);
		ct = _tmp9_;
		_g_object_unref0 (_tmp6_);
	} else {
		DrawArea* _tmp10_;
		Callout* _tmp11_;
		Callout* _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = self->priv->_da;
		_tmp11_ = draw_area_get_current_callout (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_g_object_unref0 (_tmp12_);
		if (_tmp13_) {
			DrawArea* _tmp14_;
			Callout* _tmp15_;
			Callout* _tmp16_;
			CanvasText* _tmp17_;
			CanvasText* _tmp18_;
			CanvasText* _tmp19_;
			_tmp14_ = self->priv->_da;
			_tmp15_ = draw_area_get_current_callout (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = callout_get_text (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (ct);
			ct = _tmp19_;
			_g_object_unref0 (_tmp16_);
		}
	}
	result = ct;
	return result;
}

static void
url_editor_check_entry (UrlEditor* self)
{
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_apply;
	_tmp1_ = self->priv->_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, utils_is_url (_tmp3_));
}

static void
url_editor_set_url (UrlEditor* self)
{
	Node* node = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Callout* callout = NULL;
	DrawArea* _tmp2_;
	Callout* _tmp3_;
	CanvasText* ct = NULL;
	CanvasText* _tmp4_;
	gboolean selected = FALSE;
	Node* _tmp5_;
	CanvasText* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	node = _tmp1_;
	_tmp2_ = self->priv->_da;
	_tmp3_ = draw_area_get_current_callout (_tmp2_);
	callout = _tmp3_;
	_tmp4_ = url_editor_current_text (self);
	ct = _tmp4_;
	selected = FALSE;
	_tmp5_ = node;
	if (_tmp5_ != NULL) {
		Node* _tmp6_;
		NodeMode _tmp7_;
		NodeMode _tmp8_;
		_tmp6_ = node;
		_tmp7_ = node_get_mode (_tmp6_);
		_tmp8_ = _tmp7_;
		selected = _tmp8_ == NODE_MODE_CURRENT;
		if (selected) {
			DrawArea* _tmp9_;
			Node* _tmp10_;
			_tmp9_ = self->priv->_da;
			_tmp10_ = node;
			draw_area_set_node_mode (_tmp9_, _tmp10_, NODE_MODE_EDITABLE, TRUE);
		}
	} else {
		Callout* _tmp11_;
		_tmp11_ = callout;
		if (_tmp11_ != NULL) {
			Callout* _tmp12_;
			CalloutMode _tmp13_;
			CalloutMode _tmp14_;
			_tmp12_ = callout;
			_tmp13_ = callout_get_mode (_tmp12_);
			_tmp14_ = _tmp13_;
			selected = _tmp14_ == CALLOUT_MODE_SELECTED;
			if (selected) {
				DrawArea* _tmp15_;
				Callout* _tmp16_;
				_tmp15_ = self->priv->_da;
				_tmp16_ = callout;
				draw_area_set_callout_mode (_tmp15_, _tmp16_, CALLOUT_MODE_EDITABLE, TRUE);
			}
		}
	}
	_tmp17_ = ct;
	if (_tmp17_ != NULL) {
		CanvasText* _tmp22_;
		GtkEntry* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		DrawArea* _tmp26_;
		UndoTextBuffer* _tmp27_;
		UndoTextBuffer* _tmp28_;
		CanvasText* _tmp29_;
		DrawArea* _tmp36_;
		DrawArea* _tmp37_;
		if (!self->priv->_add) {
			CanvasText* _tmp18_;
			DrawArea* _tmp19_;
			UndoTextBuffer* _tmp20_;
			UndoTextBuffer* _tmp21_;
			_tmp18_ = ct;
			_tmp19_ = self->priv->_da;
			_tmp20_ = draw_area_get_undo_text (_tmp19_);
			_tmp21_ = _tmp20_;
			canvas_text_remove_tag (_tmp18_, FORMAT_TAG_URL, _tmp21_);
		}
		_tmp22_ = ct;
		_tmp23_ = self->priv->_entry;
		_tmp24_ = gtk_entry_get_text (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_da;
		_tmp27_ = draw_area_get_undo_text (_tmp26_);
		_tmp28_ = _tmp27_;
		canvas_text_add_tag (_tmp22_, FORMAT_TAG_URL, _tmp25_, FALSE, _tmp28_);
		_tmp29_ = ct;
		canvas_text_clear_selection (_tmp29_, NULL);
		if (selected) {
			Node* _tmp30_;
			_tmp30_ = node;
			if (_tmp30_ != NULL) {
				DrawArea* _tmp31_;
				Node* _tmp32_;
				_tmp31_ = self->priv->_da;
				_tmp32_ = node;
				draw_area_set_node_mode (_tmp31_, _tmp32_, NODE_MODE_CURRENT, TRUE);
			} else {
				Callout* _tmp33_;
				_tmp33_ = callout;
				if (_tmp33_ != NULL) {
					DrawArea* _tmp34_;
					Callout* _tmp35_;
					_tmp34_ = self->priv->_da;
					_tmp35_ = callout;
					draw_area_set_callout_mode (_tmp34_, _tmp35_, CALLOUT_MODE_SELECTED, TRUE);
				}
			}
		}
		_tmp36_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp36_);
		_tmp37_ = self->priv->_da;
		draw_area_auto_save (_tmp37_);
	}
	_g_object_unref0 (ct);
	_g_object_unref0 (callout);
	_g_object_unref0 (node);
}

void
url_editor_add_url (UrlEditor* self)
{
	CanvasText* ct = NULL;
	CanvasText* _tmp0_;
	gint selstart = 0;
	gint selend = 0;
	gint cursor = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble bottom = 0.0;
	gint line = 0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gint _tmp7_ = 0;
	gint int_left = 0;
	gint int_top = 0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp8_ = {0};
	GdkRectangle _tmp9_;
	GtkEntry* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = url_editor_current_text (self);
	ct = _tmp0_;
	canvas_text_get_cursor_info (ct, &_tmp1_, &_tmp2_, &_tmp3_);
	cursor = _tmp1_;
	selstart = _tmp2_;
	selend = _tmp3_;
	canvas_text_get_char_pos (ct, selstart, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	left = _tmp4_;
	top = _tmp5_;
	bottom = _tmp6_;
	line = _tmp7_;
	int_left = (gint) left;
	int_top = (gint) top;
	_tmp8_.x = int_left;
	_tmp8_.y = int_top;
	_tmp8_.width = 1;
	_tmp8_.height = 1;
	rect = _tmp8_;
	_tmp9_ = rect;
	g_object_set ((GtkPopover*) self, "pointing-to", &_tmp9_, NULL);
	self->priv->_add = TRUE;
	_tmp10_ = self->priv->_entry;
	_tmp11_ = url_editor_get_url_from_clipboard (self);
	_tmp12_ = _tmp11_;
	gtk_entry_set_text (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	url_editor_check_entry (self);
	utils_show_popover ((GtkPopover*) self);
	_g_object_unref0 (ct);
}

void
url_editor_remove_url (UrlEditor* self)
{
	CanvasText* ct = NULL;
	CanvasText* _tmp0_;
	Node* node = NULL;
	DrawArea* _tmp1_;
	Node* _tmp2_;
	Callout* callout = NULL;
	DrawArea* _tmp3_;
	Callout* _tmp4_;
	gboolean selected = FALSE;
	Node* _tmp5_;
	CanvasText* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = url_editor_current_text (self);
	ct = _tmp0_;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_current_node (_tmp1_);
	node = _tmp2_;
	_tmp3_ = self->priv->_da;
	_tmp4_ = draw_area_get_current_callout (_tmp3_);
	callout = _tmp4_;
	selected = FALSE;
	_tmp5_ = node;
	if (_tmp5_ != NULL) {
		Node* _tmp6_;
		NodeMode _tmp7_;
		NodeMode _tmp8_;
		_tmp6_ = node;
		_tmp7_ = node_get_mode (_tmp6_);
		_tmp8_ = _tmp7_;
		selected = _tmp8_ == NODE_MODE_CURRENT;
		if (selected) {
			DrawArea* _tmp9_;
			Node* _tmp10_;
			_tmp9_ = self->priv->_da;
			_tmp10_ = node;
			draw_area_set_node_mode (_tmp9_, _tmp10_, NODE_MODE_EDITABLE, TRUE);
		}
	} else {
		Callout* _tmp11_;
		_tmp11_ = callout;
		if (_tmp11_ != NULL) {
			Callout* _tmp12_;
			CalloutMode _tmp13_;
			CalloutMode _tmp14_;
			_tmp12_ = callout;
			_tmp13_ = callout_get_mode (_tmp12_);
			_tmp14_ = _tmp13_;
			selected = _tmp14_ == CALLOUT_MODE_SELECTED;
			if (selected) {
				DrawArea* _tmp15_;
				Callout* _tmp16_;
				_tmp15_ = self->priv->_da;
				_tmp16_ = callout;
				draw_area_set_callout_mode (_tmp15_, _tmp16_, CALLOUT_MODE_EDITABLE, TRUE);
			}
		}
	}
	_tmp17_ = ct;
	if (_tmp17_ != NULL) {
		CanvasText* _tmp18_;
		DrawArea* _tmp19_;
		UndoTextBuffer* _tmp20_;
		UndoTextBuffer* _tmp21_;
		CanvasText* _tmp22_;
		DrawArea* _tmp29_;
		DrawArea* _tmp30_;
		_tmp18_ = ct;
		_tmp19_ = self->priv->_da;
		_tmp20_ = draw_area_get_undo_text (_tmp19_);
		_tmp21_ = _tmp20_;
		canvas_text_remove_tag (_tmp18_, FORMAT_TAG_URL, _tmp21_);
		_tmp22_ = ct;
		canvas_text_clear_selection (_tmp22_, NULL);
		if (selected) {
			Node* _tmp23_;
			_tmp23_ = node;
			if (_tmp23_ != NULL) {
				DrawArea* _tmp24_;
				Node* _tmp25_;
				_tmp24_ = self->priv->_da;
				_tmp25_ = node;
				draw_area_set_node_mode (_tmp24_, _tmp25_, NODE_MODE_CURRENT, TRUE);
			} else {
				Callout* _tmp26_;
				_tmp26_ = callout;
				if (_tmp26_ != NULL) {
					DrawArea* _tmp27_;
					Callout* _tmp28_;
					_tmp27_ = self->priv->_da;
					_tmp28_ = callout;
					draw_area_set_callout_mode (_tmp27_, _tmp28_, CALLOUT_MODE_SELECTED, TRUE);
				}
			}
		}
		_tmp29_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp29_);
		_tmp30_ = self->priv->_da;
		draw_area_auto_save (_tmp30_);
	}
	_g_object_unref0 (callout);
	_g_object_unref0 (node);
	_g_object_unref0 (ct);
}

static gchar*
url_editor_get_url_from_clipboard (UrlEditor* self)
{
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	gchar* text = NULL;
	GtkClipboard* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gtk_clipboard_get_default (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = clipboard;
	_tmp4_ = gtk_clipboard_wait_for_text (_tmp3_);
	text = _tmp4_;
	_tmp7_ = text;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = text;
		_tmp6_ = utils_is_url (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		_tmp9_ = text;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = "";
	}
	_tmp10_ = g_strdup (_tmp5_);
	result = _tmp10_;
	_g_free0 (text);
	_g_object_unref0 (clipboard);
	return result;
}

void
url_editor_edit_url (UrlEditor* self)
{
	CanvasText* ct = NULL;
	CanvasText* _tmp0_;
	gint selstart = 0;
	gint selend = 0;
	gint cursor = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble bottom = 0.0;
	gint line = 0;
	GArray* links = NULL;
	FormattedText* _tmp4_;
	FormattedText* _tmp5_;
	GArray* _tmp6_;
	UndoTagInfo* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gint _tmp13_ = 0;
	gint int_left = 0;
	gint int_top = 0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp14_ = {0};
	GdkRectangle _tmp15_;
	GtkEntry* _tmp16_;
	UndoTagInfo* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkButton* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = url_editor_current_text (self);
	ct = _tmp0_;
	canvas_text_get_cursor_info (ct, &_tmp1_, &_tmp2_, &_tmp3_);
	cursor = _tmp1_;
	selstart = _tmp2_;
	selend = _tmp3_;
	_tmp4_ = canvas_text_get_text (ct);
	_tmp5_ = _tmp4_;
	_tmp6_ = formatted_text_get_full_tags_in_range (_tmp5_, FORMAT_TAG_URL, cursor, cursor);
	links = _tmp6_;
	_tmp7_ = g_array_index (links, UndoTagInfo*, (guint) 0);
	_tmp8_ = undo_tag_info_get_start (_tmp7_);
	_tmp9_ = _tmp8_;
	canvas_text_get_char_pos (ct, _tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	left = _tmp10_;
	top = _tmp11_;
	bottom = _tmp12_;
	line = _tmp13_;
	int_left = (gint) left;
	int_top = (gint) top;
	_tmp14_.x = int_left;
	_tmp14_.y = int_top;
	_tmp14_.width = 1;
	_tmp14_.height = 1;
	rect = _tmp14_;
	_tmp15_ = rect;
	g_object_set ((GtkPopover*) self, "pointing-to", &_tmp15_, NULL);
	self->priv->_add = FALSE;
	_tmp16_ = self->priv->_entry;
	_tmp17_ = g_array_index (links, UndoTagInfo*, (guint) 0);
	_tmp18_ = undo_tag_info_get_extra (_tmp17_);
	_tmp19_ = _tmp18_;
	gtk_entry_set_text (_tmp16_, _tmp19_);
	_tmp20_ = self->priv->_apply;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
	utils_show_popover ((GtkPopover*) self);
	_g_array_unref0 (links);
	_g_object_unref0 (ct);
}

static void
url_editor_class_init (UrlEditorClass * klass,
                       gpointer klass_data)
{
	url_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UrlEditor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = url_editor_finalize;
}

static void
url_editor_instance_init (UrlEditor * self,
                          gpointer klass)
{
	self->priv = url_editor_get_instance_private (self);
	self->priv->_add = TRUE;
}

static void
url_editor_finalize (GObject * obj)
{
	UrlEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_URL_EDITOR, UrlEditor);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_apply);
	G_OBJECT_CLASS (url_editor_parent_class)->finalize (obj);
}

static GType
url_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UrlEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) url_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UrlEditor), 0, (GInstanceInitFunc) url_editor_instance_init, NULL };
	GType url_editor_type_id;
	url_editor_type_id = g_type_register_static (gtk_popover_get_type (), "UrlEditor", &g_define_type_info, 0);
	UrlEditor_private_offset = g_type_add_instance_private (url_editor_type_id, sizeof (UrlEditorPrivate));
	return url_editor_type_id;
}

GType
url_editor_get_type (void)
{
	static volatile gsize url_editor_type_id__once = 0;
	if (g_once_init_enter (&url_editor_type_id__once)) {
		GType url_editor_type_id;
		url_editor_type_id = url_editor_get_type_once ();
		g_once_init_leave (&url_editor_type_id__once, url_editor_type_id);
	}
	return url_editor_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

