/* Themes.c generated by valac 0.56.18, the Vala compiler
 * generated from Themes.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib/gstdio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEMES (themes_get_type ())
#define THEMES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES, Themes))
#define THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES, ThemesClass))
#define IS_THEMES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES))
#define IS_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES))
#define THEMES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES, ThemesClass))

typedef struct _Themes Themes;
typedef struct _ThemesClass ThemesClass;
typedef struct _ThemesPrivate ThemesPrivate;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
enum  {
	THEMES_0_PROPERTY,
	THEMES_NUM_PROPERTIES
};
static GParamSpec* themes_properties[THEMES_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_THEME_DEFAULT (theme_default_get_type ())
#define THEME_DEFAULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_DEFAULT, ThemeDefault))
#define THEME_DEFAULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_DEFAULT, ThemeDefaultClass))
#define IS_THEME_DEFAULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_DEFAULT))
#define IS_THEME_DEFAULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_DEFAULT))
#define THEME_DEFAULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_DEFAULT, ThemeDefaultClass))

typedef struct _ThemeDefault ThemeDefault;
typedef struct _ThemeDefaultClass ThemeDefaultClass;

#define TYPE_THEME_DARK (theme_dark_get_type ())
#define THEME_DARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_DARK, ThemeDark))
#define THEME_DARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_DARK, ThemeDarkClass))
#define IS_THEME_DARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_DARK))
#define IS_THEME_DARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_DARK))
#define THEME_DARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_DARK, ThemeDarkClass))

typedef struct _ThemeDark ThemeDark;
typedef struct _ThemeDarkClass ThemeDarkClass;

#define TYPE_THEME_SOLARIZED_LIGHT (theme_solarized_light_get_type ())
#define THEME_SOLARIZED_LIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SOLARIZED_LIGHT, ThemeSolarizedLight))
#define THEME_SOLARIZED_LIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SOLARIZED_LIGHT, ThemeSolarizedLightClass))
#define IS_THEME_SOLARIZED_LIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SOLARIZED_LIGHT))
#define IS_THEME_SOLARIZED_LIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SOLARIZED_LIGHT))
#define THEME_SOLARIZED_LIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SOLARIZED_LIGHT, ThemeSolarizedLightClass))

typedef struct _ThemeSolarizedLight ThemeSolarizedLight;
typedef struct _ThemeSolarizedLightClass ThemeSolarizedLightClass;

#define TYPE_THEME_SOLARIZED_DARK (theme_solarized_dark_get_type ())
#define THEME_SOLARIZED_DARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SOLARIZED_DARK, ThemeSolarizedDark))
#define THEME_SOLARIZED_DARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SOLARIZED_DARK, ThemeSolarizedDarkClass))
#define IS_THEME_SOLARIZED_DARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SOLARIZED_DARK))
#define IS_THEME_SOLARIZED_DARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SOLARIZED_DARK))
#define THEME_SOLARIZED_DARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SOLARIZED_DARK, ThemeSolarizedDarkClass))

typedef struct _ThemeSolarizedDark ThemeSolarizedDark;
typedef struct _ThemeSolarizedDarkClass ThemeSolarizedDarkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	THEMES_THEMES_CHANGED_SIGNAL,
	THEMES_NUM_SIGNALS
};
static guint themes_signals[THEMES_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Themes {
	GObject parent_instance;
	ThemesPrivate * priv;
};

struct _ThemesClass {
	GObjectClass parent_class;
	void (*themes_changed) (Themes* self);
};

struct _ThemesPrivate {
	GArray* _themes;
};

static gint Themes_private_offset;
static gpointer themes_parent_class = NULL;

VALA_EXTERN GType themes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Themes, g_object_unref)
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Themes* themes_new (void);
VALA_EXTERN Themes* themes_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void _vala_Theme_free_function_content_of (gpointer data);
VALA_EXTERN GType theme_default_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeDefault, g_object_unref)
VALA_EXTERN ThemeDefault* theme_default_new (void);
VALA_EXTERN ThemeDefault* theme_default_construct (GType object_type);
VALA_EXTERN GType theme_dark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeDark, g_object_unref)
VALA_EXTERN ThemeDark* theme_dark_new (void);
VALA_EXTERN ThemeDark* theme_dark_construct (GType object_type);
VALA_EXTERN GType theme_solarized_light_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeSolarizedLight, g_object_unref)
VALA_EXTERN ThemeSolarizedLight* theme_solarized_light_new (void);
VALA_EXTERN ThemeSolarizedLight* theme_solarized_light_construct (GType object_type);
VALA_EXTERN GType theme_solarized_dark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeSolarizedDark, g_object_unref)
VALA_EXTERN ThemeSolarizedDark* theme_solarized_dark_new (void);
VALA_EXTERN ThemeSolarizedDark* theme_solarized_dark_construct (GType object_type);
static void themes_load_custom (Themes* self);
VALA_EXTERN void themes_names (Themes* self,
                   GArray** names);
VALA_EXTERN const gchar* theme_get_name (Theme* self);
VALA_EXTERN void themes_names_hash (Themes* self,
                        GeeHashMap** names);
VALA_EXTERN void themes_icons (Themes* self,
                   GArray** icons);
VALA_EXTERN cairo_surface_t* theme_make_icon (Theme* self);
VALA_EXTERN gboolean themes_exists (Themes* self,
                        Theme* theme);
VALA_EXTERN gboolean theme_matches (Theme* self,
                        Theme* theme);
VALA_EXTERN Theme* themes_get_theme (Themes* self,
                         const gchar* name);
VALA_EXTERN void themes_add_theme (Themes* self,
                       Theme* theme);
VALA_EXTERN void themes_delete_theme (Themes* self,
                          const gchar* name);
VALA_EXTERN Theme* theme_new_from_theme (Theme* theme);
VALA_EXTERN Theme* theme_construct_from_theme (GType object_type,
                                   Theme* theme);
VALA_EXTERN gboolean theme_load (Theme* self,
                     xmlNode* n);
VALA_EXTERN void themes_save_custom (Themes* self);
VALA_EXTERN gboolean theme_get_custom (Theme* self);
VALA_EXTERN gboolean theme_get_temporary (Theme* self);
VALA_EXTERN xmlNode* theme_save (Theme* self);
VALA_EXTERN gchar* themes_uniquify_name (Themes* self,
                             const gchar* name);
static void themes_real_themes_changed (Themes* self);
static void themes_finalize (GObject * obj);
static GType themes_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
themes_get_instance_private (Themes* self)
{
	return G_STRUCT_MEMBER_P (self, Themes_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_Theme_free_function_content_of (gpointer data)
{
	Theme* self;
	self = *((Theme**) data);
	_g_object_unref0_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Themes*
themes_construct (GType object_type)
{
	Themes * self = NULL;
	GArray* _tmp0_;
	ThemeDefault* default_theme = NULL;
	ThemeDefault* _tmp1_;
	ThemeDark* dark_theme = NULL;
	ThemeDark* _tmp2_;
	ThemeSolarizedLight* solarized_light_theme = NULL;
	ThemeSolarizedLight* _tmp3_;
	ThemeSolarizedDark* solarized_dark_theme = NULL;
	ThemeSolarizedDark* _tmp4_;
	GArray* _tmp5_;
	Theme* _tmp6_;
	GArray* _tmp7_;
	Theme* _tmp8_;
	GArray* _tmp9_;
	Theme* _tmp10_;
	GArray* _tmp11_;
	Theme* _tmp12_;
	self = (Themes*) g_object_new (object_type, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Theme*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Theme_free_function_content_of);
	_g_array_unref0 (self->priv->_themes);
	self->priv->_themes = _tmp0_;
	_tmp1_ = theme_default_new ();
	default_theme = _tmp1_;
	_tmp2_ = theme_dark_new ();
	dark_theme = _tmp2_;
	_tmp3_ = theme_solarized_light_new ();
	solarized_light_theme = _tmp3_;
	_tmp4_ = theme_solarized_dark_new ();
	solarized_dark_theme = _tmp4_;
	_tmp5_ = self->priv->_themes;
	_tmp6_ = _g_object_ref0 ((Theme*) default_theme);
	g_array_append_val (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_themes;
	_tmp8_ = _g_object_ref0 ((Theme*) dark_theme);
	g_array_append_val (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->_themes;
	_tmp10_ = _g_object_ref0 ((Theme*) solarized_light_theme);
	g_array_append_val (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->_themes;
	_tmp12_ = _g_object_ref0 ((Theme*) solarized_dark_theme);
	g_array_append_val (_tmp11_, _tmp12_);
	themes_load_custom (self);
	_g_object_unref0 (solarized_dark_theme);
	_g_object_unref0 (solarized_light_theme);
	_g_object_unref0 (dark_theme);
	_g_object_unref0 (default_theme);
	return self;
}

Themes*
themes_new (void)
{
	return themes_construct (TYPE_THEMES);
}

void
themes_names (Themes* self,
              GArray** names)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*names != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Theme* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_themes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_themes;
				_tmp4_ = g_array_index (_tmp3_, Theme*, (guint) i);
				_tmp5_ = theme_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				g_array_append_val (*names, _tmp7_);
			}
		}
	}
}

void
themes_names_hash (Themes* self,
                   GeeHashMap** names)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*names != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Theme* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_themes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_themes;
				_tmp4_ = g_array_index (_tmp3_, Theme*, (guint) i);
				_tmp5_ = theme_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				gee_abstract_map_set ((GeeAbstractMap*) (*names), _tmp6_, (gpointer) ((gintptr) 1));
			}
		}
	}
}

void
themes_icons (Themes* self,
              GArray** icons)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*icons != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Theme* _tmp4_;
				cairo_surface_t* _tmp5_;
				cairo_surface_t* _tmp6_;
				GtkImage* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_themes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_themes;
				_tmp4_ = g_array_index (_tmp3_, Theme*, (guint) i);
				_tmp5_ = theme_make_icon (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = (GtkImage*) gtk_image_new_from_surface (_tmp6_);
				g_object_ref_sink (_tmp7_);
				g_array_append_val (*icons, _tmp7_);
				_cairo_surface_destroy0 (_tmp6_);
			}
		}
	}
}

gboolean
themes_exists (Themes* self,
               Theme* theme)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (theme != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Theme* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_themes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_themes;
				_tmp4_ = g_array_index (_tmp3_, Theme*, (guint) i);
				if (theme_matches (_tmp4_, theme)) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

Theme*
themes_get_theme (Themes* self,
                  const gchar* name)
{
	GArray* _tmp10_;
	Theme* _tmp11_;
	Theme* _tmp12_;
	Theme* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Theme* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_themes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_themes;
				_tmp4_ = g_array_index (_tmp3_, Theme*, (guint) i);
				_tmp5_ = theme_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				if (g_strcmp0 (name, _tmp6_) == 0) {
					GArray* _tmp7_;
					Theme* _tmp8_;
					Theme* _tmp9_;
					_tmp7_ = self->priv->_themes;
					_tmp8_ = g_array_index (_tmp7_, Theme*, (guint) i);
					_tmp9_ = _g_object_ref0 (_tmp8_);
					result = _tmp9_;
					return result;
				}
			}
		}
	}
	_tmp10_ = self->priv->_themes;
	_tmp11_ = g_array_index (_tmp10_, Theme*, (guint) 0);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	return result;
}

void
themes_add_theme (Themes* self,
                  Theme* theme)
{
	GArray* _tmp0_;
	Theme* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = self->priv->_themes;
	_tmp1_ = _g_object_ref0 (theme);
	g_array_append_val (_tmp0_, _tmp1_);
	g_signal_emit (self, themes_signals[THEMES_THEMES_CHANGED_SIGNAL], 0);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

void
themes_delete_theme (Themes* self,
                     const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Theme* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_themes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_themes;
				_tmp4_ = g_array_index (_tmp3_, Theme*, (guint) i);
				_tmp5_ = theme_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				if (g_strcmp0 (_tmp6_, name) == 0) {
					GArray* _tmp7_;
					Theme* _tmp8_;
					Theme* _tmp9_;
					_tmp7_ = self->priv->_themes;
					_tmp8_ = vala_g_array_remove_index (_tmp7_, (guint) i);
					_tmp9_ = _tmp8_;
					_g_object_unref0 (_tmp9_);
					g_signal_emit (self, themes_signals[THEMES_THEMES_CHANGED_SIGNAL], 0);
					return;
				}
			}
		}
	}
}

static void
themes_load_custom (Themes* self)
{
	gchar* themes = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "minder", "custom_themes.xml", NULL);
	themes = _tmp1_;
	_tmp2_ = themes;
	if (g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
		xmlDoc* doc = NULL;
		const gchar* _tmp3_;
		xmlDoc* _tmp4_;
		xmlDoc* _tmp5_;
		xmlDoc* _tmp25_;
		_tmp3_ = themes;
		_tmp4_ = xmlParseFile (_tmp3_);
		doc = _tmp4_;
		_tmp5_ = doc;
		if (_tmp5_ == NULL) {
			_g_free0 (themes);
			return;
		}
		{
			xmlNode* it = NULL;
			xmlDoc* _tmp6_;
			xmlNode* _tmp7_;
			xmlNode* _tmp8_;
			_tmp6_ = doc;
			_tmp7_ = xmlDocGetRootElement (_tmp6_);
			_tmp8_ = _tmp7_->children;
			it = _tmp8_;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					xmlNode* _tmp12_;
					gboolean _tmp13_ = FALSE;
					xmlNode* _tmp14_;
					if (!_tmp9_) {
						xmlNode* _tmp10_;
						xmlNode* _tmp11_;
						_tmp10_ = it;
						_tmp11_ = _tmp10_->next;
						it = _tmp11_;
					}
					_tmp9_ = FALSE;
					_tmp12_ = it;
					if (!(_tmp12_ != NULL)) {
						break;
					}
					_tmp14_ = it;
					if (_tmp14_->type == XML_ELEMENT_NODE) {
						xmlNode* _tmp15_;
						const gchar* _tmp16_;
						_tmp15_ = it;
						_tmp16_ = _tmp15_->name;
						_tmp13_ = g_strcmp0 (_tmp16_, "theme") == 0;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						Theme* theme = NULL;
						GArray* _tmp17_;
						Theme* _tmp18_;
						Theme* _tmp19_;
						Theme* _tmp20_;
						xmlNode* _tmp21_;
						GArray* _tmp22_;
						Theme* _tmp23_;
						Theme* _tmp24_;
						_tmp17_ = self->priv->_themes;
						_tmp18_ = g_array_index (_tmp17_, Theme*, (guint) 0);
						_tmp19_ = theme_new_from_theme (_tmp18_);
						theme = _tmp19_;
						_tmp20_ = theme;
						_tmp21_ = it;
						theme_load (_tmp20_, _tmp21_);
						_tmp22_ = self->priv->_themes;
						_tmp23_ = theme;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						g_array_append_val (_tmp22_, _tmp24_);
						_g_object_unref0 (theme);
					}
				}
			}
		}
		_tmp25_ = doc;
		_xmlFreeDoc0 (_tmp25_);
	}
	_g_free0 (themes);
}

void
themes_save_custom (Themes* self)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* fname = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp5_;
	xmlNode* root = NULL;
	xmlNode* _tmp6_;
	xmlDoc* _tmp7_;
	xmlNode* _tmp8_;
	xmlDoc* _tmp25_;
	const gchar* _tmp26_;
	xmlDoc* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "minder", NULL);
	dir = _tmp1_;
	_tmp2_ = dir;
	if (g_mkdir_with_parents (_tmp2_, 0775) != 0) {
		_g_free0 (dir);
		return;
	}
	_tmp3_ = dir;
	_tmp4_ = g_build_filename (_tmp3_, "custom_themes.xml", NULL);
	fname = _tmp4_;
	_tmp5_ = xmlNewDoc ((xmlChar*) "1.0");
	doc = _tmp5_;
	_tmp6_ = xmlNewNode (NULL, (xmlChar*) "themes");
	root = _tmp6_;
	_tmp7_ = doc;
	_tmp8_ = root;
	xmlDocSetRootElement (_tmp7_, _tmp8_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GArray* _tmp11_;
				gboolean _tmp12_ = FALSE;
				GArray* _tmp13_;
				Theme* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				if (!_tmp9_) {
					guint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = self->priv->_themes;
				if (!(i < _tmp11_->len)) {
					break;
				}
				_tmp13_ = self->priv->_themes;
				_tmp14_ = g_array_index (_tmp13_, Theme*, i);
				_tmp15_ = theme_get_custom (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					GArray* _tmp17_;
					Theme* _tmp18_;
					gboolean _tmp19_;
					gboolean _tmp20_;
					_tmp17_ = self->priv->_themes;
					_tmp18_ = g_array_index (_tmp17_, Theme*, i);
					_tmp19_ = theme_get_temporary (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp12_ = !_tmp20_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					xmlNode* _tmp21_;
					GArray* _tmp22_;
					Theme* _tmp23_;
					xmlNode* _tmp24_;
					_tmp21_ = root;
					_tmp22_ = self->priv->_themes;
					_tmp23_ = g_array_index (_tmp22_, Theme*, i);
					_tmp24_ = theme_save (_tmp23_);
					xmlAddChild (_tmp21_, _tmp24_);
				}
			}
		}
	}
	_tmp25_ = doc;
	_tmp26_ = fname;
	xmlSaveFormatFile (_tmp26_, _tmp25_, 1);
	_tmp27_ = doc;
	_xmlFreeDoc0 (_tmp27_);
	_g_free0 (fname);
	_g_free0 (dir);
}

gchar*
themes_uniquify_name (Themes* self,
                      const gchar* name)
{
	GeeHashMap* names = NULL;
	GeeHashMap* _tmp0_;
	gchar* check = NULL;
	gchar* _tmp1_;
	gint index = 0;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	names = _tmp0_;
	_tmp1_ = g_strdup (name);
	check = _tmp1_;
	index = 2;
	themes_names_hash (self, &names);
	_tmp2_ = names;
	_tmp3_ = check;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_)) {
		GMatchInfo* match_info = NULL;
		gchar* n = NULL;
		gchar* _tmp4_;
		_tmp4_ = g_strdup (name);
		n = _tmp4_;
		{
			GRegex* re = NULL;
			GRegex* _tmp5_;
			GRegex* _tmp6_;
			GMatchInfo* _tmp7_ = NULL;
			gboolean _tmp8_;
			_tmp5_ = g_regex_new ("(.*)(\\d+)", 0, 0, &_inner_error0_);
			re = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_free0 (n);
				_g_match_info_unref0 (match_info);
				_g_free0 (check);
				_g_object_unref0 (names);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp6_ = re;
			_tmp8_ = g_regex_match (_tmp6_, name, 0, &_tmp7_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp7_;
			if (_tmp8_) {
				GMatchInfo* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GMatchInfo* _tmp12_;
				gchar* _tmp13_;
				_tmp9_ = match_info;
				_tmp10_ = g_match_info_fetch (_tmp9_, 2);
				_tmp11_ = _tmp10_;
				index = atoi (_tmp11_) + 1;
				_g_free0 (_tmp11_);
				_tmp12_ = match_info;
				_tmp13_ = g_match_info_fetch (_tmp12_, 1);
				_g_free0 (n);
				n = _tmp13_;
			} else {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = n;
				_tmp15_ = g_strconcat (_tmp14_, " #", NULL);
				_g_free0 (n);
				n = _tmp15_;
			}
			_g_regex_unref0 (re);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			FILE* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			g_clear_error (&_inner_error0_);
			_tmp16_ = stdout;
			_tmp17_ = g_strconcat (_ ("Error parsing regular expression"), "\n", NULL);
			_tmp18_ = _tmp17_;
			fprintf (_tmp16_, "%s", _tmp18_);
			_g_free0 (_tmp18_);
			_tmp19_ = g_strdup ("");
			result = _tmp19_;
			_g_free0 (n);
			_g_match_info_unref0 (match_info);
			_g_free0 (check);
			_g_object_unref0 (names);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (n);
			_g_match_info_unref0 (match_info);
			_g_free0 (check);
			_g_object_unref0 (names);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				const gchar* _tmp23_;
				gint _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				if (!_tmp20_) {
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = names;
					_tmp22_ = check;
					if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp21_, _tmp22_)) {
						break;
					}
				}
				_tmp20_ = FALSE;
				_tmp23_ = n;
				_tmp24_ = index;
				index = _tmp24_ + 1;
				_tmp25_ = g_strdup_printf ("%d", _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
				_g_free0 (check);
				check = _tmp27_;
				_g_free0 (_tmp26_);
			}
		}
		_g_free0 (n);
		_g_match_info_unref0 (match_info);
	}
	result = check;
	_g_object_unref0 (names);
	return result;
}

static void
themes_real_themes_changed (Themes* self)
{
	themes_save_custom (self);
}

static void
themes_class_init (ThemesClass * klass,
                   gpointer klass_data)
{
	themes_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Themes_private_offset);
	((ThemesClass *) klass)->themes_changed = themes_real_themes_changed;
	G_OBJECT_CLASS (klass)->finalize = themes_finalize;
	themes_signals[THEMES_THEMES_CHANGED_SIGNAL] = g_signal_new ("themes-changed", TYPE_THEMES, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ThemesClass, themes_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
themes_instance_init (Themes * self,
                      gpointer klass)
{
	self->priv = themes_get_instance_private (self);
}

static void
themes_finalize (GObject * obj)
{
	Themes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEMES, Themes);
	_g_array_unref0 (self->priv->_themes);
	G_OBJECT_CLASS (themes_parent_class)->finalize (obj);
}

static GType
themes_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) themes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Themes), 0, (GInstanceInitFunc) themes_instance_init, NULL };
	GType themes_type_id;
	themes_type_id = g_type_register_static (G_TYPE_OBJECT, "Themes", &g_define_type_info, 0);
	Themes_private_offset = g_type_add_instance_private (themes_type_id, sizeof (ThemesPrivate));
	return themes_type_id;
}

GType
themes_get_type (void)
{
	static volatile gsize themes_type_id__once = 0;
	if (g_once_init_enter (&themes_type_id__once)) {
		GType themes_type_id;
		themes_type_id = themes_get_type_once ();
		g_once_init_leave (&themes_type_id__once, themes_type_id);
	}
	return themes_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

