#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 25
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 20
#define ALIAS_COUNT 0
#define TOKEN_COUNT 12
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_LBRACK = 1,
  aux_sym_section_name_token1 = 2,
  anon_sym_RBRACK = 3,
  anon_sym_LF = 4,
  anon_sym_CR_LF = 5,
  aux_sym_setting_token1 = 6,
  anon_sym_EQ = 7,
  aux_sym_setting_token2 = 8,
  aux_sym__comment_token1 = 9,
  aux_sym__comment_token2 = 10,
  sym__blank = 11,
  sym_document = 12,
  sym_section = 13,
  sym_section_name = 14,
  sym_setting = 15,
  sym__comment = 16,
  aux_sym_document_repeat1 = 17,
  aux_sym_document_repeat2 = 18,
  aux_sym_section_repeat1 = 19,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LBRACK] = "[",
  [aux_sym_section_name_token1] = "text",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [aux_sym_setting_token1] = "setting_name",
  [anon_sym_EQ] = "=",
  [aux_sym_setting_token2] = "setting_value",
  [aux_sym__comment_token1] = "_comment_token1",
  [aux_sym__comment_token2] = "_comment_token2",
  [sym__blank] = "_blank",
  [sym_document] = "document",
  [sym_section] = "section",
  [sym_section_name] = "section_name",
  [sym_setting] = "setting",
  [sym__comment] = "_comment",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_document_repeat2] = "document_repeat2",
  [aux_sym_section_repeat1] = "section_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [aux_sym_section_name_token1] = aux_sym_section_name_token1,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [aux_sym_setting_token1] = aux_sym_setting_token1,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_setting_token2] = aux_sym_setting_token2,
  [aux_sym__comment_token1] = aux_sym__comment_token1,
  [aux_sym__comment_token2] = aux_sym__comment_token2,
  [sym__blank] = sym__blank,
  [sym_document] = sym_document,
  [sym_section] = sym_section,
  [sym_section_name] = sym_section_name,
  [sym_setting] = sym_setting,
  [sym__comment] = sym__comment,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_document_repeat2] = aux_sym_document_repeat2,
  [aux_sym_section_repeat1] = aux_sym_section_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_section_name_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_setting_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_setting_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comment_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__blank] = {
    .visible = false,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym_section_name] = {
    .visible = true,
    .named = true,
  },
  [sym_setting] = {
    .visible = true,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_document_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_section_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(6);
      if (lookahead == '\n') ADVANCE(13);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '[') ADVANCE(7);
      if (lookahead == ']') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(20);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(14);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(25);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(25);
      if (lookahead == '\r') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(9);
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(10);
      if (lookahead != 0 &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(10);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(25);
      if (lookahead == '\r') ADVANCE(2);
      if (lookahead == ']') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(4)
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(20);
      END_STATE();
    case 5:
      if (eof) ADVANCE(6);
      if (lookahead == '\n') ADVANCE(25);
      if (lookahead == '\r') ADVANCE(2);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '[') ADVANCE(7);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(20);
      if (lookahead != 0) ADVANCE(15);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(aux_sym_section_name_token1);
      if (lookahead == '\n') ADVANCE(25);
      if (lookahead != 0 &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(10);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(aux_sym_section_name_token1);
      if (lookahead == '\r') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(9);
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(10);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(10);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(aux_sym_section_name_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(10);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '[') ADVANCE(15);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_CR_LF);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(aux_sym_setting_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '[') ADVANCE(15);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(aux_sym_setting_token2);
      if (lookahead == '\n') ADVANCE(25);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(aux_sym_setting_token2);
      if (lookahead == '\r') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(18);
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(19);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(19);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym_setting_token2);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(19);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(24);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(aux_sym__comment_token2);
      if (lookahead == '\n') ADVANCE(25);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(aux_sym__comment_token2);
      if (lookahead == '\r') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(23);
      if (lookahead == '#' ||
          lookahead == ';') ADVANCE(21);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(24);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(aux_sym__comment_token2);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym__blank);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 5},
  [2] = {.lex_state = 5},
  [3] = {.lex_state = 5},
  [4] = {.lex_state = 5},
  [5] = {.lex_state = 5},
  [6] = {.lex_state = 5},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 5},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 5},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 18},
  [20] = {.lex_state = 23},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 5},
  [23] = {.lex_state = 3},
  [24] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym__comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_CR_LF] = ACTIONS(1),
    [aux_sym_setting_token1] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__blank] = ACTIONS(5),
  },
  [1] = {
    [sym_document] = STATE(22),
    [sym_section] = STATE(16),
    [sym_section_name] = STATE(3),
    [sym__comment] = STATE(1),
    [aux_sym_document_repeat1] = STATE(2),
    [aux_sym_document_repeat2] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__blank] = ACTIONS(11),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      sym__blank,
    ACTIONS(13), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      sym__comment,
    STATE(3), 1,
      sym_section_name,
    STATE(7), 1,
      aux_sym_document_repeat2,
    STATE(12), 1,
      aux_sym_document_repeat1,
    STATE(16), 1,
      sym_section,
  [28] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(17), 1,
      aux_sym_setting_token1,
    ACTIONS(19), 1,
      sym__blank,
    STATE(3), 1,
      sym__comment,
    STATE(6), 1,
      aux_sym_section_repeat1,
    STATE(11), 1,
      sym_setting,
    ACTIONS(15), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
  [51] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(13), 1,
      ts_builtin_sym_end,
    ACTIONS(19), 1,
      sym__blank,
    STATE(3), 1,
      sym_section_name,
    STATE(4), 1,
      sym__comment,
    STATE(8), 1,
      aux_sym_document_repeat2,
    STATE(16), 1,
      sym_section,
  [76] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    ACTIONS(23), 1,
      aux_sym_setting_token1,
    STATE(11), 1,
      sym_setting,
    ACTIONS(21), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
    STATE(5), 2,
      sym__comment,
      aux_sym_section_repeat1,
  [97] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(17), 1,
      aux_sym_setting_token1,
    ACTIONS(19), 1,
      sym__blank,
    STATE(5), 1,
      aux_sym_section_repeat1,
    STATE(6), 1,
      sym__comment,
    STATE(11), 1,
      sym_setting,
    ACTIONS(26), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
  [120] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      sym__blank,
    ACTIONS(28), 1,
      ts_builtin_sym_end,
    STATE(3), 1,
      sym_section_name,
    STATE(7), 1,
      sym__comment,
    STATE(8), 1,
      aux_sym_document_repeat2,
    STATE(16), 1,
      sym_section,
  [145] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    ACTIONS(30), 1,
      ts_builtin_sym_end,
    ACTIONS(32), 1,
      anon_sym_LBRACK,
    STATE(3), 1,
      sym_section_name,
    STATE(16), 1,
      sym_section,
    STATE(8), 2,
      sym__comment,
      aux_sym_document_repeat2,
  [168] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    STATE(9), 1,
      sym__comment,
    ACTIONS(35), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      aux_sym_setting_token1,
  [183] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    STATE(10), 1,
      sym__comment,
    ACTIONS(37), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      aux_sym_setting_token1,
  [198] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    STATE(11), 1,
      sym__comment,
    ACTIONS(39), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      aux_sym_setting_token1,
  [213] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(43), 1,
      sym__blank,
    ACTIONS(41), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
    STATE(12), 2,
      sym__comment,
      aux_sym_document_repeat1,
  [228] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__blank,
    STATE(13), 1,
      sym__comment,
    ACTIONS(46), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [242] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__blank,
    STATE(14), 1,
      sym__comment,
    ACTIONS(48), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [256] = 3,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    STATE(15), 1,
      sym__comment,
    ACTIONS(50), 3,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      sym__blank,
  [268] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    STATE(16), 1,
      sym__comment,
    ACTIONS(52), 2,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
  [282] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__blank,
    STATE(17), 1,
      sym__comment,
    ACTIONS(54), 2,
      anon_sym_LF,
      anon_sym_CR_LF,
  [296] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    ACTIONS(56), 1,
      anon_sym_EQ,
    STATE(18), 1,
      sym__comment,
  [309] = 4,
    ACTIONS(5), 1,
      sym__blank,
    ACTIONS(58), 1,
      aux_sym_setting_token2,
    ACTIONS(60), 1,
      aux_sym__comment_token1,
    STATE(19), 1,
      sym__comment,
  [322] = 4,
    ACTIONS(5), 1,
      sym__blank,
    ACTIONS(60), 1,
      aux_sym__comment_token1,
    ACTIONS(62), 1,
      aux_sym__comment_token2,
    STATE(20), 1,
      sym__comment,
  [335] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    ACTIONS(64), 1,
      anon_sym_RBRACK,
    STATE(21), 1,
      sym__comment,
  [348] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(19), 1,
      sym__blank,
    ACTIONS(66), 1,
      ts_builtin_sym_end,
    STATE(22), 1,
      sym__comment,
  [361] = 4,
    ACTIONS(5), 1,
      sym__blank,
    ACTIONS(60), 1,
      aux_sym__comment_token1,
    ACTIONS(68), 1,
      aux_sym_section_name_token1,
    STATE(23), 1,
      sym__comment,
  [374] = 1,
    ACTIONS(70), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 28,
  [SMALL_STATE(4)] = 51,
  [SMALL_STATE(5)] = 76,
  [SMALL_STATE(6)] = 97,
  [SMALL_STATE(7)] = 120,
  [SMALL_STATE(8)] = 145,
  [SMALL_STATE(9)] = 168,
  [SMALL_STATE(10)] = 183,
  [SMALL_STATE(11)] = 198,
  [SMALL_STATE(12)] = 213,
  [SMALL_STATE(13)] = 228,
  [SMALL_STATE(14)] = 242,
  [SMALL_STATE(15)] = 256,
  [SMALL_STATE(16)] = 268,
  [SMALL_STATE(17)] = 282,
  [SMALL_STATE(18)] = 296,
  [SMALL_STATE(19)] = 309,
  [SMALL_STATE(20)] = 322,
  [SMALL_STATE(21)] = 335,
  [SMALL_STATE(22)] = 348,
  [SMALL_STATE(23)] = 361,
  [SMALL_STATE(24)] = 374,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [13] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [15] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 1),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [21] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_section_repeat1, 2),
  [23] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(18),
  [26] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 2),
  [28] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 2),
  [30] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2),
  [32] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 2), SHIFT_REPEAT(23),
  [35] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setting, 4),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section_name, 4),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_section_repeat1, 1),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(15),
  [46] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [48] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [50] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 1),
  [52] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat2, 1),
  [54] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [56] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [58] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [60] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [62] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [64] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [66] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [68] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [70] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment, 3),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_ini(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
