#include <memory>
#include "typenamespace.hpp"
#include "type.hpp"
#define True true
#define False false
void TypeNamespace::initMethods() {
  this->vtables["bool"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "to_int",
      "Returns `1` if `true` and `0` if `false`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("bool")
    ),
    std::make_shared<Method>(
      "to_string",
      "Returns the string `'true'` if the boolean is true or `'false'` otherwise. Additionally, you can pass two strings as positional arguments to specify what to return for true/false.\nFor example, `bool.to_string('yes', 'no')` will return `'yes'` if the boolean is true and `'no'` if it is false.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "true_str",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<PositionalArgument>(
          "false_str",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("bool")
    )
  };
  this->vtables["both_libs"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "get_shared_lib",
      "Returns the stored shared library",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("lib")
      },
     this->types.at("both_libs")
    ),
    std::make_shared<Method>(
      "get_static_lib",
      "Returns the stored static library",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("lib")
      },
     this->types.at("both_libs")
    )
  };
  this->vtables["build_machine"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "cpu",
      "Returns a more specific CPU name, such as `i686`, `amd64`, etc.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_machine")
    ),
    std::make_shared<Method>(
      "cpu_family",
      "Returns the CPU family name. [This table](https://mesonbuild.com/Reference-tables.html#cpu-families) contains all known CPU families. These are guaranteed to continue working.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_machine")
    ),
    std::make_shared<Method>(
      "endian",
      "Returns `'big'` on big-endian systems and `'little'` on little-endian systems.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_machine")
    ),
    std::make_shared<Method>(
      "system",
      "Returns the operating system name. [This table](https://mesonbuild.com/Reference-tables.html#operating-system-names) lists all of the currently known Operating System names, these are guaranteed to continue working.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_machine")
    )
  };
  this->vtables["build_tgt"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "extract_all_objects",
      "Acts the same as `extract_objects`, but returns all object files generated by this target.\n\nBy default only objects built for this target are returned to maintain backward compatibility with previous versions. The default value for the `recursive` kwarg will eventually be changed to `true` in a future version.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "recursive",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("extracted_obj")
      },
     this->types.at("build_tgt")
    ),
    std::make_shared<Method>(
      "extract_objects",
      "Returns an opaque value representing the object files generated for those source files. This is typically used to take single object files and link them to unit tests or to compile some source files with custom flags. To use the object file(s) in another build target, use the `objects:` keyword argument to a `build_target()` or `declare_dependency()`, or include them in the command line of a `custom_target()`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("generated_list"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("extracted_obj")
      },
     this->types.at("build_tgt")
    ),
    std::make_shared<Method>(
      "found",
      "Always returns `true`. This function is meant to make executables objects feature compatible with `external_program` objects. This simplifies use-cases where an executable is used instead of an `external_program`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("build_tgt")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "full_path",
      "Returns a full path pointing to the result target file. **NOTE:** In most cases using the object itself will do the same job as this and will also allow Meson to setup inter-target dependencies correctly. Please file a bug if that doesn't work for you.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_tgt")
    ),
    std::make_shared<Method>(
      "outdir",
      "????",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_tgt")
    ),
    std::make_shared<Method>(
      "name",
      "Returns the name of the target.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_tgt")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "path",
      "Does the exact same as `build_tgt.full_path()`. **NOTE:** This function is solely kept for compatibility with `external_program` objects. It will be removed once the, also deprecated, corresponding `path()` function in the `external_program` object is removed.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("build_tgt")
,DeprecationState(
"0.59.0", std::vector<std::string>
{"build_tgt.full_path()"
})
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "private_dir_include",
      "Returns a value that works like `include_directories()`, but points to the private directory of this target. Usually only needed if an another target needs to access some generated internal headers of this target.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("inc")
      },
     this->types.at("build_tgt")
    )
  };
  this->vtables["cfg_data"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "get",
      "Returns the value of `varname`, if the value has not been set returns `default_value` if it is defined (since 0.38.0) and errors out if not.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "default_value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("int"),
            this->types.at("bool")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool"),
        this->types.at("str"),
        this->types.at("int")
      },
     this->types.at("cfg_data")
,DeprecationState()
,Version("0.38.0")
    ),
    std::make_shared<Method>(
      "get_unquoted",
      "Returns the value of `varname` but without surrounding double quotes (`\"`). If the value has not been set, it returns `default_value` if it is defined and errors out if not.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "default_value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("int"),
            this->types.at("bool")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool"),
        this->types.at("str"),
        this->types.at("int")
      },
     this->types.at("cfg_data")
,DeprecationState()
,Version("0.44.0")
    ),
    std::make_shared<Method>(
      "has",
      "Returns `true` if the specified variable is set.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("cfg_data")
    ),
    std::make_shared<Method>(
      "keys",
      "Returns an array of keys of the configuration data object.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("cfg_data")
,DeprecationState()
,Version("0.57.0")
    ),
    std::make_shared<Method>(
      "merge_from",
      "Takes as argument a different configuration data object and copies all entries from that object to the current.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "other",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cfg_data")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cfg_data")
,DeprecationState()
,Version("0.42.0")
    ),
    std::make_shared<Method>(
      "set",
      "Sets a variable to a given value",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("int"),
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "description",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cfg_data")
    ),
    std::make_shared<Method>(
      "set10",
      "Is the same as `cfg_data.set()` but the value is either `true` or `false` and will be written as 1 or 0, respectively",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("int"),
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "description",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cfg_data")
    ),
    std::make_shared<Method>(
      "set_quoted",
      "Is same as `cfg_data.set()` but quotes the value in double quotes (`\"`)",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("int"),
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "description",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cfg_data")
    )
  };
  this->vtables["cmake_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "subproject",
      "The `subproject` method is almost identical to the normal Meson `subproject()` function. The only difference is that a CMake project instead of a Meson project is configured.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "subproject_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "cmake_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "options",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_subprojectoptions")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("cmake_subproject")
      },
     this->types.at("cmake_module")
    ),
    std::make_shared<Method>(
      "subproject_options",
      "Returns a `cmake_subprojectoptions` that is very similar to the `cfg_data` object.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("cmake_subprojectoptions")
      },
     this->types.at("cmake_module")
    ),
    std::make_shared<Method>(
      "write_basic_package_version_file",
      "This method is the equivalent of the corresponding CMake function, generating a named package version file.\n\n- `name`: the name of the package.\n- `version`: the version of the generated package file.\n- `compatibility`: a string indicating the kind of compatibility; accepted values are `AnyNewerVersion`, `SameMajorVersion`, `SameMinorVersion`, or `ExactVersion`. It defaults to `AnyNewerVersion`. Depending on your CMake installation, some compatibility types may not be available.\n- `arch_independent`: new in 0.62.0, if true, the generated package file will skip architecture checks. This is useful for header-only libraries.\n- `install_dir`: an optional installation directory; it defaults to `$(libdir)/cmake/$(name)`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "arch_independent",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "compatibility",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "version",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_module")
    ),
    std::make_shared<Method>(
      "configure_package_config_file",
      "This method is the equivalent of the corresponding CMake function. It generates a named package configuration file from the input template file. Similar to the CMake function in this file, the `@PACKAGE_INIT@` statement will be replaced by the appropriate piece of CMake code. The equivalent `PATH_VARS` argument is given through the `configuration` parameter.\n\n- `name`: the name of the package.\n- `input`: the template file where variables will be substituted based on the provided `configuration`.\n- `install_dir`: an optional installation directory; it defaults to `$(libdir)/cmake/$(name)`.\n- `configuration`: a `configuration_data` object used for variable substitution in the template file. Since 0.62.0, it can take a dictionary instead.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "configuration",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cfg_data"),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          False
        ),
        std::make_shared<Kwarg>(
          "input",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_module")
    )
  };
  this->vtables["cmake_subproject"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "dependency",
      "Returns a dependency object for any CMake target.\nThe `include_type` kwarg (new in 0.56.0) controls the include type of the returned dependency object similar to the same kwarg in the `dependency()` function.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "tgt",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "include_type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("cmake_subproject")
    ),
    std::make_shared<Method>(
      "include_directories",
      "Returns a Meson `inc` object for the specified target. Using this method is not necessary if the dependency object is used.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "tgt",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("inc")
      },
     this->types.at("cmake_subproject")
    ),
    std::make_shared<Method>(
      "target",
      "Returns the raw build target.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "tgt",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("tgt")
      },
     this->types.at("cmake_subproject")
    ),
    std::make_shared<Method>(
      "target_type",
      "Returns the type of the target as a string",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "tgt",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("cmake_subproject")
    ),
    std::make_shared<Method>(
      "target_list",
      "Returns a list of all target `name`s.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("cmake_subproject")
    ),
    std::make_shared<Method>(
      "found",
      "Returns `true` if the subproject is available, otherwise `false`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("cmake_subproject")
    ),
    std::make_shared<Method>(
      "get_variable",
      "Fetches the specified variable from inside the subproject. Usually `dependency()` or `target()` should be preferred to extract build targets.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "var_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("cmake_subproject")
    )
  };
  this->vtables["cmake_subprojectoptions"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "add_cmake_defines",
      "Add additional CMake commandline defines",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "defines",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("str")})
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_subprojectoptions")
    ),
    std::make_shared<Method>(
      "set_override_option",
      "Set specific build options for targets. This will effectively add `opt=val` to the `override_options` array of the `build_target()`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "opt",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "val",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "target",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_subprojectoptions")
    ),
    std::make_shared<Method>(
      "set_install",
      "Override whether targets should be installed or not",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "target",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_subprojectoptions")
    ),
    std::make_shared<Method>(
      "append_compile_args",
      "Append compile flags for a specific language to the targets",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "language",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          True
        ),
        std::make_shared<Kwarg>(
          "target",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_subprojectoptions")
    ),
    std::make_shared<Method>(
      "append_link_args",
      "Append linker args to the targets.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          True
        ),
        std::make_shared<Kwarg>(
          "language",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "target",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cmake_tgt"),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_subprojectoptions")
    ),
    std::make_shared<Method>(
      "clear",
      "Reset all data in the cmake options object",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("cmake_subprojectoptions")
    )
  };
  this->vtables["compiler"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "alignment",
      "Returns the alignment of the specified type. For C-like languages, the header `stddef.h` and `stdio.h` are included implicitly for native compilation, only `stddef.h` is included when cross-compiling.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "typename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "check_header",
      "Returns true if the specified header is usable with the specified prefix, dependencies, and arguments.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "header_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.47.0")
    ),
    std::make_shared<Method>(
      "has_define",
      "Returns `true` if the given preprocessor symbol is defined.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "definename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("1.3.0")
    ),
    std::make_shared<Method>(
      "cmd_array",
      "Returns an array containing the command(s) for the compiler.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "compiles",
      "Returns true if the code compiles.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "code",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "werror",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "compute_int",
      "Computes the value of the given expression (for example, 1 + 2). When cross-compiling, this is evaluated with an iterative algorithm. You can specify the following keyword arguments:\n- `low` (defaults to -1024)\n- `high` (defaults to 1024)\n- `guess` to specify max and min values for the search and the value to try first.\n\nFor C-like languages, the header `stddef.h` and `stdio.h` are implicitly included for native compilation, whereas only `stddef.h` is included when cross-compiling.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "expr",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "guess",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "high",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "low",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.40.0")
    ),
    std::make_shared<Method>(
      "find_library",
      "Tries to find the library specified in the positional argument.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "libname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "disabler",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "has_headers",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header_dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header_include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header_no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "static",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "first_supported_argument",
      "Given a list of strings, returns a single-element list containing the first argument that passes the `compiler.has_argument()` test or an empty array if none pass.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "first_supported_link_argument",
      "Given a list of strings, returns the first argument that passes the `compiler.has_link_argument()` test or an empty array if none pass.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.46.0")
    ),
    std::make_shared<Method>(
      "get_argument_syntax",
      "returns a string identifying the type of arguments the compiler takes. Can be one of `gcc`, `msvc`, or an undefined string value. This method is useful for identifying compilers that are not gcc or msvc, but use the same argument syntax as one of those two compilers such as clang or icc, especially when they use different syntax on different operating systems.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.49.0")
    ),
    std::make_shared<Method>(
      "get_define",
      "Returns the given preprocessor symbol's value as a string or empty string if it is not defined.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "definename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.40.0")
    ),
    std::make_shared<Method>(
      "get_id",
      "Returns a string identifying the compiler. For example, `gcc`, `msvc`, and more.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "get_linker_id",
      "Returns a string identifying the linker. For example, `ld.bfd`, `link`, and more.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.53.0")
    ),
    std::make_shared<Method>(
      "get_supported_arguments",
      "Returns an array containing only the arguments supported by the compiler, as if `compiler.has_argument()` were called on them individually.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "checked",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.43.0")
    ),
    std::make_shared<Method>(
      "get_supported_function_attributes",
      "Returns an array containing any names that are supported GCC style attributes. Equivalent to `compiler.has_function_attribute()` was called on each of them individually.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "attribs",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.48.0")
    ),
    std::make_shared<Method>(
      "get_supported_link_arguments",
      "Returns an array containing only the arguments supported by the compiler, as if `compiler.has_link_argument()` were called on them individually.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.46.0")
    ),
    std::make_shared<Method>(
      "has_argument",
      "Returns `true` if the compiler accepts the specified command line argument, that is, can compile code without erroring out or printing a warning about an unknown flag.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "argument",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_function",
      "Returns true if the given function is provided by the standard library or a library passed in with the `args` keyword.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "funcname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_function_attribute",
      "Returns true if the compiler supports the GNU style `(__attribute__(...))` `name`. This is preferable to manual compile checks as it may be optimized for compilers that do not support such attributes.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.48.0")
    ),
    std::make_shared<Method>(
      "has_header",
      "Returns true if the specified header is exists with the specified prefix, dependencies, and arguments.\n\nThis method is faster than `compiler.check_header()` since it only does a pre-processor check.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "header_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_header_symbol",
      "Detects whether a particular symbol is declared in the specified header.\n\nSymbols here include function, variable, `#define`, type definition, etc.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "header",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "symbol",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_link_argument",
      "Returns true if the linker accepts the specified command line argument, that is, can compile and link code without erroring out or printing a warning about an unknown flag. Link arguments will be passed to the compiler, so should usually have the `-Wl,` prefix. On VisualStudio a `/link` argument will be prepended.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "argument",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.46.0")
    ),
    std::make_shared<Method>(
      "has_member",
      "Returns true if the type has the specified member.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "typename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "membername",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_members",
      "Returns true if the type has *all* the specified members.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "typename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "member",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          True
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_multi_arguments",
      "The same as `compiler.has_argument()` but takes multiple arguments and uses them all in a single compiler invocation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.37.0")
    ),
    std::make_shared<Method>(
      "has_multi_link_arguments",
      "The same as `compiler.has_link_argument()` but takes multiple arguments and uses them all in a single compiler invocation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "has_type",
      "Returns `true` if the specified token is a type.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "typename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "links",
      "Returns true if the code compiles and links.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "werror",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "preprocess",
      "Preprocesses a list of source files but does not compile them. The preprocessor will receive the same arguments (include directories, defines, etc.) as with normal compilation. This includes, for example, arguments added with `add_project_arguments()`, or those set on the command line using `-Dc_args=-DFOO`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "compile_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "output",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx")})
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.64.0")
    ),
    std::make_shared<Method>(
      "run",
      "Attempts to compile and execute the given code fragment.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "code",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "werror",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("runresult")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "sizeof",
      "Returns the size of the given type (e.g., 'int') or -1 if the type is unknown. For C-like languages, the header `stddef.h` and `stdio.h` are included implicitly for native compilation, whereas only `stddef.h` is included when cross-compiling.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "typename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc")}),
            this->types.at("inc")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "no_builtin_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("compiler")
    ),
    std::make_shared<Method>(
      "symbols_have_underscore_prefix",
      "Returns true if the C symbol mangling is one underscore (`_`) prefixed to the symbol.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("compiler")
,DeprecationState()
,Version("0.37.0")
    ),
    std::make_shared<Method>(
      "version",
      "Returns the compiler's version number as a string.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("compiler")
    )
  };
  this->vtables["cuda_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "min_driver_version",
      "Returns the minimum NVIDIA proprietary driver version required, on the host system, by kernels compiled with a CUDA Toolkit with the given version string.\n\nThe output of this function is generally intended for informative message printing, but could be used for assertions or to conditionally enable features known to exist within the minimum NVIDIA driver required.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "version_string",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("cuda_module")
,DeprecationState()
,Version("0.50.0")
    ),
    std::make_shared<Method>(
      "nvcc_arch_flags",
      "Returns a list of `-gencode` flags that should be passed to `cuda_args:` in order to compile a \"fat binary\" for the architectures/compute capabilities enumerated in the positional argument(s). These flags shall be acceptable to an NVCC with CUDA Toolkit version string `cuda_version_string`.\n\nA set of architectures and/or compute capabilities may be specified by:\n- The single positional argument `'All'`, `'Common'`, or `'Auto'`\n- As (an array of):\n- Architecture names (`'Kepler'`, `'Maxwell+Tegra'`, `'Turing'`) and/or\n- Compute capabilities (`'3.0'`, `'3.5'`, `'5.3'`, `'7.5'`)\n\nA suffix of `+PTX` requests PTX code generation for the given architecture. A compute capability given as `A.B(X.Y)` requests PTX generation for an older virtual architecture `X.Y` before binary generation for a newer architecture `A.B`.\n\nMultiple architectures and compute capabilities may be passed in using:\n- Multiple positional arguments\n- Lists of strings\n- Space (' '), comma (','), or semicolon (';') separated strings",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "architecture_set",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "detected",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("cuda_module")
,DeprecationState()
,Version("0.50.0")
    ),
    std::make_shared<Method>(
      "nvcc_arch_readable",
      "Has precisely the same interface as `nvcc_arch_flags()`, but rather than returning a list of flags, it returns a \"readable\" list of architectures that will be compiled for. The output of this function is solely intended for informative message printing.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "architecture_set",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "detected",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("cuda_module")
,DeprecationState()
,Version("0.50.0")
    )
  };
  this->vtables["custom_idx"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "full_path",
      "Returns a full path pointing to the result target file. **NOTE:** In most cases using the object itself will do the same job as this and will also allow Meson to setup inter-target dependencies correctly. Please file a bug if that doesn't work for you.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("custom_idx")
,DeprecationState()
,Version("0.54.0")
    )
  };
  this->vtables["custom_tgt"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "index",
      "Returns an opaque object that references this target, and can be used as a source in other targets. When it is used as such it will make that target depend on this custom target, but the only source added will be the one that corresponds to the index of the custom target's output argument.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_idx")
      },
     this->types.at("custom_tgt")
    ),
    std::make_shared<Method>(
      "full_path",
      "Returns a full path pointing to the resulting target file. **NOTE:** In most cases, using the object itself will accomplish the same task as this function and will also allow Meson to set up inter-target dependencies correctly. Please file a bug if that doesn't work for you. (since 0.54.0) It can also be called on index objects: `custom_targets[i].full_path()`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("custom_tgt")
    ),
    std::make_shared<Method>(
      "to_list",
      "Returns a list of opaque objects that references this target, and can be used as a source in other targets.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx")})
      },
     this->types.at("custom_tgt")
,DeprecationState()
,Version("0.54.0")
    )
  };
  this->vtables["dep"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "as_link_whole",
      "Only dependencies created with `declare_dependency()`. Returns a copy of the dependency object with all `link_with` arguments changed to `link_whole`. This is useful, for example, for a fallback dependency from a subproject built with `default_library=static`. Note that all `link_with` objects must be static libraries; otherwise, an error will be raised when attempting to `link_whole` a shared library.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("dep")
,DeprecationState()
,Version("0.56.0")
    ),
    std::make_shared<Method>(
      "as_system",
      "Returns a copy of the dependency object, modifying the value of `include_type` to `value`. The `value` argument is optional and defaults to `'preserve'`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("dep")
,DeprecationState()
,Version("0.52.0")
    ),
    std::make_shared<Method>(
      "found",
      "Returns whether the dependency was found.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("dep")
    ),
    std::make_shared<Method>(
      "get_configtool_variable",
      "Gets the command line argument from the config tool (with `--` prepended), or, if invoked on a non config-tool dependency, error out.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "var_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
,DeprecationState(
"0.56.0", std::vector<std::string>
{"dep.get_variable()"
})
,Version("0.44.0")
    ),
    std::make_shared<Method>(
      "get_pkgconfig_variable",
      "Gets the pkg-config variable specified, or, if invoked on a non pkg-config dependency, error out.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "var_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "define_variable",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
,DeprecationState(
"0.56.0", std::vector<std::string>
{"dep.get_variable()"
})
,Version("0.36.0")
    ),
    std::make_shared<Method>(
      "get_variable",
      "A generic variable getter method, replacing the `get_*type*_variable` methods. This method enables retrieval of the variable from a dependency without requiring specific knowledge of how that dependency was found. If `default_value` is set and the value cannot be retrieved from the object, then `default_value` is returned. If it is not set, an error is raised.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "varname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "cmake",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "configtool",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "default_value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "internal",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "pkgconfig",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "pkgconfig_define",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
,DeprecationState()
,Version("0.51.0")
    ),
    std::make_shared<Method>(
      "include_type",
      "Returns the value set by the `include_type` kwarg.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
,DeprecationState()
,Version("0.52.0")
    ),
    std::make_shared<Method>(
      "name",
      "Returns the name of the dependency that was searched. Returns `'internal'` for dependencies created with `declare_dependency()`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
,DeprecationState()
,Version("0.48.0")
    ),
    std::make_shared<Method>(
      "partial_dependency",
      "Returns a new dependency object with the same name, version, found status, type name, and methods as the object that called it. This new object will only inherit other attributes from its parent as controlled by keyword arguments.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "compile_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "includes",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "links",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("dep")
,DeprecationState()
,Version("0.46.0")
    ),
    std::make_shared<Method>(
      "type_name",
      "Returns a string describing the type of the dependency, the most common values are `internal` for deps created with `declare_dependency()` and `pkgconfig` for system dependencies obtained with Pkg-config.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
    ),
    std::make_shared<Method>(
      "version",
      "the version number as a string, for example `1.2.8`. `unknown` if the dependency provider doesn't support determining the version.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("dep")
    )
  };
  this->vtables["dict"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "get",
      "Returns the value for the key given as first argument if it is present in the dictionary, or the optional fallback value given as the second argument. If a single argument was given and the key was not found, causes a fatal error",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "key",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("dict")
    ),
    std::make_shared<Method>(
      "has_key",
      "Returns true if the dictionary contains the key given as argument, false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "key",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("dict")
    ),
    std::make_shared<Method>(
      "keys",
      "Returns an array of keys in the dictionary.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("dict")
    )
  };
  this->vtables["disabler"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "found",
      "Always returns `false`",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("disabler")
    )
  };
  this->vtables["dlang_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "generate_dub_file",
      "This method only has two required arguments, the project name and the source folder. You can pass other arguments with additional keywords, they will be automatically translated to json and added to the `dub.json` file.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "authors",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "copyright",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "description",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "license",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sourceFiles",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "targetType",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("dlang_module")
    )
  };
  this->vtables["env"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "append",
      "Appends the given values to the old value of the environment variable. For example, `env.append('FOO', 'BAR', 'BAZ', separator: ';')` produces `BOB;BAR;BAZ` if `FOO` had the value `BOB`, and plain `BAR;BAZ` if the value was not defined.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "variable",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "separator",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("env")
    ),
    std::make_shared<Method>(
      "prepend",
      "Same as `append` except that it writes to the beginning of the variable.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "variable",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "separator",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("env")
    ),
    std::make_shared<Method>(
      "set",
      "Sets the environment variable specified in the first argument to the values in the varargs joined by the separator. For instance, `env.set('FOO', 'BAR')` sets environment variable `FOO` to value `BAR`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "variable",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("bool"),
            this->types.at("int")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "separator",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("env")
    ),
    std::make_shared<Method>(
      "unset",
      "Unset the specified environment variable. If this variable does not exist, nothing happens.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "variable",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("env")
,DeprecationState()
,Version("1.4.0")
    )
  };
  this->vtables["external_program"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "found",
      "Returns whether the executable was found.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("external_program")
    ),
    std::make_shared<Method>(
      "full_path",
      "Returns a string pointing to the script or executable.\n\n**NOTE:** You should not usually need to use this method. Passing the object itself should work in most contexts where a program can appear, and allows Meson to setup inter-target dependencies correctly (for example in cases where a program might be overridden by a `build_tgt`). Only use this if you specifically need a string, such as when embedding a program path into a header file.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("external_program")
,DeprecationState()
,Version("0.55.0")
    ),
    std::make_shared<Method>(
      "path",
      "Returns a string pointing to the script or executable.\n\n**NOTE:** You should not usually need to use this method. Passing the object itself should work in most contexts where a program can appear, and allows Meson to setup inter-target dependencies correctly (for example in cases where a program might be overridden by a `build_tgt`). Only use this if you specifically need a string, such as when embedding a program path into a header file.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("external_program")
,DeprecationState(
"0.55.0", std::vector<std::string>
{"external_program.full_path()"
})
    ),
    std::make_shared<Method>(
      "version",
      "The version number as a string, for example `1.2.8`.\n\nReturns `'unknown'` if the program cannot determine the version via a `--version` argument.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("external_program")
,DeprecationState()
,Version("0.62.0")
    )
  };
  this->vtables["external_project"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "dependency",
      "Return a dependency object that can be used to build targets against a library from the external project.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "subdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "subdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("external_project")
    )
  };
  this->vtables["external_project_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "add_project",
      "This function should be called at the root directory of a project using another build system. Usually in a `meson.build` file placed in the top directory of a subproject, but could be also in any subdir.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "script",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "configure_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cross_configure_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "env",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("env"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "verbose",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("external_project")
      },
     this->types.at("external_project_module")
    )
  };
  this->vtables["feature"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "allowed",
      "Returns whether the feature was set to 'enabled' or 'auto'.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("feature")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "auto",
      "Returns whether the feature was set to 'auto'.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("feature")
    ),
    std::make_shared<Method>(
      "disable_auto_if",
      "Returns the feature, with 'auto' converted to 'disabled' if value is true.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("feature")
      },
     this->types.at("feature")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "disable_if",
      "Returns the object itself if the value is false; an error if the object is 'enabled' and the value is true; a disabled feature if the object is 'auto' or 'disabled' and the value is true.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "error_message",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("feature")
      },
     this->types.at("feature")
,DeprecationState()
,Version("1.1.0")
    ),
    std::make_shared<Method>(
      "disabled",
      "Returns whether the feature was set to 'disabled'",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("feature")
    ),
    std::make_shared<Method>(
      "enable_auto_if",
      "Returns the feature, with 'auto' converted to 'enabled' if value is true.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("feature")
      },
     this->types.at("feature")
    ),
    std::make_shared<Method>(
      "enable_if",
      "Returns the object itself if the value is false; an error if the object is 'disabled' and the value is true; an enabled feature if the object is 'auto' or 'enabled' and the value is true.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "error_message",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("feature")
      },
     this->types.at("feature")
,DeprecationState()
,Version("1.1.0")
    ),
    std::make_shared<Method>(
      "enabled",
      "Returns whether the feature was set to 'enabled'",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("feature")
    ),
    std::make_shared<Method>(
      "require",
      "Returns the object itself if the value is true; an error if the object is 'enabled' and the value is false; a disabled feature if the object is 'auto' or 'disabled' and the value is false.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "error_message",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("feature")
      },
     this->types.at("feature")
,DeprecationState()
,Version("0.59.0")
    )
  };
  this->vtables["file"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "full_path",
      "Returns a full path pointing to the file. This is useful for printing the path with e.g. `message()` function for debugging purpose.\n\n**NOTE:** In most cases using the object itself will do the same job as this and will also allow Meson to setup dependencies correctly.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("file")
,DeprecationState()
,Version("1.4.0")
    )
  };
  this->vtables["fs_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "exists",
      "Takes a single string argument and returns true if an entity with that name exists on the file system. This can be a file, directory or a special entry such as a device node.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "is_dir",
      "Takes a single string argument and returns true if a directory with that name exists on the file system.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "is_file",
      "Takes a single string argument and returns true if an file with that name exists on the file system.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "is_symlink",
      "Takes a single string or (since 0.59.0) `files()` argument and returns true if the path pointed to by the string is a symbolic link.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "is_absolute",
      "Return a boolean indicating if the path string or (since 0.59.0) `files()` specified is absolute, WITHOUT expanding `~`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("fs_module")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "relative_to",
      "Return a relative filepath. In the event a relative path could not be found, the absolute path of `to` is returned. Relative path arguments will be assumed to be relative to `meson.current_source_dir()`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "to",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("build_tgt")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "from",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("build_tgt")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
,DeprecationState()
,Version("1.3.0")
    ),
    std::make_shared<Method>(
      "hash",
      "The `fs.hash(filename, hash_algorithm)` method returns a string containing the hexadecimal `hash_algorithm` digest of a file. `hash_algorithm` is a string, and the available hash algorithms include: `md5`, `sha1`, `sha224`, `sha256`, `sha384`, `sha512`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "hash_algorithm",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "size",
      "The `fs.size(filename)` method returns the size of the file in integer bytes.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "is_samepath",
      "The `fs.is_samepath(path1, path2)` returns a boolean `true` if both paths resolve to the same path.\n\nFor example, suppose `path1` is a symlink and `path2` is a relative path. If `path1` can be resolved to `path2`, then `true` is returned. If `path1` is not resolved to `path2`, `false` is returned. If `path1` or `path2` do not exist, `false` is returned.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "path1",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "path2",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "expanduser",
      "A path string with a leading `~` is expanded to the user home directory",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "as_posix",
      "The `fs.as_posix(path)` function assumes a Windows path, even if on a Unix-like system. Consequently, all `'\\'` or `'\\\\'` characters are converted to `'/'`, even if you intended to escape a character.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "replace_suffix",
      "The `replace_suffix` method is a string manipulation convenient for filename modifications. It allows changing the filename suffix like:",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("build_tgt"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "suffix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "parent",
      "Returns the parent directory (i.e. dirname).",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str"),
            this->types.at("build_tgt"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "name",
      "Returns the last component of the path (i.e. basename).",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str"),
            this->types.at("build_tgt"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "stem",
      "Returns the last component of the path, dropping the last part of the suffix",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str"),
            this->types.at("build_tgt"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "read",
      "`read(path, encoding: 'utf-8')` (since 0.57.0): Returns a string with the contents of the given path. If the `encoding` keyword argument is not specified, the file specified by `path` is assumed to be UTF-8 encoded. Binary files are not supported.\n\nThe provided paths should be relative to the current `meson.current_source_dir()` or an absolute path outside the build directory is accepted.\n\nIf the file specified by `path` changes, this will trigger Meson to reconfigure the project.\n\nIf the file specified by `path` is a `files()` object, it cannot refer to a built file.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "encoding",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("fs_module")
    ),
    std::make_shared<Method>(
      "copyfile",
      "Copy a file from the source directory to the build directory at build time",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "src",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "dst",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_mode",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("fs_module")
,DeprecationState()
,Version("0.64.0")
    )
  };
  this->vtables["generator"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "process",
      "Takes a list of files, causes them to be processed and returns an object containing the result which can then, for example, be passed into a build target definition.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False,
          True
        ),
        std::make_shared<Kwarg>(
          "env",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("env"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_path_from",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("generated_list")
      },
     this->types.at("generator")
    )
  };
  this->vtables["gnome_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "compile_resources",
      "This function compiles resources specified in an XML file into code that can be embedded inside the main binary. Similar to a build target, it takes two positional arguments.\n\n- The first one is the name of the resource, and\n- the second is the XML file containing the resource definitions.\n\nIf the name is `foobar`, Meson will generate a header file called `foobar.h`, which you can then include in your sources. The resources specified are automatically added as dependencies of the generated target.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "id",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "input",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "export",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gresource_bundle",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_header",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "source_dir",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "generate_gir",
      "Generates GObject introspection data.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("exe"),
            this->types.at("lib")
          },
          False,
          True
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("dep")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "env",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("env")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "export_packages",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fatal_warnings",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "identifier_prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "includes",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir_gir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir_typelib",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_gir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_typelib",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_with",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "namespace",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "nsversion",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "symbok_prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "symbol_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "genmarshal",
      "Generates a marshal file using the `glib-genmarshal` tool. The first argument is the basename of the output files.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "basename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "depend_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_header",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "internal",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "nostdinc",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "prefix",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "skip_source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          False
        ),
        std::make_shared<Kwarg>(
          "stdinc",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "valist_marshallers",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "mkenums",
      "Generates enum files for GObject using the `glib-mkenums` tool. The first argument is the base name of the output files, unless `c_template` and `h_template` are specified. In this case, the output files will be the base name of the values passed as templates.\n\nThis method is essentially a wrapper around the `glib-mkenums` tool's command line API. It is the most featureful method for enum creation.\n\nTypically, you either provide template files or specify the various template sections manually as strings.\n\nMost libraries and applications will be using the same standard template with only minor tweaks, in which case the `gnome.mkenums_simple()` convenience method can be used instead.\n\nNote that if you `#include` the generated header in any of the sources for a build target, you must add the generated header to the build target's list of sources to codify the dependency. This is true for all generated sources, not just `mkenums`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "c_template",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "comments",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "eprod",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fhead",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fprod",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ftail",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "h_template",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "identifier_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_header",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          False
        ),
        std::make_shared<Kwarg>(
          "symbol_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vhead",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vprod",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vtail",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "mkenums_simple",
      "Generates enum `.c` and `.h` files for GObject using the `glib-mkenums` tool with the standard template used by most GObject-based C libraries. The first argument is the base name of the output files.\n\nNote that if you `#include` the generated header in any of the sources for a build target, you must add the generated header to the build target's list of sources to codify the dependency. This is true for all generated sources, not just `mkenums_simple`.\n\nThe generated source file includes all headers passed to the `sources` keyword argument, using paths relative to the current build or source directory. That means targets compiling the generated source file must have the current directory in their `include_directories`. Since 1.3.0, sour",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "body_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "decorator",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "function_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "header_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "identifier_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_header",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          False
        ),
        std::make_shared<Kwarg>(
          "symbol_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "compile_schemas",
      "When called, this method will compile the gschemas in the current directory. Note that this is not for installing schemas and is only useful when running the application locally for example during tests.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depend_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "gdbus_codegen",
      "Compiles the given XML schema into gdbus source code. Takes two positional arguments, the first one specifies the base name to use while creating the output source and header and the second specifies one XML file.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "annotations",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "autocleanup",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "docbook",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_header",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "interface_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "namespace",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "object_manager",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "generate_vapi",
      "Creates a VAPI file from gir. The first argument is the name of the library.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "gir_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "metadata_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "packages",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("str")})
          },
          False
        ),
        std::make_shared<Kwarg>(
          "vapi_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "yelp",
      "Installs help documentation for Yelp using itstool and gettext. The first argument is the project id.\n\nAdditionally, sources can be passed as additional positional arguments. This was, however, undocumented and never officially supported. Due to a longstanding bug, passing sources as a keyword argument will result in the positional argument sources to be ignored. since 0.60.0 A warning is raised in this case.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "languages",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
,DeprecationState(
"0.43.0", std::vector<std::string>
{""
})
        ),
        std::make_shared<Kwarg>(
          "media",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "symlink_media",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "gtkdoc",
      "Compiles and installs gtkdoc documentation into `prefix/share/gtk-doc/html`. Takes one positional argument: The name of the module.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "c_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "check",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "content_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "expand_content_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fixref_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fixxref_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gobject_typesfile",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "html_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "html_assets",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ignore_headers",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "main_sgml",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "main_xml",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "mkdb_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "mode",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "module_version",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "namespace",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "scan_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "scanobj_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "src_dir",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "gtkdoc_html_dir",
      "Takes as argument a module name and returns the path where that module's HTML files will be installed.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("gnome_module")
    ),
    std::make_shared<Method>(
      "post_install",
      "Post-install update of various system wide caches.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "gio_querymodules",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "glib_compile_schemas",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gtk_update_icon_cache",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "update_desktop_database",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "update_mime_database",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("gnome_module")
,DeprecationState()
,Version("0.57.0")
    )
  };
  this->vtables["hotdoc_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "has_extensions",
      "Returns true if all the extensions where found, false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "extensions",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("hotdoc_module")
    ),
    std::make_shared<Method>(
      "generate_doc",
      "Generates documentation using hotdoc and installs it into `$prefix/share/doc/html`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "project_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "build_always_stale",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_flags",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_order_generated_subpages",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_smart_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_source_filters",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "console",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("dep"),this->types.at("lib"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "devhelp_activate",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "devhelp_online",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "disable_incremental_build",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "edit_on_github_repository",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_assets",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_c_flags",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_extension_paths",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fatal_warnings",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_c_source_filters",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_c_source_roots",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_c_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_order_generated_subpages",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_smart_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gi_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_c_source_filters",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_c_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_cache_file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_dl_sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_list_plugins_page",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_order_generated_subpages",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_plugin_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gst_smart_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "html_extra_theme",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "html_list_plugins_page",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "html_theme",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_paths",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "languages",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
,DeprecationState(
"0.43.0", std::vector<std::string>
{""
})
        ),
        std::make_shared<Kwarg>(
          "previous_symbol_index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "project_version",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "sitemap",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "subprojects",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("hotdoc_target")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "syntax_highlighting_activate",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("hotdoc_target")
      },
     this->types.at("hotdoc_module")
    )
  };
  this->vtables["hotdoc_target"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "config_path",
      "Path to the generated `hotdoc` configuration file.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("hotdoc_target")
    )
  };
  this->vtables["i18n_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "gettext",
      "Sets up gettext localisation so that translations are built and placed into their proper locations during install. Takes one positional argument which is the name of the gettext module.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "packagename",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "data_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "languages",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
,DeprecationState(
"0.43.0", std::vector<std::string>
{""
})
        ),
        std::make_shared<Kwarg>(
          "preset",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")}),this->types.at("run_tgt")})
      },
     this->types.at("i18n_module")
    ),
    std::make_shared<Method>(
      "merge_file",
      "This merges translations into a text file using `msgfmt`. See `custom_target()` for normal keywords. In addition it accepts these keywords:",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "data_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "input",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("external_program"),this->types.at("extracted_obj"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "output",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "po_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("i18n_module")
,DeprecationState()
,Version("0.37.0")
    ),
    std::make_shared<Method>(
      "itstool_join",
      "This joins translations into a XML file using `itstool`. See `custom_target()` for normal keywords. In addition it accepts these keywords:",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "data_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "input",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("external_program"),this->types.at("extracted_obj"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "its_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "mo_targets",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
          },
          False
        ),
        std::make_shared<Kwarg>(
          "output",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("i18n_module")
,DeprecationState()
,Version("0.62.0")
    )
  };
  this->vtables["icestorm_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "project",
      "The input to this function includes a set of Verilog files and a constraint file. It produces output files named projname.asc, projname.blif, and projname.bin. Additionally, it creates two run targets:\n\n- `projname-time` for running timing analysis.\n- `projname-upload` that uploads the generated bitstream to an FPGA device using the iceprog programming executable.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "project_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "constraint_file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("run_tgt")})
      },
     this->types.at("icestorm_module")
,DeprecationState()
,Version("0.45.0")
    )
  };
  this->vtables["int"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "is_even",
      "Returns true if the number is even.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("int")
    ),
    std::make_shared<Method>(
      "is_odd",
      "Returns true if the number is odd",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("int")
    ),
    std::make_shared<Method>(
      "to_string",
      "Returns the value of the number as a string.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "fill",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("int")
    )
  };
  this->vtables["java_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "generate_native_header",
      "This function will generate a header file for use in Java native module development by reading the supplied Java file for `native` method declarations.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "package",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("java_module")
,DeprecationState(
"0.62.0", std::vector<std::string>
{"java_module.generate_native_headers()"
})
,Version("0.60.0")
    ),
    std::make_shared<Method>(
      "generate_native_headers",
      "This function will generate native header files for use in Java native module development by reading the supplied Java files for `native` method declarations.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "classes",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "package",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("java_module")
,DeprecationState(
"1.0.0", std::vector<std::string>
{"java_module.native_headers()"
})
,Version("0.62.0")
    ),
    std::make_shared<Method>(
      "native_headers",
      "This function will generate native header files for use in Java native module development by reading the supplied Java files for `native` method declarations.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "classes",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "package",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("java_module")
,DeprecationState()
,Version("1.0.0")
    )
  };
  this->vtables["keyval_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "load",
      "This function loads a file consisting of a series of `key=value` lines and returns a dictionary object.\n\n`keyval.load()` makes no attempt at parsing the values in the file. Boolean and integer values are represented as strings, and strings retain any quoting present in the input file. It can be useful to create a `configuration_data()` object from the dictionary and use methods such as `get_unquoted()`.\n\nKconfig frontends typically use \".config\" as the default name for the configuration file. However, placing the configuration file in the source directory limits the user to one configuration per source directory. To allow separate configurations for each build directory, following the Meson standard, `meson.build` should not hardcode \".config\" as the argument to `kconfig.load()`. Instead, it should make the argument to `kconfig.load()` a project build option.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("file"),
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("keyval_module")
    )
  };
  this->vtables["list"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "contains",
      "Returns true if the array contains the object given as argument, false otherwise",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "item",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("list")
    ),
    std::make_shared<Method>(
      "get",
      "Returns the object at the given index, negative indices count from the back of the array, indexing out of bounds returns the `fallback` value (since 0.38.0) or, if it is not specified, causes a fatal error",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "index",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("list")
    ),
    std::make_shared<Method>(
      "length",
      "Returns the current size of the array / list.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("list")
    )
  };
  this->vtables["meson"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "add_devenv",
      "Add an `env` object (returned by `environment()`) to the list of environments that will be applied when using the `meson devenv` command line.\n\nThis feature is beneficial for developers who want to use the project without installing it. It is often necessary to set variables such as the path to the plugins directory, among others. Alternatively, a list or dictionary can be passed as the first argument.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "env",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("env"),
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})})
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "separator",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.58.0")
    ),
    std::make_shared<Method>(
      "add_dist_script",
      "Causes the script given as an argument to run during the `dist` operation after the distribution source has been generated but before it is archived. Please note that this runs the script file located in the staging directory, not the one in the source directory. If the script file cannot be found in the staging directory, it results in a hard error. The `MESON_DIST_ROOT` environment variable is set when `dist` scripts are run.\n\n(since 0.54.0) The `MESON_SOURCE_ROOT` and `MESON_BUILD_ROOT` environment variables are set when `dist` scripts are run. They represent the path to the root source and build directory of the main project, even when the script comes from a subproject.\n\n(since 0.58.0) This command can be invoked from a subproject. In earlier versions, it resulted in a hard error. Subproject `dist` scripts will only be executed when running `meson dist --include-subprojects`. The `MESON_PROJECT_SOURCE_ROOT`, `MESON_PROJECT_BUILD_ROOT`, and `MESON_PROJECT_DIST_ROOT` environment variables are set when `dist` scripts are run for subprojects. They are identical to `MESON_SOURCE_ROOT`, `MESON_BUILD_ROOT`, and `MESON_DIST_ROOT` for main project scripts, but for subproject scripts, they have the path to the root of the subproject appended, usually `subprojects/<subproject-name>`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "script_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("external_program")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("external_program")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.48.0")
    ),
    std::make_shared<Method>(
      "add_install_script",
      "Causes the script given as an argument to be run during the install step. This script will have the following environment variables set:\n- `MESON_SOURCE_ROOT`\n- `MESON_BUILD_ROOT`\n- `MESON_INSTALL_PREFIX`\n- `MESON_INSTALL_DESTDIR_PREFIX`\n- `MESONINTROSPECT`\n\nAll positional arguments are passed as parameters.\n\n(since 0.54.0) If `meson install` is called with the `--quiet` option, the environment variable `MESON_INSTALL_QUIET` will be set.\n\n(since 1.1.0) If `meson install` is called with the `--dry-run` option, the environment variable `MESON_INSTALL_DRY_RUN` will be set.\n\nMeson uses the `DESTDIR` environment variable as set by the inherited environment to determine the temporary installation location for files. Your install script must be aware of this while manipulating and installing files. The correct way to handle this is with the `MESON_INSTALL_DESTDIR_PREFIX` variable, which is always set and contains `DESTDIR` (if set) and `prefix` joined together. This is useful because both are usually absolute paths, and there are platform-specific edge cases in joining two absolute paths.\n\nIf needed, `MESON_INSTALL_PREFIX` is also always set and has the value of the `prefix` option passed to Meson.\n\n`MESONINTROSPECT` contains the path to the introspect command that corresponds to the `meson` executable that was used to configure the build. This might be a different path than the first executable found in `PATH`. It can be used to query build configuration. Note that the value will contain many parts, for example, it may be `python3 /path/to/meson.py introspect`. The user is responsible for splitting the string into an array if needed by splitting lexically like a UNIX shell would. If your script uses Python, `shlex.split()` is the easiest correct way to do this.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "script_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("external_program"),
            this->types.at("exe"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("run_tgt")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("external_program"),
            this->types.at("exe"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "dry_run",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "skip_if_destdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "add_postconf_script",
      "Runs the given command after all project files have been generated. This script will have the environment variables `MESON_SOURCE_ROOT` and `MESON_BUILD_ROOT` set.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "script_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("external_program")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "arg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("external_program")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "backend",
      "Returns a string representing the current backend",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.37.0")
    ),
    std::make_shared<Method>(
      "build_root",
      "Returns a string with the absolute path to the build root directory.\n\nHowever, note that this function will return the build root of the parent project if called from a subproject, which might not be the desired behavior in most cases.\n\nFor subprojects, it's recommended to use:\n- `meson.current_build_dir()`\n- `meson.project_build_root()`\n\nIn rare cases where the root of the main project is explicitly needed, you can use `meson.global_build_root()`, which behaves similarly but has a more explicit name.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState(
"0.56.0", std::vector<std::string>
{"meson.current_build_dir()","meson.project_build_root()","meson.global_build_root()"
})
    ),
    std::make_shared<Method>(
      "build_options",
      "Returns a string with the configuration line used to set the current project up.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState()
,Version("1.1.0")
    ),
    std::make_shared<Method>(
      "can_run_host_binaries",
      "Returns true if the build machine can run binaries compiled for the host. This returns true unless you are cross compiling, need a helper to run host binaries, and don't have one. For example when cross compiling from Linux to Windows, one can use wine as the helper.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.55.0")
    ),
    std::make_shared<Method>(
      "current_build_dir",
      "Returns a string with the absolute path to the current build directory.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "current_source_dir",
      "Returns a string to the current source directory.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "get_compiler",
      "Returns a `compiler` object describing a compiler.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "language",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("compiler")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "get_cross_property",
      "Returns the given property from a cross file, the optional fallback_value is returned if not cross compiling or the given property is not found.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "propname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback_value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("meson")
,DeprecationState(
"0.58.0", std::vector<std::string>
{"meson.get_external_property()"
})
    ),
    std::make_shared<Method>(
      "get_external_property",
      "Returns the given property from a native or cross file. The optional fallback_value is returned if the given property is not found.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "propname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback_value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "global_build_root",
      "Returns a string with the absolute path to the build root directory. This function will return the build root of the main project if called from a subproject, which is usually not what you want. It is usually preferable to use `meson.current_build_dir()` or `meson.project_build_root()`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.58.0")
    ),
    std::make_shared<Method>(
      "global_source_root",
      "Returns a string with the absolute path to the source root directory. This function will return the source root of the main project if called from a subproject, which is usually not what you want. It is usually preferable to use `meson.current_source_dir()` or `meson.project_source_root()`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.58.0")
    ),
    std::make_shared<Method>(
      "has_exe_wrapper",
      "Use `meson.can_run_host_binaries()` instead.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("meson")
,DeprecationState(
"0.55.0", std::vector<std::string>
{"meson.can_run_host_binaries()"
})
    ),
    std::make_shared<Method>(
      "has_external_property",
      "Checks whether the given property exist in a native or cross file.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "propname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.58.0")
    ),
    std::make_shared<Method>(
      "install_dependency_manifest",
      "Installs a manifest file containing a list of all subprojects, their versions and license names to the file name given as the argument.\n\nIf license files are defined as well, they will be copied next to the manifest and referenced in it.\n\nIf this function is not used, the builtin option `licensedir` can be used to install the manifest to a given directory with the name `depmf.json`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "output_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "is_cross_build",
      "Returns true if the current build is a cross build and false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "is_subproject",
      "Returns true if the current project is being built as a subproject of some other project and false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "is_unity",
      "Returns true when doing a unity build (multiple sources are combined before compilation to reduce build time) and false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "override_dependency",
      "Specifies that whenever `dependency()` with a specified name is used, Meson should bypass the system lookup and instead return `dep_object`. This object can be the result of `dependency()` or `declare_dependency()`.\n\nThis setup in a subproject enables the parent project to obtain the dependency without needing to know the specific dependency variable name. This can be achieved using: `dependency(name, fallback: subproject_name)`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "dep_object",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("dep")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "static",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.54.0")
    ),
    std::make_shared<Method>(
      "override_find_program",
      "Specifies that whenever `find_program()` is utilized to locate a program named `progname`, Meson should bypass the system lookup and instead return `program`. This `program` object can be the result of `find_program()`, `configure_file()`, or `executable()`.\n\nStarting from Meson version 0.55.0, if a version check is provided to `find_program()` for a program that has been overridden with an executable, the current project version is utilized.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "progname",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "program",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("exe"),
            this->types.at("file"),
            this->types.at("external_program")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.46.0")
    ),
    std::make_shared<Method>(
      "project_build_root",
      "Returns a string with the absolute path to the build root directory of the current (sub)project.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.56.0")
    ),
    std::make_shared<Method>(
      "project_license",
      "Returns the array of licenses specified in `project()` function call.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.45.0")
    ),
    std::make_shared<Method>(
      "project_license_files",
      "Returns the array of license files specified in the `project()` function call.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("meson")
,DeprecationState()
,Version("1.1.0")
    ),
    std::make_shared<Method>(
      "project_name",
      "Returns the project name specified in the `project()` function call.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "project_source_root",
      "Returns a string with the absolute path to the source root directory of the current (sub)project.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState()
,Version("0.56.0")
    ),
    std::make_shared<Method>(
      "project_version",
      "Returns the version string specified in `project()` function call.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
    ),
    std::make_shared<Method>(
      "source_root",
      "Returns a string with the absolute path to the source root directory.\n\nThis function will return the source root of the parent project if called from a subproject, which is usually not what you want. Try using `meson.current_source_dir()` or `meson.project_source_root()`. In the rare cases where the root of the main project is needed, use `meson.global_source_root()` that has the same behavior but with a more explicit name.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
,DeprecationState(
"0.56.0", std::vector<std::string>
{"meson.current_source_dir()","meson.project_source_root()","meson.global_source_root()"
})
    ),
    std::make_shared<Method>(
      "version",
      "Return a string with the version of Meson.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("meson")
    )
  };
  this->vtables["module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "found",
      "Returns true if the module was successfully imported, otherwise false.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("module")
,DeprecationState()
,Version("0.59.0")
    )
  };
  this->vtables["pkgconfig_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "generate",
      "Generates a pkg-config file",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "libs",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("lib"),
            this->types.at("build_tgt")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "conflicts",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_module_versions",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dataonly",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "description",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_cflags",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "filebase",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "libraries",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("dep"),this->types.at("lib"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "libraries_private",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("dep"),this->types.at("lib"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "requires",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "requires_private",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "subdirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "unescaped_uninstalled_variables",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "unescaped_variables",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "uninstalled_variables",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "url",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "variables",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "version",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("external_program")
      },
     this->types.at("pkgconfig_module")
    )
  };
  this->vtables["python3_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "find_python",
      "This is a cross platform way of finding the Python 3 executable, which may have a different name on different operating systems. Returns an `external_program` object.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("external_program")
      },
     this->types.at("python3_module")
,DeprecationState(
"0.48.0", std::vector<std::string>
{"python_module.find_installation()"
})
,Version("0.38.0")
    ),
    std::make_shared<Method>(
      "extension_module",
      "Creates a `shared_module` target that is named according to the naming conventions of the target platform. All positional and keyword arguments are the same as for `shared_module()`.\n\n`extension_module` does not add any dependencies to the library, so the user may need to add dependencies using `dependency('python3')`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "target_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "build_rpath",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_pch",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cpp_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cpp_pch",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cs_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cython_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_debug",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_import_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_module_versions",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_unittest",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fortran_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gnu_symbol_visibility",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gui_app",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
        ),
        std::make_shared<Kwarg>(
          "implicit_include_directories",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_mode",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_rpath",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "java_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_depends",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_language",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_whole",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_with",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "masm_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name_prefix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>()
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name_suffix",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>()
          },
          True
        ),
        std::make_shared<Kwarg>(
          "nasm_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "objc_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "objcpp_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "objects",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "override_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_crate_type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
        ),
        std::make_shared<Kwarg>(
          "rust_dependency_map",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list"),
            this->types.at("structured_src")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vala_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vs_module_defs",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "win_subsystem",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("build_tgt")
      },
     this->types.at("python3_module")
,DeprecationState(
"0.48.0", std::vector<std::string>
{"python_installation.extension_module()"
})
,Version("0.38.0")
    ),
    std::make_shared<Method>(
      "language_version",
      "Returns a string with the Python language version such as `3.5`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("python3_module")
,DeprecationState(
"0.48.0", std::vector<std::string>
{"python_installation.language_version()"
})
,Version("0.40.0")
    ),
    std::make_shared<Method>(
      "sysconfig_path",
      "Returns the Python sysconfig path without prefix, such as `lib/python3.6/site-packages`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "path_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("python3_module")
,DeprecationState(
"0.40.0", std::vector<std::string>
{"python_installation.get_path()"
})
,Version("0.40.0")
    )
  };
  this->vtables["python_installation"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "path",
      "Works like the path method of other `ExternalProgram` objects.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("python_installation")
,DeprecationState()
,Version("0.50.0")
    ),
    std::make_shared<Method>(
      "extension_module",
      "Create a `shared_module()` target that follows the target platform's naming conventions. All positional and keyword arguments are the same as for `shared_module()`, excluding `name_suffix` and `name_prefix`. Additionally, it includes the following:\n\n- `subdir`: By default, Meson installs the extension module in the relevant top-level location for the Python installation, e.g., `/usr/lib/site-packages`. When `subdir` is passed to this method, it will be appended to that location. This keyword argument is mutually exclusive with `install_dir`.\n- `limited_api`: Since 1.3.0, a string containing the Python version of the `Py_LIMITED_API` that the extension targets. For example, '3.7' to target Python 3.7's version of the limited API. This behavior can be disabled by setting the value of `python.allow_limited_api`. See Python module options.\n\nAdditionally, the following differs from `shared_module()`'s default behavior:\n\n- `gnu_symbol_visibility`: If unset, it defaults to 'hidden' on versions of Python that support this (the python headers define `PyMODINIT_FUNC` has default visibility).\n\nSince 0.63.0, `extension_module` automatically adds a dependency to the library if one is not explicitly provided. To support older versions, the user may need to add `dependencies : py_installation.dependency()`, see `dependency()`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "target_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "build_rpath",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_pch",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cpp_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cpp_pch",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cs_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "cython_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_debug",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_import_dirs",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_module_versions",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "d_unittest",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fortran_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gnu_symbol_visibility",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "gui_app",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
,DeprecationState(
"0.56.0", std::vector<std::string>
{"@win_subsystem"
})
        ),
        std::make_shared<Kwarg>(
          "implicit_include_directories",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_mode",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_rpath",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "java_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "limited_api",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_depends",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_language",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_whole",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_with",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "masm_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "nasm_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "objc_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "objcpp_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "objects",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("extracted_obj"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "override_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_crate_type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
        ),
        std::make_shared<Kwarg>(
          "rust_dependency_map",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list"),
            this->types.at("structured_src")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "subdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vala_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "vs_module_defs",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "win_subsystem",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("build_tgt")
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "dependency",
      "This method accepts no positional arguments, and the same keyword arguments as the standard `dependency()` function.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "allow_fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "default_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "disabler",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "embed",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "language",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "native",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "not_found_message",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "static",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "version",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("dep")
      },
     this->types.at("python_installation")
,DeprecationState()
,Version("0.53.0")
    ),
    std::make_shared<Method>(
      "install_sources",
      "Install actual python sources (.py).\n\nAll positional and keyword arguments for this function are the same as for `install_data()`, with the addition of the following:\n\n- `python.platlibdir` and `python.purelibdir` options, available since 0.60.0, control the default installation path. See Python module options.\n- `pure`: On certain platforms, architecture-independent files are typically placed in a separate directory. However, if the Python sources should be installed alongside an extension module built with this module, this keyword argument can be used to override that behavior. Defaults to the value specified in `find_installation()`, or else `true`.\n- `subdir`: Refer to the documentation for the argument of the same name in `extension_module()`.\n- `install_tag` (since 0.60.0): A string used by `meson install --tags` command to install only a subset of the files. By default, it has the tag `python-runtime`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "file",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_mode",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("int"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_tag",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_path",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "pure",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rename",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "subdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "get_install_dir",
      "Retrieve the directory `install_sources()` will install to.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "pure",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "subdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "language_version",
      "Get the major.minor python version, e.g. `2.7`.\nThe version is obtained through the `sysconfig` module.\nThis function expects no arguments or keyword arguments.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "get_path",
      "Get a path as defined by the `sysconfig` module.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "path_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "has_path",
      "Returns true if a path named `path_name` can be retrieved with `get_path()`, false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "path_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "get_variable",
      "Get a variable as defined by the `sysconfig` module.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "variable_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("python_installation")
    ),
    std::make_shared<Method>(
      "has_variable",
      "Returns true if a variable named `variable_name` can be retrieved with `get_variable()`, false otherwise.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "variable_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("python_installation")
    )
  };
  this->vtables["python_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "find_installation",
      "Find a Python installation matching `name_or_path`.\n\nThe `name_or_path` argument is optional. If not provided, the returned Python installation will be the one used to run Meson.\n\nIf provided, `name_or_path` can be:\n\n- A simple name, e.g., `python-2.7`. Meson will look for an external program named that way using `find_program()`.\n- A path, e.g., `/usr/local/bin/python3.4m`.\n- One of `python2` or `python3`: In either case, the module will try some alternative names like `py -2` or `py -3` on Windows, and `python` everywhere. In the latter case, it will check whether the version provided by the `sysconfig` module matches the required major version.\n- Since 1.2.0, searching for a minor version (e.g., `python3.11`) also works on Windows.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name_or_path",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "disabler",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "modules",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "pure",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("python_installation")
      },
     this->types.at("python_module")
,DeprecationState()
,Version("0.46.0")
    )
  };
  this->vtables["qt4_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "compile_resources",
      "Compiles Qt's resources collection files (`.qrc`) into c++ files for compilation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt4_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "compile_ui",
      "Compiles Qt's ui files (`.ui`) into header files.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt4_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "compile_moc",
      "Compiles Qt's moc files (`.moc`) into header and/or source files. At least one of the keyword arguments `headers` and `sources` must be provided.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "headers",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt4_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "preprocess",
      "Consider using `compile_resources`, `compile_ui`, and `compile_moc` instead.\n\nThis function takes sources for `moc`, `uic`, and `rcc`, and converts them into C++ files for compilation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_headers",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "qresources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rcc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ui_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "uic_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt4_module")
    ),
    std::make_shared<Method>(
      "compile_translations",
      "This method generates the necessary targets to build translation files with `lrelease`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "qresource",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rcc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ts_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt4_module")
,DeprecationState()
,Version("0.44.0")
    ),
    std::make_shared<Method>(
      "has_tools",
      "This method returns `true` if all tools used by this module are found, otherwise `false`.\n\nIt should be used to compile optional Qt code.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("qt4_module")
,DeprecationState()
,Version("0.54.0")
    )
  };
  this->vtables["qt5_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "compile_resources",
      "Compiles Qt's resources collection files (`.qrc`) into c++ files for compilation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt5_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "compile_ui",
      "Compiles Qt's ui files (`.ui`) into header files.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt5_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "compile_moc",
      "Compiles Qt's moc files (`.moc`) into header and/or source files. At least one of the keyword arguments `headers` and `sources` must be provided.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "headers",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt5_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "preprocess",
      "Consider using `compile_resources`, `compile_ui`, and `compile_moc` instead.\n\nThis function takes sources for `moc`, `uic`, and `rcc`, and converts them into C++ files for compilation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_headers",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "qresources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rcc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ui_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "uic_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt5_module")
    ),
    std::make_shared<Method>(
      "compile_translations",
      "This method generates the necessary targets to build translation files with `lrelease`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "qresource",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rcc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ts_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt5_module")
,DeprecationState()
,Version("0.44.0")
    ),
    std::make_shared<Method>(
      "has_tools",
      "This method returns `true` if all tools used by this module are found, otherwise `false`.\n\nIt should be used to compile optional Qt code.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("qt5_module")
,DeprecationState()
,Version("0.54.0")
    )
  };
  this->vtables["qt6_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "compile_resources",
      "Compiles Qt's resources collection files (`.qrc`) into c++ files for compilation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt6_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "compile_ui",
      "Compiles Qt's ui files (`.ui`) into header files.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt6_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "compile_moc",
      "Compiles Qt's moc files (`.moc`) into header and/or source files. At least one of the keyword arguments `headers` and `sources` must be provided.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "headers",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt6_module")
,DeprecationState()
,Version("0.59.0")
    ),
    std::make_shared<Method>(
      "preprocess",
      "Consider using `compile_resources`, `compile_ui`, and `compile_moc` instead.\n\nThis function takes sources for `moc`, `uic`, and `rcc`, and converts them into C++ files for compilation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_headers",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "moc_sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "qresources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rcc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ui_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt"),this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "uic_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "preserve_paths",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt6_module")
    ),
    std::make_shared<Method>(
      "compile_translations",
      "This method generates the necessary targets to build translation files with `lrelease`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "build_by_default",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "install_dir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "qresource",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rcc_extra_arguments",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ts_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("qt6_module")
,DeprecationState()
,Version("0.44.0")
    ),
    std::make_shared<Method>(
      "has_tools",
      "This method returns `true` if all tools used by this module are found, otherwise `false`.\n\nIt should be used to compile optional Qt code.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "method",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "required",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool"),
            this->types.at("feature")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("qt6_module")
,DeprecationState()
,Version("0.54.0")
    )
  };
  this->vtables["runresult"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "compiled",
      "If true, the compilation succeeded, if false it did not and the other methods return unspecified data. This is only available for `compiler.run()` results.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("runresult")
    ),
    std::make_shared<Method>(
      "returncode",
      "The return code of executing the compiled binary",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("runresult")
    ),
    std::make_shared<Method>(
      "stderr",
      "The standard error produced when the command was run.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("runresult")
    ),
    std::make_shared<Method>(
      "stdout",
      "The standard out produced when the command was run.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("runresult")
    )
  };
  this->vtables["rust_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "proc_macro",
      "This function creates a Rust proc-macro crate, similar to:\n```meson\nshared_library()(name, sources,\nrust_crate_type: 'proc-macro',\nnative: true)\n```\nproc-macro targets can be passed to the `link_with` keyword argument of other Rust targets.\n\nOnly a subset of `shared_library()` keyword arguments are allowed:\n\n- `rust_args`\n- `rust_dependency_map`\n- `sources`\n- `dependencies`\n- `extra_files`\n- `link_args`\n- `link_depends`\n- `link_with`\n- `override_options`",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "target_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "source",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list"),
            this->types.at("build_tgt")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("dep")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "extra_files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_depends",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_with",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "override_options",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_crate_type",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
,DeprecationState(
"1.3.0", std::vector<std::string>
{"@rust_abi"
})
        ),
        std::make_shared<Kwarg>(
          "rust_dependency_map",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("generated_list"),
            this->types.at("structured_src")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("lib")
      },
     this->types.at("rust_module")
,DeprecationState()
,Version("1.3.0")
    ),
    std::make_shared<Method>(
      "test",
      "This function creates a new rust unittest target from an existing rust based target,\nwhich may be a library or executable. It does this by copying the sources and arguments passed to the original target and adding the `--test` argument to the compilation, then creates a new test target which calls that executable, using the rust test protocol.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "tgt",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("build_tgt"),
            this->types.at("tgt")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("file"),this->types.at("str"),this->types.at("tgt")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")}),
            this->types.at("dep")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "env",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("str")}),
            this->types.at("env")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "is_parallel",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "link_with",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("lib")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "priority",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "rust_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "should_fail",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "suite",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "timeout",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "verbose",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "workdir",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("rust_module")
,DeprecationState()
,Version("0.57.0")
    ),
    std::make_shared<Method>(
      "bindgen",
      "This function wraps bindgen to simplify creating Rust bindings around C libraries. It offers two advantages over invoking bindgen with a generator or custom_target:\n\n- It handles `include_directories`, eliminating the need to manually convert them to `-I...`.\n- It automatically sets up a depfile, making the results more reliable.\n- It automatically handles assertions, ensuring synchronization between Rust and C/C++ for consistent behavior.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "c_args",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("dep")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "input",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("extracted_obj"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "output",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False
        ),
        std::make_shared<Kwarg>(
          "output_inline_wrapper",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("custom_tgt")
      },
     this->types.at("rust_module")
,DeprecationState()
,Version("0.57.0")
    )
  };
  this->vtables["simd_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "check",
      "The module provides one method, `check()`, which is used like this:\n\n```meson\nrval = simd.check('mysimds',\nmmx : 'simd_mmx.c',\nsse : 'simd_sse.c',\nsse2 : 'simd_sse2.c',\nsse3 : 'simd_sse3.c',\nssse3 : 'simd_ssse3.c',\nsse41 : 'simd_sse41.c',\nsse42 : 'simd_sse42.c',\navx : 'simd_avx.c',\navx2 : 'simd_avx2.c',\nneon : 'simd_neon.c',\ncompiler : cc)\n```\nGenerating code to detect the proper instruction set at runtime is straightforward. First you create a header with the configuration object and then a chooser function that looks like this:\n```c\nvoid (*fptr)(type_of_function_here)  = NULL;\n\n#if HAVE_NEON\nif(fptr == NULL && neon_available()) {\nfptr = neon_accelerated_function;\n}\n#endif\n#if HAVE_AVX2\nif(fptr == NULL && avx2_available()) {\nfptr = avx_accelerated_function;\n}\n#endif\n\n...\n\nif(fptr == NULL) {\nfptr = default_function;\n}\n```\nEach source file provides two functions, the `xxx_available` function to query whether the CPU currently in use supports the instruction set and `xxx_accelerated_function` that is the corresponding accelerated implementation.\n\nAt the end of this function the function pointer points to the fastest available implementation and can be invoked to do the computation.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "avx",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "avx2",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "compiler",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("compiler")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "dependencies",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "mmx",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "neon",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sse",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sse2",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sse3",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sse41",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "sse42",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "ssse3",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("cfg_data"),this->types.at("lib")})
      },
     this->types.at("simd_module")
,DeprecationState()
,Version("0.42.0")
    )
  };
  this->vtables["source_configuration"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "sources",
      "Return the source files corresponding to the applied configuration.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
      },
     this->types.at("source_configuration")
    ),
    std::make_shared<Method>(
      "dependencies",
      "Return the dependencies corresponding to the applied configuration.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
      },
     this->types.at("source_configuration")
    )
  };
  this->vtables["sourceset"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "add",
      "To add a rule to a source set, you can use the `apply()` method. This method determines the conditions under which certain source files or dependency objects are included in a build configuration. All source files must exist in the source tree or can be generated in the build tree through methods like `configure_file()`, `custom_target`, or `generator`.\n\nThe `apply()` method takes `varnames_and_deps`, a list of conditions for the rule, which can be either strings or dependency objects. If all the strings evaluate to true and all dependencies are found, the rule will evaluate to true. Then, `apply()` will include the contents of the `if_true` keyword argument in its result. Otherwise, if any of the strings in the positional arguments evaluate to false or any dependency is not found, `apply()` will instead use the contents of the `if_false` keyword argument.\n\nDependencies can also appear in `sources_and_deps`. In this case, a missing dependency will simply be ignored and will not disable the rule, similar to how the `dependencies` keyword argument works in build targets.\n\n**Note:** It's generally advisable to avoid mixing source sets and disablers. Disablers will cause the rule to be dropped altogether, and the `list_of_alt_sources` would not be taken into account anymore.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("generated_list"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx"),
            this->types.at("dep")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "if_false",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("dep"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "if_true",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_idx"),this->types.at("custom_tgt"),this->types.at("dep"),this->types.at("file"),this->types.at("generated_list"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "when",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("sourceset")
    ),
    std::make_shared<Method>(
      "add_all",
      "Add one or more source sets to another.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "sources",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("sourceset")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "if_true",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("sourceset")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "when",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("dep")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
      },
     this->types.at("sourceset")
    ),
    std::make_shared<Method>(
      "all_sources",
      "Returns a list of all sources that were placed in the source set using `add` (including nested source sets) and that do not have a not-found dependency. If a rule has a not-found dependency, only the `if_false` sources are included (if any).",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
      },
     this->types.at("sourceset")
    ),
    std::make_shared<Method>(
      "all_dependencies",
      "Returns a list of all dependencies that were placed in the source set using `add` (including nested source sets) and that were found.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
      },
     this->types.at("sourceset")
    ),
    std::make_shared<Method>(
      "apply",
      "Match the source set against a dictionary or a configuration_data object and return a source configuration object. A source configuration object allows you to retrieve the sources and dependencies for a specific configuration.\n\nBy default, all the variables that were specified in the rules have to be present in conf_data. However, in some cases the convention is that false configuration symbols are absent in conf_data; this is the case for example when the configuration was loaded from a Kconfig file. In that case you can specify the strict: false keyword argument, which will treat absent variables as false.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "cfg",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("cfg_data"),
            std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("bool"),this->types.at("str")})
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "strict",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("source_configuration")
      },
     this->types.at("sourceset")
    )
  };
  this->vtables["sourceset_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "source_set",
      "Create and return a new source set object.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("sourceset")
      },
     this->types.at("sourceset_module")
,DeprecationState()
,Version("0.51.0")
    )
  };
  this->vtables["str"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "contains",
      "Returns true if string contains the string specified as the argument.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "fragment",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "endswith",
      "Returns true if string ends with the string specified as the argument.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "fragment",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "format",
      "Strings can be built using the string formatting functionality.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "value",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int"),
            this->types.at("bool"),
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("env")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "join",
      "The opposite of split, for example `'.'.join(['a', 'b', 'c'])` yields `'a.b.c'`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "strings",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "replace",
      "Search all occurrences of `old` and replace it with `new`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "old",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "new",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "split",
      "Splits the string at the specified character (or whitespace if not set) and returns the parts in an array.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "split_string",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "splitlines",
      "Splits the string into an array of lines. Unlike `.split('\\n')`, the empty string produces an empty array, and if the string ends in a newline, `splitlines()` doesn't split on that last newline. `\\n`, `\\r`, and `\\r\\n` are all considered newlines.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
      },
     this->types.at("str")
,DeprecationState()
,Version("1.2.0")
    ),
    std::make_shared<Method>(
      "startswith",
      "Returns true if string starts with the string specified as the argument.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "fragment",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "strip",
      "Removes leading/ending characters from the string.\n\nBy default the characters to remove are spaces and newlines.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "strip_chars",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "substring",
      "Returns a substring specified from start to end. Both `start` and `end` arguments are optional, so, for example, `'foobar'.substring()` will return `'foobar'`.\n\nThe method accepts negative values, where negative `start` is relative to the end of string `len(string) - start`, as well as negative `end`.\n\nIf `start` or `end` are out of bounds, the position of the closest character will be used. If `start` is bigger than `end`, the result will be an empty substring.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "start",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True,
          False
        ),
        std::make_shared<PositionalArgument>(
          "end",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
,DeprecationState()
,Version("0.56.0")
    ),
    std::make_shared<Method>(
      "to_int",
      "Converts the string to an int and throws an error if it can't be",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("int")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "to_lower",
      "Converts all characters to lower case",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "to_upper",
      "Converts all characters to upper case",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "underscorify",
      "Creates a string where every non-alphabetical non-number character is replaced with `_`.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("str")
      },
     this->types.at("str")
    ),
    std::make_shared<Method>(
      "version_compare",
      "Does semantic version comparison.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "compare_string",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("str")
    )
  };
  this->vtables["subproject"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "found",
      "Returns whether the subproject was successfully setup.",
      std::vector<std::shared_ptr<Argument>> {
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("bool")
      },
     this->types.at("subproject")
,DeprecationState()
,Version("0.48.0")
    ),
    std::make_shared<Method>(
      "get_variable",
      "Fetches the specified variable from inside the subproject. This is useful to, for instance, get a `declare_dependency()` from the subproject.\n\nIf the variable does not exist, the variable `fallback` is returned. If a fallback is not specified, then attempting to read a non-existing variable will cause a fatal error.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "var_name",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<PositionalArgument>(
          "fallback",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("any")
          },
          True,
          False
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("any"),
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("any")}),
        std::make_shared<Dict>(std::vector<std::shared_ptr<Type>>{this->types.at("any")})
      },
     this->types.at("subproject")
    )
  };
  this->vtables["wayland_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "scan_xml",
      "Returns a list of `custom_tgt` in the order source, client-side header, server-side header. Generated header files have the name `<name>-<client|server>-protocol.h`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file")
          },
          False,
          True
        ),
        std::make_shared<Kwarg>(
          "client",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_core_only",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "public",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "server",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("bool")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("wayland_module")
,DeprecationState()
,Version("0.62.0")
    ),
    std::make_shared<Method>(
      "find_protocol",
      "This function requires one positional argument: the protocol base name. It returns a `file` that can be passed to `scan_xml`.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "files",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          False,
          False
        ),
        std::make_shared<Kwarg>(
          "state",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str")
          },
          True
        ),
        std::make_shared<Kwarg>(
          "version",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("int")
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        this->types.at("file")
      },
     this->types.at("wayland_module")
,DeprecationState()
,Version("0.62.0")
    )
  };
  this->vtables["windows_module"] = std::vector<std::shared_ptr<Method>>{
    std::make_shared<Method>(
      "compile_resources",
      "Compiles Windows `rc` files specified in the positional arguments. Returns a list of `CustomTarget` objects that you put in the list of sources for the target you want to have the resources in.",
      std::vector<std::shared_ptr<Argument>> {
        std::make_shared<PositionalArgument>(
          "libs",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            this->types.at("file"),
            this->types.at("custom_tgt"),
            this->types.at("custom_idx")
          },
          True,
          True
        ),
        std::make_shared<Kwarg>(
          "args",
          std::vector<std::shared_ptr<Type>>{
            this->types.at("str"),
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depend_files",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("file"),this->types.at("str")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "depends",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("build_tgt"),this->types.at("custom_tgt"),this->types.at("custom_idx")})
          },
          True
        ),
        std::make_shared<Kwarg>(
          "include_directories",
          std::vector<std::shared_ptr<Type>>{
            std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("inc"),this->types.at("str")})
          },
          True
        )
      },
      std::vector<std::shared_ptr<Type>>{
        std::make_shared<List>(std::vector<std::shared_ptr<Type>>{this->types.at("custom_tgt")})
      },
     this->types.at("windows_module")
    )
  };
}
