/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * BPF Disassembler                                                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace llvm {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * be constructible from an APInt (this can be private)
// * Support insertBits(bits, startBit, numBits)
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
// * Support put (<<) to raw_ostream&
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// a field.
template <typename InsnType>
static std::enable_if_t<std::is_integral<InsnType>::value>
insertBits(InsnType &field, InsnType bits, unsigned startBit, unsigned numBits) {
  assert(startBit + numBits <= sizeof field * 8);
  field |= (InsnType)bits << startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value>
insertBits(InsnType &field, uint64_t bits, unsigned startBit, unsigned numBits) {
  field.insertBits(bits, startBit, numBits);
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTableBPF64[] = {
/* 0 */       MCD::OPC_ExtractField, 56, 8,  // Inst{63-56} ...
/* 3 */       MCD::OPC_FilterValue, 4, 11, 0, 0, // Skip to: 19
/* 8 */       MCD::OPC_CheckField, 32, 16, 0, 79, 7, 0, // Skip to: 1886
/* 15 */      MCD::OPC_Decode, 181, 2, 0, // Opcode: ADD_ri_32
/* 19 */      MCD::OPC_FilterValue, 5, 4, 0, 0, // Skip to: 28
/* 24 */      MCD::OPC_Decode, 211, 2, 1, // Opcode: JMP
/* 28 */      MCD::OPC_FilterValue, 6, 4, 0, 0, // Skip to: 37
/* 33 */      MCD::OPC_Decode, 212, 2, 2, // Opcode: JMPL
/* 37 */      MCD::OPC_FilterValue, 7, 11, 0, 0, // Skip to: 53
/* 42 */      MCD::OPC_CheckField, 32, 16, 0, 45, 7, 0, // Skip to: 1886
/* 49 */      MCD::OPC_Decode, 180, 2, 3, // Opcode: ADD_ri
/* 53 */      MCD::OPC_FilterValue, 12, 11, 0, 0, // Skip to: 69
/* 58 */      MCD::OPC_CheckField, 32, 16, 0, 29, 7, 0, // Skip to: 1886
/* 65 */      MCD::OPC_Decode, 183, 2, 4, // Opcode: ADD_rr_32
/* 69 */      MCD::OPC_FilterValue, 15, 11, 0, 0, // Skip to: 85
/* 74 */      MCD::OPC_CheckField, 32, 16, 0, 13, 7, 0, // Skip to: 1886
/* 81 */      MCD::OPC_Decode, 182, 2, 5, // Opcode: ADD_rr
/* 85 */      MCD::OPC_FilterValue, 20, 11, 0, 0, // Skip to: 101
/* 90 */      MCD::OPC_CheckField, 32, 16, 0, 253, 6, 0, // Skip to: 1886
/* 97 */      MCD::OPC_Decode, 204, 3, 0, // Opcode: SUB_ri_32
/* 101 */     MCD::OPC_FilterValue, 21, 4, 0, 0, // Skip to: 110
/* 106 */     MCD::OPC_Decode, 207, 2, 6, // Opcode: JEQ_ri
/* 110 */     MCD::OPC_FilterValue, 22, 4, 0, 0, // Skip to: 119
/* 115 */     MCD::OPC_Decode, 208, 2, 7, // Opcode: JEQ_ri_32
/* 119 */     MCD::OPC_FilterValue, 23, 11, 0, 0, // Skip to: 135
/* 124 */     MCD::OPC_CheckField, 32, 16, 0, 219, 6, 0, // Skip to: 1886
/* 131 */     MCD::OPC_Decode, 203, 3, 3, // Opcode: SUB_ri
/* 135 */     MCD::OPC_FilterValue, 24, 23, 0, 0, // Skip to: 163
/* 140 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 143 */     MCD::OPC_FilterValue, 0, 202, 6, 0, // Skip to: 1886
/* 148 */     MCD::OPC_CheckField, 52, 4, 0, 4, 0, 0, // Skip to: 159
/* 155 */     MCD::OPC_Decode, 141, 3, 8, // Opcode: LD_imm64
/* 159 */     MCD::OPC_Decode, 142, 3, 9, // Opcode: LD_pseudo
/* 163 */     MCD::OPC_FilterValue, 28, 11, 0, 0, // Skip to: 179
/* 168 */     MCD::OPC_CheckField, 32, 16, 0, 175, 6, 0, // Skip to: 1886
/* 175 */     MCD::OPC_Decode, 206, 3, 4, // Opcode: SUB_rr_32
/* 179 */     MCD::OPC_FilterValue, 29, 4, 0, 0, // Skip to: 188
/* 184 */     MCD::OPC_Decode, 209, 2, 10, // Opcode: JEQ_rr
/* 188 */     MCD::OPC_FilterValue, 30, 4, 0, 0, // Skip to: 197
/* 193 */     MCD::OPC_Decode, 210, 2, 11, // Opcode: JEQ_rr_32
/* 197 */     MCD::OPC_FilterValue, 31, 11, 0, 0, // Skip to: 213
/* 202 */     MCD::OPC_CheckField, 32, 16, 0, 141, 6, 0, // Skip to: 1886
/* 209 */     MCD::OPC_Decode, 205, 3, 5, // Opcode: SUB_rr
/* 213 */     MCD::OPC_FilterValue, 32, 4, 0, 0, // Skip to: 222
/* 218 */     MCD::OPC_Decode, 137, 3, 2, // Opcode: LD_ABS_W
/* 222 */     MCD::OPC_FilterValue, 36, 11, 0, 0, // Skip to: 238
/* 227 */     MCD::OPC_CheckField, 32, 16, 0, 116, 6, 0, // Skip to: 1886
/* 234 */     MCD::OPC_Decode, 161, 3, 0, // Opcode: MUL_ri_32
/* 238 */     MCD::OPC_FilterValue, 37, 4, 0, 0, // Skip to: 247
/* 243 */     MCD::OPC_Decode, 241, 2, 6, // Opcode: JUGT_ri
/* 247 */     MCD::OPC_FilterValue, 38, 4, 0, 0, // Skip to: 256
/* 252 */     MCD::OPC_Decode, 242, 2, 7, // Opcode: JUGT_ri_32
/* 256 */     MCD::OPC_FilterValue, 39, 11, 0, 0, // Skip to: 272
/* 261 */     MCD::OPC_CheckField, 32, 16, 0, 82, 6, 0, // Skip to: 1886
/* 268 */     MCD::OPC_Decode, 160, 3, 3, // Opcode: MUL_ri
/* 272 */     MCD::OPC_FilterValue, 40, 4, 0, 0, // Skip to: 281
/* 277 */     MCD::OPC_Decode, 136, 3, 2, // Opcode: LD_ABS_H
/* 281 */     MCD::OPC_FilterValue, 44, 11, 0, 0, // Skip to: 297
/* 286 */     MCD::OPC_CheckField, 32, 16, 0, 57, 6, 0, // Skip to: 1886
/* 293 */     MCD::OPC_Decode, 163, 3, 4, // Opcode: MUL_rr_32
/* 297 */     MCD::OPC_FilterValue, 45, 4, 0, 0, // Skip to: 306
/* 302 */     MCD::OPC_Decode, 243, 2, 10, // Opcode: JUGT_rr
/* 306 */     MCD::OPC_FilterValue, 46, 4, 0, 0, // Skip to: 315
/* 311 */     MCD::OPC_Decode, 244, 2, 11, // Opcode: JUGT_rr_32
/* 315 */     MCD::OPC_FilterValue, 47, 11, 0, 0, // Skip to: 331
/* 320 */     MCD::OPC_CheckField, 32, 16, 0, 23, 6, 0, // Skip to: 1886
/* 327 */     MCD::OPC_Decode, 162, 3, 5, // Opcode: MUL_rr
/* 331 */     MCD::OPC_FilterValue, 48, 4, 0, 0, // Skip to: 340
/* 336 */     MCD::OPC_Decode, 135, 3, 2, // Opcode: LD_ABS_B
/* 340 */     MCD::OPC_FilterValue, 52, 21, 0, 0, // Skip to: 366
/* 345 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 348 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 357
/* 353 */     MCD::OPC_Decode, 201, 2, 0, // Opcode: DIV_ri_32
/* 357 */     MCD::OPC_FilterValue, 1, 244, 5, 0, // Skip to: 1886
/* 362 */     MCD::OPC_Decode, 173, 3, 0, // Opcode: SDIV_ri_32
/* 366 */     MCD::OPC_FilterValue, 53, 4, 0, 0, // Skip to: 375
/* 371 */     MCD::OPC_Decode, 237, 2, 6, // Opcode: JUGE_ri
/* 375 */     MCD::OPC_FilterValue, 54, 4, 0, 0, // Skip to: 384
/* 380 */     MCD::OPC_Decode, 238, 2, 7, // Opcode: JUGE_ri_32
/* 384 */     MCD::OPC_FilterValue, 55, 21, 0, 0, // Skip to: 410
/* 389 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 392 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 401
/* 397 */     MCD::OPC_Decode, 200, 2, 3, // Opcode: DIV_ri
/* 401 */     MCD::OPC_FilterValue, 1, 200, 5, 0, // Skip to: 1886
/* 406 */     MCD::OPC_Decode, 172, 3, 3, // Opcode: SDIV_ri
/* 410 */     MCD::OPC_FilterValue, 60, 21, 0, 0, // Skip to: 436
/* 415 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 418 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 427
/* 423 */     MCD::OPC_Decode, 203, 2, 4, // Opcode: DIV_rr_32
/* 427 */     MCD::OPC_FilterValue, 1, 174, 5, 0, // Skip to: 1886
/* 432 */     MCD::OPC_Decode, 175, 3, 4, // Opcode: SDIV_rr_32
/* 436 */     MCD::OPC_FilterValue, 61, 4, 0, 0, // Skip to: 445
/* 441 */     MCD::OPC_Decode, 239, 2, 10, // Opcode: JUGE_rr
/* 445 */     MCD::OPC_FilterValue, 62, 4, 0, 0, // Skip to: 454
/* 450 */     MCD::OPC_Decode, 240, 2, 11, // Opcode: JUGE_rr_32
/* 454 */     MCD::OPC_FilterValue, 63, 21, 0, 0, // Skip to: 480
/* 459 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 462 */     MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 471
/* 467 */     MCD::OPC_Decode, 202, 2, 5, // Opcode: DIV_rr
/* 471 */     MCD::OPC_FilterValue, 1, 130, 5, 0, // Skip to: 1886
/* 476 */     MCD::OPC_Decode, 174, 3, 5, // Opcode: SDIV_rr
/* 480 */     MCD::OPC_FilterValue, 64, 4, 0, 0, // Skip to: 489
/* 485 */     MCD::OPC_Decode, 140, 3, 12, // Opcode: LD_IND_W
/* 489 */     MCD::OPC_FilterValue, 68, 11, 0, 0, // Skip to: 505
/* 494 */     MCD::OPC_CheckField, 32, 16, 0, 105, 5, 0, // Skip to: 1886
/* 501 */     MCD::OPC_Decode, 168, 3, 0, // Opcode: OR_ri_32
/* 505 */     MCD::OPC_FilterValue, 69, 4, 0, 0, // Skip to: 514
/* 510 */     MCD::OPC_Decode, 217, 2, 6, // Opcode: JSET_ri
/* 514 */     MCD::OPC_FilterValue, 70, 4, 0, 0, // Skip to: 523
/* 519 */     MCD::OPC_Decode, 218, 2, 7, // Opcode: JSET_ri_32
/* 523 */     MCD::OPC_FilterValue, 71, 11, 0, 0, // Skip to: 539
/* 528 */     MCD::OPC_CheckField, 32, 16, 0, 71, 5, 0, // Skip to: 1886
/* 535 */     MCD::OPC_Decode, 167, 3, 3, // Opcode: OR_ri
/* 539 */     MCD::OPC_FilterValue, 72, 4, 0, 0, // Skip to: 548
/* 544 */     MCD::OPC_Decode, 139, 3, 12, // Opcode: LD_IND_H
/* 548 */     MCD::OPC_FilterValue, 76, 11, 0, 0, // Skip to: 564
/* 553 */     MCD::OPC_CheckField, 32, 16, 0, 46, 5, 0, // Skip to: 1886
/* 560 */     MCD::OPC_Decode, 170, 3, 4, // Opcode: OR_rr_32
/* 564 */     MCD::OPC_FilterValue, 77, 4, 0, 0, // Skip to: 573
/* 569 */     MCD::OPC_Decode, 219, 2, 10, // Opcode: JSET_rr
/* 573 */     MCD::OPC_FilterValue, 78, 4, 0, 0, // Skip to: 582
/* 578 */     MCD::OPC_Decode, 220, 2, 11, // Opcode: JSET_rr_32
/* 582 */     MCD::OPC_FilterValue, 79, 11, 0, 0, // Skip to: 598
/* 587 */     MCD::OPC_CheckField, 32, 16, 0, 12, 5, 0, // Skip to: 1886
/* 594 */     MCD::OPC_Decode, 169, 3, 5, // Opcode: OR_rr
/* 598 */     MCD::OPC_FilterValue, 80, 4, 0, 0, // Skip to: 607
/* 603 */     MCD::OPC_Decode, 138, 3, 12, // Opcode: LD_IND_B
/* 607 */     MCD::OPC_FilterValue, 84, 11, 0, 0, // Skip to: 623
/* 612 */     MCD::OPC_CheckField, 32, 16, 0, 243, 4, 0, // Skip to: 1886
/* 619 */     MCD::OPC_Decode, 185, 2, 0, // Opcode: AND_ri_32
/* 623 */     MCD::OPC_FilterValue, 85, 4, 0, 0, // Skip to: 632
/* 628 */     MCD::OPC_Decode, 213, 2, 6, // Opcode: JNE_ri
/* 632 */     MCD::OPC_FilterValue, 86, 4, 0, 0, // Skip to: 641
/* 637 */     MCD::OPC_Decode, 214, 2, 7, // Opcode: JNE_ri_32
/* 641 */     MCD::OPC_FilterValue, 87, 11, 0, 0, // Skip to: 657
/* 646 */     MCD::OPC_CheckField, 32, 16, 0, 209, 4, 0, // Skip to: 1886
/* 653 */     MCD::OPC_Decode, 184, 2, 3, // Opcode: AND_ri
/* 657 */     MCD::OPC_FilterValue, 92, 11, 0, 0, // Skip to: 673
/* 662 */     MCD::OPC_CheckField, 32, 16, 0, 193, 4, 0, // Skip to: 1886
/* 669 */     MCD::OPC_Decode, 187, 2, 4, // Opcode: AND_rr_32
/* 673 */     MCD::OPC_FilterValue, 93, 4, 0, 0, // Skip to: 682
/* 678 */     MCD::OPC_Decode, 215, 2, 10, // Opcode: JNE_rr
/* 682 */     MCD::OPC_FilterValue, 94, 4, 0, 0, // Skip to: 691
/* 687 */     MCD::OPC_Decode, 216, 2, 11, // Opcode: JNE_rr_32
/* 691 */     MCD::OPC_FilterValue, 95, 11, 0, 0, // Skip to: 707
/* 696 */     MCD::OPC_CheckField, 32, 16, 0, 159, 4, 0, // Skip to: 1886
/* 703 */     MCD::OPC_Decode, 186, 2, 5, // Opcode: AND_rr
/* 707 */     MCD::OPC_FilterValue, 97, 4, 0, 0, // Skip to: 716
/* 712 */     MCD::OPC_Decode, 132, 3, 13, // Opcode: LDW
/* 716 */     MCD::OPC_FilterValue, 98, 4, 0, 0, // Skip to: 725
/* 721 */     MCD::OPC_Decode, 202, 3, 14, // Opcode: STW_imm
/* 725 */     MCD::OPC_FilterValue, 99, 4, 0, 0, // Skip to: 734
/* 730 */     MCD::OPC_Decode, 200, 3, 15, // Opcode: STW
/* 734 */     MCD::OPC_FilterValue, 100, 11, 0, 0, // Skip to: 750
/* 739 */     MCD::OPC_CheckField, 32, 16, 0, 116, 4, 0, // Skip to: 1886
/* 746 */     MCD::OPC_Decode, 177, 3, 0, // Opcode: SLL_ri_32
/* 750 */     MCD::OPC_FilterValue, 101, 4, 0, 0, // Skip to: 759
/* 755 */     MCD::OPC_Decode, 225, 2, 6, // Opcode: JSGT_ri
/* 759 */     MCD::OPC_FilterValue, 102, 4, 0, 0, // Skip to: 768
/* 764 */     MCD::OPC_Decode, 226, 2, 7, // Opcode: JSGT_ri_32
/* 768 */     MCD::OPC_FilterValue, 103, 11, 0, 0, // Skip to: 784
/* 773 */     MCD::OPC_CheckField, 32, 16, 0, 82, 4, 0, // Skip to: 1886
/* 780 */     MCD::OPC_Decode, 176, 3, 3, // Opcode: SLL_ri
/* 784 */     MCD::OPC_FilterValue, 105, 4, 0, 0, // Skip to: 793
/* 789 */     MCD::OPC_Decode, 129, 3, 13, // Opcode: LDH
/* 793 */     MCD::OPC_FilterValue, 106, 4, 0, 0, // Skip to: 802
/* 798 */     MCD::OPC_Decode, 199, 3, 14, // Opcode: STH_imm
/* 802 */     MCD::OPC_FilterValue, 107, 4, 0, 0, // Skip to: 811
/* 807 */     MCD::OPC_Decode, 197, 3, 15, // Opcode: STH
/* 811 */     MCD::OPC_FilterValue, 108, 11, 0, 0, // Skip to: 827
/* 816 */     MCD::OPC_CheckField, 32, 16, 0, 39, 4, 0, // Skip to: 1886
/* 823 */     MCD::OPC_Decode, 179, 3, 4, // Opcode: SLL_rr_32
/* 827 */     MCD::OPC_FilterValue, 109, 4, 0, 0, // Skip to: 836
/* 832 */     MCD::OPC_Decode, 227, 2, 10, // Opcode: JSGT_rr
/* 836 */     MCD::OPC_FilterValue, 110, 4, 0, 0, // Skip to: 845
/* 841 */     MCD::OPC_Decode, 228, 2, 11, // Opcode: JSGT_rr_32
/* 845 */     MCD::OPC_FilterValue, 111, 11, 0, 0, // Skip to: 861
/* 850 */     MCD::OPC_CheckField, 32, 16, 0, 5, 4, 0, // Skip to: 1886
/* 857 */     MCD::OPC_Decode, 178, 3, 5, // Opcode: SLL_rr
/* 861 */     MCD::OPC_FilterValue, 113, 4, 0, 0, // Skip to: 870
/* 866 */     MCD::OPC_Decode, 253, 2, 13, // Opcode: LDB
/* 870 */     MCD::OPC_FilterValue, 114, 4, 0, 0, // Skip to: 879
/* 875 */     MCD::OPC_Decode, 194, 3, 14, // Opcode: STB_imm
/* 879 */     MCD::OPC_FilterValue, 115, 4, 0, 0, // Skip to: 888
/* 884 */     MCD::OPC_Decode, 192, 3, 15, // Opcode: STB
/* 888 */     MCD::OPC_FilterValue, 116, 11, 0, 0, // Skip to: 904
/* 893 */     MCD::OPC_CheckField, 32, 16, 0, 218, 3, 0, // Skip to: 1886
/* 900 */     MCD::OPC_Decode, 189, 3, 0, // Opcode: SRL_ri_32
/* 904 */     MCD::OPC_FilterValue, 117, 4, 0, 0, // Skip to: 913
/* 909 */     MCD::OPC_Decode, 221, 2, 6, // Opcode: JSGE_ri
/* 913 */     MCD::OPC_FilterValue, 118, 4, 0, 0, // Skip to: 922
/* 918 */     MCD::OPC_Decode, 222, 2, 7, // Opcode: JSGE_ri_32
/* 922 */     MCD::OPC_FilterValue, 119, 11, 0, 0, // Skip to: 938
/* 927 */     MCD::OPC_CheckField, 32, 16, 0, 184, 3, 0, // Skip to: 1886
/* 934 */     MCD::OPC_Decode, 188, 3, 3, // Opcode: SRL_ri
/* 938 */     MCD::OPC_FilterValue, 121, 4, 0, 0, // Skip to: 947
/* 943 */     MCD::OPC_Decode, 128, 3, 13, // Opcode: LDD
/* 947 */     MCD::OPC_FilterValue, 122, 4, 0, 0, // Skip to: 956
/* 952 */     MCD::OPC_Decode, 196, 3, 14, // Opcode: STD_imm
/* 956 */     MCD::OPC_FilterValue, 123, 4, 0, 0, // Skip to: 965
/* 961 */     MCD::OPC_Decode, 195, 3, 15, // Opcode: STD
/* 965 */     MCD::OPC_FilterValue, 124, 11, 0, 0, // Skip to: 981
/* 970 */     MCD::OPC_CheckField, 32, 16, 0, 141, 3, 0, // Skip to: 1886
/* 977 */     MCD::OPC_Decode, 191, 3, 4, // Opcode: SRL_rr_32
/* 981 */     MCD::OPC_FilterValue, 125, 4, 0, 0, // Skip to: 990
/* 986 */     MCD::OPC_Decode, 223, 2, 10, // Opcode: JSGE_rr
/* 990 */     MCD::OPC_FilterValue, 126, 4, 0, 0, // Skip to: 999
/* 995 */     MCD::OPC_Decode, 224, 2, 11, // Opcode: JSGE_rr_32
/* 999 */     MCD::OPC_FilterValue, 127, 11, 0, 0, // Skip to: 1015
/* 1004 */    MCD::OPC_CheckField, 32, 16, 0, 107, 3, 0, // Skip to: 1886
/* 1011 */    MCD::OPC_Decode, 190, 3, 5, // Opcode: SRL_rr
/* 1015 */    MCD::OPC_FilterValue, 129, 1, 4, 0, 0, // Skip to: 1025
/* 1021 */    MCD::OPC_Decode, 134, 3, 13, // Opcode: LDWSX
/* 1025 */    MCD::OPC_FilterValue, 132, 1, 4, 0, 0, // Skip to: 1035
/* 1031 */    MCD::OPC_Decode, 164, 3, 16, // Opcode: NEG_32
/* 1035 */    MCD::OPC_FilterValue, 133, 1, 4, 0, 0, // Skip to: 1045
/* 1041 */    MCD::OPC_Decode, 204, 2, 2, // Opcode: JAL
/* 1045 */    MCD::OPC_FilterValue, 135, 1, 4, 0, 0, // Skip to: 1055
/* 1051 */    MCD::OPC_Decode, 165, 3, 17, // Opcode: NEG_64
/* 1055 */    MCD::OPC_FilterValue, 137, 1, 4, 0, 0, // Skip to: 1065
/* 1061 */    MCD::OPC_Decode, 131, 3, 13, // Opcode: LDHSX
/* 1065 */    MCD::OPC_FilterValue, 141, 1, 4, 0, 0, // Skip to: 1075
/* 1071 */    MCD::OPC_Decode, 205, 2, 18, // Opcode: JALX
/* 1075 */    MCD::OPC_FilterValue, 145, 1, 4, 0, 0, // Skip to: 1085
/* 1081 */    MCD::OPC_Decode, 255, 2, 13, // Opcode: LDBSX
/* 1085 */    MCD::OPC_FilterValue, 148, 1, 21, 0, 0, // Skip to: 1112
/* 1091 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1094 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1103
/* 1099 */    MCD::OPC_Decode, 147, 3, 0, // Opcode: MOD_ri_32
/* 1103 */    MCD::OPC_FilterValue, 1, 10, 3, 0, // Skip to: 1886
/* 1108 */    MCD::OPC_Decode, 181, 3, 0, // Opcode: SMOD_ri_32
/* 1112 */    MCD::OPC_FilterValue, 149, 1, 11, 0, 0, // Skip to: 1129
/* 1118 */    MCD::OPC_CheckField, 0, 32, 0, 249, 2, 0, // Skip to: 1886
/* 1125 */    MCD::OPC_Decode, 171, 3, 19, // Opcode: RET
/* 1129 */    MCD::OPC_FilterValue, 151, 1, 21, 0, 0, // Skip to: 1156
/* 1135 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1138 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1147
/* 1143 */    MCD::OPC_Decode, 146, 3, 3, // Opcode: MOD_ri
/* 1147 */    MCD::OPC_FilterValue, 1, 222, 2, 0, // Skip to: 1886
/* 1152 */    MCD::OPC_Decode, 180, 3, 3, // Opcode: SMOD_ri
/* 1156 */    MCD::OPC_FilterValue, 156, 1, 21, 0, 0, // Skip to: 1183
/* 1162 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1165 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1174
/* 1170 */    MCD::OPC_Decode, 149, 3, 4, // Opcode: MOD_rr_32
/* 1174 */    MCD::OPC_FilterValue, 1, 195, 2, 0, // Skip to: 1886
/* 1179 */    MCD::OPC_Decode, 183, 3, 4, // Opcode: SMOD_rr_32
/* 1183 */    MCD::OPC_FilterValue, 159, 1, 21, 0, 0, // Skip to: 1210
/* 1189 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1192 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1201
/* 1197 */    MCD::OPC_Decode, 148, 3, 5, // Opcode: MOD_rr
/* 1201 */    MCD::OPC_FilterValue, 1, 168, 2, 0, // Skip to: 1886
/* 1206 */    MCD::OPC_Decode, 182, 3, 5, // Opcode: SMOD_rr
/* 1210 */    MCD::OPC_FilterValue, 164, 1, 11, 0, 0, // Skip to: 1227
/* 1216 */    MCD::OPC_CheckField, 32, 16, 0, 151, 2, 0, // Skip to: 1886
/* 1223 */    MCD::OPC_Decode, 225, 3, 0, // Opcode: XOR_ri_32
/* 1227 */    MCD::OPC_FilterValue, 165, 1, 4, 0, 0, // Skip to: 1237
/* 1233 */    MCD::OPC_Decode, 249, 2, 6, // Opcode: JULT_ri
/* 1237 */    MCD::OPC_FilterValue, 166, 1, 4, 0, 0, // Skip to: 1247
/* 1243 */    MCD::OPC_Decode, 250, 2, 7, // Opcode: JULT_ri_32
/* 1247 */    MCD::OPC_FilterValue, 167, 1, 11, 0, 0, // Skip to: 1264
/* 1253 */    MCD::OPC_CheckField, 32, 16, 0, 114, 2, 0, // Skip to: 1886
/* 1260 */    MCD::OPC_Decode, 224, 3, 3, // Opcode: XOR_ri
/* 1264 */    MCD::OPC_FilterValue, 172, 1, 11, 0, 0, // Skip to: 1281
/* 1270 */    MCD::OPC_CheckField, 32, 16, 0, 97, 2, 0, // Skip to: 1886
/* 1277 */    MCD::OPC_Decode, 227, 3, 4, // Opcode: XOR_rr_32
/* 1281 */    MCD::OPC_FilterValue, 173, 1, 4, 0, 0, // Skip to: 1291
/* 1287 */    MCD::OPC_Decode, 251, 2, 10, // Opcode: JULT_rr
/* 1291 */    MCD::OPC_FilterValue, 174, 1, 4, 0, 0, // Skip to: 1301
/* 1297 */    MCD::OPC_Decode, 252, 2, 11, // Opcode: JULT_rr_32
/* 1301 */    MCD::OPC_FilterValue, 175, 1, 11, 0, 0, // Skip to: 1318
/* 1307 */    MCD::OPC_CheckField, 32, 16, 0, 60, 2, 0, // Skip to: 1886
/* 1314 */    MCD::OPC_Decode, 226, 3, 5, // Opcode: XOR_rr
/* 1318 */    MCD::OPC_FilterValue, 180, 1, 11, 0, 0, // Skip to: 1335
/* 1324 */    MCD::OPC_CheckField, 32, 16, 0, 43, 2, 0, // Skip to: 1886
/* 1331 */    MCD::OPC_Decode, 157, 3, 20, // Opcode: MOV_ri_32
/* 1335 */    MCD::OPC_FilterValue, 181, 1, 4, 0, 0, // Skip to: 1345
/* 1341 */    MCD::OPC_Decode, 245, 2, 6, // Opcode: JULE_ri
/* 1345 */    MCD::OPC_FilterValue, 182, 1, 4, 0, 0, // Skip to: 1355
/* 1351 */    MCD::OPC_Decode, 246, 2, 7, // Opcode: JULE_ri_32
/* 1355 */    MCD::OPC_FilterValue, 183, 1, 11, 0, 0, // Skip to: 1372
/* 1361 */    MCD::OPC_CheckField, 32, 16, 0, 6, 2, 0, // Skip to: 1886
/* 1368 */    MCD::OPC_Decode, 156, 3, 8, // Opcode: MOV_ri
/* 1372 */    MCD::OPC_FilterValue, 188, 1, 30, 0, 0, // Skip to: 1408
/* 1378 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1381 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1390
/* 1386 */    MCD::OPC_Decode, 159, 3, 21, // Opcode: MOV_rr_32
/* 1390 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 1399
/* 1395 */    MCD::OPC_Decode, 153, 3, 21, // Opcode: MOVSX_rr_32_8
/* 1399 */    MCD::OPC_FilterValue, 16, 226, 1, 0, // Skip to: 1886
/* 1404 */    MCD::OPC_Decode, 152, 3, 21, // Opcode: MOVSX_rr_32_16
/* 1408 */    MCD::OPC_FilterValue, 189, 1, 4, 0, 0, // Skip to: 1418
/* 1414 */    MCD::OPC_Decode, 247, 2, 10, // Opcode: JULE_rr
/* 1418 */    MCD::OPC_FilterValue, 190, 1, 4, 0, 0, // Skip to: 1428
/* 1424 */    MCD::OPC_Decode, 248, 2, 11, // Opcode: JULE_rr_32
/* 1428 */    MCD::OPC_FilterValue, 191, 1, 48, 0, 0, // Skip to: 1482
/* 1434 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1437 */    MCD::OPC_FilterValue, 0, 4, 0, 0, // Skip to: 1446
/* 1442 */    MCD::OPC_Decode, 158, 3, 22, // Opcode: MOV_rr
/* 1446 */    MCD::OPC_FilterValue, 1, 4, 0, 0, // Skip to: 1455
/* 1451 */    MCD::OPC_Decode, 179, 2, 23, // Opcode: ADDR_SPACE_CAST
/* 1455 */    MCD::OPC_FilterValue, 8, 4, 0, 0, // Skip to: 1464
/* 1460 */    MCD::OPC_Decode, 154, 3, 22, // Opcode: MOVSX_rr_8
/* 1464 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 1473
/* 1469 */    MCD::OPC_Decode, 150, 3, 22, // Opcode: MOVSX_rr_16
/* 1473 */    MCD::OPC_FilterValue, 32, 152, 1, 0, // Skip to: 1886
/* 1478 */    MCD::OPC_Decode, 151, 3, 22, // Opcode: MOVSX_rr_32
/* 1482 */    MCD::OPC_FilterValue, 195, 1, 11, 0, 0, // Skip to: 1499
/* 1488 */    MCD::OPC_CheckField, 4, 4, 0, 135, 1, 0, // Skip to: 1886
/* 1495 */    MCD::OPC_Decode, 208, 3, 24, // Opcode: XADDW
/* 1499 */    MCD::OPC_FilterValue, 196, 1, 11, 0, 0, // Skip to: 1516
/* 1505 */    MCD::OPC_CheckField, 32, 16, 0, 118, 1, 0, // Skip to: 1886
/* 1512 */    MCD::OPC_Decode, 185, 3, 0, // Opcode: SRA_ri_32
/* 1516 */    MCD::OPC_FilterValue, 197, 1, 4, 0, 0, // Skip to: 1526
/* 1522 */    MCD::OPC_Decode, 233, 2, 6, // Opcode: JSLT_ri
/* 1526 */    MCD::OPC_FilterValue, 198, 1, 4, 0, 0, // Skip to: 1536
/* 1532 */    MCD::OPC_Decode, 234, 2, 7, // Opcode: JSLT_ri_32
/* 1536 */    MCD::OPC_FilterValue, 199, 1, 11, 0, 0, // Skip to: 1553
/* 1542 */    MCD::OPC_CheckField, 32, 16, 0, 81, 1, 0, // Skip to: 1886
/* 1549 */    MCD::OPC_Decode, 184, 3, 3, // Opcode: SRA_ri
/* 1553 */    MCD::OPC_FilterValue, 204, 1, 11, 0, 0, // Skip to: 1570
/* 1559 */    MCD::OPC_CheckField, 32, 16, 0, 64, 1, 0, // Skip to: 1886
/* 1566 */    MCD::OPC_Decode, 187, 3, 4, // Opcode: SRA_rr_32
/* 1570 */    MCD::OPC_FilterValue, 205, 1, 4, 0, 0, // Skip to: 1580
/* 1576 */    MCD::OPC_Decode, 235, 2, 10, // Opcode: JSLT_rr
/* 1580 */    MCD::OPC_FilterValue, 206, 1, 4, 0, 0, // Skip to: 1590
/* 1586 */    MCD::OPC_Decode, 236, 2, 11, // Opcode: JSLT_rr_32
/* 1590 */    MCD::OPC_FilterValue, 207, 1, 11, 0, 0, // Skip to: 1607
/* 1596 */    MCD::OPC_CheckField, 32, 16, 0, 27, 1, 0, // Skip to: 1886
/* 1603 */    MCD::OPC_Decode, 186, 3, 5, // Opcode: SRA_rr
/* 1607 */    MCD::OPC_FilterValue, 212, 1, 30, 0, 0, // Skip to: 1643
/* 1613 */    MCD::OPC_ExtractField, 0, 32,  // Inst{31-0} ...
/* 1616 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 1625
/* 1621 */    MCD::OPC_Decode, 143, 3, 17, // Opcode: LE16
/* 1625 */    MCD::OPC_FilterValue, 32, 4, 0, 0, // Skip to: 1634
/* 1630 */    MCD::OPC_Decode, 144, 3, 17, // Opcode: LE32
/* 1634 */    MCD::OPC_FilterValue, 64, 247, 0, 0, // Skip to: 1886
/* 1639 */    MCD::OPC_Decode, 145, 3, 17, // Opcode: LE64
/* 1643 */    MCD::OPC_FilterValue, 213, 1, 4, 0, 0, // Skip to: 1653
/* 1649 */    MCD::OPC_Decode, 229, 2, 6, // Opcode: JSLE_ri
/* 1653 */    MCD::OPC_FilterValue, 214, 1, 4, 0, 0, // Skip to: 1663
/* 1659 */    MCD::OPC_Decode, 230, 2, 7, // Opcode: JSLE_ri_32
/* 1663 */    MCD::OPC_FilterValue, 215, 1, 30, 0, 0, // Skip to: 1699
/* 1669 */    MCD::OPC_ExtractField, 0, 32,  // Inst{31-0} ...
/* 1672 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 1681
/* 1677 */    MCD::OPC_Decode, 191, 2, 17, // Opcode: BSWAP16
/* 1681 */    MCD::OPC_FilterValue, 32, 4, 0, 0, // Skip to: 1690
/* 1686 */    MCD::OPC_Decode, 192, 2, 17, // Opcode: BSWAP32
/* 1690 */    MCD::OPC_FilterValue, 64, 191, 0, 0, // Skip to: 1886
/* 1695 */    MCD::OPC_Decode, 193, 2, 17, // Opcode: BSWAP64
/* 1699 */    MCD::OPC_FilterValue, 219, 1, 115, 0, 0, // Skip to: 1820
/* 1705 */    MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 1708 */    MCD::OPC_FilterValue, 0, 15, 0, 0, // Skip to: 1728
/* 1713 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 1724
/* 1720 */    MCD::OPC_Decode, 214, 3, 24, // Opcode: XFADDD
/* 1724 */    MCD::OPC_Decode, 207, 3, 24, // Opcode: XADDD
/* 1728 */    MCD::OPC_FilterValue, 4, 15, 0, 0, // Skip to: 1748
/* 1733 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 1744
/* 1740 */    MCD::OPC_Decode, 218, 3, 24, // Opcode: XFORD
/* 1744 */    MCD::OPC_Decode, 222, 3, 24, // Opcode: XORD
/* 1748 */    MCD::OPC_FilterValue, 5, 15, 0, 0, // Skip to: 1768
/* 1753 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 1764
/* 1760 */    MCD::OPC_Decode, 216, 3, 24, // Opcode: XFANDD
/* 1764 */    MCD::OPC_Decode, 210, 3, 24, // Opcode: XANDD
/* 1768 */    MCD::OPC_FilterValue, 10, 15, 0, 0, // Skip to: 1788
/* 1773 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 1784
/* 1780 */    MCD::OPC_Decode, 220, 3, 24, // Opcode: XFXORD
/* 1784 */    MCD::OPC_Decode, 228, 3, 24, // Opcode: XXORD
/* 1788 */    MCD::OPC_FilterValue, 14, 11, 0, 0, // Skip to: 1804
/* 1793 */    MCD::OPC_CheckField, 0, 4, 1, 86, 0, 0, // Skip to: 1886
/* 1800 */    MCD::OPC_Decode, 212, 3, 24, // Opcode: XCHGD
/* 1804 */    MCD::OPC_FilterValue, 15, 77, 0, 0, // Skip to: 1886
/* 1809 */    MCD::OPC_CheckField, 0, 4, 1, 70, 0, 0, // Skip to: 1886
/* 1816 */    MCD::OPC_Decode, 194, 2, 25, // Opcode: CMPXCHGD
/* 1820 */    MCD::OPC_FilterValue, 220, 1, 30, 0, 0, // Skip to: 1856
/* 1826 */    MCD::OPC_ExtractField, 0, 32,  // Inst{31-0} ...
/* 1829 */    MCD::OPC_FilterValue, 16, 4, 0, 0, // Skip to: 1838
/* 1834 */    MCD::OPC_Decode, 188, 2, 17, // Opcode: BE16
/* 1838 */    MCD::OPC_FilterValue, 32, 4, 0, 0, // Skip to: 1847
/* 1843 */    MCD::OPC_Decode, 189, 2, 17, // Opcode: BE32
/* 1847 */    MCD::OPC_FilterValue, 64, 34, 0, 0, // Skip to: 1886
/* 1852 */    MCD::OPC_Decode, 190, 2, 17, // Opcode: BE64
/* 1856 */    MCD::OPC_FilterValue, 221, 1, 4, 0, 0, // Skip to: 1866
/* 1862 */    MCD::OPC_Decode, 231, 2, 10, // Opcode: JSLE_rr
/* 1866 */    MCD::OPC_FilterValue, 222, 1, 4, 0, 0, // Skip to: 1876
/* 1872 */    MCD::OPC_Decode, 232, 2, 11, // Opcode: JSLE_rr_32
/* 1876 */    MCD::OPC_FilterValue, 229, 1, 4, 0, 0, // Skip to: 1886
/* 1882 */    MCD::OPC_Decode, 206, 2, 1, // Opcode: JCOND
/* 1886 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableBPFALU3264[] = {
/* 0 */       MCD::OPC_ExtractField, 56, 8,  // Inst{63-56} ...
/* 3 */       MCD::OPC_FilterValue, 97, 4, 0, 0, // Skip to: 12
/* 8 */       MCD::OPC_Decode, 133, 3, 26, // Opcode: LDW32
/* 12 */      MCD::OPC_FilterValue, 99, 4, 0, 0, // Skip to: 21
/* 17 */      MCD::OPC_Decode, 201, 3, 27, // Opcode: STW32
/* 21 */      MCD::OPC_FilterValue, 105, 4, 0, 0, // Skip to: 30
/* 26 */      MCD::OPC_Decode, 130, 3, 26, // Opcode: LDH32
/* 30 */      MCD::OPC_FilterValue, 107, 4, 0, 0, // Skip to: 39
/* 35 */      MCD::OPC_Decode, 198, 3, 27, // Opcode: STH32
/* 39 */      MCD::OPC_FilterValue, 113, 4, 0, 0, // Skip to: 48
/* 44 */      MCD::OPC_Decode, 254, 2, 26, // Opcode: LDB32
/* 48 */      MCD::OPC_FilterValue, 115, 4, 0, 0, // Skip to: 57
/* 53 */      MCD::OPC_Decode, 193, 3, 27, // Opcode: STB32
/* 57 */      MCD::OPC_FilterValue, 195, 1, 115, 0, 0, // Skip to: 178
/* 63 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 66 */      MCD::OPC_FilterValue, 0, 15, 0, 0, // Skip to: 86
/* 71 */      MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 82
/* 78 */      MCD::OPC_Decode, 215, 3, 28, // Opcode: XFADDW32
/* 82 */      MCD::OPC_Decode, 209, 3, 28, // Opcode: XADDW32
/* 86 */      MCD::OPC_FilterValue, 4, 15, 0, 0, // Skip to: 106
/* 91 */      MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 102
/* 98 */      MCD::OPC_Decode, 219, 3, 28, // Opcode: XFORW32
/* 102 */     MCD::OPC_Decode, 223, 3, 28, // Opcode: XORW32
/* 106 */     MCD::OPC_FilterValue, 5, 15, 0, 0, // Skip to: 126
/* 111 */     MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 122
/* 118 */     MCD::OPC_Decode, 217, 3, 28, // Opcode: XFANDW32
/* 122 */     MCD::OPC_Decode, 211, 3, 28, // Opcode: XANDW32
/* 126 */     MCD::OPC_FilterValue, 10, 15, 0, 0, // Skip to: 146
/* 131 */     MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 142
/* 138 */     MCD::OPC_Decode, 221, 3, 28, // Opcode: XFXORW32
/* 142 */     MCD::OPC_Decode, 229, 3, 28, // Opcode: XXORW32
/* 146 */     MCD::OPC_FilterValue, 14, 11, 0, 0, // Skip to: 162
/* 151 */     MCD::OPC_CheckField, 0, 4, 1, 20, 0, 0, // Skip to: 178
/* 158 */     MCD::OPC_Decode, 213, 3, 28, // Opcode: XCHGW32
/* 162 */     MCD::OPC_FilterValue, 15, 11, 0, 0, // Skip to: 178
/* 167 */     MCD::OPC_CheckField, 0, 4, 1, 4, 0, 0, // Skip to: 178
/* 174 */     MCD::OPC_Decode, 195, 2, 29, // Opcode: CMPXCHGW32
/* 178 */     MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  llvm_unreachable("Invalid index!");
}

template <typename InsnType>
static DecodeStatus decodeToMCInst(DecodeStatus S, unsigned Idx, InsnType insn, MCInst &MI,
                                   uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 32, 16), 0, 16);
    insertBits(tmp, fieldFromInstruction(insn, 52, 4), 16, 4);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 19:
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 21:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 32, 16), 0, 16);
    insertBits(tmp, fieldFromInstruction(insn, 52, 4), 16, 4);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    switch (*Ptr) {
    default:
      errs() << Loc << ": Unexpected decode table opcode!\n";
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(++Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue: {
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(++Ptr);
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // Perform the filter operation.
      if (Val != CurFieldValue)
        Ptr += NumToSkip;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_FilterValue(" << Val << ", " << NumToSkip
                   << "): " << ((Val != CurFieldValue) ? "FAIL:" : "PASS:")
                   << " continuing at " << (Ptr - DecodeTable) << "\n");

      break;
    }
    case MCD::OPC_CheckField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(++Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // If the actual and expected values don't match, skip.
      if (ExpectedValue != FieldValue)
        Ptr += NumToSkip;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_CheckField(" << Start << ", "
                   << Len << ", " << ExpectedValue << ", " << NumToSkip
                   << "): FieldValue = " << FieldValue << ", ExpectedValue = "
                   << ExpectedValue << ": "
                   << ((ExpectedValue == FieldValue) ? "PASS\n" : "FAIL\n"));
      break;
    }
    case MCD::OPC_CheckPredicate: {
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128AndIncUnsafe(++Ptr);
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;
      // Check the predicate.
      bool Pred;
      if (!(Pred = checkDecoderPredicate(PIdx, Bits)))
        Ptr += NumToSkip;
      (void)Pred;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_CheckPredicate(" << PIdx << "): "
            << (Pred ? "PASS\n" : "FAIL\n"));

      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(++Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(S, DecodeIdx, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS" : "FAIL") << "\n");
      return S;
    }
    case MCD::OPC_TryDecode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(++Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);
      // NumToSkip is a plain 24-bit integer.
      unsigned NumToSkip = *Ptr++;
      NumToSkip |= (*Ptr++) << 8;
      NumToSkip |= (*Ptr++) << 16;

      // Perform the decode operation.
      MCInst TmpMI;
      TmpMI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(S, DecodeIdx, insn, TmpMI, Address, DisAsm, DecodeComplete);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_TryDecode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": ");

      if (DecodeComplete) {
        // Decoding complete.
        LLVM_DEBUG(dbgs() << (S != MCDisassembler::Fail ? "PASS" : "FAIL") << "\n");
        MI = TmpMI;
        return S;
      } else {
        assert(S == MCDisassembler::Fail);
        // If the decoding was incomplete, skip.
        Ptr += NumToSkip;
        LLVM_DEBUG(dbgs() << "FAIL: continuing at " << (Ptr - DecodeTable) << "\n");
        // Reset decode status. This also drops a SoftFail status that could be
        // set before the decode attempt.
        S = MCDisassembler::Success;
      }
      break;
    }
    case MCD::OPC_SoftFail: {
      // Decode the mask values.
      uint64_t PositiveMask = decodeULEB128AndIncUnsafe(++Ptr);
      uint64_t NegativeMask = decodeULEB128AndIncUnsafe(Ptr);
      bool Fail = (insn & PositiveMask) != 0 || (~insn & NegativeMask) != 0;
      if (Fail)
        S = MCDisassembler::SoftFail;
      LLVM_DEBUG(dbgs() << Loc << ": OPC_SoftFail: " << (Fail ? "FAIL\n" : "PASS\n"));
      break;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // end namespace llvm
