/*
Copyright (C) 2010 Christian Kothe

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "FreeSurround/ChannelMaps.h"

float map_5point1_ang[] = {-27, 0, 27, -105, 105};
float map_5point1_xsf[] = {-1, 0, 1, -1, 1};
float map_5point1_ysf[] = {1, 1, 1, -1, -1};
channel_id map_5point1_id[] = {ci_front_left, ci_front_center, ci_front_right,
                               ci_back_left,  ci_back_right,   ci_lfe};

float map_5point1_lf[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.054079f, 0.13605f,  0.11031f,  0.083738f,  0.058746f, 0.03616f,
     0.022585f, 0.018356f, 0.012179f, 0.0043961f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.11103f,   0.16562f,  0.18635f,  0.15778f,  0.12791f,  0.12403f,
     0.10709f,   0.090176f, 0.070512f, 0.049741f, 0.027549f, 0.011727f,
     0.0013628f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.17535f,  0.20208f,   0.21809f,  0.22862f,  0.21842f,  0.20197f,
     0.18341f,  0.15706f,   0.13031f,  0.10103f,  0.068601f, 0.041975f,
     0.018696f, 0.0039144f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.24362f,  0.24543f,  0.25563f,   0.27972f,  0.28786f,  0.26979f,
     0.24789f,  0.21805f,  0.18569f,   0.14921f,  0.10871f,  0.073541f,
     0.041097f, 0.017152f, 0.0038597f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.3173f,   0.29703f,  0.31848f,  0.33006f,   0.33185f,  0.32571f,
     0.30203f,  0.27305f,  0.23691f,  0.19431f,   0.14844f,  0.10174f,
     0.061737f, 0.03134f,  0.010908f, 0.0013625f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.39394f,  0.36121f,  0.3753f,   0.38051f,    0.37306f,  0.35451f,
     0.33178f,  0.30958f,  0.28023f,  0.23726f,    0.18262f,  0.12638f,
     0.07899f,  0.043546f, 0.017841f, 0.00044495f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.47562f,  0.43164f,  0.43211f,  0.42477f,  0.4019f,   0.37291f,
     0.34131f,  0.31385f,  0.29675f,  0.2674f,   0.21259f,  0.14347f,
     0.086077f, 0.046322f, 0.012467f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.55484f,  0.49969f,  0.48539f,   0.45665f,  0.41889f,  0.37886f,
     0.33895f,  0.30764f,  0.28138f,   0.2723f,   0.23279f,  0.14674f,
     0.083778f, 0.032293f, 0.0048976f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.63203f,  0.56664f,  0.52742f,  0.47709f,   0.42408f,  0.37424f,
     0.33419f,  0.30176f,  0.27482f,  0.25011f,   0.23665f,  0.1471f,
     0.082204f, 0.040759f, 0.015195f, 0.0028496f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.70711f,  0.63601f,  0.56403f,  0.49301f,  0.42572f,   0.37154f,
     0.33227f,  0.30051f,  0.27246f,  0.24769f,  0.22385f,   0.17996f,
     0.13303f,  0.089089f, 0.051572f, 0.021112f, 0.0019269f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.77384f,  0.69829f,  0.59208f,  0.49896f,  0.42627f, 0.37547f,
     0.33559f,  0.30342f,  0.27695f,  0.2532f,   0.24555f, 0.24096f,
     0.202f,    0.15312f,  0.099312f, 0.049149f, 0.01419f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.83292f,  0.75424f,  0.62497f, 0.51188f,  0.43577f,  0.38288f,
     0.34157f,  0.31064f,  0.28485f, 0.27588f,  0.27011f,  0.26791f,
     0.24233f,  0.19874f,  0.14444f, 0.081488f, 0.031102f, 0.0022352f,
     0.000000f, 0.000000f, 0.000000f},
    {0.88048f,  0.80823f,  0.66178f, 0.53219f, 0.45043f,  0.39421f,
     0.35046f,  0.32046f,  0.30985f, 0.30176f, 0.29791f,  0.28855f,
     0.26277f,  0.22895f,  0.1783f,  0.11122f, 0.048526f, 0.0073556f,
     0.000000f, 0.000000f, 0.000000f},
    {0.91982f, 0.8564f,  0.6966f,   0.55364f,  0.46596f,  0.41011f,  0.36623f,
     0.3499f,  0.34025f, 0.33348f,  0.32389f,  0.30536f,  0.27602f,  0.24046f,
     0.19967f, 0.13416f, 0.066173f, 0.014462f, 0.000000f, 0.000000f, 0.000000f},
    {0.94888f, 0.8756f,  0.72118f,  0.58509f,  0.49378f,  0.42727f,  0.40951f,
     0.39303f, 0.37927f, 0.36377f,  0.34295f,  0.31626f,  0.28156f,  0.24129f,
     0.19667f, 0.15218f, 0.075526f, 0.017441f, 0.000000f, 0.000000f, 0.000000f},
    {0.9703f,  0.87092f, 0.76228f,  0.60765f,  0.51716f,  0.48514f,  0.45531f,
     0.43328f, 0.40894f, 0.38299f,  0.35389f,  0.31939f,  0.27862f,  0.23237f,
     0.18465f, 0.12881f, 0.081296f, 0.019071f, 0.000000f, 0.000000f, 0.000000f},
    {0.98481f, 0.85688f, 0.73952f, 0.62982f,  0.5767f,   0.53382f,  0.4939f,
     0.46098f, 0.42667f, 0.39124f, 0.35254f,  0.31034f,  0.26195f,  0.20782f,
     0.15167f, 0.09417f, 0.04946f, 0.016531f, 0.000000f, 0.000000f, 0.000000f},
    {0.99396f,  0.83616f,  0.71307f,  0.68155f,  0.64457f,   0.57478f,
     0.52315f,  0.47464f,  0.42859f,  0.38222f,  0.33181f,   0.27965f,
     0.21975f,  0.15464f,  0.094607f, 0.047925f, 0.0098814f, 0.0024671f,
     0.000000f, 0.000000f, 0.000000f},
    {0.99855f,  0.81216f,  0.78057f,  0.73849f,   0.68375f,  0.61653f,
     0.5369f,   0.46213f,  0.39741f,  0.33339f,   0.26339f,  0.19725f,
     0.13069f,  0.067274f, 0.019339f, 0.0021311f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {1.000000f, 0.94446f,  0.8823f,   0.80914f,  0.72626f,  0.63102f,
     0.52519f,  0.40402f,  0.27711f,  0.14046f,  0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

float map_5point1_cf[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f,   0.000000f, 0.000000f,   0.000000f, 0.000000f, 0.0019269f,
     0.00062925f, 0.000000f, 0.000000f,   0.000000f, 0.000000f, 0.000000f,
     0.000000f,   0.000000f, 0.00059225f, 0.001914f, 0.000000f, 0.000000f,
     0.000000f,   0.000000f, 0.000000f},
    {0.000000f,  0.000000f, 0.000000f,  0.000000f,    0.0055425f, 0.0155f,
     0.025167f,  0.017695f, 0.0063155f, 1.0116e-005f, 0.000000f,  0.000000f,
     0.0062031f, 0.017508f, 0.025125f,  0.015305f,    0.0054168f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.0056317f, 0.024256f,    0.044322f,
     0.061583f, 0.065405f, 0.041656f, 0.014688f,  4.0817e-019f, 0.014527f,
     0.041389f, 0.065342f, 0.061236f, 0.044002f,  0.024003f,    0.005504f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f,  0.000000f, 0.0019274f, 0.02644f,  0.05812f,  0.08731f,
     0.11105f,   0.11767f,  0.10963f,   0.061306f, 0.017226f, 0.061006f,
     0.10958f,   0.11735f,  0.11066f,   0.086884f, 0.057744f, 0.026151f,
     0.0018503f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.016697f, 0.059451f, 0.104f,    0.13974f,
     0.15702f,  0.15962f,  0.15223f,  0.13355f,  0.063692f, 0.13353f,
     0.15211f,  0.15945f,  0.15675f,  0.13934f,  0.10352f,  0.059047f,
     0.016456f, 0.000000f, 0.000000f},
    {0.000000f, 1.2068e-018f, 0.038851f, 0.096919f, 0.15087f, 0.17987f,
     0.18511f,  0.17445f,     0.15817f,  0.14379f,  0.13384f, 0.14378f,
     0.15816f,  0.17444f,     0.18509f,  0.17981f,  0.15076f, 0.096821f,
     0.038797f, 0.000000f,    0.000000f},
    {0.000000f, 0.0063777f, 0.070344f, 0.14288f, 0.19068f, 0.2049f,
     0.19453f,  0.1758f,    0.16036f,  0.14645f, 0.14681f, 0.14646f,
     0.16036f,  0.1758f,    0.19453f,  0.20473f, 0.19031f, 0.14227f,
     0.06984f,  0.0061903f, 0.000000f},
    {0.000000f, 0.017224f, 0.099719f, 0.18101f, 0.21822f, 0.2193f,
     0.19777f,  0.17979f,  0.16475f,  0.16187f, 0.16149f, 0.16187f,
     0.16477f,  0.1798f,   0.19777f,  0.21922f, 0.21792f, 0.18045f,
     0.099116f, 0.016918f, 0.000000f},
    {0.000000f, 0.02596f, 0.12753f, 0.21148f, 0.23925f, 0.22819f,  0.20284f,
     0.18535f,  0.18085f, 0.17814f, 0.17812f, 0.17814f, 0.18084f,  0.18536f,
     0.20284f,  0.22818f, 0.23901f, 0.21095f, 0.12685f, 0.025562f, 0.000000f},
    {0.000000f, 0.03194f, 0.15144f, 0.23904f, 0.2564f,  0.23733f,  0.21182f,
     0.20371f,  0.19964f, 0.19751f, 0.19694f, 0.1975f,  0.19963f,  0.20369f,
     0.21184f,  0.23733f, 0.25621f, 0.23853f, 0.15068f, 0.031485f, 0.000000f},
    {0.000000f, 0.051138f, 0.17541f, 0.26062f, 0.27419f, 0.24713f,  0.23812f,
     0.22985f,  0.2244f,   0.22133f, 0.22022f, 0.22132f, 0.22439f,  0.22984f,
     0.2381f,   0.24715f,  0.274f,   0.26009f, 0.17455f, 0.050511f, 0.000000f},
    {0.000000f, 0.08308f, 0.18105f, 0.28155f, 0.29188f, 0.28632f,  0.27128f,
     0.26327f,  0.25585f, 0.25151f, 0.25234f, 0.2515f,  0.25584f,  0.26325f,
     0.27127f,  0.28627f, 0.29189f, 0.28098f, 0.18013f, 0.082312f, 0.000000f},
    {0.000000f, 0.11865f, 0.22314f, 0.29977f, 0.32517f, 0.33282f, 0.32312f,
     0.31164f,  0.30095f, 0.2946f,  0.29542f, 0.29459f, 0.30094f, 0.31163f,
     0.32308f,  0.33259f, 0.32473f, 0.29967f, 0.22211f, 0.11774f, 0.000000f},
    {0.000000f, 0.15601f, 0.26339f, 0.30497f, 0.3472f,  0.38198f, 0.39609f,
     0.39135f,  0.3765f,  0.36616f, 0.36703f, 0.36615f, 0.37649f, 0.39123f,
     0.39574f,  0.3814f,  0.34627f, 0.30393f, 0.26322f, 0.15497f, 0.000000f},
    {0.000000f, 0.19222f, 0.23448f, 0.28578f, 0.34732f, 0.4169f,  0.48293f,
     0.51439f,  0.52067f, 0.52104f, 0.52661f, 0.52086f, 0.52026f, 0.51365f,
     0.48176f,  0.41543f, 0.34579f, 0.28436f, 0.23319f, 0.19202f, 0.000000f},
    {1.1102e-016f, 0.076479f, 0.15764f, 0.24801f, 0.34452f,  0.44874f,
     0.55712f,     0.67263f,  0.78467f, 0.89574f, 1.000000f, 0.89382f,
     0.78261f,     0.67046f,  0.55485f, 0.4464f,  0.34213f,  0.24558f,
     0.15519f,     0.074014f, 0.000000f}};

float map_5point1_rf[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0043772f,
     0.011962f, 0.018075f, 0.022264f, 0.035717f, 0.058204f, 0.083257f,
     0.10958f,  0.13592f,  0.052336f},
    {0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.0013084f, 0.011636f, 0.027472f, 0.049384f,
     0.070085f, 0.089694f, 0.10655f,   0.12342f,  0.12737f,  0.15705f,
     0.18623f,  0.16489f,  0.10973f},
    {0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.0038919f, 0.018492f, 0.041753f, 0.068513f, 0.1006f,
     0.12983f,  0.15652f,   0.18313f,  0.20135f,  0.21775f,  0.22851f,
     0.21738f,  0.20108f,   0.17363f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0038302f, 0.016973f, 0.040831f, 0.073199f, 0.10859f,  0.14876f,
     0.1852f,    0.21753f,  0.24734f,  0.26927f,  0.28776f,  0.27908f,
     0.25473f,   0.24451f,  0.24192f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0013625f,
     0.010822f, 0.031114f, 0.061436f, 0.10138f,  0.14831f,  0.19392f,
     0.2365f,   0.27257f,  0.30156f,  0.32564f,  0.33123f,  0.32934f,
     0.31761f,  0.29589f,  0.31565f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.00041878f,
     0.017789f, 0.0433f,   0.07868f,  0.12602f,  0.18248f,  0.23686f,
     0.2799f,   0.30936f,  0.33175f,  0.35421f,  0.37263f,  0.38012f,
     0.37444f,  0.35999f,  0.39234f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.01238f,  0.046242f, 0.085813f, 0.14312f,  0.21247f,  0.26716f,
     0.29661f,  0.31385f,  0.34119f,  0.3727f,   0.40155f,  0.42428f,
     0.43128f,  0.43048f,  0.47409f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0048489f, 0.032179f, 0.083684f, 0.14641f,  0.23272f,  0.27225f,
     0.28139f,   0.30767f,  0.33894f,  0.3788f,   0.4187f,   0.45626f,
     0.48466f,   0.49857f,  0.55339f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0029287f,
     0.015357f, 0.040874f, 0.082238f, 0.14702f,  0.23663f,  0.25012f,
     0.27481f,  0.30176f,  0.33418f,  0.37423f,  0.42403f,  0.4769f,
     0.52692f,  0.56555f,  0.63203f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0019397f, 0.021156f,
     0.051639f, 0.089163f, 0.13307f,  0.17997f,  0.22386f,   0.24772f,
     0.27249f,  0.30054f,  0.33231f,  0.37158f,  0.42577f,   0.49302f,
     0.56398f,  0.63586f,  0.70711f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.01438f, 0.049473f, 0.099723f,
     0.15348f,  0.20226f,  0.24098f,  0.24557f,  0.25321f, 0.27695f,  0.30342f,
     0.33559f,  0.37551f,  0.42626f,  0.49895f,  0.59175f, 0.69745f,  0.77384f},
    {0.000000f, 0.000000f, 0.000000f, 0.0023122f, 0.031384f, 0.081894f,
     0.14485f,  0.19907f,  0.24237f,  0.268f,     0.27012f,  0.27589f,
     0.28486f,  0.31064f,  0.34157f,  0.38293f,   0.43576f,  0.51188f,
     0.62473f,  0.75361f,  0.83195f},
    {0.000000f, 0.000000f, 0.000000f, 0.0075151f, 0.048878f, 0.11169f,
     0.17871f,  0.229f,    0.263f,    0.28867f,   0.29793f,  0.30177f,
     0.3099f,   0.32047f,  0.3505f,   0.39422f,   0.45043f,  0.53218f,
     0.66167f,  0.80779f,  0.87965f},
    {0.000000f, 0.000000f, 0.000000f, 0.014677f, 0.066587f, 0.13466f, 0.19976f,
     0.24081f,  0.2763f,   0.30555f,  0.32392f,  0.33349f,  0.34026f, 0.3499f,
     0.36625f,  0.41012f,  0.46596f,  0.55393f,  0.69668f,  0.85613f, 0.91914f},
    {0.000000f, 0.000000f, 0.000000f, 0.017689f, 0.075976f, 0.15229f, 0.19715f,
     0.24172f,  0.28192f,  0.31654f,  0.343f,    0.3639f,   0.37933f, 0.39305f,
     0.40957f,  0.42729f,  0.49385f,  0.58524f,  0.72145f,  0.8756f,  0.94832f},
    {0.000000f, 0.000000f, 0.000000f, 0.019339f, 0.081415f, 0.12939f, 0.18521f,
     0.2329f,   0.27908f,  0.31978f,  0.35395f,  0.38326f,  0.40917f, 0.43346f,
     0.45546f,  0.48528f,  0.5172f,   0.60794f,  0.76272f,  0.87113f, 0.96987f},
    {0.000000f, 0.000000f, 0.000000f, 0.016574f, 0.049892f, 0.094728f, 0.15233f,
     0.20846f,  0.26255f,  0.31088f,  0.35261f,  0.39169f,  0.42708f,  0.46137f,
     0.49449f,  0.53421f,  0.57711f,  0.6299f,   0.74014f,  0.85731f,  0.9845f},
    {0.000000f, 0.000000f, 0.000000f, 0.0025743f, 0.010122f, 0.048381f,
     0.095227f, 0.15539f,  0.22053f,  0.28038f,   0.33191f,  0.38291f,
     0.42927f,  0.47532f,  0.52386f,  0.57553f,   0.64546f,  0.68239f,
     0.71318f,  0.83679f,  0.99377f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0022432f,
     0.019725f, 0.067908f, 0.13152f,  0.19821f,  0.26356f,  0.3345f,
     0.39855f,  0.46338f,  0.53833f,  0.61802f,  0.68515f,  0.7397f,
     0.78158f,  0.8123f,   0.99846f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.14292f,
     0.27953f,  0.40639f,  0.52748f,  0.63323f,  0.72837f,  0.81116f,
     0.88423f,  0.94629f,  1.000000f}};

float map_5point1_ls[21][21] = {
    {1.000000f, 0.99863f,  0.99396f,     0.98481f, 0.9703f,  0.94888f,
     0.91914f,  0.88048f,  0.83195f,     0.77384f, 0.70834f, 0.63338f,
     0.55484f,  0.47562f,  0.39394f,     0.3173f,  0.24362f, 0.17537f,
     0.11147f,  0.054079f, -7.8496e-017f},
    {0.99854f, 0.94804f, 0.94647f, 0.94043f, 0.92966f, 0.91177f, 0.87898f,
     0.82659f, 0.76643f, 0.70248f, 0.63602f, 0.56664f, 0.49969f, 0.43164f,
     0.36121f, 0.29703f, 0.24559f, 0.20208f, 0.16581f, 0.13592f, 0.000000f},
    {0.99373f, 0.94619f, 0.89929f, 0.8973f,  0.89f,    0.84522f, 0.80369f,
     0.75196f, 0.69549f, 0.64182f, 0.59149f, 0.53909f, 0.48676f, 0.43211f,
     0.3753f,  0.31848f, 0.25563f, 0.21817f, 0.18628f, 0.11031f, 0.000000f},
    {0.98443f, 0.94057f, 0.89693f, 0.84178f, 0.80673f, 0.76938f,  0.72295f,
     0.68173f, 0.63988f, 0.59999f, 0.56152f, 0.51902f, 0.47535f,  0.42864f,
     0.38061f, 0.33006f, 0.27965f, 0.22857f, 0.15778f, 0.083896f, 0.000000f},
    {0.96987f, 0.92924f, 0.89008f, 0.8064f,  0.72353f, 0.68753f,  0.64727f,
     0.61961f, 0.59007f, 0.5611f,  0.53236f, 0.49762f, 0.45999f,  0.41905f,
     0.37687f, 0.33185f, 0.28785f, 0.21842f, 0.12802f, 0.058746f, 0.000000f},
    {0.94832f, 0.91132f, 0.84488f, 0.76916f, 0.6876f,  0.60199f, 0.57793f,
     0.55557f, 0.53786f, 0.52026f, 0.49866f, 0.47305f, 0.4406f,  0.40425f,
     0.36538f, 0.32707f, 0.2697f,  0.20197f, 0.12403f, 0.03616f, 0.000000f},
    {0.91914f, 0.87839f, 0.80323f, 0.72262f, 0.64697f, 0.57779f,  0.51599f,
     0.49381f, 0.48147f, 0.4732f,  0.46311f, 0.44521f, 0.41747f,  0.38486f,
     0.34957f, 0.30247f, 0.24789f, 0.18361f, 0.10709f, 0.022585f, 0.000000f},
    {0.87965f, 0.82586f, 0.75136f, 0.68116f, 0.61943f,  0.55563f,  0.49394f,
     0.45149f, 0.43778f, 0.42773f, 0.42381f, 0.41464f,  0.39077f,  0.36007f,
     0.32202f, 0.27305f, 0.21805f, 0.15706f, 0.090176f, 0.018356f, 0.000000f},
    {0.83195f, 0.76558f, 0.69482f, 0.63955f, 0.58992f,  0.53794f,  0.48142f,
     0.43767f, 0.40132f, 0.39038f, 0.38425f, 0.38246f,  0.35885f,  0.3262f,
     0.2847f,  0.23683f, 0.18569f, 0.13031f, 0.070512f, 0.012179f, 0.000000f},
    {0.77494f, 0.70182f, 0.64105f, 0.59937f, 0.5609f,   0.52028f,   0.47314f,
     0.42777f, 0.39034f, 0.35673f, 0.34932f, 0.34449f,  0.31565f,   0.27779f,
     0.23728f, 0.19424f, 0.14921f, 0.10103f, 0.049741f, 0.0045097f, 0.000000f},
    {0.70711f,  0.63577f,      0.59134f, 0.56143f, 0.53234f, 0.49869f,
     0.46315f,  0.42387f,      0.38431f, 0.34937f, 0.3185f,  0.28163f,
     0.2449f,   0.21252f,      0.18253f, 0.14834f, 0.1086f,  0.068513f,
     0.027472f, -8.5322e-019f, 0.000000f},
    {0.63338f, 0.56555f, 0.53856f,  0.51865f,  0.49722f,  0.47263f,  0.44507f,
     0.41451f, 0.38241f, 0.34452f,  0.2816f,   0.24145f,  0.18988f,  0.15379f,
     0.12638f, 0.10174f, 0.073541f, 0.042039f, 0.011806f, 0.000000f, 0.000000f},
    {0.55339f,   0.49871f,  0.48607f,  0.47475f,  0.45953f,  0.44013f,
     0.41724f,   0.39065f,  0.35885f,  0.31539f,  0.24485f,  0.1898f,
     0.16119f,   0.11535f,  0.083376f, 0.061737f, 0.041097f, 0.018696f,
     0.0013628f, 0.000000f, 0.000000f},
    {0.47409f,  0.43048f,  0.43138f,  0.42817f, 0.41859f,  0.40381f,
     0.38442f,  0.36003f,  0.32583f,  0.27748f, 0.21245f,  0.15351f,
     0.11527f,  0.092466f, 0.055926f, 0.03134f, 0.017152f, 0.0039822f,
     0.000000f, 0.000000f, 0.000000f},
    {0.39234f,  0.35999f,  0.37455f, 0.38033f,  0.37646f,   0.36503f,
     0.34948f,  0.32174f,  0.28429f, 0.23686f,  0.18246f,   0.12608f,
     0.083197f, 0.055812f, 0.03557f, 0.011379f, 0.0039191f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.31565f,  0.29607f,  0.31773f,  0.32943f,  0.33124f,  0.32696f,
     0.30198f,  0.27263f,  0.2365f,   0.19392f,  0.14828f,  0.10138f,
     0.061436f, 0.031114f, 0.011267f, 0.002725f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.24192f,  0.24451f,  0.25473f,   0.27908f,  0.28772f,  0.26927f,
     0.24734f,  0.21753f,  0.18526f,   0.14882f,  0.10856f,  0.073199f,
     0.040831f, 0.01704f,  0.0038302f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.17365f,  0.20108f,   0.21738f,  0.22846f,  0.21775f,  0.20135f,
     0.18335f,  0.15652f,   0.12991f,  0.1006f,   0.068474f, 0.041753f,
     0.018492f, 0.0038919f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.10973f,   0.16489f,  0.18616f,  0.15705f,  0.12737f,  0.12342f,
     0.10655f,   0.089694f, 0.070085f, 0.049384f, 0.027446f, 0.011636f,
     0.0013628f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.052332f, 0.13583f,  0.10958f,  0.083257f,  0.058204f, 0.035717f,
     0.022438f, 0.018227f, 0.011962f, 0.0043772f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

float map_5point1_rs[21][21] = {
    {-7.8496e-017f, 0.052336f, 0.10973f, 0.17365f, 0.24192f, 0.31565f,
     0.39394f,      0.47409f,  0.55484f, 0.63338f, 0.70587f, 0.77384f,
     0.83195f,      0.87965f,  0.91914f, 0.94832f, 0.96987f, 0.9845f,
     0.99377f,      0.99854f,  1.000000f},
    {0.000000f, 0.13583f, 0.16489f, 0.20208f, 0.24451f, 0.29589f, 0.35999f,
     0.43048f,  0.49857f, 0.56633f, 0.63558f, 0.70182f, 0.76558f, 0.82586f,
     0.87839f,  0.91132f, 0.92934f, 0.94057f, 0.94637f, 0.94804f, 0.99863f},
    {0.000000f, 0.11031f, 0.18615f, 0.21738f, 0.25552f, 0.31761f, 0.37444f,
     0.43128f,  0.48597f, 0.53856f, 0.59121f, 0.64167f, 0.69482f, 0.75136f,
     0.80323f,  0.84488f, 0.89008f, 0.89725f, 0.89927f, 0.94647f, 0.99396f},
    {0.000000f, 0.083257f, 0.15778f, 0.22845f, 0.27908f, 0.32934f, 0.38061f,
     0.42817f,  0.47475f,  0.51865f, 0.56131f, 0.59998f, 0.63948f, 0.6818f,
     0.72306f,  0.76916f,  0.80688f, 0.84174f, 0.8973f,  0.94077f, 0.98473f},
    {0.000000f, 0.058746f, 0.12737f, 0.2183f,  0.28772f, 0.33167f, 0.37646f,
     0.41852f,  0.45953f,  0.49722f, 0.53221f, 0.56083f, 0.58986f, 0.61943f,
     0.64753f,  0.6876f,   0.72348f, 0.80673f, 0.89031f, 0.92966f, 0.9703f},
    {0.000000f, 0.035717f, 0.12342f, 0.20135f, 0.26927f, 0.32696f, 0.36503f,
     0.40381f,  0.44057f,  0.47309f, 0.49858f, 0.52028f, 0.53794f, 0.55557f,
     0.57829f,  0.60191f,  0.688f,   0.76938f, 0.84522f, 0.91177f, 0.94888f},
    {0.000000f, 0.022264f, 0.10655f, 0.18361f, 0.24774f, 0.30233f, 0.34948f,
     0.3848f,   0.41719f,  0.44502f, 0.46308f, 0.47314f, 0.48142f, 0.49394f,
     0.51592f,  0.57793f,  0.64727f, 0.72306f, 0.80369f, 0.87898f, 0.91982f},
    {0.000000f, 0.018075f, 0.089694f, 0.15698f, 0.21753f, 0.27257f, 0.32174f,
     0.36002f,  0.39065f,  0.41451f,  0.4238f,  0.42773f, 0.43804f, 0.45143f,
     0.49424f,  0.55557f,  0.61961f,  0.68173f, 0.75196f, 0.82659f, 0.88048f},
    {0.000000f, 0.011962f, 0.070085f, 0.12983f, 0.1852f,  0.2365f,  0.28429f,
     0.32614f,  0.35884f,  0.38237f,  0.38425f, 0.39034f, 0.40127f, 0.43778f,
     0.48142f,  0.53827f,  0.59007f,  0.63988f, 0.69549f, 0.76643f, 0.83292f},
    {0.000000f, 0.0043772f, 0.049741f, 0.10103f, 0.14876f, 0.19392f, 0.23686f,
     0.27743f,  0.31539f,   0.34452f,  0.34932f, 0.35669f, 0.39034f, 0.42773f,
     0.47315f,  0.52061f,   0.5611f,   0.59999f, 0.64182f, 0.7028f,  0.77494f},
    {0.000000f, -8.5322e-019f, 0.027447f, 0.068465f, 0.10853f, 0.14825f,
     0.18244f,  0.21244f,      0.24485f,  0.28161f,  0.31849f, 0.34932f,
     0.38425f,  0.42381f,      0.46314f,  0.49869f,  0.53239f, 0.56152f,
     0.59147f,  0.63596f,      0.70711f},
    {0.000000f, 0.000000f, 0.011636f, 0.041753f, 0.073199f, 0.1017f,  0.12603f,
     0.15351f,  0.18976f,  0.24145f,  0.28164f,  0.34451f,  0.38246f, 0.41464f,
     0.44521f,  0.47305f,  0.49762f,  0.51919f,  0.5393f,   0.56664f, 0.63338f},
    {0.000000f, 0.000000f, 0.0013084f, 0.018492f, 0.040831f, 0.061737f,
     0.083146f, 0.11527f,  0.16121f,   0.18988f,  0.2449f,   0.31565f,
     0.35887f,  0.39092f,  0.41747f,   0.4406f,   0.45999f,  0.47535f,
     0.48676f,  0.49969f,  0.55484f},
    {0.000000f, 0.000000f, 0.000000f, 0.0038919f, 0.016973f, 0.031114f,
     0.056058f, 0.092505f, 0.11557f,  0.15374f,   0.21251f,  0.27779f,
     0.3262f,   0.36008f,  0.38486f,  0.40425f,   0.41905f,  0.42882f,
     0.43211f,  0.43164f,  0.47562f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0038302f, 0.011267f,
     0.0356f,   0.055926f, 0.083376f, 0.12638f,  0.18252f,   0.23728f,
     0.2847f,   0.32214f,  0.34955f,  0.36552f,  0.37704f,   0.38081f,
     0.3753f,   0.36121f,  0.39394f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0027341f,
     0.011405f, 0.03134f,  0.061737f, 0.10174f,  0.14834f,  0.19436f,
     0.23696f,  0.27305f,  0.30247f,  0.32704f,  0.33185f,  0.33006f,
     0.31848f,  0.29703f,  0.3173f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0039191f, 0.017152f, 0.041097f, 0.073541f, 0.10862f,  0.14921f,
     0.18569f,   0.21805f,  0.24789f,  0.26986f,  0.28782f,  0.27982f,
     0.25563f,   0.24559f,  0.24362f},
    {0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.0039822f, 0.018696f, 0.042039f, 0.068554f, 0.10103f,
     0.13031f,  0.15706f,   0.1837f,   0.20197f,  0.21842f,  0.22858f,
     0.21822f,  0.20208f,   0.17537f},
    {0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.0013628f, 0.011806f, 0.027511f, 0.049741f,
     0.070512f, 0.090176f, 0.10709f,   0.12403f,  0.12802f,  0.15778f,
     0.1863f,   0.16581f,  0.11147f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,     0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, -8.5322e-019f, 0.0045097f,
     0.012179f, 0.018356f, 0.022585f, 0.03616f,  0.058746f,     0.083896f,
     0.11031f,  0.136f,    0.054075f},
    {0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, -7.8496e-017f}};

float map_7point1_ang[] = {-27, 0, 27, -95, 95, -142, 142};
float map_7point1_xsf[] = {-1, 0, 1, -1, 1, -1, 1};
float map_7point1_ysf[] = {1, 1, 1, 0, 0, -1, -1};
channel_id map_7point1_id[] = {
    ci_front_left,        ci_front_center, ci_front_right, ci_side_center_left,
    ci_side_center_right, ci_back_left,    ci_back_right,  ci_lfe};

float map_7point1_lf[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 9.4126e-019f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f,  0.0025743f, 0.016552f, 0.019339f, 0.017689f,
     0.014677f, 0.0075151f, 0.0023122f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.000000f, 0.000000f, 0.010122f, 0.049892f, 0.081385f,  0.075976f,
     0.066587f, 0.048878f, 0.031384f, 0.01438f,  0.0019269f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,  0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.0022432f, 0.048381f, 0.094728f, 0.12939f,  0.15091f,
     0.13421f,  0.11169f,   0.081894f, 0.049473f, 0.021188f, 0.0029287f,
     0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.000000f,  0.019725f, 0.095227f, 0.15233f,  0.18129f,  0.18619f,
     0.18195f,   0.1662f,   0.14038f,  0.099716f, 0.051668f, 0.015357f,
     0.0004627f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.000000f,  0.067908f, 0.15539f,  0.20448f,  0.21574f,  0.21038f,
     0.19727f,   0.18275f,  0.16961f,  0.14309f,  0.089211f, 0.030602f,
     0.0029125f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.000000f,  0.13152f,   0.21916f,    0.24385f,  0.23799f,  0.22019f,
     0.19777f,   0.1798f,    0.16484f,    0.15891f,  0.12092f,  0.0391f,
     0.0061765f, 0.0028379f, 0.00043186f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f,  0.000000f},
    {0.000000f, 0.19821f,  0.26858f,  0.26884f,   0.24624f,  0.21773f,
     0.19453f,  0.1758f,   0.16036f,  0.14653f,   0.13495f,  0.052607f,
     0.038854f, 0.030373f, 0.015188f, 0.0028496f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {8.6596e-017f, 0.26351f,  0.30441f,  0.28405f,  0.24723f,   0.21577f,
     0.19296f,     0.17452f,  0.15823f,  0.14384f,  0.13114f,   0.13492f,
     0.12086f,     0.089089f, 0.051572f, 0.021112f, 0.0019269f, 0.000000f,
     0.000000f,    0.000000f, 0.000000f},
    {0.14292f,  0.32999f,  0.33317f,  0.29065f,  0.24843f, 0.21902f,
     0.19594f,  0.17746f,  0.1625f,   0.14962f,  0.14386f, 0.14651f,
     0.15886f,  0.14285f,  0.099312f, 0.049149f, 0.01419f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.27953f,  0.38637f,  0.35876f, 0.29909f,  0.25487f,  0.22426f,
     0.20041f,  0.18277f,  0.16832f, 0.16249f,  0.15824f,  0.16036f,
     0.16482f,  0.16948f,  0.14005f, 0.081488f, 0.031102f, 0.0022352f,
     0.000000f, 0.000000f, 0.000000f},
    {0.40639f,  0.44503f,  0.38515f, 0.31183f, 0.26428f,  0.23169f,
     0.20647f,  0.18936f,  0.18276f, 0.17745f, 0.17453f,  0.1758f,
     0.17979f,  0.18273f,  0.16592f, 0.11122f, 0.048526f, 0.0073556f,
     0.000000f, 0.000000f, 0.000000f},
    {0.52748f, 0.51574f, 0.41678f,  0.32546f,  0.27415f,  0.24175f,  0.21641f,
     0.20646f, 0.2004f,  0.19593f,  0.19298f,  0.19453f,  0.19777f,  0.19716f,
     0.18189f, 0.13374f, 0.066173f, 0.014462f, 0.000000f, 0.000000f, 0.000000f},
    {0.63323f, 0.58186f, 0.4515f,   0.34992f,  0.2914f,   0.25248f,  0.24174f,
     0.23169f, 0.22425f, 0.219f,    0.21579f,  0.21773f,  0.22013f,  0.21018f,
     0.18585f, 0.15082f, 0.075526f, 0.017441f, 0.000000f, 0.000000f, 0.000000f},
    {0.72837f, 0.62641f, 0.51744f,  0.37803f,  0.31074f,  0.29139f,  0.27414f,
     0.26427f, 0.25485f, 0.24842f,  0.24726f,  0.24619f,  0.23779f,  0.2154f,
     0.18082f, 0.12881f, 0.081296f, 0.019071f, 0.000000f, 0.000000f, 0.000000f},
    {0.81116f, 0.6558f,  0.5246f,  0.41789f,  0.37802f,  0.34991f,  0.32545f,
     0.31182f, 0.29908f, 0.29063f, 0.28406f,  0.26859f,  0.24346f,  0.20392f,
     0.15167f, 0.09417f, 0.04946f, 0.016531f, 0.000000f, 0.000000f, 0.000000f},
    {0.88423f,  0.67127f,  0.52691f,  0.5245f,   0.51721f,   0.45136f,
     0.41661f,  0.38495f,  0.35851f,  0.33283f,  0.30436f,   0.26801f,
     0.21844f,  0.15464f,  0.094607f, 0.047925f, 0.0098814f, 0.0024671f,
     0.000000f, 0.000000f, 0.000000f},
    {0.94622f,  0.67633f,  0.67099f,  0.65523f,   0.62554f,  0.58081f,
     0.51465f,  0.44406f,  0.38544f,  0.32902f,   0.26339f,  0.19725f,
     0.13069f,  0.067274f, 0.019339f, 0.0021311f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {1.000000f, 0.94446f,  0.8823f,   0.80914f,  0.72626f,  0.63102f,
     0.52519f,  0.40402f,  0.27711f,  0.14046f,  0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

float map_7point1_cf[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f,   0.000000f, 0.000000f,   0.000000f, 0.000000f, 0.0019269f,
     0.00062925f, 0.000000f, 0.000000f,   0.000000f, 0.000000f, 0.000000f,
     0.000000f,   0.000000f, 0.00059225f, 0.001914f, 0.000000f, 0.000000f,
     0.000000f,   0.000000f, 0.000000f},
    {0.000000f,  0.000000f, 0.000000f,  0.000000f,    0.0055425f, 0.0155f,
     0.025167f,  0.017695f, 0.0063155f, 1.0116e-005f, 0.000000f,  0.000000f,
     0.0062031f, 0.017508f, 0.025125f,  0.015305f,    0.0054168f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.0056317f, 0.024256f,    0.044322f,
     0.061583f, 0.065405f, 0.041656f, 0.014688f,  4.0817e-019f, 0.014527f,
     0.041389f, 0.065342f, 0.061236f, 0.044002f,  0.024003f,    0.005504f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f,  0.000000f, 0.0019274f, 0.02644f,  0.05812f,  0.08731f,
     0.11105f,   0.11767f,  0.10963f,   0.061306f, 0.017226f, 0.061006f,
     0.10958f,   0.11735f,  0.11066f,   0.086884f, 0.057744f, 0.026151f,
     0.0018503f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.016697f, 0.059451f, 0.104f,    0.13974f,
     0.15702f,  0.15962f,  0.15223f,  0.13355f,  0.063692f, 0.13353f,
     0.15211f,  0.15945f,  0.15675f,  0.13934f,  0.10352f,  0.059047f,
     0.016456f, 0.000000f, 0.000000f},
    {0.000000f, 1.2068e-018f, 0.038851f, 0.096919f, 0.15087f, 0.17987f,
     0.18511f,  0.17445f,     0.15817f,  0.14379f,  0.13384f, 0.14378f,
     0.15816f,  0.17444f,     0.18509f,  0.17981f,  0.15076f, 0.096821f,
     0.038797f, 0.000000f,    0.000000f},
    {0.000000f, 0.0063777f, 0.070344f, 0.14288f, 0.19068f, 0.2049f,
     0.19453f,  0.1758f,    0.16036f,  0.14645f, 0.14681f, 0.14646f,
     0.16036f,  0.1758f,    0.19453f,  0.20473f, 0.19031f, 0.14227f,
     0.06984f,  0.0061903f, 0.000000f},
    {0.000000f, 0.017224f, 0.099719f, 0.18101f, 0.21822f, 0.2193f,
     0.19777f,  0.17979f,  0.16475f,  0.16187f, 0.16149f, 0.16187f,
     0.16477f,  0.1798f,   0.19777f,  0.21922f, 0.21792f, 0.18045f,
     0.099116f, 0.016918f, 0.000000f},
    {0.000000f, 0.02596f, 0.12753f, 0.21148f, 0.23925f, 0.22819f,  0.20284f,
     0.18535f,  0.18085f, 0.17814f, 0.17812f, 0.17814f, 0.18084f,  0.18536f,
     0.20284f,  0.22818f, 0.23901f, 0.21095f, 0.12685f, 0.025562f, 0.000000f},
    {0.000000f, 0.03194f, 0.15144f, 0.23904f, 0.2564f,  0.23733f,  0.21182f,
     0.20371f,  0.19964f, 0.19751f, 0.19694f, 0.1975f,  0.19963f,  0.20369f,
     0.21184f,  0.23733f, 0.25621f, 0.23853f, 0.15068f, 0.031485f, 0.000000f},
    {0.000000f, 0.051138f, 0.17541f, 0.26062f, 0.27419f, 0.24713f,  0.23812f,
     0.22985f,  0.2244f,   0.22133f, 0.22022f, 0.22132f, 0.22439f,  0.22984f,
     0.2381f,   0.24715f,  0.274f,   0.26009f, 0.17455f, 0.050511f, 0.000000f},
    {0.000000f, 0.08308f, 0.18105f, 0.28155f, 0.29188f, 0.28632f,  0.27128f,
     0.26327f,  0.25585f, 0.25151f, 0.25234f, 0.2515f,  0.25584f,  0.26325f,
     0.27127f,  0.28627f, 0.29189f, 0.28098f, 0.18013f, 0.082312f, 0.000000f},
    {0.000000f, 0.11865f, 0.22314f, 0.29977f, 0.32517f, 0.33282f, 0.32312f,
     0.31164f,  0.30095f, 0.2946f,  0.29542f, 0.29459f, 0.30094f, 0.31163f,
     0.32308f,  0.33259f, 0.32473f, 0.29967f, 0.22211f, 0.11774f, 0.000000f},
    {0.000000f, 0.15601f, 0.26339f, 0.30497f, 0.3472f,  0.38198f, 0.39609f,
     0.39135f,  0.3765f,  0.36616f, 0.36703f, 0.36615f, 0.37649f, 0.39123f,
     0.39574f,  0.3814f,  0.34627f, 0.30393f, 0.26322f, 0.15497f, 0.000000f},
    {0.000000f, 0.19222f, 0.23448f, 0.28578f, 0.34732f, 0.4169f,  0.48293f,
     0.51439f,  0.52067f, 0.52104f, 0.52661f, 0.52086f, 0.52026f, 0.51365f,
     0.48176f,  0.41543f, 0.34579f, 0.28436f, 0.23319f, 0.19202f, 0.000000f},
    {1.1102e-016f, 0.076479f, 0.15764f, 0.24801f, 0.34452f,  0.44874f,
     0.55712f,     0.67263f,  0.78467f, 0.89574f, 1.000000f, 0.89382f,
     0.78261f,     0.67046f,  0.55485f, 0.4464f,  0.34213f,  0.24558f,
     0.15519f,     0.074014f, 0.000000f}};

float map_7point1_rf[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0022352f, 0.0073556f, 0.014462f, 0.017441f, 0.019071f, 0.016531f,
     0.0024671f, 0.000000f,  0.000000f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,  0.000000f,
     0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.0019269f, 0.01419f,
     0.031102f,  0.048526f, 0.066173f, 0.075526f, 0.081297f,  0.04946f,
     0.0098814f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f,  0.000000f, 0.000000f,  0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f, 0.0028496f, 0.021112f, 0.049149f,
     0.081488f, 0.11122f,   0.13374f,  0.15081f,   0.12881f,  0.09417f,
     0.047925f, 0.0021311f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f,   0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.00043186f, 0.015188f, 0.051545f, 0.099312f,
     0.14005f,  0.16592f,  0.1819f,     0.18585f,  0.18082f,  0.15167f,
     0.094607f, 0.019339f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.0028379f, 0.030373f, 0.089057f, 0.14285f,
     0.16948f,  0.18273f,  0.19716f,   0.21018f,  0.2154f,   0.20392f,
     0.15464f,  0.067274f, 0.000000f},
    {0.000000f,  0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.0004627f, 0.0029125f, 0.0061679f, 0.038854f, 0.12083f,  0.15886f,
     0.16483f,   0.17979f,   0.19777f,   0.22013f,  0.23779f,  0.24346f,
     0.21844f,   0.13069f,   0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0029287f,
     0.015357f, 0.030602f, 0.0391f,   0.052555f, 0.13491f,  0.14652f,
     0.16036f,  0.1758f,   0.19453f,  0.21773f,  0.24619f,  0.26859f,
     0.26801f,  0.19725f,  0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0019397f, 0.021156f,
     0.051639f, 0.089163f, 0.1209f,   0.13493f,  0.13114f,   0.14385f,
     0.15824f,  0.17453f,  0.19297f,  0.21578f,  0.24725f,   0.28402f,
     0.30431f,  0.2633f,   0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.01438f, 0.049473f, 0.099716f,
     0.14309f,  0.15891f,  0.1465f,   0.14385f,  0.14961f, 0.16249f,  0.17745f,
     0.19593f,  0.219f,    0.24842f,  0.29063f,  0.33283f, 0.32902f,  0.14046f},
    {0.000000f, 0.000000f, 0.000000f, 0.0023122f, 0.031384f, 0.081894f,
     0.14038f,  0.16961f,  0.16482f,  0.16036f,   0.15824f,  0.1625f,
     0.16831f,  0.18276f,  0.2004f,   0.22425f,   0.25485f,  0.29908f,
     0.35851f,  0.38544f,  0.27711f},
    {0.000000f, 0.000000f, 0.000000f, 0.0075151f, 0.048878f, 0.11169f,
     0.1662f,   0.18272f,  0.1798f,   0.1758f,    0.17453f,  0.17746f,
     0.18277f,  0.18935f,  0.20646f,  0.23169f,   0.26427f,  0.31182f,
     0.38495f,  0.44406f,  0.40402f},
    {0.000000f, 0.000000f, 0.000000f, 0.014677f, 0.066587f, 0.13421f, 0.18194f,
     0.19727f,  0.19777f,  0.19453f,  0.19297f,  0.19594f,  0.20041f, 0.20647f,
     0.2164f,   0.24174f,  0.27414f,  0.32545f,  0.41661f,  0.51465f, 0.52519f},
    {0.000000f, 0.000000f, 0.000000f, 0.017689f, 0.075976f, 0.15092f, 0.18619f,
     0.21038f,  0.22019f,  0.21773f,  0.21578f,  0.21902f,  0.22426f, 0.23169f,
     0.24175f,  0.25247f,  0.29139f,  0.34991f,  0.45136f,  0.58081f, 0.63102f},
    {0.000000f, 0.000000f, 0.000000f, 0.019339f, 0.081415f, 0.12939f, 0.18129f,
     0.21574f,  0.23799f,  0.24624f,  0.24725f,  0.24843f,  0.25487f, 0.26428f,
     0.27415f,  0.2914f,   0.31073f,  0.37802f,  0.51721f,  0.62554f, 0.72626f},
    {0.000000f, 0.000000f, 0.000000f, 0.016574f, 0.049892f, 0.094728f,
     0.15233f,  0.20448f,  0.24385f,  0.26884f,  0.28405f,  0.29065f,
     0.29909f,  0.31183f,  0.32546f,  0.34992f,  0.37803f,  0.41787f,
     0.5245f,   0.65523f,  0.80914f},
    {0.000000f, 0.000000f, 0.000000f, 0.0025743f, 0.010122f, 0.048381f,
     0.095227f, 0.15539f,  0.21916f,  0.26858f,   0.3044f,   0.33317f,
     0.35876f,  0.38515f,  0.41678f,  0.4515f,    0.51744f,  0.5246f,
     0.52688f,  0.67099f,  0.8823f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0022432f,
     0.019725f, 0.067908f, 0.13152f,  0.19821f,  0.26356f,  0.32999f,
     0.38637f,  0.44503f,  0.51574f,  0.58186f,  0.62641f,  0.6558f,
     0.67127f,  0.6763f,   0.94439f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.14292f,
     0.27953f,  0.40639f,  0.52748f,  0.63323f,  0.72837f,  0.81116f,
     0.88423f,  0.94629f,  1.000000f}};

float map_7point1_lsm[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.076479f, 0.1924f,   0.15601f,  0.11842f,  0.08308f,  0.051138f,
     0.03194f,  0.02596f,  0.017224f, 0.006217f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.15701f,   0.23422f,  0.26354f,  0.22314f,  0.18089f,  0.17541f,
     0.15144f,   0.12753f,  0.099719f, 0.070344f, 0.038959f, 0.016585f,
     0.0019274f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.24799f,  0.28578f,   0.30478f,  0.2999f,   0.28155f,  0.26062f,
     0.23875f,  0.21148f,   0.18101f,  0.14288f,  0.097017f, 0.059361f,
     0.02644f,  0.0055357f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.34452f,  0.34709f,  0.3472f,    0.32503f,  0.29199f,  0.2741f,
     0.2564f,   0.23925f,  0.21822f,   0.19068f,  0.15101f,  0.104f,
     0.05812f,  0.024256f, 0.0054585f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.44874f,  0.4169f,   0.38198f,  0.33282f,   0.28632f,  0.24721f,
     0.23733f,  0.22819f,  0.21923f,  0.20483f,   0.17996f,  0.13974f,
     0.08731f,  0.044322f, 0.015426f, 0.0019269f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.55712f,  0.48293f,  0.39609f,  0.32283f,    0.2712f,   0.23804f,
     0.21189f,  0.20278f,  0.19777f,  0.19453f,    0.18519f,  0.15702f,
     0.11105f,  0.061583f, 0.025231f, 0.00062925f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.67263f,  0.51439f,  0.39135f,  0.31154f,  0.26327f,  0.22985f,
     0.20371f,  0.18541f,  0.17979f,  0.1758f,   0.17449f,  0.15962f,
     0.11761f,  0.06551f,  0.017632f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.78467f,  0.52067f,  0.3765f,    0.30095f,  0.25585f,  0.2244f,
     0.19964f,  0.1808f,   0.16481f,   0.16036f,  0.15821f,  0.15223f,
     0.10975f,  0.041656f, 0.0063155f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.89382f,  0.52104f,  0.36605f,     0.29451f,  0.25151f,  0.22133f,
     0.19751f,  0.17814f,  0.16187f,     0.14649f,  0.14382f,  0.13363f,
     0.061306f, 0.014688f, 1.0116e-005f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {1.000000f, 0.52679f,  0.36715f,  0.29551f,  0.25242f,  0.22029f,
     0.19701f,  0.17818f,  0.16155f,  0.14686f,  0.1311f,   0.063705f,
     0.017218f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.89382f,  0.52086f,  0.36615f,  0.29459f,  0.2515f,   0.22126f,
     0.1975f,   0.17814f,  0.16187f,  0.14649f,  0.14382f,  0.13358f,
     0.061006f, 0.014527f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.78261f,  0.52026f,  0.37649f,   0.30094f,  0.25584f,  0.22432f,
     0.19963f,  0.18084f,  0.1648f,    0.16036f,  0.1582f,   0.15211f,
     0.10961f,  0.041389f, 0.0062031f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.67046f,  0.51365f,  0.39123f,  0.31163f,  0.26325f,  0.22984f,
     0.20363f,  0.1854f,   0.17974f,  0.1758f,   0.17448f,  0.15945f,
     0.11735f,  0.065362f, 0.017508f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.55485f,  0.48176f,  0.39574f,  0.32282f,    0.27127f,  0.2381f,
     0.21189f,  0.20284f,  0.19777f,  0.19453f,    0.18513f,  0.15675f,
     0.11066f,  0.061236f, 0.025146f, 0.00059225f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.4464f,   0.41543f,  0.3814f,   0.33259f,   0.28621f,  0.2472f,
     0.23726f,  0.22818f,  0.21922f,  0.20473f,   0.17984f,  0.13934f,
     0.086884f, 0.044002f, 0.015305f, 0.0019269f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.34213f,  0.34579f,  0.34627f,   0.32473f,  0.29192f,  0.274f,
     0.25621f,  0.23901f,  0.21792f,   0.19031f,  0.1508f,   0.10352f,
     0.057744f, 0.024003f, 0.0054168f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.24558f,  0.28436f,  0.30393f,  0.29971f,  0.28098f,  0.26009f,
     0.23836f,  0.21095f,  0.18045f,  0.14227f,  0.096837f, 0.059047f,
     0.026151f, 0.005504f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.15519f,   0.23319f,  0.26327f,  0.22211f,  0.18013f,  0.17455f,
     0.15068f,   0.12685f,  0.099116f, 0.06984f,  0.038815f, 0.016456f,
     0.0018503f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.074009f, 0.19209f,  0.15497f,  0.11774f,   0.082312f, 0.050511f,
     0.031485f, 0.025562f, 0.016918f, 0.0061903f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

float map_7point1_rsm[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0061903f,
     0.016918f, 0.025562f, 0.031485f, 0.050511f, 0.082312f, 0.11774f,
     0.15497f,  0.19222f,  0.074014f},
    {0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.0018503f, 0.016456f, 0.038851f, 0.06984f,
     0.099116f, 0.12685f,  0.15068f,   0.17455f,  0.18013f,  0.22211f,
     0.26337f,  0.23319f,  0.15519f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.005504f, 0.026151f, 0.059047f, 0.096892f, 0.14227f,
     0.18045f,  0.21095f,  0.23853f,  0.26009f,  0.28098f,  0.29979f,
     0.30393f,  0.28436f,  0.24556f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0054168f, 0.024003f, 0.057744f, 0.10352f,  0.15084f,  0.19031f,
     0.21792f,   0.23901f,  0.25621f,  0.274f,    0.29198f,  0.32473f,
     0.34627f,   0.34579f,  0.34213f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0019269f,
     0.015305f, 0.044002f, 0.086884f, 0.13934f,  0.17988f,  0.20473f,
     0.21922f,  0.22818f,  0.23733f,  0.24725f,  0.28627f,  0.33259f,
     0.3814f,   0.41543f,  0.4464f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.00059225f,
     0.025157f, 0.061236f, 0.11066f,  0.15675f,  0.18518f,  0.19453f,
     0.19777f,  0.20284f,  0.21193f,  0.2381f,   0.27127f,  0.32308f,
     0.39574f,  0.48176f,  0.55485f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.017508f, 0.065396f, 0.11735f,  0.15945f,  0.17454f,  0.1758f,
     0.1798f,   0.18544f,  0.20369f,  0.22984f,  0.26325f,  0.31163f,
     0.39123f,  0.51365f,  0.67046f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0062031f, 0.041389f, 0.10962f,  0.15211f,  0.15825f,  0.16036f,
     0.16483f,   0.18084f,  0.19963f,  0.22439f,  0.25584f,  0.30094f,
     0.37649f,   0.52026f,  0.78261f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.014527f, 0.061006f, 0.13359f,  0.14386f,  0.14652f,
     0.16187f,  0.17814f,  0.1975f,   0.22132f,  0.2515f,   0.29459f,
     0.36615f,  0.52086f,  0.89382f},
    {0.000000f, 0.000000f,     0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, -4.0817e-019f, 0.017202f, 0.06369f,  0.13113f,  0.14689f,
     0.16158f,  0.17821f,      0.19705f,  0.22033f,  0.25247f,  0.29557f,
     0.36722f,  0.52689f,      1.000000f},
    {0.000000f,    0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     1.0116e-005f, 0.014688f, 0.061306f, 0.13361f,  0.14385f,  0.14651f,
     0.16187f,     0.17814f,  0.19751f,  0.22133f,  0.25151f,  0.2946f,
     0.36616f,     0.52104f,  0.89574f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0063155f, 0.041656f, 0.10967f,  0.15223f,  0.15823f,  0.16036f,
     0.16482f,   0.18085f,  0.19964f,  0.2244f,   0.25585f,  0.30095f,
     0.3765f,    0.52067f,  0.78467f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.017695f, 0.065451f, 0.11767f,  0.15962f,  0.17452f,  0.1758f,
     0.17979f,  0.18543f,  0.20371f,  0.22985f,  0.26327f,  0.31164f,
     0.39135f,  0.51439f,  0.67263f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.00062925f,
     0.0252f,   0.061583f, 0.11105f,  0.15702f,  0.18518f,  0.19453f,
     0.19777f,  0.20284f,  0.21192f,  0.23812f,  0.27128f,  0.32312f,
     0.39609f,  0.48293f,  0.55712f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0019397f,
     0.0155f,   0.044322f, 0.08731f,  0.13974f,  0.17992f,  0.2049f,
     0.2193f,   0.22819f,  0.23733f,  0.24724f,  0.28632f,  0.33282f,
     0.38198f,  0.4169f,   0.44874f},
    {0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0055425f, 0.024256f, 0.05812f,  0.104f,    0.15089f,  0.19068f,
     0.21822f,   0.23925f,  0.2564f,   0.27419f,  0.292f,    0.32517f,
     0.3472f,    0.34732f,  0.34452f},
    {0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.0056317f, 0.02644f,  0.059451f, 0.09695f,  0.14288f,
     0.18101f,  0.21148f,   0.23904f,  0.26062f,  0.28155f,  0.29985f,
     0.30497f,  0.28578f,   0.24801f},
    {0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.0019274f, 0.016697f, 0.038906f, 0.070344f,
     0.099719f, 0.12753f,  0.15144f,   0.17541f,  0.18105f,  0.22314f,
     0.26347f,  0.23448f,  0.15764f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,     0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, -1.2068e-018f, 0.0063777f,
     0.017224f, 0.02596f,  0.03194f,  0.051138f, 0.08308f,      0.11865f,
     0.15601f,  0.19233f,  0.076473f},
    {0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,    0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, -1.1102e-016f}};

float map_7point1_ls[21][21] = {
    {1.000000f, 0.99863f,  0.99396f,     0.98481f, 0.9703f,  0.94888f,
     0.91914f,  0.88048f,  0.83195f,     0.77384f, 0.70834f, 0.63338f,
     0.55484f,  0.47562f,  0.39394f,     0.3173f,  0.24362f, 0.17537f,
     0.11147f,  0.054079f, -7.8496e-017f},
    {0.94446f, 0.81199f, 0.83616f, 0.85669f, 0.87092f, 0.87561f, 0.8564f,
     0.80823f, 0.75425f, 0.69808f, 0.63602f, 0.56664f, 0.49969f, 0.43164f,
     0.36121f, 0.29703f, 0.24559f, 0.20208f, 0.16581f, 0.13592f, 0.000000f},
    {0.88271f, 0.78057f, 0.71294f, 0.73952f, 0.76209f, 0.72118f, 0.69661f,
     0.66179f, 0.62498f, 0.59208f, 0.56394f, 0.52736f, 0.48539f, 0.43211f,
     0.3753f,  0.31848f, 0.25563f, 0.21817f, 0.18628f, 0.11031f, 0.000000f},
    {0.80907f, 0.73849f, 0.68142f, 0.62971f, 0.60765f, 0.58509f,  0.55402f,
     0.53219f, 0.51188f, 0.49896f, 0.49292f, 0.47704f, 0.45666f,  0.42472f,
     0.38061f, 0.33006f, 0.27965f, 0.22857f, 0.15778f, 0.083896f, 0.000000f},
    {0.72626f, 0.68381f, 0.64457f, 0.57657f, 0.51706f, 0.49372f,  0.46596f,
     0.45043f, 0.43577f, 0.42627f, 0.42558f, 0.42408f, 0.4189f,   0.4019f,
     0.37301f, 0.33185f, 0.28785f, 0.21842f, 0.12802f, 0.058746f, 0.000000f},
    {0.63102f, 0.61653f, 0.57478f, 0.53382f, 0.48514f, 0.42718f, 0.41011f,
     0.39421f, 0.38285f, 0.37543f, 0.37141f, 0.37424f, 0.37886f, 0.37291f,
     0.35447f, 0.32571f, 0.2697f,  0.20197f, 0.12403f, 0.03616f, 0.000000f},
    {0.52519f, 0.53691f, 0.52315f, 0.49422f, 0.4552f,  0.40947f,  0.36615f,
     0.35043f, 0.34158f, 0.3356f,  0.33216f, 0.33419f, 0.33895f,  0.34131f,
     0.33172f, 0.30203f, 0.24789f, 0.18361f, 0.10709f, 0.022585f, 0.000000f},
    {0.40402f, 0.46214f, 0.47464f, 0.46087f, 0.43328f,  0.39304f,  0.3499f,
     0.32038f, 0.31064f, 0.30342f, 0.30041f, 0.30177f,  0.30761f,  0.31375f,
     0.30955f, 0.27305f, 0.21805f, 0.15706f, 0.090176f, 0.018356f, 0.000000f},
    {0.27711f, 0.39741f, 0.42859f, 0.42667f, 0.40895f,  0.37927f,  0.34025f,
     0.30982f, 0.28478f, 0.27695f, 0.27237f, 0.27482f,  0.28125f,  0.29675f,
     0.28023f, 0.23683f, 0.18569f, 0.13031f, 0.070512f, 0.012179f, 0.000000f},
    {0.14292f, 0.33339f, 0.38221f, 0.39113f, 0.38299f,  0.36377f,   0.33348f,
     0.30176f, 0.27588f, 0.25314f, 0.24761f, 0.25f,     0.2723f,    0.2674f,
     0.23727f, 0.19424f, 0.14921f, 0.10103f, 0.049741f, 0.0045097f, 0.000000f},
    {0.000000f, 0.26327f,      0.33172f, 0.35247f, 0.35385f, 0.34292f,
     0.32385f,  0.29788f,      0.27007f, 0.24552f, 0.22579f, 0.23659f,
     0.23272f,  0.21252f,      0.18253f, 0.14834f, 0.1086f,  0.068513f,
     0.027472f, -8.5322e-019f, 0.000000f},
    {0.000000f, 0.19725f,  0.27965f, 0.31034f, 0.31939f,  0.31618f,
     0.30536f,  0.28855f,  0.26792f, 0.24094f, 0.1799f,   0.14699f,
     0.14674f,  0.14347f,  0.12638f, 0.10174f, 0.073541f, 0.042039f,
     0.011806f, 0.000000f, 0.000000f},
    {0.000000f,  0.13069f,  0.21975f, 0.26195f,  0.27862f,  0.28151f,
     0.27602f,   0.26277f,  0.24232f, 0.202f,    0.13299f,  0.082204f,
     0.083689f,  0.086082f, 0.07899f, 0.061737f, 0.041097f, 0.018696f,
     0.0013628f, 0.000000f, 0.000000f},
    {0.000000f, 0.067274f, 0.15464f,  0.20782f, 0.23238f,  0.24129f,
     0.24043f,  0.22893f,  0.19873f,  0.15312f, 0.089072f, 0.040759f,
     0.032293f, 0.046248f, 0.043546f, 0.03134f, 0.017152f, 0.0039822f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f,  0.019339f, 0.094607f, 0.15196f,  0.18465f,   0.19667f,
     0.19966f,   0.1783f,   0.14444f,  0.099312f, 0.051555f,  0.015195f,
     0.0048976f, 0.012512f, 0.017789f, 0.01096f,  0.0039191f, 0.000000f,
     0.000000f,  0.000000f, 0.000000f},
    {0.000000f, 0.0021311f, 0.047925f,   0.09417f,   0.12885f,  0.15216f,
     0.13421f,  0.11122f,   0.081488f,   0.049149f,  0.021112f, 0.0028496f,
     0.000000f, 0.000000f,  0.00044495f, 0.0013625f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.000000f, 0.000000f, 0.0098814f, 0.04946f,  0.081296f,  0.075526f,
     0.066173f, 0.048526f, 0.031102f,  0.01419f,  0.0019269f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.000000f,  0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f,  0.0024671f, 0.016531f, 0.019071f, 0.017441f,
     0.014677f, 0.0073556f, 0.0022352f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f,  0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

float map_7point1_rs[21][21] = {
    {-7.8496e-017f, 0.052336f, 0.10973f, 0.17365f, 0.24192f, 0.31565f,
     0.39394f,      0.47409f,  0.55484f, 0.63338f, 0.70587f, 0.77384f,
     0.83195f,      0.87965f,  0.91914f, 0.94832f, 0.96987f, 0.9845f,
     0.99377f,      0.99854f,  1.000000f},
    {0.000000f, 0.13583f, 0.16489f, 0.20208f, 0.24451f, 0.29589f, 0.35999f,
     0.43048f,  0.49857f, 0.56633f, 0.63558f, 0.69745f, 0.75361f, 0.80779f,
     0.85613f,  0.8756f,  0.87113f, 0.85731f, 0.83679f, 0.81212f, 0.94629f},
    {0.000000f, 0.11031f, 0.18615f, 0.21738f, 0.25552f, 0.31761f, 0.37444f,
     0.43128f,  0.48466f, 0.52692f, 0.56374f, 0.59228f, 0.62473f, 0.66167f,
     0.69668f,  0.72145f, 0.76272f, 0.7402f,  0.71303f, 0.78158f, 0.88423f},
    {0.000000f, 0.083257f, 0.15778f, 0.22845f, 0.27908f, 0.32934f, 0.38061f,
     0.42428f,  0.45626f,  0.4769f,  0.4928f,  0.49938f, 0.51188f, 0.53264f,
     0.55439f,  0.58524f,  0.6082f,  0.62975f, 0.68239f, 0.7397f,  0.8111f},
    {0.000000f, 0.058746f, 0.12737f, 0.2183f,  0.28772f, 0.33167f, 0.37263f,
     0.40155f,  0.4187f,   0.42403f, 0.42555f, 0.42626f, 0.43576f, 0.45043f,
     0.46637f,  0.49385f,  0.51702f, 0.57711f, 0.64546f, 0.68515f, 0.72837f},
    {0.000000f, 0.035717f, 0.12342f, 0.20135f, 0.26927f, 0.3256f,  0.35421f,
     0.3727f,   0.37913f,  0.37456f, 0.37139f, 0.37551f, 0.38293f, 0.39422f,
     0.41047f,  0.42708f,  0.48557f, 0.53421f, 0.57553f, 0.61802f, 0.63323f},
    {0.000000f, 0.022264f, 0.10655f, 0.18361f, 0.24774f, 0.30191f, 0.3317f,
     0.3415f,   0.33894f,  0.33418f, 0.33214f, 0.33559f, 0.34157f, 0.3505f,
     0.36607f,  0.40957f,  0.45546f, 0.49461f, 0.52386f, 0.53833f, 0.52748f},
    {0.000000f, 0.018075f, 0.089694f, 0.15698f, 0.21753f, 0.27257f, 0.30936f,
     0.31378f,  0.30767f,  0.30176f,  0.30039f, 0.30342f, 0.31091f, 0.32031f,
     0.3502f,   0.39305f,  0.43346f,  0.46137f, 0.47532f, 0.46338f, 0.40639f},
    {0.000000f, 0.011962f, 0.070085f, 0.12983f, 0.1852f,  0.2365f,  0.2799f,
     0.29688f,  0.28132f,  0.27481f,  0.27235f, 0.27695f, 0.28472f, 0.3099f,
     0.34026f,  0.3796f,   0.40917f,  0.42708f, 0.42927f, 0.39855f, 0.27953f},
    {0.000000f, 0.0043772f, 0.049741f, 0.10103f, 0.14876f, 0.19392f, 0.23686f,
     0.26716f,  0.27225f,   0.25006f,  0.24759f, 0.25308f, 0.27589f, 0.30177f,
     0.33349f,  0.36411f,   0.38326f,  0.39169f, 0.38291f, 0.3345f,  0.14292f},
    {0.000000f, -8.5322e-019f, 0.027447f,    0.068465f, 0.10853f, 0.14825f,
     0.18244f,  0.21244f,      0.23269f,     0.23658f,  0.22577f, 0.24545f,
     0.27f,     0.29779f,      0.3238f,      0.34289f,  0.35387f, 0.35252f,
     0.3318f,   0.26339f,      -8.6596e-017f},
    {0.000000f, 0.000000f, 0.011636f, 0.041753f, 0.073199f, 0.1017f,
     0.12602f,  0.14312f,  0.14641f,  0.14698f,  0.17992f,  0.24091f,
     0.268f,    0.28867f,  0.30555f,  0.31654f,  0.31978f,  0.31088f,
     0.28038f,  0.19821f,  0.000000f},
    {0.000000f, 0.000000f, 0.0013084f, 0.018492f, 0.040831f, 0.061737f,
     0.07868f,  0.085813f, 0.08366f,   0.082238f, 0.13301f,  0.20226f,
     0.24232f,  0.26304f,  0.2763f,    0.28192f,  0.27908f,  0.26255f,
     0.22053f,  0.13152f,  0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.0038919f, 0.016973f, 0.031114f,
     0.043546f, 0.046224f, 0.032368f, 0.040874f,  0.089105f, 0.15348f,
     0.19907f,  0.22896f,  0.24081f,  0.24172f,   0.2329f,   0.20846f,
     0.15539f,  0.067908f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f,  0.000000f, 0.0038302f, 0.010822f,
     0.017781f, 0.01238f,  0.0048489f, 0.015357f, 0.051582f,  0.099723f,
     0.14485f,  0.17871f,  0.1997f,    0.19715f,  0.18521f,   0.15233f,
     0.095227f, 0.019725f, 0.000000f},
    {0.000000f,   0.000000f,  0.000000f, 0.000000f,  0.000000f, 0.0013625f,
     0.00044495f, 0.000000f,  0.000000f, 0.0029287f, 0.021123f, 0.049473f,
     0.081894f,   0.11169f,   0.13466f,  0.15222f,   0.12939f,  0.094728f,
     0.048381f,   0.0022432f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,  0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0019269f, 0.01438f,
     0.031384f, 0.048878f, 0.066587f, 0.075976f, 0.081342f,  0.049892f,
     0.010122f, 0.000000f, 0.000000f},
    {0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,  0.000000f,  0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.0023122f, 0.0075151f, 0.014677f, 0.017689f, 0.019339f, 0.016553f,
     0.0025743f, 0.000000f,  0.000000f},
    {0.000000f,     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f,     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     -9.4126e-019f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

float map_lfe_lfe[21][21] = {
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f},
    {0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f,
     0.000000f, 0.000000f, 0.000000f}};

std::map<unsigned, alloc_lut> chn_alloc;
std::map<unsigned, std::vector<float>> chn_angle;
std::map<unsigned, std::vector<float>> chn_xsf;
std::map<unsigned, std::vector<float>> chn_ysf;
std::map<unsigned, std::vector<channel_id>> chn_id;

bool init_maps() {
  chn_angle[cs_5point1] = std::vector<float>(
      &map_5point1_ang[0],
      &map_5point1_ang[sizeof(map_5point1_ang) / sizeof(map_5point1_ang[0])]);
  chn_xsf[cs_5point1] = std::vector<float>(
      &map_5point1_xsf[0],
      &map_5point1_xsf[sizeof(map_5point1_xsf) / sizeof(map_5point1_xsf[0])]);
  chn_ysf[cs_5point1] = std::vector<float>(
      &map_5point1_ysf[0],
      &map_5point1_ysf[sizeof(map_5point1_ysf) / sizeof(map_5point1_ysf[0])]);
  chn_id[cs_5point1] = std::vector<channel_id>(
      &map_5point1_id[0],
      &map_5point1_id[sizeof(map_5point1_id) / sizeof(map_5point1_id[0])]);
  chn_alloc[cs_5point1].push_back(
      std::vector<float *>(&map_5point1_lf[0], &map_5point1_lf[21]));
  chn_alloc[cs_5point1].push_back(
      std::vector<float *>(&map_5point1_cf[0], &map_5point1_cf[21]));
  chn_alloc[cs_5point1].push_back(
      std::vector<float *>(&map_5point1_rf[0], &map_5point1_rf[21]));
  chn_alloc[cs_5point1].push_back(
      std::vector<float *>(&map_5point1_ls[0], &map_5point1_ls[21]));
  chn_alloc[cs_5point1].push_back(
      std::vector<float *>(&map_5point1_rs[0], &map_5point1_rs[21]));
  chn_alloc[cs_5point1].push_back(
      std::vector<float *>(&map_lfe_lfe[0], &map_lfe_lfe[21]));

  chn_angle[cs_7point1] = std::vector<float>(
      &map_7point1_ang[0],
      &map_7point1_ang[sizeof(map_7point1_ang) / sizeof(map_7point1_ang[0])]);
  chn_xsf[cs_7point1] = std::vector<float>(
      &map_7point1_xsf[0],
      &map_7point1_xsf[sizeof(map_7point1_xsf) / sizeof(map_7point1_xsf[0])]);
  chn_ysf[cs_7point1] = std::vector<float>(
      &map_7point1_ysf[0],
      &map_7point1_ysf[sizeof(map_7point1_ysf) / sizeof(map_7point1_ysf[0])]);
  chn_id[cs_7point1] = std::vector<channel_id>(
      &map_7point1_id[0],
      &map_7point1_id[sizeof(map_7point1_id) / sizeof(map_7point1_id[0])]);
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_lf[0], &map_7point1_lf[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_cf[0], &map_7point1_cf[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_rf[0], &map_7point1_rf[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_lsm[0], &map_7point1_lsm[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_rsm[0], &map_7point1_rsm[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_ls[0], &map_7point1_ls[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_7point1_rs[0], &map_7point1_rs[21]));
  chn_alloc[cs_7point1].push_back(
      std::vector<float *>(&map_lfe_lfe[0], &map_lfe_lfe[21]));

  return true;
}

namespace {
bool success = init_maps();
};
