#ifndef INCLUDED_OFFICECFG_OFFICE_COMPATIBILITY_HXX
#define INCLUDED_OFFICECFG_OFFICE_COMPATIBILITY_HXX

#include "sal/config.h"

#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Compatibility {

struct AllFileFormats: public comphelper::ConfigurationSet< AllFileFormats> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/AllFileFormats"_ustr); return PATH; }
private:
    AllFileFormats(); // not defined
    ~AllFileFormats(); // not defined
};

struct View: public comphelper::ConfigurationGroup< View> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/View"_ustr); return PATH; }

struct MSCompatibleFormsMenu: public comphelper::ConfigurationProperty<MSCompatibleFormsMenu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/View/MSCompatibleFormsMenu"_ustr); return PATH; }
private:
    MSCompatibleFormsMenu(); // not defined
    ~MSCompatibleFormsMenu(); // not defined
};

struct AllowCommentsInFootnotes: public comphelper::ConfigurationProperty<AllowCommentsInFootnotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/View/AllowCommentsInFootnotes"_ustr); return PATH; }
private:
    AllowCommentsInFootnotes(); // not defined
    ~AllowCommentsInFootnotes(); // not defined
};

struct ReverseSeriesOrderAreaAndNetChart: public comphelper::ConfigurationProperty<ReverseSeriesOrderAreaAndNetChart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/View/ReverseSeriesOrderAreaAndNetChart"_ustr); return PATH; }
private:
    ReverseSeriesOrderAreaAndNetChart(); // not defined
    ~ReverseSeriesOrderAreaAndNetChart(); // not defined
};

struct ReverseXAxisOrientationDoughnutChart: public comphelper::ConfigurationProperty<ReverseXAxisOrientationDoughnutChart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/View/ReverseXAxisOrientationDoughnutChart"_ustr); return PATH; }
private:
    ReverseXAxisOrientationDoughnutChart(); // not defined
    ~ReverseXAxisOrientationDoughnutChart(); // not defined
};

struct ClockwisePieChartDirection: public comphelper::ConfigurationProperty<ClockwisePieChartDirection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Compatibility/View/ClockwisePieChartDirection"_ustr); return PATH; }
private:
    ClockwisePieChartDirection(); // not defined
    ~ClockwisePieChartDirection(); // not defined
};

private:
    View(); // not defined
    ~View(); // not defined
};

} } }

#endif
