// Code generated by smithy-go-codegen DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lightsail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the specified attribute for a load balancer. You can only update one
// attribute at a time.
//
// The update load balancer attribute operation supports tag-based access control
// via resource tags applied to the resource identified by load balancer name . For
// more information, see the [Amazon Lightsail Developer Guide].
//
// [Amazon Lightsail Developer Guide]: https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-controlling-access-using-tags
func (c *Client) UpdateLoadBalancerAttribute(ctx context.Context, params *UpdateLoadBalancerAttributeInput, optFns ...func(*Options)) (*UpdateLoadBalancerAttributeOutput, error) {
	if params == nil {
		params = &UpdateLoadBalancerAttributeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLoadBalancerAttribute", params, optFns, c.addOperationUpdateLoadBalancerAttributeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLoadBalancerAttributeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLoadBalancerAttributeInput struct {

	// The name of the attribute you want to update.
	//
	// This member is required.
	AttributeName types.LoadBalancerAttributeName

	// The value that you want to specify for the attribute name.
	//
	// The following values are supported depending on what you specify for the
	// attributeName request parameter:
	//
	//   - If you specify HealthCheckPath for the attributeName request parameter, then
	//   the attributeValue request parameter must be the path to ping on the target
	//   (for example, /weather/us/wa/seattle ).
	//
	//   - If you specify SessionStickinessEnabled for the attributeName request
	//   parameter, then the attributeValue request parameter must be true to activate
	//   session stickiness or false to deactivate session stickiness.
	//
	//   - If you specify SessionStickiness_LB_CookieDurationSeconds for the
	//   attributeName request parameter, then the attributeValue request parameter
	//   must be an interger that represents the cookie duration in seconds.
	//
	//   - If you specify HttpsRedirectionEnabled for the attributeName request
	//   parameter, then the attributeValue request parameter must be true to activate
	//   HTTP to HTTPS redirection or false to deactivate HTTP to HTTPS redirection.
	//
	//   - If you specify TlsPolicyName for the attributeName request parameter, then
	//   the attributeValue request parameter must be the name of the TLS policy.
	//
	// Use the [GetLoadBalancerTlsPolicies]action to get a list of TLS policy names that you can specify.
	//
	// [GetLoadBalancerTlsPolicies]: https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancerTlsPolicies.html
	//
	// This member is required.
	AttributeValue *string

	// The name of the load balancer that you want to modify ( my-load-balancer .
	//
	// This member is required.
	LoadBalancerName *string

	noSmithyDocumentSerde
}

type UpdateLoadBalancerAttributeOutput struct {

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected by the
	// request.
	Operations []types.Operation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLoadBalancerAttributeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLoadBalancerAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLoadBalancerAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLoadBalancerAttribute"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateLoadBalancerAttributeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLoadBalancerAttribute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLoadBalancerAttribute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLoadBalancerAttribute",
	}
}
