/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         itex2MML_yyparse
#define yylex           itex2MML_yylex
#define yyerror         itex2MML_yyerror
#define yydebug         itex2MML_yydebug
#define yynerrs         itex2MML_yynerrs
#define yylval          itex2MML_yylval
#define yychar          itex2MML_yychar

/* First part of user prologue.  */
#line 7 "../lasem/itex2mml/itex2MML.y"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "itex2MML.h"

#define YYSTYPE char *
#define YYPARSE_PARAM_TYPE char **
#define YYPARSE_PARAM ret_str

#define yytext itex2MML_yytext

 extern int yylex ();
 int itex2MML_do_html_filter (const char * buffer, size_t length, const int forbid_markup);

 extern char * yytext;

 static void itex2MML_default_error (const char * msg)
   {
     if (msg)
       fprintf(stderr, "Line: %d Error: %s\n", itex2MML_lineno, msg);
   }

 void (*itex2MML_error) (const char * msg) = itex2MML_default_error;

 static void yyerror (char **ret_str, char * s)
   {
     char * msg = itex2MML_copy3 (s, " at token ", yytext);
     if (itex2MML_error)
       (*itex2MML_error) (msg);
     itex2MML_free_string (msg);
   }

 /* Note: If length is 0, then buffer is treated like a string; otherwise only length bytes are written.
  */
 static void itex2MML_default_write (const char * buffer, size_t length)
   {
     if (buffer)
       {
	 if (length)
	   fwrite (buffer, 1, length, stdout);
	 else
	   fputs (buffer, stdout);
       }
   }

 static void itex2MML_default_write_mathml (const char * mathml)
   {
     if (itex2MML_write)
       (*itex2MML_write) (mathml, 0);
   }

#ifdef itex2MML_CAPTURE
    static char * itex2MML_output_string = "" ;

    const char * itex2MML_output ()
    {
        char * copy = (char *) malloc((itex2MML_output_string ? strlen(itex2MML_output_string) : 0) + 1);
        if (copy)
          {
           if (itex2MML_output_string)
             {
               strcpy(copy, itex2MML_output_string);
               if (*itex2MML_output_string != '\0')
                   free(itex2MML_output_string);
             }
           else
             copy[0] = 0;
           itex2MML_output_string = "";
          }
        return copy;
    }

 static void itex2MML_capture (const char * buffer, size_t length)
    {
     if (buffer)
       {
         if (length)
           {
              size_t first_length = itex2MML_output_string ? strlen(itex2MML_output_string) : 0;
              char * copy  = (char *) malloc(first_length + length + 1);
              if (copy)
                {
                  if (itex2MML_output_string)
                    {
                       strcpy(copy, itex2MML_output_string);
                       if (*itex2MML_output_string != '\0')
                          free(itex2MML_output_string);
                    }
                  else
                     copy[0] = 0;
                  strncat(copy, buffer, length);
                  itex2MML_output_string = copy;
                 }
            }
         else
            {
              char * copy = itex2MML_copy2(itex2MML_output_string, buffer);
              if (*itex2MML_output_string != '\0')
                 free(itex2MML_output_string);
              itex2MML_output_string = copy;
            }
        }
    }

    static void itex2MML_capture_mathml (const char * buffer)
    {
       char * temp = itex2MML_copy2(itex2MML_output_string, buffer);
       if (*itex2MML_output_string != '\0')
         free(itex2MML_output_string);
       itex2MML_output_string = temp;
    }
    void (*itex2MML_write) (const char * buffer, size_t length) = itex2MML_capture;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_capture_mathml;
#else
    void (*itex2MML_write) (const char * buffer, size_t length) = itex2MML_default_write;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_default_write_mathml;
#endif 

 char * itex2MML_empty_string = "";

 /* Create a copy of a string, adding space for extra chars
  */
 char * itex2MML_copy_string_extra (const char * str, unsigned extra)
   {
     char * copy = (char *) malloc(extra + (str ? strlen (str) : 0) + 1);
     if (copy)
       {
	 if (str)
	   strcpy(copy, str);
	 else
	   copy[0] = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending two strings
  */
 char * itex2MML_copy3 (const char * first, const char * second, const char * third)
   {
     size_t first_length =  first ? strlen( first) : 0;
     size_t second_length = second ? strlen(second) : 0;
     size_t third_length =  third ? strlen( third) : 0;

     char * copy = (char *) malloc(first_length + second_length + third_length + 1);

     if (copy)
       {
	 if (first)
	   strcpy(copy, first);
	 else
	   copy[0] = 0;

	 if (second) strcat(copy, second);
	 if ( third) strcat(copy,  third);
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending a second string
  */
 char * itex2MML_copy2 (const char * first, const char * second)
   {
     return itex2MML_copy3(first, second, 0);
   }

 /* Create a copy of a string
  */
 char * itex2MML_copy_string (const char * str)
   {
     return itex2MML_copy3(str, 0, 0);
   }

 /* Create a copy of a string, escaping unsafe characters for XML
  */
 char * itex2MML_copy_escaped (const char * str)
   {
     size_t length = 0;

     const char * ptr1 = str;

     char * ptr2 = 0;
     char * copy = 0;

     if ( str == 0) return itex2MML_empty_string;
     if (*str == 0) return itex2MML_empty_string;

     while (*ptr1)
       {
	 switch (*ptr1)
	   {
	   case '<':  /* &lt;   */
	   case '>':  /* &gt;   */
	     length += 4;
	     break;
	   case '&':  /* &amp;  */
	     length += 5;
	     break;
	   case '\'': /* &apos; */
	   case '"':  /* &quot; */
	   case '-':  /* &#x2d; */
	     length += 6;
	     break;
	   default:
	     length += 1;
	     break;
	   }
	 ++ptr1;
       }

     copy = (char *) malloc (length + 1);

     if (copy)
       {
	 ptr1 = str;
	 ptr2 = copy;

	 while (*ptr1)
	   {
	     switch (*ptr1)
	       {
	       case '<':
		 strcpy (ptr2, "&lt;");
		 ptr2 += 4;
		 break;
	       case '>':
		 strcpy (ptr2, "&gt;");
		 ptr2 += 4;
		 break;
	       case '&':  /* &amp;  */
		 strcpy (ptr2, "&amp;");
		 ptr2 += 5;
		 break;
	       case '\'': /* &apos; */
		 strcpy (ptr2, "&apos;");
		 ptr2 += 6;
		 break;
	       case '"':  /* &quot; */
		 strcpy (ptr2, "&quot;");
		 ptr2 += 6;
		 break;
	       case '-':  /* &#x2d; */
		 strcpy (ptr2, "&#x2d;");
		 ptr2 += 6;
		 break;
	       default:
		 *ptr2++ = *ptr1;
		 break;
	       }
	     ++ptr1;
	   }
	 *ptr2 = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a hex character reference string corresponding to code
  */
 char * itex2MML_character_reference (unsigned long int code)
   {
#define ENTITY_LENGTH 10
     char * entity = (char *) malloc(ENTITY_LENGTH);
     sprintf(entity, "&#x%05lx;", code);
     return entity;
   }

 void itex2MML_free_string (char * str)
   {
     if (str && str != itex2MML_empty_string)
       free(str);
   }


#line 353 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "itex2MML.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TEXOVER = 3,                    /* TEXOVER  */
  YYSYMBOL_TEXATOP = 4,                    /* TEXATOP  */
  YYSYMBOL_CHAR = 5,                       /* CHAR  */
  YYSYMBOL_STARTMATH = 6,                  /* STARTMATH  */
  YYSYMBOL_STARTDMATH = 7,                 /* STARTDMATH  */
  YYSYMBOL_ENDMATH = 8,                    /* ENDMATH  */
  YYSYMBOL_MI = 9,                         /* MI  */
  YYSYMBOL_MIB = 10,                       /* MIB  */
  YYSYMBOL_MN = 11,                        /* MN  */
  YYSYMBOL_MO = 12,                        /* MO  */
  YYSYMBOL_SUP = 13,                       /* SUP  */
  YYSYMBOL_SUB = 14,                       /* SUB  */
  YYSYMBOL_MROWOPEN = 15,                  /* MROWOPEN  */
  YYSYMBOL_MROWCLOSE = 16,                 /* MROWCLOSE  */
  YYSYMBOL_LEFT = 17,                      /* LEFT  */
  YYSYMBOL_RIGHT = 18,                     /* RIGHT  */
  YYSYMBOL_BIG = 19,                       /* BIG  */
  YYSYMBOL_BBIG = 20,                      /* BBIG  */
  YYSYMBOL_BIGG = 21,                      /* BIGG  */
  YYSYMBOL_BBIGG = 22,                     /* BBIGG  */
  YYSYMBOL_BIGL = 23,                      /* BIGL  */
  YYSYMBOL_BBIGL = 24,                     /* BBIGL  */
  YYSYMBOL_BIGGL = 25,                     /* BIGGL  */
  YYSYMBOL_BBIGGL = 26,                    /* BBIGGL  */
  YYSYMBOL_FRAC = 27,                      /* FRAC  */
  YYSYMBOL_TFRAC = 28,                     /* TFRAC  */
  YYSYMBOL_OPERATORNAME = 29,              /* OPERATORNAME  */
  YYSYMBOL_MATHOP = 30,                    /* MATHOP  */
  YYSYMBOL_MATHBIN = 31,                   /* MATHBIN  */
  YYSYMBOL_MATHREL = 32,                   /* MATHREL  */
  YYSYMBOL_MOP = 33,                       /* MOP  */
  YYSYMBOL_MOL = 34,                       /* MOL  */
  YYSYMBOL_MOLL = 35,                      /* MOLL  */
  YYSYMBOL_MOF = 36,                       /* MOF  */
  YYSYMBOL_MOR = 37,                       /* MOR  */
  YYSYMBOL_PERIODDELIM = 38,               /* PERIODDELIM  */
  YYSYMBOL_OTHERDELIM = 39,                /* OTHERDELIM  */
  YYSYMBOL_LEFTDELIM = 40,                 /* LEFTDELIM  */
  YYSYMBOL_RIGHTDELIM = 41,                /* RIGHTDELIM  */
  YYSYMBOL_MOS = 42,                       /* MOS  */
  YYSYMBOL_MOB = 43,                       /* MOB  */
  YYSYMBOL_SQRT = 44,                      /* SQRT  */
  YYSYMBOL_ROOT = 45,                      /* ROOT  */
  YYSYMBOL_BINOM = 46,                     /* BINOM  */
  YYSYMBOL_TBINOM = 47,                    /* TBINOM  */
  YYSYMBOL_UNDER = 48,                     /* UNDER  */
  YYSYMBOL_OVER = 49,                      /* OVER  */
  YYSYMBOL_OVERBRACE = 50,                 /* OVERBRACE  */
  YYSYMBOL_UNDERLINE = 51,                 /* UNDERLINE  */
  YYSYMBOL_UNDERBRACE = 52,                /* UNDERBRACE  */
  YYSYMBOL_UNDEROVER = 53,                 /* UNDEROVER  */
  YYSYMBOL_TENSOR = 54,                    /* TENSOR  */
  YYSYMBOL_MULTI = 55,                     /* MULTI  */
  YYSYMBOL_ARRAYALIGN = 56,                /* ARRAYALIGN  */
  YYSYMBOL_COLUMNALIGN = 57,               /* COLUMNALIGN  */
  YYSYMBOL_ARRAY = 58,                     /* ARRAY  */
  YYSYMBOL_COLSEP = 59,                    /* COLSEP  */
  YYSYMBOL_ROWSEP = 60,                    /* ROWSEP  */
  YYSYMBOL_ARRAYOPTS = 61,                 /* ARRAYOPTS  */
  YYSYMBOL_COLLAYOUT = 62,                 /* COLLAYOUT  */
  YYSYMBOL_COLALIGN = 63,                  /* COLALIGN  */
  YYSYMBOL_ROWALIGN = 64,                  /* ROWALIGN  */
  YYSYMBOL_ALIGN = 65,                     /* ALIGN  */
  YYSYMBOL_EQROWS = 66,                    /* EQROWS  */
  YYSYMBOL_EQCOLS = 67,                    /* EQCOLS  */
  YYSYMBOL_ROWLINES = 68,                  /* ROWLINES  */
  YYSYMBOL_COLLINES = 69,                  /* COLLINES  */
  YYSYMBOL_FRAME = 70,                     /* FRAME  */
  YYSYMBOL_PADDING = 71,                   /* PADDING  */
  YYSYMBOL_ATTRLIST = 72,                  /* ATTRLIST  */
  YYSYMBOL_ITALICS = 73,                   /* ITALICS  */
  YYSYMBOL_SANS = 74,                      /* SANS  */
  YYSYMBOL_TT = 75,                        /* TT  */
  YYSYMBOL_BOLD = 76,                      /* BOLD  */
  YYSYMBOL_BOXED = 77,                     /* BOXED  */
  YYSYMBOL_SLASHED = 78,                   /* SLASHED  */
  YYSYMBOL_RM = 79,                        /* RM  */
  YYSYMBOL_BB = 80,                        /* BB  */
  YYSYMBOL_ST = 81,                        /* ST  */
  YYSYMBOL_END = 82,                       /* END  */
  YYSYMBOL_BBLOWERCHAR = 83,               /* BBLOWERCHAR  */
  YYSYMBOL_BBUPPERCHAR = 84,               /* BBUPPERCHAR  */
  YYSYMBOL_BBDIGIT = 85,                   /* BBDIGIT  */
  YYSYMBOL_CALCHAR = 86,                   /* CALCHAR  */
  YYSYMBOL_FRAKCHAR = 87,                  /* FRAKCHAR  */
  YYSYMBOL_CAL = 88,                       /* CAL  */
  YYSYMBOL_SCR = 89,                       /* SCR  */
  YYSYMBOL_FRAK = 90,                      /* FRAK  */
  YYSYMBOL_CLAP = 91,                      /* CLAP  */
  YYSYMBOL_LLAP = 92,                      /* LLAP  */
  YYSYMBOL_RLAP = 93,                      /* RLAP  */
  YYSYMBOL_ROWOPTS = 94,                   /* ROWOPTS  */
  YYSYMBOL_TEXTSIZE = 95,                  /* TEXTSIZE  */
  YYSYMBOL_SCSIZE = 96,                    /* SCSIZE  */
  YYSYMBOL_SCSCSIZE = 97,                  /* SCSCSIZE  */
  YYSYMBOL_DISPLAY = 98,                   /* DISPLAY  */
  YYSYMBOL_TEXTSTY = 99,                   /* TEXTSTY  */
  YYSYMBOL_TEXTBOX = 100,                  /* TEXTBOX  */
  YYSYMBOL_TEXTSTRING = 101,               /* TEXTSTRING  */
  YYSYMBOL_XMLSTRING = 102,                /* XMLSTRING  */
  YYSYMBOL_CELLOPTS = 103,                 /* CELLOPTS  */
  YYSYMBOL_ROWSPAN = 104,                  /* ROWSPAN  */
  YYSYMBOL_COLSPAN = 105,                  /* COLSPAN  */
  YYSYMBOL_THINSPACE = 106,                /* THINSPACE  */
  YYSYMBOL_MEDSPACE = 107,                 /* MEDSPACE  */
  YYSYMBOL_THICKSPACE = 108,               /* THICKSPACE  */
  YYSYMBOL_QUAD = 109,                     /* QUAD  */
  YYSYMBOL_QQUAD = 110,                    /* QQUAD  */
  YYSYMBOL_NEGSPACE = 111,                 /* NEGSPACE  */
  YYSYMBOL_NEGMEDSPACE = 112,              /* NEGMEDSPACE  */
  YYSYMBOL_NEGTHICKSPACE = 113,            /* NEGTHICKSPACE  */
  YYSYMBOL_PHANTOM = 114,                  /* PHANTOM  */
  YYSYMBOL_HREF = 115,                     /* HREF  */
  YYSYMBOL_UNKNOWNCHAR = 116,              /* UNKNOWNCHAR  */
  YYSYMBOL_EMPTYMROW = 117,                /* EMPTYMROW  */
  YYSYMBOL_STATLINE = 118,                 /* STATLINE  */
  YYSYMBOL_TOOLTIP = 119,                  /* TOOLTIP  */
  YYSYMBOL_TOGGLE = 120,                   /* TOGGLE  */
  YYSYMBOL_TOGGLESTART = 121,              /* TOGGLESTART  */
  YYSYMBOL_TOGGLEEND = 122,                /* TOGGLEEND  */
  YYSYMBOL_FGHIGHLIGHT = 123,              /* FGHIGHLIGHT  */
  YYSYMBOL_BGHIGHLIGHT = 124,              /* BGHIGHLIGHT  */
  YYSYMBOL_SPACE = 125,                    /* SPACE  */
  YYSYMBOL_INTONE = 126,                   /* INTONE  */
  YYSYMBOL_INTTWO = 127,                   /* INTTWO  */
  YYSYMBOL_INTTHREE = 128,                 /* INTTHREE  */
  YYSYMBOL_BAR = 129,                      /* BAR  */
  YYSYMBOL_WIDEBAR = 130,                  /* WIDEBAR  */
  YYSYMBOL_VEC = 131,                      /* VEC  */
  YYSYMBOL_WIDEVEC = 132,                  /* WIDEVEC  */
  YYSYMBOL_WIDELVEC = 133,                 /* WIDELVEC  */
  YYSYMBOL_WIDELRVEC = 134,                /* WIDELRVEC  */
  YYSYMBOL_WIDEUVEC = 135,                 /* WIDEUVEC  */
  YYSYMBOL_WIDEULVEC = 136,                /* WIDEULVEC  */
  YYSYMBOL_WIDEULRVEC = 137,               /* WIDEULRVEC  */
  YYSYMBOL_HAT = 138,                      /* HAT  */
  YYSYMBOL_WIDEHAT = 139,                  /* WIDEHAT  */
  YYSYMBOL_CHECK = 140,                    /* CHECK  */
  YYSYMBOL_WIDECHECK = 141,                /* WIDECHECK  */
  YYSYMBOL_TILDE = 142,                    /* TILDE  */
  YYSYMBOL_WIDETILDE = 143,                /* WIDETILDE  */
  YYSYMBOL_DOT = 144,                      /* DOT  */
  YYSYMBOL_DDOT = 145,                     /* DDOT  */
  YYSYMBOL_DDDOT = 146,                    /* DDDOT  */
  YYSYMBOL_DDDDOT = 147,                   /* DDDDOT  */
  YYSYMBOL_UNARYMINUS = 148,               /* UNARYMINUS  */
  YYSYMBOL_UNARYPLUS = 149,                /* UNARYPLUS  */
  YYSYMBOL_BEGINENV = 150,                 /* BEGINENV  */
  YYSYMBOL_ENDENV = 151,                   /* ENDENV  */
  YYSYMBOL_MATRIX = 152,                   /* MATRIX  */
  YYSYMBOL_PMATRIX = 153,                  /* PMATRIX  */
  YYSYMBOL_BMATRIX = 154,                  /* BMATRIX  */
  YYSYMBOL_BBMATRIX = 155,                 /* BBMATRIX  */
  YYSYMBOL_VMATRIX = 156,                  /* VMATRIX  */
  YYSYMBOL_VVMATRIX = 157,                 /* VVMATRIX  */
  YYSYMBOL_SVG = 158,                      /* SVG  */
  YYSYMBOL_ENDSVG = 159,                   /* ENDSVG  */
  YYSYMBOL_SMALLMATRIX = 160,              /* SMALLMATRIX  */
  YYSYMBOL_CASES = 161,                    /* CASES  */
  YYSYMBOL_ALIGNED = 162,                  /* ALIGNED  */
  YYSYMBOL_GATHERED = 163,                 /* GATHERED  */
  YYSYMBOL_SUBSTACK = 164,                 /* SUBSTACK  */
  YYSYMBOL_PMOD = 165,                     /* PMOD  */
  YYSYMBOL_RMCHAR = 166,                   /* RMCHAR  */
  YYSYMBOL_COLOR = 167,                    /* COLOR  */
  YYSYMBOL_BGCOLOR = 168,                  /* BGCOLOR  */
  YYSYMBOL_XARROW = 169,                   /* XARROW  */
  YYSYMBOL_OPTARGOPEN = 170,               /* OPTARGOPEN  */
  YYSYMBOL_OPTARGCLOSE = 171,              /* OPTARGCLOSE  */
  YYSYMBOL_ITEXNUM = 172,                  /* ITEXNUM  */
  YYSYMBOL_RAISEBOX = 173,                 /* RAISEBOX  */
  YYSYMBOL_NEG = 174,                      /* NEG  */
  YYSYMBOL_YYACCEPT = 175,                 /* $accept  */
  YYSYMBOL_doc = 176,                      /* doc  */
  YYSYMBOL_xmlmmlTermList = 177,           /* xmlmmlTermList  */
  YYSYMBOL_char = 178,                     /* char  */
  YYSYMBOL_expression = 179,               /* expression  */
  YYSYMBOL_compoundTermList = 180,         /* compoundTermList  */
  YYSYMBOL_compoundTerm = 181,             /* compoundTerm  */
  YYSYMBOL_closedTerm = 182,               /* closedTerm  */
  YYSYMBOL_left = 183,                     /* left  */
  YYSYMBOL_right = 184,                    /* right  */
  YYSYMBOL_bigdelim = 185,                 /* bigdelim  */
  YYSYMBOL_unrecognized = 186,             /* unrecognized  */
  YYSYMBOL_unaryminus = 187,               /* unaryminus  */
  YYSYMBOL_unaryplus = 188,                /* unaryplus  */
  YYSYMBOL_mi = 189,                       /* mi  */
  YYSYMBOL_mib = 190,                      /* mib  */
  YYSYMBOL_mn = 191,                       /* mn  */
  YYSYMBOL_mob = 192,                      /* mob  */
  YYSYMBOL_mo = 193,                       /* mo  */
  YYSYMBOL_space = 194,                    /* space  */
  YYSYMBOL_statusline = 195,               /* statusline  */
  YYSYMBOL_tooltip = 196,                  /* tooltip  */
  YYSYMBOL_toggle = 197,                   /* toggle  */
  YYSYMBOL_fghighlight = 198,              /* fghighlight  */
  YYSYMBOL_bghighlight = 199,              /* bghighlight  */
  YYSYMBOL_color = 200,                    /* color  */
  YYSYMBOL_mathrlap = 201,                 /* mathrlap  */
  YYSYMBOL_mathllap = 202,                 /* mathllap  */
  YYSYMBOL_mathclap = 203,                 /* mathclap  */
  YYSYMBOL_textstring = 204,               /* textstring  */
  YYSYMBOL_displaystyle = 205,             /* displaystyle  */
  YYSYMBOL_textstyle = 206,                /* textstyle  */
  YYSYMBOL_textsize = 207,                 /* textsize  */
  YYSYMBOL_scriptsize = 208,               /* scriptsize  */
  YYSYMBOL_scriptscriptsize = 209,         /* scriptscriptsize  */
  YYSYMBOL_italics = 210,                  /* italics  */
  YYSYMBOL_sans = 211,                     /* sans  */
  YYSYMBOL_mono = 212,                     /* mono  */
  YYSYMBOL_slashed = 213,                  /* slashed  */
  YYSYMBOL_boxed = 214,                    /* boxed  */
  YYSYMBOL_bold = 215,                     /* bold  */
  YYSYMBOL_roman = 216,                    /* roman  */
  YYSYMBOL_rmchars = 217,                  /* rmchars  */
  YYSYMBOL_bbold = 218,                    /* bbold  */
  YYSYMBOL_bbchars = 219,                  /* bbchars  */
  YYSYMBOL_bbchar = 220,                   /* bbchar  */
  YYSYMBOL_frak = 221,                     /* frak  */
  YYSYMBOL_frakletters = 222,              /* frakletters  */
  YYSYMBOL_frakletter = 223,               /* frakletter  */
  YYSYMBOL_cal = 224,                      /* cal  */
  YYSYMBOL_scr = 225,                      /* scr  */
  YYSYMBOL_calletters = 226,               /* calletters  */
  YYSYMBOL_calletter = 227,                /* calletter  */
  YYSYMBOL_thinspace = 228,                /* thinspace  */
  YYSYMBOL_medspace = 229,                 /* medspace  */
  YYSYMBOL_thickspace = 230,               /* thickspace  */
  YYSYMBOL_quad = 231,                     /* quad  */
  YYSYMBOL_qquad = 232,                    /* qquad  */
  YYSYMBOL_negspace = 233,                 /* negspace  */
  YYSYMBOL_negmedspace = 234,              /* negmedspace  */
  YYSYMBOL_negthickspace = 235,            /* negthickspace  */
  YYSYMBOL_phantom = 236,                  /* phantom  */
  YYSYMBOL_href = 237,                     /* href  */
  YYSYMBOL_tensor = 238,                   /* tensor  */
  YYSYMBOL_multi = 239,                    /* multi  */
  YYSYMBOL_subsupList = 240,               /* subsupList  */
  YYSYMBOL_subsupTerm = 241,               /* subsupTerm  */
  YYSYMBOL_mfrac = 242,                    /* mfrac  */
  YYSYMBOL_pmod = 243,                     /* pmod  */
  YYSYMBOL_texover = 244,                  /* texover  */
  YYSYMBOL_texatop = 245,                  /* texatop  */
  YYSYMBOL_binom = 246,                    /* binom  */
  YYSYMBOL_munderbrace = 247,              /* munderbrace  */
  YYSYMBOL_munderline = 248,               /* munderline  */
  YYSYMBOL_moverbrace = 249,               /* moverbrace  */
  YYSYMBOL_bar = 250,                      /* bar  */
  YYSYMBOL_vec = 251,                      /* vec  */
  YYSYMBOL_lvec = 252,                     /* lvec  */
  YYSYMBOL_lrvec = 253,                    /* lrvec  */
  YYSYMBOL_uvec = 254,                     /* uvec  */
  YYSYMBOL_ulvec = 255,                    /* ulvec  */
  YYSYMBOL_ulrvec = 256,                   /* ulrvec  */
  YYSYMBOL_dot = 257,                      /* dot  */
  YYSYMBOL_ddot = 258,                     /* ddot  */
  YYSYMBOL_dddot = 259,                    /* dddot  */
  YYSYMBOL_ddddot = 260,                   /* ddddot  */
  YYSYMBOL_tilde = 261,                    /* tilde  */
  YYSYMBOL_check = 262,                    /* check  */
  YYSYMBOL_hat = 263,                      /* hat  */
  YYSYMBOL_msqrt = 264,                    /* msqrt  */
  YYSYMBOL_mroot = 265,                    /* mroot  */
  YYSYMBOL_raisebox = 266,                 /* raisebox  */
  YYSYMBOL_munder = 267,                   /* munder  */
  YYSYMBOL_mover = 268,                    /* mover  */
  YYSYMBOL_munderover = 269,               /* munderover  */
  YYSYMBOL_emptymrow = 270,                /* emptymrow  */
  YYSYMBOL_mathenv = 271,                  /* mathenv  */
  YYSYMBOL_columnAlignList = 272,          /* columnAlignList  */
  YYSYMBOL_substack = 273,                 /* substack  */
  YYSYMBOL_array = 274,                    /* array  */
  YYSYMBOL_arrayopts = 275,                /* arrayopts  */
  YYSYMBOL_anarrayopt = 276,               /* anarrayopt  */
  YYSYMBOL_collayout = 277,                /* collayout  */
  YYSYMBOL_colalign = 278,                 /* colalign  */
  YYSYMBOL_rowalign = 279,                 /* rowalign  */
  YYSYMBOL_align = 280,                    /* align  */
  YYSYMBOL_eqrows = 281,                   /* eqrows  */
  YYSYMBOL_eqcols = 282,                   /* eqcols  */
  YYSYMBOL_rowlines = 283,                 /* rowlines  */
  YYSYMBOL_collines = 284,                 /* collines  */
  YYSYMBOL_frame = 285,                    /* frame  */
  YYSYMBOL_padding = 286,                  /* padding  */
  YYSYMBOL_tableRowList = 287,             /* tableRowList  */
  YYSYMBOL_tableRow = 288,                 /* tableRow  */
  YYSYMBOL_simpleTableRow = 289,           /* simpleTableRow  */
  YYSYMBOL_optsTableRow = 290,             /* optsTableRow  */
  YYSYMBOL_rowopts = 291,                  /* rowopts  */
  YYSYMBOL_arowopt = 292,                  /* arowopt  */
  YYSYMBOL_tableCell = 293,                /* tableCell  */
  YYSYMBOL_cellopts = 294,                 /* cellopts  */
  YYSYMBOL_acellopt = 295,                 /* acellopt  */
  YYSYMBOL_rowspan = 296,                  /* rowspan  */
  YYSYMBOL_colspan = 297                   /* colspan  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  211
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   5195

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  175
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  123
/* YYNRULES -- Number of rules.  */
#define YYNRULES  335
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  594

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   429


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   287,   287,   290,   291,   292,   293,   294,   296,   298,
     299,   300,   316,   333,   337,   343,   362,   376,   395,   409,
     428,   442,   461,   475,   485,   495,   502,   509,   513,   517,
     522,   523,   524,   525,   526,   530,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,   602,   603,   607,   611,   619,   620,
     621,   622,   624,   629,   634,   640,   644,   648,   653,   658,
     662,   666,   671,   675,   679,   684,   688,   692,   697,   701,
     705,   710,   715,   720,   725,   730,   735,   740,   746,   750,
     754,   758,   760,   766,   767,   773,   779,   780,   781,   786,
     791,   796,   800,   805,   809,   813,   817,   822,   827,   832,
     837,   842,   847,   853,   864,   872,   880,   887,   892,   900,
     908,   915,   923,   928,   933,   938,   943,   948,   953,   958,
     963,   968,   973,   978,   983,   988,   993,   998,  1003,  1007,
    1013,  1018,  1022,  1028,  1032,  1036,  1044,  1049,  1053,  1059,
    1064,  1069,  1074,  1078,  1084,  1089,  1093,  1097,  1101,  1105,
    1109,  1113,  1117,  1121,  1126,  1136,  1143,  1151,  1161,  1170,
    1178,  1182,  1188,  1193,  1197,  1201,  1206,  1213,  1221,  1226,
    1233,  1247,  1254,  1268,  1275,  1283,  1288,  1293,  1298,  1302,
    1307,  1311,  1316,  1320,  1324,  1328,  1332,  1337,  1342,  1347,
    1352,  1357,  1361,  1366,  1370,  1375,  1379,  1384,  1389,  1396,
    1404,  1417,  1430,  1440,  1452,  1461,  1471,  1478,  1486,  1493,
    1501,  1511,  1520,  1524,  1528,  1532,  1536,  1540,  1544,  1548,
    1552,  1556,  1560,  1564,  1574,  1581,  1585,  1589,  1594,  1599,
    1604,  1608,  1616,  1620,  1626,  1630,  1634,  1638,  1642,  1646,
    1650,  1654,  1658,  1662,  1667,  1672,  1677,  1682,  1687,  1692,
    1697,  1702,  1707,  1712,  1719,  1723,  1729,  1733,  1738,  1742,
    1748,  1756,  1760,  1766,  1770,  1775,  1778,  1782,  1790,  1794,
    1800,  1804,  1808,  1812,  1817,  1822
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TEXOVER", "TEXATOP",
  "CHAR", "STARTMATH", "STARTDMATH", "ENDMATH", "MI", "MIB", "MN", "MO",
  "SUP", "SUB", "MROWOPEN", "MROWCLOSE", "LEFT", "RIGHT", "BIG", "BBIG",
  "BIGG", "BBIGG", "BIGL", "BBIGL", "BIGGL", "BBIGGL", "FRAC", "TFRAC",
  "OPERATORNAME", "MATHOP", "MATHBIN", "MATHREL", "MOP", "MOL", "MOLL",
  "MOF", "MOR", "PERIODDELIM", "OTHERDELIM", "LEFTDELIM", "RIGHTDELIM",
  "MOS", "MOB", "SQRT", "ROOT", "BINOM", "TBINOM", "UNDER", "OVER",
  "OVERBRACE", "UNDERLINE", "UNDERBRACE", "UNDEROVER", "TENSOR", "MULTI",
  "ARRAYALIGN", "COLUMNALIGN", "ARRAY", "COLSEP", "ROWSEP", "ARRAYOPTS",
  "COLLAYOUT", "COLALIGN", "ROWALIGN", "ALIGN", "EQROWS", "EQCOLS",
  "ROWLINES", "COLLINES", "FRAME", "PADDING", "ATTRLIST", "ITALICS",
  "SANS", "TT", "BOLD", "BOXED", "SLASHED", "RM", "BB", "ST", "END",
  "BBLOWERCHAR", "BBUPPERCHAR", "BBDIGIT", "CALCHAR", "FRAKCHAR", "CAL",
  "SCR", "FRAK", "CLAP", "LLAP", "RLAP", "ROWOPTS", "TEXTSIZE", "SCSIZE",
  "SCSCSIZE", "DISPLAY", "TEXTSTY", "TEXTBOX", "TEXTSTRING", "XMLSTRING",
  "CELLOPTS", "ROWSPAN", "COLSPAN", "THINSPACE", "MEDSPACE", "THICKSPACE",
  "QUAD", "QQUAD", "NEGSPACE", "NEGMEDSPACE", "NEGTHICKSPACE", "PHANTOM",
  "HREF", "UNKNOWNCHAR", "EMPTYMROW", "STATLINE", "TOOLTIP", "TOGGLE",
  "TOGGLESTART", "TOGGLEEND", "FGHIGHLIGHT", "BGHIGHLIGHT", "SPACE",
  "INTONE", "INTTWO", "INTTHREE", "BAR", "WIDEBAR", "VEC", "WIDEVEC",
  "WIDELVEC", "WIDELRVEC", "WIDEUVEC", "WIDEULVEC", "WIDEULRVEC", "HAT",
  "WIDEHAT", "CHECK", "WIDECHECK", "TILDE", "WIDETILDE", "DOT", "DDOT",
  "DDDOT", "DDDDOT", "UNARYMINUS", "UNARYPLUS", "BEGINENV", "ENDENV",
  "MATRIX", "PMATRIX", "BMATRIX", "BBMATRIX", "VMATRIX", "VVMATRIX", "SVG",
  "ENDSVG", "SMALLMATRIX", "CASES", "ALIGNED", "GATHERED", "SUBSTACK",
  "PMOD", "RMCHAR", "COLOR", "BGCOLOR", "XARROW", "OPTARGOPEN",
  "OPTARGCLOSE", "ITEXNUM", "RAISEBOX", "NEG", "$accept", "doc",
  "xmlmmlTermList", "char", "expression", "compoundTermList",
  "compoundTerm", "closedTerm", "left", "right", "bigdelim",
  "unrecognized", "unaryminus", "unaryplus", "mi", "mib", "mn", "mob",
  "mo", "space", "statusline", "tooltip", "toggle", "fghighlight",
  "bghighlight", "color", "mathrlap", "mathllap", "mathclap", "textstring",
  "displaystyle", "textstyle", "textsize", "scriptsize",
  "scriptscriptsize", "italics", "sans", "mono", "slashed", "boxed",
  "bold", "roman", "rmchars", "bbold", "bbchars", "bbchar", "frak",
  "frakletters", "frakletter", "cal", "scr", "calletters", "calletter",
  "thinspace", "medspace", "thickspace", "quad", "qquad", "negspace",
  "negmedspace", "negthickspace", "phantom", "href", "tensor", "multi",
  "subsupList", "subsupTerm", "mfrac", "pmod", "texover", "texatop",
  "binom", "munderbrace", "munderline", "moverbrace", "bar", "vec", "lvec",
  "lrvec", "uvec", "ulvec", "ulrvec", "dot", "ddot", "dddot", "ddddot",
  "tilde", "check", "hat", "msqrt", "mroot", "raisebox", "munder", "mover",
  "munderover", "emptymrow", "mathenv", "columnAlignList", "substack",
  "array", "arrayopts", "anarrayopt", "collayout", "colalign", "rowalign",
  "align", "eqrows", "eqcols", "rowlines", "collines", "frame", "padding",
  "tableRowList", "tableRow", "simpleTableRow", "optsTableRow", "rowopts",
  "arowopt", "tableCell", "cellopts", "acellopt", "rowspan", "colspan", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-387)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     142,  -387,  1389,  1555,    37,   142,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  4857,  4857,  3537,   129,   160,   166,   170,
     173,    50,   163,   186,   188,  4857,  4857,   -56,   -41,   -29,
     -20,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  3702,  4857,  4857,  4857,  4857,  4857,  4857,  4857,
    4857,  4857,  4857,   -10,    41,  4857,  4857,  4857,  4857,  4857,
    4857,    46,    48,    77,    84,    93,  4857,  4857,  4857,  3537,
    3537,  3537,  3537,  3537,    79,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  4857,    81,  -387,  -387,    97,   114,  4857,
    3537,    25,    32,    95,  4857,  4857,  4857,  4857,  4857,  4857,
    4857,  4857,  4857,  4857,  4857,  4857,  4857,  4857,  4857,  4857,
    4857,  4857,  4857,  -387,  -387,    -1,   103,  4857,  -387,   148,
     174,  3867,   147,   -91,  1721,  -387,   216,  3537,  -387,  -387,
    -387,  -387,  -387,   218,  -387,   220,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
      83,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    1887,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  1056,   110,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  4857,  4857,  -387,  -387,  -387,  -387,  3537,
    -387,  4857,  4857,  4857,  4857,  4857,  -387,  -387,  -387,  4857,
     204,   222,  4857,  2052,  -387,  -387,  -387,  -387,  -387,  -387,
      85,   139,   164,   164,   167,  -387,  -387,  -387,  3537,  3537,
    3537,  3537,  3537,  -387,  -387,  4857,  4857,  4857,  4857,  2382,
    4857,  4857,   126,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,   -26,  2217,  2217,  2217,  2217,  2217,  2217,   -86,
    2217,  2217,  2217,  2217,  2217,  -387,  3537,  3537,  3537,  -387,
    -387,  4032,   152,  -387,  -387,  4857,  4857,  1223,  4857,  4857,
    4857,  4857,  -387,  -387,  3537,  3537,  -387,  -387,  -387,  -387,
    2547,  -387,  -387,  -387,  -387,  -387,  4857,  4857,  4197,   222,
     222,  -387,   119,   241,   242,   244,   245,  3537,     3,  -387,
     203,  -387,  -387,   -47,  -387,  -387,  -387,     2,  -387,  -387,
     -24,  -387,    -4,  -387,   -55,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,   187,   182,   213,   -53,   -52,   -51,   -49,
     -48,   -46,   112,  -387,   -45,   -42,   -40,   -39,     6,  3537,
    3537,  2712,  4362,  -387,  4527,   259,   261,  3537,  3537,   125,
    -387,   267,   269,   270,   272,  2877,  3042,  4857,  -387,  -387,
    4857,   273,   159,  -387,  4857,   222,   122,   179,    16,  -387,
    2217,  3207,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
     202,   213,  -387,   -23,   136,   137,   135,   143,   138,   134,
    -387,   140,   144,   141,   145,  -387,  5022,  4857,  -387,  4692,
    -387,  4857,  4857,  3372,  3372,  -387,  -387,  -387,  4857,  4857,
    4857,  4857,  -387,  -387,  -387,  -387,  4857,  -387,    -9,   165,
     225,   227,   229,   232,   234,   235,   237,   238,   255,   256,
      75,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,     1,  -387,   257,   258,  -387,  -387,
      12,  -387,  -387,  -387,  -387,  -387,   190,   -21,  -387,  2217,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  4857,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,   222,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  2217,  -387,  3207,
    -387,  -387,  -387,  3537,  -387,   249,  2217,   -37,  -387,   181,
      17,   203,  3537,   251,   -36,   275,  -387,  -387,   206,   279,
    -387,   262,  -387,  -387
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       3,     8,     0,     0,     0,     2,     4,     5,     9,   141,
     142,   143,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   157,   149,   150,   154,   158,   155,   153,   152,   151,
     156,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,   206,   207,   208,   209,
     210,   211,   212,     0,     0,   138,   272,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   139,   140,     0,     0,     0,   188,     0,
       0,     0,     0,     0,     0,    13,    29,     0,   147,   111,
      31,    32,    34,    33,    35,   146,    36,    85,    97,    98,
      99,   100,   101,   102,    67,    66,    65,    86,    68,    69,
      70,    71,    72,    73,    74,    75,    81,    82,    76,    77,
      78,    79,    80,    83,    84,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    37,    38,    39,   110,   103,
     104,    40,    61,    62,    60,    46,    47,    48,    49,    50,
      51,    52,    54,    55,    56,    57,    59,    58,    53,    41,
      42,    43,    44,    45,    63,    64,   108,   109,    30,    10,
       0,     1,     6,     7,    28,    33,   146,    27,     0,    29,
     114,   113,   112,   120,   118,   119,   123,   121,   122,   126,
     124,   125,   129,   127,   128,   131,   130,   133,   132,   135,
     134,   137,   136,     0,     0,   159,   160,   161,   162,     0,
     257,     0,     0,     0,     0,     0,   237,   236,   235,     0,
       0,     0,     0,   325,   181,   182,   183,   186,   185,   184,
       0,     0,     0,     0,     0,   174,   173,   172,   178,   179,
     180,   176,   177,   175,   213,     0,     0,     0,     0,     0,
       0,     0,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   255,   256,   253,   254,   251,   252,   247,   248,
     249,   250,     0,   325,   325,   325,   325,   325,   325,     0,
     325,   325,   325,   325,   325,   228,     0,     0,     0,   268,
     144,     0,     0,    11,    14,     0,     0,     0,     0,     0,
       0,     0,   189,    12,     0,     0,   106,   105,   226,   227,
       0,   259,   233,   234,   267,   269,     0,     0,     0,     0,
     216,   220,     0,     0,     0,     0,     0,   326,     0,   314,
     316,   317,   318,     0,   193,   194,   195,     0,   191,   204,
       0,   202,     0,   199,     0,   197,   214,   164,   165,   166,
     167,   168,   169,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   286,     0,     0,     0,     0,     0,   170,
     171,     0,     0,   264,     0,    26,    25,     0,     0,     0,
     107,    22,    20,    18,    16,     0,     0,     0,   271,   224,
       0,   223,     0,   221,     0,     0,     0,     0,     0,   290,
     325,   325,   187,   190,   192,   200,   203,   201,   196,   198,
       0,     0,   288,     0,     0,     0,     0,     0,     0,     0,
     285,     0,     0,     0,     0,   289,     0,     0,   262,     0,
     265,     0,     0,     0,     0,   117,   116,   115,     0,     0,
       0,     0,   229,   231,   258,   225,     0,   215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   292,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   323,   324,     0,   321,     0,     0,   330,   331,
       0,   328,   332,   333,   315,   319,     0,     0,   287,   325,
     273,   275,   276,   278,   277,   279,   280,   281,   282,   274,
     266,   270,   260,     0,   263,    24,    23,   230,   232,    21,
      19,    17,    15,   222,     0,   218,   219,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   325,   293,   325,
     322,   334,   335,     0,   329,     0,   325,     0,   261,     0,
       0,   320,   327,     0,     0,     0,   217,   291,     0,     0,
     284,     0,   283,   163
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -387,  -387,  -387,   333,   334,    23,   -14,   577,  -387,  -229,
    -387,  -387,  -387,  -387,  -387,    -2,  -387,   168,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,    70,  -387,  -387,   -32,  -387,  -387,   -43,  -387,
    -387,    73,  -351,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -258,  -358,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -387,  -387,  -387,  -387,  -387,  -104,  -387,  -387,
    -387,  -148,  -387,  -386,  -384,  -387,  -387,  -387,  -387,  -387,
    -387,  -387,  -274,   -85,  -215,  -387,  -387,  -158,   -84,  -387,
    -162,  -387,  -387
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     4,     5,     6,     7,   367,   125,   126,   127,   420,
     128,   129,   130,   131,   132,   215,   134,   216,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   377,   378,   162,   384,   385,   163,
     164,   380,   381,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   360,   361,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   453,   207,   208,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,   511,   368,   369,   370,   371,   514,   515,   372,   520,
     521,   522,   523
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     133,   133,   433,   362,   433,   261,   554,   440,   440,   440,
     331,   440,   440,   133,   440,   440,   402,   569,   440,   439,
     440,   440,   465,   440,   440,   124,   210,   448,   573,   446,
     394,   446,   383,   587,   528,   442,   528,   211,   218,   396,
     397,   398,   399,   400,   401,   245,   404,   405,   406,   407,
     408,   512,   518,   513,   519,   395,   263,   312,   445,   529,
     246,   576,   379,   440,   491,   492,   440,   133,   133,   133,
     133,   133,   247,   403,   433,   491,   492,   440,   447,   491,
     492,   248,   379,   332,   443,   374,   375,   376,   133,   235,
     236,   567,   278,   279,   280,   281,   282,   290,   454,   455,
     456,   432,   457,   458,   291,   459,   461,   262,   555,   462,
     334,   463,   464,   289,   585,   589,   516,   517,   324,   342,
     516,   517,   133,   335,   336,   133,   347,   270,   512,   271,
     513,   433,   357,   358,   518,   434,   519,   490,   491,   492,
     493,   494,   495,   496,   497,   498,   499,     1,     2,     3,
     337,   313,   314,   315,   316,   317,   318,   319,   272,   320,
     321,   322,   323,   475,   476,   273,   477,   220,   221,   222,
     135,   135,   357,   358,   274,   487,   292,   489,   357,   358,
     283,   556,   285,   135,   490,   491,   492,   493,   494,   495,
     496,   497,   498,   499,   357,   358,   334,   586,   286,   223,
     224,   225,   237,   238,   334,   226,   227,   228,   133,   229,
     230,   231,   232,   233,   234,   287,   133,   357,   358,   359,
     326,   433,   374,   375,   376,   239,   240,   241,   242,   335,
     336,   338,   339,   340,   341,   357,   358,   135,   135,   135,
     135,   135,   491,   492,   547,   548,   327,   133,   330,   342,
     379,   118,   393,   414,   383,   577,   435,   436,   135,   437,
     438,   133,   441,   451,   334,   334,   334,   334,   334,   450,
     452,   460,   350,   471,   472,   334,   133,   133,   133,   133,
     133,   478,   479,   526,   480,   481,   486,   133,   530,   532,
     531,   535,   135,   580,   534,   135,   579,   557,   533,   558,
     536,   559,   584,   538,   560,   537,   561,   562,   539,   563,
     564,   133,   133,   133,   133,   133,   133,   575,   133,   133,
     133,   133,   133,   334,   133,   133,   133,   565,   566,   571,
     572,   583,   588,   590,   591,   133,   334,   592,   212,   213,
     373,   449,   133,   133,   593,   444,   382,   527,   133,   409,
     410,   411,   568,   334,   581,   524,   570,   525,   574,     0,
       0,     0,     0,     0,     0,   133,     0,   425,   426,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   135,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,     0,
       0,     0,     0,     0,     0,   334,   334,   334,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,   133,   133,
       0,   334,   334,     0,     0,   133,   133,   135,     0,     0,
       0,     0,     0,   133,   133,     0,     0,     0,     0,     0,
       0,   135,     0,     0,     0,     0,     0,     0,   133,   133,
     473,   474,     0,     0,     0,     0,   135,   135,   135,   135,
     135,     0,     0,     0,     0,     0,     0,   135,     0,   334,
     334,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,   133,     0,     0,     0,     0,     0,     0,     0,
       0,   135,   135,   135,   135,   135,   135,     0,   135,   135,
     135,   135,   135,     0,   135,   135,   135,     0,     0,     0,
       0,     0,     0,     0,     0,   135,     0,     0,     0,     0,
       0,     0,   135,   135,     0,     0,     0,     0,   135,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,     0,     0,     0,     0,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,   133,   334,     0,
       0,   133,     0,     0,   133,     0,     0,   135,   135,   135,
     133,     0,     0,     0,     0,   135,   135,     0,     0,     0,
     214,   217,   219,   135,   135,     0,   582,     0,     0,     0,
       0,     0,   243,   244,     0,     0,     0,     0,   135,   135,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
       0,     0,   264,   265,   266,   267,   268,   269,     0,     0,
       0,   135,   135,   275,   276,   277,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     284,     0,     0,     0,     0,     0,   288,     0,     0,     0,
       0,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
       0,     0,     0,     0,   325,     0,     0,   135,   329,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   135,     0,   135,     0,     0,
       0,   135,     0,     0,   135,     0,     0,     0,     0,     0,
     135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     348,   349,     0,     0,     0,     0,     0,     0,   351,   352,
     353,   354,   355,     0,     0,     0,   356,     0,     0,   363,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   386,   387,   388,   389,     0,   391,   392,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,     0,
       0,     0,   415,   416,     0,   421,   422,   423,   424,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   428,   429,   431,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   468,
       0,   470,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   484,     0,     0,   485,     0,     0,
       0,   488,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   541,   542,     0,   544,     0,   545,   546,
       0,     0,     0,     0,     0,   549,   550,   551,   552,   344,
     345,     0,     0,   553,     0,     9,    10,    11,    12,    13,
      14,    15,   346,    16,     0,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,     0,     0,    54,     0,     0,     0,     0,     0,
     578,     0,     0,     0,     0,     0,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,    62,     0,     0,     0,
       0,     0,     0,     0,    63,    64,    65,    66,    67,    68,
       0,    69,    70,    71,    72,    73,    74,     0,     0,     0,
       0,     0,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,     0,    91,
      92,    93,     0,     0,     0,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     116,   117,   118,   119,   120,   121,   417,   418,   122,   123,
       0,     0,     9,    10,    11,    12,    13,    14,    15,     0,
      16,   419,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,    56,    57,    58,
      59,    60,    61,    62,     0,     0,     0,     0,     0,     0,
       0,    63,    64,    65,    66,    67,    68,     0,    69,    70,
      71,    72,    73,    74,     0,     0,     0,     0,     0,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,    91,    92,    93,     0,
       0,     0,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   116,   117,   118,
     119,   120,   121,     0,     0,   122,   123,     8,     9,    10,
      11,    12,    13,    14,    15,     0,    16,     0,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,     0,     0,    54,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,    56,    57,    58,    59,    60,    61,    62,
       0,     0,     0,     0,     0,     0,     0,    63,    64,    65,
      66,    67,    68,     0,    69,    70,    71,    72,    73,    74,
       0,     0,     0,     0,     0,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,    91,    92,    93,     0,     0,     0,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   116,   117,   118,   119,   120,   121,     0,
       0,   122,   123,   209,     9,    10,    11,    12,    13,    14,
      15,     0,    16,     0,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,     0,     0,    54,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,    56,
      57,    58,    59,    60,    61,    62,     0,     0,     0,     0,
       0,     0,     0,    63,    64,    65,    66,    67,    68,     0,
      69,    70,    71,    72,    73,    74,     0,     0,     0,     0,
       0,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,    91,    92,
      93,     0,     0,     0,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   116,
     117,   118,   119,   120,   121,     0,     0,   122,   123,   333,
       9,    10,    11,    12,    13,    14,    15,     0,    16,     0,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,     0,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,    56,    57,    58,    59,    60,
      61,    62,     0,     0,     0,     0,     0,     0,     0,    63,
      64,    65,    66,    67,    68,     0,    69,    70,    71,    72,
      73,    74,     0,     0,     0,     0,     0,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,    91,    92,    93,     0,     0,     0,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   116,   117,   118,   119,   120,
     121,     0,     0,   122,   123,   343,     9,    10,    11,    12,
      13,    14,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,    13,    14,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,   364,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,   365,    69,    70,    71,
      72,    73,    74,     0,     0,   366,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
      13,    14,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,   365,    69,    70,    71,    72,    73,    74,     0,     0,
     366,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,    13,    14,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,     0,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,   390,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
      13,    14,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,   427,   122,
     123,     9,    10,    11,    12,    13,    14,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,     0,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,   466,   122,   123,     9,    10,    11,    12,
      13,    14,    15,   482,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,    13,    14,    15,   483,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,     0,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
      13,    14,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
     366,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,    13,    14,    15,     0,    16,
     419,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,     0,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
      13,    14,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,     0,     0,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,     0,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,   249,     0,   122,   123,     9,    10,    11,    12,
       0,     0,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,   328,     0,   122,
     123,     9,    10,    11,    12,     0,     0,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,   412,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
     430,     0,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,     0,     0,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,   467,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
       0,     0,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,   469,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,     0,     0,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,   543,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123,     9,    10,    11,    12,
       0,     0,    15,     0,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,    62,     0,     0,
       0,     0,     0,     0,     0,    63,    64,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,    74,     0,     0,
       0,     0,     0,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
      91,    92,    93,     0,     0,     0,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,   120,   121,     0,     0,   122,
     123,     9,    10,    11,    12,     0,     0,    15,     0,    16,
       0,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,     0,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,    62,     0,     0,     0,     0,     0,     0,     0,
      63,    64,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,    74,     0,     0,     0,     0,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,   540,
      87,    88,    89,    90,     0,    91,    92,    93,     0,     0,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   116,   117,   118,   119,
     120,   121,     0,     0,   122,   123
};

static const yytype_int16 yycheck[] =
{
       2,     3,   360,   261,   362,    15,    15,    60,    60,    60,
     101,    60,    60,    15,    60,    60,   102,    16,    60,    16,
      60,    60,    16,    60,    60,     2,     3,    82,    16,   380,
      56,   382,    87,    16,    57,    82,    57,     0,    15,   313,
     314,   315,   316,   317,   318,   101,   320,   321,   322,   323,
     324,   437,   438,   437,   438,    81,    15,    58,    82,    82,
     101,    82,    86,    60,    63,    64,    60,    69,    70,    71,
      72,    73,   101,   159,   432,    63,    64,    60,    82,    63,
      64,   101,    86,   174,    82,    83,    84,    85,    90,    39,
      40,    16,    69,    70,    71,    72,    73,    72,   151,   151,
     151,   359,   151,   151,    72,   151,   151,   117,   117,   151,
     124,   151,   151,    90,   151,   151,   104,   105,    15,   166,
     104,   105,   124,    13,    14,   127,    16,    81,   514,    81,
     514,   489,    13,    14,   520,    16,   520,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,     5,     6,     7,
     127,   152,   153,   154,   155,   156,   157,   158,    81,   160,
     161,   162,   163,    38,    39,    81,    41,    38,    39,    40,
       2,     3,    13,    14,    81,    16,    81,   435,    13,    14,
     101,    16,   101,    15,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    13,    14,   210,    16,   101,    39,
      40,    41,    39,    40,   218,    39,    40,    41,   210,    39,
      40,    41,    39,    40,    41,   101,   218,    13,    14,    15,
      72,   579,    83,    84,    85,    39,    40,    39,    40,    13,
      14,    13,    14,    13,    14,    13,    14,    69,    70,    71,
      72,    73,    63,    64,   473,   474,    72,   249,   101,   166,
      86,   166,   126,   101,    87,   529,    15,    15,    90,    15,
      15,   263,    59,    81,   278,   279,   280,   281,   282,    82,
      57,   159,   249,    14,    13,   289,   278,   279,   280,   281,
     282,    14,    13,    81,    14,    13,    13,   289,   152,   154,
     153,   157,   124,   567,   156,   127,   554,    72,   155,    72,
     160,    72,   576,   162,    72,   161,    72,    72,   163,    72,
      72,   313,   314,   315,   316,   317,   318,   127,   320,   321,
     322,   323,   324,   337,   326,   327,   328,    72,    72,    72,
      72,    82,    81,    58,   128,   337,   350,    58,     5,     5,
     270,   384,   344,   345,    82,   377,   273,   451,   350,   326,
     327,   328,   500,   367,   569,   440,   514,   441,   520,    -1,
      -1,    -1,    -1,    -1,    -1,   367,    -1,   344,   345,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   210,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   218,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   409,   410,   411,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   409,   410,   411,
      -1,   425,   426,    -1,    -1,   417,   418,   249,    -1,    -1,
      -1,    -1,    -1,   425,   426,    -1,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,   440,   441,
     417,   418,    -1,    -1,    -1,    -1,   278,   279,   280,   281,
     282,    -1,    -1,    -1,    -1,    -1,    -1,   289,    -1,   473,
     474,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   473,   474,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   313,   314,   315,   316,   317,   318,    -1,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   337,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,    -1,    -1,    -1,   350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   367,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   567,    -1,   569,   582,    -1,
      -1,   573,    -1,    -1,   576,    -1,    -1,   409,   410,   411,
     582,    -1,    -1,    -1,    -1,   417,   418,    -1,    -1,    -1,
      13,    14,    15,   425,   426,    -1,   573,    -1,    -1,    -1,
      -1,    -1,    25,    26,    -1,    -1,    -1,    -1,   440,   441,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      -1,    -1,    55,    56,    57,    58,    59,    60,    -1,    -1,
      -1,   473,   474,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
      -1,    -1,    -1,    -1,   117,    -1,    -1,   529,   121,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   567,    -1,   569,    -1,    -1,
      -1,   573,    -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,
     582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,   244,    -1,    -1,    -1,    -1,    -1,    -1,   251,   252,
     253,   254,   255,    -1,    -1,    -1,   259,    -1,    -1,   262,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   285,   286,   287,   288,    -1,   290,   291,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   331,    -1,
      -1,    -1,   335,   336,    -1,   338,   339,   340,   341,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,   357,   358,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   412,
      -1,   414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   427,    -1,    -1,   430,    -1,    -1,
      -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,   471,   472,
      -1,    -1,    -1,    -1,    -1,   478,   479,   480,   481,     3,
       4,    -1,    -1,   486,    -1,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,    93,
      -1,    95,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,    -1,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,    -1,   123,
     124,   125,    -1,    -1,    -1,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     164,   165,   166,   167,   168,   169,     3,     4,   172,   173,
      -1,    -1,     9,    10,    11,    12,    13,    14,    15,    -1,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    -1,
      -1,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    89,    90,    91,    92,    93,    -1,    95,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,    -1,   123,   124,   125,    -1,
      -1,    -1,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,
     167,   168,   169,    -1,    -1,   172,   173,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    -1,    -1,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    89,    90,
      91,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,    -1,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,    -1,   123,   124,   125,    -1,    -1,    -1,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   164,   165,   166,   167,   168,   169,    -1,
      -1,   172,   173,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    -1,    -1,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    88,    89,    90,    91,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
      -1,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,    -1,   123,   124,
     125,    -1,    -1,    -1,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,
     165,   166,   167,   168,   169,    -1,    -1,   172,   173,     8,
       9,    10,    11,    12,    13,    14,    15,    -1,    17,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    -1,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,
      89,    90,    91,    92,    93,    -1,    95,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,    -1,   123,   124,   125,    -1,    -1,    -1,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,   168,
     169,    -1,    -1,   172,   173,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,    -1,    -1,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,    -1,    -1,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,   171,   172,
     173,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,   171,   172,   173,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    -1,    -1,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,   170,    -1,   172,
     173,     9,    10,    11,    12,    -1,    -1,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      13,    -1,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    -1,    -1,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    -1,    -1,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    -1,    -1,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,    89,    90,    91,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,    -1,    -1,    -1,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   164,   165,   166,   167,   168,   169,    -1,    -1,   172,
     173,     9,    10,    11,    12,    -1,    -1,    15,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      88,    89,    90,    91,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,    -1,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,   165,   166,   167,
     168,   169,    -1,    -1,   172,   173
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     5,     6,     7,   176,   177,   178,   179,     8,     9,
      10,    11,    12,    13,    14,    15,    17,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    58,    73,    74,    75,    76,    77,
      78,    79,    80,    88,    89,    90,    91,    92,    93,    95,
      96,    97,    98,    99,   100,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   123,   124,   125,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   164,   165,   166,   167,
     168,   169,   172,   173,   180,   181,   182,   183,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   221,   224,   225,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   273,   274,     8,
     180,     0,   178,   179,   182,   190,   192,   182,   180,   182,
      38,    39,    40,    39,    40,    41,    39,    40,    41,    39,
      40,    41,    39,    40,    41,    39,    40,    39,    40,    39,
      40,    39,    40,   182,   182,   101,   101,   101,   101,   170,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,    15,   117,    15,   182,   182,   182,   182,   182,   182,
      81,    81,    81,    81,    81,   182,   182,   182,   180,   180,
     180,   180,   180,   101,   182,   101,   101,   101,   182,   180,
      72,    72,    81,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,    58,   152,   153,   154,   155,   156,   157,   158,
     160,   161,   162,   163,    15,   182,    72,    72,   170,   182,
     101,   101,   174,     8,   181,    13,    14,   180,    13,    14,
      13,    14,   166,     8,     3,     4,    16,    16,   182,   182,
     180,   182,   182,   182,   182,   182,   182,    13,    14,    15,
     240,   241,   240,   182,    61,    94,   103,   180,   287,   288,
     289,   290,   293,   217,    83,    84,    85,   219,   220,    86,
     226,   227,   226,    87,   222,   223,   182,   182,   182,   182,
     122,   182,   182,   126,    56,    81,   287,   287,   287,   287,
     287,   287,   102,   159,   287,   287,   287,   287,   287,   180,
     180,   180,   101,   182,   101,   182,   182,     3,     4,    18,
     184,   182,   182,   182,   182,   180,   180,   171,   182,   182,
      13,   182,   240,   241,    16,    15,    15,    15,    15,    16,
      60,    59,    82,    82,   220,    82,   227,    82,    82,   223,
      82,    81,    57,   272,   151,   151,   151,   151,   151,   151,
     159,   151,   151,   151,   151,    16,   171,   101,   182,   101,
     182,    14,    13,   180,   180,    38,    39,    41,    14,    13,
      14,    13,    16,    16,   182,   182,    13,    16,   182,   240,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   278,   279,   291,   292,   104,   105,   278,   279,
     294,   295,   296,   297,   288,   293,    81,   272,    57,    82,
     152,   153,   154,   155,   156,   157,   160,   161,   162,   163,
     117,   182,   182,   101,   182,   182,   182,   184,   184,   182,
     182,   182,   182,   182,    15,   117,    16,    72,    72,    72,
      72,    72,    72,    72,    72,    72,    72,    16,   276,    16,
     292,    72,    72,    16,   295,   127,    82,   287,   182,   240,
     287,   289,   180,    82,   287,   151,    16,    16,    81,   151,
      58,   128,    58,    82
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   175,   176,   177,   177,   177,   177,   177,   178,   179,
     179,   179,   179,   180,   180,   181,   181,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   183,   183,   183,   184,   184,   184,   185,   185,
     185,   185,   185,   185,   185,   185,   185,   185,   185,   185,
     185,   185,   185,   185,   185,   185,   185,   185,   186,   187,
     188,   189,   190,   191,   191,   192,   193,   193,   193,   193,
     193,   193,   193,   193,   193,   193,   193,   193,   193,   193,
     193,   193,   193,   194,   195,   196,   197,   197,   198,   199,
     200,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   217,
     218,   219,   219,   220,   220,   220,   221,   222,   222,   223,
     224,   225,   226,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   238,   239,   239,   239,
     240,   240,   241,   241,   241,   241,   242,   242,   243,   244,
     244,   245,   245,   246,   246,   247,   248,   249,   250,   250,
     251,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   261,   262,   262,   263,   263,   264,   265,   265,
     266,   266,   266,   266,   266,   266,   267,   267,   268,   268,
     269,   269,   270,   271,   271,   271,   271,   271,   271,   271,
     271,   271,   271,   271,   271,   271,   271,   272,   272,   273,
     274,   274,   275,   275,   276,   276,   276,   276,   276,   276,
     276,   276,   276,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   287,   288,   288,   289,   289,
     290,   291,   291,   292,   292,   293,   293,   293,   294,   294,
     295,   295,   295,   295,   296,   297
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     0,     1,     1,     2,     2,     1,     2,
       2,     3,     3,     1,     2,     5,     3,     5,     3,     5,
       3,     5,     3,     5,     5,     3,     3,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,    10,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     4,     1,     2,
       4,     1,     2,     1,     1,     1,     4,     1,     2,     1,
       4,     4,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     5,     3,     8,     6,     6,
       1,     2,     4,     2,     2,     3,     3,     3,     2,     5,
       5,     5,     5,     3,     3,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     5,     3,
       5,     6,     4,     5,     3,     4,     5,     3,     2,     3,
       5,     4,     1,     5,     5,     5,     5,     5,     5,     5,
       5,     5,     5,     9,     8,     4,     3,     2,     1,     4,
       4,     8,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     1,     1,     3,
       5,     1,     2,     1,     1,     0,     1,     5,     1,     2,
       1,     1,     1,     1,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (ret_str, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, ret_str); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, char **ret_str)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (ret_str);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, char **ret_str)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, ret_str);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, char **ret_str)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], ret_str);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, ret_str); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, char **ret_str)
{
  YY_USE (yyvaluep);
  YY_USE (ret_str);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (char **ret_str)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* doc: xmlmmlTermList  */
#line 287 "../lasem/itex2mml/itex2MML.y"
                     {/* all processing done in body*/}
#line 3025 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 3: /* xmlmmlTermList: %empty  */
#line 290 "../lasem/itex2mml/itex2MML.y"
{/* nothing - do nothing*/}
#line 3031 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 4: /* xmlmmlTermList: char  */
#line 291 "../lasem/itex2mml/itex2MML.y"
       {/* proc done in body*/}
#line 3037 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 5: /* xmlmmlTermList: expression  */
#line 292 "../lasem/itex2mml/itex2MML.y"
             {/* all proc. in body*/}
#line 3043 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 6: /* xmlmmlTermList: xmlmmlTermList char  */
#line 293 "../lasem/itex2mml/itex2MML.y"
                      {/* all proc. in body*/}
#line 3049 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 7: /* xmlmmlTermList: xmlmmlTermList expression  */
#line 294 "../lasem/itex2mml/itex2MML.y"
                            {/* all proc. in body*/}
#line 3055 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 8: /* char: CHAR  */
#line 296 "../lasem/itex2mml/itex2MML.y"
           {}
#line 3061 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 9: /* expression: STARTMATH ENDMATH  */
#line 298 "../lasem/itex2mml/itex2MML.y"
                              {/* empty math group - ignore*/}
#line 3067 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 10: /* expression: STARTDMATH ENDMATH  */
#line 299 "../lasem/itex2mml/itex2MML.y"
                     {/* ditto */}
#line 3073 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 11: /* expression: STARTMATH compoundTermList ENDMATH  */
#line 300 "../lasem/itex2mml/itex2MML.y"
                                     {
  char ** r = (char **) ret_str;
  char * p = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'><semantics><mrow>", yyvsp[-1], "</mrow><annotation encoding='application/x-tex'>");
  char * s = itex2MML_copy3(p, yyvsp[0], "</annotation></semantics></math>");
  itex2MML_free_string(p);
  itex2MML_free_string(yyvsp[-1]);  
  itex2MML_free_string(yyvsp[0]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
#line 3094 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 12: /* expression: STARTDMATH compoundTermList ENDMATH  */
#line 316 "../lasem/itex2mml/itex2MML.y"
                                      {
  char ** r = (char **) ret_str;
  char * p = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'><semantics><mrow>", yyvsp[-1], "</mrow><annotation encoding='application/x-tex'>");
  char * s = itex2MML_copy3(p, yyvsp[0], "</annotation></semantics></math>");
  itex2MML_free_string(p);
  itex2MML_free_string(yyvsp[-1]);  
  itex2MML_free_string(yyvsp[0]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
#line 3115 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 13: /* compoundTermList: compoundTerm  */
#line 333 "../lasem/itex2mml/itex2MML.y"
                               {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3124 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 14: /* compoundTermList: compoundTermList compoundTerm  */
#line 337 "../lasem/itex2mml/itex2MML.y"
                                {
  yyval = itex2MML_copy2(yyvsp[-1], yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3134 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 15: /* compoundTerm: mob SUB closedTerm SUP closedTerm  */
#line 343 "../lasem/itex2mml/itex2MML.y"
                                                {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3158 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 16: /* compoundTerm: mob SUB closedTerm  */
#line 362 "../lasem/itex2mml/itex2MML.y"
                     {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3177 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 17: /* compoundTerm: mob SUP closedTerm SUB closedTerm  */
#line 376 "../lasem/itex2mml/itex2MML.y"
                                    {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[0], " ", yyvsp[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[0], " ", yyvsp[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3201 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 18: /* compoundTerm: mob SUP closedTerm  */
#line 395 "../lasem/itex2mml/itex2MML.y"
                     {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3220 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 19: /* compoundTerm: mib SUB closedTerm SUP closedTerm  */
#line 409 "../lasem/itex2mml/itex2MML.y"
                                   {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3244 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 20: /* compoundTerm: mib SUB closedTerm  */
#line 428 "../lasem/itex2mml/itex2MML.y"
                     {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3263 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 21: /* compoundTerm: mib SUP closedTerm SUB closedTerm  */
#line 442 "../lasem/itex2mml/itex2MML.y"
                                    {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[0], " ", yyvsp[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yyvsp[-4], " ");
    char * s2 = itex2MML_copy3(yyvsp[0], " ", yyvsp[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3287 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 22: /* compoundTerm: mib SUP closedTerm  */
#line 461 "../lasem/itex2mml/itex2MML.y"
                     {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yyvsp[-2], " ");
    yyval = itex2MML_copy3(s1, yyvsp[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3306 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 23: /* compoundTerm: closedTerm SUB closedTerm SUP closedTerm  */
#line 475 "../lasem/itex2mml/itex2MML.y"
                                           {
  char * s1 = itex2MML_copy3("<msubsup>", yyvsp[-4], " ");
  char * s2 = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3321 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 24: /* compoundTerm: closedTerm SUP closedTerm SUB closedTerm  */
#line 485 "../lasem/itex2mml/itex2MML.y"
                                           {
  char * s1 = itex2MML_copy3("<msubsup>", yyvsp[-4], " ");
  char * s2 = itex2MML_copy3(yyvsp[0], " ", yyvsp[-2]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3336 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 25: /* compoundTerm: closedTerm SUB closedTerm  */
#line 495 "../lasem/itex2mml/itex2MML.y"
                            {
  char * s1 = itex2MML_copy3("<msub>", yyvsp[-2], " ");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</msub>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3348 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 26: /* compoundTerm: closedTerm SUP closedTerm  */
#line 502 "../lasem/itex2mml/itex2MML.y"
                            {
  char * s1 = itex2MML_copy3("<msup>", yyvsp[-2], " ");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</msup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3360 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 27: /* compoundTerm: SUB closedTerm  */
#line 509 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy3("<msub><mo/>", yyvsp[0], "</msub>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3369 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 28: /* compoundTerm: SUP closedTerm  */
#line 513 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy3("<msup><mo/>", yyvsp[0], "</msup>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3378 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 29: /* compoundTerm: closedTerm  */
#line 517 "../lasem/itex2mml/itex2MML.y"
             {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3387 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 34: /* closedTerm: mi  */
#line 526 "../lasem/itex2mml/itex2MML.y"
     {
  yyval = itex2MML_copy3("<mi>", yyvsp[0], "</mi>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3396 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 35: /* closedTerm: mn  */
#line 530 "../lasem/itex2mml/itex2MML.y"
     {
  yyval = itex2MML_copy3("<mn>", yyvsp[0], "</mn>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3405 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 105: /* closedTerm: MROWOPEN closedTerm MROWCLOSE  */
#line 603 "../lasem/itex2mml/itex2MML.y"
                                {
  yyval = itex2MML_copy_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 3414 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 106: /* closedTerm: MROWOPEN compoundTermList MROWCLOSE  */
#line 607 "../lasem/itex2mml/itex2MML.y"
                                      {
  yyval = itex2MML_copy3("<mrow>", yyvsp[-1], "</mrow>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 3423 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 107: /* closedTerm: left compoundTermList right  */
#line 611 "../lasem/itex2mml/itex2MML.y"
                              {
  char * s1 = itex2MML_copy3("<mrow>", yyvsp[-2], yyvsp[-1]);
  yyval = itex2MML_copy3(s1, yyvsp[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3436 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 112: /* left: LEFT LEFTDELIM  */
#line 624 "../lasem/itex2mml/itex2MML.y"
                     {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3446 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 113: /* left: LEFT OTHERDELIM  */
#line 629 "../lasem/itex2mml/itex2MML.y"
                  {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3456 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 114: /* left: LEFT PERIODDELIM  */
#line 634 "../lasem/itex2mml/itex2MML.y"
                   {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yyvsp[0]);
}
#line 3466 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 115: /* right: RIGHT RIGHTDELIM  */
#line 640 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3475 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 116: /* right: RIGHT OTHERDELIM  */
#line 644 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3484 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 117: /* right: RIGHT PERIODDELIM  */
#line 648 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yyvsp[0]);
}
#line 3493 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 118: /* bigdelim: BIG LEFTDELIM  */
#line 653 "../lasem/itex2mml/itex2MML.y"
                        {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3503 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 119: /* bigdelim: BIG RIGHTDELIM  */
#line 658 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3512 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 120: /* bigdelim: BIG OTHERDELIM  */
#line 662 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3521 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 121: /* bigdelim: BBIG LEFTDELIM  */
#line 666 "../lasem/itex2mml/itex2MML.y"
                 {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3531 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 122: /* bigdelim: BBIG RIGHTDELIM  */
#line 671 "../lasem/itex2mml/itex2MML.y"
                  {
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3540 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 123: /* bigdelim: BBIG OTHERDELIM  */
#line 675 "../lasem/itex2mml/itex2MML.y"
                  {
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3549 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 124: /* bigdelim: BIGG LEFTDELIM  */
#line 679 "../lasem/itex2mml/itex2MML.y"
                 {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3559 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 125: /* bigdelim: BIGG RIGHTDELIM  */
#line 684 "../lasem/itex2mml/itex2MML.y"
                  {
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3568 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 126: /* bigdelim: BIGG OTHERDELIM  */
#line 688 "../lasem/itex2mml/itex2MML.y"
                  {
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3577 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 127: /* bigdelim: BBIGG LEFTDELIM  */
#line 692 "../lasem/itex2mml/itex2MML.y"
                  {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3587 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 128: /* bigdelim: BBIGG RIGHTDELIM  */
#line 697 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3596 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 129: /* bigdelim: BBIGG OTHERDELIM  */
#line 701 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3605 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 130: /* bigdelim: BIGL LEFTDELIM  */
#line 705 "../lasem/itex2mml/itex2MML.y"
                {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3615 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 131: /* bigdelim: BIGL OTHERDELIM  */
#line 710 "../lasem/itex2mml/itex2MML.y"
                  {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3625 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 132: /* bigdelim: BBIGL LEFTDELIM  */
#line 715 "../lasem/itex2mml/itex2MML.y"
                  {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3635 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 133: /* bigdelim: BBIGL OTHERDELIM  */
#line 720 "../lasem/itex2mml/itex2MML.y"
                   {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3645 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 134: /* bigdelim: BIGGL LEFTDELIM  */
#line 725 "../lasem/itex2mml/itex2MML.y"
                  {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3655 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 135: /* bigdelim: BIGGL OTHERDELIM  */
#line 730 "../lasem/itex2mml/itex2MML.y"
                   {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3665 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 136: /* bigdelim: BBIGGL LEFTDELIM  */
#line 735 "../lasem/itex2mml/itex2MML.y"
                   {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3675 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 137: /* bigdelim: BBIGGL OTHERDELIM  */
#line 740 "../lasem/itex2mml/itex2MML.y"
                    {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3685 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 138: /* unrecognized: UNKNOWNCHAR  */
#line 746 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy_string("<merror><mtext>Unknown character</mtext></merror>");
}
#line 3693 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 139: /* unaryminus: UNARYMINUS  */
#line 750 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy_string("<mo lspace=\"0.11111em\" rspace=\"0em\">&minus;</mo>");
}
#line 3701 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 140: /* unaryplus: UNARYPLUS  */
#line 754 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy_string("<mo lspace=\"0.11111em\" rspace=\"0em\">+</mo>");
}
#line 3709 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 142: /* mib: MIB  */
#line 760 "../lasem/itex2mml/itex2MML.y"
         {
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mi>", yyvsp[0], "</mi>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3719 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 144: /* mn: ITEXNUM TEXTSTRING  */
#line 767 "../lasem/itex2mml/itex2MML.y"
                     {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3729 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 145: /* mob: MOB  */
#line 773 "../lasem/itex2mml/itex2MML.y"
         {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0.16667em\" rspace=\"0.16667em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3739 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 148: /* mo: MO  */
#line 781 "../lasem/itex2mml/itex2MML.y"
     {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3749 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 149: /* mo: MOL  */
#line 786 "../lasem/itex2mml/itex2MML.y"
      {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3759 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 150: /* mo: MOLL  */
#line 791 "../lasem/itex2mml/itex2MML.y"
       {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\"><mo>", yyvsp[0], "</mo></mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3769 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 151: /* mo: RIGHTDELIM  */
#line 796 "../lasem/itex2mml/itex2MML.y"
             {
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3778 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 152: /* mo: LEFTDELIM  */
#line 800 "../lasem/itex2mml/itex2MML.y"
            {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3788 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 153: /* mo: OTHERDELIM  */
#line 805 "../lasem/itex2mml/itex2MML.y"
             {
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3797 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 154: /* mo: MOF  */
#line 809 "../lasem/itex2mml/itex2MML.y"
      {
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3806 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 155: /* mo: PERIODDELIM  */
#line 813 "../lasem/itex2mml/itex2MML.y"
              {
  yyval = itex2MML_copy3("<mo>", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3815 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 156: /* mo: MOS  */
#line 817 "../lasem/itex2mml/itex2MML.y"
      {
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mo lspace=\"0.22222em\" rspace=\"0.22222em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3825 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 157: /* mo: MOP  */
#line 822 "../lasem/itex2mml/itex2MML.y"
      {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"0.16667em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3835 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 158: /* mo: MOR  */
#line 827 "../lasem/itex2mml/itex2MML.y"
      {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0.11111em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3845 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 159: /* mo: OPERATORNAME TEXTSTRING  */
#line 832 "../lasem/itex2mml/itex2MML.y"
                          {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"0.16667em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3855 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 160: /* mo: MATHOP TEXTSTRING  */
#line 837 "../lasem/itex2mml/itex2MML.y"
                    {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0.16667em\" rspace=\"0.16667em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3865 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 161: /* mo: MATHBIN TEXTSTRING  */
#line 842 "../lasem/itex2mml/itex2MML.y"
                     {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0.22222em\" rspace=\"0.22222em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3875 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 162: /* mo: MATHREL TEXTSTRING  */
#line 847 "../lasem/itex2mml/itex2MML.y"
                     {
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0.27778em\" rspace=\"0.27778em\">", yyvsp[0], "</mo>");
  itex2MML_free_string(yyvsp[0]);
}
#line 3885 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 163: /* space: SPACE ST INTONE END ST INTTWO END ST INTTHREE END  */
#line 853 "../lasem/itex2mml/itex2MML.y"
                                                         {
  char * s1 = itex2MML_copy3("<mspace height=\"", yyvsp[-7], "ex\" depth=\"");
  char * s2 = itex2MML_copy3(yyvsp[-4], "ex\" width=\"", yyvsp[-1]);
  yyval = itex2MML_copy3(s1, s2, "em\"/>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-7]);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 3900 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 164: /* statusline: STATLINE TEXTSTRING closedTerm  */
#line 864 "../lasem/itex2mml/itex2MML.y"
                                           {
  char * s1 = itex2MML_copy3("<maction actiontype=\"statusline\">", yyvsp[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yyvsp[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3912 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 165: /* tooltip: TOOLTIP TEXTSTRING closedTerm  */
#line 872 "../lasem/itex2mml/itex2MML.y"
                                       {
  char * s1 = itex2MML_copy3("<maction actiontype=\"tooltip\">", yyvsp[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yyvsp[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3924 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 166: /* toggle: TOGGLE closedTerm closedTerm  */
#line 880 "../lasem/itex2mml/itex2MML.y"
                                     {
  char * s1 = itex2MML_copy3("<maction actiontype=\"toggle\" selection=\"2\">", yyvsp[-1], " ");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3936 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 167: /* toggle: TOGGLESTART compoundTermList TOGGLEEND  */
#line 887 "../lasem/itex2mml/itex2MML.y"
                                         {
  yyval = itex2MML_copy3("<maction actiontype=\"toggle\">", yyvsp[-1], "</maction>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 3945 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 168: /* fghighlight: FGHIGHLIGHT ATTRLIST closedTerm  */
#line 892 "../lasem/itex2mml/itex2MML.y"
                                             {
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='color=", yyvsp[-1], "'>");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3957 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 169: /* bghighlight: BGHIGHLIGHT ATTRLIST closedTerm  */
#line 900 "../lasem/itex2mml/itex2MML.y"
                                             {
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='background=", yyvsp[-1], "'>");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3969 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 170: /* color: COLOR ATTRLIST compoundTermList  */
#line 908 "../lasem/itex2mml/itex2MML.y"
                                       {
  char * s1 = itex2MML_copy3("<mstyle mathcolor=", yyvsp[-1], ">");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3981 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 171: /* color: BGCOLOR ATTRLIST compoundTermList  */
#line 915 "../lasem/itex2mml/itex2MML.y"
                                    {
  char * s1 = itex2MML_copy3("<mstyle mathbackground=", yyvsp[-1], ">");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 3993 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 172: /* mathrlap: RLAP closedTerm  */
#line 923 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy3("<mpadded width=\"0px\">", yyvsp[0], "</mpadded>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4002 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 173: /* mathllap: LLAP closedTerm  */
#line 928 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy3("<mpadded width=\"0px\" lspace=\"-100%width\">", yyvsp[0], "</mpadded>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4011 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 174: /* mathclap: CLAP closedTerm  */
#line 933 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy3("<mpadded width=\"0px\" lspace=\"-50%width\">", yyvsp[0], "</mpadded>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4020 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 175: /* textstring: TEXTBOX TEXTSTRING  */
#line 938 "../lasem/itex2mml/itex2MML.y"
                               {
  yyval = itex2MML_copy3("<mtext>", yyvsp[0], "</mtext>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4029 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 176: /* displaystyle: DISPLAY compoundTermList  */
#line 943 "../lasem/itex2mml/itex2MML.y"
                                       {
  yyval = itex2MML_copy3("<mstyle displaystyle=\"true\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4038 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 177: /* textstyle: TEXTSTY compoundTermList  */
#line 948 "../lasem/itex2mml/itex2MML.y"
                                    {
  yyval = itex2MML_copy3("<mstyle displaystyle=\"false\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4047 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 178: /* textsize: TEXTSIZE compoundTermList  */
#line 953 "../lasem/itex2mml/itex2MML.y"
                                    {
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4056 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 179: /* scriptsize: SCSIZE compoundTermList  */
#line 958 "../lasem/itex2mml/itex2MML.y"
                                    {
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"1\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4065 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 180: /* scriptscriptsize: SCSCSIZE compoundTermList  */
#line 963 "../lasem/itex2mml/itex2MML.y"
                                            {
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4074 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 181: /* italics: ITALICS closedTerm  */
#line 968 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy3("<mstyle mathvariant=\"italic\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4083 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 182: /* sans: SANS closedTerm  */
#line 973 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy3("<mstyle mathvariant=\"sans-serif\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4092 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 183: /* mono: TT closedTerm  */
#line 978 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3("<mstyle mathvariant=\"monospace\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4101 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 184: /* slashed: SLASHED closedTerm  */
#line 983 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy3("<menclose notation=\"updiagonalstrike\">", yyvsp[0], "</menclose>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4110 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 185: /* boxed: BOXED closedTerm  */
#line 988 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy3("<menclose notation=\"box\">", yyvsp[0], "</menclose>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4119 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 186: /* bold: BOLD closedTerm  */
#line 993 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy3("<mstyle mathvariant=\"bold\">", yyvsp[0], "</mstyle>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4128 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 187: /* roman: RM ST rmchars END  */
#line 998 "../lasem/itex2mml/itex2MML.y"
                         {
  yyval = itex2MML_copy3("<mi mathvariant=\"normal\">", yyvsp[-1], "</mi>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 4137 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 188: /* rmchars: RMCHAR  */
#line 1003 "../lasem/itex2mml/itex2MML.y"
                {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4146 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 189: /* rmchars: rmchars RMCHAR  */
#line 1007 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy2(yyvsp[-1], yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4156 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 190: /* bbold: BB ST bbchars END  */
#line 1013 "../lasem/itex2mml/itex2MML.y"
                         {
  yyval = itex2MML_copy3("<mi>", yyvsp[-1], "</mi>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 4165 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 191: /* bbchars: bbchar  */
#line 1018 "../lasem/itex2mml/itex2MML.y"
                {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4174 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 192: /* bbchars: bbchars bbchar  */
#line 1022 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy2(yyvsp[-1], yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4184 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 193: /* bbchar: BBLOWERCHAR  */
#line 1028 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3("&", yyvsp[0], "opf;");
  itex2MML_free_string(yyvsp[0]);
}
#line 4193 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 194: /* bbchar: BBUPPERCHAR  */
#line 1032 "../lasem/itex2mml/itex2MML.y"
              {
  yyval = itex2MML_copy3("&", yyvsp[0], "opf;");
  itex2MML_free_string(yyvsp[0]);
}
#line 4202 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 195: /* bbchar: BBDIGIT  */
#line 1036 "../lasem/itex2mml/itex2MML.y"
          {
  /* Blackboard digits 0-9 correspond to Unicode characters 0x1D7D8-0x1D7E1 */
  char * end = yyvsp[0] + 1;
  int code = 0x1D7D8 + strtoul(yyvsp[0], &end, 10);
  yyval = itex2MML_character_reference(code);
  itex2MML_free_string(yyvsp[0]);
}
#line 4214 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 196: /* frak: FRAK ST frakletters END  */
#line 1044 "../lasem/itex2mml/itex2MML.y"
                              {
  yyval = itex2MML_copy3("<mi>", yyvsp[-1], "</mi>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 4223 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 197: /* frakletters: frakletter  */
#line 1049 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4232 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 198: /* frakletters: frakletters frakletter  */
#line 1053 "../lasem/itex2mml/itex2MML.y"
                         {
  yyval = itex2MML_copy2(yyvsp[-1], yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4242 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 199: /* frakletter: FRAKCHAR  */
#line 1059 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy3("&", yyvsp[0], "fr;");
  itex2MML_free_string(yyvsp[0]);
}
#line 4251 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 200: /* cal: CAL ST calletters END  */
#line 1064 "../lasem/itex2mml/itex2MML.y"
                           {
  yyval = itex2MML_copy3("<mi>", yyvsp[-1], "</mi>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 4260 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 201: /* scr: SCR ST calletters END  */
#line 1069 "../lasem/itex2mml/itex2MML.y"
                           {
  yyval = itex2MML_copy3("<mi class='mathscript'>", yyvsp[-1], "</mi>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 4269 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 202: /* calletters: calletter  */
#line 1074 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4278 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 203: /* calletters: calletters calletter  */
#line 1078 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy2(yyvsp[-1], yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4288 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 204: /* calletter: CALCHAR  */
#line 1084 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy3("&", yyvsp[0], "scr;");
  itex2MML_free_string(yyvsp[0]);
}
#line 4297 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 205: /* thinspace: THINSPACE  */
#line 1089 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy_string("<mspace width=\"0.16667em\"/>");
}
#line 4305 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 206: /* medspace: MEDSPACE  */
#line 1093 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy_string("<mspace width=\"0.22222em\"/>");
}
#line 4313 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 207: /* thickspace: THICKSPACE  */
#line 1097 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy_string("<mspace width=\"0.27778em\"/>");
}
#line 4321 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 208: /* quad: QUAD  */
#line 1101 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string("<mspace width=\"1em\"/>");
}
#line 4329 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 209: /* qquad: QQUAD  */
#line 1105 "../lasem/itex2mml/itex2MML.y"
             {
  yyval = itex2MML_copy_string("<mspace width=\"2em\"/>");
}
#line 4337 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 210: /* negspace: NEGSPACE  */
#line 1109 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy_string("<mspace width=\"-0.16667em\"/>");
}
#line 4345 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 211: /* negmedspace: NEGMEDSPACE  */
#line 1113 "../lasem/itex2mml/itex2MML.y"
                         {
  yyval = itex2MML_copy_string("<mspace width=\"-0.22222em\"/>");
}
#line 4353 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 212: /* negthickspace: NEGTHICKSPACE  */
#line 1117 "../lasem/itex2mml/itex2MML.y"
                             {
  yyval = itex2MML_copy_string("<mspace width=\"-0.27778em\"/>");
}
#line 4361 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 213: /* phantom: PHANTOM closedTerm  */
#line 1121 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy3("<mphantom>", yyvsp[0], "</mphantom>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4370 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 214: /* href: HREF TEXTSTRING closedTerm  */
#line 1126 "../lasem/itex2mml/itex2MML.y"
                                 {
  char * s1 = itex2MML_copy3("<mrow href=\"", yyvsp[-1], "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"");
  char * s2 = itex2MML_copy3(s1, yyvsp[-1], "\">");
  yyval = itex2MML_copy3(s2, yyvsp[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4384 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 215: /* tensor: TENSOR closedTerm MROWOPEN subsupList MROWCLOSE  */
#line 1136 "../lasem/itex2mml/itex2MML.y"
                                                        {
  char * s1 = itex2MML_copy3("<mmultiscripts>", yyvsp[-3], yyvsp[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 4396 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 216: /* tensor: TENSOR closedTerm subsupList  */
#line 1143 "../lasem/itex2mml/itex2MML.y"
                               {
  char * s1 = itex2MML_copy3("<mmultiscripts>", yyvsp[-1], yyvsp[0]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4408 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 217: /* multi: MULTI MROWOPEN subsupList MROWCLOSE closedTerm MROWOPEN subsupList MROWCLOSE  */
#line 1151 "../lasem/itex2mml/itex2MML.y"
                                                                                    {
  char * s1 = itex2MML_copy3("<mmultiscripts>", yyvsp[-3], yyvsp[-1]);
  char * s2 = itex2MML_copy3("<mprescripts/>", yyvsp[-5], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-5]);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 4423 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 218: /* multi: MULTI MROWOPEN subsupList MROWCLOSE closedTerm EMPTYMROW  */
#line 1161 "../lasem/itex2mml/itex2MML.y"
                                                           {
  char * s1 = itex2MML_copy2("<mmultiscripts>", yyvsp[-1]);
  char * s2 = itex2MML_copy3("<mprescripts/>", yyvsp[-3], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 4437 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 219: /* multi: MULTI EMPTYMROW closedTerm MROWOPEN subsupList MROWCLOSE  */
#line 1170 "../lasem/itex2mml/itex2MML.y"
                                                           {
  char * s1 = itex2MML_copy3("<mmultiscripts>", yyvsp[-3], yyvsp[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]); 
}
#line 4449 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 220: /* subsupList: subsupTerm  */
#line 1178 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4458 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 221: /* subsupList: subsupList subsupTerm  */
#line 1182 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy3(yyvsp[-1], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4468 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 222: /* subsupTerm: SUB closedTerm SUP closedTerm  */
#line 1188 "../lasem/itex2mml/itex2MML.y"
                                          {
  yyval = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4478 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 223: /* subsupTerm: SUB closedTerm  */
#line 1193 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy2(yyvsp[0], " <none/>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4487 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 224: /* subsupTerm: SUP closedTerm  */
#line 1197 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy2("<none/> ", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4496 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 225: /* subsupTerm: SUB SUP closedTerm  */
#line 1201 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy2("<none/> ", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4505 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 226: /* mfrac: FRAC closedTerm closedTerm  */
#line 1206 "../lasem/itex2mml/itex2MML.y"
                                  {
  char * s1 = itex2MML_copy3("<mfrac>", yyvsp[-1], yyvsp[0]);
  yyval = itex2MML_copy2(s1, "</mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4517 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 227: /* mfrac: TFRAC closedTerm closedTerm  */
#line 1213 "../lasem/itex2mml/itex2MML.y"
                              {
  char * s1 = itex2MML_copy3("<mstyle displaystyle=\"false\"><mfrac>", yyvsp[-1], yyvsp[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4529 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 228: /* pmod: PMOD closedTerm  */
#line 1221 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy3( "<mrow><mo lspace=\"0.22222em\">(</mo><mo rspace=\"0.16667em\">mod</mo>", yyvsp[0], "<mo rspace=\"0.22222em\">)</mo></mrow>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4538 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 229: /* texover: MROWOPEN compoundTermList TEXOVER compoundTermList MROWCLOSE  */
#line 1226 "../lasem/itex2mml/itex2MML.y"
                                                                      {
  char * s1 = itex2MML_copy3("<mfrac><mrow>", yyvsp[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yyvsp[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 4550 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 230: /* texover: left compoundTermList TEXOVER compoundTermList right  */
#line 1233 "../lasem/itex2mml/itex2MML.y"
                                                       {
  char * s1 = itex2MML_copy3("<mrow>", yyvsp[-4], "<mfrac><mrow>");
  char * s2 = itex2MML_copy3(yyvsp[-3], "</mrow><mrow>", yyvsp[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yyvsp[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4568 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 231: /* texatop: MROWOPEN compoundTermList TEXATOP compoundTermList MROWCLOSE  */
#line 1247 "../lasem/itex2mml/itex2MML.y"
                                                                      {
  char * s1 = itex2MML_copy3("<mfrac linethickness=\"0px\"><mrow>", yyvsp[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yyvsp[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 4580 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 232: /* texatop: left compoundTermList TEXATOP compoundTermList right  */
#line 1254 "../lasem/itex2mml/itex2MML.y"
                                                       {
  char * s1 = itex2MML_copy3("<mrow>", yyvsp[-4], "<mfrac linethickness=\"0px\"><mrow>");
  char * s2 = itex2MML_copy3(yyvsp[-3], "</mrow><mrow>", yyvsp[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yyvsp[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4598 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 233: /* binom: BINOM closedTerm closedTerm  */
#line 1268 "../lasem/itex2mml/itex2MML.y"
                                   {
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mfrac linethickness=\"0px\">", yyvsp[-1], yyvsp[0]);
  yyval = itex2MML_copy2(s1, "</mfrac><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4610 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 234: /* binom: TBINOM closedTerm closedTerm  */
#line 1275 "../lasem/itex2mml/itex2MML.y"
                               {
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mstyle displaystyle=\"false\"><mfrac linethickness=\"0px\">", yyvsp[-1], yyvsp[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4622 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 235: /* munderbrace: UNDERBRACE closedTerm  */
#line 1283 "../lasem/itex2mml/itex2MML.y"
                                   {
  yyval = itex2MML_copy3("<munder>", yyvsp[0], "<mo>&UnderBrace;</mo></munder>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4631 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 236: /* munderline: UNDERLINE closedTerm  */
#line 1288 "../lasem/itex2mml/itex2MML.y"
                                 {
  yyval = itex2MML_copy3("<munder>", yyvsp[0], "<mo>&#x00332;</mo></munder>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4640 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 237: /* moverbrace: OVERBRACE closedTerm  */
#line 1293 "../lasem/itex2mml/itex2MML.y"
                                 {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&OverBrace;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4649 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 238: /* bar: BAR closedTerm  */
#line 1298 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo stretchy=\"false\">&#x000AF;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4658 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 239: /* bar: WIDEBAR closedTerm  */
#line 1302 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&#x000AF;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4667 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 240: /* vec: VEC closedTerm  */
#line 1307 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo stretchy=\"false\">&rightarrow;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4676 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 241: /* vec: WIDEVEC closedTerm  */
#line 1311 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&rightarrow;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4685 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 242: /* lvec: WIDELVEC closedTerm  */
#line 1316 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&leftarrow;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4694 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 243: /* lrvec: WIDELRVEC closedTerm  */
#line 1320 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&leftrightarrow;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4703 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 244: /* uvec: WIDEUVEC closedTerm  */
#line 1324 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy3("<munder>", yyvsp[0], "<mo>&rightarrow;</mo></munder>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4712 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 245: /* ulvec: WIDEULVEC closedTerm  */
#line 1328 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy3("<munder>", yyvsp[0], "<mo>&leftarrow;</mo></munder>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4721 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 246: /* ulrvec: WIDEULRVEC closedTerm  */
#line 1332 "../lasem/itex2mml/itex2MML.y"
                              {
  yyval = itex2MML_copy3("<munder>", yyvsp[0], "<mo>&leftrightarrow;</mo></munder>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4730 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 247: /* dot: DOT closedTerm  */
#line 1337 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&dot;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4739 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 248: /* ddot: DDOT closedTerm  */
#line 1342 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&Dot;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4748 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 249: /* dddot: DDDOT closedTerm  */
#line 1347 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&tdot;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4757 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 250: /* ddddot: DDDDOT closedTerm  */
#line 1352 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&DotDot;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4766 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 251: /* tilde: TILDE closedTerm  */
#line 1357 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo stretchy=\"false\">&tilde;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4775 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 252: /* tilde: WIDETILDE closedTerm  */
#line 1361 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&tilde;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4784 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 253: /* check: CHECK closedTerm  */
#line 1366 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo stretchy=\"false\">&#x2c7;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4793 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 254: /* check: WIDECHECK closedTerm  */
#line 1370 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&#x2c7;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4802 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 255: /* hat: HAT closedTerm  */
#line 1375 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo stretchy=\"false\">&#x5E;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4811 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 256: /* hat: WIDEHAT closedTerm  */
#line 1379 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy3("<mover>", yyvsp[0], "<mo>&#x5E;</mo></mover>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4820 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 257: /* msqrt: SQRT closedTerm  */
#line 1384 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy3("<msqrt>", yyvsp[0], "</msqrt>");
  itex2MML_free_string(yyvsp[0]);
}
#line 4829 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 258: /* mroot: SQRT OPTARGOPEN compoundTermList OPTARGCLOSE closedTerm  */
#line 1389 "../lasem/itex2mml/itex2MML.y"
                                                               {
  char * s1 = itex2MML_copy3("<mroot>", yyvsp[0], yyvsp[-2]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4841 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 259: /* mroot: ROOT closedTerm closedTerm  */
#line 1396 "../lasem/itex2mml/itex2MML.y"
                             {
  char * s1 = itex2MML_copy3("<mroot>", yyvsp[0], yyvsp[-1]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4853 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 260: /* raisebox: RAISEBOX TEXTSTRING TEXTSTRING TEXTSTRING closedTerm  */
#line 1404 "../lasem/itex2mml/itex2MML.y"
                                                               {
  char * s1 = itex2MML_copy3("<mpadded voffset='", yyvsp[-3], "' height='");
  char * s2 = itex2MML_copy3(s1, yyvsp[-2], "' depth='");
  char * s3 = itex2MML_copy3(s2, yyvsp[-1], "'>");
  yyval = itex2MML_copy3(s3, yyvsp[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4871 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 261: /* raisebox: RAISEBOX NEG TEXTSTRING TEXTSTRING TEXTSTRING closedTerm  */
#line 1417 "../lasem/itex2mml/itex2MML.y"
                                                           {
  char * s1 = itex2MML_copy3("<mpadded voffset='-", yyvsp[-3], "' height='");
  char * s2 = itex2MML_copy3(s1, yyvsp[-2], "' depth='");
  char * s3 = itex2MML_copy3(s2, yyvsp[-1], "'>");
  yyval = itex2MML_copy3(s3, yyvsp[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4889 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 262: /* raisebox: RAISEBOX TEXTSTRING TEXTSTRING closedTerm  */
#line 1430 "../lasem/itex2mml/itex2MML.y"
                                            {
  char * s1 = itex2MML_copy3("<mpadded voffset='", yyvsp[-2], "' height='");
  char * s2 = itex2MML_copy3(s1, yyvsp[-1], "' depth='depth'>");
  yyval = itex2MML_copy3(s2, yyvsp[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4904 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 263: /* raisebox: RAISEBOX NEG TEXTSTRING TEXTSTRING closedTerm  */
#line 1440 "../lasem/itex2mml/itex2MML.y"
                                                {
  char * s1 = itex2MML_copy3("<mpadded voffset='-", yyvsp[-2], "' height='");
  char * s2 = itex2MML_copy3(s1, yyvsp[-1], "' depth='+");
  char * s3 = itex2MML_copy3(s2, yyvsp[-2], "'>");
  yyval = itex2MML_copy3(s3, yyvsp[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4921 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 264: /* raisebox: RAISEBOX TEXTSTRING closedTerm  */
#line 1452 "../lasem/itex2mml/itex2MML.y"
                                 {
  char * s1 = itex2MML_copy3("<mpadded voffset='", yyvsp[-1], "' height='+");
  char * s2 = itex2MML_copy3(s1, yyvsp[-1], "' depth='depth'>");
  yyval = itex2MML_copy3(s2, yyvsp[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4935 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 265: /* raisebox: RAISEBOX NEG TEXTSTRING closedTerm  */
#line 1461 "../lasem/itex2mml/itex2MML.y"
                                     {
  char * s1 = itex2MML_copy3("<mpadded voffset='-", yyvsp[-1], "' height='0pt' depth='+");
  char * s2 = itex2MML_copy3(s1, yyvsp[-1], "'>");
  yyval = itex2MML_copy3(s2, yyvsp[0], "</mpadded>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4949 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 266: /* munder: XARROW OPTARGOPEN compoundTermList OPTARGCLOSE EMPTYMROW  */
#line 1471 "../lasem/itex2mml/itex2MML.y"
                                                                 {
  char * s1 = itex2MML_copy3("<munder><mo>", yyvsp[-4], "</mo><mrow>");
  yyval = itex2MML_copy3(s1, yyvsp[-2], "</mrow></munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
}
#line 4961 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 267: /* munder: UNDER closedTerm closedTerm  */
#line 1478 "../lasem/itex2mml/itex2MML.y"
                              {
  char * s1 = itex2MML_copy3("<munder>", yyvsp[0], yyvsp[-1]);
  yyval = itex2MML_copy2(s1, "</munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4973 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 268: /* mover: XARROW closedTerm  */
#line 1486 "../lasem/itex2mml/itex2MML.y"
                         {
  char * s1 = itex2MML_copy3("<mover><mo>", yyvsp[-1], "</mo>");
  yyval =  itex2MML_copy3(s1, yyvsp[0], "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4985 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 269: /* mover: OVER closedTerm closedTerm  */
#line 1493 "../lasem/itex2mml/itex2MML.y"
                             {
  char * s1 = itex2MML_copy3("<mover>", yyvsp[0], yyvsp[-1]);
  yyval = itex2MML_copy2(s1, "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 4997 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 270: /* munderover: XARROW OPTARGOPEN compoundTermList OPTARGCLOSE closedTerm  */
#line 1501 "../lasem/itex2mml/itex2MML.y"
                                                                      {
  char * s1 = itex2MML_copy3("<munderover><mo>", yyvsp[-4], "</mo><mrow>");
  char * s2 = itex2MML_copy3(s1, yyvsp[-2], "</mrow>");
  yyval = itex2MML_copy3(s2, yyvsp[0], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5012 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 271: /* munderover: UNDEROVER closedTerm closedTerm closedTerm  */
#line 1511 "../lasem/itex2mml/itex2MML.y"
                                             {
  char * s1 = itex2MML_copy3("<munderover>", yyvsp[0], yyvsp[-2]);
  yyval = itex2MML_copy3(s1, yyvsp[-1], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5025 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 272: /* emptymrow: EMPTYMROW  */
#line 1520 "../lasem/itex2mml/itex2MML.y"
                     {
  yyval = itex2MML_copy_string("<mrow/>");
}
#line 5033 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 273: /* mathenv: BEGINENV MATRIX tableRowList ENDENV MATRIX  */
#line 1524 "../lasem/itex2mml/itex2MML.y"
                                                    {
  yyval = itex2MML_copy3("<mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5042 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 274: /* mathenv: BEGINENV GATHERED tableRowList ENDENV GATHERED  */
#line 1528 "../lasem/itex2mml/itex2MML.y"
                                                  {
  yyval = itex2MML_copy3("<mrow><mtable displaystyle=\"true\" rowspacing=\"1.0ex\">", yyvsp[-2], "</mtable></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5051 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 275: /* mathenv: BEGINENV PMATRIX tableRowList ENDENV PMATRIX  */
#line 1532 "../lasem/itex2mml/itex2MML.y"
                                               {
  yyval = itex2MML_copy3("<mrow><mo>(</mo><mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow><mo>)</mo></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5060 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 276: /* mathenv: BEGINENV BMATRIX tableRowList ENDENV BMATRIX  */
#line 1536 "../lasem/itex2mml/itex2MML.y"
                                               {
  yyval = itex2MML_copy3("<mrow><mo>[</mo><mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow><mo>]</mo></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5069 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 277: /* mathenv: BEGINENV VMATRIX tableRowList ENDENV VMATRIX  */
#line 1540 "../lasem/itex2mml/itex2MML.y"
                                               {
  yyval = itex2MML_copy3("<mrow><mo>&VerticalBar;</mo><mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow><mo>&VerticalBar;</mo></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5078 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 278: /* mathenv: BEGINENV BBMATRIX tableRowList ENDENV BBMATRIX  */
#line 1544 "../lasem/itex2mml/itex2MML.y"
                                                 {
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow><mo>}</mo></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5087 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 279: /* mathenv: BEGINENV VVMATRIX tableRowList ENDENV VVMATRIX  */
#line 1548 "../lasem/itex2mml/itex2MML.y"
                                                 {
  yyval = itex2MML_copy3("<mrow><mo>&DoubleVerticalBar;</mo><mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow><mo>&DoubleVerticalBar;</mo></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5096 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 280: /* mathenv: BEGINENV SMALLMATRIX tableRowList ENDENV SMALLMATRIX  */
#line 1552 "../lasem/itex2mml/itex2MML.y"
                                                       {
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\"><mrow><mtable displaystyle=\"false\" rowspacing=\"0.5ex\">", yyvsp[-2], "</mtable></mrow></mstyle>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5105 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 281: /* mathenv: BEGINENV CASES tableRowList ENDENV CASES  */
#line 1556 "../lasem/itex2mml/itex2MML.y"
                                           {
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable displaystyle=\"false\" columnalign=\"left left\">", yyvsp[-2], "</mtable></mrow></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5114 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 282: /* mathenv: BEGINENV ALIGNED tableRowList ENDENV ALIGNED  */
#line 1560 "../lasem/itex2mml/itex2MML.y"
                                               {
  yyval = itex2MML_copy3("<mrow><mtable displaystyle=\"true\" columnalign=\"right left right left right left right left right left\" columnspacing=\"0em\">", yyvsp[-2], "</mtable></mrow>");
  itex2MML_free_string(yyvsp[-2]);
}
#line 5123 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 283: /* mathenv: BEGINENV ARRAY ARRAYALIGN ST columnAlignList END tableRowList ENDENV ARRAY  */
#line 1564 "../lasem/itex2mml/itex2MML.y"
                                                                             {
  char * s1 = itex2MML_copy3("<mtable displaystyle=\"false\" rowspacing=\"0.5ex\" align=\"", yyvsp[-6], "\" columnalign=\"");
  char * s2 = itex2MML_copy3(s1, yyvsp[-4], "\">");
  yyval = itex2MML_copy3(s2, yyvsp[-2], "</mtable>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yyvsp[-6]);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
}
#line 5138 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 284: /* mathenv: BEGINENV ARRAY ST columnAlignList END tableRowList ENDENV ARRAY  */
#line 1574 "../lasem/itex2mml/itex2MML.y"
                                                                  {
  char * s1 = itex2MML_copy3("<mtable displaystyle=\"false\" rowspacing=\"0.5ex\" columnalign=\"", yyvsp[-4], "\">");
  yyval = itex2MML_copy3(s1, yyvsp[-2], "</mtable>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-4]);
  itex2MML_free_string(yyvsp[-2]);
}
#line 5150 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 285: /* mathenv: BEGINENV SVG XMLSTRING ENDSVG  */
#line 1581 "../lasem/itex2mml/itex2MML.y"
                                {
  yyval = itex2MML_copy3("<semantics><annotation-xml encoding=\"SVG1.1\">", yyvsp[-1], "</annotation-xml></semantics>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 5159 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 286: /* mathenv: BEGINENV SVG ENDSVG  */
#line 1585 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy_string(" ");
}
#line 5167 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 287: /* columnAlignList: columnAlignList COLUMNALIGN  */
#line 1589 "../lasem/itex2mml/itex2MML.y"
                                             {
  yyval = itex2MML_copy3(yyvsp[-1], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5177 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 288: /* columnAlignList: COLUMNALIGN  */
#line 1594 "../lasem/itex2mml/itex2MML.y"
              {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5186 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 289: /* substack: SUBSTACK MROWOPEN tableRowList MROWCLOSE  */
#line 1599 "../lasem/itex2mml/itex2MML.y"
                                                   {
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"center\" rowspacing=\"0.5ex\">", yyvsp[-1], "</mtable></mrow>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 5195 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 290: /* array: ARRAY MROWOPEN tableRowList MROWCLOSE  */
#line 1604 "../lasem/itex2mml/itex2MML.y"
                                             {
  yyval = itex2MML_copy3("<mrow><mtable>", yyvsp[-1], "</mtable></mrow>");
  itex2MML_free_string(yyvsp[-1]);
}
#line 5204 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 291: /* array: ARRAY MROWOPEN ARRAYOPTS MROWOPEN arrayopts MROWCLOSE tableRowList MROWCLOSE  */
#line 1608 "../lasem/itex2mml/itex2MML.y"
                                                                               {
  char * s1 = itex2MML_copy3("<mrow><mtable ", yyvsp[-3], ">");
  yyval = itex2MML_copy3(s1, yyvsp[-1], "</mtable></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-3]);
  itex2MML_free_string(yyvsp[-1]);
}
#line 5216 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 292: /* arrayopts: anarrayopt  */
#line 1616 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5225 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 293: /* arrayopts: arrayopts anarrayopt  */
#line 1620 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy3(yyvsp[-1], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5235 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 294: /* anarrayopt: collayout  */
#line 1626 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5244 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 295: /* anarrayopt: colalign  */
#line 1630 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5253 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 296: /* anarrayopt: rowalign  */
#line 1634 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5262 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 297: /* anarrayopt: align  */
#line 1638 "../lasem/itex2mml/itex2MML.y"
        {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5271 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 298: /* anarrayopt: eqrows  */
#line 1642 "../lasem/itex2mml/itex2MML.y"
         {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5280 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 299: /* anarrayopt: eqcols  */
#line 1646 "../lasem/itex2mml/itex2MML.y"
         {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5289 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 300: /* anarrayopt: rowlines  */
#line 1650 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5298 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 301: /* anarrayopt: collines  */
#line 1654 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5307 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 302: /* anarrayopt: frame  */
#line 1658 "../lasem/itex2mml/itex2MML.y"
        {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5316 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 303: /* anarrayopt: padding  */
#line 1662 "../lasem/itex2mml/itex2MML.y"
          {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5325 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 304: /* collayout: COLLAYOUT ATTRLIST  */
#line 1667 "../lasem/itex2mml/itex2MML.y"
                              {
  yyval = itex2MML_copy2("columnalign=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5334 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 305: /* colalign: COLALIGN ATTRLIST  */
#line 1672 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy2("columnalign=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5343 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 306: /* rowalign: ROWALIGN ATTRLIST  */
#line 1677 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy2("rowalign=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5352 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 307: /* align: ALIGN ATTRLIST  */
#line 1682 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy2("align=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5361 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 308: /* eqrows: EQROWS ATTRLIST  */
#line 1687 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy2("equalrows=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5370 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 309: /* eqcols: EQCOLS ATTRLIST  */
#line 1692 "../lasem/itex2mml/itex2MML.y"
                        {
  yyval = itex2MML_copy2("equalcolumns=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5379 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 310: /* rowlines: ROWLINES ATTRLIST  */
#line 1697 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy2("rowlines=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5388 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 311: /* collines: COLLINES ATTRLIST  */
#line 1702 "../lasem/itex2mml/itex2MML.y"
                            {
  yyval = itex2MML_copy2("columnlines=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5397 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 312: /* frame: FRAME ATTRLIST  */
#line 1707 "../lasem/itex2mml/itex2MML.y"
                      {
  yyval = itex2MML_copy2("frame=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5406 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 313: /* padding: PADDING ATTRLIST  */
#line 1712 "../lasem/itex2mml/itex2MML.y"
                          {
  char * s1 = itex2MML_copy3("rowspacing=", yyvsp[0], " columnspacing=");
  yyval = itex2MML_copy2(s1, yyvsp[0]);
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[0]);
}
#line 5417 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 314: /* tableRowList: tableRow  */
#line 1719 "../lasem/itex2mml/itex2MML.y"
                       {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5426 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 315: /* tableRowList: tableRowList ROWSEP tableRow  */
#line 1723 "../lasem/itex2mml/itex2MML.y"
                               {
  yyval = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5436 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 316: /* tableRow: simpleTableRow  */
#line 1729 "../lasem/itex2mml/itex2MML.y"
                         {
  yyval = itex2MML_copy3("<mtr>", yyvsp[0], "</mtr>");
  itex2MML_free_string(yyvsp[0]);
}
#line 5445 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 317: /* tableRow: optsTableRow  */
#line 1733 "../lasem/itex2mml/itex2MML.y"
               {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5454 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 318: /* simpleTableRow: tableCell  */
#line 1738 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5463 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 319: /* simpleTableRow: simpleTableRow COLSEP tableCell  */
#line 1742 "../lasem/itex2mml/itex2MML.y"
                                  {
  yyval = itex2MML_copy3(yyvsp[-2], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5473 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 320: /* optsTableRow: ROWOPTS MROWOPEN rowopts MROWCLOSE simpleTableRow  */
#line 1748 "../lasem/itex2mml/itex2MML.y"
                                                                {
  char * s1 = itex2MML_copy3("<mtr ", yyvsp[-2], ">");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</mtr>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5485 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 321: /* rowopts: arowopt  */
#line 1756 "../lasem/itex2mml/itex2MML.y"
                 {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5494 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 322: /* rowopts: rowopts arowopt  */
#line 1760 "../lasem/itex2mml/itex2MML.y"
                  {
  yyval = itex2MML_copy3(yyvsp[-1], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5504 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 323: /* arowopt: colalign  */
#line 1766 "../lasem/itex2mml/itex2MML.y"
                  {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5513 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 324: /* arowopt: rowalign  */
#line 1770 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5522 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 325: /* tableCell: %empty  */
#line 1775 "../lasem/itex2mml/itex2MML.y"
             {
  yyval = itex2MML_copy_string("<mtd/>");
}
#line 5530 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 326: /* tableCell: compoundTermList  */
#line 1778 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy3("<mtd>", yyvsp[0], "</mtd>");
  itex2MML_free_string(yyvsp[0]);
}
#line 5539 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 327: /* tableCell: CELLOPTS MROWOPEN cellopts MROWCLOSE compoundTermList  */
#line 1782 "../lasem/itex2mml/itex2MML.y"
                                                        {
  char * s1 = itex2MML_copy3("<mtd ", yyvsp[-2], ">");
  yyval = itex2MML_copy3(s1, yyvsp[0], "</mtd>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yyvsp[-2]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5551 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 328: /* cellopts: acellopt  */
#line 1790 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5560 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 329: /* cellopts: cellopts acellopt  */
#line 1794 "../lasem/itex2mml/itex2MML.y"
                    {
  yyval = itex2MML_copy3(yyvsp[-1], " ", yyvsp[0]);
  itex2MML_free_string(yyvsp[-1]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5570 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 330: /* acellopt: colalign  */
#line 1800 "../lasem/itex2mml/itex2MML.y"
                   {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5579 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 331: /* acellopt: rowalign  */
#line 1804 "../lasem/itex2mml/itex2MML.y"
           {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5588 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 332: /* acellopt: rowspan  */
#line 1808 "../lasem/itex2mml/itex2MML.y"
          {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5597 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 333: /* acellopt: colspan  */
#line 1812 "../lasem/itex2mml/itex2MML.y"
          {
  yyval = itex2MML_copy_string(yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5606 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 334: /* rowspan: ROWSPAN ATTRLIST  */
#line 1817 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy2("rowspan=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5615 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;

  case 335: /* colspan: COLSPAN ATTRLIST  */
#line 1822 "../lasem/itex2mml/itex2MML.y"
                          {
  yyval = itex2MML_copy2("columnspan=", yyvsp[0]);
  itex2MML_free_string(yyvsp[0]);
}
#line 5624 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"
    break;


#line 5628 "src/liblasem-0.6.so.0.6.0.p/itex2MML.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (ret_str, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, ret_str);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, ret_str);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (ret_str, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, ret_str);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, ret_str);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 1827 "../lasem/itex2mml/itex2MML.y"


char * itex2MML_parse (const char * buffer, size_t length)
{
  char * mathml = 0;

  int result;

  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  result = itex2MML_yyparse (&mathml);

  if (result && mathml) /* shouldn't happen? */
    {
      itex2MML_free_string (mathml);
      mathml = 0;
    }
  return mathml;
}

int itex2MML_filter (const char * buffer, size_t length)
{
  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  return itex2MML_yyparse (0);
}

#define ITEX_DELIMITER_DOLLAR 0
#define ITEX_DELIMITER_DOUBLE 1
#define ITEX_DELIMITER_SQUARE 2
#define ITEX_DELIMITER_PAREN  3

static char * itex2MML_last_error = 0;

static void itex2MML_keep_error (const char * msg)
{
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_last_error = itex2MML_copy_escaped (msg);
}

int itex2MML_html_filter (const char * buffer, size_t length)
{
  return itex2MML_do_html_filter (buffer, length, 0);
}

int itex2MML_strict_html_filter (const char * buffer, size_t length)
{
  return itex2MML_do_html_filter (buffer, length, 1);
}

int itex2MML_do_html_filter (const char * buffer, size_t length, const int forbid_markup)
{
  int result = 0;

  int type = 0;
  int skip = 0;
  int match = 0;

  const char * ptr1 = buffer;
  const char * ptr2 = 0;

  const char * end = buffer + length;

  char * mathml = 0;

  void (*save_error_fn) (const char * msg) = itex2MML_error;

  itex2MML_error = itex2MML_keep_error;

 _until_math:
  ptr2 = ptr1;

  while (ptr2 < end)
    {
      if (*ptr2 == '$') break;
      if ((*ptr2 == '\\') && (ptr2 + 1 < end))
	{
	  if (*(ptr2+1) == '[' || *(ptr2+1) == '(') break;
	}
      ++ptr2;
    }
  if (itex2MML_write && ptr2 > ptr1)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

  if (ptr2 == end) goto _finish;

  ptr1 = ptr2;

  if (ptr2 + 1 < end)
    {
      if ((*ptr2 == '\\') && (*(ptr2+1) == '['))
	{
	  type = ITEX_DELIMITER_SQUARE;
	  ptr2 += 2;
	}
      else if ((*ptr2 == '\\') && (*(ptr2+1) == '('))
	{
	  type = ITEX_DELIMITER_PAREN;
	  ptr2 += 2;
	}
      else if ((*ptr2 == '$') && (*(ptr2+1) == '$'))
	{
	  type = ITEX_DELIMITER_DOUBLE;
	  ptr2 += 2;
	}
      else
	{
	  type = ITEX_DELIMITER_DOLLAR;
	  ptr2 += 2;
	}
    }
  else goto _finish;

  skip = 0;
  match = 0;

  while (ptr2 < end)
    {
      switch (*ptr2)
	{
	case '<':
	case '>':
	  if (forbid_markup == 1) skip = 1;
	  break;

	case '\\':
	  if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '[' || *(ptr2 + 1) == '(')
		{
		  skip = 1;
		}
	      else if (*(ptr2 + 1) == ']')
		{
		  if (type == ITEX_DELIMITER_SQUARE)
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	      else if (*(ptr2 + 1) == ')')
		{
		  if (type == ITEX_DELIMITER_PAREN)
		    {
		      ptr2 += 2;
		      match = 1;
		    }
	  else
	    {
	      skip = 1;
	    }
	}

	    }
	  break;

	case '$':
	  if (*(ptr2-1) == '\\')
	    {
	      skip = 0;
	    }
	  else if (type == ITEX_DELIMITER_SQUARE || type == ITEX_DELIMITER_PAREN)
	    {
	      skip = 1;
	    }
	  else if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '$')
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		}
	      else
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  else
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		{
		  ptr2++;
		  match = 1;
		}
	      else
		{
		  skip = 1;
		}
	    }
	  break;

	default:
	  break;
	}
      if (skip || match) break;

      ++ptr2;
    }
  if (skip)
    {
      if (type == ITEX_DELIMITER_DOLLAR)
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 1);
	  ptr1++;
	}
      else
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 2);
	  ptr1 += 2;
	}
      goto _until_math;
    }
  if (match)
    {
      mathml = itex2MML_parse (ptr1, ptr2 - ptr1);

      if (mathml)
	{
	  if (itex2MML_write_mathml)
	    (*itex2MML_write_mathml) (mathml);
	  itex2MML_free_string (mathml);
	  mathml = 0;
	}
      else
	{
	  ++result;
	  if (itex2MML_write)
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'><merror><mtext>", 0);
	      else
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'><merror><mtext>", 0);

	      (*itex2MML_write) (itex2MML_last_error, 0);
	      (*itex2MML_write) ("</mtext></merror></math>", 0);
	    }
	}
      ptr1 = ptr2;

      goto _until_math;
    }
  if (itex2MML_write)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

 _finish:
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_error = save_error_fn;

  return result;
}
