/* Generated by wayland-scanner 1.24.0 */

#ifndef CONTRAST_SERVER_PROTOCOL_H
#define CONTRAST_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_contrast The contrast protocol
 * @section page_ifaces_contrast Interfaces
 * - @subpage page_iface_org_kde_kwin_contrast_manager - 
 * - @subpage page_iface_org_kde_kwin_contrast - 
 * @section page_copyright_contrast Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 * SPDX-FileCopyrightText: 2015 Marco Martin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_contrast;
struct org_kde_kwin_contrast_manager;
struct wl_region;
struct wl_surface;

#ifndef ORG_KDE_KWIN_CONTRAST_MANAGER_INTERFACE
#define ORG_KDE_KWIN_CONTRAST_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_contrast_manager org_kde_kwin_contrast_manager
 * @section page_iface_org_kde_kwin_contrast_manager_api API
 * See @ref iface_org_kde_kwin_contrast_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_contrast_manager The org_kde_kwin_contrast_manager interface
 */
extern const struct wl_interface org_kde_kwin_contrast_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_CONTRAST_INTERFACE
#define ORG_KDE_KWIN_CONTRAST_INTERFACE
/**
 * @page page_iface_org_kde_kwin_contrast org_kde_kwin_contrast
 * @section page_iface_org_kde_kwin_contrast_api API
 * See @ref iface_org_kde_kwin_contrast.
 */
/**
 * @defgroup iface_org_kde_kwin_contrast The org_kde_kwin_contrast interface
 */
extern const struct wl_interface org_kde_kwin_contrast_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 * @struct org_kde_kwin_contrast_manager_interface
 */
struct org_kde_kwin_contrast_manager_interface {
	/**
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t id,
		       struct wl_resource *surface);
	/**
	 */
	void (*unset)(struct wl_client *client,
		      struct wl_resource *resource,
		      struct wl_resource *surface);
};


/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 */
#define ORG_KDE_KWIN_CONTRAST_MANAGER_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast_manager
 */
#define ORG_KDE_KWIN_CONTRAST_MANAGER_UNSET_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_contrast
 * @struct org_kde_kwin_contrast_interface
 */
struct org_kde_kwin_contrast_interface {
	/**
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 */
	void (*set_region)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *region);
	/**
	 */
	void (*set_contrast)(struct wl_client *client,
			     struct wl_resource *resource,
			     wl_fixed_t contrast);
	/**
	 */
	void (*set_intensity)(struct wl_client *client,
			      struct wl_resource *resource,
			      wl_fixed_t intensity);
	/**
	 */
	void (*set_saturation)(struct wl_client *client,
			       struct wl_resource *resource,
			       wl_fixed_t saturation);
	/**
	 * release the contrast object
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * opt into frost effect w/ given colour
	 *
	 * enables 'frost' variant of contrast effect.
	 *
	 * 'frost' is an enhanced version of the contrast effect that uses
	 * different colour arithmetic to get backgrounds simultaneously
	 * higher in contrast and (apparent) transparency.
	 *
	 * r, g, b, a are channels from 0-255, indicating a colour to use
	 * in contrast calculation. should be based off of the "main"
	 * background colour of the surface.
	 * @since 2
	 */
	void (*set_frost)(struct wl_client *client,
			  struct wl_resource *resource,
			  int32_t red,
			  int32_t green,
			  int32_t blue,
			  int32_t alpha);
	/**
	 * opts out of frost effect
	 *
	 * 
	 * @since 2
	 */
	void (*unset_frost)(struct wl_client *client,
			    struct wl_resource *resource);
};


/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_REGION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_CONTRAST_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_INTENSITY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_SATURATION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_RELEASE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_SET_FROST_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_contrast
 */
#define ORG_KDE_KWIN_CONTRAST_UNSET_FROST_SINCE_VERSION 2

#ifdef  __cplusplus
}
#endif

#endif
