/* Generated by wayland-scanner 1.22.0 */

#ifndef ORG_KDE_PLASMA_VIRTUAL_DESKTOP_SERVER_PROTOCOL_H
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_org_kde_plasma_virtual_desktop The org_kde_plasma_virtual_desktop protocol
 * @section page_ifaces_org_kde_plasma_virtual_desktop Interfaces
 * - @subpage page_iface_org_kde_plasma_virtual_desktop_management - 
 * - @subpage page_iface_org_kde_plasma_virtual_desktop - 
 * @section page_copyright_org_kde_plasma_virtual_desktop Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2018 Marco Martin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_plasma_virtual_desktop;
struct org_kde_plasma_virtual_desktop_management;

#ifndef ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_INTERFACE
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_INTERFACE
/**
 * @page page_iface_org_kde_plasma_virtual_desktop_management org_kde_plasma_virtual_desktop_management
 * @section page_iface_org_kde_plasma_virtual_desktop_management_api API
 * See @ref iface_org_kde_plasma_virtual_desktop_management.
 */
/**
 * @defgroup iface_org_kde_plasma_virtual_desktop_management The org_kde_plasma_virtual_desktop_management interface
 */
extern const struct wl_interface org_kde_plasma_virtual_desktop_management_interface;
#endif
#ifndef ORG_KDE_PLASMA_VIRTUAL_DESKTOP_INTERFACE
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_INTERFACE
/**
 * @page page_iface_org_kde_plasma_virtual_desktop org_kde_plasma_virtual_desktop
 * @section page_iface_org_kde_plasma_virtual_desktop_api API
 * See @ref iface_org_kde_plasma_virtual_desktop.
 */
/**
 * @defgroup iface_org_kde_plasma_virtual_desktop The org_kde_plasma_virtual_desktop interface
 */
extern const struct wl_interface org_kde_plasma_virtual_desktop_interface;
#endif

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 * @struct org_kde_plasma_virtual_desktop_management_interface
 */
struct org_kde_plasma_virtual_desktop_management_interface {
	/**
	 * get the org_kde_plasma_virtual_desktop interface for a desktop
	 *
	 * Given the id of a particular virtual desktop, get the
	 * corresponding org_kde_plasma_virtual_desktop which represents
	 * only the desktop with that id.
	 * @param desktop_id Unique id of the desktop
	 */
	void (*get_virtual_desktop)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t id,
				    const char *desktop_id);
	/**
	 * ask for the creation of a new desktop at a specified position
	 *
	 * Ask the server to create a new virtual desktop, and position
	 * it at a specified position. If the position is zero or less, it
	 * will be positioned at the beginning, if the position is the
	 * count or more, it will be positioned at the end.
	 * @param name The user readable name we want for the desktop
	 * @param position The position we want for the desktop
	 */
	void (*request_create_virtual_desktop)(struct wl_client *client,
					       struct wl_resource *resource,
					       const char *name,
					       uint32_t position);
	/**
	 * ask for a desktop removal identified by id
	 *
	 * Ask the server to get rid of a virtual desktop, the server may
	 * or may not acconsent to the request.
	 * @param desktop_id Unique id of the desktop
	 */
	void (*request_remove_virtual_desktop)(struct wl_client *client,
					       struct wl_resource *resource,
					       const char *desktop_id);
};

#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_CREATED 0
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_REMOVED 1
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DONE 2
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_ROWS 3

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_REMOVED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_ROWS_SINCE_VERSION 2

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_GET_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_CREATE_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_REMOVE_VIRTUAL_DESKTOP_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 * Sends an desktop_created event to the client owning the resource.
 * @param resource_ The client's resource
 * @param desktop_id Unique id of the desktop
 * @param position Position of this desktop, to ensure the client and the server will see desktops in the same order
 */
static inline void
org_kde_plasma_virtual_desktop_management_send_desktop_created(struct wl_resource *resource_, const char *desktop_id, uint32_t position)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_CREATED, desktop_id, position);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 * Sends an desktop_removed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param desktop_id Unique id of the desktop
 */
static inline void
org_kde_plasma_virtual_desktop_management_send_desktop_removed(struct wl_resource *resource_, const char *desktop_id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_REMOVED, desktop_id);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_virtual_desktop_management_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DONE);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 * Sends an rows event to the client owning the resource.
 * @param resource_ The client's resource
 * @param rows Number of rows the virtual desktops are laid out into.
 */
static inline void
org_kde_plasma_virtual_desktop_management_send_rows(struct wl_resource *resource_, uint32_t rows)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_ROWS, rows);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * @struct org_kde_plasma_virtual_desktop_interface
 */
struct org_kde_plasma_virtual_desktop_interface {
	/**
	 * Requests this desktop to be activated
	 *
	 * Request the server to set the status of this desktop to
	 * active: The server is free to consent or deny the request. This
	 * will be the new "current" virtual desktop of the system.
	 */
	void (*request_activate)(struct wl_client *client,
				 struct wl_resource *resource);
};

#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DESKTOP_ID 0
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_NAME 1
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_ACTIVATED 2
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DEACTIVATED 3
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DONE 4
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REMOVED 5

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DESKTOP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_ACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DEACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REQUEST_ACTIVATE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * Sends an desktop_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param desktop_id Unique id of the desktop
 */
static inline void
org_kde_plasma_virtual_desktop_send_desktop_id(struct wl_resource *resource_, const char *desktop_id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DESKTOP_ID, desktop_id);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * Sends an name event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name User readable descriptive name for the desktop
 */
static inline void
org_kde_plasma_virtual_desktop_send_name(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_NAME, name);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * Sends an activated event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_virtual_desktop_send_activated(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_ACTIVATED);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * Sends an deactivated event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_virtual_desktop_send_deactivated(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DEACTIVATED);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_virtual_desktop_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DONE);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_virtual_desktop_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REMOVED);
}

#ifdef  __cplusplus
}
#endif

#endif
